// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gst {

	using System;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Debug {

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_add_log_function(GstSharp.LogFunctionNative func, IntPtr user_data, GLib.DestroyNotify notify);

		public static void AddLogFunction(Gst.LogFunction func) {
			GstSharp.LogFunctionWrapper func_wrapper = new GstSharp.LogFunctionWrapper (func);
			IntPtr user_data;
			GLib.DestroyNotify notify;
			if (func == null) {
				user_data = IntPtr.Zero;
				notify = null;
			} else {
				user_data = (IntPtr) GCHandle.Alloc (func_wrapper);
				notify = GLib.DestroyHelper.NotifyHandler;
			}
			gst_debug_add_log_function(func_wrapper.NativeDelegate, user_data, notify);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_add_ring_buffer_logger(uint max_size_per_thread, uint thread_timeout);

		public static void AddRingBufferLogger(uint max_size_per_thread, uint thread_timeout) {
			gst_debug_add_ring_buffer_logger(max_size_per_thread, thread_timeout);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_debug_bin_to_dot_data(IntPtr bin, int details);

		public static string BinToDotData(Gst.Bin bin, Gst.DebugGraphDetails details) {
			IntPtr raw_ret = gst_debug_bin_to_dot_data(bin == null ? IntPtr.Zero : bin.Handle, (int) details);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_bin_to_dot_file(IntPtr bin, int details, IntPtr file_name);

		public static void BinToDotFile(Gst.Bin bin, Gst.DebugGraphDetails details, string file_name) {
			IntPtr native_file_name = GLib.Marshaller.StringToFilenamePtr (file_name);
			gst_debug_bin_to_dot_file(bin == null ? IntPtr.Zero : bin.Handle, (int) details, native_file_name);
			GLib.Marshaller.Free (native_file_name);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_bin_to_dot_file_with_ts(IntPtr bin, int details, IntPtr file_name);

		public static void BinToDotFileWithTs(Gst.Bin bin, Gst.DebugGraphDetails details, string file_name) {
			IntPtr native_file_name = GLib.Marshaller.StringToFilenamePtr (file_name);
			gst_debug_bin_to_dot_file_with_ts(bin == null ? IntPtr.Zero : bin.Handle, (int) details, native_file_name);
			GLib.Marshaller.Free (native_file_name);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_debug_construct_term_color(uint colorinfo);

		public static string ConstructTermColor(uint colorinfo) {
			IntPtr raw_ret = gst_debug_construct_term_color(colorinfo);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_debug_construct_win_color(uint colorinfo);

		public static int ConstructWinColor(uint colorinfo) {
			int raw_ret = gst_debug_construct_win_color(colorinfo);
			int ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_debug_get_all_categories();

		public static GLib.SList[] GetAllCategories() {
			IntPtr raw_ret = gst_debug_get_all_categories();
			GLib.SList[] ret = (GLib.SList[]) GLib.Marshaller.ListPtrToArray (raw_ret, typeof(GLib.SList), false, true, typeof(GLib.SList));
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_debug_get_color_mode();

		public static Gst.DebugColorMode GetColorMode() {
			int raw_ret = gst_debug_get_color_mode();
			Gst.DebugColorMode ret = (Gst.DebugColorMode) raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_debug_get_default_threshold();

		public static Gst.DebugLevel GetDefaultThreshold() {
			int raw_ret = gst_debug_get_default_threshold();
			Gst.DebugLevel ret = (Gst.DebugLevel) raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_debug_get_stack_trace(int flags);

		public static string GetStackTrace(Gst.StackTraceFlags flags) {
			IntPtr raw_ret = gst_debug_get_stack_trace((int) flags);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_debug_is_active();

		public static bool IsActive() {
			bool raw_ret = gst_debug_is_active();
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_debug_is_colored();

		public static bool IsColored() {
			bool raw_ret = gst_debug_is_colored();
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_debug_level_get_name(int level);

		public static string LevelGetName(Gst.DebugLevel level) {
			IntPtr raw_ret = gst_debug_level_get_name((int) level);
			string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_log_default(IntPtr category, int level, IntPtr file, IntPtr function, int line, IntPtr _object, IntPtr message, IntPtr user_data);

		public static void LogDefault(Gst.DebugCategory category, Gst.DebugLevel level, string file, string function, int line, GLib.Object _object, Gst.DebugMessage message, IntPtr user_data) {
			IntPtr native_category = GLib.Marshaller.StructureToPtrAlloc (category);
			IntPtr native_file = GLib.Marshaller.StringToPtrGStrdup (file);
			IntPtr native_function = GLib.Marshaller.StringToPtrGStrdup (function);
			gst_debug_log_default(native_category, (int) level, native_file, native_function, line, _object == null ? IntPtr.Zero : _object.Handle, message == null ? IntPtr.Zero : message.Handle, user_data);
			Marshal.FreeHGlobal (native_category);
			GLib.Marshaller.Free (native_file);
			GLib.Marshaller.Free (native_function);
		}

		public static void LogDefault(Gst.DebugCategory category, Gst.DebugLevel level, string file, string function, int line, Gst.DebugMessage message) {
			LogDefault (category, level, file, function, line, null, message, IntPtr.Zero);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_debug_log_get_line(IntPtr category, int level, IntPtr file, IntPtr function, int line, IntPtr _object, IntPtr message);

		public static string LogGetLine(Gst.DebugCategory category, Gst.DebugLevel level, string file, string function, int line, GLib.Object _object, Gst.DebugMessage message) {
			IntPtr native_category = GLib.Marshaller.StructureToPtrAlloc (category);
			IntPtr native_file = GLib.Marshaller.StringToPtrGStrdup (file);
			IntPtr native_function = GLib.Marshaller.StringToPtrGStrdup (function);
			IntPtr raw_ret = gst_debug_log_get_line(native_category, (int) level, native_file, native_function, line, _object == null ? IntPtr.Zero : _object.Handle, message == null ? IntPtr.Zero : message.Handle);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			Marshal.FreeHGlobal (native_category);
			GLib.Marshaller.Free (native_file);
			GLib.Marshaller.Free (native_function);
			return ret;
		}

		public static string LogGetLine(Gst.DebugCategory category, Gst.DebugLevel level, string file, string function, int line, Gst.DebugMessage message) {
			return LogGetLine (category, level, file, function, line, null, message);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_print_stack_trace();

		public static void PrintStackTrace() {
			gst_debug_print_stack_trace();
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_debug_remove_log_function(GstSharp.LogFunctionNative func);

		public static uint RemoveLogFunction(Gst.LogFunction func) {
			GstSharp.LogFunctionWrapper func_wrapper = new GstSharp.LogFunctionWrapper (func);
			uint raw_ret = gst_debug_remove_log_function(func_wrapper.NativeDelegate);
			uint ret = raw_ret;
			return ret;
		}

		public static uint RemoveLogFunction() {
			return RemoveLogFunction (null);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_debug_remove_log_function_by_data(IntPtr data);

		public static uint RemoveLogFunctionByData(IntPtr data) {
			uint raw_ret = gst_debug_remove_log_function_by_data(data);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_remove_ring_buffer_logger();

		public static void RemoveRingBufferLogger() {
			gst_debug_remove_ring_buffer_logger();
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_debug_ring_buffer_logger_get_logs();

		public static string[] RingBufferLoggerGetLogs() {
			IntPtr raw_ret = gst_debug_ring_buffer_logger_get_logs();
			string[] ret = GLib.Marshaller.NullTermPtrToStringArray (raw_ret, true);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_set_active(bool active);

		public static void SetActive(bool active) {
			gst_debug_set_active(active);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_set_color_mode(int mode);

		public static void SetColorMode(Gst.DebugColorMode mode) {
			gst_debug_set_color_mode((int) mode);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_set_color_mode_from_string(IntPtr mode);

		public static void SetColorModeFromString(string mode) {
			IntPtr native_mode = GLib.Marshaller.StringToPtrGStrdup (mode);
			gst_debug_set_color_mode_from_string(native_mode);
			GLib.Marshaller.Free (native_mode);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_set_colored(bool colored);

		public static void SetColored(bool colored) {
			gst_debug_set_colored(colored);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_set_default_threshold(int level);

		public static void SetDefaultThreshold(Gst.DebugLevel level) {
			gst_debug_set_default_threshold((int) level);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_set_threshold_for_name(IntPtr name, int level);

		public static void SetThresholdForName(string name, Gst.DebugLevel level) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			gst_debug_set_threshold_for_name(native_name, (int) level);
			GLib.Marshaller.Free (native_name);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_set_threshold_from_string(IntPtr list, bool reset);

		public static void SetThresholdFromString(string list, bool reset) {
			IntPtr native_list = GLib.Marshaller.StringToPtrGStrdup (list);
			gst_debug_set_threshold_from_string(native_list, reset);
			GLib.Marshaller.Free (native_list);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_debug_unset_threshold_for_name(IntPtr name);

		public static void UnsetThresholdForName(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			gst_debug_unset_threshold_for_name(native_name);
			GLib.Marshaller.Free (native_name);
		}

#endregion
	}
}
