/* valaswitchsection.c generated by valac, the Vala compiler
 * generated from valaswitchsection.vala, do not modify */

/* valaswitchsection.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaSwitchSectionPrivate {
	ValaList* labels;
};

static gint ValaSwitchSection_private_offset;
static gpointer vala_switch_section_parent_class = NULL;

static void vala_switch_section_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_switch_section_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static gboolean vala_switch_section_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_switch_section_real_emit (ValaCodeNode* base,
                                    ValaCodeGenerator* codegen);
static void vala_switch_section_finalize (ValaCodeNode * obj);
static GType vala_switch_section_get_type_once (void);

static inline gpointer
vala_switch_section_get_instance_private (ValaSwitchSection* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSwitchSection_private_offset);
}

/**
 * Creates a new switch section.
 *
 * @param source_reference reference to source code
 * @return                 newly created switch section
 */
ValaSwitchSection*
vala_switch_section_construct (GType object_type,
                               ValaSourceReference* source_reference)
{
	ValaSwitchSection* self = NULL;
	self = (ValaSwitchSection*) vala_block_construct (object_type, source_reference);
	return self;
}

ValaSwitchSection*
vala_switch_section_new (ValaSourceReference* source_reference)
{
	return vala_switch_section_construct (VALA_TYPE_SWITCH_SECTION, source_reference);
}

/**
 * Appends the specified label to the list of switch labels.
 *
 * @param label a switch label
 */
void
vala_switch_section_add_label (ValaSwitchSection* self,
                               ValaSwitchLabel* label)
{
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->labels;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		ValaSourceReference* _tmp3_;
		ValaSourceReference* _tmp4_;
		_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) label);
		_tmp4_ = _tmp3_;
		vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp4_);
	}
	_tmp5_ = self->priv->labels;
	vala_collection_add ((ValaCollection*) _tmp5_, label);
	vala_code_node_set_parent_node ((ValaCodeNode*) label, (ValaCodeNode*) self);
}

/**
 * Returns the list of switch labels.
 *
 * @return switch label list
 */
ValaList*
vala_switch_section_get_labels (ValaSwitchSection* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->labels;
	result = _tmp0_;
	return result;
}

gboolean
vala_switch_section_has_default_label (ValaSwitchSection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		gint _label_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_label_list = _tmp0_;
		_tmp1_ = _label_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_label_size = _tmp3_;
		_label_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaSwitchLabel* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_label_index = _label_index + 1;
			_tmp4_ = _label_index;
			_tmp5_ = _label_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _label_list;
			_tmp7_ = vala_list_get (_tmp6_, _label_index);
			label = (ValaSwitchLabel*) _tmp7_;
			_tmp8_ = label;
			_tmp9_ = vala_switch_label_get_expression (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == NULL) {
				result = TRUE;
				_vala_code_node_unref0 (label);
				return result;
			}
			_vala_code_node_unref0 (label);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_switch_section_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_switch_section (visitor, self);
}

static void
vala_switch_section_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		gint _label_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_label_list = _tmp0_;
		_tmp1_ = _label_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_label_size = _tmp3_;
		_label_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaSwitchLabel* _tmp8_;
			_label_index = _label_index + 1;
			_tmp4_ = _label_index;
			_tmp5_ = _label_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _label_list;
			_tmp7_ = vala_list_get (_tmp6_, _label_index);
			label = (ValaSwitchLabel*) _tmp7_;
			_tmp8_ = label;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (label);
		}
	}
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), visitor);
}

static gboolean
vala_switch_section_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaSwitchSection * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeNode* _tmp4_;
	ValaCodeNode* _tmp5_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean result;
	self = (ValaSwitchSection*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	_tmp4_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp5_ = _tmp4_;
	if (!VALA_IS_SWITCH_STATEMENT (_tmp5_)) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "no enclosing switch statement found");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp8_;
		gint _label_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _label_index = 0;
		_tmp8_ = vala_switch_section_get_labels (self);
		_label_list = _tmp8_;
		_tmp9_ = _label_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_label_size = _tmp11_;
		_label_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaSwitchLabel* _tmp16_;
			_label_index = _label_index + 1;
			_tmp12_ = _label_index;
			_tmp13_ = _label_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _label_list;
			_tmp15_ = vala_list_get (_tmp14_, _label_index);
			label = (ValaSwitchLabel*) _tmp15_;
			_tmp16_ = label;
			vala_code_node_check ((ValaCodeNode*) _tmp16_, context);
			_vala_code_node_unref0 (label);
		}
	}
	if (!VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp17_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp18_ = _tmp17_;
	result = !_tmp18_;
	return result;
}

static void
vala_switch_section_real_emit (ValaCodeNode* base,
                               ValaCodeGenerator* codegen)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		gint _label_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_label_list = _tmp0_;
		_tmp1_ = _label_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_label_size = _tmp3_;
		_label_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaSwitchLabel* _tmp8_;
			_label_index = _label_index + 1;
			_tmp4_ = _label_index;
			_tmp5_ = _label_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _label_list;
			_tmp7_ = vala_list_get (_tmp6_, _label_index);
			label = (ValaSwitchLabel*) _tmp7_;
			_tmp8_ = label;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (label);
		}
	}
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->emit ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), codegen);
}

static void
vala_switch_section_class_init (ValaSwitchSectionClass * klass,
                                gpointer klass_data)
{
	vala_switch_section_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_switch_section_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSwitchSection_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_switch_section_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_switch_section_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_switch_section_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_switch_section_real_emit;
}

static void
vala_switch_section_instance_init (ValaSwitchSection * self,
                                   gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_switch_section_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_SWITCH_LABEL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->labels = (ValaList*) _tmp1_;
}

static void
vala_switch_section_finalize (ValaCodeNode * obj)
{
	ValaSwitchSection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SWITCH_SECTION, ValaSwitchSection);
	_vala_iterable_unref0 (self->priv->labels);
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->finalize (obj);
}

/**
 * Represents a switch section in the source code.
 */
static GType
vala_switch_section_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchSection), 0, (GInstanceInitFunc) vala_switch_section_instance_init, NULL };
	GType vala_switch_section_type_id;
	vala_switch_section_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaSwitchSection", &g_define_type_info, 0);
	ValaSwitchSection_private_offset = g_type_add_instance_private (vala_switch_section_type_id, sizeof (ValaSwitchSectionPrivate));
	return vala_switch_section_type_id;
}

GType
vala_switch_section_get_type (void)
{
	static volatile gsize vala_switch_section_type_id__once = 0;
	if (g_once_init_enter (&vala_switch_section_type_id__once)) {
		GType vala_switch_section_type_id;
		vala_switch_section_type_id = vala_switch_section_get_type_once ();
		g_once_init_leave (&vala_switch_section_type_id__once, vala_switch_section_type_id);
	}
	return vala_switch_section_type_id__once;
}

