/* valaarraytype.c generated by valac, the Vala compiler
 * generated from valaarraytype.vala, do not modify */

/* valaarraytype.vala
 *
 * Copyright (C) 2007-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaArrayTypePrivate {
	gboolean _invalid_syntax;
	gboolean _inline_allocated;
	gboolean _fixed_length;
	gint _rank;
	ValaDataType* _element_type;
	ValaDataType* _length_type;
	ValaExpression* _length;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
	ValaArrayCopyMethod* copy_method;
};

static gint ValaArrayType_private_offset;
static gpointer vala_array_type_parent_class = NULL;

static void vala_array_type_set_element_type (ValaArrayType* self,
                                       ValaDataType* value);
static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base,
                                             const gchar* member_name);
static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self);
static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self);
static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self);
static ValaArrayCopyMethod* vala_array_type_get_copy_method (ValaArrayType* self);
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
static gchar* vala_array_type_real_to_qualified_string (ValaDataType* base,
                                                 ValaScope* scope);
static gboolean vala_array_type_real_compatible (ValaDataType* base,
                                          ValaDataType* target_type);
static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base);
static void vala_array_type_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static void vala_array_type_real_replace_type (ValaCodeNode* base,
                                        ValaDataType* old_type,
                                        ValaDataType* new_type);
static gboolean vala_array_type_real_is_accessible (ValaDataType* base,
                                             ValaSymbol* sym);
static gboolean vala_array_type_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static ValaDataType* vala_array_type_real_get_actual_type (ValaDataType* base,
                                                    ValaDataType* derived_instance_type,
                                                    ValaList* method_type_arguments,
                                                    ValaCodeNode* node_reference);
static ValaDataType* vala_array_type_real_infer_type_argument (ValaDataType* base,
                                                        ValaTypeParameter* type_param,
                                                        ValaDataType* value_type);
static gboolean vala_array_type_real_is_disposable (ValaDataType* base);
static void vala_array_type_finalize (ValaCodeNode * obj);
static GType vala_array_type_get_type_once (void);

static inline gpointer
vala_array_type_get_instance_private (ValaArrayType* self)
{
	return G_STRUCT_MEMBER_P (self, ValaArrayType_private_offset);
}

ValaDataType*
vala_array_type_get_element_type (ValaArrayType* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_array_type_set_element_type (ValaArrayType* self,
                                  ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp0_;
	_tmp1_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaDataType*
vala_array_type_get_length_type (ValaArrayType* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length_type;
	result = _tmp0_;
	return result;
}

void
vala_array_type_set_length_type (ValaArrayType* self,
                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_length_type);
	self->priv->_length_type = _tmp0_;
	_tmp1_ = self->priv->_length_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		_tmp2_ = self->priv->_length_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gboolean
vala_array_type_get_invalid_syntax (ValaArrayType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_invalid_syntax;
	return result;
}

void
vala_array_type_set_invalid_syntax (ValaArrayType* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_invalid_syntax = value;
}

gboolean
vala_array_type_get_inline_allocated (ValaArrayType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_inline_allocated;
	return result;
}

void
vala_array_type_set_inline_allocated (ValaArrayType* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_inline_allocated = value;
}

gboolean
vala_array_type_get_fixed_length (ValaArrayType* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fixed_length;
	return result;
}

void
vala_array_type_set_fixed_length (ValaArrayType* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_fixed_length = value;
}

ValaExpression*
vala_array_type_get_length (ValaArrayType* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length;
	result = _tmp0_;
	return result;
}

void
vala_array_type_set_length (ValaArrayType* self,
                            ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_length);
	self->priv->_length = _tmp0_;
	_tmp1_ = self->priv->_length;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_length;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gint
vala_array_type_get_rank (ValaArrayType* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rank;
	return result;
}

void
vala_array_type_set_rank (ValaArrayType* self,
                          gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rank = value;
}

ValaArrayType*
vala_array_type_construct (GType object_type,
                           ValaDataType* element_type,
                           gint rank,
                           ValaSourceReference* source_reference)
{
	ValaArrayType* self = NULL;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayType*) vala_reference_type_construct (object_type, NULL, source_reference);
	vala_array_type_set_element_type (self, element_type);
	vala_array_type_set_rank (self, rank);
	return self;
}

ValaArrayType*
vala_array_type_new (ValaDataType* element_type,
                     gint rank,
                     ValaSourceReference* source_reference)
{
	return vala_array_type_construct (VALA_TYPE_ARRAY_TYPE, element_type, rank, source_reference);
}

static ValaSymbol*
vala_array_type_real_get_member (ValaDataType* base,
                                 const gchar* member_name)
{
	ValaArrayType * self;
	ValaSymbol* result;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	if (g_strcmp0 (member_name, "length") == 0) {
		ValaArrayLengthField* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_array_type_get_length_field (self);
		_tmp1_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp0_);
		result = _tmp1_;
		return result;
	} else {
		if (g_strcmp0 (member_name, "move") == 0) {
			ValaArrayMoveMethod* _tmp2_;
			ValaSymbol* _tmp3_;
			_tmp2_ = vala_array_type_get_move_method (self);
			_tmp3_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp2_);
			result = _tmp3_;
			return result;
		} else {
			if (g_strcmp0 (member_name, "resize") == 0) {
				gint _tmp4_;
				ValaArrayResizeMethod* _tmp5_;
				ValaSymbol* _tmp6_;
				_tmp4_ = self->priv->_rank;
				if (_tmp4_ > 1) {
					result = NULL;
					return result;
				}
				_tmp5_ = vala_array_type_get_resize_method (self);
				_tmp6_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp5_);
				result = _tmp6_;
				return result;
			} else {
				if (g_strcmp0 (member_name, "copy") == 0) {
					ValaArrayCopyMethod* _tmp7_;
					ValaSymbol* _tmp8_;
					_tmp7_ = vala_array_type_get_copy_method (self);
					_tmp8_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp7_);
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static ValaArrayLengthField*
vala_array_type_get_length_field (ValaArrayType* self)
{
	ValaArrayLengthField* _tmp0_;
	ValaArrayLengthField* _tmp20_;
	ValaArrayLengthField* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->length_field;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayLengthField* _tmp3_;
		ValaArrayLengthField* _tmp4_;
		gint _tmp5_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_length_field_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->length_field);
		self->priv->length_field = _tmp3_;
		_tmp4_ = self->priv->length_field;
		vala_symbol_set_access ((ValaSymbol*) _tmp4_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp5_ = self->priv->_rank;
		if (_tmp5_ > 1) {
			ValaArrayLengthField* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaDataType* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaArrayType* _tmp13_;
			ValaArrayType* _tmp14_;
			_tmp6_ = self->priv->length_field;
			_tmp7_ = vala_array_type_get_length_type (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_copy (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_array_type_new (_tmp10_, 1, _tmp12_);
			_tmp14_ = _tmp13_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp6_, (ValaDataType*) _tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			_vala_code_node_unref0 (_tmp10_);
		} else {
			ValaArrayLengthField* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			_tmp15_ = self->priv->length_field;
			_tmp16_ = vala_array_type_get_length_type (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_data_type_copy (_tmp17_);
			_tmp19_ = _tmp18_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp15_, _tmp19_);
			_vala_code_node_unref0 (_tmp19_);
		}
	}
	_tmp20_ = self->priv->length_field;
	result = _tmp20_;
	return result;
}

static ValaArrayResizeMethod*
vala_array_type_get_resize_method (ValaArrayType* self)
{
	ValaArrayResizeMethod* _tmp0_;
	ValaArrayResizeMethod* _tmp21_;
	ValaArrayResizeMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->resize_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayResizeMethod* _tmp3_;
		ValaArrayResizeMethod* _tmp4_;
		ValaVoidType* _tmp5_;
		ValaVoidType* _tmp6_;
		ValaArrayResizeMethod* _tmp7_;
		ValaCodeContext* _tmp8_;
		ValaCodeContext* _tmp9_;
		ValaProfile _tmp10_;
		ValaProfile _tmp11_;
		gboolean _tmp12_;
		ValaArrayResizeMethod* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaParameter* _tmp18_;
		ValaParameter* _tmp19_;
		ValaArrayResizeMethod* _tmp20_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_resize_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->resize_method);
		self->priv->resize_method = _tmp3_;
		_tmp4_ = self->priv->resize_method;
		_tmp5_ = vala_void_type_new (NULL);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, (ValaDataType*) _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->resize_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = vala_code_context_get ();
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_context_get_profile (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ == VALA_PROFILE_POSIX;
		_vala_code_context_unref0 (_tmp9_);
		if (_tmp12_) {
			ValaArrayResizeMethod* _tmp13_;
			_tmp13_ = self->priv->resize_method;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp13_, "CCode", "cname", "realloc", NULL);
		} else {
			ValaArrayResizeMethod* _tmp14_;
			_tmp14_ = self->priv->resize_method;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp14_, "CCode", "cname", "g_renew", NULL);
		}
		_tmp15_ = self->priv->resize_method;
		_tmp16_ = vala_array_type_get_length_type (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_parameter_new ("length", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		vala_callable_add_parameter ((ValaCallable*) _tmp15_, _tmp19_);
		_vala_code_node_unref0 (_tmp19_);
		_tmp20_ = self->priv->resize_method;
		vala_method_set_returns_modified_pointer ((ValaMethod*) _tmp20_, TRUE);
	}
	_tmp21_ = self->priv->resize_method;
	result = _tmp21_;
	return result;
}

static ValaArrayMoveMethod*
vala_array_type_get_move_method (ValaArrayType* self)
{
	ValaArrayMoveMethod* _tmp0_;
	ValaArrayMoveMethod* _tmp24_;
	ValaArrayMoveMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->move_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayMoveMethod* _tmp3_;
		ValaArrayMoveMethod* _tmp4_;
		ValaVoidType* _tmp5_;
		ValaVoidType* _tmp6_;
		ValaArrayMoveMethod* _tmp7_;
		ValaArrayMoveMethod* _tmp8_;
		ValaArrayMoveMethod* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		ValaArrayMoveMethod* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		ValaArrayMoveMethod* _tmp19_;
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_move_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->move_method);
		self->priv->move_method = _tmp3_;
		_tmp4_ = self->priv->move_method;
		_tmp5_ = vala_void_type_new (NULL);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, (ValaDataType*) _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->move_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->move_method;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "cname", "_vala_array_move", NULL);
		_tmp9_ = self->priv->move_method;
		_tmp10_ = vala_array_type_get_length_type (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_parameter_new ("src", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		vala_callable_add_parameter ((ValaCallable*) _tmp9_, _tmp13_);
		_vala_code_node_unref0 (_tmp13_);
		_tmp14_ = self->priv->move_method;
		_tmp15_ = vala_array_type_get_length_type (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_parameter_new ("dest", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		vala_callable_add_parameter ((ValaCallable*) _tmp14_, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp19_ = self->priv->move_method;
		_tmp20_ = vala_array_type_get_length_type (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_parameter_new ("length", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		vala_callable_add_parameter ((ValaCallable*) _tmp19_, _tmp23_);
		_vala_code_node_unref0 (_tmp23_);
	}
	_tmp24_ = self->priv->move_method;
	result = _tmp24_;
	return result;
}

static ValaArrayCopyMethod*
vala_array_type_get_copy_method (ValaArrayType* self)
{
	ValaArrayCopyMethod* _tmp0_;
	ValaArrayCopyMethod* _tmp12_;
	ValaArrayCopyMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->copy_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayCopyMethod* _tmp3_;
		ValaArrayCopyMethod* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaArrayCopyMethod* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaArrayCopyMethod* _tmp10_;
		ValaArrayCopyMethod* _tmp11_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_copy_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->copy_method);
		self->priv->copy_method = _tmp3_;
		_tmp4_ = self->priv->copy_method;
		_tmp5_ = vala_data_type_copy ((ValaDataType*) self);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->copy_method;
		_tmp8_ = vala_callable_get_return_type ((ValaCallable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
		_tmp10_ = self->priv->copy_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp10_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp11_ = self->priv->copy_method;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp11_, "CCode", "cname", "_vala_array_copy", NULL);
	}
	_tmp12_ = self->priv->copy_method;
	result = _tmp12_;
	return result;
}

static ValaDataType*
vala_array_type_real_copy (ValaDataType* base)
{
	ValaArrayType * self;
	ValaArrayType* _result_ = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gint _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaArrayType* _tmp7_;
	ValaArrayType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaArrayType* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	ValaArrayType* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	ValaArrayType* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	ValaArrayType* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	ValaArrayType* _tmp32_;
	gboolean _tmp33_;
	ValaDataType* result;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_copy (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_rank;
	_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_array_type_new (_tmp3_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_code_node_unref0 (_tmp3_);
	_result_ = _tmp8_;
	_tmp9_ = vala_array_type_get_length_type (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaArrayType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		_tmp11_ = _result_;
		_tmp12_ = vala_array_type_get_length_type (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_data_type_copy (_tmp13_);
		_tmp15_ = _tmp14_;
		vala_array_type_set_length_type (_tmp11_, _tmp15_);
		_vala_code_node_unref0 (_tmp15_);
	}
	_tmp16_ = _result_;
	_tmp17_ = vala_data_type_get_value_owned ((ValaDataType*) self);
	_tmp18_ = _tmp17_;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp16_, _tmp18_);
	_tmp19_ = _result_;
	_tmp20_ = vala_data_type_get_nullable ((ValaDataType*) self);
	_tmp21_ = _tmp20_;
	vala_data_type_set_nullable ((ValaDataType*) _tmp19_, _tmp21_);
	_tmp22_ = _result_;
	_tmp23_ = vala_data_type_get_floating_reference ((ValaDataType*) self);
	_tmp24_ = _tmp23_;
	vala_data_type_set_floating_reference ((ValaDataType*) _tmp22_, _tmp24_);
	_tmp25_ = _result_;
	_tmp26_ = self->priv->_inline_allocated;
	vala_array_type_set_inline_allocated (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->_fixed_length;
	if (_tmp27_) {
		ValaArrayType* _tmp28_;
		ValaArrayType* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp28_ = _result_;
		vala_array_type_set_fixed_length (_tmp28_, TRUE);
		_tmp29_ = _result_;
		_tmp30_ = vala_array_type_get_length (self);
		_tmp31_ = _tmp30_;
		vala_array_type_set_length (_tmp29_, _tmp31_);
	}
	_tmp32_ = _result_;
	_tmp33_ = self->priv->_invalid_syntax;
	vala_array_type_set_invalid_syntax (_tmp32_, _tmp33_);
	result = (ValaDataType*) _result_;
	return result;
}

static gchar*
vala_array_type_real_to_qualified_string (ValaDataType* base,
                                          ValaScope* scope)
{
	ValaArrayType * self;
	gchar* elem_str = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp10_;
	gchar* result;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_to_qualified_string (_tmp1_, scope);
	elem_str = _tmp2_;
	_tmp4_ = vala_array_type_get_element_type (self);
	_tmp5_ = _tmp4_;
	if (vala_data_type_is_weak (_tmp5_)) {
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		_tmp6_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		_tmp3_ = !VALA_IS_CONSTANT (_tmp7_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = elem_str;
		_tmp9_ = g_strdup_printf ("(unowned %s)", _tmp8_);
		_g_free0 (elem_str);
		elem_str = _tmp9_;
	}
	_tmp10_ = self->priv->_fixed_length;
	if (!_tmp10_) {
		gchar* _tmp11_ = NULL;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		gchar* length_str = NULL;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp23_ = NULL;
		gboolean _tmp24_;
		gboolean _tmp25_;
		const gchar* _tmp26_;
		gint _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp12_ = vala_array_type_get_length_type (self);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == NULL) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("int");
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp14_;
		} else {
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = vala_array_type_get_length_type (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_data_type_to_qualified_string (_tmp16_, scope);
			_g_free0 (_tmp11_);
			_tmp11_ = _tmp17_;
		}
		_tmp18_ = g_strdup (_tmp11_);
		length_str = _tmp18_;
		_tmp19_ = length_str;
		if (g_strcmp0 (_tmp19_, "int") != 0) {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp20_ = length_str;
			_tmp21_ = g_strdup_printf (":%s", _tmp20_);
			_g_free0 (length_str);
			length_str = _tmp21_;
		} else {
			gchar* _tmp22_;
			_tmp22_ = g_strdup ("");
			_g_free0 (length_str);
			length_str = _tmp22_;
		}
		_tmp24_ = vala_data_type_get_nullable ((ValaDataType*) self);
		_tmp25_ = _tmp24_;
		if (_tmp25_) {
			_tmp23_ = "?";
		} else {
			_tmp23_ = "";
		}
		_tmp26_ = elem_str;
		_tmp27_ = self->priv->_rank;
		_tmp28_ = g_strnfill ((gsize) (_tmp27_ - 1), ',');
		_tmp29_ = _tmp28_;
		_tmp30_ = length_str;
		_tmp31_ = g_strdup_printf ("%s[%s%s]%s", _tmp26_, _tmp29_, _tmp30_, _tmp23_);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp29_);
		result = _tmp32_;
		_g_free0 (length_str);
		_g_free0 (_tmp11_);
		_g_free0 (elem_str);
		return result;
	} else {
		result = elem_str;
		return result;
	}
}

static gboolean
vala_array_type_real_compatible (ValaDataType* base,
                                 ValaDataType* target_type)
{
	ValaArrayType * self;
	ValaCodeContext* context = NULL;
	ValaCodeContext* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_;
	ValaProfile _tmp3_;
	ValaProfile _tmp4_;
	gboolean _tmp34_ = FALSE;
	ValaArrayType* target_array_type = NULL;
	ValaArrayType* _tmp41_;
	ValaArrayType* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gboolean _tmp45_ = FALSE;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp57_;
	ValaDataType* _tmp58_;
	ValaArrayType* _tmp59_;
	ValaDataType* _tmp60_;
	ValaDataType* _tmp61_;
	gboolean _tmp62_ = FALSE;
	ValaDataType* _tmp63_;
	ValaDataType* _tmp64_;
	ValaArrayType* _tmp65_;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	gboolean result;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp0_ = vala_code_context_get ();
	context = _tmp0_;
	_tmp2_ = context;
	_tmp3_ = vala_code_context_get_profile (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == VALA_PROFILE_GOBJECT) {
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		_tmp5_ = vala_data_type_get_type_symbol (target_type);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp7_ = FALSE;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		ValaCodeContext* _tmp10_;
		ValaSemanticAnalyzer* _tmp11_;
		ValaSemanticAnalyzer* _tmp12_;
		ValaStructValueType* _tmp13_;
		ValaTypeSymbol* _tmp14_;
		ValaTypeSymbol* _tmp15_;
		ValaTypeSymbol* _tmp26_;
		ValaTypeSymbol* _tmp27_;
		ValaCodeContext* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaSemanticAnalyzer* _tmp30_;
		ValaObjectType* _tmp31_;
		ValaTypeSymbol* _tmp32_;
		ValaTypeSymbol* _tmp33_;
		_tmp8_ = vala_data_type_get_type_symbol (target_type);
		_tmp9_ = _tmp8_;
		_tmp10_ = context;
		_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_->gvalue_type;
		_tmp14_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (vala_typesymbol_is_subtype_of (_tmp9_, _tmp15_)) {
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaTypeSymbol* _tmp18_;
			ValaTypeSymbol* _tmp19_;
			ValaCodeContext* _tmp20_;
			ValaSemanticAnalyzer* _tmp21_;
			ValaSemanticAnalyzer* _tmp22_;
			ValaDataType* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			_tmp16_ = vala_array_type_get_element_type (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_data_type_get_type_symbol (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = context;
			_tmp21_ = vala_code_context_get_analyzer (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_->string_type;
			_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp7_ = _tmp19_ == _tmp25_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			result = TRUE;
			_vala_code_context_unref0 (context);
			return result;
		}
		_tmp26_ = vala_data_type_get_type_symbol (target_type);
		_tmp27_ = _tmp26_;
		_tmp28_ = context;
		_tmp29_ = vala_code_context_get_analyzer (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_->gvariant_type;
		_tmp32_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp31_);
		_tmp33_ = _tmp32_;
		if (vala_typesymbol_is_subtype_of (_tmp27_, _tmp33_)) {
			result = TRUE;
			_vala_code_context_unref0 (context);
			return result;
		}
	}
	if (VALA_IS_POINTER_TYPE (target_type)) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp35_ = FALSE;
		ValaTypeSymbol* _tmp36_;
		ValaTypeSymbol* _tmp37_;
		_tmp36_ = vala_data_type_get_type_symbol (target_type);
		_tmp37_ = _tmp36_;
		if (_tmp37_ != NULL) {
			ValaTypeSymbol* _tmp38_;
			ValaTypeSymbol* _tmp39_;
			ValaAttribute* _tmp40_;
			_tmp38_ = vala_data_type_get_type_symbol (target_type);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp39_, "PointerType");
			_tmp35_ = _tmp40_ != NULL;
		} else {
			_tmp35_ = FALSE;
		}
		_tmp34_ = _tmp35_;
	}
	if (_tmp34_) {
		result = TRUE;
		_vala_code_context_unref0 (context);
		return result;
	}
	if (VALA_IS_GENERIC_TYPE (target_type)) {
		result = TRUE;
		_vala_code_context_unref0 (context);
		return result;
	}
	target_array_type = VALA_IS_ARRAY_TYPE (target_type) ? ((ValaArrayType*) target_type) : NULL;
	_tmp41_ = target_array_type;
	if (_tmp41_ == NULL) {
		result = FALSE;
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp42_ = target_array_type;
	_tmp43_ = _tmp42_->priv->_rank;
	_tmp44_ = self->priv->_rank;
	if (_tmp43_ != _tmp44_) {
		result = FALSE;
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp46_ = vala_array_type_get_element_type (self);
	_tmp47_ = _tmp46_;
	if (VALA_IS_VALUE_TYPE (_tmp47_)) {
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		gboolean _tmp50_;
		gboolean _tmp51_;
		ValaArrayType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		gboolean _tmp55_;
		gboolean _tmp56_;
		_tmp48_ = vala_array_type_get_element_type (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_data_type_get_nullable (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = target_array_type;
		_tmp53_ = vala_array_type_get_element_type (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_data_type_get_nullable (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp45_ = _tmp51_ != _tmp56_;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		result = FALSE;
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp57_ = vala_array_type_get_length_type (self);
	_tmp58_ = _tmp57_;
	_tmp59_ = target_array_type;
	_tmp60_ = vala_array_type_get_length_type (_tmp59_);
	_tmp61_ = _tmp60_;
	if (!vala_data_type_compatible (_tmp58_, _tmp61_)) {
		result = FALSE;
		_vala_code_context_unref0 (context);
		return result;
	}
	_tmp63_ = vala_array_type_get_element_type (self);
	_tmp64_ = _tmp63_;
	_tmp65_ = target_array_type;
	_tmp66_ = vala_array_type_get_element_type (_tmp65_);
	_tmp67_ = _tmp66_;
	if (vala_data_type_compatible (_tmp64_, _tmp67_)) {
		ValaArrayType* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		_tmp68_ = target_array_type;
		_tmp69_ = vala_array_type_get_element_type (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_array_type_get_element_type (self);
		_tmp72_ = _tmp71_;
		_tmp62_ = vala_data_type_compatible (_tmp70_, _tmp72_);
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		result = TRUE;
		_vala_code_context_unref0 (context);
		return result;
	}
	result = FALSE;
	_vala_code_context_unref0 (context);
	return result;
}

static gboolean
vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base)
{
	ValaArrayType * self;
	gboolean result;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}

static void
vala_array_type_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaArrayType * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaArrayType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_array_type_get_length_type (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp4_ = vala_array_type_get_length_type (self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_array_type_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type)
{
	ValaArrayType * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaArrayType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_array_type_set_element_type (self, new_type);
	}
	_tmp2_ = vala_array_type_get_length_type (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_array_type_set_length_type (self, new_type);
	}
}

static gboolean
vala_array_type_real_is_accessible (ValaDataType* base,
                                    ValaSymbol* sym)
{
	ValaArrayType * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean result;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_array_type_get_length_type (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_array_type_get_length_type (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_data_type_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = vala_array_type_get_element_type (self);
	_tmp6_ = _tmp5_;
	result = vala_data_type_is_accessible (_tmp6_, sym);
	return result;
}

static gboolean
vala_array_type_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaArrayType * self;
	gboolean _tmp0_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	ValaDataType* _tmp30_;
	ValaDataType* _tmp31_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	gboolean result;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = self->priv->_invalid_syntax;
	if (_tmp0_) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, no expression allowed between array brackets");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_fixed_length;
	if (_tmp4_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_array_type_get_length (self);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp7_ = vala_array_type_get_length (self);
		_tmp8_ = _tmp7_;
		vala_code_node_check ((ValaCodeNode*) _tmp8_, context);
		_tmp11_ = vala_array_type_get_length (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_expression_get_value_type (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			_tmp16_ = vala_array_type_get_length (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_expression_get_value_type (_tmp17_);
			_tmp19_ = _tmp18_;
			if (VALA_IS_INTEGER_TYPE (_tmp19_)) {
				_tmp15_ = TRUE;
			} else {
				ValaExpression* _tmp20_;
				ValaExpression* _tmp21_;
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				_tmp20_ = vala_array_type_get_length (self);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_expression_get_value_type (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp15_ = VALA_IS_ENUM_VALUE_TYPE (_tmp23_);
			}
			_tmp10_ = !_tmp15_;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaExpression* _tmp24_;
			ValaExpression* _tmp25_;
			_tmp24_ = vala_array_type_get_length (self);
			_tmp25_ = _tmp24_;
			_tmp9_ = !vala_expression_is_constant (_tmp25_);
		}
		if (_tmp9_) {
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaSourceReference* _tmp28_;
			ValaSourceReference* _tmp29_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp26_ = vala_array_type_get_length (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
			_tmp29_ = _tmp28_;
			vala_report_error (_tmp29_, "Expression of constant integer type expected");
			result = FALSE;
			return result;
		}
	}
	_tmp30_ = vala_array_type_get_element_type (self);
	_tmp31_ = _tmp30_;
	if (VALA_IS_ARRAY_TYPE (_tmp31_)) {
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		vala_report_error (_tmp33_, "Stacked arrays are not supported");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		_tmp34_ = vala_array_type_get_element_type (self);
		_tmp35_ = _tmp34_;
		if (VALA_IS_DELEGATE_TYPE (_tmp35_)) {
			ValaDelegateType* delegate_type = NULL;
			ValaDataType* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDelegateType* _tmp38_;
			ValaDelegateType* _tmp39_;
			ValaDelegate* _tmp40_;
			ValaDelegate* _tmp41_;
			gboolean _tmp42_;
			gboolean _tmp43_;
			_tmp36_ = vala_array_type_get_element_type (self);
			_tmp37_ = _tmp36_;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			delegate_type = _tmp38_;
			_tmp39_ = delegate_type;
			_tmp40_ = vala_delegate_type_get_delegate_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_delegate_get_has_target (_tmp41_);
			_tmp43_ = _tmp42_;
			if (_tmp43_) {
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp45_, "Delegates with target are not supported as array element type");
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				return result;
			}
			_vala_code_node_unref0 (delegate_type);
		}
	}
	_tmp46_ = vala_array_type_get_length_type (self);
	_tmp47_ = _tmp46_;
	if (_tmp47_ == NULL) {
		ValaSemanticAnalyzer* _tmp48_;
		ValaSemanticAnalyzer* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		ValaDataType* _tmp52_;
		_tmp48_ = vala_code_context_get_analyzer (context);
		_tmp49_ = _tmp48_;
		_tmp50_ = _tmp49_->int_type;
		_tmp51_ = vala_data_type_copy (_tmp50_);
		_tmp52_ = _tmp51_;
		vala_array_type_set_length_type (self, _tmp52_);
		_vala_code_node_unref0 (_tmp52_);
	} else {
		ValaDataType* _tmp53_;
		ValaDataType* _tmp54_;
		gboolean _tmp55_ = FALSE;
		ValaDataType* _tmp56_;
		ValaDataType* _tmp57_;
		_tmp53_ = vala_array_type_get_length_type (self);
		_tmp54_ = _tmp53_;
		vala_code_node_check ((ValaCodeNode*) _tmp54_, context);
		_tmp56_ = vala_array_type_get_length_type (self);
		_tmp57_ = _tmp56_;
		if (!VALA_IS_INTEGER_TYPE (_tmp57_)) {
			_tmp55_ = TRUE;
		} else {
			ValaDataType* _tmp58_;
			ValaDataType* _tmp59_;
			gboolean _tmp60_;
			gboolean _tmp61_;
			_tmp58_ = vala_array_type_get_length_type (self);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_data_type_get_nullable (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp55_ = _tmp61_;
		}
		if (_tmp55_) {
			ValaDataType* _tmp62_;
			ValaDataType* _tmp63_;
			ValaSourceReference* _tmp64_;
			ValaSourceReference* _tmp65_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp62_ = vala_array_type_get_length_type (self);
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
			_tmp65_ = _tmp64_;
			vala_report_error (_tmp65_, "Expected integer type as length type of array");
			result = FALSE;
			return result;
		}
	}
	_tmp66_ = vala_array_type_get_element_type (self);
	_tmp67_ = _tmp66_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp67_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp68_ = vala_array_type_get_element_type (self);
	_tmp69_ = _tmp68_;
	if (!vala_data_type_check_type_arguments (_tmp69_, context, TRUE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static ValaDataType*
vala_array_type_real_get_actual_type (ValaDataType* base,
                                      ValaDataType* derived_instance_type,
                                      ValaList* method_type_arguments,
                                      ValaCodeNode* node_reference)
{
	ValaArrayType * self;
	ValaArrayType* _result_ = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* result;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_data_type_copy ((ValaDataType*) self);
	_result_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	if (derived_instance_type == NULL) {
		_tmp1_ = method_type_arguments == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = (ValaDataType*) _result_;
		return result;
	}
	_tmp3_ = vala_array_type_get_element_type (self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_GENERIC_TYPE (_tmp4_)) {
		_tmp2_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp5_ = vala_array_type_get_element_type (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = vala_data_type_has_type_arguments (_tmp6_);
	}
	if (_tmp2_) {
		ValaArrayType* _tmp7_;
		ValaArrayType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp7_ = _result_;
		_tmp8_ = _result_;
		_tmp9_ = vala_array_type_get_element_type (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_data_type_get_actual_type (_tmp10_, derived_instance_type, method_type_arguments, node_reference);
		_tmp12_ = _tmp11_;
		vala_array_type_set_element_type (_tmp7_, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
	}
	result = (ValaDataType*) _result_;
	return result;
}

static ValaDataType*
vala_array_type_real_infer_type_argument (ValaDataType* base,
                                          ValaTypeParameter* type_param,
                                          ValaDataType* value_type)
{
	ValaArrayType * self;
	ValaArrayType* array_type = NULL;
	ValaArrayType* _tmp0_;
	ValaDataType* result;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (type_param != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	array_type = VALA_IS_ARRAY_TYPE (value_type) ? ((ValaArrayType*) value_type) : NULL;
	_tmp0_ = array_type;
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaArrayType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp1_ = vala_array_type_get_element_type (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = array_type;
		_tmp4_ = vala_array_type_get_element_type (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_infer_type_argument (_tmp2_, type_param, _tmp5_);
		result = _tmp6_;
		return result;
	}
	result = NULL;
	return result;
}

static gboolean
vala_array_type_real_is_disposable (ValaDataType* base)
{
	ValaArrayType * self;
	gboolean _tmp0_;
	gboolean result;
	self = (ValaArrayType*) base;
	_tmp0_ = self->priv->_fixed_length;
	if (_tmp0_) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		_tmp1_ = vala_array_type_get_element_type (self);
		_tmp2_ = _tmp1_;
		result = vala_data_type_is_disposable (_tmp2_);
		return result;
	} else {
		result = VALA_DATA_TYPE_CLASS (vala_array_type_parent_class)->is_disposable ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_REFERENCE_TYPE, ValaReferenceType));
		return result;
	}
}

static void
vala_array_type_class_init (ValaArrayTypeClass * klass,
                            gpointer klass_data)
{
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_type_finalize;
	g_type_class_adjust_private_offset (klass, &ValaArrayType_private_offset);
	((ValaDataTypeClass *) klass)->get_member = (ValaSymbol* (*) (ValaDataType*, const gchar*)) vala_array_type_real_get_member;
	((ValaDataTypeClass *) klass)->copy = (ValaDataType* (*) (ValaDataType*)) vala_array_type_real_copy;
	((ValaDataTypeClass *) klass)->to_qualified_string = (gchar* (*) (ValaDataType*, ValaScope*)) vala_array_type_real_to_qualified_string;
	((ValaDataTypeClass *) klass)->compatible = (gboolean (*) (ValaDataType*, ValaDataType*)) vala_array_type_real_compatible;
	((ValaDataTypeClass *) klass)->is_reference_type_or_type_parameter = (gboolean (*) (ValaDataType*)) vala_array_type_real_is_reference_type_or_type_parameter;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_array_type_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_array_type_real_replace_type;
	((ValaDataTypeClass *) klass)->is_accessible = (gboolean (*) (ValaDataType*, ValaSymbol*)) vala_array_type_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_array_type_real_check;
	((ValaDataTypeClass *) klass)->get_actual_type = (ValaDataType* (*) (ValaDataType*, ValaDataType*, ValaList*, ValaCodeNode*)) vala_array_type_real_get_actual_type;
	((ValaDataTypeClass *) klass)->infer_type_argument = (ValaDataType* (*) (ValaDataType*, ValaTypeParameter*, ValaDataType*)) vala_array_type_real_infer_type_argument;
	((ValaDataTypeClass *) klass)->is_disposable = (gboolean (*) (ValaDataType*)) vala_array_type_real_is_disposable;
}

static void
vala_array_type_instance_init (ValaArrayType * self,
                               gpointer klass)
{
	self->priv = vala_array_type_get_instance_private (self);
}

static void
vala_array_type_finalize (ValaCodeNode * obj)
{
	ValaArrayType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_length_type);
	_vala_code_node_unref0 (self->priv->_length);
	_vala_code_node_unref0 (self->priv->length_field);
	_vala_code_node_unref0 (self->priv->resize_method);
	_vala_code_node_unref0 (self->priv->move_method);
	_vala_code_node_unref0 (self->priv->copy_method);
	VALA_CODE_NODE_CLASS (vala_array_type_parent_class)->finalize (obj);
}

/**
 * An array type.
 */
static GType
vala_array_type_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_instance_init, NULL };
	GType vala_array_type_type_id;
	vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
	ValaArrayType_private_offset = g_type_add_instance_private (vala_array_type_type_id, sizeof (ValaArrayTypePrivate));
	return vala_array_type_type_id;
}

GType
vala_array_type_get_type (void)
{
	static volatile gsize vala_array_type_type_id__once = 0;
	if (g_once_init_enter (&vala_array_type_type_id__once)) {
		GType vala_array_type_type_id;
		vala_array_type_type_id = vala_array_type_get_type_once ();
		g_once_init_leave (&vala_array_type_type_id__once, vala_array_type_type_id);
	}
	return vala_array_type_type_id__once;
}

