A tuple struct's element isn't a machine type when using the `#[simd]`
attribute.

Erroneous code example:

```compile_fail,E0077
#![feature(repr_simd)]

#[repr(simd)]
struct Bad(String); // error!
```

When using the `#[simd]` attribute on a tuple struct, the elements in the tuple
must be machine types so SIMD operations can be applied to them.

Fixed example:

```
#![feature(repr_simd)]

#[repr(simd)]
struct Good(u32, u32, u32, u32); // ok!
```
