An associated item wasn't found in the given type.

Erroneous code example:

```compile_fail,E0576
trait Hello {
    type Who;

    fn hello() -> <Self as Hello>::You; // error!
}
```

In this example, we tried to use the nonexistent associated type `You` of the
`Hello` trait. To fix this error, use an existing associated type:

```
trait Hello {
    type Who;

    fn hello() -> <Self as Hello>::Who; // ok!
}
```
