A function was given both the `ffi_const` and `ffi_pure` attributes.

Erroneous code example:

```compile_fail,E0757
#![feature(ffi_const, ffi_pure)]

extern "C" {
    #[ffi_const]
    #[ffi_pure] // error: `#[ffi_const]` function cannot be `#[ffi_pure]`
    pub fn square(num: i32) -> i32;
}
```

As `ffi_const` provides stronger guarantees than `ffi_pure`, remove the
`ffi_pure` attribute:

```
#![feature(ffi_const)]

extern "C" {
    #[ffi_const]
    pub fn square(num: i32) -> i32;
}
```

You can get more information about `const` and `pure` in the [GCC documentation
on Common Function Attributes]. The unstable Rust Book has more information
about [`ffi_const`] and [`ffi_pure`].

[GCC documentation on Common Function Attributes]: https://gcc.gnu.org/onlinedocs/gcc/Common-Function-Attributes.html
[`ffi_const`]: https://doc.rust-lang.org/nightly/unstable-book/language-features/ffi-const.html
[`ffi_pure`]: https://doc.rust-lang.org/nightly/unstable-book/language-features/ffi-pure.html
