.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbFreeKeyboard __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbFreeKeyboard \-  Destroys either an entire XkbDescRec or just some of its 
members
.SH SYNOPSIS
.HP
.B void XkbFreeKeyboard
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "Bool " "free_all" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I xkb
keyboard description with components to free 
.TP
.I which
mask selecting components to free
.TP
.I free_all
True => free all components and 
.I xkb
.SH DESCRIPTION
.LP
.I XkbFreeKeyboard 
frees the components of 
.I xkb 
specified by 
.I which 
and sets the corresponding values to NULL. If 
.I
free_all 
is True, 
.I XkbFreeKeyboard 
frees every non-NULL component of 
.I xkb 
and then frees the 
.I xkb 
structure itself.

If kbd is NULL, no operation is performed.

.SH "SEE ALSO"
.BR XkbFreeClientMap (__libmansuffix__),
.BR XkbFreeServerMap (__libmansuffix__),
.BR XkbFreeCompatMap (__libmansuffix__),
.BR XkbFreeIndicatorMaps (__libmansuffix__),
.BR XkbFreeNames (__libmansuffix__),
.BR XkbFreeGeometry (__libmansuffix__),
.BR XkbFreeControls (__libmansuffix__)
