/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_oaep_2048_sha1_mgf1sha1_vectors_h__
#define rsa_oaep_2048_sha1_mgf1sha1_vectors_h__

#include "testvectors_base/test-structs.h"

static const std::vector<uint8_t> priv_key_0{
    0x30, 0x82, 0x04, 0xbc, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a,
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82,
    0x04, 0xa6, 0x30, 0x82, 0x04, 0xa2, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01,
    0x01, 0x00, 0xbd, 0x31, 0xc7, 0xa0, 0x26, 0x91, 0xd2, 0xd9, 0x58, 0x7e,
    0xf6, 0xa9, 0x46, 0xff, 0x78, 0x85, 0x44, 0xcc, 0xad, 0xd4, 0xb2, 0x98,
    0x8a, 0xd6, 0x20, 0x86, 0x79, 0x2a, 0x6b, 0xf9, 0x6c, 0x86, 0x16, 0xb4,
    0xad, 0x13, 0x31, 0x7d, 0x22, 0x70, 0xb9, 0x01, 0xd0, 0xfc, 0xd1, 0xd8,
    0x80, 0xcb, 0x8f, 0x52, 0xfb, 0x87, 0x30, 0x4a, 0x52, 0x58, 0xc1, 0x1b,
    0x38, 0xdf, 0xea, 0xe8, 0xdf, 0x67, 0x0a, 0xee, 0xe7, 0xea, 0x1d, 0x0d,
    0x9d, 0xf8, 0xe0, 0x0e, 0x80, 0x84, 0x7e, 0x41, 0xe5, 0x98, 0x9e, 0xd4,
    0x02, 0xd4, 0x4e, 0x78, 0xb3, 0x0f, 0xef, 0x17, 0xb5, 0x67, 0x1d, 0x3a,
    0xdb, 0xf8, 0x68, 0x5e, 0x4d, 0xc2, 0x04, 0x49, 0x9e, 0xcd, 0x18, 0x63,
    0xe1, 0xd5, 0xaf, 0xf2, 0x8a, 0x7c, 0xf6, 0x6e, 0xad, 0xf3, 0x1f, 0xec,
    0x92, 0x36, 0xc1, 0x20, 0xad, 0xd1, 0x34, 0x51, 0x52, 0x2c, 0x64, 0x7c,
    0x98, 0x32, 0xa6, 0x72, 0xcd, 0x64, 0xd3, 0x28, 0xc1, 0xc3, 0x22, 0x18,
    0x3f, 0x46, 0x61, 0xd0, 0x9b, 0xda, 0x60, 0xb8, 0xdd, 0x5f, 0x03, 0x28,
    0xda, 0x54, 0x20, 0x82, 0x14, 0x24, 0xaf, 0xda, 0xbb, 0x1a, 0x80, 0xc5,
    0xd1, 0x27, 0x63, 0xa1, 0xb0, 0x23, 0x8c, 0xd8, 0x9d, 0x07, 0x42, 0xbf,
    0xc5, 0x0b, 0x6a, 0x2f, 0xcb, 0x70, 0x1d, 0x82, 0x42, 0x18, 0xf9, 0x82,
    0x6f, 0x4f, 0x78, 0xa2, 0x3a, 0x2b, 0x5a, 0xa4, 0x2a, 0xce, 0x7f, 0x17,
    0x53, 0x76, 0xfb, 0x6c, 0xbd, 0xb2, 0xba, 0xd2, 0x93, 0xba, 0x58, 0x3d,
    0x4d, 0x31, 0xc6, 0xb8, 0xf9, 0x02, 0x9e, 0x46, 0xb1, 0x36, 0x89, 0x24,
    0x98, 0x55, 0xf5, 0x05, 0x75, 0x6e, 0x00, 0xe2, 0x25, 0xa6, 0xa4, 0x5a,
    0x18, 0x76, 0x9b, 0xd8, 0xd2, 0xb3, 0xa4, 0xac, 0xb9, 0xf1, 0xc2, 0x3d,
    0x3e, 0x51, 0x88, 0x25, 0x61, 0xe5, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02,
    0x82, 0x01, 0x00, 0x07, 0x47, 0xd5, 0x20, 0xca, 0x9b, 0x2d, 0xfc, 0x03,
    0x35, 0xcf, 0x94, 0x30, 0x11, 0x40, 0xb8, 0x10, 0x2f, 0xb8, 0x38, 0xc9,
    0x2e, 0xa9, 0x99, 0x17, 0xe3, 0x54, 0xe2, 0x57, 0x09, 0x60, 0x2d, 0xc0,
    0xcd, 0xef, 0x23, 0x1f, 0xf2, 0x6a, 0xd2, 0xdf, 0xab, 0xbc, 0x39, 0x1e,
    0x72, 0x30, 0x72, 0xa4, 0xef, 0x52, 0x92, 0x9f, 0x3f, 0x1c, 0xf0, 0x21,
    0x6e, 0x44, 0xc0, 0x09, 0x30, 0x30, 0xf8, 0xac, 0x29, 0x09, 0x6f, 0xae,
    0xf2, 0x89, 0x33, 0xbc, 0x9b, 0x92, 0x42, 0x87, 0x01, 0x4e, 0x2e, 0x93,
    0x5e, 0x21, 0x45, 0xbe, 0x47, 0x52, 0xcc, 0xb8, 0x2c, 0xb7, 0x64, 0x62,
    0x71, 0x93, 0x69, 0x79, 0xca, 0xb7, 0x3f, 0x52, 0x1e, 0xeb, 0x27, 0x85,
    0x5a, 0xc2, 0xa4, 0x10, 0x83, 0x4a, 0xe5, 0x08, 0x2e, 0xb6, 0x2e, 0xf6,
    0xf9, 0x89, 0x9e, 0xe5, 0xcb, 0xb6, 0x24, 0xa8, 0xd8, 0xc0, 0x4a, 0xb7,
    0xed, 0xcf, 0x78, 0xfe, 0x13, 0x5d, 0x0f, 0x80, 0x8f, 0x63, 0xb5, 0xde,
    0x6e, 0x07, 0x17, 0x79, 0xbf, 0x1d, 0x9e, 0xaa, 0xf8, 0xd3, 0xef, 0x96,
    0x54, 0x86, 0xf2, 0xc5, 0x26, 0x25, 0xe6, 0xe5, 0x7a, 0x65, 0x1c, 0x7b,
    0xbd, 0x01, 0x97, 0xc9, 0x9c, 0x05, 0x7b, 0x38, 0x60, 0xa3, 0x26, 0x0c,
    0x86, 0x4a, 0x11, 0xb3, 0xcf, 0x22, 0xba, 0x44, 0xde, 0x3a, 0x3b, 0x3f,
    0x31, 0x17, 0xe6, 0x4e, 0xbf, 0x9a, 0x91, 0xf6, 0x26, 0xeb, 0xb3, 0xf3,
    0xc2, 0x6d, 0x1b, 0x0b, 0xb8, 0x07, 0x53, 0x46, 0x8d, 0x4b, 0xf6, 0xa9,
    0x97, 0xb2, 0x83, 0x35, 0xf2, 0x0e, 0xd8, 0xc3, 0x84, 0xd7, 0x55, 0x83,
    0x60, 0xa9, 0xae, 0x97, 0x55, 0x66, 0x1f, 0xa3, 0x74, 0x98, 0x46, 0xb1,
    0x74, 0xe6, 0xbf, 0x33, 0x0e, 0x52, 0xd0, 0x99, 0x41, 0xf6, 0xcc, 0xd7,
    0xde, 0x50, 0x04, 0x77, 0x9f, 0x9b, 0xb9, 0x02, 0x81, 0x81, 0x00, 0xfe,
    0x3d, 0x23, 0x8d, 0x37, 0x6a, 0x38, 0x56, 0xd9, 0x59, 0x2f, 0xd4, 0x96,
    0x1c, 0x17, 0xa7, 0xfb, 0x0f, 0xa3, 0x9d, 0x44, 0x2e, 0x9d, 0xf2, 0x2e,
    0x7e, 0xda, 0x11, 0x5c, 0x64, 0x8c, 0x5c, 0xb7, 0x38, 0xdf, 0x89, 0xea,
    0x92, 0xd8, 0x37, 0x85, 0x58, 0xd0, 0xd9, 0xc1, 0xcf, 0x3d, 0x8b, 0xff,
    0x74, 0x0d, 0x37, 0x43, 0xa0, 0x14, 0x0a, 0x6a, 0x75, 0x23, 0xe9, 0x17,
    0x6c, 0x29, 0x53, 0xb2, 0xc1, 0x1d, 0x7f, 0x44, 0x69, 0x1c, 0xf8, 0xbe,
    0xc2, 0xb3, 0x4f, 0xb5, 0x9c, 0x64, 0x95, 0x35, 0x98, 0x33, 0x19, 0x48,
    0x81, 0x18, 0xc0, 0x31, 0x18, 0xae, 0x74, 0x45, 0xe7, 0x0d, 0xf4, 0x66,
    0xce, 0x98, 0x67, 0x12, 0x60, 0xf0, 0x5d, 0x50, 0x68, 0xce, 0x77, 0x7d,
    0xa9, 0x7e, 0x2b, 0xa8, 0x47, 0x79, 0x49, 0x05, 0x00, 0xce, 0xb4, 0xff,
    0x7f, 0x62, 0xce, 0xca, 0x9a, 0x14, 0x7f, 0x02, 0x81, 0x81, 0x00, 0xbe,
    0x81, 0x4a, 0xf2, 0x6b, 0xf3, 0xc2, 0x71, 0x15, 0xbc, 0x75, 0x95, 0xd0,
    0xd1, 0x2a, 0x1a, 0xf7, 0x71, 0x3f, 0xec, 0xa8, 0x77, 0xae, 0x6e, 0x6d,
    0x85, 0x88, 0x25, 0xed, 0xa3, 0xd1, 0x92, 0x70, 0x47, 0x74, 0xf4, 0x2e,
    0x1a, 0xe1, 0xb6, 0x7f, 0x17, 0x39, 0xe8, 0xc4, 0x5a, 0x04, 0x76, 0x38,
    0x80, 0x70, 0xfa, 0x54, 0x5b, 0x7c, 0xc9, 0x6b, 0x8a, 0x44, 0x00, 0x3b,
    0xc8, 0xd0, 0x7f, 0xde, 0x73, 0xf5, 0xbc, 0xdd, 0x18, 0x26, 0x83, 0x95,
    0xdc, 0xc2, 0x84, 0x2b, 0x50, 0x23, 0xff, 0x14, 0xb3, 0x52, 0x38, 0x26,
    0x07, 0xb7, 0x17, 0x9a, 0x5e, 0xa3, 0x30, 0x84, 0x0f, 0xc4, 0x50, 0x45,
    0xd8, 0x6e, 0x0a, 0xcc, 0x4f, 0xeb, 0x13, 0x5f, 0x0a, 0xb9, 0xb7, 0xce,
    0x6b, 0x8e, 0xb5, 0xf5, 0xa5, 0x75, 0xf2, 0xa2, 0xa8, 0xde, 0x29, 0x9c,
    0x0d, 0x3f, 0x50, 0x6d, 0xf4, 0x87, 0x9b, 0x02, 0x81, 0x80, 0x61, 0xbb,
    0x4c, 0xf4, 0x57, 0x2e, 0x0c, 0xf4, 0x4d, 0xde, 0xfc, 0x05, 0x03, 0xa3,
    0x4e, 0xf0, 0xb3, 0x11, 0x42, 0xfb, 0x0c, 0x9f, 0xc2, 0xf5, 0xbb, 0x2b,
    0xe6, 0x56, 0x30, 0x27, 0x32, 0xd1, 0xdd, 0x59, 0x0e, 0x8d, 0x6c, 0xd0,
    0x00, 0x2f, 0xef, 0xa1, 0xc1, 0xbf, 0x43, 0xc2, 0x8f, 0xcd, 0x46, 0x68,
    0xed, 0x3f, 0xa6, 0x4e, 0x5e, 0x05, 0xd7, 0x00, 0xaa, 0xca, 0x4a, 0xc7,
    0xb8, 0x67, 0x45, 0x5a, 0xf9, 0x24, 0xd8, 0x3e, 0x73, 0xf5, 0xa7, 0x17,
    0x1f, 0x68, 0xef, 0xce, 0x6b, 0xd7, 0xf3, 0xdf, 0x4b, 0x1d, 0x58, 0x02,
    0xd0, 0x69, 0xe9, 0x35, 0xac, 0xb2, 0x63, 0xc0, 0xbb, 0x5b, 0x8d, 0x3d,
    0xb3, 0xd6, 0x43, 0x79, 0x62, 0x4c, 0xec, 0xc1, 0x2d, 0x45, 0x3f, 0xd8,
    0x2c, 0xf9, 0x49, 0x5a, 0x18, 0x64, 0x9a, 0x78, 0xc1, 0xfd, 0x50, 0x0e,
    0x3f, 0x04, 0x71, 0x5b, 0xa3, 0xaf, 0x02, 0x81, 0x80, 0x66, 0x49, 0xdb,
    0xe9, 0x20, 0xa7, 0xa8, 0xce, 0xb9, 0x82, 0x10, 0x8c, 0xd9, 0xab, 0x85,
    0x75, 0x27, 0x49, 0x8a, 0xae, 0x52, 0xa2, 0xb8, 0x69, 0x18, 0xab, 0x6b,
    0x38, 0x1a, 0x4a, 0x2c, 0xbb, 0xf9, 0x47, 0x94, 0xf7, 0x8b, 0x4d, 0xe9,
    0xc5, 0xe8, 0xa5, 0x9a, 0xf5, 0x6d, 0x80, 0x7c, 0x06, 0xd2, 0x3d, 0xbc,
    0xeb, 0xdc, 0xa1, 0xa6, 0xf6, 0x2b, 0xa4, 0xf8, 0xf0, 0x3b, 0x29, 0x8f,
    0x32, 0x29, 0x4a, 0x90, 0x36, 0xd1, 0x6c, 0x27, 0x39, 0xde, 0x1c, 0xc3,
    0xe0, 0xdd, 0xb4, 0xd1, 0x2f, 0x24, 0x79, 0x48, 0x7b, 0x57, 0x88, 0x2a,
    0xfa, 0x24, 0x6c, 0x0e, 0x29, 0x7d, 0xaf, 0x4d, 0x94, 0x60, 0x7c, 0x5e,
    0x51, 0xb3, 0xf4, 0x71, 0x5f, 0x5c, 0x57, 0xd0, 0xf2, 0x6d, 0x86, 0x79,
    0x01, 0x20, 0x9d, 0xb0, 0x20, 0x10, 0xd0, 0xa5, 0x41, 0x28, 0x46, 0x40,
    0xa9, 0xb9, 0xf0, 0x63, 0x63, 0x02, 0x81, 0x80, 0x39, 0xec, 0x60, 0x6f,
    0x5c, 0x9f, 0x1f, 0x33, 0xd9, 0x64, 0x60, 0x6e, 0x12, 0x8e, 0x9e, 0x90,
    0xcf, 0xf9, 0x32, 0x77, 0x2c, 0x57, 0x15, 0xaa, 0x75, 0x98, 0x16, 0xd5,
    0x04, 0xef, 0xe2, 0xc4, 0x62, 0x06, 0xf3, 0x37, 0x9a, 0xa6, 0x1d, 0x31,
    0xf8, 0x8e, 0x72, 0x6b, 0x50, 0xdd, 0x80, 0xb8, 0xce, 0x85, 0x58, 0xa0,
    0xd7, 0x40, 0x85, 0x25, 0xf5, 0x8c, 0x33, 0x99, 0xce, 0x32, 0xe2, 0x39,
    0xd7, 0x09, 0x41, 0xf1, 0x2d, 0x21, 0xe7, 0x76, 0x1c, 0x04, 0x3e, 0x0b,
    0x02, 0x22, 0x0d, 0x25, 0xff, 0xd0, 0x35, 0x71, 0xc7, 0xae, 0x5b, 0xbd,
    0x59, 0xc3, 0x1f, 0x48, 0x12, 0x06, 0x76, 0xf9, 0xd7, 0xc3, 0x70, 0xa7,
    0x49, 0xd8, 0x49, 0x1b, 0xdf, 0xce, 0xa0, 0x16, 0x62, 0xa1, 0x36, 0xc8,
    0x5d, 0x34, 0x9b, 0x6c, 0x71, 0x0f, 0xc6, 0xf6, 0xeb, 0xf8, 0xa7, 0xa7,
    0x9b, 0x62, 0xad, 0xc3};

const RsaOaepTestVector kRsaOaep2048Sha1WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     1,
     {},
     {0xba, 0x36, 0x68, 0x06, 0xe4, 0xad, 0x50, 0xf7, 0x6c, 0x0d, 0x8f, 0x63,
      0xa8, 0x4c, 0xc8, 0xc1, 0x04, 0x5f, 0xbb, 0x2f, 0x9b, 0xef, 0x31, 0xda,
      0x89, 0x21, 0x4b, 0x2c, 0x85, 0x53, 0xe2, 0xd0, 0x12, 0x6f, 0xb9, 0x1e,
      0x8a, 0xd9, 0xc7, 0x8d, 0x15, 0x15, 0xc1, 0x59, 0x3f, 0xcd, 0x58, 0x92,
      0x78, 0x36, 0x9f, 0x83, 0xd8, 0xda, 0x35, 0x08, 0xbe, 0xed, 0x57, 0x3b,
      0x2e, 0x8a, 0x2e, 0x61, 0xe0, 0x9d, 0x99, 0x23, 0x47, 0x6c, 0xf2, 0xd1,
      0xca, 0xde, 0x86, 0x23, 0x44, 0xa8, 0x7c, 0x8e, 0x50, 0xd6, 0x60, 0x07,
      0x54, 0x08, 0x99, 0x92, 0x85, 0x1f, 0x44, 0x99, 0x8b, 0xe5, 0x71, 0x09,
      0xfe, 0x4f, 0x9a, 0x78, 0x7f, 0xc1, 0x3c, 0xba, 0x35, 0x1f, 0x33, 0x5d,
      0xf5, 0xf4, 0xcd, 0x65, 0x68, 0x58, 0xa9, 0xd9, 0xb5, 0x47, 0x43, 0x8d,
      0xb4, 0xe0, 0xe8, 0x16, 0x40, 0x61, 0x81, 0x04, 0xfa, 0xc1, 0x0c, 0x02,
      0x27, 0x73, 0x3f, 0x85, 0xe0, 0x41, 0xa3, 0x22, 0x45, 0x9c, 0x13, 0xeb,
      0xcf, 0x48, 0x55, 0xfa, 0x69, 0x51, 0x9a, 0xb9, 0x43, 0x01, 0x56, 0x11,
      0x46, 0x83, 0x06, 0x80, 0xe1, 0x61, 0x6f, 0xcf, 0x46, 0x52, 0xd3, 0x0d,
      0xc6, 0xd0, 0xcd, 0x0a, 0xba, 0x39, 0x75, 0x60, 0xd2, 0xa5, 0xb9, 0x55,
      0x6b, 0x42, 0xd4, 0x2e, 0xe2, 0x08, 0x8e, 0xf8, 0x79, 0x34, 0x69, 0xd1,
      0x14, 0x23, 0x31, 0xa0, 0xb3, 0x01, 0x8f, 0xeb, 0x15, 0x39, 0x99, 0xa2,
      0x43, 0x93, 0x49, 0xa7, 0x09, 0xee, 0xcb, 0xf0, 0x95, 0x68, 0x64, 0x3f,
      0x8e, 0x5d, 0x33, 0x89, 0x07, 0x3e, 0xaf, 0xd9, 0x3d, 0x37, 0x54, 0x40,
      0x57, 0xe5, 0x67, 0xc3, 0xa5, 0x53, 0x26, 0x9e, 0xa1, 0xb1, 0x5a, 0x49,
      0x38, 0x81, 0x27, 0x53, 0x2a, 0xb9, 0x67, 0x86, 0x0c, 0x04, 0x06, 0xa4,
      0xb0, 0xcb, 0x3a, 0xdc},
     {},
     priv_key_0,
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     2,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x87, 0x73, 0xfd, 0xde, 0x3f, 0x14, 0x8e, 0xc3, 0x3d, 0x4f, 0xac, 0xdf,
      0xba, 0x81, 0x2e, 0x44, 0x00, 0x1d, 0x90, 0x86, 0x1c, 0x04, 0x7a, 0x9e,
      0xef, 0xe6, 0xc6, 0x54, 0x02, 0x12, 0x79, 0x5b, 0x50, 0xdd, 0x18, 0x6b,
      0xb7, 0x71, 0x2b, 0x84, 0x48, 0x83, 0x0f, 0xc1, 0x79, 0x9e, 0x05, 0x43,
      0xb7, 0x09, 0x3e, 0x47, 0x70, 0xf3, 0x01, 0xe9, 0x21, 0x69, 0x22, 0xe8,
      0x02, 0x80, 0xe9, 0xb5, 0x05, 0x82, 0xc6, 0x69, 0xe3, 0xa9, 0xa4, 0xfe,
      0xb0, 0x8e, 0xc6, 0xf5, 0xb2, 0x42, 0x8d, 0xc7, 0xef, 0xbc, 0xf6, 0xfe,
      0x49, 0xfe, 0xb6, 0x1f, 0xd2, 0x79, 0x5a, 0xf1, 0xc8, 0xb2, 0x3a, 0xcb,
      0x60, 0x58, 0x12, 0xc9, 0xd7, 0x58, 0x6e, 0x4f, 0x48, 0xe4, 0xd7, 0x58,
      0xf0, 0x69, 0x5b, 0x68, 0x8d, 0x1b, 0x4b, 0x56, 0x30, 0x67, 0x85, 0x2b,
      0x1c, 0xe9, 0xdb, 0x5d, 0xc8, 0x2a, 0xba, 0x29, 0xab, 0x41, 0x61, 0x78,
      0xf6, 0x16, 0x42, 0x6e, 0x5d, 0x0c, 0xaf, 0x3f, 0x99, 0x03, 0xde, 0x2a,
      0x5b, 0xee, 0xb9, 0x70, 0xaf, 0x72, 0x81, 0xe7, 0xcd, 0xac, 0xaa, 0xa0,
      0x06, 0x62, 0xae, 0x36, 0xfb, 0x03, 0x65, 0xc2, 0x0c, 0x65, 0x3b, 0x67,
      0x0b, 0x3e, 0x7b, 0xe4, 0xb0, 0x68, 0x09, 0x32, 0xf3, 0x25, 0x4d, 0x48,
      0xec, 0x35, 0x05, 0xca, 0x15, 0x47, 0xd1, 0xbe, 0x27, 0xd2, 0x41, 0x4a,
      0x35, 0x39, 0xf4, 0x05, 0xdf, 0x91, 0x05, 0x7f, 0x4f, 0x97, 0xaa, 0x77,
      0x96, 0xd7, 0xcc, 0xb6, 0x9e, 0xd5, 0x53, 0x44, 0x71, 0x31, 0xfb, 0xe7,
      0x96, 0x11, 0x75, 0x6b, 0x7e, 0x56, 0x4b, 0xba, 0x7d, 0x76, 0xce, 0x92,
      0x56, 0x16, 0x84, 0x46, 0xb3, 0x44, 0x98, 0xa2, 0xe9, 0x1d, 0x9a, 0x95,
      0x5a, 0x8a, 0xa9, 0x8a, 0x71, 0xa4, 0x3d, 0x65, 0xee, 0x60, 0xfc, 0xea,
      0x39, 0xd8, 0x11, 0xfe},
     {},
     priv_key_0,
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     3,
     {0x54, 0x65, 0x73, 0x74},
     {0x50, 0x4b, 0x4e, 0x0d, 0x94, 0xd8, 0x00, 0xa9, 0xda, 0x92, 0xbe, 0x8f,
      0xa8, 0x4f, 0xc3, 0x45, 0xf7, 0xab, 0x49, 0x21, 0xec, 0x53, 0xc0, 0x73,
      0xc7, 0x95, 0x92, 0xb3, 0x47, 0xa6, 0x92, 0xcc, 0xe2, 0x45, 0x01, 0x35,
      0xe9, 0x98, 0xe0, 0x7b, 0xb7, 0x5e, 0xd7, 0xee, 0x44, 0xf0, 0x47, 0xf7,
      0x5a, 0x07, 0xe3, 0x7b, 0x9c, 0x91, 0x2d, 0x3d, 0x52, 0x9b, 0x62, 0xbe,
      0xf1, 0x44, 0x95, 0x2d, 0x5b, 0x20, 0x22, 0x46, 0xad, 0x32, 0xc5, 0xd3,
      0x4e, 0xc8, 0x55, 0x9c, 0x41, 0x63, 0xe2, 0x14, 0x5f, 0xa5, 0xfd, 0x4d,
      0x56, 0xde, 0x28, 0xcb, 0xfe, 0x7e, 0x53, 0x7d, 0x57, 0x32, 0x30, 0x59,
      0x45, 0xc9, 0x37, 0x0b, 0xbc, 0x6d, 0xcd, 0x72, 0xb3, 0x29, 0x6f, 0xd5,
      0x4a, 0x26, 0x60, 0x36, 0x57, 0x15, 0xf7, 0xd9, 0x11, 0x09, 0x9c, 0x96,
      0xdf, 0xe6, 0xd1, 0x14, 0xee, 0xc7, 0xb4, 0x42, 0x5c, 0xb6, 0x57, 0x01,
      0xaa, 0x9e, 0x08, 0xd9, 0x9c, 0x7a, 0xc2, 0x01, 0x79, 0x65, 0x6b, 0xb6,
      0x78, 0x55, 0x4d, 0x74, 0xba, 0xca, 0x45, 0x01, 0xb5, 0xd0, 0xb3, 0x66,
      0xc9, 0x72, 0x24, 0xbf, 0x0c, 0x87, 0x34, 0xe0, 0x0f, 0xf2, 0xaf, 0x8b,
      0x91, 0x6a, 0xef, 0x8b, 0x83, 0x14, 0x2d, 0x5e, 0xc1, 0x42, 0x49, 0x3e,
      0x0c, 0xc4, 0xc5, 0x73, 0x26, 0x51, 0x5a, 0x50, 0xa3, 0x1e, 0xc2, 0xc6,
      0x70, 0x35, 0x12, 0x03, 0x46, 0x42, 0xe5, 0x78, 0x96, 0x49, 0x77, 0x3d,
      0x2f, 0x83, 0x12, 0x56, 0x1b, 0xf2, 0xf2, 0xf6, 0x00, 0x0c, 0xeb, 0xdb,
      0xf7, 0xc7, 0xa9, 0x5f, 0xbf, 0xd0, 0xf7, 0x21, 0xc3, 0x1b, 0xa3, 0x92,
      0xac, 0xea, 0x37, 0x56, 0x8a, 0x24, 0xf1, 0x76, 0x76, 0x7f, 0x71, 0xb3,
      0x1f, 0x40, 0x75, 0x73, 0xde, 0xef, 0x95, 0xc3, 0x05, 0xe0, 0xe0, 0x63,
      0xdb, 0x0e, 0x91, 0x68},
     {},
     priv_key_0,
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     4,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x25, 0xa9, 0x18, 0xa0, 0xc7, 0x98, 0x5a, 0x72, 0xf1, 0x8f, 0x6b, 0x62,
      0x16, 0xd0, 0xe2, 0xd1, 0x9a, 0x9b, 0x42, 0xa4, 0xd5, 0xb6, 0x80, 0xe9,
      0x95, 0xc3, 0xc5, 0xc5, 0x84, 0x96, 0x6e, 0x29, 0xc6, 0x17, 0x98, 0x77,
      0xcf, 0xd0, 0x31, 0x7f, 0x9e, 0x4d, 0xcd, 0xc8, 0x7f, 0x76, 0x71, 0x49,
      0x94, 0xe4, 0x40, 0x7c, 0xd8, 0x68, 0x84, 0x23, 0x50, 0xe2, 0x8f, 0x32,
      0x8b, 0x3f, 0x33, 0x74, 0x6a, 0x89, 0x7e, 0xa9, 0x99, 0x55, 0x75, 0xf3,
      0x28, 0xbe, 0x7f, 0x99, 0x12, 0x36, 0x94, 0x82, 0xae, 0x1a, 0x66, 0xff,
      0x5b, 0x7a, 0x1c, 0x8a, 0xc8, 0xfd, 0x4e, 0x57, 0x71, 0xe5, 0x80, 0x77,
      0xb5, 0x4a, 0x55, 0xdb, 0x6c, 0x68, 0x49, 0xff, 0x28, 0x8d, 0x50, 0xde,
      0x0e, 0xe1, 0xe4, 0x5b, 0xfd, 0xf8, 0x1f, 0xfa, 0xed, 0x16, 0x97, 0x1f,
      0x19, 0xab, 0xae, 0x66, 0x03, 0x38, 0xa3, 0xa9, 0x24, 0x0a, 0x0b, 0x73,
      0x29, 0x84, 0xfa, 0xdc, 0xd2, 0x8a, 0x85, 0xc6, 0x80, 0xf0, 0xda, 0xc8,
      0xb7, 0x33, 0x06, 0x48, 0x1a, 0x09, 0x6f, 0x70, 0x07, 0x06, 0xe9, 0x1f,
      0x7c, 0x10, 0x0c, 0xe6, 0x4e, 0x1c, 0x6b, 0xba, 0xbd, 0x41, 0x98, 0x07,
      0xdc, 0x16, 0x7f, 0x1f, 0x92, 0x4e, 0xdc, 0x6f, 0x44, 0xa6, 0x9b, 0x75,
      0xa7, 0xc7, 0x29, 0x89, 0xb2, 0x5c, 0xe3, 0x54, 0x80, 0x43, 0x3b, 0xc4,
      0x56, 0xc6, 0xaf, 0xa9, 0x3a, 0x0e, 0x9b, 0x41, 0x56, 0xd7, 0x58, 0x63,
      0xf9, 0x44, 0x0a, 0xe4, 0x42, 0xee, 0xfd, 0x21, 0x3b, 0x8a, 0x3f, 0x53,
      0xa0, 0x65, 0xda, 0xa8, 0xcd, 0x02, 0x06, 0x88, 0x6d, 0x15, 0x44, 0xc3,
      0xbf, 0xec, 0xaf, 0x62, 0x65, 0x9c, 0xfa, 0x59, 0x1d, 0xa5, 0xe9, 0x20,
      0xd7, 0xd4, 0x37, 0x0a, 0x9a, 0xab, 0xf7, 0xf9, 0x98, 0x3f, 0xad, 0xe1,
      0x01, 0xda, 0x2d, 0xba},
     {},
     priv_key_0,
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     5,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     {0xa2, 0x55, 0x0a, 0x98, 0x50, 0x90, 0x3f, 0x31, 0x42, 0xbc, 0x1b, 0x1b,
      0x54, 0xe4, 0x5d, 0x77, 0x54, 0xe7, 0x5f, 0xf0, 0xd3, 0x9a, 0x8a, 0xe8,
      0x13, 0xb5, 0x1e, 0xb8, 0x16, 0x5b, 0xe0, 0x8a, 0x4c, 0x03, 0x66, 0xb9,
      0x3c, 0x80, 0x3e, 0xf1, 0x61, 0x65, 0x0f, 0x8c, 0xb9, 0x66, 0xf7, 0xdd,
      0x46, 0x48, 0xf4, 0x03, 0x63, 0xdd, 0x0c, 0xc3, 0x75, 0x95, 0xe4, 0x37,
      0x56, 0x07, 0x89, 0x55, 0xef, 0x02, 0xe4, 0x15, 0xb3, 0xe0, 0xef, 0xd5,
      0xf9, 0x74, 0x4d, 0x56, 0x4e, 0xae, 0x76, 0x3e, 0x30, 0x7e, 0x89, 0x30,
      0x02, 0xdd, 0x1a, 0x9d, 0x0b, 0xa2, 0x99, 0x7f, 0xe6, 0x65, 0x8f, 0x36,
      0x89, 0xfe, 0xf4, 0xf4, 0xf2, 0x1e, 0x7a, 0x97, 0x2c, 0x0d, 0xc6, 0x42,
      0x99, 0x3f, 0xf6, 0x61, 0x2c, 0x6e, 0x6b, 0x43, 0xf9, 0xce, 0x53, 0x67,
      0x49, 0x19, 0xab, 0xbc, 0x13, 0xe4, 0x27, 0x72, 0xbe, 0xb8, 0xc3, 0xf3,
      0xf6, 0x55, 0xdf, 0x9d, 0xc9, 0x83, 0x9e, 0x07, 0x5e, 0x01, 0xbe, 0xb9,
      0xb9, 0x3d, 0x8e, 0x01, 0x6f, 0x57, 0xaf, 0xc9, 0xa0, 0x20, 0x7d, 0x91,
      0x89, 0xb4, 0xbc, 0xb1, 0x4b, 0xa6, 0x45, 0x9f, 0xf5, 0xfd, 0xd5, 0xf2,
      0xfe, 0xd5, 0x26, 0x0a, 0xc9, 0xa7, 0xa0, 0x92, 0xfe, 0xca, 0x20, 0xaf,
      0x0f, 0x23, 0xa0, 0x0d, 0x8b, 0x99, 0x0c, 0x07, 0x4c, 0xa2, 0x3d, 0x96,
      0x4e, 0x19, 0xe4, 0x9c, 0x17, 0xc9, 0x70, 0xbc, 0x97, 0x2b, 0x70, 0xfd,
      0xa2, 0xb6, 0xc6, 0xe9, 0x9e, 0x4e, 0x7f, 0xf1, 0x19, 0x02, 0xea, 0x71,
      0x26, 0x25, 0x7f, 0xd1, 0x96, 0x4e, 0x7d, 0xa0, 0x7f, 0xbf, 0x41, 0x3c,
      0x8b, 0xec, 0xb4, 0x87, 0x29, 0xfb, 0xd8, 0x61, 0xdd, 0xcc, 0x3f, 0xa6,
      0xc3, 0xdf, 0x23, 0x55, 0x75, 0x9e, 0xf1, 0x33, 0x8d, 0x02, 0x55, 0x1b,
      0x7f, 0xc8, 0x0a, 0x88},
     {},
     priv_key_0,
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     6,
     {0x61},
     {0x6f, 0x35, 0xb5, 0x6e, 0xbd, 0x7e, 0x12, 0xd5, 0x8c, 0xf2, 0x23, 0x9b,
      0x3c, 0x92, 0x6d, 0x21, 0xd5, 0x42, 0x22, 0xda, 0x0d, 0x19, 0x43, 0xbc,
      0xd0, 0xc0, 0xe4, 0x46, 0xbc, 0x92, 0x13, 0x52, 0x6c, 0x63, 0xce, 0x07,
      0x36, 0xb1, 0x13, 0x40, 0x75, 0x44, 0x60, 0x03, 0x6e, 0xea, 0xc8, 0x85,
      0xda, 0xca, 0xc6, 0x17, 0x49, 0x9a, 0x58, 0xc5, 0x6a, 0x6d, 0xf5, 0xde,
      0x1e, 0x91, 0xdb, 0x4e, 0x1b, 0xef, 0xba, 0x02, 0x37, 0xf6, 0x96, 0xd1,
      0xb6, 0xa8, 0x44, 0x71, 0x63, 0xb8, 0x39, 0xdd, 0xf0, 0x82, 0xa1, 0xc5,
      0xf8, 0xc1, 0x31, 0x5f, 0x7f, 0xba, 0xb4, 0x5b, 0x2b, 0xd8, 0x01, 0x1a,
      0xcc, 0xd5, 0xb2, 0xb1, 0xe3, 0xd4, 0xf3, 0x53, 0x15, 0xe9, 0x98, 0xee,
      0xf8, 0x2f, 0x36, 0x8a, 0x72, 0x72, 0x88, 0x17, 0xf7, 0x36, 0x96, 0x48,
      0xb9, 0xb1, 0x95, 0x97, 0x81, 0x44, 0x97, 0x07, 0xa5, 0xa6, 0x68, 0xa6,
      0xf8, 0xee, 0xfe, 0x56, 0x24, 0x13, 0x5f, 0xf8, 0xed, 0xcd, 0xf9, 0x59,
      0x4e, 0xb4, 0xdb, 0x32, 0xf2, 0x7b, 0x2a, 0x6f, 0x5f, 0x7c, 0x64, 0x06,
      0xc2, 0xf2, 0xc7, 0xb8, 0x18, 0xf8, 0x59, 0xd9, 0xe3, 0x79, 0xa7, 0x6c,
      0x17, 0xb4, 0xd1, 0x53, 0x5d, 0xb7, 0x40, 0x4e, 0x77, 0xd6, 0x11, 0xf6,
      0xcf, 0x5b, 0x4d, 0x02, 0x05, 0xf8, 0x85, 0x88, 0x31, 0x86, 0xd6, 0x03,
      0xc7, 0xa9, 0x92, 0x09, 0x34, 0xfb, 0x58, 0x86, 0x40, 0x6a, 0x38, 0x01,
      0x3f, 0x7a, 0x18, 0x64, 0xd5, 0x07, 0x4f, 0x89, 0xdd, 0xc1, 0x64, 0xc9,
      0xe1, 0x3f, 0x5a, 0xa5, 0xe4, 0xeb, 0x13, 0xdf, 0xc3, 0xa5, 0x3b, 0x15,
      0x3c, 0x56, 0xd9, 0xf6, 0x40, 0x3b, 0xf2, 0xac, 0x5d, 0xde, 0x9c, 0x42,
      0x22, 0x72, 0x01, 0xfe, 0x31, 0x49, 0x84, 0x75, 0x2b, 0x5b, 0x41, 0xef,
      0x00, 0x64, 0xac, 0xb0},
     {},
     priv_key_0,
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     7,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     {0x35, 0x30, 0x60, 0x5f, 0x43, 0xb5, 0x53, 0x9c, 0x80, 0x39, 0x8f, 0x85,
      0x6e, 0xea, 0x8d, 0x88, 0x98, 0x4a, 0xf4, 0xa6, 0xa0, 0x8d, 0xb3, 0xb9,
      0xd4, 0x09, 0x3c, 0xc8, 0x0d, 0x1a, 0x31, 0x3c, 0x0e, 0xbe, 0x72, 0x7e,
      0xb2, 0xc4, 0x5c, 0xec, 0x20, 0x25, 0xee, 0xe6, 0x0f, 0x38, 0x58, 0x22,
      0xc0, 0x9f, 0x82, 0xe3, 0xbc, 0xed, 0xf6, 0x6b, 0x79, 0xc2, 0xb3, 0x4a,
      0x4f, 0x41, 0xaa, 0x88, 0x85, 0xec, 0xa5, 0xb9, 0x89, 0x17, 0x98, 0xd4,
      0x79, 0x14, 0xf9, 0x47, 0xc7, 0x68, 0x81, 0xdb, 0xfc, 0x3f, 0x21, 0xec,
      0x27, 0xa1, 0x1d, 0xc9, 0x26, 0xc6, 0x47, 0xb6, 0xb2, 0xa7, 0xf3, 0x29,
      0x2e, 0xc4, 0xaa, 0x32, 0xe9, 0x69, 0xba, 0xb4, 0x9a, 0xfe, 0x20, 0x3f,
      0xfd, 0x79, 0xb0, 0xc1, 0xab, 0x57, 0x77, 0xa0, 0x41, 0xfb, 0xe4, 0xe9,
      0xe1, 0xa6, 0x79, 0xfe, 0x2d, 0x82, 0xe9, 0xc2, 0x67, 0xee, 0x7f, 0xbe,
      0x54, 0xe9, 0xe0, 0xde, 0xf6, 0x8d, 0x8b, 0xba, 0xcb, 0x1e, 0x53, 0xda,
      0x99, 0xae, 0xc8, 0xba, 0x92, 0x55, 0xd2, 0xff, 0x66, 0x76, 0xdb, 0xcc,
      0x58, 0x49, 0x8a, 0x38, 0x6d, 0xd8, 0xa6, 0xb3, 0xcf, 0x02, 0x22, 0xa9,
      0xe1, 0x4f, 0xd0, 0x33, 0x13, 0x30, 0x3b, 0xec, 0x9d, 0x04, 0x39, 0xff,
      0x0e, 0x8a, 0x5a, 0x09, 0xce, 0x29, 0x26, 0xeb, 0xe8, 0x6c, 0xaf, 0xd0,
      0x0c, 0xd8, 0xca, 0x76, 0x1b, 0x88, 0xdf, 0x9c, 0xf8, 0x4f, 0x7b, 0x8e,
      0x07, 0xcc, 0x5f, 0x65, 0x51, 0x99, 0xea, 0x81, 0xea, 0x64, 0x07, 0xec,
      0x26, 0x4b, 0x59, 0x71, 0x73, 0x89, 0x67, 0xa2, 0xe9, 0x77, 0x13, 0x2d,
      0xc5, 0x89, 0xc7, 0x2f, 0x8b, 0xb6, 0x39, 0xa9, 0x42, 0x9f, 0xeb, 0x51,
      0x2d, 0x8d, 0x32, 0xc4, 0x41, 0xf7, 0xe1, 0xce, 0x6c, 0x6b, 0xef, 0xa0,
      0x81, 0x40, 0xa0, 0x90},
     {},
     priv_key_0,
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     8,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x4d, 0x0c, 0xb9, 0xe2, 0x3e, 0xa2, 0xf2, 0x5c, 0xd9, 0x3f, 0x6a, 0x4a,
      0x5b, 0x91, 0x89, 0x15, 0x61, 0x78, 0x57, 0x22, 0x14, 0xc2, 0xbb, 0xc7,
      0x73, 0x15, 0x8e, 0xd8, 0x2b, 0x83, 0xcd, 0xfe, 0x7a, 0xc1, 0xe9, 0x6d,
      0x66, 0x2a, 0xfd, 0x46, 0xa9, 0x22, 0x5b, 0x9e, 0x8d, 0x1d, 0xed, 0x27,
      0x4e, 0x00, 0x04, 0x8c, 0x05, 0x8d, 0x4c, 0xb6, 0x6c, 0xcc, 0xf4, 0xeb,
      0x6c, 0x4e, 0xba, 0xf3, 0x0b, 0x97, 0xe3, 0xff, 0x17, 0xa2, 0x12, 0x23,
      0xcd, 0xed, 0x87, 0x08, 0x52, 0x4b, 0xf7, 0x5e, 0x3d, 0xec, 0x07, 0x58,
      0x33, 0xdc, 0x95, 0x3d, 0xfd, 0x9a, 0x13, 0x41, 0x07, 0x2f, 0x14, 0x85,
      0xc6, 0x00, 0x18, 0xf9, 0x2b, 0xd4, 0x1c, 0xed, 0xd0, 0x51, 0x00, 0x85,
      0xd8, 0x18, 0xa5, 0xcb, 0x4d, 0xf3, 0x2c, 0x44, 0x72, 0x94, 0xf4, 0x24,
      0x53, 0x85, 0xe1, 0xe5, 0xc4, 0x62, 0x7c, 0x41, 0x45, 0x0c, 0x1d, 0xfd,
      0x22, 0xf3, 0x4f, 0x96, 0x51, 0x4a, 0xed, 0x15, 0x65, 0x97, 0x67, 0x35,
      0xe3, 0x21, 0xc2, 0x66, 0x30, 0x0d, 0xe6, 0xb9, 0x3d, 0xd9, 0x3e, 0x4d,
      0xb4, 0xe5, 0x21, 0xb1, 0xa2, 0x69, 0x94, 0x7c, 0xb7, 0x9b, 0xcc, 0xd4,
      0x72, 0xcd, 0x40, 0xe3, 0xfd, 0x43, 0x07, 0x26, 0x72, 0x3c, 0xb9, 0x7b,
      0xca, 0x50, 0xe6, 0x10, 0xbd, 0x81, 0xda, 0xed, 0x31, 0xfc, 0x16, 0x4c,
      0x18, 0xef, 0x37, 0x8f, 0x68, 0xe4, 0x05, 0xee, 0x6d, 0x97, 0x8f, 0x97,
      0xcc, 0x04, 0x2d, 0xd2, 0x66, 0xc9, 0x0b, 0x90, 0x9b, 0xa5, 0x21, 0x28,
      0x82, 0x4f, 0xea, 0x7f, 0x44, 0x96, 0xad, 0x56, 0xe0, 0x3f, 0xa4, 0xae,
      0xb5, 0x28, 0xd2, 0xfd, 0x3d, 0x9b, 0xfa, 0xe8, 0x29, 0x5e, 0x1a, 0x53,
      0x06, 0xb3, 0x89, 0x65, 0x4b, 0x1d, 0x70, 0x58, 0x89, 0x0b, 0x5d, 0xbd,
      0x67, 0x70, 0xff, 0x5b},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     priv_key_0,
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     9,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x87, 0x3c, 0x4e, 0xcb, 0x48, 0x58, 0xc6, 0x02, 0x18, 0xb4, 0xff, 0x5f,
      0xe7, 0x5e, 0xc2, 0x16, 0x50, 0x23, 0x67, 0xe0, 0xa8, 0x44, 0x6f, 0xef,
      0x23, 0x02, 0xda, 0x89, 0x28, 0x16, 0xf1, 0x27, 0xa8, 0xbe, 0xdf, 0x7e,
      0x2f, 0xff, 0x34, 0x9b, 0xe4, 0x93, 0x85, 0x7c, 0x4e, 0x36, 0x34, 0x93,
      0xb2, 0x8f, 0x90, 0x36, 0x5e, 0xae, 0x44, 0x32, 0x3a, 0x93, 0x3e, 0xae,
      0x25, 0x70, 0x1d, 0x84, 0x02, 0x4c, 0x84, 0xe0, 0x9b, 0x91, 0x63, 0xde,
      0x0d, 0xc7, 0xba, 0x2d, 0x44, 0xf9, 0x7c, 0x29, 0xaf, 0x5b, 0x94, 0x22,
      0xc4, 0x17, 0xbb, 0x24, 0x1a, 0x2f, 0xd3, 0x26, 0xef, 0xd9, 0xae, 0xd2,
      0xdc, 0xd7, 0xce, 0xa5, 0x5b, 0xb1, 0x6b, 0x95, 0x71, 0x64, 0x7e, 0xae,
      0xce, 0x0a, 0x0c, 0xa7, 0x1f, 0x7d, 0xa7, 0xde, 0xcf, 0xbc, 0x58, 0x8c,
      0xaf, 0xa8, 0xbe, 0xac, 0xf0, 0xb2, 0x86, 0xe1, 0x43, 0xff, 0x77, 0xf0,
      0x54, 0x07, 0x38, 0x8b, 0x72, 0xc8, 0x9c, 0x6a, 0x4b, 0xe3, 0x5d, 0x07,
      0x40, 0x83, 0xe2, 0xa1, 0x28, 0xfd, 0xa5, 0x3b, 0xa7, 0xd3, 0x36, 0x3c,
      0x0d, 0x26, 0x14, 0x30, 0x66, 0x77, 0x70, 0xfd, 0x7b, 0x42, 0x03, 0x2a,
      0x4d, 0x97, 0x64, 0xfa, 0x86, 0xdd, 0x48, 0x34, 0xeb, 0xa3, 0x86, 0x4a,
      0xcf, 0x3e, 0x0c, 0x23, 0x0f, 0xd0, 0x35, 0x81, 0x29, 0x25, 0x62, 0x15,
      0x1f, 0xaa, 0x1e, 0xd3, 0xf8, 0x43, 0x3b, 0xc6, 0x34, 0x72, 0xc4, 0x25,
      0xc3, 0x82, 0xd7, 0x42, 0x5b, 0x11, 0xc9, 0x79, 0x69, 0xb1, 0xfd, 0x0f,
      0xa0, 0xb0, 0x14, 0xd4, 0x7d, 0x87, 0xaf, 0x91, 0x9d, 0xe6, 0xdf, 0x72,
      0xba, 0x52, 0xbe, 0x88, 0x8e, 0x44, 0xde, 0x4f, 0xa6, 0x3c, 0x21, 0x5e,
      0xa8, 0x0f, 0xc6, 0x10, 0x72, 0xa3, 0x20, 0xa2, 0x4e, 0x99, 0xc6, 0xa2,
      0x47, 0x88, 0x0c, 0x9a},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
      0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13},
     priv_key_0,
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     10,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x91, 0xde, 0x22, 0xe7, 0x67, 0x14, 0xef, 0xf6, 0x12, 0xa4, 0x13, 0x18,
      0x30, 0x3d, 0xc5, 0xaa, 0xf1, 0x54, 0xdc, 0x5e, 0x4b, 0x79, 0xdf, 0x84,
      0x95, 0xb5, 0xac, 0xba, 0x18, 0xa2, 0x7b, 0xe6, 0xdd, 0x45, 0x4f, 0x2c,
      0x39, 0x49, 0x4a, 0xa1, 0x8d, 0x19, 0x11, 0xaa, 0xbf, 0x38, 0xbb, 0xad,
      0x04, 0x60, 0x92, 0x24, 0x04, 0xc6, 0xe2, 0xc0, 0x8a, 0xc3, 0xab, 0xfd,
      0xcd, 0xb9, 0x63, 0x62, 0x3f, 0x1c, 0x1c, 0x07, 0xeb, 0x20, 0x96, 0xdf,
      0xf7, 0x06, 0x4d, 0x3c, 0x55, 0xc6, 0x22, 0x17, 0x73, 0xe4, 0xb2, 0xa8,
      0x0a, 0xda, 0xeb, 0x21, 0x05, 0x32, 0xec, 0x76, 0xa3, 0xc9, 0x28, 0x32,
      0xb0, 0xaa, 0xf7, 0xda, 0x03, 0xcf, 0xb6, 0x03, 0x03, 0xe0, 0x11, 0x6c,
      0xb6, 0xcd, 0xea, 0xd2, 0xb7, 0x37, 0x1c, 0xbf, 0xae, 0xbb, 0xf3, 0xe5,
      0x11, 0x50, 0x3b, 0x9b, 0x8b, 0xcd, 0x54, 0xc1, 0x3c, 0x03, 0x5a, 0x44,
      0x36, 0x8f, 0xba, 0x19, 0xdf, 0xb8, 0x73, 0x5c, 0x61, 0x17, 0xa3, 0xed,
      0xcb, 0xe9, 0x93, 0x9a, 0xfa, 0xbd, 0x72, 0x04, 0xb6, 0x54, 0x2c, 0x77,
      0xd3, 0x1a, 0x6a, 0x24, 0x4b, 0x10, 0x48, 0x12, 0x11, 0xec, 0x99, 0xe4,
      0x52, 0x31, 0x20, 0x37, 0x20, 0x04, 0x3f, 0xe8, 0x9a, 0x57, 0xc7, 0xa6,
      0x12, 0xb3, 0x58, 0x8b, 0x12, 0x16, 0x6c, 0x55, 0xed, 0xec, 0x13, 0xb8,
      0x26, 0x5a, 0x2c, 0x09, 0x1d, 0xd8, 0x59, 0xd4, 0xf3, 0x4e, 0xb6, 0x6e,
      0xad, 0x8b, 0x58, 0x3f, 0xd1, 0xf0, 0xf0, 0xec, 0x73, 0x9b, 0x92, 0xe7,
      0x61, 0x8c, 0x1a, 0xbe, 0x1e, 0x3e, 0x92, 0x19, 0xfc, 0x43, 0xf6, 0x28,
      0xfe, 0x89, 0xcc, 0xdf, 0x2c, 0xab, 0xc0, 0x7f, 0xfc, 0xc5, 0xc4, 0x85,
      0xc4, 0xca, 0xdb, 0xbb, 0xeb, 0x02, 0xef, 0xd8, 0x39, 0x4f, 0x4d, 0xb0,
      0xb7, 0x2d, 0x81, 0xd8},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
      0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
      0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f},
     priv_key_0,
     true},

    // Comment: Longest valid message size
    // tcID: 11
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     11,
     {0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78},
     {0x86, 0x54, 0x64, 0x30, 0x90, 0xce, 0x42, 0x61, 0x18, 0xdc, 0xce, 0x2b,
      0xb0, 0xfc, 0xa3, 0xb2, 0xa4, 0xed, 0x45, 0x58, 0x9d, 0x73, 0xae, 0x2f,
      0x56, 0x83, 0x33, 0x4f, 0x17, 0xca, 0x5b, 0x9f, 0x41, 0xeb, 0x97, 0xff,
      0x56, 0x6c, 0xbb, 0xc0, 0x17, 0x1d, 0x89, 0x62, 0xfc, 0xca, 0x46, 0x5f,
      0x66, 0xf4, 0xcf, 0x14, 0xd0, 0x11, 0x4d, 0x77, 0x68, 0xbb, 0xac, 0x1d,
      0xfb, 0x72, 0x6d, 0x91, 0x33, 0x16, 0x70, 0xe0, 0xe8, 0x8c, 0xe7, 0x28,
      0x6e, 0x1f, 0x0e, 0xe7, 0xac, 0xd5, 0xcd, 0x75, 0xe0, 0xd3, 0x25, 0xad,
      0xc9, 0xf4, 0x7f, 0xf0, 0x28, 0x20, 0x54, 0x47, 0x70, 0xec, 0xf4, 0x6f,
      0x38, 0x1f, 0xf3, 0x30, 0xa5, 0xc7, 0x59, 0x78, 0xe8, 0xd2, 0x48, 0xcc,
      0x12, 0xf0, 0x75, 0x2c, 0xc7, 0xc4, 0x52, 0x26, 0x5a, 0xe9, 0x19, 0xf5,
      0xa4, 0xdd, 0x7c, 0x20, 0x02, 0x3f, 0xbf, 0x51, 0xd0, 0xb4, 0x13, 0xaf,
      0xe0, 0x9f, 0x74, 0x61, 0x14, 0xd1, 0x6d, 0x1b, 0xe4, 0x99, 0xc9, 0x8d,
      0x27, 0x0e, 0x92, 0x13, 0xa3, 0x7a, 0x2a, 0x74, 0x5a, 0x3b, 0xb2, 0x16,
      0xbd, 0x30, 0xa0, 0x7d, 0x11, 0x05, 0x58, 0x09, 0x0f, 0x4f, 0xe7, 0x3d,
      0xeb, 0xea, 0x00, 0x9e, 0x18, 0xeb, 0x37, 0x70, 0xee, 0xdd, 0xd7, 0x15,
      0x0b, 0x4c, 0x72, 0x31, 0x53, 0x9f, 0x72, 0x32, 0xd8, 0x37, 0x83, 0x64,
      0x90, 0xc9, 0x54, 0x7e, 0x27, 0xda, 0xc0, 0x0e, 0xfb, 0x5a, 0x8c, 0xcd,
      0xf9, 0xa7, 0xc3, 0xc1, 0xd2, 0x9c, 0x03, 0x51, 0x70, 0xa5, 0x17, 0xdb,
      0x89, 0x9e, 0xe6, 0x19, 0x25, 0xcc, 0x7a, 0x2c, 0xd2, 0x78, 0xcf, 0x57,
      0x6e, 0xbe, 0x82, 0x81, 0xbd, 0x3a, 0x4f, 0x26, 0x65, 0xf1, 0x5d, 0xd0,
      0xb2, 0xe6, 0x1b, 0xcd, 0x65, 0x17, 0x2c, 0x2f, 0xff, 0x50, 0xa8, 0x6a,
      0x2a, 0xdb, 0xf2, 0xf1},
     {},
     priv_key_0,
     true},

    // Comment: first byte of l_hash modified
    // tcID: 12
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     12,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x78, 0x66, 0xab, 0x0f, 0x81, 0x43, 0x7d, 0xe9, 0x34, 0x42, 0x32, 0x5f,
      0x02, 0xf8, 0x6a, 0x30, 0x5c, 0x4a, 0x4a, 0x08, 0x71, 0x20, 0x7f, 0xf3,
      0x20, 0x37, 0x46, 0xc2, 0x6a, 0x43, 0xff, 0xf5, 0x97, 0x9e, 0x68, 0xc7,
      0x42, 0x64, 0xc3, 0x4d, 0xad, 0x13, 0x95, 0x5a, 0x32, 0x78, 0x5e, 0xc1,
      0x52, 0x3f, 0xcc, 0xb2, 0x64, 0x95, 0x7e, 0xd6, 0xf6, 0xb8, 0x22, 0xb5,
      0xc0, 0x52, 0xb9, 0x16, 0x1d, 0x6b, 0x75, 0xad, 0xde, 0x45, 0x1c, 0x6f,
      0x8d, 0x63, 0x7a, 0x75, 0xdf, 0xfc, 0x9b, 0x9a, 0x91, 0x03, 0x93, 0x4e,
      0x77, 0x7c, 0xef, 0x41, 0xb7, 0x96, 0x6b, 0xf7, 0x30, 0xa6, 0x48, 0xe5,
      0xb9, 0x6a, 0xa5, 0x87, 0x93, 0x6d, 0x46, 0x01, 0x24, 0xdc, 0xec, 0x51,
      0x5b, 0x55, 0x47, 0x3a, 0x00, 0x98, 0x44, 0xf1, 0x9c, 0xb2, 0x79, 0x4b,
      0xd7, 0x39, 0x55, 0x7d, 0x25, 0x41, 0x7e, 0x2c, 0x03, 0x67, 0x62, 0xa9,
      0x21, 0x48, 0x1d, 0x72, 0x8b, 0x4d, 0x32, 0xa8, 0x01, 0x5b, 0x17, 0x53,
      0x9b, 0x7c, 0xc2, 0xa1, 0x6a, 0x2b, 0x33, 0xe4, 0x3b, 0x85, 0x56, 0x1a,
      0x21, 0x19, 0xfb, 0x6c, 0x9d, 0x8e, 0xd4, 0x2d, 0x6b, 0xec, 0x32, 0x42,
      0x81, 0xbe, 0x79, 0xe2, 0xf7, 0x94, 0x26, 0xc6, 0x53, 0xf8, 0x44, 0x5a,
      0x20, 0xcc, 0xe8, 0x7a, 0x2c, 0x26, 0x3e, 0x79, 0x33, 0xb8, 0xef, 0x3f,
      0xa0, 0xb9, 0xf9, 0xf3, 0x8f, 0xd1, 0x15, 0xfd, 0xe4, 0x59, 0xe5, 0xd3,
      0x2e, 0xee, 0x24, 0x12, 0xc0, 0xaf, 0x06, 0xd2, 0xf6, 0x45, 0x4e, 0x04,
      0xba, 0x06, 0x0e, 0xa8, 0x7c, 0x5a, 0xa0, 0xd4, 0xb3, 0x65, 0xf2, 0x4b,
      0x4f, 0x05, 0xbb, 0x27, 0xc4, 0xaa, 0x42, 0x06, 0x1a, 0x45, 0xcd, 0xce,
      0xf1, 0xa3, 0x91, 0x18, 0x01, 0x8b, 0x87, 0x5d, 0xfb, 0x9f, 0x90, 0x4f,
      0xda, 0x4d, 0x80, 0xfb},
     {},
     priv_key_0,
     false},

    // Comment: last byte of l_hash modified
    // tcID: 13
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     13,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x55, 0xfe, 0x2f, 0x0f, 0xdb, 0xe1, 0x6b, 0xc2, 0x84, 0x54, 0x5c, 0xf2,
      0xbe, 0x83, 0xd2, 0xa9, 0x2a, 0x52, 0x6f, 0x52, 0xe3, 0x3e, 0x7b, 0x11,
      0x6b, 0x26, 0x58, 0x59, 0xf1, 0x44, 0x33, 0xfd, 0xf3, 0xae, 0x92, 0xe1,
      0x0b, 0x3a, 0x90, 0x6a, 0xc9, 0x5a, 0x45, 0x41, 0xc4, 0x2e, 0xb8, 0x0b,
      0x3a, 0xa9, 0x63, 0xe5, 0xd9, 0xdc, 0x4d, 0x34, 0x14, 0xbb, 0x5f, 0x37,
      0x8c, 0xfb, 0x3d, 0x50, 0xaf, 0x10, 0xe9, 0xe8, 0x4f, 0xe0, 0xe3, 0x1c,
      0x98, 0xe0, 0x91, 0x64, 0x3e, 0xe9, 0x9f, 0xda, 0x65, 0xa2, 0xa8, 0x80,
      0x2f, 0x9f, 0xba, 0x68, 0x49, 0x2b, 0xea, 0xb9, 0xe6, 0x06, 0x50, 0x1b,
      0x8e, 0x82, 0xa3, 0xd8, 0x30, 0x17, 0x51, 0x37, 0x61, 0x7a, 0xe0, 0x35,
      0x2b, 0xc7, 0x90, 0xb4, 0xec, 0xfb, 0x76, 0xfc, 0x12, 0x6c, 0x34, 0xfc,
      0x60, 0x0f, 0x5f, 0x09, 0xb5, 0x8f, 0x39, 0x15, 0x15, 0x5d, 0x3a, 0xe4,
      0x82, 0x0d, 0x91, 0x90, 0x4c, 0xb9, 0x2b, 0x61, 0xfe, 0x91, 0x93, 0xd1,
      0x50, 0xd4, 0xf0, 0xb6, 0xbb, 0xba, 0xba, 0x26, 0x92, 0xea, 0xff, 0x15,
      0xd2, 0xa0, 0xf0, 0x1d, 0x0b, 0xfb, 0x81, 0x22, 0x84, 0x62, 0x95, 0x4f,
      0x40, 0x4a, 0xe0, 0x63, 0x50, 0xa2, 0x44, 0x69, 0x38, 0x10, 0x47, 0xa6,
      0x2e, 0x28, 0x1d, 0x2b, 0xfa, 0x79, 0x8a, 0x3f, 0xe1, 0x9a, 0xb0, 0xc8,
      0x08, 0xde, 0x18, 0xeb, 0xae, 0xa1, 0x19, 0x41, 0xe6, 0x32, 0x5c, 0x04,
      0x92, 0x7e, 0x0a, 0xf3, 0x49, 0x90, 0x43, 0xa4, 0x27, 0x05, 0xcf, 0xec,
      0xe0, 0x4a, 0x60, 0xb6, 0xed, 0x8c, 0x28, 0x08, 0x69, 0x78, 0x7a, 0x4f,
      0x3d, 0x48, 0x42, 0x18, 0xf0, 0x9f, 0x0b, 0x26, 0x6e, 0xfc, 0x3a, 0x5b,
      0x44, 0x20, 0x98, 0xc8, 0x2c, 0xdf, 0x80, 0x98, 0x20, 0xcf, 0x3b, 0x8e,
      0x7f, 0x6e, 0xbb, 0x8c},
     {},
     priv_key_0,
     false},

    // Comment: l_hash changed to all 0
    // tcID: 14
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     14,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x93, 0x0e, 0xee, 0xdf, 0xc0, 0xe9, 0x47, 0x91, 0xa2, 0x11, 0x8b, 0x22,
      0x8c, 0x4e, 0x15, 0x22, 0xab, 0x52, 0xf5, 0xfb, 0xe5, 0x33, 0x73, 0xd9,
      0xc1, 0x1b, 0x4d, 0x1b, 0x25, 0x95, 0xb1, 0x21, 0x78, 0x0f, 0x43, 0x12,
      0xa4, 0xf8, 0x34, 0x61, 0x4d, 0xf0, 0xc3, 0x14, 0x25, 0x48, 0x3d, 0xd8,
      0x45, 0x27, 0x9b, 0x08, 0xfc, 0x0f, 0x10, 0x81, 0xda, 0xfc, 0xf5, 0x1f,
      0x32, 0x95, 0x85, 0x05, 0x96, 0x0e, 0x2e, 0xb9, 0xb9, 0x67, 0x2c, 0x9a,
      0x72, 0xa1, 0x2f, 0xb4, 0x5a, 0x25, 0xdf, 0x67, 0x80, 0x09, 0x54, 0x2a,
      0x17, 0x1e, 0xf8, 0xd7, 0xf0, 0x7b, 0x11, 0xfb, 0xe5, 0x2d, 0xb4, 0x79,
      0x57, 0xce, 0x38, 0xd9, 0x24, 0x28, 0x52, 0xa2, 0x28, 0xa4, 0xea, 0x86,
      0x4c, 0x36, 0xd1, 0x4d, 0x58, 0xbf, 0x41, 0xd2, 0xa1, 0x15, 0x1b, 0x8c,
      0x18, 0xca, 0xd7, 0x77, 0xc9, 0xa6, 0xf8, 0x54, 0x2b, 0x2f, 0x3c, 0x9c,
      0x84, 0x99, 0x0a, 0x46, 0x1d, 0xf6, 0x13, 0xf3, 0x6a, 0x04, 0x61, 0x65,
      0x8b, 0x98, 0xba, 0x19, 0x3e, 0x6e, 0x6b, 0x14, 0x76, 0x50, 0x21, 0xd0,
      0x27, 0x25, 0x36, 0xc0, 0x44, 0xd8, 0x82, 0x0b, 0xc3, 0xa5, 0xda, 0x24,
      0x04, 0xf1, 0x1a, 0x35, 0xc6, 0x32, 0xb8, 0xc0, 0xf9, 0xee, 0x8f, 0x5f,
      0x3c, 0xf6, 0xc7, 0x79, 0x34, 0xa7, 0xb0, 0x37, 0x50, 0x03, 0x1d, 0x6d,
      0x7c, 0xd9, 0x96, 0x23, 0xc4, 0x84, 0xc5, 0xc2, 0x44, 0xdd, 0xc0, 0x75,
      0x59, 0xea, 0x75, 0x68, 0x86, 0xd2, 0x35, 0x84, 0x4d, 0x9c, 0x6b, 0xa4,
      0xaa, 0x24, 0xfa, 0xb1, 0x4e, 0x9c, 0x4e, 0xd0, 0x1b, 0xac, 0x85, 0xd3,
      0x32, 0x86, 0x9a, 0x8b, 0xa8, 0xc0, 0x5c, 0xa7, 0xa0, 0x74, 0x40, 0x9e,
      0x82, 0x31, 0xae, 0x38, 0xc0, 0xe1, 0xbb, 0x98, 0x41, 0x2f, 0xdf, 0x12,
      0x4f, 0x3f, 0xfa, 0x9f},
     {},
     priv_key_0,
     false},

    // Comment: l_hash changed to all 1
    // tcID: 15
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     15,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xbb, 0xf2, 0x7b, 0xdc, 0x63, 0x11, 0x95, 0x2d, 0xcf, 0x7b, 0xb3, 0x14,
      0x59, 0xad, 0x6f, 0x97, 0xe0, 0x9d, 0x59, 0x48, 0xc7, 0xd2, 0x12, 0x26,
      0xc6, 0x56, 0x12, 0x1a, 0xaa, 0xf3, 0xac, 0x28, 0x11, 0x8e, 0xfc, 0x49,
      0xe3, 0x79, 0xea, 0xba, 0xd3, 0xab, 0x4b, 0x57, 0x6b, 0x49, 0x4c, 0xf4,
      0x38, 0xd0, 0xe2, 0x10, 0xb8, 0xcb, 0xe6, 0x06, 0x7a, 0x07, 0xca, 0x78,
      0xaf, 0x7d, 0xf1, 0x54, 0x7e, 0xf9, 0xac, 0xcb, 0x15, 0xc5, 0xc2, 0x60,
      0x1c, 0x2a, 0x02, 0x07, 0x80, 0xcb, 0x14, 0x75, 0x72, 0x01, 0xbf, 0xab,
      0x58, 0xbb, 0x85, 0xef, 0x56, 0x42, 0xd9, 0xb5, 0xb9, 0x7a, 0xb7, 0x68,
      0xf2, 0x85, 0xeb, 0x20, 0x12, 0xf1, 0xed, 0x8f, 0x7b, 0xbd, 0x2b, 0xc4,
      0xac, 0x2b, 0x9e, 0xdd, 0xbd, 0x65, 0x6d, 0xc7, 0x47, 0x7e, 0x80, 0x0e,
      0x95, 0x92, 0x48, 0x27, 0xba, 0x6d, 0x4f, 0x5b, 0xfa, 0xe0, 0x58, 0xe3,
      0x41, 0x50, 0xdc, 0x67, 0x6e, 0x91, 0xce, 0xc7, 0x80, 0x52, 0x8d, 0x6b,
      0xdb, 0x9d, 0x39, 0xc4, 0xaf, 0x40, 0x05, 0x03, 0x5e, 0xf4, 0x5a, 0xfe,
      0xce, 0xd5, 0x7c, 0xa8, 0xf2, 0x81, 0x7b, 0x5f, 0xce, 0xc9, 0x69, 0xa6,
      0xaf, 0xa2, 0xe0, 0xdf, 0x7c, 0xfe, 0x5b, 0x81, 0x8b, 0xbd, 0xda, 0x76,
      0xd7, 0xb7, 0x60, 0x45, 0x4f, 0x68, 0x2d, 0x55, 0x3f, 0x69, 0x76, 0x56,
      0x2f, 0x7f, 0x52, 0x9e, 0xd8, 0x31, 0x9c, 0xbc, 0x98, 0xbc, 0xc7, 0x59,
      0xdb, 0x0c, 0x5f, 0x3c, 0x7c, 0x47, 0x55, 0x70, 0x92, 0xbb, 0x3e, 0x0d,
      0x3b, 0x20, 0x8a, 0xb6, 0xfd, 0xfe, 0x75, 0xdd, 0x5c, 0x08, 0x1f, 0xf4,
      0xfc, 0xdb, 0x08, 0x55, 0x6e, 0x78, 0x87, 0x76, 0x23, 0xfd, 0xc4, 0xbe,
      0x02, 0x99, 0x33, 0xbb, 0x65, 0x9f, 0xd3, 0x67, 0x7d, 0x62, 0xbc, 0xb5,
      0xd8, 0xd3, 0x78, 0x18},
     {},
     priv_key_0,
     false},

    // Comment: first byte of ps modified
    // tcID: 16
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     16,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x0f, 0xe6, 0xfc, 0xde, 0x58, 0x64, 0x8f, 0x13, 0xeb, 0xd5, 0xf0, 0xcc,
      0xbd, 0x68, 0x45, 0x8d, 0xa8, 0xae, 0x18, 0xdf, 0xbe, 0x82, 0x23, 0x8d,
      0x2f, 0xb9, 0x0e, 0xb4, 0x2b, 0x74, 0x3d, 0xcb, 0xe7, 0xb1, 0x2b, 0x33,
      0xf7, 0x7e, 0x31, 0xca, 0x85, 0xea, 0xf6, 0x94, 0xdc, 0xc1, 0x15, 0x9c,
      0x2f, 0xd4, 0x77, 0x8f, 0xce, 0x93, 0xce, 0xca, 0x25, 0xf5, 0x12, 0x3a,
      0xa6, 0x3a, 0xd8, 0xdd, 0xbf, 0x77, 0x64, 0x00, 0xd4, 0x89, 0xd8, 0xd3,
      0xd4, 0x66, 0x65, 0xc9, 0xd2, 0x2b, 0x43, 0x82, 0xd4, 0x68, 0x88, 0x1b,
      0x7a, 0xa3, 0x0c, 0x97, 0xcc, 0x60, 0x68, 0xa9, 0x03, 0x1a, 0x10, 0x0c,
      0xd4, 0xb0, 0x35, 0x42, 0x69, 0x32, 0xc4, 0x88, 0xa6, 0x39, 0x6d, 0xe7,
      0xbf, 0x42, 0xbd, 0xfc, 0x8d, 0xa0, 0x4a, 0xf6, 0xce, 0xaa, 0x78, 0x36,
      0x75, 0x2f, 0xec, 0xcf, 0xbe, 0x52, 0x95, 0xa7, 0x57, 0xdf, 0xcc, 0x25,
      0xc8, 0xe8, 0xc5, 0xcf, 0xe1, 0x22, 0xbc, 0xb7, 0x64, 0xf0, 0x66, 0x05,
      0x28, 0xe1, 0x62, 0xc3, 0x20, 0x5e, 0x0a, 0x6b, 0x9f, 0x8d, 0x39, 0x9f,
      0x50, 0x52, 0x90, 0x05, 0x46, 0x7f, 0x56, 0xea, 0x70, 0xc0, 0x18, 0x2c,
      0x9d, 0x67, 0x9d, 0x13, 0xdb, 0xb0, 0xe1, 0xea, 0x24, 0xb8, 0x47, 0x09,
      0xc1, 0x68, 0x14, 0x18, 0xcd, 0x17, 0x4f, 0x44, 0x67, 0xf9, 0x43, 0xcd,
      0x5a, 0x18, 0x02, 0xbd, 0x0a, 0xc6, 0x66, 0xda, 0xba, 0xc7, 0x2b, 0xb3,
      0xbe, 0x4d, 0x3a, 0xb9, 0x87, 0x4b, 0x23, 0xc4, 0xc3, 0x94, 0xf3, 0x28,
      0x70, 0x75, 0xc6, 0x04, 0x54, 0xda, 0xad, 0x06, 0x2f, 0x2e, 0x5b, 0x81,
      0xbf, 0xb1, 0x42, 0x22, 0xc9, 0x7c, 0xae, 0xf7, 0x42, 0x48, 0x2c, 0x67,
      0x29, 0xc9, 0xb4, 0x4d, 0xe8, 0x80, 0xe0, 0x76, 0x68, 0xb5, 0x9a, 0x93,
      0xd8, 0xe2, 0x7d, 0x17},
     {},
     priv_key_0,
     false},

    // Comment: ps terminated by 0xff
    // tcID: 17
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     17,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x0a, 0x18, 0x2c, 0xc2, 0x30, 0x64, 0xe7, 0xb1, 0xd1, 0x1f, 0xf9, 0x06,
      0xed, 0x40, 0x84, 0x22, 0x13, 0x93, 0x84, 0x31, 0x90, 0x63, 0x95, 0xac,
      0x49, 0x95, 0xb9, 0xe8, 0xe5, 0x6f, 0xa3, 0x83, 0x5e, 0x9f, 0xc4, 0xc4,
      0xca, 0x81, 0xd5, 0xcd, 0x0e, 0x14, 0x81, 0x4b, 0xf1, 0x6d, 0xe6, 0xe0,
      0x7d, 0xdd, 0x94, 0x9b, 0x43, 0x52, 0x23, 0x87, 0xe8, 0xf5, 0x43, 0x67,
      0x2d, 0xc9, 0x65, 0x97, 0x62, 0x29, 0xda, 0x3e, 0x79, 0x1e, 0xfc, 0xcf,
      0x4a, 0x4d, 0x28, 0xc3, 0xd5, 0xcc, 0x8c, 0x32, 0xf7, 0x21, 0x6e, 0x89,
      0x40, 0x07, 0x94, 0xc4, 0x95, 0xa5, 0x4d, 0x2b, 0x38, 0xf7, 0x2e, 0x30,
      0x57, 0x0b, 0x43, 0xb5, 0x8c, 0x65, 0x74, 0x71, 0xfb, 0x9b, 0x6b, 0xe7,
      0xa9, 0x99, 0x80, 0x79, 0x76, 0x26, 0x3c, 0xc2, 0x59, 0xc0, 0x6d, 0xf5,
      0x1e, 0x63, 0x2b, 0xee, 0xcd, 0x73, 0x72, 0xe2, 0xd0, 0xff, 0xa1, 0x7f,
      0x79, 0xd0, 0x29, 0xdb, 0xa8, 0xcf, 0x00, 0x61, 0x1c, 0xaa, 0x9e, 0x05,
      0xbd, 0xc0, 0xef, 0x87, 0xd9, 0xa2, 0xf5, 0xf0, 0x2e, 0x47, 0x32, 0xaa,
      0xc5, 0xbd, 0xbf, 0x1d, 0x75, 0x4e, 0x22, 0x63, 0xa2, 0x09, 0xa9, 0xb2,
      0x11, 0xa1, 0xa8, 0x71, 0x2a, 0x2b, 0x9a, 0x8d, 0xbf, 0x67, 0x6f, 0xb7,
      0xbf, 0x13, 0x0c, 0x50, 0x5e, 0xc1, 0x97, 0x2e, 0x4c, 0x5c, 0x4b, 0xae,
      0xf2, 0xe3, 0x3c, 0x95, 0x5e, 0x63, 0xd5, 0x5c, 0xec, 0xb8, 0x18, 0xf9,
      0xc8, 0x5d, 0xfb, 0x1f, 0xa5, 0x42, 0x07, 0xa4, 0x06, 0xf1, 0x53, 0xce,
      0x77, 0xd9, 0x46, 0xc6, 0x0c, 0x4f, 0xaa, 0x28, 0x9d, 0x95, 0x5d, 0x73,
      0xa8, 0xc6, 0x4f, 0x5d, 0x4d, 0xbc, 0x2f, 0xac, 0x3b, 0x47, 0x41, 0xef,
      0xf3, 0xb3, 0xfc, 0x20, 0x5e, 0x1b, 0xda, 0xf7, 0xfa, 0xbd, 0x73, 0x8d,
      0x01, 0xea, 0xa4, 0x04},
     {},
     priv_key_0,
     false},

    // Comment: ps is all zero
    // tcID: 18
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     18,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xaf, 0xfb, 0x96, 0x04, 0xfa, 0x25, 0xac, 0x90, 0x4e, 0x05, 0x4b, 0x04,
      0x01, 0xd5, 0x1c, 0x56, 0x6c, 0x75, 0x56, 0xc9, 0x65, 0x08, 0x8e, 0x81,
      0xbb, 0x01, 0x81, 0xdc, 0x16, 0x53, 0x2b, 0x5c, 0x58, 0x00, 0x11, 0x7e,
      0xae, 0xe4, 0x91, 0xc1, 0xdc, 0xfe, 0xbb, 0x18, 0x4c, 0xa0, 0x0c, 0xcf,
      0xb3, 0xa9, 0x34, 0xa4, 0xe3, 0xef, 0xd4, 0x2a, 0x22, 0x49, 0xef, 0x6d,
      0x4a, 0x1d, 0xf9, 0x3a, 0xf9, 0x0d, 0xb0, 0xd1, 0x35, 0xa0, 0x00, 0xc9,
      0x7f, 0xc1, 0x09, 0x2e, 0x85, 0xcc, 0xa9, 0x07, 0x70, 0xe4, 0xb3, 0x58,
      0x3b, 0xaa, 0x65, 0x4c, 0xd1, 0x27, 0xb5, 0xef, 0x75, 0x49, 0xd7, 0xd7,
      0xa4, 0xda, 0xb1, 0xcc, 0xb1, 0x6b, 0x7f, 0xb0, 0xb0, 0xea, 0xa6, 0xae,
      0x40, 0x1e, 0x02, 0x3e, 0xfa, 0x97, 0xef, 0x61, 0xa1, 0x36, 0x55, 0x4d,
      0x01, 0x3c, 0x61, 0x93, 0x4c, 0xb9, 0x99, 0x6d, 0xb2, 0xcb, 0xac, 0x0a,
      0x4b, 0x68, 0x65, 0x12, 0x85, 0xef, 0x34, 0x21, 0xae, 0x22, 0x76, 0xc7,
      0xe6, 0x5d, 0xc8, 0x1d, 0x8e, 0x30, 0x89, 0xc1, 0x5e, 0x36, 0xe2, 0xbc,
      0xd8, 0xf4, 0x29, 0x26, 0xda, 0xa9, 0x07, 0xf5, 0x6e, 0x5f, 0xa4, 0xd6,
      0xa8, 0xf3, 0x89, 0x1e, 0x71, 0xb4, 0xf8, 0x0a, 0x15, 0x79, 0x8a, 0x94,
      0xbb, 0x64, 0xaa, 0x68, 0xe2, 0x95, 0xbb, 0x0d, 0x1f, 0x66, 0x69, 0xea,
      0x76, 0x1d, 0xe0, 0x79, 0x2f, 0xee, 0x6e, 0x0b, 0xff, 0x46, 0x5e, 0x53,
      0xb1, 0x44, 0x7e, 0xff, 0x61, 0x0b, 0x33, 0xd3, 0x8e, 0xca, 0x86, 0xd9,
      0xc6, 0x6b, 0x54, 0x2f, 0x57, 0x93, 0x38, 0xfd, 0x94, 0x4f, 0x6a, 0x11,
      0x63, 0x33, 0xde, 0xc3, 0x68, 0x4e, 0x4c, 0x78, 0xab, 0xa1, 0xb1, 0xec,
      0x12, 0xe8, 0xe6, 0x71, 0x22, 0x06, 0xf8, 0x17, 0x01, 0xd3, 0x0a, 0x3b,
      0x43, 0x68, 0x8d, 0x0b},
     {},
     priv_key_0,
     false},

    // Comment: ps replaced by 0xff's
    // tcID: 19
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     19,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa4, 0x55, 0xa8, 0x53, 0x6e, 0x52, 0x95, 0xac, 0x29, 0x24, 0x3e, 0x3f,
      0x7b, 0xfd, 0x2f, 0x6e, 0xbf, 0x1a, 0xa7, 0xe3, 0xd1, 0x33, 0x3c, 0x1b,
      0xd9, 0xfe, 0x05, 0xb6, 0xad, 0xe3, 0xaa, 0x91, 0x3b, 0x85, 0x9d, 0xbd,
      0x45, 0xba, 0x09, 0x3a, 0xe9, 0xb0, 0x34, 0xf6, 0x19, 0xf9, 0x9a, 0x69,
      0xea, 0xa6, 0x80, 0xff, 0xb7, 0xbe, 0x3a, 0xb3, 0x87, 0x84, 0x64, 0x8f,
      0x6f, 0x31, 0xf8, 0x58, 0x20, 0x09, 0x92, 0xf9, 0x57, 0x40, 0xff, 0x2e,
      0xdb, 0x83, 0x5f, 0x8f, 0xc0, 0x3b, 0xb6, 0x78, 0x52, 0x78, 0xab, 0x9e,
      0xae, 0x74, 0x2d, 0x59, 0x66, 0x51, 0x9f, 0xa9, 0xf5, 0x84, 0xf0, 0xc3,
      0x04, 0x41, 0x36, 0xd0, 0x4f, 0xe1, 0x21, 0x04, 0xec, 0x8a, 0x8b, 0xd0,
      0x79, 0x50, 0x33, 0x4d, 0xb8, 0xdf, 0x8a, 0x83, 0xaf, 0x84, 0x33, 0x47,
      0xa1, 0x09, 0x74, 0x24, 0x5c, 0x72, 0x3f, 0xc8, 0x56, 0x86, 0x24, 0x0e,
      0xef, 0xd0, 0xcc, 0xe0, 0x9d, 0x81, 0xa6, 0x3c, 0x6f, 0x6a, 0x4d, 0x2b,
      0x83, 0xd2, 0x9f, 0xf9, 0xad, 0x06, 0x01, 0x29, 0xe5, 0x52, 0x1d, 0xa5,
      0xe6, 0x35, 0xdc, 0x05, 0x79, 0x6b, 0xa5, 0x40, 0xf1, 0xda, 0xd2, 0x5b,
      0x94, 0x23, 0xbd, 0xa3, 0x65, 0x20, 0x27, 0x09, 0xe5, 0xe2, 0x87, 0xa2,
      0xb0, 0xd7, 0xb0, 0x9a, 0x2a, 0xb6, 0x03, 0x14, 0x47, 0xe1, 0xa2, 0xae,
      0x8e, 0xfd, 0x9e, 0x98, 0x0a, 0x29, 0xdf, 0xf1, 0x45, 0x83, 0x27, 0xed,
      0xc0, 0xad, 0x16, 0x26, 0x70, 0xf8, 0x03, 0x43, 0xd8, 0x49, 0x01, 0x18,
      0x85, 0x6f, 0x39, 0x6c, 0x72, 0x05, 0x82, 0x27, 0xf5, 0x7b, 0x9b, 0x0b,
      0xa6, 0x6b, 0x13, 0xc4, 0xe7, 0x11, 0x75, 0x38, 0xbc, 0xda, 0x3e, 0x93,
      0x7d, 0xfe, 0x05, 0xd1, 0x0a, 0x76, 0x4c, 0x0b, 0xa1, 0xf5, 0x62, 0x64,
      0x78, 0xd4, 0xfc, 0x72},
     {},
     priv_key_0,
     false},

    // Comment: seed is all 0
    // tcID: 20
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     20,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x96, 0x98, 0x2e, 0x22, 0x23, 0x02, 0x81, 0x8f, 0x50, 0x62, 0x85, 0x64,
      0x27, 0x68, 0x61, 0x5f, 0x42, 0x6b, 0xdf, 0x9f, 0x3b, 0x4d, 0xaf, 0x80,
      0xec, 0x5e, 0x3e, 0xa2, 0x6c, 0xbb, 0xe7, 0xf5, 0xab, 0x48, 0xcb, 0xda,
      0xca, 0x4a, 0xb0, 0x53, 0x8b, 0xfd, 0xd9, 0x1f, 0x76, 0x78, 0x10, 0x1b,
      0x61, 0x18, 0x18, 0x06, 0xf4, 0x8b, 0x2d, 0x6f, 0xe7, 0x78, 0xd8, 0x99,
      0x80, 0x4a, 0x88, 0x87, 0x16, 0xa0, 0xc2, 0xc3, 0xa7, 0x07, 0x85, 0x13,
      0xb1, 0xcb, 0xaf, 0x1d, 0x09, 0x6e, 0x6f, 0xdc, 0x83, 0xab, 0xc2, 0xfe,
      0x40, 0xb6, 0x74, 0x27, 0x09, 0xa2, 0xe5, 0x1a, 0xfd, 0x8e, 0x76, 0x7a,
      0xa4, 0xa7, 0x2b, 0xb4, 0x55, 0x42, 0x86, 0x14, 0x05, 0x33, 0xe4, 0xbd,
      0x54, 0x32, 0x01, 0x0d, 0x60, 0x16, 0xd3, 0x08, 0xd4, 0x75, 0xeb, 0x2a,
      0x40, 0x16, 0x5d, 0x46, 0xdb, 0xa6, 0x30, 0xc1, 0x1a, 0x18, 0x35, 0x32,
      0xf6, 0x58, 0xbd, 0x53, 0x80, 0x96, 0xc1, 0x87, 0x7f, 0xc4, 0xd8, 0x43,
      0xd9, 0xd2, 0xd8, 0xce, 0xe5, 0x70, 0xda, 0xdc, 0x98, 0x95, 0xcf, 0xe2,
      0x37, 0x2d, 0xf9, 0x60, 0x1f, 0xcd, 0x74, 0x39, 0x90, 0x06, 0x46, 0x6f,
      0xb9, 0xed, 0x92, 0x3b, 0x7d, 0x9a, 0xbb, 0xad, 0x9b, 0xc7, 0xde, 0x96,
      0x3e, 0x0e, 0xea, 0xc7, 0xbb, 0xd5, 0x6f, 0x20, 0xe1, 0xc2, 0x54, 0xef,
      0x72, 0x2d, 0x52, 0x3f, 0xa8, 0xf3, 0xbd, 0xb0, 0xb9, 0x1b, 0x37, 0x20,
      0x2e, 0x11, 0xb4, 0x57, 0x8a, 0x32, 0x52, 0x67, 0x3e, 0x69, 0xec, 0x05,
      0xa0, 0x5e, 0xa6, 0x09, 0x13, 0xea, 0x1b, 0x9e, 0x62, 0x28, 0xd9, 0xfa,
      0x0c, 0x85, 0xac, 0x6d, 0x79, 0x4d, 0xfe, 0xcc, 0xdf, 0x75, 0x95, 0x82,
      0x8b, 0x06, 0xdf, 0x2b, 0xdc, 0x89, 0xfd, 0x8d, 0x22, 0x62, 0x9f, 0xdf,
      0xee, 0x20, 0x5b, 0xe7},
     {},
     priv_key_0,
     true},

    // Comment: seed is all 1
    // tcID: 21
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     21,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xae, 0x11, 0xf4, 0x5e, 0x24, 0xcf, 0xfa, 0x8e, 0x4f, 0x37, 0xbe, 0x34,
      0xec, 0x87, 0x85, 0x2d, 0xb7, 0x7c, 0x25, 0x01, 0xc1, 0x27, 0x4e, 0x23,
      0x47, 0x7c, 0x50, 0xd6, 0x23, 0x13, 0x48, 0x0b, 0xa2, 0xac, 0x9d, 0xe7,
      0x6b, 0x79, 0x0a, 0x35, 0x5b, 0x50, 0xc2, 0xf2, 0xed, 0x2d, 0xd0, 0x61,
      0xcd, 0x86, 0x0f, 0xf7, 0x93, 0x2c, 0xad, 0xaa, 0x0e, 0x15, 0x65, 0xe4,
      0x3d, 0x41, 0x77, 0xac, 0x98, 0xe2, 0x6d, 0x96, 0x4e, 0x81, 0xcf, 0xb7,
      0xc2, 0x0f, 0xba, 0x7e, 0x2b, 0x08, 0x53, 0xfd, 0xcc, 0x7d, 0xea, 0xb7,
      0x5b, 0x62, 0xef, 0x5f, 0x23, 0x1e, 0xa2, 0x9f, 0x10, 0xc8, 0x3c, 0x2f,
      0x27, 0xc9, 0x21, 0x5b, 0x7d, 0x10, 0xd8, 0x54, 0x43, 0xd9, 0x67, 0xce,
      0x7f, 0xcd, 0x41, 0xb0, 0xde, 0x99, 0x9d, 0x9f, 0x98, 0xa0, 0x72, 0xdc,
      0x80, 0xfb, 0x58, 0x57, 0xd4, 0x7e, 0x43, 0x73, 0xc7, 0x36, 0xba, 0xe7,
      0x28, 0x93, 0x27, 0x33, 0xd0, 0xa0, 0x71, 0x16, 0x4b, 0x6d, 0x6d, 0xea,
      0x32, 0x05, 0xe2, 0x67, 0xbe, 0xbc, 0x28, 0x7d, 0x9b, 0x50, 0x35, 0xa7,
      0x69, 0x78, 0xdc, 0xc2, 0xf3, 0x89, 0x46, 0xdd, 0xdc, 0xa4, 0x8a, 0x6a,
      0x60, 0x35, 0x55, 0x7d, 0xd9, 0xe1, 0xaa, 0xec, 0x43, 0x44, 0xdb, 0xb4,
      0x57, 0x61, 0x2e, 0xb2, 0x7b, 0x93, 0x02, 0xe0, 0x2e, 0xa0, 0xc9, 0x45,
      0x69, 0x84, 0xe7, 0x0f, 0xaf, 0x23, 0x5a, 0xec, 0xd2, 0x0c, 0xb3, 0x2f,
      0x3d, 0xa0, 0x16, 0xc9, 0xa8, 0xa8, 0xb2, 0x3e, 0x07, 0xa0, 0x6d, 0xfa,
      0x57, 0xf5, 0xa2, 0x58, 0x53, 0x94, 0x4c, 0xbf, 0x53, 0x8c, 0x86, 0x41,
      0x69, 0x56, 0x67, 0x97, 0xa4, 0x34, 0x6e, 0x52, 0xfc, 0xd2, 0xea, 0x14,
      0x89, 0x79, 0x91, 0x09, 0x82, 0x0c, 0xca, 0x4b, 0x62, 0x49, 0x50, 0x22,
      0x70, 0xdf, 0xb1, 0xf6},
     {},
     priv_key_0,
     true},

    // Comment: First byte is 1
    // tcID: 22
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     22,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x8b, 0xa6, 0x59, 0x49, 0xd2, 0xa5, 0x3d, 0x5a, 0x93, 0x3a, 0xbb, 0xdf,
      0xf1, 0xef, 0xb4, 0xb6, 0x86, 0x14, 0x84, 0xdc, 0x23, 0x0b, 0xca, 0x0c,
      0x36, 0x3a, 0x66, 0x20, 0x26, 0x91, 0xbd, 0x39, 0xd9, 0x47, 0x98, 0x66,
      0x47, 0x63, 0xd7, 0x2f, 0x55, 0xed, 0xb3, 0x7e, 0x8c, 0xc7, 0x91, 0xb3,
      0x90, 0x4c, 0x42, 0xc4, 0xe1, 0xb7, 0x5e, 0x4a, 0xaa, 0xd3, 0x12, 0xf5,
      0xdc, 0x53, 0xa2, 0x46, 0xf2, 0x11, 0xd1, 0x9e, 0x31, 0x1a, 0x97, 0x4c,
      0x92, 0xff, 0x8a, 0xf0, 0x57, 0x3d, 0xc8, 0x31, 0xc5, 0x11, 0x94, 0xe5,
      0x9c, 0x92, 0x0e, 0xc3, 0xd6, 0x32, 0x5f, 0x06, 0xb9, 0xc4, 0xbc, 0xea,
      0xa6, 0xe5, 0x56, 0x96, 0xb1, 0x85, 0x16, 0x3e, 0x73, 0xaa, 0xc4, 0x01,
      0xfc, 0x19, 0x25, 0xcf, 0xfc, 0xc7, 0xb8, 0x09, 0x85, 0xba, 0xb7, 0x27,
      0x28, 0x8d, 0x25, 0x8a, 0x3c, 0x60, 0xf7, 0xd3, 0xd2, 0xd8, 0xec, 0x80,
      0xdc, 0xfe, 0x75, 0x47, 0x22, 0x91, 0x83, 0xa1, 0x92, 0x47, 0xe3, 0xea,
      0x10, 0xaf, 0xcb, 0x0f, 0xb0, 0xc8, 0xe7, 0xc4, 0xc5, 0x7b, 0xd5, 0xcf,
      0xd5, 0x52, 0x9a, 0xbb, 0xd4, 0x07, 0xf9, 0x59, 0xf4, 0xb9, 0xc4, 0x92,
      0x41, 0x16, 0x91, 0xda, 0x44, 0x5f, 0xc5, 0xff, 0x3f, 0xfd, 0xd1, 0x1f,
      0xcd, 0x20, 0xc2, 0xa2, 0x93, 0x6d, 0x13, 0x73, 0xb5, 0x5c, 0x2e, 0xe4,
      0x1a, 0x7b, 0x43, 0xc0, 0x49, 0xb4, 0x0c, 0xc5, 0x5f, 0x7b, 0xc8, 0x5e,
      0x46, 0xb0, 0xd8, 0x46, 0x4a, 0x3a, 0xdd, 0x0b, 0xf2, 0x8a, 0x0d, 0x3e,
      0xe4, 0x6c, 0x12, 0xe6, 0xfd, 0x60, 0x0f, 0x84, 0x0e, 0xd6, 0x5f, 0x11,
      0xd5, 0x90, 0x38, 0x1f, 0xb9, 0xc6, 0xa8, 0x0a, 0x46, 0xd6, 0x45, 0x70,
      0xeb, 0x4f, 0x69, 0x30, 0xed, 0x24, 0x08, 0x7e, 0x47, 0xaa, 0x12, 0xec,
      0xa2, 0xa1, 0x32, 0x9a},
     {},
     priv_key_0,
     false},

    // Comment: m is 0
    // tcID: 23
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     23,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     {},
     priv_key_0,
     false},

    // Comment: m is 1
    // tcID: 24
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     24,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     {},
     priv_key_0,
     false},

    // Comment: m is n-1
    // tcID: 25
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     25,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xbd, 0x31, 0xc7, 0xa0, 0x26, 0x91, 0xd2, 0xd9, 0x58, 0x7e, 0xf6, 0xa9,
      0x46, 0xff, 0x78, 0x85, 0x44, 0xcc, 0xad, 0xd4, 0xb2, 0x98, 0x8a, 0xd6,
      0x20, 0x86, 0x79, 0x2a, 0x6b, 0xf9, 0x6c, 0x86, 0x16, 0xb4, 0xad, 0x13,
      0x31, 0x7d, 0x22, 0x70, 0xb9, 0x01, 0xd0, 0xfc, 0xd1, 0xd8, 0x80, 0xcb,
      0x8f, 0x52, 0xfb, 0x87, 0x30, 0x4a, 0x52, 0x58, 0xc1, 0x1b, 0x38, 0xdf,
      0xea, 0xe8, 0xdf, 0x67, 0x0a, 0xee, 0xe7, 0xea, 0x1d, 0x0d, 0x9d, 0xf8,
      0xe0, 0x0e, 0x80, 0x84, 0x7e, 0x41, 0xe5, 0x98, 0x9e, 0xd4, 0x02, 0xd4,
      0x4e, 0x78, 0xb3, 0x0f, 0xef, 0x17, 0xb5, 0x67, 0x1d, 0x3a, 0xdb, 0xf8,
      0x68, 0x5e, 0x4d, 0xc2, 0x04, 0x49, 0x9e, 0xcd, 0x18, 0x63, 0xe1, 0xd5,
      0xaf, 0xf2, 0x8a, 0x7c, 0xf6, 0x6e, 0xad, 0xf3, 0x1f, 0xec, 0x92, 0x36,
      0xc1, 0x20, 0xad, 0xd1, 0x34, 0x51, 0x52, 0x2c, 0x64, 0x7c, 0x98, 0x32,
      0xa6, 0x72, 0xcd, 0x64, 0xd3, 0x28, 0xc1, 0xc3, 0x22, 0x18, 0x3f, 0x46,
      0x61, 0xd0, 0x9b, 0xda, 0x60, 0xb8, 0xdd, 0x5f, 0x03, 0x28, 0xda, 0x54,
      0x20, 0x82, 0x14, 0x24, 0xaf, 0xda, 0xbb, 0x1a, 0x80, 0xc5, 0xd1, 0x27,
      0x63, 0xa1, 0xb0, 0x23, 0x8c, 0xd8, 0x9d, 0x07, 0x42, 0xbf, 0xc5, 0x0b,
      0x6a, 0x2f, 0xcb, 0x70, 0x1d, 0x82, 0x42, 0x18, 0xf9, 0x82, 0x6f, 0x4f,
      0x78, 0xa2, 0x3a, 0x2b, 0x5a, 0xa4, 0x2a, 0xce, 0x7f, 0x17, 0x53, 0x76,
      0xfb, 0x6c, 0xbd, 0xb2, 0xba, 0xd2, 0x93, 0xba, 0x58, 0x3d, 0x4d, 0x31,
      0xc6, 0xb8, 0xf9, 0x02, 0x9e, 0x46, 0xb1, 0x36, 0x89, 0x24, 0x98, 0x55,
      0xf5, 0x05, 0x75, 0x6e, 0x00, 0xe2, 0x25, 0xa6, 0xa4, 0x5a, 0x18, 0x76,
      0x9b, 0xd8, 0xd2, 0xb3, 0xa4, 0xac, 0xb9, 0xf1, 0xc2, 0x3d, 0x3e, 0x51,
      0x88, 0x25, 0x61, 0xe4},
     {},
     priv_key_0,
     false},

    // Comment: added n to c
    // tcID: 26
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     26,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xe2, 0xda, 0xe0, 0x40, 0xee, 0x2a, 0x2d, 0x4c, 0x4a, 0x0e, 0x62, 0x0b,
      0x5d, 0xd0, 0x5b, 0x56, 0xdf, 0x67, 0xf0, 0x79, 0x88, 0x4f, 0x0b, 0xbf,
      0xb6, 0x4a, 0x3e, 0xef, 0xf0, 0x8f, 0xda, 0xaf, 0xdc, 0xcc, 0x45, 0x8b,
      0x01, 0x4d, 0x53, 0xf0, 0x57, 0x4f, 0x9e, 0xc5, 0x51, 0x4e, 0xf2, 0x15,
      0x24, 0x37, 0x3c, 0x04, 0x08, 0xb2, 0xd6, 0x7c, 0x11, 0xfd, 0xc8, 0x12,
      0x76, 0x28, 0x12, 0xdb, 0x75, 0x78, 0x66, 0x93, 0xb6, 0x63, 0x13, 0xec,
      0x08, 0xcd, 0x00, 0x1d, 0x90, 0x78, 0x7a, 0x1b, 0x4c, 0xee, 0x69, 0xd3,
      0xa9, 0xf2, 0xcf, 0x9a, 0xb8, 0x15, 0x03, 0xbe, 0x8f, 0x20, 0x5c, 0x70,
      0x1d, 0xa8, 0xa3, 0x9d, 0x70, 0xb1, 0xe8, 0xcc, 0x40, 0xf1, 0x32, 0xb3,
      0xbe, 0xd4, 0x6e, 0xd8, 0xf4, 0x66, 0xcd, 0xee, 0x0d, 0x03, 0x29, 0x55,
      0xda, 0xcc, 0x5c, 0x37, 0x37, 0x89, 0xf5, 0xd5, 0x88, 0x86, 0xa3, 0xa5,
      0xcf, 0xf7, 0xc8, 0x41, 0xa5, 0xb3, 0x47, 0x89, 0xa3, 0x09, 0x1a, 0x0f,
      0x19, 0x03, 0xa2, 0x22, 0x7a, 0xc2, 0x4c, 0xcf, 0x0a, 0x2f, 0xc3, 0x73,
      0x9c, 0x92, 0x21, 0x0a, 0xfd, 0xf7, 0x26, 0xd5, 0x3e, 0x07, 0x69, 0x2f,
      0x3f, 0xb8, 0x2f, 0x43, 0x1f, 0x27, 0x79, 0x76, 0x87, 0x66, 0x60, 0x81,
      0x11, 0xf6, 0xf4, 0xf9, 0xcf, 0xdf, 0x25, 0x6d, 0x79, 0xc5, 0xab, 0x13,
      0xcf, 0x68, 0xe9, 0xd4, 0x94, 0xb2, 0xc6, 0x0f, 0xd5, 0xee, 0xab, 0xda,
      0xf4, 0xb0, 0xc8, 0x96, 0xfd, 0xc1, 0x90, 0xdb, 0x93, 0xc7, 0x8c, 0x85,
      0x67, 0x1e, 0xd3, 0xab, 0x6b, 0x48, 0xb7, 0xbe, 0xf6, 0x39, 0xdd, 0x19,
      0xb4, 0xf2, 0x24, 0xd0, 0x66, 0x7f, 0x1f, 0xff, 0xc2, 0x00, 0x01, 0x97,
      0x73, 0xad, 0x09, 0xbe, 0x3f, 0x58, 0xb1, 0xeb, 0x5a, 0x7c, 0xec, 0x32,
      0x89, 0xff, 0x8f, 0x9f},
     {},
     priv_key_0,
     false},

    // Comment: ciphertext is empty
    // tcID: 27
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     27,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {},
     {},
     priv_key_0,
     false},

    // Comment: prepended bytes to ciphertext
    // tcID: 28
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     28,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x25, 0xa9, 0x18, 0xa0, 0xc7, 0x98, 0x5a, 0x72, 0xf1, 0x8f,
      0x6b, 0x62, 0x16, 0xd0, 0xe2, 0xd1, 0x9a, 0x9b, 0x42, 0xa4, 0xd5, 0xb6,
      0x80, 0xe9, 0x95, 0xc3, 0xc5, 0xc5, 0x84, 0x96, 0x6e, 0x29, 0xc6, 0x17,
      0x98, 0x77, 0xcf, 0xd0, 0x31, 0x7f, 0x9e, 0x4d, 0xcd, 0xc8, 0x7f, 0x76,
      0x71, 0x49, 0x94, 0xe4, 0x40, 0x7c, 0xd8, 0x68, 0x84, 0x23, 0x50, 0xe2,
      0x8f, 0x32, 0x8b, 0x3f, 0x33, 0x74, 0x6a, 0x89, 0x7e, 0xa9, 0x99, 0x55,
      0x75, 0xf3, 0x28, 0xbe, 0x7f, 0x99, 0x12, 0x36, 0x94, 0x82, 0xae, 0x1a,
      0x66, 0xff, 0x5b, 0x7a, 0x1c, 0x8a, 0xc8, 0xfd, 0x4e, 0x57, 0x71, 0xe5,
      0x80, 0x77, 0xb5, 0x4a, 0x55, 0xdb, 0x6c, 0x68, 0x49, 0xff, 0x28, 0x8d,
      0x50, 0xde, 0x0e, 0xe1, 0xe4, 0x5b, 0xfd, 0xf8, 0x1f, 0xfa, 0xed, 0x16,
      0x97, 0x1f, 0x19, 0xab, 0xae, 0x66, 0x03, 0x38, 0xa3, 0xa9, 0x24, 0x0a,
      0x0b, 0x73, 0x29, 0x84, 0xfa, 0xdc, 0xd2, 0x8a, 0x85, 0xc6, 0x80, 0xf0,
      0xda, 0xc8, 0xb7, 0x33, 0x06, 0x48, 0x1a, 0x09, 0x6f, 0x70, 0x07, 0x06,
      0xe9, 0x1f, 0x7c, 0x10, 0x0c, 0xe6, 0x4e, 0x1c, 0x6b, 0xba, 0xbd, 0x41,
      0x98, 0x07, 0xdc, 0x16, 0x7f, 0x1f, 0x92, 0x4e, 0xdc, 0x6f, 0x44, 0xa6,
      0x9b, 0x75, 0xa7, 0xc7, 0x29, 0x89, 0xb2, 0x5c, 0xe3, 0x54, 0x80, 0x43,
      0x3b, 0xc4, 0x56, 0xc6, 0xaf, 0xa9, 0x3a, 0x0e, 0x9b, 0x41, 0x56, 0xd7,
      0x58, 0x63, 0xf9, 0x44, 0x0a, 0xe4, 0x42, 0xee, 0xfd, 0x21, 0x3b, 0x8a,
      0x3f, 0x53, 0xa0, 0x65, 0xda, 0xa8, 0xcd, 0x02, 0x06, 0x88, 0x6d, 0x15,
      0x44, 0xc3, 0xbf, 0xec, 0xaf, 0x62, 0x65, 0x9c, 0xfa, 0x59, 0x1d, 0xa5,
      0xe9, 0x20, 0xd7, 0xd4, 0x37, 0x0a, 0x9a, 0xab, 0xf7, 0xf9, 0x98, 0x3f,
      0xad, 0xe1, 0x01, 0xda, 0x2d, 0xba},
     {},
     priv_key_0,
     false},

    // Comment: appended bytes to ciphertext
    // tcID: 29
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     29,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x25, 0xa9, 0x18, 0xa0, 0xc7, 0x98, 0x5a, 0x72, 0xf1, 0x8f, 0x6b, 0x62,
      0x16, 0xd0, 0xe2, 0xd1, 0x9a, 0x9b, 0x42, 0xa4, 0xd5, 0xb6, 0x80, 0xe9,
      0x95, 0xc3, 0xc5, 0xc5, 0x84, 0x96, 0x6e, 0x29, 0xc6, 0x17, 0x98, 0x77,
      0xcf, 0xd0, 0x31, 0x7f, 0x9e, 0x4d, 0xcd, 0xc8, 0x7f, 0x76, 0x71, 0x49,
      0x94, 0xe4, 0x40, 0x7c, 0xd8, 0x68, 0x84, 0x23, 0x50, 0xe2, 0x8f, 0x32,
      0x8b, 0x3f, 0x33, 0x74, 0x6a, 0x89, 0x7e, 0xa9, 0x99, 0x55, 0x75, 0xf3,
      0x28, 0xbe, 0x7f, 0x99, 0x12, 0x36, 0x94, 0x82, 0xae, 0x1a, 0x66, 0xff,
      0x5b, 0x7a, 0x1c, 0x8a, 0xc8, 0xfd, 0x4e, 0x57, 0x71, 0xe5, 0x80, 0x77,
      0xb5, 0x4a, 0x55, 0xdb, 0x6c, 0x68, 0x49, 0xff, 0x28, 0x8d, 0x50, 0xde,
      0x0e, 0xe1, 0xe4, 0x5b, 0xfd, 0xf8, 0x1f, 0xfa, 0xed, 0x16, 0x97, 0x1f,
      0x19, 0xab, 0xae, 0x66, 0x03, 0x38, 0xa3, 0xa9, 0x24, 0x0a, 0x0b, 0x73,
      0x29, 0x84, 0xfa, 0xdc, 0xd2, 0x8a, 0x85, 0xc6, 0x80, 0xf0, 0xda, 0xc8,
      0xb7, 0x33, 0x06, 0x48, 0x1a, 0x09, 0x6f, 0x70, 0x07, 0x06, 0xe9, 0x1f,
      0x7c, 0x10, 0x0c, 0xe6, 0x4e, 0x1c, 0x6b, 0xba, 0xbd, 0x41, 0x98, 0x07,
      0xdc, 0x16, 0x7f, 0x1f, 0x92, 0x4e, 0xdc, 0x6f, 0x44, 0xa6, 0x9b, 0x75,
      0xa7, 0xc7, 0x29, 0x89, 0xb2, 0x5c, 0xe3, 0x54, 0x80, 0x43, 0x3b, 0xc4,
      0x56, 0xc6, 0xaf, 0xa9, 0x3a, 0x0e, 0x9b, 0x41, 0x56, 0xd7, 0x58, 0x63,
      0xf9, 0x44, 0x0a, 0xe4, 0x42, 0xee, 0xfd, 0x21, 0x3b, 0x8a, 0x3f, 0x53,
      0xa0, 0x65, 0xda, 0xa8, 0xcd, 0x02, 0x06, 0x88, 0x6d, 0x15, 0x44, 0xc3,
      0xbf, 0xec, 0xaf, 0x62, 0x65, 0x9c, 0xfa, 0x59, 0x1d, 0xa5, 0xe9, 0x20,
      0xd7, 0xd4, 0x37, 0x0a, 0x9a, 0xab, 0xf7, 0xf9, 0x98, 0x3f, 0xad, 0xe1,
      0x01, 0xda, 0x2d, 0xba, 0x00, 0x00},
     {},
     priv_key_0,
     false},

    // Comment: truncated ciphertext
    // tcID: 30
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     30,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa9, 0x18, 0xa0, 0xc7, 0x98, 0x5a, 0x72, 0xf1, 0x8f, 0x6b, 0x62, 0x16,
      0xd0, 0xe2, 0xd1, 0x9a, 0x9b, 0x42, 0xa4, 0xd5, 0xb6, 0x80, 0xe9, 0x95,
      0xc3, 0xc5, 0xc5, 0x84, 0x96, 0x6e, 0x29, 0xc6, 0x17, 0x98, 0x77, 0xcf,
      0xd0, 0x31, 0x7f, 0x9e, 0x4d, 0xcd, 0xc8, 0x7f, 0x76, 0x71, 0x49, 0x94,
      0xe4, 0x40, 0x7c, 0xd8, 0x68, 0x84, 0x23, 0x50, 0xe2, 0x8f, 0x32, 0x8b,
      0x3f, 0x33, 0x74, 0x6a, 0x89, 0x7e, 0xa9, 0x99, 0x55, 0x75, 0xf3, 0x28,
      0xbe, 0x7f, 0x99, 0x12, 0x36, 0x94, 0x82, 0xae, 0x1a, 0x66, 0xff, 0x5b,
      0x7a, 0x1c, 0x8a, 0xc8, 0xfd, 0x4e, 0x57, 0x71, 0xe5, 0x80, 0x77, 0xb5,
      0x4a, 0x55, 0xdb, 0x6c, 0x68, 0x49, 0xff, 0x28, 0x8d, 0x50, 0xde, 0x0e,
      0xe1, 0xe4, 0x5b, 0xfd, 0xf8, 0x1f, 0xfa, 0xed, 0x16, 0x97, 0x1f, 0x19,
      0xab, 0xae, 0x66, 0x03, 0x38, 0xa3, 0xa9, 0x24, 0x0a, 0x0b, 0x73, 0x29,
      0x84, 0xfa, 0xdc, 0xd2, 0x8a, 0x85, 0xc6, 0x80, 0xf0, 0xda, 0xc8, 0xb7,
      0x33, 0x06, 0x48, 0x1a, 0x09, 0x6f, 0x70, 0x07, 0x06, 0xe9, 0x1f, 0x7c,
      0x10, 0x0c, 0xe6, 0x4e, 0x1c, 0x6b, 0xba, 0xbd, 0x41, 0x98, 0x07, 0xdc,
      0x16, 0x7f, 0x1f, 0x92, 0x4e, 0xdc, 0x6f, 0x44, 0xa6, 0x9b, 0x75, 0xa7,
      0xc7, 0x29, 0x89, 0xb2, 0x5c, 0xe3, 0x54, 0x80, 0x43, 0x3b, 0xc4, 0x56,
      0xc6, 0xaf, 0xa9, 0x3a, 0x0e, 0x9b, 0x41, 0x56, 0xd7, 0x58, 0x63, 0xf9,
      0x44, 0x0a, 0xe4, 0x42, 0xee, 0xfd, 0x21, 0x3b, 0x8a, 0x3f, 0x53, 0xa0,
      0x65, 0xda, 0xa8, 0xcd, 0x02, 0x06, 0x88, 0x6d, 0x15, 0x44, 0xc3, 0xbf,
      0xec, 0xaf, 0x62, 0x65, 0x9c, 0xfa, 0x59, 0x1d, 0xa5, 0xe9, 0x20, 0xd7,
      0xd4, 0x37, 0x0a, 0x9a, 0xab, 0xf7, 0xf9, 0x98, 0x3f, 0xad, 0xe1, 0x01,
      0xda, 0x2d, 0xba},
     {},
     priv_key_0,
     false},

    // Comment: em represents a small integer
    // tcID: 31
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     31,
     {0x32, 0xfd, 0xd5, 0xb5, 0x31, 0x91, 0x88, 0x91, 0x4a, 0xfb, 0xe2, 0x1b,
      0x1f, 0xa9, 0x1b, 0xc4, 0xe4, 0x84, 0xec, 0xd1, 0xf9, 0x96, 0x82, 0x31,
      0x87, 0x9e, 0x37, 0x25, 0x70, 0xc4, 0x3a, 0x27, 0xf7, 0x20, 0xe6, 0x77,
      0x3e, 0x1d, 0x90, 0x5b, 0x70, 0xf8, 0x5a, 0x31, 0x23, 0x47, 0xf7, 0xe9,
      0x75, 0x2a, 0x8c, 0x4f, 0x5b, 0x9f, 0x27, 0xbd, 0x01, 0x53, 0x0b, 0x6e,
      0xfe, 0xb2, 0x21, 0xdd, 0xdc, 0x72, 0x3c, 0xd5, 0x1b, 0x4b, 0xc4, 0x81,
      0x49, 0x92, 0x26, 0x8c, 0x40, 0x3e, 0xd4, 0xfd, 0xdd, 0xd5, 0x26, 0xef,
      0xa8, 0x7d, 0x83, 0x50, 0x69, 0x24, 0x6f, 0x25, 0xe8, 0x09, 0x8d, 0xd5,
      0xae, 0x3e, 0x46, 0x3f, 0xd6, 0x39, 0xb3, 0x6a, 0x4c, 0x13, 0x94, 0x76,
      0xb3, 0xd2, 0x9a, 0xe0, 0xc9, 0xb6, 0xc1, 0x63, 0xd8, 0x1e, 0x77, 0x19,
      0xcc, 0x85, 0xe6, 0x52, 0x89, 0xbd, 0xde, 0x2f, 0x82, 0xb6, 0x9b, 0xb4,
      0xaa, 0x9c, 0x5a, 0x5d, 0xcd, 0x51, 0x34, 0x21, 0xa5, 0x4e, 0x5d, 0x46,
      0x38, 0xd8, 0xc2, 0x35, 0x67, 0xc1, 0x29, 0x78, 0xc3, 0xaa, 0x80, 0x6b,
      0xa7, 0x96, 0x4a, 0x54, 0x7a, 0x68, 0x93, 0x60, 0x10, 0x5f, 0xc1, 0xb2,
      0x46, 0x8f, 0xa1, 0x48, 0x02, 0x04, 0xd4, 0x68, 0xba, 0x2f, 0xe4, 0x1c,
      0xe9, 0x30, 0x23, 0x28, 0xd4, 0x27, 0x9e, 0x00, 0xa9, 0xaf, 0x1c, 0x7c,
      0xdd, 0x9f, 0x16, 0xd5, 0x72, 0xe7, 0x0b, 0x06, 0xf1, 0xf4, 0x0a, 0xcf,
      0xd5, 0x0c, 0x88, 0x65, 0xef, 0x37, 0xd8, 0x88, 0xb2, 0xfb},
     {0x09, 0x2d, 0x5b, 0x4b, 0xea, 0x48, 0x70, 0x29, 0xa4, 0xc0, 0x6c, 0x97,
      0xf7, 0x27, 0xf6, 0xad, 0x45, 0x31, 0xf7, 0xf6, 0x46, 0xc9, 0x5c, 0xd2,
      0x69, 0xe1, 0xe6, 0x06, 0xa7, 0xe0, 0x47, 0xc1, 0x9a, 0x6a, 0x9e, 0xca,
      0x8f, 0xa5, 0xab, 0xcb, 0xbc, 0xa4, 0x15, 0x47, 0x74, 0x20, 0xba, 0x42,
      0x2a, 0x7d, 0x5b, 0xa4, 0x1a, 0xc7, 0x9b, 0xa7, 0x54, 0x8a, 0xa6, 0xf4,
      0xb4, 0x4a, 0xa6, 0x5a, 0xd9, 0x15, 0xec, 0x11, 0xd7, 0xf5, 0x0c, 0xd2,
      0xad, 0x7e, 0xac, 0x86, 0x86, 0x9b, 0xf8, 0x8b, 0xd7, 0xcb, 0xd1, 0x14,
      0x39, 0xae, 0xc3, 0x54, 0xa2, 0x5b, 0xe7, 0x1d, 0x36, 0x54, 0x1e, 0x7e,
      0xf2, 0x11, 0xae, 0x01, 0x0d, 0x82, 0x59, 0xac, 0x7b, 0x5a, 0xf4, 0x9e,
      0x38, 0xe1, 0x4d, 0x87, 0xb6, 0x2a, 0x3e, 0x78, 0x40, 0x31, 0x67, 0x99,
      0xb5, 0x48, 0xf1, 0x43, 0x39, 0xcf, 0x7b, 0x46, 0xcc, 0xff, 0xd6, 0x6e,
      0x59, 0x6b, 0x08, 0x79, 0x78, 0x2f, 0x86, 0x38, 0xb9, 0x75, 0xa8, 0x9e,
      0xdc, 0x2b, 0x23, 0x55, 0xf0, 0x5c, 0x53, 0x84, 0x50, 0x78, 0x50, 0x2d,
      0x04, 0x6b, 0x7f, 0x43, 0x71, 0xbd, 0xf9, 0x11, 0xe3, 0x03, 0x02, 0xfa,
      0x98, 0x0f, 0xef, 0xb4, 0x39, 0x73, 0x73, 0x33, 0xfa, 0x9c, 0x17, 0x9c,
      0x33, 0xa9, 0x8e, 0x1b, 0x05, 0x2d, 0xa7, 0xda, 0x24, 0x36, 0xe8, 0xb8,
      0x62, 0xee, 0x5f, 0x7c, 0x63, 0xc8, 0x8a, 0xb7, 0x51, 0xa2, 0x44, 0x70,
      0x5c, 0x8b, 0xd1, 0xf3, 0x2c, 0x27, 0x7e, 0x0a, 0x7c, 0x80, 0xef, 0x30,
      0x2b, 0xd0, 0x1c, 0x9f, 0xd5, 0x0c, 0x9b, 0x7b, 0x63, 0x95, 0x04, 0x4c,
      0x72, 0x46, 0x1d, 0xc6, 0x9a, 0xea, 0x54, 0x9e, 0x37, 0x85, 0x8b, 0x8b,
      0x53, 0xb2, 0x79, 0x22, 0x38, 0xf5, 0x94, 0x45, 0x68, 0x4e, 0x55, 0x1e,
      0x52, 0xe0, 0x87, 0x50},
     {0x61, 0x0c, 0x54, 0x9c, 0xe7, 0x17, 0x74, 0x9d, 0x31, 0x43, 0xcb, 0xd9,
      0x6c, 0x51, 0xc1, 0xc7, 0x58, 0x85, 0xa5, 0xd2, 0x00, 0x00, 0x00, 0x00},
     priv_key_0,
     true},

    // Comment: em has a large hamming weight
    // tcID: 32
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     32,
     {0xf0, 0x32, 0xef, 0x27, 0x59, 0xde, 0x94, 0x6b, 0x6c, 0xcf, 0x82, 0x96,
      0x95, 0xa9, 0x43, 0x8e, 0x5f, 0x98, 0x6f, 0xdb, 0xbf, 0x33, 0x32, 0x62,
      0xa7, 0x95, 0xff, 0x9e, 0xde, 0x84, 0x2b, 0xb7, 0xb1, 0x53, 0xc5, 0x26,
      0xab, 0xd1, 0xea, 0x49, 0x8f, 0x56, 0xe9, 0x92, 0xbd, 0x21, 0x55, 0x8c,
      0x7c, 0x3b, 0x64, 0x34, 0xe4, 0xc6, 0x67, 0xcc, 0xd1, 0x66, 0x87, 0xed,
      0xdc, 0x19, 0x9b, 0xba, 0xa5, 0x95, 0x47, 0xe0, 0x65, 0xa8, 0xa3, 0x81,
      0x4c, 0xd5, 0xea, 0x46, 0xd7, 0x43, 0x7c, 0x1d, 0x6b, 0xdd, 0x8f, 0x1a,
      0x72, 0xee, 0x5e, 0x94, 0x5a, 0x2b, 0x1f, 0x11, 0xda, 0x20, 0x49, 0xa6,
      0x85, 0xdd, 0xb5, 0x25, 0xda, 0x74, 0x22, 0x60, 0xa2, 0x0c, 0xe5, 0x2f,
      0x95, 0x75, 0x5b, 0x8d, 0x7b, 0x5d, 0x29, 0xdf, 0xe7, 0xf5, 0x53, 0x95,
      0xc6, 0x20, 0x3c, 0x51, 0x8d, 0x5f, 0x45, 0xae, 0x74, 0x35, 0xfb, 0xc1,
      0x9e, 0xfb, 0x7f, 0xa9, 0xd2, 0xe1, 0x62, 0x6c, 0xd6, 0x55, 0xd4, 0x09,
      0xe3, 0x5f, 0xdc, 0x4e, 0x8b, 0x57, 0x73, 0x96, 0x5d, 0x9d, 0xb7, 0x26,
      0xaf, 0xa4, 0x0a, 0x73, 0xcb, 0x21, 0x2b, 0x60, 0x67, 0x8b, 0xbc, 0x7a,
      0x04, 0x17, 0xb9, 0x4d, 0x97, 0xe0, 0x3c, 0x27, 0x3c, 0x8e, 0xe2, 0xec,
      0x49, 0xf2, 0x3f, 0x57, 0x57, 0x6a, 0xb3, 0xbc, 0xe5, 0x68, 0xfa, 0x2a,
      0x10, 0x80, 0xf0, 0xf0, 0x36, 0xe6, 0x97, 0x1e, 0xba, 0x8a, 0x77, 0x3b,
      0x40, 0x5b, 0xa2, 0xc5, 0xba, 0x65, 0x64, 0xa4, 0x28, 0x9a},
     {0x58, 0xa4, 0xe1, 0x90, 0xa7, 0x30, 0x6b, 0xcb, 0x33, 0xea, 0x5f, 0x1a,
      0xd8, 0x3b, 0x74, 0xda, 0x56, 0xe3, 0xde, 0xbd, 0x2b, 0x2f, 0xb4, 0x49,
      0x9e, 0xa9, 0x33, 0x93, 0x79, 0xb0, 0xf0, 0x81, 0x17, 0xc7, 0x7b, 0x4d,
      0x5c, 0xa6, 0xdd, 0x1a, 0xd5, 0x1a, 0x4c, 0xea, 0x4b, 0x81, 0x8c, 0x27,
      0x03, 0x44, 0x98, 0x00, 0x77, 0x67, 0x4c, 0x8b, 0xf6, 0xe8, 0xa5, 0xce,
      0x5a, 0xb6, 0x21, 0x2d, 0xdc, 0xab, 0xcd, 0x53, 0xbe, 0x82, 0x67, 0x2f,
      0x19, 0xd5, 0x35, 0xde, 0xbf, 0x66, 0xbf, 0x85, 0x35, 0x38, 0xd1, 0x63,
      0xb6, 0x12, 0x84, 0x68, 0xfa, 0x21, 0xbd, 0x44, 0x64, 0xe8, 0x4f, 0xbf,
      0xa9, 0x25, 0x01, 0xad, 0x51, 0xbb, 0x1b, 0xf7, 0xe1, 0x4f, 0xf5, 0x22,
      0xec, 0xfd, 0x65, 0xa2, 0x9e, 0x08, 0xef, 0x23, 0xaa, 0xe0, 0x12, 0x18,
      0xd7, 0x63, 0x59, 0x15, 0xf8, 0x37, 0x20, 0x55, 0xe0, 0xc6, 0xa2, 0xed,
      0x1d, 0xe6, 0x15, 0x11, 0x48, 0x4b, 0xd6, 0xc3, 0x22, 0x86, 0xa2, 0x3a,
      0x9e, 0xb2, 0xf1, 0x99, 0x97, 0x08, 0xe8, 0xed, 0x5e, 0x28, 0x51, 0x68,
      0x74, 0x24, 0x1e, 0xb7, 0x78, 0x71, 0x3a, 0x84, 0x52, 0x41, 0x15, 0x1a,
      0x94, 0x6c, 0x50, 0x9c, 0x07, 0xe4, 0xd2, 0x7c, 0x16, 0x7b, 0x7b, 0x5e,
      0xf6, 0xf7, 0xa4, 0xf1, 0xfa, 0xdf, 0x90, 0x49, 0x99, 0x6e, 0xab, 0x17,
      0xd9, 0x7e, 0xf4, 0xd2, 0x25, 0x50, 0x64, 0x90, 0x60, 0x69, 0x2a, 0xf6,
      0x3f, 0xd0, 0x6d, 0x05, 0xc7, 0x6f, 0x31, 0x91, 0x68, 0x91, 0x58, 0x32,
      0x36, 0x05, 0x58, 0x26, 0x96, 0x72, 0x9d, 0xb7, 0xd9, 0x4f, 0x73, 0x0e,
      0x51, 0x07, 0xd0, 0xd5, 0x85, 0xce, 0xa5, 0x61, 0x60, 0x96, 0x8a, 0x88,
      0x7a, 0xb4, 0x2b, 0xee, 0x7f, 0xd4, 0xf9, 0xff, 0xd1, 0x44, 0x9f, 0x02,
      0x1a, 0x3d, 0x41, 0xab},
     {0xa0, 0xa0, 0xb4, 0x80, 0x32, 0x70, 0x73, 0xf0, 0x80, 0xfc, 0x1e, 0xfd,
      0x8c, 0xf5, 0xbe, 0x9b, 0xfc, 0xef, 0xd3, 0xa0, 0x00, 0x00, 0x00, 0x00},
     priv_key_0,
     true},

    // Comment: em has a large hamming weight
    // tcID: 33
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     33,
     {0xa4, 0x72, 0xbb, 0xae, 0x5a, 0x81, 0xe6, 0x50, 0x0a, 0xfc, 0x18, 0x3d,
      0x8b, 0xd1, 0xce, 0xec, 0x79, 0x5f, 0x49, 0x07, 0xc4, 0x96, 0x83, 0x0b,
      0xff, 0x4a, 0x9f, 0x3b, 0x15, 0xf1, 0x76, 0x87, 0x24, 0xce, 0xc8, 0xd2,
      0x88, 0xd1, 0xd1, 0x1f, 0x47, 0x52, 0x95, 0x38, 0xcd, 0xf9, 0x3f, 0x76,
      0x99, 0x17, 0xaf, 0xd6, 0x5d, 0x03, 0x3d, 0x4f, 0x56, 0x3c, 0xc1, 0x4f,
      0x6d, 0xd3, 0x9a, 0x8e, 0x7e, 0x03, 0xaf, 0xde, 0x9e, 0xb3, 0x74, 0xb9,
      0x17, 0x7f, 0x5b, 0xed, 0x74, 0xeb, 0xcb, 0xf7, 0x71, 0xf6, 0x30, 0xa1,
      0xb3, 0x07, 0x5d, 0x0a, 0x30, 0x8c, 0xe6, 0x54, 0x24, 0x38, 0x63, 0x04,
      0x39, 0x6e, 0x82, 0x45, 0x28, 0xde, 0xed, 0x8a, 0x2a, 0xc7, 0xa3, 0x87,
      0xf7, 0xa3, 0xee, 0xc3, 0xb6, 0x33, 0x88, 0x2c, 0x92, 0xe9, 0xc3, 0x3e,
      0xba, 0x9a, 0x91, 0xf9, 0x29, 0x7d, 0xd6, 0xae, 0xef, 0x37, 0xa5, 0xd4,
      0x75, 0xd1, 0x0f, 0xe6, 0x9e, 0x0b, 0x12, 0x64, 0xfc, 0x2e, 0xa1, 0xcb,
      0x45, 0xab, 0x4f, 0x1c, 0x69, 0x08, 0xce, 0xda, 0xc2, 0x76, 0x18, 0x3a,
      0xde, 0xe1, 0xf6, 0x0d, 0xa7, 0xcc, 0x1a, 0x10, 0x5e, 0xd5, 0xef, 0x18,
      0x7c, 0x2b, 0x11, 0x74, 0x8e, 0x98, 0xc8, 0xa9, 0x3a, 0xf9, 0x68, 0x3d,
      0x44, 0x1a, 0x30, 0x88, 0xcb, 0x0a, 0xa6, 0x69, 0xb0, 0x6d, 0xb1, 0x51,
      0xe7, 0x15, 0x13, 0x71, 0xd0, 0x27, 0x3e, 0x2e, 0xcb, 0x16, 0x1c, 0x8f,
      0xa6, 0x9d, 0x4e, 0x56, 0x66, 0x66, 0x81, 0xc6, 0x43, 0x9b},
     {0x52, 0x63, 0x52, 0xba, 0x3b, 0x50, 0xba, 0x16, 0x0f, 0x05, 0xb9, 0xb7,
      0x60, 0x4a, 0xbd, 0x50, 0x8e, 0x74, 0x4e, 0x17, 0x6f, 0x99, 0xf5, 0xed,
      0x5f, 0xa4, 0x78, 0x69, 0xdb, 0xf2, 0x20, 0xf3, 0x2f, 0xa4, 0x3f, 0x79,
      0x42, 0xa8, 0x95, 0x1a, 0x75, 0x50, 0x5a, 0x58, 0x00, 0xf8, 0xf4, 0x92,
      0x33, 0xd5, 0x77, 0x78, 0xea, 0x9d, 0xd5, 0x22, 0x0b, 0xbe, 0xce, 0xf1,
      0x5d, 0x38, 0xdd, 0x74, 0x00, 0xba, 0x81, 0xff, 0x4c, 0xd5, 0x08, 0x5d,
      0x2d, 0x20, 0xaf, 0x7c, 0xe7, 0x9f, 0x09, 0x7e, 0xc0, 0x8c, 0xe2, 0xa8,
      0xdb, 0xab, 0x44, 0x82, 0x67, 0x5f, 0xf0, 0x8b, 0xda, 0x80, 0xc7, 0x40,
      0x78, 0xa4, 0x4c, 0xd8, 0x9a, 0xf5, 0x47, 0xa3, 0x56, 0xcd, 0x21, 0xbb,
      0x4b, 0xe5, 0x2a, 0x0c, 0xc5, 0xda, 0xd5, 0xbc, 0x77, 0x9b, 0x54, 0xfb,
      0xad, 0x60, 0xd1, 0x5f, 0x10, 0xca, 0x79, 0xd2, 0x5e, 0x82, 0xf1, 0x9d,
      0x9d, 0xbf, 0xff, 0x7e, 0xcc, 0x1c, 0xcc, 0xd8, 0x37, 0x45, 0x82, 0xbe,
      0xf1, 0xd4, 0xbc, 0x3f, 0xa7, 0x45, 0x25, 0x9d, 0xca, 0xec, 0xc5, 0x6b,
      0x8f, 0x16, 0x2f, 0x7d, 0x40, 0x63, 0xaa, 0x2c, 0x99, 0xed, 0x8f, 0x41,
      0x8f, 0x2a, 0xa5, 0x65, 0x8d, 0xf7, 0xd1, 0xf3, 0x60, 0x41, 0x88, 0x3b,
      0x44, 0x84, 0xac, 0x67, 0x66, 0xb0, 0x59, 0x94, 0x89, 0x60, 0xfa, 0x2e,
      0x40, 0x36, 0x3c, 0x6c, 0x56, 0x24, 0x23, 0x96, 0x80, 0x9f, 0x4b, 0x03,
      0x6f, 0xd9, 0x1d, 0x46, 0xde, 0x8e, 0xb0, 0x53, 0xc8, 0xcb, 0x02, 0x97,
      0x78, 0x41, 0x20, 0x26, 0x4c, 0x6a, 0xc7, 0xe3, 0x59, 0xf4, 0xad, 0x5e,
      0xc6, 0x5a, 0x00, 0x26, 0x44, 0xc0, 0x3c, 0xfc, 0x16, 0x6a, 0x8e, 0x5a,
      0x01, 0x9b, 0x82, 0x36, 0xc7, 0xd7, 0x14, 0x5d, 0xf2, 0x47, 0xcd, 0x12,
      0x3a, 0x09, 0xc8, 0xc2},
     {0xbb, 0xa0, 0xb4, 0x80, 0x32, 0x70, 0x73, 0xf0, 0x80, 0xfc, 0x1e, 0xfd,
      0x8c, 0xf5, 0xbe, 0x9b, 0xfc, 0xef, 0xd3, 0xa0, 0x00, 0x00, 0x00, 0x00},
     priv_key_0,
     true},

    // Comment: em has a large hamming weight
    // tcID: 34
    {SEC_OID_SHA1,
     CKG_MGF1_SHA1,
     34,
     {0x6d, 0x5c, 0x2c, 0xb5, 0x79, 0x08, 0x75, 0x72, 0x8f, 0xb2, 0x1e, 0x98,
      0x72, 0x78, 0xfd, 0xd1, 0xd8, 0x81, 0xcf, 0x49, 0x53, 0xe6, 0x28, 0x66,
      0xf8, 0xd5, 0x3e, 0xbb, 0x06, 0x7c, 0xf9, 0xa4, 0xef, 0x53, 0x21, 0x80,
      0x30, 0xe3, 0xec, 0xa6, 0x73, 0x2a, 0x6b, 0x1f, 0x78, 0x9c, 0xdf, 0x3c,
      0xc7, 0x11, 0xb6, 0x06, 0x3a, 0x01, 0xf4, 0x24, 0xb3, 0x88, 0x90, 0x55,
      0x49, 0x66, 0x37, 0x69, 0xdc, 0xdc, 0xbd, 0xd8, 0x2d, 0xeb, 0x6b, 0xc2,
      0x3f, 0x66, 0xc1, 0xc0, 0x4d, 0x30, 0xc6, 0xd9, 0x1f, 0xd6, 0x11, 0x6b,
      0xdf, 0x88, 0x02, 0xc1, 0x50, 0xfe, 0xd3, 0x96, 0x56, 0x2e, 0xdd, 0x21,
      0xca, 0x60, 0x65, 0x28, 0xcd, 0x40, 0xb5, 0x69, 0xe8, 0x95, 0xc8, 0xad,
      0x5b, 0xd1, 0xbd, 0x58, 0x48, 0xa2, 0x15, 0x50, 0x15, 0x37, 0xdc, 0xcb,
      0xd0, 0xfc, 0xd7, 0x0c, 0xf3, 0xb2, 0xd0, 0xdf, 0x58, 0xa0, 0x72, 0xe0,
      0x7f, 0x60, 0xff, 0x76, 0x4c, 0x46, 0x88, 0xc3, 0x72, 0x40, 0x86, 0x32,
      0x42, 0xf6, 0xea, 0xfe, 0x36, 0x60, 0x1d, 0xfc, 0xda, 0x41, 0xeb, 0x86,
      0x3f, 0x4d, 0xb7, 0x01, 0xde, 0x54, 0x78, 0x1a, 0x6d, 0x53, 0xa9, 0x79,
      0x32, 0xd3, 0x2a, 0xae, 0x0e, 0x6a, 0x52, 0x60, 0x48, 0xf7, 0x66, 0x90,
      0x21, 0x28, 0xb4, 0x84, 0x20, 0x68, 0xfa, 0xd9, 0xab, 0x10, 0x81, 0x1c,
      0xe9, 0x33, 0x39, 0xad, 0x42, 0xf2, 0xe1, 0x3c, 0x4c, 0xec, 0x32, 0x4a,
      0x8c, 0xf7, 0x03, 0x57, 0x05, 0xb8, 0xa3, 0x6f, 0xd8, 0xa7},
     {0x6a, 0xb9, 0x2b, 0x1c, 0x57, 0xf9, 0x9c, 0x17, 0xae, 0x4c, 0xa5, 0xf7,
      0xd4, 0xc0, 0x14, 0x9e, 0xb2, 0x4c, 0xb1, 0x8a, 0xaf, 0x36, 0x16, 0x38,
      0x59, 0xe1, 0x18, 0x6d, 0xcb, 0xaf, 0xee, 0xda, 0x4d, 0x77, 0xfd, 0x05,
      0x9b, 0x0f, 0x93, 0x8e, 0x92, 0xb8, 0xd4, 0x13, 0xb7, 0x71, 0x85, 0x2f,
      0xb0, 0x19, 0xa6, 0x6d, 0x76, 0x00, 0x94, 0x44, 0x60, 0x5e, 0xdd, 0x5f,
      0xb4, 0x8e, 0x6e, 0xeb, 0xbd, 0x9d, 0x01, 0x82, 0x7b, 0xe7, 0x32, 0x29,
      0x2c, 0xb0, 0x7c, 0xde, 0x54, 0x1d, 0xce, 0x13, 0x89, 0x90, 0xd4, 0x65,
      0x99, 0xb5, 0xa1, 0x96, 0x52, 0x5a, 0xf1, 0x99, 0xad, 0x4a, 0xdf, 0x7c,
      0x25, 0x91, 0x09, 0xe7, 0x15, 0xe5, 0x63, 0xd8, 0x97, 0x4c, 0xbb, 0xea,
      0xe6, 0x2a, 0x53, 0xc8, 0x13, 0x70, 0x76, 0xf1, 0x07, 0x31, 0xa9, 0x64,
      0xf2, 0xce, 0x37, 0x30, 0x5a, 0x17, 0x5d, 0x35, 0xeb, 0x7c, 0x8e, 0x6e,
      0x72, 0xc9, 0x79, 0x26, 0x31, 0xd3, 0x51, 0x33, 0xdc, 0xd4, 0x9f, 0x1a,
      0x1d, 0xa6, 0x77, 0xab, 0x3a, 0xc0, 0x74, 0x17, 0x27, 0x78, 0x40, 0x2a,
      0x41, 0x76, 0xc0, 0x36, 0xcd, 0x8a, 0xc5, 0x67, 0x47, 0x70, 0xf1, 0x71,
      0xd9, 0x13, 0x45, 0x85, 0xa1, 0x15, 0xf6, 0xa0, 0x98, 0x3d, 0x60, 0x6b,
      0x74, 0x8e, 0x0e, 0x47, 0xbe, 0x04, 0x0a, 0xcd, 0xa8, 0x8c, 0xc5, 0xb8,
      0xc7, 0xea, 0xdd, 0x33, 0x16, 0x21, 0x17, 0xbb, 0x61, 0xf4, 0x9c, 0xac,
      0xe9, 0x12, 0x60, 0xc5, 0xe2, 0xc8, 0xef, 0x4d, 0xbc, 0xec, 0x7f, 0x15,
      0x6a, 0x18, 0x89, 0x4a, 0x2b, 0xed, 0x99, 0x56, 0x52, 0x0b, 0x2b, 0x68,
      0x1b, 0x2f, 0xa3, 0x13, 0x47, 0xdf, 0x7e, 0xa9, 0x80, 0x62, 0xd9, 0x7f,
      0x29, 0x72, 0x28, 0x0b, 0xe2, 0x2e, 0x50, 0x72, 0x49, 0xb2, 0x43, 0x6a,
      0x9a, 0xb9, 0x16, 0x89},
     {0x7f, 0xa0, 0xb4, 0x80, 0x32, 0x70, 0x73, 0xf0, 0x80, 0xfc, 0x1e, 0xfd,
      0x8c, 0xf5, 0xbe, 0x9b, 0xfc, 0xef, 0xd3, 0xa0, 0x00, 0x00, 0x00, 0x00},
     priv_key_0,
     true}};

#endif  // rsa_oaep_2048_sha1_mgf1sha1_vectors_h__
