# An minimal example showing how to use the python doxmlparser module to read
# the XML output generated by doxygen for a project and dump it to the output again.

import sys

import doxmlparser

# process a compound file and export the results to stdout
def parse_compound(inDirName,baseName):
    doxmlparser.compound.parse(inDirName+"/"+baseName+".xml",False)

# process the index file and export the results to stdout
def parse_index(inDirName):
    rootObj = doxmlparser.index.parse(inDirName+"/index.xml",False)
    for compound in rootObj.get_compound(): # for each compound defined in the index
        parse_compound(inDirName,compound.get_refid())

def usage():
    print("Usage {0} <xml_output_dir>".format(sys.argv[0]))
    sys.exit(1)

def main():
    args = sys.argv[1:]
    if len(args)==1:
        parse_index(args[0])
    else:
        usage()

if __name__ == '__main__':
    main()

