#ifndef __SI86XX_PROPS_H__
#define __SI86XX_PROPS_H__

char *si46xx_property_name(int id, int mode);

/* common */
#define INT_CTL_ENABLE	0x0000
#define INT_CTL_REPEAT	0x0001
#define DIGITAL_IO_OUTPUT_SELECT	0x0200
#define DIGITAL_IO_OUTPUT_SAMPLE_RATE	0x0201
#define DIGITAL_IO_OUTPUT_FORMAT	0x0202
#define DIGITAL_IO_OUTPUT_SAMPLE_RATE	0x0201
#define DIGITAL_IO_OUTPUT_FORMAT	0x0202
#define DIGITAL_IO_OUTPUT_FORMAT_OVERRIDES_1	0x0203
#define DIGITAL_IO_OUTPUT_FORMAT_OVERRIDES_2	0x0204
#define DIGITAL_IO_OUTPUT_FORMAT_OVERRIDES_3	0x0205
#define DIGITAL_IO_OUTPUT_FORMAT_OVERRIDES_4	0x0206
#define AUDIO_ANALOG_VOLUME	0x0300
#define AUDIO_MUTE	0x0301
#define PIN_CONFIG_ENABLE	0x0800

/* FM */
#define FM_TUNE_FE_VARM			0x1710
#define FM_TUNE_FE_VARB			0x1711
#define FM_TUNE_FE_CFG			0x1712
#define FM_SEEK_BAND_BOTTOM		0x3100
#define FM_SEEK_BAND_TOP		0x3101
#define FM_SEEK_FREQUENCY_SPACING	0x3102
#define FM_VALID_MAX_TUNE_ERROR		0x3200
#define FM_VALID_RSSI_TIME		0x3201
#define FM_VALID_RSSI_THRESHOLD		0x3202
#define FM_VALID_SNR_TIME		0x3203
#define FM_VALID_SNR_THRESHOLD		0x3204
#define FM_RSQ_INTERRUPT_SOURCE		0x3300
#define FM_RSQ_SNR_HIGH_THRESHOLD	0x3301
#define FM_RSQ_SNR_LOW_THRESHOLD	0x3302
#define FM_RSQ_RSSI_HIGH_THRESHOLD	0x3303
#define FM_RSQ_RSSI_LOW_THRESHOLD	0x3304
#define FM_RSQ_HD_DETECTION		0x3307
#define FM_ACF_INTERRUPT_SOURCE		0x3400
#define FM_ACF_SOFTMUTE_THRESHOLD	0x3401
#define FM_ACF_HIGHCUT_THRESHOLD	0x3402
#define FM_ACF_BLEND_THRESHOLD		0x3403
#define FM_ACF_SOFTMUTE_TOLERANCE	0x3404
#define FM_ACF_HIGHCUT_TOLERANCE	0x3405
#define FM_ACF_BLEND_TOLERANCE		0x3406
#define FM_SOFTMUTE_SNR_LIMITS		0x3500
#define FM_SOFTMUTE_SNR_ATTENUATION	0x3501
#define FM_SOFTMUTE_SNR_ATTACK_TIME	0x3502
#define FM_SOFTMUTE_SNR_RELEASE_TIME	0x3503
#define FM_HIGHCUT_RSSI_LIMITS		0x3600
#define FM_HIGHCUT_RSSI_CUTOFF_FREQ	0x3601
#define FM_HIGHCUT_RSSI_ATTACK_TIME	0x3602
#define FM_HIGHCUT_RSSI_RELEASE_TIME	0x3603
#define FM_HIGHCUT_SNR_LIMITS		0x3604
#define FM_HIGHCUT_SNR_CUTOFF_FREQ	0x3605
#define FM_HIGHCUT_SNR_ATTACK_TIME	0x3606
#define FM_HIGHCUT_SNR_RELEASE_TIME	0x3607
#define FM_HIGHCUT_MULTIPATH_LIMITS	0x3608
#define FM_HIGHCUT_MULTIPATH_CUTOFF_FREQ	0x3609
#define FM_HIGHCUT_MULTIPATH_ATTACK_TIME	0x360A
#define FM_HIGHCUT_MULTIPATH_RELEASE_TIME	0x360B
#define FM_BLEND_RSSI_LIMITS		0x3700
#define FM_BLEND_RSSI_ATTACK_TIME	0x3702
#define FM_BLEND_RSSI_RELEASE_TIME	0x3703
#define FM_BLEND_SNR_LIMITS		0x3704
#define FM_BLEND_SNR_ATTACK_TIME	0x3706
#define FM_BLEND_SNR_RELEASE_TIME	0x3707
#define FM_BLEND_MULTIPATH_LIMITS	0x3708
#define FM_BLEND_MULTIPATH_ATTACK_TIME	0x370A
#define FM_BLEND_MULTIPATH_RELEASE_TIME	0x370B
#define FM_AUDIO_DE_EMPHASIS		0x3900
#define FM_RDS_INTERRUPT_SOURCE		0x3C00
#define FM_RDS_INTERRUPT_FIFO_COUNT	0x3C01
#define FM_RDS_CONFIG			0x3C02
#define FM_RDS_CONFIDENCE		0x3C03
#define DIGITAL_SERVICE_INT_SOURCE	0x8100
#define HD_BLEND_OPTIONS		0x9101
#define HD_BLEND_ANALOG_TO_HD_TRANSITION_TIME	0x9102
#define HD_BLEND_HD_TO_ANALOG_TRANSITION_TIME	0x9103
#define HD_BLEND_DYNAMIC_GAIN		0x9106
#define HD_DIGRAD_INTERRUPT_SOURCE	0x9200
#define HD_DIGRAD_CDNR_LOW_THRESHOLD	0x9201
#define HD_DIGRAD_CDNR_HIGH_THRESHOLD	0x9202
#define HD_DIGRAD_AUTO_ACQUIRE		0x9203
#define HD_EVENT_INTERRUPT_SOURCE	0x9300
#define HD_EVENT_SIS_CONFIG		0x9301
#define HD_EVENT_ALERT_CONFIG		0x9302
#define HD_PSD_ENABLE			0x9500
#define HD_PSD_FIELD_MASK		0x9501
#define HD_AUDIO_CTRL_FRAME_DELAY	0x9700
#define HD_AUDIO_CTRL_PROGRAM_LOSS_THRESHOLD	0x9701
#define HD_AUDIO_CTRL_BALL_GAME_ENABLE	0x9702
#define HD_CODEC_MODE_0_SAMPLES_DELAY	0x9901
#define HD_CODEC_MODE_2_SAMPLES_DELAY	0x9904
#define HD_CODEC_MODE_10_SAMPLES_DELAY	0x9907
#define HD_CODEC_MODE_13_SAMPLES_DELAY	0x990A
#define HD_TEST_BER_CONFIG		0xE800
#define HD_TEST_DEBUG_AUDIO		0xE801

/*flash */
#define BL_SPI_CLOCK_FREQ_KHZ		0x0001
#define BL_SPI_MODE			0x0002
#define BL_READ_CMD			0x0101
#define BL_HIGH_SPEED_READ_CMD		0x0102
#define BL_HIGH_SPEED_READ_MAX_FREQ_MHZ	0x0103
#define BL_WRITE_CMD			0x0201
#define BL_ERASE_SECTOR_CMD		0x0202
#define BL_ERASE_CHIP_CMD		0x0204

#endif //__SI86XX_PROPS_H__
