'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbChangeControls __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbChangeControls \- Provides a flexible method for updating the controls in a 
server to match those in 
the changed keyboard description
.SH SYNOPSIS
.HP
.B Bool XkbChangeControls
.BI "(\^Display *" "dpy" "\^,"
.BI "XkbDescPtr " "xkb" "\^,"
.BI "XkbControlsChangesPtr " "changes" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- xkb
keyboard description with changed xkb->ctrls
.TP
.I \- changes
which parts of xkb->ctrls have changed
.SH DESCRIPTION
.LP
The XkbControlsChangesRec structure allows applications to track modifications 
to an XkbControlsRec 
structure and thereby reduce the amount of traffic sent to the server. The same 
XkbControlsChangesRec 
structure may be used in several successive modifications to the same 
XkbControlsRec structure, then 
subsequently used to cause all of the changes, and only the changes, to be 
propagated to the server. 

The 
.I changed_ctrls 
field is a mask specifying which logical sets of data in the controls structure 
have been modified. In 
this context, modified means 
.I set, 
that is, if a value is set to the same value it previously contained, it has 
still been modified, and is 
noted as changed. Valid values for 
.I changed_ctrls 
are any combination of the masks listed in Table 1 that have "ok" in the 
.I changed_ctrls 
column. Setting a bit implies the corresponding data fields from the "Relevant 
XkbControlsRec Data 
Fields" column in Table 1 have been modified. The 
.I enabled_ctrls_changes 
field specifies which bits in the 
.I enabled_ctrls 
field have changed. If the number of keyboard groups has changed, the 
.I num_groups_changed 
field is set to True.

Table 1 shows the actual values for the individual mask bits used to select 
controls for 
modification and to enable and disable the control. Note that the same mask bit 
is used to 
specify general modifications to the parameters used to configure the control 
(which), and to 
enable and disable the control (enabled_ctrls). The anomalies in the table (no 
"ok" in column) 
are for controls that have no configurable attributes; and for controls that are 
not boolean 
controls and therefore cannot be enabled or disabled.

.TS
c s s s s
l l l l l
l l l l l
l l l l l
l l l l l
lw(1.5i) lw(1.5i) l lw(1.5i) l.
Table 1 Xkb Controls
_
Control	Control			
	Selection	Relevant		
	Mask (which	XkbControlsRec	Boolean Control	
	parameter)	DataFields	enabled_ctrls bit	Section
_
T{
AccessXFeedback
T}	T{
XkbAccessX\%FeedbackMask
T}	T{
ax_options:
  XkbAX_*FBMask
T}	T{
XkbAccessX\%FeedbackMask
T}	10.6.3
T{
AccessXKeys
T}			T{
XkbAccessX\%Keys\%Mask
T}	10.6.1
T{
AccessX\%Timeout
T}	T{
XkbAccessX\%Timeout\%Mask
T}	T{
ax_timeout
axt_opts_mask
axt_opts_values
axt_ctrls_mask
axt_ctrls_values
T}	T{
XkbAccessX\%Timeout\%Mask
T}	10.6.2
T{
AudibleBell
T}			T{
XkbAudible\%Bell\%Mask
T}	9.2
T{
AutoReset
T}				10.1.2
T{
BounceKeys
T}	T{
XkbBounce\%KeysMask
T}	debounce_delay	T{
XkbBounce\%KeysMask
T}	10.6.7
T{
Detectable-
T}				10.3.3
T{
Autorepeat
T}
T{
EnabledControls
T}	T{
XkbControls\%EnabledMask
T}	enabled_ctrls	T{
Non-Boolean \%Control
T}	10.1.1
T{
GroupsWrap
T}	T{
XkbGroups\%Wrap\%Mask
T}	groups_wrap	T{
Non-Boolean \%Control
T}	10.7.1
T{
IgnoreGroupLock
T}			T{
XkbIgnore\%GroupLock\%Mask
T}	10.7.3
T{
IgnoreLockMods
T}	T{
XkbIgnore\%LockMods\%Mask
T}	ignore_lock	T{
Non-Boolean \%Control
T}	5.1
T{
InternalMods
T}	T{
XkbInternal\%Mods\%Mask
T}	internal	T{
Non-Boolean \%Control
T}	5.1
T{
MouseKeys
T}	T{
XkbMouseKeysMask
T}	mk_dflt_btn	T{
XkbMouseKeysMask
T}	10.5.1
T{
MouseKeysAccel
T}	T{
XkbMouseKeys\%Accel\%Mask
T}	T{
mk_delay
mk_interval
mk_time_to_max
mk_max_speed
mk_curve
T}	T{
XkbMouseKeys\%Accel\%Mask
T}	10.5.2
T{
Overlay1
T}			T{
XkbOverlay1Mask
T}	10.4
T{
Overlay2
T}			T{
XkbOverlay2Mask
T}	10.4
T{
PerKeyRepeat
T}	T{
XkbPerKey\%Repeat\%Mask
T}	per_key_repeat	T{
Non-Boolean \%Control
T}	10.3.1
T{
RepeatKeys
T}	T{
Xkb\%Repeat\%Keys\%Mask
T}	repeat_delay	T{
Xkb\%Repeat\%Keys\%Mask
T}	10.3
			repeat_interval
T{
SlowKeys
T}	T{
Xkb\%Slow\%Keys\%Mask
T}	slow_keys_delay	T{
Xkb\%Slow\%Keys\%Mask
T}	10.6.6
T{
StickyKeys
T}	T{
Xkb\%Sticky\%Keys\%Mask
T}	T{
ax_options:
  XkbAX_TwoKeysMask
  XkbAX_LatchToLockMask
T}	T{
Xkb\%Sticky\%Keys\%Mask
T}	10.6.8
.TE

Table 2 shows the actual values for the individual mask bits used to select 
controls for 
modification and to enable and disable the control. Note that the same mask bit 
is used to 
specify general modifications to the parameters used to configure the control 
(which), and to 
enable and disable the control (enabled_ctrls). The anomalies in the table (no 
"ok" in column) 
are for controls that have no configurable attributes; and for controls that are 
not boolean 
controls and therefore cannot be enabled or disabled.

.TS
c s s s
l l l l
l l l l
l l l l. 
Table 2 Controls Mask Bits
_
Mask Bit	which or		Value
	changed	enabled
	_ctrls	_ctrls
_
XkbRepeatKeysMask	ok	ok	(1L<<0)
XkbSlowKeysMask	ok	ok	(1L<<1)
XkbBounceKeysMask	ok	ok	(1L<<2)
XkbStickyKeysMask	ok	ok	(1L<<3)
XkbMouseKeysMask	ok	ok	(1L<<4)
XkbMouseKeysAccelMask	ok	ok	(1L<<5)
XkbAccessXKeysMask	ok	ok	(1L<<6)
XkbAccessXTimeoutMask	ok	ok	(1L<<7)
XkbAccessXFeedbackMask	ok	ok	(1L<<8)
XkbAudibleBellMask		ok	(1L<<9)
XkbOverlay1Mask		ok	(1L<<10)
XkbOverlay2Mask		ok	(1L<<11)
XkbIgnoreGroupLockMask		ok	(1L<<12)
XkbGroupsWrapMask	ok		(1L<<27)
XkbInternalModsMask	ok		(1L<<28)
XkbIgnoreLockModsMask	ok		(1L<<29)
XkbPerKeyRepeatMask	ok		(1L<<30)
XkbControlsEnabledMask	ok		(1L<<31)
XkbAccessXOptionsMask	ok	ok	(XkbStickyKeysMask | 
			XkbAccessXFeedbackMask)
XkbAllBooleanCtrlsMask		ok	(0x00001FFF) 
XkbAllControlsMask	ok		(0xF8001FFF)
.TE




If you have an Xkb description with controls that have been modified and an 
XkbControlsChangesRec that 
describes the changes that have been made, the 
.I XkbChangeControls 
function provides a flexible method for updating the controls in a server to 
match those in the changed 
keyboard description.

.I XkbChangeControls 
copies any controls fields specified by 
.I changes 
from the keyboard description controls structure, 
.I xkb->ctrls, 
to the server specified by 
.I dpy.
.SH STRUCTURES
.LP
The XkbControlsChangesRec structure is defined as follows:
.nf

typedef struct _XkbControlsChanges {
    unsigned int  changed_ctrls;         /\(** bits indicating changed control data 
*/
    unsigned int  enabled_ctrls_changes; /\(** bits indicating enabled/disabled 
controls */
    Bool          num_groups_changed;    /\(** True if number of keyboard groups 
changed */
} XkbControlsChangesRec,*XkbControlsChangesPtr;

.fi
