---
hide-toc: true
---

# Welcome to installer's documentation

```{include} ../README.md
:start-after: <!-- start readme-pitch -->
:end-before: <!-- end readme-pitch -->
```

```{toctree}
:hidden:

concepts
```

```{toctree}
:caption: API reference
:hidden:
:glob:

api/*
```

```{toctree}
:caption: CLI reference
:hidden:
:glob:

cli/*
```

```{toctree}
:caption: Project
:hidden:

development/index
changelog
license
GitHub <https://github.com/pradyunsg/installer>
PyPI <https://pypi.org/project/installer>
```

## Basic Usage

```python
import sys
import sysconfig

from installer import install
from installer.destinations import SchemeDictionaryDestination
from installer.sources import WheelFile

# Handler for installation directories and writing into them.
destination = SchemeDictionaryDestination(
    sysconfig.get_paths(),
    interpreter=sys.executable,
    script_kind="posix",
)

with WheelFile.open("sampleproject-1.3.1-py2.py3-none-any.whl") as source:
    install(
        source=source,
        destination=destination,
        # Additional metadata that is generated by the installation tool.
        additional_metadata={
            "INSTALLER": b"amazing-installer 0.1.0",
        },
    )
```
