// Code generated by re2c, DO NOT EDIT.
//go:generate re2go $INPUT -o $OUTPUT --loop-switch -i
package main

import "testing"

// Expects a null-terminated string.
func lex(str string) int {
	var cursor, marker int
	limit := len(str) - 1 // limit points at the terminating null
	count := 0
loop:
	
{
	var yych byte
	yystate := 0
yyl:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			switch (yych) {
			case ' ':
				cursor += 1
				yystate = 3
				continue yyl
			case '\'':
				cursor += 1
				yystate = 5
				continue yyl
			default:
				if (limit <= cursor) {
					yystate = 10
					continue yyl
				}
				cursor += 1
				yystate = 1
				continue yyl
			}
		case 1:
			yystate = 2
			continue yyl
		case 2:
			{ return -1 }
		case 3:
			yych = str[cursor]
			switch (yych) {
			case ' ':
				cursor += 1
				yystate = 3
				continue yyl
			default:
				yystate = 4
				continue yyl
			}
		case 4:
			{ goto loop }
		case 5:
			marker = cursor
			yych = str[cursor]
			if (yych >= 0x01) {
				yystate = 7
				continue yyl
			}
			if (limit <= cursor) {
				yystate = 2
				continue yyl
			}
			cursor += 1
			yystate = 6
			continue yyl
		case 6:
			yych = str[cursor]
			yystate = 7
			continue yyl
		case 7:
			switch (yych) {
			case '\'':
				cursor += 1
				yystate = 8
				continue yyl
			case '\\':
				cursor += 1
				yystate = 9
				continue yyl
			default:
				if (limit <= cursor) {
					yystate = 11
					continue yyl
				}
				cursor += 1
				yystate = 6
				continue yyl
			}
		case 8:
			{ count += 1; goto loop }
		case 9:
			yych = str[cursor]
			if (yych <= 0x00) {
				if (limit <= cursor) {
					yystate = 11
					continue yyl
				}
				cursor += 1
				yystate = 6
				continue yyl
			}
			cursor += 1
			yystate = 6
			continue yyl
		case 10:
			{ return count }
		case 11:
			cursor = marker
			yystate = 2
			continue yyl
		default:
			panic("internal lexer error")
		}
	}
}

}

func TestLex(t *testing.T) {
	var tests = []struct {
		res int
		str string
	}{
		{0, "\000"},
		{3, "'qu\000tes' 'are' 'fine: \\'' \000"},
		{-1, "'unterminated\\'\000"},
	}

	for _, x := range tests {
		t.Run(x.str, func(t *testing.T) {
			res := lex(x.str)
			if res != x.res {
				t.Errorf("got %d, want %d", res, x.res)
			}
		})
	}
}
