---
title: Journal Message Catalogs
category: Documentation for Developers
layout: default
SPDX-License-Identifier: LGPL-2.1-or-later
---

# Journal Message Catalogs

Starting with 196 systemd includes a message catalog system which allows augmentation on display of journal log messages with short explanation texts, keyed off the MESSAGE\_ID= field of the entry. Many important log messages generated by systemd itself have message catalog entries. External packages can easily provide catalog data for their own messages.

The message catalog has a number of purposes:

* Provide the administrator, user or developer with further information about the issue at hand, beyond the actual message text
* Provide links to further documentation on the topic of the specific message
* Provide native language explanations for English language system messages
* Provide links for support forums, hotlines or other contacts

## Format

Message catalog source files are simple text files that follow an RFC822 inspired format. To get an understanding of the format [here's an example file](http://cgit.freedesktop.org/systemd/systemd/plain/catalog/systemd.catalog), which includes entries for many important messages systemd itself generates. On installation of a package that includes message catalogs all installed message catalog source files get compiled into a binary index, which is then used to look up catalog data.

journalctl's `-x` command line parameter may be used to augment on display journal log messages with message catalog data when browsing. `journalctl --list-catalog` may be used to print a list of all known catalog entries.

To register additional catalog entries, packages may drop (text) catalog files into /usr/lib/systemd/catalog/ with a suffix of .catalog. The files are not accessed directly when needed, but need to be built into a binary index file with `journalctl --update-catalog`.

Here's an example how a single catalog entry looks like in the text source format. Multiple of these may be listed one after the other per catalog source file:

```
-- fc2e22bc6ee647b6b90729ab34a250b1
Subject: Process @COREDUMP_PID@ (@COREDUMP_COMM@) dumped core
Defined-By: systemd
Support: http://lists.freedesktop.org/mailman/listinfo/systemd-devel
Documentation: man:core(5)
Documentation: http://www.freedesktop.org/wiki/Software/systemd/catalog/@MESSAGE_ID@

Process @COREDUMP_PID@ (@COREDUMP_COMM@) crashed and dumped core.

This usually indicates a programming error in the crashing program and
should be reported to its vendor as a bug.
```


The text format of the .catalog files is as follows:

* Simple, UTF-8 text files, with usual line breaks at 76 chars. URLs and suchlike where line-breaks are undesirable may use longer lines. As catalog files need to be usable on text consoles it is essential that the 76 char line break rule is otherwise followed for human readable text.
* Lines starting with `#` are ignored, and may be used for comments.
* The files consist of a series of entries. For each message ID (in combination with a locale) only a single entry may be defined. Every entry consists of:
    * A separator line beginning with `-- `, followed by a hexadecimal message ID formatted as lower case ASCII string. Optionally, the message ID may be suffixed by a space and a locale identifier, such as `de` or `fr\_FR`, if i10n is required.
    * A series of entry headers, in RFC822-style but not supporting continuation lines. Some header fields may appear more than once per entry. The following header fields are currently known (but additional fields may be added later):
        * Subject: A short, one-line human readable description of the message
        * Defined-By: Who defined this message. Usually a package name or suchlike
        * Support: A URI for getting further support. This can be a web URL or a telephone number in the tel:// namespace
        * Documentation: URIs for further user, administrator or developer documentation on the log entry. URIs should be listed in order of relevance, the most relevant documentation first.
    * An empty line
    * The actual catalog entry payload, as human readable prose. Multiple paragraphs may be separated by empty lines. The prose should first describe the message and when it occurs, possibly followed by recommendations how to deal with the message and (if it is an error message) correct the problem at hand. This message text should be readable by users and administrators. Information for developers should be stored externally instead, and referenced via a Documentation= header field.
* When a catalog entry is printed on screen for a specific log entry simple variable replacements are applied. Journal field names enclosed in @ will be replaced by their values, if such a field is available in an entry. If such a field is not defined in an entry the enclosing @ will be dropped but the variable name is kept. See [systemd's own message catalog](http://cgit.freedesktop.org/systemd/systemd/plain/catalog/systemd.catalog) for a complete example for a catalog file.

## Adding Message Catalog Support to Your Program

Note that the message catalog is only available for messages generated with the MESSAGE\_ID= journal meta data field, as this is need to find the right entry for a message. For more information on the MESSAGE\_ID= journal entry field see [systemd.journal-fields(7)](http://www.freedesktop.org/software/systemd/man/systemd.journal-fields.html).

To add message catalog entries for log messages your application generates, please follow the following guidelines:

* Use the [native Journal logging APIs](http://0pointer.de/blog/projects/journal-submit.html) to generate your messages, and define message IDs for all messages you want to add catalog entries for. You may use `journalctl --new-id128` to allocate new message IDs.
* Write a catalog entry file for your messages and ship them in your package and install them to `/usr/lib/systemd/catalog/` (if you package your software with RPM use `%_journalcatalogdir`)
* Ensure that after installation of your application's RPM/DEB "`journalctl --update-catalog`" is executed, in order to update the binary catalog index. (if you package your software with RPM use the `%journal_catalog_update` macro to achieve that.)
