if(NOT DEFINED PRECISION)
  message(FATAL_ERROR "PRECISION must be specified")
endif()

if(NOT DEFINED WITH_JAVA)
  message(FATAL_ERROR "WITH_JAVA must be specified")
endif()

macro(check_error program)
  if(NOT RESULT EQUAL 0)
    message(FATAL_ERROR "${program} failed.")
  endif()
endmacro()

macro(run_test PROG ARGS)
  string(REPLACE ";" " " SPACED_ARGS "${ARGS}")
  message(STATUS "${PROG} ${SPACED_ARGS}")
  execute_process(COMMAND ${CMAKE_CURRENT_BINARY_DIR}/${PROG} ${ARGS}
    RESULT_VARIABLE RESULT)
  check_error("${PROG} ${SPACED_ARGS}")
endmacro()

if(NOT PRECISION EQUAL 16)
  run_test(tjbenchtest "-precision;${PRECISION}")
  run_test(tjbenchtest "-precision;${PRECISION};-alloc")
endif()
if(PRECISION EQUAL 8)
  run_test(tjbenchtest "-precision;${PRECISION};-yuv")
  run_test(tjbenchtest "-precision;${PRECISION};-yuv;-alloc")
  run_test(tjbenchtest "-precision;${PRECISION};-optimize")
  run_test(tjbenchtest "-precision;${PRECISION};-optimize;-yuv")
endif()
if(NOT PRECISION EQUAL 16)
  run_test(tjbenchtest "-precision;${PRECISION};-progressive")
endif()
if(PRECISION EQUAL 8)
  run_test(tjbenchtest "-precision;${PRECISION};-progressive;-yuv")
endif()
if(NOT PRECISION EQUAL 16)
  run_test(tjbenchtest "-precision;${PRECISION};-arithmetic")
  run_test(tjbenchtest "-precision;${PRECISION};-progressive;-arithmetic")
endif()
if(PRECISION EQUAL 8)
  run_test(tjbenchtest "-precision;${PRECISION};-arithmetic;-yuv")
endif()
run_test(tjbenchtest "-precision;${PRECISION};-lossless")
run_test(tjbenchtest "-precision;${PRECISION};-lossless;-alloc")
if(PRECISION EQUAL 8)
  run_test(tjexampletest "")
endif()
if(WITH_JAVA)
  if(NOT PRECISION EQUAL 16)
    run_test(tjbenchtest "-java;-precision;${PRECISION}")
  endif()
  if(PRECISION EQUAL 8)
    run_test(tjbenchtest "-java;-precision;${PRECISION};-yuv")
    run_test(tjbenchtest "-java;-precision;${PRECISION};-optimize")
    run_test(tjbenchtest "-java;-precision;${PRECISION};-optimize;-yuv")
  endif()
  if(NOT PRECISION EQUAL 16)
    run_test(tjbenchtest "-java;-precision;${PRECISION};-progressive")
  endif()
  if(PRECISION EQUAL 8)
    run_test(tjbenchtest "-java;-precision;${PRECISION};-progressive;-yuv")
  endif()
  if(NOT PRECISION EQUAL 16)
    run_test(tjbenchtest "-java;-precision;${PRECISION};-arithmetic")
    run_test(tjbenchtest "-java;-precision;${PRECISION};-progressive;-arithmetic")
  endif()
  if(PRECISION EQUAL 8)
    run_test(tjbenchtest "-java;-precision;${PRECISION};-arithmetic;-yuv")
  endif()
  run_test(tjbenchtest "-java;-precision;${PRECISION};-lossless")
  if(PRECISION EQUAL 8)
    run_test(tjexampletest "-java")
  endif()
endif()
