'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
'\" t
.TH XCreateWindow __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XCreateWindow, XCreateSimpleWindow, XSetWindowAttributes \- create windows and window attributes structure
.SH SYNTAX
.HP
Window XCreateWindow\^(\^Display *\fIdisplay\fP\^, Window \fIparent\fP\^, int \fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int \fIheight\fP\^, unsigned int \fIborder_width\fP\^, int \fIdepth\fP\^, unsigned int \fIclass\fP\^, Visual *\fIvisual\fP\^, unsigned long \fIvaluemask\fP\^, XSetWindowAttributes *\fIattributes\fP\^);
.HP
Window XCreateSimpleWindow\^(\^Display *\fIdisplay\fP\^, Window \fIparent\fP\^, int \fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int \fIheight\fP\^, unsigned int \fIborder_width\fP\^, unsigned long \fIborder\fP\^, unsigned long \fIbackground\fP\^);
.SH ARGUMENTS
.IP \fIattributes\fP 1i
Specifies the structure from which the values (as specified by the value mask)
are to be taken.
The value mask should have the appropriate bits
set to indicate which attributes have been set in the structure.
.IP \fIbackground\fP 1i
Specifies the background pixel value of the window.

.IP \fIborder\fP 1i
Specifies the border pixel value of the window.
.IP \fIborder_width\fP 1i
Specifies the width of the created window's border in pixels.
.IP \fIclass\fP 1i
Specifies the created window's class.
You can pass
.BR InputOutput ,
.BR InputOnly ,
or
.BR CopyFromParent .
A class of
.B CopyFromParent
means the class
is taken from the parent.
.IP \fIdepth\fP 1i
Specifies the window's depth.
A depth of
.B CopyFromParent
means the depth is taken from the parent.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIparent\fP 1i
Specifies the parent window.
.IP \fIvaluemask\fP 1i
Specifies which window attributes are defined in the attributes
argument.
This mask is the bitwise inclusive OR of the valid attribute mask bits.
If valuemask is zero,
the attributes are ignored and are not referenced.
.IP \fIvisual\fP 1i
Specifies the visual type.
A visual of
.B CopyFromParent
means the visual type is taken from the
parent.
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height, which are the created window's inside dimensions
and do not include the created window's borders.
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates, which are the top-left outside
corner of the window's
borders and are relative to the inside of the parent window's borders.
.SH DESCRIPTION
The
.B XCreateWindow
function creates an unmapped subwindow for a specified parent window,
returns the window ID of the created window,
and causes the X server to generate a
.B CreateNotify
event.
The created window is placed on top in the stacking order
with respect to siblings.
.LP
The coordinate system has the X axis horizontal and the Y axis vertical
with the origin [0, 0] at the upper-left corner.
Coordinates are integral,
in terms of pixels,
and coincide with pixel centers.
Each window and pixmap has its own coordinate system.
For a window,
the origin is inside the border at the inside, upper-left corner.
.LP
The border_width for an
.B InputOnly
window must be zero, or a
.B BadMatch
error results.
For class
.BR InputOutput ,
the visual type and depth must be a combination supported for the screen,
or a
.B BadMatch
error results.
The depth need not be the same as the parent,
but the parent must not be a window of class
.BR InputOnly ,
or a
.B BadMatch
error results.
For an
.B InputOnly
window,
the depth must be zero, and the visual must be one supported by the screen.
If either condition is not met,
a
.B BadMatch
error results.
The parent window, however, may have any depth and class.
If you specify any invalid window attribute for a window, a
.B BadMatch
error results.
.LP
The created window is not yet displayed (mapped) on the user's display.
To display the window, call
.BR XMapWindow .
The new window initially uses the same cursor as
its parent.
A new cursor can be defined for the new window by calling
.BR XDefineCursor .
The window will not be visible on the screen unless it and all of its
ancestors are mapped and it is not obscured by any of its ancestors.
.LP
.B XCreateWindow
can generate
.B BadAlloc
.BR BadColor ,
.BR BadCursor ,
.BR BadMatch ,
.BR BadPixmap ,
.BR BadValue ,
and
.B BadWindow
errors.
.LP
The
.B XCreateSimpleWindow
function creates an unmapped
.B InputOutput
subwindow for a specified parent window, returns the
window ID of the created window, and causes the X server to generate a
.B CreateNotify
event.
The created window is placed on top in the stacking order with respect to
siblings.
Any part of the window that extends outside its parent window is clipped.
The border_width for an
.B InputOnly
window must be zero, or a
.B BadMatch
error results.
.B XCreateSimpleWindow
inherits its depth, class, and visual from its parent.
All other window attributes, except background and border,
have their default values.
.LP
.B XCreateSimpleWindow
can generate
.BR BadAlloc ,
.BR BadMatch ,
.BR BadValue ,
and
.B BadWindow
errors.
.SH STRUCTURES
The
.BR XSetWindow Attributes
structure contains:
.LP
.LP
/\&* Window attribute value mask bits */
.TS
lw(.5i) lw(2.5i) lw(.8i).
T{
\&#define
T}	T{
.B CWBackPixmap
T}	T{
(1L<<0)
T}
T{
\&#define
T}	T{
.B CWBackPixel
T}	T{
(1L<<1)
T}
T{
\&#define
T}	T{
.B CWBorderPixmap
T}	T{
(1L<<2)
T}
T{
\&#define
T}	T{
.B CWBorderPixel
T}	T{
(1L<<3)
T}
T{
\&#define
T}	T{
.B CWBitGravity
T}	T{
(1L<<4)
T}
T{
\&#define
T}	T{
.B CWWinGravity
T}	T{
(1L<<5)
T}
T{
\&#define
T}	T{
.B CWBackingStore
T}	T{
(1L<<6)
T}
T{
\&#define
T}	T{
.B CWBackingPlanes
T}	T{
(1L<<7)
T}
T{
\&#define
T}	T{
.B CWBackingPixel
T}	T{
(1L<<8)
T}
T{
\&#define
T}	T{
.B CWOverrideRedirect
T}	T{
(1L<<9)
T}
T{
\&#define
T}	T{
.B CWSaveUnder
T}	T{
(1L<<10)
T}
T{
\&#define
T}	T{
.B CWEventMask
T}	T{
(1L<<11)
T}
T{
\&#define
T}	T{
.B CWDontPropagate
T}	T{
(1L<<12)
T}
T{
\&#define
T}	T{
.B CWColormap
T}	T{
(1L<<13)
T}
T{
\&#define
T}	T{
.B CWCursor
T}	T{
(1L<<14)
T}
.TE
.EX
/\&* Values */

typedef struct {
        Pixmap background_pixmap;       /\&* background, None, or ParentRelative */
        unsigned long background_pixel; /\&* background pixel */
        Pixmap border_pixmap;           /\&* border of the window or CopyFromParent */
        unsigned long border_pixel;     /\&* border pixel value */
        int bit_gravity;        /\&* one of bit gravity values */
        int win_gravity;        /\&* one of the window gravity values */
        int backing_store;      /\&* NotUseful, WhenMapped, Always */
        unsigned long backing_planes;   /\&* planes to be preserved if possible */
        unsigned long backing_pixel;    /\&* value to use in restoring planes */
        Bool save_under;        /\&* should bits under be saved? (popups) */
        long event_mask;        /\&* set of events that should be saved */
        long do_not_propagate_mask;     /\&* set of events that should not propagate */
        Bool override_redirect; /\&* boolean value for override_redirect */
        Colormap colormap;      /\&* color map to be associated with window */
        Cursor cursor;          /\&* cursor to be displayed (or None) */
} XSetWindowAttributes;
.EE
.LP
For a detailed explanation of the members of this structure,
see \fI\*(xL\fP\^.
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.B BadCursor
A value for a Cursor argument does not name a defined Cursor.
.TP 1i
.B BadMatch
The values do not exist for an
.B InputOnly
window.
.TP 1i
.B BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.B BadPixmap
A value for a Pixmap argument does not name a defined Pixmap.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XChangeWindowAttributes(__libmansuffix__),
XConfigureWindow(__libmansuffix__),
XDefineCursor(__libmansuffix__),
XDestroyWindow(__libmansuffix__),
XMapWindow(__libmansuffix__),
XRaiseWindow(__libmansuffix__),
XUnmapWindow(__libmansuffix__)
.br
\fI\*(xL\fP
