# Copyright 2021 The gRPC Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""AUTOGENERATED: configuration of benchmark scenarios to be run as bazel test"""

JSON_RUN_LOCALHOST_SCENARIOS = {
    "cpp_protobuf_async_unary_75Kqps_600channel_60Krpcs_300Breq_50Bresp": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_75Kqps_600channel_60Krpcs_300Breq_50Bresp", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 300, "resp_size": 50}}, "load_params": {"poisson": {"offered_load": 37500}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 16, "server_processes": 0, "threads_per_cq": 1, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_qps_unconstrained_10mps_secure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_qps_unconstrained_10mps_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}, "messages_per_stream": 10}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_qps_1channel_1MBmsg_secure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_qps_1channel_1MBmsg_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 100, "client_channels": 1, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"bytebuf_params": {"req_size": 1048576, "resp_size": 1048576}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"bytebuf_params": {"req_size": 1048576, "resp_size": 1048576}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_qps_unconstrained_64KBmsg_secure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_qps_unconstrained_64KBmsg_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"bytebuf_params": {"req_size": 65536, "resp_size": 65536}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"bytebuf_params": {"req_size": 65536, "resp_size": 65536}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_qps_unconstrained_1cq_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_qps_unconstrained_1cq_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 13, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 1000000, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 1000000, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_unary_qps_unconstrained_1cq_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_qps_unconstrained_1cq_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 13, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 1000000, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 1000000, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_client_sync_server_unary_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_client_sync_server_unary_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 10, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_client_unary_1channel_64wide_128Breq_8MBresp_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_client_unary_1channel_64wide_128Breq_8MBresp_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 128, "resp_size": 8388608}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_unary_ping_pong_secure_1MB": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_ping_pong_secure_1MB", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 1048576, "resp_size": 1048576}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_unary_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_unary_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_unary_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_unary_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_unary_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_unary_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_qps_unconstrained_10mps_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_qps_unconstrained_10mps_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}, "messages_per_stream": 10}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_qps_unconstrained_10mps_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_qps_unconstrained_10mps_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}, "messages_per_stream": 10}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_from_client_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_from_client_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING_FROM_CLIENT", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_from_client_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_from_client_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING_FROM_CLIENT", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_from_client_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_from_client_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING_FROM_CLIENT", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_from_client_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_from_client_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING_FROM_CLIENT", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_from_server_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_from_server_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING_FROM_SERVER", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_from_server_qps_unconstrained_secure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_from_server_qps_unconstrained_secure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 4, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING_FROM_SERVER", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_from_server_ping_pong_secure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_from_server_ping_pong_secure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING_FROM_SERVER", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": {"use_test_ca": true, "server_host_override": "foo.test.google.fr"}, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_qps_unconstrained_10mps_insecure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_qps_unconstrained_10mps_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}, "messages_per_stream": 10}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"bytebuf_params": {"req_size": 0, "resp_size": 0}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_qps_1channel_1MBmsg_insecure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_qps_1channel_1MBmsg_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 1, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"bytebuf_params": {"req_size": 1048576, "resp_size": 1048576}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"bytebuf_params": {"req_size": 1048576, "resp_size": 1048576}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_generic_async_streaming_qps_unconstrained_64KBmsg_insecure": '\'{"scenarios": [{"name": "cpp_generic_async_streaming_qps_unconstrained_64KBmsg_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"bytebuf_params": {"req_size": 65536, "resp_size": 65536}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_GENERIC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"bytebuf_params": {"req_size": 65536, "resp_size": 65536}}}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_qps_unconstrained_1cq_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_qps_unconstrained_1cq_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 13, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 1000000, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 1000000, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_unary_qps_unconstrained_1cq_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_qps_unconstrained_1cq_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 13, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 1000000, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 1000000, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_client_sync_server_unary_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_client_sync_server_unary_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 10, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_client_unary_1channel_64wide_128Breq_8MBresp_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_client_unary_1channel_64wide_128Breq_8MBresp_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 128, "resp_size": 8388608}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_unary_ping_pong_insecure_1MB": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_ping_pong_insecure_1MB", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 1048576, "resp_size": 1048576}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_unary_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_unary_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_unary_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_unary_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_unary_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_unary_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_unary_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "UNARY", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_qps_unconstrained_10mps_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_qps_unconstrained_10mps_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}, "messages_per_stream": 10}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_qps_unconstrained_10mps_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_qps_unconstrained_10mps_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}, "messages_per_stream": 10}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_from_client_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_from_client_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING_FROM_CLIENT", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_from_client_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_from_client_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING_FROM_CLIENT", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_from_client_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_from_client_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING_FROM_CLIENT", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_from_client_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_from_client_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 16, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING_FROM_CLIENT", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_from_server_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_from_server_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING_FROM_SERVER", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_sync_streaming_from_server_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_sync_streaming_from_server_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "SYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 4, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING_FROM_SERVER", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "SYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_from_server_ping_pong_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_from_server_ping_pong_insecure", "num_servers": 1, "num_clients": 1, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 1, "client_channels": 1, "async_client_threads": 1, "client_processes": 0, "threads_per_cq": 0, "rpc_type": "STREAMING_FROM_SERVER", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 1, "server_processes": 0, "threads_per_cq": 0, "channel_args": [{"name": "grpc.optimization_target", "str_value": "latency"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
    "cpp_protobuf_async_streaming_from_server_qps_unconstrained_insecure": '\'{"scenarios": [{"name": "cpp_protobuf_async_streaming_from_server_qps_unconstrained_insecure", "num_servers": 1, "num_clients": 0, "client_config": {"client_type": "ASYNC_CLIENT", "security_params": null, "outstanding_rpcs_per_channel": 100, "client_channels": 4, "async_client_threads": 0, "client_processes": 0, "threads_per_cq": 2, "rpc_type": "STREAMING_FROM_SERVER", "histogram_params": {"resolution": 0.01, "max_possible": 60000000000.0}, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}], "payload_config": {"simple_params": {"req_size": 0, "resp_size": 0}}, "load_params": {"closed_loop": {}}}, "server_config": {"server_type": "ASYNC_SERVER", "security_params": null, "async_server_threads": 0, "server_processes": 0, "threads_per_cq": 2, "channel_args": [{"name": "grpc.optimization_target", "str_value": "throughput"}, {"name": "grpc.minimal_stack", "int_value": 1}]}, "warmup_seconds": 0, "benchmark_seconds": 1}]}\'',
}
