// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v11.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.g.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>

namespace plugin_webview_flutter {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

// WebResourceRequestData

WebResourceRequestData::WebResourceRequestData(
    const std::string& url,
    bool is_for_main_frame,
    bool has_gesture,
    const std::string& method,
    const EncodableMap& request_headers)
    : url_(url),
      is_for_main_frame_(is_for_main_frame),
      has_gesture_(has_gesture),
      method_(method),
      request_headers_(request_headers) {}

WebResourceRequestData::WebResourceRequestData(
    const std::string& url,
    bool is_for_main_frame,
    const bool* is_redirect,
    bool has_gesture,
    const std::string& method,
    const EncodableMap& request_headers)
    : url_(url),
      is_for_main_frame_(is_for_main_frame),
      is_redirect_(is_redirect ? std::optional<bool>(*is_redirect)
                               : std::nullopt),
      has_gesture_(has_gesture),
      method_(method),
      request_headers_(request_headers) {}

const std::string& WebResourceRequestData::url() const {
  return url_;
}

void WebResourceRequestData::set_url(std::string_view value_arg) {
  url_ = value_arg;
}

bool WebResourceRequestData::is_for_main_frame() const {
  return is_for_main_frame_;
}

void WebResourceRequestData::set_is_for_main_frame(bool value_arg) {
  is_for_main_frame_ = value_arg;
}

const bool* WebResourceRequestData::is_redirect() const {
  return is_redirect_ ? &(*is_redirect_) : nullptr;
}

void WebResourceRequestData::set_is_redirect(const bool* value_arg) {
  is_redirect_ = value_arg ? std::optional<bool>(*value_arg) : std::nullopt;
}

void WebResourceRequestData::set_is_redirect(bool value_arg) {
  is_redirect_ = value_arg;
}

bool WebResourceRequestData::has_gesture() const {
  return has_gesture_;
}

void WebResourceRequestData::set_has_gesture(bool value_arg) {
  has_gesture_ = value_arg;
}

const std::string& WebResourceRequestData::method() const {
  return method_;
}

void WebResourceRequestData::set_method(std::string_view value_arg) {
  method_ = value_arg;
}

const EncodableMap& WebResourceRequestData::request_headers() const {
  return request_headers_;
}

void WebResourceRequestData::set_request_headers(
    const EncodableMap& value_arg) {
  request_headers_ = value_arg;
}

EncodableList WebResourceRequestData::ToEncodableList() const {
  EncodableList list;
  list.reserve(6);
  list.push_back(EncodableValue(url_));
  list.push_back(EncodableValue(is_for_main_frame_));
  list.push_back(is_redirect_ ? EncodableValue(*is_redirect_)
                              : EncodableValue());
  list.push_back(EncodableValue(has_gesture_));
  list.push_back(EncodableValue(method_));
  list.push_back(EncodableValue(request_headers_));
  return list;
}

WebResourceRequestData WebResourceRequestData::FromEncodableList(
    const EncodableList& list) {
  WebResourceRequestData decoded(
      std::get<std::string>(list[0]), std::get<bool>(list[1]),
      std::get<bool>(list[3]), std::get<std::string>(list[4]),
      std::get<EncodableMap>(list[5]));
  auto& encodable_is_redirect = list[2];
  if (!encodable_is_redirect.IsNull()) {
    decoded.set_is_redirect(std::get<bool>(encodable_is_redirect));
  }
  return decoded;
}

// WebResourceResponseData

WebResourceResponseData::WebResourceResponseData(int64_t status_code)
    : status_code_(status_code) {}

int64_t WebResourceResponseData::status_code() const {
  return status_code_;
}

void WebResourceResponseData::set_status_code(int64_t value_arg) {
  status_code_ = value_arg;
}

EncodableList WebResourceResponseData::ToEncodableList() const {
  EncodableList list;
  list.reserve(1);
  list.push_back(EncodableValue(status_code_));
  return list;
}

WebResourceResponseData WebResourceResponseData::FromEncodableList(
    const EncodableList& list) {
  WebResourceResponseData decoded(list[0].LongValue());
  return decoded;
}

// WebResourceErrorData

WebResourceErrorData::WebResourceErrorData(int64_t error_code,
                                           const std::string& description)
    : error_code_(error_code), description_(description) {}

int64_t WebResourceErrorData::error_code() const {
  return error_code_;
}

void WebResourceErrorData::set_error_code(int64_t value_arg) {
  error_code_ = value_arg;
}

const std::string& WebResourceErrorData::description() const {
  return description_;
}

void WebResourceErrorData::set_description(std::string_view value_arg) {
  description_ = value_arg;
}

EncodableList WebResourceErrorData::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.push_back(EncodableValue(error_code_));
  list.push_back(EncodableValue(description_));
  return list;
}

WebResourceErrorData WebResourceErrorData::FromEncodableList(
    const EncodableList& list) {
  WebResourceErrorData decoded(list[0].LongValue(),
                               std::get<std::string>(list[1]));
  return decoded;
}

// WebViewPoint

WebViewPoint::WebViewPoint(int64_t x, int64_t y) : x_(x), y_(y) {}

int64_t WebViewPoint::x() const {
  return x_;
}

void WebViewPoint::set_x(int64_t value_arg) {
  x_ = value_arg;
}

int64_t WebViewPoint::y() const {
  return y_;
}

void WebViewPoint::set_y(int64_t value_arg) {
  y_ = value_arg;
}

EncodableList WebViewPoint::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.push_back(EncodableValue(x_));
  list.push_back(EncodableValue(y_));
  return list;
}

WebViewPoint WebViewPoint::FromEncodableList(const EncodableList& list) {
  WebViewPoint decoded(list[0].LongValue(), list[1].LongValue());
  return decoded;
}

// ConsoleMessage

ConsoleMessage::ConsoleMessage(int64_t line_number,
                               const std::string& message,
                               const ConsoleMessageLevel& level,
                               const std::string& source_id)
    : line_number_(line_number),
      message_(message),
      level_(level),
      source_id_(source_id) {}

int64_t ConsoleMessage::line_number() const {
  return line_number_;
}

void ConsoleMessage::set_line_number(int64_t value_arg) {
  line_number_ = value_arg;
}

const std::string& ConsoleMessage::message() const {
  return message_;
}

void ConsoleMessage::set_message(std::string_view value_arg) {
  message_ = value_arg;
}

const ConsoleMessageLevel& ConsoleMessage::level() const {
  return level_;
}

void ConsoleMessage::set_level(const ConsoleMessageLevel& value_arg) {
  level_ = value_arg;
}

const std::string& ConsoleMessage::source_id() const {
  return source_id_;
}

void ConsoleMessage::set_source_id(std::string_view value_arg) {
  source_id_ = value_arg;
}

EncodableList ConsoleMessage::ToEncodableList() const {
  EncodableList list;
  list.reserve(4);
  list.push_back(EncodableValue(line_number_));
  list.push_back(EncodableValue(message_));
  list.push_back(EncodableValue((int)level_));
  list.push_back(EncodableValue(source_id_));
  return list;
}

ConsoleMessage ConsoleMessage::FromEncodableList(const EncodableList& list) {
  ConsoleMessage decoded(list[0].LongValue(), std::get<std::string>(list[1]),
                         (ConsoleMessageLevel)(std::get<int32_t>(list[2])),
                         std::get<std::string>(list[3]));
  return decoded;
}

/// The codec used by InstanceManagerHostApi.
const flutter::StandardMessageCodec& InstanceManagerHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `InstanceManagerHostApi` to handle messages through
// the `binary_messenger`.
void InstanceManagerHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                   InstanceManagerHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.InstanceManagerHostApi.clear",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              std::optional<FlutterError> output = api->Clear();
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue InstanceManagerHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue InstanceManagerHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

/// The codec used by JavaObjectHostApi.
const flutter::StandardMessageCodec& JavaObjectHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `JavaObjectHostApi` to handle messages through the
// `binary_messenger`.
void JavaObjectHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                              JavaObjectHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.JavaObjectHostApi.dispose",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_identifier_arg = args.at(0);
              if (encodable_identifier_arg.IsNull()) {
                reply(WrapError("identifier_arg unexpectedly null."));
                return;
              }
              const int64_t identifier_arg =
                  encodable_identifier_arg.LongValue();
              std::optional<FlutterError> output = api->Dispose(identifier_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue JavaObjectHostApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue JavaObjectHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
JavaObjectFlutterApi::JavaObjectFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& JavaObjectFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void JavaObjectFlutterApi::Dispose(
    int64_t identifier_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.JavaObjectFlutterApi.dispose",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(identifier_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by CookieManagerHostApi.
const flutter::StandardMessageCodec& CookieManagerHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `CookieManagerHostApi` to handle messages through the
// `binary_messenger`.
void CookieManagerHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                 CookieManagerHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.CookieManagerHostApi."
        "attachInstance",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_identifier_arg = args.at(0);
              if (encodable_instance_identifier_arg.IsNull()) {
                reply(WrapError("instance_identifier_arg unexpectedly null."));
                return;
              }
              const int64_t instance_identifier_arg =
                  encodable_instance_identifier_arg.LongValue();
              std::optional<FlutterError> output =
                  api->AttachInstance(instance_identifier_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.CookieManagerHostApi."
        "setCookie",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_identifier_arg = args.at(0);
              if (encodable_identifier_arg.IsNull()) {
                reply(WrapError("identifier_arg unexpectedly null."));
                return;
              }
              const int64_t identifier_arg =
                  encodable_identifier_arg.LongValue();
              const auto& encodable_url_arg = args.at(1);
              if (encodable_url_arg.IsNull()) {
                reply(WrapError("url_arg unexpectedly null."));
                return;
              }
              const auto& url_arg = std::get<std::string>(encodable_url_arg);
              const auto& encodable_value_arg = args.at(2);
              if (encodable_value_arg.IsNull()) {
                reply(WrapError("value_arg unexpectedly null."));
                return;
              }
              const auto& value_arg =
                  std::get<std::string>(encodable_value_arg);
              std::optional<FlutterError> output =
                  api->SetCookie(identifier_arg, url_arg, value_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.CookieManagerHostApi."
        "removeAllCookies",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_identifier_arg = args.at(0);
              if (encodable_identifier_arg.IsNull()) {
                reply(WrapError("identifier_arg unexpectedly null."));
                return;
              }
              const int64_t identifier_arg =
                  encodable_identifier_arg.LongValue();
              api->RemoveAllCookies(
                  identifier_arg, [reply](ErrorOr<bool>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.push_back(
                        EncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.CookieManagerHostApi."
        "setAcceptThirdPartyCookies",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_identifier_arg = args.at(0);
              if (encodable_identifier_arg.IsNull()) {
                reply(WrapError("identifier_arg unexpectedly null."));
                return;
              }
              const int64_t identifier_arg =
                  encodable_identifier_arg.LongValue();
              const auto& encodable_web_view_identifier_arg = args.at(1);
              if (encodable_web_view_identifier_arg.IsNull()) {
                reply(WrapError("web_view_identifier_arg unexpectedly null."));
                return;
              }
              const int64_t web_view_identifier_arg =
                  encodable_web_view_identifier_arg.LongValue();
              const auto& encodable_accept_arg = args.at(2);
              if (encodable_accept_arg.IsNull()) {
                reply(WrapError("accept_arg unexpectedly null."));
                return;
              }
              const auto& accept_arg = std::get<bool>(encodable_accept_arg);
              std::optional<FlutterError> output =
                  api->SetAcceptThirdPartyCookies(
                      identifier_arg, web_view_identifier_arg, accept_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue CookieManagerHostApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue CookieManagerHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

WebViewHostApiCodecSerializer::WebViewHostApiCodecSerializer() {}

EncodableValue WebViewHostApiCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(WebViewPoint::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void WebViewHostApiCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(WebViewPoint)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(
              std::any_cast<WebViewPoint>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by WebViewHostApi.
const flutter::StandardMessageCodec& WebViewHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &WebViewHostApiCodecSerializer::GetInstance());
}

// Sets up an instance of `WebViewHostApi` to handle messages through the
// `binary_messenger`.
void WebViewHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                           WebViewHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.create",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->Create(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.loadData",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_data_arg = args.at(1);
              if (encodable_data_arg.IsNull()) {
                reply(WrapError("data_arg unexpectedly null."));
                return;
              }
              const auto& data_arg = std::get<std::string>(encodable_data_arg);
              const auto& encodable_mime_type_arg = args.at(2);
              const auto* mime_type_arg =
                  std::get_if<std::string>(&encodable_mime_type_arg);
              const auto& encodable_encoding_arg = args.at(3);
              const auto* encoding_arg =
                  std::get_if<std::string>(&encodable_encoding_arg);
              std::optional<FlutterError> output = api->LoadData(
                  instance_id_arg, data_arg, mime_type_arg, encoding_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "loadDataWithBaseUrl",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_base_url_arg = args.at(1);
              const auto* base_url_arg =
                  std::get_if<std::string>(&encodable_base_url_arg);
              const auto& encodable_data_arg = args.at(2);
              if (encodable_data_arg.IsNull()) {
                reply(WrapError("data_arg unexpectedly null."));
                return;
              }
              const auto& data_arg = std::get<std::string>(encodable_data_arg);
              const auto& encodable_mime_type_arg = args.at(3);
              const auto* mime_type_arg =
                  std::get_if<std::string>(&encodable_mime_type_arg);
              const auto& encodable_encoding_arg = args.at(4);
              const auto* encoding_arg =
                  std::get_if<std::string>(&encodable_encoding_arg);
              const auto& encodable_history_url_arg = args.at(5);
              const auto* history_url_arg =
                  std::get_if<std::string>(&encodable_history_url_arg);
              std::optional<FlutterError> output = api->LoadDataWithBaseUrl(
                  instance_id_arg, base_url_arg, data_arg, mime_type_arg,
                  encoding_arg, history_url_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.loadUrl",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_url_arg = args.at(1);
              if (encodable_url_arg.IsNull()) {
                reply(WrapError("url_arg unexpectedly null."));
                return;
              }
              const auto& url_arg = std::get<std::string>(encodable_url_arg);
              const auto& encodable_headers_arg = args.at(2);
              if (encodable_headers_arg.IsNull()) {
                reply(WrapError("headers_arg unexpectedly null."));
                return;
              }
              const auto& headers_arg =
                  std::get<EncodableMap>(encodable_headers_arg);
              std::optional<FlutterError> output =
                  api->LoadUrl(instance_id_arg, url_arg, headers_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.postUrl",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_url_arg = args.at(1);
              if (encodable_url_arg.IsNull()) {
                reply(WrapError("url_arg unexpectedly null."));
                return;
              }
              const auto& url_arg = std::get<std::string>(encodable_url_arg);
              const auto& encodable_data_arg = args.at(2);
              if (encodable_data_arg.IsNull()) {
                reply(WrapError("data_arg unexpectedly null."));
                return;
              }
              const auto& data_arg =
                  std::get<std::vector<uint8_t>>(encodable_data_arg);
              std::optional<FlutterError> output =
                  api->PostUrl(instance_id_arg, url_arg, data_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.getUrl",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<std::optional<std::string>> output =
                  api->GetUrl(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.canGoBack",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<bool> output = api->CanGoBack(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.canGoForward",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<bool> output = api->CanGoForward(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.goBack",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->GoBack(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.goForward",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output =
                  api->GoForward(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.reload",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->Reload(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.clearCache",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_include_disk_files_arg = args.at(1);
              if (encodable_include_disk_files_arg.IsNull()) {
                reply(WrapError("include_disk_files_arg unexpectedly null."));
                return;
              }
              const auto& include_disk_files_arg =
                  std::get<bool>(encodable_include_disk_files_arg);
              std::optional<FlutterError> output =
                  api->ClearCache(instance_id_arg, include_disk_files_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "evaluateJavascript",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_javascript_string_arg = args.at(1);
              if (encodable_javascript_string_arg.IsNull()) {
                reply(WrapError("javascript_string_arg unexpectedly null."));
                return;
              }
              const auto& javascript_string_arg =
                  std::get<std::string>(encodable_javascript_string_arg);
              api->EvaluateJavascript(
                  instance_id_arg, javascript_string_arg,
                  [reply](ErrorOr<std::optional<std::string>>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    auto output_optional = std::move(output).TakeValue();
                    if (output_optional) {
                      wrapped.push_back(
                          EncodableValue(std::move(output_optional).value()));
                    } else {
                      wrapped.push_back(EncodableValue());
                    }
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.getTitle",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<std::optional<std::string>> output =
                  api->GetTitle(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              auto output_optional = std::move(output).TakeValue();
              if (output_optional) {
                wrapped.push_back(
                    EncodableValue(std::move(output_optional).value()));
              } else {
                wrapped.push_back(EncodableValue());
              }
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.scrollTo",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_x_arg = args.at(1);
              if (encodable_x_arg.IsNull()) {
                reply(WrapError("x_arg unexpectedly null."));
                return;
              }
              const int64_t x_arg = encodable_x_arg.LongValue();
              const auto& encodable_y_arg = args.at(2);
              if (encodable_y_arg.IsNull()) {
                reply(WrapError("y_arg unexpectedly null."));
                return;
              }
              const int64_t y_arg = encodable_y_arg.LongValue();
              std::optional<FlutterError> output =
                  api->ScrollTo(instance_id_arg, x_arg, y_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.scrollBy",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_x_arg = args.at(1);
              if (encodable_x_arg.IsNull()) {
                reply(WrapError("x_arg unexpectedly null."));
                return;
              }
              const int64_t x_arg = encodable_x_arg.LongValue();
              const auto& encodable_y_arg = args.at(2);
              if (encodable_y_arg.IsNull()) {
                reply(WrapError("y_arg unexpectedly null."));
                return;
              }
              const int64_t y_arg = encodable_y_arg.LongValue();
              std::optional<FlutterError> output =
                  api->ScrollBy(instance_id_arg, x_arg, y_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.getScrollX",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<int64_t> output = api->GetScrollX(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi.getScrollY",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<int64_t> output = api->GetScrollY(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "getScrollPosition",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<WebViewPoint> output =
                  api->GetScrollPosition(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "setWebContentsDebuggingEnabled",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enabled_arg = args.at(0);
              if (encodable_enabled_arg.IsNull()) {
                reply(WrapError("enabled_arg unexpectedly null."));
                return;
              }
              const auto& enabled_arg = std::get<bool>(encodable_enabled_arg);
              std::optional<FlutterError> output =
                  api->SetWebContentsDebuggingEnabled(enabled_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "setWebViewClient",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_web_view_client_instance_id_arg =
                  args.at(1);
              if (encodable_web_view_client_instance_id_arg.IsNull()) {
                reply(WrapError(
                    "web_view_client_instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t web_view_client_instance_id_arg =
                  encodable_web_view_client_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->SetWebViewClient(
                  instance_id_arg, web_view_client_instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "addJavaScriptChannel",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_java_script_channel_instance_id_arg =
                  args.at(1);
              if (encodable_java_script_channel_instance_id_arg.IsNull()) {
                reply(WrapError(
                    "java_script_channel_instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t java_script_channel_instance_id_arg =
                  encodable_java_script_channel_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->AddJavaScriptChannel(
                  instance_id_arg, java_script_channel_instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "removeJavaScriptChannel",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_java_script_channel_instance_id_arg =
                  args.at(1);
              if (encodable_java_script_channel_instance_id_arg.IsNull()) {
                reply(WrapError(
                    "java_script_channel_instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t java_script_channel_instance_id_arg =
                  encodable_java_script_channel_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->RemoveJavaScriptChannel(
                  instance_id_arg, java_script_channel_instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "setDownloadListener",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_listener_instance_id_arg = args.at(1);
              const int64_t listener_instance_id_arg_value =
                  encodable_listener_instance_id_arg.IsNull()
                      ? 0
                      : encodable_listener_instance_id_arg.LongValue();
              const auto* listener_instance_id_arg =
                  encodable_listener_instance_id_arg.IsNull()
                      ? nullptr
                      : &listener_instance_id_arg_value;
              std::optional<FlutterError> output = api->SetDownloadListener(
                  instance_id_arg, listener_instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "setWebChromeClient",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_client_instance_id_arg = args.at(1);
              const int64_t client_instance_id_arg_value =
                  encodable_client_instance_id_arg.IsNull()
                      ? 0
                      : encodable_client_instance_id_arg.LongValue();
              const auto* client_instance_id_arg =
                  encodable_client_instance_id_arg.IsNull()
                      ? nullptr
                      : &client_instance_id_arg_value;
              std::optional<FlutterError> output = api->SetWebChromeClient(
                  instance_id_arg, client_instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewHostApi."
        "setBackgroundColor",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_color_arg = args.at(1);
              if (encodable_color_arg.IsNull()) {
                reply(WrapError("color_arg unexpectedly null."));
                return;
              }
              const int64_t color_arg = encodable_color_arg.LongValue();
              std::optional<FlutterError> output =
                  api->SetBackgroundColor(instance_id_arg, color_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue WebViewHostApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue WebViewHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
WebViewFlutterApi::WebViewFlutterApi(flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& WebViewFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void WebViewFlutterApi::Create(
    int64_t identifier_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewFlutterApi.create",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(identifier_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewFlutterApi::OnScrollChanged(
    int64_t web_view_instance_id_arg,
    int64_t left_arg,
    int64_t top_arg,
    int64_t old_left_arg,
    int64_t old_top_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewFlutterApi."
      "onScrollChanged",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(left_arg),
      EncodableValue(top_arg),
      EncodableValue(old_left_arg),
      EncodableValue(old_top_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by WebSettingsHostApi.
const flutter::StandardMessageCodec& WebSettingsHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `WebSettingsHostApi` to handle messages through the
// `binary_messenger`.
void WebSettingsHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                               WebSettingsHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi.create",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_web_view_instance_id_arg = args.at(1);
              if (encodable_web_view_instance_id_arg.IsNull()) {
                reply(WrapError("web_view_instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t web_view_instance_id_arg =
                  encodable_web_view_instance_id_arg.LongValue();
              std::optional<FlutterError> output =
                  api->Create(instance_id_arg, web_view_instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setDomStorageEnabled",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_flag_arg = args.at(1);
              if (encodable_flag_arg.IsNull()) {
                reply(WrapError("flag_arg unexpectedly null."));
                return;
              }
              const auto& flag_arg = std::get<bool>(encodable_flag_arg);
              std::optional<FlutterError> output =
                  api->SetDomStorageEnabled(instance_id_arg, flag_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setJavaScriptCanOpenWindowsAutomatically",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_flag_arg = args.at(1);
              if (encodable_flag_arg.IsNull()) {
                reply(WrapError("flag_arg unexpectedly null."));
                return;
              }
              const auto& flag_arg = std::get<bool>(encodable_flag_arg);
              std::optional<FlutterError> output =
                  api->SetJavaScriptCanOpenWindowsAutomatically(instance_id_arg,
                                                                flag_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setSupportMultipleWindows",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_support_arg = args.at(1);
              if (encodable_support_arg.IsNull()) {
                reply(WrapError("support_arg unexpectedly null."));
                return;
              }
              const auto& support_arg = std::get<bool>(encodable_support_arg);
              std::optional<FlutterError> output =
                  api->SetSupportMultipleWindows(instance_id_arg, support_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setJavaScriptEnabled",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_flag_arg = args.at(1);
              if (encodable_flag_arg.IsNull()) {
                reply(WrapError("flag_arg unexpectedly null."));
                return;
              }
              const auto& flag_arg = std::get<bool>(encodable_flag_arg);
              std::optional<FlutterError> output =
                  api->SetJavaScriptEnabled(instance_id_arg, flag_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setUserAgentString",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_user_agent_string_arg = args.at(1);
              const auto* user_agent_string_arg =
                  std::get_if<std::string>(&encodable_user_agent_string_arg);
              std::optional<FlutterError> output = api->SetUserAgentString(
                  instance_id_arg, user_agent_string_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setMediaPlaybackRequiresUserGesture",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_require_arg = args.at(1);
              if (encodable_require_arg.IsNull()) {
                reply(WrapError("require_arg unexpectedly null."));
                return;
              }
              const auto& require_arg = std::get<bool>(encodable_require_arg);
              std::optional<FlutterError> output =
                  api->SetMediaPlaybackRequiresUserGesture(instance_id_arg,
                                                           require_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setSupportZoom",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_support_arg = args.at(1);
              if (encodable_support_arg.IsNull()) {
                reply(WrapError("support_arg unexpectedly null."));
                return;
              }
              const auto& support_arg = std::get<bool>(encodable_support_arg);
              std::optional<FlutterError> output =
                  api->SetSupportZoom(instance_id_arg, support_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setLoadWithOverviewMode",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_overview_arg = args.at(1);
              if (encodable_overview_arg.IsNull()) {
                reply(WrapError("overview_arg unexpectedly null."));
                return;
              }
              const auto& overview_arg = std::get<bool>(encodable_overview_arg);
              std::optional<FlutterError> output =
                  api->SetLoadWithOverviewMode(instance_id_arg, overview_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setUseWideViewPort",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_use_arg = args.at(1);
              if (encodable_use_arg.IsNull()) {
                reply(WrapError("use_arg unexpectedly null."));
                return;
              }
              const auto& use_arg = std::get<bool>(encodable_use_arg);
              std::optional<FlutterError> output =
                  api->SetUseWideViewPort(instance_id_arg, use_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setDisplayZoomControls",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_enabled_arg = args.at(1);
              if (encodable_enabled_arg.IsNull()) {
                reply(WrapError("enabled_arg unexpectedly null."));
                return;
              }
              const auto& enabled_arg = std::get<bool>(encodable_enabled_arg);
              std::optional<FlutterError> output =
                  api->SetDisplayZoomControls(instance_id_arg, enabled_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setBuiltInZoomControls",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_enabled_arg = args.at(1);
              if (encodable_enabled_arg.IsNull()) {
                reply(WrapError("enabled_arg unexpectedly null."));
                return;
              }
              const auto& enabled_arg = std::get<bool>(encodable_enabled_arg);
              std::optional<FlutterError> output =
                  api->SetBuiltInZoomControls(instance_id_arg, enabled_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setAllowFileAccess",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_enabled_arg = args.at(1);
              if (encodable_enabled_arg.IsNull()) {
                reply(WrapError("enabled_arg unexpectedly null."));
                return;
              }
              const auto& enabled_arg = std::get<bool>(encodable_enabled_arg);
              std::optional<FlutterError> output =
                  api->SetAllowFileAccess(instance_id_arg, enabled_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "setTextZoom",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_text_zoom_arg = args.at(1);
              if (encodable_text_zoom_arg.IsNull()) {
                reply(WrapError("text_zoom_arg unexpectedly null."));
                return;
              }
              const int64_t text_zoom_arg = encodable_text_zoom_arg.LongValue();
              std::optional<FlutterError> output =
                  api->SetTextZoom(instance_id_arg, text_zoom_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebSettingsHostApi."
        "getUserAgentString",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<std::string> output =
                  api->GetUserAgentString(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue WebSettingsHostApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue WebSettingsHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

/// The codec used by JavaScriptChannelHostApi.
const flutter::StandardMessageCodec& JavaScriptChannelHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `JavaScriptChannelHostApi` to handle messages through
// the `binary_messenger`.
void JavaScriptChannelHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                     JavaScriptChannelHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.JavaScriptChannelHostApi."
        "create",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_channel_name_arg = args.at(1);
              if (encodable_channel_name_arg.IsNull()) {
                reply(WrapError("channel_name_arg unexpectedly null."));
                return;
              }
              const auto& channel_name_arg =
                  std::get<std::string>(encodable_channel_name_arg);
              std::optional<FlutterError> output =
                  api->Create(instance_id_arg, channel_name_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue JavaScriptChannelHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue JavaScriptChannelHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
JavaScriptChannelFlutterApi::JavaScriptChannelFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& JavaScriptChannelFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void JavaScriptChannelFlutterApi::PostMessage(
    int64_t instance_id_arg,
    const std::string& message_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.JavaScriptChannelFlutterApi."
      "postMessage",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(message_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by WebViewClientHostApi.
const flutter::StandardMessageCodec& WebViewClientHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `WebViewClientHostApi` to handle messages through the
// `binary_messenger`.
void WebViewClientHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                 WebViewClientHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewClientHostApi.create",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->Create(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebViewClientHostApi."
        "setSynchronousReturnValueForShouldOverrideUrlLoading",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_value_arg = args.at(1);
              if (encodable_value_arg.IsNull()) {
                reply(WrapError("value_arg unexpectedly null."));
                return;
              }
              const auto& value_arg = std::get<bool>(encodable_value_arg);
              std::optional<FlutterError> output =
                  api->SetSynchronousReturnValueForShouldOverrideUrlLoading(
                      instance_id_arg, value_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue WebViewClientHostApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue WebViewClientHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

WvcFlutterApiCodecSerializer::WvcFlutterApiCodecSerializer() {}

EncodableValue WvcFlutterApiCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(WebResourceErrorData::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 129:
      return CustomEncodableValue(WebResourceRequestData::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 130:
      return CustomEncodableValue(WebResourceResponseData::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void WvcFlutterApiCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(WebResourceErrorData)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(std::any_cast<WebResourceErrorData>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(WebResourceRequestData)) {
      stream->WriteByte(129);
      WriteValue(
          EncodableValue(std::any_cast<WebResourceRequestData>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(WebResourceResponseData)) {
      stream->WriteByte(130);
      WriteValue(
          EncodableValue(std::any_cast<WebResourceResponseData>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
WebViewClientFlutterApi::WebViewClientFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& WebViewClientFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &WvcFlutterApiCodecSerializer::GetInstance());
}

void WebViewClientFlutterApi::OnPageStarted(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    const std::string& url_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "onPageStarted",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(url_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewClientFlutterApi::OnPageFinished(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    const std::string& url_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "onPageFinished",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(url_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewClientFlutterApi::OnReceivedHttpError(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    const WebResourceRequestData& request_arg,
    const WebResourceResponseData& response_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "onReceivedHttpError",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      CustomEncodableValue(request_arg),
      CustomEncodableValue(response_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewClientFlutterApi::OnReceivedRequestError(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    const WebResourceRequestData& request_arg,
    const WebResourceErrorData& error_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "onReceivedRequestError",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      CustomEncodableValue(request_arg),
      CustomEncodableValue(error_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewClientFlutterApi::OnReceivedError(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    int64_t error_code_arg,
    const std::string& description_arg,
    const std::string& failing_url_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "onReceivedError",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(error_code_arg),
      EncodableValue(description_arg),
      EncodableValue(failing_url_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewClientFlutterApi::RequestLoading(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    const WebResourceRequestData& request_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "requestLoading",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      CustomEncodableValue(request_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewClientFlutterApi::UrlLoading(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    const std::string& url_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "urlLoading",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(url_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewClientFlutterApi::DoUpdateVisitedHistory(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    const std::string& url_arg,
    bool is_reload_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "doUpdateVisitedHistory",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(url_arg),
      EncodableValue(is_reload_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebViewClientFlutterApi::OnReceivedHttpAuthRequest(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    int64_t http_auth_handler_instance_id_arg,
    const std::string& host_arg,
    const std::string& realm_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebViewClientFlutterApi."
      "onReceivedHttpAuthRequest",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(http_auth_handler_instance_id_arg),
      EncodableValue(host_arg),
      EncodableValue(realm_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by DownloadListenerHostApi.
const flutter::StandardMessageCodec& DownloadListenerHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `DownloadListenerHostApi` to handle messages through
// the `binary_messenger`.
void DownloadListenerHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                    DownloadListenerHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.DownloadListenerHostApi."
        "create",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->Create(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue DownloadListenerHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue DownloadListenerHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
DownloadListenerFlutterApi::DownloadListenerFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& DownloadListenerFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void DownloadListenerFlutterApi::OnDownloadStart(
    int64_t instance_id_arg,
    const std::string& url_arg,
    const std::string& user_agent_arg,
    const std::string& content_disposition_arg,
    const std::string& mimetype_arg,
    int64_t content_length_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.DownloadListenerFlutterApi."
      "onDownloadStart",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(url_arg),
      EncodableValue(user_agent_arg),
      EncodableValue(content_disposition_arg),
      EncodableValue(mimetype_arg),
      EncodableValue(content_length_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by WebChromeClientHostApi.
const flutter::StandardMessageCodec& WebChromeClientHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `WebChromeClientHostApi` to handle messages through
// the `binary_messenger`.
void WebChromeClientHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                   WebChromeClientHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientHostApi."
        "create",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->Create(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientHostApi."
        "setSynchronousReturnValueForOnShowFileChooser",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_value_arg = args.at(1);
              if (encodable_value_arg.IsNull()) {
                reply(WrapError("value_arg unexpectedly null."));
                return;
              }
              const auto& value_arg = std::get<bool>(encodable_value_arg);
              std::optional<FlutterError> output =
                  api->SetSynchronousReturnValueForOnShowFileChooser(
                      instance_id_arg, value_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientHostApi."
        "setSynchronousReturnValueForOnConsoleMessage",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_value_arg = args.at(1);
              if (encodable_value_arg.IsNull()) {
                reply(WrapError("value_arg unexpectedly null."));
                return;
              }
              const auto& value_arg = std::get<bool>(encodable_value_arg);
              std::optional<FlutterError> output =
                  api->SetSynchronousReturnValueForOnConsoleMessage(
                      instance_id_arg, value_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientHostApi."
        "setSynchronousReturnValueForOnJsAlert",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_value_arg = args.at(1);
              if (encodable_value_arg.IsNull()) {
                reply(WrapError("value_arg unexpectedly null."));
                return;
              }
              const auto& value_arg = std::get<bool>(encodable_value_arg);
              std::optional<FlutterError> output =
                  api->SetSynchronousReturnValueForOnJsAlert(instance_id_arg,
                                                             value_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientHostApi."
        "setSynchronousReturnValueForOnJsConfirm",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_value_arg = args.at(1);
              if (encodable_value_arg.IsNull()) {
                reply(WrapError("value_arg unexpectedly null."));
                return;
              }
              const auto& value_arg = std::get<bool>(encodable_value_arg);
              std::optional<FlutterError> output =
                  api->SetSynchronousReturnValueForOnJsConfirm(instance_id_arg,
                                                               value_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientHostApi."
        "setSynchronousReturnValueForOnJsPrompt",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_value_arg = args.at(1);
              if (encodable_value_arg.IsNull()) {
                reply(WrapError("value_arg unexpectedly null."));
                return;
              }
              const auto& value_arg = std::get<bool>(encodable_value_arg);
              std::optional<FlutterError> output =
                  api->SetSynchronousReturnValueForOnJsPrompt(instance_id_arg,
                                                              value_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue WebChromeClientHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue WebChromeClientHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

/// The codec used by FlutterAssetManagerHostApi.
const flutter::StandardMessageCodec& FlutterAssetManagerHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `FlutterAssetManagerHostApi` to handle messages
// through the `binary_messenger`.
void FlutterAssetManagerHostApi::SetUp(
    flutter::BinaryMessenger* binary_messenger,
    FlutterAssetManagerHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.FlutterAssetManagerHostApi."
        "list",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_path_arg = args.at(0);
              if (encodable_path_arg.IsNull()) {
                reply(WrapError("path_arg unexpectedly null."));
                return;
              }
              const auto& path_arg = std::get<std::string>(encodable_path_arg);
              ErrorOr<EncodableList> output = api->List(path_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.FlutterAssetManagerHostApi."
        "getAssetFilePathByName",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_name_arg = args.at(0);
              if (encodable_name_arg.IsNull()) {
                reply(WrapError("name_arg unexpectedly null."));
                return;
              }
              const auto& name_arg = std::get<std::string>(encodable_name_arg);
              ErrorOr<std::string> output =
                  api->GetAssetFilePathByName(name_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue FlutterAssetManagerHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue FlutterAssetManagerHostApi::WrapError(
    const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

WccFlutterApiCodecSerializer::WccFlutterApiCodecSerializer() {}

EncodableValue WccFlutterApiCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(ConsoleMessage::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void WccFlutterApiCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(ConsoleMessage)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(
              std::any_cast<ConsoleMessage>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
WebChromeClientFlutterApi::WebChromeClientFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& WebChromeClientFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &WccFlutterApiCodecSerializer::GetInstance());
}

void WebChromeClientFlutterApi::OnProgressChanged(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    int64_t progress_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onProgressChanged",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(progress_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebChromeClientFlutterApi::OnShowFileChooser(
    int64_t instance_id_arg,
    int64_t web_view_instance_id_arg,
    int64_t params_instance_id_arg,
    std::function<void(const EncodableList&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onShowFileChooser",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(web_view_instance_id_arg),
      EncodableValue(params_instance_id_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto& return_value =
            std::get<EncodableList>(encodable_return_value);
        on_success(return_value);
      });
}

void WebChromeClientFlutterApi::OnPermissionRequest(
    int64_t instance_id_arg,
    int64_t request_instance_id_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onPermissionRequest",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(request_instance_id_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebChromeClientFlutterApi::OnShowCustomView(
    int64_t instance_id_arg,
    int64_t view_identifier_arg,
    int64_t callback_identifier_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onShowCustomView",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(view_identifier_arg),
      EncodableValue(callback_identifier_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebChromeClientFlutterApi::OnHideCustomView(
    int64_t instance_id_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onHideCustomView",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebChromeClientFlutterApi::OnGeolocationPermissionsShowPrompt(
    int64_t instance_id_arg,
    int64_t params_instance_id_arg,
    const std::string& origin_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onGeolocationPermissionsShowPrompt",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(params_instance_id_arg),
      EncodableValue(origin_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebChromeClientFlutterApi::OnGeolocationPermissionsHidePrompt(
    int64_t identifier_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onGeolocationPermissionsHidePrompt",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(identifier_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebChromeClientFlutterApi::OnConsoleMessage(
    int64_t instance_id_arg,
    const ConsoleMessage& message_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onConsoleMessage",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      CustomEncodableValue(message_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebChromeClientFlutterApi::OnJsAlert(
    int64_t instance_id_arg,
    const std::string& url_arg,
    const std::string& message_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onJsAlert",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(url_arg),
      EncodableValue(message_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

void WebChromeClientFlutterApi::OnJsConfirm(
    int64_t instance_id_arg,
    const std::string& url_arg,
    const std::string& message_arg,
    std::function<void(bool)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onJsConfirm",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(url_arg),
      EncodableValue(message_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto& return_value = std::get<bool>(encodable_return_value);
        on_success(return_value);
      });
}

void WebChromeClientFlutterApi::OnJsPrompt(
    int64_t instance_id_arg,
    const std::string& url_arg,
    const std::string& message_arg,
    const std::string& default_value_arg,
    std::function<void(const std::string&)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.WebChromeClientFlutterApi."
      "onJsPrompt",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(url_arg),
      EncodableValue(message_arg),
      EncodableValue(default_value_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) {
        std::unique_ptr<EncodableValue> response =
            GetCodec().DecodeMessage(reply, reply_size);
        const auto& encodable_return_value = *response;
        const auto& return_value =
            std::get<std::string>(encodable_return_value);
        on_success(return_value);
      });
}

/// The codec used by WebStorageHostApi.
const flutter::StandardMessageCodec& WebStorageHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `WebStorageHostApi` to handle messages through the
// `binary_messenger`.
void WebStorageHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                              WebStorageHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebStorageHostApi.create",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->Create(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.WebStorageHostApi."
        "deleteAllData",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output =
                  api->DeleteAllData(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue WebStorageHostApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue WebStorageHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
FileChooserParamsFlutterApi::FileChooserParamsFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& FileChooserParamsFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void FileChooserParamsFlutterApi::Create(
    int64_t instance_id_arg,
    bool is_capture_enabled_arg,
    const EncodableList& accept_types_arg,
    const FileChooserMode& mode_arg,
    const std::string* filename_hint_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.FileChooserParamsFlutterApi."
      "create",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(is_capture_enabled_arg),
      EncodableValue(accept_types_arg),
      EncodableValue((int)mode_arg),
      filename_hint_arg ? EncodableValue(*filename_hint_arg) : EncodableValue(),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by PermissionRequestHostApi.
const flutter::StandardMessageCodec& PermissionRequestHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `PermissionRequestHostApi` to handle messages through
// the `binary_messenger`.
void PermissionRequestHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                     PermissionRequestHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.PermissionRequestHostApi."
        "grant",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_resources_arg = args.at(1);
              if (encodable_resources_arg.IsNull()) {
                reply(WrapError("resources_arg unexpectedly null."));
                return;
              }
              const auto& resources_arg =
                  std::get<EncodableList>(encodable_resources_arg);
              std::optional<FlutterError> output =
                  api->Grant(instance_id_arg, resources_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.PermissionRequestHostApi."
        "deny",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->Deny(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue PermissionRequestHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue PermissionRequestHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
PermissionRequestFlutterApi::PermissionRequestFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& PermissionRequestFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void PermissionRequestFlutterApi::Create(
    int64_t instance_id_arg,
    const EncodableList& resources_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.PermissionRequestFlutterApi."
      "create",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
      EncodableValue(resources_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by CustomViewCallbackHostApi.
const flutter::StandardMessageCodec& CustomViewCallbackHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `CustomViewCallbackHostApi` to handle messages through
// the `binary_messenger`.
void CustomViewCallbackHostApi::SetUp(
    flutter::BinaryMessenger* binary_messenger,
    CustomViewCallbackHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.CustomViewCallbackHostApi."
        "onCustomViewHidden",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_identifier_arg = args.at(0);
              if (encodable_identifier_arg.IsNull()) {
                reply(WrapError("identifier_arg unexpectedly null."));
                return;
              }
              const int64_t identifier_arg =
                  encodable_identifier_arg.LongValue();
              std::optional<FlutterError> output =
                  api->OnCustomViewHidden(identifier_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue CustomViewCallbackHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue CustomViewCallbackHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
CustomViewCallbackFlutterApi::CustomViewCallbackFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& CustomViewCallbackFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void CustomViewCallbackFlutterApi::Create(
    int64_t identifier_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.CustomViewCallbackFlutterApi."
      "create",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(identifier_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
ViewFlutterApi::ViewFlutterApi(flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& ViewFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void ViewFlutterApi::Create(
    int64_t identifier_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.ViewFlutterApi.create",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(identifier_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by GeolocationPermissionsCallbackHostApi.
const flutter::StandardMessageCodec&
GeolocationPermissionsCallbackHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `GeolocationPermissionsCallbackHostApi` to handle
// messages through the `binary_messenger`.
void GeolocationPermissionsCallbackHostApi::SetUp(
    flutter::BinaryMessenger* binary_messenger,
    GeolocationPermissionsCallbackHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux."
        "GeolocationPermissionsCallbackHostApi.invoke",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_origin_arg = args.at(1);
              if (encodable_origin_arg.IsNull()) {
                reply(WrapError("origin_arg unexpectedly null."));
                return;
              }
              const auto& origin_arg =
                  std::get<std::string>(encodable_origin_arg);
              const auto& encodable_allow_arg = args.at(2);
              if (encodable_allow_arg.IsNull()) {
                reply(WrapError("allow_arg unexpectedly null."));
                return;
              }
              const auto& allow_arg = std::get<bool>(encodable_allow_arg);
              const auto& encodable_retain_arg = args.at(3);
              if (encodable_retain_arg.IsNull()) {
                reply(WrapError("retain_arg unexpectedly null."));
                return;
              }
              const auto& retain_arg = std::get<bool>(encodable_retain_arg);
              std::optional<FlutterError> output = api->Invoke(
                  instance_id_arg, origin_arg, allow_arg, retain_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue GeolocationPermissionsCallbackHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue GeolocationPermissionsCallbackHostApi::WrapError(
    const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
GeoPermissionsCallbackFlutterApi::GeoPermissionsCallbackFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec&
GeoPermissionsCallbackFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void GeoPermissionsCallbackFlutterApi::Create(
    int64_t instance_id_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux."
      "GeolocationPermissionsCallbackFlutterApi.create",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

/// The codec used by HttpAuthHandlerHostApi.
const flutter::StandardMessageCodec& HttpAuthHandlerHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `HttpAuthHandlerHostApi` to handle messages through
// the `binary_messenger`.
void HttpAuthHandlerHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                   HttpAuthHandlerHostApi* api) {
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.HttpAuthHandlerHostApi."
        "useHttpAuthUsernamePassword",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              ErrorOr<bool> output =
                  api->UseHttpAuthUsernamePassword(instance_id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.HttpAuthHandlerHostApi."
        "cancel",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              std::optional<FlutterError> output = api->Cancel(instance_id_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.webview_flutter_linux.HttpAuthHandlerHostApi."
        "proceed",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_instance_id_arg = args.at(0);
              if (encodable_instance_id_arg.IsNull()) {
                reply(WrapError("instance_id_arg unexpectedly null."));
                return;
              }
              const int64_t instance_id_arg =
                  encodable_instance_id_arg.LongValue();
              const auto& encodable_username_arg = args.at(1);
              if (encodable_username_arg.IsNull()) {
                reply(WrapError("username_arg unexpectedly null."));
                return;
              }
              const auto& username_arg =
                  std::get<std::string>(encodable_username_arg);
              const auto& encodable_password_arg = args.at(2);
              if (encodable_password_arg.IsNull()) {
                reply(WrapError("password_arg unexpectedly null."));
                return;
              }
              const auto& password_arg =
                  std::get<std::string>(encodable_password_arg);
              std::optional<FlutterError> output =
                  api->Proceed(instance_id_arg, username_arg, password_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.push_back(EncodableValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue HttpAuthHandlerHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue HttpAuthHandlerHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
HttpAuthHandlerFlutterApi::HttpAuthHandlerFlutterApi(
    flutter::BinaryMessenger* binary_messenger)
    : binary_messenger_(binary_messenger) {}

const flutter::StandardMessageCodec& HttpAuthHandlerFlutterApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

void HttpAuthHandlerFlutterApi::Create(
    int64_t instance_id_arg,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error) {
  auto channel = std::make_unique<BasicMessageChannel<>>(
      binary_messenger_,
      "dev.flutter.pigeon.webview_flutter_linux.HttpAuthHandlerFlutterApi."
      "create",
      &GetCodec());
  EncodableValue encoded_api_arguments = EncodableValue(EncodableList{
      EncodableValue(instance_id_arg),
  });
  channel->Send(
      encoded_api_arguments,
      [on_success = std::move(on_success), on_error = std::move(on_error)](
          const uint8_t* reply, size_t reply_size) { on_success(); });
}

}  // namespace plugin_webview_flutter
