/* Simulator instruction decoder for frvbf.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright (C) 1996-2024 Free Software Foundation, Inc.

This file is part of the GNU simulators.

   This file is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.

*/

#define WANT_CPU frvbf
#define WANT_CPU_FRVBF

#include "sim-main.h"
#include "sim-assert.h"
#include "cgen-mem.h"
#include "cgen-ops.h"

/* The instruction descriptor array.
   This is computed at runtime.  Space for it is not malloc'd to save a
   teensy bit of cpu in the decoder.  Moving it to malloc space is trivial
   but won't be done until necessary (we don't currently support the runtime
   addition of instructions nor an SMP machine with different cpus).  */
static IDESC frvbf_insn_data[FRVBF_INSN__MAX];

/* Commas between elements are contained in the macros.
   Some of these are conditionally compiled out.  */

static const struct insn_sem frvbf_insn_sem[] =
{
  { VIRTUAL_INSN_X_INVALID, FRVBF_INSN_X_INVALID, FRVBF_SFMT_EMPTY },
  { VIRTUAL_INSN_X_AFTER, FRVBF_INSN_X_AFTER, FRVBF_SFMT_EMPTY },
  { VIRTUAL_INSN_X_BEFORE, FRVBF_INSN_X_BEFORE, FRVBF_SFMT_EMPTY },
  { VIRTUAL_INSN_X_CTI_CHAIN, FRVBF_INSN_X_CTI_CHAIN, FRVBF_SFMT_EMPTY },
  { VIRTUAL_INSN_X_CHAIN, FRVBF_INSN_X_CHAIN, FRVBF_SFMT_EMPTY },
  { VIRTUAL_INSN_X_BEGIN, FRVBF_INSN_X_BEGIN, FRVBF_SFMT_EMPTY },
  { FRV_INSN_ADD, FRVBF_INSN_ADD, FRVBF_SFMT_ADD },
  { FRV_INSN_SUB, FRVBF_INSN_SUB, FRVBF_SFMT_ADD },
  { FRV_INSN_AND, FRVBF_INSN_AND, FRVBF_SFMT_ADD },
  { FRV_INSN_OR, FRVBF_INSN_OR, FRVBF_SFMT_ADD },
  { FRV_INSN_XOR, FRVBF_INSN_XOR, FRVBF_SFMT_ADD },
  { FRV_INSN_NOT, FRVBF_INSN_NOT, FRVBF_SFMT_NOT },
  { FRV_INSN_SDIV, FRVBF_INSN_SDIV, FRVBF_SFMT_SDIV },
  { FRV_INSN_NSDIV, FRVBF_INSN_NSDIV, FRVBF_SFMT_SDIV },
  { FRV_INSN_UDIV, FRVBF_INSN_UDIV, FRVBF_SFMT_SDIV },
  { FRV_INSN_NUDIV, FRVBF_INSN_NUDIV, FRVBF_SFMT_SDIV },
  { FRV_INSN_SMUL, FRVBF_INSN_SMUL, FRVBF_SFMT_SMUL },
  { FRV_INSN_UMUL, FRVBF_INSN_UMUL, FRVBF_SFMT_SMUL },
  { FRV_INSN_SMU, FRVBF_INSN_SMU, FRVBF_SFMT_SMU },
  { FRV_INSN_SMASS, FRVBF_INSN_SMASS, FRVBF_SFMT_SMASS },
  { FRV_INSN_SMSSS, FRVBF_INSN_SMSSS, FRVBF_SFMT_SMASS },
  { FRV_INSN_SLL, FRVBF_INSN_SLL, FRVBF_SFMT_ADD },
  { FRV_INSN_SRL, FRVBF_INSN_SRL, FRVBF_SFMT_ADD },
  { FRV_INSN_SRA, FRVBF_INSN_SRA, FRVBF_SFMT_ADD },
  { FRV_INSN_SLASS, FRVBF_INSN_SLASS, FRVBF_SFMT_SLASS },
  { FRV_INSN_SCUTSS, FRVBF_INSN_SCUTSS, FRVBF_SFMT_SCUTSS },
  { FRV_INSN_SCAN, FRVBF_INSN_SCAN, FRVBF_SFMT_ADD },
  { FRV_INSN_CADD, FRVBF_INSN_CADD, FRVBF_SFMT_CADD },
  { FRV_INSN_CSUB, FRVBF_INSN_CSUB, FRVBF_SFMT_CADD },
  { FRV_INSN_CAND, FRVBF_INSN_CAND, FRVBF_SFMT_CADD },
  { FRV_INSN_COR, FRVBF_INSN_COR, FRVBF_SFMT_CADD },
  { FRV_INSN_CXOR, FRVBF_INSN_CXOR, FRVBF_SFMT_CADD },
  { FRV_INSN_CNOT, FRVBF_INSN_CNOT, FRVBF_SFMT_CNOT },
  { FRV_INSN_CSMUL, FRVBF_INSN_CSMUL, FRVBF_SFMT_CSMUL },
  { FRV_INSN_CSDIV, FRVBF_INSN_CSDIV, FRVBF_SFMT_CSDIV },
  { FRV_INSN_CUDIV, FRVBF_INSN_CUDIV, FRVBF_SFMT_CSDIV },
  { FRV_INSN_CSLL, FRVBF_INSN_CSLL, FRVBF_SFMT_CADD },
  { FRV_INSN_CSRL, FRVBF_INSN_CSRL, FRVBF_SFMT_CADD },
  { FRV_INSN_CSRA, FRVBF_INSN_CSRA, FRVBF_SFMT_CADD },
  { FRV_INSN_CSCAN, FRVBF_INSN_CSCAN, FRVBF_SFMT_CADD },
  { FRV_INSN_ADDCC, FRVBF_INSN_ADDCC, FRVBF_SFMT_ADDCC },
  { FRV_INSN_SUBCC, FRVBF_INSN_SUBCC, FRVBF_SFMT_ADDCC },
  { FRV_INSN_ANDCC, FRVBF_INSN_ANDCC, FRVBF_SFMT_ANDCC },
  { FRV_INSN_ORCC, FRVBF_INSN_ORCC, FRVBF_SFMT_ANDCC },
  { FRV_INSN_XORCC, FRVBF_INSN_XORCC, FRVBF_SFMT_ANDCC },
  { FRV_INSN_SLLCC, FRVBF_INSN_SLLCC, FRVBF_SFMT_ADDCC },
  { FRV_INSN_SRLCC, FRVBF_INSN_SRLCC, FRVBF_SFMT_ADDCC },
  { FRV_INSN_SRACC, FRVBF_INSN_SRACC, FRVBF_SFMT_ADDCC },
  { FRV_INSN_SMULCC, FRVBF_INSN_SMULCC, FRVBF_SFMT_SMULCC },
  { FRV_INSN_UMULCC, FRVBF_INSN_UMULCC, FRVBF_SFMT_SMULCC },
  { FRV_INSN_CADDCC, FRVBF_INSN_CADDCC, FRVBF_SFMT_CADDCC },
  { FRV_INSN_CSUBCC, FRVBF_INSN_CSUBCC, FRVBF_SFMT_CADDCC },
  { FRV_INSN_CSMULCC, FRVBF_INSN_CSMULCC, FRVBF_SFMT_CSMULCC },
  { FRV_INSN_CANDCC, FRVBF_INSN_CANDCC, FRVBF_SFMT_CADDCC },
  { FRV_INSN_CORCC, FRVBF_INSN_CORCC, FRVBF_SFMT_CADDCC },
  { FRV_INSN_CXORCC, FRVBF_INSN_CXORCC, FRVBF_SFMT_CADDCC },
  { FRV_INSN_CSLLCC, FRVBF_INSN_CSLLCC, FRVBF_SFMT_CADDCC },
  { FRV_INSN_CSRLCC, FRVBF_INSN_CSRLCC, FRVBF_SFMT_CADDCC },
  { FRV_INSN_CSRACC, FRVBF_INSN_CSRACC, FRVBF_SFMT_CADDCC },
  { FRV_INSN_ADDX, FRVBF_INSN_ADDX, FRVBF_SFMT_ADDX },
  { FRV_INSN_SUBX, FRVBF_INSN_SUBX, FRVBF_SFMT_ADDX },
  { FRV_INSN_ADDXCC, FRVBF_INSN_ADDXCC, FRVBF_SFMT_ADDCC },
  { FRV_INSN_SUBXCC, FRVBF_INSN_SUBXCC, FRVBF_SFMT_ADDCC },
  { FRV_INSN_ADDSS, FRVBF_INSN_ADDSS, FRVBF_SFMT_SLASS },
  { FRV_INSN_SUBSS, FRVBF_INSN_SUBSS, FRVBF_SFMT_SLASS },
  { FRV_INSN_ADDI, FRVBF_INSN_ADDI, FRVBF_SFMT_ADDI },
  { FRV_INSN_SUBI, FRVBF_INSN_SUBI, FRVBF_SFMT_ADDI },
  { FRV_INSN_ANDI, FRVBF_INSN_ANDI, FRVBF_SFMT_ADDI },
  { FRV_INSN_ORI, FRVBF_INSN_ORI, FRVBF_SFMT_ADDI },
  { FRV_INSN_XORI, FRVBF_INSN_XORI, FRVBF_SFMT_ADDI },
  { FRV_INSN_SDIVI, FRVBF_INSN_SDIVI, FRVBF_SFMT_SDIVI },
  { FRV_INSN_NSDIVI, FRVBF_INSN_NSDIVI, FRVBF_SFMT_SDIVI },
  { FRV_INSN_UDIVI, FRVBF_INSN_UDIVI, FRVBF_SFMT_SDIVI },
  { FRV_INSN_NUDIVI, FRVBF_INSN_NUDIVI, FRVBF_SFMT_SDIVI },
  { FRV_INSN_SMULI, FRVBF_INSN_SMULI, FRVBF_SFMT_SMULI },
  { FRV_INSN_UMULI, FRVBF_INSN_UMULI, FRVBF_SFMT_SMULI },
  { FRV_INSN_SLLI, FRVBF_INSN_SLLI, FRVBF_SFMT_ADDI },
  { FRV_INSN_SRLI, FRVBF_INSN_SRLI, FRVBF_SFMT_ADDI },
  { FRV_INSN_SRAI, FRVBF_INSN_SRAI, FRVBF_SFMT_ADDI },
  { FRV_INSN_SCANI, FRVBF_INSN_SCANI, FRVBF_SFMT_ADDI },
  { FRV_INSN_ADDICC, FRVBF_INSN_ADDICC, FRVBF_SFMT_ADDICC },
  { FRV_INSN_SUBICC, FRVBF_INSN_SUBICC, FRVBF_SFMT_ADDICC },
  { FRV_INSN_ANDICC, FRVBF_INSN_ANDICC, FRVBF_SFMT_ANDICC },
  { FRV_INSN_ORICC, FRVBF_INSN_ORICC, FRVBF_SFMT_ANDICC },
  { FRV_INSN_XORICC, FRVBF_INSN_XORICC, FRVBF_SFMT_ANDICC },
  { FRV_INSN_SMULICC, FRVBF_INSN_SMULICC, FRVBF_SFMT_SMULICC },
  { FRV_INSN_UMULICC, FRVBF_INSN_UMULICC, FRVBF_SFMT_SMULICC },
  { FRV_INSN_SLLICC, FRVBF_INSN_SLLICC, FRVBF_SFMT_ADDICC },
  { FRV_INSN_SRLICC, FRVBF_INSN_SRLICC, FRVBF_SFMT_ADDICC },
  { FRV_INSN_SRAICC, FRVBF_INSN_SRAICC, FRVBF_SFMT_ADDICC },
  { FRV_INSN_ADDXI, FRVBF_INSN_ADDXI, FRVBF_SFMT_ADDXI },
  { FRV_INSN_SUBXI, FRVBF_INSN_SUBXI, FRVBF_SFMT_ADDXI },
  { FRV_INSN_ADDXICC, FRVBF_INSN_ADDXICC, FRVBF_SFMT_ADDICC },
  { FRV_INSN_SUBXICC, FRVBF_INSN_SUBXICC, FRVBF_SFMT_ADDICC },
  { FRV_INSN_CMPB, FRVBF_INSN_CMPB, FRVBF_SFMT_CMPB },
  { FRV_INSN_CMPBA, FRVBF_INSN_CMPBA, FRVBF_SFMT_CMPB },
  { FRV_INSN_SETLO, FRVBF_INSN_SETLO, FRVBF_SFMT_SETLO },
  { FRV_INSN_SETHI, FRVBF_INSN_SETHI, FRVBF_SFMT_SETHI },
  { FRV_INSN_SETLOS, FRVBF_INSN_SETLOS, FRVBF_SFMT_SETLOS },
  { FRV_INSN_LDSB, FRVBF_INSN_LDSB, FRVBF_SFMT_LDSB },
  { FRV_INSN_LDUB, FRVBF_INSN_LDUB, FRVBF_SFMT_LDSB },
  { FRV_INSN_LDSH, FRVBF_INSN_LDSH, FRVBF_SFMT_LDSB },
  { FRV_INSN_LDUH, FRVBF_INSN_LDUH, FRVBF_SFMT_LDSB },
  { FRV_INSN_LD, FRVBF_INSN_LD, FRVBF_SFMT_LDSB },
  { FRV_INSN_LDBF, FRVBF_INSN_LDBF, FRVBF_SFMT_LDBF },
  { FRV_INSN_LDHF, FRVBF_INSN_LDHF, FRVBF_SFMT_LDBF },
  { FRV_INSN_LDF, FRVBF_INSN_LDF, FRVBF_SFMT_LDBF },
  { FRV_INSN_LDC, FRVBF_INSN_LDC, FRVBF_SFMT_LDC },
  { FRV_INSN_NLDSB, FRVBF_INSN_NLDSB, FRVBF_SFMT_NLDSB },
  { FRV_INSN_NLDUB, FRVBF_INSN_NLDUB, FRVBF_SFMT_NLDSB },
  { FRV_INSN_NLDSH, FRVBF_INSN_NLDSH, FRVBF_SFMT_NLDSB },
  { FRV_INSN_NLDUH, FRVBF_INSN_NLDUH, FRVBF_SFMT_NLDSB },
  { FRV_INSN_NLD, FRVBF_INSN_NLD, FRVBF_SFMT_NLDSB },
  { FRV_INSN_NLDBF, FRVBF_INSN_NLDBF, FRVBF_SFMT_NLDBF },
  { FRV_INSN_NLDHF, FRVBF_INSN_NLDHF, FRVBF_SFMT_NLDBF },
  { FRV_INSN_NLDF, FRVBF_INSN_NLDF, FRVBF_SFMT_NLDBF },
  { FRV_INSN_LDD, FRVBF_INSN_LDD, FRVBF_SFMT_LDD },
  { FRV_INSN_LDDF, FRVBF_INSN_LDDF, FRVBF_SFMT_LDDF },
  { FRV_INSN_LDDC, FRVBF_INSN_LDDC, FRVBF_SFMT_LDDC },
  { FRV_INSN_NLDD, FRVBF_INSN_NLDD, FRVBF_SFMT_NLDD },
  { FRV_INSN_NLDDF, FRVBF_INSN_NLDDF, FRVBF_SFMT_NLDDF },
  { FRV_INSN_LDQ, FRVBF_INSN_LDQ, FRVBF_SFMT_LDQ },
  { FRV_INSN_LDQF, FRVBF_INSN_LDQF, FRVBF_SFMT_LDQF },
  { FRV_INSN_LDQC, FRVBF_INSN_LDQC, FRVBF_SFMT_LDQC },
  { FRV_INSN_NLDQ, FRVBF_INSN_NLDQ, FRVBF_SFMT_NLDQ },
  { FRV_INSN_NLDQF, FRVBF_INSN_NLDQF, FRVBF_SFMT_NLDQF },
  { FRV_INSN_LDSBU, FRVBF_INSN_LDSBU, FRVBF_SFMT_LDSBU },
  { FRV_INSN_LDUBU, FRVBF_INSN_LDUBU, FRVBF_SFMT_LDSBU },
  { FRV_INSN_LDSHU, FRVBF_INSN_LDSHU, FRVBF_SFMT_LDSBU },
  { FRV_INSN_LDUHU, FRVBF_INSN_LDUHU, FRVBF_SFMT_LDSBU },
  { FRV_INSN_LDU, FRVBF_INSN_LDU, FRVBF_SFMT_LDSBU },
  { FRV_INSN_NLDSBU, FRVBF_INSN_NLDSBU, FRVBF_SFMT_NLDSBU },
  { FRV_INSN_NLDUBU, FRVBF_INSN_NLDUBU, FRVBF_SFMT_NLDSBU },
  { FRV_INSN_NLDSHU, FRVBF_INSN_NLDSHU, FRVBF_SFMT_NLDSBU },
  { FRV_INSN_NLDUHU, FRVBF_INSN_NLDUHU, FRVBF_SFMT_NLDSBU },
  { FRV_INSN_NLDU, FRVBF_INSN_NLDU, FRVBF_SFMT_NLDSBU },
  { FRV_INSN_LDBFU, FRVBF_INSN_LDBFU, FRVBF_SFMT_LDBFU },
  { FRV_INSN_LDHFU, FRVBF_INSN_LDHFU, FRVBF_SFMT_LDBFU },
  { FRV_INSN_LDFU, FRVBF_INSN_LDFU, FRVBF_SFMT_LDBFU },
  { FRV_INSN_LDCU, FRVBF_INSN_LDCU, FRVBF_SFMT_LDCU },
  { FRV_INSN_NLDBFU, FRVBF_INSN_NLDBFU, FRVBF_SFMT_NLDBFU },
  { FRV_INSN_NLDHFU, FRVBF_INSN_NLDHFU, FRVBF_SFMT_NLDBFU },
  { FRV_INSN_NLDFU, FRVBF_INSN_NLDFU, FRVBF_SFMT_NLDBFU },
  { FRV_INSN_LDDU, FRVBF_INSN_LDDU, FRVBF_SFMT_LDDU },
  { FRV_INSN_NLDDU, FRVBF_INSN_NLDDU, FRVBF_SFMT_NLDDU },
  { FRV_INSN_LDDFU, FRVBF_INSN_LDDFU, FRVBF_SFMT_LDDFU },
  { FRV_INSN_LDDCU, FRVBF_INSN_LDDCU, FRVBF_SFMT_LDDCU },
  { FRV_INSN_NLDDFU, FRVBF_INSN_NLDDFU, FRVBF_SFMT_NLDDFU },
  { FRV_INSN_LDQU, FRVBF_INSN_LDQU, FRVBF_SFMT_LDQU },
  { FRV_INSN_NLDQU, FRVBF_INSN_NLDQU, FRVBF_SFMT_NLDQU },
  { FRV_INSN_LDQFU, FRVBF_INSN_LDQFU, FRVBF_SFMT_LDQFU },
  { FRV_INSN_LDQCU, FRVBF_INSN_LDQCU, FRVBF_SFMT_LDQCU },
  { FRV_INSN_NLDQFU, FRVBF_INSN_NLDQFU, FRVBF_SFMT_NLDQFU },
  { FRV_INSN_LDSBI, FRVBF_INSN_LDSBI, FRVBF_SFMT_LDSBI },
  { FRV_INSN_LDSHI, FRVBF_INSN_LDSHI, FRVBF_SFMT_LDSBI },
  { FRV_INSN_LDI, FRVBF_INSN_LDI, FRVBF_SFMT_LDSBI },
  { FRV_INSN_LDUBI, FRVBF_INSN_LDUBI, FRVBF_SFMT_LDSBI },
  { FRV_INSN_LDUHI, FRVBF_INSN_LDUHI, FRVBF_SFMT_LDSBI },
  { FRV_INSN_LDBFI, FRVBF_INSN_LDBFI, FRVBF_SFMT_LDBFI },
  { FRV_INSN_LDHFI, FRVBF_INSN_LDHFI, FRVBF_SFMT_LDBFI },
  { FRV_INSN_LDFI, FRVBF_INSN_LDFI, FRVBF_SFMT_LDBFI },
  { FRV_INSN_NLDSBI, FRVBF_INSN_NLDSBI, FRVBF_SFMT_NLDSBI },
  { FRV_INSN_NLDUBI, FRVBF_INSN_NLDUBI, FRVBF_SFMT_NLDSBI },
  { FRV_INSN_NLDSHI, FRVBF_INSN_NLDSHI, FRVBF_SFMT_NLDSBI },
  { FRV_INSN_NLDUHI, FRVBF_INSN_NLDUHI, FRVBF_SFMT_NLDSBI },
  { FRV_INSN_NLDI, FRVBF_INSN_NLDI, FRVBF_SFMT_NLDSBI },
  { FRV_INSN_NLDBFI, FRVBF_INSN_NLDBFI, FRVBF_SFMT_NLDBFI },
  { FRV_INSN_NLDHFI, FRVBF_INSN_NLDHFI, FRVBF_SFMT_NLDBFI },
  { FRV_INSN_NLDFI, FRVBF_INSN_NLDFI, FRVBF_SFMT_NLDBFI },
  { FRV_INSN_LDDI, FRVBF_INSN_LDDI, FRVBF_SFMT_LDDI },
  { FRV_INSN_LDDFI, FRVBF_INSN_LDDFI, FRVBF_SFMT_LDDFI },
  { FRV_INSN_NLDDI, FRVBF_INSN_NLDDI, FRVBF_SFMT_NLDDI },
  { FRV_INSN_NLDDFI, FRVBF_INSN_NLDDFI, FRVBF_SFMT_NLDDFI },
  { FRV_INSN_LDQI, FRVBF_INSN_LDQI, FRVBF_SFMT_LDQI },
  { FRV_INSN_LDQFI, FRVBF_INSN_LDQFI, FRVBF_SFMT_LDQFI },
  { FRV_INSN_NLDQFI, FRVBF_INSN_NLDQFI, FRVBF_SFMT_NLDQFI },
  { FRV_INSN_STB, FRVBF_INSN_STB, FRVBF_SFMT_STB },
  { FRV_INSN_STH, FRVBF_INSN_STH, FRVBF_SFMT_STB },
  { FRV_INSN_ST, FRVBF_INSN_ST, FRVBF_SFMT_STB },
  { FRV_INSN_STBF, FRVBF_INSN_STBF, FRVBF_SFMT_STBF },
  { FRV_INSN_STHF, FRVBF_INSN_STHF, FRVBF_SFMT_STBF },
  { FRV_INSN_STF, FRVBF_INSN_STF, FRVBF_SFMT_STBF },
  { FRV_INSN_STC, FRVBF_INSN_STC, FRVBF_SFMT_STC },
  { FRV_INSN_STD, FRVBF_INSN_STD, FRVBF_SFMT_STD },
  { FRV_INSN_STDF, FRVBF_INSN_STDF, FRVBF_SFMT_STDF },
  { FRV_INSN_STDC, FRVBF_INSN_STDC, FRVBF_SFMT_STDC },
  { FRV_INSN_STQ, FRVBF_INSN_STQ, FRVBF_SFMT_LDQ },
  { FRV_INSN_STQF, FRVBF_INSN_STQF, FRVBF_SFMT_LDQF },
  { FRV_INSN_STQC, FRVBF_INSN_STQC, FRVBF_SFMT_LDQC },
  { FRV_INSN_STBU, FRVBF_INSN_STBU, FRVBF_SFMT_STBU },
  { FRV_INSN_STHU, FRVBF_INSN_STHU, FRVBF_SFMT_STBU },
  { FRV_INSN_STU, FRVBF_INSN_STU, FRVBF_SFMT_STBU },
  { FRV_INSN_STBFU, FRVBF_INSN_STBFU, FRVBF_SFMT_STBFU },
  { FRV_INSN_STHFU, FRVBF_INSN_STHFU, FRVBF_SFMT_STBFU },
  { FRV_INSN_STFU, FRVBF_INSN_STFU, FRVBF_SFMT_STBFU },
  { FRV_INSN_STCU, FRVBF_INSN_STCU, FRVBF_SFMT_STCU },
  { FRV_INSN_STDU, FRVBF_INSN_STDU, FRVBF_SFMT_STDU },
  { FRV_INSN_STDFU, FRVBF_INSN_STDFU, FRVBF_SFMT_STDFU },
  { FRV_INSN_STDCU, FRVBF_INSN_STDCU, FRVBF_SFMT_STDCU },
  { FRV_INSN_STQU, FRVBF_INSN_STQU, FRVBF_SFMT_STQU },
  { FRV_INSN_STQFU, FRVBF_INSN_STQFU, FRVBF_SFMT_LDQFU },
  { FRV_INSN_STQCU, FRVBF_INSN_STQCU, FRVBF_SFMT_LDQCU },
  { FRV_INSN_CLDSB, FRVBF_INSN_CLDSB, FRVBF_SFMT_CLDSB },
  { FRV_INSN_CLDUB, FRVBF_INSN_CLDUB, FRVBF_SFMT_CLDSB },
  { FRV_INSN_CLDSH, FRVBF_INSN_CLDSH, FRVBF_SFMT_CLDSB },
  { FRV_INSN_CLDUH, FRVBF_INSN_CLDUH, FRVBF_SFMT_CLDSB },
  { FRV_INSN_CLD, FRVBF_INSN_CLD, FRVBF_SFMT_CLDSB },
  { FRV_INSN_CLDBF, FRVBF_INSN_CLDBF, FRVBF_SFMT_CLDBF },
  { FRV_INSN_CLDHF, FRVBF_INSN_CLDHF, FRVBF_SFMT_CLDBF },
  { FRV_INSN_CLDF, FRVBF_INSN_CLDF, FRVBF_SFMT_CLDBF },
  { FRV_INSN_CLDD, FRVBF_INSN_CLDD, FRVBF_SFMT_CLDD },
  { FRV_INSN_CLDDF, FRVBF_INSN_CLDDF, FRVBF_SFMT_CLDDF },
  { FRV_INSN_CLDQ, FRVBF_INSN_CLDQ, FRVBF_SFMT_CLDQ },
  { FRV_INSN_CLDSBU, FRVBF_INSN_CLDSBU, FRVBF_SFMT_CLDSBU },
  { FRV_INSN_CLDUBU, FRVBF_INSN_CLDUBU, FRVBF_SFMT_CLDSBU },
  { FRV_INSN_CLDSHU, FRVBF_INSN_CLDSHU, FRVBF_SFMT_CLDSBU },
  { FRV_INSN_CLDUHU, FRVBF_INSN_CLDUHU, FRVBF_SFMT_CLDSBU },
  { FRV_INSN_CLDU, FRVBF_INSN_CLDU, FRVBF_SFMT_CLDSBU },
  { FRV_INSN_CLDBFU, FRVBF_INSN_CLDBFU, FRVBF_SFMT_CLDBFU },
  { FRV_INSN_CLDHFU, FRVBF_INSN_CLDHFU, FRVBF_SFMT_CLDBFU },
  { FRV_INSN_CLDFU, FRVBF_INSN_CLDFU, FRVBF_SFMT_CLDBFU },
  { FRV_INSN_CLDDU, FRVBF_INSN_CLDDU, FRVBF_SFMT_CLDDU },
  { FRV_INSN_CLDDFU, FRVBF_INSN_CLDDFU, FRVBF_SFMT_CLDDFU },
  { FRV_INSN_CLDQU, FRVBF_INSN_CLDQU, FRVBF_SFMT_CLDQU },
  { FRV_INSN_CSTB, FRVBF_INSN_CSTB, FRVBF_SFMT_CSTB },
  { FRV_INSN_CSTH, FRVBF_INSN_CSTH, FRVBF_SFMT_CSTB },
  { FRV_INSN_CST, FRVBF_INSN_CST, FRVBF_SFMT_CSTB },
  { FRV_INSN_CSTBF, FRVBF_INSN_CSTBF, FRVBF_SFMT_CSTBF },
  { FRV_INSN_CSTHF, FRVBF_INSN_CSTHF, FRVBF_SFMT_CSTBF },
  { FRV_INSN_CSTF, FRVBF_INSN_CSTF, FRVBF_SFMT_CSTBF },
  { FRV_INSN_CSTD, FRVBF_INSN_CSTD, FRVBF_SFMT_CSTD },
  { FRV_INSN_CSTDF, FRVBF_INSN_CSTDF, FRVBF_SFMT_CSTDF },
  { FRV_INSN_CSTQ, FRVBF_INSN_CSTQ, FRVBF_SFMT_CLDQ },
  { FRV_INSN_CSTBU, FRVBF_INSN_CSTBU, FRVBF_SFMT_CSTBU },
  { FRV_INSN_CSTHU, FRVBF_INSN_CSTHU, FRVBF_SFMT_CSTBU },
  { FRV_INSN_CSTU, FRVBF_INSN_CSTU, FRVBF_SFMT_CSTBU },
  { FRV_INSN_CSTBFU, FRVBF_INSN_CSTBFU, FRVBF_SFMT_CSTBFU },
  { FRV_INSN_CSTHFU, FRVBF_INSN_CSTHFU, FRVBF_SFMT_CSTBFU },
  { FRV_INSN_CSTFU, FRVBF_INSN_CSTFU, FRVBF_SFMT_CSTBFU },
  { FRV_INSN_CSTDU, FRVBF_INSN_CSTDU, FRVBF_SFMT_CSTDU },
  { FRV_INSN_CSTDFU, FRVBF_INSN_CSTDFU, FRVBF_SFMT_CSTDFU },
  { FRV_INSN_STBI, FRVBF_INSN_STBI, FRVBF_SFMT_STBI },
  { FRV_INSN_STHI, FRVBF_INSN_STHI, FRVBF_SFMT_STBI },
  { FRV_INSN_STI, FRVBF_INSN_STI, FRVBF_SFMT_STBI },
  { FRV_INSN_STBFI, FRVBF_INSN_STBFI, FRVBF_SFMT_STBFI },
  { FRV_INSN_STHFI, FRVBF_INSN_STHFI, FRVBF_SFMT_STBFI },
  { FRV_INSN_STFI, FRVBF_INSN_STFI, FRVBF_SFMT_STBFI },
  { FRV_INSN_STDI, FRVBF_INSN_STDI, FRVBF_SFMT_STDI },
  { FRV_INSN_STDFI, FRVBF_INSN_STDFI, FRVBF_SFMT_STDFI },
  { FRV_INSN_STQI, FRVBF_INSN_STQI, FRVBF_SFMT_LDQI },
  { FRV_INSN_STQFI, FRVBF_INSN_STQFI, FRVBF_SFMT_LDQFI },
  { FRV_INSN_SWAP, FRVBF_INSN_SWAP, FRVBF_SFMT_SWAP },
  { FRV_INSN_SWAPI, FRVBF_INSN_SWAPI, FRVBF_SFMT_SWAPI },
  { FRV_INSN_CSWAP, FRVBF_INSN_CSWAP, FRVBF_SFMT_CSWAP },
  { FRV_INSN_MOVGF, FRVBF_INSN_MOVGF, FRVBF_SFMT_MOVGF },
  { FRV_INSN_MOVFG, FRVBF_INSN_MOVFG, FRVBF_SFMT_MOVFG },
  { FRV_INSN_MOVGFD, FRVBF_INSN_MOVGFD, FRVBF_SFMT_MOVGFD },
  { FRV_INSN_MOVFGD, FRVBF_INSN_MOVFGD, FRVBF_SFMT_MOVFGD },
  { FRV_INSN_MOVGFQ, FRVBF_INSN_MOVGFQ, FRVBF_SFMT_MOVGFQ },
  { FRV_INSN_MOVFGQ, FRVBF_INSN_MOVFGQ, FRVBF_SFMT_MOVFGQ },
  { FRV_INSN_CMOVGF, FRVBF_INSN_CMOVGF, FRVBF_SFMT_CMOVGF },
  { FRV_INSN_CMOVFG, FRVBF_INSN_CMOVFG, FRVBF_SFMT_CMOVFG },
  { FRV_INSN_CMOVGFD, FRVBF_INSN_CMOVGFD, FRVBF_SFMT_CMOVGFD },
  { FRV_INSN_CMOVFGD, FRVBF_INSN_CMOVFGD, FRVBF_SFMT_CMOVFGD },
  { FRV_INSN_MOVGS, FRVBF_INSN_MOVGS, FRVBF_SFMT_MOVGS },
  { FRV_INSN_MOVSG, FRVBF_INSN_MOVSG, FRVBF_SFMT_MOVSG },
  { FRV_INSN_BRA, FRVBF_INSN_BRA, FRVBF_SFMT_BRA },
  { FRV_INSN_BNO, FRVBF_INSN_BNO, FRVBF_SFMT_BNO },
  { FRV_INSN_BEQ, FRVBF_INSN_BEQ, FRVBF_SFMT_BEQ },
  { FRV_INSN_BNE, FRVBF_INSN_BNE, FRVBF_SFMT_BEQ },
  { FRV_INSN_BLE, FRVBF_INSN_BLE, FRVBF_SFMT_BEQ },
  { FRV_INSN_BGT, FRVBF_INSN_BGT, FRVBF_SFMT_BEQ },
  { FRV_INSN_BLT, FRVBF_INSN_BLT, FRVBF_SFMT_BEQ },
  { FRV_INSN_BGE, FRVBF_INSN_BGE, FRVBF_SFMT_BEQ },
  { FRV_INSN_BLS, FRVBF_INSN_BLS, FRVBF_SFMT_BEQ },
  { FRV_INSN_BHI, FRVBF_INSN_BHI, FRVBF_SFMT_BEQ },
  { FRV_INSN_BC, FRVBF_INSN_BC, FRVBF_SFMT_BEQ },
  { FRV_INSN_BNC, FRVBF_INSN_BNC, FRVBF_SFMT_BEQ },
  { FRV_INSN_BN, FRVBF_INSN_BN, FRVBF_SFMT_BEQ },
  { FRV_INSN_BP, FRVBF_INSN_BP, FRVBF_SFMT_BEQ },
  { FRV_INSN_BV, FRVBF_INSN_BV, FRVBF_SFMT_BEQ },
  { FRV_INSN_BNV, FRVBF_INSN_BNV, FRVBF_SFMT_BEQ },
  { FRV_INSN_FBRA, FRVBF_INSN_FBRA, FRVBF_SFMT_FBRA },
  { FRV_INSN_FBNO, FRVBF_INSN_FBNO, FRVBF_SFMT_FBNO },
  { FRV_INSN_FBNE, FRVBF_INSN_FBNE, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBEQ, FRVBF_INSN_FBEQ, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBLG, FRVBF_INSN_FBLG, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBUE, FRVBF_INSN_FBUE, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBUL, FRVBF_INSN_FBUL, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBGE, FRVBF_INSN_FBGE, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBLT, FRVBF_INSN_FBLT, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBUGE, FRVBF_INSN_FBUGE, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBUG, FRVBF_INSN_FBUG, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBLE, FRVBF_INSN_FBLE, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBGT, FRVBF_INSN_FBGT, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBULE, FRVBF_INSN_FBULE, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBU, FRVBF_INSN_FBU, FRVBF_SFMT_FBNE },
  { FRV_INSN_FBO, FRVBF_INSN_FBO, FRVBF_SFMT_FBNE },
  { FRV_INSN_BCTRLR, FRVBF_INSN_BCTRLR, FRVBF_SFMT_BCTRLR },
  { FRV_INSN_BRALR, FRVBF_INSN_BRALR, FRVBF_SFMT_BRALR },
  { FRV_INSN_BNOLR, FRVBF_INSN_BNOLR, FRVBF_SFMT_BNOLR },
  { FRV_INSN_BEQLR, FRVBF_INSN_BEQLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BNELR, FRVBF_INSN_BNELR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BLELR, FRVBF_INSN_BLELR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BGTLR, FRVBF_INSN_BGTLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BLTLR, FRVBF_INSN_BLTLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BGELR, FRVBF_INSN_BGELR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BLSLR, FRVBF_INSN_BLSLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BHILR, FRVBF_INSN_BHILR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BCLR, FRVBF_INSN_BCLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BNCLR, FRVBF_INSN_BNCLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BNLR, FRVBF_INSN_BNLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BPLR, FRVBF_INSN_BPLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BVLR, FRVBF_INSN_BVLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_BNVLR, FRVBF_INSN_BNVLR, FRVBF_SFMT_BEQLR },
  { FRV_INSN_FBRALR, FRVBF_INSN_FBRALR, FRVBF_SFMT_FBRALR },
  { FRV_INSN_FBNOLR, FRVBF_INSN_FBNOLR, FRVBF_SFMT_FBNOLR },
  { FRV_INSN_FBEQLR, FRVBF_INSN_FBEQLR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBNELR, FRVBF_INSN_FBNELR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBLGLR, FRVBF_INSN_FBLGLR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBUELR, FRVBF_INSN_FBUELR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBULLR, FRVBF_INSN_FBULLR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBGELR, FRVBF_INSN_FBGELR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBLTLR, FRVBF_INSN_FBLTLR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBUGELR, FRVBF_INSN_FBUGELR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBUGLR, FRVBF_INSN_FBUGLR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBLELR, FRVBF_INSN_FBLELR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBGTLR, FRVBF_INSN_FBGTLR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBULELR, FRVBF_INSN_FBULELR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBULR, FRVBF_INSN_FBULR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_FBOLR, FRVBF_INSN_FBOLR, FRVBF_SFMT_FBEQLR },
  { FRV_INSN_BCRALR, FRVBF_INSN_BCRALR, FRVBF_SFMT_BCRALR },
  { FRV_INSN_BCNOLR, FRVBF_INSN_BCNOLR, FRVBF_SFMT_BCNOLR },
  { FRV_INSN_BCEQLR, FRVBF_INSN_BCEQLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCNELR, FRVBF_INSN_BCNELR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCLELR, FRVBF_INSN_BCLELR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCGTLR, FRVBF_INSN_BCGTLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCLTLR, FRVBF_INSN_BCLTLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCGELR, FRVBF_INSN_BCGELR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCLSLR, FRVBF_INSN_BCLSLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCHILR, FRVBF_INSN_BCHILR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCCLR, FRVBF_INSN_BCCLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCNCLR, FRVBF_INSN_BCNCLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCNLR, FRVBF_INSN_BCNLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCPLR, FRVBF_INSN_BCPLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCVLR, FRVBF_INSN_BCVLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_BCNVLR, FRVBF_INSN_BCNVLR, FRVBF_SFMT_BCEQLR },
  { FRV_INSN_FCBRALR, FRVBF_INSN_FCBRALR, FRVBF_SFMT_FCBRALR },
  { FRV_INSN_FCBNOLR, FRVBF_INSN_FCBNOLR, FRVBF_SFMT_FCBNOLR },
  { FRV_INSN_FCBEQLR, FRVBF_INSN_FCBEQLR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBNELR, FRVBF_INSN_FCBNELR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBLGLR, FRVBF_INSN_FCBLGLR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBUELR, FRVBF_INSN_FCBUELR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBULLR, FRVBF_INSN_FCBULLR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBGELR, FRVBF_INSN_FCBGELR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBLTLR, FRVBF_INSN_FCBLTLR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBUGELR, FRVBF_INSN_FCBUGELR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBUGLR, FRVBF_INSN_FCBUGLR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBLELR, FRVBF_INSN_FCBLELR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBGTLR, FRVBF_INSN_FCBGTLR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBULELR, FRVBF_INSN_FCBULELR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBULR, FRVBF_INSN_FCBULR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_FCBOLR, FRVBF_INSN_FCBOLR, FRVBF_SFMT_FCBEQLR },
  { FRV_INSN_JMPL, FRVBF_INSN_JMPL, FRVBF_SFMT_JMPL },
  { FRV_INSN_CALLL, FRVBF_INSN_CALLL, FRVBF_SFMT_CALLL },
  { FRV_INSN_JMPIL, FRVBF_INSN_JMPIL, FRVBF_SFMT_JMPIL },
  { FRV_INSN_CALLIL, FRVBF_INSN_CALLIL, FRVBF_SFMT_CALLIL },
  { FRV_INSN_CALL, FRVBF_INSN_CALL, FRVBF_SFMT_CALL },
  { FRV_INSN_RETT, FRVBF_INSN_RETT, FRVBF_SFMT_RETT },
  { FRV_INSN_REI, FRVBF_INSN_REI, FRVBF_SFMT_REI },
  { FRV_INSN_TRA, FRVBF_INSN_TRA, FRVBF_SFMT_TRA },
  { FRV_INSN_TNO, FRVBF_INSN_TNO, FRVBF_SFMT_REI },
  { FRV_INSN_TEQ, FRVBF_INSN_TEQ, FRVBF_SFMT_TEQ },
  { FRV_INSN_TNE, FRVBF_INSN_TNE, FRVBF_SFMT_TEQ },
  { FRV_INSN_TLE, FRVBF_INSN_TLE, FRVBF_SFMT_TEQ },
  { FRV_INSN_TGT, FRVBF_INSN_TGT, FRVBF_SFMT_TEQ },
  { FRV_INSN_TLT, FRVBF_INSN_TLT, FRVBF_SFMT_TEQ },
  { FRV_INSN_TGE, FRVBF_INSN_TGE, FRVBF_SFMT_TEQ },
  { FRV_INSN_TLS, FRVBF_INSN_TLS, FRVBF_SFMT_TEQ },
  { FRV_INSN_THI, FRVBF_INSN_THI, FRVBF_SFMT_TEQ },
  { FRV_INSN_TC, FRVBF_INSN_TC, FRVBF_SFMT_TEQ },
  { FRV_INSN_TNC, FRVBF_INSN_TNC, FRVBF_SFMT_TEQ },
  { FRV_INSN_TN, FRVBF_INSN_TN, FRVBF_SFMT_TEQ },
  { FRV_INSN_TP, FRVBF_INSN_TP, FRVBF_SFMT_TEQ },
  { FRV_INSN_TV, FRVBF_INSN_TV, FRVBF_SFMT_TEQ },
  { FRV_INSN_TNV, FRVBF_INSN_TNV, FRVBF_SFMT_TEQ },
  { FRV_INSN_FTRA, FRVBF_INSN_FTRA, FRVBF_SFMT_FTRA },
  { FRV_INSN_FTNO, FRVBF_INSN_FTNO, FRVBF_SFMT_REI },
  { FRV_INSN_FTNE, FRVBF_INSN_FTNE, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTEQ, FRVBF_INSN_FTEQ, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTLG, FRVBF_INSN_FTLG, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTUE, FRVBF_INSN_FTUE, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTUL, FRVBF_INSN_FTUL, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTGE, FRVBF_INSN_FTGE, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTLT, FRVBF_INSN_FTLT, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTUGE, FRVBF_INSN_FTUGE, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTUG, FRVBF_INSN_FTUG, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTLE, FRVBF_INSN_FTLE, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTGT, FRVBF_INSN_FTGT, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTULE, FRVBF_INSN_FTULE, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTU, FRVBF_INSN_FTU, FRVBF_SFMT_FTNE },
  { FRV_INSN_FTO, FRVBF_INSN_FTO, FRVBF_SFMT_FTNE },
  { FRV_INSN_TIRA, FRVBF_INSN_TIRA, FRVBF_SFMT_TIRA },
  { FRV_INSN_TINO, FRVBF_INSN_TINO, FRVBF_SFMT_REI },
  { FRV_INSN_TIEQ, FRVBF_INSN_TIEQ, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TINE, FRVBF_INSN_TINE, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TILE, FRVBF_INSN_TILE, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TIGT, FRVBF_INSN_TIGT, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TILT, FRVBF_INSN_TILT, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TIGE, FRVBF_INSN_TIGE, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TILS, FRVBF_INSN_TILS, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TIHI, FRVBF_INSN_TIHI, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TIC, FRVBF_INSN_TIC, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TINC, FRVBF_INSN_TINC, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TIN, FRVBF_INSN_TIN, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TIP, FRVBF_INSN_TIP, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TIV, FRVBF_INSN_TIV, FRVBF_SFMT_TIEQ },
  { FRV_INSN_TINV, FRVBF_INSN_TINV, FRVBF_SFMT_TIEQ },
  { FRV_INSN_FTIRA, FRVBF_INSN_FTIRA, FRVBF_SFMT_FTIRA },
  { FRV_INSN_FTINO, FRVBF_INSN_FTINO, FRVBF_SFMT_REI },
  { FRV_INSN_FTINE, FRVBF_INSN_FTINE, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIEQ, FRVBF_INSN_FTIEQ, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTILG, FRVBF_INSN_FTILG, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIUE, FRVBF_INSN_FTIUE, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIUL, FRVBF_INSN_FTIUL, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIGE, FRVBF_INSN_FTIGE, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTILT, FRVBF_INSN_FTILT, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIUGE, FRVBF_INSN_FTIUGE, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIUG, FRVBF_INSN_FTIUG, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTILE, FRVBF_INSN_FTILE, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIGT, FRVBF_INSN_FTIGT, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIULE, FRVBF_INSN_FTIULE, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIU, FRVBF_INSN_FTIU, FRVBF_SFMT_FTINE },
  { FRV_INSN_FTIO, FRVBF_INSN_FTIO, FRVBF_SFMT_FTINE },
  { FRV_INSN_BREAK, FRVBF_INSN_BREAK, FRVBF_SFMT_BREAK },
  { FRV_INSN_MTRAP, FRVBF_INSN_MTRAP, FRVBF_SFMT_REI },
  { FRV_INSN_ANDCR, FRVBF_INSN_ANDCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_ORCR, FRVBF_INSN_ORCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_XORCR, FRVBF_INSN_XORCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_NANDCR, FRVBF_INSN_NANDCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_NORCR, FRVBF_INSN_NORCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_ANDNCR, FRVBF_INSN_ANDNCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_ORNCR, FRVBF_INSN_ORNCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_NANDNCR, FRVBF_INSN_NANDNCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_NORNCR, FRVBF_INSN_NORNCR, FRVBF_SFMT_ANDCR },
  { FRV_INSN_NOTCR, FRVBF_INSN_NOTCR, FRVBF_SFMT_NOTCR },
  { FRV_INSN_CKRA, FRVBF_INSN_CKRA, FRVBF_SFMT_CKRA },
  { FRV_INSN_CKNO, FRVBF_INSN_CKNO, FRVBF_SFMT_CKRA },
  { FRV_INSN_CKEQ, FRVBF_INSN_CKEQ, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKNE, FRVBF_INSN_CKNE, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKLE, FRVBF_INSN_CKLE, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKGT, FRVBF_INSN_CKGT, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKLT, FRVBF_INSN_CKLT, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKGE, FRVBF_INSN_CKGE, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKLS, FRVBF_INSN_CKLS, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKHI, FRVBF_INSN_CKHI, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKC, FRVBF_INSN_CKC, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKNC, FRVBF_INSN_CKNC, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKN, FRVBF_INSN_CKN, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKP, FRVBF_INSN_CKP, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKV, FRVBF_INSN_CKV, FRVBF_SFMT_CKEQ },
  { FRV_INSN_CKNV, FRVBF_INSN_CKNV, FRVBF_SFMT_CKEQ },
  { FRV_INSN_FCKRA, FRVBF_INSN_FCKRA, FRVBF_SFMT_FCKRA },
  { FRV_INSN_FCKNO, FRVBF_INSN_FCKNO, FRVBF_SFMT_FCKRA },
  { FRV_INSN_FCKNE, FRVBF_INSN_FCKNE, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKEQ, FRVBF_INSN_FCKEQ, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKLG, FRVBF_INSN_FCKLG, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKUE, FRVBF_INSN_FCKUE, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKUL, FRVBF_INSN_FCKUL, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKGE, FRVBF_INSN_FCKGE, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKLT, FRVBF_INSN_FCKLT, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKUGE, FRVBF_INSN_FCKUGE, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKUG, FRVBF_INSN_FCKUG, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKLE, FRVBF_INSN_FCKLE, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKGT, FRVBF_INSN_FCKGT, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKULE, FRVBF_INSN_FCKULE, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKU, FRVBF_INSN_FCKU, FRVBF_SFMT_FCKNE },
  { FRV_INSN_FCKO, FRVBF_INSN_FCKO, FRVBF_SFMT_FCKNE },
  { FRV_INSN_CCKRA, FRVBF_INSN_CCKRA, FRVBF_SFMT_CCKRA },
  { FRV_INSN_CCKNO, FRVBF_INSN_CCKNO, FRVBF_SFMT_CCKRA },
  { FRV_INSN_CCKEQ, FRVBF_INSN_CCKEQ, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKNE, FRVBF_INSN_CCKNE, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKLE, FRVBF_INSN_CCKLE, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKGT, FRVBF_INSN_CCKGT, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKLT, FRVBF_INSN_CCKLT, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKGE, FRVBF_INSN_CCKGE, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKLS, FRVBF_INSN_CCKLS, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKHI, FRVBF_INSN_CCKHI, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKC, FRVBF_INSN_CCKC, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKNC, FRVBF_INSN_CCKNC, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKN, FRVBF_INSN_CCKN, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKP, FRVBF_INSN_CCKP, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKV, FRVBF_INSN_CCKV, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CCKNV, FRVBF_INSN_CCKNV, FRVBF_SFMT_CCKEQ },
  { FRV_INSN_CFCKRA, FRVBF_INSN_CFCKRA, FRVBF_SFMT_CFCKRA },
  { FRV_INSN_CFCKNO, FRVBF_INSN_CFCKNO, FRVBF_SFMT_CFCKRA },
  { FRV_INSN_CFCKNE, FRVBF_INSN_CFCKNE, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKEQ, FRVBF_INSN_CFCKEQ, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKLG, FRVBF_INSN_CFCKLG, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKUE, FRVBF_INSN_CFCKUE, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKUL, FRVBF_INSN_CFCKUL, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKGE, FRVBF_INSN_CFCKGE, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKLT, FRVBF_INSN_CFCKLT, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKUGE, FRVBF_INSN_CFCKUGE, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKUG, FRVBF_INSN_CFCKUG, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKLE, FRVBF_INSN_CFCKLE, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKGT, FRVBF_INSN_CFCKGT, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKULE, FRVBF_INSN_CFCKULE, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKU, FRVBF_INSN_CFCKU, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CFCKO, FRVBF_INSN_CFCKO, FRVBF_SFMT_CFCKNE },
  { FRV_INSN_CJMPL, FRVBF_INSN_CJMPL, FRVBF_SFMT_CJMPL },
  { FRV_INSN_CCALLL, FRVBF_INSN_CCALLL, FRVBF_SFMT_CCALLL },
  { FRV_INSN_ICI, FRVBF_INSN_ICI, FRVBF_SFMT_ICI },
  { FRV_INSN_DCI, FRVBF_INSN_DCI, FRVBF_SFMT_ICI },
  { FRV_INSN_ICEI, FRVBF_INSN_ICEI, FRVBF_SFMT_ICEI },
  { FRV_INSN_DCEI, FRVBF_INSN_DCEI, FRVBF_SFMT_ICEI },
  { FRV_INSN_DCF, FRVBF_INSN_DCF, FRVBF_SFMT_ICI },
  { FRV_INSN_DCEF, FRVBF_INSN_DCEF, FRVBF_SFMT_ICEI },
  { FRV_INSN_WITLB, FRVBF_INSN_WITLB, FRVBF_SFMT_REI },
  { FRV_INSN_WDTLB, FRVBF_INSN_WDTLB, FRVBF_SFMT_REI },
  { FRV_INSN_ITLBI, FRVBF_INSN_ITLBI, FRVBF_SFMT_REI },
  { FRV_INSN_DTLBI, FRVBF_INSN_DTLBI, FRVBF_SFMT_REI },
  { FRV_INSN_ICPL, FRVBF_INSN_ICPL, FRVBF_SFMT_ICPL },
  { FRV_INSN_DCPL, FRVBF_INSN_DCPL, FRVBF_SFMT_ICPL },
  { FRV_INSN_ICUL, FRVBF_INSN_ICUL, FRVBF_SFMT_ICUL },
  { FRV_INSN_DCUL, FRVBF_INSN_DCUL, FRVBF_SFMT_ICUL },
  { FRV_INSN_BAR, FRVBF_INSN_BAR, FRVBF_SFMT_REI },
  { FRV_INSN_MEMBAR, FRVBF_INSN_MEMBAR, FRVBF_SFMT_REI },
  { FRV_INSN_LRAI, FRVBF_INSN_LRAI, FRVBF_SFMT_REI },
  { FRV_INSN_LRAD, FRVBF_INSN_LRAD, FRVBF_SFMT_REI },
  { FRV_INSN_TLBPR, FRVBF_INSN_TLBPR, FRVBF_SFMT_REI },
  { FRV_INSN_COP1, FRVBF_INSN_COP1, FRVBF_SFMT_REI },
  { FRV_INSN_COP2, FRVBF_INSN_COP2, FRVBF_SFMT_REI },
  { FRV_INSN_CLRGR, FRVBF_INSN_CLRGR, FRVBF_SFMT_CLRGR },
  { FRV_INSN_CLRFR, FRVBF_INSN_CLRFR, FRVBF_SFMT_CLRFR },
  { FRV_INSN_CLRGA, FRVBF_INSN_CLRGA, FRVBF_SFMT_REI },
  { FRV_INSN_CLRFA, FRVBF_INSN_CLRFA, FRVBF_SFMT_REI },
  { FRV_INSN_COMMITGR, FRVBF_INSN_COMMITGR, FRVBF_SFMT_COMMITGR },
  { FRV_INSN_COMMITFR, FRVBF_INSN_COMMITFR, FRVBF_SFMT_COMMITFR },
  { FRV_INSN_COMMITGA, FRVBF_INSN_COMMITGA, FRVBF_SFMT_REI },
  { FRV_INSN_COMMITFA, FRVBF_INSN_COMMITFA, FRVBF_SFMT_REI },
  { FRV_INSN_FITOS, FRVBF_INSN_FITOS, FRVBF_SFMT_FITOS },
  { FRV_INSN_FSTOI, FRVBF_INSN_FSTOI, FRVBF_SFMT_FSTOI },
  { FRV_INSN_FITOD, FRVBF_INSN_FITOD, FRVBF_SFMT_FITOD },
  { FRV_INSN_FDTOI, FRVBF_INSN_FDTOI, FRVBF_SFMT_FDTOI },
  { FRV_INSN_FDITOS, FRVBF_INSN_FDITOS, FRVBF_SFMT_FDITOS },
  { FRV_INSN_FDSTOI, FRVBF_INSN_FDSTOI, FRVBF_SFMT_FDSTOI },
  { FRV_INSN_NFDITOS, FRVBF_INSN_NFDITOS, FRVBF_SFMT_FDITOS },
  { FRV_INSN_NFDSTOI, FRVBF_INSN_NFDSTOI, FRVBF_SFMT_FDSTOI },
  { FRV_INSN_CFITOS, FRVBF_INSN_CFITOS, FRVBF_SFMT_CFITOS },
  { FRV_INSN_CFSTOI, FRVBF_INSN_CFSTOI, FRVBF_SFMT_CFSTOI },
  { FRV_INSN_NFITOS, FRVBF_INSN_NFITOS, FRVBF_SFMT_NFITOS },
  { FRV_INSN_NFSTOI, FRVBF_INSN_NFSTOI, FRVBF_SFMT_NFSTOI },
  { FRV_INSN_FMOVS, FRVBF_INSN_FMOVS, FRVBF_SFMT_FMOVS },
  { FRV_INSN_FMOVD, FRVBF_INSN_FMOVD, FRVBF_SFMT_FMOVD },
  { FRV_INSN_FDMOVS, FRVBF_INSN_FDMOVS, FRVBF_SFMT_FDMOVS },
  { FRV_INSN_CFMOVS, FRVBF_INSN_CFMOVS, FRVBF_SFMT_CFMOVS },
  { FRV_INSN_FNEGS, FRVBF_INSN_FNEGS, FRVBF_SFMT_FMOVS },
  { FRV_INSN_FNEGD, FRVBF_INSN_FNEGD, FRVBF_SFMT_FMOVD },
  { FRV_INSN_FDNEGS, FRVBF_INSN_FDNEGS, FRVBF_SFMT_FDMOVS },
  { FRV_INSN_CFNEGS, FRVBF_INSN_CFNEGS, FRVBF_SFMT_CFMOVS },
  { FRV_INSN_FABSS, FRVBF_INSN_FABSS, FRVBF_SFMT_FMOVS },
  { FRV_INSN_FABSD, FRVBF_INSN_FABSD, FRVBF_SFMT_FMOVD },
  { FRV_INSN_FDABSS, FRVBF_INSN_FDABSS, FRVBF_SFMT_FDMOVS },
  { FRV_INSN_CFABSS, FRVBF_INSN_CFABSS, FRVBF_SFMT_CFMOVS },
  { FRV_INSN_FSQRTS, FRVBF_INSN_FSQRTS, FRVBF_SFMT_FMOVS },
  { FRV_INSN_FDSQRTS, FRVBF_INSN_FDSQRTS, FRVBF_SFMT_FDMOVS },
  { FRV_INSN_NFDSQRTS, FRVBF_INSN_NFDSQRTS, FRVBF_SFMT_FDMOVS },
  { FRV_INSN_FSQRTD, FRVBF_INSN_FSQRTD, FRVBF_SFMT_FMOVD },
  { FRV_INSN_CFSQRTS, FRVBF_INSN_CFSQRTS, FRVBF_SFMT_CFMOVS },
  { FRV_INSN_NFSQRTS, FRVBF_INSN_NFSQRTS, FRVBF_SFMT_NFSQRTS },
  { FRV_INSN_FADDS, FRVBF_INSN_FADDS, FRVBF_SFMT_FADDS },
  { FRV_INSN_FSUBS, FRVBF_INSN_FSUBS, FRVBF_SFMT_FADDS },
  { FRV_INSN_FMULS, FRVBF_INSN_FMULS, FRVBF_SFMT_FADDS },
  { FRV_INSN_FDIVS, FRVBF_INSN_FDIVS, FRVBF_SFMT_FADDS },
  { FRV_INSN_FADDD, FRVBF_INSN_FADDD, FRVBF_SFMT_FADDD },
  { FRV_INSN_FSUBD, FRVBF_INSN_FSUBD, FRVBF_SFMT_FADDD },
  { FRV_INSN_FMULD, FRVBF_INSN_FMULD, FRVBF_SFMT_FADDD },
  { FRV_INSN_FDIVD, FRVBF_INSN_FDIVD, FRVBF_SFMT_FADDD },
  { FRV_INSN_CFADDS, FRVBF_INSN_CFADDS, FRVBF_SFMT_CFADDS },
  { FRV_INSN_CFSUBS, FRVBF_INSN_CFSUBS, FRVBF_SFMT_CFADDS },
  { FRV_INSN_CFMULS, FRVBF_INSN_CFMULS, FRVBF_SFMT_CFADDS },
  { FRV_INSN_CFDIVS, FRVBF_INSN_CFDIVS, FRVBF_SFMT_CFADDS },
  { FRV_INSN_NFADDS, FRVBF_INSN_NFADDS, FRVBF_SFMT_NFADDS },
  { FRV_INSN_NFSUBS, FRVBF_INSN_NFSUBS, FRVBF_SFMT_NFADDS },
  { FRV_INSN_NFMULS, FRVBF_INSN_NFMULS, FRVBF_SFMT_NFADDS },
  { FRV_INSN_NFDIVS, FRVBF_INSN_NFDIVS, FRVBF_SFMT_NFADDS },
  { FRV_INSN_FCMPS, FRVBF_INSN_FCMPS, FRVBF_SFMT_FCMPS },
  { FRV_INSN_FCMPD, FRVBF_INSN_FCMPD, FRVBF_SFMT_FCMPD },
  { FRV_INSN_CFCMPS, FRVBF_INSN_CFCMPS, FRVBF_SFMT_CFCMPS },
  { FRV_INSN_FDCMPS, FRVBF_INSN_FDCMPS, FRVBF_SFMT_FDCMPS },
  { FRV_INSN_FMADDS, FRVBF_INSN_FMADDS, FRVBF_SFMT_FMADDS },
  { FRV_INSN_FMSUBS, FRVBF_INSN_FMSUBS, FRVBF_SFMT_FMADDS },
  { FRV_INSN_FMADDD, FRVBF_INSN_FMADDD, FRVBF_SFMT_FMADDD },
  { FRV_INSN_FMSUBD, FRVBF_INSN_FMSUBD, FRVBF_SFMT_FMADDD },
  { FRV_INSN_FDMADDS, FRVBF_INSN_FDMADDS, FRVBF_SFMT_FDMADDS },
  { FRV_INSN_NFDMADDS, FRVBF_INSN_NFDMADDS, FRVBF_SFMT_FDMADDS },
  { FRV_INSN_CFMADDS, FRVBF_INSN_CFMADDS, FRVBF_SFMT_CFMADDS },
  { FRV_INSN_CFMSUBS, FRVBF_INSN_CFMSUBS, FRVBF_SFMT_CFMADDS },
  { FRV_INSN_NFMADDS, FRVBF_INSN_NFMADDS, FRVBF_SFMT_NFMADDS },
  { FRV_INSN_NFMSUBS, FRVBF_INSN_NFMSUBS, FRVBF_SFMT_NFMADDS },
  { FRV_INSN_FMAS, FRVBF_INSN_FMAS, FRVBF_SFMT_FMAS },
  { FRV_INSN_FMSS, FRVBF_INSN_FMSS, FRVBF_SFMT_FMAS },
  { FRV_INSN_FDMAS, FRVBF_INSN_FDMAS, FRVBF_SFMT_FDMAS },
  { FRV_INSN_FDMSS, FRVBF_INSN_FDMSS, FRVBF_SFMT_FDMAS },
  { FRV_INSN_NFDMAS, FRVBF_INSN_NFDMAS, FRVBF_SFMT_FDMAS },
  { FRV_INSN_NFDMSS, FRVBF_INSN_NFDMSS, FRVBF_SFMT_FDMAS },
  { FRV_INSN_CFMAS, FRVBF_INSN_CFMAS, FRVBF_SFMT_CFMAS },
  { FRV_INSN_CFMSS, FRVBF_INSN_CFMSS, FRVBF_SFMT_CFMAS },
  { FRV_INSN_FMAD, FRVBF_INSN_FMAD, FRVBF_SFMT_FMAS },
  { FRV_INSN_FMSD, FRVBF_INSN_FMSD, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFMAS, FRVBF_INSN_NFMAS, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFMSS, FRVBF_INSN_NFMSS, FRVBF_SFMT_FMAS },
  { FRV_INSN_FDADDS, FRVBF_INSN_FDADDS, FRVBF_SFMT_FMAS },
  { FRV_INSN_FDSUBS, FRVBF_INSN_FDSUBS, FRVBF_SFMT_FMAS },
  { FRV_INSN_FDMULS, FRVBF_INSN_FDMULS, FRVBF_SFMT_FMAS },
  { FRV_INSN_FDDIVS, FRVBF_INSN_FDDIVS, FRVBF_SFMT_FMAS },
  { FRV_INSN_FDSADS, FRVBF_INSN_FDSADS, FRVBF_SFMT_FMAS },
  { FRV_INSN_FDMULCS, FRVBF_INSN_FDMULCS, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFDMULCS, FRVBF_INSN_NFDMULCS, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFDADDS, FRVBF_INSN_NFDADDS, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFDSUBS, FRVBF_INSN_NFDSUBS, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFDMULS, FRVBF_INSN_NFDMULS, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFDDIVS, FRVBF_INSN_NFDDIVS, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFDSADS, FRVBF_INSN_NFDSADS, FRVBF_SFMT_FMAS },
  { FRV_INSN_NFDCMPS, FRVBF_INSN_NFDCMPS, FRVBF_SFMT_NFDCMPS },
  { FRV_INSN_MHSETLOS, FRVBF_INSN_MHSETLOS, FRVBF_SFMT_MHSETLOS },
  { FRV_INSN_MHSETHIS, FRVBF_INSN_MHSETHIS, FRVBF_SFMT_MHSETHIS },
  { FRV_INSN_MHDSETS, FRVBF_INSN_MHDSETS, FRVBF_SFMT_MHDSETS },
  { FRV_INSN_MHSETLOH, FRVBF_INSN_MHSETLOH, FRVBF_SFMT_MHSETLOH },
  { FRV_INSN_MHSETHIH, FRVBF_INSN_MHSETHIH, FRVBF_SFMT_MHSETHIH },
  { FRV_INSN_MHDSETH, FRVBF_INSN_MHDSETH, FRVBF_SFMT_MHDSETH },
  { FRV_INSN_MAND, FRVBF_INSN_MAND, FRVBF_SFMT_MAND },
  { FRV_INSN_MOR, FRVBF_INSN_MOR, FRVBF_SFMT_MAND },
  { FRV_INSN_MXOR, FRVBF_INSN_MXOR, FRVBF_SFMT_MAND },
  { FRV_INSN_CMAND, FRVBF_INSN_CMAND, FRVBF_SFMT_CMAND },
  { FRV_INSN_CMOR, FRVBF_INSN_CMOR, FRVBF_SFMT_CMAND },
  { FRV_INSN_CMXOR, FRVBF_INSN_CMXOR, FRVBF_SFMT_CMAND },
  { FRV_INSN_MNOT, FRVBF_INSN_MNOT, FRVBF_SFMT_MNOT },
  { FRV_INSN_CMNOT, FRVBF_INSN_CMNOT, FRVBF_SFMT_CMNOT },
  { FRV_INSN_MROTLI, FRVBF_INSN_MROTLI, FRVBF_SFMT_MROTLI },
  { FRV_INSN_MROTRI, FRVBF_INSN_MROTRI, FRVBF_SFMT_MROTLI },
  { FRV_INSN_MWCUT, FRVBF_INSN_MWCUT, FRVBF_SFMT_MWCUT },
  { FRV_INSN_MWCUTI, FRVBF_INSN_MWCUTI, FRVBF_SFMT_MWCUTI },
  { FRV_INSN_MCUT, FRVBF_INSN_MCUT, FRVBF_SFMT_MCUT },
  { FRV_INSN_MCUTI, FRVBF_INSN_MCUTI, FRVBF_SFMT_MCUTI },
  { FRV_INSN_MCUTSS, FRVBF_INSN_MCUTSS, FRVBF_SFMT_MCUT },
  { FRV_INSN_MCUTSSI, FRVBF_INSN_MCUTSSI, FRVBF_SFMT_MCUTI },
  { FRV_INSN_MDCUTSSI, FRVBF_INSN_MDCUTSSI, FRVBF_SFMT_MDCUTSSI },
  { FRV_INSN_MAVEH, FRVBF_INSN_MAVEH, FRVBF_SFMT_MAND },
  { FRV_INSN_MSLLHI, FRVBF_INSN_MSLLHI, FRVBF_SFMT_MSLLHI },
  { FRV_INSN_MSRLHI, FRVBF_INSN_MSRLHI, FRVBF_SFMT_MSLLHI },
  { FRV_INSN_MSRAHI, FRVBF_INSN_MSRAHI, FRVBF_SFMT_MSLLHI },
  { FRV_INSN_MDROTLI, FRVBF_INSN_MDROTLI, FRVBF_SFMT_MDROTLI },
  { FRV_INSN_MCPLHI, FRVBF_INSN_MCPLHI, FRVBF_SFMT_MCPLHI },
  { FRV_INSN_MCPLI, FRVBF_INSN_MCPLI, FRVBF_SFMT_MCPLI },
  { FRV_INSN_MSATHS, FRVBF_INSN_MSATHS, FRVBF_SFMT_MSATHS },
  { FRV_INSN_MQSATHS, FRVBF_INSN_MQSATHS, FRVBF_SFMT_MQSATHS },
  { FRV_INSN_MSATHU, FRVBF_INSN_MSATHU, FRVBF_SFMT_MSATHS },
  { FRV_INSN_MCMPSH, FRVBF_INSN_MCMPSH, FRVBF_SFMT_MCMPSH },
  { FRV_INSN_MCMPUH, FRVBF_INSN_MCMPUH, FRVBF_SFMT_MCMPSH },
  { FRV_INSN_MABSHS, FRVBF_INSN_MABSHS, FRVBF_SFMT_MABSHS },
  { FRV_INSN_MADDHSS, FRVBF_INSN_MADDHSS, FRVBF_SFMT_MSATHS },
  { FRV_INSN_MADDHUS, FRVBF_INSN_MADDHUS, FRVBF_SFMT_MSATHS },
  { FRV_INSN_MSUBHSS, FRVBF_INSN_MSUBHSS, FRVBF_SFMT_MSATHS },
  { FRV_INSN_MSUBHUS, FRVBF_INSN_MSUBHUS, FRVBF_SFMT_MSATHS },
  { FRV_INSN_CMADDHSS, FRVBF_INSN_CMADDHSS, FRVBF_SFMT_CMADDHSS },
  { FRV_INSN_CMADDHUS, FRVBF_INSN_CMADDHUS, FRVBF_SFMT_CMADDHSS },
  { FRV_INSN_CMSUBHSS, FRVBF_INSN_CMSUBHSS, FRVBF_SFMT_CMADDHSS },
  { FRV_INSN_CMSUBHUS, FRVBF_INSN_CMSUBHUS, FRVBF_SFMT_CMADDHSS },
  { FRV_INSN_MQADDHSS, FRVBF_INSN_MQADDHSS, FRVBF_SFMT_MQSATHS },
  { FRV_INSN_MQADDHUS, FRVBF_INSN_MQADDHUS, FRVBF_SFMT_MQSATHS },
  { FRV_INSN_MQSUBHSS, FRVBF_INSN_MQSUBHSS, FRVBF_SFMT_MQSATHS },
  { FRV_INSN_MQSUBHUS, FRVBF_INSN_MQSUBHUS, FRVBF_SFMT_MQSATHS },
  { FRV_INSN_CMQADDHSS, FRVBF_INSN_CMQADDHSS, FRVBF_SFMT_CMQADDHSS },
  { FRV_INSN_CMQADDHUS, FRVBF_INSN_CMQADDHUS, FRVBF_SFMT_CMQADDHSS },
  { FRV_INSN_CMQSUBHSS, FRVBF_INSN_CMQSUBHSS, FRVBF_SFMT_CMQADDHSS },
  { FRV_INSN_CMQSUBHUS, FRVBF_INSN_CMQSUBHUS, FRVBF_SFMT_CMQADDHSS },
  { FRV_INSN_MQLCLRHS, FRVBF_INSN_MQLCLRHS, FRVBF_SFMT_MQSATHS },
  { FRV_INSN_MQLMTHS, FRVBF_INSN_MQLMTHS, FRVBF_SFMT_MQSATHS },
  { FRV_INSN_MQSLLHI, FRVBF_INSN_MQSLLHI, FRVBF_SFMT_MQSLLHI },
  { FRV_INSN_MQSRAHI, FRVBF_INSN_MQSRAHI, FRVBF_SFMT_MQSLLHI },
  { FRV_INSN_MADDACCS, FRVBF_INSN_MADDACCS, FRVBF_SFMT_MADDACCS },
  { FRV_INSN_MSUBACCS, FRVBF_INSN_MSUBACCS, FRVBF_SFMT_MADDACCS },
  { FRV_INSN_MDADDACCS, FRVBF_INSN_MDADDACCS, FRVBF_SFMT_MDADDACCS },
  { FRV_INSN_MDSUBACCS, FRVBF_INSN_MDSUBACCS, FRVBF_SFMT_MDADDACCS },
  { FRV_INSN_MASACCS, FRVBF_INSN_MASACCS, FRVBF_SFMT_MASACCS },
  { FRV_INSN_MDASACCS, FRVBF_INSN_MDASACCS, FRVBF_SFMT_MDASACCS },
  { FRV_INSN_MMULHS, FRVBF_INSN_MMULHS, FRVBF_SFMT_MMULHS },
  { FRV_INSN_MMULHU, FRVBF_INSN_MMULHU, FRVBF_SFMT_MMULHS },
  { FRV_INSN_MMULXHS, FRVBF_INSN_MMULXHS, FRVBF_SFMT_MMULHS },
  { FRV_INSN_MMULXHU, FRVBF_INSN_MMULXHU, FRVBF_SFMT_MMULHS },
  { FRV_INSN_CMMULHS, FRVBF_INSN_CMMULHS, FRVBF_SFMT_CMMULHS },
  { FRV_INSN_CMMULHU, FRVBF_INSN_CMMULHU, FRVBF_SFMT_CMMULHS },
  { FRV_INSN_MQMULHS, FRVBF_INSN_MQMULHS, FRVBF_SFMT_MQMULHS },
  { FRV_INSN_MQMULHU, FRVBF_INSN_MQMULHU, FRVBF_SFMT_MQMULHS },
  { FRV_INSN_MQMULXHS, FRVBF_INSN_MQMULXHS, FRVBF_SFMT_MQMULHS },
  { FRV_INSN_MQMULXHU, FRVBF_INSN_MQMULXHU, FRVBF_SFMT_MQMULHS },
  { FRV_INSN_CMQMULHS, FRVBF_INSN_CMQMULHS, FRVBF_SFMT_CMQMULHS },
  { FRV_INSN_CMQMULHU, FRVBF_INSN_CMQMULHU, FRVBF_SFMT_CMQMULHS },
  { FRV_INSN_MMACHS, FRVBF_INSN_MMACHS, FRVBF_SFMT_MMACHS },
  { FRV_INSN_MMACHU, FRVBF_INSN_MMACHU, FRVBF_SFMT_MMACHU },
  { FRV_INSN_MMRDHS, FRVBF_INSN_MMRDHS, FRVBF_SFMT_MMACHS },
  { FRV_INSN_MMRDHU, FRVBF_INSN_MMRDHU, FRVBF_SFMT_MMACHU },
  { FRV_INSN_CMMACHS, FRVBF_INSN_CMMACHS, FRVBF_SFMT_CMMACHS },
  { FRV_INSN_CMMACHU, FRVBF_INSN_CMMACHU, FRVBF_SFMT_CMMACHU },
  { FRV_INSN_MQMACHS, FRVBF_INSN_MQMACHS, FRVBF_SFMT_MQMACHS },
  { FRV_INSN_MQMACHU, FRVBF_INSN_MQMACHU, FRVBF_SFMT_MQMACHU },
  { FRV_INSN_CMQMACHS, FRVBF_INSN_CMQMACHS, FRVBF_SFMT_CMQMACHS },
  { FRV_INSN_CMQMACHU, FRVBF_INSN_CMQMACHU, FRVBF_SFMT_CMQMACHU },
  { FRV_INSN_MQXMACHS, FRVBF_INSN_MQXMACHS, FRVBF_SFMT_MQMACHS },
  { FRV_INSN_MQXMACXHS, FRVBF_INSN_MQXMACXHS, FRVBF_SFMT_MQMACHS },
  { FRV_INSN_MQMACXHS, FRVBF_INSN_MQMACXHS, FRVBF_SFMT_MQMACHS },
  { FRV_INSN_MCPXRS, FRVBF_INSN_MCPXRS, FRVBF_SFMT_MCPXRS },
  { FRV_INSN_MCPXRU, FRVBF_INSN_MCPXRU, FRVBF_SFMT_MCPXRS },
  { FRV_INSN_MCPXIS, FRVBF_INSN_MCPXIS, FRVBF_SFMT_MCPXRS },
  { FRV_INSN_MCPXIU, FRVBF_INSN_MCPXIU, FRVBF_SFMT_MCPXRS },
  { FRV_INSN_CMCPXRS, FRVBF_INSN_CMCPXRS, FRVBF_SFMT_CMCPXRS },
  { FRV_INSN_CMCPXRU, FRVBF_INSN_CMCPXRU, FRVBF_SFMT_CMCPXRS },
  { FRV_INSN_CMCPXIS, FRVBF_INSN_CMCPXIS, FRVBF_SFMT_CMCPXRS },
  { FRV_INSN_CMCPXIU, FRVBF_INSN_CMCPXIU, FRVBF_SFMT_CMCPXRS },
  { FRV_INSN_MQCPXRS, FRVBF_INSN_MQCPXRS, FRVBF_SFMT_MQCPXRS },
  { FRV_INSN_MQCPXRU, FRVBF_INSN_MQCPXRU, FRVBF_SFMT_MQCPXRS },
  { FRV_INSN_MQCPXIS, FRVBF_INSN_MQCPXIS, FRVBF_SFMT_MQCPXRS },
  { FRV_INSN_MQCPXIU, FRVBF_INSN_MQCPXIU, FRVBF_SFMT_MQCPXRS },
  { FRV_INSN_MEXPDHW, FRVBF_INSN_MEXPDHW, FRVBF_SFMT_MEXPDHW },
  { FRV_INSN_CMEXPDHW, FRVBF_INSN_CMEXPDHW, FRVBF_SFMT_CMEXPDHW },
  { FRV_INSN_MEXPDHD, FRVBF_INSN_MEXPDHD, FRVBF_SFMT_MEXPDHD },
  { FRV_INSN_CMEXPDHD, FRVBF_INSN_CMEXPDHD, FRVBF_SFMT_CMEXPDHD },
  { FRV_INSN_MPACKH, FRVBF_INSN_MPACKH, FRVBF_SFMT_MPACKH },
  { FRV_INSN_MDPACKH, FRVBF_INSN_MDPACKH, FRVBF_SFMT_MDPACKH },
  { FRV_INSN_MUNPACKH, FRVBF_INSN_MUNPACKH, FRVBF_SFMT_MUNPACKH },
  { FRV_INSN_MDUNPACKH, FRVBF_INSN_MDUNPACKH, FRVBF_SFMT_MDUNPACKH },
  { FRV_INSN_MBTOH, FRVBF_INSN_MBTOH, FRVBF_SFMT_MBTOH },
  { FRV_INSN_CMBTOH, FRVBF_INSN_CMBTOH, FRVBF_SFMT_CMBTOH },
  { FRV_INSN_MHTOB, FRVBF_INSN_MHTOB, FRVBF_SFMT_MHTOB },
  { FRV_INSN_CMHTOB, FRVBF_INSN_CMHTOB, FRVBF_SFMT_CMHTOB },
  { FRV_INSN_MBTOHE, FRVBF_INSN_MBTOHE, FRVBF_SFMT_MBTOHE },
  { FRV_INSN_CMBTOHE, FRVBF_INSN_CMBTOHE, FRVBF_SFMT_CMBTOHE },
  { FRV_INSN_MNOP, FRVBF_INSN_MNOP, FRVBF_SFMT_REI },
  { FRV_INSN_MCLRACC_0, FRVBF_INSN_MCLRACC_0, FRVBF_SFMT_MCLRACC_0 },
  { FRV_INSN_MCLRACC_1, FRVBF_INSN_MCLRACC_1, FRVBF_SFMT_MCLRACC_0 },
  { FRV_INSN_MRDACC, FRVBF_INSN_MRDACC, FRVBF_SFMT_MRDACC },
  { FRV_INSN_MRDACCG, FRVBF_INSN_MRDACCG, FRVBF_SFMT_MRDACCG },
  { FRV_INSN_MWTACC, FRVBF_INSN_MWTACC, FRVBF_SFMT_MWTACC },
  { FRV_INSN_MWTACCG, FRVBF_INSN_MWTACCG, FRVBF_SFMT_MWTACCG },
  { FRV_INSN_MCOP1, FRVBF_INSN_MCOP1, FRVBF_SFMT_REI },
  { FRV_INSN_MCOP2, FRVBF_INSN_MCOP2, FRVBF_SFMT_REI },
  { FRV_INSN_FNOP, FRVBF_INSN_FNOP, FRVBF_SFMT_REI },
};

static const struct insn_sem frvbf_insn_sem_invalid =
{
  VIRTUAL_INSN_X_INVALID, FRVBF_INSN_X_INVALID, FRVBF_SFMT_EMPTY
};

/* Initialize an IDESC from the compile-time computable parts.  */

static INLINE void
init_idesc (SIM_CPU *cpu, IDESC *id, const struct insn_sem *t)
{
  const CGEN_INSN *insn_table = CGEN_CPU_INSN_TABLE (CPU_CPU_DESC (cpu))->init_entries;

  id->num = t->index;
  id->sfmt = t->sfmt;
  if ((int) t->type <= 0)
    id->idata = & cgen_virtual_insn_table[- (int) t->type];
  else
    id->idata = & insn_table[t->type];
  id->attrs = CGEN_INSN_ATTRS (id->idata);
  /* Oh my god, a magic number.  */
  id->length = CGEN_INSN_BITSIZE (id->idata) / 8;

#if WITH_PROFILE_MODEL_P
  id->timing = & MODEL_TIMING (CPU_MODEL (cpu)) [t->index];
  {
    SIM_DESC sd = CPU_STATE (cpu);
    SIM_ASSERT (t->index == id->timing->num);
  }
#endif

  /* Semantic pointers are initialized elsewhere.  */
}

/* Initialize the instruction descriptor table.  */

void
frvbf_init_idesc_table (SIM_CPU *cpu)
{
  IDESC *id,*tabend;
  const struct insn_sem *t,*tend;
  int tabsize = FRVBF_INSN__MAX;
  IDESC *table = frvbf_insn_data;

  memset (table, 0, tabsize * sizeof (IDESC));

  /* First set all entries to the `invalid insn'.  */
  t = & frvbf_insn_sem_invalid;
  for (id = table, tabend = table + tabsize; id < tabend; ++id)
    init_idesc (cpu, id, t);

  /* Now fill in the values for the chosen cpu.  */
  for (t = frvbf_insn_sem, tend = t + ARRAY_SIZE (frvbf_insn_sem);
       t != tend; ++t)
    {
      init_idesc (cpu, & table[t->index], t);
    }

  /* Link the IDESC table into the cpu.  */
  CPU_IDESC (cpu) = table;
}

/* Given an instruction, return a pointer to its IDESC entry.  */

const IDESC *
frvbf_decode (SIM_CPU *current_cpu, IADDR pc,
              CGEN_INSN_WORD base_insn, CGEN_INSN_WORD entire_insn,
              ARGBUF *abuf)
{
  /* Result of decoder.  */
  FRVBF_INSN_TYPE itype;

  {
    CGEN_INSN_WORD insn = base_insn;

    {
      unsigned int val0 = (((insn >> 18) & (127 << 0)));
      switch (val0)
      {
      case 0:
        {
          unsigned int val1 = (((insn >> 6) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1fc0fc0) == 0x0)
              { itype = FRVBF_INSN_ADD; goto extract_sfmt_add; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1: itype = FRVBF_INSN_ADDCC; goto extract_sfmt_addcc;
          case 2: itype = FRVBF_INSN_ADDX; goto extract_sfmt_addx;
          case 3: itype = FRVBF_INSN_ADDXCC; goto extract_sfmt_addcc;
          case 4:
            if ((entire_insn & 0x1fc0fc0) == 0x100)
              { itype = FRVBF_INSN_SUB; goto extract_sfmt_add; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5: itype = FRVBF_INSN_SUBCC; goto extract_sfmt_addcc;
          case 6: itype = FRVBF_INSN_SUBX; goto extract_sfmt_addx;
          case 7: itype = FRVBF_INSN_SUBXCC; goto extract_sfmt_addcc;
          case 8:
            if ((entire_insn & 0x1fc0fc0) == 0x200)
              { itype = FRVBF_INSN_SMUL; goto extract_sfmt_smul; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9: itype = FRVBF_INSN_SMULCC; goto extract_sfmt_smulcc;
          case 10:
            if ((entire_insn & 0x1fc0fc0) == 0x280)
              { itype = FRVBF_INSN_UMUL; goto extract_sfmt_smul; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11: itype = FRVBF_INSN_UMULCC; goto extract_sfmt_smulcc;
          case 12:
            if ((entire_insn & 0x7ffc03c0) == 0x300)
              { itype = FRVBF_INSN_CMPB; goto extract_sfmt_cmpb; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 13:
            if ((entire_insn & 0x7ffc03c0) == 0x340)
              { itype = FRVBF_INSN_CMPBA; goto extract_sfmt_cmpb; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 14:
            if ((entire_insn & 0x1fc0fc0) == 0x380)
              { itype = FRVBF_INSN_SDIV; goto extract_sfmt_sdiv; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x1fc0fc0) == 0x3c0)
              { itype = FRVBF_INSN_UDIV; goto extract_sfmt_sdiv; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 1:
        {
          unsigned int val1 = (((insn >> 6) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1fc0fc0) == 0x40000)
              { itype = FRVBF_INSN_AND; goto extract_sfmt_add; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1: itype = FRVBF_INSN_ANDCC; goto extract_sfmt_andcc;
          case 2:
            if ((entire_insn & 0x1fc0fc0) == 0x40080)
              { itype = FRVBF_INSN_OR; goto extract_sfmt_add; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3: itype = FRVBF_INSN_ORCC; goto extract_sfmt_andcc;
          case 4:
            if ((entire_insn & 0x1fc0fc0) == 0x40100)
              { itype = FRVBF_INSN_XOR; goto extract_sfmt_add; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5: itype = FRVBF_INSN_XORCC; goto extract_sfmt_andcc;
          case 6:
            if ((entire_insn & 0x1ffffc0) == 0x40180)
              { itype = FRVBF_INSN_NOT; goto extract_sfmt_not; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x1fc0fc0) == 0x40200)
              { itype = FRVBF_INSN_SLL; goto extract_sfmt_add; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9: itype = FRVBF_INSN_SLLCC; goto extract_sfmt_addcc;
          case 10:
            if ((entire_insn & 0x1fc0fc0) == 0x40280)
              { itype = FRVBF_INSN_SRL; goto extract_sfmt_add; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11: itype = FRVBF_INSN_SRLCC; goto extract_sfmt_addcc;
          case 12:
            if ((entire_insn & 0x1fc0fc0) == 0x40300)
              { itype = FRVBF_INSN_SRA; goto extract_sfmt_add; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 13: itype = FRVBF_INSN_SRACC; goto extract_sfmt_addcc;
          case 14:
            if ((entire_insn & 0x1fc0fc0) == 0x40380)
              { itype = FRVBF_INSN_NSDIV; goto extract_sfmt_sdiv; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x1fc0fc0) == 0x403c0)
              { itype = FRVBF_INSN_NUDIV; goto extract_sfmt_sdiv; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 2:
        {
          unsigned int val1 = (((insn >> 6) & (63 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_LDSB; goto extract_sfmt_ldsb;
          case 1: itype = FRVBF_INSN_LDUB; goto extract_sfmt_ldsb;
          case 2: itype = FRVBF_INSN_LDSH; goto extract_sfmt_ldsb;
          case 3: itype = FRVBF_INSN_LDUH; goto extract_sfmt_ldsb;
          case 4: itype = FRVBF_INSN_LD; goto extract_sfmt_ldsb;
          case 5: itype = FRVBF_INSN_LDD; goto extract_sfmt_ldd;
          case 6: itype = FRVBF_INSN_LDQ; goto extract_sfmt_ldq;
          case 8: itype = FRVBF_INSN_LDBF; goto extract_sfmt_ldbf;
          case 9: itype = FRVBF_INSN_LDHF; goto extract_sfmt_ldbf;
          case 10: itype = FRVBF_INSN_LDF; goto extract_sfmt_ldbf;
          case 11: itype = FRVBF_INSN_LDDF; goto extract_sfmt_lddf;
          case 12: itype = FRVBF_INSN_LDQF; goto extract_sfmt_ldqf;
          case 13: itype = FRVBF_INSN_LDC; goto extract_sfmt_ldc;
          case 14: itype = FRVBF_INSN_LDDC; goto extract_sfmt_lddc;
          case 15: itype = FRVBF_INSN_LDQC; goto extract_sfmt_ldqc;
          case 16: itype = FRVBF_INSN_LDSBU; goto extract_sfmt_ldsbu;
          case 17: itype = FRVBF_INSN_LDUBU; goto extract_sfmt_ldsbu;
          case 18: itype = FRVBF_INSN_LDSHU; goto extract_sfmt_ldsbu;
          case 19: itype = FRVBF_INSN_LDUHU; goto extract_sfmt_ldsbu;
          case 20: itype = FRVBF_INSN_LDU; goto extract_sfmt_ldsbu;
          case 21: itype = FRVBF_INSN_LDDU; goto extract_sfmt_lddu;
          case 22: itype = FRVBF_INSN_LDQU; goto extract_sfmt_ldqu;
          case 24: itype = FRVBF_INSN_LDBFU; goto extract_sfmt_ldbfu;
          case 25: itype = FRVBF_INSN_LDHFU; goto extract_sfmt_ldbfu;
          case 26: itype = FRVBF_INSN_LDFU; goto extract_sfmt_ldbfu;
          case 27: itype = FRVBF_INSN_LDDFU; goto extract_sfmt_lddfu;
          case 28: itype = FRVBF_INSN_LDQFU; goto extract_sfmt_ldqfu;
          case 29: itype = FRVBF_INSN_LDCU; goto extract_sfmt_ldcu;
          case 30: itype = FRVBF_INSN_LDDCU; goto extract_sfmt_lddcu;
          case 31: itype = FRVBF_INSN_LDQCU; goto extract_sfmt_ldqcu;
          case 32: itype = FRVBF_INSN_NLDSB; goto extract_sfmt_nldsb;
          case 33: itype = FRVBF_INSN_NLDUB; goto extract_sfmt_nldsb;
          case 34: itype = FRVBF_INSN_NLDSH; goto extract_sfmt_nldsb;
          case 35: itype = FRVBF_INSN_NLDUH; goto extract_sfmt_nldsb;
          case 36: itype = FRVBF_INSN_NLD; goto extract_sfmt_nldsb;
          case 37: itype = FRVBF_INSN_NLDD; goto extract_sfmt_nldd;
          case 38: itype = FRVBF_INSN_NLDQ; goto extract_sfmt_nldq;
          case 40: itype = FRVBF_INSN_NLDBF; goto extract_sfmt_nldbf;
          case 41: itype = FRVBF_INSN_NLDHF; goto extract_sfmt_nldbf;
          case 42: itype = FRVBF_INSN_NLDF; goto extract_sfmt_nldbf;
          case 43: itype = FRVBF_INSN_NLDDF; goto extract_sfmt_nlddf;
          case 44: itype = FRVBF_INSN_NLDQF; goto extract_sfmt_nldqf;
          case 48: itype = FRVBF_INSN_NLDSBU; goto extract_sfmt_nldsbu;
          case 49: itype = FRVBF_INSN_NLDUBU; goto extract_sfmt_nldsbu;
          case 50: itype = FRVBF_INSN_NLDSHU; goto extract_sfmt_nldsbu;
          case 51: itype = FRVBF_INSN_NLDUHU; goto extract_sfmt_nldsbu;
          case 52: itype = FRVBF_INSN_NLDU; goto extract_sfmt_nldsbu;
          case 53: itype = FRVBF_INSN_NLDDU; goto extract_sfmt_nlddu;
          case 54: itype = FRVBF_INSN_NLDQU; goto extract_sfmt_nldqu;
          case 56: itype = FRVBF_INSN_NLDBFU; goto extract_sfmt_nldbfu;
          case 57: itype = FRVBF_INSN_NLDHFU; goto extract_sfmt_nldbfu;
          case 58: itype = FRVBF_INSN_NLDFU; goto extract_sfmt_nldbfu;
          case 59: itype = FRVBF_INSN_NLDDFU; goto extract_sfmt_nlddfu;
          case 60: itype = FRVBF_INSN_NLDQFU; goto extract_sfmt_nldqfu;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 3:
        {
          unsigned int val1 = (((insn >> 6) & (63 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_STB; goto extract_sfmt_stb;
          case 1: itype = FRVBF_INSN_STH; goto extract_sfmt_stb;
          case 2: itype = FRVBF_INSN_ST; goto extract_sfmt_stb;
          case 3: itype = FRVBF_INSN_STD; goto extract_sfmt_std;
          case 4: itype = FRVBF_INSN_STQ; goto extract_sfmt_ldq;
          case 5: itype = FRVBF_INSN_SWAP; goto extract_sfmt_swap;
          case 6: itype = FRVBF_INSN_MOVGS; goto extract_sfmt_movgs;
          case 7: itype = FRVBF_INSN_MOVSG; goto extract_sfmt_movsg;
          case 8: itype = FRVBF_INSN_STBF; goto extract_sfmt_stbf;
          case 9: itype = FRVBF_INSN_STHF; goto extract_sfmt_stbf;
          case 10: itype = FRVBF_INSN_STF; goto extract_sfmt_stbf;
          case 11: itype = FRVBF_INSN_STDF; goto extract_sfmt_stdf;
          case 12: itype = FRVBF_INSN_STQF; goto extract_sfmt_ldqf;
          case 13:
            if ((entire_insn & 0x1ffffc0) == 0xc0340)
              { itype = FRVBF_INSN_MOVFG; goto extract_sfmt_movfg; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 14:
            if ((entire_insn & 0x1ffffc0) == 0xc0380)
              { itype = FRVBF_INSN_MOVFGD; goto extract_sfmt_movfgd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x1ffffc0) == 0xc03c0)
              { itype = FRVBF_INSN_MOVFGQ; goto extract_sfmt_movfgq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 16: itype = FRVBF_INSN_STBU; goto extract_sfmt_stbu;
          case 17: itype = FRVBF_INSN_STHU; goto extract_sfmt_stbu;
          case 18: itype = FRVBF_INSN_STU; goto extract_sfmt_stbu;
          case 19: itype = FRVBF_INSN_STDU; goto extract_sfmt_stdu;
          case 20: itype = FRVBF_INSN_STQU; goto extract_sfmt_stqu;
          case 21:
            if ((entire_insn & 0x1ffffc0) == 0xc0540)
              { itype = FRVBF_INSN_MOVGF; goto extract_sfmt_movgf; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 22:
            if ((entire_insn & 0x1ffffc0) == 0xc0580)
              { itype = FRVBF_INSN_MOVGFD; goto extract_sfmt_movgfd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 23:
            if ((entire_insn & 0x1ffffc0) == 0xc05c0)
              { itype = FRVBF_INSN_MOVGFQ; goto extract_sfmt_movgfq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 24: itype = FRVBF_INSN_STBFU; goto extract_sfmt_stbfu;
          case 25: itype = FRVBF_INSN_STHFU; goto extract_sfmt_stbfu;
          case 26: itype = FRVBF_INSN_STFU; goto extract_sfmt_stbfu;
          case 27: itype = FRVBF_INSN_STDFU; goto extract_sfmt_stdfu;
          case 28: itype = FRVBF_INSN_STQFU; goto extract_sfmt_ldqfu;
          case 32:
            if ((entire_insn & 0x1fc0fc7) == 0xc0800)
              { itype = FRVBF_INSN_LRAI; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 33:
            if ((entire_insn & 0x1fc0fc7) == 0xc0840)
              { itype = FRVBF_INSN_LRAD; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 36:
            if ((entire_insn & 0x61fc0fc0) == 0xc0900)
              { itype = FRVBF_INSN_TLBPR; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 37: itype = FRVBF_INSN_STC; goto extract_sfmt_stc;
          case 38: itype = FRVBF_INSN_STDC; goto extract_sfmt_stdc;
          case 39: itype = FRVBF_INSN_STQC; goto extract_sfmt_ldqc;
          case 45: itype = FRVBF_INSN_STCU; goto extract_sfmt_stcu;
          case 46: itype = FRVBF_INSN_STDCU; goto extract_sfmt_stdcu;
          case 47: itype = FRVBF_INSN_STQCU; goto extract_sfmt_ldqcu;
          case 48:
            if ((entire_insn & 0x7dfc0fc0) == 0xc0c00)
              { itype = FRVBF_INSN_ICPL; goto extract_sfmt_icpl; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 49:
            if ((entire_insn & 0x7ffc0fff) == 0xc0c40)
              { itype = FRVBF_INSN_ICUL; goto extract_sfmt_icul; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 50: itype = FRVBF_INSN_WITLB; goto extract_sfmt_rei;
          case 51:
            if ((entire_insn & 0x7ffc0fc0) == 0xc0cc0)
              { itype = FRVBF_INSN_ITLBI; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 52:
            if ((entire_insn & 0x7dfc0fc0) == 0xc0d00)
              { itype = FRVBF_INSN_DCPL; goto extract_sfmt_icpl; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 53:
            if ((entire_insn & 0x7ffc0fff) == 0xc0d40)
              { itype = FRVBF_INSN_DCUL; goto extract_sfmt_icul; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 54: itype = FRVBF_INSN_WDTLB; goto extract_sfmt_rei;
          case 55:
            if ((entire_insn & 0x7ffc0fc0) == 0xc0dc0)
              { itype = FRVBF_INSN_DTLBI; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 56:
            if ((entire_insn & 0x7ffc0fc0) == 0xc0e00)
              { itype = FRVBF_INSN_ICI; goto extract_sfmt_ici; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 57:
            if ((entire_insn & 0x7dfc0fc0) == 0xc0e40)
              { itype = FRVBF_INSN_ICEI; goto extract_sfmt_icei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 58:
            if ((entire_insn & 0x7dfc0fc0) == 0xc0e80)
              { itype = FRVBF_INSN_DCEI; goto extract_sfmt_icei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 59:
            if ((entire_insn & 0x7dfc0fc0) == 0xc0ec0)
              { itype = FRVBF_INSN_DCEF; goto extract_sfmt_icei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 60:
            if ((entire_insn & 0x7ffc0fc0) == 0xc0f00)
              { itype = FRVBF_INSN_DCI; goto extract_sfmt_ici; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 61:
            if ((entire_insn & 0x7ffc0fc0) == 0xc0f40)
              { itype = FRVBF_INSN_DCF; goto extract_sfmt_ici; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 62:
            if ((entire_insn & 0x7fffffff) == 0xc0f80)
              { itype = FRVBF_INSN_BAR; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 63:
            if ((entire_insn & 0x7fffffff) == 0xc0fc0)
              { itype = FRVBF_INSN_MEMBAR; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 4:
        {
          unsigned int val1 = (((insn >> 25) & (15 << 2)) | ((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x7fffffff) == 0x100000)
              { itype = FRVBF_INSN_TNO; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x7fffffff) == 0x100040)
              { itype = FRVBF_INSN_FTNO; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x7fffffff) == 0x100080)
              { itype = FRVBF_INSN_MTRAP; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3:
            if ((entire_insn & 0x7fffffff) == 0x1000c0)
              { itype = FRVBF_INSN_BREAK; goto extract_sfmt_break; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4:
            if ((entire_insn & 0x79fc0fc0) == 0x8100000)
              { itype = FRVBF_INSN_TC; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x79fc0fc0) == 0x8100040)
              { itype = FRVBF_INSN_FTU; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x79fc0fc0) == 0x10100000)
              { itype = FRVBF_INSN_TV; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9:
            if ((entire_insn & 0x79fc0fc0) == 0x10100040)
              { itype = FRVBF_INSN_FTGT; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 12:
            if ((entire_insn & 0x79fc0fc0) == 0x18100000)
              { itype = FRVBF_INSN_TLT; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 13:
            if ((entire_insn & 0x79fc0fc0) == 0x18100040)
              { itype = FRVBF_INSN_FTUG; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 16:
            if ((entire_insn & 0x79fc0fc0) == 0x20100000)
              { itype = FRVBF_INSN_TEQ; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 17:
            if ((entire_insn & 0x79fc0fc0) == 0x20100040)
              { itype = FRVBF_INSN_FTLT; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 20:
            if ((entire_insn & 0x79fc0fc0) == 0x28100000)
              { itype = FRVBF_INSN_TLS; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 21:
            if ((entire_insn & 0x79fc0fc0) == 0x28100040)
              { itype = FRVBF_INSN_FTUL; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 24:
            if ((entire_insn & 0x79fc0fc0) == 0x30100000)
              { itype = FRVBF_INSN_TN; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 25:
            if ((entire_insn & 0x79fc0fc0) == 0x30100040)
              { itype = FRVBF_INSN_FTLG; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 28:
            if ((entire_insn & 0x79fc0fc0) == 0x38100000)
              { itype = FRVBF_INSN_TLE; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 29:
            if ((entire_insn & 0x79fc0fc0) == 0x38100040)
              { itype = FRVBF_INSN_FTNE; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 32:
            if ((entire_insn & 0x7ffc0fc0) == 0x40100000)
              { itype = FRVBF_INSN_TRA; goto extract_sfmt_tra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 33:
            if ((entire_insn & 0x79fc0fc0) == 0x40100040)
              { itype = FRVBF_INSN_FTEQ; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 36:
            if ((entire_insn & 0x79fc0fc0) == 0x48100000)
              { itype = FRVBF_INSN_TNC; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 37:
            if ((entire_insn & 0x79fc0fc0) == 0x48100040)
              { itype = FRVBF_INSN_FTUE; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 40:
            if ((entire_insn & 0x79fc0fc0) == 0x50100000)
              { itype = FRVBF_INSN_TNV; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 41:
            if ((entire_insn & 0x79fc0fc0) == 0x50100040)
              { itype = FRVBF_INSN_FTGE; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 44:
            if ((entire_insn & 0x79fc0fc0) == 0x58100000)
              { itype = FRVBF_INSN_TGE; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 45:
            if ((entire_insn & 0x79fc0fc0) == 0x58100040)
              { itype = FRVBF_INSN_FTUGE; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 48:
            if ((entire_insn & 0x79fc0fc0) == 0x60100000)
              { itype = FRVBF_INSN_TNE; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 49:
            if ((entire_insn & 0x79fc0fc0) == 0x60100040)
              { itype = FRVBF_INSN_FTLE; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 52:
            if ((entire_insn & 0x79fc0fc0) == 0x68100000)
              { itype = FRVBF_INSN_THI; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 53:
            if ((entire_insn & 0x79fc0fc0) == 0x68100040)
              { itype = FRVBF_INSN_FTULE; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 56:
            if ((entire_insn & 0x79fc0fc0) == 0x70100000)
              { itype = FRVBF_INSN_TP; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 57:
            if ((entire_insn & 0x79fc0fc0) == 0x70100040)
              { itype = FRVBF_INSN_FTO; goto extract_sfmt_ftne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 60:
            if ((entire_insn & 0x79fc0fc0) == 0x78100000)
              { itype = FRVBF_INSN_TGT; goto extract_sfmt_teq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 61:
            if ((entire_insn & 0x7ffc0fc0) == 0x78100040)
              { itype = FRVBF_INSN_FTRA; goto extract_sfmt_ftra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 5:
        if ((entire_insn & 0x7dffffff) == 0x140000)
          { itype = FRVBF_INSN_RETT; goto extract_sfmt_rett; }
        itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      case 6:
        {
          unsigned int val1 = (((insn >> 27) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x7ffcffff) == 0x180000)
              { itype = FRVBF_INSN_BNO; goto extract_sfmt_bno; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1: itype = FRVBF_INSN_BC; goto extract_sfmt_beq;
          case 2: itype = FRVBF_INSN_BV; goto extract_sfmt_beq;
          case 3: itype = FRVBF_INSN_BLT; goto extract_sfmt_beq;
          case 4: itype = FRVBF_INSN_BEQ; goto extract_sfmt_beq;
          case 5: itype = FRVBF_INSN_BLS; goto extract_sfmt_beq;
          case 6: itype = FRVBF_INSN_BN; goto extract_sfmt_beq;
          case 7: itype = FRVBF_INSN_BLE; goto extract_sfmt_beq;
          case 8:
            if ((entire_insn & 0x7ffc0000) == 0x40180000)
              { itype = FRVBF_INSN_BRA; goto extract_sfmt_bra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9: itype = FRVBF_INSN_BNC; goto extract_sfmt_beq;
          case 10: itype = FRVBF_INSN_BNV; goto extract_sfmt_beq;
          case 11: itype = FRVBF_INSN_BGE; goto extract_sfmt_beq;
          case 12: itype = FRVBF_INSN_BNE; goto extract_sfmt_beq;
          case 13: itype = FRVBF_INSN_BHI; goto extract_sfmt_beq;
          case 14: itype = FRVBF_INSN_BP; goto extract_sfmt_beq;
          case 15: itype = FRVBF_INSN_BGT; goto extract_sfmt_beq;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 7:
        {
          unsigned int val1 = (((insn >> 27) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x7ffcffff) == 0x1c0000)
              { itype = FRVBF_INSN_FBNO; goto extract_sfmt_fbno; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1: itype = FRVBF_INSN_FBU; goto extract_sfmt_fbne;
          case 2: itype = FRVBF_INSN_FBGT; goto extract_sfmt_fbne;
          case 3: itype = FRVBF_INSN_FBUG; goto extract_sfmt_fbne;
          case 4: itype = FRVBF_INSN_FBLT; goto extract_sfmt_fbne;
          case 5: itype = FRVBF_INSN_FBUL; goto extract_sfmt_fbne;
          case 6: itype = FRVBF_INSN_FBLG; goto extract_sfmt_fbne;
          case 7: itype = FRVBF_INSN_FBNE; goto extract_sfmt_fbne;
          case 8: itype = FRVBF_INSN_FBEQ; goto extract_sfmt_fbne;
          case 9: itype = FRVBF_INSN_FBUE; goto extract_sfmt_fbne;
          case 10: itype = FRVBF_INSN_FBGE; goto extract_sfmt_fbne;
          case 11: itype = FRVBF_INSN_FBUGE; goto extract_sfmt_fbne;
          case 12: itype = FRVBF_INSN_FBLE; goto extract_sfmt_fbne;
          case 13: itype = FRVBF_INSN_FBULE; goto extract_sfmt_fbne;
          case 14: itype = FRVBF_INSN_FBO; goto extract_sfmt_fbne;
          case 15:
            if ((entire_insn & 0x7ffc0000) == 0x781c0000)
              { itype = FRVBF_INSN_FBRA; goto extract_sfmt_fbra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 8:
        {
          unsigned int val1 = (((insn >> 27) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x79ffffff) == 0x200000)
              { itype = FRVBF_INSN_CKNO; goto extract_sfmt_ckra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x79fffffc) == 0x8200000)
              { itype = FRVBF_INSN_CKC; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x79fffffc) == 0x10200000)
              { itype = FRVBF_INSN_CKV; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3:
            if ((entire_insn & 0x79fffffc) == 0x18200000)
              { itype = FRVBF_INSN_CKLT; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4:
            if ((entire_insn & 0x79fffffc) == 0x20200000)
              { itype = FRVBF_INSN_CKEQ; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x79fffffc) == 0x28200000)
              { itype = FRVBF_INSN_CKLS; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 6:
            if ((entire_insn & 0x79fffffc) == 0x30200000)
              { itype = FRVBF_INSN_CKN; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 7:
            if ((entire_insn & 0x79fffffc) == 0x38200000)
              { itype = FRVBF_INSN_CKLE; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x79ffffff) == 0x40200000)
              { itype = FRVBF_INSN_CKRA; goto extract_sfmt_ckra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9:
            if ((entire_insn & 0x79fffffc) == 0x48200000)
              { itype = FRVBF_INSN_CKNC; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 10:
            if ((entire_insn & 0x79fffffc) == 0x50200000)
              { itype = FRVBF_INSN_CKNV; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11:
            if ((entire_insn & 0x79fffffc) == 0x58200000)
              { itype = FRVBF_INSN_CKGE; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 12:
            if ((entire_insn & 0x79fffffc) == 0x60200000)
              { itype = FRVBF_INSN_CKNE; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 13:
            if ((entire_insn & 0x79fffffc) == 0x68200000)
              { itype = FRVBF_INSN_CKHI; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 14:
            if ((entire_insn & 0x79fffffc) == 0x70200000)
              { itype = FRVBF_INSN_CKP; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x79fffffc) == 0x78200000)
              { itype = FRVBF_INSN_CKGT; goto extract_sfmt_ckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 9:
        {
          unsigned int val1 = (((insn >> 27) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x79fffffc) == 0x240000)
              { itype = FRVBF_INSN_FCKNO; goto extract_sfmt_fckra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x79fffffc) == 0x8240000)
              { itype = FRVBF_INSN_FCKU; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x79fffffc) == 0x10240000)
              { itype = FRVBF_INSN_FCKGT; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3:
            if ((entire_insn & 0x79fffffc) == 0x18240000)
              { itype = FRVBF_INSN_FCKUG; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4:
            if ((entire_insn & 0x79fffffc) == 0x20240000)
              { itype = FRVBF_INSN_FCKLT; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x79fffffc) == 0x28240000)
              { itype = FRVBF_INSN_FCKUL; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 6:
            if ((entire_insn & 0x79fffffc) == 0x30240000)
              { itype = FRVBF_INSN_FCKLG; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 7:
            if ((entire_insn & 0x79fffffc) == 0x38240000)
              { itype = FRVBF_INSN_FCKNE; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x79fffffc) == 0x40240000)
              { itype = FRVBF_INSN_FCKEQ; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9:
            if ((entire_insn & 0x79fffffc) == 0x48240000)
              { itype = FRVBF_INSN_FCKUE; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 10:
            if ((entire_insn & 0x79fffffc) == 0x50240000)
              { itype = FRVBF_INSN_FCKGE; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11:
            if ((entire_insn & 0x79fffffc) == 0x58240000)
              { itype = FRVBF_INSN_FCKUGE; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 12:
            if ((entire_insn & 0x79fffffc) == 0x60240000)
              { itype = FRVBF_INSN_FCKLE; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 13:
            if ((entire_insn & 0x79fffffc) == 0x68240000)
              { itype = FRVBF_INSN_FCKULE; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 14:
            if ((entire_insn & 0x79fffffc) == 0x70240000)
              { itype = FRVBF_INSN_FCKO; goto extract_sfmt_fckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x79fffffc) == 0x78240000)
              { itype = FRVBF_INSN_FCKRA; goto extract_sfmt_fckra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 10:
        {
          unsigned int val1 = (((insn >> 6) & (31 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1ffffff) == 0x280000)
              { itype = FRVBF_INSN_CLRGR; goto extract_sfmt_clrgr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x7fffffff) == 0x280040)
              { itype = FRVBF_INSN_CLRGA; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x1ffffff) == 0x280080)
              { itype = FRVBF_INSN_CLRFR; goto extract_sfmt_clrfr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3:
            if ((entire_insn & 0x7fffffff) == 0x2800c0)
              { itype = FRVBF_INSN_CLRFA; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4:
            if ((entire_insn & 0x1ffffff) == 0x280100)
              { itype = FRVBF_INSN_COMMITGR; goto extract_sfmt_commitgr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x7fffffff) == 0x280140)
              { itype = FRVBF_INSN_COMMITGA; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 6:
            if ((entire_insn & 0x1ffffff) == 0x280180)
              { itype = FRVBF_INSN_COMMITFR; goto extract_sfmt_commitfr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 7:
            if ((entire_insn & 0x7fffffff) == 0x2801c0)
              { itype = FRVBF_INSN_COMMITFA; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x71ff8ff8) == 0x280200)
              { itype = FRVBF_INSN_ANDCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9:
            if ((entire_insn & 0x71ff8ff8) == 0x280240)
              { itype = FRVBF_INSN_ORCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 10:
            if ((entire_insn & 0x71ff8ff8) == 0x280280)
              { itype = FRVBF_INSN_XORCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11:
            if ((entire_insn & 0x71fffff8) == 0x2802c0)
              { itype = FRVBF_INSN_NOTCR; goto extract_sfmt_notcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 12:
            if ((entire_insn & 0x71ff8ff8) == 0x280300)
              { itype = FRVBF_INSN_NANDCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 13:
            if ((entire_insn & 0x71ff8ff8) == 0x280340)
              { itype = FRVBF_INSN_NORCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 16:
            if ((entire_insn & 0x71ff8ff8) == 0x280400)
              { itype = FRVBF_INSN_ANDNCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 17:
            if ((entire_insn & 0x71ff8ff8) == 0x280440)
              { itype = FRVBF_INSN_ORNCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 20:
            if ((entire_insn & 0x71ff8ff8) == 0x280500)
              { itype = FRVBF_INSN_NANDNCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 21:
            if ((entire_insn & 0x71ff8ff8) == 0x280540)
              { itype = FRVBF_INSN_NORNCR; goto extract_sfmt_andcr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 11:
        if ((entire_insn & 0x1fc0fc0) == 0x2c0000)
          { itype = FRVBF_INSN_SCAN; goto extract_sfmt_add; }
        itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      case 12:
        {
          unsigned int val1 = (((insn >> 25) & (1 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x7ffc0fc0) == 0x300000)
              { itype = FRVBF_INSN_JMPL; goto extract_sfmt_jmpl; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x7ffc0fc0) == 0x2300000)
              { itype = FRVBF_INSN_CALLL; goto extract_sfmt_calll; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 13:
        {
          unsigned int val1 = (((insn >> 25) & (1 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x7ffc0000) == 0x340000)
              { itype = FRVBF_INSN_JMPIL; goto extract_sfmt_jmpil; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x7ffc0000) == 0x2340000)
              { itype = FRVBF_INSN_CALLIL; goto extract_sfmt_callil; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 14:
        {
          unsigned int val1 = (((insn >> 25) & (15 << 2)) | ((insn >> 14) & (1 << 1)) | ((insn >> 13) & (1 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x7ffcffff) == 0x384000)
              { itype = FRVBF_INSN_BNOLR; goto extract_sfmt_bnolr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            {
              unsigned int val2 = (((insn >> 14) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x7ffcefff) == 0x382000)
                  { itype = FRVBF_INSN_BCTRLR; goto extract_sfmt_bctrlr; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1:
                if ((entire_insn & 0x7ffcffff) == 0x386000)
                  { itype = FRVBF_INSN_BCNOLR; goto extract_sfmt_bcnolr; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 2:
            if ((entire_insn & 0x7ffcffff) == 0x38c000)
              { itype = FRVBF_INSN_FBNOLR; goto extract_sfmt_fbnolr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3:
            if ((entire_insn & 0x7ffcffff) == 0x38e000)
              { itype = FRVBF_INSN_FCBNOLR; goto extract_sfmt_fcbnolr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4:
            if ((entire_insn & 0x79fcffff) == 0x8384000)
              { itype = FRVBF_INSN_BCLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x79fcefff) == 0x8386000)
              { itype = FRVBF_INSN_BCCLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 6:
            if ((entire_insn & 0x79fcffff) == 0x838c000)
              { itype = FRVBF_INSN_FBULR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 7:
            if ((entire_insn & 0x79fcefff) == 0x838e000)
              { itype = FRVBF_INSN_FCBULR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x79fcffff) == 0x10384000)
              { itype = FRVBF_INSN_BVLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9:
            if ((entire_insn & 0x79fcefff) == 0x10386000)
              { itype = FRVBF_INSN_BCVLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 10:
            if ((entire_insn & 0x79fcffff) == 0x1038c000)
              { itype = FRVBF_INSN_FBGTLR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11:
            if ((entire_insn & 0x79fcefff) == 0x1038e000)
              { itype = FRVBF_INSN_FCBGTLR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 12:
            if ((entire_insn & 0x79fcffff) == 0x18384000)
              { itype = FRVBF_INSN_BLTLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 13:
            if ((entire_insn & 0x79fcefff) == 0x18386000)
              { itype = FRVBF_INSN_BCLTLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 14:
            if ((entire_insn & 0x79fcffff) == 0x1838c000)
              { itype = FRVBF_INSN_FBUGLR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x79fcefff) == 0x1838e000)
              { itype = FRVBF_INSN_FCBUGLR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 16:
            if ((entire_insn & 0x79fcffff) == 0x20384000)
              { itype = FRVBF_INSN_BEQLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 17:
            if ((entire_insn & 0x79fcefff) == 0x20386000)
              { itype = FRVBF_INSN_BCEQLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 18:
            if ((entire_insn & 0x79fcffff) == 0x2038c000)
              { itype = FRVBF_INSN_FBLTLR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 19:
            if ((entire_insn & 0x79fcefff) == 0x2038e000)
              { itype = FRVBF_INSN_FCBLTLR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 20:
            if ((entire_insn & 0x79fcffff) == 0x28384000)
              { itype = FRVBF_INSN_BLSLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 21:
            if ((entire_insn & 0x79fcefff) == 0x28386000)
              { itype = FRVBF_INSN_BCLSLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 22:
            if ((entire_insn & 0x79fcffff) == 0x2838c000)
              { itype = FRVBF_INSN_FBULLR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 23:
            if ((entire_insn & 0x79fcefff) == 0x2838e000)
              { itype = FRVBF_INSN_FCBULLR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 24:
            if ((entire_insn & 0x79fcffff) == 0x30384000)
              { itype = FRVBF_INSN_BNLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 25:
            if ((entire_insn & 0x79fcefff) == 0x30386000)
              { itype = FRVBF_INSN_BCNLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 26:
            if ((entire_insn & 0x79fcffff) == 0x3038c000)
              { itype = FRVBF_INSN_FBLGLR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 27:
            if ((entire_insn & 0x79fcefff) == 0x3038e000)
              { itype = FRVBF_INSN_FCBLGLR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 28:
            if ((entire_insn & 0x79fcffff) == 0x38384000)
              { itype = FRVBF_INSN_BLELR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 29:
            if ((entire_insn & 0x79fcefff) == 0x38386000)
              { itype = FRVBF_INSN_BCLELR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 30:
            if ((entire_insn & 0x79fcffff) == 0x3838c000)
              { itype = FRVBF_INSN_FBNELR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 31:
            if ((entire_insn & 0x79fcefff) == 0x3838e000)
              { itype = FRVBF_INSN_FCBNELR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 32:
            if ((entire_insn & 0x7ffcffff) == 0x40384000)
              { itype = FRVBF_INSN_BRALR; goto extract_sfmt_bralr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 33:
            if ((entire_insn & 0x7ffcefff) == 0x40386000)
              { itype = FRVBF_INSN_BCRALR; goto extract_sfmt_bcralr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 34:
            if ((entire_insn & 0x79fcffff) == 0x4038c000)
              { itype = FRVBF_INSN_FBEQLR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 35:
            if ((entire_insn & 0x79fcefff) == 0x4038e000)
              { itype = FRVBF_INSN_FCBEQLR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 36:
            if ((entire_insn & 0x79fcffff) == 0x48384000)
              { itype = FRVBF_INSN_BNCLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 37:
            if ((entire_insn & 0x79fcefff) == 0x48386000)
              { itype = FRVBF_INSN_BCNCLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 38:
            if ((entire_insn & 0x79fcffff) == 0x4838c000)
              { itype = FRVBF_INSN_FBUELR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 39:
            if ((entire_insn & 0x79fcefff) == 0x4838e000)
              { itype = FRVBF_INSN_FCBUELR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 40:
            if ((entire_insn & 0x79fcffff) == 0x50384000)
              { itype = FRVBF_INSN_BNVLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 41:
            if ((entire_insn & 0x79fcefff) == 0x50386000)
              { itype = FRVBF_INSN_BCNVLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 42:
            if ((entire_insn & 0x79fcffff) == 0x5038c000)
              { itype = FRVBF_INSN_FBGELR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 43:
            if ((entire_insn & 0x79fcefff) == 0x5038e000)
              { itype = FRVBF_INSN_FCBGELR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 44:
            if ((entire_insn & 0x79fcffff) == 0x58384000)
              { itype = FRVBF_INSN_BGELR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 45:
            if ((entire_insn & 0x79fcefff) == 0x58386000)
              { itype = FRVBF_INSN_BCGELR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 46:
            if ((entire_insn & 0x79fcffff) == 0x5838c000)
              { itype = FRVBF_INSN_FBUGELR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 47:
            if ((entire_insn & 0x79fcefff) == 0x5838e000)
              { itype = FRVBF_INSN_FCBUGELR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 48:
            if ((entire_insn & 0x79fcffff) == 0x60384000)
              { itype = FRVBF_INSN_BNELR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 49:
            if ((entire_insn & 0x79fcefff) == 0x60386000)
              { itype = FRVBF_INSN_BCNELR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 50:
            if ((entire_insn & 0x79fcffff) == 0x6038c000)
              { itype = FRVBF_INSN_FBLELR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 51:
            if ((entire_insn & 0x79fcefff) == 0x6038e000)
              { itype = FRVBF_INSN_FCBLELR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 52:
            if ((entire_insn & 0x79fcffff) == 0x68384000)
              { itype = FRVBF_INSN_BHILR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 53:
            if ((entire_insn & 0x79fcefff) == 0x68386000)
              { itype = FRVBF_INSN_BCHILR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 54:
            if ((entire_insn & 0x79fcffff) == 0x6838c000)
              { itype = FRVBF_INSN_FBULELR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 55:
            if ((entire_insn & 0x79fcefff) == 0x6838e000)
              { itype = FRVBF_INSN_FCBULELR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 56:
            if ((entire_insn & 0x79fcffff) == 0x70384000)
              { itype = FRVBF_INSN_BPLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 57:
            if ((entire_insn & 0x79fcefff) == 0x70386000)
              { itype = FRVBF_INSN_BCPLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 58:
            if ((entire_insn & 0x79fcffff) == 0x7038c000)
              { itype = FRVBF_INSN_FBOLR; goto extract_sfmt_fbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 59:
            if ((entire_insn & 0x79fcefff) == 0x7038e000)
              { itype = FRVBF_INSN_FCBOLR; goto extract_sfmt_fcbeqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 60:
            if ((entire_insn & 0x79fcffff) == 0x78384000)
              { itype = FRVBF_INSN_BGTLR; goto extract_sfmt_beqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 61:
            if ((entire_insn & 0x79fcefff) == 0x78386000)
              { itype = FRVBF_INSN_BCGTLR; goto extract_sfmt_bceqlr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 62:
            if ((entire_insn & 0x7ffcffff) == 0x7838c000)
              { itype = FRVBF_INSN_FBRALR; goto extract_sfmt_fbralr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 63:
            if ((entire_insn & 0x7ffcefff) == 0x7838e000)
              { itype = FRVBF_INSN_FCBRALR; goto extract_sfmt_fcbralr; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 15: itype = FRVBF_INSN_CALL; goto extract_sfmt_call;
      case 16: itype = FRVBF_INSN_ADDI; goto extract_sfmt_addi;
      case 17: itype = FRVBF_INSN_ADDICC; goto extract_sfmt_addicc;
      case 18: itype = FRVBF_INSN_ADDXI; goto extract_sfmt_addxi;
      case 19: itype = FRVBF_INSN_ADDXICC; goto extract_sfmt_addicc;
      case 20: itype = FRVBF_INSN_SUBI; goto extract_sfmt_addi;
      case 21: itype = FRVBF_INSN_SUBICC; goto extract_sfmt_addicc;
      case 22: itype = FRVBF_INSN_SUBXI; goto extract_sfmt_addxi;
      case 23: itype = FRVBF_INSN_SUBXICC; goto extract_sfmt_addicc;
      case 24: itype = FRVBF_INSN_SMULI; goto extract_sfmt_smuli;
      case 25: itype = FRVBF_INSN_SMULICC; goto extract_sfmt_smulicc;
      case 26: itype = FRVBF_INSN_UMULI; goto extract_sfmt_smuli;
      case 27: itype = FRVBF_INSN_UMULICC; goto extract_sfmt_smulicc;
      case 28:
        {
          unsigned int val1 = (((insn >> 27) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x7fffffff) == 0x700000)
              { itype = FRVBF_INSN_TINO; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1: itype = FRVBF_INSN_TIC; goto extract_sfmt_tieq;
          case 2: itype = FRVBF_INSN_TIV; goto extract_sfmt_tieq;
          case 3: itype = FRVBF_INSN_TILT; goto extract_sfmt_tieq;
          case 4: itype = FRVBF_INSN_TIEQ; goto extract_sfmt_tieq;
          case 5: itype = FRVBF_INSN_TILS; goto extract_sfmt_tieq;
          case 6: itype = FRVBF_INSN_TIN; goto extract_sfmt_tieq;
          case 7: itype = FRVBF_INSN_TILE; goto extract_sfmt_tieq;
          case 8:
            if ((entire_insn & 0x7ffc0000) == 0x40700000)
              { itype = FRVBF_INSN_TIRA; goto extract_sfmt_tira; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9: itype = FRVBF_INSN_TINC; goto extract_sfmt_tieq;
          case 10: itype = FRVBF_INSN_TINV; goto extract_sfmt_tieq;
          case 11: itype = FRVBF_INSN_TIGE; goto extract_sfmt_tieq;
          case 12: itype = FRVBF_INSN_TINE; goto extract_sfmt_tieq;
          case 13: itype = FRVBF_INSN_TIHI; goto extract_sfmt_tieq;
          case 14: itype = FRVBF_INSN_TIP; goto extract_sfmt_tieq;
          case 15: itype = FRVBF_INSN_TIGT; goto extract_sfmt_tieq;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 29:
        {
          unsigned int val1 = (((insn >> 27) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x7fffffff) == 0x740000)
              { itype = FRVBF_INSN_FTINO; goto extract_sfmt_rei; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1: itype = FRVBF_INSN_FTIU; goto extract_sfmt_ftine;
          case 2: itype = FRVBF_INSN_FTIGT; goto extract_sfmt_ftine;
          case 3: itype = FRVBF_INSN_FTIUG; goto extract_sfmt_ftine;
          case 4: itype = FRVBF_INSN_FTILT; goto extract_sfmt_ftine;
          case 5: itype = FRVBF_INSN_FTIUL; goto extract_sfmt_ftine;
          case 6: itype = FRVBF_INSN_FTILG; goto extract_sfmt_ftine;
          case 7: itype = FRVBF_INSN_FTINE; goto extract_sfmt_ftine;
          case 8: itype = FRVBF_INSN_FTIEQ; goto extract_sfmt_ftine;
          case 9: itype = FRVBF_INSN_FTIUE; goto extract_sfmt_ftine;
          case 10: itype = FRVBF_INSN_FTIGE; goto extract_sfmt_ftine;
          case 11: itype = FRVBF_INSN_FTIUGE; goto extract_sfmt_ftine;
          case 12: itype = FRVBF_INSN_FTILE; goto extract_sfmt_ftine;
          case 13: itype = FRVBF_INSN_FTIULE; goto extract_sfmt_ftine;
          case 14: itype = FRVBF_INSN_FTIO; goto extract_sfmt_ftine;
          case 15:
            if ((entire_insn & 0x7ffc0000) == 0x78740000)
              { itype = FRVBF_INSN_FTIRA; goto extract_sfmt_ftira; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 30: itype = FRVBF_INSN_SDIVI; goto extract_sfmt_sdivi;
      case 31: itype = FRVBF_INSN_UDIVI; goto extract_sfmt_sdivi;
      case 32: itype = FRVBF_INSN_ANDI; goto extract_sfmt_addi;
      case 33: itype = FRVBF_INSN_ANDICC; goto extract_sfmt_andicc;
      case 34: itype = FRVBF_INSN_ORI; goto extract_sfmt_addi;
      case 35: itype = FRVBF_INSN_ORICC; goto extract_sfmt_andicc;
      case 36: itype = FRVBF_INSN_XORI; goto extract_sfmt_addi;
      case 37: itype = FRVBF_INSN_XORICC; goto extract_sfmt_andicc;
      case 40: itype = FRVBF_INSN_SLLI; goto extract_sfmt_addi;
      case 41: itype = FRVBF_INSN_SLLICC; goto extract_sfmt_addicc;
      case 42: itype = FRVBF_INSN_SRLI; goto extract_sfmt_addi;
      case 43: itype = FRVBF_INSN_SRLICC; goto extract_sfmt_addicc;
      case 44: itype = FRVBF_INSN_SRAI; goto extract_sfmt_addi;
      case 45: itype = FRVBF_INSN_SRAICC; goto extract_sfmt_addicc;
      case 46: itype = FRVBF_INSN_NSDIVI; goto extract_sfmt_sdivi;
      case 47: itype = FRVBF_INSN_NUDIVI; goto extract_sfmt_sdivi;
      case 48: itype = FRVBF_INSN_LDSBI; goto extract_sfmt_ldsbi;
      case 49: itype = FRVBF_INSN_LDSHI; goto extract_sfmt_ldsbi;
      case 50: itype = FRVBF_INSN_LDI; goto extract_sfmt_ldsbi;
      case 51: itype = FRVBF_INSN_LDDI; goto extract_sfmt_lddi;
      case 52: itype = FRVBF_INSN_LDQI; goto extract_sfmt_ldqi;
      case 53: itype = FRVBF_INSN_LDUBI; goto extract_sfmt_ldsbi;
      case 54: itype = FRVBF_INSN_LDUHI; goto extract_sfmt_ldsbi;
      case 55:
        if ((entire_insn & 0x7ffc0fff) == 0xdc0000)
          { itype = FRVBF_INSN_REI; goto extract_sfmt_rei; }
        itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      case 56: itype = FRVBF_INSN_LDBFI; goto extract_sfmt_ldbfi;
      case 57: itype = FRVBF_INSN_LDHFI; goto extract_sfmt_ldbfi;
      case 58: itype = FRVBF_INSN_LDFI; goto extract_sfmt_ldbfi;
      case 59: itype = FRVBF_INSN_LDDFI; goto extract_sfmt_lddfi;
      case 60: itype = FRVBF_INSN_LDQFI; goto extract_sfmt_ldqfi;
      case 61:
        if ((entire_insn & 0x1ff0000) == 0xf40000)
          { itype = FRVBF_INSN_SETLO; goto extract_sfmt_setlo; }
        itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      case 62:
        if ((entire_insn & 0x1ff0000) == 0xf80000)
          { itype = FRVBF_INSN_SETHI; goto extract_sfmt_sethi; }
        itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      case 63:
        if ((entire_insn & 0x1ff0000) == 0xfc0000)
          { itype = FRVBF_INSN_SETLOS; goto extract_sfmt_setlos; }
        itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      case 64: itype = FRVBF_INSN_NLDSBI; goto extract_sfmt_nldsbi;
      case 65: itype = FRVBF_INSN_NLDUBI; goto extract_sfmt_nldsbi;
      case 66: itype = FRVBF_INSN_NLDSHI; goto extract_sfmt_nldsbi;
      case 67: itype = FRVBF_INSN_NLDUHI; goto extract_sfmt_nldsbi;
      case 68: itype = FRVBF_INSN_NLDI; goto extract_sfmt_nldsbi;
      case 69: itype = FRVBF_INSN_NLDDI; goto extract_sfmt_nlddi;
      case 70:
        {
          unsigned int val1 = (((insn >> 6) & (7 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1fc0fc0) == 0x1180000)
              { itype = FRVBF_INSN_ADDSS; goto extract_sfmt_slass; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x1fc0fc0) == 0x1180040)
              { itype = FRVBF_INSN_SUBSS; goto extract_sfmt_slass; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x1fc0fc0) == 0x1180080)
              { itype = FRVBF_INSN_SLASS; goto extract_sfmt_slass; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4:
            if ((entire_insn & 0x1ffffc0) == 0x1180100)
              { itype = FRVBF_INSN_SCUTSS; goto extract_sfmt_scutss; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x7ffc0fc0) == 0x1180140)
              { itype = FRVBF_INSN_SMU; goto extract_sfmt_smu; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 6:
            if ((entire_insn & 0x7ffc0fc0) == 0x1180180)
              { itype = FRVBF_INSN_SMASS; goto extract_sfmt_smass; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 7:
            if ((entire_insn & 0x7ffc0fc0) == 0x11801c0)
              { itype = FRVBF_INSN_SMSSS; goto extract_sfmt_smass; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 71: itype = FRVBF_INSN_SCANI; goto extract_sfmt_addi;
      case 72: itype = FRVBF_INSN_NLDBFI; goto extract_sfmt_nldbfi;
      case 73: itype = FRVBF_INSN_NLDHFI; goto extract_sfmt_nldbfi;
      case 74: itype = FRVBF_INSN_NLDFI; goto extract_sfmt_nldbfi;
      case 75: itype = FRVBF_INSN_NLDDFI; goto extract_sfmt_nlddfi;
      case 76: itype = FRVBF_INSN_NLDQFI; goto extract_sfmt_nldqfi;
      case 77: itype = FRVBF_INSN_SWAPI; goto extract_sfmt_swapi;
      case 78: itype = FRVBF_INSN_STBFI; goto extract_sfmt_stbfi;
      case 79: itype = FRVBF_INSN_STHFI; goto extract_sfmt_stbfi;
      case 80: itype = FRVBF_INSN_STBI; goto extract_sfmt_stbi;
      case 81: itype = FRVBF_INSN_STHI; goto extract_sfmt_stbi;
      case 82: itype = FRVBF_INSN_STI; goto extract_sfmt_stbi;
      case 83: itype = FRVBF_INSN_STDI; goto extract_sfmt_stdi;
      case 84: itype = FRVBF_INSN_STQI; goto extract_sfmt_ldqi;
      case 85: itype = FRVBF_INSN_STFI; goto extract_sfmt_stbfi;
      case 86: itype = FRVBF_INSN_STDFI; goto extract_sfmt_stdfi;
      case 87: itype = FRVBF_INSN_STQFI; goto extract_sfmt_ldqfi;
      case 88:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CADD; goto extract_sfmt_cadd;
          case 1: itype = FRVBF_INSN_CSUB; goto extract_sfmt_cadd;
          case 2: itype = FRVBF_INSN_CSMUL; goto extract_sfmt_csmul;
          case 3: itype = FRVBF_INSN_CSDIV; goto extract_sfmt_csdiv;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 89:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CADDCC; goto extract_sfmt_caddcc;
          case 1: itype = FRVBF_INSN_CSUBCC; goto extract_sfmt_caddcc;
          case 2: itype = FRVBF_INSN_CSMULCC; goto extract_sfmt_csmulcc;
          case 3: itype = FRVBF_INSN_CUDIV; goto extract_sfmt_csdiv;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 90:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CAND; goto extract_sfmt_cadd;
          case 1: itype = FRVBF_INSN_COR; goto extract_sfmt_cadd;
          case 2: itype = FRVBF_INSN_CXOR; goto extract_sfmt_cadd;
          case 3:
            if ((entire_insn & 0x1fff0c0) == 0x16800c0)
              { itype = FRVBF_INSN_CNOT; goto extract_sfmt_cnot; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 91:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CANDCC; goto extract_sfmt_caddcc;
          case 1: itype = FRVBF_INSN_CORCC; goto extract_sfmt_caddcc;
          case 2: itype = FRVBF_INSN_CXORCC; goto extract_sfmt_caddcc;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 92:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CSLL; goto extract_sfmt_cadd;
          case 1: itype = FRVBF_INSN_CSRL; goto extract_sfmt_cadd;
          case 2: itype = FRVBF_INSN_CSRA; goto extract_sfmt_cadd;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 93:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CSLLCC; goto extract_sfmt_caddcc;
          case 1: itype = FRVBF_INSN_CSRLCC; goto extract_sfmt_caddcc;
          case 2: itype = FRVBF_INSN_CSRACC; goto extract_sfmt_caddcc;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 94:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CLDSB; goto extract_sfmt_cldsb;
          case 1: itype = FRVBF_INSN_CLDUB; goto extract_sfmt_cldsb;
          case 2: itype = FRVBF_INSN_CLDSH; goto extract_sfmt_cldsb;
          case 3: itype = FRVBF_INSN_CLDUH; goto extract_sfmt_cldsb;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 95:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CLD; goto extract_sfmt_cldsb;
          case 1: itype = FRVBF_INSN_CLDD; goto extract_sfmt_cldd;
          case 2: itype = FRVBF_INSN_CLDQ; goto extract_sfmt_cldq;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 96:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CLDBF; goto extract_sfmt_cldbf;
          case 1: itype = FRVBF_INSN_CLDHF; goto extract_sfmt_cldbf;
          case 2: itype = FRVBF_INSN_CLDF; goto extract_sfmt_cldbf;
          case 3: itype = FRVBF_INSN_CLDDF; goto extract_sfmt_clddf;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 97:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CLDSBU; goto extract_sfmt_cldsbu;
          case 1: itype = FRVBF_INSN_CLDUBU; goto extract_sfmt_cldsbu;
          case 2: itype = FRVBF_INSN_CLDSHU; goto extract_sfmt_cldsbu;
          case 3: itype = FRVBF_INSN_CLDUHU; goto extract_sfmt_cldsbu;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 98:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CLDU; goto extract_sfmt_cldsbu;
          case 1: itype = FRVBF_INSN_CLDDU; goto extract_sfmt_clddu;
          case 2: itype = FRVBF_INSN_CLDQU; goto extract_sfmt_cldqu;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 99:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CLDBFU; goto extract_sfmt_cldbfu;
          case 1: itype = FRVBF_INSN_CLDHFU; goto extract_sfmt_cldbfu;
          case 2: itype = FRVBF_INSN_CLDFU; goto extract_sfmt_cldbfu;
          case 3: itype = FRVBF_INSN_CLDDFU; goto extract_sfmt_clddfu;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 100:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CSTB; goto extract_sfmt_cstb;
          case 1: itype = FRVBF_INSN_CSTH; goto extract_sfmt_cstb;
          case 2: itype = FRVBF_INSN_CST; goto extract_sfmt_cstb;
          case 3: itype = FRVBF_INSN_CSTD; goto extract_sfmt_cstd;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 101:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CSTQ; goto extract_sfmt_cldq;
          case 2: itype = FRVBF_INSN_CSWAP; goto extract_sfmt_cswap;
          case 3: itype = FRVBF_INSN_CSCAN; goto extract_sfmt_cadd;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 102:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CSTBF; goto extract_sfmt_cstbf;
          case 1: itype = FRVBF_INSN_CSTHF; goto extract_sfmt_cstbf;
          case 2: itype = FRVBF_INSN_CSTF; goto extract_sfmt_cstbf;
          case 3: itype = FRVBF_INSN_CSTDF; goto extract_sfmt_cstdf;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 103:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CSTBU; goto extract_sfmt_cstbu;
          case 1: itype = FRVBF_INSN_CSTHU; goto extract_sfmt_cstbu;
          case 2: itype = FRVBF_INSN_CSTU; goto extract_sfmt_cstbu;
          case 3: itype = FRVBF_INSN_CSTDU; goto extract_sfmt_cstdu;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 104:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CSTBFU; goto extract_sfmt_cstbfu;
          case 1: itype = FRVBF_INSN_CSTHFU; goto extract_sfmt_cstbfu;
          case 2: itype = FRVBF_INSN_CSTFU; goto extract_sfmt_cstbfu;
          case 3: itype = FRVBF_INSN_CSTDFU; goto extract_sfmt_cstdfu;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 105:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1fff0c0) == 0x1a40000)
              { itype = FRVBF_INSN_CMOVGF; goto extract_sfmt_cmovgf; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x1fff0c0) == 0x1a40040)
              { itype = FRVBF_INSN_CMOVGFD; goto extract_sfmt_cmovgfd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x1fff0c0) == 0x1a40080)
              { itype = FRVBF_INSN_CMOVFG; goto extract_sfmt_cmovfg; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3:
            if ((entire_insn & 0x1fff0c0) == 0x1a400c0)
              { itype = FRVBF_INSN_CMOVFGD; goto extract_sfmt_cmovfgd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 106:
        {
          unsigned int val1 = (((insn >> 26) & (15 << 1)) | ((insn >> 6) & (1 << 0)));
          switch (val1)
          {
          case 0:
            {
              unsigned int val2 = (((insn >> 24) & (1 << 1)) | ((insn >> 7) & (1 << 0)));
              switch (val2)
              {
              case 0:
              case 2:
                if ((entire_insn & 0x79fff0ff) == 0x1a80000)
                  { itype = FRVBF_INSN_CCKNO; goto extract_sfmt_cckra; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1:
                if ((entire_insn & 0x7ffc00c0) == 0x1a80080)
                  { itype = FRVBF_INSN_CJMPL; goto extract_sfmt_cjmpl; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 3:
                if ((entire_insn & 0x7ffc00c0) == 0x3a80080)
                  { itype = FRVBF_INSN_CCALLL; goto extract_sfmt_ccalll; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 1:
            if ((entire_insn & 0x79fff0ff) == 0x1a80040)
              { itype = FRVBF_INSN_CFCKNO; goto extract_sfmt_cfckra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x79fff0fc) == 0x9a80000)
              { itype = FRVBF_INSN_CCKC; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3:
            if ((entire_insn & 0x79fff0fc) == 0x9a80040)
              { itype = FRVBF_INSN_CFCKU; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4:
            if ((entire_insn & 0x79fff0fc) == 0x11a80000)
              { itype = FRVBF_INSN_CCKV; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x79fff0fc) == 0x11a80040)
              { itype = FRVBF_INSN_CFCKGT; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 6:
            if ((entire_insn & 0x79fff0fc) == 0x19a80000)
              { itype = FRVBF_INSN_CCKLT; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 7:
            if ((entire_insn & 0x79fff0fc) == 0x19a80040)
              { itype = FRVBF_INSN_CFCKUG; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x79fff0fc) == 0x21a80000)
              { itype = FRVBF_INSN_CCKEQ; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9:
            if ((entire_insn & 0x79fff0fc) == 0x21a80040)
              { itype = FRVBF_INSN_CFCKLT; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 10:
            if ((entire_insn & 0x79fff0fc) == 0x29a80000)
              { itype = FRVBF_INSN_CCKLS; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11:
            if ((entire_insn & 0x79fff0fc) == 0x29a80040)
              { itype = FRVBF_INSN_CFCKUL; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 12:
            if ((entire_insn & 0x79fff0fc) == 0x31a80000)
              { itype = FRVBF_INSN_CCKN; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 13:
            if ((entire_insn & 0x79fff0fc) == 0x31a80040)
              { itype = FRVBF_INSN_CFCKLG; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 14:
            if ((entire_insn & 0x79fff0fc) == 0x39a80000)
              { itype = FRVBF_INSN_CCKLE; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x79fff0fc) == 0x39a80040)
              { itype = FRVBF_INSN_CFCKNE; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 16:
            if ((entire_insn & 0x79fff0ff) == 0x41a80000)
              { itype = FRVBF_INSN_CCKRA; goto extract_sfmt_cckra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 17:
            if ((entire_insn & 0x79fff0fc) == 0x41a80040)
              { itype = FRVBF_INSN_CFCKEQ; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 18:
            if ((entire_insn & 0x79fff0fc) == 0x49a80000)
              { itype = FRVBF_INSN_CCKNC; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 19:
            if ((entire_insn & 0x79fff0fc) == 0x49a80040)
              { itype = FRVBF_INSN_CFCKUE; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 20:
            if ((entire_insn & 0x79fff0fc) == 0x51a80000)
              { itype = FRVBF_INSN_CCKNV; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 21:
            if ((entire_insn & 0x79fff0fc) == 0x51a80040)
              { itype = FRVBF_INSN_CFCKGE; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 22:
            if ((entire_insn & 0x79fff0fc) == 0x59a80000)
              { itype = FRVBF_INSN_CCKGE; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 23:
            if ((entire_insn & 0x79fff0fc) == 0x59a80040)
              { itype = FRVBF_INSN_CFCKUGE; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 24:
            if ((entire_insn & 0x79fff0fc) == 0x61a80000)
              { itype = FRVBF_INSN_CCKNE; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 25:
            if ((entire_insn & 0x79fff0fc) == 0x61a80040)
              { itype = FRVBF_INSN_CFCKLE; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 26:
            if ((entire_insn & 0x79fff0fc) == 0x69a80000)
              { itype = FRVBF_INSN_CCKHI; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 27:
            if ((entire_insn & 0x79fff0fc) == 0x69a80040)
              { itype = FRVBF_INSN_CFCKULE; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 28:
            if ((entire_insn & 0x79fff0fc) == 0x71a80000)
              { itype = FRVBF_INSN_CCKP; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 29:
            if ((entire_insn & 0x79fff0fc) == 0x71a80040)
              { itype = FRVBF_INSN_CFCKO; goto extract_sfmt_cfckne; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 30:
            if ((entire_insn & 0x79fff0fc) == 0x79a80000)
              { itype = FRVBF_INSN_CCKGT; goto extract_sfmt_cckeq; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 31:
            if ((entire_insn & 0x79fff0ff) == 0x79a80040)
              { itype = FRVBF_INSN_CFCKRA; goto extract_sfmt_cfckra; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 107:
        {
          unsigned int val1 = (((insn >> 6) & (1 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1fff0c0) == 0x1ac0000)
              { itype = FRVBF_INSN_CFITOS; goto extract_sfmt_cfitos; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x1fff0c0) == 0x1ac0040)
              { itype = FRVBF_INSN_CFSTOI; goto extract_sfmt_cfstoi; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 108:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1fff0c0) == 0x1b00000)
              { itype = FRVBF_INSN_CFMOVS; goto extract_sfmt_cfmovs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x1fff0c0) == 0x1b00040)
              { itype = FRVBF_INSN_CFNEGS; goto extract_sfmt_cfmovs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x1fff0c0) == 0x1b00080)
              { itype = FRVBF_INSN_CFABSS; goto extract_sfmt_cfmovs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 109:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CFADDS; goto extract_sfmt_cfadds;
          case 1: itype = FRVBF_INSN_CFSUBS; goto extract_sfmt_cfadds;
          case 2:
            if ((entire_insn & 0x79fc00c0) == 0x1b40080)
              { itype = FRVBF_INSN_CFCMPS; goto extract_sfmt_cfcmps; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 110:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CFMULS; goto extract_sfmt_cfadds;
          case 1: itype = FRVBF_INSN_CFDIVS; goto extract_sfmt_cfadds;
          case 2:
            if ((entire_insn & 0x1fff0c0) == 0x1b80080)
              { itype = FRVBF_INSN_CFSQRTS; goto extract_sfmt_cfmovs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 111:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CFMADDS; goto extract_sfmt_cfmadds;
          case 1: itype = FRVBF_INSN_CFMSUBS; goto extract_sfmt_cfmadds;
          case 2: itype = FRVBF_INSN_CFMAS; goto extract_sfmt_cfmas;
          case 3: itype = FRVBF_INSN_CFMSS; goto extract_sfmt_cfmas;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 112:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CMAND; goto extract_sfmt_cmand;
          case 1: itype = FRVBF_INSN_CMOR; goto extract_sfmt_cmand;
          case 2: itype = FRVBF_INSN_CMXOR; goto extract_sfmt_cmand;
          case 3:
            if ((entire_insn & 0x1fff0c0) == 0x1c000c0)
              { itype = FRVBF_INSN_CMNOT; goto extract_sfmt_cmnot; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 113:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CMADDHSS; goto extract_sfmt_cmaddhss;
          case 1: itype = FRVBF_INSN_CMADDHUS; goto extract_sfmt_cmaddhss;
          case 2: itype = FRVBF_INSN_CMSUBHSS; goto extract_sfmt_cmaddhss;
          case 3: itype = FRVBF_INSN_CMSUBHUS; goto extract_sfmt_cmaddhss;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 114:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CMMULHS; goto extract_sfmt_cmmulhs;
          case 1: itype = FRVBF_INSN_CMMULHU; goto extract_sfmt_cmmulhs;
          case 2: itype = FRVBF_INSN_CMMACHS; goto extract_sfmt_cmmachs;
          case 3: itype = FRVBF_INSN_CMMACHU; goto extract_sfmt_cmmachu;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 115:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CMQADDHSS; goto extract_sfmt_cmqaddhss;
          case 1: itype = FRVBF_INSN_CMQADDHUS; goto extract_sfmt_cmqaddhss;
          case 2: itype = FRVBF_INSN_CMQSUBHSS; goto extract_sfmt_cmqaddhss;
          case 3: itype = FRVBF_INSN_CMQSUBHUS; goto extract_sfmt_cmqaddhss;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 116:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CMQMULHS; goto extract_sfmt_cmqmulhs;
          case 1: itype = FRVBF_INSN_CMQMULHU; goto extract_sfmt_cmqmulhs;
          case 2: itype = FRVBF_INSN_CMQMACHS; goto extract_sfmt_cmqmachs;
          case 3: itype = FRVBF_INSN_CMQMACHU; goto extract_sfmt_cmqmachu;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 117:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_CMCPXRS; goto extract_sfmt_cmcpxrs;
          case 1: itype = FRVBF_INSN_CMCPXRU; goto extract_sfmt_cmcpxrs;
          case 2: itype = FRVBF_INSN_CMCPXIS; goto extract_sfmt_cmcpxrs;
          case 3: itype = FRVBF_INSN_CMCPXIU; goto extract_sfmt_cmcpxrs;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 118:
        {
          unsigned int val1 = (((insn >> 6) & (1 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1fc00c0) == 0x1d80080)
              { itype = FRVBF_INSN_CMEXPDHW; goto extract_sfmt_cmexpdhw; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x1fc00c0) == 0x1d800c0)
              { itype = FRVBF_INSN_CMEXPDHD; goto extract_sfmt_cmexpdhd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 119:
        {
          unsigned int val1 = (((insn >> 6) & (3 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1fff0c0) == 0x1dc0000)
              { itype = FRVBF_INSN_CMBTOH; goto extract_sfmt_cmbtoh; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x1fff0c0) == 0x1dc0040)
              { itype = FRVBF_INSN_CMHTOB; goto extract_sfmt_cmhtob; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x1fff0c0) == 0x1dc0080)
              { itype = FRVBF_INSN_CMBTOHE; goto extract_sfmt_cmbtohe; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 120:
        {
          unsigned int val1 = (((insn >> 6) & (63 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_MQXMACHS; goto extract_sfmt_mqmachs;
          case 1: itype = FRVBF_INSN_MQXMACXHS; goto extract_sfmt_mqmachs;
          case 2: itype = FRVBF_INSN_MQMACXHS; goto extract_sfmt_mqmachs;
          case 4:
            if ((entire_insn & 0x1fc0fff) == 0x1e00100)
              { itype = FRVBF_INSN_MADDACCS; goto extract_sfmt_maddaccs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x1fc0fff) == 0x1e00140)
              { itype = FRVBF_INSN_MSUBACCS; goto extract_sfmt_maddaccs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 6:
            if ((entire_insn & 0x1fc0fff) == 0x1e00180)
              { itype = FRVBF_INSN_MDADDACCS; goto extract_sfmt_mdaddaccs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 7:
            if ((entire_insn & 0x1fc0fff) == 0x1e001c0)
              { itype = FRVBF_INSN_MDSUBACCS; goto extract_sfmt_mdaddaccs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x1fc0fff) == 0x1e00200)
              { itype = FRVBF_INSN_MASACCS; goto extract_sfmt_masaccs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9:
            if ((entire_insn & 0x1fc0fff) == 0x1e00240)
              { itype = FRVBF_INSN_MDASACCS; goto extract_sfmt_mdasaccs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 10:
            if ((entire_insn & 0x1ffffc0) == 0x1e00280)
              { itype = FRVBF_INSN_MABSHS; goto extract_sfmt_mabshs; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11: itype = FRVBF_INSN_MDROTLI; goto extract_sfmt_mdrotli;
          case 12: itype = FRVBF_INSN_MCPLHI; goto extract_sfmt_mcplhi;
          case 13: itype = FRVBF_INSN_MCPLI; goto extract_sfmt_mcpli;
          case 14: itype = FRVBF_INSN_MDCUTSSI; goto extract_sfmt_mdcutssi;
          case 15: itype = FRVBF_INSN_MQSATHS; goto extract_sfmt_mqsaths;
          case 16: itype = FRVBF_INSN_MQLCLRHS; goto extract_sfmt_mqsaths;
          case 17: itype = FRVBF_INSN_MQSLLHI; goto extract_sfmt_mqsllhi;
          case 19: itype = FRVBF_INSN_MQSRAHI; goto extract_sfmt_mqsllhi;
          case 20: itype = FRVBF_INSN_MQLMTHS; goto extract_sfmt_mqsaths;
          case 32: itype = FRVBF_INSN_MHSETLOS; goto extract_sfmt_mhsetlos;
          case 33:
            if ((entire_insn & 0x1ffffe0) == 0x1e00840)
              { itype = FRVBF_INSN_MHSETLOH; goto extract_sfmt_mhsetloh; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 34: itype = FRVBF_INSN_MHSETHIS; goto extract_sfmt_mhsethis;
          case 35:
            if ((entire_insn & 0x1ffffe0) == 0x1e008c0)
              { itype = FRVBF_INSN_MHSETHIH; goto extract_sfmt_mhsethih; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 36: itype = FRVBF_INSN_MHDSETS; goto extract_sfmt_mhdsets;
          case 37:
            if ((entire_insn & 0x1ffffe0) == 0x1e00940)
              { itype = FRVBF_INSN_MHDSETH; goto extract_sfmt_mhdseth; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 121:
        {
          unsigned int val1 = (((insn >> 7) & (1 << 3)) | ((insn >> 6) & (7 << 0)));
          switch (val1)
          {
          case 0:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40000)
                  { itype = FRVBF_INSN_FITOS; goto extract_sfmt_fitos; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FMULS; goto extract_sfmt_fadds;
              case 2:
                if ((entire_insn & 0x1ffffc0) == 0x1e40800)
                  { itype = FRVBF_INSN_NFITOS; goto extract_sfmt_nfitos; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 3: itype = FRVBF_INSN_NFMULS; goto extract_sfmt_nfadds;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 1:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40040)
                  { itype = FRVBF_INSN_FSTOI; goto extract_sfmt_fstoi; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FDIVS; goto extract_sfmt_fadds;
              case 2:
                if ((entire_insn & 0x1ffffc0) == 0x1e40840)
                  { itype = FRVBF_INSN_NFSTOI; goto extract_sfmt_nfstoi; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 3: itype = FRVBF_INSN_NFDIVS; goto extract_sfmt_nfadds;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 2:
            {
              unsigned int val2 = (((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40080)
                  { itype = FRVBF_INSN_FMOVS; goto extract_sfmt_fmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1:
                if ((entire_insn & 0x79fc0fc0) == 0x1e40280)
                  { itype = FRVBF_INSN_FCMPS; goto extract_sfmt_fcmps; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 3:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e400c0)
                  { itype = FRVBF_INSN_FNEGS; goto extract_sfmt_fmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FMADDS; goto extract_sfmt_fmadds;
              case 3: itype = FRVBF_INSN_NFMADDS; goto extract_sfmt_nfmadds;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 4:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40100)
                  { itype = FRVBF_INSN_FABSS; goto extract_sfmt_fmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FMSUBS; goto extract_sfmt_fmadds;
              case 3: itype = FRVBF_INSN_NFMSUBS; goto extract_sfmt_nfmadds;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 5:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40140)
                  { itype = FRVBF_INSN_FSQRTS; goto extract_sfmt_fmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1:
                if ((entire_insn & 0x7fffffff) == 0x1e40340)
                  { itype = FRVBF_INSN_FNOP; goto extract_sfmt_rei; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 2:
                if ((entire_insn & 0x1ffffc0) == 0x1e40940)
                  { itype = FRVBF_INSN_NFSQRTS; goto extract_sfmt_nfsqrts; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 6:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0: itype = FRVBF_INSN_FADDS; goto extract_sfmt_fadds;
              case 1: itype = FRVBF_INSN_FMAS; goto extract_sfmt_fmas;
              case 2: itype = FRVBF_INSN_NFADDS; goto extract_sfmt_nfadds;
              case 3: itype = FRVBF_INSN_NFMAS; goto extract_sfmt_fmas;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 7:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0: itype = FRVBF_INSN_FSUBS; goto extract_sfmt_fadds;
              case 1: itype = FRVBF_INSN_FMSS; goto extract_sfmt_fmas;
              case 2: itype = FRVBF_INSN_NFSUBS; goto extract_sfmt_nfadds;
              case 3: itype = FRVBF_INSN_NFMSS; goto extract_sfmt_fmas;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 8:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40400)
                  { itype = FRVBF_INSN_FDITOS; goto extract_sfmt_fditos; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FDMULS; goto extract_sfmt_fmas;
              case 2:
                if ((entire_insn & 0x1ffffc0) == 0x1e40c00)
                  { itype = FRVBF_INSN_NFDITOS; goto extract_sfmt_fditos; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 3: itype = FRVBF_INSN_NFDMULS; goto extract_sfmt_fmas;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 9:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40440)
                  { itype = FRVBF_INSN_FDSTOI; goto extract_sfmt_fdstoi; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FDDIVS; goto extract_sfmt_fmas;
              case 2:
                if ((entire_insn & 0x1ffffc0) == 0x1e40c40)
                  { itype = FRVBF_INSN_NFDSTOI; goto extract_sfmt_fdstoi; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 3: itype = FRVBF_INSN_NFDDIVS; goto extract_sfmt_fmas;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 10:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40480)
                  { itype = FRVBF_INSN_FDMOVS; goto extract_sfmt_fdmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1:
                if ((entire_insn & 0x79fc0fc0) == 0x1e40680)
                  { itype = FRVBF_INSN_FDCMPS; goto extract_sfmt_fdcmps; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 3:
                if ((entire_insn & 0x79fc0fc0) == 0x1e40e80)
                  { itype = FRVBF_INSN_NFDCMPS; goto extract_sfmt_nfdcmps; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 11:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e404c0)
                  { itype = FRVBF_INSN_FDNEGS; goto extract_sfmt_fdmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FDMADDS; goto extract_sfmt_fdmadds;
              case 3: itype = FRVBF_INSN_NFDMADDS; goto extract_sfmt_fdmadds;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 12:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40500)
                  { itype = FRVBF_INSN_FDABSS; goto extract_sfmt_fdmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FDMAS; goto extract_sfmt_fdmas;
              case 3: itype = FRVBF_INSN_NFDMAS; goto extract_sfmt_fdmas;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 13:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffc0) == 0x1e40540)
                  { itype = FRVBF_INSN_FDSQRTS; goto extract_sfmt_fdmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1: itype = FRVBF_INSN_FDMSS; goto extract_sfmt_fdmas;
              case 2:
                if ((entire_insn & 0x1ffffc0) == 0x1e40d40)
                  { itype = FRVBF_INSN_NFDSQRTS; goto extract_sfmt_fdmovs; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 3: itype = FRVBF_INSN_NFDMSS; goto extract_sfmt_fdmas;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 14:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0: itype = FRVBF_INSN_FDADDS; goto extract_sfmt_fmas;
              case 1: itype = FRVBF_INSN_FDSADS; goto extract_sfmt_fmas;
              case 2: itype = FRVBF_INSN_NFDADDS; goto extract_sfmt_fmas;
              case 3: itype = FRVBF_INSN_NFDSADS; goto extract_sfmt_fmas;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 15:
            {
              unsigned int val2 = (((insn >> 10) & (1 << 1)) | ((insn >> 9) & (1 << 0)));
              switch (val2)
              {
              case 0: itype = FRVBF_INSN_FDSUBS; goto extract_sfmt_fmas;
              case 1: itype = FRVBF_INSN_FDMULCS; goto extract_sfmt_fmas;
              case 2: itype = FRVBF_INSN_NFDSUBS; goto extract_sfmt_fmas;
              case 3: itype = FRVBF_INSN_NFDMULCS; goto extract_sfmt_fmas;
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 122:
        {
          unsigned int val1 = (((insn >> 6) & (15 << 0)));
          switch (val1)
          {
          case 0:
            if ((entire_insn & 0x1ffffc0) == 0x1e80000)
              { itype = FRVBF_INSN_FITOD; goto extract_sfmt_fitod; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 1:
            if ((entire_insn & 0x1ffffc0) == 0x1e80040)
              { itype = FRVBF_INSN_FDTOI; goto extract_sfmt_fdtoi; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 2:
            if ((entire_insn & 0x1ffffc0) == 0x1e80080)
              { itype = FRVBF_INSN_FMOVD; goto extract_sfmt_fmovd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 3:
            if ((entire_insn & 0x1ffffc0) == 0x1e800c0)
              { itype = FRVBF_INSN_FNEGD; goto extract_sfmt_fmovd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4:
            if ((entire_insn & 0x1ffffc0) == 0x1e80100)
              { itype = FRVBF_INSN_FABSD; goto extract_sfmt_fmovd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 5:
            if ((entire_insn & 0x1ffffc0) == 0x1e80140)
              { itype = FRVBF_INSN_FSQRTD; goto extract_sfmt_fmovd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 6:
            if ((entire_insn & 0x1fc0fc0) == 0x1e80180)
              { itype = FRVBF_INSN_FADDD; goto extract_sfmt_faddd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 7:
            if ((entire_insn & 0x1fc0fc0) == 0x1e801c0)
              { itype = FRVBF_INSN_FSUBD; goto extract_sfmt_faddd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 8:
            if ((entire_insn & 0x1fc0fc0) == 0x1e80200)
              { itype = FRVBF_INSN_FMULD; goto extract_sfmt_faddd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 9:
            if ((entire_insn & 0x1fc0fc0) == 0x1e80240)
              { itype = FRVBF_INSN_FDIVD; goto extract_sfmt_faddd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 10:
            if ((entire_insn & 0x79fc0fc0) == 0x1e80280)
              { itype = FRVBF_INSN_FCMPD; goto extract_sfmt_fcmpd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 11:
            if ((entire_insn & 0x1fc0fc0) == 0x1e802c0)
              { itype = FRVBF_INSN_FMADDD; goto extract_sfmt_fmaddd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 12:
            if ((entire_insn & 0x1fc0fc0) == 0x1e80300)
              { itype = FRVBF_INSN_FMSUBD; goto extract_sfmt_fmaddd; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 14:
            if ((entire_insn & 0x1fc0fc0) == 0x1e80380)
              { itype = FRVBF_INSN_FMAD; goto extract_sfmt_fmas; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x1fc0fc0) == 0x1e803c0)
              { itype = FRVBF_INSN_FMSD; goto extract_sfmt_fmas; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 123:
        {
          unsigned int val1 = (((insn >> 6) & (63 << 0)));
          switch (val1)
          {
          case 0: itype = FRVBF_INSN_MAND; goto extract_sfmt_mand;
          case 1: itype = FRVBF_INSN_MOR; goto extract_sfmt_mand;
          case 2: itype = FRVBF_INSN_MXOR; goto extract_sfmt_mand;
          case 3:
            if ((entire_insn & 0x1ffffc0) == 0x1ec00c0)
              { itype = FRVBF_INSN_MNOT; goto extract_sfmt_mnot; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 4: itype = FRVBF_INSN_MROTLI; goto extract_sfmt_mrotli;
          case 5: itype = FRVBF_INSN_MROTRI; goto extract_sfmt_mrotli;
          case 6: itype = FRVBF_INSN_MWCUT; goto extract_sfmt_mwcut;
          case 7: itype = FRVBF_INSN_MWCUTI; goto extract_sfmt_mwcuti;
          case 8: itype = FRVBF_INSN_MAVEH; goto extract_sfmt_mand;
          case 9: itype = FRVBF_INSN_MSLLHI; goto extract_sfmt_msllhi;
          case 10: itype = FRVBF_INSN_MSRLHI; goto extract_sfmt_msllhi;
          case 11: itype = FRVBF_INSN_MSRAHI; goto extract_sfmt_msllhi;
          case 12: itype = FRVBF_INSN_MSATHS; goto extract_sfmt_msaths;
          case 13: itype = FRVBF_INSN_MSATHU; goto extract_sfmt_msaths;
          case 14:
            if ((entire_insn & 0x79fc0fc0) == 0x1ec0380)
              { itype = FRVBF_INSN_MCMPSH; goto extract_sfmt_mcmpsh; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 15:
            if ((entire_insn & 0x79fc0fc0) == 0x1ec03c0)
              { itype = FRVBF_INSN_MCMPUH; goto extract_sfmt_mcmpsh; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 16: itype = FRVBF_INSN_MADDHSS; goto extract_sfmt_msaths;
          case 17: itype = FRVBF_INSN_MADDHUS; goto extract_sfmt_msaths;
          case 18: itype = FRVBF_INSN_MSUBHSS; goto extract_sfmt_msaths;
          case 19: itype = FRVBF_INSN_MSUBHUS; goto extract_sfmt_msaths;
          case 20: itype = FRVBF_INSN_MMULHS; goto extract_sfmt_mmulhs;
          case 21: itype = FRVBF_INSN_MMULHU; goto extract_sfmt_mmulhs;
          case 22: itype = FRVBF_INSN_MMACHS; goto extract_sfmt_mmachs;
          case 23: itype = FRVBF_INSN_MMACHU; goto extract_sfmt_mmachu;
          case 24: itype = FRVBF_INSN_MQADDHSS; goto extract_sfmt_mqsaths;
          case 25: itype = FRVBF_INSN_MQADDHUS; goto extract_sfmt_mqsaths;
          case 26: itype = FRVBF_INSN_MQSUBHSS; goto extract_sfmt_mqsaths;
          case 27: itype = FRVBF_INSN_MQSUBHUS; goto extract_sfmt_mqsaths;
          case 28: itype = FRVBF_INSN_MQMULHS; goto extract_sfmt_mqmulhs;
          case 29: itype = FRVBF_INSN_MQMULHU; goto extract_sfmt_mqmulhs;
          case 30: itype = FRVBF_INSN_MQMACHS; goto extract_sfmt_mqmachs;
          case 31: itype = FRVBF_INSN_MQMACHU; goto extract_sfmt_mqmachu;
          case 32: itype = FRVBF_INSN_MCPXRS; goto extract_sfmt_mcpxrs;
          case 33: itype = FRVBF_INSN_MCPXRU; goto extract_sfmt_mcpxrs;
          case 34: itype = FRVBF_INSN_MCPXIS; goto extract_sfmt_mcpxrs;
          case 35: itype = FRVBF_INSN_MCPXIU; goto extract_sfmt_mcpxrs;
          case 36: itype = FRVBF_INSN_MQCPXRS; goto extract_sfmt_mqcpxrs;
          case 37: itype = FRVBF_INSN_MQCPXRU; goto extract_sfmt_mqcpxrs;
          case 38: itype = FRVBF_INSN_MQCPXIS; goto extract_sfmt_mqcpxrs;
          case 39: itype = FRVBF_INSN_MQCPXIU; goto extract_sfmt_mqcpxrs;
          case 40: itype = FRVBF_INSN_MMULXHS; goto extract_sfmt_mmulhs;
          case 41: itype = FRVBF_INSN_MMULXHU; goto extract_sfmt_mmulhs;
          case 42: itype = FRVBF_INSN_MQMULXHS; goto extract_sfmt_mqmulhs;
          case 43: itype = FRVBF_INSN_MQMULXHU; goto extract_sfmt_mqmulhs;
          case 44: itype = FRVBF_INSN_MCUT; goto extract_sfmt_mcut;
          case 45: itype = FRVBF_INSN_MCUTSS; goto extract_sfmt_mcut;
          case 46: itype = FRVBF_INSN_MCUTI; goto extract_sfmt_mcuti;
          case 47: itype = FRVBF_INSN_MCUTSSI; goto extract_sfmt_mcuti;
          case 48: itype = FRVBF_INSN_MMRDHS; goto extract_sfmt_mmachs;
          case 49: itype = FRVBF_INSN_MMRDHU; goto extract_sfmt_mmachu;
          case 50: itype = FRVBF_INSN_MEXPDHW; goto extract_sfmt_mexpdhw;
          case 51: itype = FRVBF_INSN_MEXPDHD; goto extract_sfmt_mexpdhd;
          case 52: itype = FRVBF_INSN_MPACKH; goto extract_sfmt_mpackh;
          case 53:
            if ((entire_insn & 0x1fc0fff) == 0x1ec0d40)
              { itype = FRVBF_INSN_MUNPACKH; goto extract_sfmt_munpackh; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 54: itype = FRVBF_INSN_MDPACKH; goto extract_sfmt_mdpackh;
          case 55:
            if ((entire_insn & 0x1fc0fff) == 0x1ec0dc0)
              { itype = FRVBF_INSN_MDUNPACKH; goto extract_sfmt_mdunpackh; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 56:
            if ((entire_insn & 0x1ffffc0) == 0x1ec0e00)
              { itype = FRVBF_INSN_MBTOH; goto extract_sfmt_mbtoh; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 57:
            if ((entire_insn & 0x1ffffc0) == 0x1ec0e40)
              { itype = FRVBF_INSN_MHTOB; goto extract_sfmt_mhtob; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 58:
            if ((entire_insn & 0x1ffffc0) == 0x1ec0e80)
              { itype = FRVBF_INSN_MBTOHE; goto extract_sfmt_mbtohe; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 59:
            {
              unsigned int val2 = (((insn >> 17) & (1 << 0)));
              switch (val2)
              {
              case 0:
                if ((entire_insn & 0x1ffffff) == 0x1ec0ec0)
                  { itype = FRVBF_INSN_MCLRACC_0; goto extract_sfmt_mclracc_0; }
                itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              case 1:
                {
                  unsigned int val3 = (((insn >> 25) & (63 << 0)));
                  switch (val3)
                  {
                  case 0:
                  case 1:
                  case 2:
                  case 3:
                  case 4:
                  case 5:
                  case 6:
                  case 7:
                  case 8:
                  case 9:
                  case 10:
                  case 11:
                  case 12:
                  case 13:
                  case 14:
                  case 15:
                  case 16:
                  case 17:
                  case 18:
                  case 19:
                  case 20:
                  case 21:
                  case 22:
                  case 23:
                  case 24:
                  case 25:
                  case 26:
                  case 27:
                  case 28:
                  case 29:
                  case 30:
                  case 31:
                  case 32:
                  case 33:
                  case 34:
                  case 35:
                  case 36:
                  case 37:
                  case 38:
                  case 39:
                  case 40:
                  case 41:
                  case 42:
                  case 43:
                  case 44:
                  case 45:
                  case 46:
                  case 47:
                  case 48:
                  case 49:
                  case 50:
                  case 51:
                  case 52:
                  case 53:
                  case 54:
                  case 55:
                  case 56:
                  case 57:
                  case 58:
                  case 59:
                  case 60:
                  case 61:
                  case 62:
                    if ((entire_insn & 0x1ffffff) == 0x1ee0ec0)
                      { itype = FRVBF_INSN_MCLRACC_1; goto extract_sfmt_mclracc_0; }
                    itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
                  case 63:
                    if ((entire_insn & 0x7fffffff) == 0x7fee0ec0)
                      { itype = FRVBF_INSN_MNOP; goto extract_sfmt_rei; }
                    itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
                  default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
                  }
                }
              default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
              }
            }
          case 60:
            if ((entire_insn & 0x1fc0fff) == 0x1ec0f00)
              { itype = FRVBF_INSN_MRDACC; goto extract_sfmt_mrdacc; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 61:
            if ((entire_insn & 0x1fc0fff) == 0x1ec0f40)
              { itype = FRVBF_INSN_MWTACC; goto extract_sfmt_mwtacc; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 62:
            if ((entire_insn & 0x1fc0fff) == 0x1ec0f80)
              { itype = FRVBF_INSN_MRDACCG; goto extract_sfmt_mrdaccg; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          case 63:
            if ((entire_insn & 0x1fc0fff) == 0x1ec0fc0)
              { itype = FRVBF_INSN_MWTACCG; goto extract_sfmt_mwtaccg; }
            itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
          }
        }
      case 124:
        if ((entire_insn & 0x1fc0fc0) == 0x1f00000)
          { itype = FRVBF_INSN_MCOP1; goto extract_sfmt_rei; }
        itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      case 125:
        if ((entire_insn & 0x1fc0fc0) == 0x1f40000)
          { itype = FRVBF_INSN_MCOP2; goto extract_sfmt_rei; }
        itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      case 126: itype = FRVBF_INSN_COP1; goto extract_sfmt_rei;
      case 127: itype = FRVBF_INSN_COP2; goto extract_sfmt_rei;
      default: itype = FRVBF_INSN_X_INVALID; goto extract_sfmt_empty;
      }
    }
  }

  /* The instruction has been decoded, now extract the fields.  */

 extract_sfmt_empty:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
#define FLD(f) abuf->fields.sfmt_empty.f


  /* Record the fields for the semantic handler.  */
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_empty", (char *) 0));

#undef FLD
    return idesc;
  }

 extract_sfmt_add:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_add", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_not:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_scutss.f
    UINT f_GRk;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_not", "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_sdiv:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_sdiv", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_smul:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smulcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_smul", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRdoublek) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_smu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smass.f
    UINT f_GRi;
    UINT f_GRj;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_smu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_h_iacc0_DI_0) = 0;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_smass:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smass.f
    UINT f_GRi;
    UINT f_GRj;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_smass", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_h_iacc0_DI_0) = 0;
      FLD (out_h_iacc0_DI_0) = 0;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_slass:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_slass", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_scutss:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_scutss.f
    UINT f_GRk;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_scutss", "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRj) = f_GRj;
      FLD (in_h_iacc0_DI_0) = 0;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cadd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cadd", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cnot:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cnot", "f_CCi 0x%x", 'x', f_CCi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_csmul:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_csmul", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRdoublek) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_csdiv:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_csdiv", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_addcc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_ICCi_1;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_ICCi_1) = f_ICCi_1;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_addcc", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_ICCi_1 0x%x", 'x', f_ICCi_1, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_ICCi_1) = f_ICCi_1;
      FLD (out_GRk) = f_GRk;
      FLD (out_ICCi_1) = f_ICCi_1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_andcc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_ICCi_1;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_ICCi_1) = f_ICCi_1;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_andcc", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_ICCi_1 0x%x", 'x', f_ICCi_1, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_ICCi_1) = f_ICCi_1;
      FLD (out_GRk) = f_GRk;
      FLD (out_ICCi_1) = f_ICCi_1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_smulcc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smulcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_ICCi_1;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_ICCi_1) = f_ICCi_1;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_smulcc", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_ICCi_1 0x%x", 'x', f_ICCi_1, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_ICCi_1) = f_ICCi_1;
      FLD (out_GRdoublek) = f_GRk;
      FLD (out_ICCi_1) = f_ICCi_1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_caddcc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_caddcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_caddcc", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_h_iccr_UQI_and__INT_index_of__INT_CCi_3) = ((FLD (f_CCi)) & (3));
      FLD (out_GRk) = f_GRk;
      FLD (out_h_iccr_UQI_and__INT_index_of__INT_CCi_3) = ((FLD (f_CCi)) & (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_csmulcc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_csmulcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_csmulcc", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_h_iccr_UQI_and__INT_index_of__INT_CCi_3) = ((FLD (f_CCi)) & (3));
      FLD (out_GRdoublek) = f_GRk;
      FLD (out_h_iccr_UQI_and__INT_index_of__INT_CCi_3) = ((FLD (f_CCi)) & (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_addx:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_ICCi_1;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_ICCi_1) = f_ICCi_1;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_addx", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_ICCi_1 0x%x", 'x', f_ICCi_1, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_ICCi_1) = f_ICCi_1;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_addi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_swapi.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_addi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_sdivi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_swapi.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRk) = f_GRk;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_sdivi", "f_GRi 0x%x", 'x', f_GRi, "f_GRk 0x%x", 'x', f_GRk, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_smuli:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smuli.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_smuli", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_GRdoublek) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_addicc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addicc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_ICCi_1;
    INT f_s10;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_s10 = EXTRACT_LSB0_SINT (insn, 32, 9, 10);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_ICCi_1) = f_ICCi_1;
  FLD (f_s10) = f_s10;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_addicc", "f_GRi 0x%x", 'x', f_GRi, "f_ICCi_1 0x%x", 'x', f_ICCi_1, "f_s10 0x%x", 'x', f_s10, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_ICCi_1) = f_ICCi_1;
      FLD (out_GRk) = f_GRk;
      FLD (out_ICCi_1) = f_ICCi_1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_andicc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addicc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_ICCi_1;
    INT f_s10;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_s10 = EXTRACT_LSB0_SINT (insn, 32, 9, 10);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_ICCi_1) = f_ICCi_1;
  FLD (f_s10) = f_s10;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_andicc", "f_GRi 0x%x", 'x', f_GRi, "f_ICCi_1 0x%x", 'x', f_ICCi_1, "f_s10 0x%x", 'x', f_s10, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_ICCi_1) = f_ICCi_1;
      FLD (out_GRk) = f_GRk;
      FLD (out_ICCi_1) = f_ICCi_1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_smulicc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smulicc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_ICCi_1;
    INT f_s10;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_s10 = EXTRACT_LSB0_SINT (insn, 32, 9, 10);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_ICCi_1) = f_ICCi_1;
  FLD (f_s10) = f_s10;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_smulicc", "f_GRi 0x%x", 'x', f_GRi, "f_ICCi_1 0x%x", 'x', f_ICCi_1, "f_s10 0x%x", 'x', f_s10, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_ICCi_1) = f_ICCi_1;
      FLD (out_GRdoublek) = f_GRk;
      FLD (out_ICCi_1) = f_ICCi_1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_addxi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addicc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_ICCi_1;
    INT f_s10;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_s10 = EXTRACT_LSB0_SINT (insn, 32, 9, 10);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_ICCi_1) = f_ICCi_1;
  FLD (f_s10) = f_s10;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_addxi", "f_GRi 0x%x", 'x', f_GRi, "f_ICCi_1 0x%x", 'x', f_ICCi_1, "f_s10 0x%x", 'x', f_s10, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_ICCi_1) = f_ICCi_1;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmpb:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smulcc.f
    UINT f_GRi;
    UINT f_ICCi_1;
    UINT f_GRj;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_ICCi_1 = EXTRACT_LSB0_UINT (insn, 32, 11, 2);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_ICCi_1) = f_ICCi_1;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmpb", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_ICCi_1 0x%x", 'x', f_ICCi_1, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_ICCi_1) = f_ICCi_1;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_setlo:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_setlo.f
    UINT f_GRk;
    UINT f_u16;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_u16 = EXTRACT_LSB0_UINT (insn, 32, 15, 16);

  /* Record the fields for the semantic handler.  */
  FLD (f_u16) = f_u16;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_setlo", "f_u16 0x%x", 'x', f_u16, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_GRklo) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_sethi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_sethi.f
    UINT f_GRk;
    UINT f_u16;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_u16 = EXTRACT_LSB0_UINT (insn, 32, 15, 16);

  /* Record the fields for the semantic handler.  */
  FLD (f_u16) = f_u16;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_sethi", "f_u16 0x%x", 'x', f_u16, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_GRkhi) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_setlos:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_setlos.f
    UINT f_GRk;
    INT f_s16;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_s16 = EXTRACT_LSB0_SINT (insn, 32, 15, 16);

  /* Record the fields for the semantic handler.  */
  FLD (f_s16) = f_s16;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_setlos", "f_s16 0x%x", 'x', f_s16, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldsb:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldsb", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldbf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldbf", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ldcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_CPRk) = f_CPRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldc", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_CPRk 0x%x", 'x', f_CPRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_CPRk) = f_CPRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldsb:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_addcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldsb", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldbf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldbf", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smulcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldd", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRdoublek) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lddf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lddf", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lddc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_lddcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_CPRk) = f_CPRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lddc", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_CPRk 0x%x", 'x', f_CPRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_CPRdoublek) = f_CPRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smulcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldd", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRdoublek) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nlddf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nlddf", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smulcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldq", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldqf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldqf", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldqc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_CPRk) = f_CPRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldqc", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_CPRk 0x%x", 'x', f_CPRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smulcc.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldq", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldqf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldqf", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldsbu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldsbu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldsbu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldsbu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldsbu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldsbu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldbfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldbfu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRintk) = f_FRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldcu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ldcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_CPRk) = f_CPRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldcu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_CPRk 0x%x", 'x', f_CPRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_CPRk) = f_CPRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldbfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldbfu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRintk) = f_FRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lddu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lddu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRdoublek) = f_GRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nlddu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nlddu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRdoublek) = f_GRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lddfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lddfu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRdoublek) = f_FRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lddcu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_lddcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_CPRk) = f_CPRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lddcu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_CPRk 0x%x", 'x', f_CPRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_CPRdoublek) = f_CPRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nlddfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nlddfu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRdoublek) = f_FRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldqu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldqu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldqu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldqu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldqfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldqfu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldqcu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_CPRk) = f_CPRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldqcu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_CPRk 0x%x", 'x', f_CPRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldqfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldqfu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldsbi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_swapi.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldsbi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldbfi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ldbfi.f
    UINT f_FRk;
    UINT f_GRi;
    INT f_d12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldbfi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldsbi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_swapi.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldsbi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldbfi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ldbfi.f
    UINT f_FRk;
    UINT f_GRi;
    INT f_d12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldbfi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lddi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smuli.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lddi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_GRdoublek) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_lddfi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_lddfi.f
    UINT f_FRk;
    UINT f_GRi;
    INT f_d12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_lddfi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nlddi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_smuli.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nlddi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_GRdoublek) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nlddfi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_lddfi.f
    UINT f_FRk;
    UINT f_GRi;
    INT f_d12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nlddfi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldqi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdi.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldqi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ldqfi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdfi.f
    UINT f_FRk;
    UINT f_GRi;
    INT f_d12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ldqfi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nldqfi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdfi.f
    UINT f_FRk;
    UINT f_GRi;
    INT f_d12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nldqfi", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stb:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stb", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stbf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stbf", "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintk) = f_FRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CPRk) = f_CPRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stc", "f_CPRk 0x%x", 'x', f_CPRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CPRk) = f_CPRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_std:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRk) = f_GRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_std", "f_GRk 0x%x", 'x', f_GRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRdoublek) = f_GRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stdf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stdf", "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRdoublek) = f_FRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stdc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CPRk) = f_CPRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stdc", "f_CPRk 0x%x", 'x', f_CPRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CPRdoublek) = f_CPRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stbu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstbu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stbu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_GRk) = f_GRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stbfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stbfu", "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintk) = f_FRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stcu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CPRk) = f_CPRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stcu", "f_CPRk 0x%x", 'x', f_CPRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CPRk) = f_CPRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stdu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRk) = f_GRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stdu", "f_GRk 0x%x", 'x', f_GRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRdoublek) = f_GRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stdfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stdfu", "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRdoublek) = f_FRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stdcu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdcu.f
    UINT f_CPRk;
    UINT f_GRi;
    UINT f_GRj;

    f_CPRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CPRk) = f_CPRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stdcu", "f_CPRk 0x%x", 'x', f_CPRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CPRdoublek) = f_CPRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stqu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stqu", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cldsb:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cldsb", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cldbf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cldbf", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cldd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cldd", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRdoublek) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_clddf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_clddf", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cldq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cldq", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cldsbu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldsbu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cldsbu", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cldbfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cldbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cldbfu", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRintk) = f_FRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_clddu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_clddu", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRdoublek) = f_GRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_clddfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_clddfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_clddfu", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRdoublek) = f_FRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cldqu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cldqu", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cstb:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cstb", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cstbf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cstbf", "f_CCi 0x%x", 'x', f_CCi, "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintk) = f_FRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cstd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRk) = f_GRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cstd", "f_CCi 0x%x", 'x', f_CCi, "f_GRk 0x%x", 'x', f_GRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRdoublek) = f_GRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cstdf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cstdf", "f_CCi 0x%x", 'x', f_CCi, "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRdoublek) = f_FRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cstbu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstbu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cstbu", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_GRk) = f_GRk;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cstbfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstbfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cstbfu", "f_CCi 0x%x", 'x', f_CCi, "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintk) = f_FRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cstdu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdu.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRk) = f_GRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cstdu", "f_CCi 0x%x", 'x', f_CCi, "f_GRk 0x%x", 'x', f_GRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRdoublek) = f_GRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cstdfu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cstdfu.f
    UINT f_FRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cstdfu", "f_CCi 0x%x", 'x', f_CCi, "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRdoublek) = f_FRk;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stbi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_swapi.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRk) = f_GRk;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stbi", "f_GRi 0x%x", 'x', f_GRi, "f_GRk 0x%x", 'x', f_GRk, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stbfi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stbfi.f
    UINT f_FRk;
    UINT f_GRi;
    INT f_d12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stbfi", "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintk) = f_FRk;
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stdi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdi.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRk) = f_GRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stdi", "f_GRk 0x%x", 'x', f_GRk, "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRdoublek) = f_GRk;
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_stdfi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_stdfi.f
    UINT f_FRk;
    UINT f_GRi;
    INT f_d12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_stdfi", "f_FRk 0x%x", 'x', f_FRk, "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRdoublek) = f_FRk;
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_swap:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_swap", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_GRk) = f_GRk;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_swapi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_swapi.f
    UINT f_GRk;
    UINT f_GRi;
    INT f_d12;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRk) = f_GRk;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_swapi", "f_GRi 0x%x", 'x', f_GRi, "f_GRk 0x%x", 'x', f_GRk, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRk) = f_GRk;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cswap:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cswap.f
    UINT f_GRk;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_GRk) = f_GRk;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cswap", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_GRk 0x%x", 'x', f_GRk, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_GRk) = f_GRk;
      FLD (out_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movgf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmovgfd.f
    UINT f_FRk;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movgf", "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRj) = f_GRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movfg:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmovfgd.f
    UINT f_FRk;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movfg", "f_FRk 0x%x", 'x', f_FRk, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintk) = f_FRk;
      FLD (out_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movgfd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmovgfd.f
    UINT f_FRk;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movgfd", "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRj) = f_GRj;
      FLD (in_h_gr_USI_add__INT_index_of__INT_GRj_1) = ((FLD (f_GRj)) + (1));
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_int_USI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movfgd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmovfgd.f
    UINT f_FRk;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movfgd", "f_FRk 0x%x", 'x', f_FRk, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_GRj) = f_GRj;
      FLD (out_h_gr_USI_add__INT_index_of__INT_GRj_1) = ((FLD (f_GRj)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movgfq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_movgfq.f
    UINT f_FRk;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRj) = f_GRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movgfq", "f_GRj 0x%x", 'x', f_GRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRj) = f_GRj;
      FLD (in_h_gr_USI_add__INT_index_of__INT_GRj_1) = ((FLD (f_GRj)) + (1));
      FLD (in_h_gr_USI_add__INT_index_of__INT_GRj_2) = ((FLD (f_GRj)) + (2));
      FLD (in_h_gr_USI_add__INT_index_of__INT_GRj_3) = ((FLD (f_GRj)) + (3));
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_int_USI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_int_USI_add__INT_index_of__INT_FRintk_2) = ((FLD (f_FRk)) + (2));
      FLD (out_h_fr_int_USI_add__INT_index_of__INT_FRintk_3) = ((FLD (f_FRk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movfgq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_movfgq.f
    UINT f_FRk;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movfgq", "f_FRk 0x%x", 'x', f_FRk, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRintk_2) = ((FLD (f_FRk)) + (2));
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRintk_3) = ((FLD (f_FRk)) + (3));
      FLD (out_GRj) = f_GRj;
      FLD (out_h_gr_USI_add__INT_index_of__INT_GRj_1) = ((FLD (f_GRj)) + (1));
      FLD (out_h_gr_USI_add__INT_index_of__INT_GRj_2) = ((FLD (f_GRj)) + (2));
      FLD (out_h_gr_USI_add__INT_index_of__INT_GRj_3) = ((FLD (f_GRj)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmovgf:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmovgfd.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmovgf", "f_CCi 0x%x", 'x', f_CCi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRj) = f_GRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmovfg:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmovfgd.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRk) = f_FRk;
  FLD (f_cond) = f_cond;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmovfg", "f_CCi 0x%x", 'x', f_CCi, "f_FRk 0x%x", 'x', f_FRk, "f_cond 0x%x", 'x', f_cond, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintk) = f_FRk;
      FLD (out_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmovgfd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmovgfd.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRj) = f_GRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmovgfd", "f_CCi 0x%x", 'x', f_CCi, "f_GRj 0x%x", 'x', f_GRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRj) = f_GRj;
      FLD (in_h_gr_USI_add__INT_index_of__INT_GRj_1) = ((FLD (f_GRj)) + (1));
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_int_USI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmovfgd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmovfgd.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRk) = f_FRk;
  FLD (f_cond) = f_cond;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmovfgd", "f_CCi 0x%x", 'x', f_CCi, "f_FRk 0x%x", 'x', f_FRk, "f_cond 0x%x", 'x', f_cond, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_GRj) = f_GRj;
      FLD (out_h_gr_USI_add__INT_index_of__INT_GRj_1) = ((FLD (f_GRj)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movgs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_movgs.f
    UINT f_spr_h;
    UINT f_spr_l;
    UINT f_GRj;
    UINT f_spr;

    f_spr_h = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_spr_l = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);
{
  f_spr = ((((f_spr_h) << (6))) | (f_spr_l));
}

  /* Record the fields for the semantic handler.  */
  FLD (f_GRj) = f_GRj;
  FLD (f_spr) = f_spr;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movgs", "f_GRj 0x%x", 'x', f_GRj, "f_spr 0x%x", 'x', f_spr, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRj) = f_GRj;
      FLD (out_spr) = f_spr;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_movsg:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_movsg.f
    UINT f_spr_h;
    UINT f_spr_l;
    UINT f_GRj;
    UINT f_spr;

    f_spr_h = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_spr_l = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);
{
  f_spr = ((((f_spr_h) << (6))) | (f_spr_l));
}

  /* Record the fields for the semantic handler.  */
  FLD (f_spr) = f_spr;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_movsg", "f_spr 0x%x", 'x', f_spr, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_spr) = f_spr;
      FLD (out_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bra:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fbne.f
    UINT f_hint;
    SI f_label16;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_label16 = ((((EXTRACT_LSB0_SINT (insn, 32, 15, 16)) * (4))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  FLD (i_label16) = f_label16;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bra", "f_hint 0x%x", 'x', f_hint, "label16 0x%x", 'x', f_label16, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bno:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fbne.f
    UINT f_hint;
    SI f_label16;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_label16 = ((((EXTRACT_LSB0_SINT (insn, 32, 15, 16)) * (4))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  FLD (i_label16) = f_label16;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bno", "f_hint 0x%x", 'x', f_hint, "label16 0x%x", 'x', f_label16, (char *) 0));

#undef FLD
    return idesc;
  }

 extract_sfmt_beq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_beq.f
    UINT f_ICCi_2;
    UINT f_hint;
    SI f_label16;

    f_ICCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_label16 = ((((EXTRACT_LSB0_SINT (insn, 32, 15, 16)) * (4))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_ICCi_2) = f_ICCi_2;
  FLD (f_hint) = f_hint;
  FLD (i_label16) = f_label16;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_beq", "f_ICCi_2 0x%x", 'x', f_ICCi_2, "f_hint 0x%x", 'x', f_hint, "label16 0x%x", 'x', f_label16, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ICCi_2) = f_ICCi_2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fbra:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fbne.f
    UINT f_hint;
    SI f_label16;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_label16 = ((((EXTRACT_LSB0_SINT (insn, 32, 15, 16)) * (4))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  FLD (i_label16) = f_label16;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fbra", "f_hint 0x%x", 'x', f_hint, "label16 0x%x", 'x', f_label16, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fbno:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fbne.f
    UINT f_hint;
    SI f_label16;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_label16 = ((((EXTRACT_LSB0_SINT (insn, 32, 15, 16)) * (4))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  FLD (i_label16) = f_label16;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fbno", "f_hint 0x%x", 'x', f_hint, "label16 0x%x", 'x', f_label16, (char *) 0));

#undef FLD
    return idesc;
  }

 extract_sfmt_fbne:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fbne.f
    UINT f_FCCi_2;
    UINT f_hint;
    SI f_label16;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_label16 = ((((EXTRACT_LSB0_SINT (insn, 32, 15, 16)) * (4))) + (pc));

  /* Record the fields for the semantic handler.  */
  FLD (f_FCCi_2) = f_FCCi_2;
  FLD (f_hint) = f_hint;
  FLD (i_label16) = f_label16;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fbne", "f_FCCi_2 0x%x", 'x', f_FCCi_2, "f_hint 0x%x", 'x', f_hint, "label16 0x%x", 'x', f_label16, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FCCi_2) = f_FCCi_2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bctrlr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;
    UINT f_ccond;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_ccond = EXTRACT_LSB0_UINT (insn, 32, 12, 1);

  /* Record the fields for the semantic handler.  */
  FLD (f_ccond) = f_ccond;
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bctrlr", "f_ccond 0x%x", 'x', f_ccond, "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
      FLD (in_h_spr_USI_273) = 273;
      FLD (out_h_spr_USI_273) = 273;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bralr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bralr", "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bnolr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bnolr", "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_beqlr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_bceqlr.f
    UINT f_ICCi_2;
    UINT f_hint;

    f_ICCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_ICCi_2) = f_ICCi_2;
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_beqlr", "f_ICCi_2 0x%x", 'x', f_ICCi_2, "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ICCi_2) = f_ICCi_2;
      FLD (in_h_spr_USI_272) = 272;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fbralr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fbralr", "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fbnolr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fbnolr", "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fbeqlr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_FCCi_2;
    UINT f_hint;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_FCCi_2) = f_FCCi_2;
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fbeqlr", "f_FCCi_2 0x%x", 'x', f_FCCi_2, "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FCCi_2) = f_FCCi_2;
      FLD (in_h_spr_USI_272) = 272;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bcralr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;
    UINT f_ccond;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_ccond = EXTRACT_LSB0_UINT (insn, 32, 12, 1);

  /* Record the fields for the semantic handler.  */
  FLD (f_ccond) = f_ccond;
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bcralr", "f_ccond 0x%x", 'x', f_ccond, "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
      FLD (in_h_spr_USI_273) = 273;
      FLD (out_h_spr_USI_273) = 273;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bcnolr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bcnolr", "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
      FLD (in_h_spr_USI_273) = 273;
      FLD (out_h_spr_USI_273) = 273;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_bceqlr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_bceqlr.f
    UINT f_ICCi_2;
    UINT f_hint;
    UINT f_ccond;

    f_ICCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_ccond = EXTRACT_LSB0_UINT (insn, 32, 12, 1);

  /* Record the fields for the semantic handler.  */
  FLD (f_ICCi_2) = f_ICCi_2;
  FLD (f_ccond) = f_ccond;
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_bceqlr", "f_ICCi_2 0x%x", 'x', f_ICCi_2, "f_ccond 0x%x", 'x', f_ccond, "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ICCi_2) = f_ICCi_2;
      FLD (in_h_spr_USI_272) = 272;
      FLD (in_h_spr_USI_273) = 273;
      FLD (out_h_spr_USI_273) = 273;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fcbralr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;
    UINT f_ccond;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_ccond = EXTRACT_LSB0_UINT (insn, 32, 12, 1);

  /* Record the fields for the semantic handler.  */
  FLD (f_ccond) = f_ccond;
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fcbralr", "f_ccond 0x%x", 'x', f_ccond, "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
      FLD (in_h_spr_USI_273) = 273;
      FLD (out_h_spr_USI_273) = 273;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fcbnolr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_hint;

    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fcbnolr", "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_spr_USI_272) = 272;
      FLD (in_h_spr_USI_273) = 273;
      FLD (out_h_spr_USI_273) = 273;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fcbeqlr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcbeqlr.f
    UINT f_FCCi_2;
    UINT f_hint;
    UINT f_ccond;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_hint = EXTRACT_LSB0_UINT (insn, 32, 17, 2);
    f_ccond = EXTRACT_LSB0_UINT (insn, 32, 12, 1);

  /* Record the fields for the semantic handler.  */
  FLD (f_FCCi_2) = f_FCCi_2;
  FLD (f_ccond) = f_ccond;
  FLD (f_hint) = f_hint;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fcbeqlr", "f_FCCi_2 0x%x", 'x', f_FCCi_2, "f_ccond 0x%x", 'x', f_ccond, "f_hint 0x%x", 'x', f_hint, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FCCi_2) = f_FCCi_2;
      FLD (in_h_spr_USI_272) = 272;
      FLD (in_h_spr_USI_273) = 273;
      FLD (out_h_spr_USI_273) = 273;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_jmpl:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cjmpl.f
    UINT f_LI;
    UINT f_GRi;
    UINT f_GRj;

    f_LI = EXTRACT_LSB0_UINT (insn, 32, 25, 1);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_LI) = f_LI;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_jmpl", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_LI 0x%x", 'x', f_LI, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_calll:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cjmpl.f
    UINT f_LI;
    UINT f_GRi;
    UINT f_GRj;

    f_LI = EXTRACT_LSB0_UINT (insn, 32, 25, 1);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_LI) = f_LI;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_calll", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_LI 0x%x", 'x', f_LI, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_jmpil:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_jmpil.f
    UINT f_LI;
    UINT f_GRi;
    INT f_d12;

    f_LI = EXTRACT_LSB0_UINT (insn, 32, 25, 1);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_LI) = f_LI;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_jmpil", "f_GRi 0x%x", 'x', f_GRi, "f_LI 0x%x", 'x', f_LI, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_callil:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_jmpil.f
    UINT f_LI;
    UINT f_GRi;
    INT f_d12;

    f_LI = EXTRACT_LSB0_UINT (insn, 32, 25, 1);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_LI) = f_LI;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_callil", "f_GRi 0x%x", 'x', f_GRi, "f_LI 0x%x", 'x', f_LI, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_call:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_call.f
    INT f_labelH6;
    UINT f_labelL18;
    INT f_label24;

    f_labelH6 = EXTRACT_LSB0_SINT (insn, 32, 30, 6);
    f_labelL18 = EXTRACT_LSB0_UINT (insn, 32, 17, 18);
{
  f_label24 = ((((((((f_labelH6) * (((1) << (18))))) | (f_labelL18))) * (4))) + (pc));
}

  /* Record the fields for the semantic handler.  */
  FLD (i_label24) = f_label24;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_call", "label24 0x%x", 'x', f_label24, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_rett:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_rett.f
    UINT f_debug;

    f_debug = EXTRACT_LSB0_UINT (insn, 32, 25, 1);

  /* Record the fields for the semantic handler.  */
  FLD (f_debug) = f_debug;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_rett", "f_debug 0x%x", 'x', f_debug, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_rei:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
#define FLD(f) abuf->fields.sfmt_empty.f


  /* Record the fields for the semantic handler.  */
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_rei", (char *) 0));

#undef FLD
    return idesc;
  }

 extract_sfmt_tra:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ftne.f
    UINT f_GRi;
    UINT f_GRj;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_tra", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_h_spr_USI_1) = 1;
      FLD (out_h_spr_USI_768) = 768;
      FLD (out_h_spr_USI_769) = 769;
      FLD (out_h_spr_USI_770) = 770;
      FLD (out_h_spr_USI_771) = 771;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_teq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_teq.f
    UINT f_ICCi_2;
    UINT f_GRi;
    UINT f_GRj;

    f_ICCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_ICCi_2) = f_ICCi_2;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_teq", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_ICCi_2 0x%x", 'x', f_ICCi_2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (in_ICCi_2) = f_ICCi_2;
      FLD (out_h_spr_USI_1) = 1;
      FLD (out_h_spr_USI_768) = 768;
      FLD (out_h_spr_USI_769) = 769;
      FLD (out_h_spr_USI_770) = 770;
      FLD (out_h_spr_USI_771) = 771;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ftra:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ftne.f
    UINT f_GRi;
    UINT f_GRj;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ftra", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_h_spr_USI_1) = 1;
      FLD (out_h_spr_USI_768) = 768;
      FLD (out_h_spr_USI_769) = 769;
      FLD (out_h_spr_USI_770) = 770;
      FLD (out_h_spr_USI_771) = 771;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ftne:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ftne.f
    UINT f_FCCi_2;
    UINT f_GRi;
    UINT f_GRj;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FCCi_2) = f_FCCi_2;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ftne", "f_FCCi_2 0x%x", 'x', f_FCCi_2, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FCCi_2) = f_FCCi_2;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
      FLD (out_h_spr_USI_1) = 1;
      FLD (out_h_spr_USI_768) = 768;
      FLD (out_h_spr_USI_769) = 769;
      FLD (out_h_spr_USI_770) = 770;
      FLD (out_h_spr_USI_771) = 771;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_tira:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ftine.f
    UINT f_GRi;
    INT f_d12;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_tira", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_h_spr_USI_1) = 1;
      FLD (out_h_spr_USI_768) = 768;
      FLD (out_h_spr_USI_769) = 769;
      FLD (out_h_spr_USI_770) = 770;
      FLD (out_h_spr_USI_771) = 771;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_tieq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_tieq.f
    UINT f_ICCi_2;
    UINT f_GRi;
    INT f_d12;

    f_ICCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_ICCi_2) = f_ICCi_2;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_tieq", "f_GRi 0x%x", 'x', f_GRi, "f_ICCi_2 0x%x", 'x', f_ICCi_2, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_ICCi_2) = f_ICCi_2;
      FLD (out_h_spr_USI_1) = 1;
      FLD (out_h_spr_USI_768) = 768;
      FLD (out_h_spr_USI_769) = 769;
      FLD (out_h_spr_USI_770) = 770;
      FLD (out_h_spr_USI_771) = 771;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ftira:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ftine.f
    UINT f_GRi;
    INT f_d12;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ftira", "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (out_h_spr_USI_1) = 1;
      FLD (out_h_spr_USI_768) = 768;
      FLD (out_h_spr_USI_769) = 769;
      FLD (out_h_spr_USI_770) = 770;
      FLD (out_h_spr_USI_771) = 771;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ftine:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_ftine.f
    UINT f_FCCi_2;
    UINT f_GRi;
    INT f_d12;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_d12 = EXTRACT_LSB0_SINT (insn, 32, 11, 12);

  /* Record the fields for the semantic handler.  */
  FLD (f_FCCi_2) = f_FCCi_2;
  FLD (f_GRi) = f_GRi;
  FLD (f_d12) = f_d12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ftine", "f_FCCi_2 0x%x", 'x', f_FCCi_2, "f_GRi 0x%x", 'x', f_GRi, "f_d12 0x%x", 'x', f_d12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FCCi_2) = f_FCCi_2;
      FLD (in_GRi) = f_GRi;
      FLD (out_h_spr_USI_1) = 1;
      FLD (out_h_spr_USI_768) = 768;
      FLD (out_h_spr_USI_769) = 769;
      FLD (out_h_spr_USI_770) = 770;
      FLD (out_h_spr_USI_771) = 771;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_break:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
#define FLD(f) abuf->fields.sfmt_break.f


  /* Record the fields for the semantic handler.  */
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_break", (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_h_spr_USI_2) = 2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_andcr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_andcr.f
    UINT f_CRk;
    UINT f_CRi;
    UINT f_CRj;

    f_CRk = EXTRACT_LSB0_UINT (insn, 32, 27, 3);
    f_CRi = EXTRACT_LSB0_UINT (insn, 32, 14, 3);
    f_CRj = EXTRACT_LSB0_UINT (insn, 32, 2, 3);

  /* Record the fields for the semantic handler.  */
  FLD (f_CRi) = f_CRi;
  FLD (f_CRj) = f_CRj;
  FLD (f_CRk) = f_CRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_andcr", "f_CRi 0x%x", 'x', f_CRi, "f_CRj 0x%x", 'x', f_CRj, "f_CRk 0x%x", 'x', f_CRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CRi) = f_CRi;
      FLD (in_CRj) = f_CRj;
      FLD (out_CRk) = f_CRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_notcr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_andcr.f
    UINT f_CRk;
    UINT f_CRj;

    f_CRk = EXTRACT_LSB0_UINT (insn, 32, 27, 3);
    f_CRj = EXTRACT_LSB0_UINT (insn, 32, 2, 3);

  /* Record the fields for the semantic handler.  */
  FLD (f_CRj) = f_CRj;
  FLD (f_CRk) = f_CRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_notcr", "f_CRj 0x%x", 'x', f_CRj, "f_CRk 0x%x", 'x', f_CRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CRj) = f_CRj;
      FLD (out_CRk) = f_CRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ckra:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cckeq.f
    SI f_CRj_int;

    f_CRj_int = ((EXTRACT_LSB0_UINT (insn, 32, 26, 2)) + (4));

  /* Record the fields for the semantic handler.  */
  FLD (f_CRj_int) = f_CRj_int;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ckra", "f_CRj_int 0x%x", 'x', f_CRj_int, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_CRj_int) = f_CRj_int;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ckeq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cckeq.f
    SI f_CRj_int;
    UINT f_ICCi_3;

    f_CRj_int = ((EXTRACT_LSB0_UINT (insn, 32, 26, 2)) + (4));
    f_ICCi_3 = EXTRACT_LSB0_UINT (insn, 32, 1, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_ICCi_3) = f_ICCi_3;
  FLD (f_CRj_int) = f_CRj_int;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ckeq", "f_ICCi_3 0x%x", 'x', f_ICCi_3, "f_CRj_int 0x%x", 'x', f_CRj_int, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ICCi_3) = f_ICCi_3;
      FLD (out_CRj_int) = f_CRj_int;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fckra:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfckne.f
    UINT f_CRj_float;

    f_CRj_float = EXTRACT_LSB0_UINT (insn, 32, 26, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_CRj_float) = f_CRj_float;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fckra", "f_CRj_float 0x%x", 'x', f_CRj_float, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_CRj_float) = f_CRj_float;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fckne:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfckne.f
    UINT f_CRj_float;
    UINT f_FCCi_3;

    f_CRj_float = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_FCCi_3 = EXTRACT_LSB0_UINT (insn, 32, 1, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_FCCi_3) = f_FCCi_3;
  FLD (f_CRj_float) = f_CRj_float;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fckne", "f_FCCi_3 0x%x", 'x', f_FCCi_3, "f_CRj_float 0x%x", 'x', f_CRj_float, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FCCi_3) = f_FCCi_3;
      FLD (out_CRj_float) = f_CRj_float;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cckra:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cckeq.f
    SI f_CRj_int;
    UINT f_CCi;
    UINT f_cond;

    f_CRj_int = ((EXTRACT_LSB0_UINT (insn, 32, 26, 2)) + (4));
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_cond) = f_cond;
  FLD (f_CRj_int) = f_CRj_int;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cckra", "f_CCi 0x%x", 'x', f_CCi, "f_cond 0x%x", 'x', f_cond, "f_CRj_int 0x%x", 'x', f_CRj_int, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (out_CRj_int) = f_CRj_int;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cckeq:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cckeq.f
    SI f_CRj_int;
    UINT f_CCi;
    UINT f_cond;
    UINT f_ICCi_3;

    f_CRj_int = ((EXTRACT_LSB0_UINT (insn, 32, 26, 2)) + (4));
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_ICCi_3 = EXTRACT_LSB0_UINT (insn, 32, 1, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_ICCi_3) = f_ICCi_3;
  FLD (f_cond) = f_cond;
  FLD (f_CRj_int) = f_CRj_int;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cckeq", "f_CCi 0x%x", 'x', f_CCi, "f_ICCi_3 0x%x", 'x', f_ICCi_3, "f_cond 0x%x", 'x', f_cond, "f_CRj_int 0x%x", 'x', f_CRj_int, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_ICCi_3) = f_ICCi_3;
      FLD (out_CRj_int) = f_CRj_int;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfckra:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfckne.f
    UINT f_CRj_float;
    UINT f_CCi;
    UINT f_cond;

    f_CRj_float = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_cond) = f_cond;
  FLD (f_CRj_float) = f_CRj_float;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfckra", "f_CCi 0x%x", 'x', f_CCi, "f_cond 0x%x", 'x', f_cond, "f_CRj_float 0x%x", 'x', f_CRj_float, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (out_CRj_float) = f_CRj_float;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfckne:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfckne.f
    UINT f_CRj_float;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FCCi_3;

    f_CRj_float = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FCCi_3 = EXTRACT_LSB0_UINT (insn, 32, 1, 2);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FCCi_3) = f_FCCi_3;
  FLD (f_cond) = f_cond;
  FLD (f_CRj_float) = f_CRj_float;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfckne", "f_CCi 0x%x", 'x', f_CCi, "f_FCCi_3 0x%x", 'x', f_FCCi_3, "f_cond 0x%x", 'x', f_cond, "f_CRj_float 0x%x", 'x', f_CRj_float, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FCCi_3) = f_FCCi_3;
      FLD (out_CRj_float) = f_CRj_float;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cjmpl:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cjmpl.f
    UINT f_LI;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_LI = EXTRACT_LSB0_UINT (insn, 32, 25, 1);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_LI) = f_LI;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cjmpl", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_LI 0x%x", 'x', f_LI, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ccalll:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cjmpl.f
    UINT f_LI;
    UINT f_GRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_GRj;

    f_LI = EXTRACT_LSB0_UINT (insn, 32, 25, 1);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_LI) = f_LI;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ccalll", "f_CCi 0x%x", 'x', f_CCi, "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_LI 0x%x", 'x', f_LI, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_ici:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_icpl.f
    UINT f_GRi;
    UINT f_GRj;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_ici", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_icei:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_icei.f
    UINT f_ae;
    UINT f_GRi;
    UINT f_GRj;

    f_ae = EXTRACT_LSB0_UINT (insn, 32, 25, 1);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_ae) = f_ae;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_icei", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_ae 0x%x", 'x', f_ae, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_icpl:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_icpl.f
    UINT f_lock;
    UINT f_GRi;
    UINT f_GRj;

    f_lock = EXTRACT_LSB0_UINT (insn, 32, 25, 1);
    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_GRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  FLD (f_GRj) = f_GRj;
  FLD (f_lock) = f_lock;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_icpl", "f_GRi 0x%x", 'x', f_GRi, "f_GRj 0x%x", 'x', f_GRj, "f_lock 0x%x", 'x', f_lock, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
      FLD (in_GRj) = f_GRj;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_icul:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_jmpil.f
    UINT f_GRi;

    f_GRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRi) = f_GRi;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_icul", "f_GRi 0x%x", 'x', f_GRi, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRi) = f_GRi;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_clrgr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_swapi.f
    UINT f_GRk;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_clrgr", "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_GRk) = f_GRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_clrfr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_clrfr", "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_commitgr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_setlos.f
    UINT f_GRk;

    f_GRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_GRk) = f_GRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_commitgr", "f_GRk 0x%x", 'x', f_GRk, (char *) 0));

#undef FLD
    return idesc;
  }

 extract_sfmt_commitfr:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mhsethis.f
    UINT f_FRk;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_commitfr", "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#undef FLD
    return idesc;
  }

 extract_sfmt_fitos:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fditos.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fitos", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fstoi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fdstoi.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fstoi", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fitod:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fitod.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fitod", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fdtoi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fdtoi.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fdtoi", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRdoublej) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fditos:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fditos.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fditos", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRintj_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRk) = f_FRk;
      FLD (out_h_fr_SF_add__INT_index_of__INT_FRk_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fdstoi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fdstoi.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fdstoi", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRj) = f_FRj;
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_int_USI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfitos:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfitos.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfitos", "f_CCi 0x%x", 'x', f_CCi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfstoi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfstoi.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfstoi", "f_CCi 0x%x", 'x', f_CCi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nfitos:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fditos.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nfitos", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nfstoi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fdstoi.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nfstoi", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fmovs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fmovs", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fmovd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fmaddd.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fmovd", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRdoublej) = f_FRj;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fdmovs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fdmadds.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fdmovs", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRj) = f_FRj;
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRk) = f_FRk;
      FLD (out_h_fr_SF_add__INT_index_of__INT_FRk_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfmovs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfmovs", "f_CCi 0x%x", 'x', f_CCi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nfsqrts:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nfsqrts", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fadds:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fadds", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_faddd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fmaddd.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_faddd", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRdoublei) = f_FRi;
      FLD (in_FRdoublej) = f_FRj;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfadds:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfadds", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nfadds:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nfadds", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fcmps:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfcmps.f
    UINT f_FCCi_2;
    UINT f_FRi;
    UINT f_FRj;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FCCi_2) = f_FCCi_2;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fcmps", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FCCi_2 0x%x", 'x', f_FCCi_2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (out_FCCi_2) = f_FCCi_2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fcmpd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fcmpd.f
    UINT f_FCCi_2;
    UINT f_FRi;
    UINT f_FRj;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FCCi_2) = f_FCCi_2;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fcmpd", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FCCi_2 0x%x", 'x', f_FCCi_2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRdoublei) = f_FRi;
      FLD (in_FRdoublej) = f_FRj;
      FLD (out_FCCi_2) = f_FCCi_2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfcmps:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfcmps.f
    UINT f_FCCi_2;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FCCi_2) = f_FCCi_2;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfcmps", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FCCi_2 0x%x", 'x', f_FCCi_2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (out_FCCi_2) = f_FCCi_2;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fdcmps:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_nfdcmps.f
    UINT f_FCCi_2;
    UINT f_FRi;
    UINT f_FRj;

    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FCCi_2) = f_FCCi_2;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fdcmps", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FCCi_2 0x%x", 'x', f_FCCi_2, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRi_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FCCi_2) = f_FCCi_2;
      FLD (out_h_fccr_UQI_add__INT_index_of__INT_FCCi_2_1) = ((FLD (f_FCCi_2)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fmadds:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fmadds", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_FRk) = f_FRk;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fmaddd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fmaddd.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fmaddd", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRdoublei) = f_FRi;
      FLD (in_FRdoublej) = f_FRj;
      FLD (in_FRdoublek) = f_FRk;
      FLD (out_FRdoublek) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fdmadds:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fdmadds.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fdmadds", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_FRk) = f_FRk;
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRi_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_FRk) = f_FRk;
      FLD (out_h_fr_SF_add__INT_index_of__INT_FRk_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfmadds:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfmadds", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_FRk) = f_FRk;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nfmadds:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmadds.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nfmadds", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_FRk) = f_FRk;
      FLD (out_FRk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fmas:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fdmadds.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fmas", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRi_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRk) = f_FRk;
      FLD (out_h_fr_SF_add__INT_index_of__INT_FRk_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_fdmas:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_fdmas.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_fdmas", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRi_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRi_2) = ((FLD (f_FRi)) + (2));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRi_3) = ((FLD (f_FRi)) + (3));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_2) = ((FLD (f_FRj)) + (2));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_3) = ((FLD (f_FRj)) + (3));
      FLD (out_FRk) = f_FRk;
      FLD (out_h_fr_SF_add__INT_index_of__INT_FRk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_SF_add__INT_index_of__INT_FRk_2) = ((FLD (f_FRk)) + (2));
      FLD (out_h_fr_SF_add__INT_index_of__INT_FRk_3) = ((FLD (f_FRk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cfmas:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cfmas.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cfmas", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRi_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRk) = f_FRk;
      FLD (out_h_fr_SF_add__INT_index_of__INT_FRk_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_nfdcmps:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_nfdcmps.f
    UINT f_FRk;
    UINT f_FCCi_2;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FCCi_2 = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FCCi_2) = f_FCCi_2;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_nfdcmps", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FCCi_2 0x%x", 'x', f_FCCi_2, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRi) = f_FRi;
      FLD (in_FRj) = f_FRj;
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRi_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_SF_add__INT_index_of__INT_FRj_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FCCi_2) = f_FCCi_2;
      FLD (out_h_fccr_UQI_add__INT_index_of__INT_FCCi_2_1) = ((FLD (f_FCCi_2)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mhsetlos:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mhsetlos.f
    UINT f_FRk;
    INT f_u12_h;
    UINT f_u12_l;
    INT f_u12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_u12_h = EXTRACT_LSB0_SINT (insn, 32, 17, 6);
    f_u12_l = EXTRACT_LSB0_UINT (insn, 32, 5, 6);
{
  f_u12 = ((((f_u12_h) * (64))) | (f_u12_l));
}

  /* Record the fields for the semantic handler.  */
  FLD (f_u12) = f_u12;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mhsetlos", "f_u12 0x%x", 'x', f_u12, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_FRklo) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mhsethis:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mhsethis.f
    UINT f_FRk;
    INT f_u12_h;
    UINT f_u12_l;
    INT f_u12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_u12_h = EXTRACT_LSB0_SINT (insn, 32, 17, 6);
    f_u12_l = EXTRACT_LSB0_UINT (insn, 32, 5, 6);
{
  f_u12 = ((((f_u12_h) * (64))) | (f_u12_l));
}

  /* Record the fields for the semantic handler.  */
  FLD (f_u12) = f_u12;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mhsethis", "f_u12 0x%x", 'x', f_u12, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (out_FRkhi) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mhdsets:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mhdsets.f
    UINT f_FRk;
    INT f_u12_h;
    UINT f_u12_l;
    INT f_u12;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_u12_h = EXTRACT_LSB0_SINT (insn, 32, 17, 6);
    f_u12_l = EXTRACT_LSB0_UINT (insn, 32, 5, 6);
{
  f_u12 = ((((f_u12_h) * (64))) | (f_u12_l));
}

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_u12) = f_u12;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mhdsets", "f_FRk 0x%x", 'x', f_FRk, "f_u12 0x%x", 'x', f_u12, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintk) = f_FRk;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mhsetloh:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mhsetloh.f
    UINT f_FRk;
    INT f_s5;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_s5 = EXTRACT_LSB0_SINT (insn, 32, 4, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_s5) = f_s5;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mhsetloh", "f_FRk 0x%x", 'x', f_FRk, "f_s5 0x%x", 'x', f_s5, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRklo) = f_FRk;
      FLD (out_FRklo) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mhsethih:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mhsethih.f
    UINT f_FRk;
    INT f_s5;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_s5 = EXTRACT_LSB0_SINT (insn, 32, 4, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_s5) = f_s5;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mhsethih", "f_FRk 0x%x", 'x', f_FRk, "f_s5 0x%x", 'x', f_s5, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRkhi) = f_FRk;
      FLD (out_FRkhi) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mhdseth:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mhdseth.f
    UINT f_FRk;
    INT f_s5;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_s5 = EXTRACT_LSB0_SINT (insn, 32, 4, 5);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_s5) = f_s5;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mhdseth", "f_FRk 0x%x", 'x', f_FRk, "f_s5 0x%x", 'x', f_s5, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mand:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mwcut.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mand", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmand:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmand.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmand", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mnot:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mcut.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mnot", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmnot:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmand.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmnot", "f_CCi 0x%x", 'x', f_CCi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mrotli:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mwcuti.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_u6) = f_u6;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mrotli", "f_FRi 0x%x", 'x', f_FRi, "f_u6 0x%x", 'x', f_u6, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mwcut:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mwcut.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mwcut", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRinti_1) = ((FLD (f_FRi)) + (1));
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mwcuti:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mwcuti.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_u6) = f_u6;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mwcuti", "f_FRi 0x%x", 'x', f_FRi, "f_u6 0x%x", 'x', f_u6, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRinti_1) = ((FLD (f_FRi)) + (1));
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mcut:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mcut.f
    UINT f_FRk;
    UINT f_ACC40Si;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACC40Si = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Si) = f_ACC40Si;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mcut", "f_ACC40Si 0x%x", 'x', f_ACC40Si, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Si) = f_ACC40Si;
      FLD (in_FRintj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mcuti:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mcuti.f
    UINT f_FRk;
    UINT f_ACC40Si;
    INT f_s6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACC40Si = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_s6 = EXTRACT_LSB0_SINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Si) = f_ACC40Si;
  FLD (f_s6) = f_s6;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mcuti", "f_ACC40Si 0x%x", 'x', f_ACC40Si, "f_s6 0x%x", 'x', f_s6, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Si) = f_ACC40Si;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mdcutssi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdcutssi.f
    UINT f_FRk;
    UINT f_ACC40Si;
    INT f_s6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACC40Si = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_s6 = EXTRACT_LSB0_SINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Si) = f_ACC40Si;
  FLD (f_FRk) = f_FRk;
  FLD (f_s6) = f_s6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mdcutssi", "f_ACC40Si 0x%x", 'x', f_ACC40Si, "f_FRk 0x%x", 'x', f_FRk, "f_s6 0x%x", 'x', f_s6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Si) = f_ACC40Si;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_1) = ((FLD (f_ACC40Si)) + (1));
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_int_USI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_msllhi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_msllhi.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRk) = f_FRk;
  FLD (f_u6) = f_u6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_msllhi", "f_FRi 0x%x", 'x', f_FRi, "f_FRk 0x%x", 'x', f_FRk, "f_u6 0x%x", 'x', f_u6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (out_FRinti) = f_FRi;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mdrotli:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdrotli.f
    UINT f_FRk;
    UINT f_FRi;
    INT f_s6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_s6 = EXTRACT_LSB0_SINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRk) = f_FRk;
  FLD (f_s6) = f_s6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mdrotli", "f_FRi 0x%x", 'x', f_FRi, "f_FRk 0x%x", 'x', f_FRk, "f_s6 0x%x", 'x', f_s6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintieven) = f_FRi;
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_int_USI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mcplhi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mcplhi.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRk) = f_FRk;
  FLD (f_u6) = f_u6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mcplhi", "f_FRi 0x%x", 'x', f_FRi, "f_FRk 0x%x", 'x', f_FRk, "f_u6 0x%x", 'x', f_u6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_1) = ((FLD (f_FRi)) + (1));
      FLD (out_FRinti) = f_FRi;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mcpli:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mwcuti.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_u6) = f_u6;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mcpli", "f_FRi 0x%x", 'x', f_FRi, "f_u6 0x%x", 'x', f_u6, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_h_fr_int_USI_add__INT_index_of__INT_FRinti_1) = ((FLD (f_FRi)) + (1));
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_msaths:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmaddhss.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_msaths", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mqsaths:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqaddhss.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mqsaths", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mcmpsh:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mcmpsh.f
    UINT f_FCCk;
    UINT f_FRi;
    UINT f_FRj;

    f_FCCk = EXTRACT_LSB0_UINT (insn, 32, 26, 2);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FCCk) = f_FCCk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mcmpsh", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FCCk 0x%x", 'x', f_FCCk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_FCCk) = f_FCCk;
      FLD (out_h_fccr_UQI_add__INT_index_of__INT_FCCk_1) = ((FLD (f_FCCk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mabshs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mabshs.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mabshs", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintj) = f_FRj;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_FRintj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmaddhss:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmaddhss.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmaddhss", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmqaddhss:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqaddhss.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmqaddhss", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mqsllhi:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mqsllhi.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRk) = f_FRk;
  FLD (f_u6) = f_u6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mqsllhi", "f_FRi 0x%x", 'x', f_FRi, "f_FRk 0x%x", 'x', f_FRk, "f_u6 0x%x", 'x', f_u6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (out_FRintieven) = f_FRi;
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_maddaccs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdasaccs.f
    UINT f_ACC40Sk;
    UINT f_ACC40Si;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACC40Si = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Si) = f_ACC40Si;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_maddaccs", "f_ACC40Si 0x%x", 'x', f_ACC40Si, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Si) = f_ACC40Si;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_1) = ((FLD (f_ACC40Si)) + (1));
      FLD (out_ACC40Sk) = f_ACC40Sk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mdaddaccs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdasaccs.f
    UINT f_ACC40Sk;
    UINT f_ACC40Si;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACC40Si = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Si) = f_ACC40Si;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mdaddaccs", "f_ACC40Si 0x%x", 'x', f_ACC40Si, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Si) = f_ACC40Si;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_1) = ((FLD (f_ACC40Si)) + (1));
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_2) = ((FLD (f_ACC40Si)) + (2));
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_3) = ((FLD (f_ACC40Si)) + (3));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_masaccs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdasaccs.f
    UINT f_ACC40Sk;
    UINT f_ACC40Si;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACC40Si = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Si) = f_ACC40Si;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_masaccs", "f_ACC40Si 0x%x", 'x', f_ACC40Si, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Si) = f_ACC40Si;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_1) = ((FLD (f_ACC40Si)) + (1));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mdasaccs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdasaccs.f
    UINT f_ACC40Sk;
    UINT f_ACC40Si;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACC40Si = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Si) = f_ACC40Si;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mdasaccs", "f_ACC40Si 0x%x", 'x', f_ACC40Si, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Si) = f_ACC40Si;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_1) = ((FLD (f_ACC40Si)) + (1));
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_2) = ((FLD (f_ACC40Si)) + (2));
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Si_3) = ((FLD (f_ACC40Si)) + (3));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_2) = ((FLD (f_ACC40Sk)) + (2));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_3) = ((FLD (f_ACC40Sk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mmulhs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mmulhs", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmmulhs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmmulhs", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mqmulhs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mqmulhs", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_2) = ((FLD (f_ACC40Sk)) + (2));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_3) = ((FLD (f_ACC40Sk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmqmulhs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmqmulhs", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_2) = ((FLD (f_ACC40Sk)) + (2));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_3) = ((FLD (f_ACC40Sk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mmachs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Sk) = f_ACC40Sk;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mmachs", "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Sk) = f_ACC40Sk;
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mmachu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachu.f
    UINT f_ACC40Uk;
    UINT f_FRi;
    UINT f_FRj;

    f_ACC40Uk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Uk) = f_ACC40Uk;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mmachu", "f_ACC40Uk 0x%x", 'x', f_ACC40Uk, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Uk) = f_ACC40Uk;
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_1) = ((FLD (f_ACC40Uk)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_ACC40Uk) = f_ACC40Uk;
      FLD (out_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_1) = ((FLD (f_ACC40Uk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmmachs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Sk) = f_ACC40Sk;
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmmachs", "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Sk) = f_ACC40Sk;
      FLD (in_CCi) = f_CCi;
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmmachu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachu.f
    UINT f_ACC40Uk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_ACC40Uk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Uk) = f_ACC40Uk;
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmmachu", "f_ACC40Uk 0x%x", 'x', f_ACC40Uk, "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Uk) = f_ACC40Uk;
      FLD (in_CCi) = f_CCi;
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_1) = ((FLD (f_ACC40Uk)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_ACC40Uk) = f_ACC40Uk;
      FLD (out_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_1) = ((FLD (f_ACC40Uk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mqmachs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Sk) = f_ACC40Sk;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mqmachs", "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Sk) = f_ACC40Sk;
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_2) = ((FLD (f_ACC40Sk)) + (2));
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_3) = ((FLD (f_ACC40Sk)) + (3));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_2) = ((FLD (f_ACC40Sk)) + (2));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_3) = ((FLD (f_ACC40Sk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mqmachu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqmachu.f
    UINT f_ACC40Uk;
    UINT f_FRi;
    UINT f_FRj;

    f_ACC40Uk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Uk) = f_ACC40Uk;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mqmachu", "f_ACC40Uk 0x%x", 'x', f_ACC40Uk, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Uk) = f_ACC40Uk;
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_1) = ((FLD (f_ACC40Uk)) + (1));
      FLD (in_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_2) = ((FLD (f_ACC40Uk)) + (2));
      FLD (in_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_3) = ((FLD (f_ACC40Uk)) + (3));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_ACC40Uk) = f_ACC40Uk;
      FLD (out_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_1) = ((FLD (f_ACC40Uk)) + (1));
      FLD (out_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_2) = ((FLD (f_ACC40Uk)) + (2));
      FLD (out_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_3) = ((FLD (f_ACC40Uk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmqmachs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Sk) = f_ACC40Sk;
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmqmachs", "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Sk) = f_ACC40Sk;
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_2) = ((FLD (f_ACC40Sk)) + (2));
      FLD (in_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_3) = ((FLD (f_ACC40Sk)) + (3));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_2) = ((FLD (f_ACC40Sk)) + (2));
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_3) = ((FLD (f_ACC40Sk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmqmachu:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqmachu.f
    UINT f_ACC40Uk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_ACC40Uk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Uk) = f_ACC40Uk;
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmqmachu", "f_ACC40Uk 0x%x", 'x', f_ACC40Uk, "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Uk) = f_ACC40Uk;
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_1) = ((FLD (f_ACC40Uk)) + (1));
      FLD (in_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_2) = ((FLD (f_ACC40Uk)) + (2));
      FLD (in_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_3) = ((FLD (f_ACC40Uk)) + (3));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_ACC40Uk) = f_ACC40Uk;
      FLD (out_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_1) = ((FLD (f_ACC40Uk)) + (1));
      FLD (out_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_2) = ((FLD (f_ACC40Uk)) + (2));
      FLD (out_h_acc40U_UDI_add__INT_index_of__INT_ACC40Uk_3) = ((FLD (f_ACC40Uk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mcpxrs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mcpxrs", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_ACC40Sk) = f_ACC40Sk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmcpxrs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_cond) = f_cond;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmcpxrs", "f_CCi 0x%x", 'x', f_CCi, "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_cond 0x%x", 'x', f_cond, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_ACC40Sk) = f_ACC40Sk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mqcpxrs:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmqmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;
    UINT f_FRj;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mqcpxrs", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_ACC40Sk) = f_ACC40Sk;
      FLD (out_h_acc40S_DI_add__INT_index_of__INT_ACC40Sk_1) = ((FLD (f_ACC40Sk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mexpdhw:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmexpdhw.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRk) = f_FRk;
  FLD (f_u6) = f_u6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mexpdhw", "f_FRi 0x%x", 'x', f_FRi, "f_FRk 0x%x", 'x', f_FRk, "f_u6 0x%x", 'x', f_u6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmexpdhw:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmexpdhw.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_cond) = f_cond;
  FLD (f_FRi) = f_FRi;
  FLD (f_FRk) = f_FRk;
  FLD (f_u6) = f_u6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmexpdhw", "f_CCi 0x%x", 'x', f_CCi, "f_cond 0x%x", 'x', f_cond, "f_FRi 0x%x", 'x', f_FRi, "f_FRk 0x%x", 'x', f_FRk, "f_u6 0x%x", 'x', f_u6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mexpdhd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmexpdhd.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRk) = f_FRk;
  FLD (f_FRi) = f_FRi;
  FLD (f_u6) = f_u6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mexpdhd", "f_FRk 0x%x", 'x', f_FRk, "f_FRi 0x%x", 'x', f_FRi, "f_u6 0x%x", 'x', f_u6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmexpdhd:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmexpdhd.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_CCi;
    UINT f_cond;
    UINT f_u6;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_u6 = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRk) = f_FRk;
  FLD (f_cond) = f_cond;
  FLD (f_FRi) = f_FRi;
  FLD (f_u6) = f_u6;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmexpdhd", "f_CCi 0x%x", 'x', f_CCi, "f_FRk 0x%x", 'x', f_FRk, "f_cond 0x%x", 'x', f_cond, "f_FRi 0x%x", 'x', f_FRi, "f_u6 0x%x", 'x', f_u6, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mpackh:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmaddhss.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mpackh", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mdpackh:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdpackh.f
    UINT f_FRk;
    UINT f_FRi;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mdpackh", "f_FRi 0x%x", 'x', f_FRi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRintieven) = f_FRi;
      FLD (out_FRintjeven) = f_FRj;
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_munpackh:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_munpackh.f
    UINT f_FRk;
    UINT f_FRi;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_munpackh", "f_FRi 0x%x", 'x', f_FRi, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRinti) = f_FRi;
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRinti_0) = ((FLD (f_FRi)) + (0));
      FLD (out_FRinti) = f_FRi;
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_add__INT_0_1) = ((FLD (f_FRk)) + (((0) + (1))));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_add__INT_0_1) = ((FLD (f_FRk)) + (((0) + (1))));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mdunpackh:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdunpackh.f
    UINT f_FRk;
    UINT f_FRi;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRi) = f_FRi;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mdunpackh", "f_FRi 0x%x", 'x', f_FRi, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintieven) = f_FRi;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_0) = ((FLD (f_FRi)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintieven_1) = ((FLD (f_FRi)) + (1));
      FLD (out_FRintieven) = f_FRi;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_2) = ((FLD (f_FRk)) + (2));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_add__INT_0_1) = ((FLD (f_FRk)) + (((0) + (1))));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_add__INT_2_1) = ((FLD (f_FRk)) + (((2) + (1))));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_2) = ((FLD (f_FRk)) + (2));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_add__INT_0_1) = ((FLD (f_FRk)) + (((0) + (1))));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_add__INT_2_1) = ((FLD (f_FRk)) + (((2) + (1))));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mbtoh:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmbtoh.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mbtoh", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintj) = f_FRj;
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_0_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_1_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_2_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_3_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_FRintj) = f_FRj;
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmbtoh:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmbtoh.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmbtoh", "f_CCi 0x%x", 'x', f_CCi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_FRintkeven) = f_FRk;
      FLD (in_h_fr_0_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_1_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_2_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_3_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_FRintj) = f_FRj;
      FLD (out_FRintkeven) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintkeven_1) = ((FLD (f_FRk)) + (1));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mhtob:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmhtob.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mhtob", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRintjeven) = f_FRj;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_0_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_1_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_2_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_3_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmhtob:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmhtob.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmhtob", "f_CCi 0x%x", 'x', f_CCi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintjeven) = f_FRj;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_hi_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_lo_UHI_add__INT_index_of__INT_FRintjeven_1) = ((FLD (f_FRj)) + (1));
      FLD (out_FRintjeven) = f_FRj;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_0_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_1_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_2_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_3_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mbtohe:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmbtohe.f
    UINT f_FRk;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mbtohe", "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_FRintj) = f_FRj;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_0_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_1_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_2_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_3_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_FRintj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_2) = ((FLD (f_FRk)) + (2));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_3) = ((FLD (f_FRk)) + (3));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_2) = ((FLD (f_FRk)) + (2));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_3) = ((FLD (f_FRk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_cmbtohe:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmbtohe.f
    UINT f_FRk;
    UINT f_CCi;
    UINT f_cond;
    UINT f_FRj;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_CCi = EXTRACT_LSB0_UINT (insn, 32, 11, 3);
    f_cond = EXTRACT_LSB0_UINT (insn, 32, 8, 1);
    f_FRj = EXTRACT_LSB0_UINT (insn, 32, 5, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_CCi) = f_CCi;
  FLD (f_FRj) = f_FRj;
  FLD (f_FRk) = f_FRk;
  FLD (f_cond) = f_cond;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_cmbtohe", "f_CCi 0x%x", 'x', f_CCi, "f_FRj 0x%x", 'x', f_FRj, "f_FRk 0x%x", 'x', f_FRk, "f_cond 0x%x", 'x', f_cond, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_CCi) = f_CCi;
      FLD (in_FRintj) = f_FRj;
      FLD (in_FRintk) = f_FRk;
      FLD (in_h_fr_0_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_1_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_2_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (in_h_fr_3_UHI_add__INT_index_of__INT_FRintj_0) = ((FLD (f_FRj)) + (0));
      FLD (out_FRintj) = f_FRj;
      FLD (out_FRintk) = f_FRk;
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_2) = ((FLD (f_FRk)) + (2));
      FLD (out_h_fr_hi_UHI_add__INT_index_of__INT_FRintk_3) = ((FLD (f_FRk)) + (3));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_0) = ((FLD (f_FRk)) + (0));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_1) = ((FLD (f_FRk)) + (1));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_2) = ((FLD (f_FRk)) + (2));
      FLD (out_h_fr_lo_UHI_add__INT_index_of__INT_FRintk_3) = ((FLD (f_FRk)) + (3));
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mclracc_0:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mdasaccs.f
    UINT f_ACC40Sk;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Sk) = f_ACC40Sk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mclracc_0", "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, (char *) 0));

#undef FLD
    return idesc;
  }

 extract_sfmt_mrdacc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mcuti.f
    UINT f_FRk;
    UINT f_ACC40Si;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACC40Si = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Si) = f_ACC40Si;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mrdacc", "f_ACC40Si 0x%x", 'x', f_ACC40Si, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Si) = f_ACC40Si;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mrdaccg:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mrdaccg.f
    UINT f_FRk;
    UINT f_ACCGi;

    f_FRk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_ACCGi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACCGi) = f_ACCGi;
  FLD (f_FRk) = f_FRk;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mrdaccg", "f_ACCGi 0x%x", 'x', f_ACCGi, "f_FRk 0x%x", 'x', f_FRk, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACCGi) = f_ACCGi;
      FLD (out_FRintk) = f_FRk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mwtacc:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_cmmachs.f
    UINT f_ACC40Sk;
    UINT f_FRi;

    f_ACC40Sk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACC40Sk) = f_ACC40Sk;
  FLD (f_FRi) = f_FRi;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mwtacc", "f_ACC40Sk 0x%x", 'x', f_ACC40Sk, "f_FRi 0x%x", 'x', f_FRi, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACC40Sk) = f_ACC40Sk;
      FLD (in_FRinti) = f_FRi;
      FLD (out_ACC40Sk) = f_ACC40Sk;
    }
#endif
#undef FLD
    return idesc;
  }

 extract_sfmt_mwtaccg:
  {
    const IDESC *idesc = &frvbf_insn_data[itype];
    CGEN_INSN_WORD insn = entire_insn;
#define FLD(f) abuf->fields.sfmt_mwtaccg.f
    UINT f_ACCGk;
    UINT f_FRi;

    f_ACCGk = EXTRACT_LSB0_UINT (insn, 32, 30, 6);
    f_FRi = EXTRACT_LSB0_UINT (insn, 32, 17, 6);

  /* Record the fields for the semantic handler.  */
  FLD (f_ACCGk) = f_ACCGk;
  FLD (f_FRi) = f_FRi;
  CGEN_TRACE_EXTRACT (current_cpu, abuf, (current_cpu, pc, "sfmt_mwtaccg", "f_ACCGk 0x%x", 'x', f_ACCGk, "f_FRi 0x%x", 'x', f_FRi, (char *) 0));

#if WITH_PROFILE_MODEL_P
  /* Record the fields for profiling.  */
  if (PROFILE_MODEL_P (current_cpu))
    {
      FLD (in_ACCGk) = f_ACCGk;
      FLD (in_FRinti) = f_FRi;
      FLD (out_ACCGk) = f_ACCGk;
    }
#endif
#undef FLD
    return idesc;
  }

}
