// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include <grpc/support/port_platform.h>

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_15_13.h"
namespace grpc_core {
namespace geometry_15_13 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table5_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41,
    0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d,
    0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table5_1_emit_[52] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table5_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d,
    0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55,
    0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d,
    0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85,
    0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d,
    0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5,
    0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table5_emit_[2] = {
    table4_0_emit_,
    table5_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table5_ops_[2] = {
    table5_0_ops_,
    table5_1_ops_,
};
const uint8_t HuffDecoderCommon::table6_0_emit_[2] = {0x30, 0x31};
const uint8_t HuffDecoderCommon::table6_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05};
const uint8_t HuffDecoderCommon::table6_1_emit_[2] = {0x32, 0x61};
const uint8_t HuffDecoderCommon::table6_2_emit_[2] = {0x63, 0x65};
const uint8_t HuffDecoderCommon::table6_3_emit_[2] = {0x69, 0x6f};
const uint8_t HuffDecoderCommon::table6_4_emit_[2] = {0x73, 0x74};
const uint8_t HuffDecoderCommon::table6_5_emit_[4] = {0x20, 0x25, 0x2d, 0x2e};
const uint8_t HuffDecoderCommon::table6_5_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d};
const uint8_t HuffDecoderCommon::table6_6_emit_[4] = {0x2f, 0x33, 0x34, 0x35};
const uint8_t HuffDecoderCommon::table6_7_emit_[4] = {0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table6_8_emit_[4] = {0x3d, 0x41, 0x5f, 0x62};
const uint8_t HuffDecoderCommon::table6_9_emit_[4] = {0x64, 0x66, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table6_10_emit_[4] = {0x6c, 0x6d, 0x6e, 0x70};
const uint8_t HuffDecoderCommon::table6_11_emit_[6] = {0x72, 0x75, 0x3a,
                                                       0x42, 0x43, 0x44};
const uint8_t HuffDecoderCommon::table6_11_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
    0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15};
const uint8_t HuffDecoderCommon::table6_12_emit_[8] = {0x45, 0x46, 0x47, 0x48,
                                                       0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table6_12_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d};
const uint8_t HuffDecoderCommon::table6_13_emit_[8] = {0x4d, 0x4e, 0x4f, 0x50,
                                                       0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table6_14_emit_[8] = {0x55, 0x56, 0x57, 0x59,
                                                       0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table6_15_emit_[10] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table6_15_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x11, 0x00, 0x15, 0x00, 0x19,
    0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table6_emit_[16] = {
    table6_0_emit_,  table6_1_emit_,  table6_2_emit_,  table6_3_emit_,
    table6_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table6_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table6_ops_[16] = {
    table6_0_ops_,  table6_0_ops_,  table6_0_ops_,  table6_0_ops_,
    table6_0_ops_,  table6_5_ops_,  table6_5_ops_,  table6_5_ops_,
    table6_5_ops_,  table6_5_ops_,  table6_5_ops_,  table6_11_ops_,
    table6_12_ops_, table6_12_ops_, table6_12_ops_, table6_15_ops_,
};
const uint8_t HuffDecoderCommon::table7_0_emit_[36] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x31, 0x31, 0x32, 0x31, 0x61,
    0x31, 0x63, 0x31, 0x65, 0x31, 0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table7_0_ops_[64] = {
    0x00, 0x04, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x08,
    0x4c, 0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a};
const uint8_t HuffDecoderCommon::table7_1_emit_[36] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x61, 0x30, 0x61, 0x31, 0x61,
    0x61, 0x63, 0x61, 0x65, 0x61, 0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table7_1_ops_[64] = {
    0x00, 0x08, 0x10, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x18, 0x5c, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a};
const uint8_t HuffDecoderCommon::table7_2_emit_[36] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x65, 0x30, 0x65, 0x31, 0x65,
    0x32, 0x65, 0x61, 0x65, 0x65, 0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table7_2_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x5c, 0x64, 0x28, 0x6c, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2a};
const uint8_t HuffDecoderCommon::table7_3_emit_[36] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x30, 0x6f, 0x31, 0x6f,
    0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65, 0x6f, 0x6f, 0x73, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table7_3_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x5c, 0x64, 0x6c, 0x74, 0x38, 0x7c, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3a};
const uint8_t HuffDecoderCommon::table7_4_emit_[38] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63,
    0x73, 0x65, 0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x30,
    0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table7_4_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x48,
    0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4a};
const uint8_t HuffDecoderCommon::table7_5_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e};
const uint8_t HuffDecoderCommon::table7_11_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16};
const uint8_t HuffDecoderCommon::table7_12_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x1a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1e};
const uint8_t HuffDecoderCommon::table7_15_emit_[15] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b,
    0x58, 0x5a, 0x21, 0x22, 0x28, 0x29, 0x3f};
const uint8_t HuffDecoderCommon::table7_15_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x1a,
    0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01, 0x22, 0x01, 0x01, 0x01,
    0x26, 0x2a, 0x2e, 0x32, 0x36, 0x3a, 0x01, 0x01, 0x03};
const uint8_t* const HuffDecoderCommon::table7_emit_[16] = {
    table7_0_emit_,  table7_1_emit_,  table7_2_emit_,  table7_3_emit_,
    table7_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table7_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table7_ops_[16] = {
    table7_0_ops_,  table7_1_ops_,  table7_2_ops_,  table7_3_ops_,
    table7_4_ops_,  table7_5_ops_,  table7_5_ops_,  table7_5_ops_,
    table7_5_ops_,  table7_5_ops_,  table7_5_ops_,  table7_11_ops_,
    table7_12_ops_, table7_12_ops_, table7_12_ops_, table7_15_ops_,
};
const uint8_t HuffDecoderCommon::table8_0_emit_[71] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x30, 0x20, 0x30, 0x25, 0x30,
    0x2d, 0x30, 0x2e, 0x30, 0x2f, 0x30, 0x33, 0x30, 0x34, 0x30, 0x35, 0x30,
    0x36, 0x30, 0x37, 0x30, 0x38, 0x30, 0x39, 0x30, 0x3d, 0x30, 0x41, 0x30,
    0x5f, 0x30, 0x62, 0x30, 0x64, 0x30, 0x66, 0x30, 0x67, 0x30, 0x68, 0x30,
    0x6c, 0x30, 0x6d, 0x30, 0x6e, 0x30, 0x70, 0x30, 0x72, 0x30, 0x75};
const uint16_t HuffDecoderCommon::table8_0_inner_[38] = {
    0x0000, 0x0001, 0x0005, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_0_outer_[64] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,
    0,  9,  0,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  37};
const uint8_t HuffDecoderCommon::table8_1_emit_[71] = {
    0x31, 0x30, 0x31, 0x31, 0x32, 0x31, 0x61, 0x31, 0x63, 0x31, 0x65, 0x31,
    0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74, 0x31, 0x20, 0x31, 0x25, 0x31,
    0x2d, 0x31, 0x2e, 0x31, 0x2f, 0x31, 0x33, 0x31, 0x34, 0x31, 0x35, 0x31,
    0x36, 0x31, 0x37, 0x31, 0x38, 0x31, 0x39, 0x31, 0x3d, 0x31, 0x41, 0x31,
    0x5f, 0x31, 0x62, 0x31, 0x64, 0x31, 0x66, 0x31, 0x67, 0x31, 0x68, 0x31,
    0x6c, 0x31, 0x6d, 0x31, 0x6e, 0x31, 0x70, 0x31, 0x72, 0x31, 0x75};
const uint16_t HuffDecoderCommon::table8_1_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_2_emit_[71] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x32, 0x20, 0x32, 0x25, 0x32,
    0x2d, 0x32, 0x2e, 0x32, 0x2f, 0x32, 0x33, 0x32, 0x34, 0x32, 0x35, 0x32,
    0x36, 0x32, 0x37, 0x32, 0x38, 0x32, 0x39, 0x32, 0x3d, 0x32, 0x41, 0x32,
    0x5f, 0x32, 0x62, 0x32, 0x64, 0x32, 0x66, 0x32, 0x67, 0x32, 0x68, 0x32,
    0x6c, 0x32, 0x6d, 0x32, 0x6e, 0x32, 0x70, 0x32, 0x72, 0x32, 0x75};
const uint16_t HuffDecoderCommon::table8_2_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_3_emit_[71] = {
    0x61, 0x30, 0x61, 0x31, 0x61, 0x32, 0x61, 0x61, 0x63, 0x61, 0x65, 0x61,
    0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74, 0x61, 0x20, 0x61, 0x25, 0x61,
    0x2d, 0x61, 0x2e, 0x61, 0x2f, 0x61, 0x33, 0x61, 0x34, 0x61, 0x35, 0x61,
    0x36, 0x61, 0x37, 0x61, 0x38, 0x61, 0x39, 0x61, 0x3d, 0x61, 0x41, 0x61,
    0x5f, 0x61, 0x62, 0x61, 0x64, 0x61, 0x66, 0x61, 0x67, 0x61, 0x68, 0x61,
    0x6c, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x70, 0x61, 0x72, 0x61, 0x75};
const uint16_t HuffDecoderCommon::table8_3_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_4_emit_[71] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x63, 0x20, 0x63, 0x25, 0x63,
    0x2d, 0x63, 0x2e, 0x63, 0x2f, 0x63, 0x33, 0x63, 0x34, 0x63, 0x35, 0x63,
    0x36, 0x63, 0x37, 0x63, 0x38, 0x63, 0x39, 0x63, 0x3d, 0x63, 0x41, 0x63,
    0x5f, 0x63, 0x62, 0x63, 0x64, 0x63, 0x66, 0x63, 0x67, 0x63, 0x68, 0x63,
    0x6c, 0x63, 0x6d, 0x63, 0x6e, 0x63, 0x70, 0x63, 0x72, 0x63, 0x75};
const uint16_t HuffDecoderCommon::table8_4_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_5_emit_[71] = {
    0x65, 0x30, 0x65, 0x31, 0x65, 0x32, 0x65, 0x61, 0x65, 0x63, 0x65, 0x65,
    0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74, 0x65, 0x20, 0x65, 0x25, 0x65,
    0x2d, 0x65, 0x2e, 0x65, 0x2f, 0x65, 0x33, 0x65, 0x34, 0x65, 0x35, 0x65,
    0x36, 0x65, 0x37, 0x65, 0x38, 0x65, 0x39, 0x65, 0x3d, 0x65, 0x41, 0x65,
    0x5f, 0x65, 0x62, 0x65, 0x64, 0x65, 0x66, 0x65, 0x67, 0x65, 0x68, 0x65,
    0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x70, 0x65, 0x72, 0x65, 0x75};
const uint16_t HuffDecoderCommon::table8_5_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_6_emit_[71] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x69, 0x20, 0x69, 0x25, 0x69,
    0x2d, 0x69, 0x2e, 0x69, 0x2f, 0x69, 0x33, 0x69, 0x34, 0x69, 0x35, 0x69,
    0x36, 0x69, 0x37, 0x69, 0x38, 0x69, 0x39, 0x69, 0x3d, 0x69, 0x41, 0x69,
    0x5f, 0x69, 0x62, 0x69, 0x64, 0x69, 0x66, 0x69, 0x67, 0x69, 0x68, 0x69,
    0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x69, 0x70, 0x69, 0x72, 0x69, 0x75};
const uint16_t HuffDecoderCommon::table8_6_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_7_emit_[71] = {
    0x6f, 0x30, 0x6f, 0x31, 0x6f, 0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65,
    0x6f, 0x69, 0x6f, 0x6f, 0x73, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x25, 0x6f,
    0x2d, 0x6f, 0x2e, 0x6f, 0x2f, 0x6f, 0x33, 0x6f, 0x34, 0x6f, 0x35, 0x6f,
    0x36, 0x6f, 0x37, 0x6f, 0x38, 0x6f, 0x39, 0x6f, 0x3d, 0x6f, 0x41, 0x6f,
    0x5f, 0x6f, 0x62, 0x6f, 0x64, 0x6f, 0x66, 0x6f, 0x67, 0x6f, 0x68, 0x6f,
    0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x6f, 0x70, 0x6f, 0x72, 0x6f, 0x75};
const uint16_t HuffDecoderCommon::table8_7_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_8_emit_[71] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63, 0x73, 0x65,
    0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x73, 0x20, 0x73, 0x25, 0x73,
    0x2d, 0x73, 0x2e, 0x73, 0x2f, 0x73, 0x33, 0x73, 0x34, 0x73, 0x35, 0x73,
    0x36, 0x73, 0x37, 0x73, 0x38, 0x73, 0x39, 0x73, 0x3d, 0x73, 0x41, 0x73,
    0x5f, 0x73, 0x62, 0x73, 0x64, 0x73, 0x66, 0x73, 0x67, 0x73, 0x68, 0x73,
    0x6c, 0x73, 0x6d, 0x73, 0x6e, 0x73, 0x70, 0x73, 0x72, 0x73, 0x75};
const uint16_t HuffDecoderCommon::table8_8_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_9_emit_[71] = {
    0x74, 0x30, 0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74, 0x20, 0x74, 0x25, 0x74,
    0x2d, 0x74, 0x2e, 0x74, 0x2f, 0x74, 0x33, 0x74, 0x34, 0x74, 0x35, 0x74,
    0x36, 0x74, 0x37, 0x74, 0x38, 0x74, 0x39, 0x74, 0x3d, 0x74, 0x41, 0x74,
    0x5f, 0x74, 0x62, 0x74, 0x64, 0x74, 0x66, 0x74, 0x67, 0x74, 0x68, 0x74,
    0x6c, 0x74, 0x6d, 0x74, 0x6e, 0x74, 0x70, 0x74, 0x72, 0x74, 0x75};
const uint16_t HuffDecoderCommon::table8_9_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_10_emit_[40] = {
    0x20, 0x30, 0x20, 0x31, 0x20, 0x32, 0x20, 0x61, 0x20, 0x63,
    0x20, 0x65, 0x20, 0x69, 0x20, 0x6f, 0x20, 0x73, 0x20, 0x74,
    0x25, 0x30, 0x25, 0x31, 0x25, 0x32, 0x25, 0x61, 0x25, 0x63,
    0x25, 0x65, 0x25, 0x69, 0x25, 0x6f, 0x25, 0x73, 0x25, 0x74};
const uint16_t HuffDecoderCommon::table8_10_inner_[23] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0002, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x0052};
const uint8_t HuffDecoderCommon::table8_10_outer_[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11,
    12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 22};
const uint8_t HuffDecoderCommon::table8_11_emit_[40] = {
    0x2d, 0x30, 0x2d, 0x31, 0x2d, 0x32, 0x2d, 0x61, 0x2d, 0x63,
    0x2d, 0x65, 0x2d, 0x69, 0x2d, 0x6f, 0x2d, 0x73, 0x2d, 0x74,
    0x2e, 0x30, 0x2e, 0x31, 0x2e, 0x32, 0x2e, 0x61, 0x2e, 0x63,
    0x2e, 0x65, 0x2e, 0x69, 0x2e, 0x6f, 0x2e, 0x73, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table8_12_emit_[40] = {
    0x2f, 0x30, 0x2f, 0x31, 0x2f, 0x32, 0x2f, 0x61, 0x2f, 0x63,
    0x2f, 0x65, 0x2f, 0x69, 0x2f, 0x6f, 0x2f, 0x73, 0x2f, 0x74,
    0x33, 0x30, 0x33, 0x31, 0x33, 0x32, 0x33, 0x61, 0x33, 0x63,
    0x33, 0x65, 0x33, 0x69, 0x33, 0x6f, 0x33, 0x73, 0x33, 0x74};
const uint8_t HuffDecoderCommon::table8_13_emit_[40] = {
    0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x61, 0x34, 0x63,
    0x34, 0x65, 0x34, 0x69, 0x34, 0x6f, 0x34, 0x73, 0x34, 0x74,
    0x35, 0x30, 0x35, 0x31, 0x35, 0x32, 0x35, 0x61, 0x35, 0x63,
    0x35, 0x65, 0x35, 0x69, 0x35, 0x6f, 0x35, 0x73, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table8_14_emit_[40] = {
    0x36, 0x30, 0x36, 0x31, 0x36, 0x32, 0x36, 0x61, 0x36, 0x63,
    0x36, 0x65, 0x36, 0x69, 0x36, 0x6f, 0x36, 0x73, 0x36, 0x74,
    0x37, 0x30, 0x37, 0x31, 0x37, 0x32, 0x37, 0x61, 0x37, 0x63,
    0x37, 0x65, 0x37, 0x69, 0x37, 0x6f, 0x37, 0x73, 0x37, 0x74};
const uint8_t HuffDecoderCommon::table8_15_emit_[40] = {
    0x38, 0x30, 0x38, 0x31, 0x38, 0x32, 0x38, 0x61, 0x38, 0x63,
    0x38, 0x65, 0x38, 0x69, 0x38, 0x6f, 0x38, 0x73, 0x38, 0x74,
    0x39, 0x30, 0x39, 0x31, 0x39, 0x32, 0x39, 0x61, 0x39, 0x63,
    0x39, 0x65, 0x39, 0x69, 0x39, 0x6f, 0x39, 0x73, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table8_16_emit_[40] = {
    0x3d, 0x30, 0x3d, 0x31, 0x3d, 0x32, 0x3d, 0x61, 0x3d, 0x63,
    0x3d, 0x65, 0x3d, 0x69, 0x3d, 0x6f, 0x3d, 0x73, 0x3d, 0x74,
    0x41, 0x30, 0x41, 0x31, 0x41, 0x32, 0x41, 0x61, 0x41, 0x63,
    0x41, 0x65, 0x41, 0x69, 0x41, 0x6f, 0x41, 0x73, 0x41, 0x74};
const uint8_t HuffDecoderCommon::table8_17_emit_[40] = {
    0x5f, 0x30, 0x5f, 0x31, 0x5f, 0x32, 0x5f, 0x61, 0x5f, 0x63,
    0x5f, 0x65, 0x5f, 0x69, 0x5f, 0x6f, 0x5f, 0x73, 0x5f, 0x74,
    0x62, 0x30, 0x62, 0x31, 0x62, 0x32, 0x62, 0x61, 0x62, 0x63,
    0x62, 0x65, 0x62, 0x69, 0x62, 0x6f, 0x62, 0x73, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table8_18_emit_[40] = {
    0x64, 0x30, 0x64, 0x31, 0x64, 0x32, 0x64, 0x61, 0x64, 0x63,
    0x64, 0x65, 0x64, 0x69, 0x64, 0x6f, 0x64, 0x73, 0x64, 0x74,
    0x66, 0x30, 0x66, 0x31, 0x66, 0x32, 0x66, 0x61, 0x66, 0x63,
    0x66, 0x65, 0x66, 0x69, 0x66, 0x6f, 0x66, 0x73, 0x66, 0x74};
const uint8_t HuffDecoderCommon::table8_19_emit_[40] = {
    0x67, 0x30, 0x67, 0x31, 0x67, 0x32, 0x67, 0x61, 0x67, 0x63,
    0x67, 0x65, 0x67, 0x69, 0x67, 0x6f, 0x67, 0x73, 0x67, 0x74,
    0x68, 0x30, 0x68, 0x31, 0x68, 0x32, 0x68, 0x61, 0x68, 0x63,
    0x68, 0x65, 0x68, 0x69, 0x68, 0x6f, 0x68, 0x73, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table8_20_emit_[40] = {
    0x6c, 0x30, 0x6c, 0x31, 0x6c, 0x32, 0x6c, 0x61, 0x6c, 0x63,
    0x6c, 0x65, 0x6c, 0x69, 0x6c, 0x6f, 0x6c, 0x73, 0x6c, 0x74,
    0x6d, 0x30, 0x6d, 0x31, 0x6d, 0x32, 0x6d, 0x61, 0x6d, 0x63,
    0x6d, 0x65, 0x6d, 0x69, 0x6d, 0x6f, 0x6d, 0x73, 0x6d, 0x74};
const uint8_t HuffDecoderCommon::table8_21_emit_[40] = {
    0x6e, 0x30, 0x6e, 0x31, 0x6e, 0x32, 0x6e, 0x61, 0x6e, 0x63,
    0x6e, 0x65, 0x6e, 0x69, 0x6e, 0x6f, 0x6e, 0x73, 0x6e, 0x74,
    0x70, 0x30, 0x70, 0x31, 0x70, 0x32, 0x70, 0x61, 0x70, 0x63,
    0x70, 0x65, 0x70, 0x69, 0x70, 0x6f, 0x70, 0x73, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table8_22_emit_[40] = {
    0x72, 0x30, 0x72, 0x31, 0x72, 0x32, 0x72, 0x61, 0x72, 0x63,
    0x72, 0x65, 0x72, 0x69, 0x72, 0x6f, 0x72, 0x73, 0x72, 0x74,
    0x75, 0x30, 0x75, 0x31, 0x75, 0x32, 0x75, 0x61, 0x75, 0x63,
    0x75, 0x65, 0x75, 0x69, 0x75, 0x6f, 0x75, 0x73, 0x75, 0x74};
const uint8_t HuffDecoderCommon::table8_23_emit_[4] = {0x3a, 0x42, 0x43, 0x44};
const uint16_t HuffDecoderCommon::table8_23_inner_[5] = {0x0000, 0x0002, 0x0006,
                                                         0x000a, 0x000e};
const uint8_t HuffDecoderCommon::table8_23_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4};
const uint8_t HuffDecoderCommon::table8_24_emit_[4] = {0x45, 0x46, 0x47, 0x48};
const uint8_t HuffDecoderCommon::table8_25_emit_[4] = {0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table8_26_emit_[4] = {0x4d, 0x4e, 0x4f, 0x50};
const uint8_t HuffDecoderCommon::table8_27_emit_[4] = {0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table8_28_emit_[4] = {0x55, 0x56, 0x57, 0x59};
const uint8_t HuffDecoderCommon::table8_29_emit_[4] = {0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table8_30_emit_[4] = {0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table8_31_emit_[14] = {
    0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a, 0x21,
    0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c};
const uint16_t HuffDecoderCommon::table8_31_inner_[16] = {
    0x0000, 0x0002, 0x0006, 0x000a, 0x000e, 0x0012, 0x0016, 0x001a,
    0x001e, 0x0022, 0x0026, 0x002a, 0x002e, 0x0032, 0x0036, 0x0003};
const uint8_t HuffDecoderCommon::table8_31_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,  0, 0,  0,  2,  0,  0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,  0, 0,  0,  0,  0,  5, 0, 0, 0, 0,
    0, 0, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 12, 13, 14, 0, 0, 15};
const uint8_t* const HuffDecoderCommon::table8_emit_[32] = {
    table8_0_emit_,  table8_1_emit_,  table8_2_emit_,  table8_3_emit_,
    table8_4_emit_,  table8_5_emit_,  table8_6_emit_,  table8_7_emit_,
    table8_8_emit_,  table8_9_emit_,  table8_10_emit_, table8_11_emit_,
    table8_12_emit_, table8_13_emit_, table8_14_emit_, table8_15_emit_,
    table8_16_emit_, table8_17_emit_, table8_18_emit_, table8_19_emit_,
    table8_20_emit_, table8_21_emit_, table8_22_emit_, table8_23_emit_,
    table8_24_emit_, table8_25_emit_, table8_26_emit_, table8_27_emit_,
    table8_28_emit_, table8_29_emit_, table8_30_emit_, table8_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table8_inner_[32] = {
    table8_0_inner_,  table8_1_inner_,  table8_2_inner_,  table8_3_inner_,
    table8_4_inner_,  table8_5_inner_,  table8_6_inner_,  table8_7_inner_,
    table8_8_inner_,  table8_9_inner_,  table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_23_inner_,
    table8_23_inner_, table8_23_inner_, table8_23_inner_, table8_23_inner_,
    table8_23_inner_, table8_23_inner_, table8_23_inner_, table8_31_inner_,
};
const uint8_t* const HuffDecoderCommon::table8_outer_[32] = {
    table8_0_outer_,  table8_0_outer_,  table8_0_outer_,  table8_0_outer_,
    table8_0_outer_,  table8_0_outer_,  table8_0_outer_,  table8_0_outer_,
    table8_0_outer_,  table8_0_outer_,  table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_23_outer_,
    table8_23_outer_, table8_23_outer_, table8_23_outer_, table8_23_outer_,
    table8_23_outer_, table8_23_outer_, table8_23_outer_, table8_31_outer_,
};
const uint8_t HuffDecoderCommon::table9_0_emit_[15] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30,
    0x63, 0x30, 0x65, 0x30, 0x69, 0x30, 0x6f};
const uint8_t HuffDecoderCommon::table9_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x0d, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_1_emit_[28] = {
    0x30, 0x73, 0x30, 0x74, 0x30, 0x20, 0x30, 0x25, 0x30, 0x2d,
    0x30, 0x2e, 0x30, 0x2f, 0x30, 0x33, 0x30, 0x34, 0x30, 0x35,
    0x30, 0x36, 0x30, 0x37, 0x30, 0x38, 0x30, 0x39};
const uint8_t HuffDecoderCommon::table9_1_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x11, 0x00,
    0x19, 0x00, 0x21, 0x00, 0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41,
    0x00, 0x49, 0x00, 0x51, 0x00, 0x59, 0x00, 0x61, 0x00, 0x69};
const uint8_t HuffDecoderCommon::table9_2_emit_[36] = {
    0x30, 0x3d, 0x30, 0x41, 0x30, 0x5f, 0x30, 0x62, 0x30, 0x64, 0x30, 0x66,
    0x30, 0x67, 0x30, 0x68, 0x30, 0x6c, 0x30, 0x6d, 0x30, 0x6e, 0x30, 0x70,
    0x30, 0x72, 0x30, 0x75, 0x30, 0x3a, 0x30, 0x42, 0x30, 0x43, 0x30, 0x44};
const uint8_t HuffDecoderCommon::table9_2_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x00, 0x51,
    0x00, 0x59, 0x00, 0x61, 0x00, 0x69, 0x71, 0x79, 0x81, 0x89};
const uint8_t HuffDecoderCommon::table9_3_emit_[56] = {
    0x30, 0x45, 0x30, 0x46, 0x30, 0x47, 0x30, 0x48, 0x30, 0x49, 0x30, 0x4a,
    0x30, 0x4b, 0x30, 0x4c, 0x30, 0x4d, 0x30, 0x4e, 0x30, 0x4f, 0x30, 0x50,
    0x30, 0x51, 0x30, 0x52, 0x30, 0x53, 0x30, 0x54, 0x30, 0x55, 0x30, 0x56,
    0x30, 0x57, 0x30, 0x59, 0x30, 0x6a, 0x30, 0x6b, 0x30, 0x71, 0x30, 0x76,
    0x30, 0x77, 0x30, 0x78, 0x30, 0x79, 0x30, 0x7a};
const uint8_t HuffDecoderCommon::table9_3_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9,
    0xb1, 0xb9, 0xc1, 0xc9, 0xd1, 0xd9, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_4_emit_[15] = {
    0x31, 0x30, 0x31, 0x31, 0x32, 0x31, 0x61, 0x31,
    0x63, 0x31, 0x65, 0x31, 0x69, 0x31, 0x6f};
const uint8_t HuffDecoderCommon::table9_4_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x0d, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_5_emit_[28] = {
    0x31, 0x73, 0x31, 0x74, 0x31, 0x20, 0x31, 0x25, 0x31, 0x2d,
    0x31, 0x2e, 0x31, 0x2f, 0x31, 0x33, 0x31, 0x34, 0x31, 0x35,
    0x31, 0x36, 0x31, 0x37, 0x31, 0x38, 0x31, 0x39};
const uint8_t HuffDecoderCommon::table9_6_emit_[36] = {
    0x31, 0x3d, 0x31, 0x41, 0x31, 0x5f, 0x31, 0x62, 0x31, 0x64, 0x31, 0x66,
    0x31, 0x67, 0x31, 0x68, 0x31, 0x6c, 0x31, 0x6d, 0x31, 0x6e, 0x31, 0x70,
    0x31, 0x72, 0x31, 0x75, 0x31, 0x3a, 0x31, 0x42, 0x31, 0x43, 0x31, 0x44};
const uint8_t HuffDecoderCommon::table9_7_emit_[56] = {
    0x31, 0x45, 0x31, 0x46, 0x31, 0x47, 0x31, 0x48, 0x31, 0x49, 0x31, 0x4a,
    0x31, 0x4b, 0x31, 0x4c, 0x31, 0x4d, 0x31, 0x4e, 0x31, 0x4f, 0x31, 0x50,
    0x31, 0x51, 0x31, 0x52, 0x31, 0x53, 0x31, 0x54, 0x31, 0x55, 0x31, 0x56,
    0x31, 0x57, 0x31, 0x59, 0x31, 0x6a, 0x31, 0x6b, 0x31, 0x71, 0x31, 0x76,
    0x31, 0x77, 0x31, 0x78, 0x31, 0x79, 0x31, 0x7a};
const uint8_t HuffDecoderCommon::table9_8_emit_[15] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32,
    0x63, 0x32, 0x65, 0x32, 0x69, 0x32, 0x6f};
const uint8_t HuffDecoderCommon::table9_8_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_9_emit_[28] = {
    0x32, 0x73, 0x32, 0x74, 0x32, 0x20, 0x32, 0x25, 0x32, 0x2d,
    0x32, 0x2e, 0x32, 0x2f, 0x32, 0x33, 0x32, 0x34, 0x32, 0x35,
    0x32, 0x36, 0x32, 0x37, 0x32, 0x38, 0x32, 0x39};
const uint8_t HuffDecoderCommon::table9_10_emit_[36] = {
    0x32, 0x3d, 0x32, 0x41, 0x32, 0x5f, 0x32, 0x62, 0x32, 0x64, 0x32, 0x66,
    0x32, 0x67, 0x32, 0x68, 0x32, 0x6c, 0x32, 0x6d, 0x32, 0x6e, 0x32, 0x70,
    0x32, 0x72, 0x32, 0x75, 0x32, 0x3a, 0x32, 0x42, 0x32, 0x43, 0x32, 0x44};
const uint8_t HuffDecoderCommon::table9_11_emit_[56] = {
    0x32, 0x45, 0x32, 0x46, 0x32, 0x47, 0x32, 0x48, 0x32, 0x49, 0x32, 0x4a,
    0x32, 0x4b, 0x32, 0x4c, 0x32, 0x4d, 0x32, 0x4e, 0x32, 0x4f, 0x32, 0x50,
    0x32, 0x51, 0x32, 0x52, 0x32, 0x53, 0x32, 0x54, 0x32, 0x55, 0x32, 0x56,
    0x32, 0x57, 0x32, 0x59, 0x32, 0x6a, 0x32, 0x6b, 0x32, 0x71, 0x32, 0x76,
    0x32, 0x77, 0x32, 0x78, 0x32, 0x79, 0x32, 0x7a};
const uint8_t HuffDecoderCommon::table9_12_emit_[15] = {
    0x61, 0x30, 0x61, 0x31, 0x61, 0x32, 0x61, 0x61,
    0x63, 0x61, 0x65, 0x61, 0x69, 0x61, 0x6f};
const uint8_t HuffDecoderCommon::table9_12_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_13_emit_[28] = {
    0x61, 0x73, 0x61, 0x74, 0x61, 0x20, 0x61, 0x25, 0x61, 0x2d,
    0x61, 0x2e, 0x61, 0x2f, 0x61, 0x33, 0x61, 0x34, 0x61, 0x35,
    0x61, 0x36, 0x61, 0x37, 0x61, 0x38, 0x61, 0x39};
const uint8_t HuffDecoderCommon::table9_14_emit_[36] = {
    0x61, 0x3d, 0x61, 0x41, 0x61, 0x5f, 0x61, 0x62, 0x61, 0x64, 0x61, 0x66,
    0x61, 0x67, 0x61, 0x68, 0x61, 0x6c, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x70,
    0x61, 0x72, 0x61, 0x75, 0x61, 0x3a, 0x61, 0x42, 0x61, 0x43, 0x61, 0x44};
const uint8_t HuffDecoderCommon::table9_15_emit_[56] = {
    0x61, 0x45, 0x61, 0x46, 0x61, 0x47, 0x61, 0x48, 0x61, 0x49, 0x61, 0x4a,
    0x61, 0x4b, 0x61, 0x4c, 0x61, 0x4d, 0x61, 0x4e, 0x61, 0x4f, 0x61, 0x50,
    0x61, 0x51, 0x61, 0x52, 0x61, 0x53, 0x61, 0x54, 0x61, 0x55, 0x61, 0x56,
    0x61, 0x57, 0x61, 0x59, 0x61, 0x6a, 0x61, 0x6b, 0x61, 0x71, 0x61, 0x76,
    0x61, 0x77, 0x61, 0x78, 0x61, 0x79, 0x61, 0x7a};
const uint8_t HuffDecoderCommon::table9_16_emit_[15] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61,
    0x63, 0x63, 0x65, 0x63, 0x69, 0x63, 0x6f};
const uint8_t HuffDecoderCommon::table9_16_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x25, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_17_emit_[28] = {
    0x63, 0x73, 0x63, 0x74, 0x63, 0x20, 0x63, 0x25, 0x63, 0x2d,
    0x63, 0x2e, 0x63, 0x2f, 0x63, 0x33, 0x63, 0x34, 0x63, 0x35,
    0x63, 0x36, 0x63, 0x37, 0x63, 0x38, 0x63, 0x39};
const uint8_t HuffDecoderCommon::table9_18_emit_[36] = {
    0x63, 0x3d, 0x63, 0x41, 0x63, 0x5f, 0x63, 0x62, 0x63, 0x64, 0x63, 0x66,
    0x63, 0x67, 0x63, 0x68, 0x63, 0x6c, 0x63, 0x6d, 0x63, 0x6e, 0x63, 0x70,
    0x63, 0x72, 0x63, 0x75, 0x63, 0x3a, 0x63, 0x42, 0x63, 0x43, 0x63, 0x44};
const uint8_t HuffDecoderCommon::table9_19_emit_[56] = {
    0x63, 0x45, 0x63, 0x46, 0x63, 0x47, 0x63, 0x48, 0x63, 0x49, 0x63, 0x4a,
    0x63, 0x4b, 0x63, 0x4c, 0x63, 0x4d, 0x63, 0x4e, 0x63, 0x4f, 0x63, 0x50,
    0x63, 0x51, 0x63, 0x52, 0x63, 0x53, 0x63, 0x54, 0x63, 0x55, 0x63, 0x56,
    0x63, 0x57, 0x63, 0x59, 0x63, 0x6a, 0x63, 0x6b, 0x63, 0x71, 0x63, 0x76,
    0x63, 0x77, 0x63, 0x78, 0x63, 0x79, 0x63, 0x7a};
const uint8_t HuffDecoderCommon::table9_20_emit_[15] = {
    0x65, 0x30, 0x65, 0x31, 0x65, 0x32, 0x65, 0x61,
    0x65, 0x63, 0x65, 0x65, 0x69, 0x65, 0x6f};
const uint8_t HuffDecoderCommon::table9_20_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_21_emit_[28] = {
    0x65, 0x73, 0x65, 0x74, 0x65, 0x20, 0x65, 0x25, 0x65, 0x2d,
    0x65, 0x2e, 0x65, 0x2f, 0x65, 0x33, 0x65, 0x34, 0x65, 0x35,
    0x65, 0x36, 0x65, 0x37, 0x65, 0x38, 0x65, 0x39};
const uint8_t HuffDecoderCommon::table9_22_emit_[36] = {
    0x65, 0x3d, 0x65, 0x41, 0x65, 0x5f, 0x65, 0x62, 0x65, 0x64, 0x65, 0x66,
    0x65, 0x67, 0x65, 0x68, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x70,
    0x65, 0x72, 0x65, 0x75, 0x65, 0x3a, 0x65, 0x42, 0x65, 0x43, 0x65, 0x44};
const uint8_t HuffDecoderCommon::table9_23_emit_[56] = {
    0x65, 0x45, 0x65, 0x46, 0x65, 0x47, 0x65, 0x48, 0x65, 0x49, 0x65, 0x4a,
    0x65, 0x4b, 0x65, 0x4c, 0x65, 0x4d, 0x65, 0x4e, 0x65, 0x4f, 0x65, 0x50,
    0x65, 0x51, 0x65, 0x52, 0x65, 0x53, 0x65, 0x54, 0x65, 0x55, 0x65, 0x56,
    0x65, 0x57, 0x65, 0x59, 0x65, 0x6a, 0x65, 0x6b, 0x65, 0x71, 0x65, 0x76,
    0x65, 0x77, 0x65, 0x78, 0x65, 0x79, 0x65, 0x7a};
const uint8_t HuffDecoderCommon::table9_24_emit_[15] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61,
    0x69, 0x63, 0x69, 0x65, 0x69, 0x69, 0x6f};
const uint8_t HuffDecoderCommon::table9_24_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35};
const uint8_t HuffDecoderCommon::table9_25_emit_[28] = {
    0x69, 0x73, 0x69, 0x74, 0x69, 0x20, 0x69, 0x25, 0x69, 0x2d,
    0x69, 0x2e, 0x69, 0x2f, 0x69, 0x33, 0x69, 0x34, 0x69, 0x35,
    0x69, 0x36, 0x69, 0x37, 0x69, 0x38, 0x69, 0x39};
const uint8_t HuffDecoderCommon::table9_26_emit_[36] = {
    0x69, 0x3d, 0x69, 0x41, 0x69, 0x5f, 0x69, 0x62, 0x69, 0x64, 0x69, 0x66,
    0x69, 0x67, 0x69, 0x68, 0x69, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x69, 0x70,
    0x69, 0x72, 0x69, 0x75, 0x69, 0x3a, 0x69, 0x42, 0x69, 0x43, 0x69, 0x44};
const uint8_t HuffDecoderCommon::table9_27_emit_[56] = {
    0x69, 0x45, 0x69, 0x46, 0x69, 0x47, 0x69, 0x48, 0x69, 0x49, 0x69, 0x4a,
    0x69, 0x4b, 0x69, 0x4c, 0x69, 0x4d, 0x69, 0x4e, 0x69, 0x4f, 0x69, 0x50,
    0x69, 0x51, 0x69, 0x52, 0x69, 0x53, 0x69, 0x54, 0x69, 0x55, 0x69, 0x56,
    0x69, 0x57, 0x69, 0x59, 0x69, 0x6a, 0x69, 0x6b, 0x69, 0x71, 0x69, 0x76,
    0x69, 0x77, 0x69, 0x78, 0x69, 0x79, 0x69, 0x7a};
const uint8_t HuffDecoderCommon::table9_28_emit_[16] = {
    0x6f, 0x30, 0x6f, 0x31, 0x6f, 0x32, 0x6f, 0x61,
    0x6f, 0x63, 0x6f, 0x65, 0x6f, 0x69, 0x6f, 0x6f};
const uint8_t HuffDecoderCommon::table9_28_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x39};
const uint8_t HuffDecoderCommon::table9_29_emit_[28] = {
    0x6f, 0x73, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x25, 0x6f, 0x2d,
    0x6f, 0x2e, 0x6f, 0x2f, 0x6f, 0x33, 0x6f, 0x34, 0x6f, 0x35,
    0x6f, 0x36, 0x6f, 0x37, 0x6f, 0x38, 0x6f, 0x39};
const uint8_t HuffDecoderCommon::table9_30_emit_[36] = {
    0x6f, 0x3d, 0x6f, 0x41, 0x6f, 0x5f, 0x6f, 0x62, 0x6f, 0x64, 0x6f, 0x66,
    0x6f, 0x67, 0x6f, 0x68, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x6f, 0x70,
    0x6f, 0x72, 0x6f, 0x75, 0x6f, 0x3a, 0x6f, 0x42, 0x6f, 0x43, 0x6f, 0x44};
const uint8_t HuffDecoderCommon::table9_31_emit_[56] = {
    0x6f, 0x45, 0x6f, 0x46, 0x6f, 0x47, 0x6f, 0x48, 0x6f, 0x49, 0x6f, 0x4a,
    0x6f, 0x4b, 0x6f, 0x4c, 0x6f, 0x4d, 0x6f, 0x4e, 0x6f, 0x4f, 0x6f, 0x50,
    0x6f, 0x51, 0x6f, 0x52, 0x6f, 0x53, 0x6f, 0x54, 0x6f, 0x55, 0x6f, 0x56,
    0x6f, 0x57, 0x6f, 0x59, 0x6f, 0x6a, 0x6f, 0x6b, 0x6f, 0x71, 0x6f, 0x76,
    0x6f, 0x77, 0x6f, 0x78, 0x6f, 0x79, 0x6f, 0x7a};
const uint8_t HuffDecoderCommon::table9_32_emit_[16] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61,
    0x73, 0x63, 0x73, 0x65, 0x73, 0x69, 0x73, 0x6f};
const uint8_t HuffDecoderCommon::table9_33_emit_[27] = {
    0x73, 0x73, 0x74, 0x73, 0x20, 0x73, 0x25, 0x73, 0x2d,
    0x73, 0x2e, 0x73, 0x2f, 0x73, 0x33, 0x73, 0x34, 0x73,
    0x35, 0x73, 0x36, 0x73, 0x37, 0x73, 0x38, 0x73, 0x39};
const uint8_t HuffDecoderCommon::table9_33_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0d, 0x00,
    0x15, 0x00, 0x1d, 0x00, 0x25, 0x00, 0x2d, 0x00, 0x35, 0x00, 0x3d,
    0x00, 0x45, 0x00, 0x4d, 0x00, 0x55, 0x00, 0x5d, 0x00, 0x65};
const uint8_t HuffDecoderCommon::table9_34_emit_[36] = {
    0x73, 0x3d, 0x73, 0x41, 0x73, 0x5f, 0x73, 0x62, 0x73, 0x64, 0x73, 0x66,
    0x73, 0x67, 0x73, 0x68, 0x73, 0x6c, 0x73, 0x6d, 0x73, 0x6e, 0x73, 0x70,
    0x73, 0x72, 0x73, 0x75, 0x73, 0x3a, 0x73, 0x42, 0x73, 0x43, 0x73, 0x44};
const uint8_t HuffDecoderCommon::table9_35_emit_[56] = {
    0x73, 0x45, 0x73, 0x46, 0x73, 0x47, 0x73, 0x48, 0x73, 0x49, 0x73, 0x4a,
    0x73, 0x4b, 0x73, 0x4c, 0x73, 0x4d, 0x73, 0x4e, 0x73, 0x4f, 0x73, 0x50,
    0x73, 0x51, 0x73, 0x52, 0x73, 0x53, 0x73, 0x54, 0x73, 0x55, 0x73, 0x56,
    0x73, 0x57, 0x73, 0x59, 0x73, 0x6a, 0x73, 0x6b, 0x73, 0x71, 0x73, 0x76,
    0x73, 0x77, 0x73, 0x78, 0x73, 0x79, 0x73, 0x7a};
const uint8_t HuffDecoderCommon::table9_36_emit_[16] = {
    0x74, 0x30, 0x74, 0x31, 0x74, 0x32, 0x74, 0x61,
    0x74, 0x63, 0x74, 0x65, 0x74, 0x69, 0x74, 0x6f};
const uint8_t HuffDecoderCommon::table9_37_emit_[27] = {
    0x74, 0x73, 0x74, 0x74, 0x20, 0x74, 0x25, 0x74, 0x2d,
    0x74, 0x2e, 0x74, 0x2f, 0x74, 0x33, 0x74, 0x34, 0x74,
    0x35, 0x74, 0x36, 0x74, 0x37, 0x74, 0x38, 0x74, 0x39};
const uint8_t HuffDecoderCommon::table9_37_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x0d, 0x00,
    0x15, 0x00, 0x1d, 0x00, 0x25, 0x00, 0x2d, 0x00, 0x35, 0x00, 0x3d,
    0x00, 0x45, 0x00, 0x4d, 0x00, 0x55, 0x00, 0x5d, 0x00, 0x65};
const uint8_t HuffDecoderCommon::table9_38_emit_[36] = {
    0x74, 0x3d, 0x74, 0x41, 0x74, 0x5f, 0x74, 0x62, 0x74, 0x64, 0x74, 0x66,
    0x74, 0x67, 0x74, 0x68, 0x74, 0x6c, 0x74, 0x6d, 0x74, 0x6e, 0x74, 0x70,
    0x74, 0x72, 0x74, 0x75, 0x74, 0x3a, 0x74, 0x42, 0x74, 0x43, 0x74, 0x44};
const uint8_t HuffDecoderCommon::table9_39_emit_[56] = {
    0x74, 0x45, 0x74, 0x46, 0x74, 0x47, 0x74, 0x48, 0x74, 0x49, 0x74, 0x4a,
    0x74, 0x4b, 0x74, 0x4c, 0x74, 0x4d, 0x74, 0x4e, 0x74, 0x4f, 0x74, 0x50,
    0x74, 0x51, 0x74, 0x52, 0x74, 0x53, 0x74, 0x54, 0x74, 0x55, 0x74, 0x56,
    0x74, 0x57, 0x74, 0x59, 0x74, 0x6a, 0x74, 0x6b, 0x74, 0x71, 0x74, 0x76,
    0x74, 0x77, 0x74, 0x78, 0x74, 0x79, 0x74, 0x7a};
const uint8_t HuffDecoderCommon::table9_40_emit_[43] = {
    0x20, 0x30, 0x20, 0x31, 0x20, 0x32, 0x20, 0x61, 0x20, 0x63, 0x20,
    0x65, 0x20, 0x69, 0x20, 0x6f, 0x20, 0x73, 0x20, 0x74, 0x20, 0x20,
    0x25, 0x20, 0x2d, 0x20, 0x2e, 0x20, 0x2f, 0x20, 0x33, 0x20, 0x34,
    0x20, 0x35, 0x20, 0x36, 0x20, 0x37, 0x20, 0x38, 0x20, 0x39};
const uint8_t HuffDecoderCommon::table9_40_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x55,
    0x5d, 0x65, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_41_emit_[28] = {
    0x20, 0x3d, 0x20, 0x41, 0x20, 0x5f, 0x20, 0x62, 0x20, 0x64,
    0x20, 0x66, 0x20, 0x67, 0x20, 0x68, 0x20, 0x6c, 0x20, 0x6d,
    0x20, 0x6e, 0x20, 0x70, 0x20, 0x72, 0x20, 0x75};
const uint8_t HuffDecoderCommon::table9_41_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_42_emit_[43] = {
    0x25, 0x30, 0x25, 0x31, 0x25, 0x32, 0x25, 0x61, 0x25, 0x63, 0x25,
    0x65, 0x25, 0x69, 0x25, 0x6f, 0x25, 0x73, 0x25, 0x74, 0x25, 0x20,
    0x25, 0x25, 0x2d, 0x25, 0x2e, 0x25, 0x2f, 0x25, 0x33, 0x25, 0x34,
    0x25, 0x35, 0x25, 0x36, 0x25, 0x37, 0x25, 0x38, 0x25, 0x39};
const uint8_t HuffDecoderCommon::table9_42_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x5d, 0x65, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_43_emit_[28] = {
    0x25, 0x3d, 0x25, 0x41, 0x25, 0x5f, 0x25, 0x62, 0x25, 0x64,
    0x25, 0x66, 0x25, 0x67, 0x25, 0x68, 0x25, 0x6c, 0x25, 0x6d,
    0x25, 0x6e, 0x25, 0x70, 0x25, 0x72, 0x25, 0x75};
const uint8_t HuffDecoderCommon::table9_44_emit_[43] = {
    0x2d, 0x30, 0x2d, 0x31, 0x2d, 0x32, 0x2d, 0x61, 0x2d, 0x63, 0x2d,
    0x65, 0x2d, 0x69, 0x2d, 0x6f, 0x2d, 0x73, 0x2d, 0x74, 0x2d, 0x20,
    0x2d, 0x25, 0x2d, 0x2d, 0x2e, 0x2d, 0x2f, 0x2d, 0x33, 0x2d, 0x34,
    0x2d, 0x35, 0x2d, 0x36, 0x2d, 0x37, 0x2d, 0x38, 0x2d, 0x39};
const uint8_t HuffDecoderCommon::table9_44_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x65, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_45_emit_[28] = {
    0x2d, 0x3d, 0x2d, 0x41, 0x2d, 0x5f, 0x2d, 0x62, 0x2d, 0x64,
    0x2d, 0x66, 0x2d, 0x67, 0x2d, 0x68, 0x2d, 0x6c, 0x2d, 0x6d,
    0x2d, 0x6e, 0x2d, 0x70, 0x2d, 0x72, 0x2d, 0x75};
const uint8_t HuffDecoderCommon::table9_46_emit_[43] = {
    0x2e, 0x30, 0x2e, 0x31, 0x2e, 0x32, 0x2e, 0x61, 0x2e, 0x63, 0x2e,
    0x65, 0x2e, 0x69, 0x2e, 0x6f, 0x2e, 0x73, 0x2e, 0x74, 0x2e, 0x20,
    0x2e, 0x25, 0x2e, 0x2d, 0x2e, 0x2e, 0x2f, 0x2e, 0x33, 0x2e, 0x34,
    0x2e, 0x35, 0x2e, 0x36, 0x2e, 0x37, 0x2e, 0x38, 0x2e, 0x39};
const uint8_t HuffDecoderCommon::table9_46_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_47_emit_[28] = {
    0x2e, 0x3d, 0x2e, 0x41, 0x2e, 0x5f, 0x2e, 0x62, 0x2e, 0x64,
    0x2e, 0x66, 0x2e, 0x67, 0x2e, 0x68, 0x2e, 0x6c, 0x2e, 0x6d,
    0x2e, 0x6e, 0x2e, 0x70, 0x2e, 0x72, 0x2e, 0x75};
const uint8_t HuffDecoderCommon::table9_48_emit_[43] = {
    0x2f, 0x30, 0x2f, 0x31, 0x2f, 0x32, 0x2f, 0x61, 0x2f, 0x63, 0x2f,
    0x65, 0x2f, 0x69, 0x2f, 0x6f, 0x2f, 0x73, 0x2f, 0x74, 0x2f, 0x20,
    0x2f, 0x25, 0x2f, 0x2d, 0x2f, 0x2e, 0x2f, 0x2f, 0x33, 0x2f, 0x34,
    0x2f, 0x35, 0x2f, 0x36, 0x2f, 0x37, 0x2f, 0x38, 0x2f, 0x39};
const uint8_t HuffDecoderCommon::table9_48_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_49_emit_[28] = {
    0x2f, 0x3d, 0x2f, 0x41, 0x2f, 0x5f, 0x2f, 0x62, 0x2f, 0x64,
    0x2f, 0x66, 0x2f, 0x67, 0x2f, 0x68, 0x2f, 0x6c, 0x2f, 0x6d,
    0x2f, 0x6e, 0x2f, 0x70, 0x2f, 0x72, 0x2f, 0x75};
const uint8_t HuffDecoderCommon::table9_50_emit_[43] = {
    0x33, 0x30, 0x33, 0x31, 0x33, 0x32, 0x33, 0x61, 0x33, 0x63, 0x33,
    0x65, 0x33, 0x69, 0x33, 0x6f, 0x33, 0x73, 0x33, 0x74, 0x33, 0x20,
    0x33, 0x25, 0x33, 0x2d, 0x33, 0x2e, 0x33, 0x2f, 0x33, 0x33, 0x34,
    0x33, 0x35, 0x33, 0x36, 0x33, 0x37, 0x33, 0x38, 0x33, 0x39};
const uint8_t HuffDecoderCommon::table9_50_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x7d, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_51_emit_[28] = {
    0x33, 0x3d, 0x33, 0x41, 0x33, 0x5f, 0x33, 0x62, 0x33, 0x64,
    0x33, 0x66, 0x33, 0x67, 0x33, 0x68, 0x33, 0x6c, 0x33, 0x6d,
    0x33, 0x6e, 0x33, 0x70, 0x33, 0x72, 0x33, 0x75};
const uint8_t HuffDecoderCommon::table9_52_emit_[43] = {
    0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x61, 0x34, 0x63, 0x34,
    0x65, 0x34, 0x69, 0x34, 0x6f, 0x34, 0x73, 0x34, 0x74, 0x34, 0x20,
    0x34, 0x25, 0x34, 0x2d, 0x34, 0x2e, 0x34, 0x2f, 0x34, 0x33, 0x34,
    0x34, 0x35, 0x34, 0x36, 0x34, 0x37, 0x34, 0x38, 0x34, 0x39};
const uint8_t HuffDecoderCommon::table9_52_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x85, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_53_emit_[28] = {
    0x34, 0x3d, 0x34, 0x41, 0x34, 0x5f, 0x34, 0x62, 0x34, 0x64,
    0x34, 0x66, 0x34, 0x67, 0x34, 0x68, 0x34, 0x6c, 0x34, 0x6d,
    0x34, 0x6e, 0x34, 0x70, 0x34, 0x72, 0x34, 0x75};
const uint8_t HuffDecoderCommon::table9_54_emit_[43] = {
    0x35, 0x30, 0x35, 0x31, 0x35, 0x32, 0x35, 0x61, 0x35, 0x63, 0x35,
    0x65, 0x35, 0x69, 0x35, 0x6f, 0x35, 0x73, 0x35, 0x74, 0x35, 0x20,
    0x35, 0x25, 0x35, 0x2d, 0x35, 0x2e, 0x35, 0x2f, 0x35, 0x33, 0x35,
    0x34, 0x35, 0x35, 0x36, 0x35, 0x37, 0x35, 0x38, 0x35, 0x39};
const uint8_t HuffDecoderCommon::table9_54_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x8d, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_55_emit_[28] = {
    0x35, 0x3d, 0x35, 0x41, 0x35, 0x5f, 0x35, 0x62, 0x35, 0x64,
    0x35, 0x66, 0x35, 0x67, 0x35, 0x68, 0x35, 0x6c, 0x35, 0x6d,
    0x35, 0x6e, 0x35, 0x70, 0x35, 0x72, 0x35, 0x75};
const uint8_t HuffDecoderCommon::table9_56_emit_[43] = {
    0x36, 0x30, 0x36, 0x31, 0x36, 0x32, 0x36, 0x61, 0x36, 0x63, 0x36,
    0x65, 0x36, 0x69, 0x36, 0x6f, 0x36, 0x73, 0x36, 0x74, 0x36, 0x20,
    0x36, 0x25, 0x36, 0x2d, 0x36, 0x2e, 0x36, 0x2f, 0x36, 0x33, 0x36,
    0x34, 0x36, 0x35, 0x36, 0x36, 0x37, 0x36, 0x38, 0x36, 0x39};
const uint8_t HuffDecoderCommon::table9_56_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x95, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_57_emit_[28] = {
    0x36, 0x3d, 0x36, 0x41, 0x36, 0x5f, 0x36, 0x62, 0x36, 0x64,
    0x36, 0x66, 0x36, 0x67, 0x36, 0x68, 0x36, 0x6c, 0x36, 0x6d,
    0x36, 0x6e, 0x36, 0x70, 0x36, 0x72, 0x36, 0x75};
const uint8_t HuffDecoderCommon::table9_58_emit_[43] = {
    0x37, 0x30, 0x37, 0x31, 0x37, 0x32, 0x37, 0x61, 0x37, 0x63, 0x37,
    0x65, 0x37, 0x69, 0x37, 0x6f, 0x37, 0x73, 0x37, 0x74, 0x37, 0x20,
    0x37, 0x25, 0x37, 0x2d, 0x37, 0x2e, 0x37, 0x2f, 0x37, 0x33, 0x37,
    0x34, 0x37, 0x35, 0x37, 0x36, 0x37, 0x37, 0x38, 0x37, 0x39};
const uint8_t HuffDecoderCommon::table9_58_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0x9d, 0xa5};
const uint8_t HuffDecoderCommon::table9_59_emit_[28] = {
    0x37, 0x3d, 0x37, 0x41, 0x37, 0x5f, 0x37, 0x62, 0x37, 0x64,
    0x37, 0x66, 0x37, 0x67, 0x37, 0x68, 0x37, 0x6c, 0x37, 0x6d,
    0x37, 0x6e, 0x37, 0x70, 0x37, 0x72, 0x37, 0x75};
const uint8_t HuffDecoderCommon::table9_60_emit_[43] = {
    0x38, 0x30, 0x38, 0x31, 0x38, 0x32, 0x38, 0x61, 0x38, 0x63, 0x38,
    0x65, 0x38, 0x69, 0x38, 0x6f, 0x38, 0x73, 0x38, 0x74, 0x38, 0x20,
    0x38, 0x25, 0x38, 0x2d, 0x38, 0x2e, 0x38, 0x2f, 0x38, 0x33, 0x38,
    0x34, 0x38, 0x35, 0x38, 0x36, 0x38, 0x37, 0x38, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table9_60_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa5};
const uint8_t HuffDecoderCommon::table9_61_emit_[28] = {
    0x38, 0x3d, 0x38, 0x41, 0x38, 0x5f, 0x38, 0x62, 0x38, 0x64,
    0x38, 0x66, 0x38, 0x67, 0x38, 0x68, 0x38, 0x6c, 0x38, 0x6d,
    0x38, 0x6e, 0x38, 0x70, 0x38, 0x72, 0x38, 0x75};
const uint8_t HuffDecoderCommon::table9_62_emit_[44] = {
    0x39, 0x30, 0x39, 0x31, 0x39, 0x32, 0x39, 0x61, 0x39, 0x63, 0x39,
    0x65, 0x39, 0x69, 0x39, 0x6f, 0x39, 0x73, 0x39, 0x74, 0x39, 0x20,
    0x39, 0x25, 0x39, 0x2d, 0x39, 0x2e, 0x39, 0x2f, 0x39, 0x33, 0x39,
    0x34, 0x39, 0x35, 0x39, 0x36, 0x39, 0x37, 0x39, 0x38, 0x39, 0x39};
const uint8_t HuffDecoderCommon::table9_62_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9};
const uint8_t HuffDecoderCommon::table9_63_emit_[28] = {
    0x39, 0x3d, 0x39, 0x41, 0x39, 0x5f, 0x39, 0x62, 0x39, 0x64,
    0x39, 0x66, 0x39, 0x67, 0x39, 0x68, 0x39, 0x6c, 0x39, 0x6d,
    0x39, 0x6e, 0x39, 0x70, 0x39, 0x72, 0x39, 0x75};
const uint8_t HuffDecoderCommon::table9_64_emit_[44] = {
    0x3d, 0x30, 0x3d, 0x31, 0x3d, 0x32, 0x3d, 0x61, 0x3d, 0x63, 0x3d,
    0x65, 0x3d, 0x69, 0x3d, 0x6f, 0x3d, 0x73, 0x3d, 0x74, 0x3d, 0x20,
    0x3d, 0x25, 0x3d, 0x2d, 0x3d, 0x2e, 0x3d, 0x2f, 0x3d, 0x33, 0x3d,
    0x34, 0x3d, 0x35, 0x3d, 0x36, 0x3d, 0x37, 0x3d, 0x38, 0x3d, 0x39};
const uint8_t HuffDecoderCommon::table9_65_emit_[27] = {
    0x3d, 0x3d, 0x41, 0x3d, 0x5f, 0x3d, 0x62, 0x3d, 0x64,
    0x3d, 0x66, 0x3d, 0x67, 0x3d, 0x68, 0x3d, 0x6c, 0x3d,
    0x6d, 0x3d, 0x6e, 0x3d, 0x70, 0x3d, 0x72, 0x3d, 0x75};
const uint8_t HuffDecoderCommon::table9_65_ops_[32] = {
    0x01, 0x05, 0x0d, 0x15, 0x1d, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_66_emit_[44] = {
    0x41, 0x30, 0x41, 0x31, 0x41, 0x32, 0x41, 0x61, 0x41, 0x63, 0x41,
    0x65, 0x41, 0x69, 0x41, 0x6f, 0x41, 0x73, 0x41, 0x74, 0x41, 0x20,
    0x41, 0x25, 0x41, 0x2d, 0x41, 0x2e, 0x41, 0x2f, 0x41, 0x33, 0x41,
    0x34, 0x41, 0x35, 0x41, 0x36, 0x41, 0x37, 0x41, 0x38, 0x41, 0x39};
const uint8_t HuffDecoderCommon::table9_67_emit_[27] = {
    0x41, 0x3d, 0x41, 0x41, 0x5f, 0x41, 0x62, 0x41, 0x64,
    0x41, 0x66, 0x41, 0x67, 0x41, 0x68, 0x41, 0x6c, 0x41,
    0x6d, 0x41, 0x6e, 0x41, 0x70, 0x41, 0x72, 0x41, 0x75};
const uint8_t HuffDecoderCommon::table9_67_ops_[32] = {
    0x01, 0x09, 0x0d, 0x15, 0x1d, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_68_emit_[44] = {
    0x5f, 0x30, 0x5f, 0x31, 0x5f, 0x32, 0x5f, 0x61, 0x5f, 0x63, 0x5f,
    0x65, 0x5f, 0x69, 0x5f, 0x6f, 0x5f, 0x73, 0x5f, 0x74, 0x5f, 0x20,
    0x5f, 0x25, 0x5f, 0x2d, 0x5f, 0x2e, 0x5f, 0x2f, 0x5f, 0x33, 0x5f,
    0x34, 0x5f, 0x35, 0x5f, 0x36, 0x5f, 0x37, 0x5f, 0x38, 0x5f, 0x39};
const uint8_t HuffDecoderCommon::table9_69_emit_[27] = {
    0x5f, 0x3d, 0x5f, 0x41, 0x5f, 0x5f, 0x62, 0x5f, 0x64,
    0x5f, 0x66, 0x5f, 0x67, 0x5f, 0x68, 0x5f, 0x6c, 0x5f,
    0x6d, 0x5f, 0x6e, 0x5f, 0x70, 0x5f, 0x72, 0x5f, 0x75};
const uint8_t HuffDecoderCommon::table9_69_ops_[32] = {
    0x01, 0x09, 0x11, 0x15, 0x1d, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_70_emit_[44] = {
    0x62, 0x30, 0x62, 0x31, 0x62, 0x32, 0x62, 0x61, 0x62, 0x63, 0x62,
    0x65, 0x62, 0x69, 0x62, 0x6f, 0x62, 0x73, 0x62, 0x74, 0x62, 0x20,
    0x62, 0x25, 0x62, 0x2d, 0x62, 0x2e, 0x62, 0x2f, 0x62, 0x33, 0x62,
    0x34, 0x62, 0x35, 0x62, 0x36, 0x62, 0x37, 0x62, 0x38, 0x62, 0x39};
const uint8_t HuffDecoderCommon::table9_71_emit_[27] = {
    0x62, 0x3d, 0x62, 0x41, 0x62, 0x5f, 0x62, 0x62, 0x64,
    0x62, 0x66, 0x62, 0x67, 0x62, 0x68, 0x62, 0x6c, 0x62,
    0x6d, 0x62, 0x6e, 0x62, 0x70, 0x62, 0x72, 0x62, 0x75};
const uint8_t HuffDecoderCommon::table9_71_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x1d, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_72_emit_[44] = {
    0x64, 0x30, 0x64, 0x31, 0x64, 0x32, 0x64, 0x61, 0x64, 0x63, 0x64,
    0x65, 0x64, 0x69, 0x64, 0x6f, 0x64, 0x73, 0x64, 0x74, 0x64, 0x20,
    0x64, 0x25, 0x64, 0x2d, 0x64, 0x2e, 0x64, 0x2f, 0x64, 0x33, 0x64,
    0x34, 0x64, 0x35, 0x64, 0x36, 0x64, 0x37, 0x64, 0x38, 0x64, 0x39};
const uint8_t HuffDecoderCommon::table9_73_emit_[27] = {
    0x64, 0x3d, 0x64, 0x41, 0x64, 0x5f, 0x64, 0x62, 0x64,
    0x64, 0x66, 0x64, 0x67, 0x64, 0x68, 0x64, 0x6c, 0x64,
    0x6d, 0x64, 0x6e, 0x64, 0x70, 0x64, 0x72, 0x64, 0x75};
const uint8_t HuffDecoderCommon::table9_73_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x25, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_74_emit_[44] = {
    0x66, 0x30, 0x66, 0x31, 0x66, 0x32, 0x66, 0x61, 0x66, 0x63, 0x66,
    0x65, 0x66, 0x69, 0x66, 0x6f, 0x66, 0x73, 0x66, 0x74, 0x66, 0x20,
    0x66, 0x25, 0x66, 0x2d, 0x66, 0x2e, 0x66, 0x2f, 0x66, 0x33, 0x66,
    0x34, 0x66, 0x35, 0x66, 0x36, 0x66, 0x37, 0x66, 0x38, 0x66, 0x39};
const uint8_t HuffDecoderCommon::table9_75_emit_[27] = {
    0x66, 0x3d, 0x66, 0x41, 0x66, 0x5f, 0x66, 0x62, 0x66,
    0x64, 0x66, 0x66, 0x67, 0x66, 0x68, 0x66, 0x6c, 0x66,
    0x6d, 0x66, 0x6e, 0x66, 0x70, 0x66, 0x72, 0x66, 0x75};
const uint8_t HuffDecoderCommon::table9_75_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x2d, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_76_emit_[44] = {
    0x67, 0x30, 0x67, 0x31, 0x67, 0x32, 0x67, 0x61, 0x67, 0x63, 0x67,
    0x65, 0x67, 0x69, 0x67, 0x6f, 0x67, 0x73, 0x67, 0x74, 0x67, 0x20,
    0x67, 0x25, 0x67, 0x2d, 0x67, 0x2e, 0x67, 0x2f, 0x67, 0x33, 0x67,
    0x34, 0x67, 0x35, 0x67, 0x36, 0x67, 0x37, 0x67, 0x38, 0x67, 0x39};
const uint8_t HuffDecoderCommon::table9_77_emit_[27] = {
    0x67, 0x3d, 0x67, 0x41, 0x67, 0x5f, 0x67, 0x62, 0x67,
    0x64, 0x67, 0x66, 0x67, 0x67, 0x68, 0x67, 0x6c, 0x67,
    0x6d, 0x67, 0x6e, 0x67, 0x70, 0x67, 0x72, 0x67, 0x75};
const uint8_t HuffDecoderCommon::table9_77_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x35, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_78_emit_[44] = {
    0x68, 0x30, 0x68, 0x31, 0x68, 0x32, 0x68, 0x61, 0x68, 0x63, 0x68,
    0x65, 0x68, 0x69, 0x68, 0x6f, 0x68, 0x73, 0x68, 0x74, 0x68, 0x20,
    0x68, 0x25, 0x68, 0x2d, 0x68, 0x2e, 0x68, 0x2f, 0x68, 0x33, 0x68,
    0x34, 0x68, 0x35, 0x68, 0x36, 0x68, 0x37, 0x68, 0x38, 0x68, 0x39};
const uint8_t HuffDecoderCommon::table9_79_emit_[27] = {
    0x68, 0x3d, 0x68, 0x41, 0x68, 0x5f, 0x68, 0x62, 0x68,
    0x64, 0x68, 0x66, 0x68, 0x67, 0x68, 0x68, 0x6c, 0x68,
    0x6d, 0x68, 0x6e, 0x68, 0x70, 0x68, 0x72, 0x68, 0x75};
const uint8_t HuffDecoderCommon::table9_79_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x3d, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_80_emit_[44] = {
    0x6c, 0x30, 0x6c, 0x31, 0x6c, 0x32, 0x6c, 0x61, 0x6c, 0x63, 0x6c,
    0x65, 0x6c, 0x69, 0x6c, 0x6f, 0x6c, 0x73, 0x6c, 0x74, 0x6c, 0x20,
    0x6c, 0x25, 0x6c, 0x2d, 0x6c, 0x2e, 0x6c, 0x2f, 0x6c, 0x33, 0x6c,
    0x34, 0x6c, 0x35, 0x6c, 0x36, 0x6c, 0x37, 0x6c, 0x38, 0x6c, 0x39};
const uint8_t HuffDecoderCommon::table9_81_emit_[27] = {
    0x6c, 0x3d, 0x6c, 0x41, 0x6c, 0x5f, 0x6c, 0x62, 0x6c,
    0x64, 0x6c, 0x66, 0x6c, 0x67, 0x6c, 0x68, 0x6c, 0x6c,
    0x6d, 0x6c, 0x6e, 0x6c, 0x70, 0x6c, 0x72, 0x6c, 0x75};
const uint8_t HuffDecoderCommon::table9_81_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x45, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_82_emit_[44] = {
    0x6d, 0x30, 0x6d, 0x31, 0x6d, 0x32, 0x6d, 0x61, 0x6d, 0x63, 0x6d,
    0x65, 0x6d, 0x69, 0x6d, 0x6f, 0x6d, 0x73, 0x6d, 0x74, 0x6d, 0x20,
    0x6d, 0x25, 0x6d, 0x2d, 0x6d, 0x2e, 0x6d, 0x2f, 0x6d, 0x33, 0x6d,
    0x34, 0x6d, 0x35, 0x6d, 0x36, 0x6d, 0x37, 0x6d, 0x38, 0x6d, 0x39};
const uint8_t HuffDecoderCommon::table9_83_emit_[27] = {
    0x6d, 0x3d, 0x6d, 0x41, 0x6d, 0x5f, 0x6d, 0x62, 0x6d,
    0x64, 0x6d, 0x66, 0x6d, 0x67, 0x6d, 0x68, 0x6d, 0x6c,
    0x6d, 0x6d, 0x6e, 0x6d, 0x70, 0x6d, 0x72, 0x6d, 0x75};
const uint8_t HuffDecoderCommon::table9_83_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x4d,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_84_emit_[44] = {
    0x6e, 0x30, 0x6e, 0x31, 0x6e, 0x32, 0x6e, 0x61, 0x6e, 0x63, 0x6e,
    0x65, 0x6e, 0x69, 0x6e, 0x6f, 0x6e, 0x73, 0x6e, 0x74, 0x6e, 0x20,
    0x6e, 0x25, 0x6e, 0x2d, 0x6e, 0x2e, 0x6e, 0x2f, 0x6e, 0x33, 0x6e,
    0x34, 0x6e, 0x35, 0x6e, 0x36, 0x6e, 0x37, 0x6e, 0x38, 0x6e, 0x39};
const uint8_t HuffDecoderCommon::table9_85_emit_[27] = {
    0x6e, 0x3d, 0x6e, 0x41, 0x6e, 0x5f, 0x6e, 0x62, 0x6e,
    0x64, 0x6e, 0x66, 0x6e, 0x67, 0x6e, 0x68, 0x6e, 0x6c,
    0x6e, 0x6d, 0x6e, 0x6e, 0x70, 0x6e, 0x72, 0x6e, 0x75};
const uint8_t HuffDecoderCommon::table9_85_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x55, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_86_emit_[44] = {
    0x70, 0x30, 0x70, 0x31, 0x70, 0x32, 0x70, 0x61, 0x70, 0x63, 0x70,
    0x65, 0x70, 0x69, 0x70, 0x6f, 0x70, 0x73, 0x70, 0x74, 0x70, 0x20,
    0x70, 0x25, 0x70, 0x2d, 0x70, 0x2e, 0x70, 0x2f, 0x70, 0x33, 0x70,
    0x34, 0x70, 0x35, 0x70, 0x36, 0x70, 0x37, 0x70, 0x38, 0x70, 0x39};
const uint8_t HuffDecoderCommon::table9_87_emit_[27] = {
    0x70, 0x3d, 0x70, 0x41, 0x70, 0x5f, 0x70, 0x62, 0x70,
    0x64, 0x70, 0x66, 0x70, 0x67, 0x70, 0x68, 0x70, 0x6c,
    0x70, 0x6d, 0x70, 0x6e, 0x70, 0x70, 0x72, 0x70, 0x75};
const uint8_t HuffDecoderCommon::table9_87_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x5d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_88_emit_[44] = {
    0x72, 0x30, 0x72, 0x31, 0x72, 0x32, 0x72, 0x61, 0x72, 0x63, 0x72,
    0x65, 0x72, 0x69, 0x72, 0x6f, 0x72, 0x73, 0x72, 0x74, 0x72, 0x20,
    0x72, 0x25, 0x72, 0x2d, 0x72, 0x2e, 0x72, 0x2f, 0x72, 0x33, 0x72,
    0x34, 0x72, 0x35, 0x72, 0x36, 0x72, 0x37, 0x72, 0x38, 0x72, 0x39};
const uint8_t HuffDecoderCommon::table9_89_emit_[27] = {
    0x72, 0x3d, 0x72, 0x41, 0x72, 0x5f, 0x72, 0x62, 0x72,
    0x64, 0x72, 0x66, 0x72, 0x67, 0x72, 0x68, 0x72, 0x6c,
    0x72, 0x6d, 0x72, 0x6e, 0x72, 0x70, 0x72, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table9_89_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_90_emit_[44] = {
    0x75, 0x30, 0x75, 0x31, 0x75, 0x32, 0x75, 0x61, 0x75, 0x63, 0x75,
    0x65, 0x75, 0x69, 0x75, 0x6f, 0x75, 0x73, 0x75, 0x74, 0x75, 0x20,
    0x75, 0x25, 0x75, 0x2d, 0x75, 0x2e, 0x75, 0x2f, 0x75, 0x33, 0x75,
    0x34, 0x75, 0x35, 0x75, 0x36, 0x75, 0x37, 0x75, 0x38, 0x75, 0x39};
const uint8_t HuffDecoderCommon::table9_91_emit_[28] = {
    0x75, 0x3d, 0x75, 0x41, 0x75, 0x5f, 0x75, 0x62, 0x75, 0x64,
    0x75, 0x66, 0x75, 0x67, 0x75, 0x68, 0x75, 0x6c, 0x75, 0x6d,
    0x75, 0x6e, 0x75, 0x70, 0x75, 0x72, 0x75, 0x75};
const uint8_t HuffDecoderCommon::table9_92_emit_[20] = {
    0x3a, 0x30, 0x3a, 0x31, 0x3a, 0x32, 0x3a, 0x61, 0x3a, 0x63,
    0x3a, 0x65, 0x3a, 0x69, 0x3a, 0x6f, 0x3a, 0x73, 0x3a, 0x74};
const uint8_t HuffDecoderCommon::table9_92_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table9_93_emit_[20] = {
    0x42, 0x30, 0x42, 0x31, 0x42, 0x32, 0x42, 0x61, 0x42, 0x63,
    0x42, 0x65, 0x42, 0x69, 0x42, 0x6f, 0x42, 0x73, 0x42, 0x74};
const uint8_t HuffDecoderCommon::table9_94_emit_[20] = {
    0x43, 0x30, 0x43, 0x31, 0x43, 0x32, 0x43, 0x61, 0x43, 0x63,
    0x43, 0x65, 0x43, 0x69, 0x43, 0x6f, 0x43, 0x73, 0x43, 0x74};
const uint8_t HuffDecoderCommon::table9_95_emit_[20] = {
    0x44, 0x30, 0x44, 0x31, 0x44, 0x32, 0x44, 0x61, 0x44, 0x63,
    0x44, 0x65, 0x44, 0x69, 0x44, 0x6f, 0x44, 0x73, 0x44, 0x74};
const uint8_t HuffDecoderCommon::table9_96_emit_[20] = {
    0x45, 0x30, 0x45, 0x31, 0x45, 0x32, 0x45, 0x61, 0x45, 0x63,
    0x45, 0x65, 0x45, 0x69, 0x45, 0x6f, 0x45, 0x73, 0x45, 0x74};
const uint8_t HuffDecoderCommon::table9_97_emit_[20] = {
    0x46, 0x30, 0x46, 0x31, 0x46, 0x32, 0x46, 0x61, 0x46, 0x63,
    0x46, 0x65, 0x46, 0x69, 0x46, 0x6f, 0x46, 0x73, 0x46, 0x74};
const uint8_t HuffDecoderCommon::table9_98_emit_[20] = {
    0x47, 0x30, 0x47, 0x31, 0x47, 0x32, 0x47, 0x61, 0x47, 0x63,
    0x47, 0x65, 0x47, 0x69, 0x47, 0x6f, 0x47, 0x73, 0x47, 0x74};
const uint8_t HuffDecoderCommon::table9_99_emit_[20] = {
    0x48, 0x30, 0x48, 0x31, 0x48, 0x32, 0x48, 0x61, 0x48, 0x63,
    0x48, 0x65, 0x48, 0x69, 0x48, 0x6f, 0x48, 0x73, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table9_100_emit_[20] = {
    0x49, 0x30, 0x49, 0x31, 0x49, 0x32, 0x49, 0x61, 0x49, 0x63,
    0x49, 0x65, 0x49, 0x69, 0x49, 0x6f, 0x49, 0x73, 0x49, 0x74};
const uint8_t HuffDecoderCommon::table9_101_emit_[20] = {
    0x4a, 0x30, 0x4a, 0x31, 0x4a, 0x32, 0x4a, 0x61, 0x4a, 0x63,
    0x4a, 0x65, 0x4a, 0x69, 0x4a, 0x6f, 0x4a, 0x73, 0x4a, 0x74};
const uint8_t HuffDecoderCommon::table9_102_emit_[20] = {
    0x4b, 0x30, 0x4b, 0x31, 0x4b, 0x32, 0x4b, 0x61, 0x4b, 0x63,
    0x4b, 0x65, 0x4b, 0x69, 0x4b, 0x6f, 0x4b, 0x73, 0x4b, 0x74};
const uint8_t HuffDecoderCommon::table9_103_emit_[20] = {
    0x4c, 0x30, 0x4c, 0x31, 0x4c, 0x32, 0x4c, 0x61, 0x4c, 0x63,
    0x4c, 0x65, 0x4c, 0x69, 0x4c, 0x6f, 0x4c, 0x73, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table9_104_emit_[20] = {
    0x4d, 0x30, 0x4d, 0x31, 0x4d, 0x32, 0x4d, 0x61, 0x4d, 0x63,
    0x4d, 0x65, 0x4d, 0x69, 0x4d, 0x6f, 0x4d, 0x73, 0x4d, 0x74};
const uint8_t HuffDecoderCommon::table9_105_emit_[20] = {
    0x4e, 0x30, 0x4e, 0x31, 0x4e, 0x32, 0x4e, 0x61, 0x4e, 0x63,
    0x4e, 0x65, 0x4e, 0x69, 0x4e, 0x6f, 0x4e, 0x73, 0x4e, 0x74};
const uint8_t HuffDecoderCommon::table9_106_emit_[20] = {
    0x4f, 0x30, 0x4f, 0x31, 0x4f, 0x32, 0x4f, 0x61, 0x4f, 0x63,
    0x4f, 0x65, 0x4f, 0x69, 0x4f, 0x6f, 0x4f, 0x73, 0x4f, 0x74};
const uint8_t HuffDecoderCommon::table9_107_emit_[20] = {
    0x50, 0x30, 0x50, 0x31, 0x50, 0x32, 0x50, 0x61, 0x50, 0x63,
    0x50, 0x65, 0x50, 0x69, 0x50, 0x6f, 0x50, 0x73, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table9_108_emit_[20] = {
    0x51, 0x30, 0x51, 0x31, 0x51, 0x32, 0x51, 0x61, 0x51, 0x63,
    0x51, 0x65, 0x51, 0x69, 0x51, 0x6f, 0x51, 0x73, 0x51, 0x74};
const uint8_t HuffDecoderCommon::table9_109_emit_[20] = {
    0x52, 0x30, 0x52, 0x31, 0x52, 0x32, 0x52, 0x61, 0x52, 0x63,
    0x52, 0x65, 0x52, 0x69, 0x52, 0x6f, 0x52, 0x73, 0x52, 0x74};
const uint8_t HuffDecoderCommon::table9_110_emit_[20] = {
    0x53, 0x30, 0x53, 0x31, 0x53, 0x32, 0x53, 0x61, 0x53, 0x63,
    0x53, 0x65, 0x53, 0x69, 0x53, 0x6f, 0x53, 0x73, 0x53, 0x74};
const uint8_t HuffDecoderCommon::table9_111_emit_[20] = {
    0x54, 0x30, 0x54, 0x31, 0x54, 0x32, 0x54, 0x61, 0x54, 0x63,
    0x54, 0x65, 0x54, 0x69, 0x54, 0x6f, 0x54, 0x73, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table9_112_emit_[20] = {
    0x55, 0x30, 0x55, 0x31, 0x55, 0x32, 0x55, 0x61, 0x55, 0x63,
    0x55, 0x65, 0x55, 0x69, 0x55, 0x6f, 0x55, 0x73, 0x55, 0x74};
const uint8_t HuffDecoderCommon::table9_113_emit_[20] = {
    0x56, 0x30, 0x56, 0x31, 0x56, 0x32, 0x56, 0x61, 0x56, 0x63,
    0x56, 0x65, 0x56, 0x69, 0x56, 0x6f, 0x56, 0x73, 0x56, 0x74};
const uint8_t HuffDecoderCommon::table9_114_emit_[20] = {
    0x57, 0x30, 0x57, 0x31, 0x57, 0x32, 0x57, 0x61, 0x57, 0x63,
    0x57, 0x65, 0x57, 0x69, 0x57, 0x6f, 0x57, 0x73, 0x57, 0x74};
const uint8_t HuffDecoderCommon::table9_115_emit_[20] = {
    0x59, 0x30, 0x59, 0x31, 0x59, 0x32, 0x59, 0x61, 0x59, 0x63,
    0x59, 0x65, 0x59, 0x69, 0x59, 0x6f, 0x59, 0x73, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table9_116_emit_[20] = {
    0x6a, 0x30, 0x6a, 0x31, 0x6a, 0x32, 0x6a, 0x61, 0x6a, 0x63,
    0x6a, 0x65, 0x6a, 0x69, 0x6a, 0x6f, 0x6a, 0x73, 0x6a, 0x74};
const uint8_t HuffDecoderCommon::table9_117_emit_[20] = {
    0x6b, 0x30, 0x6b, 0x31, 0x6b, 0x32, 0x6b, 0x61, 0x6b, 0x63,
    0x6b, 0x65, 0x6b, 0x69, 0x6b, 0x6f, 0x6b, 0x73, 0x6b, 0x74};
const uint8_t HuffDecoderCommon::table9_118_emit_[20] = {
    0x71, 0x30, 0x71, 0x31, 0x71, 0x32, 0x71, 0x61, 0x71, 0x63,
    0x71, 0x65, 0x71, 0x69, 0x71, 0x6f, 0x71, 0x73, 0x71, 0x74};
const uint8_t HuffDecoderCommon::table9_119_emit_[20] = {
    0x76, 0x30, 0x76, 0x31, 0x76, 0x32, 0x76, 0x61, 0x76, 0x63,
    0x76, 0x65, 0x76, 0x69, 0x76, 0x6f, 0x76, 0x73, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table9_120_emit_[20] = {
    0x77, 0x30, 0x77, 0x31, 0x77, 0x32, 0x77, 0x61, 0x77, 0x63,
    0x77, 0x65, 0x77, 0x69, 0x77, 0x6f, 0x77, 0x73, 0x77, 0x74};
const uint8_t HuffDecoderCommon::table9_121_emit_[20] = {
    0x78, 0x30, 0x78, 0x31, 0x78, 0x32, 0x78, 0x61, 0x78, 0x63,
    0x78, 0x65, 0x78, 0x69, 0x78, 0x6f, 0x78, 0x73, 0x78, 0x74};
const uint8_t HuffDecoderCommon::table9_122_emit_[20] = {
    0x79, 0x30, 0x79, 0x31, 0x79, 0x32, 0x79, 0x61, 0x79, 0x63,
    0x79, 0x65, 0x79, 0x69, 0x79, 0x6f, 0x79, 0x73, 0x79, 0x74};
const uint8_t HuffDecoderCommon::table9_123_emit_[20] = {
    0x7a, 0x30, 0x7a, 0x31, 0x7a, 0x32, 0x7a, 0x61, 0x7a, 0x63,
    0x7a, 0x65, 0x7a, 0x69, 0x7a, 0x6f, 0x7a, 0x73, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table9_124_emit_[2] = {0x26, 0x2a};
const uint8_t HuffDecoderCommon::table9_124_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06};
const uint8_t HuffDecoderCommon::table9_125_emit_[2] = {0x2c, 0x3b};
const uint8_t HuffDecoderCommon::table9_126_emit_[2] = {0x58, 0x5a};
const uint8_t HuffDecoderCommon::table9_127_emit_[10] = {
    0x21, 0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e};
const uint8_t HuffDecoderCommon::table9_127_ops_[32] = {
    0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    0x0a, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x16,
    0x00, 0x1a, 0x00, 0x1e, 0x22, 0x26, 0x00, 0x00, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table9_emit_[128] = {
    table9_0_emit_,   table9_1_emit_,   table9_2_emit_,   table9_3_emit_,
    table9_4_emit_,   table9_5_emit_,   table9_6_emit_,   table9_7_emit_,
    table9_8_emit_,   table9_9_emit_,   table9_10_emit_,  table9_11_emit_,
    table9_12_emit_,  table9_13_emit_,  table9_14_emit_,  table9_15_emit_,
    table9_16_emit_,  table9_17_emit_,  table9_18_emit_,  table9_19_emit_,
    table9_20_emit_,  table9_21_emit_,  table9_22_emit_,  table9_23_emit_,
    table9_24_emit_,  table9_25_emit_,  table9_26_emit_,  table9_27_emit_,
    table9_28_emit_,  table9_29_emit_,  table9_30_emit_,  table9_31_emit_,
    table9_32_emit_,  table9_33_emit_,  table9_34_emit_,  table9_35_emit_,
    table9_36_emit_,  table9_37_emit_,  table9_38_emit_,  table9_39_emit_,
    table9_40_emit_,  table9_41_emit_,  table9_42_emit_,  table9_43_emit_,
    table9_44_emit_,  table9_45_emit_,  table9_46_emit_,  table9_47_emit_,
    table9_48_emit_,  table9_49_emit_,  table9_50_emit_,  table9_51_emit_,
    table9_52_emit_,  table9_53_emit_,  table9_54_emit_,  table9_55_emit_,
    table9_56_emit_,  table9_57_emit_,  table9_58_emit_,  table9_59_emit_,
    table9_60_emit_,  table9_61_emit_,  table9_62_emit_,  table9_63_emit_,
    table9_64_emit_,  table9_65_emit_,  table9_66_emit_,  table9_67_emit_,
    table9_68_emit_,  table9_69_emit_,  table9_70_emit_,  table9_71_emit_,
    table9_72_emit_,  table9_73_emit_,  table9_74_emit_,  table9_75_emit_,
    table9_76_emit_,  table9_77_emit_,  table9_78_emit_,  table9_79_emit_,
    table9_80_emit_,  table9_81_emit_,  table9_82_emit_,  table9_83_emit_,
    table9_84_emit_,  table9_85_emit_,  table9_86_emit_,  table9_87_emit_,
    table9_88_emit_,  table9_89_emit_,  table9_90_emit_,  table9_91_emit_,
    table9_92_emit_,  table9_93_emit_,  table9_94_emit_,  table9_95_emit_,
    table9_96_emit_,  table9_97_emit_,  table9_98_emit_,  table9_99_emit_,
    table9_100_emit_, table9_101_emit_, table9_102_emit_, table9_103_emit_,
    table9_104_emit_, table9_105_emit_, table9_106_emit_, table9_107_emit_,
    table9_108_emit_, table9_109_emit_, table9_110_emit_, table9_111_emit_,
    table9_112_emit_, table9_113_emit_, table9_114_emit_, table9_115_emit_,
    table9_116_emit_, table9_117_emit_, table9_118_emit_, table9_119_emit_,
    table9_120_emit_, table9_121_emit_, table9_122_emit_, table9_123_emit_,
    table9_124_emit_, table9_125_emit_, table9_126_emit_, table9_127_emit_,
};
const uint8_t* const HuffDecoderCommon::table9_ops_[128] = {
    table9_0_ops_,   table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_4_ops_,   table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_8_ops_,   table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_12_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_16_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_20_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_24_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_28_ops_,  table9_1_ops_,   table9_2_ops_,   table9_3_ops_,
    table9_28_ops_,  table9_33_ops_,  table9_2_ops_,   table9_3_ops_,
    table9_28_ops_,  table9_37_ops_,  table9_2_ops_,   table9_3_ops_,
    table9_40_ops_,  table9_41_ops_,  table9_42_ops_,  table9_41_ops_,
    table9_44_ops_,  table9_41_ops_,  table9_46_ops_,  table9_41_ops_,
    table9_48_ops_,  table9_41_ops_,  table9_50_ops_,  table9_41_ops_,
    table9_52_ops_,  table9_41_ops_,  table9_54_ops_,  table9_41_ops_,
    table9_56_ops_,  table9_41_ops_,  table9_58_ops_,  table9_41_ops_,
    table9_60_ops_,  table9_41_ops_,  table9_62_ops_,  table9_41_ops_,
    table9_62_ops_,  table9_65_ops_,  table9_62_ops_,  table9_67_ops_,
    table9_62_ops_,  table9_69_ops_,  table9_62_ops_,  table9_71_ops_,
    table9_62_ops_,  table9_73_ops_,  table9_62_ops_,  table9_75_ops_,
    table9_62_ops_,  table9_77_ops_,  table9_62_ops_,  table9_79_ops_,
    table9_62_ops_,  table9_81_ops_,  table9_62_ops_,  table9_83_ops_,
    table9_62_ops_,  table9_85_ops_,  table9_62_ops_,  table9_87_ops_,
    table9_62_ops_,  table9_89_ops_,  table9_62_ops_,  table9_41_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_92_ops_,  table9_92_ops_,  table9_92_ops_,  table9_92_ops_,
    table9_124_ops_, table9_124_ops_, table9_124_ops_, table9_127_ops_,
};
const uint16_t HuffDecoderCommon::table10_0_inner_[9] = {
    0x0000, 0x0001, 0x0005, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d, 0x0035};
const uint8_t HuffDecoderCommon::table10_0_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0,
    0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 8};
const uint16_t HuffDecoderCommon::table10_1_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069};
const uint8_t HuffDecoderCommon::table10_1_outer_[64] = {
    0, 0, 0, 0,  0, 0, 0, 1,  0, 0, 0, 0,  0, 0, 0, 2,  0, 0, 0, 3, 0, 0,
    0, 4, 0, 0,  0, 5, 0, 0,  0, 6, 0, 0,  0, 7, 0, 0,  0, 8, 0, 0, 0, 9,
    0, 0, 0, 10, 0, 0, 0, 11, 0, 0, 0, 12, 0, 0, 0, 13, 0, 0, 0, 14};
const uint16_t HuffDecoderCommon::table10_2_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061,
    0x0069, 0x0071, 0x0079, 0x0081, 0x0089};
const uint8_t HuffDecoderCommon::table10_2_outer_[64] = {
    0, 0, 0, 1,  0, 0, 0, 2,  0, 0, 0, 3,  0, 0,  0, 4,  0, 0,  0, 5, 0, 0,
    0, 6, 0, 0,  0, 7, 0, 0,  0, 8, 0, 0,  0, 9,  0, 0,  0, 10, 0, 0, 0, 11,
    0, 0, 0, 12, 0, 0, 0, 13, 0, 0, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18};
const uint8_t HuffDecoderCommon::table10_3_emit_[68] = {
    0x30, 0x45, 0x30, 0x46, 0x30, 0x47, 0x30, 0x48, 0x30, 0x49, 0x30, 0x4a,
    0x30, 0x4b, 0x30, 0x4c, 0x30, 0x4d, 0x30, 0x4e, 0x30, 0x4f, 0x30, 0x50,
    0x30, 0x51, 0x30, 0x52, 0x30, 0x53, 0x30, 0x54, 0x30, 0x55, 0x30, 0x56,
    0x30, 0x57, 0x30, 0x59, 0x30, 0x6a, 0x30, 0x6b, 0x30, 0x71, 0x30, 0x76,
    0x30, 0x77, 0x30, 0x78, 0x30, 0x79, 0x30, 0x7a, 0x30, 0x26, 0x30, 0x2a,
    0x30, 0x2c, 0x30, 0x3b, 0x30, 0x58, 0x30, 0x5a};
const uint16_t HuffDecoderCommon::table10_3_inner_[36] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081,
    0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0002};
const uint8_t HuffDecoderCommon::table10_3_outer_[64] = {
    0, 1,  0, 2,  0, 3,  0, 4,  0,  5,  0,  6,  0,  7,  0, 8,
    0, 9,  0, 10, 0, 11, 0, 12, 0,  13, 0,  14, 0,  15, 0, 16,
    0, 17, 0, 18, 0, 19, 0, 20, 0,  21, 0,  22, 0,  23, 0, 24,
    0, 25, 0, 26, 0, 27, 0, 28, 29, 30, 31, 32, 33, 34, 0, 35};
const uint16_t HuffDecoderCommon::table10_4_inner_[9] = {
    0x0000, 0x0001, 0x0009, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d, 0x0035};
const uint8_t HuffDecoderCommon::table10_7_emit_[68] = {
    0x31, 0x45, 0x31, 0x46, 0x31, 0x47, 0x31, 0x48, 0x31, 0x49, 0x31, 0x4a,
    0x31, 0x4b, 0x31, 0x4c, 0x31, 0x4d, 0x31, 0x4e, 0x31, 0x4f, 0x31, 0x50,
    0x31, 0x51, 0x31, 0x52, 0x31, 0x53, 0x31, 0x54, 0x31, 0x55, 0x31, 0x56,
    0x31, 0x57, 0x31, 0x59, 0x31, 0x6a, 0x31, 0x6b, 0x31, 0x71, 0x31, 0x76,
    0x31, 0x77, 0x31, 0x78, 0x31, 0x79, 0x31, 0x7a, 0x31, 0x26, 0x31, 0x2a,
    0x31, 0x2c, 0x31, 0x3b, 0x31, 0x58, 0x31, 0x5a};
const uint16_t HuffDecoderCommon::table10_8_inner_[9] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0015, 0x001d, 0x0025, 0x002d, 0x0035};
const uint8_t HuffDecoderCommon::table10_11_emit_[68] = {
    0x32, 0x45, 0x32, 0x46, 0x32, 0x47, 0x32, 0x48, 0x32, 0x49, 0x32, 0x4a,
    0x32, 0x4b, 0x32, 0x4c, 0x32, 0x4d, 0x32, 0x4e, 0x32, 0x4f, 0x32, 0x50,
    0x32, 0x51, 0x32, 0x52, 0x32, 0x53, 0x32, 0x54, 0x32, 0x55, 0x32, 0x56,
    0x32, 0x57, 0x32, 0x59, 0x32, 0x6a, 0x32, 0x6b, 0x32, 0x71, 0x32, 0x76,
    0x32, 0x77, 0x32, 0x78, 0x32, 0x79, 0x32, 0x7a, 0x32, 0x26, 0x32, 0x2a,
    0x32, 0x2c, 0x32, 0x3b, 0x32, 0x58, 0x32, 0x5a};
const uint16_t HuffDecoderCommon::table10_12_inner_[9] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x001d, 0x0025, 0x002d, 0x0035};
const uint8_t HuffDecoderCommon::table10_15_emit_[68] = {
    0x61, 0x45, 0x61, 0x46, 0x61, 0x47, 0x61, 0x48, 0x61, 0x49, 0x61, 0x4a,
    0x61, 0x4b, 0x61, 0x4c, 0x61, 0x4d, 0x61, 0x4e, 0x61, 0x4f, 0x61, 0x50,
    0x61, 0x51, 0x61, 0x52, 0x61, 0x53, 0x61, 0x54, 0x61, 0x55, 0x61, 0x56,
    0x61, 0x57, 0x61, 0x59, 0x61, 0x6a, 0x61, 0x6b, 0x61, 0x71, 0x61, 0x76,
    0x61, 0x77, 0x61, 0x78, 0x61, 0x79, 0x61, 0x7a, 0x61, 0x26, 0x61, 0x2a,
    0x61, 0x2c, 0x61, 0x3b, 0x61, 0x58, 0x61, 0x5a};
const uint16_t HuffDecoderCommon::table10_16_inner_[9] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0025, 0x002d, 0x0035};
const uint8_t HuffDecoderCommon::table10_19_emit_[68] = {
    0x63, 0x45, 0x63, 0x46, 0x63, 0x47, 0x63, 0x48, 0x63, 0x49, 0x63, 0x4a,
    0x63, 0x4b, 0x63, 0x4c, 0x63, 0x4d, 0x63, 0x4e, 0x63, 0x4f, 0x63, 0x50,
    0x63, 0x51, 0x63, 0x52, 0x63, 0x53, 0x63, 0x54, 0x63, 0x55, 0x63, 0x56,
    0x63, 0x57, 0x63, 0x59, 0x63, 0x6a, 0x63, 0x6b, 0x63, 0x71, 0x63, 0x76,
    0x63, 0x77, 0x63, 0x78, 0x63, 0x79, 0x63, 0x7a, 0x63, 0x26, 0x63, 0x2a,
    0x63, 0x2c, 0x63, 0x3b, 0x63, 0x58, 0x63, 0x5a};
const uint16_t HuffDecoderCommon::table10_20_inner_[9] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x002d, 0x0035};
const uint8_t HuffDecoderCommon::table10_23_emit_[68] = {
    0x65, 0x45, 0x65, 0x46, 0x65, 0x47, 0x65, 0x48, 0x65, 0x49, 0x65, 0x4a,
    0x65, 0x4b, 0x65, 0x4c, 0x65, 0x4d, 0x65, 0x4e, 0x65, 0x4f, 0x65, 0x50,
    0x65, 0x51, 0x65, 0x52, 0x65, 0x53, 0x65, 0x54, 0x65, 0x55, 0x65, 0x56,
    0x65, 0x57, 0x65, 0x59, 0x65, 0x6a, 0x65, 0x6b, 0x65, 0x71, 0x65, 0x76,
    0x65, 0x77, 0x65, 0x78, 0x65, 0x79, 0x65, 0x7a, 0x65, 0x26, 0x65, 0x2a,
    0x65, 0x2c, 0x65, 0x3b, 0x65, 0x58, 0x65, 0x5a};
const uint16_t HuffDecoderCommon::table10_24_inner_[9] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0035};
const uint8_t HuffDecoderCommon::table10_27_emit_[68] = {
    0x69, 0x45, 0x69, 0x46, 0x69, 0x47, 0x69, 0x48, 0x69, 0x49, 0x69, 0x4a,
    0x69, 0x4b, 0x69, 0x4c, 0x69, 0x4d, 0x69, 0x4e, 0x69, 0x4f, 0x69, 0x50,
    0x69, 0x51, 0x69, 0x52, 0x69, 0x53, 0x69, 0x54, 0x69, 0x55, 0x69, 0x56,
    0x69, 0x57, 0x69, 0x59, 0x69, 0x6a, 0x69, 0x6b, 0x69, 0x71, 0x69, 0x76,
    0x69, 0x77, 0x69, 0x78, 0x69, 0x79, 0x69, 0x7a, 0x69, 0x26, 0x69, 0x2a,
    0x69, 0x2c, 0x69, 0x3b, 0x69, 0x58, 0x69, 0x5a};
const uint16_t HuffDecoderCommon::table10_28_inner_[9] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039};
const uint8_t HuffDecoderCommon::table10_31_emit_[68] = {
    0x6f, 0x45, 0x6f, 0x46, 0x6f, 0x47, 0x6f, 0x48, 0x6f, 0x49, 0x6f, 0x4a,
    0x6f, 0x4b, 0x6f, 0x4c, 0x6f, 0x4d, 0x6f, 0x4e, 0x6f, 0x4f, 0x6f, 0x50,
    0x6f, 0x51, 0x6f, 0x52, 0x6f, 0x53, 0x6f, 0x54, 0x6f, 0x55, 0x6f, 0x56,
    0x6f, 0x57, 0x6f, 0x59, 0x6f, 0x6a, 0x6f, 0x6b, 0x6f, 0x71, 0x6f, 0x76,
    0x6f, 0x77, 0x6f, 0x78, 0x6f, 0x79, 0x6f, 0x7a, 0x6f, 0x26, 0x6f, 0x2a,
    0x6f, 0x2c, 0x6f, 0x3b, 0x6f, 0x58, 0x6f, 0x5a};
const uint16_t HuffDecoderCommon::table10_33_inner_[15] = {
    0x0000, 0x0001, 0x0005, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table10_35_emit_[68] = {
    0x73, 0x45, 0x73, 0x46, 0x73, 0x47, 0x73, 0x48, 0x73, 0x49, 0x73, 0x4a,
    0x73, 0x4b, 0x73, 0x4c, 0x73, 0x4d, 0x73, 0x4e, 0x73, 0x4f, 0x73, 0x50,
    0x73, 0x51, 0x73, 0x52, 0x73, 0x53, 0x73, 0x54, 0x73, 0x55, 0x73, 0x56,
    0x73, 0x57, 0x73, 0x59, 0x73, 0x6a, 0x73, 0x6b, 0x73, 0x71, 0x73, 0x76,
    0x73, 0x77, 0x73, 0x78, 0x73, 0x79, 0x73, 0x7a, 0x73, 0x26, 0x73, 0x2a,
    0x73, 0x2c, 0x73, 0x3b, 0x73, 0x58, 0x73, 0x5a};
const uint16_t HuffDecoderCommon::table10_37_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table10_39_emit_[68] = {
    0x74, 0x45, 0x74, 0x46, 0x74, 0x47, 0x74, 0x48, 0x74, 0x49, 0x74, 0x4a,
    0x74, 0x4b, 0x74, 0x4c, 0x74, 0x4d, 0x74, 0x4e, 0x74, 0x4f, 0x74, 0x50,
    0x74, 0x51, 0x74, 0x52, 0x74, 0x53, 0x74, 0x54, 0x74, 0x55, 0x74, 0x56,
    0x74, 0x57, 0x74, 0x59, 0x74, 0x6a, 0x74, 0x6b, 0x74, 0x71, 0x74, 0x76,
    0x74, 0x77, 0x74, 0x78, 0x74, 0x79, 0x74, 0x7a, 0x74, 0x26, 0x74, 0x2a,
    0x74, 0x2c, 0x74, 0x3b, 0x74, 0x58, 0x74, 0x5a};
const uint16_t HuffDecoderCommon::table10_40_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_40_outer_[64] = {
    0, 0,  0, 1,  0, 0,  0, 2,  0, 0,  0, 3,  0, 0,  0, 4,  0, 0,  0, 5,  0, 0,
    0, 6,  0, 0,  0, 7,  0, 0,  0, 8,  0, 0,  0, 9,  0, 0,  0, 10, 0, 11, 0, 12,
    0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22};
const uint8_t HuffDecoderCommon::table10_41_emit_[92] = {
    0x20, 0x3d, 0x20, 0x41, 0x20, 0x5f, 0x20, 0x62, 0x20, 0x64, 0x20, 0x66,
    0x20, 0x67, 0x20, 0x68, 0x20, 0x6c, 0x20, 0x6d, 0x20, 0x6e, 0x20, 0x70,
    0x20, 0x72, 0x20, 0x75, 0x20, 0x3a, 0x20, 0x42, 0x20, 0x43, 0x20, 0x44,
    0x20, 0x45, 0x20, 0x46, 0x20, 0x47, 0x20, 0x48, 0x20, 0x49, 0x20, 0x4a,
    0x20, 0x4b, 0x20, 0x4c, 0x20, 0x4d, 0x20, 0x4e, 0x20, 0x4f, 0x20, 0x50,
    0x20, 0x51, 0x20, 0x52, 0x20, 0x53, 0x20, 0x54, 0x20, 0x55, 0x20, 0x56,
    0x20, 0x57, 0x20, 0x59, 0x20, 0x6a, 0x20, 0x6b, 0x20, 0x71, 0x20, 0x76,
    0x20, 0x77, 0x20, 0x78, 0x20, 0x79, 0x20, 0x7a};
const uint16_t HuffDecoderCommon::table10_41_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131,
    0x0139, 0x0141, 0x0149, 0x0151, 0x0159, 0x0161, 0x0169, 0x0002};
const uint8_t HuffDecoderCommon::table10_41_outer_[64] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,
    0,  9,  0,  10, 0,  11, 0,  12, 0,  13, 0,  14, 15, 16, 17, 18,
    19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
    35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 0,  0,  0,  47};
const uint16_t HuffDecoderCommon::table10_42_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_43_emit_[92] = {
    0x25, 0x3d, 0x25, 0x41, 0x25, 0x5f, 0x25, 0x62, 0x25, 0x64, 0x25, 0x66,
    0x25, 0x67, 0x25, 0x68, 0x25, 0x6c, 0x25, 0x6d, 0x25, 0x6e, 0x25, 0x70,
    0x25, 0x72, 0x25, 0x75, 0x25, 0x3a, 0x25, 0x42, 0x25, 0x43, 0x25, 0x44,
    0x25, 0x45, 0x25, 0x46, 0x25, 0x47, 0x25, 0x48, 0x25, 0x49, 0x25, 0x4a,
    0x25, 0x4b, 0x25, 0x4c, 0x25, 0x4d, 0x25, 0x4e, 0x25, 0x4f, 0x25, 0x50,
    0x25, 0x51, 0x25, 0x52, 0x25, 0x53, 0x25, 0x54, 0x25, 0x55, 0x25, 0x56,
    0x25, 0x57, 0x25, 0x59, 0x25, 0x6a, 0x25, 0x6b, 0x25, 0x71, 0x25, 0x76,
    0x25, 0x77, 0x25, 0x78, 0x25, 0x79, 0x25, 0x7a};
const uint16_t HuffDecoderCommon::table10_44_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_45_emit_[92] = {
    0x2d, 0x3d, 0x2d, 0x41, 0x2d, 0x5f, 0x2d, 0x62, 0x2d, 0x64, 0x2d, 0x66,
    0x2d, 0x67, 0x2d, 0x68, 0x2d, 0x6c, 0x2d, 0x6d, 0x2d, 0x6e, 0x2d, 0x70,
    0x2d, 0x72, 0x2d, 0x75, 0x2d, 0x3a, 0x2d, 0x42, 0x2d, 0x43, 0x2d, 0x44,
    0x2d, 0x45, 0x2d, 0x46, 0x2d, 0x47, 0x2d, 0x48, 0x2d, 0x49, 0x2d, 0x4a,
    0x2d, 0x4b, 0x2d, 0x4c, 0x2d, 0x4d, 0x2d, 0x4e, 0x2d, 0x4f, 0x2d, 0x50,
    0x2d, 0x51, 0x2d, 0x52, 0x2d, 0x53, 0x2d, 0x54, 0x2d, 0x55, 0x2d, 0x56,
    0x2d, 0x57, 0x2d, 0x59, 0x2d, 0x6a, 0x2d, 0x6b, 0x2d, 0x71, 0x2d, 0x76,
    0x2d, 0x77, 0x2d, 0x78, 0x2d, 0x79, 0x2d, 0x7a};
const uint16_t HuffDecoderCommon::table10_46_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_47_emit_[92] = {
    0x2e, 0x3d, 0x2e, 0x41, 0x2e, 0x5f, 0x2e, 0x62, 0x2e, 0x64, 0x2e, 0x66,
    0x2e, 0x67, 0x2e, 0x68, 0x2e, 0x6c, 0x2e, 0x6d, 0x2e, 0x6e, 0x2e, 0x70,
    0x2e, 0x72, 0x2e, 0x75, 0x2e, 0x3a, 0x2e, 0x42, 0x2e, 0x43, 0x2e, 0x44,
    0x2e, 0x45, 0x2e, 0x46, 0x2e, 0x47, 0x2e, 0x48, 0x2e, 0x49, 0x2e, 0x4a,
    0x2e, 0x4b, 0x2e, 0x4c, 0x2e, 0x4d, 0x2e, 0x4e, 0x2e, 0x4f, 0x2e, 0x50,
    0x2e, 0x51, 0x2e, 0x52, 0x2e, 0x53, 0x2e, 0x54, 0x2e, 0x55, 0x2e, 0x56,
    0x2e, 0x57, 0x2e, 0x59, 0x2e, 0x6a, 0x2e, 0x6b, 0x2e, 0x71, 0x2e, 0x76,
    0x2e, 0x77, 0x2e, 0x78, 0x2e, 0x79, 0x2e, 0x7a};
const uint16_t HuffDecoderCommon::table10_48_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_49_emit_[92] = {
    0x2f, 0x3d, 0x2f, 0x41, 0x2f, 0x5f, 0x2f, 0x62, 0x2f, 0x64, 0x2f, 0x66,
    0x2f, 0x67, 0x2f, 0x68, 0x2f, 0x6c, 0x2f, 0x6d, 0x2f, 0x6e, 0x2f, 0x70,
    0x2f, 0x72, 0x2f, 0x75, 0x2f, 0x3a, 0x2f, 0x42, 0x2f, 0x43, 0x2f, 0x44,
    0x2f, 0x45, 0x2f, 0x46, 0x2f, 0x47, 0x2f, 0x48, 0x2f, 0x49, 0x2f, 0x4a,
    0x2f, 0x4b, 0x2f, 0x4c, 0x2f, 0x4d, 0x2f, 0x4e, 0x2f, 0x4f, 0x2f, 0x50,
    0x2f, 0x51, 0x2f, 0x52, 0x2f, 0x53, 0x2f, 0x54, 0x2f, 0x55, 0x2f, 0x56,
    0x2f, 0x57, 0x2f, 0x59, 0x2f, 0x6a, 0x2f, 0x6b, 0x2f, 0x71, 0x2f, 0x76,
    0x2f, 0x77, 0x2f, 0x78, 0x2f, 0x79, 0x2f, 0x7a};
const uint16_t HuffDecoderCommon::table10_50_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_51_emit_[92] = {
    0x33, 0x3d, 0x33, 0x41, 0x33, 0x5f, 0x33, 0x62, 0x33, 0x64, 0x33, 0x66,
    0x33, 0x67, 0x33, 0x68, 0x33, 0x6c, 0x33, 0x6d, 0x33, 0x6e, 0x33, 0x70,
    0x33, 0x72, 0x33, 0x75, 0x33, 0x3a, 0x33, 0x42, 0x33, 0x43, 0x33, 0x44,
    0x33, 0x45, 0x33, 0x46, 0x33, 0x47, 0x33, 0x48, 0x33, 0x49, 0x33, 0x4a,
    0x33, 0x4b, 0x33, 0x4c, 0x33, 0x4d, 0x33, 0x4e, 0x33, 0x4f, 0x33, 0x50,
    0x33, 0x51, 0x33, 0x52, 0x33, 0x53, 0x33, 0x54, 0x33, 0x55, 0x33, 0x56,
    0x33, 0x57, 0x33, 0x59, 0x33, 0x6a, 0x33, 0x6b, 0x33, 0x71, 0x33, 0x76,
    0x33, 0x77, 0x33, 0x78, 0x33, 0x79, 0x33, 0x7a};
const uint16_t HuffDecoderCommon::table10_52_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_53_emit_[92] = {
    0x34, 0x3d, 0x34, 0x41, 0x34, 0x5f, 0x34, 0x62, 0x34, 0x64, 0x34, 0x66,
    0x34, 0x67, 0x34, 0x68, 0x34, 0x6c, 0x34, 0x6d, 0x34, 0x6e, 0x34, 0x70,
    0x34, 0x72, 0x34, 0x75, 0x34, 0x3a, 0x34, 0x42, 0x34, 0x43, 0x34, 0x44,
    0x34, 0x45, 0x34, 0x46, 0x34, 0x47, 0x34, 0x48, 0x34, 0x49, 0x34, 0x4a,
    0x34, 0x4b, 0x34, 0x4c, 0x34, 0x4d, 0x34, 0x4e, 0x34, 0x4f, 0x34, 0x50,
    0x34, 0x51, 0x34, 0x52, 0x34, 0x53, 0x34, 0x54, 0x34, 0x55, 0x34, 0x56,
    0x34, 0x57, 0x34, 0x59, 0x34, 0x6a, 0x34, 0x6b, 0x34, 0x71, 0x34, 0x76,
    0x34, 0x77, 0x34, 0x78, 0x34, 0x79, 0x34, 0x7a};
const uint16_t HuffDecoderCommon::table10_54_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x008d, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_55_emit_[92] = {
    0x35, 0x3d, 0x35, 0x41, 0x35, 0x5f, 0x35, 0x62, 0x35, 0x64, 0x35, 0x66,
    0x35, 0x67, 0x35, 0x68, 0x35, 0x6c, 0x35, 0x6d, 0x35, 0x6e, 0x35, 0x70,
    0x35, 0x72, 0x35, 0x75, 0x35, 0x3a, 0x35, 0x42, 0x35, 0x43, 0x35, 0x44,
    0x35, 0x45, 0x35, 0x46, 0x35, 0x47, 0x35, 0x48, 0x35, 0x49, 0x35, 0x4a,
    0x35, 0x4b, 0x35, 0x4c, 0x35, 0x4d, 0x35, 0x4e, 0x35, 0x4f, 0x35, 0x50,
    0x35, 0x51, 0x35, 0x52, 0x35, 0x53, 0x35, 0x54, 0x35, 0x55, 0x35, 0x56,
    0x35, 0x57, 0x35, 0x59, 0x35, 0x6a, 0x35, 0x6b, 0x35, 0x71, 0x35, 0x76,
    0x35, 0x77, 0x35, 0x78, 0x35, 0x79, 0x35, 0x7a};
const uint16_t HuffDecoderCommon::table10_56_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0095, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_57_emit_[92] = {
    0x36, 0x3d, 0x36, 0x41, 0x36, 0x5f, 0x36, 0x62, 0x36, 0x64, 0x36, 0x66,
    0x36, 0x67, 0x36, 0x68, 0x36, 0x6c, 0x36, 0x6d, 0x36, 0x6e, 0x36, 0x70,
    0x36, 0x72, 0x36, 0x75, 0x36, 0x3a, 0x36, 0x42, 0x36, 0x43, 0x36, 0x44,
    0x36, 0x45, 0x36, 0x46, 0x36, 0x47, 0x36, 0x48, 0x36, 0x49, 0x36, 0x4a,
    0x36, 0x4b, 0x36, 0x4c, 0x36, 0x4d, 0x36, 0x4e, 0x36, 0x4f, 0x36, 0x50,
    0x36, 0x51, 0x36, 0x52, 0x36, 0x53, 0x36, 0x54, 0x36, 0x55, 0x36, 0x56,
    0x36, 0x57, 0x36, 0x59, 0x36, 0x6a, 0x36, 0x6b, 0x36, 0x71, 0x36, 0x76,
    0x36, 0x77, 0x36, 0x78, 0x36, 0x79, 0x36, 0x7a};
const uint16_t HuffDecoderCommon::table10_58_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x009d, 0x00a5};
const uint8_t HuffDecoderCommon::table10_59_emit_[92] = {
    0x37, 0x3d, 0x37, 0x41, 0x37, 0x5f, 0x37, 0x62, 0x37, 0x64, 0x37, 0x66,
    0x37, 0x67, 0x37, 0x68, 0x37, 0x6c, 0x37, 0x6d, 0x37, 0x6e, 0x37, 0x70,
    0x37, 0x72, 0x37, 0x75, 0x37, 0x3a, 0x37, 0x42, 0x37, 0x43, 0x37, 0x44,
    0x37, 0x45, 0x37, 0x46, 0x37, 0x47, 0x37, 0x48, 0x37, 0x49, 0x37, 0x4a,
    0x37, 0x4b, 0x37, 0x4c, 0x37, 0x4d, 0x37, 0x4e, 0x37, 0x4f, 0x37, 0x50,
    0x37, 0x51, 0x37, 0x52, 0x37, 0x53, 0x37, 0x54, 0x37, 0x55, 0x37, 0x56,
    0x37, 0x57, 0x37, 0x59, 0x37, 0x6a, 0x37, 0x6b, 0x37, 0x71, 0x37, 0x76,
    0x37, 0x77, 0x37, 0x78, 0x37, 0x79, 0x37, 0x7a};
const uint16_t HuffDecoderCommon::table10_60_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a5};
const uint8_t HuffDecoderCommon::table10_61_emit_[92] = {
    0x38, 0x3d, 0x38, 0x41, 0x38, 0x5f, 0x38, 0x62, 0x38, 0x64, 0x38, 0x66,
    0x38, 0x67, 0x38, 0x68, 0x38, 0x6c, 0x38, 0x6d, 0x38, 0x6e, 0x38, 0x70,
    0x38, 0x72, 0x38, 0x75, 0x38, 0x3a, 0x38, 0x42, 0x38, 0x43, 0x38, 0x44,
    0x38, 0x45, 0x38, 0x46, 0x38, 0x47, 0x38, 0x48, 0x38, 0x49, 0x38, 0x4a,
    0x38, 0x4b, 0x38, 0x4c, 0x38, 0x4d, 0x38, 0x4e, 0x38, 0x4f, 0x38, 0x50,
    0x38, 0x51, 0x38, 0x52, 0x38, 0x53, 0x38, 0x54, 0x38, 0x55, 0x38, 0x56,
    0x38, 0x57, 0x38, 0x59, 0x38, 0x6a, 0x38, 0x6b, 0x38, 0x71, 0x38, 0x76,
    0x38, 0x77, 0x38, 0x78, 0x38, 0x79, 0x38, 0x7a};
const uint16_t HuffDecoderCommon::table10_62_inner_[23] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9};
const uint8_t HuffDecoderCommon::table10_63_emit_[92] = {
    0x39, 0x3d, 0x39, 0x41, 0x39, 0x5f, 0x39, 0x62, 0x39, 0x64, 0x39, 0x66,
    0x39, 0x67, 0x39, 0x68, 0x39, 0x6c, 0x39, 0x6d, 0x39, 0x6e, 0x39, 0x70,
    0x39, 0x72, 0x39, 0x75, 0x39, 0x3a, 0x39, 0x42, 0x39, 0x43, 0x39, 0x44,
    0x39, 0x45, 0x39, 0x46, 0x39, 0x47, 0x39, 0x48, 0x39, 0x49, 0x39, 0x4a,
    0x39, 0x4b, 0x39, 0x4c, 0x39, 0x4d, 0x39, 0x4e, 0x39, 0x4f, 0x39, 0x50,
    0x39, 0x51, 0x39, 0x52, 0x39, 0x53, 0x39, 0x54, 0x39, 0x55, 0x39, 0x56,
    0x39, 0x57, 0x39, 0x59, 0x39, 0x6a, 0x39, 0x6b, 0x39, 0x71, 0x39, 0x76,
    0x39, 0x77, 0x39, 0x78, 0x39, 0x79, 0x39, 0x7a};
const uint8_t HuffDecoderCommon::table10_65_emit_[91] = {
    0x3d, 0x3d, 0x41, 0x3d, 0x5f, 0x3d, 0x62, 0x3d, 0x64, 0x3d, 0x66, 0x3d,
    0x67, 0x3d, 0x68, 0x3d, 0x6c, 0x3d, 0x6d, 0x3d, 0x6e, 0x3d, 0x70, 0x3d,
    0x72, 0x3d, 0x75, 0x3d, 0x3a, 0x3d, 0x42, 0x3d, 0x43, 0x3d, 0x44, 0x3d,
    0x45, 0x3d, 0x46, 0x3d, 0x47, 0x3d, 0x48, 0x3d, 0x49, 0x3d, 0x4a, 0x3d,
    0x4b, 0x3d, 0x4c, 0x3d, 0x4d, 0x3d, 0x4e, 0x3d, 0x4f, 0x3d, 0x50, 0x3d,
    0x51, 0x3d, 0x52, 0x3d, 0x53, 0x3d, 0x54, 0x3d, 0x55, 0x3d, 0x56, 0x3d,
    0x57, 0x3d, 0x59, 0x3d, 0x6a, 0x3d, 0x6b, 0x3d, 0x71, 0x3d, 0x76, 0x3d,
    0x77, 0x3d, 0x78, 0x3d, 0x79, 0x3d, 0x7a};
const uint16_t HuffDecoderCommon::table10_65_inner_[48] = {
    0x0000, 0x0001, 0x0005, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_67_emit_[91] = {
    0x41, 0x3d, 0x41, 0x41, 0x5f, 0x41, 0x62, 0x41, 0x64, 0x41, 0x66, 0x41,
    0x67, 0x41, 0x68, 0x41, 0x6c, 0x41, 0x6d, 0x41, 0x6e, 0x41, 0x70, 0x41,
    0x72, 0x41, 0x75, 0x41, 0x3a, 0x41, 0x42, 0x41, 0x43, 0x41, 0x44, 0x41,
    0x45, 0x41, 0x46, 0x41, 0x47, 0x41, 0x48, 0x41, 0x49, 0x41, 0x4a, 0x41,
    0x4b, 0x41, 0x4c, 0x41, 0x4d, 0x41, 0x4e, 0x41, 0x4f, 0x41, 0x50, 0x41,
    0x51, 0x41, 0x52, 0x41, 0x53, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56, 0x41,
    0x57, 0x41, 0x59, 0x41, 0x6a, 0x41, 0x6b, 0x41, 0x71, 0x41, 0x76, 0x41,
    0x77, 0x41, 0x78, 0x41, 0x79, 0x41, 0x7a};
const uint16_t HuffDecoderCommon::table10_67_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_69_emit_[91] = {
    0x5f, 0x3d, 0x5f, 0x41, 0x5f, 0x5f, 0x62, 0x5f, 0x64, 0x5f, 0x66, 0x5f,
    0x67, 0x5f, 0x68, 0x5f, 0x6c, 0x5f, 0x6d, 0x5f, 0x6e, 0x5f, 0x70, 0x5f,
    0x72, 0x5f, 0x75, 0x5f, 0x3a, 0x5f, 0x42, 0x5f, 0x43, 0x5f, 0x44, 0x5f,
    0x45, 0x5f, 0x46, 0x5f, 0x47, 0x5f, 0x48, 0x5f, 0x49, 0x5f, 0x4a, 0x5f,
    0x4b, 0x5f, 0x4c, 0x5f, 0x4d, 0x5f, 0x4e, 0x5f, 0x4f, 0x5f, 0x50, 0x5f,
    0x51, 0x5f, 0x52, 0x5f, 0x53, 0x5f, 0x54, 0x5f, 0x55, 0x5f, 0x56, 0x5f,
    0x57, 0x5f, 0x59, 0x5f, 0x6a, 0x5f, 0x6b, 0x5f, 0x71, 0x5f, 0x76, 0x5f,
    0x77, 0x5f, 0x78, 0x5f, 0x79, 0x5f, 0x7a};
const uint16_t HuffDecoderCommon::table10_69_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_71_emit_[91] = {
    0x62, 0x3d, 0x62, 0x41, 0x62, 0x5f, 0x62, 0x62, 0x64, 0x62, 0x66, 0x62,
    0x67, 0x62, 0x68, 0x62, 0x6c, 0x62, 0x6d, 0x62, 0x6e, 0x62, 0x70, 0x62,
    0x72, 0x62, 0x75, 0x62, 0x3a, 0x62, 0x42, 0x62, 0x43, 0x62, 0x44, 0x62,
    0x45, 0x62, 0x46, 0x62, 0x47, 0x62, 0x48, 0x62, 0x49, 0x62, 0x4a, 0x62,
    0x4b, 0x62, 0x4c, 0x62, 0x4d, 0x62, 0x4e, 0x62, 0x4f, 0x62, 0x50, 0x62,
    0x51, 0x62, 0x52, 0x62, 0x53, 0x62, 0x54, 0x62, 0x55, 0x62, 0x56, 0x62,
    0x57, 0x62, 0x59, 0x62, 0x6a, 0x62, 0x6b, 0x62, 0x71, 0x62, 0x76, 0x62,
    0x77, 0x62, 0x78, 0x62, 0x79, 0x62, 0x7a};
const uint16_t HuffDecoderCommon::table10_71_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_73_emit_[91] = {
    0x64, 0x3d, 0x64, 0x41, 0x64, 0x5f, 0x64, 0x62, 0x64, 0x64, 0x66, 0x64,
    0x67, 0x64, 0x68, 0x64, 0x6c, 0x64, 0x6d, 0x64, 0x6e, 0x64, 0x70, 0x64,
    0x72, 0x64, 0x75, 0x64, 0x3a, 0x64, 0x42, 0x64, 0x43, 0x64, 0x44, 0x64,
    0x45, 0x64, 0x46, 0x64, 0x47, 0x64, 0x48, 0x64, 0x49, 0x64, 0x4a, 0x64,
    0x4b, 0x64, 0x4c, 0x64, 0x4d, 0x64, 0x4e, 0x64, 0x4f, 0x64, 0x50, 0x64,
    0x51, 0x64, 0x52, 0x64, 0x53, 0x64, 0x54, 0x64, 0x55, 0x64, 0x56, 0x64,
    0x57, 0x64, 0x59, 0x64, 0x6a, 0x64, 0x6b, 0x64, 0x71, 0x64, 0x76, 0x64,
    0x77, 0x64, 0x78, 0x64, 0x79, 0x64, 0x7a};
const uint16_t HuffDecoderCommon::table10_73_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_75_emit_[91] = {
    0x66, 0x3d, 0x66, 0x41, 0x66, 0x5f, 0x66, 0x62, 0x66, 0x64, 0x66, 0x66,
    0x67, 0x66, 0x68, 0x66, 0x6c, 0x66, 0x6d, 0x66, 0x6e, 0x66, 0x70, 0x66,
    0x72, 0x66, 0x75, 0x66, 0x3a, 0x66, 0x42, 0x66, 0x43, 0x66, 0x44, 0x66,
    0x45, 0x66, 0x46, 0x66, 0x47, 0x66, 0x48, 0x66, 0x49, 0x66, 0x4a, 0x66,
    0x4b, 0x66, 0x4c, 0x66, 0x4d, 0x66, 0x4e, 0x66, 0x4f, 0x66, 0x50, 0x66,
    0x51, 0x66, 0x52, 0x66, 0x53, 0x66, 0x54, 0x66, 0x55, 0x66, 0x56, 0x66,
    0x57, 0x66, 0x59, 0x66, 0x6a, 0x66, 0x6b, 0x66, 0x71, 0x66, 0x76, 0x66,
    0x77, 0x66, 0x78, 0x66, 0x79, 0x66, 0x7a};
const uint16_t HuffDecoderCommon::table10_75_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_77_emit_[91] = {
    0x67, 0x3d, 0x67, 0x41, 0x67, 0x5f, 0x67, 0x62, 0x67, 0x64, 0x67, 0x66,
    0x67, 0x67, 0x68, 0x67, 0x6c, 0x67, 0x6d, 0x67, 0x6e, 0x67, 0x70, 0x67,
    0x72, 0x67, 0x75, 0x67, 0x3a, 0x67, 0x42, 0x67, 0x43, 0x67, 0x44, 0x67,
    0x45, 0x67, 0x46, 0x67, 0x47, 0x67, 0x48, 0x67, 0x49, 0x67, 0x4a, 0x67,
    0x4b, 0x67, 0x4c, 0x67, 0x4d, 0x67, 0x4e, 0x67, 0x4f, 0x67, 0x50, 0x67,
    0x51, 0x67, 0x52, 0x67, 0x53, 0x67, 0x54, 0x67, 0x55, 0x67, 0x56, 0x67,
    0x57, 0x67, 0x59, 0x67, 0x6a, 0x67, 0x6b, 0x67, 0x71, 0x67, 0x76, 0x67,
    0x77, 0x67, 0x78, 0x67, 0x79, 0x67, 0x7a};
const uint16_t HuffDecoderCommon::table10_77_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_79_emit_[91] = {
    0x68, 0x3d, 0x68, 0x41, 0x68, 0x5f, 0x68, 0x62, 0x68, 0x64, 0x68, 0x66,
    0x68, 0x67, 0x68, 0x68, 0x6c, 0x68, 0x6d, 0x68, 0x6e, 0x68, 0x70, 0x68,
    0x72, 0x68, 0x75, 0x68, 0x3a, 0x68, 0x42, 0x68, 0x43, 0x68, 0x44, 0x68,
    0x45, 0x68, 0x46, 0x68, 0x47, 0x68, 0x48, 0x68, 0x49, 0x68, 0x4a, 0x68,
    0x4b, 0x68, 0x4c, 0x68, 0x4d, 0x68, 0x4e, 0x68, 0x4f, 0x68, 0x50, 0x68,
    0x51, 0x68, 0x52, 0x68, 0x53, 0x68, 0x54, 0x68, 0x55, 0x68, 0x56, 0x68,
    0x57, 0x68, 0x59, 0x68, 0x6a, 0x68, 0x6b, 0x68, 0x71, 0x68, 0x76, 0x68,
    0x77, 0x68, 0x78, 0x68, 0x79, 0x68, 0x7a};
const uint16_t HuffDecoderCommon::table10_79_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_81_emit_[91] = {
    0x6c, 0x3d, 0x6c, 0x41, 0x6c, 0x5f, 0x6c, 0x62, 0x6c, 0x64, 0x6c, 0x66,
    0x6c, 0x67, 0x6c, 0x68, 0x6c, 0x6c, 0x6d, 0x6c, 0x6e, 0x6c, 0x70, 0x6c,
    0x72, 0x6c, 0x75, 0x6c, 0x3a, 0x6c, 0x42, 0x6c, 0x43, 0x6c, 0x44, 0x6c,
    0x45, 0x6c, 0x46, 0x6c, 0x47, 0x6c, 0x48, 0x6c, 0x49, 0x6c, 0x4a, 0x6c,
    0x4b, 0x6c, 0x4c, 0x6c, 0x4d, 0x6c, 0x4e, 0x6c, 0x4f, 0x6c, 0x50, 0x6c,
    0x51, 0x6c, 0x52, 0x6c, 0x53, 0x6c, 0x54, 0x6c, 0x55, 0x6c, 0x56, 0x6c,
    0x57, 0x6c, 0x59, 0x6c, 0x6a, 0x6c, 0x6b, 0x6c, 0x71, 0x6c, 0x76, 0x6c,
    0x77, 0x6c, 0x78, 0x6c, 0x79, 0x6c, 0x7a};
const uint16_t HuffDecoderCommon::table10_81_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_83_emit_[91] = {
    0x6d, 0x3d, 0x6d, 0x41, 0x6d, 0x5f, 0x6d, 0x62, 0x6d, 0x64, 0x6d, 0x66,
    0x6d, 0x67, 0x6d, 0x68, 0x6d, 0x6c, 0x6d, 0x6d, 0x6e, 0x6d, 0x70, 0x6d,
    0x72, 0x6d, 0x75, 0x6d, 0x3a, 0x6d, 0x42, 0x6d, 0x43, 0x6d, 0x44, 0x6d,
    0x45, 0x6d, 0x46, 0x6d, 0x47, 0x6d, 0x48, 0x6d, 0x49, 0x6d, 0x4a, 0x6d,
    0x4b, 0x6d, 0x4c, 0x6d, 0x4d, 0x6d, 0x4e, 0x6d, 0x4f, 0x6d, 0x50, 0x6d,
    0x51, 0x6d, 0x52, 0x6d, 0x53, 0x6d, 0x54, 0x6d, 0x55, 0x6d, 0x56, 0x6d,
    0x57, 0x6d, 0x59, 0x6d, 0x6a, 0x6d, 0x6b, 0x6d, 0x71, 0x6d, 0x76, 0x6d,
    0x77, 0x6d, 0x78, 0x6d, 0x79, 0x6d, 0x7a};
const uint16_t HuffDecoderCommon::table10_83_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_85_emit_[91] = {
    0x6e, 0x3d, 0x6e, 0x41, 0x6e, 0x5f, 0x6e, 0x62, 0x6e, 0x64, 0x6e, 0x66,
    0x6e, 0x67, 0x6e, 0x68, 0x6e, 0x6c, 0x6e, 0x6d, 0x6e, 0x6e, 0x70, 0x6e,
    0x72, 0x6e, 0x75, 0x6e, 0x3a, 0x6e, 0x42, 0x6e, 0x43, 0x6e, 0x44, 0x6e,
    0x45, 0x6e, 0x46, 0x6e, 0x47, 0x6e, 0x48, 0x6e, 0x49, 0x6e, 0x4a, 0x6e,
    0x4b, 0x6e, 0x4c, 0x6e, 0x4d, 0x6e, 0x4e, 0x6e, 0x4f, 0x6e, 0x50, 0x6e,
    0x51, 0x6e, 0x52, 0x6e, 0x53, 0x6e, 0x54, 0x6e, 0x55, 0x6e, 0x56, 0x6e,
    0x57, 0x6e, 0x59, 0x6e, 0x6a, 0x6e, 0x6b, 0x6e, 0x71, 0x6e, 0x76, 0x6e,
    0x77, 0x6e, 0x78, 0x6e, 0x79, 0x6e, 0x7a};
const uint16_t HuffDecoderCommon::table10_85_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_87_emit_[91] = {
    0x70, 0x3d, 0x70, 0x41, 0x70, 0x5f, 0x70, 0x62, 0x70, 0x64, 0x70, 0x66,
    0x70, 0x67, 0x70, 0x68, 0x70, 0x6c, 0x70, 0x6d, 0x70, 0x6e, 0x70, 0x70,
    0x72, 0x70, 0x75, 0x70, 0x3a, 0x70, 0x42, 0x70, 0x43, 0x70, 0x44, 0x70,
    0x45, 0x70, 0x46, 0x70, 0x47, 0x70, 0x48, 0x70, 0x49, 0x70, 0x4a, 0x70,
    0x4b, 0x70, 0x4c, 0x70, 0x4d, 0x70, 0x4e, 0x70, 0x4f, 0x70, 0x50, 0x70,
    0x51, 0x70, 0x52, 0x70, 0x53, 0x70, 0x54, 0x70, 0x55, 0x70, 0x56, 0x70,
    0x57, 0x70, 0x59, 0x70, 0x6a, 0x70, 0x6b, 0x70, 0x71, 0x70, 0x76, 0x70,
    0x77, 0x70, 0x78, 0x70, 0x79, 0x70, 0x7a};
const uint16_t HuffDecoderCommon::table10_87_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_89_emit_[91] = {
    0x72, 0x3d, 0x72, 0x41, 0x72, 0x5f, 0x72, 0x62, 0x72, 0x64, 0x72, 0x66,
    0x72, 0x67, 0x72, 0x68, 0x72, 0x6c, 0x72, 0x6d, 0x72, 0x6e, 0x72, 0x70,
    0x72, 0x72, 0x75, 0x72, 0x3a, 0x72, 0x42, 0x72, 0x43, 0x72, 0x44, 0x72,
    0x45, 0x72, 0x46, 0x72, 0x47, 0x72, 0x48, 0x72, 0x49, 0x72, 0x4a, 0x72,
    0x4b, 0x72, 0x4c, 0x72, 0x4d, 0x72, 0x4e, 0x72, 0x4f, 0x72, 0x50, 0x72,
    0x51, 0x72, 0x52, 0x72, 0x53, 0x72, 0x54, 0x72, 0x55, 0x72, 0x56, 0x72,
    0x57, 0x72, 0x59, 0x72, 0x6a, 0x72, 0x6b, 0x72, 0x71, 0x72, 0x76, 0x72,
    0x77, 0x72, 0x78, 0x72, 0x79, 0x72, 0x7a};
const uint16_t HuffDecoderCommon::table10_89_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_91_emit_[91] = {
    0x75, 0x3d, 0x75, 0x41, 0x75, 0x5f, 0x75, 0x62, 0x75, 0x64, 0x75, 0x66,
    0x75, 0x67, 0x75, 0x68, 0x75, 0x6c, 0x75, 0x6d, 0x75, 0x6e, 0x75, 0x70,
    0x75, 0x72, 0x75, 0x75, 0x3a, 0x75, 0x42, 0x75, 0x43, 0x75, 0x44, 0x75,
    0x45, 0x75, 0x46, 0x75, 0x47, 0x75, 0x48, 0x75, 0x49, 0x75, 0x4a, 0x75,
    0x4b, 0x75, 0x4c, 0x75, 0x4d, 0x75, 0x4e, 0x75, 0x4f, 0x75, 0x50, 0x75,
    0x51, 0x75, 0x52, 0x75, 0x53, 0x75, 0x54, 0x75, 0x55, 0x75, 0x56, 0x75,
    0x57, 0x75, 0x59, 0x75, 0x6a, 0x75, 0x6b, 0x75, 0x71, 0x75, 0x76, 0x75,
    0x77, 0x75, 0x78, 0x75, 0x79, 0x75, 0x7a};
const uint16_t HuffDecoderCommon::table10_91_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table10_92_emit_[72] = {
    0x3a, 0x30, 0x3a, 0x31, 0x3a, 0x32, 0x3a, 0x61, 0x3a, 0x63, 0x3a, 0x65,
    0x3a, 0x69, 0x3a, 0x6f, 0x3a, 0x73, 0x3a, 0x74, 0x3a, 0x20, 0x3a, 0x25,
    0x3a, 0x2d, 0x3a, 0x2e, 0x3a, 0x2f, 0x3a, 0x33, 0x3a, 0x34, 0x3a, 0x35,
    0x3a, 0x36, 0x3a, 0x37, 0x3a, 0x38, 0x3a, 0x39, 0x3a, 0x3d, 0x3a, 0x41,
    0x3a, 0x5f, 0x3a, 0x62, 0x3a, 0x64, 0x3a, 0x66, 0x3a, 0x67, 0x3a, 0x68,
    0x3a, 0x6c, 0x3a, 0x6d, 0x3a, 0x6e, 0x3a, 0x70, 0x3a, 0x72, 0x3a, 0x75};
const uint16_t HuffDecoderCommon::table10_92_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0002};
const uint8_t HuffDecoderCommon::table10_93_emit_[72] = {
    0x42, 0x30, 0x42, 0x31, 0x42, 0x32, 0x42, 0x61, 0x42, 0x63, 0x42, 0x65,
    0x42, 0x69, 0x42, 0x6f, 0x42, 0x73, 0x42, 0x74, 0x42, 0x20, 0x42, 0x25,
    0x42, 0x2d, 0x42, 0x2e, 0x42, 0x2f, 0x42, 0x33, 0x42, 0x34, 0x42, 0x35,
    0x42, 0x36, 0x42, 0x37, 0x42, 0x38, 0x42, 0x39, 0x42, 0x3d, 0x42, 0x41,
    0x42, 0x5f, 0x42, 0x62, 0x42, 0x64, 0x42, 0x66, 0x42, 0x67, 0x42, 0x68,
    0x42, 0x6c, 0x42, 0x6d, 0x42, 0x6e, 0x42, 0x70, 0x42, 0x72, 0x42, 0x75};
const uint8_t HuffDecoderCommon::table10_94_emit_[72] = {
    0x43, 0x30, 0x43, 0x31, 0x43, 0x32, 0x43, 0x61, 0x43, 0x63, 0x43, 0x65,
    0x43, 0x69, 0x43, 0x6f, 0x43, 0x73, 0x43, 0x74, 0x43, 0x20, 0x43, 0x25,
    0x43, 0x2d, 0x43, 0x2e, 0x43, 0x2f, 0x43, 0x33, 0x43, 0x34, 0x43, 0x35,
    0x43, 0x36, 0x43, 0x37, 0x43, 0x38, 0x43, 0x39, 0x43, 0x3d, 0x43, 0x41,
    0x43, 0x5f, 0x43, 0x62, 0x43, 0x64, 0x43, 0x66, 0x43, 0x67, 0x43, 0x68,
    0x43, 0x6c, 0x43, 0x6d, 0x43, 0x6e, 0x43, 0x70, 0x43, 0x72, 0x43, 0x75};
const uint8_t HuffDecoderCommon::table10_95_emit_[72] = {
    0x44, 0x30, 0x44, 0x31, 0x44, 0x32, 0x44, 0x61, 0x44, 0x63, 0x44, 0x65,
    0x44, 0x69, 0x44, 0x6f, 0x44, 0x73, 0x44, 0x74, 0x44, 0x20, 0x44, 0x25,
    0x44, 0x2d, 0x44, 0x2e, 0x44, 0x2f, 0x44, 0x33, 0x44, 0x34, 0x44, 0x35,
    0x44, 0x36, 0x44, 0x37, 0x44, 0x38, 0x44, 0x39, 0x44, 0x3d, 0x44, 0x41,
    0x44, 0x5f, 0x44, 0x62, 0x44, 0x64, 0x44, 0x66, 0x44, 0x67, 0x44, 0x68,
    0x44, 0x6c, 0x44, 0x6d, 0x44, 0x6e, 0x44, 0x70, 0x44, 0x72, 0x44, 0x75};
const uint8_t HuffDecoderCommon::table10_96_emit_[72] = {
    0x45, 0x30, 0x45, 0x31, 0x45, 0x32, 0x45, 0x61, 0x45, 0x63, 0x45, 0x65,
    0x45, 0x69, 0x45, 0x6f, 0x45, 0x73, 0x45, 0x74, 0x45, 0x20, 0x45, 0x25,
    0x45, 0x2d, 0x45, 0x2e, 0x45, 0x2f, 0x45, 0x33, 0x45, 0x34, 0x45, 0x35,
    0x45, 0x36, 0x45, 0x37, 0x45, 0x38, 0x45, 0x39, 0x45, 0x3d, 0x45, 0x41,
    0x45, 0x5f, 0x45, 0x62, 0x45, 0x64, 0x45, 0x66, 0x45, 0x67, 0x45, 0x68,
    0x45, 0x6c, 0x45, 0x6d, 0x45, 0x6e, 0x45, 0x70, 0x45, 0x72, 0x45, 0x75};
const uint8_t HuffDecoderCommon::table10_97_emit_[72] = {
    0x46, 0x30, 0x46, 0x31, 0x46, 0x32, 0x46, 0x61, 0x46, 0x63, 0x46, 0x65,
    0x46, 0x69, 0x46, 0x6f, 0x46, 0x73, 0x46, 0x74, 0x46, 0x20, 0x46, 0x25,
    0x46, 0x2d, 0x46, 0x2e, 0x46, 0x2f, 0x46, 0x33, 0x46, 0x34, 0x46, 0x35,
    0x46, 0x36, 0x46, 0x37, 0x46, 0x38, 0x46, 0x39, 0x46, 0x3d, 0x46, 0x41,
    0x46, 0x5f, 0x46, 0x62, 0x46, 0x64, 0x46, 0x66, 0x46, 0x67, 0x46, 0x68,
    0x46, 0x6c, 0x46, 0x6d, 0x46, 0x6e, 0x46, 0x70, 0x46, 0x72, 0x46, 0x75};
const uint8_t HuffDecoderCommon::table10_98_emit_[72] = {
    0x47, 0x30, 0x47, 0x31, 0x47, 0x32, 0x47, 0x61, 0x47, 0x63, 0x47, 0x65,
    0x47, 0x69, 0x47, 0x6f, 0x47, 0x73, 0x47, 0x74, 0x47, 0x20, 0x47, 0x25,
    0x47, 0x2d, 0x47, 0x2e, 0x47, 0x2f, 0x47, 0x33, 0x47, 0x34, 0x47, 0x35,
    0x47, 0x36, 0x47, 0x37, 0x47, 0x38, 0x47, 0x39, 0x47, 0x3d, 0x47, 0x41,
    0x47, 0x5f, 0x47, 0x62, 0x47, 0x64, 0x47, 0x66, 0x47, 0x67, 0x47, 0x68,
    0x47, 0x6c, 0x47, 0x6d, 0x47, 0x6e, 0x47, 0x70, 0x47, 0x72, 0x47, 0x75};
const uint8_t HuffDecoderCommon::table10_99_emit_[72] = {
    0x48, 0x30, 0x48, 0x31, 0x48, 0x32, 0x48, 0x61, 0x48, 0x63, 0x48, 0x65,
    0x48, 0x69, 0x48, 0x6f, 0x48, 0x73, 0x48, 0x74, 0x48, 0x20, 0x48, 0x25,
    0x48, 0x2d, 0x48, 0x2e, 0x48, 0x2f, 0x48, 0x33, 0x48, 0x34, 0x48, 0x35,
    0x48, 0x36, 0x48, 0x37, 0x48, 0x38, 0x48, 0x39, 0x48, 0x3d, 0x48, 0x41,
    0x48, 0x5f, 0x48, 0x62, 0x48, 0x64, 0x48, 0x66, 0x48, 0x67, 0x48, 0x68,
    0x48, 0x6c, 0x48, 0x6d, 0x48, 0x6e, 0x48, 0x70, 0x48, 0x72, 0x48, 0x75};
const uint8_t HuffDecoderCommon::table10_100_emit_[72] = {
    0x49, 0x30, 0x49, 0x31, 0x49, 0x32, 0x49, 0x61, 0x49, 0x63, 0x49, 0x65,
    0x49, 0x69, 0x49, 0x6f, 0x49, 0x73, 0x49, 0x74, 0x49, 0x20, 0x49, 0x25,
    0x49, 0x2d, 0x49, 0x2e, 0x49, 0x2f, 0x49, 0x33, 0x49, 0x34, 0x49, 0x35,
    0x49, 0x36, 0x49, 0x37, 0x49, 0x38, 0x49, 0x39, 0x49, 0x3d, 0x49, 0x41,
    0x49, 0x5f, 0x49, 0x62, 0x49, 0x64, 0x49, 0x66, 0x49, 0x67, 0x49, 0x68,
    0x49, 0x6c, 0x49, 0x6d, 0x49, 0x6e, 0x49, 0x70, 0x49, 0x72, 0x49, 0x75};
const uint8_t HuffDecoderCommon::table10_101_emit_[72] = {
    0x4a, 0x30, 0x4a, 0x31, 0x4a, 0x32, 0x4a, 0x61, 0x4a, 0x63, 0x4a, 0x65,
    0x4a, 0x69, 0x4a, 0x6f, 0x4a, 0x73, 0x4a, 0x74, 0x4a, 0x20, 0x4a, 0x25,
    0x4a, 0x2d, 0x4a, 0x2e, 0x4a, 0x2f, 0x4a, 0x33, 0x4a, 0x34, 0x4a, 0x35,
    0x4a, 0x36, 0x4a, 0x37, 0x4a, 0x38, 0x4a, 0x39, 0x4a, 0x3d, 0x4a, 0x41,
    0x4a, 0x5f, 0x4a, 0x62, 0x4a, 0x64, 0x4a, 0x66, 0x4a, 0x67, 0x4a, 0x68,
    0x4a, 0x6c, 0x4a, 0x6d, 0x4a, 0x6e, 0x4a, 0x70, 0x4a, 0x72, 0x4a, 0x75};
const uint8_t HuffDecoderCommon::table10_102_emit_[72] = {
    0x4b, 0x30, 0x4b, 0x31, 0x4b, 0x32, 0x4b, 0x61, 0x4b, 0x63, 0x4b, 0x65,
    0x4b, 0x69, 0x4b, 0x6f, 0x4b, 0x73, 0x4b, 0x74, 0x4b, 0x20, 0x4b, 0x25,
    0x4b, 0x2d, 0x4b, 0x2e, 0x4b, 0x2f, 0x4b, 0x33, 0x4b, 0x34, 0x4b, 0x35,
    0x4b, 0x36, 0x4b, 0x37, 0x4b, 0x38, 0x4b, 0x39, 0x4b, 0x3d, 0x4b, 0x41,
    0x4b, 0x5f, 0x4b, 0x62, 0x4b, 0x64, 0x4b, 0x66, 0x4b, 0x67, 0x4b, 0x68,
    0x4b, 0x6c, 0x4b, 0x6d, 0x4b, 0x6e, 0x4b, 0x70, 0x4b, 0x72, 0x4b, 0x75};
const uint8_t HuffDecoderCommon::table10_103_emit_[72] = {
    0x4c, 0x30, 0x4c, 0x31, 0x4c, 0x32, 0x4c, 0x61, 0x4c, 0x63, 0x4c, 0x65,
    0x4c, 0x69, 0x4c, 0x6f, 0x4c, 0x73, 0x4c, 0x74, 0x4c, 0x20, 0x4c, 0x25,
    0x4c, 0x2d, 0x4c, 0x2e, 0x4c, 0x2f, 0x4c, 0x33, 0x4c, 0x34, 0x4c, 0x35,
    0x4c, 0x36, 0x4c, 0x37, 0x4c, 0x38, 0x4c, 0x39, 0x4c, 0x3d, 0x4c, 0x41,
    0x4c, 0x5f, 0x4c, 0x62, 0x4c, 0x64, 0x4c, 0x66, 0x4c, 0x67, 0x4c, 0x68,
    0x4c, 0x6c, 0x4c, 0x6d, 0x4c, 0x6e, 0x4c, 0x70, 0x4c, 0x72, 0x4c, 0x75};
const uint8_t HuffDecoderCommon::table10_104_emit_[72] = {
    0x4d, 0x30, 0x4d, 0x31, 0x4d, 0x32, 0x4d, 0x61, 0x4d, 0x63, 0x4d, 0x65,
    0x4d, 0x69, 0x4d, 0x6f, 0x4d, 0x73, 0x4d, 0x74, 0x4d, 0x20, 0x4d, 0x25,
    0x4d, 0x2d, 0x4d, 0x2e, 0x4d, 0x2f, 0x4d, 0x33, 0x4d, 0x34, 0x4d, 0x35,
    0x4d, 0x36, 0x4d, 0x37, 0x4d, 0x38, 0x4d, 0x39, 0x4d, 0x3d, 0x4d, 0x41,
    0x4d, 0x5f, 0x4d, 0x62, 0x4d, 0x64, 0x4d, 0x66, 0x4d, 0x67, 0x4d, 0x68,
    0x4d, 0x6c, 0x4d, 0x6d, 0x4d, 0x6e, 0x4d, 0x70, 0x4d, 0x72, 0x4d, 0x75};
const uint8_t HuffDecoderCommon::table10_105_emit_[72] = {
    0x4e, 0x30, 0x4e, 0x31, 0x4e, 0x32, 0x4e, 0x61, 0x4e, 0x63, 0x4e, 0x65,
    0x4e, 0x69, 0x4e, 0x6f, 0x4e, 0x73, 0x4e, 0x74, 0x4e, 0x20, 0x4e, 0x25,
    0x4e, 0x2d, 0x4e, 0x2e, 0x4e, 0x2f, 0x4e, 0x33, 0x4e, 0x34, 0x4e, 0x35,
    0x4e, 0x36, 0x4e, 0x37, 0x4e, 0x38, 0x4e, 0x39, 0x4e, 0x3d, 0x4e, 0x41,
    0x4e, 0x5f, 0x4e, 0x62, 0x4e, 0x64, 0x4e, 0x66, 0x4e, 0x67, 0x4e, 0x68,
    0x4e, 0x6c, 0x4e, 0x6d, 0x4e, 0x6e, 0x4e, 0x70, 0x4e, 0x72, 0x4e, 0x75};
const uint8_t HuffDecoderCommon::table10_106_emit_[72] = {
    0x4f, 0x30, 0x4f, 0x31, 0x4f, 0x32, 0x4f, 0x61, 0x4f, 0x63, 0x4f, 0x65,
    0x4f, 0x69, 0x4f, 0x6f, 0x4f, 0x73, 0x4f, 0x74, 0x4f, 0x20, 0x4f, 0x25,
    0x4f, 0x2d, 0x4f, 0x2e, 0x4f, 0x2f, 0x4f, 0x33, 0x4f, 0x34, 0x4f, 0x35,
    0x4f, 0x36, 0x4f, 0x37, 0x4f, 0x38, 0x4f, 0x39, 0x4f, 0x3d, 0x4f, 0x41,
    0x4f, 0x5f, 0x4f, 0x62, 0x4f, 0x64, 0x4f, 0x66, 0x4f, 0x67, 0x4f, 0x68,
    0x4f, 0x6c, 0x4f, 0x6d, 0x4f, 0x6e, 0x4f, 0x70, 0x4f, 0x72, 0x4f, 0x75};
const uint8_t HuffDecoderCommon::table10_107_emit_[72] = {
    0x50, 0x30, 0x50, 0x31, 0x50, 0x32, 0x50, 0x61, 0x50, 0x63, 0x50, 0x65,
    0x50, 0x69, 0x50, 0x6f, 0x50, 0x73, 0x50, 0x74, 0x50, 0x20, 0x50, 0x25,
    0x50, 0x2d, 0x50, 0x2e, 0x50, 0x2f, 0x50, 0x33, 0x50, 0x34, 0x50, 0x35,
    0x50, 0x36, 0x50, 0x37, 0x50, 0x38, 0x50, 0x39, 0x50, 0x3d, 0x50, 0x41,
    0x50, 0x5f, 0x50, 0x62, 0x50, 0x64, 0x50, 0x66, 0x50, 0x67, 0x50, 0x68,
    0x50, 0x6c, 0x50, 0x6d, 0x50, 0x6e, 0x50, 0x70, 0x50, 0x72, 0x50, 0x75};
const uint8_t HuffDecoderCommon::table10_108_emit_[72] = {
    0x51, 0x30, 0x51, 0x31, 0x51, 0x32, 0x51, 0x61, 0x51, 0x63, 0x51, 0x65,
    0x51, 0x69, 0x51, 0x6f, 0x51, 0x73, 0x51, 0x74, 0x51, 0x20, 0x51, 0x25,
    0x51, 0x2d, 0x51, 0x2e, 0x51, 0x2f, 0x51, 0x33, 0x51, 0x34, 0x51, 0x35,
    0x51, 0x36, 0x51, 0x37, 0x51, 0x38, 0x51, 0x39, 0x51, 0x3d, 0x51, 0x41,
    0x51, 0x5f, 0x51, 0x62, 0x51, 0x64, 0x51, 0x66, 0x51, 0x67, 0x51, 0x68,
    0x51, 0x6c, 0x51, 0x6d, 0x51, 0x6e, 0x51, 0x70, 0x51, 0x72, 0x51, 0x75};
const uint8_t HuffDecoderCommon::table10_109_emit_[72] = {
    0x52, 0x30, 0x52, 0x31, 0x52, 0x32, 0x52, 0x61, 0x52, 0x63, 0x52, 0x65,
    0x52, 0x69, 0x52, 0x6f, 0x52, 0x73, 0x52, 0x74, 0x52, 0x20, 0x52, 0x25,
    0x52, 0x2d, 0x52, 0x2e, 0x52, 0x2f, 0x52, 0x33, 0x52, 0x34, 0x52, 0x35,
    0x52, 0x36, 0x52, 0x37, 0x52, 0x38, 0x52, 0x39, 0x52, 0x3d, 0x52, 0x41,
    0x52, 0x5f, 0x52, 0x62, 0x52, 0x64, 0x52, 0x66, 0x52, 0x67, 0x52, 0x68,
    0x52, 0x6c, 0x52, 0x6d, 0x52, 0x6e, 0x52, 0x70, 0x52, 0x72, 0x52, 0x75};
const uint8_t HuffDecoderCommon::table10_110_emit_[72] = {
    0x53, 0x30, 0x53, 0x31, 0x53, 0x32, 0x53, 0x61, 0x53, 0x63, 0x53, 0x65,
    0x53, 0x69, 0x53, 0x6f, 0x53, 0x73, 0x53, 0x74, 0x53, 0x20, 0x53, 0x25,
    0x53, 0x2d, 0x53, 0x2e, 0x53, 0x2f, 0x53, 0x33, 0x53, 0x34, 0x53, 0x35,
    0x53, 0x36, 0x53, 0x37, 0x53, 0x38, 0x53, 0x39, 0x53, 0x3d, 0x53, 0x41,
    0x53, 0x5f, 0x53, 0x62, 0x53, 0x64, 0x53, 0x66, 0x53, 0x67, 0x53, 0x68,
    0x53, 0x6c, 0x53, 0x6d, 0x53, 0x6e, 0x53, 0x70, 0x53, 0x72, 0x53, 0x75};
const uint8_t HuffDecoderCommon::table10_111_emit_[72] = {
    0x54, 0x30, 0x54, 0x31, 0x54, 0x32, 0x54, 0x61, 0x54, 0x63, 0x54, 0x65,
    0x54, 0x69, 0x54, 0x6f, 0x54, 0x73, 0x54, 0x74, 0x54, 0x20, 0x54, 0x25,
    0x54, 0x2d, 0x54, 0x2e, 0x54, 0x2f, 0x54, 0x33, 0x54, 0x34, 0x54, 0x35,
    0x54, 0x36, 0x54, 0x37, 0x54, 0x38, 0x54, 0x39, 0x54, 0x3d, 0x54, 0x41,
    0x54, 0x5f, 0x54, 0x62, 0x54, 0x64, 0x54, 0x66, 0x54, 0x67, 0x54, 0x68,
    0x54, 0x6c, 0x54, 0x6d, 0x54, 0x6e, 0x54, 0x70, 0x54, 0x72, 0x54, 0x75};
const uint8_t HuffDecoderCommon::table10_112_emit_[72] = {
    0x55, 0x30, 0x55, 0x31, 0x55, 0x32, 0x55, 0x61, 0x55, 0x63, 0x55, 0x65,
    0x55, 0x69, 0x55, 0x6f, 0x55, 0x73, 0x55, 0x74, 0x55, 0x20, 0x55, 0x25,
    0x55, 0x2d, 0x55, 0x2e, 0x55, 0x2f, 0x55, 0x33, 0x55, 0x34, 0x55, 0x35,
    0x55, 0x36, 0x55, 0x37, 0x55, 0x38, 0x55, 0x39, 0x55, 0x3d, 0x55, 0x41,
    0x55, 0x5f, 0x55, 0x62, 0x55, 0x64, 0x55, 0x66, 0x55, 0x67, 0x55, 0x68,
    0x55, 0x6c, 0x55, 0x6d, 0x55, 0x6e, 0x55, 0x70, 0x55, 0x72, 0x55, 0x75};
const uint8_t HuffDecoderCommon::table10_113_emit_[72] = {
    0x56, 0x30, 0x56, 0x31, 0x56, 0x32, 0x56, 0x61, 0x56, 0x63, 0x56, 0x65,
    0x56, 0x69, 0x56, 0x6f, 0x56, 0x73, 0x56, 0x74, 0x56, 0x20, 0x56, 0x25,
    0x56, 0x2d, 0x56, 0x2e, 0x56, 0x2f, 0x56, 0x33, 0x56, 0x34, 0x56, 0x35,
    0x56, 0x36, 0x56, 0x37, 0x56, 0x38, 0x56, 0x39, 0x56, 0x3d, 0x56, 0x41,
    0x56, 0x5f, 0x56, 0x62, 0x56, 0x64, 0x56, 0x66, 0x56, 0x67, 0x56, 0x68,
    0x56, 0x6c, 0x56, 0x6d, 0x56, 0x6e, 0x56, 0x70, 0x56, 0x72, 0x56, 0x75};
const uint8_t HuffDecoderCommon::table10_114_emit_[72] = {
    0x57, 0x30, 0x57, 0x31, 0x57, 0x32, 0x57, 0x61, 0x57, 0x63, 0x57, 0x65,
    0x57, 0x69, 0x57, 0x6f, 0x57, 0x73, 0x57, 0x74, 0x57, 0x20, 0x57, 0x25,
    0x57, 0x2d, 0x57, 0x2e, 0x57, 0x2f, 0x57, 0x33, 0x57, 0x34, 0x57, 0x35,
    0x57, 0x36, 0x57, 0x37, 0x57, 0x38, 0x57, 0x39, 0x57, 0x3d, 0x57, 0x41,
    0x57, 0x5f, 0x57, 0x62, 0x57, 0x64, 0x57, 0x66, 0x57, 0x67, 0x57, 0x68,
    0x57, 0x6c, 0x57, 0x6d, 0x57, 0x6e, 0x57, 0x70, 0x57, 0x72, 0x57, 0x75};
const uint8_t HuffDecoderCommon::table10_115_emit_[72] = {
    0x59, 0x30, 0x59, 0x31, 0x59, 0x32, 0x59, 0x61, 0x59, 0x63, 0x59, 0x65,
    0x59, 0x69, 0x59, 0x6f, 0x59, 0x73, 0x59, 0x74, 0x59, 0x20, 0x59, 0x25,
    0x59, 0x2d, 0x59, 0x2e, 0x59, 0x2f, 0x59, 0x33, 0x59, 0x34, 0x59, 0x35,
    0x59, 0x36, 0x59, 0x37, 0x59, 0x38, 0x59, 0x39, 0x59, 0x3d, 0x59, 0x41,
    0x59, 0x5f, 0x59, 0x62, 0x59, 0x64, 0x59, 0x66, 0x59, 0x67, 0x59, 0x68,
    0x59, 0x6c, 0x59, 0x6d, 0x59, 0x6e, 0x59, 0x70, 0x59, 0x72, 0x59, 0x75};
const uint8_t HuffDecoderCommon::table10_116_emit_[72] = {
    0x6a, 0x30, 0x6a, 0x31, 0x6a, 0x32, 0x6a, 0x61, 0x6a, 0x63, 0x6a, 0x65,
    0x6a, 0x69, 0x6a, 0x6f, 0x6a, 0x73, 0x6a, 0x74, 0x6a, 0x20, 0x6a, 0x25,
    0x6a, 0x2d, 0x6a, 0x2e, 0x6a, 0x2f, 0x6a, 0x33, 0x6a, 0x34, 0x6a, 0x35,
    0x6a, 0x36, 0x6a, 0x37, 0x6a, 0x38, 0x6a, 0x39, 0x6a, 0x3d, 0x6a, 0x41,
    0x6a, 0x5f, 0x6a, 0x62, 0x6a, 0x64, 0x6a, 0x66, 0x6a, 0x67, 0x6a, 0x68,
    0x6a, 0x6c, 0x6a, 0x6d, 0x6a, 0x6e, 0x6a, 0x70, 0x6a, 0x72, 0x6a, 0x75};
const uint8_t HuffDecoderCommon::table10_117_emit_[72] = {
    0x6b, 0x30, 0x6b, 0x31, 0x6b, 0x32, 0x6b, 0x61, 0x6b, 0x63, 0x6b, 0x65,
    0x6b, 0x69, 0x6b, 0x6f, 0x6b, 0x73, 0x6b, 0x74, 0x6b, 0x20, 0x6b, 0x25,
    0x6b, 0x2d, 0x6b, 0x2e, 0x6b, 0x2f, 0x6b, 0x33, 0x6b, 0x34, 0x6b, 0x35,
    0x6b, 0x36, 0x6b, 0x37, 0x6b, 0x38, 0x6b, 0x39, 0x6b, 0x3d, 0x6b, 0x41,
    0x6b, 0x5f, 0x6b, 0x62, 0x6b, 0x64, 0x6b, 0x66, 0x6b, 0x67, 0x6b, 0x68,
    0x6b, 0x6c, 0x6b, 0x6d, 0x6b, 0x6e, 0x6b, 0x70, 0x6b, 0x72, 0x6b, 0x75};
const uint8_t HuffDecoderCommon::table10_118_emit_[72] = {
    0x71, 0x30, 0x71, 0x31, 0x71, 0x32, 0x71, 0x61, 0x71, 0x63, 0x71, 0x65,
    0x71, 0x69, 0x71, 0x6f, 0x71, 0x73, 0x71, 0x74, 0x71, 0x20, 0x71, 0x25,
    0x71, 0x2d, 0x71, 0x2e, 0x71, 0x2f, 0x71, 0x33, 0x71, 0x34, 0x71, 0x35,
    0x71, 0x36, 0x71, 0x37, 0x71, 0x38, 0x71, 0x39, 0x71, 0x3d, 0x71, 0x41,
    0x71, 0x5f, 0x71, 0x62, 0x71, 0x64, 0x71, 0x66, 0x71, 0x67, 0x71, 0x68,
    0x71, 0x6c, 0x71, 0x6d, 0x71, 0x6e, 0x71, 0x70, 0x71, 0x72, 0x71, 0x75};
const uint8_t HuffDecoderCommon::table10_119_emit_[72] = {
    0x76, 0x30, 0x76, 0x31, 0x76, 0x32, 0x76, 0x61, 0x76, 0x63, 0x76, 0x65,
    0x76, 0x69, 0x76, 0x6f, 0x76, 0x73, 0x76, 0x74, 0x76, 0x20, 0x76, 0x25,
    0x76, 0x2d, 0x76, 0x2e, 0x76, 0x2f, 0x76, 0x33, 0x76, 0x34, 0x76, 0x35,
    0x76, 0x36, 0x76, 0x37, 0x76, 0x38, 0x76, 0x39, 0x76, 0x3d, 0x76, 0x41,
    0x76, 0x5f, 0x76, 0x62, 0x76, 0x64, 0x76, 0x66, 0x76, 0x67, 0x76, 0x68,
    0x76, 0x6c, 0x76, 0x6d, 0x76, 0x6e, 0x76, 0x70, 0x76, 0x72, 0x76, 0x75};
const uint8_t HuffDecoderCommon::table10_120_emit_[72] = {
    0x77, 0x30, 0x77, 0x31, 0x77, 0x32, 0x77, 0x61, 0x77, 0x63, 0x77, 0x65,
    0x77, 0x69, 0x77, 0x6f, 0x77, 0x73, 0x77, 0x74, 0x77, 0x20, 0x77, 0x25,
    0x77, 0x2d, 0x77, 0x2e, 0x77, 0x2f, 0x77, 0x33, 0x77, 0x34, 0x77, 0x35,
    0x77, 0x36, 0x77, 0x37, 0x77, 0x38, 0x77, 0x39, 0x77, 0x3d, 0x77, 0x41,
    0x77, 0x5f, 0x77, 0x62, 0x77, 0x64, 0x77, 0x66, 0x77, 0x67, 0x77, 0x68,
    0x77, 0x6c, 0x77, 0x6d, 0x77, 0x6e, 0x77, 0x70, 0x77, 0x72, 0x77, 0x75};
const uint8_t HuffDecoderCommon::table10_121_emit_[72] = {
    0x78, 0x30, 0x78, 0x31, 0x78, 0x32, 0x78, 0x61, 0x78, 0x63, 0x78, 0x65,
    0x78, 0x69, 0x78, 0x6f, 0x78, 0x73, 0x78, 0x74, 0x78, 0x20, 0x78, 0x25,
    0x78, 0x2d, 0x78, 0x2e, 0x78, 0x2f, 0x78, 0x33, 0x78, 0x34, 0x78, 0x35,
    0x78, 0x36, 0x78, 0x37, 0x78, 0x38, 0x78, 0x39, 0x78, 0x3d, 0x78, 0x41,
    0x78, 0x5f, 0x78, 0x62, 0x78, 0x64, 0x78, 0x66, 0x78, 0x67, 0x78, 0x68,
    0x78, 0x6c, 0x78, 0x6d, 0x78, 0x6e, 0x78, 0x70, 0x78, 0x72, 0x78, 0x75};
const uint8_t HuffDecoderCommon::table10_122_emit_[72] = {
    0x79, 0x30, 0x79, 0x31, 0x79, 0x32, 0x79, 0x61, 0x79, 0x63, 0x79, 0x65,
    0x79, 0x69, 0x79, 0x6f, 0x79, 0x73, 0x79, 0x74, 0x79, 0x20, 0x79, 0x25,
    0x79, 0x2d, 0x79, 0x2e, 0x79, 0x2f, 0x79, 0x33, 0x79, 0x34, 0x79, 0x35,
    0x79, 0x36, 0x79, 0x37, 0x79, 0x38, 0x79, 0x39, 0x79, 0x3d, 0x79, 0x41,
    0x79, 0x5f, 0x79, 0x62, 0x79, 0x64, 0x79, 0x66, 0x79, 0x67, 0x79, 0x68,
    0x79, 0x6c, 0x79, 0x6d, 0x79, 0x6e, 0x79, 0x70, 0x79, 0x72, 0x79, 0x75};
const uint8_t HuffDecoderCommon::table10_123_emit_[72] = {
    0x7a, 0x30, 0x7a, 0x31, 0x7a, 0x32, 0x7a, 0x61, 0x7a, 0x63, 0x7a, 0x65,
    0x7a, 0x69, 0x7a, 0x6f, 0x7a, 0x73, 0x7a, 0x74, 0x7a, 0x20, 0x7a, 0x25,
    0x7a, 0x2d, 0x7a, 0x2e, 0x7a, 0x2f, 0x7a, 0x33, 0x7a, 0x34, 0x7a, 0x35,
    0x7a, 0x36, 0x7a, 0x37, 0x7a, 0x38, 0x7a, 0x39, 0x7a, 0x3d, 0x7a, 0x41,
    0x7a, 0x5f, 0x7a, 0x62, 0x7a, 0x64, 0x7a, 0x66, 0x7a, 0x67, 0x7a, 0x68,
    0x7a, 0x6c, 0x7a, 0x6d, 0x7a, 0x6e, 0x7a, 0x70, 0x7a, 0x72, 0x7a, 0x75};
const uint8_t HuffDecoderCommon::table10_124_emit_[40] = {
    0x26, 0x30, 0x26, 0x31, 0x26, 0x32, 0x26, 0x61, 0x26, 0x63,
    0x26, 0x65, 0x26, 0x69, 0x26, 0x6f, 0x26, 0x73, 0x26, 0x74,
    0x2a, 0x30, 0x2a, 0x31, 0x2a, 0x32, 0x2a, 0x61, 0x2a, 0x63,
    0x2a, 0x65, 0x2a, 0x69, 0x2a, 0x6f, 0x2a, 0x73, 0x2a, 0x74};
const uint8_t HuffDecoderCommon::table10_125_emit_[40] = {
    0x2c, 0x30, 0x2c, 0x31, 0x2c, 0x32, 0x2c, 0x61, 0x2c, 0x63,
    0x2c, 0x65, 0x2c, 0x69, 0x2c, 0x6f, 0x2c, 0x73, 0x2c, 0x74,
    0x3b, 0x30, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x61, 0x3b, 0x63,
    0x3b, 0x65, 0x3b, 0x69, 0x3b, 0x6f, 0x3b, 0x73, 0x3b, 0x74};
const uint8_t HuffDecoderCommon::table10_126_emit_[40] = {
    0x58, 0x30, 0x58, 0x31, 0x58, 0x32, 0x58, 0x61, 0x58, 0x63,
    0x58, 0x65, 0x58, 0x69, 0x58, 0x6f, 0x58, 0x73, 0x58, 0x74,
    0x5a, 0x30, 0x5a, 0x31, 0x5a, 0x32, 0x5a, 0x61, 0x5a, 0x63,
    0x5a, 0x65, 0x5a, 0x69, 0x5a, 0x6f, 0x5a, 0x73, 0x5a, 0x74};
const uint8_t HuffDecoderCommon::table10_127_emit_[16] = {
    0x21, 0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c,
    0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e};
const uint16_t HuffDecoderCommon::table10_127_inner_[18] = {
    0x0000, 0x0002, 0x0006, 0x000a, 0x000e, 0x0012, 0x0016, 0x001a, 0x001e,
    0x0022, 0x0026, 0x002a, 0x002e, 0x0032, 0x0036, 0x003a, 0x003e, 0x0003};
const uint8_t HuffDecoderCommon::table10_127_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,  0,  0,  0,  2,  0,  0,  0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,  0,  0,  0,  0,  0,  5,  0, 0, 0, 6,
    0, 0, 0, 7, 0, 0, 0, 8, 0, 9, 0, 10, 11, 12, 13, 14, 15, 16, 0, 17};
const uint8_t* const HuffDecoderCommon::table10_emit_[128] = {
    table9_0_emit_,    table9_1_emit_,    table9_2_emit_,    table10_3_emit_,
    table9_4_emit_,    table9_5_emit_,    table9_6_emit_,    table10_7_emit_,
    table9_8_emit_,    table9_9_emit_,    table9_10_emit_,   table10_11_emit_,
    table9_12_emit_,   table9_13_emit_,   table9_14_emit_,   table10_15_emit_,
    table9_16_emit_,   table9_17_emit_,   table9_18_emit_,   table10_19_emit_,
    table9_20_emit_,   table9_21_emit_,   table9_22_emit_,   table10_23_emit_,
    table9_24_emit_,   table9_25_emit_,   table9_26_emit_,   table10_27_emit_,
    table9_28_emit_,   table9_29_emit_,   table9_30_emit_,   table10_31_emit_,
    table9_32_emit_,   table9_33_emit_,   table9_34_emit_,   table10_35_emit_,
    table9_36_emit_,   table9_37_emit_,   table9_38_emit_,   table10_39_emit_,
    table9_40_emit_,   table10_41_emit_,  table9_42_emit_,   table10_43_emit_,
    table9_44_emit_,   table10_45_emit_,  table9_46_emit_,   table10_47_emit_,
    table9_48_emit_,   table10_49_emit_,  table9_50_emit_,   table10_51_emit_,
    table9_52_emit_,   table10_53_emit_,  table9_54_emit_,   table10_55_emit_,
    table9_56_emit_,   table10_57_emit_,  table9_58_emit_,   table10_59_emit_,
    table9_60_emit_,   table10_61_emit_,  table9_62_emit_,   table10_63_emit_,
    table9_64_emit_,   table10_65_emit_,  table9_66_emit_,   table10_67_emit_,
    table9_68_emit_,   table10_69_emit_,  table9_70_emit_,   table10_71_emit_,
    table9_72_emit_,   table10_73_emit_,  table9_74_emit_,   table10_75_emit_,
    table9_76_emit_,   table10_77_emit_,  table9_78_emit_,   table10_79_emit_,
    table9_80_emit_,   table10_81_emit_,  table9_82_emit_,   table10_83_emit_,
    table9_84_emit_,   table10_85_emit_,  table9_86_emit_,   table10_87_emit_,
    table9_88_emit_,   table10_89_emit_,  table9_90_emit_,   table10_91_emit_,
    table10_92_emit_,  table10_93_emit_,  table10_94_emit_,  table10_95_emit_,
    table10_96_emit_,  table10_97_emit_,  table10_98_emit_,  table10_99_emit_,
    table10_100_emit_, table10_101_emit_, table10_102_emit_, table10_103_emit_,
    table10_104_emit_, table10_105_emit_, table10_106_emit_, table10_107_emit_,
    table10_108_emit_, table10_109_emit_, table10_110_emit_, table10_111_emit_,
    table10_112_emit_, table10_113_emit_, table10_114_emit_, table10_115_emit_,
    table10_116_emit_, table10_117_emit_, table10_118_emit_, table10_119_emit_,
    table10_120_emit_, table10_121_emit_, table10_122_emit_, table10_123_emit_,
    table10_124_emit_, table10_125_emit_, table10_126_emit_, table10_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table10_inner_[128] = {
    table10_0_inner_,  table10_1_inner_,  table10_2_inner_,  table10_3_inner_,
    table10_4_inner_,  table10_1_inner_,  table10_2_inner_,  table10_3_inner_,
    table10_8_inner_,  table10_1_inner_,  table10_2_inner_,  table10_3_inner_,
    table10_12_inner_, table10_1_inner_,  table10_2_inner_,  table10_3_inner_,
    table10_16_inner_, table10_1_inner_,  table10_2_inner_,  table10_3_inner_,
    table10_20_inner_, table10_1_inner_,  table10_2_inner_,  table10_3_inner_,
    table10_24_inner_, table10_1_inner_,  table10_2_inner_,  table10_3_inner_,
    table10_28_inner_, table10_1_inner_,  table10_2_inner_,  table10_3_inner_,
    table10_28_inner_, table10_33_inner_, table10_2_inner_,  table10_3_inner_,
    table10_28_inner_, table10_37_inner_, table10_2_inner_,  table10_3_inner_,
    table10_40_inner_, table10_41_inner_, table10_42_inner_, table10_41_inner_,
    table10_44_inner_, table10_41_inner_, table10_46_inner_, table10_41_inner_,
    table10_48_inner_, table10_41_inner_, table10_50_inner_, table10_41_inner_,
    table10_52_inner_, table10_41_inner_, table10_54_inner_, table10_41_inner_,
    table10_56_inner_, table10_41_inner_, table10_58_inner_, table10_41_inner_,
    table10_60_inner_, table10_41_inner_, table10_62_inner_, table10_41_inner_,
    table10_62_inner_, table10_65_inner_, table10_62_inner_, table10_67_inner_,
    table10_62_inner_, table10_69_inner_, table10_62_inner_, table10_71_inner_,
    table10_62_inner_, table10_73_inner_, table10_62_inner_, table10_75_inner_,
    table10_62_inner_, table10_77_inner_, table10_62_inner_, table10_79_inner_,
    table10_62_inner_, table10_81_inner_, table10_62_inner_, table10_83_inner_,
    table10_62_inner_, table10_85_inner_, table10_62_inner_, table10_87_inner_,
    table10_62_inner_, table10_89_inner_, table10_62_inner_, table10_91_inner_,
    table10_92_inner_, table10_92_inner_, table10_92_inner_, table10_92_inner_,
    table10_92_inner_, table10_92_inner_, table10_92_inner_, table10_92_inner_,
    table10_92_inner_, table10_92_inner_, table10_92_inner_, table10_92_inner_,
    table10_92_inner_, table10_92_inner_, table10_92_inner_, table10_92_inner_,
    table10_92_inner_, table10_92_inner_, table10_92_inner_, table10_92_inner_,
    table10_92_inner_, table10_92_inner_, table10_92_inner_, table10_92_inner_,
    table10_92_inner_, table10_92_inner_, table10_92_inner_, table10_92_inner_,
    table10_92_inner_, table10_92_inner_, table10_92_inner_, table10_92_inner_,
    table8_10_inner_,  table8_10_inner_,  table8_10_inner_,  table10_127_inner_,
};
const uint8_t* const HuffDecoderCommon::table10_outer_[128] = {
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_10_outer_,  table8_10_outer_,  table8_10_outer_,  table10_127_outer_,
};
const uint8_t HuffDecoderCommon::table11_0_emit_[7] = {0x30, 0x30, 0x31, 0x30,
                                                       0x32, 0x30, 0x61};
const uint16_t HuffDecoderCommon::table11_0_inner_[5] = {0x0000, 0x0001, 0x0005,
                                                         0x000d, 0x0015};
const uint8_t HuffDecoderCommon::table11_1_emit_[8] = {0x30, 0x63, 0x30, 0x65,
                                                       0x30, 0x69, 0x30, 0x6f};
const uint16_t HuffDecoderCommon::table11_1_inner_[5] = {0x0000, 0x0001, 0x0009,
                                                         0x0011, 0x0019};
const uint8_t HuffDecoderCommon::table11_2_emit_[12] = {
    0x30, 0x73, 0x30, 0x74, 0x30, 0x20, 0x30, 0x25, 0x30, 0x2d, 0x30, 0x2e};
const uint16_t HuffDecoderCommon::table11_2_inner_[7] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029};
const uint8_t HuffDecoderCommon::table11_2_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 6};
const uint8_t HuffDecoderCommon::table11_3_emit_[16] = {
    0x30, 0x2f, 0x30, 0x33, 0x30, 0x34, 0x30, 0x35,
    0x30, 0x36, 0x30, 0x37, 0x30, 0x38, 0x30, 0x39};
const uint8_t HuffDecoderCommon::table11_4_emit_[16] = {
    0x30, 0x3d, 0x30, 0x41, 0x30, 0x5f, 0x30, 0x62,
    0x30, 0x64, 0x30, 0x66, 0x30, 0x67, 0x30, 0x68};
const uint8_t HuffDecoderCommon::table11_5_emit_[20] = {
    0x30, 0x6c, 0x30, 0x6d, 0x30, 0x6e, 0x30, 0x70, 0x30, 0x72,
    0x30, 0x75, 0x30, 0x3a, 0x30, 0x42, 0x30, 0x43, 0x30, 0x44};
const uint16_t HuffDecoderCommon::table11_5_inner_[11] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021,
    0x0029, 0x0031, 0x0039, 0x0041, 0x0049};
const uint8_t HuffDecoderCommon::table11_5_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0,
    0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 9, 0, 0, 0, 10};
const uint8_t HuffDecoderCommon::table11_6_emit_[32] = {
    0x30, 0x45, 0x30, 0x46, 0x30, 0x47, 0x30, 0x48, 0x30, 0x49, 0x30,
    0x4a, 0x30, 0x4b, 0x30, 0x4c, 0x30, 0x4d, 0x30, 0x4e, 0x30, 0x4f,
    0x30, 0x50, 0x30, 0x51, 0x30, 0x52, 0x30, 0x53, 0x30, 0x54};
const uint16_t HuffDecoderCommon::table11_6_inner_[17] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079};
const uint8_t HuffDecoderCommon::table11_6_outer_[64] = {
    0, 0, 0, 1,  0, 0, 0, 2,  0, 0, 0, 3,  0, 0, 0, 4,  0, 0,  0, 5, 0, 0,
    0, 6, 0, 0,  0, 7, 0, 0,  0, 8, 0, 0,  0, 9, 0, 0,  0, 10, 0, 0, 0, 11,
    0, 0, 0, 12, 0, 0, 0, 13, 0, 0, 0, 14, 0, 0, 0, 15, 0, 0,  0, 16};
const uint8_t HuffDecoderCommon::table11_7_emit_[36] = {
    0x30, 0x55, 0x30, 0x56, 0x30, 0x57, 0x30, 0x59, 0x30, 0x6a, 0x30, 0x6b,
    0x30, 0x71, 0x30, 0x76, 0x30, 0x77, 0x30, 0x78, 0x30, 0x79, 0x30, 0x7a,
    0x30, 0x26, 0x30, 0x2a, 0x30, 0x2c, 0x30, 0x3b, 0x30, 0x58, 0x30, 0x5a};
const uint16_t HuffDecoderCommon::table11_7_inner_[20] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061,
    0x0069, 0x0071, 0x0079, 0x0081, 0x0089, 0x0002};
const uint8_t HuffDecoderCommon::table11_7_outer_[64] = {
    0, 0, 0, 1,  0, 0,  0, 2,  0, 0,  0, 3,  0, 0,  0, 4,  0, 0,  0, 5, 0, 0,
    0, 6, 0, 0,  0, 7,  0, 0,  0, 8,  0, 0,  0, 9,  0, 0,  0, 10, 0, 0, 0, 11,
    0, 0, 0, 12, 0, 13, 0, 14, 0, 15, 0, 16, 0, 17, 0, 18, 0, 0,  0, 19};
const uint8_t HuffDecoderCommon::table11_8_emit_[7] = {0x31, 0x30, 0x31, 0x31,
                                                       0x32, 0x31, 0x61};
const uint16_t HuffDecoderCommon::table11_8_inner_[5] = {0x0000, 0x0001, 0x0009,
                                                         0x000d, 0x0015};
const uint8_t HuffDecoderCommon::table11_9_emit_[8] = {0x31, 0x63, 0x31, 0x65,
                                                       0x31, 0x69, 0x31, 0x6f};
const uint8_t HuffDecoderCommon::table11_10_emit_[12] = {
    0x31, 0x73, 0x31, 0x74, 0x31, 0x20, 0x31, 0x25, 0x31, 0x2d, 0x31, 0x2e};
const uint8_t HuffDecoderCommon::table11_11_emit_[16] = {
    0x31, 0x2f, 0x31, 0x33, 0x31, 0x34, 0x31, 0x35,
    0x31, 0x36, 0x31, 0x37, 0x31, 0x38, 0x31, 0x39};
const uint8_t HuffDecoderCommon::table11_12_emit_[16] = {
    0x31, 0x3d, 0x31, 0x41, 0x31, 0x5f, 0x31, 0x62,
    0x31, 0x64, 0x31, 0x66, 0x31, 0x67, 0x31, 0x68};
const uint8_t HuffDecoderCommon::table11_13_emit_[20] = {
    0x31, 0x6c, 0x31, 0x6d, 0x31, 0x6e, 0x31, 0x70, 0x31, 0x72,
    0x31, 0x75, 0x31, 0x3a, 0x31, 0x42, 0x31, 0x43, 0x31, 0x44};
const uint8_t HuffDecoderCommon::table11_14_emit_[32] = {
    0x31, 0x45, 0x31, 0x46, 0x31, 0x47, 0x31, 0x48, 0x31, 0x49, 0x31,
    0x4a, 0x31, 0x4b, 0x31, 0x4c, 0x31, 0x4d, 0x31, 0x4e, 0x31, 0x4f,
    0x31, 0x50, 0x31, 0x51, 0x31, 0x52, 0x31, 0x53, 0x31, 0x54};
const uint8_t HuffDecoderCommon::table11_15_emit_[36] = {
    0x31, 0x55, 0x31, 0x56, 0x31, 0x57, 0x31, 0x59, 0x31, 0x6a, 0x31, 0x6b,
    0x31, 0x71, 0x31, 0x76, 0x31, 0x77, 0x31, 0x78, 0x31, 0x79, 0x31, 0x7a,
    0x31, 0x26, 0x31, 0x2a, 0x31, 0x2c, 0x31, 0x3b, 0x31, 0x58, 0x31, 0x5a};
const uint8_t HuffDecoderCommon::table11_16_emit_[7] = {0x32, 0x30, 0x32, 0x31,
                                                        0x32, 0x32, 0x61};
const uint16_t HuffDecoderCommon::table11_16_inner_[5] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0015};
const uint8_t HuffDecoderCommon::table11_17_emit_[8] = {0x32, 0x63, 0x32, 0x65,
                                                        0x32, 0x69, 0x32, 0x6f};
const uint8_t HuffDecoderCommon::table11_18_emit_[12] = {
    0x32, 0x73, 0x32, 0x74, 0x32, 0x20, 0x32, 0x25, 0x32, 0x2d, 0x32, 0x2e};
const uint8_t HuffDecoderCommon::table11_19_emit_[16] = {
    0x32, 0x2f, 0x32, 0x33, 0x32, 0x34, 0x32, 0x35,
    0x32, 0x36, 0x32, 0x37, 0x32, 0x38, 0x32, 0x39};
const uint8_t HuffDecoderCommon::table11_20_emit_[16] = {
    0x32, 0x3d, 0x32, 0x41, 0x32, 0x5f, 0x32, 0x62,
    0x32, 0x64, 0x32, 0x66, 0x32, 0x67, 0x32, 0x68};
const uint8_t HuffDecoderCommon::table11_21_emit_[20] = {
    0x32, 0x6c, 0x32, 0x6d, 0x32, 0x6e, 0x32, 0x70, 0x32, 0x72,
    0x32, 0x75, 0x32, 0x3a, 0x32, 0x42, 0x32, 0x43, 0x32, 0x44};
const uint8_t HuffDecoderCommon::table11_22_emit_[32] = {
    0x32, 0x45, 0x32, 0x46, 0x32, 0x47, 0x32, 0x48, 0x32, 0x49, 0x32,
    0x4a, 0x32, 0x4b, 0x32, 0x4c, 0x32, 0x4d, 0x32, 0x4e, 0x32, 0x4f,
    0x32, 0x50, 0x32, 0x51, 0x32, 0x52, 0x32, 0x53, 0x32, 0x54};
const uint8_t HuffDecoderCommon::table11_23_emit_[36] = {
    0x32, 0x55, 0x32, 0x56, 0x32, 0x57, 0x32, 0x59, 0x32, 0x6a, 0x32, 0x6b,
    0x32, 0x71, 0x32, 0x76, 0x32, 0x77, 0x32, 0x78, 0x32, 0x79, 0x32, 0x7a,
    0x32, 0x26, 0x32, 0x2a, 0x32, 0x2c, 0x32, 0x3b, 0x32, 0x58, 0x32, 0x5a};
const uint8_t HuffDecoderCommon::table11_24_emit_[8] = {0x61, 0x30, 0x61, 0x31,
                                                        0x61, 0x32, 0x61, 0x61};
const uint8_t HuffDecoderCommon::table11_25_emit_[8] = {0x61, 0x63, 0x61, 0x65,
                                                        0x61, 0x69, 0x61, 0x6f};
const uint8_t HuffDecoderCommon::table11_26_emit_[12] = {
    0x61, 0x73, 0x61, 0x74, 0x61, 0x20, 0x61, 0x25, 0x61, 0x2d, 0x61, 0x2e};
const uint8_t HuffDecoderCommon::table11_27_emit_[16] = {
    0x61, 0x2f, 0x61, 0x33, 0x61, 0x34, 0x61, 0x35,
    0x61, 0x36, 0x61, 0x37, 0x61, 0x38, 0x61, 0x39};
const uint8_t HuffDecoderCommon::table11_28_emit_[16] = {
    0x61, 0x3d, 0x61, 0x41, 0x61, 0x5f, 0x61, 0x62,
    0x61, 0x64, 0x61, 0x66, 0x61, 0x67, 0x61, 0x68};
const uint8_t HuffDecoderCommon::table11_29_emit_[20] = {
    0x61, 0x6c, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x70, 0x61, 0x72,
    0x61, 0x75, 0x61, 0x3a, 0x61, 0x42, 0x61, 0x43, 0x61, 0x44};
const uint8_t HuffDecoderCommon::table11_30_emit_[32] = {
    0x61, 0x45, 0x61, 0x46, 0x61, 0x47, 0x61, 0x48, 0x61, 0x49, 0x61,
    0x4a, 0x61, 0x4b, 0x61, 0x4c, 0x61, 0x4d, 0x61, 0x4e, 0x61, 0x4f,
    0x61, 0x50, 0x61, 0x51, 0x61, 0x52, 0x61, 0x53, 0x61, 0x54};
const uint8_t HuffDecoderCommon::table11_31_emit_[36] = {
    0x61, 0x55, 0x61, 0x56, 0x61, 0x57, 0x61, 0x59, 0x61, 0x6a, 0x61, 0x6b,
    0x61, 0x71, 0x61, 0x76, 0x61, 0x77, 0x61, 0x78, 0x61, 0x79, 0x61, 0x7a,
    0x61, 0x26, 0x61, 0x2a, 0x61, 0x2c, 0x61, 0x3b, 0x61, 0x58, 0x61, 0x5a};
const uint8_t HuffDecoderCommon::table11_32_emit_[8] = {0x63, 0x30, 0x63, 0x31,
                                                        0x63, 0x32, 0x63, 0x61};
const uint8_t HuffDecoderCommon::table11_33_emit_[7] = {0x63, 0x63, 0x65, 0x63,
                                                        0x69, 0x63, 0x6f};
const uint8_t HuffDecoderCommon::table11_34_emit_[12] = {
    0x63, 0x73, 0x63, 0x74, 0x63, 0x20, 0x63, 0x25, 0x63, 0x2d, 0x63, 0x2e};
const uint8_t HuffDecoderCommon::table11_35_emit_[16] = {
    0x63, 0x2f, 0x63, 0x33, 0x63, 0x34, 0x63, 0x35,
    0x63, 0x36, 0x63, 0x37, 0x63, 0x38, 0x63, 0x39};
const uint8_t HuffDecoderCommon::table11_36_emit_[16] = {
    0x63, 0x3d, 0x63, 0x41, 0x63, 0x5f, 0x63, 0x62,
    0x63, 0x64, 0x63, 0x66, 0x63, 0x67, 0x63, 0x68};
const uint8_t HuffDecoderCommon::table11_37_emit_[20] = {
    0x63, 0x6c, 0x63, 0x6d, 0x63, 0x6e, 0x63, 0x70, 0x63, 0x72,
    0x63, 0x75, 0x63, 0x3a, 0x63, 0x42, 0x63, 0x43, 0x63, 0x44};
const uint8_t HuffDecoderCommon::table11_38_emit_[32] = {
    0x63, 0x45, 0x63, 0x46, 0x63, 0x47, 0x63, 0x48, 0x63, 0x49, 0x63,
    0x4a, 0x63, 0x4b, 0x63, 0x4c, 0x63, 0x4d, 0x63, 0x4e, 0x63, 0x4f,
    0x63, 0x50, 0x63, 0x51, 0x63, 0x52, 0x63, 0x53, 0x63, 0x54};
const uint8_t HuffDecoderCommon::table11_39_emit_[36] = {
    0x63, 0x55, 0x63, 0x56, 0x63, 0x57, 0x63, 0x59, 0x63, 0x6a, 0x63, 0x6b,
    0x63, 0x71, 0x63, 0x76, 0x63, 0x77, 0x63, 0x78, 0x63, 0x79, 0x63, 0x7a,
    0x63, 0x26, 0x63, 0x2a, 0x63, 0x2c, 0x63, 0x3b, 0x63, 0x58, 0x63, 0x5a};
const uint8_t HuffDecoderCommon::table11_40_emit_[8] = {0x65, 0x30, 0x65, 0x31,
                                                        0x65, 0x32, 0x65, 0x61};
const uint8_t HuffDecoderCommon::table11_41_emit_[7] = {0x65, 0x63, 0x65, 0x65,
                                                        0x69, 0x65, 0x6f};
const uint8_t HuffDecoderCommon::table11_42_emit_[12] = {
    0x65, 0x73, 0x65, 0x74, 0x65, 0x20, 0x65, 0x25, 0x65, 0x2d, 0x65, 0x2e};
const uint8_t HuffDecoderCommon::table11_43_emit_[16] = {
    0x65, 0x2f, 0x65, 0x33, 0x65, 0x34, 0x65, 0x35,
    0x65, 0x36, 0x65, 0x37, 0x65, 0x38, 0x65, 0x39};
const uint8_t HuffDecoderCommon::table11_44_emit_[16] = {
    0x65, 0x3d, 0x65, 0x41, 0x65, 0x5f, 0x65, 0x62,
    0x65, 0x64, 0x65, 0x66, 0x65, 0x67, 0x65, 0x68};
const uint8_t HuffDecoderCommon::table11_45_emit_[20] = {
    0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x70, 0x65, 0x72,
    0x65, 0x75, 0x65, 0x3a, 0x65, 0x42, 0x65, 0x43, 0x65, 0x44};
const uint8_t HuffDecoderCommon::table11_46_emit_[32] = {
    0x65, 0x45, 0x65, 0x46, 0x65, 0x47, 0x65, 0x48, 0x65, 0x49, 0x65,
    0x4a, 0x65, 0x4b, 0x65, 0x4c, 0x65, 0x4d, 0x65, 0x4e, 0x65, 0x4f,
    0x65, 0x50, 0x65, 0x51, 0x65, 0x52, 0x65, 0x53, 0x65, 0x54};
const uint8_t HuffDecoderCommon::table11_47_emit_[36] = {
    0x65, 0x55, 0x65, 0x56, 0x65, 0x57, 0x65, 0x59, 0x65, 0x6a, 0x65, 0x6b,
    0x65, 0x71, 0x65, 0x76, 0x65, 0x77, 0x65, 0x78, 0x65, 0x79, 0x65, 0x7a,
    0x65, 0x26, 0x65, 0x2a, 0x65, 0x2c, 0x65, 0x3b, 0x65, 0x58, 0x65, 0x5a};
const uint8_t HuffDecoderCommon::table11_48_emit_[8] = {0x69, 0x30, 0x69, 0x31,
                                                        0x69, 0x32, 0x69, 0x61};
const uint8_t HuffDecoderCommon::table11_49_emit_[7] = {0x69, 0x63, 0x69, 0x65,
                                                        0x69, 0x69, 0x6f};
const uint8_t HuffDecoderCommon::table11_50_emit_[12] = {
    0x69, 0x73, 0x69, 0x74, 0x69, 0x20, 0x69, 0x25, 0x69, 0x2d, 0x69, 0x2e};
const uint8_t HuffDecoderCommon::table11_51_emit_[16] = {
    0x69, 0x2f, 0x69, 0x33, 0x69, 0x34, 0x69, 0x35,
    0x69, 0x36, 0x69, 0x37, 0x69, 0x38, 0x69, 0x39};
const uint8_t HuffDecoderCommon::table11_52_emit_[16] = {
    0x69, 0x3d, 0x69, 0x41, 0x69, 0x5f, 0x69, 0x62,
    0x69, 0x64, 0x69, 0x66, 0x69, 0x67, 0x69, 0x68};
const uint8_t HuffDecoderCommon::table11_53_emit_[20] = {
    0x69, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x69, 0x70, 0x69, 0x72,
    0x69, 0x75, 0x69, 0x3a, 0x69, 0x42, 0x69, 0x43, 0x69, 0x44};
const uint8_t HuffDecoderCommon::table11_54_emit_[32] = {
    0x69, 0x45, 0x69, 0x46, 0x69, 0x47, 0x69, 0x48, 0x69, 0x49, 0x69,
    0x4a, 0x69, 0x4b, 0x69, 0x4c, 0x69, 0x4d, 0x69, 0x4e, 0x69, 0x4f,
    0x69, 0x50, 0x69, 0x51, 0x69, 0x52, 0x69, 0x53, 0x69, 0x54};
const uint8_t HuffDecoderCommon::table11_55_emit_[36] = {
    0x69, 0x55, 0x69, 0x56, 0x69, 0x57, 0x69, 0x59, 0x69, 0x6a, 0x69, 0x6b,
    0x69, 0x71, 0x69, 0x76, 0x69, 0x77, 0x69, 0x78, 0x69, 0x79, 0x69, 0x7a,
    0x69, 0x26, 0x69, 0x2a, 0x69, 0x2c, 0x69, 0x3b, 0x69, 0x58, 0x69, 0x5a};
const uint8_t HuffDecoderCommon::table11_56_emit_[8] = {0x6f, 0x30, 0x6f, 0x31,
                                                        0x6f, 0x32, 0x6f, 0x61};
const uint8_t HuffDecoderCommon::table11_57_emit_[8] = {0x6f, 0x63, 0x6f, 0x65,
                                                        0x6f, 0x69, 0x6f, 0x6f};
const uint8_t HuffDecoderCommon::table11_58_emit_[12] = {
    0x6f, 0x73, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x25, 0x6f, 0x2d, 0x6f, 0x2e};
const uint8_t HuffDecoderCommon::table11_59_emit_[16] = {
    0x6f, 0x2f, 0x6f, 0x33, 0x6f, 0x34, 0x6f, 0x35,
    0x6f, 0x36, 0x6f, 0x37, 0x6f, 0x38, 0x6f, 0x39};
const uint8_t HuffDecoderCommon::table11_60_emit_[16] = {
    0x6f, 0x3d, 0x6f, 0x41, 0x6f, 0x5f, 0x6f, 0x62,
    0x6f, 0x64, 0x6f, 0x66, 0x6f, 0x67, 0x6f, 0x68};
const uint8_t HuffDecoderCommon::table11_61_emit_[20] = {
    0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x6f, 0x70, 0x6f, 0x72,
    0x6f, 0x75, 0x6f, 0x3a, 0x6f, 0x42, 0x6f, 0x43, 0x6f, 0x44};
const uint8_t HuffDecoderCommon::table11_62_emit_[32] = {
    0x6f, 0x45, 0x6f, 0x46, 0x6f, 0x47, 0x6f, 0x48, 0x6f, 0x49, 0x6f,
    0x4a, 0x6f, 0x4b, 0x6f, 0x4c, 0x6f, 0x4d, 0x6f, 0x4e, 0x6f, 0x4f,
    0x6f, 0x50, 0x6f, 0x51, 0x6f, 0x52, 0x6f, 0x53, 0x6f, 0x54};
const uint8_t HuffDecoderCommon::table11_63_emit_[36] = {
    0x6f, 0x55, 0x6f, 0x56, 0x6f, 0x57, 0x6f, 0x59, 0x6f, 0x6a, 0x6f, 0x6b,
    0x6f, 0x71, 0x6f, 0x76, 0x6f, 0x77, 0x6f, 0x78, 0x6f, 0x79, 0x6f, 0x7a,
    0x6f, 0x26, 0x6f, 0x2a, 0x6f, 0x2c, 0x6f, 0x3b, 0x6f, 0x58, 0x6f, 0x5a};
const uint8_t HuffDecoderCommon::table11_64_emit_[8] = {0x73, 0x30, 0x73, 0x31,
                                                        0x73, 0x32, 0x73, 0x61};
const uint8_t HuffDecoderCommon::table11_65_emit_[8] = {0x73, 0x63, 0x73, 0x65,
                                                        0x73, 0x69, 0x73, 0x6f};
const uint8_t HuffDecoderCommon::table11_66_emit_[11] = {
    0x73, 0x73, 0x74, 0x73, 0x20, 0x73, 0x25, 0x73, 0x2d, 0x73, 0x2e};
const uint16_t HuffDecoderCommon::table11_66_inner_[7] = {
    0x0000, 0x0001, 0x0005, 0x000d, 0x0015, 0x001d, 0x0025};
const uint8_t HuffDecoderCommon::table11_67_emit_[16] = {
    0x73, 0x2f, 0x73, 0x33, 0x73, 0x34, 0x73, 0x35,
    0x73, 0x36, 0x73, 0x37, 0x73, 0x38, 0x73, 0x39};
const uint8_t HuffDecoderCommon::table11_68_emit_[16] = {
    0x73, 0x3d, 0x73, 0x41, 0x73, 0x5f, 0x73, 0x62,
    0x73, 0x64, 0x73, 0x66, 0x73, 0x67, 0x73, 0x68};
const uint8_t HuffDecoderCommon::table11_69_emit_[20] = {
    0x73, 0x6c, 0x73, 0x6d, 0x73, 0x6e, 0x73, 0x70, 0x73, 0x72,
    0x73, 0x75, 0x73, 0x3a, 0x73, 0x42, 0x73, 0x43, 0x73, 0x44};
const uint8_t HuffDecoderCommon::table11_70_emit_[32] = {
    0x73, 0x45, 0x73, 0x46, 0x73, 0x47, 0x73, 0x48, 0x73, 0x49, 0x73,
    0x4a, 0x73, 0x4b, 0x73, 0x4c, 0x73, 0x4d, 0x73, 0x4e, 0x73, 0x4f,
    0x73, 0x50, 0x73, 0x51, 0x73, 0x52, 0x73, 0x53, 0x73, 0x54};
const uint8_t HuffDecoderCommon::table11_71_emit_[36] = {
    0x73, 0x55, 0x73, 0x56, 0x73, 0x57, 0x73, 0x59, 0x73, 0x6a, 0x73, 0x6b,
    0x73, 0x71, 0x73, 0x76, 0x73, 0x77, 0x73, 0x78, 0x73, 0x79, 0x73, 0x7a,
    0x73, 0x26, 0x73, 0x2a, 0x73, 0x2c, 0x73, 0x3b, 0x73, 0x58, 0x73, 0x5a};
const uint8_t HuffDecoderCommon::table11_72_emit_[8] = {0x74, 0x30, 0x74, 0x31,
                                                        0x74, 0x32, 0x74, 0x61};
const uint8_t HuffDecoderCommon::table11_73_emit_[8] = {0x74, 0x63, 0x74, 0x65,
                                                        0x74, 0x69, 0x74, 0x6f};
const uint8_t HuffDecoderCommon::table11_74_emit_[11] = {
    0x74, 0x73, 0x74, 0x74, 0x20, 0x74, 0x25, 0x74, 0x2d, 0x74, 0x2e};
const uint16_t HuffDecoderCommon::table11_74_inner_[7] = {
    0x0000, 0x0001, 0x0009, 0x000d, 0x0015, 0x001d, 0x0025};
const uint8_t HuffDecoderCommon::table11_75_emit_[16] = {
    0x74, 0x2f, 0x74, 0x33, 0x74, 0x34, 0x74, 0x35,
    0x74, 0x36, 0x74, 0x37, 0x74, 0x38, 0x74, 0x39};
const uint8_t HuffDecoderCommon::table11_76_emit_[16] = {
    0x74, 0x3d, 0x74, 0x41, 0x74, 0x5f, 0x74, 0x62,
    0x74, 0x64, 0x74, 0x66, 0x74, 0x67, 0x74, 0x68};
const uint8_t HuffDecoderCommon::table11_77_emit_[20] = {
    0x74, 0x6c, 0x74, 0x6d, 0x74, 0x6e, 0x74, 0x70, 0x74, 0x72,
    0x74, 0x75, 0x74, 0x3a, 0x74, 0x42, 0x74, 0x43, 0x74, 0x44};
const uint8_t HuffDecoderCommon::table11_78_emit_[32] = {
    0x74, 0x45, 0x74, 0x46, 0x74, 0x47, 0x74, 0x48, 0x74, 0x49, 0x74,
    0x4a, 0x74, 0x4b, 0x74, 0x4c, 0x74, 0x4d, 0x74, 0x4e, 0x74, 0x4f,
    0x74, 0x50, 0x74, 0x51, 0x74, 0x52, 0x74, 0x53, 0x74, 0x54};
const uint8_t HuffDecoderCommon::table11_79_emit_[36] = {
    0x74, 0x55, 0x74, 0x56, 0x74, 0x57, 0x74, 0x59, 0x74, 0x6a, 0x74, 0x6b,
    0x74, 0x71, 0x74, 0x76, 0x74, 0x77, 0x74, 0x78, 0x74, 0x79, 0x74, 0x7a,
    0x74, 0x26, 0x74, 0x2a, 0x74, 0x2c, 0x74, 0x3b, 0x74, 0x58, 0x74, 0x5a};
const uint8_t HuffDecoderCommon::table11_80_emit_[16] = {
    0x20, 0x30, 0x20, 0x31, 0x20, 0x32, 0x20, 0x61,
    0x20, 0x63, 0x20, 0x65, 0x20, 0x69, 0x20, 0x6f};
const uint8_t HuffDecoderCommon::table11_81_emit_[27] = {
    0x20, 0x73, 0x20, 0x74, 0x20, 0x20, 0x25, 0x20, 0x2d,
    0x20, 0x2e, 0x20, 0x2f, 0x20, 0x33, 0x20, 0x34, 0x20,
    0x35, 0x20, 0x36, 0x20, 0x37, 0x20, 0x38, 0x20, 0x39};
const uint16_t HuffDecoderCommon::table11_81_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_82_emit_[36] = {
    0x20, 0x3d, 0x20, 0x41, 0x20, 0x5f, 0x20, 0x62, 0x20, 0x64, 0x20, 0x66,
    0x20, 0x67, 0x20, 0x68, 0x20, 0x6c, 0x20, 0x6d, 0x20, 0x6e, 0x20, 0x70,
    0x20, 0x72, 0x20, 0x75, 0x20, 0x3a, 0x20, 0x42, 0x20, 0x43, 0x20, 0x44};
const uint8_t HuffDecoderCommon::table11_83_emit_[68] = {
    0x20, 0x45, 0x20, 0x46, 0x20, 0x47, 0x20, 0x48, 0x20, 0x49, 0x20, 0x4a,
    0x20, 0x4b, 0x20, 0x4c, 0x20, 0x4d, 0x20, 0x4e, 0x20, 0x4f, 0x20, 0x50,
    0x20, 0x51, 0x20, 0x52, 0x20, 0x53, 0x20, 0x54, 0x20, 0x55, 0x20, 0x56,
    0x20, 0x57, 0x20, 0x59, 0x20, 0x6a, 0x20, 0x6b, 0x20, 0x71, 0x20, 0x76,
    0x20, 0x77, 0x20, 0x78, 0x20, 0x79, 0x20, 0x7a, 0x20, 0x26, 0x20, 0x2a,
    0x20, 0x2c, 0x20, 0x3b, 0x20, 0x58, 0x20, 0x5a};
const uint8_t HuffDecoderCommon::table11_84_emit_[16] = {
    0x25, 0x30, 0x25, 0x31, 0x25, 0x32, 0x25, 0x61,
    0x25, 0x63, 0x25, 0x65, 0x25, 0x69, 0x25, 0x6f};
const uint8_t HuffDecoderCommon::table11_85_emit_[27] = {
    0x25, 0x73, 0x25, 0x74, 0x25, 0x20, 0x25, 0x25, 0x2d,
    0x25, 0x2e, 0x25, 0x2f, 0x25, 0x33, 0x25, 0x34, 0x25,
    0x35, 0x25, 0x36, 0x25, 0x37, 0x25, 0x38, 0x25, 0x39};
const uint16_t HuffDecoderCommon::table11_85_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_86_emit_[36] = {
    0x25, 0x3d, 0x25, 0x41, 0x25, 0x5f, 0x25, 0x62, 0x25, 0x64, 0x25, 0x66,
    0x25, 0x67, 0x25, 0x68, 0x25, 0x6c, 0x25, 0x6d, 0x25, 0x6e, 0x25, 0x70,
    0x25, 0x72, 0x25, 0x75, 0x25, 0x3a, 0x25, 0x42, 0x25, 0x43, 0x25, 0x44};
const uint8_t HuffDecoderCommon::table11_87_emit_[68] = {
    0x25, 0x45, 0x25, 0x46, 0x25, 0x47, 0x25, 0x48, 0x25, 0x49, 0x25, 0x4a,
    0x25, 0x4b, 0x25, 0x4c, 0x25, 0x4d, 0x25, 0x4e, 0x25, 0x4f, 0x25, 0x50,
    0x25, 0x51, 0x25, 0x52, 0x25, 0x53, 0x25, 0x54, 0x25, 0x55, 0x25, 0x56,
    0x25, 0x57, 0x25, 0x59, 0x25, 0x6a, 0x25, 0x6b, 0x25, 0x71, 0x25, 0x76,
    0x25, 0x77, 0x25, 0x78, 0x25, 0x79, 0x25, 0x7a, 0x25, 0x26, 0x25, 0x2a,
    0x25, 0x2c, 0x25, 0x3b, 0x25, 0x58, 0x25, 0x5a};
const uint8_t HuffDecoderCommon::table11_88_emit_[16] = {
    0x2d, 0x30, 0x2d, 0x31, 0x2d, 0x32, 0x2d, 0x61,
    0x2d, 0x63, 0x2d, 0x65, 0x2d, 0x69, 0x2d, 0x6f};
const uint8_t HuffDecoderCommon::table11_89_emit_[27] = {
    0x2d, 0x73, 0x2d, 0x74, 0x2d, 0x20, 0x2d, 0x25, 0x2d,
    0x2d, 0x2e, 0x2d, 0x2f, 0x2d, 0x33, 0x2d, 0x34, 0x2d,
    0x35, 0x2d, 0x36, 0x2d, 0x37, 0x2d, 0x38, 0x2d, 0x39};
const uint16_t HuffDecoderCommon::table11_89_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_90_emit_[36] = {
    0x2d, 0x3d, 0x2d, 0x41, 0x2d, 0x5f, 0x2d, 0x62, 0x2d, 0x64, 0x2d, 0x66,
    0x2d, 0x67, 0x2d, 0x68, 0x2d, 0x6c, 0x2d, 0x6d, 0x2d, 0x6e, 0x2d, 0x70,
    0x2d, 0x72, 0x2d, 0x75, 0x2d, 0x3a, 0x2d, 0x42, 0x2d, 0x43, 0x2d, 0x44};
const uint8_t HuffDecoderCommon::table11_91_emit_[68] = {
    0x2d, 0x45, 0x2d, 0x46, 0x2d, 0x47, 0x2d, 0x48, 0x2d, 0x49, 0x2d, 0x4a,
    0x2d, 0x4b, 0x2d, 0x4c, 0x2d, 0x4d, 0x2d, 0x4e, 0x2d, 0x4f, 0x2d, 0x50,
    0x2d, 0x51, 0x2d, 0x52, 0x2d, 0x53, 0x2d, 0x54, 0x2d, 0x55, 0x2d, 0x56,
    0x2d, 0x57, 0x2d, 0x59, 0x2d, 0x6a, 0x2d, 0x6b, 0x2d, 0x71, 0x2d, 0x76,
    0x2d, 0x77, 0x2d, 0x78, 0x2d, 0x79, 0x2d, 0x7a, 0x2d, 0x26, 0x2d, 0x2a,
    0x2d, 0x2c, 0x2d, 0x3b, 0x2d, 0x58, 0x2d, 0x5a};
const uint8_t HuffDecoderCommon::table11_92_emit_[16] = {
    0x2e, 0x30, 0x2e, 0x31, 0x2e, 0x32, 0x2e, 0x61,
    0x2e, 0x63, 0x2e, 0x65, 0x2e, 0x69, 0x2e, 0x6f};
const uint8_t HuffDecoderCommon::table11_93_emit_[27] = {
    0x2e, 0x73, 0x2e, 0x74, 0x2e, 0x20, 0x2e, 0x25, 0x2e,
    0x2d, 0x2e, 0x2e, 0x2f, 0x2e, 0x33, 0x2e, 0x34, 0x2e,
    0x35, 0x2e, 0x36, 0x2e, 0x37, 0x2e, 0x38, 0x2e, 0x39};
const uint16_t HuffDecoderCommon::table11_93_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_94_emit_[36] = {
    0x2e, 0x3d, 0x2e, 0x41, 0x2e, 0x5f, 0x2e, 0x62, 0x2e, 0x64, 0x2e, 0x66,
    0x2e, 0x67, 0x2e, 0x68, 0x2e, 0x6c, 0x2e, 0x6d, 0x2e, 0x6e, 0x2e, 0x70,
    0x2e, 0x72, 0x2e, 0x75, 0x2e, 0x3a, 0x2e, 0x42, 0x2e, 0x43, 0x2e, 0x44};
const uint8_t HuffDecoderCommon::table11_95_emit_[68] = {
    0x2e, 0x45, 0x2e, 0x46, 0x2e, 0x47, 0x2e, 0x48, 0x2e, 0x49, 0x2e, 0x4a,
    0x2e, 0x4b, 0x2e, 0x4c, 0x2e, 0x4d, 0x2e, 0x4e, 0x2e, 0x4f, 0x2e, 0x50,
    0x2e, 0x51, 0x2e, 0x52, 0x2e, 0x53, 0x2e, 0x54, 0x2e, 0x55, 0x2e, 0x56,
    0x2e, 0x57, 0x2e, 0x59, 0x2e, 0x6a, 0x2e, 0x6b, 0x2e, 0x71, 0x2e, 0x76,
    0x2e, 0x77, 0x2e, 0x78, 0x2e, 0x79, 0x2e, 0x7a, 0x2e, 0x26, 0x2e, 0x2a,
    0x2e, 0x2c, 0x2e, 0x3b, 0x2e, 0x58, 0x2e, 0x5a};
const uint8_t HuffDecoderCommon::table11_96_emit_[16] = {
    0x2f, 0x30, 0x2f, 0x31, 0x2f, 0x32, 0x2f, 0x61,
    0x2f, 0x63, 0x2f, 0x65, 0x2f, 0x69, 0x2f, 0x6f};
const uint8_t HuffDecoderCommon::table11_97_emit_[27] = {
    0x2f, 0x73, 0x2f, 0x74, 0x2f, 0x20, 0x2f, 0x25, 0x2f,
    0x2d, 0x2f, 0x2e, 0x2f, 0x2f, 0x33, 0x2f, 0x34, 0x2f,
    0x35, 0x2f, 0x36, 0x2f, 0x37, 0x2f, 0x38, 0x2f, 0x39};
const uint16_t HuffDecoderCommon::table11_97_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_98_emit_[36] = {
    0x2f, 0x3d, 0x2f, 0x41, 0x2f, 0x5f, 0x2f, 0x62, 0x2f, 0x64, 0x2f, 0x66,
    0x2f, 0x67, 0x2f, 0x68, 0x2f, 0x6c, 0x2f, 0x6d, 0x2f, 0x6e, 0x2f, 0x70,
    0x2f, 0x72, 0x2f, 0x75, 0x2f, 0x3a, 0x2f, 0x42, 0x2f, 0x43, 0x2f, 0x44};
const uint8_t HuffDecoderCommon::table11_99_emit_[68] = {
    0x2f, 0x45, 0x2f, 0x46, 0x2f, 0x47, 0x2f, 0x48, 0x2f, 0x49, 0x2f, 0x4a,
    0x2f, 0x4b, 0x2f, 0x4c, 0x2f, 0x4d, 0x2f, 0x4e, 0x2f, 0x4f, 0x2f, 0x50,
    0x2f, 0x51, 0x2f, 0x52, 0x2f, 0x53, 0x2f, 0x54, 0x2f, 0x55, 0x2f, 0x56,
    0x2f, 0x57, 0x2f, 0x59, 0x2f, 0x6a, 0x2f, 0x6b, 0x2f, 0x71, 0x2f, 0x76,
    0x2f, 0x77, 0x2f, 0x78, 0x2f, 0x79, 0x2f, 0x7a, 0x2f, 0x26, 0x2f, 0x2a,
    0x2f, 0x2c, 0x2f, 0x3b, 0x2f, 0x58, 0x2f, 0x5a};
const uint8_t HuffDecoderCommon::table11_100_emit_[16] = {
    0x33, 0x30, 0x33, 0x31, 0x33, 0x32, 0x33, 0x61,
    0x33, 0x63, 0x33, 0x65, 0x33, 0x69, 0x33, 0x6f};
const uint8_t HuffDecoderCommon::table11_101_emit_[27] = {
    0x33, 0x73, 0x33, 0x74, 0x33, 0x20, 0x33, 0x25, 0x33,
    0x2d, 0x33, 0x2e, 0x33, 0x2f, 0x33, 0x33, 0x34, 0x33,
    0x35, 0x33, 0x36, 0x33, 0x37, 0x33, 0x38, 0x33, 0x39};
const uint16_t HuffDecoderCommon::table11_101_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_102_emit_[36] = {
    0x33, 0x3d, 0x33, 0x41, 0x33, 0x5f, 0x33, 0x62, 0x33, 0x64, 0x33, 0x66,
    0x33, 0x67, 0x33, 0x68, 0x33, 0x6c, 0x33, 0x6d, 0x33, 0x6e, 0x33, 0x70,
    0x33, 0x72, 0x33, 0x75, 0x33, 0x3a, 0x33, 0x42, 0x33, 0x43, 0x33, 0x44};
const uint8_t HuffDecoderCommon::table11_103_emit_[68] = {
    0x33, 0x45, 0x33, 0x46, 0x33, 0x47, 0x33, 0x48, 0x33, 0x49, 0x33, 0x4a,
    0x33, 0x4b, 0x33, 0x4c, 0x33, 0x4d, 0x33, 0x4e, 0x33, 0x4f, 0x33, 0x50,
    0x33, 0x51, 0x33, 0x52, 0x33, 0x53, 0x33, 0x54, 0x33, 0x55, 0x33, 0x56,
    0x33, 0x57, 0x33, 0x59, 0x33, 0x6a, 0x33, 0x6b, 0x33, 0x71, 0x33, 0x76,
    0x33, 0x77, 0x33, 0x78, 0x33, 0x79, 0x33, 0x7a, 0x33, 0x26, 0x33, 0x2a,
    0x33, 0x2c, 0x33, 0x3b, 0x33, 0x58, 0x33, 0x5a};
const uint8_t HuffDecoderCommon::table11_104_emit_[16] = {
    0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x61,
    0x34, 0x63, 0x34, 0x65, 0x34, 0x69, 0x34, 0x6f};
const uint8_t HuffDecoderCommon::table11_105_emit_[27] = {
    0x34, 0x73, 0x34, 0x74, 0x34, 0x20, 0x34, 0x25, 0x34,
    0x2d, 0x34, 0x2e, 0x34, 0x2f, 0x34, 0x33, 0x34, 0x34,
    0x35, 0x34, 0x36, 0x34, 0x37, 0x34, 0x38, 0x34, 0x39};
const uint16_t HuffDecoderCommon::table11_105_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_106_emit_[36] = {
    0x34, 0x3d, 0x34, 0x41, 0x34, 0x5f, 0x34, 0x62, 0x34, 0x64, 0x34, 0x66,
    0x34, 0x67, 0x34, 0x68, 0x34, 0x6c, 0x34, 0x6d, 0x34, 0x6e, 0x34, 0x70,
    0x34, 0x72, 0x34, 0x75, 0x34, 0x3a, 0x34, 0x42, 0x34, 0x43, 0x34, 0x44};
const uint8_t HuffDecoderCommon::table11_107_emit_[68] = {
    0x34, 0x45, 0x34, 0x46, 0x34, 0x47, 0x34, 0x48, 0x34, 0x49, 0x34, 0x4a,
    0x34, 0x4b, 0x34, 0x4c, 0x34, 0x4d, 0x34, 0x4e, 0x34, 0x4f, 0x34, 0x50,
    0x34, 0x51, 0x34, 0x52, 0x34, 0x53, 0x34, 0x54, 0x34, 0x55, 0x34, 0x56,
    0x34, 0x57, 0x34, 0x59, 0x34, 0x6a, 0x34, 0x6b, 0x34, 0x71, 0x34, 0x76,
    0x34, 0x77, 0x34, 0x78, 0x34, 0x79, 0x34, 0x7a, 0x34, 0x26, 0x34, 0x2a,
    0x34, 0x2c, 0x34, 0x3b, 0x34, 0x58, 0x34, 0x5a};
const uint8_t HuffDecoderCommon::table11_108_emit_[16] = {
    0x35, 0x30, 0x35, 0x31, 0x35, 0x32, 0x35, 0x61,
    0x35, 0x63, 0x35, 0x65, 0x35, 0x69, 0x35, 0x6f};
const uint8_t HuffDecoderCommon::table11_109_emit_[27] = {
    0x35, 0x73, 0x35, 0x74, 0x35, 0x20, 0x35, 0x25, 0x35,
    0x2d, 0x35, 0x2e, 0x35, 0x2f, 0x35, 0x33, 0x35, 0x34,
    0x35, 0x35, 0x36, 0x35, 0x37, 0x35, 0x38, 0x35, 0x39};
const uint16_t HuffDecoderCommon::table11_109_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x004d, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_110_emit_[36] = {
    0x35, 0x3d, 0x35, 0x41, 0x35, 0x5f, 0x35, 0x62, 0x35, 0x64, 0x35, 0x66,
    0x35, 0x67, 0x35, 0x68, 0x35, 0x6c, 0x35, 0x6d, 0x35, 0x6e, 0x35, 0x70,
    0x35, 0x72, 0x35, 0x75, 0x35, 0x3a, 0x35, 0x42, 0x35, 0x43, 0x35, 0x44};
const uint8_t HuffDecoderCommon::table11_111_emit_[68] = {
    0x35, 0x45, 0x35, 0x46, 0x35, 0x47, 0x35, 0x48, 0x35, 0x49, 0x35, 0x4a,
    0x35, 0x4b, 0x35, 0x4c, 0x35, 0x4d, 0x35, 0x4e, 0x35, 0x4f, 0x35, 0x50,
    0x35, 0x51, 0x35, 0x52, 0x35, 0x53, 0x35, 0x54, 0x35, 0x55, 0x35, 0x56,
    0x35, 0x57, 0x35, 0x59, 0x35, 0x6a, 0x35, 0x6b, 0x35, 0x71, 0x35, 0x76,
    0x35, 0x77, 0x35, 0x78, 0x35, 0x79, 0x35, 0x7a, 0x35, 0x26, 0x35, 0x2a,
    0x35, 0x2c, 0x35, 0x3b, 0x35, 0x58, 0x35, 0x5a};
const uint8_t HuffDecoderCommon::table11_112_emit_[16] = {
    0x36, 0x30, 0x36, 0x31, 0x36, 0x32, 0x36, 0x61,
    0x36, 0x63, 0x36, 0x65, 0x36, 0x69, 0x36, 0x6f};
const uint8_t HuffDecoderCommon::table11_113_emit_[27] = {
    0x36, 0x73, 0x36, 0x74, 0x36, 0x20, 0x36, 0x25, 0x36,
    0x2d, 0x36, 0x2e, 0x36, 0x2f, 0x36, 0x33, 0x36, 0x34,
    0x36, 0x35, 0x36, 0x36, 0x37, 0x36, 0x38, 0x36, 0x39};
const uint16_t HuffDecoderCommon::table11_113_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0055, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_114_emit_[36] = {
    0x36, 0x3d, 0x36, 0x41, 0x36, 0x5f, 0x36, 0x62, 0x36, 0x64, 0x36, 0x66,
    0x36, 0x67, 0x36, 0x68, 0x36, 0x6c, 0x36, 0x6d, 0x36, 0x6e, 0x36, 0x70,
    0x36, 0x72, 0x36, 0x75, 0x36, 0x3a, 0x36, 0x42, 0x36, 0x43, 0x36, 0x44};
const uint8_t HuffDecoderCommon::table11_115_emit_[68] = {
    0x36, 0x45, 0x36, 0x46, 0x36, 0x47, 0x36, 0x48, 0x36, 0x49, 0x36, 0x4a,
    0x36, 0x4b, 0x36, 0x4c, 0x36, 0x4d, 0x36, 0x4e, 0x36, 0x4f, 0x36, 0x50,
    0x36, 0x51, 0x36, 0x52, 0x36, 0x53, 0x36, 0x54, 0x36, 0x55, 0x36, 0x56,
    0x36, 0x57, 0x36, 0x59, 0x36, 0x6a, 0x36, 0x6b, 0x36, 0x71, 0x36, 0x76,
    0x36, 0x77, 0x36, 0x78, 0x36, 0x79, 0x36, 0x7a, 0x36, 0x26, 0x36, 0x2a,
    0x36, 0x2c, 0x36, 0x3b, 0x36, 0x58, 0x36, 0x5a};
const uint8_t HuffDecoderCommon::table11_116_emit_[16] = {
    0x37, 0x30, 0x37, 0x31, 0x37, 0x32, 0x37, 0x61,
    0x37, 0x63, 0x37, 0x65, 0x37, 0x69, 0x37, 0x6f};
const uint8_t HuffDecoderCommon::table11_117_emit_[27] = {
    0x37, 0x73, 0x37, 0x74, 0x37, 0x20, 0x37, 0x25, 0x37,
    0x2d, 0x37, 0x2e, 0x37, 0x2f, 0x37, 0x33, 0x37, 0x34,
    0x37, 0x35, 0x37, 0x36, 0x37, 0x37, 0x38, 0x37, 0x39};
const uint16_t HuffDecoderCommon::table11_117_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x005d, 0x0065};
const uint8_t HuffDecoderCommon::table11_118_emit_[36] = {
    0x37, 0x3d, 0x37, 0x41, 0x37, 0x5f, 0x37, 0x62, 0x37, 0x64, 0x37, 0x66,
    0x37, 0x67, 0x37, 0x68, 0x37, 0x6c, 0x37, 0x6d, 0x37, 0x6e, 0x37, 0x70,
    0x37, 0x72, 0x37, 0x75, 0x37, 0x3a, 0x37, 0x42, 0x37, 0x43, 0x37, 0x44};
const uint8_t HuffDecoderCommon::table11_119_emit_[68] = {
    0x37, 0x45, 0x37, 0x46, 0x37, 0x47, 0x37, 0x48, 0x37, 0x49, 0x37, 0x4a,
    0x37, 0x4b, 0x37, 0x4c, 0x37, 0x4d, 0x37, 0x4e, 0x37, 0x4f, 0x37, 0x50,
    0x37, 0x51, 0x37, 0x52, 0x37, 0x53, 0x37, 0x54, 0x37, 0x55, 0x37, 0x56,
    0x37, 0x57, 0x37, 0x59, 0x37, 0x6a, 0x37, 0x6b, 0x37, 0x71, 0x37, 0x76,
    0x37, 0x77, 0x37, 0x78, 0x37, 0x79, 0x37, 0x7a, 0x37, 0x26, 0x37, 0x2a,
    0x37, 0x2c, 0x37, 0x3b, 0x37, 0x58, 0x37, 0x5a};
const uint8_t HuffDecoderCommon::table11_120_emit_[16] = {
    0x38, 0x30, 0x38, 0x31, 0x38, 0x32, 0x38, 0x61,
    0x38, 0x63, 0x38, 0x65, 0x38, 0x69, 0x38, 0x6f};
const uint8_t HuffDecoderCommon::table11_121_emit_[27] = {
    0x38, 0x73, 0x38, 0x74, 0x38, 0x20, 0x38, 0x25, 0x38,
    0x2d, 0x38, 0x2e, 0x38, 0x2f, 0x38, 0x33, 0x38, 0x34,
    0x38, 0x35, 0x38, 0x36, 0x38, 0x37, 0x38, 0x38, 0x39};
const uint16_t HuffDecoderCommon::table11_121_inner_[15] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0065};
const uint8_t HuffDecoderCommon::table11_122_emit_[36] = {
    0x38, 0x3d, 0x38, 0x41, 0x38, 0x5f, 0x38, 0x62, 0x38, 0x64, 0x38, 0x66,
    0x38, 0x67, 0x38, 0x68, 0x38, 0x6c, 0x38, 0x6d, 0x38, 0x6e, 0x38, 0x70,
    0x38, 0x72, 0x38, 0x75, 0x38, 0x3a, 0x38, 0x42, 0x38, 0x43, 0x38, 0x44};
const uint8_t HuffDecoderCommon::table11_123_emit_[68] = {
    0x38, 0x45, 0x38, 0x46, 0x38, 0x47, 0x38, 0x48, 0x38, 0x49, 0x38, 0x4a,
    0x38, 0x4b, 0x38, 0x4c, 0x38, 0x4d, 0x38, 0x4e, 0x38, 0x4f, 0x38, 0x50,
    0x38, 0x51, 0x38, 0x52, 0x38, 0x53, 0x38, 0x54, 0x38, 0x55, 0x38, 0x56,
    0x38, 0x57, 0x38, 0x59, 0x38, 0x6a, 0x38, 0x6b, 0x38, 0x71, 0x38, 0x76,
    0x38, 0x77, 0x38, 0x78, 0x38, 0x79, 0x38, 0x7a, 0x38, 0x26, 0x38, 0x2a,
    0x38, 0x2c, 0x38, 0x3b, 0x38, 0x58, 0x38, 0x5a};
const uint8_t HuffDecoderCommon::table11_124_emit_[16] = {
    0x39, 0x30, 0x39, 0x31, 0x39, 0x32, 0x39, 0x61,
    0x39, 0x63, 0x39, 0x65, 0x39, 0x69, 0x39, 0x6f};
const uint8_t HuffDecoderCommon::table11_125_emit_[28] = {
    0x39, 0x73, 0x39, 0x74, 0x39, 0x20, 0x39, 0x25, 0x39, 0x2d,
    0x39, 0x2e, 0x39, 0x2f, 0x39, 0x33, 0x39, 0x34, 0x39, 0x35,
    0x39, 0x36, 0x39, 0x37, 0x39, 0x38, 0x39, 0x39};
const uint8_t HuffDecoderCommon::table11_126_emit_[36] = {
    0x39, 0x3d, 0x39, 0x41, 0x39, 0x5f, 0x39, 0x62, 0x39, 0x64, 0x39, 0x66,
    0x39, 0x67, 0x39, 0x68, 0x39, 0x6c, 0x39, 0x6d, 0x39, 0x6e, 0x39, 0x70,
    0x39, 0x72, 0x39, 0x75, 0x39, 0x3a, 0x39, 0x42, 0x39, 0x43, 0x39, 0x44};
const uint8_t HuffDecoderCommon::table11_127_emit_[68] = {
    0x39, 0x45, 0x39, 0x46, 0x39, 0x47, 0x39, 0x48, 0x39, 0x49, 0x39, 0x4a,
    0x39, 0x4b, 0x39, 0x4c, 0x39, 0x4d, 0x39, 0x4e, 0x39, 0x4f, 0x39, 0x50,
    0x39, 0x51, 0x39, 0x52, 0x39, 0x53, 0x39, 0x54, 0x39, 0x55, 0x39, 0x56,
    0x39, 0x57, 0x39, 0x59, 0x39, 0x6a, 0x39, 0x6b, 0x39, 0x71, 0x39, 0x76,
    0x39, 0x77, 0x39, 0x78, 0x39, 0x79, 0x39, 0x7a, 0x39, 0x26, 0x39, 0x2a,
    0x39, 0x2c, 0x39, 0x3b, 0x39, 0x58, 0x39, 0x5a};
const uint8_t HuffDecoderCommon::table11_128_emit_[16] = {
    0x3d, 0x30, 0x3d, 0x31, 0x3d, 0x32, 0x3d, 0x61,
    0x3d, 0x63, 0x3d, 0x65, 0x3d, 0x69, 0x3d, 0x6f};
const uint8_t HuffDecoderCommon::table11_129_emit_[28] = {
    0x3d, 0x73, 0x3d, 0x74, 0x3d, 0x20, 0x3d, 0x25, 0x3d, 0x2d,
    0x3d, 0x2e, 0x3d, 0x2f, 0x3d, 0x33, 0x3d, 0x34, 0x3d, 0x35,
    0x3d, 0x36, 0x3d, 0x37, 0x3d, 0x38, 0x3d, 0x39};
const uint8_t HuffDecoderCommon::table11_130_emit_[35] = {
    0x3d, 0x3d, 0x41, 0x3d, 0x5f, 0x3d, 0x62, 0x3d, 0x64, 0x3d, 0x66, 0x3d,
    0x67, 0x3d, 0x68, 0x3d, 0x6c, 0x3d, 0x6d, 0x3d, 0x6e, 0x3d, 0x70, 0x3d,
    0x72, 0x3d, 0x75, 0x3d, 0x3a, 0x3d, 0x42, 0x3d, 0x43, 0x3d, 0x44};
const uint16_t HuffDecoderCommon::table11_130_inner_[19] = {
    0x0000, 0x0001, 0x0005, 0x000d, 0x0015, 0x001d, 0x0025,
    0x002d, 0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_131_emit_[68] = {
    0x3d, 0x45, 0x3d, 0x46, 0x3d, 0x47, 0x3d, 0x48, 0x3d, 0x49, 0x3d, 0x4a,
    0x3d, 0x4b, 0x3d, 0x4c, 0x3d, 0x4d, 0x3d, 0x4e, 0x3d, 0x4f, 0x3d, 0x50,
    0x3d, 0x51, 0x3d, 0x52, 0x3d, 0x53, 0x3d, 0x54, 0x3d, 0x55, 0x3d, 0x56,
    0x3d, 0x57, 0x3d, 0x59, 0x3d, 0x6a, 0x3d, 0x6b, 0x3d, 0x71, 0x3d, 0x76,
    0x3d, 0x77, 0x3d, 0x78, 0x3d, 0x79, 0x3d, 0x7a, 0x3d, 0x26, 0x3d, 0x2a,
    0x3d, 0x2c, 0x3d, 0x3b, 0x3d, 0x58, 0x3d, 0x5a};
const uint8_t HuffDecoderCommon::table11_132_emit_[16] = {
    0x41, 0x30, 0x41, 0x31, 0x41, 0x32, 0x41, 0x61,
    0x41, 0x63, 0x41, 0x65, 0x41, 0x69, 0x41, 0x6f};
const uint8_t HuffDecoderCommon::table11_133_emit_[28] = {
    0x41, 0x73, 0x41, 0x74, 0x41, 0x20, 0x41, 0x25, 0x41, 0x2d,
    0x41, 0x2e, 0x41, 0x2f, 0x41, 0x33, 0x41, 0x34, 0x41, 0x35,
    0x41, 0x36, 0x41, 0x37, 0x41, 0x38, 0x41, 0x39};
const uint8_t HuffDecoderCommon::table11_134_emit_[35] = {
    0x41, 0x3d, 0x41, 0x41, 0x5f, 0x41, 0x62, 0x41, 0x64, 0x41, 0x66, 0x41,
    0x67, 0x41, 0x68, 0x41, 0x6c, 0x41, 0x6d, 0x41, 0x6e, 0x41, 0x70, 0x41,
    0x72, 0x41, 0x75, 0x41, 0x3a, 0x41, 0x42, 0x41, 0x43, 0x41, 0x44};
const uint16_t HuffDecoderCommon::table11_134_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x000d, 0x0015, 0x001d, 0x0025,
    0x002d, 0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_135_emit_[68] = {
    0x41, 0x45, 0x41, 0x46, 0x41, 0x47, 0x41, 0x48, 0x41, 0x49, 0x41, 0x4a,
    0x41, 0x4b, 0x41, 0x4c, 0x41, 0x4d, 0x41, 0x4e, 0x41, 0x4f, 0x41, 0x50,
    0x41, 0x51, 0x41, 0x52, 0x41, 0x53, 0x41, 0x54, 0x41, 0x55, 0x41, 0x56,
    0x41, 0x57, 0x41, 0x59, 0x41, 0x6a, 0x41, 0x6b, 0x41, 0x71, 0x41, 0x76,
    0x41, 0x77, 0x41, 0x78, 0x41, 0x79, 0x41, 0x7a, 0x41, 0x26, 0x41, 0x2a,
    0x41, 0x2c, 0x41, 0x3b, 0x41, 0x58, 0x41, 0x5a};
const uint8_t HuffDecoderCommon::table11_136_emit_[16] = {
    0x5f, 0x30, 0x5f, 0x31, 0x5f, 0x32, 0x5f, 0x61,
    0x5f, 0x63, 0x5f, 0x65, 0x5f, 0x69, 0x5f, 0x6f};
const uint8_t HuffDecoderCommon::table11_137_emit_[28] = {
    0x5f, 0x73, 0x5f, 0x74, 0x5f, 0x20, 0x5f, 0x25, 0x5f, 0x2d,
    0x5f, 0x2e, 0x5f, 0x2f, 0x5f, 0x33, 0x5f, 0x34, 0x5f, 0x35,
    0x5f, 0x36, 0x5f, 0x37, 0x5f, 0x38, 0x5f, 0x39};
const uint8_t HuffDecoderCommon::table11_138_emit_[35] = {
    0x5f, 0x3d, 0x5f, 0x41, 0x5f, 0x5f, 0x62, 0x5f, 0x64, 0x5f, 0x66, 0x5f,
    0x67, 0x5f, 0x68, 0x5f, 0x6c, 0x5f, 0x6d, 0x5f, 0x6e, 0x5f, 0x70, 0x5f,
    0x72, 0x5f, 0x75, 0x5f, 0x3a, 0x5f, 0x42, 0x5f, 0x43, 0x5f, 0x44};
const uint16_t HuffDecoderCommon::table11_138_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0015, 0x001d, 0x0025,
    0x002d, 0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_139_emit_[68] = {
    0x5f, 0x45, 0x5f, 0x46, 0x5f, 0x47, 0x5f, 0x48, 0x5f, 0x49, 0x5f, 0x4a,
    0x5f, 0x4b, 0x5f, 0x4c, 0x5f, 0x4d, 0x5f, 0x4e, 0x5f, 0x4f, 0x5f, 0x50,
    0x5f, 0x51, 0x5f, 0x52, 0x5f, 0x53, 0x5f, 0x54, 0x5f, 0x55, 0x5f, 0x56,
    0x5f, 0x57, 0x5f, 0x59, 0x5f, 0x6a, 0x5f, 0x6b, 0x5f, 0x71, 0x5f, 0x76,
    0x5f, 0x77, 0x5f, 0x78, 0x5f, 0x79, 0x5f, 0x7a, 0x5f, 0x26, 0x5f, 0x2a,
    0x5f, 0x2c, 0x5f, 0x3b, 0x5f, 0x58, 0x5f, 0x5a};
const uint8_t HuffDecoderCommon::table11_140_emit_[16] = {
    0x62, 0x30, 0x62, 0x31, 0x62, 0x32, 0x62, 0x61,
    0x62, 0x63, 0x62, 0x65, 0x62, 0x69, 0x62, 0x6f};
const uint8_t HuffDecoderCommon::table11_141_emit_[28] = {
    0x62, 0x73, 0x62, 0x74, 0x62, 0x20, 0x62, 0x25, 0x62, 0x2d,
    0x62, 0x2e, 0x62, 0x2f, 0x62, 0x33, 0x62, 0x34, 0x62, 0x35,
    0x62, 0x36, 0x62, 0x37, 0x62, 0x38, 0x62, 0x39};
const uint8_t HuffDecoderCommon::table11_142_emit_[35] = {
    0x62, 0x3d, 0x62, 0x41, 0x62, 0x5f, 0x62, 0x62, 0x64, 0x62, 0x66, 0x62,
    0x67, 0x62, 0x68, 0x62, 0x6c, 0x62, 0x6d, 0x62, 0x6e, 0x62, 0x70, 0x62,
    0x72, 0x62, 0x75, 0x62, 0x3a, 0x62, 0x42, 0x62, 0x43, 0x62, 0x44};
const uint16_t HuffDecoderCommon::table11_142_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x001d, 0x0025,
    0x002d, 0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_143_emit_[68] = {
    0x62, 0x45, 0x62, 0x46, 0x62, 0x47, 0x62, 0x48, 0x62, 0x49, 0x62, 0x4a,
    0x62, 0x4b, 0x62, 0x4c, 0x62, 0x4d, 0x62, 0x4e, 0x62, 0x4f, 0x62, 0x50,
    0x62, 0x51, 0x62, 0x52, 0x62, 0x53, 0x62, 0x54, 0x62, 0x55, 0x62, 0x56,
    0x62, 0x57, 0x62, 0x59, 0x62, 0x6a, 0x62, 0x6b, 0x62, 0x71, 0x62, 0x76,
    0x62, 0x77, 0x62, 0x78, 0x62, 0x79, 0x62, 0x7a, 0x62, 0x26, 0x62, 0x2a,
    0x62, 0x2c, 0x62, 0x3b, 0x62, 0x58, 0x62, 0x5a};
const uint8_t HuffDecoderCommon::table11_144_emit_[16] = {
    0x64, 0x30, 0x64, 0x31, 0x64, 0x32, 0x64, 0x61,
    0x64, 0x63, 0x64, 0x65, 0x64, 0x69, 0x64, 0x6f};
const uint8_t HuffDecoderCommon::table11_145_emit_[28] = {
    0x64, 0x73, 0x64, 0x74, 0x64, 0x20, 0x64, 0x25, 0x64, 0x2d,
    0x64, 0x2e, 0x64, 0x2f, 0x64, 0x33, 0x64, 0x34, 0x64, 0x35,
    0x64, 0x36, 0x64, 0x37, 0x64, 0x38, 0x64, 0x39};
const uint8_t HuffDecoderCommon::table11_146_emit_[35] = {
    0x64, 0x3d, 0x64, 0x41, 0x64, 0x5f, 0x64, 0x62, 0x64, 0x64, 0x66, 0x64,
    0x67, 0x64, 0x68, 0x64, 0x6c, 0x64, 0x6d, 0x64, 0x6e, 0x64, 0x70, 0x64,
    0x72, 0x64, 0x75, 0x64, 0x3a, 0x64, 0x42, 0x64, 0x43, 0x64, 0x44};
const uint16_t HuffDecoderCommon::table11_146_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0025,
    0x002d, 0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_147_emit_[68] = {
    0x64, 0x45, 0x64, 0x46, 0x64, 0x47, 0x64, 0x48, 0x64, 0x49, 0x64, 0x4a,
    0x64, 0x4b, 0x64, 0x4c, 0x64, 0x4d, 0x64, 0x4e, 0x64, 0x4f, 0x64, 0x50,
    0x64, 0x51, 0x64, 0x52, 0x64, 0x53, 0x64, 0x54, 0x64, 0x55, 0x64, 0x56,
    0x64, 0x57, 0x64, 0x59, 0x64, 0x6a, 0x64, 0x6b, 0x64, 0x71, 0x64, 0x76,
    0x64, 0x77, 0x64, 0x78, 0x64, 0x79, 0x64, 0x7a, 0x64, 0x26, 0x64, 0x2a,
    0x64, 0x2c, 0x64, 0x3b, 0x64, 0x58, 0x64, 0x5a};
const uint8_t HuffDecoderCommon::table11_148_emit_[16] = {
    0x66, 0x30, 0x66, 0x31, 0x66, 0x32, 0x66, 0x61,
    0x66, 0x63, 0x66, 0x65, 0x66, 0x69, 0x66, 0x6f};
const uint8_t HuffDecoderCommon::table11_149_emit_[28] = {
    0x66, 0x73, 0x66, 0x74, 0x66, 0x20, 0x66, 0x25, 0x66, 0x2d,
    0x66, 0x2e, 0x66, 0x2f, 0x66, 0x33, 0x66, 0x34, 0x66, 0x35,
    0x66, 0x36, 0x66, 0x37, 0x66, 0x38, 0x66, 0x39};
const uint8_t HuffDecoderCommon::table11_150_emit_[35] = {
    0x66, 0x3d, 0x66, 0x41, 0x66, 0x5f, 0x66, 0x62, 0x66, 0x64, 0x66, 0x66,
    0x67, 0x66, 0x68, 0x66, 0x6c, 0x66, 0x6d, 0x66, 0x6e, 0x66, 0x70, 0x66,
    0x72, 0x66, 0x75, 0x66, 0x3a, 0x66, 0x42, 0x66, 0x43, 0x66, 0x44};
const uint16_t HuffDecoderCommon::table11_150_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x002d, 0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_151_emit_[68] = {
    0x66, 0x45, 0x66, 0x46, 0x66, 0x47, 0x66, 0x48, 0x66, 0x49, 0x66, 0x4a,
    0x66, 0x4b, 0x66, 0x4c, 0x66, 0x4d, 0x66, 0x4e, 0x66, 0x4f, 0x66, 0x50,
    0x66, 0x51, 0x66, 0x52, 0x66, 0x53, 0x66, 0x54, 0x66, 0x55, 0x66, 0x56,
    0x66, 0x57, 0x66, 0x59, 0x66, 0x6a, 0x66, 0x6b, 0x66, 0x71, 0x66, 0x76,
    0x66, 0x77, 0x66, 0x78, 0x66, 0x79, 0x66, 0x7a, 0x66, 0x26, 0x66, 0x2a,
    0x66, 0x2c, 0x66, 0x3b, 0x66, 0x58, 0x66, 0x5a};
const uint8_t HuffDecoderCommon::table11_152_emit_[16] = {
    0x67, 0x30, 0x67, 0x31, 0x67, 0x32, 0x67, 0x61,
    0x67, 0x63, 0x67, 0x65, 0x67, 0x69, 0x67, 0x6f};
const uint8_t HuffDecoderCommon::table11_153_emit_[28] = {
    0x67, 0x73, 0x67, 0x74, 0x67, 0x20, 0x67, 0x25, 0x67, 0x2d,
    0x67, 0x2e, 0x67, 0x2f, 0x67, 0x33, 0x67, 0x34, 0x67, 0x35,
    0x67, 0x36, 0x67, 0x37, 0x67, 0x38, 0x67, 0x39};
const uint8_t HuffDecoderCommon::table11_154_emit_[35] = {
    0x67, 0x3d, 0x67, 0x41, 0x67, 0x5f, 0x67, 0x62, 0x67, 0x64, 0x67, 0x66,
    0x67, 0x67, 0x68, 0x67, 0x6c, 0x67, 0x6d, 0x67, 0x6e, 0x67, 0x70, 0x67,
    0x72, 0x67, 0x75, 0x67, 0x3a, 0x67, 0x42, 0x67, 0x43, 0x67, 0x44};
const uint16_t HuffDecoderCommon::table11_154_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_155_emit_[68] = {
    0x67, 0x45, 0x67, 0x46, 0x67, 0x47, 0x67, 0x48, 0x67, 0x49, 0x67, 0x4a,
    0x67, 0x4b, 0x67, 0x4c, 0x67, 0x4d, 0x67, 0x4e, 0x67, 0x4f, 0x67, 0x50,
    0x67, 0x51, 0x67, 0x52, 0x67, 0x53, 0x67, 0x54, 0x67, 0x55, 0x67, 0x56,
    0x67, 0x57, 0x67, 0x59, 0x67, 0x6a, 0x67, 0x6b, 0x67, 0x71, 0x67, 0x76,
    0x67, 0x77, 0x67, 0x78, 0x67, 0x79, 0x67, 0x7a, 0x67, 0x26, 0x67, 0x2a,
    0x67, 0x2c, 0x67, 0x3b, 0x67, 0x58, 0x67, 0x5a};
const uint8_t HuffDecoderCommon::table11_156_emit_[16] = {
    0x68, 0x30, 0x68, 0x31, 0x68, 0x32, 0x68, 0x61,
    0x68, 0x63, 0x68, 0x65, 0x68, 0x69, 0x68, 0x6f};
const uint8_t HuffDecoderCommon::table11_157_emit_[28] = {
    0x68, 0x73, 0x68, 0x74, 0x68, 0x20, 0x68, 0x25, 0x68, 0x2d,
    0x68, 0x2e, 0x68, 0x2f, 0x68, 0x33, 0x68, 0x34, 0x68, 0x35,
    0x68, 0x36, 0x68, 0x37, 0x68, 0x38, 0x68, 0x39};
const uint8_t HuffDecoderCommon::table11_158_emit_[35] = {
    0x68, 0x3d, 0x68, 0x41, 0x68, 0x5f, 0x68, 0x62, 0x68, 0x64, 0x68, 0x66,
    0x68, 0x67, 0x68, 0x68, 0x6c, 0x68, 0x6d, 0x68, 0x6e, 0x68, 0x70, 0x68,
    0x72, 0x68, 0x75, 0x68, 0x3a, 0x68, 0x42, 0x68, 0x43, 0x68, 0x44};
const uint16_t HuffDecoderCommon::table11_158_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_159_emit_[68] = {
    0x68, 0x45, 0x68, 0x46, 0x68, 0x47, 0x68, 0x48, 0x68, 0x49, 0x68, 0x4a,
    0x68, 0x4b, 0x68, 0x4c, 0x68, 0x4d, 0x68, 0x4e, 0x68, 0x4f, 0x68, 0x50,
    0x68, 0x51, 0x68, 0x52, 0x68, 0x53, 0x68, 0x54, 0x68, 0x55, 0x68, 0x56,
    0x68, 0x57, 0x68, 0x59, 0x68, 0x6a, 0x68, 0x6b, 0x68, 0x71, 0x68, 0x76,
    0x68, 0x77, 0x68, 0x78, 0x68, 0x79, 0x68, 0x7a, 0x68, 0x26, 0x68, 0x2a,
    0x68, 0x2c, 0x68, 0x3b, 0x68, 0x58, 0x68, 0x5a};
const uint8_t HuffDecoderCommon::table11_160_emit_[16] = {
    0x6c, 0x30, 0x6c, 0x31, 0x6c, 0x32, 0x6c, 0x61,
    0x6c, 0x63, 0x6c, 0x65, 0x6c, 0x69, 0x6c, 0x6f};
const uint8_t HuffDecoderCommon::table11_161_emit_[28] = {
    0x6c, 0x73, 0x6c, 0x74, 0x6c, 0x20, 0x6c, 0x25, 0x6c, 0x2d,
    0x6c, 0x2e, 0x6c, 0x2f, 0x6c, 0x33, 0x6c, 0x34, 0x6c, 0x35,
    0x6c, 0x36, 0x6c, 0x37, 0x6c, 0x38, 0x6c, 0x39};
const uint8_t HuffDecoderCommon::table11_162_emit_[35] = {
    0x6c, 0x3d, 0x6c, 0x41, 0x6c, 0x5f, 0x6c, 0x62, 0x6c, 0x64, 0x6c, 0x66,
    0x6c, 0x67, 0x6c, 0x68, 0x6c, 0x6c, 0x6d, 0x6c, 0x6e, 0x6c, 0x70, 0x6c,
    0x72, 0x6c, 0x75, 0x6c, 0x3a, 0x6c, 0x42, 0x6c, 0x43, 0x6c, 0x44};
const uint16_t HuffDecoderCommon::table11_162_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x0041, 0x0045, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_163_emit_[68] = {
    0x6c, 0x45, 0x6c, 0x46, 0x6c, 0x47, 0x6c, 0x48, 0x6c, 0x49, 0x6c, 0x4a,
    0x6c, 0x4b, 0x6c, 0x4c, 0x6c, 0x4d, 0x6c, 0x4e, 0x6c, 0x4f, 0x6c, 0x50,
    0x6c, 0x51, 0x6c, 0x52, 0x6c, 0x53, 0x6c, 0x54, 0x6c, 0x55, 0x6c, 0x56,
    0x6c, 0x57, 0x6c, 0x59, 0x6c, 0x6a, 0x6c, 0x6b, 0x6c, 0x71, 0x6c, 0x76,
    0x6c, 0x77, 0x6c, 0x78, 0x6c, 0x79, 0x6c, 0x7a, 0x6c, 0x26, 0x6c, 0x2a,
    0x6c, 0x2c, 0x6c, 0x3b, 0x6c, 0x58, 0x6c, 0x5a};
const uint8_t HuffDecoderCommon::table11_164_emit_[16] = {
    0x6d, 0x30, 0x6d, 0x31, 0x6d, 0x32, 0x6d, 0x61,
    0x6d, 0x63, 0x6d, 0x65, 0x6d, 0x69, 0x6d, 0x6f};
const uint8_t HuffDecoderCommon::table11_165_emit_[28] = {
    0x6d, 0x73, 0x6d, 0x74, 0x6d, 0x20, 0x6d, 0x25, 0x6d, 0x2d,
    0x6d, 0x2e, 0x6d, 0x2f, 0x6d, 0x33, 0x6d, 0x34, 0x6d, 0x35,
    0x6d, 0x36, 0x6d, 0x37, 0x6d, 0x38, 0x6d, 0x39};
const uint8_t HuffDecoderCommon::table11_166_emit_[35] = {
    0x6d, 0x3d, 0x6d, 0x41, 0x6d, 0x5f, 0x6d, 0x62, 0x6d, 0x64, 0x6d, 0x66,
    0x6d, 0x67, 0x6d, 0x68, 0x6d, 0x6c, 0x6d, 0x6d, 0x6e, 0x6d, 0x70, 0x6d,
    0x72, 0x6d, 0x75, 0x6d, 0x3a, 0x6d, 0x42, 0x6d, 0x43, 0x6d, 0x44};
const uint16_t HuffDecoderCommon::table11_166_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x0041, 0x0049, 0x004d, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_167_emit_[68] = {
    0x6d, 0x45, 0x6d, 0x46, 0x6d, 0x47, 0x6d, 0x48, 0x6d, 0x49, 0x6d, 0x4a,
    0x6d, 0x4b, 0x6d, 0x4c, 0x6d, 0x4d, 0x6d, 0x4e, 0x6d, 0x4f, 0x6d, 0x50,
    0x6d, 0x51, 0x6d, 0x52, 0x6d, 0x53, 0x6d, 0x54, 0x6d, 0x55, 0x6d, 0x56,
    0x6d, 0x57, 0x6d, 0x59, 0x6d, 0x6a, 0x6d, 0x6b, 0x6d, 0x71, 0x6d, 0x76,
    0x6d, 0x77, 0x6d, 0x78, 0x6d, 0x79, 0x6d, 0x7a, 0x6d, 0x26, 0x6d, 0x2a,
    0x6d, 0x2c, 0x6d, 0x3b, 0x6d, 0x58, 0x6d, 0x5a};
const uint8_t HuffDecoderCommon::table11_168_emit_[16] = {
    0x6e, 0x30, 0x6e, 0x31, 0x6e, 0x32, 0x6e, 0x61,
    0x6e, 0x63, 0x6e, 0x65, 0x6e, 0x69, 0x6e, 0x6f};
const uint8_t HuffDecoderCommon::table11_169_emit_[28] = {
    0x6e, 0x73, 0x6e, 0x74, 0x6e, 0x20, 0x6e, 0x25, 0x6e, 0x2d,
    0x6e, 0x2e, 0x6e, 0x2f, 0x6e, 0x33, 0x6e, 0x34, 0x6e, 0x35,
    0x6e, 0x36, 0x6e, 0x37, 0x6e, 0x38, 0x6e, 0x39};
const uint8_t HuffDecoderCommon::table11_170_emit_[35] = {
    0x6e, 0x3d, 0x6e, 0x41, 0x6e, 0x5f, 0x6e, 0x62, 0x6e, 0x64, 0x6e, 0x66,
    0x6e, 0x67, 0x6e, 0x68, 0x6e, 0x6c, 0x6e, 0x6d, 0x6e, 0x6e, 0x70, 0x6e,
    0x72, 0x6e, 0x75, 0x6e, 0x3a, 0x6e, 0x42, 0x6e, 0x43, 0x6e, 0x44};
const uint16_t HuffDecoderCommon::table11_170_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x0041, 0x0049, 0x0051, 0x0055, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_171_emit_[68] = {
    0x6e, 0x45, 0x6e, 0x46, 0x6e, 0x47, 0x6e, 0x48, 0x6e, 0x49, 0x6e, 0x4a,
    0x6e, 0x4b, 0x6e, 0x4c, 0x6e, 0x4d, 0x6e, 0x4e, 0x6e, 0x4f, 0x6e, 0x50,
    0x6e, 0x51, 0x6e, 0x52, 0x6e, 0x53, 0x6e, 0x54, 0x6e, 0x55, 0x6e, 0x56,
    0x6e, 0x57, 0x6e, 0x59, 0x6e, 0x6a, 0x6e, 0x6b, 0x6e, 0x71, 0x6e, 0x76,
    0x6e, 0x77, 0x6e, 0x78, 0x6e, 0x79, 0x6e, 0x7a, 0x6e, 0x26, 0x6e, 0x2a,
    0x6e, 0x2c, 0x6e, 0x3b, 0x6e, 0x58, 0x6e, 0x5a};
const uint8_t HuffDecoderCommon::table11_172_emit_[16] = {
    0x70, 0x30, 0x70, 0x31, 0x70, 0x32, 0x70, 0x61,
    0x70, 0x63, 0x70, 0x65, 0x70, 0x69, 0x70, 0x6f};
const uint8_t HuffDecoderCommon::table11_173_emit_[28] = {
    0x70, 0x73, 0x70, 0x74, 0x70, 0x20, 0x70, 0x25, 0x70, 0x2d,
    0x70, 0x2e, 0x70, 0x2f, 0x70, 0x33, 0x70, 0x34, 0x70, 0x35,
    0x70, 0x36, 0x70, 0x37, 0x70, 0x38, 0x70, 0x39};
const uint8_t HuffDecoderCommon::table11_174_emit_[35] = {
    0x70, 0x3d, 0x70, 0x41, 0x70, 0x5f, 0x70, 0x62, 0x70, 0x64, 0x70, 0x66,
    0x70, 0x67, 0x70, 0x68, 0x70, 0x6c, 0x70, 0x6d, 0x70, 0x6e, 0x70, 0x70,
    0x72, 0x70, 0x75, 0x70, 0x3a, 0x70, 0x42, 0x70, 0x43, 0x70, 0x44};
const uint16_t HuffDecoderCommon::table11_174_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x005d,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_175_emit_[68] = {
    0x70, 0x45, 0x70, 0x46, 0x70, 0x47, 0x70, 0x48, 0x70, 0x49, 0x70, 0x4a,
    0x70, 0x4b, 0x70, 0x4c, 0x70, 0x4d, 0x70, 0x4e, 0x70, 0x4f, 0x70, 0x50,
    0x70, 0x51, 0x70, 0x52, 0x70, 0x53, 0x70, 0x54, 0x70, 0x55, 0x70, 0x56,
    0x70, 0x57, 0x70, 0x59, 0x70, 0x6a, 0x70, 0x6b, 0x70, 0x71, 0x70, 0x76,
    0x70, 0x77, 0x70, 0x78, 0x70, 0x79, 0x70, 0x7a, 0x70, 0x26, 0x70, 0x2a,
    0x70, 0x2c, 0x70, 0x3b, 0x70, 0x58, 0x70, 0x5a};
const uint8_t HuffDecoderCommon::table11_176_emit_[16] = {
    0x72, 0x30, 0x72, 0x31, 0x72, 0x32, 0x72, 0x61,
    0x72, 0x63, 0x72, 0x65, 0x72, 0x69, 0x72, 0x6f};
const uint8_t HuffDecoderCommon::table11_177_emit_[28] = {
    0x72, 0x73, 0x72, 0x74, 0x72, 0x20, 0x72, 0x25, 0x72, 0x2d,
    0x72, 0x2e, 0x72, 0x2f, 0x72, 0x33, 0x72, 0x34, 0x72, 0x35,
    0x72, 0x36, 0x72, 0x37, 0x72, 0x38, 0x72, 0x39};
const uint8_t HuffDecoderCommon::table11_178_emit_[35] = {
    0x72, 0x3d, 0x72, 0x41, 0x72, 0x5f, 0x72, 0x62, 0x72, 0x64, 0x72, 0x66,
    0x72, 0x67, 0x72, 0x68, 0x72, 0x6c, 0x72, 0x6d, 0x72, 0x6e, 0x72, 0x70,
    0x72, 0x72, 0x75, 0x72, 0x3a, 0x72, 0x42, 0x72, 0x43, 0x72, 0x44};
const uint16_t HuffDecoderCommon::table11_178_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061,
    0x0065, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_179_emit_[68] = {
    0x72, 0x45, 0x72, 0x46, 0x72, 0x47, 0x72, 0x48, 0x72, 0x49, 0x72, 0x4a,
    0x72, 0x4b, 0x72, 0x4c, 0x72, 0x4d, 0x72, 0x4e, 0x72, 0x4f, 0x72, 0x50,
    0x72, 0x51, 0x72, 0x52, 0x72, 0x53, 0x72, 0x54, 0x72, 0x55, 0x72, 0x56,
    0x72, 0x57, 0x72, 0x59, 0x72, 0x6a, 0x72, 0x6b, 0x72, 0x71, 0x72, 0x76,
    0x72, 0x77, 0x72, 0x78, 0x72, 0x79, 0x72, 0x7a, 0x72, 0x26, 0x72, 0x2a,
    0x72, 0x2c, 0x72, 0x3b, 0x72, 0x58, 0x72, 0x5a};
const uint8_t HuffDecoderCommon::table11_180_emit_[16] = {
    0x75, 0x30, 0x75, 0x31, 0x75, 0x32, 0x75, 0x61,
    0x75, 0x63, 0x75, 0x65, 0x75, 0x69, 0x75, 0x6f};
const uint8_t HuffDecoderCommon::table11_181_emit_[28] = {
    0x75, 0x73, 0x75, 0x74, 0x75, 0x20, 0x75, 0x25, 0x75, 0x2d,
    0x75, 0x2e, 0x75, 0x2f, 0x75, 0x33, 0x75, 0x34, 0x75, 0x35,
    0x75, 0x36, 0x75, 0x37, 0x75, 0x38, 0x75, 0x39};
const uint8_t HuffDecoderCommon::table11_182_emit_[35] = {
    0x75, 0x3d, 0x75, 0x41, 0x75, 0x5f, 0x75, 0x62, 0x75, 0x64, 0x75, 0x66,
    0x75, 0x67, 0x75, 0x68, 0x75, 0x6c, 0x75, 0x6d, 0x75, 0x6e, 0x75, 0x70,
    0x75, 0x72, 0x75, 0x75, 0x3a, 0x75, 0x42, 0x75, 0x43, 0x75, 0x44};
const uint16_t HuffDecoderCommon::table11_182_inner_[19] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029,
    0x0031, 0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061,
    0x0069, 0x006d, 0x0075, 0x007d, 0x0085};
const uint8_t HuffDecoderCommon::table11_183_emit_[68] = {
    0x75, 0x45, 0x75, 0x46, 0x75, 0x47, 0x75, 0x48, 0x75, 0x49, 0x75, 0x4a,
    0x75, 0x4b, 0x75, 0x4c, 0x75, 0x4d, 0x75, 0x4e, 0x75, 0x4f, 0x75, 0x50,
    0x75, 0x51, 0x75, 0x52, 0x75, 0x53, 0x75, 0x54, 0x75, 0x55, 0x75, 0x56,
    0x75, 0x57, 0x75, 0x59, 0x75, 0x6a, 0x75, 0x6b, 0x75, 0x71, 0x75, 0x76,
    0x75, 0x77, 0x75, 0x78, 0x75, 0x79, 0x75, 0x7a, 0x75, 0x26, 0x75, 0x2a,
    0x75, 0x2c, 0x75, 0x3b, 0x75, 0x58, 0x75, 0x5a};
const uint8_t HuffDecoderCommon::table11_184_emit_[44] = {
    0x3a, 0x30, 0x3a, 0x31, 0x3a, 0x32, 0x3a, 0x61, 0x3a, 0x63, 0x3a,
    0x65, 0x3a, 0x69, 0x3a, 0x6f, 0x3a, 0x73, 0x3a, 0x74, 0x3a, 0x20,
    0x3a, 0x25, 0x3a, 0x2d, 0x3a, 0x2e, 0x3a, 0x2f, 0x3a, 0x33, 0x3a,
    0x34, 0x3a, 0x35, 0x3a, 0x36, 0x3a, 0x37, 0x3a, 0x38, 0x3a, 0x39};
const uint8_t HuffDecoderCommon::table11_185_emit_[91] = {
    0x3a, 0x3d, 0x3a, 0x41, 0x3a, 0x5f, 0x3a, 0x62, 0x3a, 0x64, 0x3a, 0x66,
    0x3a, 0x67, 0x3a, 0x68, 0x3a, 0x6c, 0x3a, 0x6d, 0x3a, 0x6e, 0x3a, 0x70,
    0x3a, 0x72, 0x3a, 0x75, 0x3a, 0x3a, 0x42, 0x3a, 0x43, 0x3a, 0x44, 0x3a,
    0x45, 0x3a, 0x46, 0x3a, 0x47, 0x3a, 0x48, 0x3a, 0x49, 0x3a, 0x4a, 0x3a,
    0x4b, 0x3a, 0x4c, 0x3a, 0x4d, 0x3a, 0x4e, 0x3a, 0x4f, 0x3a, 0x50, 0x3a,
    0x51, 0x3a, 0x52, 0x3a, 0x53, 0x3a, 0x54, 0x3a, 0x55, 0x3a, 0x56, 0x3a,
    0x57, 0x3a, 0x59, 0x3a, 0x6a, 0x3a, 0x6b, 0x3a, 0x71, 0x3a, 0x76, 0x3a,
    0x77, 0x3a, 0x78, 0x3a, 0x79, 0x3a, 0x7a};
const uint16_t HuffDecoderCommon::table11_185_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_186_emit_[44] = {
    0x42, 0x30, 0x42, 0x31, 0x42, 0x32, 0x42, 0x61, 0x42, 0x63, 0x42,
    0x65, 0x42, 0x69, 0x42, 0x6f, 0x42, 0x73, 0x42, 0x74, 0x42, 0x20,
    0x42, 0x25, 0x42, 0x2d, 0x42, 0x2e, 0x42, 0x2f, 0x42, 0x33, 0x42,
    0x34, 0x42, 0x35, 0x42, 0x36, 0x42, 0x37, 0x42, 0x38, 0x42, 0x39};
const uint8_t HuffDecoderCommon::table11_187_emit_[91] = {
    0x42, 0x3d, 0x42, 0x41, 0x42, 0x5f, 0x42, 0x62, 0x42, 0x64, 0x42, 0x66,
    0x42, 0x67, 0x42, 0x68, 0x42, 0x6c, 0x42, 0x6d, 0x42, 0x6e, 0x42, 0x70,
    0x42, 0x72, 0x42, 0x75, 0x42, 0x3a, 0x42, 0x42, 0x43, 0x42, 0x44, 0x42,
    0x45, 0x42, 0x46, 0x42, 0x47, 0x42, 0x48, 0x42, 0x49, 0x42, 0x4a, 0x42,
    0x4b, 0x42, 0x4c, 0x42, 0x4d, 0x42, 0x4e, 0x42, 0x4f, 0x42, 0x50, 0x42,
    0x51, 0x42, 0x52, 0x42, 0x53, 0x42, 0x54, 0x42, 0x55, 0x42, 0x56, 0x42,
    0x57, 0x42, 0x59, 0x42, 0x6a, 0x42, 0x6b, 0x42, 0x71, 0x42, 0x76, 0x42,
    0x77, 0x42, 0x78, 0x42, 0x79, 0x42, 0x7a};
const uint16_t HuffDecoderCommon::table11_187_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_188_emit_[44] = {
    0x43, 0x30, 0x43, 0x31, 0x43, 0x32, 0x43, 0x61, 0x43, 0x63, 0x43,
    0x65, 0x43, 0x69, 0x43, 0x6f, 0x43, 0x73, 0x43, 0x74, 0x43, 0x20,
    0x43, 0x25, 0x43, 0x2d, 0x43, 0x2e, 0x43, 0x2f, 0x43, 0x33, 0x43,
    0x34, 0x43, 0x35, 0x43, 0x36, 0x43, 0x37, 0x43, 0x38, 0x43, 0x39};
const uint8_t HuffDecoderCommon::table11_189_emit_[91] = {
    0x43, 0x3d, 0x43, 0x41, 0x43, 0x5f, 0x43, 0x62, 0x43, 0x64, 0x43, 0x66,
    0x43, 0x67, 0x43, 0x68, 0x43, 0x6c, 0x43, 0x6d, 0x43, 0x6e, 0x43, 0x70,
    0x43, 0x72, 0x43, 0x75, 0x43, 0x3a, 0x43, 0x42, 0x43, 0x43, 0x44, 0x43,
    0x45, 0x43, 0x46, 0x43, 0x47, 0x43, 0x48, 0x43, 0x49, 0x43, 0x4a, 0x43,
    0x4b, 0x43, 0x4c, 0x43, 0x4d, 0x43, 0x4e, 0x43, 0x4f, 0x43, 0x50, 0x43,
    0x51, 0x43, 0x52, 0x43, 0x53, 0x43, 0x54, 0x43, 0x55, 0x43, 0x56, 0x43,
    0x57, 0x43, 0x59, 0x43, 0x6a, 0x43, 0x6b, 0x43, 0x71, 0x43, 0x76, 0x43,
    0x77, 0x43, 0x78, 0x43, 0x79, 0x43, 0x7a};
const uint16_t HuffDecoderCommon::table11_189_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_190_emit_[44] = {
    0x44, 0x30, 0x44, 0x31, 0x44, 0x32, 0x44, 0x61, 0x44, 0x63, 0x44,
    0x65, 0x44, 0x69, 0x44, 0x6f, 0x44, 0x73, 0x44, 0x74, 0x44, 0x20,
    0x44, 0x25, 0x44, 0x2d, 0x44, 0x2e, 0x44, 0x2f, 0x44, 0x33, 0x44,
    0x34, 0x44, 0x35, 0x44, 0x36, 0x44, 0x37, 0x44, 0x38, 0x44, 0x39};
const uint8_t HuffDecoderCommon::table11_191_emit_[91] = {
    0x44, 0x3d, 0x44, 0x41, 0x44, 0x5f, 0x44, 0x62, 0x44, 0x64, 0x44, 0x66,
    0x44, 0x67, 0x44, 0x68, 0x44, 0x6c, 0x44, 0x6d, 0x44, 0x6e, 0x44, 0x70,
    0x44, 0x72, 0x44, 0x75, 0x44, 0x3a, 0x44, 0x42, 0x44, 0x43, 0x44, 0x44,
    0x45, 0x44, 0x46, 0x44, 0x47, 0x44, 0x48, 0x44, 0x49, 0x44, 0x4a, 0x44,
    0x4b, 0x44, 0x4c, 0x44, 0x4d, 0x44, 0x4e, 0x44, 0x4f, 0x44, 0x50, 0x44,
    0x51, 0x44, 0x52, 0x44, 0x53, 0x44, 0x54, 0x44, 0x55, 0x44, 0x56, 0x44,
    0x57, 0x44, 0x59, 0x44, 0x6a, 0x44, 0x6b, 0x44, 0x71, 0x44, 0x76, 0x44,
    0x77, 0x44, 0x78, 0x44, 0x79, 0x44, 0x7a};
const uint16_t HuffDecoderCommon::table11_191_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_192_emit_[44] = {
    0x45, 0x30, 0x45, 0x31, 0x45, 0x32, 0x45, 0x61, 0x45, 0x63, 0x45,
    0x65, 0x45, 0x69, 0x45, 0x6f, 0x45, 0x73, 0x45, 0x74, 0x45, 0x20,
    0x45, 0x25, 0x45, 0x2d, 0x45, 0x2e, 0x45, 0x2f, 0x45, 0x33, 0x45,
    0x34, 0x45, 0x35, 0x45, 0x36, 0x45, 0x37, 0x45, 0x38, 0x45, 0x39};
const uint8_t HuffDecoderCommon::table11_193_emit_[91] = {
    0x45, 0x3d, 0x45, 0x41, 0x45, 0x5f, 0x45, 0x62, 0x45, 0x64, 0x45, 0x66,
    0x45, 0x67, 0x45, 0x68, 0x45, 0x6c, 0x45, 0x6d, 0x45, 0x6e, 0x45, 0x70,
    0x45, 0x72, 0x45, 0x75, 0x45, 0x3a, 0x45, 0x42, 0x45, 0x43, 0x45, 0x44,
    0x45, 0x45, 0x46, 0x45, 0x47, 0x45, 0x48, 0x45, 0x49, 0x45, 0x4a, 0x45,
    0x4b, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x45, 0x4f, 0x45, 0x50, 0x45,
    0x51, 0x45, 0x52, 0x45, 0x53, 0x45, 0x54, 0x45, 0x55, 0x45, 0x56, 0x45,
    0x57, 0x45, 0x59, 0x45, 0x6a, 0x45, 0x6b, 0x45, 0x71, 0x45, 0x76, 0x45,
    0x77, 0x45, 0x78, 0x45, 0x79, 0x45, 0x7a};
const uint16_t HuffDecoderCommon::table11_193_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_194_emit_[44] = {
    0x46, 0x30, 0x46, 0x31, 0x46, 0x32, 0x46, 0x61, 0x46, 0x63, 0x46,
    0x65, 0x46, 0x69, 0x46, 0x6f, 0x46, 0x73, 0x46, 0x74, 0x46, 0x20,
    0x46, 0x25, 0x46, 0x2d, 0x46, 0x2e, 0x46, 0x2f, 0x46, 0x33, 0x46,
    0x34, 0x46, 0x35, 0x46, 0x36, 0x46, 0x37, 0x46, 0x38, 0x46, 0x39};
const uint8_t HuffDecoderCommon::table11_195_emit_[91] = {
    0x46, 0x3d, 0x46, 0x41, 0x46, 0x5f, 0x46, 0x62, 0x46, 0x64, 0x46, 0x66,
    0x46, 0x67, 0x46, 0x68, 0x46, 0x6c, 0x46, 0x6d, 0x46, 0x6e, 0x46, 0x70,
    0x46, 0x72, 0x46, 0x75, 0x46, 0x3a, 0x46, 0x42, 0x46, 0x43, 0x46, 0x44,
    0x46, 0x45, 0x46, 0x46, 0x47, 0x46, 0x48, 0x46, 0x49, 0x46, 0x4a, 0x46,
    0x4b, 0x46, 0x4c, 0x46, 0x4d, 0x46, 0x4e, 0x46, 0x4f, 0x46, 0x50, 0x46,
    0x51, 0x46, 0x52, 0x46, 0x53, 0x46, 0x54, 0x46, 0x55, 0x46, 0x56, 0x46,
    0x57, 0x46, 0x59, 0x46, 0x6a, 0x46, 0x6b, 0x46, 0x71, 0x46, 0x76, 0x46,
    0x77, 0x46, 0x78, 0x46, 0x79, 0x46, 0x7a};
const uint16_t HuffDecoderCommon::table11_195_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_196_emit_[44] = {
    0x47, 0x30, 0x47, 0x31, 0x47, 0x32, 0x47, 0x61, 0x47, 0x63, 0x47,
    0x65, 0x47, 0x69, 0x47, 0x6f, 0x47, 0x73, 0x47, 0x74, 0x47, 0x20,
    0x47, 0x25, 0x47, 0x2d, 0x47, 0x2e, 0x47, 0x2f, 0x47, 0x33, 0x47,
    0x34, 0x47, 0x35, 0x47, 0x36, 0x47, 0x37, 0x47, 0x38, 0x47, 0x39};
const uint8_t HuffDecoderCommon::table11_197_emit_[91] = {
    0x47, 0x3d, 0x47, 0x41, 0x47, 0x5f, 0x47, 0x62, 0x47, 0x64, 0x47, 0x66,
    0x47, 0x67, 0x47, 0x68, 0x47, 0x6c, 0x47, 0x6d, 0x47, 0x6e, 0x47, 0x70,
    0x47, 0x72, 0x47, 0x75, 0x47, 0x3a, 0x47, 0x42, 0x47, 0x43, 0x47, 0x44,
    0x47, 0x45, 0x47, 0x46, 0x47, 0x47, 0x48, 0x47, 0x49, 0x47, 0x4a, 0x47,
    0x4b, 0x47, 0x4c, 0x47, 0x4d, 0x47, 0x4e, 0x47, 0x4f, 0x47, 0x50, 0x47,
    0x51, 0x47, 0x52, 0x47, 0x53, 0x47, 0x54, 0x47, 0x55, 0x47, 0x56, 0x47,
    0x57, 0x47, 0x59, 0x47, 0x6a, 0x47, 0x6b, 0x47, 0x71, 0x47, 0x76, 0x47,
    0x77, 0x47, 0x78, 0x47, 0x79, 0x47, 0x7a};
const uint16_t HuffDecoderCommon::table11_197_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_198_emit_[44] = {
    0x48, 0x30, 0x48, 0x31, 0x48, 0x32, 0x48, 0x61, 0x48, 0x63, 0x48,
    0x65, 0x48, 0x69, 0x48, 0x6f, 0x48, 0x73, 0x48, 0x74, 0x48, 0x20,
    0x48, 0x25, 0x48, 0x2d, 0x48, 0x2e, 0x48, 0x2f, 0x48, 0x33, 0x48,
    0x34, 0x48, 0x35, 0x48, 0x36, 0x48, 0x37, 0x48, 0x38, 0x48, 0x39};
const uint8_t HuffDecoderCommon::table11_199_emit_[91] = {
    0x48, 0x3d, 0x48, 0x41, 0x48, 0x5f, 0x48, 0x62, 0x48, 0x64, 0x48, 0x66,
    0x48, 0x67, 0x48, 0x68, 0x48, 0x6c, 0x48, 0x6d, 0x48, 0x6e, 0x48, 0x70,
    0x48, 0x72, 0x48, 0x75, 0x48, 0x3a, 0x48, 0x42, 0x48, 0x43, 0x48, 0x44,
    0x48, 0x45, 0x48, 0x46, 0x48, 0x47, 0x48, 0x48, 0x49, 0x48, 0x4a, 0x48,
    0x4b, 0x48, 0x4c, 0x48, 0x4d, 0x48, 0x4e, 0x48, 0x4f, 0x48, 0x50, 0x48,
    0x51, 0x48, 0x52, 0x48, 0x53, 0x48, 0x54, 0x48, 0x55, 0x48, 0x56, 0x48,
    0x57, 0x48, 0x59, 0x48, 0x6a, 0x48, 0x6b, 0x48, 0x71, 0x48, 0x76, 0x48,
    0x77, 0x48, 0x78, 0x48, 0x79, 0x48, 0x7a};
const uint16_t HuffDecoderCommon::table11_199_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_200_emit_[44] = {
    0x49, 0x30, 0x49, 0x31, 0x49, 0x32, 0x49, 0x61, 0x49, 0x63, 0x49,
    0x65, 0x49, 0x69, 0x49, 0x6f, 0x49, 0x73, 0x49, 0x74, 0x49, 0x20,
    0x49, 0x25, 0x49, 0x2d, 0x49, 0x2e, 0x49, 0x2f, 0x49, 0x33, 0x49,
    0x34, 0x49, 0x35, 0x49, 0x36, 0x49, 0x37, 0x49, 0x38, 0x49, 0x39};
const uint8_t HuffDecoderCommon::table11_201_emit_[91] = {
    0x49, 0x3d, 0x49, 0x41, 0x49, 0x5f, 0x49, 0x62, 0x49, 0x64, 0x49, 0x66,
    0x49, 0x67, 0x49, 0x68, 0x49, 0x6c, 0x49, 0x6d, 0x49, 0x6e, 0x49, 0x70,
    0x49, 0x72, 0x49, 0x75, 0x49, 0x3a, 0x49, 0x42, 0x49, 0x43, 0x49, 0x44,
    0x49, 0x45, 0x49, 0x46, 0x49, 0x47, 0x49, 0x48, 0x49, 0x49, 0x4a, 0x49,
    0x4b, 0x49, 0x4c, 0x49, 0x4d, 0x49, 0x4e, 0x49, 0x4f, 0x49, 0x50, 0x49,
    0x51, 0x49, 0x52, 0x49, 0x53, 0x49, 0x54, 0x49, 0x55, 0x49, 0x56, 0x49,
    0x57, 0x49, 0x59, 0x49, 0x6a, 0x49, 0x6b, 0x49, 0x71, 0x49, 0x76, 0x49,
    0x77, 0x49, 0x78, 0x49, 0x79, 0x49, 0x7a};
const uint16_t HuffDecoderCommon::table11_201_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_202_emit_[44] = {
    0x4a, 0x30, 0x4a, 0x31, 0x4a, 0x32, 0x4a, 0x61, 0x4a, 0x63, 0x4a,
    0x65, 0x4a, 0x69, 0x4a, 0x6f, 0x4a, 0x73, 0x4a, 0x74, 0x4a, 0x20,
    0x4a, 0x25, 0x4a, 0x2d, 0x4a, 0x2e, 0x4a, 0x2f, 0x4a, 0x33, 0x4a,
    0x34, 0x4a, 0x35, 0x4a, 0x36, 0x4a, 0x37, 0x4a, 0x38, 0x4a, 0x39};
const uint8_t HuffDecoderCommon::table11_203_emit_[91] = {
    0x4a, 0x3d, 0x4a, 0x41, 0x4a, 0x5f, 0x4a, 0x62, 0x4a, 0x64, 0x4a, 0x66,
    0x4a, 0x67, 0x4a, 0x68, 0x4a, 0x6c, 0x4a, 0x6d, 0x4a, 0x6e, 0x4a, 0x70,
    0x4a, 0x72, 0x4a, 0x75, 0x4a, 0x3a, 0x4a, 0x42, 0x4a, 0x43, 0x4a, 0x44,
    0x4a, 0x45, 0x4a, 0x46, 0x4a, 0x47, 0x4a, 0x48, 0x4a, 0x49, 0x4a, 0x4a,
    0x4b, 0x4a, 0x4c, 0x4a, 0x4d, 0x4a, 0x4e, 0x4a, 0x4f, 0x4a, 0x50, 0x4a,
    0x51, 0x4a, 0x52, 0x4a, 0x53, 0x4a, 0x54, 0x4a, 0x55, 0x4a, 0x56, 0x4a,
    0x57, 0x4a, 0x59, 0x4a, 0x6a, 0x4a, 0x6b, 0x4a, 0x71, 0x4a, 0x76, 0x4a,
    0x77, 0x4a, 0x78, 0x4a, 0x79, 0x4a, 0x7a};
const uint16_t HuffDecoderCommon::table11_203_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_204_emit_[44] = {
    0x4b, 0x30, 0x4b, 0x31, 0x4b, 0x32, 0x4b, 0x61, 0x4b, 0x63, 0x4b,
    0x65, 0x4b, 0x69, 0x4b, 0x6f, 0x4b, 0x73, 0x4b, 0x74, 0x4b, 0x20,
    0x4b, 0x25, 0x4b, 0x2d, 0x4b, 0x2e, 0x4b, 0x2f, 0x4b, 0x33, 0x4b,
    0x34, 0x4b, 0x35, 0x4b, 0x36, 0x4b, 0x37, 0x4b, 0x38, 0x4b, 0x39};
const uint8_t HuffDecoderCommon::table11_205_emit_[91] = {
    0x4b, 0x3d, 0x4b, 0x41, 0x4b, 0x5f, 0x4b, 0x62, 0x4b, 0x64, 0x4b, 0x66,
    0x4b, 0x67, 0x4b, 0x68, 0x4b, 0x6c, 0x4b, 0x6d, 0x4b, 0x6e, 0x4b, 0x70,
    0x4b, 0x72, 0x4b, 0x75, 0x4b, 0x3a, 0x4b, 0x42, 0x4b, 0x43, 0x4b, 0x44,
    0x4b, 0x45, 0x4b, 0x46, 0x4b, 0x47, 0x4b, 0x48, 0x4b, 0x49, 0x4b, 0x4a,
    0x4b, 0x4b, 0x4c, 0x4b, 0x4d, 0x4b, 0x4e, 0x4b, 0x4f, 0x4b, 0x50, 0x4b,
    0x51, 0x4b, 0x52, 0x4b, 0x53, 0x4b, 0x54, 0x4b, 0x55, 0x4b, 0x56, 0x4b,
    0x57, 0x4b, 0x59, 0x4b, 0x6a, 0x4b, 0x6b, 0x4b, 0x71, 0x4b, 0x76, 0x4b,
    0x77, 0x4b, 0x78, 0x4b, 0x79, 0x4b, 0x7a};
const uint16_t HuffDecoderCommon::table11_205_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_206_emit_[44] = {
    0x4c, 0x30, 0x4c, 0x31, 0x4c, 0x32, 0x4c, 0x61, 0x4c, 0x63, 0x4c,
    0x65, 0x4c, 0x69, 0x4c, 0x6f, 0x4c, 0x73, 0x4c, 0x74, 0x4c, 0x20,
    0x4c, 0x25, 0x4c, 0x2d, 0x4c, 0x2e, 0x4c, 0x2f, 0x4c, 0x33, 0x4c,
    0x34, 0x4c, 0x35, 0x4c, 0x36, 0x4c, 0x37, 0x4c, 0x38, 0x4c, 0x39};
const uint8_t HuffDecoderCommon::table11_207_emit_[91] = {
    0x4c, 0x3d, 0x4c, 0x41, 0x4c, 0x5f, 0x4c, 0x62, 0x4c, 0x64, 0x4c, 0x66,
    0x4c, 0x67, 0x4c, 0x68, 0x4c, 0x6c, 0x4c, 0x6d, 0x4c, 0x6e, 0x4c, 0x70,
    0x4c, 0x72, 0x4c, 0x75, 0x4c, 0x3a, 0x4c, 0x42, 0x4c, 0x43, 0x4c, 0x44,
    0x4c, 0x45, 0x4c, 0x46, 0x4c, 0x47, 0x4c, 0x48, 0x4c, 0x49, 0x4c, 0x4a,
    0x4c, 0x4b, 0x4c, 0x4c, 0x4d, 0x4c, 0x4e, 0x4c, 0x4f, 0x4c, 0x50, 0x4c,
    0x51, 0x4c, 0x52, 0x4c, 0x53, 0x4c, 0x54, 0x4c, 0x55, 0x4c, 0x56, 0x4c,
    0x57, 0x4c, 0x59, 0x4c, 0x6a, 0x4c, 0x6b, 0x4c, 0x71, 0x4c, 0x76, 0x4c,
    0x77, 0x4c, 0x78, 0x4c, 0x79, 0x4c, 0x7a};
const uint16_t HuffDecoderCommon::table11_207_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_208_emit_[44] = {
    0x4d, 0x30, 0x4d, 0x31, 0x4d, 0x32, 0x4d, 0x61, 0x4d, 0x63, 0x4d,
    0x65, 0x4d, 0x69, 0x4d, 0x6f, 0x4d, 0x73, 0x4d, 0x74, 0x4d, 0x20,
    0x4d, 0x25, 0x4d, 0x2d, 0x4d, 0x2e, 0x4d, 0x2f, 0x4d, 0x33, 0x4d,
    0x34, 0x4d, 0x35, 0x4d, 0x36, 0x4d, 0x37, 0x4d, 0x38, 0x4d, 0x39};
const uint8_t HuffDecoderCommon::table11_209_emit_[91] = {
    0x4d, 0x3d, 0x4d, 0x41, 0x4d, 0x5f, 0x4d, 0x62, 0x4d, 0x64, 0x4d, 0x66,
    0x4d, 0x67, 0x4d, 0x68, 0x4d, 0x6c, 0x4d, 0x6d, 0x4d, 0x6e, 0x4d, 0x70,
    0x4d, 0x72, 0x4d, 0x75, 0x4d, 0x3a, 0x4d, 0x42, 0x4d, 0x43, 0x4d, 0x44,
    0x4d, 0x45, 0x4d, 0x46, 0x4d, 0x47, 0x4d, 0x48, 0x4d, 0x49, 0x4d, 0x4a,
    0x4d, 0x4b, 0x4d, 0x4c, 0x4d, 0x4d, 0x4e, 0x4d, 0x4f, 0x4d, 0x50, 0x4d,
    0x51, 0x4d, 0x52, 0x4d, 0x53, 0x4d, 0x54, 0x4d, 0x55, 0x4d, 0x56, 0x4d,
    0x57, 0x4d, 0x59, 0x4d, 0x6a, 0x4d, 0x6b, 0x4d, 0x71, 0x4d, 0x76, 0x4d,
    0x77, 0x4d, 0x78, 0x4d, 0x79, 0x4d, 0x7a};
const uint16_t HuffDecoderCommon::table11_209_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_210_emit_[44] = {
    0x4e, 0x30, 0x4e, 0x31, 0x4e, 0x32, 0x4e, 0x61, 0x4e, 0x63, 0x4e,
    0x65, 0x4e, 0x69, 0x4e, 0x6f, 0x4e, 0x73, 0x4e, 0x74, 0x4e, 0x20,
    0x4e, 0x25, 0x4e, 0x2d, 0x4e, 0x2e, 0x4e, 0x2f, 0x4e, 0x33, 0x4e,
    0x34, 0x4e, 0x35, 0x4e, 0x36, 0x4e, 0x37, 0x4e, 0x38, 0x4e, 0x39};
const uint8_t HuffDecoderCommon::table11_211_emit_[91] = {
    0x4e, 0x3d, 0x4e, 0x41, 0x4e, 0x5f, 0x4e, 0x62, 0x4e, 0x64, 0x4e, 0x66,
    0x4e, 0x67, 0x4e, 0x68, 0x4e, 0x6c, 0x4e, 0x6d, 0x4e, 0x6e, 0x4e, 0x70,
    0x4e, 0x72, 0x4e, 0x75, 0x4e, 0x3a, 0x4e, 0x42, 0x4e, 0x43, 0x4e, 0x44,
    0x4e, 0x45, 0x4e, 0x46, 0x4e, 0x47, 0x4e, 0x48, 0x4e, 0x49, 0x4e, 0x4a,
    0x4e, 0x4b, 0x4e, 0x4c, 0x4e, 0x4d, 0x4e, 0x4e, 0x4f, 0x4e, 0x50, 0x4e,
    0x51, 0x4e, 0x52, 0x4e, 0x53, 0x4e, 0x54, 0x4e, 0x55, 0x4e, 0x56, 0x4e,
    0x57, 0x4e, 0x59, 0x4e, 0x6a, 0x4e, 0x6b, 0x4e, 0x71, 0x4e, 0x76, 0x4e,
    0x77, 0x4e, 0x78, 0x4e, 0x79, 0x4e, 0x7a};
const uint16_t HuffDecoderCommon::table11_211_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_212_emit_[44] = {
    0x4f, 0x30, 0x4f, 0x31, 0x4f, 0x32, 0x4f, 0x61, 0x4f, 0x63, 0x4f,
    0x65, 0x4f, 0x69, 0x4f, 0x6f, 0x4f, 0x73, 0x4f, 0x74, 0x4f, 0x20,
    0x4f, 0x25, 0x4f, 0x2d, 0x4f, 0x2e, 0x4f, 0x2f, 0x4f, 0x33, 0x4f,
    0x34, 0x4f, 0x35, 0x4f, 0x36, 0x4f, 0x37, 0x4f, 0x38, 0x4f, 0x39};
const uint8_t HuffDecoderCommon::table11_213_emit_[91] = {
    0x4f, 0x3d, 0x4f, 0x41, 0x4f, 0x5f, 0x4f, 0x62, 0x4f, 0x64, 0x4f, 0x66,
    0x4f, 0x67, 0x4f, 0x68, 0x4f, 0x6c, 0x4f, 0x6d, 0x4f, 0x6e, 0x4f, 0x70,
    0x4f, 0x72, 0x4f, 0x75, 0x4f, 0x3a, 0x4f, 0x42, 0x4f, 0x43, 0x4f, 0x44,
    0x4f, 0x45, 0x4f, 0x46, 0x4f, 0x47, 0x4f, 0x48, 0x4f, 0x49, 0x4f, 0x4a,
    0x4f, 0x4b, 0x4f, 0x4c, 0x4f, 0x4d, 0x4f, 0x4e, 0x4f, 0x4f, 0x50, 0x4f,
    0x51, 0x4f, 0x52, 0x4f, 0x53, 0x4f, 0x54, 0x4f, 0x55, 0x4f, 0x56, 0x4f,
    0x57, 0x4f, 0x59, 0x4f, 0x6a, 0x4f, 0x6b, 0x4f, 0x71, 0x4f, 0x76, 0x4f,
    0x77, 0x4f, 0x78, 0x4f, 0x79, 0x4f, 0x7a};
const uint16_t HuffDecoderCommon::table11_213_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_214_emit_[44] = {
    0x50, 0x30, 0x50, 0x31, 0x50, 0x32, 0x50, 0x61, 0x50, 0x63, 0x50,
    0x65, 0x50, 0x69, 0x50, 0x6f, 0x50, 0x73, 0x50, 0x74, 0x50, 0x20,
    0x50, 0x25, 0x50, 0x2d, 0x50, 0x2e, 0x50, 0x2f, 0x50, 0x33, 0x50,
    0x34, 0x50, 0x35, 0x50, 0x36, 0x50, 0x37, 0x50, 0x38, 0x50, 0x39};
const uint8_t HuffDecoderCommon::table11_215_emit_[91] = {
    0x50, 0x3d, 0x50, 0x41, 0x50, 0x5f, 0x50, 0x62, 0x50, 0x64, 0x50, 0x66,
    0x50, 0x67, 0x50, 0x68, 0x50, 0x6c, 0x50, 0x6d, 0x50, 0x6e, 0x50, 0x70,
    0x50, 0x72, 0x50, 0x75, 0x50, 0x3a, 0x50, 0x42, 0x50, 0x43, 0x50, 0x44,
    0x50, 0x45, 0x50, 0x46, 0x50, 0x47, 0x50, 0x48, 0x50, 0x49, 0x50, 0x4a,
    0x50, 0x4b, 0x50, 0x4c, 0x50, 0x4d, 0x50, 0x4e, 0x50, 0x4f, 0x50, 0x50,
    0x51, 0x50, 0x52, 0x50, 0x53, 0x50, 0x54, 0x50, 0x55, 0x50, 0x56, 0x50,
    0x57, 0x50, 0x59, 0x50, 0x6a, 0x50, 0x6b, 0x50, 0x71, 0x50, 0x76, 0x50,
    0x77, 0x50, 0x78, 0x50, 0x79, 0x50, 0x7a};
const uint16_t HuffDecoderCommon::table11_215_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_216_emit_[44] = {
    0x51, 0x30, 0x51, 0x31, 0x51, 0x32, 0x51, 0x61, 0x51, 0x63, 0x51,
    0x65, 0x51, 0x69, 0x51, 0x6f, 0x51, 0x73, 0x51, 0x74, 0x51, 0x20,
    0x51, 0x25, 0x51, 0x2d, 0x51, 0x2e, 0x51, 0x2f, 0x51, 0x33, 0x51,
    0x34, 0x51, 0x35, 0x51, 0x36, 0x51, 0x37, 0x51, 0x38, 0x51, 0x39};
const uint8_t HuffDecoderCommon::table11_217_emit_[91] = {
    0x51, 0x3d, 0x51, 0x41, 0x51, 0x5f, 0x51, 0x62, 0x51, 0x64, 0x51, 0x66,
    0x51, 0x67, 0x51, 0x68, 0x51, 0x6c, 0x51, 0x6d, 0x51, 0x6e, 0x51, 0x70,
    0x51, 0x72, 0x51, 0x75, 0x51, 0x3a, 0x51, 0x42, 0x51, 0x43, 0x51, 0x44,
    0x51, 0x45, 0x51, 0x46, 0x51, 0x47, 0x51, 0x48, 0x51, 0x49, 0x51, 0x4a,
    0x51, 0x4b, 0x51, 0x4c, 0x51, 0x4d, 0x51, 0x4e, 0x51, 0x4f, 0x51, 0x50,
    0x51, 0x51, 0x52, 0x51, 0x53, 0x51, 0x54, 0x51, 0x55, 0x51, 0x56, 0x51,
    0x57, 0x51, 0x59, 0x51, 0x6a, 0x51, 0x6b, 0x51, 0x71, 0x51, 0x76, 0x51,
    0x77, 0x51, 0x78, 0x51, 0x79, 0x51, 0x7a};
const uint16_t HuffDecoderCommon::table11_217_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_218_emit_[44] = {
    0x52, 0x30, 0x52, 0x31, 0x52, 0x32, 0x52, 0x61, 0x52, 0x63, 0x52,
    0x65, 0x52, 0x69, 0x52, 0x6f, 0x52, 0x73, 0x52, 0x74, 0x52, 0x20,
    0x52, 0x25, 0x52, 0x2d, 0x52, 0x2e, 0x52, 0x2f, 0x52, 0x33, 0x52,
    0x34, 0x52, 0x35, 0x52, 0x36, 0x52, 0x37, 0x52, 0x38, 0x52, 0x39};
const uint8_t HuffDecoderCommon::table11_219_emit_[91] = {
    0x52, 0x3d, 0x52, 0x41, 0x52, 0x5f, 0x52, 0x62, 0x52, 0x64, 0x52, 0x66,
    0x52, 0x67, 0x52, 0x68, 0x52, 0x6c, 0x52, 0x6d, 0x52, 0x6e, 0x52, 0x70,
    0x52, 0x72, 0x52, 0x75, 0x52, 0x3a, 0x52, 0x42, 0x52, 0x43, 0x52, 0x44,
    0x52, 0x45, 0x52, 0x46, 0x52, 0x47, 0x52, 0x48, 0x52, 0x49, 0x52, 0x4a,
    0x52, 0x4b, 0x52, 0x4c, 0x52, 0x4d, 0x52, 0x4e, 0x52, 0x4f, 0x52, 0x50,
    0x52, 0x51, 0x52, 0x52, 0x53, 0x52, 0x54, 0x52, 0x55, 0x52, 0x56, 0x52,
    0x57, 0x52, 0x59, 0x52, 0x6a, 0x52, 0x6b, 0x52, 0x71, 0x52, 0x76, 0x52,
    0x77, 0x52, 0x78, 0x52, 0x79, 0x52, 0x7a};
const uint16_t HuffDecoderCommon::table11_219_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x00fd, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_220_emit_[44] = {
    0x53, 0x30, 0x53, 0x31, 0x53, 0x32, 0x53, 0x61, 0x53, 0x63, 0x53,
    0x65, 0x53, 0x69, 0x53, 0x6f, 0x53, 0x73, 0x53, 0x74, 0x53, 0x20,
    0x53, 0x25, 0x53, 0x2d, 0x53, 0x2e, 0x53, 0x2f, 0x53, 0x33, 0x53,
    0x34, 0x53, 0x35, 0x53, 0x36, 0x53, 0x37, 0x53, 0x38, 0x53, 0x39};
const uint8_t HuffDecoderCommon::table11_221_emit_[91] = {
    0x53, 0x3d, 0x53, 0x41, 0x53, 0x5f, 0x53, 0x62, 0x53, 0x64, 0x53, 0x66,
    0x53, 0x67, 0x53, 0x68, 0x53, 0x6c, 0x53, 0x6d, 0x53, 0x6e, 0x53, 0x70,
    0x53, 0x72, 0x53, 0x75, 0x53, 0x3a, 0x53, 0x42, 0x53, 0x43, 0x53, 0x44,
    0x53, 0x45, 0x53, 0x46, 0x53, 0x47, 0x53, 0x48, 0x53, 0x49, 0x53, 0x4a,
    0x53, 0x4b, 0x53, 0x4c, 0x53, 0x4d, 0x53, 0x4e, 0x53, 0x4f, 0x53, 0x50,
    0x53, 0x51, 0x53, 0x52, 0x53, 0x53, 0x54, 0x53, 0x55, 0x53, 0x56, 0x53,
    0x57, 0x53, 0x59, 0x53, 0x6a, 0x53, 0x6b, 0x53, 0x71, 0x53, 0x76, 0x53,
    0x77, 0x53, 0x78, 0x53, 0x79, 0x53, 0x7a};
const uint16_t HuffDecoderCommon::table11_221_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0105, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_222_emit_[44] = {
    0x54, 0x30, 0x54, 0x31, 0x54, 0x32, 0x54, 0x61, 0x54, 0x63, 0x54,
    0x65, 0x54, 0x69, 0x54, 0x6f, 0x54, 0x73, 0x54, 0x74, 0x54, 0x20,
    0x54, 0x25, 0x54, 0x2d, 0x54, 0x2e, 0x54, 0x2f, 0x54, 0x33, 0x54,
    0x34, 0x54, 0x35, 0x54, 0x36, 0x54, 0x37, 0x54, 0x38, 0x54, 0x39};
const uint8_t HuffDecoderCommon::table11_223_emit_[91] = {
    0x54, 0x3d, 0x54, 0x41, 0x54, 0x5f, 0x54, 0x62, 0x54, 0x64, 0x54, 0x66,
    0x54, 0x67, 0x54, 0x68, 0x54, 0x6c, 0x54, 0x6d, 0x54, 0x6e, 0x54, 0x70,
    0x54, 0x72, 0x54, 0x75, 0x54, 0x3a, 0x54, 0x42, 0x54, 0x43, 0x54, 0x44,
    0x54, 0x45, 0x54, 0x46, 0x54, 0x47, 0x54, 0x48, 0x54, 0x49, 0x54, 0x4a,
    0x54, 0x4b, 0x54, 0x4c, 0x54, 0x4d, 0x54, 0x4e, 0x54, 0x4f, 0x54, 0x50,
    0x54, 0x51, 0x54, 0x52, 0x54, 0x53, 0x54, 0x54, 0x55, 0x54, 0x56, 0x54,
    0x57, 0x54, 0x59, 0x54, 0x6a, 0x54, 0x6b, 0x54, 0x71, 0x54, 0x76, 0x54,
    0x77, 0x54, 0x78, 0x54, 0x79, 0x54, 0x7a};
const uint16_t HuffDecoderCommon::table11_223_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x010d, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_224_emit_[44] = {
    0x55, 0x30, 0x55, 0x31, 0x55, 0x32, 0x55, 0x61, 0x55, 0x63, 0x55,
    0x65, 0x55, 0x69, 0x55, 0x6f, 0x55, 0x73, 0x55, 0x74, 0x55, 0x20,
    0x55, 0x25, 0x55, 0x2d, 0x55, 0x2e, 0x55, 0x2f, 0x55, 0x33, 0x55,
    0x34, 0x55, 0x35, 0x55, 0x36, 0x55, 0x37, 0x55, 0x38, 0x55, 0x39};
const uint8_t HuffDecoderCommon::table11_225_emit_[91] = {
    0x55, 0x3d, 0x55, 0x41, 0x55, 0x5f, 0x55, 0x62, 0x55, 0x64, 0x55, 0x66,
    0x55, 0x67, 0x55, 0x68, 0x55, 0x6c, 0x55, 0x6d, 0x55, 0x6e, 0x55, 0x70,
    0x55, 0x72, 0x55, 0x75, 0x55, 0x3a, 0x55, 0x42, 0x55, 0x43, 0x55, 0x44,
    0x55, 0x45, 0x55, 0x46, 0x55, 0x47, 0x55, 0x48, 0x55, 0x49, 0x55, 0x4a,
    0x55, 0x4b, 0x55, 0x4c, 0x55, 0x4d, 0x55, 0x4e, 0x55, 0x4f, 0x55, 0x50,
    0x55, 0x51, 0x55, 0x52, 0x55, 0x53, 0x55, 0x54, 0x55, 0x55, 0x56, 0x55,
    0x57, 0x55, 0x59, 0x55, 0x6a, 0x55, 0x6b, 0x55, 0x71, 0x55, 0x76, 0x55,
    0x77, 0x55, 0x78, 0x55, 0x79, 0x55, 0x7a};
const uint16_t HuffDecoderCommon::table11_225_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0115, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_226_emit_[44] = {
    0x56, 0x30, 0x56, 0x31, 0x56, 0x32, 0x56, 0x61, 0x56, 0x63, 0x56,
    0x65, 0x56, 0x69, 0x56, 0x6f, 0x56, 0x73, 0x56, 0x74, 0x56, 0x20,
    0x56, 0x25, 0x56, 0x2d, 0x56, 0x2e, 0x56, 0x2f, 0x56, 0x33, 0x56,
    0x34, 0x56, 0x35, 0x56, 0x36, 0x56, 0x37, 0x56, 0x38, 0x56, 0x39};
const uint8_t HuffDecoderCommon::table11_227_emit_[91] = {
    0x56, 0x3d, 0x56, 0x41, 0x56, 0x5f, 0x56, 0x62, 0x56, 0x64, 0x56, 0x66,
    0x56, 0x67, 0x56, 0x68, 0x56, 0x6c, 0x56, 0x6d, 0x56, 0x6e, 0x56, 0x70,
    0x56, 0x72, 0x56, 0x75, 0x56, 0x3a, 0x56, 0x42, 0x56, 0x43, 0x56, 0x44,
    0x56, 0x45, 0x56, 0x46, 0x56, 0x47, 0x56, 0x48, 0x56, 0x49, 0x56, 0x4a,
    0x56, 0x4b, 0x56, 0x4c, 0x56, 0x4d, 0x56, 0x4e, 0x56, 0x4f, 0x56, 0x50,
    0x56, 0x51, 0x56, 0x52, 0x56, 0x53, 0x56, 0x54, 0x56, 0x55, 0x56, 0x56,
    0x57, 0x56, 0x59, 0x56, 0x6a, 0x56, 0x6b, 0x56, 0x71, 0x56, 0x76, 0x56,
    0x77, 0x56, 0x78, 0x56, 0x79, 0x56, 0x7a};
const uint16_t HuffDecoderCommon::table11_227_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x011d, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_228_emit_[44] = {
    0x57, 0x30, 0x57, 0x31, 0x57, 0x32, 0x57, 0x61, 0x57, 0x63, 0x57,
    0x65, 0x57, 0x69, 0x57, 0x6f, 0x57, 0x73, 0x57, 0x74, 0x57, 0x20,
    0x57, 0x25, 0x57, 0x2d, 0x57, 0x2e, 0x57, 0x2f, 0x57, 0x33, 0x57,
    0x34, 0x57, 0x35, 0x57, 0x36, 0x57, 0x37, 0x57, 0x38, 0x57, 0x39};
const uint8_t HuffDecoderCommon::table11_229_emit_[91] = {
    0x57, 0x3d, 0x57, 0x41, 0x57, 0x5f, 0x57, 0x62, 0x57, 0x64, 0x57, 0x66,
    0x57, 0x67, 0x57, 0x68, 0x57, 0x6c, 0x57, 0x6d, 0x57, 0x6e, 0x57, 0x70,
    0x57, 0x72, 0x57, 0x75, 0x57, 0x3a, 0x57, 0x42, 0x57, 0x43, 0x57, 0x44,
    0x57, 0x45, 0x57, 0x46, 0x57, 0x47, 0x57, 0x48, 0x57, 0x49, 0x57, 0x4a,
    0x57, 0x4b, 0x57, 0x4c, 0x57, 0x4d, 0x57, 0x4e, 0x57, 0x4f, 0x57, 0x50,
    0x57, 0x51, 0x57, 0x52, 0x57, 0x53, 0x57, 0x54, 0x57, 0x55, 0x57, 0x56,
    0x57, 0x57, 0x59, 0x57, 0x6a, 0x57, 0x6b, 0x57, 0x71, 0x57, 0x76, 0x57,
    0x77, 0x57, 0x78, 0x57, 0x79, 0x57, 0x7a};
const uint16_t HuffDecoderCommon::table11_229_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0125, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_230_emit_[44] = {
    0x59, 0x30, 0x59, 0x31, 0x59, 0x32, 0x59, 0x61, 0x59, 0x63, 0x59,
    0x65, 0x59, 0x69, 0x59, 0x6f, 0x59, 0x73, 0x59, 0x74, 0x59, 0x20,
    0x59, 0x25, 0x59, 0x2d, 0x59, 0x2e, 0x59, 0x2f, 0x59, 0x33, 0x59,
    0x34, 0x59, 0x35, 0x59, 0x36, 0x59, 0x37, 0x59, 0x38, 0x59, 0x39};
const uint8_t HuffDecoderCommon::table11_231_emit_[91] = {
    0x59, 0x3d, 0x59, 0x41, 0x59, 0x5f, 0x59, 0x62, 0x59, 0x64, 0x59, 0x66,
    0x59, 0x67, 0x59, 0x68, 0x59, 0x6c, 0x59, 0x6d, 0x59, 0x6e, 0x59, 0x70,
    0x59, 0x72, 0x59, 0x75, 0x59, 0x3a, 0x59, 0x42, 0x59, 0x43, 0x59, 0x44,
    0x59, 0x45, 0x59, 0x46, 0x59, 0x47, 0x59, 0x48, 0x59, 0x49, 0x59, 0x4a,
    0x59, 0x4b, 0x59, 0x4c, 0x59, 0x4d, 0x59, 0x4e, 0x59, 0x4f, 0x59, 0x50,
    0x59, 0x51, 0x59, 0x52, 0x59, 0x53, 0x59, 0x54, 0x59, 0x55, 0x59, 0x56,
    0x59, 0x57, 0x59, 0x59, 0x6a, 0x59, 0x6b, 0x59, 0x71, 0x59, 0x76, 0x59,
    0x77, 0x59, 0x78, 0x59, 0x79, 0x59, 0x7a};
const uint16_t HuffDecoderCommon::table11_231_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x012d,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_232_emit_[44] = {
    0x6a, 0x30, 0x6a, 0x31, 0x6a, 0x32, 0x6a, 0x61, 0x6a, 0x63, 0x6a,
    0x65, 0x6a, 0x69, 0x6a, 0x6f, 0x6a, 0x73, 0x6a, 0x74, 0x6a, 0x20,
    0x6a, 0x25, 0x6a, 0x2d, 0x6a, 0x2e, 0x6a, 0x2f, 0x6a, 0x33, 0x6a,
    0x34, 0x6a, 0x35, 0x6a, 0x36, 0x6a, 0x37, 0x6a, 0x38, 0x6a, 0x39};
const uint8_t HuffDecoderCommon::table11_233_emit_[91] = {
    0x6a, 0x3d, 0x6a, 0x41, 0x6a, 0x5f, 0x6a, 0x62, 0x6a, 0x64, 0x6a, 0x66,
    0x6a, 0x67, 0x6a, 0x68, 0x6a, 0x6c, 0x6a, 0x6d, 0x6a, 0x6e, 0x6a, 0x70,
    0x6a, 0x72, 0x6a, 0x75, 0x6a, 0x3a, 0x6a, 0x42, 0x6a, 0x43, 0x6a, 0x44,
    0x6a, 0x45, 0x6a, 0x46, 0x6a, 0x47, 0x6a, 0x48, 0x6a, 0x49, 0x6a, 0x4a,
    0x6a, 0x4b, 0x6a, 0x4c, 0x6a, 0x4d, 0x6a, 0x4e, 0x6a, 0x4f, 0x6a, 0x50,
    0x6a, 0x51, 0x6a, 0x52, 0x6a, 0x53, 0x6a, 0x54, 0x6a, 0x55, 0x6a, 0x56,
    0x6a, 0x57, 0x6a, 0x59, 0x6a, 0x6a, 0x6b, 0x6a, 0x71, 0x6a, 0x76, 0x6a,
    0x77, 0x6a, 0x78, 0x6a, 0x79, 0x6a, 0x7a};
const uint16_t HuffDecoderCommon::table11_233_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131,
    0x0135, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_234_emit_[44] = {
    0x6b, 0x30, 0x6b, 0x31, 0x6b, 0x32, 0x6b, 0x61, 0x6b, 0x63, 0x6b,
    0x65, 0x6b, 0x69, 0x6b, 0x6f, 0x6b, 0x73, 0x6b, 0x74, 0x6b, 0x20,
    0x6b, 0x25, 0x6b, 0x2d, 0x6b, 0x2e, 0x6b, 0x2f, 0x6b, 0x33, 0x6b,
    0x34, 0x6b, 0x35, 0x6b, 0x36, 0x6b, 0x37, 0x6b, 0x38, 0x6b, 0x39};
const uint8_t HuffDecoderCommon::table11_235_emit_[91] = {
    0x6b, 0x3d, 0x6b, 0x41, 0x6b, 0x5f, 0x6b, 0x62, 0x6b, 0x64, 0x6b, 0x66,
    0x6b, 0x67, 0x6b, 0x68, 0x6b, 0x6c, 0x6b, 0x6d, 0x6b, 0x6e, 0x6b, 0x70,
    0x6b, 0x72, 0x6b, 0x75, 0x6b, 0x3a, 0x6b, 0x42, 0x6b, 0x43, 0x6b, 0x44,
    0x6b, 0x45, 0x6b, 0x46, 0x6b, 0x47, 0x6b, 0x48, 0x6b, 0x49, 0x6b, 0x4a,
    0x6b, 0x4b, 0x6b, 0x4c, 0x6b, 0x4d, 0x6b, 0x4e, 0x6b, 0x4f, 0x6b, 0x50,
    0x6b, 0x51, 0x6b, 0x52, 0x6b, 0x53, 0x6b, 0x54, 0x6b, 0x55, 0x6b, 0x56,
    0x6b, 0x57, 0x6b, 0x59, 0x6b, 0x6a, 0x6b, 0x6b, 0x71, 0x6b, 0x76, 0x6b,
    0x77, 0x6b, 0x78, 0x6b, 0x79, 0x6b, 0x7a};
const uint16_t HuffDecoderCommon::table11_235_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131,
    0x0139, 0x013d, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_236_emit_[44] = {
    0x71, 0x30, 0x71, 0x31, 0x71, 0x32, 0x71, 0x61, 0x71, 0x63, 0x71,
    0x65, 0x71, 0x69, 0x71, 0x6f, 0x71, 0x73, 0x71, 0x74, 0x71, 0x20,
    0x71, 0x25, 0x71, 0x2d, 0x71, 0x2e, 0x71, 0x2f, 0x71, 0x33, 0x71,
    0x34, 0x71, 0x35, 0x71, 0x36, 0x71, 0x37, 0x71, 0x38, 0x71, 0x39};
const uint8_t HuffDecoderCommon::table11_237_emit_[91] = {
    0x71, 0x3d, 0x71, 0x41, 0x71, 0x5f, 0x71, 0x62, 0x71, 0x64, 0x71, 0x66,
    0x71, 0x67, 0x71, 0x68, 0x71, 0x6c, 0x71, 0x6d, 0x71, 0x6e, 0x71, 0x70,
    0x71, 0x72, 0x71, 0x75, 0x71, 0x3a, 0x71, 0x42, 0x71, 0x43, 0x71, 0x44,
    0x71, 0x45, 0x71, 0x46, 0x71, 0x47, 0x71, 0x48, 0x71, 0x49, 0x71, 0x4a,
    0x71, 0x4b, 0x71, 0x4c, 0x71, 0x4d, 0x71, 0x4e, 0x71, 0x4f, 0x71, 0x50,
    0x71, 0x51, 0x71, 0x52, 0x71, 0x53, 0x71, 0x54, 0x71, 0x55, 0x71, 0x56,
    0x71, 0x57, 0x71, 0x59, 0x71, 0x6a, 0x71, 0x6b, 0x71, 0x71, 0x76, 0x71,
    0x77, 0x71, 0x78, 0x71, 0x79, 0x71, 0x7a};
const uint16_t HuffDecoderCommon::table11_237_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131,
    0x0139, 0x0141, 0x0145, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_238_emit_[44] = {
    0x76, 0x30, 0x76, 0x31, 0x76, 0x32, 0x76, 0x61, 0x76, 0x63, 0x76,
    0x65, 0x76, 0x69, 0x76, 0x6f, 0x76, 0x73, 0x76, 0x74, 0x76, 0x20,
    0x76, 0x25, 0x76, 0x2d, 0x76, 0x2e, 0x76, 0x2f, 0x76, 0x33, 0x76,
    0x34, 0x76, 0x35, 0x76, 0x36, 0x76, 0x37, 0x76, 0x38, 0x76, 0x39};
const uint8_t HuffDecoderCommon::table11_239_emit_[91] = {
    0x76, 0x3d, 0x76, 0x41, 0x76, 0x5f, 0x76, 0x62, 0x76, 0x64, 0x76, 0x66,
    0x76, 0x67, 0x76, 0x68, 0x76, 0x6c, 0x76, 0x6d, 0x76, 0x6e, 0x76, 0x70,
    0x76, 0x72, 0x76, 0x75, 0x76, 0x3a, 0x76, 0x42, 0x76, 0x43, 0x76, 0x44,
    0x76, 0x45, 0x76, 0x46, 0x76, 0x47, 0x76, 0x48, 0x76, 0x49, 0x76, 0x4a,
    0x76, 0x4b, 0x76, 0x4c, 0x76, 0x4d, 0x76, 0x4e, 0x76, 0x4f, 0x76, 0x50,
    0x76, 0x51, 0x76, 0x52, 0x76, 0x53, 0x76, 0x54, 0x76, 0x55, 0x76, 0x56,
    0x76, 0x57, 0x76, 0x59, 0x76, 0x6a, 0x76, 0x6b, 0x76, 0x71, 0x76, 0x76,
    0x77, 0x76, 0x78, 0x76, 0x79, 0x76, 0x7a};
const uint16_t HuffDecoderCommon::table11_239_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131,
    0x0139, 0x0141, 0x0149, 0x014d, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_240_emit_[44] = {
    0x77, 0x30, 0x77, 0x31, 0x77, 0x32, 0x77, 0x61, 0x77, 0x63, 0x77,
    0x65, 0x77, 0x69, 0x77, 0x6f, 0x77, 0x73, 0x77, 0x74, 0x77, 0x20,
    0x77, 0x25, 0x77, 0x2d, 0x77, 0x2e, 0x77, 0x2f, 0x77, 0x33, 0x77,
    0x34, 0x77, 0x35, 0x77, 0x36, 0x77, 0x37, 0x77, 0x38, 0x77, 0x39};
const uint8_t HuffDecoderCommon::table11_241_emit_[91] = {
    0x77, 0x3d, 0x77, 0x41, 0x77, 0x5f, 0x77, 0x62, 0x77, 0x64, 0x77, 0x66,
    0x77, 0x67, 0x77, 0x68, 0x77, 0x6c, 0x77, 0x6d, 0x77, 0x6e, 0x77, 0x70,
    0x77, 0x72, 0x77, 0x75, 0x77, 0x3a, 0x77, 0x42, 0x77, 0x43, 0x77, 0x44,
    0x77, 0x45, 0x77, 0x46, 0x77, 0x47, 0x77, 0x48, 0x77, 0x49, 0x77, 0x4a,
    0x77, 0x4b, 0x77, 0x4c, 0x77, 0x4d, 0x77, 0x4e, 0x77, 0x4f, 0x77, 0x50,
    0x77, 0x51, 0x77, 0x52, 0x77, 0x53, 0x77, 0x54, 0x77, 0x55, 0x77, 0x56,
    0x77, 0x57, 0x77, 0x59, 0x77, 0x6a, 0x77, 0x6b, 0x77, 0x71, 0x77, 0x76,
    0x77, 0x77, 0x78, 0x77, 0x79, 0x77, 0x7a};
const uint16_t HuffDecoderCommon::table11_241_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131,
    0x0139, 0x0141, 0x0149, 0x0151, 0x0155, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_242_emit_[44] = {
    0x78, 0x30, 0x78, 0x31, 0x78, 0x32, 0x78, 0x61, 0x78, 0x63, 0x78,
    0x65, 0x78, 0x69, 0x78, 0x6f, 0x78, 0x73, 0x78, 0x74, 0x78, 0x20,
    0x78, 0x25, 0x78, 0x2d, 0x78, 0x2e, 0x78, 0x2f, 0x78, 0x33, 0x78,
    0x34, 0x78, 0x35, 0x78, 0x36, 0x78, 0x37, 0x78, 0x38, 0x78, 0x39};
const uint8_t HuffDecoderCommon::table11_243_emit_[91] = {
    0x78, 0x3d, 0x78, 0x41, 0x78, 0x5f, 0x78, 0x62, 0x78, 0x64, 0x78, 0x66,
    0x78, 0x67, 0x78, 0x68, 0x78, 0x6c, 0x78, 0x6d, 0x78, 0x6e, 0x78, 0x70,
    0x78, 0x72, 0x78, 0x75, 0x78, 0x3a, 0x78, 0x42, 0x78, 0x43, 0x78, 0x44,
    0x78, 0x45, 0x78, 0x46, 0x78, 0x47, 0x78, 0x48, 0x78, 0x49, 0x78, 0x4a,
    0x78, 0x4b, 0x78, 0x4c, 0x78, 0x4d, 0x78, 0x4e, 0x78, 0x4f, 0x78, 0x50,
    0x78, 0x51, 0x78, 0x52, 0x78, 0x53, 0x78, 0x54, 0x78, 0x55, 0x78, 0x56,
    0x78, 0x57, 0x78, 0x59, 0x78, 0x6a, 0x78, 0x6b, 0x78, 0x71, 0x78, 0x76,
    0x78, 0x77, 0x78, 0x78, 0x79, 0x78, 0x7a};
const uint16_t HuffDecoderCommon::table11_243_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131,
    0x0139, 0x0141, 0x0149, 0x0151, 0x0159, 0x015d, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_244_emit_[44] = {
    0x79, 0x30, 0x79, 0x31, 0x79, 0x32, 0x79, 0x61, 0x79, 0x63, 0x79,
    0x65, 0x79, 0x69, 0x79, 0x6f, 0x79, 0x73, 0x79, 0x74, 0x79, 0x20,
    0x79, 0x25, 0x79, 0x2d, 0x79, 0x2e, 0x79, 0x2f, 0x79, 0x33, 0x79,
    0x34, 0x79, 0x35, 0x79, 0x36, 0x79, 0x37, 0x79, 0x38, 0x79, 0x39};
const uint8_t HuffDecoderCommon::table11_245_emit_[91] = {
    0x79, 0x3d, 0x79, 0x41, 0x79, 0x5f, 0x79, 0x62, 0x79, 0x64, 0x79, 0x66,
    0x79, 0x67, 0x79, 0x68, 0x79, 0x6c, 0x79, 0x6d, 0x79, 0x6e, 0x79, 0x70,
    0x79, 0x72, 0x79, 0x75, 0x79, 0x3a, 0x79, 0x42, 0x79, 0x43, 0x79, 0x44,
    0x79, 0x45, 0x79, 0x46, 0x79, 0x47, 0x79, 0x48, 0x79, 0x49, 0x79, 0x4a,
    0x79, 0x4b, 0x79, 0x4c, 0x79, 0x4d, 0x79, 0x4e, 0x79, 0x4f, 0x79, 0x50,
    0x79, 0x51, 0x79, 0x52, 0x79, 0x53, 0x79, 0x54, 0x79, 0x55, 0x79, 0x56,
    0x79, 0x57, 0x79, 0x59, 0x79, 0x6a, 0x79, 0x6b, 0x79, 0x71, 0x79, 0x76,
    0x79, 0x77, 0x79, 0x78, 0x79, 0x79, 0x7a};
const uint16_t HuffDecoderCommon::table11_245_inner_[48] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071,
    0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1,
    0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1,
    0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0121, 0x0129, 0x0131,
    0x0139, 0x0141, 0x0149, 0x0151, 0x0159, 0x0161, 0x0165, 0x0002};
const uint8_t HuffDecoderCommon::table11_246_emit_[44] = {
    0x7a, 0x30, 0x7a, 0x31, 0x7a, 0x32, 0x7a, 0x61, 0x7a, 0x63, 0x7a,
    0x65, 0x7a, 0x69, 0x7a, 0x6f, 0x7a, 0x73, 0x7a, 0x74, 0x7a, 0x20,
    0x7a, 0x25, 0x7a, 0x2d, 0x7a, 0x2e, 0x7a, 0x2f, 0x7a, 0x33, 0x7a,
    0x34, 0x7a, 0x35, 0x7a, 0x36, 0x7a, 0x37, 0x7a, 0x38, 0x7a, 0x39};
const uint8_t HuffDecoderCommon::table11_247_emit_[92] = {
    0x7a, 0x3d, 0x7a, 0x41, 0x7a, 0x5f, 0x7a, 0x62, 0x7a, 0x64, 0x7a, 0x66,
    0x7a, 0x67, 0x7a, 0x68, 0x7a, 0x6c, 0x7a, 0x6d, 0x7a, 0x6e, 0x7a, 0x70,
    0x7a, 0x72, 0x7a, 0x75, 0x7a, 0x3a, 0x7a, 0x42, 0x7a, 0x43, 0x7a, 0x44,
    0x7a, 0x45, 0x7a, 0x46, 0x7a, 0x47, 0x7a, 0x48, 0x7a, 0x49, 0x7a, 0x4a,
    0x7a, 0x4b, 0x7a, 0x4c, 0x7a, 0x4d, 0x7a, 0x4e, 0x7a, 0x4f, 0x7a, 0x50,
    0x7a, 0x51, 0x7a, 0x52, 0x7a, 0x53, 0x7a, 0x54, 0x7a, 0x55, 0x7a, 0x56,
    0x7a, 0x57, 0x7a, 0x59, 0x7a, 0x6a, 0x7a, 0x6b, 0x7a, 0x71, 0x7a, 0x76,
    0x7a, 0x77, 0x7a, 0x78, 0x7a, 0x79, 0x7a, 0x7a};
const uint8_t HuffDecoderCommon::table11_248_emit_[72] = {
    0x26, 0x30, 0x26, 0x31, 0x26, 0x32, 0x26, 0x61, 0x26, 0x63, 0x26, 0x65,
    0x26, 0x69, 0x26, 0x6f, 0x26, 0x73, 0x26, 0x74, 0x26, 0x20, 0x26, 0x25,
    0x26, 0x2d, 0x26, 0x2e, 0x26, 0x2f, 0x26, 0x33, 0x26, 0x34, 0x26, 0x35,
    0x26, 0x36, 0x26, 0x37, 0x26, 0x38, 0x26, 0x39, 0x26, 0x3d, 0x26, 0x41,
    0x26, 0x5f, 0x26, 0x62, 0x26, 0x64, 0x26, 0x66, 0x26, 0x67, 0x26, 0x68,
    0x26, 0x6c, 0x26, 0x6d, 0x26, 0x6e, 0x26, 0x70, 0x26, 0x72, 0x26, 0x75};
const uint8_t HuffDecoderCommon::table11_249_emit_[72] = {
    0x2a, 0x30, 0x2a, 0x31, 0x2a, 0x32, 0x2a, 0x61, 0x2a, 0x63, 0x2a, 0x65,
    0x2a, 0x69, 0x2a, 0x6f, 0x2a, 0x73, 0x2a, 0x74, 0x2a, 0x20, 0x2a, 0x25,
    0x2a, 0x2d, 0x2a, 0x2e, 0x2a, 0x2f, 0x2a, 0x33, 0x2a, 0x34, 0x2a, 0x35,
    0x2a, 0x36, 0x2a, 0x37, 0x2a, 0x38, 0x2a, 0x39, 0x2a, 0x3d, 0x2a, 0x41,
    0x2a, 0x5f, 0x2a, 0x62, 0x2a, 0x64, 0x2a, 0x66, 0x2a, 0x67, 0x2a, 0x68,
    0x2a, 0x6c, 0x2a, 0x6d, 0x2a, 0x6e, 0x2a, 0x70, 0x2a, 0x72, 0x2a, 0x75};
const uint8_t HuffDecoderCommon::table11_250_emit_[72] = {
    0x2c, 0x30, 0x2c, 0x31, 0x2c, 0x32, 0x2c, 0x61, 0x2c, 0x63, 0x2c, 0x65,
    0x2c, 0x69, 0x2c, 0x6f, 0x2c, 0x73, 0x2c, 0x74, 0x2c, 0x20, 0x2c, 0x25,
    0x2c, 0x2d, 0x2c, 0x2e, 0x2c, 0x2f, 0x2c, 0x33, 0x2c, 0x34, 0x2c, 0x35,
    0x2c, 0x36, 0x2c, 0x37, 0x2c, 0x38, 0x2c, 0x39, 0x2c, 0x3d, 0x2c, 0x41,
    0x2c, 0x5f, 0x2c, 0x62, 0x2c, 0x64, 0x2c, 0x66, 0x2c, 0x67, 0x2c, 0x68,
    0x2c, 0x6c, 0x2c, 0x6d, 0x2c, 0x6e, 0x2c, 0x70, 0x2c, 0x72, 0x2c, 0x75};
const uint8_t HuffDecoderCommon::table11_251_emit_[72] = {
    0x3b, 0x30, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x61, 0x3b, 0x63, 0x3b, 0x65,
    0x3b, 0x69, 0x3b, 0x6f, 0x3b, 0x73, 0x3b, 0x74, 0x3b, 0x20, 0x3b, 0x25,
    0x3b, 0x2d, 0x3b, 0x2e, 0x3b, 0x2f, 0x3b, 0x33, 0x3b, 0x34, 0x3b, 0x35,
    0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39, 0x3b, 0x3d, 0x3b, 0x41,
    0x3b, 0x5f, 0x3b, 0x62, 0x3b, 0x64, 0x3b, 0x66, 0x3b, 0x67, 0x3b, 0x68,
    0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6e, 0x3b, 0x70, 0x3b, 0x72, 0x3b, 0x75};
const uint8_t HuffDecoderCommon::table11_252_emit_[72] = {
    0x58, 0x30, 0x58, 0x31, 0x58, 0x32, 0x58, 0x61, 0x58, 0x63, 0x58, 0x65,
    0x58, 0x69, 0x58, 0x6f, 0x58, 0x73, 0x58, 0x74, 0x58, 0x20, 0x58, 0x25,
    0x58, 0x2d, 0x58, 0x2e, 0x58, 0x2f, 0x58, 0x33, 0x58, 0x34, 0x58, 0x35,
    0x58, 0x36, 0x58, 0x37, 0x58, 0x38, 0x58, 0x39, 0x58, 0x3d, 0x58, 0x41,
    0x58, 0x5f, 0x58, 0x62, 0x58, 0x64, 0x58, 0x66, 0x58, 0x67, 0x58, 0x68,
    0x58, 0x6c, 0x58, 0x6d, 0x58, 0x6e, 0x58, 0x70, 0x58, 0x72, 0x58, 0x75};
const uint8_t HuffDecoderCommon::table11_253_emit_[72] = {
    0x5a, 0x30, 0x5a, 0x31, 0x5a, 0x32, 0x5a, 0x61, 0x5a, 0x63, 0x5a, 0x65,
    0x5a, 0x69, 0x5a, 0x6f, 0x5a, 0x73, 0x5a, 0x74, 0x5a, 0x20, 0x5a, 0x25,
    0x5a, 0x2d, 0x5a, 0x2e, 0x5a, 0x2f, 0x5a, 0x33, 0x5a, 0x34, 0x5a, 0x35,
    0x5a, 0x36, 0x5a, 0x37, 0x5a, 0x38, 0x5a, 0x39, 0x5a, 0x3d, 0x5a, 0x41,
    0x5a, 0x5f, 0x5a, 0x62, 0x5a, 0x64, 0x5a, 0x66, 0x5a, 0x67, 0x5a, 0x68,
    0x5a, 0x6c, 0x5a, 0x6d, 0x5a, 0x6e, 0x5a, 0x70, 0x5a, 0x72, 0x5a, 0x75};
const uint8_t HuffDecoderCommon::table11_254_emit_[4] = {0x21, 0x22, 0x28,
                                                         0x29};
const uint8_t HuffDecoderCommon::table11_255_emit_[14] = {
    0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e, 0x00,
    0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d};
const uint8_t HuffDecoderCommon::table11_255_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0,  0, 1,  0,  0,  0, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,  0, 0,  0, 0,  0,  4,  0, 0, 0, 5,
    0, 0, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 0, 12, 13, 14, 0, 15};
const uint8_t* const HuffDecoderCommon::table11_emit_[256] = {
    table11_0_emit_,   table11_1_emit_,   table11_2_emit_,   table11_3_emit_,
    table11_4_emit_,   table11_5_emit_,   table11_6_emit_,   table11_7_emit_,
    table11_8_emit_,   table11_9_emit_,   table11_10_emit_,  table11_11_emit_,
    table11_12_emit_,  table11_13_emit_,  table11_14_emit_,  table11_15_emit_,
    table11_16_emit_,  table11_17_emit_,  table11_18_emit_,  table11_19_emit_,
    table11_20_emit_,  table11_21_emit_,  table11_22_emit_,  table11_23_emit_,
    table11_24_emit_,  table11_25_emit_,  table11_26_emit_,  table11_27_emit_,
    table11_28_emit_,  table11_29_emit_,  table11_30_emit_,  table11_31_emit_,
    table11_32_emit_,  table11_33_emit_,  table11_34_emit_,  table11_35_emit_,
    table11_36_emit_,  table11_37_emit_,  table11_38_emit_,  table11_39_emit_,
    table11_40_emit_,  table11_41_emit_,  table11_42_emit_,  table11_43_emit_,
    table11_44_emit_,  table11_45_emit_,  table11_46_emit_,  table11_47_emit_,
    table11_48_emit_,  table11_49_emit_,  table11_50_emit_,  table11_51_emit_,
    table11_52_emit_,  table11_53_emit_,  table11_54_emit_,  table11_55_emit_,
    table11_56_emit_,  table11_57_emit_,  table11_58_emit_,  table11_59_emit_,
    table11_60_emit_,  table11_61_emit_,  table11_62_emit_,  table11_63_emit_,
    table11_64_emit_,  table11_65_emit_,  table11_66_emit_,  table11_67_emit_,
    table11_68_emit_,  table11_69_emit_,  table11_70_emit_,  table11_71_emit_,
    table11_72_emit_,  table11_73_emit_,  table11_74_emit_,  table11_75_emit_,
    table11_76_emit_,  table11_77_emit_,  table11_78_emit_,  table11_79_emit_,
    table11_80_emit_,  table11_81_emit_,  table11_82_emit_,  table11_83_emit_,
    table11_84_emit_,  table11_85_emit_,  table11_86_emit_,  table11_87_emit_,
    table11_88_emit_,  table11_89_emit_,  table11_90_emit_,  table11_91_emit_,
    table11_92_emit_,  table11_93_emit_,  table11_94_emit_,  table11_95_emit_,
    table11_96_emit_,  table11_97_emit_,  table11_98_emit_,  table11_99_emit_,
    table11_100_emit_, table11_101_emit_, table11_102_emit_, table11_103_emit_,
    table11_104_emit_, table11_105_emit_, table11_106_emit_, table11_107_emit_,
    table11_108_emit_, table11_109_emit_, table11_110_emit_, table11_111_emit_,
    table11_112_emit_, table11_113_emit_, table11_114_emit_, table11_115_emit_,
    table11_116_emit_, table11_117_emit_, table11_118_emit_, table11_119_emit_,
    table11_120_emit_, table11_121_emit_, table11_122_emit_, table11_123_emit_,
    table11_124_emit_, table11_125_emit_, table11_126_emit_, table11_127_emit_,
    table11_128_emit_, table11_129_emit_, table11_130_emit_, table11_131_emit_,
    table11_132_emit_, table11_133_emit_, table11_134_emit_, table11_135_emit_,
    table11_136_emit_, table11_137_emit_, table11_138_emit_, table11_139_emit_,
    table11_140_emit_, table11_141_emit_, table11_142_emit_, table11_143_emit_,
    table11_144_emit_, table11_145_emit_, table11_146_emit_, table11_147_emit_,
    table11_148_emit_, table11_149_emit_, table11_150_emit_, table11_151_emit_,
    table11_152_emit_, table11_153_emit_, table11_154_emit_, table11_155_emit_,
    table11_156_emit_, table11_157_emit_, table11_158_emit_, table11_159_emit_,
    table11_160_emit_, table11_161_emit_, table11_162_emit_, table11_163_emit_,
    table11_164_emit_, table11_165_emit_, table11_166_emit_, table11_167_emit_,
    table11_168_emit_, table11_169_emit_, table11_170_emit_, table11_171_emit_,
    table11_172_emit_, table11_173_emit_, table11_174_emit_, table11_175_emit_,
    table11_176_emit_, table11_177_emit_, table11_178_emit_, table11_179_emit_,
    table11_180_emit_, table11_181_emit_, table11_182_emit_, table11_183_emit_,
    table11_184_emit_, table11_185_emit_, table11_186_emit_, table11_187_emit_,
    table11_188_emit_, table11_189_emit_, table11_190_emit_, table11_191_emit_,
    table11_192_emit_, table11_193_emit_, table11_194_emit_, table11_195_emit_,
    table11_196_emit_, table11_197_emit_, table11_198_emit_, table11_199_emit_,
    table11_200_emit_, table11_201_emit_, table11_202_emit_, table11_203_emit_,
    table11_204_emit_, table11_205_emit_, table11_206_emit_, table11_207_emit_,
    table11_208_emit_, table11_209_emit_, table11_210_emit_, table11_211_emit_,
    table11_212_emit_, table11_213_emit_, table11_214_emit_, table11_215_emit_,
    table11_216_emit_, table11_217_emit_, table11_218_emit_, table11_219_emit_,
    table11_220_emit_, table11_221_emit_, table11_222_emit_, table11_223_emit_,
    table11_224_emit_, table11_225_emit_, table11_226_emit_, table11_227_emit_,
    table11_228_emit_, table11_229_emit_, table11_230_emit_, table11_231_emit_,
    table11_232_emit_, table11_233_emit_, table11_234_emit_, table11_235_emit_,
    table11_236_emit_, table11_237_emit_, table11_238_emit_, table11_239_emit_,
    table11_240_emit_, table11_241_emit_, table11_242_emit_, table11_243_emit_,
    table11_244_emit_, table11_245_emit_, table11_246_emit_, table11_247_emit_,
    table11_248_emit_, table11_249_emit_, table11_250_emit_, table11_251_emit_,
    table11_252_emit_, table11_253_emit_, table11_254_emit_, table11_255_emit_,
};
const uint16_t* const HuffDecoderCommon::table11_inner_[256] = {
    table11_0_inner_,   table11_1_inner_,   table11_2_inner_,
    table10_28_inner_,  table10_28_inner_,  table11_5_inner_,
    table11_6_inner_,   table11_7_inner_,   table11_8_inner_,
    table11_1_inner_,   table11_2_inner_,   table10_28_inner_,
    table10_28_inner_,  table11_5_inner_,   table11_6_inner_,
    table11_7_inner_,   table11_16_inner_,  table11_1_inner_,
    table11_2_inner_,   table10_28_inner_,  table10_28_inner_,
    table11_5_inner_,   table11_6_inner_,   table11_7_inner_,
    table11_1_inner_,   table11_1_inner_,   table11_2_inner_,
    table10_28_inner_,  table10_28_inner_,  table11_5_inner_,
    table11_6_inner_,   table11_7_inner_,   table11_1_inner_,
    table11_0_inner_,   table11_2_inner_,   table10_28_inner_,
    table10_28_inner_,  table11_5_inner_,   table11_6_inner_,
    table11_7_inner_,   table11_1_inner_,   table11_8_inner_,
    table11_2_inner_,   table10_28_inner_,  table10_28_inner_,
    table11_5_inner_,   table11_6_inner_,   table11_7_inner_,
    table11_1_inner_,   table11_16_inner_,  table11_2_inner_,
    table10_28_inner_,  table10_28_inner_,  table11_5_inner_,
    table11_6_inner_,   table11_7_inner_,   table11_1_inner_,
    table11_1_inner_,   table11_2_inner_,   table10_28_inner_,
    table10_28_inner_,  table11_5_inner_,   table11_6_inner_,
    table11_7_inner_,   table11_1_inner_,   table11_1_inner_,
    table11_66_inner_,  table10_28_inner_,  table10_28_inner_,
    table11_5_inner_,   table11_6_inner_,   table11_7_inner_,
    table11_1_inner_,   table11_1_inner_,   table11_74_inner_,
    table10_28_inner_,  table10_28_inner_,  table11_5_inner_,
    table11_6_inner_,   table11_7_inner_,   table10_28_inner_,
    table11_81_inner_,  table10_2_inner_,   table10_3_inner_,
    table10_28_inner_,  table11_85_inner_,  table10_2_inner_,
    table10_3_inner_,   table10_28_inner_,  table11_89_inner_,
    table10_2_inner_,   table10_3_inner_,   table10_28_inner_,
    table11_93_inner_,  table10_2_inner_,   table10_3_inner_,
    table10_28_inner_,  table11_97_inner_,  table10_2_inner_,
    table10_3_inner_,   table10_28_inner_,  table11_101_inner_,
    table10_2_inner_,   table10_3_inner_,   table10_28_inner_,
    table11_105_inner_, table10_2_inner_,   table10_3_inner_,
    table10_28_inner_,  table11_109_inner_, table10_2_inner_,
    table10_3_inner_,   table10_28_inner_,  table11_113_inner_,
    table10_2_inner_,   table10_3_inner_,   table10_28_inner_,
    table11_117_inner_, table10_2_inner_,   table10_3_inner_,
    table10_28_inner_,  table11_121_inner_, table10_2_inner_,
    table10_3_inner_,   table10_28_inner_,  table10_1_inner_,
    table10_2_inner_,   table10_3_inner_,   table10_28_inner_,
    table10_1_inner_,   table11_130_inner_, table10_3_inner_,
    table10_28_inner_,  table10_1_inner_,   table11_134_inner_,
    table10_3_inner_,   table10_28_inner_,  table10_1_inner_,
    table11_138_inner_, table10_3_inner_,   table10_28_inner_,
    table10_1_inner_,   table11_142_inner_, table10_3_inner_,
    table10_28_inner_,  table10_1_inner_,   table11_146_inner_,
    table10_3_inner_,   table10_28_inner_,  table10_1_inner_,
    table11_150_inner_, table10_3_inner_,   table10_28_inner_,
    table10_1_inner_,   table11_154_inner_, table10_3_inner_,
    table10_28_inner_,  table10_1_inner_,   table11_158_inner_,
    table10_3_inner_,   table10_28_inner_,  table10_1_inner_,
    table11_162_inner_, table10_3_inner_,   table10_28_inner_,
    table10_1_inner_,   table11_166_inner_, table10_3_inner_,
    table10_28_inner_,  table10_1_inner_,   table11_170_inner_,
    table10_3_inner_,   table10_28_inner_,  table10_1_inner_,
    table11_174_inner_, table10_3_inner_,   table10_28_inner_,
    table10_1_inner_,   table11_178_inner_, table10_3_inner_,
    table10_28_inner_,  table10_1_inner_,   table11_182_inner_,
    table10_3_inner_,   table10_62_inner_,  table11_185_inner_,
    table10_62_inner_,  table11_187_inner_, table10_62_inner_,
    table11_189_inner_, table10_62_inner_,  table11_191_inner_,
    table10_62_inner_,  table11_193_inner_, table10_62_inner_,
    table11_195_inner_, table10_62_inner_,  table11_197_inner_,
    table10_62_inner_,  table11_199_inner_, table10_62_inner_,
    table11_201_inner_, table10_62_inner_,  table11_203_inner_,
    table10_62_inner_,  table11_205_inner_, table10_62_inner_,
    table11_207_inner_, table10_62_inner_,  table11_209_inner_,
    table10_62_inner_,  table11_211_inner_, table10_62_inner_,
    table11_213_inner_, table10_62_inner_,  table11_215_inner_,
    table10_62_inner_,  table11_217_inner_, table10_62_inner_,
    table11_219_inner_, table10_62_inner_,  table11_221_inner_,
    table10_62_inner_,  table11_223_inner_, table10_62_inner_,
    table11_225_inner_, table10_62_inner_,  table11_227_inner_,
    table10_62_inner_,  table11_229_inner_, table10_62_inner_,
    table11_231_inner_, table10_62_inner_,  table11_233_inner_,
    table10_62_inner_,  table11_235_inner_, table10_62_inner_,
    table11_237_inner_, table10_62_inner_,  table11_239_inner_,
    table10_62_inner_,  table11_241_inner_, table10_62_inner_,
    table11_243_inner_, table10_62_inner_,  table11_245_inner_,
    table10_62_inner_,  table10_41_inner_,  table10_92_inner_,
    table10_92_inner_,  table10_92_inner_,  table10_92_inner_,
    table10_92_inner_,  table10_92_inner_,  table8_23_inner_,
    table8_31_inner_,
};
const uint8_t* const HuffDecoderCommon::table11_outer_[256] = {
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table8_23_outer_,  table8_23_outer_,  table11_2_outer_,  table10_0_outer_,
    table10_0_outer_,  table11_5_outer_,  table11_6_outer_,  table11_7_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_0_outer_,  table10_1_outer_,  table10_2_outer_,  table10_3_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table10_40_outer_, table10_41_outer_, table10_40_outer_, table10_41_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_0_outer_,   table8_0_outer_,
    table8_0_outer_,   table8_0_outer_,   table8_23_outer_,  table11_255_outer_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[55] = {
    0x30, 0x30, 0x30, 0x31, 0x30, 0x30, 0x32, 0x30, 0x30, 0x61, 0x30,
    0x30, 0x63, 0x30, 0x30, 0x65, 0x30, 0x30, 0x69, 0x30, 0x30, 0x6f,
    0x30, 0x30, 0x73, 0x30, 0x30, 0x74, 0x30, 0x31, 0x31, 0x30, 0x31,
    0x32, 0x30, 0x31, 0x61, 0x30, 0x31, 0x63, 0x30, 0x31, 0x65, 0x30,
    0x31, 0x69, 0x30, 0x31, 0x6f, 0x30, 0x31, 0x73, 0x30, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_0_inner_[22] = {
    0x000f, 0x004f, 0x010f, 0x01cf, 0x028f, 0x034f, 0x040f, 0x04cf,
    0x058f, 0x064f, 0x001a, 0x008f, 0x070f, 0x07cf, 0x088f, 0x094f,
    0x0a0f, 0x0acf, 0x0b8f, 0x0c4f, 0x0d0f, 0x009a};
const uint8_t HuffDecoderCommon::table1_0_outer_[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
const uint8_t HuffDecoderCommon::table1_1_emit_[58] = {
    0x30, 0x32, 0x30, 0x32, 0x31, 0x30, 0x32, 0x32, 0x30, 0x32, 0x61, 0x30,
    0x32, 0x63, 0x30, 0x32, 0x65, 0x30, 0x32, 0x69, 0x30, 0x32, 0x6f, 0x30,
    0x32, 0x73, 0x30, 0x32, 0x74, 0x30, 0x61, 0x30, 0x61, 0x31, 0x30, 0x61,
    0x32, 0x30, 0x61, 0x61, 0x30, 0x61, 0x63, 0x30, 0x61, 0x65, 0x30, 0x61,
    0x69, 0x30, 0x61, 0x6f, 0x30, 0x61, 0x73, 0x30, 0x61, 0x74};
const uint16_t HuffDecoderCommon::table1_1_inner_[22] = {
    0x000f, 0x008f, 0x014f, 0x020f, 0x02cf, 0x038f, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x07cf, 0x088f, 0x094f, 0x0a0f,
    0x0acf, 0x0b8f, 0x0c4f, 0x0d0f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_2_emit_[58] = {
    0x30, 0x63, 0x30, 0x63, 0x31, 0x30, 0x63, 0x32, 0x30, 0x63, 0x61, 0x30,
    0x63, 0x63, 0x30, 0x63, 0x65, 0x30, 0x63, 0x69, 0x30, 0x63, 0x6f, 0x30,
    0x63, 0x73, 0x30, 0x63, 0x74, 0x30, 0x65, 0x30, 0x65, 0x31, 0x30, 0x65,
    0x32, 0x30, 0x65, 0x61, 0x30, 0x65, 0x63, 0x30, 0x65, 0x65, 0x30, 0x65,
    0x69, 0x30, 0x65, 0x6f, 0x30, 0x65, 0x73, 0x30, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table1_3_emit_[58] = {
    0x30, 0x69, 0x30, 0x69, 0x31, 0x30, 0x69, 0x32, 0x30, 0x69, 0x61, 0x30,
    0x69, 0x63, 0x30, 0x69, 0x65, 0x30, 0x69, 0x69, 0x30, 0x69, 0x6f, 0x30,
    0x69, 0x73, 0x30, 0x69, 0x74, 0x30, 0x6f, 0x30, 0x6f, 0x31, 0x30, 0x6f,
    0x32, 0x30, 0x6f, 0x61, 0x30, 0x6f, 0x63, 0x30, 0x6f, 0x65, 0x30, 0x6f,
    0x69, 0x30, 0x6f, 0x6f, 0x30, 0x6f, 0x73, 0x30, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table1_4_emit_[58] = {
    0x30, 0x73, 0x30, 0x73, 0x31, 0x30, 0x73, 0x32, 0x30, 0x73, 0x61, 0x30,
    0x73, 0x63, 0x30, 0x73, 0x65, 0x30, 0x73, 0x69, 0x30, 0x73, 0x6f, 0x30,
    0x73, 0x73, 0x30, 0x73, 0x74, 0x30, 0x74, 0x30, 0x74, 0x31, 0x30, 0x74,
    0x32, 0x30, 0x74, 0x61, 0x30, 0x74, 0x63, 0x30, 0x74, 0x65, 0x30, 0x74,
    0x69, 0x30, 0x74, 0x6f, 0x30, 0x74, 0x73, 0x30, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_5_emit_[8] = {0x30, 0x20, 0x30, 0x25,
                                                      0x30, 0x2d, 0x30, 0x2e};
const uint16_t HuffDecoderCommon::table1_5_inner_[4] = {0x001b, 0x009b, 0x011b,
                                                        0x019b};
const uint8_t HuffDecoderCommon::table1_5_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
const uint8_t HuffDecoderCommon::table1_6_emit_[8] = {0x30, 0x2f, 0x30, 0x33,
                                                      0x30, 0x34, 0x30, 0x35};
const uint8_t HuffDecoderCommon::table1_7_emit_[8] = {0x30, 0x36, 0x30, 0x37,
                                                      0x30, 0x38, 0x30, 0x39};
const uint8_t HuffDecoderCommon::table1_8_emit_[8] = {0x30, 0x3d, 0x30, 0x41,
                                                      0x30, 0x5f, 0x30, 0x62};
const uint8_t HuffDecoderCommon::table1_9_emit_[8] = {0x30, 0x64, 0x30, 0x66,
                                                      0x30, 0x67, 0x30, 0x68};
const uint8_t HuffDecoderCommon::table1_10_emit_[8] = {0x30, 0x6c, 0x30, 0x6d,
                                                       0x30, 0x6e, 0x30, 0x70};
const uint8_t HuffDecoderCommon::table1_11_emit_[12] = {
    0x30, 0x72, 0x30, 0x75, 0x30, 0x3a, 0x30, 0x42, 0x30, 0x43, 0x30, 0x44};
const uint16_t HuffDecoderCommon::table1_11_inner_[6] = {
    0x001b, 0x009b, 0x011c, 0x019c, 0x021c, 0x029c};
const uint8_t HuffDecoderCommon::table1_11_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3,
    3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5};
const uint8_t HuffDecoderCommon::table1_12_emit_[16] = {
    0x30, 0x45, 0x30, 0x46, 0x30, 0x47, 0x30, 0x48,
    0x30, 0x49, 0x30, 0x4a, 0x30, 0x4b, 0x30, 0x4c};
const uint16_t HuffDecoderCommon::table1_12_inner_[8] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x021c, 0x029c, 0x031c, 0x039c};
const uint8_t HuffDecoderCommon::table1_12_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5,
    5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7};
const uint8_t HuffDecoderCommon::table1_13_emit_[16] = {
    0x30, 0x4d, 0x30, 0x4e, 0x30, 0x4f, 0x30, 0x50,
    0x30, 0x51, 0x30, 0x52, 0x30, 0x53, 0x30, 0x54};
const uint8_t HuffDecoderCommon::table1_14_emit_[16] = {
    0x30, 0x55, 0x30, 0x56, 0x30, 0x57, 0x30, 0x59,
    0x30, 0x6a, 0x30, 0x6b, 0x30, 0x71, 0x30, 0x76};
const uint8_t HuffDecoderCommon::table1_15_emit_[30] = {
    0x30, 0x77, 0x30, 0x78, 0x30, 0x79, 0x30, 0x7a, 0x30, 0x26,
    0x30, 0x2a, 0x30, 0x2c, 0x30, 0x3b, 0x30, 0x58, 0x30, 0x5a,
    0x30, 0x21, 0x30, 0x22, 0x30, 0x28, 0x30, 0x29, 0x30, 0x3f};
const uint16_t HuffDecoderCommon::table1_15_inner_[16] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x021d, 0x029d, 0x031d, 0x039d,
    0x041d, 0x049d, 0x051f, 0x059f, 0x061f, 0x069f, 0x071f, 0x0025};
const uint8_t HuffDecoderCommon::table1_15_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1,  1,  1,  1,  2,  2,  2,  2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4,  4,  5,  5,  5,  5,  6,  6, 6, 6,
    7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 11, 12, 13, 14, 15, 15, 15};
const uint8_t HuffDecoderCommon::table1_16_emit_[57] = {
    0x31, 0x30, 0x30, 0x31, 0x30, 0x31, 0x30, 0x32, 0x31, 0x30, 0x61, 0x31,
    0x30, 0x63, 0x31, 0x30, 0x65, 0x31, 0x30, 0x69, 0x31, 0x30, 0x6f, 0x31,
    0x30, 0x73, 0x31, 0x30, 0x74, 0x31, 0x31, 0x30, 0x31, 0x31, 0x31, 0x32,
    0x31, 0x31, 0x61, 0x31, 0x31, 0x63, 0x31, 0x31, 0x65, 0x31, 0x31, 0x69,
    0x31, 0x31, 0x6f, 0x31, 0x31, 0x73, 0x31, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_16_inner_[22] = {
    0x000f, 0x00cf, 0x014f, 0x020f, 0x02cf, 0x038f, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x084f, 0x090f, 0x09cf,
    0x0a8f, 0x0b4f, 0x0c0f, 0x0ccf, 0x0d8f, 0x075a};
const uint8_t HuffDecoderCommon::table1_17_emit_[58] = {
    0x31, 0x32, 0x30, 0x31, 0x32, 0x31, 0x32, 0x32, 0x31, 0x32, 0x61, 0x31,
    0x32, 0x63, 0x31, 0x32, 0x65, 0x31, 0x32, 0x69, 0x31, 0x32, 0x6f, 0x31,
    0x32, 0x73, 0x31, 0x32, 0x74, 0x31, 0x61, 0x30, 0x31, 0x61, 0x31, 0x61,
    0x32, 0x31, 0x61, 0x61, 0x31, 0x61, 0x63, 0x31, 0x61, 0x65, 0x31, 0x61,
    0x69, 0x31, 0x61, 0x6f, 0x31, 0x61, 0x73, 0x31, 0x61, 0x74};
const uint16_t HuffDecoderCommon::table1_17_inner_[22] = {
    0x000f, 0x00cf, 0x014f, 0x020f, 0x02cf, 0x038f, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x088f, 0x094f, 0x0a0f,
    0x0acf, 0x0b8f, 0x0c4f, 0x0d0f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_18_emit_[58] = {
    0x31, 0x63, 0x30, 0x31, 0x63, 0x31, 0x63, 0x32, 0x31, 0x63, 0x61, 0x31,
    0x63, 0x63, 0x31, 0x63, 0x65, 0x31, 0x63, 0x69, 0x31, 0x63, 0x6f, 0x31,
    0x63, 0x73, 0x31, 0x63, 0x74, 0x31, 0x65, 0x30, 0x31, 0x65, 0x31, 0x65,
    0x32, 0x31, 0x65, 0x61, 0x31, 0x65, 0x63, 0x31, 0x65, 0x65, 0x31, 0x65,
    0x69, 0x31, 0x65, 0x6f, 0x31, 0x65, 0x73, 0x31, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table1_19_emit_[58] = {
    0x31, 0x69, 0x30, 0x31, 0x69, 0x31, 0x69, 0x32, 0x31, 0x69, 0x61, 0x31,
    0x69, 0x63, 0x31, 0x69, 0x65, 0x31, 0x69, 0x69, 0x31, 0x69, 0x6f, 0x31,
    0x69, 0x73, 0x31, 0x69, 0x74, 0x31, 0x6f, 0x30, 0x31, 0x6f, 0x31, 0x6f,
    0x32, 0x31, 0x6f, 0x61, 0x31, 0x6f, 0x63, 0x31, 0x6f, 0x65, 0x31, 0x6f,
    0x69, 0x31, 0x6f, 0x6f, 0x31, 0x6f, 0x73, 0x31, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table1_20_emit_[58] = {
    0x31, 0x73, 0x30, 0x31, 0x73, 0x31, 0x73, 0x32, 0x31, 0x73, 0x61, 0x31,
    0x73, 0x63, 0x31, 0x73, 0x65, 0x31, 0x73, 0x69, 0x31, 0x73, 0x6f, 0x31,
    0x73, 0x73, 0x31, 0x73, 0x74, 0x31, 0x74, 0x30, 0x31, 0x74, 0x31, 0x74,
    0x32, 0x31, 0x74, 0x61, 0x31, 0x74, 0x63, 0x31, 0x74, 0x65, 0x31, 0x74,
    0x69, 0x31, 0x74, 0x6f, 0x31, 0x74, 0x73, 0x31, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_21_emit_[8] = {0x31, 0x20, 0x31, 0x25,
                                                       0x31, 0x2d, 0x31, 0x2e};
const uint8_t HuffDecoderCommon::table1_22_emit_[8] = {0x31, 0x2f, 0x31, 0x33,
                                                       0x31, 0x34, 0x31, 0x35};
const uint8_t HuffDecoderCommon::table1_23_emit_[8] = {0x31, 0x36, 0x31, 0x37,
                                                       0x31, 0x38, 0x31, 0x39};
const uint8_t HuffDecoderCommon::table1_24_emit_[8] = {0x31, 0x3d, 0x31, 0x41,
                                                       0x31, 0x5f, 0x31, 0x62};
const uint8_t HuffDecoderCommon::table1_25_emit_[8] = {0x31, 0x64, 0x31, 0x66,
                                                       0x31, 0x67, 0x31, 0x68};
const uint8_t HuffDecoderCommon::table1_26_emit_[8] = {0x31, 0x6c, 0x31, 0x6d,
                                                       0x31, 0x6e, 0x31, 0x70};
const uint8_t HuffDecoderCommon::table1_27_emit_[12] = {
    0x31, 0x72, 0x31, 0x75, 0x31, 0x3a, 0x31, 0x42, 0x31, 0x43, 0x31, 0x44};
const uint8_t HuffDecoderCommon::table1_28_emit_[16] = {
    0x31, 0x45, 0x31, 0x46, 0x31, 0x47, 0x31, 0x48,
    0x31, 0x49, 0x31, 0x4a, 0x31, 0x4b, 0x31, 0x4c};
const uint8_t HuffDecoderCommon::table1_29_emit_[16] = {
    0x31, 0x4d, 0x31, 0x4e, 0x31, 0x4f, 0x31, 0x50,
    0x31, 0x51, 0x31, 0x52, 0x31, 0x53, 0x31, 0x54};
const uint8_t HuffDecoderCommon::table1_30_emit_[16] = {
    0x31, 0x55, 0x31, 0x56, 0x31, 0x57, 0x31, 0x59,
    0x31, 0x6a, 0x31, 0x6b, 0x31, 0x71, 0x31, 0x76};
const uint8_t HuffDecoderCommon::table1_31_emit_[30] = {
    0x31, 0x77, 0x31, 0x78, 0x31, 0x79, 0x31, 0x7a, 0x31, 0x26,
    0x31, 0x2a, 0x31, 0x2c, 0x31, 0x3b, 0x31, 0x58, 0x31, 0x5a,
    0x31, 0x21, 0x31, 0x22, 0x31, 0x28, 0x31, 0x29, 0x31, 0x3f};
const uint8_t HuffDecoderCommon::table1_32_emit_[58] = {
    0x32, 0x30, 0x30, 0x32, 0x30, 0x31, 0x32, 0x30, 0x32, 0x30, 0x61, 0x32,
    0x30, 0x63, 0x32, 0x30, 0x65, 0x32, 0x30, 0x69, 0x32, 0x30, 0x6f, 0x32,
    0x30, 0x73, 0x32, 0x30, 0x74, 0x32, 0x31, 0x30, 0x32, 0x31, 0x31, 0x32,
    0x31, 0x32, 0x31, 0x61, 0x32, 0x31, 0x63, 0x32, 0x31, 0x65, 0x32, 0x31,
    0x69, 0x32, 0x31, 0x6f, 0x32, 0x31, 0x73, 0x32, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_32_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x020f, 0x02cf, 0x038f, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x094f, 0x0a0f,
    0x0acf, 0x0b8f, 0x0c4f, 0x0d0f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_33_emit_[55] = {
    0x32, 0x32, 0x30, 0x32, 0x32, 0x31, 0x32, 0x32, 0x32, 0x61, 0x32,
    0x32, 0x63, 0x32, 0x32, 0x65, 0x32, 0x32, 0x69, 0x32, 0x32, 0x6f,
    0x32, 0x32, 0x73, 0x32, 0x32, 0x74, 0x32, 0x61, 0x30, 0x32, 0x61,
    0x31, 0x32, 0x61, 0x61, 0x32, 0x61, 0x63, 0x32, 0x61, 0x65, 0x32,
    0x61, 0x69, 0x32, 0x61, 0x6f, 0x32, 0x61, 0x73, 0x32, 0x61, 0x74};
const uint16_t HuffDecoderCommon::table1_33_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x01cf, 0x028f, 0x034f, 0x040f, 0x04cf,
    0x058f, 0x064f, 0x001a, 0x070f, 0x07cf, 0x020f, 0x088f, 0x094f,
    0x0a0f, 0x0acf, 0x0b8f, 0x0c4f, 0x0d0f, 0x021a};
const uint8_t HuffDecoderCommon::table1_34_emit_[58] = {
    0x32, 0x63, 0x30, 0x32, 0x63, 0x31, 0x32, 0x63, 0x32, 0x63, 0x61, 0x32,
    0x63, 0x63, 0x32, 0x63, 0x65, 0x32, 0x63, 0x69, 0x32, 0x63, 0x6f, 0x32,
    0x63, 0x73, 0x32, 0x63, 0x74, 0x32, 0x65, 0x30, 0x32, 0x65, 0x31, 0x32,
    0x65, 0x32, 0x65, 0x61, 0x32, 0x65, 0x63, 0x32, 0x65, 0x65, 0x32, 0x65,
    0x69, 0x32, 0x65, 0x6f, 0x32, 0x65, 0x73, 0x32, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table1_35_emit_[58] = {
    0x32, 0x69, 0x30, 0x32, 0x69, 0x31, 0x32, 0x69, 0x32, 0x69, 0x61, 0x32,
    0x69, 0x63, 0x32, 0x69, 0x65, 0x32, 0x69, 0x69, 0x32, 0x69, 0x6f, 0x32,
    0x69, 0x73, 0x32, 0x69, 0x74, 0x32, 0x6f, 0x30, 0x32, 0x6f, 0x31, 0x32,
    0x6f, 0x32, 0x6f, 0x61, 0x32, 0x6f, 0x63, 0x32, 0x6f, 0x65, 0x32, 0x6f,
    0x69, 0x32, 0x6f, 0x6f, 0x32, 0x6f, 0x73, 0x32, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table1_36_emit_[58] = {
    0x32, 0x73, 0x30, 0x32, 0x73, 0x31, 0x32, 0x73, 0x32, 0x73, 0x61, 0x32,
    0x73, 0x63, 0x32, 0x73, 0x65, 0x32, 0x73, 0x69, 0x32, 0x73, 0x6f, 0x32,
    0x73, 0x73, 0x32, 0x73, 0x74, 0x32, 0x74, 0x30, 0x32, 0x74, 0x31, 0x32,
    0x74, 0x32, 0x74, 0x61, 0x32, 0x74, 0x63, 0x32, 0x74, 0x65, 0x32, 0x74,
    0x69, 0x32, 0x74, 0x6f, 0x32, 0x74, 0x73, 0x32, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_37_emit_[8] = {0x32, 0x20, 0x32, 0x25,
                                                       0x32, 0x2d, 0x32, 0x2e};
const uint8_t HuffDecoderCommon::table1_38_emit_[8] = {0x32, 0x2f, 0x32, 0x33,
                                                       0x32, 0x34, 0x32, 0x35};
const uint8_t HuffDecoderCommon::table1_39_emit_[8] = {0x32, 0x36, 0x32, 0x37,
                                                       0x32, 0x38, 0x32, 0x39};
const uint8_t HuffDecoderCommon::table1_40_emit_[8] = {0x32, 0x3d, 0x32, 0x41,
                                                       0x32, 0x5f, 0x32, 0x62};
const uint8_t HuffDecoderCommon::table1_41_emit_[8] = {0x32, 0x64, 0x32, 0x66,
                                                       0x32, 0x67, 0x32, 0x68};
const uint8_t HuffDecoderCommon::table1_42_emit_[8] = {0x32, 0x6c, 0x32, 0x6d,
                                                       0x32, 0x6e, 0x32, 0x70};
const uint8_t HuffDecoderCommon::table1_43_emit_[12] = {
    0x32, 0x72, 0x32, 0x75, 0x32, 0x3a, 0x32, 0x42, 0x32, 0x43, 0x32, 0x44};
const uint8_t HuffDecoderCommon::table1_44_emit_[16] = {
    0x32, 0x45, 0x32, 0x46, 0x32, 0x47, 0x32, 0x48,
    0x32, 0x49, 0x32, 0x4a, 0x32, 0x4b, 0x32, 0x4c};
const uint8_t HuffDecoderCommon::table1_45_emit_[16] = {
    0x32, 0x4d, 0x32, 0x4e, 0x32, 0x4f, 0x32, 0x50,
    0x32, 0x51, 0x32, 0x52, 0x32, 0x53, 0x32, 0x54};
const uint8_t HuffDecoderCommon::table1_46_emit_[16] = {
    0x32, 0x55, 0x32, 0x56, 0x32, 0x57, 0x32, 0x59,
    0x32, 0x6a, 0x32, 0x6b, 0x32, 0x71, 0x32, 0x76};
const uint8_t HuffDecoderCommon::table1_47_emit_[30] = {
    0x32, 0x77, 0x32, 0x78, 0x32, 0x79, 0x32, 0x7a, 0x32, 0x26,
    0x32, 0x2a, 0x32, 0x2c, 0x32, 0x3b, 0x32, 0x58, 0x32, 0x5a,
    0x32, 0x21, 0x32, 0x22, 0x32, 0x28, 0x32, 0x29, 0x32, 0x3f};
const uint8_t HuffDecoderCommon::table1_48_emit_[58] = {
    0x61, 0x30, 0x30, 0x61, 0x30, 0x31, 0x61, 0x30, 0x32, 0x61, 0x30, 0x61,
    0x30, 0x63, 0x61, 0x30, 0x65, 0x61, 0x30, 0x69, 0x61, 0x30, 0x6f, 0x61,
    0x30, 0x73, 0x61, 0x30, 0x74, 0x61, 0x31, 0x30, 0x61, 0x31, 0x31, 0x61,
    0x31, 0x32, 0x61, 0x31, 0x61, 0x31, 0x63, 0x61, 0x31, 0x65, 0x61, 0x31,
    0x69, 0x61, 0x31, 0x6f, 0x61, 0x31, 0x73, 0x61, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_48_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x02cf, 0x038f, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a0f,
    0x0acf, 0x0b8f, 0x0c4f, 0x0d0f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_49_emit_[57] = {
    0x61, 0x32, 0x30, 0x61, 0x32, 0x31, 0x61, 0x32, 0x32, 0x61, 0x32, 0x61,
    0x32, 0x63, 0x61, 0x32, 0x65, 0x61, 0x32, 0x69, 0x61, 0x32, 0x6f, 0x61,
    0x32, 0x73, 0x61, 0x32, 0x74, 0x61, 0x61, 0x30, 0x61, 0x61, 0x31, 0x61,
    0x61, 0x32, 0x61, 0x61, 0x61, 0x63, 0x61, 0x61, 0x65, 0x61, 0x61, 0x69,
    0x61, 0x61, 0x6f, 0x61, 0x61, 0x73, 0x61, 0x61, 0x74};
const uint16_t HuffDecoderCommon::table1_49_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x02cf, 0x038f, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x09cf,
    0x0a8f, 0x0b4f, 0x0c0f, 0x0ccf, 0x0d8f, 0x075a};
const uint8_t HuffDecoderCommon::table1_50_emit_[58] = {
    0x61, 0x63, 0x30, 0x61, 0x63, 0x31, 0x61, 0x63, 0x32, 0x61, 0x63, 0x61,
    0x63, 0x63, 0x61, 0x63, 0x65, 0x61, 0x63, 0x69, 0x61, 0x63, 0x6f, 0x61,
    0x63, 0x73, 0x61, 0x63, 0x74, 0x61, 0x65, 0x30, 0x61, 0x65, 0x31, 0x61,
    0x65, 0x32, 0x61, 0x65, 0x61, 0x65, 0x63, 0x61, 0x65, 0x65, 0x61, 0x65,
    0x69, 0x61, 0x65, 0x6f, 0x61, 0x65, 0x73, 0x61, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table1_51_emit_[58] = {
    0x61, 0x69, 0x30, 0x61, 0x69, 0x31, 0x61, 0x69, 0x32, 0x61, 0x69, 0x61,
    0x69, 0x63, 0x61, 0x69, 0x65, 0x61, 0x69, 0x69, 0x61, 0x69, 0x6f, 0x61,
    0x69, 0x73, 0x61, 0x69, 0x74, 0x61, 0x6f, 0x30, 0x61, 0x6f, 0x31, 0x61,
    0x6f, 0x32, 0x61, 0x6f, 0x61, 0x6f, 0x63, 0x61, 0x6f, 0x65, 0x61, 0x6f,
    0x69, 0x61, 0x6f, 0x6f, 0x61, 0x6f, 0x73, 0x61, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table1_52_emit_[58] = {
    0x61, 0x73, 0x30, 0x61, 0x73, 0x31, 0x61, 0x73, 0x32, 0x61, 0x73, 0x61,
    0x73, 0x63, 0x61, 0x73, 0x65, 0x61, 0x73, 0x69, 0x61, 0x73, 0x6f, 0x61,
    0x73, 0x73, 0x61, 0x73, 0x74, 0x61, 0x74, 0x30, 0x61, 0x74, 0x31, 0x61,
    0x74, 0x32, 0x61, 0x74, 0x61, 0x74, 0x63, 0x61, 0x74, 0x65, 0x61, 0x74,
    0x69, 0x61, 0x74, 0x6f, 0x61, 0x74, 0x73, 0x61, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_53_emit_[8] = {0x61, 0x20, 0x61, 0x25,
                                                       0x61, 0x2d, 0x61, 0x2e};
const uint8_t HuffDecoderCommon::table1_54_emit_[8] = {0x61, 0x2f, 0x61, 0x33,
                                                       0x61, 0x34, 0x61, 0x35};
const uint8_t HuffDecoderCommon::table1_55_emit_[8] = {0x61, 0x36, 0x61, 0x37,
                                                       0x61, 0x38, 0x61, 0x39};
const uint8_t HuffDecoderCommon::table1_56_emit_[8] = {0x61, 0x3d, 0x61, 0x41,
                                                       0x61, 0x5f, 0x61, 0x62};
const uint8_t HuffDecoderCommon::table1_57_emit_[8] = {0x61, 0x64, 0x61, 0x66,
                                                       0x61, 0x67, 0x61, 0x68};
const uint8_t HuffDecoderCommon::table1_58_emit_[8] = {0x61, 0x6c, 0x61, 0x6d,
                                                       0x61, 0x6e, 0x61, 0x70};
const uint8_t HuffDecoderCommon::table1_59_emit_[12] = {
    0x61, 0x72, 0x61, 0x75, 0x61, 0x3a, 0x61, 0x42, 0x61, 0x43, 0x61, 0x44};
const uint8_t HuffDecoderCommon::table1_60_emit_[16] = {
    0x61, 0x45, 0x61, 0x46, 0x61, 0x47, 0x61, 0x48,
    0x61, 0x49, 0x61, 0x4a, 0x61, 0x4b, 0x61, 0x4c};
const uint8_t HuffDecoderCommon::table1_61_emit_[16] = {
    0x61, 0x4d, 0x61, 0x4e, 0x61, 0x4f, 0x61, 0x50,
    0x61, 0x51, 0x61, 0x52, 0x61, 0x53, 0x61, 0x54};
const uint8_t HuffDecoderCommon::table1_62_emit_[16] = {
    0x61, 0x55, 0x61, 0x56, 0x61, 0x57, 0x61, 0x59,
    0x61, 0x6a, 0x61, 0x6b, 0x61, 0x71, 0x61, 0x76};
const uint8_t HuffDecoderCommon::table1_63_emit_[30] = {
    0x61, 0x77, 0x61, 0x78, 0x61, 0x79, 0x61, 0x7a, 0x61, 0x26,
    0x61, 0x2a, 0x61, 0x2c, 0x61, 0x3b, 0x61, 0x58, 0x61, 0x5a,
    0x61, 0x21, 0x61, 0x22, 0x61, 0x28, 0x61, 0x29, 0x61, 0x3f};
const uint8_t HuffDecoderCommon::table1_64_emit_[58] = {
    0x63, 0x30, 0x30, 0x63, 0x30, 0x31, 0x63, 0x30, 0x32, 0x63, 0x30, 0x61,
    0x63, 0x30, 0x63, 0x30, 0x65, 0x63, 0x30, 0x69, 0x63, 0x30, 0x6f, 0x63,
    0x30, 0x73, 0x63, 0x30, 0x74, 0x63, 0x31, 0x30, 0x63, 0x31, 0x31, 0x63,
    0x31, 0x32, 0x63, 0x31, 0x61, 0x63, 0x31, 0x63, 0x31, 0x65, 0x63, 0x31,
    0x69, 0x63, 0x31, 0x6f, 0x63, 0x31, 0x73, 0x63, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_64_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x038f, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a4f,
    0x0acf, 0x0b8f, 0x0c4f, 0x0d0f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_65_emit_[58] = {
    0x63, 0x32, 0x30, 0x63, 0x32, 0x31, 0x63, 0x32, 0x32, 0x63, 0x32, 0x61,
    0x63, 0x32, 0x63, 0x32, 0x65, 0x63, 0x32, 0x69, 0x63, 0x32, 0x6f, 0x63,
    0x32, 0x73, 0x63, 0x32, 0x74, 0x63, 0x61, 0x30, 0x63, 0x61, 0x31, 0x63,
    0x61, 0x32, 0x63, 0x61, 0x61, 0x63, 0x61, 0x63, 0x61, 0x65, 0x63, 0x61,
    0x69, 0x63, 0x61, 0x6f, 0x63, 0x61, 0x73, 0x63, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table1_66_emit_[55] = {
    0x63, 0x63, 0x30, 0x63, 0x63, 0x31, 0x63, 0x63, 0x32, 0x63, 0x63,
    0x61, 0x63, 0x63, 0x63, 0x65, 0x63, 0x63, 0x69, 0x63, 0x63, 0x6f,
    0x63, 0x63, 0x73, 0x63, 0x63, 0x74, 0x63, 0x65, 0x30, 0x63, 0x65,
    0x31, 0x63, 0x65, 0x32, 0x63, 0x65, 0x61, 0x63, 0x65, 0x65, 0x63,
    0x65, 0x69, 0x63, 0x65, 0x6f, 0x63, 0x65, 0x73, 0x63, 0x65, 0x74};
const uint16_t HuffDecoderCommon::table1_66_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x034f, 0x040f, 0x04cf,
    0x058f, 0x064f, 0x001a, 0x070f, 0x07cf, 0x088f, 0x094f, 0x038f,
    0x0a0f, 0x0acf, 0x0b8f, 0x0c4f, 0x0d0f, 0x039a};
const uint8_t HuffDecoderCommon::table1_67_emit_[58] = {
    0x63, 0x69, 0x30, 0x63, 0x69, 0x31, 0x63, 0x69, 0x32, 0x63, 0x69, 0x61,
    0x63, 0x69, 0x63, 0x69, 0x65, 0x63, 0x69, 0x69, 0x63, 0x69, 0x6f, 0x63,
    0x69, 0x73, 0x63, 0x69, 0x74, 0x63, 0x6f, 0x30, 0x63, 0x6f, 0x31, 0x63,
    0x6f, 0x32, 0x63, 0x6f, 0x61, 0x63, 0x6f, 0x63, 0x6f, 0x65, 0x63, 0x6f,
    0x69, 0x63, 0x6f, 0x6f, 0x63, 0x6f, 0x73, 0x63, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table1_68_emit_[58] = {
    0x63, 0x73, 0x30, 0x63, 0x73, 0x31, 0x63, 0x73, 0x32, 0x63, 0x73, 0x61,
    0x63, 0x73, 0x63, 0x73, 0x65, 0x63, 0x73, 0x69, 0x63, 0x73, 0x6f, 0x63,
    0x73, 0x73, 0x63, 0x73, 0x74, 0x63, 0x74, 0x30, 0x63, 0x74, 0x31, 0x63,
    0x74, 0x32, 0x63, 0x74, 0x61, 0x63, 0x74, 0x63, 0x74, 0x65, 0x63, 0x74,
    0x69, 0x63, 0x74, 0x6f, 0x63, 0x74, 0x73, 0x63, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_69_emit_[8] = {0x63, 0x20, 0x63, 0x25,
                                                       0x63, 0x2d, 0x63, 0x2e};
const uint8_t HuffDecoderCommon::table1_70_emit_[8] = {0x63, 0x2f, 0x63, 0x33,
                                                       0x63, 0x34, 0x63, 0x35};
const uint8_t HuffDecoderCommon::table1_71_emit_[8] = {0x63, 0x36, 0x63, 0x37,
                                                       0x63, 0x38, 0x63, 0x39};
const uint8_t HuffDecoderCommon::table1_72_emit_[8] = {0x63, 0x3d, 0x63, 0x41,
                                                       0x63, 0x5f, 0x63, 0x62};
const uint8_t HuffDecoderCommon::table1_73_emit_[8] = {0x63, 0x64, 0x63, 0x66,
                                                       0x63, 0x67, 0x63, 0x68};
const uint8_t HuffDecoderCommon::table1_74_emit_[8] = {0x63, 0x6c, 0x63, 0x6d,
                                                       0x63, 0x6e, 0x63, 0x70};
const uint8_t HuffDecoderCommon::table1_75_emit_[12] = {
    0x63, 0x72, 0x63, 0x75, 0x63, 0x3a, 0x63, 0x42, 0x63, 0x43, 0x63, 0x44};
const uint8_t HuffDecoderCommon::table1_76_emit_[16] = {
    0x63, 0x45, 0x63, 0x46, 0x63, 0x47, 0x63, 0x48,
    0x63, 0x49, 0x63, 0x4a, 0x63, 0x4b, 0x63, 0x4c};
const uint8_t HuffDecoderCommon::table1_77_emit_[16] = {
    0x63, 0x4d, 0x63, 0x4e, 0x63, 0x4f, 0x63, 0x50,
    0x63, 0x51, 0x63, 0x52, 0x63, 0x53, 0x63, 0x54};
const uint8_t HuffDecoderCommon::table1_78_emit_[16] = {
    0x63, 0x55, 0x63, 0x56, 0x63, 0x57, 0x63, 0x59,
    0x63, 0x6a, 0x63, 0x6b, 0x63, 0x71, 0x63, 0x76};
const uint8_t HuffDecoderCommon::table1_79_emit_[30] = {
    0x63, 0x77, 0x63, 0x78, 0x63, 0x79, 0x63, 0x7a, 0x63, 0x26,
    0x63, 0x2a, 0x63, 0x2c, 0x63, 0x3b, 0x63, 0x58, 0x63, 0x5a,
    0x63, 0x21, 0x63, 0x22, 0x63, 0x28, 0x63, 0x29, 0x63, 0x3f};
const uint8_t HuffDecoderCommon::table1_80_emit_[58] = {
    0x65, 0x30, 0x30, 0x65, 0x30, 0x31, 0x65, 0x30, 0x32, 0x65, 0x30, 0x61,
    0x65, 0x30, 0x63, 0x65, 0x30, 0x65, 0x30, 0x69, 0x65, 0x30, 0x6f, 0x65,
    0x30, 0x73, 0x65, 0x30, 0x74, 0x65, 0x31, 0x30, 0x65, 0x31, 0x31, 0x65,
    0x31, 0x32, 0x65, 0x31, 0x61, 0x65, 0x31, 0x63, 0x65, 0x31, 0x65, 0x31,
    0x69, 0x65, 0x31, 0x6f, 0x65, 0x31, 0x73, 0x65, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_80_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a4f,
    0x0b0f, 0x0b8f, 0x0c4f, 0x0d0f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_81_emit_[58] = {
    0x65, 0x32, 0x30, 0x65, 0x32, 0x31, 0x65, 0x32, 0x32, 0x65, 0x32, 0x61,
    0x65, 0x32, 0x63, 0x65, 0x32, 0x65, 0x32, 0x69, 0x65, 0x32, 0x6f, 0x65,
    0x32, 0x73, 0x65, 0x32, 0x74, 0x65, 0x61, 0x30, 0x65, 0x61, 0x31, 0x65,
    0x61, 0x32, 0x65, 0x61, 0x61, 0x65, 0x61, 0x63, 0x65, 0x61, 0x65, 0x61,
    0x69, 0x65, 0x61, 0x6f, 0x65, 0x61, 0x73, 0x65, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table1_82_emit_[57] = {
    0x65, 0x63, 0x30, 0x65, 0x63, 0x31, 0x65, 0x63, 0x32, 0x65, 0x63, 0x61,
    0x65, 0x63, 0x63, 0x65, 0x63, 0x65, 0x63, 0x69, 0x65, 0x63, 0x6f, 0x65,
    0x63, 0x73, 0x65, 0x63, 0x74, 0x65, 0x65, 0x30, 0x65, 0x65, 0x31, 0x65,
    0x65, 0x32, 0x65, 0x65, 0x61, 0x65, 0x65, 0x63, 0x65, 0x65, 0x65, 0x69,
    0x65, 0x65, 0x6f, 0x65, 0x65, 0x73, 0x65, 0x65, 0x74};
const uint16_t HuffDecoderCommon::table1_82_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x044f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a4f,
    0x0b0f, 0x0b4f, 0x0c0f, 0x0ccf, 0x0d8f, 0x075a};
const uint8_t HuffDecoderCommon::table1_83_emit_[58] = {
    0x65, 0x69, 0x30, 0x65, 0x69, 0x31, 0x65, 0x69, 0x32, 0x65, 0x69, 0x61,
    0x65, 0x69, 0x63, 0x65, 0x69, 0x65, 0x69, 0x69, 0x65, 0x69, 0x6f, 0x65,
    0x69, 0x73, 0x65, 0x69, 0x74, 0x65, 0x6f, 0x30, 0x65, 0x6f, 0x31, 0x65,
    0x6f, 0x32, 0x65, 0x6f, 0x61, 0x65, 0x6f, 0x63, 0x65, 0x6f, 0x65, 0x6f,
    0x69, 0x65, 0x6f, 0x6f, 0x65, 0x6f, 0x73, 0x65, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table1_84_emit_[58] = {
    0x65, 0x73, 0x30, 0x65, 0x73, 0x31, 0x65, 0x73, 0x32, 0x65, 0x73, 0x61,
    0x65, 0x73, 0x63, 0x65, 0x73, 0x65, 0x73, 0x69, 0x65, 0x73, 0x6f, 0x65,
    0x73, 0x73, 0x65, 0x73, 0x74, 0x65, 0x74, 0x30, 0x65, 0x74, 0x31, 0x65,
    0x74, 0x32, 0x65, 0x74, 0x61, 0x65, 0x74, 0x63, 0x65, 0x74, 0x65, 0x74,
    0x69, 0x65, 0x74, 0x6f, 0x65, 0x74, 0x73, 0x65, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_85_emit_[8] = {0x65, 0x20, 0x65, 0x25,
                                                       0x65, 0x2d, 0x65, 0x2e};
const uint8_t HuffDecoderCommon::table1_86_emit_[8] = {0x65, 0x2f, 0x65, 0x33,
                                                       0x65, 0x34, 0x65, 0x35};
const uint8_t HuffDecoderCommon::table1_87_emit_[8] = {0x65, 0x36, 0x65, 0x37,
                                                       0x65, 0x38, 0x65, 0x39};
const uint8_t HuffDecoderCommon::table1_88_emit_[8] = {0x65, 0x3d, 0x65, 0x41,
                                                       0x65, 0x5f, 0x65, 0x62};
const uint8_t HuffDecoderCommon::table1_89_emit_[8] = {0x65, 0x64, 0x65, 0x66,
                                                       0x65, 0x67, 0x65, 0x68};
const uint8_t HuffDecoderCommon::table1_90_emit_[8] = {0x65, 0x6c, 0x65, 0x6d,
                                                       0x65, 0x6e, 0x65, 0x70};
const uint8_t HuffDecoderCommon::table1_91_emit_[12] = {
    0x65, 0x72, 0x65, 0x75, 0x65, 0x3a, 0x65, 0x42, 0x65, 0x43, 0x65, 0x44};
const uint8_t HuffDecoderCommon::table1_92_emit_[16] = {
    0x65, 0x45, 0x65, 0x46, 0x65, 0x47, 0x65, 0x48,
    0x65, 0x49, 0x65, 0x4a, 0x65, 0x4b, 0x65, 0x4c};
const uint8_t HuffDecoderCommon::table1_93_emit_[16] = {
    0x65, 0x4d, 0x65, 0x4e, 0x65, 0x4f, 0x65, 0x50,
    0x65, 0x51, 0x65, 0x52, 0x65, 0x53, 0x65, 0x54};
const uint8_t HuffDecoderCommon::table1_94_emit_[16] = {
    0x65, 0x55, 0x65, 0x56, 0x65, 0x57, 0x65, 0x59,
    0x65, 0x6a, 0x65, 0x6b, 0x65, 0x71, 0x65, 0x76};
const uint8_t HuffDecoderCommon::table1_95_emit_[30] = {
    0x65, 0x77, 0x65, 0x78, 0x65, 0x79, 0x65, 0x7a, 0x65, 0x26,
    0x65, 0x2a, 0x65, 0x2c, 0x65, 0x3b, 0x65, 0x58, 0x65, 0x5a,
    0x65, 0x21, 0x65, 0x22, 0x65, 0x28, 0x65, 0x29, 0x65, 0x3f};
const uint8_t HuffDecoderCommon::table1_96_emit_[58] = {
    0x69, 0x30, 0x30, 0x69, 0x30, 0x31, 0x69, 0x30, 0x32, 0x69, 0x30, 0x61,
    0x69, 0x30, 0x63, 0x69, 0x30, 0x65, 0x69, 0x30, 0x69, 0x30, 0x6f, 0x69,
    0x30, 0x73, 0x69, 0x30, 0x74, 0x69, 0x31, 0x30, 0x69, 0x31, 0x31, 0x69,
    0x31, 0x32, 0x69, 0x31, 0x61, 0x69, 0x31, 0x63, 0x69, 0x31, 0x65, 0x69,
    0x31, 0x69, 0x31, 0x6f, 0x69, 0x31, 0x73, 0x69, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_96_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x048f, 0x050f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a4f,
    0x0b0f, 0x0bcf, 0x0c4f, 0x0d0f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_97_emit_[58] = {
    0x69, 0x32, 0x30, 0x69, 0x32, 0x31, 0x69, 0x32, 0x32, 0x69, 0x32, 0x61,
    0x69, 0x32, 0x63, 0x69, 0x32, 0x65, 0x69, 0x32, 0x69, 0x32, 0x6f, 0x69,
    0x32, 0x73, 0x69, 0x32, 0x74, 0x69, 0x61, 0x30, 0x69, 0x61, 0x31, 0x69,
    0x61, 0x32, 0x69, 0x61, 0x61, 0x69, 0x61, 0x63, 0x69, 0x61, 0x65, 0x69,
    0x61, 0x69, 0x61, 0x6f, 0x69, 0x61, 0x73, 0x69, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table1_98_emit_[58] = {
    0x69, 0x63, 0x30, 0x69, 0x63, 0x31, 0x69, 0x63, 0x32, 0x69, 0x63, 0x61,
    0x69, 0x63, 0x63, 0x69, 0x63, 0x65, 0x69, 0x63, 0x69, 0x63, 0x6f, 0x69,
    0x63, 0x73, 0x69, 0x63, 0x74, 0x69, 0x65, 0x30, 0x69, 0x65, 0x31, 0x69,
    0x65, 0x32, 0x69, 0x65, 0x61, 0x69, 0x65, 0x63, 0x69, 0x65, 0x65, 0x69,
    0x65, 0x69, 0x65, 0x6f, 0x69, 0x65, 0x73, 0x69, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table1_99_emit_[55] = {
    0x69, 0x69, 0x30, 0x69, 0x69, 0x31, 0x69, 0x69, 0x32, 0x69, 0x69,
    0x61, 0x69, 0x69, 0x63, 0x69, 0x69, 0x65, 0x69, 0x69, 0x69, 0x6f,
    0x69, 0x69, 0x73, 0x69, 0x69, 0x74, 0x69, 0x6f, 0x30, 0x69, 0x6f,
    0x31, 0x69, 0x6f, 0x32, 0x69, 0x6f, 0x61, 0x69, 0x6f, 0x63, 0x69,
    0x6f, 0x65, 0x69, 0x6f, 0x6f, 0x69, 0x6f, 0x73, 0x69, 0x6f, 0x74};
const uint16_t HuffDecoderCommon::table1_99_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x048f, 0x04cf,
    0x058f, 0x064f, 0x001a, 0x070f, 0x07cf, 0x088f, 0x094f, 0x0a0f,
    0x0acf, 0x050f, 0x0b8f, 0x0c4f, 0x0d0f, 0x051a};
const uint8_t HuffDecoderCommon::table1_100_emit_[58] = {
    0x69, 0x73, 0x30, 0x69, 0x73, 0x31, 0x69, 0x73, 0x32, 0x69, 0x73, 0x61,
    0x69, 0x73, 0x63, 0x69, 0x73, 0x65, 0x69, 0x73, 0x69, 0x73, 0x6f, 0x69,
    0x73, 0x73, 0x69, 0x73, 0x74, 0x69, 0x74, 0x30, 0x69, 0x74, 0x31, 0x69,
    0x74, 0x32, 0x69, 0x74, 0x61, 0x69, 0x74, 0x63, 0x69, 0x74, 0x65, 0x69,
    0x74, 0x69, 0x74, 0x6f, 0x69, 0x74, 0x73, 0x69, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_101_emit_[8] = {0x69, 0x20, 0x69, 0x25,
                                                        0x69, 0x2d, 0x69, 0x2e};
const uint8_t HuffDecoderCommon::table1_102_emit_[8] = {0x69, 0x2f, 0x69, 0x33,
                                                        0x69, 0x34, 0x69, 0x35};
const uint8_t HuffDecoderCommon::table1_103_emit_[8] = {0x69, 0x36, 0x69, 0x37,
                                                        0x69, 0x38, 0x69, 0x39};
const uint8_t HuffDecoderCommon::table1_104_emit_[8] = {0x69, 0x3d, 0x69, 0x41,
                                                        0x69, 0x5f, 0x69, 0x62};
const uint8_t HuffDecoderCommon::table1_105_emit_[8] = {0x69, 0x64, 0x69, 0x66,
                                                        0x69, 0x67, 0x69, 0x68};
const uint8_t HuffDecoderCommon::table1_106_emit_[8] = {0x69, 0x6c, 0x69, 0x6d,
                                                        0x69, 0x6e, 0x69, 0x70};
const uint8_t HuffDecoderCommon::table1_107_emit_[12] = {
    0x69, 0x72, 0x69, 0x75, 0x69, 0x3a, 0x69, 0x42, 0x69, 0x43, 0x69, 0x44};
const uint8_t HuffDecoderCommon::table1_108_emit_[16] = {
    0x69, 0x45, 0x69, 0x46, 0x69, 0x47, 0x69, 0x48,
    0x69, 0x49, 0x69, 0x4a, 0x69, 0x4b, 0x69, 0x4c};
const uint8_t HuffDecoderCommon::table1_109_emit_[16] = {
    0x69, 0x4d, 0x69, 0x4e, 0x69, 0x4f, 0x69, 0x50,
    0x69, 0x51, 0x69, 0x52, 0x69, 0x53, 0x69, 0x54};
const uint8_t HuffDecoderCommon::table1_110_emit_[16] = {
    0x69, 0x55, 0x69, 0x56, 0x69, 0x57, 0x69, 0x59,
    0x69, 0x6a, 0x69, 0x6b, 0x69, 0x71, 0x69, 0x76};
const uint8_t HuffDecoderCommon::table1_111_emit_[30] = {
    0x69, 0x77, 0x69, 0x78, 0x69, 0x79, 0x69, 0x7a, 0x69, 0x26,
    0x69, 0x2a, 0x69, 0x2c, 0x69, 0x3b, 0x69, 0x58, 0x69, 0x5a,
    0x69, 0x21, 0x69, 0x22, 0x69, 0x28, 0x69, 0x29, 0x69, 0x3f};
const uint8_t HuffDecoderCommon::table1_112_emit_[58] = {
    0x6f, 0x30, 0x30, 0x6f, 0x30, 0x31, 0x6f, 0x30, 0x32, 0x6f, 0x30, 0x61,
    0x6f, 0x30, 0x63, 0x6f, 0x30, 0x65, 0x6f, 0x30, 0x69, 0x6f, 0x30, 0x6f,
    0x30, 0x73, 0x6f, 0x30, 0x74, 0x6f, 0x31, 0x30, 0x6f, 0x31, 0x31, 0x6f,
    0x31, 0x32, 0x6f, 0x31, 0x61, 0x6f, 0x31, 0x63, 0x6f, 0x31, 0x65, 0x6f,
    0x31, 0x69, 0x6f, 0x31, 0x6f, 0x31, 0x73, 0x6f, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_112_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x048f, 0x054f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a4f,
    0x0b0f, 0x0bcf, 0x0c8f, 0x0d0f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_113_emit_[58] = {
    0x6f, 0x32, 0x30, 0x6f, 0x32, 0x31, 0x6f, 0x32, 0x32, 0x6f, 0x32, 0x61,
    0x6f, 0x32, 0x63, 0x6f, 0x32, 0x65, 0x6f, 0x32, 0x69, 0x6f, 0x32, 0x6f,
    0x32, 0x73, 0x6f, 0x32, 0x74, 0x6f, 0x61, 0x30, 0x6f, 0x61, 0x31, 0x6f,
    0x61, 0x32, 0x6f, 0x61, 0x61, 0x6f, 0x61, 0x63, 0x6f, 0x61, 0x65, 0x6f,
    0x61, 0x69, 0x6f, 0x61, 0x6f, 0x61, 0x73, 0x6f, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table1_114_emit_[58] = {
    0x6f, 0x63, 0x30, 0x6f, 0x63, 0x31, 0x6f, 0x63, 0x32, 0x6f, 0x63, 0x61,
    0x6f, 0x63, 0x63, 0x6f, 0x63, 0x65, 0x6f, 0x63, 0x69, 0x6f, 0x63, 0x6f,
    0x63, 0x73, 0x6f, 0x63, 0x74, 0x6f, 0x65, 0x30, 0x6f, 0x65, 0x31, 0x6f,
    0x65, 0x32, 0x6f, 0x65, 0x61, 0x6f, 0x65, 0x63, 0x6f, 0x65, 0x65, 0x6f,
    0x65, 0x69, 0x6f, 0x65, 0x6f, 0x65, 0x73, 0x6f, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table1_115_emit_[57] = {
    0x6f, 0x69, 0x30, 0x6f, 0x69, 0x31, 0x6f, 0x69, 0x32, 0x6f, 0x69, 0x61,
    0x6f, 0x69, 0x63, 0x6f, 0x69, 0x65, 0x6f, 0x69, 0x69, 0x6f, 0x69, 0x6f,
    0x69, 0x73, 0x6f, 0x69, 0x74, 0x6f, 0x6f, 0x30, 0x6f, 0x6f, 0x31, 0x6f,
    0x6f, 0x32, 0x6f, 0x6f, 0x61, 0x6f, 0x6f, 0x63, 0x6f, 0x6f, 0x65, 0x6f,
    0x6f, 0x69, 0x6f, 0x6f, 0x6f, 0x73, 0x6f, 0x6f, 0x74};
const uint16_t HuffDecoderCommon::table1_115_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x048f, 0x054f,
    0x05cf, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a4f,
    0x0b0f, 0x0bcf, 0x0c8f, 0x0ccf, 0x0d8f, 0x075a};
const uint8_t HuffDecoderCommon::table1_116_emit_[58] = {
    0x6f, 0x73, 0x30, 0x6f, 0x73, 0x31, 0x6f, 0x73, 0x32, 0x6f, 0x73, 0x61,
    0x6f, 0x73, 0x63, 0x6f, 0x73, 0x65, 0x6f, 0x73, 0x69, 0x6f, 0x73, 0x6f,
    0x73, 0x73, 0x6f, 0x73, 0x74, 0x6f, 0x74, 0x30, 0x6f, 0x74, 0x31, 0x6f,
    0x74, 0x32, 0x6f, 0x74, 0x61, 0x6f, 0x74, 0x63, 0x6f, 0x74, 0x65, 0x6f,
    0x74, 0x69, 0x6f, 0x74, 0x6f, 0x74, 0x73, 0x6f, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_117_emit_[8] = {0x6f, 0x20, 0x6f, 0x25,
                                                        0x6f, 0x2d, 0x6f, 0x2e};
const uint8_t HuffDecoderCommon::table1_118_emit_[8] = {0x6f, 0x2f, 0x6f, 0x33,
                                                        0x6f, 0x34, 0x6f, 0x35};
const uint8_t HuffDecoderCommon::table1_119_emit_[8] = {0x6f, 0x36, 0x6f, 0x37,
                                                        0x6f, 0x38, 0x6f, 0x39};
const uint8_t HuffDecoderCommon::table1_120_emit_[8] = {0x6f, 0x3d, 0x6f, 0x41,
                                                        0x6f, 0x5f, 0x6f, 0x62};
const uint8_t HuffDecoderCommon::table1_121_emit_[8] = {0x6f, 0x64, 0x6f, 0x66,
                                                        0x6f, 0x67, 0x6f, 0x68};
const uint8_t HuffDecoderCommon::table1_122_emit_[8] = {0x6f, 0x6c, 0x6f, 0x6d,
                                                        0x6f, 0x6e, 0x6f, 0x70};
const uint8_t HuffDecoderCommon::table1_123_emit_[12] = {
    0x6f, 0x72, 0x6f, 0x75, 0x6f, 0x3a, 0x6f, 0x42, 0x6f, 0x43, 0x6f, 0x44};
const uint8_t HuffDecoderCommon::table1_124_emit_[16] = {
    0x6f, 0x45, 0x6f, 0x46, 0x6f, 0x47, 0x6f, 0x48,
    0x6f, 0x49, 0x6f, 0x4a, 0x6f, 0x4b, 0x6f, 0x4c};
const uint8_t HuffDecoderCommon::table1_125_emit_[16] = {
    0x6f, 0x4d, 0x6f, 0x4e, 0x6f, 0x4f, 0x6f, 0x50,
    0x6f, 0x51, 0x6f, 0x52, 0x6f, 0x53, 0x6f, 0x54};
const uint8_t HuffDecoderCommon::table1_126_emit_[16] = {
    0x6f, 0x55, 0x6f, 0x56, 0x6f, 0x57, 0x6f, 0x59,
    0x6f, 0x6a, 0x6f, 0x6b, 0x6f, 0x71, 0x6f, 0x76};
const uint8_t HuffDecoderCommon::table1_127_emit_[30] = {
    0x6f, 0x77, 0x6f, 0x78, 0x6f, 0x79, 0x6f, 0x7a, 0x6f, 0x26,
    0x6f, 0x2a, 0x6f, 0x2c, 0x6f, 0x3b, 0x6f, 0x58, 0x6f, 0x5a,
    0x6f, 0x21, 0x6f, 0x22, 0x6f, 0x28, 0x6f, 0x29, 0x6f, 0x3f};
const uint8_t HuffDecoderCommon::table1_128_emit_[58] = {
    0x73, 0x30, 0x30, 0x73, 0x30, 0x31, 0x73, 0x30, 0x32, 0x73, 0x30, 0x61,
    0x73, 0x30, 0x63, 0x73, 0x30, 0x65, 0x73, 0x30, 0x69, 0x73, 0x30, 0x6f,
    0x73, 0x30, 0x73, 0x30, 0x74, 0x73, 0x31, 0x30, 0x73, 0x31, 0x31, 0x73,
    0x31, 0x32, 0x73, 0x31, 0x61, 0x73, 0x31, 0x63, 0x73, 0x31, 0x65, 0x73,
    0x31, 0x69, 0x73, 0x31, 0x6f, 0x73, 0x31, 0x73, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_128_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x048f, 0x054f,
    0x060f, 0x068f, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a4f,
    0x0b0f, 0x0bcf, 0x0c8f, 0x0d4f, 0x0dcf, 0x075a};
const uint8_t HuffDecoderCommon::table1_129_emit_[58] = {
    0x73, 0x32, 0x30, 0x73, 0x32, 0x31, 0x73, 0x32, 0x32, 0x73, 0x32, 0x61,
    0x73, 0x32, 0x63, 0x73, 0x32, 0x65, 0x73, 0x32, 0x69, 0x73, 0x32, 0x6f,
    0x73, 0x32, 0x73, 0x32, 0x74, 0x73, 0x61, 0x30, 0x73, 0x61, 0x31, 0x73,
    0x61, 0x32, 0x73, 0x61, 0x61, 0x73, 0x61, 0x63, 0x73, 0x61, 0x65, 0x73,
    0x61, 0x69, 0x73, 0x61, 0x6f, 0x73, 0x61, 0x73, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table1_130_emit_[58] = {
    0x73, 0x63, 0x30, 0x73, 0x63, 0x31, 0x73, 0x63, 0x32, 0x73, 0x63, 0x61,
    0x73, 0x63, 0x63, 0x73, 0x63, 0x65, 0x73, 0x63, 0x69, 0x73, 0x63, 0x6f,
    0x73, 0x63, 0x73, 0x63, 0x74, 0x73, 0x65, 0x30, 0x73, 0x65, 0x31, 0x73,
    0x65, 0x32, 0x73, 0x65, 0x61, 0x73, 0x65, 0x63, 0x73, 0x65, 0x65, 0x73,
    0x65, 0x69, 0x73, 0x65, 0x6f, 0x73, 0x65, 0x73, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table1_131_emit_[58] = {
    0x73, 0x69, 0x30, 0x73, 0x69, 0x31, 0x73, 0x69, 0x32, 0x73, 0x69, 0x61,
    0x73, 0x69, 0x63, 0x73, 0x69, 0x65, 0x73, 0x69, 0x69, 0x73, 0x69, 0x6f,
    0x73, 0x69, 0x73, 0x69, 0x74, 0x73, 0x6f, 0x30, 0x73, 0x6f, 0x31, 0x73,
    0x6f, 0x32, 0x73, 0x6f, 0x61, 0x73, 0x6f, 0x63, 0x73, 0x6f, 0x65, 0x73,
    0x6f, 0x69, 0x73, 0x6f, 0x6f, 0x73, 0x6f, 0x73, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table1_132_emit_[55] = {
    0x73, 0x73, 0x30, 0x73, 0x73, 0x31, 0x73, 0x73, 0x32, 0x73, 0x73,
    0x61, 0x73, 0x73, 0x63, 0x73, 0x73, 0x65, 0x73, 0x73, 0x69, 0x73,
    0x73, 0x6f, 0x73, 0x73, 0x73, 0x74, 0x30, 0x73, 0x74, 0x31, 0x73,
    0x74, 0x32, 0x73, 0x74, 0x61, 0x73, 0x74, 0x63, 0x73, 0x74, 0x65,
    0x73, 0x74, 0x69, 0x73, 0x74, 0x6f, 0x73, 0x74, 0x73, 0x74, 0x74};
const uint16_t HuffDecoderCommon::table1_132_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x048f, 0x054f,
    0x060f, 0x064f, 0x001a, 0x068f, 0x074f, 0x080f, 0x08cf, 0x098f,
    0x0a4f, 0x0b0f, 0x0bcf, 0x0c8f, 0x0d0f, 0x069a};
const uint8_t HuffDecoderCommon::table1_133_emit_[8] = {0x73, 0x20, 0x73, 0x25,
                                                        0x73, 0x2d, 0x73, 0x2e};
const uint8_t HuffDecoderCommon::table1_134_emit_[8] = {0x73, 0x2f, 0x73, 0x33,
                                                        0x73, 0x34, 0x73, 0x35};
const uint8_t HuffDecoderCommon::table1_135_emit_[8] = {0x73, 0x36, 0x73, 0x37,
                                                        0x73, 0x38, 0x73, 0x39};
const uint8_t HuffDecoderCommon::table1_136_emit_[8] = {0x73, 0x3d, 0x73, 0x41,
                                                        0x73, 0x5f, 0x73, 0x62};
const uint8_t HuffDecoderCommon::table1_137_emit_[8] = {0x73, 0x64, 0x73, 0x66,
                                                        0x73, 0x67, 0x73, 0x68};
const uint8_t HuffDecoderCommon::table1_138_emit_[8] = {0x73, 0x6c, 0x73, 0x6d,
                                                        0x73, 0x6e, 0x73, 0x70};
const uint8_t HuffDecoderCommon::table1_139_emit_[12] = {
    0x73, 0x72, 0x73, 0x75, 0x73, 0x3a, 0x73, 0x42, 0x73, 0x43, 0x73, 0x44};
const uint8_t HuffDecoderCommon::table1_140_emit_[16] = {
    0x73, 0x45, 0x73, 0x46, 0x73, 0x47, 0x73, 0x48,
    0x73, 0x49, 0x73, 0x4a, 0x73, 0x4b, 0x73, 0x4c};
const uint8_t HuffDecoderCommon::table1_141_emit_[16] = {
    0x73, 0x4d, 0x73, 0x4e, 0x73, 0x4f, 0x73, 0x50,
    0x73, 0x51, 0x73, 0x52, 0x73, 0x53, 0x73, 0x54};
const uint8_t HuffDecoderCommon::table1_142_emit_[16] = {
    0x73, 0x55, 0x73, 0x56, 0x73, 0x57, 0x73, 0x59,
    0x73, 0x6a, 0x73, 0x6b, 0x73, 0x71, 0x73, 0x76};
const uint8_t HuffDecoderCommon::table1_143_emit_[30] = {
    0x73, 0x77, 0x73, 0x78, 0x73, 0x79, 0x73, 0x7a, 0x73, 0x26,
    0x73, 0x2a, 0x73, 0x2c, 0x73, 0x3b, 0x73, 0x58, 0x73, 0x5a,
    0x73, 0x21, 0x73, 0x22, 0x73, 0x28, 0x73, 0x29, 0x73, 0x3f};
const uint8_t HuffDecoderCommon::table1_144_emit_[59] = {
    0x74, 0x30, 0x30, 0x74, 0x30, 0x31, 0x74, 0x30, 0x32, 0x74, 0x30, 0x61,
    0x74, 0x30, 0x63, 0x74, 0x30, 0x65, 0x74, 0x30, 0x69, 0x74, 0x30, 0x6f,
    0x74, 0x30, 0x73, 0x74, 0x30, 0x74, 0x31, 0x30, 0x74, 0x31, 0x31, 0x74,
    0x31, 0x32, 0x74, 0x31, 0x61, 0x74, 0x31, 0x63, 0x74, 0x31, 0x65, 0x74,
    0x31, 0x69, 0x74, 0x31, 0x6f, 0x74, 0x31, 0x73, 0x74, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table1_144_inner_[22] = {
    0x000f, 0x00cf, 0x018f, 0x024f, 0x030f, 0x03cf, 0x048f, 0x054f,
    0x060f, 0x06cf, 0x001a, 0x074f, 0x080f, 0x08cf, 0x098f, 0x0a4f,
    0x0b0f, 0x0bcf, 0x0c8f, 0x0d4f, 0x0e0f, 0x075a};
const uint8_t HuffDecoderCommon::table1_145_emit_[59] = {
    0x74, 0x32, 0x30, 0x74, 0x32, 0x31, 0x74, 0x32, 0x32, 0x74, 0x32, 0x61,
    0x74, 0x32, 0x63, 0x74, 0x32, 0x65, 0x74, 0x32, 0x69, 0x74, 0x32, 0x6f,
    0x74, 0x32, 0x73, 0x74, 0x32, 0x74, 0x61, 0x30, 0x74, 0x61, 0x31, 0x74,
    0x61, 0x32, 0x74, 0x61, 0x61, 0x74, 0x61, 0x63, 0x74, 0x61, 0x65, 0x74,
    0x61, 0x69, 0x74, 0x61, 0x6f, 0x74, 0x61, 0x73, 0x74, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table1_146_emit_[59] = {
    0x74, 0x63, 0x30, 0x74, 0x63, 0x31, 0x74, 0x63, 0x32, 0x74, 0x63, 0x61,
    0x74, 0x63, 0x63, 0x74, 0x63, 0x65, 0x74, 0x63, 0x69, 0x74, 0x63, 0x6f,
    0x74, 0x63, 0x73, 0x74, 0x63, 0x74, 0x65, 0x30, 0x74, 0x65, 0x31, 0x74,
    0x65, 0x32, 0x74, 0x65, 0x61, 0x74, 0x65, 0x63, 0x74, 0x65, 0x65, 0x74,
    0x65, 0x69, 0x74, 0x65, 0x6f, 0x74, 0x65, 0x73, 0x74, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table1_147_emit_[59] = {
    0x74, 0x69, 0x30, 0x74, 0x69, 0x31, 0x74, 0x69, 0x32, 0x74, 0x69, 0x61,
    0x74, 0x69, 0x63, 0x74, 0x69, 0x65, 0x74, 0x69, 0x69, 0x74, 0x69, 0x6f,
    0x74, 0x69, 0x73, 0x74, 0x69, 0x74, 0x6f, 0x30, 0x74, 0x6f, 0x31, 0x74,
    0x6f, 0x32, 0x74, 0x6f, 0x61, 0x74, 0x6f, 0x63, 0x74, 0x6f, 0x65, 0x74,
    0x6f, 0x69, 0x74, 0x6f, 0x6f, 0x74, 0x6f, 0x73, 0x74, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table1_148_emit_[59] = {
    0x74, 0x73, 0x30, 0x74, 0x73, 0x31, 0x74, 0x73, 0x32, 0x74, 0x73, 0x61,
    0x74, 0x73, 0x63, 0x74, 0x73, 0x65, 0x74, 0x73, 0x69, 0x74, 0x73, 0x6f,
    0x74, 0x73, 0x73, 0x74, 0x73, 0x74, 0x74, 0x30, 0x74, 0x74, 0x31, 0x74,
    0x74, 0x32, 0x74, 0x74, 0x61, 0x74, 0x74, 0x63, 0x74, 0x74, 0x65, 0x74,
    0x74, 0x69, 0x74, 0x74, 0x6f, 0x74, 0x74, 0x73, 0x74, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table1_149_emit_[8] = {0x74, 0x20, 0x74, 0x25,
                                                        0x74, 0x2d, 0x74, 0x2e};
const uint8_t HuffDecoderCommon::table1_150_emit_[8] = {0x74, 0x2f, 0x74, 0x33,
                                                        0x74, 0x34, 0x74, 0x35};
const uint8_t HuffDecoderCommon::table1_151_emit_[8] = {0x74, 0x36, 0x74, 0x37,
                                                        0x74, 0x38, 0x74, 0x39};
const uint8_t HuffDecoderCommon::table1_152_emit_[8] = {0x74, 0x3d, 0x74, 0x41,
                                                        0x74, 0x5f, 0x74, 0x62};
const uint8_t HuffDecoderCommon::table1_153_emit_[8] = {0x74, 0x64, 0x74, 0x66,
                                                        0x74, 0x67, 0x74, 0x68};
const uint8_t HuffDecoderCommon::table1_154_emit_[8] = {0x74, 0x6c, 0x74, 0x6d,
                                                        0x74, 0x6e, 0x74, 0x70};
const uint8_t HuffDecoderCommon::table1_155_emit_[12] = {
    0x74, 0x72, 0x74, 0x75, 0x74, 0x3a, 0x74, 0x42, 0x74, 0x43, 0x74, 0x44};
const uint8_t HuffDecoderCommon::table1_156_emit_[16] = {
    0x74, 0x45, 0x74, 0x46, 0x74, 0x47, 0x74, 0x48,
    0x74, 0x49, 0x74, 0x4a, 0x74, 0x4b, 0x74, 0x4c};
const uint8_t HuffDecoderCommon::table1_157_emit_[16] = {
    0x74, 0x4d, 0x74, 0x4e, 0x74, 0x4f, 0x74, 0x50,
    0x74, 0x51, 0x74, 0x52, 0x74, 0x53, 0x74, 0x54};
const uint8_t HuffDecoderCommon::table1_158_emit_[16] = {
    0x74, 0x55, 0x74, 0x56, 0x74, 0x57, 0x74, 0x59,
    0x74, 0x6a, 0x74, 0x6b, 0x74, 0x71, 0x74, 0x76};
const uint8_t HuffDecoderCommon::table1_159_emit_[30] = {
    0x74, 0x77, 0x74, 0x78, 0x74, 0x79, 0x74, 0x7a, 0x74, 0x26,
    0x74, 0x2a, 0x74, 0x2c, 0x74, 0x3b, 0x74, 0x58, 0x74, 0x5a,
    0x74, 0x21, 0x74, 0x22, 0x74, 0x28, 0x74, 0x29, 0x74, 0x3f};
const uint8_t HuffDecoderCommon::table1_160_emit_[8] = {0x20, 0x30, 0x20, 0x31,
                                                        0x20, 0x32, 0x20, 0x61};
const uint8_t HuffDecoderCommon::table1_161_emit_[8] = {0x20, 0x63, 0x20, 0x65,
                                                        0x20, 0x69, 0x20, 0x6f};
const uint8_t HuffDecoderCommon::table1_162_emit_[11] = {
    0x20, 0x73, 0x20, 0x74, 0x20, 0x20, 0x25, 0x20, 0x2d, 0x20, 0x2e};
const uint16_t HuffDecoderCommon::table1_162_inner_[6] = {
    0x001b, 0x009b, 0x011c, 0x015c, 0x01dc, 0x025c};
const uint8_t HuffDecoderCommon::table1_163_emit_[16] = {
    0x20, 0x2f, 0x20, 0x33, 0x20, 0x34, 0x20, 0x35,
    0x20, 0x36, 0x20, 0x37, 0x20, 0x38, 0x20, 0x39};
const uint8_t HuffDecoderCommon::table1_164_emit_[16] = {
    0x20, 0x3d, 0x20, 0x41, 0x20, 0x5f, 0x20, 0x62,
    0x20, 0x64, 0x20, 0x66, 0x20, 0x67, 0x20, 0x68};
const uint8_t HuffDecoderCommon::table1_165_emit_[20] = {
    0x20, 0x6c, 0x20, 0x6d, 0x20, 0x6e, 0x20, 0x70, 0x20, 0x72,
    0x20, 0x75, 0x20, 0x3a, 0x20, 0x42, 0x20, 0x43, 0x20, 0x44};
const uint16_t HuffDecoderCommon::table1_165_inner_[10] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x021c,
    0x029c, 0x031d, 0x039d, 0x041d, 0x049d};
const uint8_t HuffDecoderCommon::table1_165_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
    2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5,
    5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9};
const uint8_t HuffDecoderCommon::table1_166_emit_[32] = {
    0x20, 0x45, 0x20, 0x46, 0x20, 0x47, 0x20, 0x48, 0x20, 0x49, 0x20,
    0x4a, 0x20, 0x4b, 0x20, 0x4c, 0x20, 0x4d, 0x20, 0x4e, 0x20, 0x4f,
    0x20, 0x50, 0x20, 0x51, 0x20, 0x52, 0x20, 0x53, 0x20, 0x54};
const uint16_t HuffDecoderCommon::table1_166_inner_[16] = {
    0x001d, 0x009d, 0x011d, 0x019d, 0x021d, 0x029d, 0x031d, 0x039d,
    0x041d, 0x049d, 0x051d, 0x059d, 0x061d, 0x069d, 0x071d, 0x079d};
const uint8_t HuffDecoderCommon::table1_166_outer_[64] = {
    0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
    4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
    8,  8,  8,  8,  9,  9,  9,  9,  10, 10, 10, 10, 11, 11, 11, 11,
    12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15};
const uint8_t HuffDecoderCommon::table1_167_emit_[36] = {
    0x20, 0x55, 0x20, 0x56, 0x20, 0x57, 0x20, 0x59, 0x20, 0x6a, 0x20, 0x6b,
    0x20, 0x71, 0x20, 0x76, 0x20, 0x77, 0x20, 0x78, 0x20, 0x79, 0x20, 0x7a,
    0x20, 0x26, 0x20, 0x2a, 0x20, 0x2c, 0x20, 0x3b, 0x20, 0x58, 0x20, 0x5a};
const uint16_t HuffDecoderCommon::table1_167_inner_[19] = {
    0x001d, 0x009d, 0x011d, 0x019d, 0x021d, 0x029d, 0x031d,
    0x039d, 0x041d, 0x049d, 0x051d, 0x059d, 0x061e, 0x069e,
    0x071e, 0x079e, 0x081e, 0x089e, 0x0026};
const uint8_t HuffDecoderCommon::table1_167_outer_[64] = {
    0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
    4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
    8,  8,  8,  8,  9,  9,  9,  9,  10, 10, 10, 10, 11, 11, 11, 11,
    12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 18, 18};
const uint8_t HuffDecoderCommon::table1_168_emit_[8] = {0x25, 0x30, 0x25, 0x31,
                                                        0x25, 0x32, 0x25, 0x61};
const uint8_t HuffDecoderCommon::table1_169_emit_[8] = {0x25, 0x63, 0x25, 0x65,
                                                        0x25, 0x69, 0x25, 0x6f};
const uint8_t HuffDecoderCommon::table1_170_emit_[11] = {
    0x25, 0x73, 0x25, 0x74, 0x25, 0x20, 0x25, 0x25, 0x2d, 0x25, 0x2e};
const uint16_t HuffDecoderCommon::table1_170_inner_[6] = {
    0x001b, 0x009b, 0x011c, 0x019c, 0x01dc, 0x025c};
const uint8_t HuffDecoderCommon::table1_171_emit_[16] = {
    0x25, 0x2f, 0x25, 0x33, 0x25, 0x34, 0x25, 0x35,
    0x25, 0x36, 0x25, 0x37, 0x25, 0x38, 0x25, 0x39};
const uint8_t HuffDecoderCommon::table1_172_emit_[16] = {
    0x25, 0x3d, 0x25, 0x41, 0x25, 0x5f, 0x25, 0x62,
    0x25, 0x64, 0x25, 0x66, 0x25, 0x67, 0x25, 0x68};
const uint8_t HuffDecoderCommon::table1_173_emit_[20] = {
    0x25, 0x6c, 0x25, 0x6d, 0x25, 0x6e, 0x25, 0x70, 0x25, 0x72,
    0x25, 0x75, 0x25, 0x3a, 0x25, 0x42, 0x25, 0x43, 0x25, 0x44};
const uint8_t HuffDecoderCommon::table1_174_emit_[32] = {
    0x25, 0x45, 0x25, 0x46, 0x25, 0x47, 0x25, 0x48, 0x25, 0x49, 0x25,
    0x4a, 0x25, 0x4b, 0x25, 0x4c, 0x25, 0x4d, 0x25, 0x4e, 0x25, 0x4f,
    0x25, 0x50, 0x25, 0x51, 0x25, 0x52, 0x25, 0x53, 0x25, 0x54};
const uint8_t HuffDecoderCommon::table1_175_emit_[36] = {
    0x25, 0x55, 0x25, 0x56, 0x25, 0x57, 0x25, 0x59, 0x25, 0x6a, 0x25, 0x6b,
    0x25, 0x71, 0x25, 0x76, 0x25, 0x77, 0x25, 0x78, 0x25, 0x79, 0x25, 0x7a,
    0x25, 0x26, 0x25, 0x2a, 0x25, 0x2c, 0x25, 0x3b, 0x25, 0x58, 0x25, 0x5a};
const uint8_t HuffDecoderCommon::table1_176_emit_[8] = {0x2d, 0x30, 0x2d, 0x31,
                                                        0x2d, 0x32, 0x2d, 0x61};
const uint8_t HuffDecoderCommon::table1_177_emit_[8] = {0x2d, 0x63, 0x2d, 0x65,
                                                        0x2d, 0x69, 0x2d, 0x6f};
const uint8_t HuffDecoderCommon::table1_178_emit_[11] = {
    0x2d, 0x73, 0x2d, 0x74, 0x2d, 0x20, 0x2d, 0x25, 0x2d, 0x2d, 0x2e};
const uint16_t HuffDecoderCommon::table1_178_inner_[6] = {
    0x001b, 0x009b, 0x011c, 0x019c, 0x021c, 0x025c};
const uint8_t HuffDecoderCommon::table1_179_emit_[16] = {
    0x2d, 0x2f, 0x2d, 0x33, 0x2d, 0x34, 0x2d, 0x35,
    0x2d, 0x36, 0x2d, 0x37, 0x2d, 0x38, 0x2d, 0x39};
const uint8_t HuffDecoderCommon::table1_180_emit_[16] = {
    0x2d, 0x3d, 0x2d, 0x41, 0x2d, 0x5f, 0x2d, 0x62,
    0x2d, 0x64, 0x2d, 0x66, 0x2d, 0x67, 0x2d, 0x68};
const uint8_t HuffDecoderCommon::table1_181_emit_[20] = {
    0x2d, 0x6c, 0x2d, 0x6d, 0x2d, 0x6e, 0x2d, 0x70, 0x2d, 0x72,
    0x2d, 0x75, 0x2d, 0x3a, 0x2d, 0x42, 0x2d, 0x43, 0x2d, 0x44};
const uint8_t HuffDecoderCommon::table1_182_emit_[32] = {
    0x2d, 0x45, 0x2d, 0x46, 0x2d, 0x47, 0x2d, 0x48, 0x2d, 0x49, 0x2d,
    0x4a, 0x2d, 0x4b, 0x2d, 0x4c, 0x2d, 0x4d, 0x2d, 0x4e, 0x2d, 0x4f,
    0x2d, 0x50, 0x2d, 0x51, 0x2d, 0x52, 0x2d, 0x53, 0x2d, 0x54};
const uint8_t HuffDecoderCommon::table1_183_emit_[36] = {
    0x2d, 0x55, 0x2d, 0x56, 0x2d, 0x57, 0x2d, 0x59, 0x2d, 0x6a, 0x2d, 0x6b,
    0x2d, 0x71, 0x2d, 0x76, 0x2d, 0x77, 0x2d, 0x78, 0x2d, 0x79, 0x2d, 0x7a,
    0x2d, 0x26, 0x2d, 0x2a, 0x2d, 0x2c, 0x2d, 0x3b, 0x2d, 0x58, 0x2d, 0x5a};
const uint8_t HuffDecoderCommon::table1_184_emit_[8] = {0x2e, 0x30, 0x2e, 0x31,
                                                        0x2e, 0x32, 0x2e, 0x61};
const uint8_t HuffDecoderCommon::table1_185_emit_[8] = {0x2e, 0x63, 0x2e, 0x65,
                                                        0x2e, 0x69, 0x2e, 0x6f};
const uint8_t HuffDecoderCommon::table1_186_emit_[12] = {
    0x2e, 0x73, 0x2e, 0x74, 0x2e, 0x20, 0x2e, 0x25, 0x2e, 0x2d, 0x2e, 0x2e};
const uint8_t HuffDecoderCommon::table1_187_emit_[16] = {
    0x2e, 0x2f, 0x2e, 0x33, 0x2e, 0x34, 0x2e, 0x35,
    0x2e, 0x36, 0x2e, 0x37, 0x2e, 0x38, 0x2e, 0x39};
const uint8_t HuffDecoderCommon::table1_188_emit_[16] = {
    0x2e, 0x3d, 0x2e, 0x41, 0x2e, 0x5f, 0x2e, 0x62,
    0x2e, 0x64, 0x2e, 0x66, 0x2e, 0x67, 0x2e, 0x68};
const uint8_t HuffDecoderCommon::table1_189_emit_[20] = {
    0x2e, 0x6c, 0x2e, 0x6d, 0x2e, 0x6e, 0x2e, 0x70, 0x2e, 0x72,
    0x2e, 0x75, 0x2e, 0x3a, 0x2e, 0x42, 0x2e, 0x43, 0x2e, 0x44};
const uint8_t HuffDecoderCommon::table1_190_emit_[32] = {
    0x2e, 0x45, 0x2e, 0x46, 0x2e, 0x47, 0x2e, 0x48, 0x2e, 0x49, 0x2e,
    0x4a, 0x2e, 0x4b, 0x2e, 0x4c, 0x2e, 0x4d, 0x2e, 0x4e, 0x2e, 0x4f,
    0x2e, 0x50, 0x2e, 0x51, 0x2e, 0x52, 0x2e, 0x53, 0x2e, 0x54};
const uint8_t HuffDecoderCommon::table1_191_emit_[36] = {
    0x2e, 0x55, 0x2e, 0x56, 0x2e, 0x57, 0x2e, 0x59, 0x2e, 0x6a, 0x2e, 0x6b,
    0x2e, 0x71, 0x2e, 0x76, 0x2e, 0x77, 0x2e, 0x78, 0x2e, 0x79, 0x2e, 0x7a,
    0x2e, 0x26, 0x2e, 0x2a, 0x2e, 0x2c, 0x2e, 0x3b, 0x2e, 0x58, 0x2e, 0x5a};
const uint8_t HuffDecoderCommon::table1_192_emit_[8] = {0x2f, 0x30, 0x2f, 0x31,
                                                        0x2f, 0x32, 0x2f, 0x61};
const uint8_t HuffDecoderCommon::table1_193_emit_[8] = {0x2f, 0x63, 0x2f, 0x65,
                                                        0x2f, 0x69, 0x2f, 0x6f};
const uint8_t HuffDecoderCommon::table1_194_emit_[12] = {
    0x2f, 0x73, 0x2f, 0x74, 0x2f, 0x20, 0x2f, 0x25, 0x2f, 0x2d, 0x2f, 0x2e};
const uint8_t HuffDecoderCommon::table1_195_emit_[15] = {
    0x2f, 0x2f, 0x33, 0x2f, 0x34, 0x2f, 0x35, 0x2f,
    0x36, 0x2f, 0x37, 0x2f, 0x38, 0x2f, 0x39};
const uint16_t HuffDecoderCommon::table1_195_inner_[8] = {
    0x001c, 0x005c, 0x00dc, 0x015c, 0x01dc, 0x025c, 0x02dc, 0x035c};
const uint8_t HuffDecoderCommon::table1_196_emit_[16] = {
    0x2f, 0x3d, 0x2f, 0x41, 0x2f, 0x5f, 0x2f, 0x62,
    0x2f, 0x64, 0x2f, 0x66, 0x2f, 0x67, 0x2f, 0x68};
const uint8_t HuffDecoderCommon::table1_197_emit_[20] = {
    0x2f, 0x6c, 0x2f, 0x6d, 0x2f, 0x6e, 0x2f, 0x70, 0x2f, 0x72,
    0x2f, 0x75, 0x2f, 0x3a, 0x2f, 0x42, 0x2f, 0x43, 0x2f, 0x44};
const uint8_t HuffDecoderCommon::table1_198_emit_[32] = {
    0x2f, 0x45, 0x2f, 0x46, 0x2f, 0x47, 0x2f, 0x48, 0x2f, 0x49, 0x2f,
    0x4a, 0x2f, 0x4b, 0x2f, 0x4c, 0x2f, 0x4d, 0x2f, 0x4e, 0x2f, 0x4f,
    0x2f, 0x50, 0x2f, 0x51, 0x2f, 0x52, 0x2f, 0x53, 0x2f, 0x54};
const uint8_t HuffDecoderCommon::table1_199_emit_[36] = {
    0x2f, 0x55, 0x2f, 0x56, 0x2f, 0x57, 0x2f, 0x59, 0x2f, 0x6a, 0x2f, 0x6b,
    0x2f, 0x71, 0x2f, 0x76, 0x2f, 0x77, 0x2f, 0x78, 0x2f, 0x79, 0x2f, 0x7a,
    0x2f, 0x26, 0x2f, 0x2a, 0x2f, 0x2c, 0x2f, 0x3b, 0x2f, 0x58, 0x2f, 0x5a};
const uint8_t HuffDecoderCommon::table1_200_emit_[8] = {0x33, 0x30, 0x33, 0x31,
                                                        0x33, 0x32, 0x33, 0x61};
const uint8_t HuffDecoderCommon::table1_201_emit_[8] = {0x33, 0x63, 0x33, 0x65,
                                                        0x33, 0x69, 0x33, 0x6f};
const uint8_t HuffDecoderCommon::table1_202_emit_[12] = {
    0x33, 0x73, 0x33, 0x74, 0x33, 0x20, 0x33, 0x25, 0x33, 0x2d, 0x33, 0x2e};
const uint8_t HuffDecoderCommon::table1_203_emit_[15] = {
    0x33, 0x2f, 0x33, 0x33, 0x34, 0x33, 0x35, 0x33,
    0x36, 0x33, 0x37, 0x33, 0x38, 0x33, 0x39};
const uint16_t HuffDecoderCommon::table1_203_inner_[8] = {
    0x001c, 0x009c, 0x00dc, 0x015c, 0x01dc, 0x025c, 0x02dc, 0x035c};
const uint8_t HuffDecoderCommon::table1_204_emit_[16] = {
    0x33, 0x3d, 0x33, 0x41, 0x33, 0x5f, 0x33, 0x62,
    0x33, 0x64, 0x33, 0x66, 0x33, 0x67, 0x33, 0x68};
const uint8_t HuffDecoderCommon::table1_205_emit_[20] = {
    0x33, 0x6c, 0x33, 0x6d, 0x33, 0x6e, 0x33, 0x70, 0x33, 0x72,
    0x33, 0x75, 0x33, 0x3a, 0x33, 0x42, 0x33, 0x43, 0x33, 0x44};
const uint8_t HuffDecoderCommon::table1_206_emit_[32] = {
    0x33, 0x45, 0x33, 0x46, 0x33, 0x47, 0x33, 0x48, 0x33, 0x49, 0x33,
    0x4a, 0x33, 0x4b, 0x33, 0x4c, 0x33, 0x4d, 0x33, 0x4e, 0x33, 0x4f,
    0x33, 0x50, 0x33, 0x51, 0x33, 0x52, 0x33, 0x53, 0x33, 0x54};
const uint8_t HuffDecoderCommon::table1_207_emit_[36] = {
    0x33, 0x55, 0x33, 0x56, 0x33, 0x57, 0x33, 0x59, 0x33, 0x6a, 0x33, 0x6b,
    0x33, 0x71, 0x33, 0x76, 0x33, 0x77, 0x33, 0x78, 0x33, 0x79, 0x33, 0x7a,
    0x33, 0x26, 0x33, 0x2a, 0x33, 0x2c, 0x33, 0x3b, 0x33, 0x58, 0x33, 0x5a};
const uint8_t HuffDecoderCommon::table1_208_emit_[8] = {0x34, 0x30, 0x34, 0x31,
                                                        0x34, 0x32, 0x34, 0x61};
const uint8_t HuffDecoderCommon::table1_209_emit_[8] = {0x34, 0x63, 0x34, 0x65,
                                                        0x34, 0x69, 0x34, 0x6f};
const uint8_t HuffDecoderCommon::table1_210_emit_[12] = {
    0x34, 0x73, 0x34, 0x74, 0x34, 0x20, 0x34, 0x25, 0x34, 0x2d, 0x34, 0x2e};
const uint8_t HuffDecoderCommon::table1_211_emit_[15] = {
    0x34, 0x2f, 0x34, 0x33, 0x34, 0x34, 0x35, 0x34,
    0x36, 0x34, 0x37, 0x34, 0x38, 0x34, 0x39};
const uint16_t HuffDecoderCommon::table1_211_inner_[8] = {
    0x001c, 0x009c, 0x011c, 0x015c, 0x01dc, 0x025c, 0x02dc, 0x035c};
const uint8_t HuffDecoderCommon::table1_212_emit_[16] = {
    0x34, 0x3d, 0x34, 0x41, 0x34, 0x5f, 0x34, 0x62,
    0x34, 0x64, 0x34, 0x66, 0x34, 0x67, 0x34, 0x68};
const uint8_t HuffDecoderCommon::table1_213_emit_[20] = {
    0x34, 0x6c, 0x34, 0x6d, 0x34, 0x6e, 0x34, 0x70, 0x34, 0x72,
    0x34, 0x75, 0x34, 0x3a, 0x34, 0x42, 0x34, 0x43, 0x34, 0x44};
const uint8_t HuffDecoderCommon::table1_214_emit_[32] = {
    0x34, 0x45, 0x34, 0x46, 0x34, 0x47, 0x34, 0x48, 0x34, 0x49, 0x34,
    0x4a, 0x34, 0x4b, 0x34, 0x4c, 0x34, 0x4d, 0x34, 0x4e, 0x34, 0x4f,
    0x34, 0x50, 0x34, 0x51, 0x34, 0x52, 0x34, 0x53, 0x34, 0x54};
const uint8_t HuffDecoderCommon::table1_215_emit_[36] = {
    0x34, 0x55, 0x34, 0x56, 0x34, 0x57, 0x34, 0x59, 0x34, 0x6a, 0x34, 0x6b,
    0x34, 0x71, 0x34, 0x76, 0x34, 0x77, 0x34, 0x78, 0x34, 0x79, 0x34, 0x7a,
    0x34, 0x26, 0x34, 0x2a, 0x34, 0x2c, 0x34, 0x3b, 0x34, 0x58, 0x34, 0x5a};
const uint8_t HuffDecoderCommon::table1_216_emit_[8] = {0x35, 0x30, 0x35, 0x31,
                                                        0x35, 0x32, 0x35, 0x61};
const uint8_t HuffDecoderCommon::table1_217_emit_[8] = {0x35, 0x63, 0x35, 0x65,
                                                        0x35, 0x69, 0x35, 0x6f};
const uint8_t HuffDecoderCommon::table1_218_emit_[12] = {
    0x35, 0x73, 0x35, 0x74, 0x35, 0x20, 0x35, 0x25, 0x35, 0x2d, 0x35, 0x2e};
const uint8_t HuffDecoderCommon::table1_219_emit_[15] = {
    0x35, 0x2f, 0x35, 0x33, 0x35, 0x34, 0x35, 0x35,
    0x36, 0x35, 0x37, 0x35, 0x38, 0x35, 0x39};
const uint16_t HuffDecoderCommon::table1_219_inner_[8] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x01dc, 0x025c, 0x02dc, 0x035c};
const uint8_t HuffDecoderCommon::table1_220_emit_[16] = {
    0x35, 0x3d, 0x35, 0x41, 0x35, 0x5f, 0x35, 0x62,
    0x35, 0x64, 0x35, 0x66, 0x35, 0x67, 0x35, 0x68};
const uint8_t HuffDecoderCommon::table1_221_emit_[20] = {
    0x35, 0x6c, 0x35, 0x6d, 0x35, 0x6e, 0x35, 0x70, 0x35, 0x72,
    0x35, 0x75, 0x35, 0x3a, 0x35, 0x42, 0x35, 0x43, 0x35, 0x44};
const uint8_t HuffDecoderCommon::table1_222_emit_[32] = {
    0x35, 0x45, 0x35, 0x46, 0x35, 0x47, 0x35, 0x48, 0x35, 0x49, 0x35,
    0x4a, 0x35, 0x4b, 0x35, 0x4c, 0x35, 0x4d, 0x35, 0x4e, 0x35, 0x4f,
    0x35, 0x50, 0x35, 0x51, 0x35, 0x52, 0x35, 0x53, 0x35, 0x54};
const uint8_t HuffDecoderCommon::table1_223_emit_[36] = {
    0x35, 0x55, 0x35, 0x56, 0x35, 0x57, 0x35, 0x59, 0x35, 0x6a, 0x35, 0x6b,
    0x35, 0x71, 0x35, 0x76, 0x35, 0x77, 0x35, 0x78, 0x35, 0x79, 0x35, 0x7a,
    0x35, 0x26, 0x35, 0x2a, 0x35, 0x2c, 0x35, 0x3b, 0x35, 0x58, 0x35, 0x5a};
const uint8_t HuffDecoderCommon::table1_224_emit_[8] = {0x36, 0x30, 0x36, 0x31,
                                                        0x36, 0x32, 0x36, 0x61};
const uint8_t HuffDecoderCommon::table1_225_emit_[8] = {0x36, 0x63, 0x36, 0x65,
                                                        0x36, 0x69, 0x36, 0x6f};
const uint8_t HuffDecoderCommon::table1_226_emit_[12] = {
    0x36, 0x73, 0x36, 0x74, 0x36, 0x20, 0x36, 0x25, 0x36, 0x2d, 0x36, 0x2e};
const uint8_t HuffDecoderCommon::table1_227_emit_[15] = {
    0x36, 0x2f, 0x36, 0x33, 0x36, 0x34, 0x36, 0x35,
    0x36, 0x36, 0x37, 0x36, 0x38, 0x36, 0x39};
const uint16_t HuffDecoderCommon::table1_227_inner_[8] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x021c, 0x025c, 0x02dc, 0x035c};
const uint8_t HuffDecoderCommon::table1_228_emit_[16] = {
    0x36, 0x3d, 0x36, 0x41, 0x36, 0x5f, 0x36, 0x62,
    0x36, 0x64, 0x36, 0x66, 0x36, 0x67, 0x36, 0x68};
const uint8_t HuffDecoderCommon::table1_229_emit_[20] = {
    0x36, 0x6c, 0x36, 0x6d, 0x36, 0x6e, 0x36, 0x70, 0x36, 0x72,
    0x36, 0x75, 0x36, 0x3a, 0x36, 0x42, 0x36, 0x43, 0x36, 0x44};
const uint8_t HuffDecoderCommon::table1_230_emit_[32] = {
    0x36, 0x45, 0x36, 0x46, 0x36, 0x47, 0x36, 0x48, 0x36, 0x49, 0x36,
    0x4a, 0x36, 0x4b, 0x36, 0x4c, 0x36, 0x4d, 0x36, 0x4e, 0x36, 0x4f,
    0x36, 0x50, 0x36, 0x51, 0x36, 0x52, 0x36, 0x53, 0x36, 0x54};
const uint8_t HuffDecoderCommon::table1_231_emit_[36] = {
    0x36, 0x55, 0x36, 0x56, 0x36, 0x57, 0x36, 0x59, 0x36, 0x6a, 0x36, 0x6b,
    0x36, 0x71, 0x36, 0x76, 0x36, 0x77, 0x36, 0x78, 0x36, 0x79, 0x36, 0x7a,
    0x36, 0x26, 0x36, 0x2a, 0x36, 0x2c, 0x36, 0x3b, 0x36, 0x58, 0x36, 0x5a};
const uint8_t HuffDecoderCommon::table1_232_emit_[8] = {0x37, 0x30, 0x37, 0x31,
                                                        0x37, 0x32, 0x37, 0x61};
const uint8_t HuffDecoderCommon::table1_233_emit_[8] = {0x37, 0x63, 0x37, 0x65,
                                                        0x37, 0x69, 0x37, 0x6f};
const uint8_t HuffDecoderCommon::table1_234_emit_[12] = {
    0x37, 0x73, 0x37, 0x74, 0x37, 0x20, 0x37, 0x25, 0x37, 0x2d, 0x37, 0x2e};
const uint8_t HuffDecoderCommon::table1_235_emit_[15] = {
    0x37, 0x2f, 0x37, 0x33, 0x37, 0x34, 0x37, 0x35,
    0x37, 0x36, 0x37, 0x37, 0x38, 0x37, 0x39};
const uint16_t HuffDecoderCommon::table1_235_inner_[8] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x021c, 0x029c, 0x02dc, 0x035c};
const uint8_t HuffDecoderCommon::table1_236_emit_[16] = {
    0x37, 0x3d, 0x37, 0x41, 0x37, 0x5f, 0x37, 0x62,
    0x37, 0x64, 0x37, 0x66, 0x37, 0x67, 0x37, 0x68};
const uint8_t HuffDecoderCommon::table1_237_emit_[20] = {
    0x37, 0x6c, 0x37, 0x6d, 0x37, 0x6e, 0x37, 0x70, 0x37, 0x72,
    0x37, 0x75, 0x37, 0x3a, 0x37, 0x42, 0x37, 0x43, 0x37, 0x44};
const uint8_t HuffDecoderCommon::table1_238_emit_[32] = {
    0x37, 0x45, 0x37, 0x46, 0x37, 0x47, 0x37, 0x48, 0x37, 0x49, 0x37,
    0x4a, 0x37, 0x4b, 0x37, 0x4c, 0x37, 0x4d, 0x37, 0x4e, 0x37, 0x4f,
    0x37, 0x50, 0x37, 0x51, 0x37, 0x52, 0x37, 0x53, 0x37, 0x54};
const uint8_t HuffDecoderCommon::table1_239_emit_[36] = {
    0x37, 0x55, 0x37, 0x56, 0x37, 0x57, 0x37, 0x59, 0x37, 0x6a, 0x37, 0x6b,
    0x37, 0x71, 0x37, 0x76, 0x37, 0x77, 0x37, 0x78, 0x37, 0x79, 0x37, 0x7a,
    0x37, 0x26, 0x37, 0x2a, 0x37, 0x2c, 0x37, 0x3b, 0x37, 0x58, 0x37, 0x5a};
const uint8_t HuffDecoderCommon::table1_240_emit_[8] = {0x38, 0x30, 0x38, 0x31,
                                                        0x38, 0x32, 0x38, 0x61};
const uint8_t HuffDecoderCommon::table1_241_emit_[8] = {0x38, 0x63, 0x38, 0x65,
                                                        0x38, 0x69, 0x38, 0x6f};
const uint8_t HuffDecoderCommon::table1_242_emit_[12] = {
    0x38, 0x73, 0x38, 0x74, 0x38, 0x20, 0x38, 0x25, 0x38, 0x2d, 0x38, 0x2e};
const uint8_t HuffDecoderCommon::table1_243_emit_[15] = {
    0x38, 0x2f, 0x38, 0x33, 0x38, 0x34, 0x38, 0x35,
    0x38, 0x36, 0x38, 0x37, 0x38, 0x38, 0x39};
const uint16_t HuffDecoderCommon::table1_243_inner_[8] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x021c, 0x029c, 0x031c, 0x035c};
const uint8_t HuffDecoderCommon::table1_244_emit_[16] = {
    0x38, 0x3d, 0x38, 0x41, 0x38, 0x5f, 0x38, 0x62,
    0x38, 0x64, 0x38, 0x66, 0x38, 0x67, 0x38, 0x68};
const uint8_t HuffDecoderCommon::table1_245_emit_[20] = {
    0x38, 0x6c, 0x38, 0x6d, 0x38, 0x6e, 0x38, 0x70, 0x38, 0x72,
    0x38, 0x75, 0x38, 0x3a, 0x38, 0x42, 0x38, 0x43, 0x38, 0x44};
const uint8_t HuffDecoderCommon::table1_246_emit_[32] = {
    0x38, 0x45, 0x38, 0x46, 0x38, 0x47, 0x38, 0x48, 0x38, 0x49, 0x38,
    0x4a, 0x38, 0x4b, 0x38, 0x4c, 0x38, 0x4d, 0x38, 0x4e, 0x38, 0x4f,
    0x38, 0x50, 0x38, 0x51, 0x38, 0x52, 0x38, 0x53, 0x38, 0x54};
const uint8_t HuffDecoderCommon::table1_247_emit_[36] = {
    0x38, 0x55, 0x38, 0x56, 0x38, 0x57, 0x38, 0x59, 0x38, 0x6a, 0x38, 0x6b,
    0x38, 0x71, 0x38, 0x76, 0x38, 0x77, 0x38, 0x78, 0x38, 0x79, 0x38, 0x7a,
    0x38, 0x26, 0x38, 0x2a, 0x38, 0x2c, 0x38, 0x3b, 0x38, 0x58, 0x38, 0x5a};
const uint8_t HuffDecoderCommon::table1_248_emit_[8] = {0x39, 0x30, 0x39, 0x31,
                                                        0x39, 0x32, 0x39, 0x61};
const uint8_t HuffDecoderCommon::table1_249_emit_[8] = {0x39, 0x63, 0x39, 0x65,
                                                        0x39, 0x69, 0x39, 0x6f};
const uint8_t HuffDecoderCommon::table1_250_emit_[12] = {
    0x39, 0x73, 0x39, 0x74, 0x39, 0x20, 0x39, 0x25, 0x39, 0x2d, 0x39, 0x2e};
const uint8_t HuffDecoderCommon::table1_251_emit_[16] = {
    0x39, 0x2f, 0x39, 0x33, 0x39, 0x34, 0x39, 0x35,
    0x39, 0x36, 0x39, 0x37, 0x39, 0x38, 0x39, 0x39};
const uint8_t HuffDecoderCommon::table1_252_emit_[16] = {
    0x39, 0x3d, 0x39, 0x41, 0x39, 0x5f, 0x39, 0x62,
    0x39, 0x64, 0x39, 0x66, 0x39, 0x67, 0x39, 0x68};
const uint8_t HuffDecoderCommon::table1_253_emit_[20] = {
    0x39, 0x6c, 0x39, 0x6d, 0x39, 0x6e, 0x39, 0x70, 0x39, 0x72,
    0x39, 0x75, 0x39, 0x3a, 0x39, 0x42, 0x39, 0x43, 0x39, 0x44};
const uint8_t HuffDecoderCommon::table1_254_emit_[32] = {
    0x39, 0x45, 0x39, 0x46, 0x39, 0x47, 0x39, 0x48, 0x39, 0x49, 0x39,
    0x4a, 0x39, 0x4b, 0x39, 0x4c, 0x39, 0x4d, 0x39, 0x4e, 0x39, 0x4f,
    0x39, 0x50, 0x39, 0x51, 0x39, 0x52, 0x39, 0x53, 0x39, 0x54};
const uint8_t HuffDecoderCommon::table1_255_emit_[36] = {
    0x39, 0x55, 0x39, 0x56, 0x39, 0x57, 0x39, 0x59, 0x39, 0x6a, 0x39, 0x6b,
    0x39, 0x71, 0x39, 0x76, 0x39, 0x77, 0x39, 0x78, 0x39, 0x79, 0x39, 0x7a,
    0x39, 0x26, 0x39, 0x2a, 0x39, 0x2c, 0x39, 0x3b, 0x39, 0x58, 0x39, 0x5a};
const uint8_t HuffDecoderCommon::table1_256_emit_[8] = {0x3d, 0x30, 0x3d, 0x31,
                                                        0x3d, 0x32, 0x3d, 0x61};
const uint8_t HuffDecoderCommon::table1_257_emit_[8] = {0x3d, 0x63, 0x3d, 0x65,
                                                        0x3d, 0x69, 0x3d, 0x6f};
const uint8_t HuffDecoderCommon::table1_258_emit_[12] = {
    0x3d, 0x73, 0x3d, 0x74, 0x3d, 0x20, 0x3d, 0x25, 0x3d, 0x2d, 0x3d, 0x2e};
const uint8_t HuffDecoderCommon::table1_259_emit_[16] = {
    0x3d, 0x2f, 0x3d, 0x33, 0x3d, 0x34, 0x3d, 0x35,
    0x3d, 0x36, 0x3d, 0x37, 0x3d, 0x38, 0x3d, 0x39};
const uint8_t HuffDecoderCommon::table1_260_emit_[15] = {
    0x3d, 0x3d, 0x41, 0x3d, 0x5f, 0x3d, 0x62, 0x3d,
    0x64, 0x3d, 0x66, 0x3d, 0x67, 0x3d, 0x68};
const uint8_t HuffDecoderCommon::table1_261_emit_[20] = {
    0x3d, 0x6c, 0x3d, 0x6d, 0x3d, 0x6e, 0x3d, 0x70, 0x3d, 0x72,
    0x3d, 0x75, 0x3d, 0x3a, 0x3d, 0x42, 0x3d, 0x43, 0x3d, 0x44};
const uint8_t HuffDecoderCommon::table1_262_emit_[32] = {
    0x3d, 0x45, 0x3d, 0x46, 0x3d, 0x47, 0x3d, 0x48, 0x3d, 0x49, 0x3d,
    0x4a, 0x3d, 0x4b, 0x3d, 0x4c, 0x3d, 0x4d, 0x3d, 0x4e, 0x3d, 0x4f,
    0x3d, 0x50, 0x3d, 0x51, 0x3d, 0x52, 0x3d, 0x53, 0x3d, 0x54};
const uint8_t HuffDecoderCommon::table1_263_emit_[36] = {
    0x3d, 0x55, 0x3d, 0x56, 0x3d, 0x57, 0x3d, 0x59, 0x3d, 0x6a, 0x3d, 0x6b,
    0x3d, 0x71, 0x3d, 0x76, 0x3d, 0x77, 0x3d, 0x78, 0x3d, 0x79, 0x3d, 0x7a,
    0x3d, 0x26, 0x3d, 0x2a, 0x3d, 0x2c, 0x3d, 0x3b, 0x3d, 0x58, 0x3d, 0x5a};
const uint8_t HuffDecoderCommon::table1_264_emit_[8] = {0x41, 0x30, 0x41, 0x31,
                                                        0x41, 0x32, 0x41, 0x61};
const uint8_t HuffDecoderCommon::table1_265_emit_[8] = {0x41, 0x63, 0x41, 0x65,
                                                        0x41, 0x69, 0x41, 0x6f};
const uint8_t HuffDecoderCommon::table1_266_emit_[12] = {
    0x41, 0x73, 0x41, 0x74, 0x41, 0x20, 0x41, 0x25, 0x41, 0x2d, 0x41, 0x2e};
const uint8_t HuffDecoderCommon::table1_267_emit_[16] = {
    0x41, 0x2f, 0x41, 0x33, 0x41, 0x34, 0x41, 0x35,
    0x41, 0x36, 0x41, 0x37, 0x41, 0x38, 0x41, 0x39};
const uint8_t HuffDecoderCommon::table1_268_emit_[15] = {
    0x41, 0x3d, 0x41, 0x41, 0x5f, 0x41, 0x62, 0x41,
    0x64, 0x41, 0x66, 0x41, 0x67, 0x41, 0x68};
const uint8_t HuffDecoderCommon::table1_269_emit_[20] = {
    0x41, 0x6c, 0x41, 0x6d, 0x41, 0x6e, 0x41, 0x70, 0x41, 0x72,
    0x41, 0x75, 0x41, 0x3a, 0x41, 0x42, 0x41, 0x43, 0x41, 0x44};
const uint8_t HuffDecoderCommon::table1_270_emit_[32] = {
    0x41, 0x45, 0x41, 0x46, 0x41, 0x47, 0x41, 0x48, 0x41, 0x49, 0x41,
    0x4a, 0x41, 0x4b, 0x41, 0x4c, 0x41, 0x4d, 0x41, 0x4e, 0x41, 0x4f,
    0x41, 0x50, 0x41, 0x51, 0x41, 0x52, 0x41, 0x53, 0x41, 0x54};
const uint8_t HuffDecoderCommon::table1_271_emit_[36] = {
    0x41, 0x55, 0x41, 0x56, 0x41, 0x57, 0x41, 0x59, 0x41, 0x6a, 0x41, 0x6b,
    0x41, 0x71, 0x41, 0x76, 0x41, 0x77, 0x41, 0x78, 0x41, 0x79, 0x41, 0x7a,
    0x41, 0x26, 0x41, 0x2a, 0x41, 0x2c, 0x41, 0x3b, 0x41, 0x58, 0x41, 0x5a};
const uint8_t HuffDecoderCommon::table1_272_emit_[8] = {0x5f, 0x30, 0x5f, 0x31,
                                                        0x5f, 0x32, 0x5f, 0x61};
const uint8_t HuffDecoderCommon::table1_273_emit_[8] = {0x5f, 0x63, 0x5f, 0x65,
                                                        0x5f, 0x69, 0x5f, 0x6f};
const uint8_t HuffDecoderCommon::table1_274_emit_[12] = {
    0x5f, 0x73, 0x5f, 0x74, 0x5f, 0x20, 0x5f, 0x25, 0x5f, 0x2d, 0x5f, 0x2e};
const uint8_t HuffDecoderCommon::table1_275_emit_[16] = {
    0x5f, 0x2f, 0x5f, 0x33, 0x5f, 0x34, 0x5f, 0x35,
    0x5f, 0x36, 0x5f, 0x37, 0x5f, 0x38, 0x5f, 0x39};
const uint8_t HuffDecoderCommon::table1_276_emit_[15] = {
    0x5f, 0x3d, 0x5f, 0x41, 0x5f, 0x5f, 0x62, 0x5f,
    0x64, 0x5f, 0x66, 0x5f, 0x67, 0x5f, 0x68};
const uint8_t HuffDecoderCommon::table1_277_emit_[20] = {
    0x5f, 0x6c, 0x5f, 0x6d, 0x5f, 0x6e, 0x5f, 0x70, 0x5f, 0x72,
    0x5f, 0x75, 0x5f, 0x3a, 0x5f, 0x42, 0x5f, 0x43, 0x5f, 0x44};
const uint8_t HuffDecoderCommon::table1_278_emit_[32] = {
    0x5f, 0x45, 0x5f, 0x46, 0x5f, 0x47, 0x5f, 0x48, 0x5f, 0x49, 0x5f,
    0x4a, 0x5f, 0x4b, 0x5f, 0x4c, 0x5f, 0x4d, 0x5f, 0x4e, 0x5f, 0x4f,
    0x5f, 0x50, 0x5f, 0x51, 0x5f, 0x52, 0x5f, 0x53, 0x5f, 0x54};
const uint8_t HuffDecoderCommon::table1_279_emit_[36] = {
    0x5f, 0x55, 0x5f, 0x56, 0x5f, 0x57, 0x5f, 0x59, 0x5f, 0x6a, 0x5f, 0x6b,
    0x5f, 0x71, 0x5f, 0x76, 0x5f, 0x77, 0x5f, 0x78, 0x5f, 0x79, 0x5f, 0x7a,
    0x5f, 0x26, 0x5f, 0x2a, 0x5f, 0x2c, 0x5f, 0x3b, 0x5f, 0x58, 0x5f, 0x5a};
const uint8_t HuffDecoderCommon::table1_280_emit_[8] = {0x62, 0x30, 0x62, 0x31,
                                                        0x62, 0x32, 0x62, 0x61};
const uint8_t HuffDecoderCommon::table1_281_emit_[8] = {0x62, 0x63, 0x62, 0x65,
                                                        0x62, 0x69, 0x62, 0x6f};
const uint8_t HuffDecoderCommon::table1_282_emit_[12] = {
    0x62, 0x73, 0x62, 0x74, 0x62, 0x20, 0x62, 0x25, 0x62, 0x2d, 0x62, 0x2e};
const uint8_t HuffDecoderCommon::table1_283_emit_[16] = {
    0x62, 0x2f, 0x62, 0x33, 0x62, 0x34, 0x62, 0x35,
    0x62, 0x36, 0x62, 0x37, 0x62, 0x38, 0x62, 0x39};
const uint8_t HuffDecoderCommon::table1_284_emit_[15] = {
    0x62, 0x3d, 0x62, 0x41, 0x62, 0x5f, 0x62, 0x62,
    0x64, 0x62, 0x66, 0x62, 0x67, 0x62, 0x68};
const uint8_t HuffDecoderCommon::table1_285_emit_[20] = {
    0x62, 0x6c, 0x62, 0x6d, 0x62, 0x6e, 0x62, 0x70, 0x62, 0x72,
    0x62, 0x75, 0x62, 0x3a, 0x62, 0x42, 0x62, 0x43, 0x62, 0x44};
const uint8_t HuffDecoderCommon::table1_286_emit_[32] = {
    0x62, 0x45, 0x62, 0x46, 0x62, 0x47, 0x62, 0x48, 0x62, 0x49, 0x62,
    0x4a, 0x62, 0x4b, 0x62, 0x4c, 0x62, 0x4d, 0x62, 0x4e, 0x62, 0x4f,
    0x62, 0x50, 0x62, 0x51, 0x62, 0x52, 0x62, 0x53, 0x62, 0x54};
const uint8_t HuffDecoderCommon::table1_287_emit_[36] = {
    0x62, 0x55, 0x62, 0x56, 0x62, 0x57, 0x62, 0x59, 0x62, 0x6a, 0x62, 0x6b,
    0x62, 0x71, 0x62, 0x76, 0x62, 0x77, 0x62, 0x78, 0x62, 0x79, 0x62, 0x7a,
    0x62, 0x26, 0x62, 0x2a, 0x62, 0x2c, 0x62, 0x3b, 0x62, 0x58, 0x62, 0x5a};
const uint8_t HuffDecoderCommon::table1_288_emit_[8] = {0x64, 0x30, 0x64, 0x31,
                                                        0x64, 0x32, 0x64, 0x61};
const uint8_t HuffDecoderCommon::table1_289_emit_[8] = {0x64, 0x63, 0x64, 0x65,
                                                        0x64, 0x69, 0x64, 0x6f};
const uint8_t HuffDecoderCommon::table1_290_emit_[12] = {
    0x64, 0x73, 0x64, 0x74, 0x64, 0x20, 0x64, 0x25, 0x64, 0x2d, 0x64, 0x2e};
const uint8_t HuffDecoderCommon::table1_291_emit_[16] = {
    0x64, 0x2f, 0x64, 0x33, 0x64, 0x34, 0x64, 0x35,
    0x64, 0x36, 0x64, 0x37, 0x64, 0x38, 0x64, 0x39};
const uint8_t HuffDecoderCommon::table1_292_emit_[15] = {
    0x64, 0x3d, 0x64, 0x41, 0x64, 0x5f, 0x64, 0x62,
    0x64, 0x64, 0x66, 0x64, 0x67, 0x64, 0x68};
const uint8_t HuffDecoderCommon::table1_293_emit_[20] = {
    0x64, 0x6c, 0x64, 0x6d, 0x64, 0x6e, 0x64, 0x70, 0x64, 0x72,
    0x64, 0x75, 0x64, 0x3a, 0x64, 0x42, 0x64, 0x43, 0x64, 0x44};
const uint8_t HuffDecoderCommon::table1_294_emit_[32] = {
    0x64, 0x45, 0x64, 0x46, 0x64, 0x47, 0x64, 0x48, 0x64, 0x49, 0x64,
    0x4a, 0x64, 0x4b, 0x64, 0x4c, 0x64, 0x4d, 0x64, 0x4e, 0x64, 0x4f,
    0x64, 0x50, 0x64, 0x51, 0x64, 0x52, 0x64, 0x53, 0x64, 0x54};
const uint8_t HuffDecoderCommon::table1_295_emit_[36] = {
    0x64, 0x55, 0x64, 0x56, 0x64, 0x57, 0x64, 0x59, 0x64, 0x6a, 0x64, 0x6b,
    0x64, 0x71, 0x64, 0x76, 0x64, 0x77, 0x64, 0x78, 0x64, 0x79, 0x64, 0x7a,
    0x64, 0x26, 0x64, 0x2a, 0x64, 0x2c, 0x64, 0x3b, 0x64, 0x58, 0x64, 0x5a};
const uint8_t HuffDecoderCommon::table1_296_emit_[8] = {0x66, 0x30, 0x66, 0x31,
                                                        0x66, 0x32, 0x66, 0x61};
const uint8_t HuffDecoderCommon::table1_297_emit_[8] = {0x66, 0x63, 0x66, 0x65,
                                                        0x66, 0x69, 0x66, 0x6f};
const uint8_t HuffDecoderCommon::table1_298_emit_[12] = {
    0x66, 0x73, 0x66, 0x74, 0x66, 0x20, 0x66, 0x25, 0x66, 0x2d, 0x66, 0x2e};
const uint8_t HuffDecoderCommon::table1_299_emit_[16] = {
    0x66, 0x2f, 0x66, 0x33, 0x66, 0x34, 0x66, 0x35,
    0x66, 0x36, 0x66, 0x37, 0x66, 0x38, 0x66, 0x39};
const uint8_t HuffDecoderCommon::table1_300_emit_[15] = {
    0x66, 0x3d, 0x66, 0x41, 0x66, 0x5f, 0x66, 0x62,
    0x66, 0x64, 0x66, 0x66, 0x67, 0x66, 0x68};
const uint8_t HuffDecoderCommon::table1_301_emit_[20] = {
    0x66, 0x6c, 0x66, 0x6d, 0x66, 0x6e, 0x66, 0x70, 0x66, 0x72,
    0x66, 0x75, 0x66, 0x3a, 0x66, 0x42, 0x66, 0x43, 0x66, 0x44};
const uint8_t HuffDecoderCommon::table1_302_emit_[32] = {
    0x66, 0x45, 0x66, 0x46, 0x66, 0x47, 0x66, 0x48, 0x66, 0x49, 0x66,
    0x4a, 0x66, 0x4b, 0x66, 0x4c, 0x66, 0x4d, 0x66, 0x4e, 0x66, 0x4f,
    0x66, 0x50, 0x66, 0x51, 0x66, 0x52, 0x66, 0x53, 0x66, 0x54};
const uint8_t HuffDecoderCommon::table1_303_emit_[36] = {
    0x66, 0x55, 0x66, 0x56, 0x66, 0x57, 0x66, 0x59, 0x66, 0x6a, 0x66, 0x6b,
    0x66, 0x71, 0x66, 0x76, 0x66, 0x77, 0x66, 0x78, 0x66, 0x79, 0x66, 0x7a,
    0x66, 0x26, 0x66, 0x2a, 0x66, 0x2c, 0x66, 0x3b, 0x66, 0x58, 0x66, 0x5a};
const uint8_t HuffDecoderCommon::table1_304_emit_[8] = {0x67, 0x30, 0x67, 0x31,
                                                        0x67, 0x32, 0x67, 0x61};
const uint8_t HuffDecoderCommon::table1_305_emit_[8] = {0x67, 0x63, 0x67, 0x65,
                                                        0x67, 0x69, 0x67, 0x6f};
const uint8_t HuffDecoderCommon::table1_306_emit_[12] = {
    0x67, 0x73, 0x67, 0x74, 0x67, 0x20, 0x67, 0x25, 0x67, 0x2d, 0x67, 0x2e};
const uint8_t HuffDecoderCommon::table1_307_emit_[16] = {
    0x67, 0x2f, 0x67, 0x33, 0x67, 0x34, 0x67, 0x35,
    0x67, 0x36, 0x67, 0x37, 0x67, 0x38, 0x67, 0x39};
const uint8_t HuffDecoderCommon::table1_308_emit_[15] = {
    0x67, 0x3d, 0x67, 0x41, 0x67, 0x5f, 0x67, 0x62,
    0x67, 0x64, 0x67, 0x66, 0x67, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table1_309_emit_[20] = {
    0x67, 0x6c, 0x67, 0x6d, 0x67, 0x6e, 0x67, 0x70, 0x67, 0x72,
    0x67, 0x75, 0x67, 0x3a, 0x67, 0x42, 0x67, 0x43, 0x67, 0x44};
const uint8_t HuffDecoderCommon::table1_310_emit_[32] = {
    0x67, 0x45, 0x67, 0x46, 0x67, 0x47, 0x67, 0x48, 0x67, 0x49, 0x67,
    0x4a, 0x67, 0x4b, 0x67, 0x4c, 0x67, 0x4d, 0x67, 0x4e, 0x67, 0x4f,
    0x67, 0x50, 0x67, 0x51, 0x67, 0x52, 0x67, 0x53, 0x67, 0x54};
const uint8_t HuffDecoderCommon::table1_311_emit_[36] = {
    0x67, 0x55, 0x67, 0x56, 0x67, 0x57, 0x67, 0x59, 0x67, 0x6a, 0x67, 0x6b,
    0x67, 0x71, 0x67, 0x76, 0x67, 0x77, 0x67, 0x78, 0x67, 0x79, 0x67, 0x7a,
    0x67, 0x26, 0x67, 0x2a, 0x67, 0x2c, 0x67, 0x3b, 0x67, 0x58, 0x67, 0x5a};
const uint8_t HuffDecoderCommon::table1_312_emit_[8] = {0x68, 0x30, 0x68, 0x31,
                                                        0x68, 0x32, 0x68, 0x61};
const uint8_t HuffDecoderCommon::table1_313_emit_[8] = {0x68, 0x63, 0x68, 0x65,
                                                        0x68, 0x69, 0x68, 0x6f};
const uint8_t HuffDecoderCommon::table1_314_emit_[12] = {
    0x68, 0x73, 0x68, 0x74, 0x68, 0x20, 0x68, 0x25, 0x68, 0x2d, 0x68, 0x2e};
const uint8_t HuffDecoderCommon::table1_315_emit_[16] = {
    0x68, 0x2f, 0x68, 0x33, 0x68, 0x34, 0x68, 0x35,
    0x68, 0x36, 0x68, 0x37, 0x68, 0x38, 0x68, 0x39};
const uint8_t HuffDecoderCommon::table1_316_emit_[16] = {
    0x68, 0x3d, 0x68, 0x41, 0x68, 0x5f, 0x68, 0x62,
    0x68, 0x64, 0x68, 0x66, 0x68, 0x67, 0x68, 0x68};
const uint8_t HuffDecoderCommon::table1_317_emit_[20] = {
    0x68, 0x6c, 0x68, 0x6d, 0x68, 0x6e, 0x68, 0x70, 0x68, 0x72,
    0x68, 0x75, 0x68, 0x3a, 0x68, 0x42, 0x68, 0x43, 0x68, 0x44};
const uint8_t HuffDecoderCommon::table1_318_emit_[32] = {
    0x68, 0x45, 0x68, 0x46, 0x68, 0x47, 0x68, 0x48, 0x68, 0x49, 0x68,
    0x4a, 0x68, 0x4b, 0x68, 0x4c, 0x68, 0x4d, 0x68, 0x4e, 0x68, 0x4f,
    0x68, 0x50, 0x68, 0x51, 0x68, 0x52, 0x68, 0x53, 0x68, 0x54};
const uint8_t HuffDecoderCommon::table1_319_emit_[36] = {
    0x68, 0x55, 0x68, 0x56, 0x68, 0x57, 0x68, 0x59, 0x68, 0x6a, 0x68, 0x6b,
    0x68, 0x71, 0x68, 0x76, 0x68, 0x77, 0x68, 0x78, 0x68, 0x79, 0x68, 0x7a,
    0x68, 0x26, 0x68, 0x2a, 0x68, 0x2c, 0x68, 0x3b, 0x68, 0x58, 0x68, 0x5a};
const uint8_t HuffDecoderCommon::table1_320_emit_[8] = {0x6c, 0x30, 0x6c, 0x31,
                                                        0x6c, 0x32, 0x6c, 0x61};
const uint8_t HuffDecoderCommon::table1_321_emit_[8] = {0x6c, 0x63, 0x6c, 0x65,
                                                        0x6c, 0x69, 0x6c, 0x6f};
const uint8_t HuffDecoderCommon::table1_322_emit_[12] = {
    0x6c, 0x73, 0x6c, 0x74, 0x6c, 0x20, 0x6c, 0x25, 0x6c, 0x2d, 0x6c, 0x2e};
const uint8_t HuffDecoderCommon::table1_323_emit_[16] = {
    0x6c, 0x2f, 0x6c, 0x33, 0x6c, 0x34, 0x6c, 0x35,
    0x6c, 0x36, 0x6c, 0x37, 0x6c, 0x38, 0x6c, 0x39};
const uint8_t HuffDecoderCommon::table1_324_emit_[16] = {
    0x6c, 0x3d, 0x6c, 0x41, 0x6c, 0x5f, 0x6c, 0x62,
    0x6c, 0x64, 0x6c, 0x66, 0x6c, 0x67, 0x6c, 0x68};
const uint8_t HuffDecoderCommon::table1_325_emit_[19] = {
    0x6c, 0x6c, 0x6d, 0x6c, 0x6e, 0x6c, 0x70, 0x6c, 0x72, 0x6c,
    0x75, 0x6c, 0x3a, 0x6c, 0x42, 0x6c, 0x43, 0x6c, 0x44};
const uint16_t HuffDecoderCommon::table1_325_inner_[10] = {
    0x001c, 0x005c, 0x00dc, 0x015c, 0x01dc,
    0x025c, 0x02dd, 0x035d, 0x03dd, 0x045d};
const uint8_t HuffDecoderCommon::table1_326_emit_[32] = {
    0x6c, 0x45, 0x6c, 0x46, 0x6c, 0x47, 0x6c, 0x48, 0x6c, 0x49, 0x6c,
    0x4a, 0x6c, 0x4b, 0x6c, 0x4c, 0x6c, 0x4d, 0x6c, 0x4e, 0x6c, 0x4f,
    0x6c, 0x50, 0x6c, 0x51, 0x6c, 0x52, 0x6c, 0x53, 0x6c, 0x54};
const uint8_t HuffDecoderCommon::table1_327_emit_[36] = {
    0x6c, 0x55, 0x6c, 0x56, 0x6c, 0x57, 0x6c, 0x59, 0x6c, 0x6a, 0x6c, 0x6b,
    0x6c, 0x71, 0x6c, 0x76, 0x6c, 0x77, 0x6c, 0x78, 0x6c, 0x79, 0x6c, 0x7a,
    0x6c, 0x26, 0x6c, 0x2a, 0x6c, 0x2c, 0x6c, 0x3b, 0x6c, 0x58, 0x6c, 0x5a};
const uint8_t HuffDecoderCommon::table1_328_emit_[8] = {0x6d, 0x30, 0x6d, 0x31,
                                                        0x6d, 0x32, 0x6d, 0x61};
const uint8_t HuffDecoderCommon::table1_329_emit_[8] = {0x6d, 0x63, 0x6d, 0x65,
                                                        0x6d, 0x69, 0x6d, 0x6f};
const uint8_t HuffDecoderCommon::table1_330_emit_[12] = {
    0x6d, 0x73, 0x6d, 0x74, 0x6d, 0x20, 0x6d, 0x25, 0x6d, 0x2d, 0x6d, 0x2e};
const uint8_t HuffDecoderCommon::table1_331_emit_[16] = {
    0x6d, 0x2f, 0x6d, 0x33, 0x6d, 0x34, 0x6d, 0x35,
    0x6d, 0x36, 0x6d, 0x37, 0x6d, 0x38, 0x6d, 0x39};
const uint8_t HuffDecoderCommon::table1_332_emit_[16] = {
    0x6d, 0x3d, 0x6d, 0x41, 0x6d, 0x5f, 0x6d, 0x62,
    0x6d, 0x64, 0x6d, 0x66, 0x6d, 0x67, 0x6d, 0x68};
const uint8_t HuffDecoderCommon::table1_333_emit_[19] = {
    0x6d, 0x6c, 0x6d, 0x6d, 0x6e, 0x6d, 0x70, 0x6d, 0x72, 0x6d,
    0x75, 0x6d, 0x3a, 0x6d, 0x42, 0x6d, 0x43, 0x6d, 0x44};
const uint16_t HuffDecoderCommon::table1_333_inner_[10] = {
    0x001c, 0x009c, 0x00dc, 0x015c, 0x01dc,
    0x025c, 0x02dd, 0x035d, 0x03dd, 0x045d};
const uint8_t HuffDecoderCommon::table1_334_emit_[32] = {
    0x6d, 0x45, 0x6d, 0x46, 0x6d, 0x47, 0x6d, 0x48, 0x6d, 0x49, 0x6d,
    0x4a, 0x6d, 0x4b, 0x6d, 0x4c, 0x6d, 0x4d, 0x6d, 0x4e, 0x6d, 0x4f,
    0x6d, 0x50, 0x6d, 0x51, 0x6d, 0x52, 0x6d, 0x53, 0x6d, 0x54};
const uint8_t HuffDecoderCommon::table1_335_emit_[36] = {
    0x6d, 0x55, 0x6d, 0x56, 0x6d, 0x57, 0x6d, 0x59, 0x6d, 0x6a, 0x6d, 0x6b,
    0x6d, 0x71, 0x6d, 0x76, 0x6d, 0x77, 0x6d, 0x78, 0x6d, 0x79, 0x6d, 0x7a,
    0x6d, 0x26, 0x6d, 0x2a, 0x6d, 0x2c, 0x6d, 0x3b, 0x6d, 0x58, 0x6d, 0x5a};
const uint8_t HuffDecoderCommon::table1_336_emit_[8] = {0x6e, 0x30, 0x6e, 0x31,
                                                        0x6e, 0x32, 0x6e, 0x61};
const uint8_t HuffDecoderCommon::table1_337_emit_[8] = {0x6e, 0x63, 0x6e, 0x65,
                                                        0x6e, 0x69, 0x6e, 0x6f};
const uint8_t HuffDecoderCommon::table1_338_emit_[12] = {
    0x6e, 0x73, 0x6e, 0x74, 0x6e, 0x20, 0x6e, 0x25, 0x6e, 0x2d, 0x6e, 0x2e};
const uint8_t HuffDecoderCommon::table1_339_emit_[16] = {
    0x6e, 0x2f, 0x6e, 0x33, 0x6e, 0x34, 0x6e, 0x35,
    0x6e, 0x36, 0x6e, 0x37, 0x6e, 0x38, 0x6e, 0x39};
const uint8_t HuffDecoderCommon::table1_340_emit_[16] = {
    0x6e, 0x3d, 0x6e, 0x41, 0x6e, 0x5f, 0x6e, 0x62,
    0x6e, 0x64, 0x6e, 0x66, 0x6e, 0x67, 0x6e, 0x68};
const uint8_t HuffDecoderCommon::table1_341_emit_[19] = {
    0x6e, 0x6c, 0x6e, 0x6d, 0x6e, 0x6e, 0x70, 0x6e, 0x72, 0x6e,
    0x75, 0x6e, 0x3a, 0x6e, 0x42, 0x6e, 0x43, 0x6e, 0x44};
const uint16_t HuffDecoderCommon::table1_341_inner_[10] = {
    0x001c, 0x009c, 0x011c, 0x015c, 0x01dc,
    0x025c, 0x02dd, 0x035d, 0x03dd, 0x045d};
const uint8_t HuffDecoderCommon::table1_342_emit_[32] = {
    0x6e, 0x45, 0x6e, 0x46, 0x6e, 0x47, 0x6e, 0x48, 0x6e, 0x49, 0x6e,
    0x4a, 0x6e, 0x4b, 0x6e, 0x4c, 0x6e, 0x4d, 0x6e, 0x4e, 0x6e, 0x4f,
    0x6e, 0x50, 0x6e, 0x51, 0x6e, 0x52, 0x6e, 0x53, 0x6e, 0x54};
const uint8_t HuffDecoderCommon::table1_343_emit_[36] = {
    0x6e, 0x55, 0x6e, 0x56, 0x6e, 0x57, 0x6e, 0x59, 0x6e, 0x6a, 0x6e, 0x6b,
    0x6e, 0x71, 0x6e, 0x76, 0x6e, 0x77, 0x6e, 0x78, 0x6e, 0x79, 0x6e, 0x7a,
    0x6e, 0x26, 0x6e, 0x2a, 0x6e, 0x2c, 0x6e, 0x3b, 0x6e, 0x58, 0x6e, 0x5a};
const uint8_t HuffDecoderCommon::table1_344_emit_[8] = {0x70, 0x30, 0x70, 0x31,
                                                        0x70, 0x32, 0x70, 0x61};
const uint8_t HuffDecoderCommon::table1_345_emit_[8] = {0x70, 0x63, 0x70, 0x65,
                                                        0x70, 0x69, 0x70, 0x6f};
const uint8_t HuffDecoderCommon::table1_346_emit_[12] = {
    0x70, 0x73, 0x70, 0x74, 0x70, 0x20, 0x70, 0x25, 0x70, 0x2d, 0x70, 0x2e};
const uint8_t HuffDecoderCommon::table1_347_emit_[16] = {
    0x70, 0x2f, 0x70, 0x33, 0x70, 0x34, 0x70, 0x35,
    0x70, 0x36, 0x70, 0x37, 0x70, 0x38, 0x70, 0x39};
const uint8_t HuffDecoderCommon::table1_348_emit_[16] = {
    0x70, 0x3d, 0x70, 0x41, 0x70, 0x5f, 0x70, 0x62,
    0x70, 0x64, 0x70, 0x66, 0x70, 0x67, 0x70, 0x68};
const uint8_t HuffDecoderCommon::table1_349_emit_[19] = {
    0x70, 0x6c, 0x70, 0x6d, 0x70, 0x6e, 0x70, 0x70, 0x72, 0x70,
    0x75, 0x70, 0x3a, 0x70, 0x42, 0x70, 0x43, 0x70, 0x44};
const uint16_t HuffDecoderCommon::table1_349_inner_[10] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x01dc,
    0x025c, 0x02dd, 0x035d, 0x03dd, 0x045d};
const uint8_t HuffDecoderCommon::table1_350_emit_[32] = {
    0x70, 0x45, 0x70, 0x46, 0x70, 0x47, 0x70, 0x48, 0x70, 0x49, 0x70,
    0x4a, 0x70, 0x4b, 0x70, 0x4c, 0x70, 0x4d, 0x70, 0x4e, 0x70, 0x4f,
    0x70, 0x50, 0x70, 0x51, 0x70, 0x52, 0x70, 0x53, 0x70, 0x54};
const uint8_t HuffDecoderCommon::table1_351_emit_[36] = {
    0x70, 0x55, 0x70, 0x56, 0x70, 0x57, 0x70, 0x59, 0x70, 0x6a, 0x70, 0x6b,
    0x70, 0x71, 0x70, 0x76, 0x70, 0x77, 0x70, 0x78, 0x70, 0x79, 0x70, 0x7a,
    0x70, 0x26, 0x70, 0x2a, 0x70, 0x2c, 0x70, 0x3b, 0x70, 0x58, 0x70, 0x5a};
const uint8_t HuffDecoderCommon::table1_352_emit_[8] = {0x72, 0x30, 0x72, 0x31,
                                                        0x72, 0x32, 0x72, 0x61};
const uint8_t HuffDecoderCommon::table1_353_emit_[8] = {0x72, 0x63, 0x72, 0x65,
                                                        0x72, 0x69, 0x72, 0x6f};
const uint8_t HuffDecoderCommon::table1_354_emit_[12] = {
    0x72, 0x73, 0x72, 0x74, 0x72, 0x20, 0x72, 0x25, 0x72, 0x2d, 0x72, 0x2e};
const uint8_t HuffDecoderCommon::table1_355_emit_[16] = {
    0x72, 0x2f, 0x72, 0x33, 0x72, 0x34, 0x72, 0x35,
    0x72, 0x36, 0x72, 0x37, 0x72, 0x38, 0x72, 0x39};
const uint8_t HuffDecoderCommon::table1_356_emit_[16] = {
    0x72, 0x3d, 0x72, 0x41, 0x72, 0x5f, 0x72, 0x62,
    0x72, 0x64, 0x72, 0x66, 0x72, 0x67, 0x72, 0x68};
const uint8_t HuffDecoderCommon::table1_357_emit_[19] = {
    0x72, 0x6c, 0x72, 0x6d, 0x72, 0x6e, 0x72, 0x70, 0x72, 0x72,
    0x75, 0x72, 0x3a, 0x72, 0x42, 0x72, 0x43, 0x72, 0x44};
const uint16_t HuffDecoderCommon::table1_357_inner_[10] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x021c,
    0x025c, 0x02dd, 0x035d, 0x03dd, 0x045d};
const uint8_t HuffDecoderCommon::table1_358_emit_[32] = {
    0x72, 0x45, 0x72, 0x46, 0x72, 0x47, 0x72, 0x48, 0x72, 0x49, 0x72,
    0x4a, 0x72, 0x4b, 0x72, 0x4c, 0x72, 0x4d, 0x72, 0x4e, 0x72, 0x4f,
    0x72, 0x50, 0x72, 0x51, 0x72, 0x52, 0x72, 0x53, 0x72, 0x54};
const uint8_t HuffDecoderCommon::table1_359_emit_[36] = {
    0x72, 0x55, 0x72, 0x56, 0x72, 0x57, 0x72, 0x59, 0x72, 0x6a, 0x72, 0x6b,
    0x72, 0x71, 0x72, 0x76, 0x72, 0x77, 0x72, 0x78, 0x72, 0x79, 0x72, 0x7a,
    0x72, 0x26, 0x72, 0x2a, 0x72, 0x2c, 0x72, 0x3b, 0x72, 0x58, 0x72, 0x5a};
const uint8_t HuffDecoderCommon::table1_360_emit_[8] = {0x75, 0x30, 0x75, 0x31,
                                                        0x75, 0x32, 0x75, 0x61};
const uint8_t HuffDecoderCommon::table1_361_emit_[8] = {0x75, 0x63, 0x75, 0x65,
                                                        0x75, 0x69, 0x75, 0x6f};
const uint8_t HuffDecoderCommon::table1_362_emit_[12] = {
    0x75, 0x73, 0x75, 0x74, 0x75, 0x20, 0x75, 0x25, 0x75, 0x2d, 0x75, 0x2e};
const uint8_t HuffDecoderCommon::table1_363_emit_[16] = {
    0x75, 0x2f, 0x75, 0x33, 0x75, 0x34, 0x75, 0x35,
    0x75, 0x36, 0x75, 0x37, 0x75, 0x38, 0x75, 0x39};
const uint8_t HuffDecoderCommon::table1_364_emit_[16] = {
    0x75, 0x3d, 0x75, 0x41, 0x75, 0x5f, 0x75, 0x62,
    0x75, 0x64, 0x75, 0x66, 0x75, 0x67, 0x75, 0x68};
const uint8_t HuffDecoderCommon::table1_365_emit_[19] = {
    0x75, 0x6c, 0x75, 0x6d, 0x75, 0x6e, 0x75, 0x70, 0x75, 0x72,
    0x75, 0x75, 0x3a, 0x75, 0x42, 0x75, 0x43, 0x75, 0x44};
const uint16_t HuffDecoderCommon::table1_365_inner_[10] = {
    0x001c, 0x009c, 0x011c, 0x019c, 0x021c,
    0x029c, 0x02dd, 0x035d, 0x03dd, 0x045d};
const uint8_t HuffDecoderCommon::table1_366_emit_[32] = {
    0x75, 0x45, 0x75, 0x46, 0x75, 0x47, 0x75, 0x48, 0x75, 0x49, 0x75,
    0x4a, 0x75, 0x4b, 0x75, 0x4c, 0x75, 0x4d, 0x75, 0x4e, 0x75, 0x4f,
    0x75, 0x50, 0x75, 0x51, 0x75, 0x52, 0x75, 0x53, 0x75, 0x54};
const uint8_t HuffDecoderCommon::table1_367_emit_[36] = {
    0x75, 0x55, 0x75, 0x56, 0x75, 0x57, 0x75, 0x59, 0x75, 0x6a, 0x75, 0x6b,
    0x75, 0x71, 0x75, 0x76, 0x75, 0x77, 0x75, 0x78, 0x75, 0x79, 0x75, 0x7a,
    0x75, 0x26, 0x75, 0x2a, 0x75, 0x2c, 0x75, 0x3b, 0x75, 0x58, 0x75, 0x5a};
const uint8_t HuffDecoderCommon::table1_368_emit_[16] = {
    0x3a, 0x30, 0x3a, 0x31, 0x3a, 0x32, 0x3a, 0x61,
    0x3a, 0x63, 0x3a, 0x65, 0x3a, 0x69, 0x3a, 0x6f};
const uint8_t HuffDecoderCommon::table1_369_emit_[28] = {
    0x3a, 0x73, 0x3a, 0x74, 0x3a, 0x20, 0x3a, 0x25, 0x3a, 0x2d,
    0x3a, 0x2e, 0x3a, 0x2f, 0x3a, 0x33, 0x3a, 0x34, 0x3a, 0x35,
    0x3a, 0x36, 0x3a, 0x37, 0x3a, 0x38, 0x3a, 0x39};
const uint16_t HuffDecoderCommon::table1_369_inner_[14] = {
    0x001c, 0x009c, 0x011d, 0x019d, 0x021d, 0x029d, 0x031d,
    0x039d, 0x041d, 0x049d, 0x051d, 0x059d, 0x061d, 0x069d};
const uint8_t HuffDecoderCommon::table1_369_outer_[64] = {
    0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,
    2,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,  4,  5,  5,  5,  5,
    6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  8,  9,  9,  9,  9,
    10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13};
const uint8_t HuffDecoderCommon::table1_370_emit_[35] = {
    0x3a, 0x3d, 0x3a, 0x41, 0x3a, 0x5f, 0x3a, 0x62, 0x3a, 0x64, 0x3a, 0x66,
    0x3a, 0x67, 0x3a, 0x68, 0x3a, 0x6c, 0x3a, 0x6d, 0x3a, 0x6e, 0x3a, 0x70,
    0x3a, 0x72, 0x3a, 0x75, 0x3a, 0x3a, 0x42, 0x3a, 0x43, 0x3a, 0x44};
const uint16_t HuffDecoderCommon::table1_370_inner_[18] = {
    0x001d, 0x009d, 0x011d, 0x019d, 0x021d, 0x029d, 0x031d, 0x039d, 0x041d,
    0x049d, 0x051d, 0x059d, 0x061d, 0x069d, 0x071e, 0x075e, 0x07de, 0x085e};
const uint8_t HuffDecoderCommon::table1_370_outer_[64] = {
    0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
    4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
    8,  8,  8,  8,  9,  9,  9,  9,  10, 10, 10, 10, 11, 11, 11, 11,
    12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17};
const uint8_t HuffDecoderCommon::table1_371_emit_[68] = {
    0x3a, 0x45, 0x3a, 0x46, 0x3a, 0x47, 0x3a, 0x48, 0x3a, 0x49, 0x3a, 0x4a,
    0x3a, 0x4b, 0x3a, 0x4c, 0x3a, 0x4d, 0x3a, 0x4e, 0x3a, 0x4f, 0x3a, 0x50,
    0x3a, 0x51, 0x3a, 0x52, 0x3a, 0x53, 0x3a, 0x54, 0x3a, 0x55, 0x3a, 0x56,
    0x3a, 0x57, 0x3a, 0x59, 0x3a, 0x6a, 0x3a, 0x6b, 0x3a, 0x71, 0x3a, 0x76,
    0x3a, 0x77, 0x3a, 0x78, 0x3a, 0x79, 0x3a, 0x7a, 0x3a, 0x26, 0x3a, 0x2a,
    0x3a, 0x2c, 0x3a, 0x3b, 0x3a, 0x58, 0x3a, 0x5a};
const uint16_t HuffDecoderCommon::table1_371_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a9e, 0x0b1e, 0x0b9e, 0x0c1e, 0x0c9e, 0x0d1e,
    0x0d9e, 0x0e1f, 0x0e9f, 0x0f1f, 0x0f9f, 0x101f, 0x109f, 0x0027};
const uint8_t HuffDecoderCommon::table1_371_outer_[64] = {
    0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
    8,  8,  9,  9,  10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15,
    16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23,
    24, 24, 25, 25, 26, 26, 27, 27, 28, 29, 30, 31, 32, 33, 34, 34};
const uint8_t HuffDecoderCommon::table1_372_emit_[16] = {
    0x42, 0x30, 0x42, 0x31, 0x42, 0x32, 0x42, 0x61,
    0x42, 0x63, 0x42, 0x65, 0x42, 0x69, 0x42, 0x6f};
const uint8_t HuffDecoderCommon::table1_373_emit_[28] = {
    0x42, 0x73, 0x42, 0x74, 0x42, 0x20, 0x42, 0x25, 0x42, 0x2d,
    0x42, 0x2e, 0x42, 0x2f, 0x42, 0x33, 0x42, 0x34, 0x42, 0x35,
    0x42, 0x36, 0x42, 0x37, 0x42, 0x38, 0x42, 0x39};
const uint8_t HuffDecoderCommon::table1_374_emit_[35] = {
    0x42, 0x3d, 0x42, 0x41, 0x42, 0x5f, 0x42, 0x62, 0x42, 0x64, 0x42, 0x66,
    0x42, 0x67, 0x42, 0x68, 0x42, 0x6c, 0x42, 0x6d, 0x42, 0x6e, 0x42, 0x70,
    0x42, 0x72, 0x42, 0x75, 0x42, 0x3a, 0x42, 0x42, 0x43, 0x42, 0x44};
const uint16_t HuffDecoderCommon::table1_374_inner_[18] = {
    0x001d, 0x009d, 0x011d, 0x019d, 0x021d, 0x029d, 0x031d, 0x039d, 0x041d,
    0x049d, 0x051d, 0x059d, 0x061d, 0x069d, 0x071e, 0x079e, 0x07de, 0x085e};
const uint8_t HuffDecoderCommon::table1_375_emit_[68] = {
    0x42, 0x45, 0x42, 0x46, 0x42, 0x47, 0x42, 0x48, 0x42, 0x49, 0x42, 0x4a,
    0x42, 0x4b, 0x42, 0x4c, 0x42, 0x4d, 0x42, 0x4e, 0x42, 0x4f, 0x42, 0x50,
    0x42, 0x51, 0x42, 0x52, 0x42, 0x53, 0x42, 0x54, 0x42, 0x55, 0x42, 0x56,
    0x42, 0x57, 0x42, 0x59, 0x42, 0x6a, 0x42, 0x6b, 0x42, 0x71, 0x42, 0x76,
    0x42, 0x77, 0x42, 0x78, 0x42, 0x79, 0x42, 0x7a, 0x42, 0x26, 0x42, 0x2a,
    0x42, 0x2c, 0x42, 0x3b, 0x42, 0x58, 0x42, 0x5a};
const uint8_t HuffDecoderCommon::table1_376_emit_[16] = {
    0x43, 0x30, 0x43, 0x31, 0x43, 0x32, 0x43, 0x61,
    0x43, 0x63, 0x43, 0x65, 0x43, 0x69, 0x43, 0x6f};
const uint8_t HuffDecoderCommon::table1_377_emit_[28] = {
    0x43, 0x73, 0x43, 0x74, 0x43, 0x20, 0x43, 0x25, 0x43, 0x2d,
    0x43, 0x2e, 0x43, 0x2f, 0x43, 0x33, 0x43, 0x34, 0x43, 0x35,
    0x43, 0x36, 0x43, 0x37, 0x43, 0x38, 0x43, 0x39};
const uint8_t HuffDecoderCommon::table1_378_emit_[35] = {
    0x43, 0x3d, 0x43, 0x41, 0x43, 0x5f, 0x43, 0x62, 0x43, 0x64, 0x43, 0x66,
    0x43, 0x67, 0x43, 0x68, 0x43, 0x6c, 0x43, 0x6d, 0x43, 0x6e, 0x43, 0x70,
    0x43, 0x72, 0x43, 0x75, 0x43, 0x3a, 0x43, 0x42, 0x43, 0x43, 0x44};
const uint16_t HuffDecoderCommon::table1_378_inner_[18] = {
    0x001d, 0x009d, 0x011d, 0x019d, 0x021d, 0x029d, 0x031d, 0x039d, 0x041d,
    0x049d, 0x051d, 0x059d, 0x061d, 0x069d, 0x071e, 0x079e, 0x081e, 0x085e};
const uint8_t HuffDecoderCommon::table1_379_emit_[68] = {
    0x43, 0x45, 0x43, 0x46, 0x43, 0x47, 0x43, 0x48, 0x43, 0x49, 0x43, 0x4a,
    0x43, 0x4b, 0x43, 0x4c, 0x43, 0x4d, 0x43, 0x4e, 0x43, 0x4f, 0x43, 0x50,
    0x43, 0x51, 0x43, 0x52, 0x43, 0x53, 0x43, 0x54, 0x43, 0x55, 0x43, 0x56,
    0x43, 0x57, 0x43, 0x59, 0x43, 0x6a, 0x43, 0x6b, 0x43, 0x71, 0x43, 0x76,
    0x43, 0x77, 0x43, 0x78, 0x43, 0x79, 0x43, 0x7a, 0x43, 0x26, 0x43, 0x2a,
    0x43, 0x2c, 0x43, 0x3b, 0x43, 0x58, 0x43, 0x5a};
const uint8_t HuffDecoderCommon::table1_380_emit_[16] = {
    0x44, 0x30, 0x44, 0x31, 0x44, 0x32, 0x44, 0x61,
    0x44, 0x63, 0x44, 0x65, 0x44, 0x69, 0x44, 0x6f};
const uint8_t HuffDecoderCommon::table1_381_emit_[28] = {
    0x44, 0x73, 0x44, 0x74, 0x44, 0x20, 0x44, 0x25, 0x44, 0x2d,
    0x44, 0x2e, 0x44, 0x2f, 0x44, 0x33, 0x44, 0x34, 0x44, 0x35,
    0x44, 0x36, 0x44, 0x37, 0x44, 0x38, 0x44, 0x39};
const uint8_t HuffDecoderCommon::table1_382_emit_[36] = {
    0x44, 0x3d, 0x44, 0x41, 0x44, 0x5f, 0x44, 0x62, 0x44, 0x64, 0x44, 0x66,
    0x44, 0x67, 0x44, 0x68, 0x44, 0x6c, 0x44, 0x6d, 0x44, 0x6e, 0x44, 0x70,
    0x44, 0x72, 0x44, 0x75, 0x44, 0x3a, 0x44, 0x42, 0x44, 0x43, 0x44, 0x44};
const uint16_t HuffDecoderCommon::table1_382_inner_[18] = {
    0x001d, 0x009d, 0x011d, 0x019d, 0x021d, 0x029d, 0x031d, 0x039d, 0x041d,
    0x049d, 0x051d, 0x059d, 0x061d, 0x069d, 0x071e, 0x079e, 0x081e, 0x089e};
const uint8_t HuffDecoderCommon::table1_383_emit_[68] = {
    0x44, 0x45, 0x44, 0x46, 0x44, 0x47, 0x44, 0x48, 0x44, 0x49, 0x44, 0x4a,
    0x44, 0x4b, 0x44, 0x4c, 0x44, 0x4d, 0x44, 0x4e, 0x44, 0x4f, 0x44, 0x50,
    0x44, 0x51, 0x44, 0x52, 0x44, 0x53, 0x44, 0x54, 0x44, 0x55, 0x44, 0x56,
    0x44, 0x57, 0x44, 0x59, 0x44, 0x6a, 0x44, 0x6b, 0x44, 0x71, 0x44, 0x76,
    0x44, 0x77, 0x44, 0x78, 0x44, 0x79, 0x44, 0x7a, 0x44, 0x26, 0x44, 0x2a,
    0x44, 0x2c, 0x44, 0x3b, 0x44, 0x58, 0x44, 0x5a};
const uint8_t HuffDecoderCommon::table1_384_emit_[16] = {
    0x45, 0x30, 0x45, 0x31, 0x45, 0x32, 0x45, 0x61,
    0x45, 0x63, 0x45, 0x65, 0x45, 0x69, 0x45, 0x6f};
const uint8_t HuffDecoderCommon::table1_385_emit_[28] = {
    0x45, 0x73, 0x45, 0x74, 0x45, 0x20, 0x45, 0x25, 0x45, 0x2d,
    0x45, 0x2e, 0x45, 0x2f, 0x45, 0x33, 0x45, 0x34, 0x45, 0x35,
    0x45, 0x36, 0x45, 0x37, 0x45, 0x38, 0x45, 0x39};
const uint8_t HuffDecoderCommon::table1_386_emit_[36] = {
    0x45, 0x3d, 0x45, 0x41, 0x45, 0x5f, 0x45, 0x62, 0x45, 0x64, 0x45, 0x66,
    0x45, 0x67, 0x45, 0x68, 0x45, 0x6c, 0x45, 0x6d, 0x45, 0x6e, 0x45, 0x70,
    0x45, 0x72, 0x45, 0x75, 0x45, 0x3a, 0x45, 0x42, 0x45, 0x43, 0x45, 0x44};
const uint8_t HuffDecoderCommon::table1_387_emit_[67] = {
    0x45, 0x45, 0x46, 0x45, 0x47, 0x45, 0x48, 0x45, 0x49, 0x45, 0x4a, 0x45,
    0x4b, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x45, 0x4f, 0x45, 0x50, 0x45,
    0x51, 0x45, 0x52, 0x45, 0x53, 0x45, 0x54, 0x45, 0x55, 0x45, 0x56, 0x45,
    0x57, 0x45, 0x59, 0x45, 0x6a, 0x45, 0x6b, 0x45, 0x71, 0x45, 0x76, 0x45,
    0x77, 0x45, 0x78, 0x45, 0x79, 0x45, 0x7a, 0x45, 0x26, 0x45, 0x2a, 0x45,
    0x2c, 0x45, 0x3b, 0x45, 0x58, 0x45, 0x5a};
const uint16_t HuffDecoderCommon::table1_387_inner_[35] = {
    0x001e, 0x005e, 0x00de, 0x015e, 0x01de, 0x025e, 0x02de, 0x035e, 0x03de,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_388_emit_[16] = {
    0x46, 0x30, 0x46, 0x31, 0x46, 0x32, 0x46, 0x61,
    0x46, 0x63, 0x46, 0x65, 0x46, 0x69, 0x46, 0x6f};
const uint8_t HuffDecoderCommon::table1_389_emit_[28] = {
    0x46, 0x73, 0x46, 0x74, 0x46, 0x20, 0x46, 0x25, 0x46, 0x2d,
    0x46, 0x2e, 0x46, 0x2f, 0x46, 0x33, 0x46, 0x34, 0x46, 0x35,
    0x46, 0x36, 0x46, 0x37, 0x46, 0x38, 0x46, 0x39};
const uint8_t HuffDecoderCommon::table1_390_emit_[36] = {
    0x46, 0x3d, 0x46, 0x41, 0x46, 0x5f, 0x46, 0x62, 0x46, 0x64, 0x46, 0x66,
    0x46, 0x67, 0x46, 0x68, 0x46, 0x6c, 0x46, 0x6d, 0x46, 0x6e, 0x46, 0x70,
    0x46, 0x72, 0x46, 0x75, 0x46, 0x3a, 0x46, 0x42, 0x46, 0x43, 0x46, 0x44};
const uint8_t HuffDecoderCommon::table1_391_emit_[67] = {
    0x46, 0x45, 0x46, 0x46, 0x47, 0x46, 0x48, 0x46, 0x49, 0x46, 0x4a, 0x46,
    0x4b, 0x46, 0x4c, 0x46, 0x4d, 0x46, 0x4e, 0x46, 0x4f, 0x46, 0x50, 0x46,
    0x51, 0x46, 0x52, 0x46, 0x53, 0x46, 0x54, 0x46, 0x55, 0x46, 0x56, 0x46,
    0x57, 0x46, 0x59, 0x46, 0x6a, 0x46, 0x6b, 0x46, 0x71, 0x46, 0x76, 0x46,
    0x77, 0x46, 0x78, 0x46, 0x79, 0x46, 0x7a, 0x46, 0x26, 0x46, 0x2a, 0x46,
    0x2c, 0x46, 0x3b, 0x46, 0x58, 0x46, 0x5a};
const uint16_t HuffDecoderCommon::table1_391_inner_[35] = {
    0x001e, 0x009e, 0x00de, 0x015e, 0x01de, 0x025e, 0x02de, 0x035e, 0x03de,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_392_emit_[16] = {
    0x47, 0x30, 0x47, 0x31, 0x47, 0x32, 0x47, 0x61,
    0x47, 0x63, 0x47, 0x65, 0x47, 0x69, 0x47, 0x6f};
const uint8_t HuffDecoderCommon::table1_393_emit_[28] = {
    0x47, 0x73, 0x47, 0x74, 0x47, 0x20, 0x47, 0x25, 0x47, 0x2d,
    0x47, 0x2e, 0x47, 0x2f, 0x47, 0x33, 0x47, 0x34, 0x47, 0x35,
    0x47, 0x36, 0x47, 0x37, 0x47, 0x38, 0x47, 0x39};
const uint8_t HuffDecoderCommon::table1_394_emit_[36] = {
    0x47, 0x3d, 0x47, 0x41, 0x47, 0x5f, 0x47, 0x62, 0x47, 0x64, 0x47, 0x66,
    0x47, 0x67, 0x47, 0x68, 0x47, 0x6c, 0x47, 0x6d, 0x47, 0x6e, 0x47, 0x70,
    0x47, 0x72, 0x47, 0x75, 0x47, 0x3a, 0x47, 0x42, 0x47, 0x43, 0x47, 0x44};
const uint8_t HuffDecoderCommon::table1_395_emit_[67] = {
    0x47, 0x45, 0x47, 0x46, 0x47, 0x47, 0x48, 0x47, 0x49, 0x47, 0x4a, 0x47,
    0x4b, 0x47, 0x4c, 0x47, 0x4d, 0x47, 0x4e, 0x47, 0x4f, 0x47, 0x50, 0x47,
    0x51, 0x47, 0x52, 0x47, 0x53, 0x47, 0x54, 0x47, 0x55, 0x47, 0x56, 0x47,
    0x57, 0x47, 0x59, 0x47, 0x6a, 0x47, 0x6b, 0x47, 0x71, 0x47, 0x76, 0x47,
    0x77, 0x47, 0x78, 0x47, 0x79, 0x47, 0x7a, 0x47, 0x26, 0x47, 0x2a, 0x47,
    0x2c, 0x47, 0x3b, 0x47, 0x58, 0x47, 0x5a};
const uint16_t HuffDecoderCommon::table1_395_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x015e, 0x01de, 0x025e, 0x02de, 0x035e, 0x03de,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_396_emit_[16] = {
    0x48, 0x30, 0x48, 0x31, 0x48, 0x32, 0x48, 0x61,
    0x48, 0x63, 0x48, 0x65, 0x48, 0x69, 0x48, 0x6f};
const uint8_t HuffDecoderCommon::table1_397_emit_[28] = {
    0x48, 0x73, 0x48, 0x74, 0x48, 0x20, 0x48, 0x25, 0x48, 0x2d,
    0x48, 0x2e, 0x48, 0x2f, 0x48, 0x33, 0x48, 0x34, 0x48, 0x35,
    0x48, 0x36, 0x48, 0x37, 0x48, 0x38, 0x48, 0x39};
const uint8_t HuffDecoderCommon::table1_398_emit_[36] = {
    0x48, 0x3d, 0x48, 0x41, 0x48, 0x5f, 0x48, 0x62, 0x48, 0x64, 0x48, 0x66,
    0x48, 0x67, 0x48, 0x68, 0x48, 0x6c, 0x48, 0x6d, 0x48, 0x6e, 0x48, 0x70,
    0x48, 0x72, 0x48, 0x75, 0x48, 0x3a, 0x48, 0x42, 0x48, 0x43, 0x48, 0x44};
const uint8_t HuffDecoderCommon::table1_399_emit_[67] = {
    0x48, 0x45, 0x48, 0x46, 0x48, 0x47, 0x48, 0x48, 0x49, 0x48, 0x4a, 0x48,
    0x4b, 0x48, 0x4c, 0x48, 0x4d, 0x48, 0x4e, 0x48, 0x4f, 0x48, 0x50, 0x48,
    0x51, 0x48, 0x52, 0x48, 0x53, 0x48, 0x54, 0x48, 0x55, 0x48, 0x56, 0x48,
    0x57, 0x48, 0x59, 0x48, 0x6a, 0x48, 0x6b, 0x48, 0x71, 0x48, 0x76, 0x48,
    0x77, 0x48, 0x78, 0x48, 0x79, 0x48, 0x7a, 0x48, 0x26, 0x48, 0x2a, 0x48,
    0x2c, 0x48, 0x3b, 0x48, 0x58, 0x48, 0x5a};
const uint16_t HuffDecoderCommon::table1_399_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x01de, 0x025e, 0x02de, 0x035e, 0x03de,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_400_emit_[16] = {
    0x49, 0x30, 0x49, 0x31, 0x49, 0x32, 0x49, 0x61,
    0x49, 0x63, 0x49, 0x65, 0x49, 0x69, 0x49, 0x6f};
const uint8_t HuffDecoderCommon::table1_401_emit_[28] = {
    0x49, 0x73, 0x49, 0x74, 0x49, 0x20, 0x49, 0x25, 0x49, 0x2d,
    0x49, 0x2e, 0x49, 0x2f, 0x49, 0x33, 0x49, 0x34, 0x49, 0x35,
    0x49, 0x36, 0x49, 0x37, 0x49, 0x38, 0x49, 0x39};
const uint8_t HuffDecoderCommon::table1_402_emit_[36] = {
    0x49, 0x3d, 0x49, 0x41, 0x49, 0x5f, 0x49, 0x62, 0x49, 0x64, 0x49, 0x66,
    0x49, 0x67, 0x49, 0x68, 0x49, 0x6c, 0x49, 0x6d, 0x49, 0x6e, 0x49, 0x70,
    0x49, 0x72, 0x49, 0x75, 0x49, 0x3a, 0x49, 0x42, 0x49, 0x43, 0x49, 0x44};
const uint8_t HuffDecoderCommon::table1_403_emit_[67] = {
    0x49, 0x45, 0x49, 0x46, 0x49, 0x47, 0x49, 0x48, 0x49, 0x49, 0x4a, 0x49,
    0x4b, 0x49, 0x4c, 0x49, 0x4d, 0x49, 0x4e, 0x49, 0x4f, 0x49, 0x50, 0x49,
    0x51, 0x49, 0x52, 0x49, 0x53, 0x49, 0x54, 0x49, 0x55, 0x49, 0x56, 0x49,
    0x57, 0x49, 0x59, 0x49, 0x6a, 0x49, 0x6b, 0x49, 0x71, 0x49, 0x76, 0x49,
    0x77, 0x49, 0x78, 0x49, 0x79, 0x49, 0x7a, 0x49, 0x26, 0x49, 0x2a, 0x49,
    0x2c, 0x49, 0x3b, 0x49, 0x58, 0x49, 0x5a};
const uint16_t HuffDecoderCommon::table1_403_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x025e, 0x02de, 0x035e, 0x03de,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_404_emit_[16] = {
    0x4a, 0x30, 0x4a, 0x31, 0x4a, 0x32, 0x4a, 0x61,
    0x4a, 0x63, 0x4a, 0x65, 0x4a, 0x69, 0x4a, 0x6f};
const uint8_t HuffDecoderCommon::table1_405_emit_[28] = {
    0x4a, 0x73, 0x4a, 0x74, 0x4a, 0x20, 0x4a, 0x25, 0x4a, 0x2d,
    0x4a, 0x2e, 0x4a, 0x2f, 0x4a, 0x33, 0x4a, 0x34, 0x4a, 0x35,
    0x4a, 0x36, 0x4a, 0x37, 0x4a, 0x38, 0x4a, 0x39};
const uint8_t HuffDecoderCommon::table1_406_emit_[36] = {
    0x4a, 0x3d, 0x4a, 0x41, 0x4a, 0x5f, 0x4a, 0x62, 0x4a, 0x64, 0x4a, 0x66,
    0x4a, 0x67, 0x4a, 0x68, 0x4a, 0x6c, 0x4a, 0x6d, 0x4a, 0x6e, 0x4a, 0x70,
    0x4a, 0x72, 0x4a, 0x75, 0x4a, 0x3a, 0x4a, 0x42, 0x4a, 0x43, 0x4a, 0x44};
const uint8_t HuffDecoderCommon::table1_407_emit_[67] = {
    0x4a, 0x45, 0x4a, 0x46, 0x4a, 0x47, 0x4a, 0x48, 0x4a, 0x49, 0x4a, 0x4a,
    0x4b, 0x4a, 0x4c, 0x4a, 0x4d, 0x4a, 0x4e, 0x4a, 0x4f, 0x4a, 0x50, 0x4a,
    0x51, 0x4a, 0x52, 0x4a, 0x53, 0x4a, 0x54, 0x4a, 0x55, 0x4a, 0x56, 0x4a,
    0x57, 0x4a, 0x59, 0x4a, 0x6a, 0x4a, 0x6b, 0x4a, 0x71, 0x4a, 0x76, 0x4a,
    0x77, 0x4a, 0x78, 0x4a, 0x79, 0x4a, 0x7a, 0x4a, 0x26, 0x4a, 0x2a, 0x4a,
    0x2c, 0x4a, 0x3b, 0x4a, 0x58, 0x4a, 0x5a};
const uint16_t HuffDecoderCommon::table1_407_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x02de, 0x035e, 0x03de,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_408_emit_[16] = {
    0x4b, 0x30, 0x4b, 0x31, 0x4b, 0x32, 0x4b, 0x61,
    0x4b, 0x63, 0x4b, 0x65, 0x4b, 0x69, 0x4b, 0x6f};
const uint8_t HuffDecoderCommon::table1_409_emit_[28] = {
    0x4b, 0x73, 0x4b, 0x74, 0x4b, 0x20, 0x4b, 0x25, 0x4b, 0x2d,
    0x4b, 0x2e, 0x4b, 0x2f, 0x4b, 0x33, 0x4b, 0x34, 0x4b, 0x35,
    0x4b, 0x36, 0x4b, 0x37, 0x4b, 0x38, 0x4b, 0x39};
const uint8_t HuffDecoderCommon::table1_410_emit_[36] = {
    0x4b, 0x3d, 0x4b, 0x41, 0x4b, 0x5f, 0x4b, 0x62, 0x4b, 0x64, 0x4b, 0x66,
    0x4b, 0x67, 0x4b, 0x68, 0x4b, 0x6c, 0x4b, 0x6d, 0x4b, 0x6e, 0x4b, 0x70,
    0x4b, 0x72, 0x4b, 0x75, 0x4b, 0x3a, 0x4b, 0x42, 0x4b, 0x43, 0x4b, 0x44};
const uint8_t HuffDecoderCommon::table1_411_emit_[67] = {
    0x4b, 0x45, 0x4b, 0x46, 0x4b, 0x47, 0x4b, 0x48, 0x4b, 0x49, 0x4b, 0x4a,
    0x4b, 0x4b, 0x4c, 0x4b, 0x4d, 0x4b, 0x4e, 0x4b, 0x4f, 0x4b, 0x50, 0x4b,
    0x51, 0x4b, 0x52, 0x4b, 0x53, 0x4b, 0x54, 0x4b, 0x55, 0x4b, 0x56, 0x4b,
    0x57, 0x4b, 0x59, 0x4b, 0x6a, 0x4b, 0x6b, 0x4b, 0x71, 0x4b, 0x76, 0x4b,
    0x77, 0x4b, 0x78, 0x4b, 0x79, 0x4b, 0x7a, 0x4b, 0x26, 0x4b, 0x2a, 0x4b,
    0x2c, 0x4b, 0x3b, 0x4b, 0x58, 0x4b, 0x5a};
const uint16_t HuffDecoderCommon::table1_411_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x035e, 0x03de,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_412_emit_[16] = {
    0x4c, 0x30, 0x4c, 0x31, 0x4c, 0x32, 0x4c, 0x61,
    0x4c, 0x63, 0x4c, 0x65, 0x4c, 0x69, 0x4c, 0x6f};
const uint8_t HuffDecoderCommon::table1_413_emit_[28] = {
    0x4c, 0x73, 0x4c, 0x74, 0x4c, 0x20, 0x4c, 0x25, 0x4c, 0x2d,
    0x4c, 0x2e, 0x4c, 0x2f, 0x4c, 0x33, 0x4c, 0x34, 0x4c, 0x35,
    0x4c, 0x36, 0x4c, 0x37, 0x4c, 0x38, 0x4c, 0x39};
const uint8_t HuffDecoderCommon::table1_414_emit_[36] = {
    0x4c, 0x3d, 0x4c, 0x41, 0x4c, 0x5f, 0x4c, 0x62, 0x4c, 0x64, 0x4c, 0x66,
    0x4c, 0x67, 0x4c, 0x68, 0x4c, 0x6c, 0x4c, 0x6d, 0x4c, 0x6e, 0x4c, 0x70,
    0x4c, 0x72, 0x4c, 0x75, 0x4c, 0x3a, 0x4c, 0x42, 0x4c, 0x43, 0x4c, 0x44};
const uint8_t HuffDecoderCommon::table1_415_emit_[67] = {
    0x4c, 0x45, 0x4c, 0x46, 0x4c, 0x47, 0x4c, 0x48, 0x4c, 0x49, 0x4c, 0x4a,
    0x4c, 0x4b, 0x4c, 0x4c, 0x4d, 0x4c, 0x4e, 0x4c, 0x4f, 0x4c, 0x50, 0x4c,
    0x51, 0x4c, 0x52, 0x4c, 0x53, 0x4c, 0x54, 0x4c, 0x55, 0x4c, 0x56, 0x4c,
    0x57, 0x4c, 0x59, 0x4c, 0x6a, 0x4c, 0x6b, 0x4c, 0x71, 0x4c, 0x76, 0x4c,
    0x77, 0x4c, 0x78, 0x4c, 0x79, 0x4c, 0x7a, 0x4c, 0x26, 0x4c, 0x2a, 0x4c,
    0x2c, 0x4c, 0x3b, 0x4c, 0x58, 0x4c, 0x5a};
const uint16_t HuffDecoderCommon::table1_415_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x03de,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_416_emit_[16] = {
    0x4d, 0x30, 0x4d, 0x31, 0x4d, 0x32, 0x4d, 0x61,
    0x4d, 0x63, 0x4d, 0x65, 0x4d, 0x69, 0x4d, 0x6f};
const uint8_t HuffDecoderCommon::table1_417_emit_[28] = {
    0x4d, 0x73, 0x4d, 0x74, 0x4d, 0x20, 0x4d, 0x25, 0x4d, 0x2d,
    0x4d, 0x2e, 0x4d, 0x2f, 0x4d, 0x33, 0x4d, 0x34, 0x4d, 0x35,
    0x4d, 0x36, 0x4d, 0x37, 0x4d, 0x38, 0x4d, 0x39};
const uint8_t HuffDecoderCommon::table1_418_emit_[36] = {
    0x4d, 0x3d, 0x4d, 0x41, 0x4d, 0x5f, 0x4d, 0x62, 0x4d, 0x64, 0x4d, 0x66,
    0x4d, 0x67, 0x4d, 0x68, 0x4d, 0x6c, 0x4d, 0x6d, 0x4d, 0x6e, 0x4d, 0x70,
    0x4d, 0x72, 0x4d, 0x75, 0x4d, 0x3a, 0x4d, 0x42, 0x4d, 0x43, 0x4d, 0x44};
const uint8_t HuffDecoderCommon::table1_419_emit_[67] = {
    0x4d, 0x45, 0x4d, 0x46, 0x4d, 0x47, 0x4d, 0x48, 0x4d, 0x49, 0x4d, 0x4a,
    0x4d, 0x4b, 0x4d, 0x4c, 0x4d, 0x4d, 0x4e, 0x4d, 0x4f, 0x4d, 0x50, 0x4d,
    0x51, 0x4d, 0x52, 0x4d, 0x53, 0x4d, 0x54, 0x4d, 0x55, 0x4d, 0x56, 0x4d,
    0x57, 0x4d, 0x59, 0x4d, 0x6a, 0x4d, 0x6b, 0x4d, 0x71, 0x4d, 0x76, 0x4d,
    0x77, 0x4d, 0x78, 0x4d, 0x79, 0x4d, 0x7a, 0x4d, 0x26, 0x4d, 0x2a, 0x4d,
    0x2c, 0x4d, 0x3b, 0x4d, 0x58, 0x4d, 0x5a};
const uint16_t HuffDecoderCommon::table1_419_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x045e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_420_emit_[16] = {
    0x4e, 0x30, 0x4e, 0x31, 0x4e, 0x32, 0x4e, 0x61,
    0x4e, 0x63, 0x4e, 0x65, 0x4e, 0x69, 0x4e, 0x6f};
const uint8_t HuffDecoderCommon::table1_421_emit_[28] = {
    0x4e, 0x73, 0x4e, 0x74, 0x4e, 0x20, 0x4e, 0x25, 0x4e, 0x2d,
    0x4e, 0x2e, 0x4e, 0x2f, 0x4e, 0x33, 0x4e, 0x34, 0x4e, 0x35,
    0x4e, 0x36, 0x4e, 0x37, 0x4e, 0x38, 0x4e, 0x39};
const uint8_t HuffDecoderCommon::table1_422_emit_[36] = {
    0x4e, 0x3d, 0x4e, 0x41, 0x4e, 0x5f, 0x4e, 0x62, 0x4e, 0x64, 0x4e, 0x66,
    0x4e, 0x67, 0x4e, 0x68, 0x4e, 0x6c, 0x4e, 0x6d, 0x4e, 0x6e, 0x4e, 0x70,
    0x4e, 0x72, 0x4e, 0x75, 0x4e, 0x3a, 0x4e, 0x42, 0x4e, 0x43, 0x4e, 0x44};
const uint8_t HuffDecoderCommon::table1_423_emit_[67] = {
    0x4e, 0x45, 0x4e, 0x46, 0x4e, 0x47, 0x4e, 0x48, 0x4e, 0x49, 0x4e, 0x4a,
    0x4e, 0x4b, 0x4e, 0x4c, 0x4e, 0x4d, 0x4e, 0x4e, 0x4f, 0x4e, 0x50, 0x4e,
    0x51, 0x4e, 0x52, 0x4e, 0x53, 0x4e, 0x54, 0x4e, 0x55, 0x4e, 0x56, 0x4e,
    0x57, 0x4e, 0x59, 0x4e, 0x6a, 0x4e, 0x6b, 0x4e, 0x71, 0x4e, 0x76, 0x4e,
    0x77, 0x4e, 0x78, 0x4e, 0x79, 0x4e, 0x7a, 0x4e, 0x26, 0x4e, 0x2a, 0x4e,
    0x2c, 0x4e, 0x3b, 0x4e, 0x58, 0x4e, 0x5a};
const uint16_t HuffDecoderCommon::table1_423_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x04de, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_424_emit_[16] = {
    0x4f, 0x30, 0x4f, 0x31, 0x4f, 0x32, 0x4f, 0x61,
    0x4f, 0x63, 0x4f, 0x65, 0x4f, 0x69, 0x4f, 0x6f};
const uint8_t HuffDecoderCommon::table1_425_emit_[28] = {
    0x4f, 0x73, 0x4f, 0x74, 0x4f, 0x20, 0x4f, 0x25, 0x4f, 0x2d,
    0x4f, 0x2e, 0x4f, 0x2f, 0x4f, 0x33, 0x4f, 0x34, 0x4f, 0x35,
    0x4f, 0x36, 0x4f, 0x37, 0x4f, 0x38, 0x4f, 0x39};
const uint8_t HuffDecoderCommon::table1_426_emit_[36] = {
    0x4f, 0x3d, 0x4f, 0x41, 0x4f, 0x5f, 0x4f, 0x62, 0x4f, 0x64, 0x4f, 0x66,
    0x4f, 0x67, 0x4f, 0x68, 0x4f, 0x6c, 0x4f, 0x6d, 0x4f, 0x6e, 0x4f, 0x70,
    0x4f, 0x72, 0x4f, 0x75, 0x4f, 0x3a, 0x4f, 0x42, 0x4f, 0x43, 0x4f, 0x44};
const uint8_t HuffDecoderCommon::table1_427_emit_[67] = {
    0x4f, 0x45, 0x4f, 0x46, 0x4f, 0x47, 0x4f, 0x48, 0x4f, 0x49, 0x4f, 0x4a,
    0x4f, 0x4b, 0x4f, 0x4c, 0x4f, 0x4d, 0x4f, 0x4e, 0x4f, 0x4f, 0x50, 0x4f,
    0x51, 0x4f, 0x52, 0x4f, 0x53, 0x4f, 0x54, 0x4f, 0x55, 0x4f, 0x56, 0x4f,
    0x57, 0x4f, 0x59, 0x4f, 0x6a, 0x4f, 0x6b, 0x4f, 0x71, 0x4f, 0x76, 0x4f,
    0x77, 0x4f, 0x78, 0x4f, 0x79, 0x4f, 0x7a, 0x4f, 0x26, 0x4f, 0x2a, 0x4f,
    0x2c, 0x4f, 0x3b, 0x4f, 0x58, 0x4f, 0x5a};
const uint16_t HuffDecoderCommon::table1_427_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x055e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_428_emit_[16] = {
    0x50, 0x30, 0x50, 0x31, 0x50, 0x32, 0x50, 0x61,
    0x50, 0x63, 0x50, 0x65, 0x50, 0x69, 0x50, 0x6f};
const uint8_t HuffDecoderCommon::table1_429_emit_[28] = {
    0x50, 0x73, 0x50, 0x74, 0x50, 0x20, 0x50, 0x25, 0x50, 0x2d,
    0x50, 0x2e, 0x50, 0x2f, 0x50, 0x33, 0x50, 0x34, 0x50, 0x35,
    0x50, 0x36, 0x50, 0x37, 0x50, 0x38, 0x50, 0x39};
const uint8_t HuffDecoderCommon::table1_430_emit_[36] = {
    0x50, 0x3d, 0x50, 0x41, 0x50, 0x5f, 0x50, 0x62, 0x50, 0x64, 0x50, 0x66,
    0x50, 0x67, 0x50, 0x68, 0x50, 0x6c, 0x50, 0x6d, 0x50, 0x6e, 0x50, 0x70,
    0x50, 0x72, 0x50, 0x75, 0x50, 0x3a, 0x50, 0x42, 0x50, 0x43, 0x50, 0x44};
const uint8_t HuffDecoderCommon::table1_431_emit_[67] = {
    0x50, 0x45, 0x50, 0x46, 0x50, 0x47, 0x50, 0x48, 0x50, 0x49, 0x50, 0x4a,
    0x50, 0x4b, 0x50, 0x4c, 0x50, 0x4d, 0x50, 0x4e, 0x50, 0x4f, 0x50, 0x50,
    0x51, 0x50, 0x52, 0x50, 0x53, 0x50, 0x54, 0x50, 0x55, 0x50, 0x56, 0x50,
    0x57, 0x50, 0x59, 0x50, 0x6a, 0x50, 0x6b, 0x50, 0x71, 0x50, 0x76, 0x50,
    0x77, 0x50, 0x78, 0x50, 0x79, 0x50, 0x7a, 0x50, 0x26, 0x50, 0x2a, 0x50,
    0x2c, 0x50, 0x3b, 0x50, 0x58, 0x50, 0x5a};
const uint16_t HuffDecoderCommon::table1_431_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x05de, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_432_emit_[16] = {
    0x51, 0x30, 0x51, 0x31, 0x51, 0x32, 0x51, 0x61,
    0x51, 0x63, 0x51, 0x65, 0x51, 0x69, 0x51, 0x6f};
const uint8_t HuffDecoderCommon::table1_433_emit_[28] = {
    0x51, 0x73, 0x51, 0x74, 0x51, 0x20, 0x51, 0x25, 0x51, 0x2d,
    0x51, 0x2e, 0x51, 0x2f, 0x51, 0x33, 0x51, 0x34, 0x51, 0x35,
    0x51, 0x36, 0x51, 0x37, 0x51, 0x38, 0x51, 0x39};
const uint8_t HuffDecoderCommon::table1_434_emit_[36] = {
    0x51, 0x3d, 0x51, 0x41, 0x51, 0x5f, 0x51, 0x62, 0x51, 0x64, 0x51, 0x66,
    0x51, 0x67, 0x51, 0x68, 0x51, 0x6c, 0x51, 0x6d, 0x51, 0x6e, 0x51, 0x70,
    0x51, 0x72, 0x51, 0x75, 0x51, 0x3a, 0x51, 0x42, 0x51, 0x43, 0x51, 0x44};
const uint8_t HuffDecoderCommon::table1_435_emit_[67] = {
    0x51, 0x45, 0x51, 0x46, 0x51, 0x47, 0x51, 0x48, 0x51, 0x49, 0x51, 0x4a,
    0x51, 0x4b, 0x51, 0x4c, 0x51, 0x4d, 0x51, 0x4e, 0x51, 0x4f, 0x51, 0x50,
    0x51, 0x51, 0x52, 0x51, 0x53, 0x51, 0x54, 0x51, 0x55, 0x51, 0x56, 0x51,
    0x57, 0x51, 0x59, 0x51, 0x6a, 0x51, 0x6b, 0x51, 0x71, 0x51, 0x76, 0x51,
    0x77, 0x51, 0x78, 0x51, 0x79, 0x51, 0x7a, 0x51, 0x26, 0x51, 0x2a, 0x51,
    0x2c, 0x51, 0x3b, 0x51, 0x58, 0x51, 0x5a};
const uint16_t HuffDecoderCommon::table1_435_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x065e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_436_emit_[16] = {
    0x52, 0x30, 0x52, 0x31, 0x52, 0x32, 0x52, 0x61,
    0x52, 0x63, 0x52, 0x65, 0x52, 0x69, 0x52, 0x6f};
const uint8_t HuffDecoderCommon::table1_437_emit_[28] = {
    0x52, 0x73, 0x52, 0x74, 0x52, 0x20, 0x52, 0x25, 0x52, 0x2d,
    0x52, 0x2e, 0x52, 0x2f, 0x52, 0x33, 0x52, 0x34, 0x52, 0x35,
    0x52, 0x36, 0x52, 0x37, 0x52, 0x38, 0x52, 0x39};
const uint8_t HuffDecoderCommon::table1_438_emit_[36] = {
    0x52, 0x3d, 0x52, 0x41, 0x52, 0x5f, 0x52, 0x62, 0x52, 0x64, 0x52, 0x66,
    0x52, 0x67, 0x52, 0x68, 0x52, 0x6c, 0x52, 0x6d, 0x52, 0x6e, 0x52, 0x70,
    0x52, 0x72, 0x52, 0x75, 0x52, 0x3a, 0x52, 0x42, 0x52, 0x43, 0x52, 0x44};
const uint8_t HuffDecoderCommon::table1_439_emit_[67] = {
    0x52, 0x45, 0x52, 0x46, 0x52, 0x47, 0x52, 0x48, 0x52, 0x49, 0x52, 0x4a,
    0x52, 0x4b, 0x52, 0x4c, 0x52, 0x4d, 0x52, 0x4e, 0x52, 0x4f, 0x52, 0x50,
    0x52, 0x51, 0x52, 0x52, 0x53, 0x52, 0x54, 0x52, 0x55, 0x52, 0x56, 0x52,
    0x57, 0x52, 0x59, 0x52, 0x6a, 0x52, 0x6b, 0x52, 0x71, 0x52, 0x76, 0x52,
    0x77, 0x52, 0x78, 0x52, 0x79, 0x52, 0x7a, 0x52, 0x26, 0x52, 0x2a, 0x52,
    0x2c, 0x52, 0x3b, 0x52, 0x58, 0x52, 0x5a};
const uint16_t HuffDecoderCommon::table1_439_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x06de, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_440_emit_[16] = {
    0x53, 0x30, 0x53, 0x31, 0x53, 0x32, 0x53, 0x61,
    0x53, 0x63, 0x53, 0x65, 0x53, 0x69, 0x53, 0x6f};
const uint8_t HuffDecoderCommon::table1_441_emit_[28] = {
    0x53, 0x73, 0x53, 0x74, 0x53, 0x20, 0x53, 0x25, 0x53, 0x2d,
    0x53, 0x2e, 0x53, 0x2f, 0x53, 0x33, 0x53, 0x34, 0x53, 0x35,
    0x53, 0x36, 0x53, 0x37, 0x53, 0x38, 0x53, 0x39};
const uint8_t HuffDecoderCommon::table1_442_emit_[36] = {
    0x53, 0x3d, 0x53, 0x41, 0x53, 0x5f, 0x53, 0x62, 0x53, 0x64, 0x53, 0x66,
    0x53, 0x67, 0x53, 0x68, 0x53, 0x6c, 0x53, 0x6d, 0x53, 0x6e, 0x53, 0x70,
    0x53, 0x72, 0x53, 0x75, 0x53, 0x3a, 0x53, 0x42, 0x53, 0x43, 0x53, 0x44};
const uint8_t HuffDecoderCommon::table1_443_emit_[67] = {
    0x53, 0x45, 0x53, 0x46, 0x53, 0x47, 0x53, 0x48, 0x53, 0x49, 0x53, 0x4a,
    0x53, 0x4b, 0x53, 0x4c, 0x53, 0x4d, 0x53, 0x4e, 0x53, 0x4f, 0x53, 0x50,
    0x53, 0x51, 0x53, 0x52, 0x53, 0x53, 0x54, 0x53, 0x55, 0x53, 0x56, 0x53,
    0x57, 0x53, 0x59, 0x53, 0x6a, 0x53, 0x6b, 0x53, 0x71, 0x53, 0x76, 0x53,
    0x77, 0x53, 0x78, 0x53, 0x79, 0x53, 0x7a, 0x53, 0x26, 0x53, 0x2a, 0x53,
    0x2c, 0x53, 0x3b, 0x53, 0x58, 0x53, 0x5a};
const uint16_t HuffDecoderCommon::table1_443_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x075e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_444_emit_[16] = {
    0x54, 0x30, 0x54, 0x31, 0x54, 0x32, 0x54, 0x61,
    0x54, 0x63, 0x54, 0x65, 0x54, 0x69, 0x54, 0x6f};
const uint8_t HuffDecoderCommon::table1_445_emit_[28] = {
    0x54, 0x73, 0x54, 0x74, 0x54, 0x20, 0x54, 0x25, 0x54, 0x2d,
    0x54, 0x2e, 0x54, 0x2f, 0x54, 0x33, 0x54, 0x34, 0x54, 0x35,
    0x54, 0x36, 0x54, 0x37, 0x54, 0x38, 0x54, 0x39};
const uint8_t HuffDecoderCommon::table1_446_emit_[36] = {
    0x54, 0x3d, 0x54, 0x41, 0x54, 0x5f, 0x54, 0x62, 0x54, 0x64, 0x54, 0x66,
    0x54, 0x67, 0x54, 0x68, 0x54, 0x6c, 0x54, 0x6d, 0x54, 0x6e, 0x54, 0x70,
    0x54, 0x72, 0x54, 0x75, 0x54, 0x3a, 0x54, 0x42, 0x54, 0x43, 0x54, 0x44};
const uint8_t HuffDecoderCommon::table1_447_emit_[67] = {
    0x54, 0x45, 0x54, 0x46, 0x54, 0x47, 0x54, 0x48, 0x54, 0x49, 0x54, 0x4a,
    0x54, 0x4b, 0x54, 0x4c, 0x54, 0x4d, 0x54, 0x4e, 0x54, 0x4f, 0x54, 0x50,
    0x54, 0x51, 0x54, 0x52, 0x54, 0x53, 0x54, 0x54, 0x55, 0x54, 0x56, 0x54,
    0x57, 0x54, 0x59, 0x54, 0x6a, 0x54, 0x6b, 0x54, 0x71, 0x54, 0x76, 0x54,
    0x77, 0x54, 0x78, 0x54, 0x79, 0x54, 0x7a, 0x54, 0x26, 0x54, 0x2a, 0x54,
    0x2c, 0x54, 0x3b, 0x54, 0x58, 0x54, 0x5a};
const uint16_t HuffDecoderCommon::table1_447_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x07de, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_448_emit_[16] = {
    0x55, 0x30, 0x55, 0x31, 0x55, 0x32, 0x55, 0x61,
    0x55, 0x63, 0x55, 0x65, 0x55, 0x69, 0x55, 0x6f};
const uint8_t HuffDecoderCommon::table1_449_emit_[28] = {
    0x55, 0x73, 0x55, 0x74, 0x55, 0x20, 0x55, 0x25, 0x55, 0x2d,
    0x55, 0x2e, 0x55, 0x2f, 0x55, 0x33, 0x55, 0x34, 0x55, 0x35,
    0x55, 0x36, 0x55, 0x37, 0x55, 0x38, 0x55, 0x39};
const uint8_t HuffDecoderCommon::table1_450_emit_[36] = {
    0x55, 0x3d, 0x55, 0x41, 0x55, 0x5f, 0x55, 0x62, 0x55, 0x64, 0x55, 0x66,
    0x55, 0x67, 0x55, 0x68, 0x55, 0x6c, 0x55, 0x6d, 0x55, 0x6e, 0x55, 0x70,
    0x55, 0x72, 0x55, 0x75, 0x55, 0x3a, 0x55, 0x42, 0x55, 0x43, 0x55, 0x44};
const uint8_t HuffDecoderCommon::table1_451_emit_[67] = {
    0x55, 0x45, 0x55, 0x46, 0x55, 0x47, 0x55, 0x48, 0x55, 0x49, 0x55, 0x4a,
    0x55, 0x4b, 0x55, 0x4c, 0x55, 0x4d, 0x55, 0x4e, 0x55, 0x4f, 0x55, 0x50,
    0x55, 0x51, 0x55, 0x52, 0x55, 0x53, 0x55, 0x54, 0x55, 0x55, 0x56, 0x55,
    0x57, 0x55, 0x59, 0x55, 0x6a, 0x55, 0x6b, 0x55, 0x71, 0x55, 0x76, 0x55,
    0x77, 0x55, 0x78, 0x55, 0x79, 0x55, 0x7a, 0x55, 0x26, 0x55, 0x2a, 0x55,
    0x2c, 0x55, 0x3b, 0x55, 0x58, 0x55, 0x5a};
const uint16_t HuffDecoderCommon::table1_451_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x085e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_452_emit_[16] = {
    0x56, 0x30, 0x56, 0x31, 0x56, 0x32, 0x56, 0x61,
    0x56, 0x63, 0x56, 0x65, 0x56, 0x69, 0x56, 0x6f};
const uint8_t HuffDecoderCommon::table1_453_emit_[28] = {
    0x56, 0x73, 0x56, 0x74, 0x56, 0x20, 0x56, 0x25, 0x56, 0x2d,
    0x56, 0x2e, 0x56, 0x2f, 0x56, 0x33, 0x56, 0x34, 0x56, 0x35,
    0x56, 0x36, 0x56, 0x37, 0x56, 0x38, 0x56, 0x39};
const uint8_t HuffDecoderCommon::table1_454_emit_[36] = {
    0x56, 0x3d, 0x56, 0x41, 0x56, 0x5f, 0x56, 0x62, 0x56, 0x64, 0x56, 0x66,
    0x56, 0x67, 0x56, 0x68, 0x56, 0x6c, 0x56, 0x6d, 0x56, 0x6e, 0x56, 0x70,
    0x56, 0x72, 0x56, 0x75, 0x56, 0x3a, 0x56, 0x42, 0x56, 0x43, 0x56, 0x44};
const uint8_t HuffDecoderCommon::table1_455_emit_[67] = {
    0x56, 0x45, 0x56, 0x46, 0x56, 0x47, 0x56, 0x48, 0x56, 0x49, 0x56, 0x4a,
    0x56, 0x4b, 0x56, 0x4c, 0x56, 0x4d, 0x56, 0x4e, 0x56, 0x4f, 0x56, 0x50,
    0x56, 0x51, 0x56, 0x52, 0x56, 0x53, 0x56, 0x54, 0x56, 0x55, 0x56, 0x56,
    0x57, 0x56, 0x59, 0x56, 0x6a, 0x56, 0x6b, 0x56, 0x71, 0x56, 0x76, 0x56,
    0x77, 0x56, 0x78, 0x56, 0x79, 0x56, 0x7a, 0x56, 0x26, 0x56, 0x2a, 0x56,
    0x2c, 0x56, 0x3b, 0x56, 0x58, 0x56, 0x5a};
const uint16_t HuffDecoderCommon::table1_455_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x08de, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_456_emit_[16] = {
    0x57, 0x30, 0x57, 0x31, 0x57, 0x32, 0x57, 0x61,
    0x57, 0x63, 0x57, 0x65, 0x57, 0x69, 0x57, 0x6f};
const uint8_t HuffDecoderCommon::table1_457_emit_[28] = {
    0x57, 0x73, 0x57, 0x74, 0x57, 0x20, 0x57, 0x25, 0x57, 0x2d,
    0x57, 0x2e, 0x57, 0x2f, 0x57, 0x33, 0x57, 0x34, 0x57, 0x35,
    0x57, 0x36, 0x57, 0x37, 0x57, 0x38, 0x57, 0x39};
const uint8_t HuffDecoderCommon::table1_458_emit_[36] = {
    0x57, 0x3d, 0x57, 0x41, 0x57, 0x5f, 0x57, 0x62, 0x57, 0x64, 0x57, 0x66,
    0x57, 0x67, 0x57, 0x68, 0x57, 0x6c, 0x57, 0x6d, 0x57, 0x6e, 0x57, 0x70,
    0x57, 0x72, 0x57, 0x75, 0x57, 0x3a, 0x57, 0x42, 0x57, 0x43, 0x57, 0x44};
const uint8_t HuffDecoderCommon::table1_459_emit_[67] = {
    0x57, 0x45, 0x57, 0x46, 0x57, 0x47, 0x57, 0x48, 0x57, 0x49, 0x57, 0x4a,
    0x57, 0x4b, 0x57, 0x4c, 0x57, 0x4d, 0x57, 0x4e, 0x57, 0x4f, 0x57, 0x50,
    0x57, 0x51, 0x57, 0x52, 0x57, 0x53, 0x57, 0x54, 0x57, 0x55, 0x57, 0x56,
    0x57, 0x57, 0x59, 0x57, 0x6a, 0x57, 0x6b, 0x57, 0x71, 0x57, 0x76, 0x57,
    0x77, 0x57, 0x78, 0x57, 0x79, 0x57, 0x7a, 0x57, 0x26, 0x57, 0x2a, 0x57,
    0x2c, 0x57, 0x3b, 0x57, 0x58, 0x57, 0x5a};
const uint16_t HuffDecoderCommon::table1_459_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x095e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_460_emit_[16] = {
    0x59, 0x30, 0x59, 0x31, 0x59, 0x32, 0x59, 0x61,
    0x59, 0x63, 0x59, 0x65, 0x59, 0x69, 0x59, 0x6f};
const uint8_t HuffDecoderCommon::table1_461_emit_[28] = {
    0x59, 0x73, 0x59, 0x74, 0x59, 0x20, 0x59, 0x25, 0x59, 0x2d,
    0x59, 0x2e, 0x59, 0x2f, 0x59, 0x33, 0x59, 0x34, 0x59, 0x35,
    0x59, 0x36, 0x59, 0x37, 0x59, 0x38, 0x59, 0x39};
const uint8_t HuffDecoderCommon::table1_462_emit_[36] = {
    0x59, 0x3d, 0x59, 0x41, 0x59, 0x5f, 0x59, 0x62, 0x59, 0x64, 0x59, 0x66,
    0x59, 0x67, 0x59, 0x68, 0x59, 0x6c, 0x59, 0x6d, 0x59, 0x6e, 0x59, 0x70,
    0x59, 0x72, 0x59, 0x75, 0x59, 0x3a, 0x59, 0x42, 0x59, 0x43, 0x59, 0x44};
const uint8_t HuffDecoderCommon::table1_463_emit_[67] = {
    0x59, 0x45, 0x59, 0x46, 0x59, 0x47, 0x59, 0x48, 0x59, 0x49, 0x59, 0x4a,
    0x59, 0x4b, 0x59, 0x4c, 0x59, 0x4d, 0x59, 0x4e, 0x59, 0x4f, 0x59, 0x50,
    0x59, 0x51, 0x59, 0x52, 0x59, 0x53, 0x59, 0x54, 0x59, 0x55, 0x59, 0x56,
    0x59, 0x57, 0x59, 0x59, 0x6a, 0x59, 0x6b, 0x59, 0x71, 0x59, 0x76, 0x59,
    0x77, 0x59, 0x78, 0x59, 0x79, 0x59, 0x7a, 0x59, 0x26, 0x59, 0x2a, 0x59,
    0x2c, 0x59, 0x3b, 0x59, 0x58, 0x59, 0x5a};
const uint16_t HuffDecoderCommon::table1_463_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x09de, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_464_emit_[16] = {
    0x6a, 0x30, 0x6a, 0x31, 0x6a, 0x32, 0x6a, 0x61,
    0x6a, 0x63, 0x6a, 0x65, 0x6a, 0x69, 0x6a, 0x6f};
const uint8_t HuffDecoderCommon::table1_465_emit_[28] = {
    0x6a, 0x73, 0x6a, 0x74, 0x6a, 0x20, 0x6a, 0x25, 0x6a, 0x2d,
    0x6a, 0x2e, 0x6a, 0x2f, 0x6a, 0x33, 0x6a, 0x34, 0x6a, 0x35,
    0x6a, 0x36, 0x6a, 0x37, 0x6a, 0x38, 0x6a, 0x39};
const uint8_t HuffDecoderCommon::table1_466_emit_[36] = {
    0x6a, 0x3d, 0x6a, 0x41, 0x6a, 0x5f, 0x6a, 0x62, 0x6a, 0x64, 0x6a, 0x66,
    0x6a, 0x67, 0x6a, 0x68, 0x6a, 0x6c, 0x6a, 0x6d, 0x6a, 0x6e, 0x6a, 0x70,
    0x6a, 0x72, 0x6a, 0x75, 0x6a, 0x3a, 0x6a, 0x42, 0x6a, 0x43, 0x6a, 0x44};
const uint8_t HuffDecoderCommon::table1_467_emit_[67] = {
    0x6a, 0x45, 0x6a, 0x46, 0x6a, 0x47, 0x6a, 0x48, 0x6a, 0x49, 0x6a, 0x4a,
    0x6a, 0x4b, 0x6a, 0x4c, 0x6a, 0x4d, 0x6a, 0x4e, 0x6a, 0x4f, 0x6a, 0x50,
    0x6a, 0x51, 0x6a, 0x52, 0x6a, 0x53, 0x6a, 0x54, 0x6a, 0x55, 0x6a, 0x56,
    0x6a, 0x57, 0x6a, 0x59, 0x6a, 0x6a, 0x6b, 0x6a, 0x71, 0x6a, 0x76, 0x6a,
    0x77, 0x6a, 0x78, 0x6a, 0x79, 0x6a, 0x7a, 0x6a, 0x26, 0x6a, 0x2a, 0x6a,
    0x2c, 0x6a, 0x3b, 0x6a, 0x58, 0x6a, 0x5a};
const uint16_t HuffDecoderCommon::table1_467_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a5e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_468_emit_[16] = {
    0x6b, 0x30, 0x6b, 0x31, 0x6b, 0x32, 0x6b, 0x61,
    0x6b, 0x63, 0x6b, 0x65, 0x6b, 0x69, 0x6b, 0x6f};
const uint8_t HuffDecoderCommon::table1_469_emit_[28] = {
    0x6b, 0x73, 0x6b, 0x74, 0x6b, 0x20, 0x6b, 0x25, 0x6b, 0x2d,
    0x6b, 0x2e, 0x6b, 0x2f, 0x6b, 0x33, 0x6b, 0x34, 0x6b, 0x35,
    0x6b, 0x36, 0x6b, 0x37, 0x6b, 0x38, 0x6b, 0x39};
const uint8_t HuffDecoderCommon::table1_470_emit_[36] = {
    0x6b, 0x3d, 0x6b, 0x41, 0x6b, 0x5f, 0x6b, 0x62, 0x6b, 0x64, 0x6b, 0x66,
    0x6b, 0x67, 0x6b, 0x68, 0x6b, 0x6c, 0x6b, 0x6d, 0x6b, 0x6e, 0x6b, 0x70,
    0x6b, 0x72, 0x6b, 0x75, 0x6b, 0x3a, 0x6b, 0x42, 0x6b, 0x43, 0x6b, 0x44};
const uint8_t HuffDecoderCommon::table1_471_emit_[67] = {
    0x6b, 0x45, 0x6b, 0x46, 0x6b, 0x47, 0x6b, 0x48, 0x6b, 0x49, 0x6b, 0x4a,
    0x6b, 0x4b, 0x6b, 0x4c, 0x6b, 0x4d, 0x6b, 0x4e, 0x6b, 0x4f, 0x6b, 0x50,
    0x6b, 0x51, 0x6b, 0x52, 0x6b, 0x53, 0x6b, 0x54, 0x6b, 0x55, 0x6b, 0x56,
    0x6b, 0x57, 0x6b, 0x59, 0x6b, 0x6a, 0x6b, 0x6b, 0x71, 0x6b, 0x76, 0x6b,
    0x77, 0x6b, 0x78, 0x6b, 0x79, 0x6b, 0x7a, 0x6b, 0x26, 0x6b, 0x2a, 0x6b,
    0x2c, 0x6b, 0x3b, 0x6b, 0x58, 0x6b, 0x5a};
const uint16_t HuffDecoderCommon::table1_471_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a9e, 0x0ade, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_472_emit_[16] = {
    0x71, 0x30, 0x71, 0x31, 0x71, 0x32, 0x71, 0x61,
    0x71, 0x63, 0x71, 0x65, 0x71, 0x69, 0x71, 0x6f};
const uint8_t HuffDecoderCommon::table1_473_emit_[28] = {
    0x71, 0x73, 0x71, 0x74, 0x71, 0x20, 0x71, 0x25, 0x71, 0x2d,
    0x71, 0x2e, 0x71, 0x2f, 0x71, 0x33, 0x71, 0x34, 0x71, 0x35,
    0x71, 0x36, 0x71, 0x37, 0x71, 0x38, 0x71, 0x39};
const uint8_t HuffDecoderCommon::table1_474_emit_[36] = {
    0x71, 0x3d, 0x71, 0x41, 0x71, 0x5f, 0x71, 0x62, 0x71, 0x64, 0x71, 0x66,
    0x71, 0x67, 0x71, 0x68, 0x71, 0x6c, 0x71, 0x6d, 0x71, 0x6e, 0x71, 0x70,
    0x71, 0x72, 0x71, 0x75, 0x71, 0x3a, 0x71, 0x42, 0x71, 0x43, 0x71, 0x44};
const uint8_t HuffDecoderCommon::table1_475_emit_[67] = {
    0x71, 0x45, 0x71, 0x46, 0x71, 0x47, 0x71, 0x48, 0x71, 0x49, 0x71, 0x4a,
    0x71, 0x4b, 0x71, 0x4c, 0x71, 0x4d, 0x71, 0x4e, 0x71, 0x4f, 0x71, 0x50,
    0x71, 0x51, 0x71, 0x52, 0x71, 0x53, 0x71, 0x54, 0x71, 0x55, 0x71, 0x56,
    0x71, 0x57, 0x71, 0x59, 0x71, 0x6a, 0x71, 0x6b, 0x71, 0x71, 0x76, 0x71,
    0x77, 0x71, 0x78, 0x71, 0x79, 0x71, 0x7a, 0x71, 0x26, 0x71, 0x2a, 0x71,
    0x2c, 0x71, 0x3b, 0x71, 0x58, 0x71, 0x5a};
const uint16_t HuffDecoderCommon::table1_475_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a9e, 0x0b1e, 0x0b5e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_476_emit_[16] = {
    0x76, 0x30, 0x76, 0x31, 0x76, 0x32, 0x76, 0x61,
    0x76, 0x63, 0x76, 0x65, 0x76, 0x69, 0x76, 0x6f};
const uint8_t HuffDecoderCommon::table1_477_emit_[28] = {
    0x76, 0x73, 0x76, 0x74, 0x76, 0x20, 0x76, 0x25, 0x76, 0x2d,
    0x76, 0x2e, 0x76, 0x2f, 0x76, 0x33, 0x76, 0x34, 0x76, 0x35,
    0x76, 0x36, 0x76, 0x37, 0x76, 0x38, 0x76, 0x39};
const uint8_t HuffDecoderCommon::table1_478_emit_[36] = {
    0x76, 0x3d, 0x76, 0x41, 0x76, 0x5f, 0x76, 0x62, 0x76, 0x64, 0x76, 0x66,
    0x76, 0x67, 0x76, 0x68, 0x76, 0x6c, 0x76, 0x6d, 0x76, 0x6e, 0x76, 0x70,
    0x76, 0x72, 0x76, 0x75, 0x76, 0x3a, 0x76, 0x42, 0x76, 0x43, 0x76, 0x44};
const uint8_t HuffDecoderCommon::table1_479_emit_[67] = {
    0x76, 0x45, 0x76, 0x46, 0x76, 0x47, 0x76, 0x48, 0x76, 0x49, 0x76, 0x4a,
    0x76, 0x4b, 0x76, 0x4c, 0x76, 0x4d, 0x76, 0x4e, 0x76, 0x4f, 0x76, 0x50,
    0x76, 0x51, 0x76, 0x52, 0x76, 0x53, 0x76, 0x54, 0x76, 0x55, 0x76, 0x56,
    0x76, 0x57, 0x76, 0x59, 0x76, 0x6a, 0x76, 0x6b, 0x76, 0x71, 0x76, 0x76,
    0x77, 0x76, 0x78, 0x76, 0x79, 0x76, 0x7a, 0x76, 0x26, 0x76, 0x2a, 0x76,
    0x2c, 0x76, 0x3b, 0x76, 0x58, 0x76, 0x5a};
const uint16_t HuffDecoderCommon::table1_479_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a9e, 0x0b1e, 0x0b9e, 0x0bde, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_480_emit_[16] = {
    0x77, 0x30, 0x77, 0x31, 0x77, 0x32, 0x77, 0x61,
    0x77, 0x63, 0x77, 0x65, 0x77, 0x69, 0x77, 0x6f};
const uint8_t HuffDecoderCommon::table1_481_emit_[28] = {
    0x77, 0x73, 0x77, 0x74, 0x77, 0x20, 0x77, 0x25, 0x77, 0x2d,
    0x77, 0x2e, 0x77, 0x2f, 0x77, 0x33, 0x77, 0x34, 0x77, 0x35,
    0x77, 0x36, 0x77, 0x37, 0x77, 0x38, 0x77, 0x39};
const uint8_t HuffDecoderCommon::table1_482_emit_[36] = {
    0x77, 0x3d, 0x77, 0x41, 0x77, 0x5f, 0x77, 0x62, 0x77, 0x64, 0x77, 0x66,
    0x77, 0x67, 0x77, 0x68, 0x77, 0x6c, 0x77, 0x6d, 0x77, 0x6e, 0x77, 0x70,
    0x77, 0x72, 0x77, 0x75, 0x77, 0x3a, 0x77, 0x42, 0x77, 0x43, 0x77, 0x44};
const uint8_t HuffDecoderCommon::table1_483_emit_[67] = {
    0x77, 0x45, 0x77, 0x46, 0x77, 0x47, 0x77, 0x48, 0x77, 0x49, 0x77, 0x4a,
    0x77, 0x4b, 0x77, 0x4c, 0x77, 0x4d, 0x77, 0x4e, 0x77, 0x4f, 0x77, 0x50,
    0x77, 0x51, 0x77, 0x52, 0x77, 0x53, 0x77, 0x54, 0x77, 0x55, 0x77, 0x56,
    0x77, 0x57, 0x77, 0x59, 0x77, 0x6a, 0x77, 0x6b, 0x77, 0x71, 0x77, 0x76,
    0x77, 0x77, 0x78, 0x77, 0x79, 0x77, 0x7a, 0x77, 0x26, 0x77, 0x2a, 0x77,
    0x2c, 0x77, 0x3b, 0x77, 0x58, 0x77, 0x5a};
const uint16_t HuffDecoderCommon::table1_483_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a9e, 0x0b1e, 0x0b9e, 0x0c1e, 0x0c5e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_484_emit_[16] = {
    0x78, 0x30, 0x78, 0x31, 0x78, 0x32, 0x78, 0x61,
    0x78, 0x63, 0x78, 0x65, 0x78, 0x69, 0x78, 0x6f};
const uint8_t HuffDecoderCommon::table1_485_emit_[28] = {
    0x78, 0x73, 0x78, 0x74, 0x78, 0x20, 0x78, 0x25, 0x78, 0x2d,
    0x78, 0x2e, 0x78, 0x2f, 0x78, 0x33, 0x78, 0x34, 0x78, 0x35,
    0x78, 0x36, 0x78, 0x37, 0x78, 0x38, 0x78, 0x39};
const uint8_t HuffDecoderCommon::table1_486_emit_[36] = {
    0x78, 0x3d, 0x78, 0x41, 0x78, 0x5f, 0x78, 0x62, 0x78, 0x64, 0x78, 0x66,
    0x78, 0x67, 0x78, 0x68, 0x78, 0x6c, 0x78, 0x6d, 0x78, 0x6e, 0x78, 0x70,
    0x78, 0x72, 0x78, 0x75, 0x78, 0x3a, 0x78, 0x42, 0x78, 0x43, 0x78, 0x44};
const uint8_t HuffDecoderCommon::table1_487_emit_[67] = {
    0x78, 0x45, 0x78, 0x46, 0x78, 0x47, 0x78, 0x48, 0x78, 0x49, 0x78, 0x4a,
    0x78, 0x4b, 0x78, 0x4c, 0x78, 0x4d, 0x78, 0x4e, 0x78, 0x4f, 0x78, 0x50,
    0x78, 0x51, 0x78, 0x52, 0x78, 0x53, 0x78, 0x54, 0x78, 0x55, 0x78, 0x56,
    0x78, 0x57, 0x78, 0x59, 0x78, 0x6a, 0x78, 0x6b, 0x78, 0x71, 0x78, 0x76,
    0x78, 0x77, 0x78, 0x78, 0x79, 0x78, 0x7a, 0x78, 0x26, 0x78, 0x2a, 0x78,
    0x2c, 0x78, 0x3b, 0x78, 0x58, 0x78, 0x5a};
const uint16_t HuffDecoderCommon::table1_487_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a9e, 0x0b1e, 0x0b9e, 0x0c1e, 0x0c9e, 0x0cde,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_488_emit_[16] = {
    0x79, 0x30, 0x79, 0x31, 0x79, 0x32, 0x79, 0x61,
    0x79, 0x63, 0x79, 0x65, 0x79, 0x69, 0x79, 0x6f};
const uint8_t HuffDecoderCommon::table1_489_emit_[28] = {
    0x79, 0x73, 0x79, 0x74, 0x79, 0x20, 0x79, 0x25, 0x79, 0x2d,
    0x79, 0x2e, 0x79, 0x2f, 0x79, 0x33, 0x79, 0x34, 0x79, 0x35,
    0x79, 0x36, 0x79, 0x37, 0x79, 0x38, 0x79, 0x39};
const uint8_t HuffDecoderCommon::table1_490_emit_[36] = {
    0x79, 0x3d, 0x79, 0x41, 0x79, 0x5f, 0x79, 0x62, 0x79, 0x64, 0x79, 0x66,
    0x79, 0x67, 0x79, 0x68, 0x79, 0x6c, 0x79, 0x6d, 0x79, 0x6e, 0x79, 0x70,
    0x79, 0x72, 0x79, 0x75, 0x79, 0x3a, 0x79, 0x42, 0x79, 0x43, 0x79, 0x44};
const uint8_t HuffDecoderCommon::table1_491_emit_[67] = {
    0x79, 0x45, 0x79, 0x46, 0x79, 0x47, 0x79, 0x48, 0x79, 0x49, 0x79, 0x4a,
    0x79, 0x4b, 0x79, 0x4c, 0x79, 0x4d, 0x79, 0x4e, 0x79, 0x4f, 0x79, 0x50,
    0x79, 0x51, 0x79, 0x52, 0x79, 0x53, 0x79, 0x54, 0x79, 0x55, 0x79, 0x56,
    0x79, 0x57, 0x79, 0x59, 0x79, 0x6a, 0x79, 0x6b, 0x79, 0x71, 0x79, 0x76,
    0x79, 0x77, 0x79, 0x78, 0x79, 0x79, 0x7a, 0x79, 0x26, 0x79, 0x2a, 0x79,
    0x2c, 0x79, 0x3b, 0x79, 0x58, 0x79, 0x5a};
const uint16_t HuffDecoderCommon::table1_491_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a9e, 0x0b1e, 0x0b9e, 0x0c1e, 0x0c9e, 0x0d1e,
    0x0d5e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_492_emit_[16] = {
    0x7a, 0x30, 0x7a, 0x31, 0x7a, 0x32, 0x7a, 0x61,
    0x7a, 0x63, 0x7a, 0x65, 0x7a, 0x69, 0x7a, 0x6f};
const uint8_t HuffDecoderCommon::table1_493_emit_[28] = {
    0x7a, 0x73, 0x7a, 0x74, 0x7a, 0x20, 0x7a, 0x25, 0x7a, 0x2d,
    0x7a, 0x2e, 0x7a, 0x2f, 0x7a, 0x33, 0x7a, 0x34, 0x7a, 0x35,
    0x7a, 0x36, 0x7a, 0x37, 0x7a, 0x38, 0x7a, 0x39};
const uint8_t HuffDecoderCommon::table1_494_emit_[36] = {
    0x7a, 0x3d, 0x7a, 0x41, 0x7a, 0x5f, 0x7a, 0x62, 0x7a, 0x64, 0x7a, 0x66,
    0x7a, 0x67, 0x7a, 0x68, 0x7a, 0x6c, 0x7a, 0x6d, 0x7a, 0x6e, 0x7a, 0x70,
    0x7a, 0x72, 0x7a, 0x75, 0x7a, 0x3a, 0x7a, 0x42, 0x7a, 0x43, 0x7a, 0x44};
const uint8_t HuffDecoderCommon::table1_495_emit_[67] = {
    0x7a, 0x45, 0x7a, 0x46, 0x7a, 0x47, 0x7a, 0x48, 0x7a, 0x49, 0x7a, 0x4a,
    0x7a, 0x4b, 0x7a, 0x4c, 0x7a, 0x4d, 0x7a, 0x4e, 0x7a, 0x4f, 0x7a, 0x50,
    0x7a, 0x51, 0x7a, 0x52, 0x7a, 0x53, 0x7a, 0x54, 0x7a, 0x55, 0x7a, 0x56,
    0x7a, 0x57, 0x7a, 0x59, 0x7a, 0x6a, 0x7a, 0x6b, 0x7a, 0x71, 0x7a, 0x76,
    0x7a, 0x77, 0x7a, 0x78, 0x7a, 0x79, 0x7a, 0x7a, 0x26, 0x7a, 0x2a, 0x7a,
    0x2c, 0x7a, 0x3b, 0x7a, 0x58, 0x7a, 0x5a};
const uint16_t HuffDecoderCommon::table1_495_inner_[35] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e, 0x041e,
    0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e, 0x081e, 0x089e,
    0x091e, 0x099e, 0x0a1e, 0x0a9e, 0x0b1e, 0x0b9e, 0x0c1e, 0x0c9e, 0x0d1e,
    0x0d9e, 0x0ddf, 0x0e5f, 0x0edf, 0x0f5f, 0x0fdf, 0x105f, 0x0027};
const uint8_t HuffDecoderCommon::table1_496_emit_[44] = {
    0x26, 0x30, 0x26, 0x31, 0x26, 0x32, 0x26, 0x61, 0x26, 0x63, 0x26,
    0x65, 0x26, 0x69, 0x26, 0x6f, 0x26, 0x73, 0x26, 0x74, 0x26, 0x20,
    0x26, 0x25, 0x26, 0x2d, 0x26, 0x2e, 0x26, 0x2f, 0x26, 0x33, 0x26,
    0x34, 0x26, 0x35, 0x26, 0x36, 0x26, 0x37, 0x26, 0x38, 0x26, 0x39};
const uint16_t HuffDecoderCommon::table1_496_inner_[22] = {
    0x001d, 0x009d, 0x011d, 0x019d, 0x021d, 0x029d, 0x031d, 0x039d,
    0x041d, 0x049d, 0x051e, 0x059e, 0x061e, 0x069e, 0x071e, 0x079e,
    0x081e, 0x089e, 0x091e, 0x099e, 0x0a1e, 0x0a9e};
const uint8_t HuffDecoderCommon::table1_496_outer_[64] = {
    0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
    4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
    8,  8,  8,  8,  9,  9,  9,  9,  10, 10, 11, 11, 12, 12, 13, 13,
    14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21};
const uint8_t HuffDecoderCommon::table1_497_emit_[92] = {
    0x26, 0x3d, 0x26, 0x41, 0x26, 0x5f, 0x26, 0x62, 0x26, 0x64, 0x26, 0x66,
    0x26, 0x67, 0x26, 0x68, 0x26, 0x6c, 0x26, 0x6d, 0x26, 0x6e, 0x26, 0x70,
    0x26, 0x72, 0x26, 0x75, 0x26, 0x3a, 0x26, 0x42, 0x26, 0x43, 0x26, 0x44,
    0x26, 0x45, 0x26, 0x46, 0x26, 0x47, 0x26, 0x48, 0x26, 0x49, 0x26, 0x4a,
    0x26, 0x4b, 0x26, 0x4c, 0x26, 0x4d, 0x26, 0x4e, 0x26, 0x4f, 0x26, 0x50,
    0x26, 0x51, 0x26, 0x52, 0x26, 0x53, 0x26, 0x54, 0x26, 0x55, 0x26, 0x56,
    0x26, 0x57, 0x26, 0x59, 0x26, 0x6a, 0x26, 0x6b, 0x26, 0x71, 0x26, 0x76,
    0x26, 0x77, 0x26, 0x78, 0x26, 0x79, 0x26, 0x7a};
const uint16_t HuffDecoderCommon::table1_497_inner_[47] = {
    0x001e, 0x009e, 0x011e, 0x019e, 0x021e, 0x029e, 0x031e, 0x039e,
    0x041e, 0x049e, 0x051e, 0x059e, 0x061e, 0x069e, 0x071f, 0x079f,
    0x081f, 0x089f, 0x091f, 0x099f, 0x0a1f, 0x0a9f, 0x0b1f, 0x0b9f,
    0x0c1f, 0x0c9f, 0x0d1f, 0x0d9f, 0x0e1f, 0x0e9f, 0x0f1f, 0x0f9f,
    0x101f, 0x109f, 0x111f, 0x119f, 0x121f, 0x129f, 0x131f, 0x139f,
    0x141f, 0x149f, 0x151f, 0x159f, 0x161f, 0x169f, 0x0028};
const uint8_t HuffDecoderCommon::table1_497_outer_[64] = {
    0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,
    8,  8,  9,  9,  10, 10, 11, 11, 12, 12, 13, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
    34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 46, 46, 46};
const uint8_t HuffDecoderCommon::table1_498_emit_[44] = {
    0x2a, 0x30, 0x2a, 0x31, 0x2a, 0x32, 0x2a, 0x61, 0x2a, 0x63, 0x2a,
    0x65, 0x2a, 0x69, 0x2a, 0x6f, 0x2a, 0x73, 0x2a, 0x74, 0x2a, 0x20,
    0x2a, 0x25, 0x2a, 0x2d, 0x2a, 0x2e, 0x2a, 0x2f, 0x2a, 0x33, 0x2a,
    0x34, 0x2a, 0x35, 0x2a, 0x36, 0x2a, 0x37, 0x2a, 0x38, 0x2a, 0x39};
const uint8_t HuffDecoderCommon::table1_499_emit_[92] = {
    0x2a, 0x3d, 0x2a, 0x41, 0x2a, 0x5f, 0x2a, 0x62, 0x2a, 0x64, 0x2a, 0x66,
    0x2a, 0x67, 0x2a, 0x68, 0x2a, 0x6c, 0x2a, 0x6d, 0x2a, 0x6e, 0x2a, 0x70,
    0x2a, 0x72, 0x2a, 0x75, 0x2a, 0x3a, 0x2a, 0x42, 0x2a, 0x43, 0x2a, 0x44,
    0x2a, 0x45, 0x2a, 0x46, 0x2a, 0x47, 0x2a, 0x48, 0x2a, 0x49, 0x2a, 0x4a,
    0x2a, 0x4b, 0x2a, 0x4c, 0x2a, 0x4d, 0x2a, 0x4e, 0x2a, 0x4f, 0x2a, 0x50,
    0x2a, 0x51, 0x2a, 0x52, 0x2a, 0x53, 0x2a, 0x54, 0x2a, 0x55, 0x2a, 0x56,
    0x2a, 0x57, 0x2a, 0x59, 0x2a, 0x6a, 0x2a, 0x6b, 0x2a, 0x71, 0x2a, 0x76,
    0x2a, 0x77, 0x2a, 0x78, 0x2a, 0x79, 0x2a, 0x7a};
const uint8_t HuffDecoderCommon::table1_500_emit_[44] = {
    0x2c, 0x30, 0x2c, 0x31, 0x2c, 0x32, 0x2c, 0x61, 0x2c, 0x63, 0x2c,
    0x65, 0x2c, 0x69, 0x2c, 0x6f, 0x2c, 0x73, 0x2c, 0x74, 0x2c, 0x20,
    0x2c, 0x25, 0x2c, 0x2d, 0x2c, 0x2e, 0x2c, 0x2f, 0x2c, 0x33, 0x2c,
    0x34, 0x2c, 0x35, 0x2c, 0x36, 0x2c, 0x37, 0x2c, 0x38, 0x2c, 0x39};
const uint8_t HuffDecoderCommon::table1_501_emit_[92] = {
    0x2c, 0x3d, 0x2c, 0x41, 0x2c, 0x5f, 0x2c, 0x62, 0x2c, 0x64, 0x2c, 0x66,
    0x2c, 0x67, 0x2c, 0x68, 0x2c, 0x6c, 0x2c, 0x6d, 0x2c, 0x6e, 0x2c, 0x70,
    0x2c, 0x72, 0x2c, 0x75, 0x2c, 0x3a, 0x2c, 0x42, 0x2c, 0x43, 0x2c, 0x44,
    0x2c, 0x45, 0x2c, 0x46, 0x2c, 0x47, 0x2c, 0x48, 0x2c, 0x49, 0x2c, 0x4a,
    0x2c, 0x4b, 0x2c, 0x4c, 0x2c, 0x4d, 0x2c, 0x4e, 0x2c, 0x4f, 0x2c, 0x50,
    0x2c, 0x51, 0x2c, 0x52, 0x2c, 0x53, 0x2c, 0x54, 0x2c, 0x55, 0x2c, 0x56,
    0x2c, 0x57, 0x2c, 0x59, 0x2c, 0x6a, 0x2c, 0x6b, 0x2c, 0x71, 0x2c, 0x76,
    0x2c, 0x77, 0x2c, 0x78, 0x2c, 0x79, 0x2c, 0x7a};
const uint8_t HuffDecoderCommon::table1_502_emit_[44] = {
    0x3b, 0x30, 0x3b, 0x31, 0x3b, 0x32, 0x3b, 0x61, 0x3b, 0x63, 0x3b,
    0x65, 0x3b, 0x69, 0x3b, 0x6f, 0x3b, 0x73, 0x3b, 0x74, 0x3b, 0x20,
    0x3b, 0x25, 0x3b, 0x2d, 0x3b, 0x2e, 0x3b, 0x2f, 0x3b, 0x33, 0x3b,
    0x34, 0x3b, 0x35, 0x3b, 0x36, 0x3b, 0x37, 0x3b, 0x38, 0x3b, 0x39};
const uint8_t HuffDecoderCommon::table1_503_emit_[92] = {
    0x3b, 0x3d, 0x3b, 0x41, 0x3b, 0x5f, 0x3b, 0x62, 0x3b, 0x64, 0x3b, 0x66,
    0x3b, 0x67, 0x3b, 0x68, 0x3b, 0x6c, 0x3b, 0x6d, 0x3b, 0x6e, 0x3b, 0x70,
    0x3b, 0x72, 0x3b, 0x75, 0x3b, 0x3a, 0x3b, 0x42, 0x3b, 0x43, 0x3b, 0x44,
    0x3b, 0x45, 0x3b, 0x46, 0x3b, 0x47, 0x3b, 0x48, 0x3b, 0x49, 0x3b, 0x4a,
    0x3b, 0x4b, 0x3b, 0x4c, 0x3b, 0x4d, 0x3b, 0x4e, 0x3b, 0x4f, 0x3b, 0x50,
    0x3b, 0x51, 0x3b, 0x52, 0x3b, 0x53, 0x3b, 0x54, 0x3b, 0x55, 0x3b, 0x56,
    0x3b, 0x57, 0x3b, 0x59, 0x3b, 0x6a, 0x3b, 0x6b, 0x3b, 0x71, 0x3b, 0x76,
    0x3b, 0x77, 0x3b, 0x78, 0x3b, 0x79, 0x3b, 0x7a};
const uint8_t HuffDecoderCommon::table1_504_emit_[44] = {
    0x58, 0x30, 0x58, 0x31, 0x58, 0x32, 0x58, 0x61, 0x58, 0x63, 0x58,
    0x65, 0x58, 0x69, 0x58, 0x6f, 0x58, 0x73, 0x58, 0x74, 0x58, 0x20,
    0x58, 0x25, 0x58, 0x2d, 0x58, 0x2e, 0x58, 0x2f, 0x58, 0x33, 0x58,
    0x34, 0x58, 0x35, 0x58, 0x36, 0x58, 0x37, 0x58, 0x38, 0x58, 0x39};
const uint8_t HuffDecoderCommon::table1_505_emit_[92] = {
    0x58, 0x3d, 0x58, 0x41, 0x58, 0x5f, 0x58, 0x62, 0x58, 0x64, 0x58, 0x66,
    0x58, 0x67, 0x58, 0x68, 0x58, 0x6c, 0x58, 0x6d, 0x58, 0x6e, 0x58, 0x70,
    0x58, 0x72, 0x58, 0x75, 0x58, 0x3a, 0x58, 0x42, 0x58, 0x43, 0x58, 0x44,
    0x58, 0x45, 0x58, 0x46, 0x58, 0x47, 0x58, 0x48, 0x58, 0x49, 0x58, 0x4a,
    0x58, 0x4b, 0x58, 0x4c, 0x58, 0x4d, 0x58, 0x4e, 0x58, 0x4f, 0x58, 0x50,
    0x58, 0x51, 0x58, 0x52, 0x58, 0x53, 0x58, 0x54, 0x58, 0x55, 0x58, 0x56,
    0x58, 0x57, 0x58, 0x59, 0x58, 0x6a, 0x58, 0x6b, 0x58, 0x71, 0x58, 0x76,
    0x58, 0x77, 0x58, 0x78, 0x58, 0x79, 0x58, 0x7a};
const uint8_t HuffDecoderCommon::table1_506_emit_[44] = {
    0x5a, 0x30, 0x5a, 0x31, 0x5a, 0x32, 0x5a, 0x61, 0x5a, 0x63, 0x5a,
    0x65, 0x5a, 0x69, 0x5a, 0x6f, 0x5a, 0x73, 0x5a, 0x74, 0x5a, 0x20,
    0x5a, 0x25, 0x5a, 0x2d, 0x5a, 0x2e, 0x5a, 0x2f, 0x5a, 0x33, 0x5a,
    0x34, 0x5a, 0x35, 0x5a, 0x36, 0x5a, 0x37, 0x5a, 0x38, 0x5a, 0x39};
const uint8_t HuffDecoderCommon::table1_507_emit_[92] = {
    0x5a, 0x3d, 0x5a, 0x41, 0x5a, 0x5f, 0x5a, 0x62, 0x5a, 0x64, 0x5a, 0x66,
    0x5a, 0x67, 0x5a, 0x68, 0x5a, 0x6c, 0x5a, 0x6d, 0x5a, 0x6e, 0x5a, 0x70,
    0x5a, 0x72, 0x5a, 0x75, 0x5a, 0x3a, 0x5a, 0x42, 0x5a, 0x43, 0x5a, 0x44,
    0x5a, 0x45, 0x5a, 0x46, 0x5a, 0x47, 0x5a, 0x48, 0x5a, 0x49, 0x5a, 0x4a,
    0x5a, 0x4b, 0x5a, 0x4c, 0x5a, 0x4d, 0x5a, 0x4e, 0x5a, 0x4f, 0x5a, 0x50,
    0x5a, 0x51, 0x5a, 0x52, 0x5a, 0x53, 0x5a, 0x54, 0x5a, 0x55, 0x5a, 0x56,
    0x5a, 0x57, 0x5a, 0x59, 0x5a, 0x6a, 0x5a, 0x6b, 0x5a, 0x71, 0x5a, 0x76,
    0x5a, 0x77, 0x5a, 0x78, 0x5a, 0x79, 0x5a, 0x7a};
const uint8_t HuffDecoderCommon::table1_508_emit_[40] = {
    0x21, 0x30, 0x21, 0x31, 0x21, 0x32, 0x21, 0x61, 0x21, 0x63,
    0x21, 0x65, 0x21, 0x69, 0x21, 0x6f, 0x21, 0x73, 0x21, 0x74,
    0x22, 0x30, 0x22, 0x31, 0x22, 0x32, 0x22, 0x61, 0x22, 0x63,
    0x22, 0x65, 0x22, 0x69, 0x22, 0x6f, 0x22, 0x73, 0x22, 0x74};
const uint16_t HuffDecoderCommon::table1_508_inner_[22] = {
    0x001f, 0x009f, 0x011f, 0x019f, 0x021f, 0x029f, 0x031f, 0x039f,
    0x041f, 0x049f, 0x002a, 0x051f, 0x059f, 0x061f, 0x069f, 0x071f,
    0x079f, 0x081f, 0x089f, 0x091f, 0x099f, 0x052a};
const uint8_t HuffDecoderCommon::table1_509_emit_[40] = {
    0x28, 0x30, 0x28, 0x31, 0x28, 0x32, 0x28, 0x61, 0x28, 0x63,
    0x28, 0x65, 0x28, 0x69, 0x28, 0x6f, 0x28, 0x73, 0x28, 0x74,
    0x29, 0x30, 0x29, 0x31, 0x29, 0x32, 0x29, 0x61, 0x29, 0x63,
    0x29, 0x65, 0x29, 0x69, 0x29, 0x6f, 0x29, 0x73, 0x29, 0x74};
const uint8_t HuffDecoderCommon::table1_510_emit_[22] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61, 0x3f, 0x63, 0x3f,
    0x65, 0x3f, 0x69, 0x3f, 0x6f, 0x3f, 0x73, 0x3f, 0x74, 0x27, 0x2b};
const uint16_t HuffDecoderCommon::table1_510_inner_[13] = {
    0x001f, 0x009f, 0x011f, 0x019f, 0x021f, 0x029f, 0x031f,
    0x039f, 0x041f, 0x049f, 0x002a, 0x052b, 0x056b};
const uint8_t HuffDecoderCommon::table1_510_outer_[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const uint8_t HuffDecoderCommon::table1_511_emit_[14] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b,
    0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint16_t HuffDecoderCommon::table1_511_inner_[15] = {
    0x002b, 0x006c, 0x00ac, 0x00ed, 0x012d, 0x016d, 0x01ad, 0x01ed,
    0x022d, 0x026e, 0x02ae, 0x02ef, 0x032f, 0x036f, 0x003f};
const uint8_t HuffDecoderCommon::table1_511_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  1,  1,  1,  1, 1, 1,
    1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4,  4,  4,  4,  5,  5, 5, 5,
    6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 10, 10, 11, 12, 13, 14};
const uint8_t* const HuffDecoderCommon::table1_emit_[512] = {
    table1_0_emit_,   table1_1_emit_,   table1_2_emit_,   table1_3_emit_,
    table1_4_emit_,   table1_5_emit_,   table1_6_emit_,   table1_7_emit_,
    table1_8_emit_,   table1_9_emit_,   table1_10_emit_,  table1_11_emit_,
    table1_12_emit_,  table1_13_emit_,  table1_14_emit_,  table1_15_emit_,
    table1_16_emit_,  table1_17_emit_,  table1_18_emit_,  table1_19_emit_,
    table1_20_emit_,  table1_21_emit_,  table1_22_emit_,  table1_23_emit_,
    table1_24_emit_,  table1_25_emit_,  table1_26_emit_,  table1_27_emit_,
    table1_28_emit_,  table1_29_emit_,  table1_30_emit_,  table1_31_emit_,
    table1_32_emit_,  table1_33_emit_,  table1_34_emit_,  table1_35_emit_,
    table1_36_emit_,  table1_37_emit_,  table1_38_emit_,  table1_39_emit_,
    table1_40_emit_,  table1_41_emit_,  table1_42_emit_,  table1_43_emit_,
    table1_44_emit_,  table1_45_emit_,  table1_46_emit_,  table1_47_emit_,
    table1_48_emit_,  table1_49_emit_,  table1_50_emit_,  table1_51_emit_,
    table1_52_emit_,  table1_53_emit_,  table1_54_emit_,  table1_55_emit_,
    table1_56_emit_,  table1_57_emit_,  table1_58_emit_,  table1_59_emit_,
    table1_60_emit_,  table1_61_emit_,  table1_62_emit_,  table1_63_emit_,
    table1_64_emit_,  table1_65_emit_,  table1_66_emit_,  table1_67_emit_,
    table1_68_emit_,  table1_69_emit_,  table1_70_emit_,  table1_71_emit_,
    table1_72_emit_,  table1_73_emit_,  table1_74_emit_,  table1_75_emit_,
    table1_76_emit_,  table1_77_emit_,  table1_78_emit_,  table1_79_emit_,
    table1_80_emit_,  table1_81_emit_,  table1_82_emit_,  table1_83_emit_,
    table1_84_emit_,  table1_85_emit_,  table1_86_emit_,  table1_87_emit_,
    table1_88_emit_,  table1_89_emit_,  table1_90_emit_,  table1_91_emit_,
    table1_92_emit_,  table1_93_emit_,  table1_94_emit_,  table1_95_emit_,
    table1_96_emit_,  table1_97_emit_,  table1_98_emit_,  table1_99_emit_,
    table1_100_emit_, table1_101_emit_, table1_102_emit_, table1_103_emit_,
    table1_104_emit_, table1_105_emit_, table1_106_emit_, table1_107_emit_,
    table1_108_emit_, table1_109_emit_, table1_110_emit_, table1_111_emit_,
    table1_112_emit_, table1_113_emit_, table1_114_emit_, table1_115_emit_,
    table1_116_emit_, table1_117_emit_, table1_118_emit_, table1_119_emit_,
    table1_120_emit_, table1_121_emit_, table1_122_emit_, table1_123_emit_,
    table1_124_emit_, table1_125_emit_, table1_126_emit_, table1_127_emit_,
    table1_128_emit_, table1_129_emit_, table1_130_emit_, table1_131_emit_,
    table1_132_emit_, table1_133_emit_, table1_134_emit_, table1_135_emit_,
    table1_136_emit_, table1_137_emit_, table1_138_emit_, table1_139_emit_,
    table1_140_emit_, table1_141_emit_, table1_142_emit_, table1_143_emit_,
    table1_144_emit_, table1_145_emit_, table1_146_emit_, table1_147_emit_,
    table1_148_emit_, table1_149_emit_, table1_150_emit_, table1_151_emit_,
    table1_152_emit_, table1_153_emit_, table1_154_emit_, table1_155_emit_,
    table1_156_emit_, table1_157_emit_, table1_158_emit_, table1_159_emit_,
    table1_160_emit_, table1_161_emit_, table1_162_emit_, table1_163_emit_,
    table1_164_emit_, table1_165_emit_, table1_166_emit_, table1_167_emit_,
    table1_168_emit_, table1_169_emit_, table1_170_emit_, table1_171_emit_,
    table1_172_emit_, table1_173_emit_, table1_174_emit_, table1_175_emit_,
    table1_176_emit_, table1_177_emit_, table1_178_emit_, table1_179_emit_,
    table1_180_emit_, table1_181_emit_, table1_182_emit_, table1_183_emit_,
    table1_184_emit_, table1_185_emit_, table1_186_emit_, table1_187_emit_,
    table1_188_emit_, table1_189_emit_, table1_190_emit_, table1_191_emit_,
    table1_192_emit_, table1_193_emit_, table1_194_emit_, table1_195_emit_,
    table1_196_emit_, table1_197_emit_, table1_198_emit_, table1_199_emit_,
    table1_200_emit_, table1_201_emit_, table1_202_emit_, table1_203_emit_,
    table1_204_emit_, table1_205_emit_, table1_206_emit_, table1_207_emit_,
    table1_208_emit_, table1_209_emit_, table1_210_emit_, table1_211_emit_,
    table1_212_emit_, table1_213_emit_, table1_214_emit_, table1_215_emit_,
    table1_216_emit_, table1_217_emit_, table1_218_emit_, table1_219_emit_,
    table1_220_emit_, table1_221_emit_, table1_222_emit_, table1_223_emit_,
    table1_224_emit_, table1_225_emit_, table1_226_emit_, table1_227_emit_,
    table1_228_emit_, table1_229_emit_, table1_230_emit_, table1_231_emit_,
    table1_232_emit_, table1_233_emit_, table1_234_emit_, table1_235_emit_,
    table1_236_emit_, table1_237_emit_, table1_238_emit_, table1_239_emit_,
    table1_240_emit_, table1_241_emit_, table1_242_emit_, table1_243_emit_,
    table1_244_emit_, table1_245_emit_, table1_246_emit_, table1_247_emit_,
    table1_248_emit_, table1_249_emit_, table1_250_emit_, table1_251_emit_,
    table1_252_emit_, table1_253_emit_, table1_254_emit_, table1_255_emit_,
    table1_256_emit_, table1_257_emit_, table1_258_emit_, table1_259_emit_,
    table1_260_emit_, table1_261_emit_, table1_262_emit_, table1_263_emit_,
    table1_264_emit_, table1_265_emit_, table1_266_emit_, table1_267_emit_,
    table1_268_emit_, table1_269_emit_, table1_270_emit_, table1_271_emit_,
    table1_272_emit_, table1_273_emit_, table1_274_emit_, table1_275_emit_,
    table1_276_emit_, table1_277_emit_, table1_278_emit_, table1_279_emit_,
    table1_280_emit_, table1_281_emit_, table1_282_emit_, table1_283_emit_,
    table1_284_emit_, table1_285_emit_, table1_286_emit_, table1_287_emit_,
    table1_288_emit_, table1_289_emit_, table1_290_emit_, table1_291_emit_,
    table1_292_emit_, table1_293_emit_, table1_294_emit_, table1_295_emit_,
    table1_296_emit_, table1_297_emit_, table1_298_emit_, table1_299_emit_,
    table1_300_emit_, table1_301_emit_, table1_302_emit_, table1_303_emit_,
    table1_304_emit_, table1_305_emit_, table1_306_emit_, table1_307_emit_,
    table1_308_emit_, table1_309_emit_, table1_310_emit_, table1_311_emit_,
    table1_312_emit_, table1_313_emit_, table1_314_emit_, table1_315_emit_,
    table1_316_emit_, table1_317_emit_, table1_318_emit_, table1_319_emit_,
    table1_320_emit_, table1_321_emit_, table1_322_emit_, table1_323_emit_,
    table1_324_emit_, table1_325_emit_, table1_326_emit_, table1_327_emit_,
    table1_328_emit_, table1_329_emit_, table1_330_emit_, table1_331_emit_,
    table1_332_emit_, table1_333_emit_, table1_334_emit_, table1_335_emit_,
    table1_336_emit_, table1_337_emit_, table1_338_emit_, table1_339_emit_,
    table1_340_emit_, table1_341_emit_, table1_342_emit_, table1_343_emit_,
    table1_344_emit_, table1_345_emit_, table1_346_emit_, table1_347_emit_,
    table1_348_emit_, table1_349_emit_, table1_350_emit_, table1_351_emit_,
    table1_352_emit_, table1_353_emit_, table1_354_emit_, table1_355_emit_,
    table1_356_emit_, table1_357_emit_, table1_358_emit_, table1_359_emit_,
    table1_360_emit_, table1_361_emit_, table1_362_emit_, table1_363_emit_,
    table1_364_emit_, table1_365_emit_, table1_366_emit_, table1_367_emit_,
    table1_368_emit_, table1_369_emit_, table1_370_emit_, table1_371_emit_,
    table1_372_emit_, table1_373_emit_, table1_374_emit_, table1_375_emit_,
    table1_376_emit_, table1_377_emit_, table1_378_emit_, table1_379_emit_,
    table1_380_emit_, table1_381_emit_, table1_382_emit_, table1_383_emit_,
    table1_384_emit_, table1_385_emit_, table1_386_emit_, table1_387_emit_,
    table1_388_emit_, table1_389_emit_, table1_390_emit_, table1_391_emit_,
    table1_392_emit_, table1_393_emit_, table1_394_emit_, table1_395_emit_,
    table1_396_emit_, table1_397_emit_, table1_398_emit_, table1_399_emit_,
    table1_400_emit_, table1_401_emit_, table1_402_emit_, table1_403_emit_,
    table1_404_emit_, table1_405_emit_, table1_406_emit_, table1_407_emit_,
    table1_408_emit_, table1_409_emit_, table1_410_emit_, table1_411_emit_,
    table1_412_emit_, table1_413_emit_, table1_414_emit_, table1_415_emit_,
    table1_416_emit_, table1_417_emit_, table1_418_emit_, table1_419_emit_,
    table1_420_emit_, table1_421_emit_, table1_422_emit_, table1_423_emit_,
    table1_424_emit_, table1_425_emit_, table1_426_emit_, table1_427_emit_,
    table1_428_emit_, table1_429_emit_, table1_430_emit_, table1_431_emit_,
    table1_432_emit_, table1_433_emit_, table1_434_emit_, table1_435_emit_,
    table1_436_emit_, table1_437_emit_, table1_438_emit_, table1_439_emit_,
    table1_440_emit_, table1_441_emit_, table1_442_emit_, table1_443_emit_,
    table1_444_emit_, table1_445_emit_, table1_446_emit_, table1_447_emit_,
    table1_448_emit_, table1_449_emit_, table1_450_emit_, table1_451_emit_,
    table1_452_emit_, table1_453_emit_, table1_454_emit_, table1_455_emit_,
    table1_456_emit_, table1_457_emit_, table1_458_emit_, table1_459_emit_,
    table1_460_emit_, table1_461_emit_, table1_462_emit_, table1_463_emit_,
    table1_464_emit_, table1_465_emit_, table1_466_emit_, table1_467_emit_,
    table1_468_emit_, table1_469_emit_, table1_470_emit_, table1_471_emit_,
    table1_472_emit_, table1_473_emit_, table1_474_emit_, table1_475_emit_,
    table1_476_emit_, table1_477_emit_, table1_478_emit_, table1_479_emit_,
    table1_480_emit_, table1_481_emit_, table1_482_emit_, table1_483_emit_,
    table1_484_emit_, table1_485_emit_, table1_486_emit_, table1_487_emit_,
    table1_488_emit_, table1_489_emit_, table1_490_emit_, table1_491_emit_,
    table1_492_emit_, table1_493_emit_, table1_494_emit_, table1_495_emit_,
    table1_496_emit_, table1_497_emit_, table1_498_emit_, table1_499_emit_,
    table1_500_emit_, table1_501_emit_, table1_502_emit_, table1_503_emit_,
    table1_504_emit_, table1_505_emit_, table1_506_emit_, table1_507_emit_,
    table1_508_emit_, table1_509_emit_, table1_510_emit_, table1_511_emit_,
};
const uint16_t* const HuffDecoderCommon::table1_inner_[512] = {
    table1_0_inner_,   table1_1_inner_,   table1_1_inner_,   table1_1_inner_,
    table1_1_inner_,   table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_16_inner_,  table1_17_inner_,  table1_17_inner_,  table1_17_inner_,
    table1_17_inner_,  table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_32_inner_,  table1_33_inner_,  table1_32_inner_,  table1_32_inner_,
    table1_32_inner_,  table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_48_inner_,  table1_49_inner_,  table1_48_inner_,  table1_48_inner_,
    table1_48_inner_,  table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_64_inner_,  table1_64_inner_,  table1_66_inner_,  table1_64_inner_,
    table1_64_inner_,  table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_80_inner_,  table1_80_inner_,  table1_82_inner_,  table1_80_inner_,
    table1_80_inner_,  table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_96_inner_,  table1_96_inner_,  table1_96_inner_,  table1_99_inner_,
    table1_96_inner_,  table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_112_inner_, table1_112_inner_, table1_112_inner_, table1_115_inner_,
    table1_112_inner_, table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_128_inner_, table1_128_inner_, table1_128_inner_, table1_128_inner_,
    table1_132_inner_, table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_144_inner_, table1_144_inner_, table1_144_inner_, table1_144_inner_,
    table1_144_inner_, table1_5_inner_,   table1_5_inner_,   table1_5_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_5_inner_,   table1_11_inner_,
    table1_12_inner_,  table1_12_inner_,  table1_12_inner_,  table1_15_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_162_inner_, table1_12_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_170_inner_, table1_12_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_178_inner_, table1_12_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_195_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_203_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_211_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_219_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_227_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_235_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_243_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_195_inner_, table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_203_inner_, table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_211_inner_, table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_219_inner_, table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_227_inner_, table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_235_inner_, table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_243_inner_, table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_165_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_325_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_333_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_341_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_349_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_357_inner_, table1_166_inner_, table1_167_inner_,
    table1_5_inner_,   table1_5_inner_,   table1_11_inner_,  table1_12_inner_,
    table1_12_inner_,  table1_365_inner_, table1_166_inner_, table1_167_inner_,
    table1_12_inner_,  table1_369_inner_, table1_370_inner_, table1_371_inner_,
    table1_12_inner_,  table1_369_inner_, table1_374_inner_, table1_371_inner_,
    table1_12_inner_,  table1_369_inner_, table1_378_inner_, table1_371_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_371_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_387_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_391_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_395_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_399_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_403_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_407_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_411_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_415_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_419_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_423_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_427_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_431_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_435_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_439_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_443_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_447_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_451_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_455_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_459_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_463_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_467_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_471_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_475_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_479_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_483_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_487_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_491_inner_,
    table1_12_inner_,  table1_369_inner_, table1_382_inner_, table1_495_inner_,
    table1_496_inner_, table1_497_inner_, table1_496_inner_, table1_497_inner_,
    table1_496_inner_, table1_497_inner_, table1_496_inner_, table1_497_inner_,
    table1_496_inner_, table1_497_inner_, table1_496_inner_, table1_497_inner_,
    table1_508_inner_, table1_508_inner_, table1_510_inner_, table1_511_inner_,
};
const uint8_t* const HuffDecoderCommon::table1_outer_[512] = {
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_0_outer_,   table1_0_outer_,
    table1_0_outer_,   table1_5_outer_,   table1_5_outer_,   table1_5_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_5_outer_,   table1_11_outer_,
    table1_12_outer_,  table1_12_outer_,  table1_12_outer_,  table1_15_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_5_outer_,   table1_5_outer_,   table1_11_outer_,  table1_12_outer_,
    table1_12_outer_,  table1_165_outer_, table1_166_outer_, table1_167_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_12_outer_,  table1_369_outer_, table1_370_outer_, table1_371_outer_,
    table1_496_outer_, table1_497_outer_, table1_496_outer_, table1_497_outer_,
    table1_496_outer_, table1_497_outer_, table1_496_outer_, table1_497_outer_,
    table1_496_outer_, table1_497_outer_, table1_496_outer_, table1_497_outer_,
    table1_0_outer_,   table1_0_outer_,   table1_510_outer_, table1_511_outer_,
};
const uint8_t HuffDecoderCommon::table13_0_inner_[5] = {0x00, 0x04, 0x08, 0x01,
                                                        0x02};
const uint8_t HuffDecoderCommon::table14_0_emit_[11] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2};
const uint8_t HuffDecoderCommon::table14_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x0d, 0x11, 0x15, 0x19, 0x1d,
    0x21, 0x25, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table15_0_emit_[24] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99,
    0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6};
const uint8_t HuffDecoderCommon::table15_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x0d, 0x00, 0x11, 0x00, 0x15, 0x00, 0x19, 0x00, 0x1d,
    0x00, 0x21, 0x00, 0x25, 0x00, 0x29, 0x2d, 0x31, 0x35, 0x39, 0x3d,
    0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59, 0x5d, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table16_0_emit_[50] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0,
    0xe2, 0x99, 0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8,
    0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85, 0x86, 0x88, 0x92,
    0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad, 0xb2, 0xb5,
    0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9};
const uint8_t HuffDecoderCommon::table16_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x2d, 0x00, 0x31,
    0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00, 0x45, 0x00, 0x49,
    0x00, 0x4d, 0x00, 0x51, 0x00, 0x55, 0x00, 0x59, 0x00, 0x5d, 0x61, 0x65,
    0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95,
    0x99, 0x9d, 0xa1, 0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0xb9, 0xbd, 0xc1, 0xc5,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table17_0_emit_[15] = {
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8,
    0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint8_t HuffDecoderCommon::table17_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31,
    0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x39};
const uint8_t HuffDecoderCommon::table17_1_emit_[64] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84,
    0x85, 0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa,
    0xad, 0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4,
    0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93,
    0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae,
    0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef};
const uint8_t HuffDecoderCommon::table17_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x25, 0x00, 0x29, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39,
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51,
    0x00, 0x55, 0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69,
    0x00, 0x6d, 0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81,
    0x00, 0x85, 0x00, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1, 0xa5, 0xa9,
    0xad, 0xb1, 0xb5, 0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0xd1, 0xd5, 0xd9,
    0xdd, 0xe1, 0xe5, 0xe9, 0xed, 0xf1, 0xf5, 0xf9, 0xfd, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table17_emit_[2] = {
    table17_0_emit_,
    table17_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table17_ops_[2] = {
    table17_0_ops_,
    table17_1_ops_,
};
const uint8_t HuffDecoderCommon::table18_0_emit_[62] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c,
    0x65, 0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0xc3, 0x30,
    0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3, 0x65, 0xc3,
    0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xd0, 0x30, 0xd0, 0x31,
    0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0, 0x65, 0xd0, 0x69, 0xd0,
    0x6f, 0xd0, 0x73, 0xd0, 0x74, 0x80, 0x82};
const uint8_t HuffDecoderCommon::table18_0_ops_[128] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x50, 0x58, 0x60, 0x68,
    0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x52, 0xa0, 0xa8, 0xb0, 0xb8, 0xc0, 0xc8, 0xd0, 0xd8,
    0xe0, 0xe8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xa2,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0xf2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xf6};
const uint8_t HuffDecoderCommon::table18_1_emit_[10] = {
    0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99, 0xa1, 0xa7, 0xac};
const uint8_t HuffDecoderCommon::table18_1_ops_[128] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26};
const uint8_t HuffDecoderCommon::table18_2_emit_[23] = {
    0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85,
    0x86, 0x88, 0x92, 0x9a, 0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad};
const uint8_t HuffDecoderCommon::table18_2_ops_[128] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22,
    0x01, 0x01, 0x01, 0x26, 0x01, 0x01, 0x01, 0x2a, 0x01, 0x01, 0x01, 0x2e,
    0x01, 0x01, 0x01, 0x32, 0x01, 0x01, 0x01, 0x36, 0x01, 0x01, 0x01, 0x3a,
    0x01, 0x01, 0x01, 0x3e, 0x01, 0x01, 0x01, 0x42, 0x01, 0x01, 0x01, 0x46,
    0x01, 0x01, 0x01, 0x4a, 0x01, 0x01, 0x01, 0x4e, 0x01, 0x01, 0x01, 0x52,
    0x01, 0x01, 0x01, 0x56, 0x01, 0x01, 0x01, 0x5a};
const uint8_t HuffDecoderCommon::table18_3_emit_[53] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8,
    0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f, 0x93, 0x95,
    0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8, 0xae, 0xaf,
    0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90,
    0x91, 0x94, 0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed};
const uint8_t HuffDecoderCommon::table18_3_ops_[128] = {
    0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x0a,
    0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x16,
    0x01, 0x01, 0x01, 0x1a, 0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01, 0x22,
    0x01, 0x01, 0x01, 0x26, 0x01, 0x01, 0x01, 0x2a, 0x01, 0x01, 0x01, 0x2e,
    0x01, 0x32, 0x01, 0x36, 0x01, 0x3a, 0x01, 0x3e, 0x01, 0x42, 0x01, 0x46,
    0x01, 0x4a, 0x01, 0x4e, 0x01, 0x52, 0x01, 0x56, 0x01, 0x5a, 0x01, 0x5e,
    0x01, 0x62, 0x01, 0x66, 0x01, 0x6a, 0x01, 0x6e, 0x01, 0x72, 0x01, 0x76,
    0x01, 0x7a, 0x01, 0x7e, 0x01, 0x82, 0x01, 0x86, 0x01, 0x8a, 0x01, 0x8e,
    0x01, 0x92, 0x01, 0x96, 0x01, 0x9a, 0x01, 0x9e, 0x01, 0xa2, 0xa6, 0xaa,
    0xae, 0xb2, 0xb6, 0xba, 0xbe, 0xc2, 0xc6, 0xca, 0xce, 0xd2, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03};
const uint8_t* const HuffDecoderCommon::table18_emit_[4] = {
    table18_0_emit_,
    table18_1_emit_,
    table18_2_emit_,
    table18_3_emit_,
};
const uint8_t* const HuffDecoderCommon::table18_ops_[4] = {
    table18_0_ops_,
    table18_1_ops_,
    table18_2_ops_,
    table18_3_ops_,
};
const uint8_t HuffDecoderCommon::table19_0_emit_[72] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c, 0x65,
    0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20, 0x5c, 0x25,
    0x5c, 0x2d, 0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c, 0x34, 0x5c, 0x35,
    0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39, 0x5c, 0x3d, 0x5c, 0x41,
    0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66, 0x5c, 0x67, 0x5c, 0x68,
    0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70, 0x5c, 0x72, 0x5c, 0x75};
const uint16_t HuffDecoderCommon::table19_0_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table19_1_emit_[72] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3, 0x65,
    0xc3, 0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20, 0xc3, 0x25,
    0xc3, 0x2d, 0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3, 0x34, 0xc3, 0x35,
    0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39, 0xc3, 0x3d, 0xc3, 0x41,
    0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66, 0xc3, 0x67, 0xc3, 0x68,
    0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70, 0xc3, 0x72, 0xc3, 0x75};
const uint8_t HuffDecoderCommon::table19_2_emit_[72] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0, 0x65,
    0xd0, 0x69, 0xd0, 0x6f, 0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20, 0xd0, 0x25,
    0xd0, 0x2d, 0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0, 0x34, 0xd0, 0x35,
    0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39, 0xd0, 0x3d, 0xd0, 0x41,
    0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66, 0xd0, 0x67, 0xd0, 0x68,
    0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70, 0xd0, 0x72, 0xd0, 0x75};
const uint8_t HuffDecoderCommon::table19_3_emit_[40] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63,
    0x80, 0x65, 0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74,
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63,
    0x82, 0x65, 0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74};
const uint16_t HuffDecoderCommon::table19_3_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table19_4_emit_[40] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63,
    0x83, 0x65, 0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74,
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63,
    0xa2, 0x65, 0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74};
const uint8_t HuffDecoderCommon::table19_5_emit_[40] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63,
    0xb8, 0x65, 0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74,
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63,
    0xc2, 0x65, 0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74};
const uint8_t HuffDecoderCommon::table19_6_emit_[40] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63,
    0xe0, 0x65, 0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74,
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63,
    0xe2, 0x65, 0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74};
const uint8_t HuffDecoderCommon::table19_7_emit_[4] = {0x99, 0xa1, 0xa7, 0xac};
const uint16_t HuffDecoderCommon::table19_7_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e};
const uint8_t HuffDecoderCommon::table19_8_emit_[4] = {0xb0, 0xb1, 0xb3, 0xd1};
const uint8_t HuffDecoderCommon::table19_9_emit_[4] = {0xd8, 0xd9, 0xe3, 0xe5};
const uint8_t HuffDecoderCommon::table19_10_emit_[7] = {0xe6, 0x81, 0x84, 0x85,
                                                        0x86, 0x88, 0x92};
const uint16_t HuffDecoderCommon::table19_10_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001a};
const uint8_t HuffDecoderCommon::table19_11_emit_[8] = {0x9a, 0x9c, 0xa0, 0xa3,
                                                        0xa4, 0xa9, 0xaa, 0xad};
const uint16_t HuffDecoderCommon::table19_11_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001e};
const uint8_t HuffDecoderCommon::table19_12_emit_[8] = {0xb2, 0xb5, 0xb9, 0xba,
                                                        0xbb, 0xbd, 0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table19_13_emit_[12] = {
    0xc6, 0xe4, 0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f};
const uint16_t HuffDecoderCommon::table19_13_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x001e,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0026,
    0x0000, 0x0000, 0x0000, 0x002a, 0x0000, 0x0000, 0x0000, 0x002e};
const uint8_t HuffDecoderCommon::table19_14_emit_[16] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e,
    0xa5, 0xa6, 0xa8, 0xae, 0xaf, 0xb4, 0xb6, 0xb7};
const uint16_t HuffDecoderCommon::table19_14_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x001e,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0026,
    0x0000, 0x0000, 0x0000, 0x002a, 0x0000, 0x0000, 0x0000, 0x002e,
    0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0036,
    0x0000, 0x0000, 0x0000, 0x003a, 0x0000, 0x0000, 0x0000, 0x003e};
const uint8_t HuffDecoderCommon::table19_15_emit_[21] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f,
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table19_15_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0016, 0x0000, 0x001a,
    0x0000, 0x001e, 0x0000, 0x0022, 0x0000, 0x0026, 0x0000, 0x002a,
    0x0000, 0x002e, 0x0000, 0x0032, 0x0000, 0x0036, 0x0000, 0x003a,
    0x0000, 0x003e, 0x0000, 0x0042, 0x0046, 0x004a, 0x004e, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table19_emit_[16] = {
    table19_0_emit_,  table19_1_emit_,  table19_2_emit_,  table19_3_emit_,
    table19_4_emit_,  table19_5_emit_,  table19_6_emit_,  table19_7_emit_,
    table19_8_emit_,  table19_9_emit_,  table19_10_emit_, table19_11_emit_,
    table19_12_emit_, table19_13_emit_, table19_14_emit_, table19_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table19_ops_[16] = {
    table19_0_ops_,  table19_0_ops_,  table19_0_ops_,  table19_3_ops_,
    table19_3_ops_,  table19_3_ops_,  table19_3_ops_,  table19_7_ops_,
    table19_7_ops_,  table19_7_ops_,  table19_10_ops_, table19_11_ops_,
    table19_11_ops_, table19_13_ops_, table19_14_ops_, table19_15_ops_,
};
const uint8_t HuffDecoderCommon::table20_0_emit_[44] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61, 0x5c, 0x63, 0x5c,
    0x65, 0x5c, 0x69, 0x5c, 0x6f, 0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20,
    0x5c, 0x25, 0x5c, 0x2d, 0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c,
    0x34, 0x5c, 0x35, 0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39};
const uint16_t HuffDecoderCommon::table20_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0051, 0x0000, 0x0059, 0x0000, 0x0061, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089,
    0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table20_1_emit_[92] = {
    0x5c, 0x3d, 0x5c, 0x41, 0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66,
    0x5c, 0x67, 0x5c, 0x68, 0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70,
    0x5c, 0x72, 0x5c, 0x75, 0x5c, 0x3a, 0x5c, 0x42, 0x5c, 0x43, 0x5c, 0x44,
    0x5c, 0x45, 0x5c, 0x46, 0x5c, 0x47, 0x5c, 0x48, 0x5c, 0x49, 0x5c, 0x4a,
    0x5c, 0x4b, 0x5c, 0x4c, 0x5c, 0x4d, 0x5c, 0x4e, 0x5c, 0x4f, 0x5c, 0x50,
    0x5c, 0x51, 0x5c, 0x52, 0x5c, 0x53, 0x5c, 0x54, 0x5c, 0x55, 0x5c, 0x56,
    0x5c, 0x57, 0x5c, 0x59, 0x5c, 0x6a, 0x5c, 0x6b, 0x5c, 0x71, 0x5c, 0x76,
    0x5c, 0x77, 0x5c, 0x78, 0x5c, 0x79, 0x5c, 0x7a};
const uint16_t HuffDecoderCommon::table20_1_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109,
    0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149,
    0x0151, 0x0159, 0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table20_2_emit_[44] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61, 0xc3, 0x63, 0xc3,
    0x65, 0xc3, 0x69, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20,
    0xc3, 0x25, 0xc3, 0x2d, 0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3,
    0x34, 0xc3, 0x35, 0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39};
const uint8_t HuffDecoderCommon::table20_3_emit_[92] = {
    0xc3, 0x3d, 0xc3, 0x41, 0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66,
    0xc3, 0x67, 0xc3, 0x68, 0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70,
    0xc3, 0x72, 0xc3, 0x75, 0xc3, 0x3a, 0xc3, 0x42, 0xc3, 0x43, 0xc3, 0x44,
    0xc3, 0x45, 0xc3, 0x46, 0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49, 0xc3, 0x4a,
    0xc3, 0x4b, 0xc3, 0x4c, 0xc3, 0x4d, 0xc3, 0x4e, 0xc3, 0x4f, 0xc3, 0x50,
    0xc3, 0x51, 0xc3, 0x52, 0xc3, 0x53, 0xc3, 0x54, 0xc3, 0x55, 0xc3, 0x56,
    0xc3, 0x57, 0xc3, 0x59, 0xc3, 0x6a, 0xc3, 0x6b, 0xc3, 0x71, 0xc3, 0x76,
    0xc3, 0x77, 0xc3, 0x78, 0xc3, 0x79, 0xc3, 0x7a};
const uint8_t HuffDecoderCommon::table20_4_emit_[44] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61, 0xd0, 0x63, 0xd0,
    0x65, 0xd0, 0x69, 0xd0, 0x6f, 0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20,
    0xd0, 0x25, 0xd0, 0x2d, 0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0,
    0x34, 0xd0, 0x35, 0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39};
const uint8_t HuffDecoderCommon::table20_5_emit_[92] = {
    0xd0, 0x3d, 0xd0, 0x41, 0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66,
    0xd0, 0x67, 0xd0, 0x68, 0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70,
    0xd0, 0x72, 0xd0, 0x75, 0xd0, 0x3a, 0xd0, 0x42, 0xd0, 0x43, 0xd0, 0x44,
    0xd0, 0x45, 0xd0, 0x46, 0xd0, 0x47, 0xd0, 0x48, 0xd0, 0x49, 0xd0, 0x4a,
    0xd0, 0x4b, 0xd0, 0x4c, 0xd0, 0x4d, 0xd0, 0x4e, 0xd0, 0x4f, 0xd0, 0x50,
    0xd0, 0x51, 0xd0, 0x52, 0xd0, 0x53, 0xd0, 0x54, 0xd0, 0x55, 0xd0, 0x56,
    0xd0, 0x57, 0xd0, 0x59, 0xd0, 0x6a, 0xd0, 0x6b, 0xd0, 0x71, 0xd0, 0x76,
    0xd0, 0x77, 0xd0, 0x78, 0xd0, 0x79, 0xd0, 0x7a};
const uint8_t HuffDecoderCommon::table20_6_emit_[72] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63, 0x80, 0x65,
    0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74, 0x80, 0x20, 0x80, 0x25,
    0x80, 0x2d, 0x80, 0x2e, 0x80, 0x2f, 0x80, 0x33, 0x80, 0x34, 0x80, 0x35,
    0x80, 0x36, 0x80, 0x37, 0x80, 0x38, 0x80, 0x39, 0x80, 0x3d, 0x80, 0x41,
    0x80, 0x5f, 0x80, 0x62, 0x80, 0x64, 0x80, 0x66, 0x80, 0x67, 0x80, 0x68,
    0x80, 0x6c, 0x80, 0x6d, 0x80, 0x6e, 0x80, 0x70, 0x80, 0x72, 0x80, 0x75};
const uint8_t HuffDecoderCommon::table20_7_emit_[72] = {
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63, 0x82, 0x65,
    0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74, 0x82, 0x20, 0x82, 0x25,
    0x82, 0x2d, 0x82, 0x2e, 0x82, 0x2f, 0x82, 0x33, 0x82, 0x34, 0x82, 0x35,
    0x82, 0x36, 0x82, 0x37, 0x82, 0x38, 0x82, 0x39, 0x82, 0x3d, 0x82, 0x41,
    0x82, 0x5f, 0x82, 0x62, 0x82, 0x64, 0x82, 0x66, 0x82, 0x67, 0x82, 0x68,
    0x82, 0x6c, 0x82, 0x6d, 0x82, 0x6e, 0x82, 0x70, 0x82, 0x72, 0x82, 0x75};
const uint8_t HuffDecoderCommon::table20_8_emit_[72] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63, 0x83, 0x65,
    0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74, 0x83, 0x20, 0x83, 0x25,
    0x83, 0x2d, 0x83, 0x2e, 0x83, 0x2f, 0x83, 0x33, 0x83, 0x34, 0x83, 0x35,
    0x83, 0x36, 0x83, 0x37, 0x83, 0x38, 0x83, 0x39, 0x83, 0x3d, 0x83, 0x41,
    0x83, 0x5f, 0x83, 0x62, 0x83, 0x64, 0x83, 0x66, 0x83, 0x67, 0x83, 0x68,
    0x83, 0x6c, 0x83, 0x6d, 0x83, 0x6e, 0x83, 0x70, 0x83, 0x72, 0x83, 0x75};
const uint8_t HuffDecoderCommon::table20_9_emit_[72] = {
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63, 0xa2, 0x65,
    0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74, 0xa2, 0x20, 0xa2, 0x25,
    0xa2, 0x2d, 0xa2, 0x2e, 0xa2, 0x2f, 0xa2, 0x33, 0xa2, 0x34, 0xa2, 0x35,
    0xa2, 0x36, 0xa2, 0x37, 0xa2, 0x38, 0xa2, 0x39, 0xa2, 0x3d, 0xa2, 0x41,
    0xa2, 0x5f, 0xa2, 0x62, 0xa2, 0x64, 0xa2, 0x66, 0xa2, 0x67, 0xa2, 0x68,
    0xa2, 0x6c, 0xa2, 0x6d, 0xa2, 0x6e, 0xa2, 0x70, 0xa2, 0x72, 0xa2, 0x75};
const uint8_t HuffDecoderCommon::table20_10_emit_[72] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63, 0xb8, 0x65,
    0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74, 0xb8, 0x20, 0xb8, 0x25,
    0xb8, 0x2d, 0xb8, 0x2e, 0xb8, 0x2f, 0xb8, 0x33, 0xb8, 0x34, 0xb8, 0x35,
    0xb8, 0x36, 0xb8, 0x37, 0xb8, 0x38, 0xb8, 0x39, 0xb8, 0x3d, 0xb8, 0x41,
    0xb8, 0x5f, 0xb8, 0x62, 0xb8, 0x64, 0xb8, 0x66, 0xb8, 0x67, 0xb8, 0x68,
    0xb8, 0x6c, 0xb8, 0x6d, 0xb8, 0x6e, 0xb8, 0x70, 0xb8, 0x72, 0xb8, 0x75};
const uint8_t HuffDecoderCommon::table20_11_emit_[72] = {
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63, 0xc2, 0x65,
    0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74, 0xc2, 0x20, 0xc2, 0x25,
    0xc2, 0x2d, 0xc2, 0x2e, 0xc2, 0x2f, 0xc2, 0x33, 0xc2, 0x34, 0xc2, 0x35,
    0xc2, 0x36, 0xc2, 0x37, 0xc2, 0x38, 0xc2, 0x39, 0xc2, 0x3d, 0xc2, 0x41,
    0xc2, 0x5f, 0xc2, 0x62, 0xc2, 0x64, 0xc2, 0x66, 0xc2, 0x67, 0xc2, 0x68,
    0xc2, 0x6c, 0xc2, 0x6d, 0xc2, 0x6e, 0xc2, 0x70, 0xc2, 0x72, 0xc2, 0x75};
const uint8_t HuffDecoderCommon::table20_12_emit_[72] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63, 0xe0, 0x65,
    0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74, 0xe0, 0x20, 0xe0, 0x25,
    0xe0, 0x2d, 0xe0, 0x2e, 0xe0, 0x2f, 0xe0, 0x33, 0xe0, 0x34, 0xe0, 0x35,
    0xe0, 0x36, 0xe0, 0x37, 0xe0, 0x38, 0xe0, 0x39, 0xe0, 0x3d, 0xe0, 0x41,
    0xe0, 0x5f, 0xe0, 0x62, 0xe0, 0x64, 0xe0, 0x66, 0xe0, 0x67, 0xe0, 0x68,
    0xe0, 0x6c, 0xe0, 0x6d, 0xe0, 0x6e, 0xe0, 0x70, 0xe0, 0x72, 0xe0, 0x75};
const uint8_t HuffDecoderCommon::table20_13_emit_[72] = {
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63, 0xe2, 0x65,
    0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74, 0xe2, 0x20, 0xe2, 0x25,
    0xe2, 0x2d, 0xe2, 0x2e, 0xe2, 0x2f, 0xe2, 0x33, 0xe2, 0x34, 0xe2, 0x35,
    0xe2, 0x36, 0xe2, 0x37, 0xe2, 0x38, 0xe2, 0x39, 0xe2, 0x3d, 0xe2, 0x41,
    0xe2, 0x5f, 0xe2, 0x62, 0xe2, 0x64, 0xe2, 0x66, 0xe2, 0x67, 0xe2, 0x68,
    0xe2, 0x6c, 0xe2, 0x6d, 0xe2, 0x6e, 0xe2, 0x70, 0xe2, 0x72, 0xe2, 0x75};
const uint8_t HuffDecoderCommon::table20_14_emit_[40] = {
    0x99, 0x30, 0x99, 0x31, 0x99, 0x32, 0x99, 0x61, 0x99, 0x63,
    0x99, 0x65, 0x99, 0x69, 0x99, 0x6f, 0x99, 0x73, 0x99, 0x74,
    0xa1, 0x30, 0xa1, 0x31, 0xa1, 0x32, 0xa1, 0x61, 0xa1, 0x63,
    0xa1, 0x65, 0xa1, 0x69, 0xa1, 0x6f, 0xa1, 0x73, 0xa1, 0x74};
const uint8_t HuffDecoderCommon::table20_15_emit_[40] = {
    0xa7, 0x30, 0xa7, 0x31, 0xa7, 0x32, 0xa7, 0x61, 0xa7, 0x63,
    0xa7, 0x65, 0xa7, 0x69, 0xa7, 0x6f, 0xa7, 0x73, 0xa7, 0x74,
    0xac, 0x30, 0xac, 0x31, 0xac, 0x32, 0xac, 0x61, 0xac, 0x63,
    0xac, 0x65, 0xac, 0x69, 0xac, 0x6f, 0xac, 0x73, 0xac, 0x74};
const uint8_t HuffDecoderCommon::table20_16_emit_[40] = {
    0xb0, 0x30, 0xb0, 0x31, 0xb0, 0x32, 0xb0, 0x61, 0xb0, 0x63,
    0xb0, 0x65, 0xb0, 0x69, 0xb0, 0x6f, 0xb0, 0x73, 0xb0, 0x74,
    0xb1, 0x30, 0xb1, 0x31, 0xb1, 0x32, 0xb1, 0x61, 0xb1, 0x63,
    0xb1, 0x65, 0xb1, 0x69, 0xb1, 0x6f, 0xb1, 0x73, 0xb1, 0x74};
const uint8_t HuffDecoderCommon::table20_17_emit_[40] = {
    0xb3, 0x30, 0xb3, 0x31, 0xb3, 0x32, 0xb3, 0x61, 0xb3, 0x63,
    0xb3, 0x65, 0xb3, 0x69, 0xb3, 0x6f, 0xb3, 0x73, 0xb3, 0x74,
    0xd1, 0x30, 0xd1, 0x31, 0xd1, 0x32, 0xd1, 0x61, 0xd1, 0x63,
    0xd1, 0x65, 0xd1, 0x69, 0xd1, 0x6f, 0xd1, 0x73, 0xd1, 0x74};
const uint8_t HuffDecoderCommon::table20_18_emit_[40] = {
    0xd8, 0x30, 0xd8, 0x31, 0xd8, 0x32, 0xd8, 0x61, 0xd8, 0x63,
    0xd8, 0x65, 0xd8, 0x69, 0xd8, 0x6f, 0xd8, 0x73, 0xd8, 0x74,
    0xd9, 0x30, 0xd9, 0x31, 0xd9, 0x32, 0xd9, 0x61, 0xd9, 0x63,
    0xd9, 0x65, 0xd9, 0x69, 0xd9, 0x6f, 0xd9, 0x73, 0xd9, 0x74};
const uint8_t HuffDecoderCommon::table20_19_emit_[40] = {
    0xe3, 0x30, 0xe3, 0x31, 0xe3, 0x32, 0xe3, 0x61, 0xe3, 0x63,
    0xe3, 0x65, 0xe3, 0x69, 0xe3, 0x6f, 0xe3, 0x73, 0xe3, 0x74,
    0xe5, 0x30, 0xe5, 0x31, 0xe5, 0x32, 0xe5, 0x61, 0xe5, 0x63,
    0xe5, 0x65, 0xe5, 0x69, 0xe5, 0x6f, 0xe5, 0x73, 0xe5, 0x74};
const uint8_t HuffDecoderCommon::table20_20_emit_[22] = {
    0xe6, 0x30, 0xe6, 0x31, 0xe6, 0x32, 0xe6, 0x61, 0xe6, 0x63, 0xe6,
    0x65, 0xe6, 0x69, 0xe6, 0x6f, 0xe6, 0x73, 0xe6, 0x74, 0x81, 0x84};
const uint16_t HuffDecoderCommon::table20_20_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0056};
const uint8_t HuffDecoderCommon::table20_21_emit_[4] = {0x85, 0x86, 0x88, 0x92};
const uint8_t HuffDecoderCommon::table20_22_emit_[4] = {0x9a, 0x9c, 0xa0, 0xa3};
const uint8_t HuffDecoderCommon::table20_23_emit_[4] = {0xa4, 0xa9, 0xaa, 0xad};
const uint8_t HuffDecoderCommon::table20_24_emit_[4] = {0xb2, 0xb5, 0xb9, 0xba};
const uint8_t HuffDecoderCommon::table20_25_emit_[4] = {0xbb, 0xbd, 0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table20_26_emit_[4] = {0xc6, 0xe4, 0xe8, 0xe9};
const uint8_t HuffDecoderCommon::table20_27_emit_[8] = {0x01, 0x87, 0x89, 0x8a,
                                                        0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table20_28_emit_[8] = {0x93, 0x95, 0x96, 0x97,
                                                        0x98, 0x9b, 0x9d, 0x9e};
const uint8_t HuffDecoderCommon::table20_29_emit_[8] = {0xa5, 0xa6, 0xa8, 0xae,
                                                        0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table20_30_emit_[11] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f};
const uint16_t HuffDecoderCommon::table20_30_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0016, 0x0000, 0x0000, 0x0000, 0x001a,
    0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022,
    0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000, 0x0000, 0x002a};
const uint8_t HuffDecoderCommon::table20_31_emit_[25] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea,
    0xeb, 0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5,
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint16_t HuffDecoderCommon::table20_31_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x001a, 0x0000, 0x001e, 0x0000, 0x0022, 0x0000, 0x0026,
    0x002a, 0x002e, 0x0032, 0x0036, 0x003a, 0x003e, 0x0042, 0x0046,
    0x004a, 0x004e, 0x0052, 0x0056, 0x005a, 0x005e, 0x0062, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table20_emit_[32] = {
    table20_0_emit_,  table20_1_emit_,  table20_2_emit_,  table20_3_emit_,
    table20_4_emit_,  table20_5_emit_,  table20_6_emit_,  table20_7_emit_,
    table20_8_emit_,  table20_9_emit_,  table20_10_emit_, table20_11_emit_,
    table20_12_emit_, table20_13_emit_, table20_14_emit_, table20_15_emit_,
    table20_16_emit_, table20_17_emit_, table20_18_emit_, table20_19_emit_,
    table20_20_emit_, table20_21_emit_, table20_22_emit_, table20_23_emit_,
    table20_24_emit_, table20_25_emit_, table20_26_emit_, table20_27_emit_,
    table20_28_emit_, table20_29_emit_, table20_30_emit_, table20_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table20_ops_[32] = {
    table20_0_ops_,  table20_1_ops_,  table20_0_ops_,  table20_1_ops_,
    table20_0_ops_,  table20_1_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_,  table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_,  table19_0_ops_,  table19_3_ops_,  table19_3_ops_,
    table19_3_ops_,  table19_3_ops_,  table19_3_ops_,  table19_3_ops_,
    table20_20_ops_, table19_7_ops_,  table19_7_ops_,  table19_7_ops_,
    table19_7_ops_,  table19_7_ops_,  table19_7_ops_,  table19_11_ops_,
    table19_11_ops_, table19_11_ops_, table20_30_ops_, table20_31_ops_,
};
const uint8_t HuffDecoderCommon::table21_0_emit_[16] = {
    0x5c, 0x30, 0x5c, 0x31, 0x5c, 0x32, 0x5c, 0x61,
    0x5c, 0x63, 0x5c, 0x65, 0x5c, 0x69, 0x5c, 0x6f};
const uint16_t HuffDecoderCommon::table21_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0039};
const uint8_t HuffDecoderCommon::table21_1_emit_[28] = {
    0x5c, 0x73, 0x5c, 0x74, 0x5c, 0x20, 0x5c, 0x25, 0x5c, 0x2d,
    0x5c, 0x2e, 0x5c, 0x2f, 0x5c, 0x33, 0x5c, 0x34, 0x5c, 0x35,
    0x5c, 0x36, 0x5c, 0x37, 0x5c, 0x38, 0x5c, 0x39};
const uint16_t HuffDecoderCommon::table21_1_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069};
const uint8_t HuffDecoderCommon::table21_2_emit_[36] = {
    0x5c, 0x3d, 0x5c, 0x41, 0x5c, 0x5f, 0x5c, 0x62, 0x5c, 0x64, 0x5c, 0x66,
    0x5c, 0x67, 0x5c, 0x68, 0x5c, 0x6c, 0x5c, 0x6d, 0x5c, 0x6e, 0x5c, 0x70,
    0x5c, 0x72, 0x5c, 0x75, 0x5c, 0x3a, 0x5c, 0x42, 0x5c, 0x43, 0x5c, 0x44};
const uint16_t HuffDecoderCommon::table21_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089};
const uint8_t HuffDecoderCommon::table21_3_emit_[68] = {
    0x5c, 0x45, 0x5c, 0x46, 0x5c, 0x47, 0x5c, 0x48, 0x5c, 0x49, 0x5c, 0x4a,
    0x5c, 0x4b, 0x5c, 0x4c, 0x5c, 0x4d, 0x5c, 0x4e, 0x5c, 0x4f, 0x5c, 0x50,
    0x5c, 0x51, 0x5c, 0x52, 0x5c, 0x53, 0x5c, 0x54, 0x5c, 0x55, 0x5c, 0x56,
    0x5c, 0x57, 0x5c, 0x59, 0x5c, 0x6a, 0x5c, 0x6b, 0x5c, 0x71, 0x5c, 0x76,
    0x5c, 0x77, 0x5c, 0x78, 0x5c, 0x79, 0x5c, 0x7a, 0x5c, 0x26, 0x5c, 0x2a,
    0x5c, 0x2c, 0x5c, 0x3b, 0x5c, 0x58, 0x5c, 0x5a};
const uint16_t HuffDecoderCommon::table21_3_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099,
    0x0000, 0x00a1, 0x0000, 0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9,
    0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000, 0x00d1, 0x0000, 0x00d9,
    0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table21_4_emit_[16] = {
    0xc3, 0x30, 0xc3, 0x31, 0xc3, 0x32, 0xc3, 0x61,
    0xc3, 0x63, 0xc3, 0x65, 0xc3, 0x69, 0xc3, 0x6f};
const uint8_t HuffDecoderCommon::table21_5_emit_[28] = {
    0xc3, 0x73, 0xc3, 0x74, 0xc3, 0x20, 0xc3, 0x25, 0xc3, 0x2d,
    0xc3, 0x2e, 0xc3, 0x2f, 0xc3, 0x33, 0xc3, 0x34, 0xc3, 0x35,
    0xc3, 0x36, 0xc3, 0x37, 0xc3, 0x38, 0xc3, 0x39};
const uint8_t HuffDecoderCommon::table21_6_emit_[36] = {
    0xc3, 0x3d, 0xc3, 0x41, 0xc3, 0x5f, 0xc3, 0x62, 0xc3, 0x64, 0xc3, 0x66,
    0xc3, 0x67, 0xc3, 0x68, 0xc3, 0x6c, 0xc3, 0x6d, 0xc3, 0x6e, 0xc3, 0x70,
    0xc3, 0x72, 0xc3, 0x75, 0xc3, 0x3a, 0xc3, 0x42, 0xc3, 0x43, 0xc3, 0x44};
const uint8_t HuffDecoderCommon::table21_7_emit_[68] = {
    0xc3, 0x45, 0xc3, 0x46, 0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49, 0xc3, 0x4a,
    0xc3, 0x4b, 0xc3, 0x4c, 0xc3, 0x4d, 0xc3, 0x4e, 0xc3, 0x4f, 0xc3, 0x50,
    0xc3, 0x51, 0xc3, 0x52, 0xc3, 0x53, 0xc3, 0x54, 0xc3, 0x55, 0xc3, 0x56,
    0xc3, 0x57, 0xc3, 0x59, 0xc3, 0x6a, 0xc3, 0x6b, 0xc3, 0x71, 0xc3, 0x76,
    0xc3, 0x77, 0xc3, 0x78, 0xc3, 0x79, 0xc3, 0x7a, 0xc3, 0x26, 0xc3, 0x2a,
    0xc3, 0x2c, 0xc3, 0x3b, 0xc3, 0x58, 0xc3, 0x5a};
const uint8_t HuffDecoderCommon::table21_8_emit_[16] = {
    0xd0, 0x30, 0xd0, 0x31, 0xd0, 0x32, 0xd0, 0x61,
    0xd0, 0x63, 0xd0, 0x65, 0xd0, 0x69, 0xd0, 0x6f};
const uint8_t HuffDecoderCommon::table21_9_emit_[28] = {
    0xd0, 0x73, 0xd0, 0x74, 0xd0, 0x20, 0xd0, 0x25, 0xd0, 0x2d,
    0xd0, 0x2e, 0xd0, 0x2f, 0xd0, 0x33, 0xd0, 0x34, 0xd0, 0x35,
    0xd0, 0x36, 0xd0, 0x37, 0xd0, 0x38, 0xd0, 0x39};
const uint8_t HuffDecoderCommon::table21_10_emit_[36] = {
    0xd0, 0x3d, 0xd0, 0x41, 0xd0, 0x5f, 0xd0, 0x62, 0xd0, 0x64, 0xd0, 0x66,
    0xd0, 0x67, 0xd0, 0x68, 0xd0, 0x6c, 0xd0, 0x6d, 0xd0, 0x6e, 0xd0, 0x70,
    0xd0, 0x72, 0xd0, 0x75, 0xd0, 0x3a, 0xd0, 0x42, 0xd0, 0x43, 0xd0, 0x44};
const uint8_t HuffDecoderCommon::table21_11_emit_[68] = {
    0xd0, 0x45, 0xd0, 0x46, 0xd0, 0x47, 0xd0, 0x48, 0xd0, 0x49, 0xd0, 0x4a,
    0xd0, 0x4b, 0xd0, 0x4c, 0xd0, 0x4d, 0xd0, 0x4e, 0xd0, 0x4f, 0xd0, 0x50,
    0xd0, 0x51, 0xd0, 0x52, 0xd0, 0x53, 0xd0, 0x54, 0xd0, 0x55, 0xd0, 0x56,
    0xd0, 0x57, 0xd0, 0x59, 0xd0, 0x6a, 0xd0, 0x6b, 0xd0, 0x71, 0xd0, 0x76,
    0xd0, 0x77, 0xd0, 0x78, 0xd0, 0x79, 0xd0, 0x7a, 0xd0, 0x26, 0xd0, 0x2a,
    0xd0, 0x2c, 0xd0, 0x3b, 0xd0, 0x58, 0xd0, 0x5a};
const uint8_t HuffDecoderCommon::table21_12_emit_[44] = {
    0x80, 0x30, 0x80, 0x31, 0x80, 0x32, 0x80, 0x61, 0x80, 0x63, 0x80,
    0x65, 0x80, 0x69, 0x80, 0x6f, 0x80, 0x73, 0x80, 0x74, 0x80, 0x20,
    0x80, 0x25, 0x80, 0x2d, 0x80, 0x2e, 0x80, 0x2f, 0x80, 0x33, 0x80,
    0x34, 0x80, 0x35, 0x80, 0x36, 0x80, 0x37, 0x80, 0x38, 0x80, 0x39};
const uint8_t HuffDecoderCommon::table21_13_emit_[92] = {
    0x80, 0x3d, 0x80, 0x41, 0x80, 0x5f, 0x80, 0x62, 0x80, 0x64, 0x80, 0x66,
    0x80, 0x67, 0x80, 0x68, 0x80, 0x6c, 0x80, 0x6d, 0x80, 0x6e, 0x80, 0x70,
    0x80, 0x72, 0x80, 0x75, 0x80, 0x3a, 0x80, 0x42, 0x80, 0x43, 0x80, 0x44,
    0x80, 0x45, 0x80, 0x46, 0x80, 0x47, 0x80, 0x48, 0x80, 0x49, 0x80, 0x4a,
    0x80, 0x4b, 0x80, 0x4c, 0x80, 0x4d, 0x80, 0x4e, 0x80, 0x4f, 0x80, 0x50,
    0x80, 0x51, 0x80, 0x52, 0x80, 0x53, 0x80, 0x54, 0x80, 0x55, 0x80, 0x56,
    0x80, 0x57, 0x80, 0x59, 0x80, 0x6a, 0x80, 0x6b, 0x80, 0x71, 0x80, 0x76,
    0x80, 0x77, 0x80, 0x78, 0x80, 0x79, 0x80, 0x7a};
const uint8_t HuffDecoderCommon::table21_14_emit_[44] = {
    0x82, 0x30, 0x82, 0x31, 0x82, 0x32, 0x82, 0x61, 0x82, 0x63, 0x82,
    0x65, 0x82, 0x69, 0x82, 0x6f, 0x82, 0x73, 0x82, 0x74, 0x82, 0x20,
    0x82, 0x25, 0x82, 0x2d, 0x82, 0x2e, 0x82, 0x2f, 0x82, 0x33, 0x82,
    0x34, 0x82, 0x35, 0x82, 0x36, 0x82, 0x37, 0x82, 0x38, 0x82, 0x39};
const uint8_t HuffDecoderCommon::table21_15_emit_[92] = {
    0x82, 0x3d, 0x82, 0x41, 0x82, 0x5f, 0x82, 0x62, 0x82, 0x64, 0x82, 0x66,
    0x82, 0x67, 0x82, 0x68, 0x82, 0x6c, 0x82, 0x6d, 0x82, 0x6e, 0x82, 0x70,
    0x82, 0x72, 0x82, 0x75, 0x82, 0x3a, 0x82, 0x42, 0x82, 0x43, 0x82, 0x44,
    0x82, 0x45, 0x82, 0x46, 0x82, 0x47, 0x82, 0x48, 0x82, 0x49, 0x82, 0x4a,
    0x82, 0x4b, 0x82, 0x4c, 0x82, 0x4d, 0x82, 0x4e, 0x82, 0x4f, 0x82, 0x50,
    0x82, 0x51, 0x82, 0x52, 0x82, 0x53, 0x82, 0x54, 0x82, 0x55, 0x82, 0x56,
    0x82, 0x57, 0x82, 0x59, 0x82, 0x6a, 0x82, 0x6b, 0x82, 0x71, 0x82, 0x76,
    0x82, 0x77, 0x82, 0x78, 0x82, 0x79, 0x82, 0x7a};
const uint8_t HuffDecoderCommon::table21_16_emit_[44] = {
    0x83, 0x30, 0x83, 0x31, 0x83, 0x32, 0x83, 0x61, 0x83, 0x63, 0x83,
    0x65, 0x83, 0x69, 0x83, 0x6f, 0x83, 0x73, 0x83, 0x74, 0x83, 0x20,
    0x83, 0x25, 0x83, 0x2d, 0x83, 0x2e, 0x83, 0x2f, 0x83, 0x33, 0x83,
    0x34, 0x83, 0x35, 0x83, 0x36, 0x83, 0x37, 0x83, 0x38, 0x83, 0x39};
const uint8_t HuffDecoderCommon::table21_17_emit_[92] = {
    0x83, 0x3d, 0x83, 0x41, 0x83, 0x5f, 0x83, 0x62, 0x83, 0x64, 0x83, 0x66,
    0x83, 0x67, 0x83, 0x68, 0x83, 0x6c, 0x83, 0x6d, 0x83, 0x6e, 0x83, 0x70,
    0x83, 0x72, 0x83, 0x75, 0x83, 0x3a, 0x83, 0x42, 0x83, 0x43, 0x83, 0x44,
    0x83, 0x45, 0x83, 0x46, 0x83, 0x47, 0x83, 0x48, 0x83, 0x49, 0x83, 0x4a,
    0x83, 0x4b, 0x83, 0x4c, 0x83, 0x4d, 0x83, 0x4e, 0x83, 0x4f, 0x83, 0x50,
    0x83, 0x51, 0x83, 0x52, 0x83, 0x53, 0x83, 0x54, 0x83, 0x55, 0x83, 0x56,
    0x83, 0x57, 0x83, 0x59, 0x83, 0x6a, 0x83, 0x6b, 0x83, 0x71, 0x83, 0x76,
    0x83, 0x77, 0x83, 0x78, 0x83, 0x79, 0x83, 0x7a};
const uint8_t HuffDecoderCommon::table21_18_emit_[44] = {
    0xa2, 0x30, 0xa2, 0x31, 0xa2, 0x32, 0xa2, 0x61, 0xa2, 0x63, 0xa2,
    0x65, 0xa2, 0x69, 0xa2, 0x6f, 0xa2, 0x73, 0xa2, 0x74, 0xa2, 0x20,
    0xa2, 0x25, 0xa2, 0x2d, 0xa2, 0x2e, 0xa2, 0x2f, 0xa2, 0x33, 0xa2,
    0x34, 0xa2, 0x35, 0xa2, 0x36, 0xa2, 0x37, 0xa2, 0x38, 0xa2, 0x39};
const uint8_t HuffDecoderCommon::table21_19_emit_[92] = {
    0xa2, 0x3d, 0xa2, 0x41, 0xa2, 0x5f, 0xa2, 0x62, 0xa2, 0x64, 0xa2, 0x66,
    0xa2, 0x67, 0xa2, 0x68, 0xa2, 0x6c, 0xa2, 0x6d, 0xa2, 0x6e, 0xa2, 0x70,
    0xa2, 0x72, 0xa2, 0x75, 0xa2, 0x3a, 0xa2, 0x42, 0xa2, 0x43, 0xa2, 0x44,
    0xa2, 0x45, 0xa2, 0x46, 0xa2, 0x47, 0xa2, 0x48, 0xa2, 0x49, 0xa2, 0x4a,
    0xa2, 0x4b, 0xa2, 0x4c, 0xa2, 0x4d, 0xa2, 0x4e, 0xa2, 0x4f, 0xa2, 0x50,
    0xa2, 0x51, 0xa2, 0x52, 0xa2, 0x53, 0xa2, 0x54, 0xa2, 0x55, 0xa2, 0x56,
    0xa2, 0x57, 0xa2, 0x59, 0xa2, 0x6a, 0xa2, 0x6b, 0xa2, 0x71, 0xa2, 0x76,
    0xa2, 0x77, 0xa2, 0x78, 0xa2, 0x79, 0xa2, 0x7a};
const uint8_t HuffDecoderCommon::table21_20_emit_[44] = {
    0xb8, 0x30, 0xb8, 0x31, 0xb8, 0x32, 0xb8, 0x61, 0xb8, 0x63, 0xb8,
    0x65, 0xb8, 0x69, 0xb8, 0x6f, 0xb8, 0x73, 0xb8, 0x74, 0xb8, 0x20,
    0xb8, 0x25, 0xb8, 0x2d, 0xb8, 0x2e, 0xb8, 0x2f, 0xb8, 0x33, 0xb8,
    0x34, 0xb8, 0x35, 0xb8, 0x36, 0xb8, 0x37, 0xb8, 0x38, 0xb8, 0x39};
const uint8_t HuffDecoderCommon::table21_21_emit_[92] = {
    0xb8, 0x3d, 0xb8, 0x41, 0xb8, 0x5f, 0xb8, 0x62, 0xb8, 0x64, 0xb8, 0x66,
    0xb8, 0x67, 0xb8, 0x68, 0xb8, 0x6c, 0xb8, 0x6d, 0xb8, 0x6e, 0xb8, 0x70,
    0xb8, 0x72, 0xb8, 0x75, 0xb8, 0x3a, 0xb8, 0x42, 0xb8, 0x43, 0xb8, 0x44,
    0xb8, 0x45, 0xb8, 0x46, 0xb8, 0x47, 0xb8, 0x48, 0xb8, 0x49, 0xb8, 0x4a,
    0xb8, 0x4b, 0xb8, 0x4c, 0xb8, 0x4d, 0xb8, 0x4e, 0xb8, 0x4f, 0xb8, 0x50,
    0xb8, 0x51, 0xb8, 0x52, 0xb8, 0x53, 0xb8, 0x54, 0xb8, 0x55, 0xb8, 0x56,
    0xb8, 0x57, 0xb8, 0x59, 0xb8, 0x6a, 0xb8, 0x6b, 0xb8, 0x71, 0xb8, 0x76,
    0xb8, 0x77, 0xb8, 0x78, 0xb8, 0x79, 0xb8, 0x7a};
const uint8_t HuffDecoderCommon::table21_22_emit_[44] = {
    0xc2, 0x30, 0xc2, 0x31, 0xc2, 0x32, 0xc2, 0x61, 0xc2, 0x63, 0xc2,
    0x65, 0xc2, 0x69, 0xc2, 0x6f, 0xc2, 0x73, 0xc2, 0x74, 0xc2, 0x20,
    0xc2, 0x25, 0xc2, 0x2d, 0xc2, 0x2e, 0xc2, 0x2f, 0xc2, 0x33, 0xc2,
    0x34, 0xc2, 0x35, 0xc2, 0x36, 0xc2, 0x37, 0xc2, 0x38, 0xc2, 0x39};
const uint8_t HuffDecoderCommon::table21_23_emit_[92] = {
    0xc2, 0x3d, 0xc2, 0x41, 0xc2, 0x5f, 0xc2, 0x62, 0xc2, 0x64, 0xc2, 0x66,
    0xc2, 0x67, 0xc2, 0x68, 0xc2, 0x6c, 0xc2, 0x6d, 0xc2, 0x6e, 0xc2, 0x70,
    0xc2, 0x72, 0xc2, 0x75, 0xc2, 0x3a, 0xc2, 0x42, 0xc2, 0x43, 0xc2, 0x44,
    0xc2, 0x45, 0xc2, 0x46, 0xc2, 0x47, 0xc2, 0x48, 0xc2, 0x49, 0xc2, 0x4a,
    0xc2, 0x4b, 0xc2, 0x4c, 0xc2, 0x4d, 0xc2, 0x4e, 0xc2, 0x4f, 0xc2, 0x50,
    0xc2, 0x51, 0xc2, 0x52, 0xc2, 0x53, 0xc2, 0x54, 0xc2, 0x55, 0xc2, 0x56,
    0xc2, 0x57, 0xc2, 0x59, 0xc2, 0x6a, 0xc2, 0x6b, 0xc2, 0x71, 0xc2, 0x76,
    0xc2, 0x77, 0xc2, 0x78, 0xc2, 0x79, 0xc2, 0x7a};
const uint8_t HuffDecoderCommon::table21_24_emit_[44] = {
    0xe0, 0x30, 0xe0, 0x31, 0xe0, 0x32, 0xe0, 0x61, 0xe0, 0x63, 0xe0,
    0x65, 0xe0, 0x69, 0xe0, 0x6f, 0xe0, 0x73, 0xe0, 0x74, 0xe0, 0x20,
    0xe0, 0x25, 0xe0, 0x2d, 0xe0, 0x2e, 0xe0, 0x2f, 0xe0, 0x33, 0xe0,
    0x34, 0xe0, 0x35, 0xe0, 0x36, 0xe0, 0x37, 0xe0, 0x38, 0xe0, 0x39};
const uint8_t HuffDecoderCommon::table21_25_emit_[92] = {
    0xe0, 0x3d, 0xe0, 0x41, 0xe0, 0x5f, 0xe0, 0x62, 0xe0, 0x64, 0xe0, 0x66,
    0xe0, 0x67, 0xe0, 0x68, 0xe0, 0x6c, 0xe0, 0x6d, 0xe0, 0x6e, 0xe0, 0x70,
    0xe0, 0x72, 0xe0, 0x75, 0xe0, 0x3a, 0xe0, 0x42, 0xe0, 0x43, 0xe0, 0x44,
    0xe0, 0x45, 0xe0, 0x46, 0xe0, 0x47, 0xe0, 0x48, 0xe0, 0x49, 0xe0, 0x4a,
    0xe0, 0x4b, 0xe0, 0x4c, 0xe0, 0x4d, 0xe0, 0x4e, 0xe0, 0x4f, 0xe0, 0x50,
    0xe0, 0x51, 0xe0, 0x52, 0xe0, 0x53, 0xe0, 0x54, 0xe0, 0x55, 0xe0, 0x56,
    0xe0, 0x57, 0xe0, 0x59, 0xe0, 0x6a, 0xe0, 0x6b, 0xe0, 0x71, 0xe0, 0x76,
    0xe0, 0x77, 0xe0, 0x78, 0xe0, 0x79, 0xe0, 0x7a};
const uint8_t HuffDecoderCommon::table21_26_emit_[44] = {
    0xe2, 0x30, 0xe2, 0x31, 0xe2, 0x32, 0xe2, 0x61, 0xe2, 0x63, 0xe2,
    0x65, 0xe2, 0x69, 0xe2, 0x6f, 0xe2, 0x73, 0xe2, 0x74, 0xe2, 0x20,
    0xe2, 0x25, 0xe2, 0x2d, 0xe2, 0x2e, 0xe2, 0x2f, 0xe2, 0x33, 0xe2,
    0x34, 0xe2, 0x35, 0xe2, 0x36, 0xe2, 0x37, 0xe2, 0x38, 0xe2, 0x39};
const uint8_t HuffDecoderCommon::table21_27_emit_[92] = {
    0xe2, 0x3d, 0xe2, 0x41, 0xe2, 0x5f, 0xe2, 0x62, 0xe2, 0x64, 0xe2, 0x66,
    0xe2, 0x67, 0xe2, 0x68, 0xe2, 0x6c, 0xe2, 0x6d, 0xe2, 0x6e, 0xe2, 0x70,
    0xe2, 0x72, 0xe2, 0x75, 0xe2, 0x3a, 0xe2, 0x42, 0xe2, 0x43, 0xe2, 0x44,
    0xe2, 0x45, 0xe2, 0x46, 0xe2, 0x47, 0xe2, 0x48, 0xe2, 0x49, 0xe2, 0x4a,
    0xe2, 0x4b, 0xe2, 0x4c, 0xe2, 0x4d, 0xe2, 0x4e, 0xe2, 0x4f, 0xe2, 0x50,
    0xe2, 0x51, 0xe2, 0x52, 0xe2, 0x53, 0xe2, 0x54, 0xe2, 0x55, 0xe2, 0x56,
    0xe2, 0x57, 0xe2, 0x59, 0xe2, 0x6a, 0xe2, 0x6b, 0xe2, 0x71, 0xe2, 0x76,
    0xe2, 0x77, 0xe2, 0x78, 0xe2, 0x79, 0xe2, 0x7a};
const uint8_t HuffDecoderCommon::table21_28_emit_[72] = {
    0x99, 0x30, 0x99, 0x31, 0x99, 0x32, 0x99, 0x61, 0x99, 0x63, 0x99, 0x65,
    0x99, 0x69, 0x99, 0x6f, 0x99, 0x73, 0x99, 0x74, 0x99, 0x20, 0x99, 0x25,
    0x99, 0x2d, 0x99, 0x2e, 0x99, 0x2f, 0x99, 0x33, 0x99, 0x34, 0x99, 0x35,
    0x99, 0x36, 0x99, 0x37, 0x99, 0x38, 0x99, 0x39, 0x99, 0x3d, 0x99, 0x41,
    0x99, 0x5f, 0x99, 0x62, 0x99, 0x64, 0x99, 0x66, 0x99, 0x67, 0x99, 0x68,
    0x99, 0x6c, 0x99, 0x6d, 0x99, 0x6e, 0x99, 0x70, 0x99, 0x72, 0x99, 0x75};
const uint8_t HuffDecoderCommon::table21_29_emit_[72] = {
    0xa1, 0x30, 0xa1, 0x31, 0xa1, 0x32, 0xa1, 0x61, 0xa1, 0x63, 0xa1, 0x65,
    0xa1, 0x69, 0xa1, 0x6f, 0xa1, 0x73, 0xa1, 0x74, 0xa1, 0x20, 0xa1, 0x25,
    0xa1, 0x2d, 0xa1, 0x2e, 0xa1, 0x2f, 0xa1, 0x33, 0xa1, 0x34, 0xa1, 0x35,
    0xa1, 0x36, 0xa1, 0x37, 0xa1, 0x38, 0xa1, 0x39, 0xa1, 0x3d, 0xa1, 0x41,
    0xa1, 0x5f, 0xa1, 0x62, 0xa1, 0x64, 0xa1, 0x66, 0xa1, 0x67, 0xa1, 0x68,
    0xa1, 0x6c, 0xa1, 0x6d, 0xa1, 0x6e, 0xa1, 0x70, 0xa1, 0x72, 0xa1, 0x75};
const uint8_t HuffDecoderCommon::table21_30_emit_[72] = {
    0xa7, 0x30, 0xa7, 0x31, 0xa7, 0x32, 0xa7, 0x61, 0xa7, 0x63, 0xa7, 0x65,
    0xa7, 0x69, 0xa7, 0x6f, 0xa7, 0x73, 0xa7, 0x74, 0xa7, 0x20, 0xa7, 0x25,
    0xa7, 0x2d, 0xa7, 0x2e, 0xa7, 0x2f, 0xa7, 0x33, 0xa7, 0x34, 0xa7, 0x35,
    0xa7, 0x36, 0xa7, 0x37, 0xa7, 0x38, 0xa7, 0x39, 0xa7, 0x3d, 0xa7, 0x41,
    0xa7, 0x5f, 0xa7, 0x62, 0xa7, 0x64, 0xa7, 0x66, 0xa7, 0x67, 0xa7, 0x68,
    0xa7, 0x6c, 0xa7, 0x6d, 0xa7, 0x6e, 0xa7, 0x70, 0xa7, 0x72, 0xa7, 0x75};
const uint8_t HuffDecoderCommon::table21_31_emit_[72] = {
    0xac, 0x30, 0xac, 0x31, 0xac, 0x32, 0xac, 0x61, 0xac, 0x63, 0xac, 0x65,
    0xac, 0x69, 0xac, 0x6f, 0xac, 0x73, 0xac, 0x74, 0xac, 0x20, 0xac, 0x25,
    0xac, 0x2d, 0xac, 0x2e, 0xac, 0x2f, 0xac, 0x33, 0xac, 0x34, 0xac, 0x35,
    0xac, 0x36, 0xac, 0x37, 0xac, 0x38, 0xac, 0x39, 0xac, 0x3d, 0xac, 0x41,
    0xac, 0x5f, 0xac, 0x62, 0xac, 0x64, 0xac, 0x66, 0xac, 0x67, 0xac, 0x68,
    0xac, 0x6c, 0xac, 0x6d, 0xac, 0x6e, 0xac, 0x70, 0xac, 0x72, 0xac, 0x75};
const uint8_t HuffDecoderCommon::table21_32_emit_[72] = {
    0xb0, 0x30, 0xb0, 0x31, 0xb0, 0x32, 0xb0, 0x61, 0xb0, 0x63, 0xb0, 0x65,
    0xb0, 0x69, 0xb0, 0x6f, 0xb0, 0x73, 0xb0, 0x74, 0xb0, 0x20, 0xb0, 0x25,
    0xb0, 0x2d, 0xb0, 0x2e, 0xb0, 0x2f, 0xb0, 0x33, 0xb0, 0x34, 0xb0, 0x35,
    0xb0, 0x36, 0xb0, 0x37, 0xb0, 0x38, 0xb0, 0x39, 0xb0, 0x3d, 0xb0, 0x41,
    0xb0, 0x5f, 0xb0, 0x62, 0xb0, 0x64, 0xb0, 0x66, 0xb0, 0x67, 0xb0, 0x68,
    0xb0, 0x6c, 0xb0, 0x6d, 0xb0, 0x6e, 0xb0, 0x70, 0xb0, 0x72, 0xb0, 0x75};
const uint8_t HuffDecoderCommon::table21_33_emit_[72] = {
    0xb1, 0x30, 0xb1, 0x31, 0xb1, 0x32, 0xb1, 0x61, 0xb1, 0x63, 0xb1, 0x65,
    0xb1, 0x69, 0xb1, 0x6f, 0xb1, 0x73, 0xb1, 0x74, 0xb1, 0x20, 0xb1, 0x25,
    0xb1, 0x2d, 0xb1, 0x2e, 0xb1, 0x2f, 0xb1, 0x33, 0xb1, 0x34, 0xb1, 0x35,
    0xb1, 0x36, 0xb1, 0x37, 0xb1, 0x38, 0xb1, 0x39, 0xb1, 0x3d, 0xb1, 0x41,
    0xb1, 0x5f, 0xb1, 0x62, 0xb1, 0x64, 0xb1, 0x66, 0xb1, 0x67, 0xb1, 0x68,
    0xb1, 0x6c, 0xb1, 0x6d, 0xb1, 0x6e, 0xb1, 0x70, 0xb1, 0x72, 0xb1, 0x75};
const uint8_t HuffDecoderCommon::table21_34_emit_[72] = {
    0xb3, 0x30, 0xb3, 0x31, 0xb3, 0x32, 0xb3, 0x61, 0xb3, 0x63, 0xb3, 0x65,
    0xb3, 0x69, 0xb3, 0x6f, 0xb3, 0x73, 0xb3, 0x74, 0xb3, 0x20, 0xb3, 0x25,
    0xb3, 0x2d, 0xb3, 0x2e, 0xb3, 0x2f, 0xb3, 0x33, 0xb3, 0x34, 0xb3, 0x35,
    0xb3, 0x36, 0xb3, 0x37, 0xb3, 0x38, 0xb3, 0x39, 0xb3, 0x3d, 0xb3, 0x41,
    0xb3, 0x5f, 0xb3, 0x62, 0xb3, 0x64, 0xb3, 0x66, 0xb3, 0x67, 0xb3, 0x68,
    0xb3, 0x6c, 0xb3, 0x6d, 0xb3, 0x6e, 0xb3, 0x70, 0xb3, 0x72, 0xb3, 0x75};
const uint8_t HuffDecoderCommon::table21_35_emit_[72] = {
    0xd1, 0x30, 0xd1, 0x31, 0xd1, 0x32, 0xd1, 0x61, 0xd1, 0x63, 0xd1, 0x65,
    0xd1, 0x69, 0xd1, 0x6f, 0xd1, 0x73, 0xd1, 0x74, 0xd1, 0x20, 0xd1, 0x25,
    0xd1, 0x2d, 0xd1, 0x2e, 0xd1, 0x2f, 0xd1, 0x33, 0xd1, 0x34, 0xd1, 0x35,
    0xd1, 0x36, 0xd1, 0x37, 0xd1, 0x38, 0xd1, 0x39, 0xd1, 0x3d, 0xd1, 0x41,
    0xd1, 0x5f, 0xd1, 0x62, 0xd1, 0x64, 0xd1, 0x66, 0xd1, 0x67, 0xd1, 0x68,
    0xd1, 0x6c, 0xd1, 0x6d, 0xd1, 0x6e, 0xd1, 0x70, 0xd1, 0x72, 0xd1, 0x75};
const uint8_t HuffDecoderCommon::table21_36_emit_[72] = {
    0xd8, 0x30, 0xd8, 0x31, 0xd8, 0x32, 0xd8, 0x61, 0xd8, 0x63, 0xd8, 0x65,
    0xd8, 0x69, 0xd8, 0x6f, 0xd8, 0x73, 0xd8, 0x74, 0xd8, 0x20, 0xd8, 0x25,
    0xd8, 0x2d, 0xd8, 0x2e, 0xd8, 0x2f, 0xd8, 0x33, 0xd8, 0x34, 0xd8, 0x35,
    0xd8, 0x36, 0xd8, 0x37, 0xd8, 0x38, 0xd8, 0x39, 0xd8, 0x3d, 0xd8, 0x41,
    0xd8, 0x5f, 0xd8, 0x62, 0xd8, 0x64, 0xd8, 0x66, 0xd8, 0x67, 0xd8, 0x68,
    0xd8, 0x6c, 0xd8, 0x6d, 0xd8, 0x6e, 0xd8, 0x70, 0xd8, 0x72, 0xd8, 0x75};
const uint8_t HuffDecoderCommon::table21_37_emit_[72] = {
    0xd9, 0x30, 0xd9, 0x31, 0xd9, 0x32, 0xd9, 0x61, 0xd9, 0x63, 0xd9, 0x65,
    0xd9, 0x69, 0xd9, 0x6f, 0xd9, 0x73, 0xd9, 0x74, 0xd9, 0x20, 0xd9, 0x25,
    0xd9, 0x2d, 0xd9, 0x2e, 0xd9, 0x2f, 0xd9, 0x33, 0xd9, 0x34, 0xd9, 0x35,
    0xd9, 0x36, 0xd9, 0x37, 0xd9, 0x38, 0xd9, 0x39, 0xd9, 0x3d, 0xd9, 0x41,
    0xd9, 0x5f, 0xd9, 0x62, 0xd9, 0x64, 0xd9, 0x66, 0xd9, 0x67, 0xd9, 0x68,
    0xd9, 0x6c, 0xd9, 0x6d, 0xd9, 0x6e, 0xd9, 0x70, 0xd9, 0x72, 0xd9, 0x75};
const uint8_t HuffDecoderCommon::table21_38_emit_[72] = {
    0xe3, 0x30, 0xe3, 0x31, 0xe3, 0x32, 0xe3, 0x61, 0xe3, 0x63, 0xe3, 0x65,
    0xe3, 0x69, 0xe3, 0x6f, 0xe3, 0x73, 0xe3, 0x74, 0xe3, 0x20, 0xe3, 0x25,
    0xe3, 0x2d, 0xe3, 0x2e, 0xe3, 0x2f, 0xe3, 0x33, 0xe3, 0x34, 0xe3, 0x35,
    0xe3, 0x36, 0xe3, 0x37, 0xe3, 0x38, 0xe3, 0x39, 0xe3, 0x3d, 0xe3, 0x41,
    0xe3, 0x5f, 0xe3, 0x62, 0xe3, 0x64, 0xe3, 0x66, 0xe3, 0x67, 0xe3, 0x68,
    0xe3, 0x6c, 0xe3, 0x6d, 0xe3, 0x6e, 0xe3, 0x70, 0xe3, 0x72, 0xe3, 0x75};
const uint8_t HuffDecoderCommon::table21_39_emit_[72] = {
    0xe5, 0x30, 0xe5, 0x31, 0xe5, 0x32, 0xe5, 0x61, 0xe5, 0x63, 0xe5, 0x65,
    0xe5, 0x69, 0xe5, 0x6f, 0xe5, 0x73, 0xe5, 0x74, 0xe5, 0x20, 0xe5, 0x25,
    0xe5, 0x2d, 0xe5, 0x2e, 0xe5, 0x2f, 0xe5, 0x33, 0xe5, 0x34, 0xe5, 0x35,
    0xe5, 0x36, 0xe5, 0x37, 0xe5, 0x38, 0xe5, 0x39, 0xe5, 0x3d, 0xe5, 0x41,
    0xe5, 0x5f, 0xe5, 0x62, 0xe5, 0x64, 0xe5, 0x66, 0xe5, 0x67, 0xe5, 0x68,
    0xe5, 0x6c, 0xe5, 0x6d, 0xe5, 0x6e, 0xe5, 0x70, 0xe5, 0x72, 0xe5, 0x75};
const uint8_t HuffDecoderCommon::table21_40_emit_[72] = {
    0xe6, 0x30, 0xe6, 0x31, 0xe6, 0x32, 0xe6, 0x61, 0xe6, 0x63, 0xe6, 0x65,
    0xe6, 0x69, 0xe6, 0x6f, 0xe6, 0x73, 0xe6, 0x74, 0xe6, 0x20, 0xe6, 0x25,
    0xe6, 0x2d, 0xe6, 0x2e, 0xe6, 0x2f, 0xe6, 0x33, 0xe6, 0x34, 0xe6, 0x35,
    0xe6, 0x36, 0xe6, 0x37, 0xe6, 0x38, 0xe6, 0x39, 0xe6, 0x3d, 0xe6, 0x41,
    0xe6, 0x5f, 0xe6, 0x62, 0xe6, 0x64, 0xe6, 0x66, 0xe6, 0x67, 0xe6, 0x68,
    0xe6, 0x6c, 0xe6, 0x6d, 0xe6, 0x6e, 0xe6, 0x70, 0xe6, 0x72, 0xe6, 0x75};
const uint8_t HuffDecoderCommon::table21_41_emit_[40] = {
    0x81, 0x30, 0x81, 0x31, 0x81, 0x32, 0x81, 0x61, 0x81, 0x63,
    0x81, 0x65, 0x81, 0x69, 0x81, 0x6f, 0x81, 0x73, 0x81, 0x74,
    0x84, 0x30, 0x84, 0x31, 0x84, 0x32, 0x84, 0x61, 0x84, 0x63,
    0x84, 0x65, 0x84, 0x69, 0x84, 0x6f, 0x84, 0x73, 0x84, 0x74};
const uint8_t HuffDecoderCommon::table21_42_emit_[40] = {
    0x85, 0x30, 0x85, 0x31, 0x85, 0x32, 0x85, 0x61, 0x85, 0x63,
    0x85, 0x65, 0x85, 0x69, 0x85, 0x6f, 0x85, 0x73, 0x85, 0x74,
    0x86, 0x30, 0x86, 0x31, 0x86, 0x32, 0x86, 0x61, 0x86, 0x63,
    0x86, 0x65, 0x86, 0x69, 0x86, 0x6f, 0x86, 0x73, 0x86, 0x74};
const uint8_t HuffDecoderCommon::table21_43_emit_[40] = {
    0x88, 0x30, 0x88, 0x31, 0x88, 0x32, 0x88, 0x61, 0x88, 0x63,
    0x88, 0x65, 0x88, 0x69, 0x88, 0x6f, 0x88, 0x73, 0x88, 0x74,
    0x92, 0x30, 0x92, 0x31, 0x92, 0x32, 0x92, 0x61, 0x92, 0x63,
    0x92, 0x65, 0x92, 0x69, 0x92, 0x6f, 0x92, 0x73, 0x92, 0x74};
const uint8_t HuffDecoderCommon::table21_44_emit_[40] = {
    0x9a, 0x30, 0x9a, 0x31, 0x9a, 0x32, 0x9a, 0x61, 0x9a, 0x63,
    0x9a, 0x65, 0x9a, 0x69, 0x9a, 0x6f, 0x9a, 0x73, 0x9a, 0x74,
    0x9c, 0x30, 0x9c, 0x31, 0x9c, 0x32, 0x9c, 0x61, 0x9c, 0x63,
    0x9c, 0x65, 0x9c, 0x69, 0x9c, 0x6f, 0x9c, 0x73, 0x9c, 0x74};
const uint8_t HuffDecoderCommon::table21_45_emit_[40] = {
    0xa0, 0x30, 0xa0, 0x31, 0xa0, 0x32, 0xa0, 0x61, 0xa0, 0x63,
    0xa0, 0x65, 0xa0, 0x69, 0xa0, 0x6f, 0xa0, 0x73, 0xa0, 0x74,
    0xa3, 0x30, 0xa3, 0x31, 0xa3, 0x32, 0xa3, 0x61, 0xa3, 0x63,
    0xa3, 0x65, 0xa3, 0x69, 0xa3, 0x6f, 0xa3, 0x73, 0xa3, 0x74};
const uint8_t HuffDecoderCommon::table21_46_emit_[40] = {
    0xa4, 0x30, 0xa4, 0x31, 0xa4, 0x32, 0xa4, 0x61, 0xa4, 0x63,
    0xa4, 0x65, 0xa4, 0x69, 0xa4, 0x6f, 0xa4, 0x73, 0xa4, 0x74,
    0xa9, 0x30, 0xa9, 0x31, 0xa9, 0x32, 0xa9, 0x61, 0xa9, 0x63,
    0xa9, 0x65, 0xa9, 0x69, 0xa9, 0x6f, 0xa9, 0x73, 0xa9, 0x74};
const uint8_t HuffDecoderCommon::table21_47_emit_[40] = {
    0xaa, 0x30, 0xaa, 0x31, 0xaa, 0x32, 0xaa, 0x61, 0xaa, 0x63,
    0xaa, 0x65, 0xaa, 0x69, 0xaa, 0x6f, 0xaa, 0x73, 0xaa, 0x74,
    0xad, 0x30, 0xad, 0x31, 0xad, 0x32, 0xad, 0x61, 0xad, 0x63,
    0xad, 0x65, 0xad, 0x69, 0xad, 0x6f, 0xad, 0x73, 0xad, 0x74};
const uint8_t HuffDecoderCommon::table21_48_emit_[40] = {
    0xb2, 0x30, 0xb2, 0x31, 0xb2, 0x32, 0xb2, 0x61, 0xb2, 0x63,
    0xb2, 0x65, 0xb2, 0x69, 0xb2, 0x6f, 0xb2, 0x73, 0xb2, 0x74,
    0xb5, 0x30, 0xb5, 0x31, 0xb5, 0x32, 0xb5, 0x61, 0xb5, 0x63,
    0xb5, 0x65, 0xb5, 0x69, 0xb5, 0x6f, 0xb5, 0x73, 0xb5, 0x74};
const uint8_t HuffDecoderCommon::table21_49_emit_[40] = {
    0xb9, 0x30, 0xb9, 0x31, 0xb9, 0x32, 0xb9, 0x61, 0xb9, 0x63,
    0xb9, 0x65, 0xb9, 0x69, 0xb9, 0x6f, 0xb9, 0x73, 0xb9, 0x74,
    0xba, 0x30, 0xba, 0x31, 0xba, 0x32, 0xba, 0x61, 0xba, 0x63,
    0xba, 0x65, 0xba, 0x69, 0xba, 0x6f, 0xba, 0x73, 0xba, 0x74};
const uint8_t HuffDecoderCommon::table21_50_emit_[40] = {
    0xbb, 0x30, 0xbb, 0x31, 0xbb, 0x32, 0xbb, 0x61, 0xbb, 0x63,
    0xbb, 0x65, 0xbb, 0x69, 0xbb, 0x6f, 0xbb, 0x73, 0xbb, 0x74,
    0xbd, 0x30, 0xbd, 0x31, 0xbd, 0x32, 0xbd, 0x61, 0xbd, 0x63,
    0xbd, 0x65, 0xbd, 0x69, 0xbd, 0x6f, 0xbd, 0x73, 0xbd, 0x74};
const uint8_t HuffDecoderCommon::table21_51_emit_[40] = {
    0xbe, 0x30, 0xbe, 0x31, 0xbe, 0x32, 0xbe, 0x61, 0xbe, 0x63,
    0xbe, 0x65, 0xbe, 0x69, 0xbe, 0x6f, 0xbe, 0x73, 0xbe, 0x74,
    0xc4, 0x30, 0xc4, 0x31, 0xc4, 0x32, 0xc4, 0x61, 0xc4, 0x63,
    0xc4, 0x65, 0xc4, 0x69, 0xc4, 0x6f, 0xc4, 0x73, 0xc4, 0x74};
const uint8_t HuffDecoderCommon::table21_52_emit_[40] = {
    0xc6, 0x30, 0xc6, 0x31, 0xc6, 0x32, 0xc6, 0x61, 0xc6, 0x63,
    0xc6, 0x65, 0xc6, 0x69, 0xc6, 0x6f, 0xc6, 0x73, 0xc6, 0x74,
    0xe4, 0x30, 0xe4, 0x31, 0xe4, 0x32, 0xe4, 0x61, 0xe4, 0x63,
    0xe4, 0x65, 0xe4, 0x69, 0xe4, 0x6f, 0xe4, 0x73, 0xe4, 0x74};
const uint8_t HuffDecoderCommon::table21_53_emit_[40] = {
    0xe8, 0x30, 0xe8, 0x31, 0xe8, 0x32, 0xe8, 0x61, 0xe8, 0x63,
    0xe8, 0x65, 0xe8, 0x69, 0xe8, 0x6f, 0xe8, 0x73, 0xe8, 0x74,
    0xe9, 0x30, 0xe9, 0x31, 0xe9, 0x32, 0xe9, 0x61, 0xe9, 0x63,
    0xe9, 0x65, 0xe9, 0x69, 0xe9, 0x6f, 0xe9, 0x73, 0xe9, 0x74};
const uint8_t HuffDecoderCommon::table21_54_emit_[4] = {0x01, 0x87, 0x89, 0x8a};
const uint8_t HuffDecoderCommon::table21_55_emit_[4] = {0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table21_56_emit_[4] = {0x93, 0x95, 0x96, 0x97};
const uint8_t HuffDecoderCommon::table21_57_emit_[4] = {0x98, 0x9b, 0x9d, 0x9e};
const uint8_t HuffDecoderCommon::table21_58_emit_[4] = {0xa5, 0xa6, 0xa8, 0xae};
const uint8_t HuffDecoderCommon::table21_59_emit_[4] = {0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table21_60_emit_[4] = {0xbc, 0xbf, 0xc5, 0xe7};
const uint8_t HuffDecoderCommon::table21_61_emit_[7] = {0xef, 0x09, 0x8e, 0x90,
                                                        0x91, 0x94, 0x9f};
const uint8_t HuffDecoderCommon::table21_62_emit_[10] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table21_62_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x001e,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0026};
const uint8_t HuffDecoderCommon::table21_63_emit_[34] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1,
    0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint16_t HuffDecoderCommon::table21_63_ops_[64] = {
    0x0000, 0x0002, 0x0000, 0x0006, 0x0000, 0x000a, 0x0000, 0x000e,
    0x0000, 0x0012, 0x0000, 0x0016, 0x0000, 0x001a, 0x0000, 0x001e,
    0x0000, 0x0022, 0x0000, 0x0026, 0x0000, 0x002a, 0x0000, 0x002e,
    0x0000, 0x0032, 0x0000, 0x0036, 0x0000, 0x003a, 0x003e, 0x0042,
    0x0046, 0x004a, 0x004e, 0x0052, 0x0056, 0x005a, 0x005e, 0x0062,
    0x0066, 0x006a, 0x006e, 0x0072, 0x0076, 0x007a, 0x007e, 0x0082,
    0x0086, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table21_emit_[64] = {
    table21_0_emit_,  table21_1_emit_,  table21_2_emit_,  table21_3_emit_,
    table21_4_emit_,  table21_5_emit_,  table21_6_emit_,  table21_7_emit_,
    table21_8_emit_,  table21_9_emit_,  table21_10_emit_, table21_11_emit_,
    table21_12_emit_, table21_13_emit_, table21_14_emit_, table21_15_emit_,
    table21_16_emit_, table21_17_emit_, table21_18_emit_, table21_19_emit_,
    table21_20_emit_, table21_21_emit_, table21_22_emit_, table21_23_emit_,
    table21_24_emit_, table21_25_emit_, table21_26_emit_, table21_27_emit_,
    table21_28_emit_, table21_29_emit_, table21_30_emit_, table21_31_emit_,
    table21_32_emit_, table21_33_emit_, table21_34_emit_, table21_35_emit_,
    table21_36_emit_, table21_37_emit_, table21_38_emit_, table21_39_emit_,
    table21_40_emit_, table21_41_emit_, table21_42_emit_, table21_43_emit_,
    table21_44_emit_, table21_45_emit_, table21_46_emit_, table21_47_emit_,
    table21_48_emit_, table21_49_emit_, table21_50_emit_, table21_51_emit_,
    table21_52_emit_, table21_53_emit_, table21_54_emit_, table21_55_emit_,
    table21_56_emit_, table21_57_emit_, table21_58_emit_, table21_59_emit_,
    table21_60_emit_, table21_61_emit_, table21_62_emit_, table21_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table21_ops_[64] = {
    table21_0_ops_, table21_1_ops_,  table21_2_ops_,  table21_3_ops_,
    table21_0_ops_, table21_1_ops_,  table21_2_ops_,  table21_3_ops_,
    table21_0_ops_, table21_1_ops_,  table21_2_ops_,  table21_3_ops_,
    table20_0_ops_, table20_1_ops_,  table20_0_ops_,  table20_1_ops_,
    table20_0_ops_, table20_1_ops_,  table20_0_ops_,  table20_1_ops_,
    table20_0_ops_, table20_1_ops_,  table20_0_ops_,  table20_1_ops_,
    table20_0_ops_, table20_1_ops_,  table20_0_ops_,  table20_1_ops_,
    table19_0_ops_, table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_, table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_, table19_0_ops_,  table19_0_ops_,  table19_0_ops_,
    table19_0_ops_, table19_3_ops_,  table19_3_ops_,  table19_3_ops_,
    table19_3_ops_, table19_3_ops_,  table19_3_ops_,  table19_3_ops_,
    table19_3_ops_, table19_3_ops_,  table19_3_ops_,  table19_3_ops_,
    table19_3_ops_, table19_3_ops_,  table19_7_ops_,  table19_7_ops_,
    table19_7_ops_, table19_7_ops_,  table19_7_ops_,  table19_7_ops_,
    table19_7_ops_, table19_10_ops_, table21_62_ops_, table21_63_ops_,
};
const uint8_t HuffDecoderCommon::table12_0_emit_[1] = {0x5c};
const uint16_t HuffDecoderCommon::table12_0_ops_[128] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004};
const uint8_t HuffDecoderCommon::table12_4_emit_[1] = {0xc3};
const uint8_t HuffDecoderCommon::table12_8_emit_[1] = {0xd0};
const uint8_t HuffDecoderCommon::table12_12_emit_[1] = {0x80};
const uint16_t HuffDecoderCommon::table12_12_ops_[128] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table12_14_emit_[1] = {0x82};
const uint8_t HuffDecoderCommon::table12_16_emit_[1] = {0x83};
const uint8_t HuffDecoderCommon::table12_18_emit_[1] = {0xa2};
const uint8_t HuffDecoderCommon::table12_20_emit_[1] = {0xb8};
const uint8_t HuffDecoderCommon::table12_22_emit_[1] = {0xc2};
const uint8_t HuffDecoderCommon::table12_24_emit_[1] = {0xe0};
const uint8_t HuffDecoderCommon::table12_26_emit_[1] = {0xe2};
const uint8_t HuffDecoderCommon::table12_28_emit_[1] = {0x99};
const uint16_t HuffDecoderCommon::table12_28_ops_[128] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006};
const uint8_t HuffDecoderCommon::table12_29_emit_[1] = {0xa1};
const uint8_t HuffDecoderCommon::table12_30_emit_[1] = {0xa7};
const uint8_t HuffDecoderCommon::table12_31_emit_[1] = {0xac};
const uint8_t HuffDecoderCommon::table12_32_emit_[1] = {0xb0};
const uint8_t HuffDecoderCommon::table12_33_emit_[1] = {0xb1};
const uint8_t HuffDecoderCommon::table12_34_emit_[1] = {0xb3};
const uint8_t HuffDecoderCommon::table12_35_emit_[1] = {0xd1};
const uint8_t HuffDecoderCommon::table12_36_emit_[1] = {0xd8};
const uint8_t HuffDecoderCommon::table12_37_emit_[1] = {0xd9};
const uint8_t HuffDecoderCommon::table12_38_emit_[1] = {0xe3};
const uint8_t HuffDecoderCommon::table12_39_emit_[1] = {0xe5};
const uint8_t HuffDecoderCommon::table12_40_emit_[1] = {0xe6};
const uint8_t HuffDecoderCommon::table12_41_emit_[2] = {0x81, 0x84};
const uint16_t HuffDecoderCommon::table12_41_ops_[128] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027};
const uint8_t HuffDecoderCommon::table12_42_emit_[2] = {0x85, 0x86};
const uint8_t HuffDecoderCommon::table12_43_emit_[2] = {0x88, 0x92};
const uint8_t HuffDecoderCommon::table12_44_emit_[2] = {0x9a, 0x9c};
const uint8_t HuffDecoderCommon::table12_45_emit_[2] = {0xa0, 0xa3};
const uint8_t HuffDecoderCommon::table12_46_emit_[2] = {0xa4, 0xa9};
const uint8_t HuffDecoderCommon::table12_47_emit_[2] = {0xaa, 0xad};
const uint8_t HuffDecoderCommon::table12_48_emit_[2] = {0xb2, 0xb5};
const uint8_t HuffDecoderCommon::table12_49_emit_[2] = {0xb9, 0xba};
const uint8_t HuffDecoderCommon::table12_50_emit_[2] = {0xbb, 0xbd};
const uint8_t HuffDecoderCommon::table12_51_emit_[2] = {0xbe, 0xc4};
const uint8_t HuffDecoderCommon::table12_52_emit_[2] = {0xc6, 0xe4};
const uint8_t HuffDecoderCommon::table12_53_emit_[2] = {0xe8, 0xe9};
const uint16_t HuffDecoderCommon::table12_54_ops_[128] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068};
const uint16_t HuffDecoderCommon::table12_61_ops_[128] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x00a9, 0x00a9, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9};
const uint16_t HuffDecoderCommon::table12_62_ops_[128] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00ca, 0x00ca, 0x00ca,
    0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
    0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
    0x010a, 0x010a, 0x010a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a,
    0x012a, 0x012a};
const uint8_t HuffDecoderCommon::table12_63_emit_[63] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee,
    0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde,
    0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd,
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint16_t HuffDecoderCommon::table12_63_ops_[128] = {
    0x000b, 0x000b, 0x000b, 0x000b, 0x002b, 0x002b, 0x002b, 0x002b, 0x004b,
    0x004b, 0x004b, 0x004b, 0x006b, 0x006b, 0x006b, 0x006b, 0x008b, 0x008b,
    0x008b, 0x008b, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00cb, 0x00cb, 0x00cb,
    0x00cb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x010b, 0x010b, 0x010b, 0x010b,
    0x012b, 0x012b, 0x012b, 0x012b, 0x014b, 0x014b, 0x014b, 0x014b, 0x016b,
    0x016b, 0x016b, 0x016b, 0x018b, 0x018b, 0x018b, 0x018b, 0x01ab, 0x01ab,
    0x01ab, 0x01ab, 0x01cb, 0x01cb, 0x01cb, 0x01cb, 0x01ec, 0x01ec, 0x020c,
    0x020c, 0x022c, 0x022c, 0x024c, 0x024c, 0x026c, 0x026c, 0x028c, 0x028c,
    0x02ac, 0x02ac, 0x02cc, 0x02cc, 0x02ec, 0x02ec, 0x030c, 0x030c, 0x032c,
    0x032c, 0x034c, 0x034c, 0x036c, 0x036c, 0x038c, 0x038c, 0x03ac, 0x03ac,
    0x03cc, 0x03cc, 0x03ec, 0x03ec, 0x040c, 0x040c, 0x042c, 0x042c, 0x044d,
    0x046d, 0x048d, 0x04ad, 0x04cd, 0x04ed, 0x050d, 0x052d, 0x054d, 0x056d,
    0x058d, 0x05ad, 0x05cd, 0x05ed, 0x060d, 0x062d, 0x064d, 0x066d, 0x068d,
    0x06ad, 0x06cd, 0x06ed, 0x070d, 0x072d, 0x074d, 0x076d, 0x078d, 0x07ad,
    0x07cd, 0x001d};
const uint8_t* const HuffDecoderCommon::table12_emit_[64] = {
    table12_0_emit_,  table12_0_emit_,  table12_0_emit_,  table12_0_emit_,
    table12_4_emit_,  table12_4_emit_,  table12_4_emit_,  table12_4_emit_,
    table12_8_emit_,  table12_8_emit_,  table12_8_emit_,  table12_8_emit_,
    table12_12_emit_, table12_12_emit_, table12_14_emit_, table12_14_emit_,
    table12_16_emit_, table12_16_emit_, table12_18_emit_, table12_18_emit_,
    table12_20_emit_, table12_20_emit_, table12_22_emit_, table12_22_emit_,
    table12_24_emit_, table12_24_emit_, table12_26_emit_, table12_26_emit_,
    table12_28_emit_, table12_29_emit_, table12_30_emit_, table12_31_emit_,
    table12_32_emit_, table12_33_emit_, table12_34_emit_, table12_35_emit_,
    table12_36_emit_, table12_37_emit_, table12_38_emit_, table12_39_emit_,
    table12_40_emit_, table12_41_emit_, table12_42_emit_, table12_43_emit_,
    table12_44_emit_, table12_45_emit_, table12_46_emit_, table12_47_emit_,
    table12_48_emit_, table12_49_emit_, table12_50_emit_, table12_51_emit_,
    table12_52_emit_, table12_53_emit_, table21_54_emit_, table21_55_emit_,
    table21_56_emit_, table21_57_emit_, table21_58_emit_, table21_59_emit_,
    table21_60_emit_, table21_61_emit_, table21_62_emit_, table12_63_emit_,
};
const uint16_t* const HuffDecoderCommon::table12_ops_[64] = {
    table12_0_ops_,  table12_0_ops_,  table12_0_ops_,  table12_0_ops_,
    table12_0_ops_,  table12_0_ops_,  table12_0_ops_,  table12_0_ops_,
    table12_0_ops_,  table12_0_ops_,  table12_0_ops_,  table12_0_ops_,
    table12_12_ops_, table12_12_ops_, table12_12_ops_, table12_12_ops_,
    table12_12_ops_, table12_12_ops_, table12_12_ops_, table12_12_ops_,
    table12_12_ops_, table12_12_ops_, table12_12_ops_, table12_12_ops_,
    table12_12_ops_, table12_12_ops_, table12_12_ops_, table12_12_ops_,
    table12_28_ops_, table12_28_ops_, table12_28_ops_, table12_28_ops_,
    table12_28_ops_, table12_28_ops_, table12_28_ops_, table12_28_ops_,
    table12_28_ops_, table12_28_ops_, table12_28_ops_, table12_28_ops_,
    table12_28_ops_, table12_41_ops_, table12_41_ops_, table12_41_ops_,
    table12_41_ops_, table12_41_ops_, table12_41_ops_, table12_41_ops_,
    table12_41_ops_, table12_41_ops_, table12_41_ops_, table12_41_ops_,
    table12_41_ops_, table12_41_ops_, table12_54_ops_, table12_54_ops_,
    table12_54_ops_, table12_54_ops_, table12_54_ops_, table12_54_ops_,
    table12_54_ops_, table12_61_ops_, table12_62_ops_, table12_63_ops_,
};
}  // namespace geometry_15_13
}  // namespace grpc_core
