// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +zksh -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV32ZKSH
// RUN: %clang_cc1 -triple riscv64 -target-feature +zksh -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s  -check-prefix=RV64ZKSH

#include <riscv_crypto.h>

// RV32ZKSH-LABEL: @sm3p0(
// RV32ZKSH-NEXT:  entry:
// RV32ZKSH-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.sm3p0(i32 [[RS1:%.*]])
// RV32ZKSH-NEXT:    ret i32 [[TMP0]]
//
// RV64ZKSH-LABEL: @sm3p0(
// RV64ZKSH-NEXT:  entry:
// RV64ZKSH-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.sm3p0(i32 [[RS1:%.*]])
// RV64ZKSH-NEXT:    ret i32 [[TMP0]]
//
uint32_t sm3p0(uint32_t rs1) {
  return __riscv_sm3p0(rs1);
}


// RV32ZKSH-LABEL: @sm3p1(
// RV32ZKSH-NEXT:  entry:
// RV32ZKSH-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.sm3p1(i32 [[RS1:%.*]])
// RV32ZKSH-NEXT:    ret i32 [[TMP0]]
//
// RV64ZKSH-LABEL: @sm3p1(
// RV64ZKSH-NEXT:  entry:
// RV64ZKSH-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.sm3p1(i32 [[RS1:%.*]])
// RV64ZKSH-NEXT:    ret i32 [[TMP0]]
//
uint32_t sm3p1(uint32_t rs1) {
  return __riscv_sm3p1(rs1);
}
