.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XKeymapEvent __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XKeymapEvent \- KeymapNotify event structure
.SH STRUCTURES
The structure for
.B KeymapNotify
events contains:
.LP
.EX
/\&* generated on EnterWindow and FocusIn when KeymapState selected */
typedef struct {
        int type;       /\&* KeymapNotify */
        unsigned long serial;   /\&* # of last request processed by server */
        Bool send_event;        /\&* true if this came from a SendEvent request */
        Display *display;       /\&* Display the event was read from */
        Window window;
        char key_vector[32];
} XKeymapEvent;
.EE
.LP
When you receive this event,
the structure members are set as follows.
.LP
The type member is set to the event type constant name that uniquely identifies
it.
For example, when the X server reports a
.B GraphicsExpose
event to a client application, it sends an
.B XGraphicsExposeEvent
structure with the type member set to
.BR GraphicsExpose .
The display member is set to a pointer to the display the event was read on.
The send_event member is set to
.B True
if the event came from a
.B SendEvent
protocol request.
The serial member is set from the serial number reported in the protocol
but expanded from the 16-bit least-significant bits to a full 32-bit value.
The window member is set to the window that is most useful to toolkit
dispatchers.
.LP
The window member is not used but is present to aid some toolkits.
The key_vector member is set to the bit vector of the keyboard.
Each bit set to 1 indicates that the corresponding key
is currently pressed.
The vector is represented as 32 bytes.
Byte N (from 0) contains the bits for keys 8N to 8N + 7
with the least significant bit in the byte representing key 8N.
.SH "SEE ALSO"
XAnyEvent(__libmansuffix__),
XButtonEvent(__libmansuffix__),
XCreateWindowEvent(__libmansuffix__),
XCirculateEvent(__libmansuffix__),
XCirculateRequestEvent(__libmansuffix__),
XColormapEvent(__libmansuffix__),
XConfigureEvent(__libmansuffix__),
XConfigureRequestEvent(__libmansuffix__),
XCrossingEvent(__libmansuffix__),
XDestroyWindowEvent(__libmansuffix__),
XErrorEvent(__libmansuffix__),
XExposeEvent(__libmansuffix__),
XFocusChangeEvent(__libmansuffix__),
XGraphicsExposeEvent(__libmansuffix__),
XGravityEvent(__libmansuffix__),
XMapEvent(__libmansuffix__),
XMapRequestEvent(__libmansuffix__),
XPropertyEvent(__libmansuffix__),
XReparentEvent(__libmansuffix__),
XResizeRequestEvent(__libmansuffix__),
XSelectionClearEvent(__libmansuffix__),
XSelectionEvent(__libmansuffix__),
XSelectionRequestEvent(__libmansuffix__),
XUnmapEvent(__libmansuffix__),
XVisibilityEvent(__libmansuffix__)
.br
\fI\*(xL\fP
