/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.flutter.Log;
import io.flutter.plugin.platform.SingleViewFakeWindowViewGroup;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

abstract class SingleViewWindowManager
implements WindowManager {
    private static final String TAG = "PlatformViewsController";
    final WindowManager delegate;
    SingleViewFakeWindowViewGroup fakeWindowRootView;

    SingleViewWindowManager(WindowManager delegate, SingleViewFakeWindowViewGroup fakeWindowViewGroup) {
        this.delegate = delegate;
        this.fakeWindowRootView = fakeWindowViewGroup;
    }

    @Deprecated
    public Display getDefaultDisplay() {
        return this.delegate.getDefaultDisplay();
    }

    public void removeViewImmediate(View view) {
        if (this.fakeWindowRootView == null) {
            Log.w(TAG, "Embedded view called removeViewImmediate while detached from presentation");
            return;
        }
        view.clearAnimation();
        this.fakeWindowRootView.removeView(view);
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        if (this.fakeWindowRootView == null) {
            Log.w(TAG, "Embedded view called addView while detached from presentation");
            return;
        }
        this.fakeWindowRootView.addView(view, params);
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        if (this.fakeWindowRootView == null) {
            Log.w(TAG, "Embedded view called updateViewLayout while detached from presentation");
            return;
        }
        this.fakeWindowRootView.updateViewLayout(view, params);
    }

    public void removeView(View view) {
        if (this.fakeWindowRootView == null) {
            Log.w(TAG, "Embedded view called removeView while detached from presentation");
            return;
        }
        this.fakeWindowRootView.removeView(view);
    }

    @RequiresApi(api=30)
    @NonNull
    public WindowMetrics getCurrentWindowMetrics() {
        return this.delegate.getCurrentWindowMetrics();
    }

    @RequiresApi(api=30)
    @NonNull
    public WindowMetrics getMaximumWindowMetrics() {
        return this.delegate.getMaximumWindowMetrics();
    }

    @RequiresApi(api=31)
    public boolean isCrossWindowBlurEnabled() {
        return this.delegate.isCrossWindowBlurEnabled();
    }

    @RequiresApi(api=31)
    public void addCrossWindowBlurEnabledListener(@NonNull Consumer<Boolean> listener) {
        this.delegate.addCrossWindowBlurEnabledListener(listener);
    }

    @RequiresApi(api=31)
    public void addCrossWindowBlurEnabledListener(@NonNull Executor executor, @NonNull Consumer<Boolean> listener) {
        this.delegate.addCrossWindowBlurEnabledListener(executor, listener);
    }

    @RequiresApi(api=31)
    public void removeCrossWindowBlurEnabledListener(@NonNull Consumer<Boolean> listener) {
        this.delegate.removeCrossWindowBlurEnabledListener(listener);
    }
}

