// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'D'.
class PartD {
  /// Applies the DM Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Mono
  static TextStyle dmMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ff334baf94fa64c73ee943b528b734656c98dfaee175025a796a21066dfb6a0',
        28092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '72d9ace813762218c3d761058169bb89da3755116610523ad455fba80d838b32',
        29252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b99c005612081b9d6aab1d23679a2a20c304b46e963201d315c06c28ca25eadc',
        28128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '104a4afc4b0a5e735734312132abffb54a40b2f78e7302cc9fd5201cd0943bb2',
        29264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f83244fb95aa75e3aec6465372381691aae04a3ac26b308a8357449a8a34567e',
        27964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd9484b55dc0127df05769db899c40cd6afcdb390fb899ba3f4ddfbc3be86e1b1',
        29284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DMMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DM Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Mono
  static TextTheme dmMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dmMono(textStyle: textTheme.displayLarge),
      displayMedium: dmMono(textStyle: textTheme.displayMedium),
      displaySmall: dmMono(textStyle: textTheme.displaySmall),
      headlineLarge: dmMono(textStyle: textTheme.headlineLarge),
      headlineMedium: dmMono(textStyle: textTheme.headlineMedium),
      headlineSmall: dmMono(textStyle: textTheme.headlineSmall),
      titleLarge: dmMono(textStyle: textTheme.titleLarge),
      titleMedium: dmMono(textStyle: textTheme.titleMedium),
      titleSmall: dmMono(textStyle: textTheme.titleSmall),
      bodyLarge: dmMono(textStyle: textTheme.bodyLarge),
      bodyMedium: dmMono(textStyle: textTheme.bodyMedium),
      bodySmall: dmMono(textStyle: textTheme.bodySmall),
      labelLarge: dmMono(textStyle: textTheme.labelLarge),
      labelMedium: dmMono(textStyle: textTheme.labelMedium),
      labelSmall: dmMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the DM Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Sans
  static TextStyle dmSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '293d525f5f7eace6f5028ebc08c6ca1098331e387a052586be24a247b3195f05',
        48268,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21d8f6e1b66bbfcffa43f5f3ea401735db985548cc18dc9ddf3b0406ab14dc6c',
        48332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e65de0f51603623fdb30ca0dcc06e67d79317c9cd4443128be7aa18fc7fddc9c',
        48272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '62a6648bbb53317b26f816c0b0c150e44d80122e76ad0b26b7e4c381638875b2',
        48260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1f423f47d938e29fc63bb611c0748be76c741f06cdb87bcc29d5708ab203f29',
        48284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0c74b9d542f889adc76fa025d198009e44fccf5c10fdce8a1bf418a57db56b3',
        48256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd50723da93e1a86c8294fca68377dc976a5b63756825fd1622a9f354e070089b',
        48176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea3f8d2d917cb2f043469bc29b2afa4f79ef9fbb350578b58f31b87b8299cc7b',
        48248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42fe4d68768d016ddbf7ba67b5a9e2ac795ffea922cf3fe41b08aa996c0d33b8',
        48272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e1b6f371ccf581ecb2eb974512122f345ca7e8990b6e1b8f94733640d5092f93',
        51228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a2058e87a0a5d111e195e5ea9edef8382dfa86b5833aeb0738e2f90c64a11fcf',
        51292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '58e9f109ba1bbcdc14f3e1ab31ef55526ddc2fc5172d025a77776febdf51d701',
        51240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a84455c117c252e20b3be0101a6113cc1ab3948e77de4d4e461ac313acaceeb2',
        51120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '425993280db3ad011ffdcda0b664836c390b4831e448b3954d7035629a638eb9',
        51260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd64df25038e907f5c4fcb5826e7fdeea0007266929f8e06ae8cbb34297aa66f7',
        51132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b16d369fee56c81f5e5d5adef22858d0aa38db534d9b768bfedfb1466916fe4',
        51104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e2c04c0d83f4e5c04c5cc609b6546bac64f401be427a11883736786865be9276',
        51212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '73dcba47f0e327998ca98a504f12d2facd80ede363574f94f5ab41893fbe0ad5',
        51124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DMSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DM Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Sans
  static TextTheme dmSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dmSans(textStyle: textTheme.displayLarge),
      displayMedium: dmSans(textStyle: textTheme.displayMedium),
      displaySmall: dmSans(textStyle: textTheme.displaySmall),
      headlineLarge: dmSans(textStyle: textTheme.headlineLarge),
      headlineMedium: dmSans(textStyle: textTheme.headlineMedium),
      headlineSmall: dmSans(textStyle: textTheme.headlineSmall),
      titleLarge: dmSans(textStyle: textTheme.titleLarge),
      titleMedium: dmSans(textStyle: textTheme.titleMedium),
      titleSmall: dmSans(textStyle: textTheme.titleSmall),
      bodyLarge: dmSans(textStyle: textTheme.bodyLarge),
      bodyMedium: dmSans(textStyle: textTheme.bodyMedium),
      bodySmall: dmSans(textStyle: textTheme.bodySmall),
      labelLarge: dmSans(textStyle: textTheme.labelLarge),
      labelMedium: dmSans(textStyle: textTheme.labelMedium),
      labelSmall: dmSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the DM Serif Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Serif+Display
  static TextStyle dmSerifDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc1fbdc15a55aed5cd062b1714e00fc5273739476643f0b1f16b567f491660ba',
        52644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fe24375d0d73b90fae5e0a7785b66f8ddd2bcdcde9c158d3a18e2474a3247dfc',
        50608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DMSerifDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DM Serif Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Serif+Display
  static TextTheme dmSerifDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dmSerifDisplay(textStyle: textTheme.displayLarge),
      displayMedium: dmSerifDisplay(textStyle: textTheme.displayMedium),
      displaySmall: dmSerifDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: dmSerifDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: dmSerifDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: dmSerifDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: dmSerifDisplay(textStyle: textTheme.titleLarge),
      titleMedium: dmSerifDisplay(textStyle: textTheme.titleMedium),
      titleSmall: dmSerifDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: dmSerifDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: dmSerifDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: dmSerifDisplay(textStyle: textTheme.bodySmall),
      labelLarge: dmSerifDisplay(textStyle: textTheme.labelLarge),
      labelMedium: dmSerifDisplay(textStyle: textTheme.labelMedium),
      labelSmall: dmSerifDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the DM Serif Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Serif+Text
  static TextStyle dmSerifText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1cb8113b59d3123e9b88873758b7287d076f20e8f0a643ee32853aaaa498ed9',
        52688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ca8e3bda889c19ab008b6a3da757e4ab64a31664792d4975df42bc823f028025',
        50420,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DMSerifText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DM Serif Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DM+Serif+Text
  static TextTheme dmSerifTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dmSerifText(textStyle: textTheme.displayLarge),
      displayMedium: dmSerifText(textStyle: textTheme.displayMedium),
      displaySmall: dmSerifText(textStyle: textTheme.displaySmall),
      headlineLarge: dmSerifText(textStyle: textTheme.headlineLarge),
      headlineMedium: dmSerifText(textStyle: textTheme.headlineMedium),
      headlineSmall: dmSerifText(textStyle: textTheme.headlineSmall),
      titleLarge: dmSerifText(textStyle: textTheme.titleLarge),
      titleMedium: dmSerifText(textStyle: textTheme.titleMedium),
      titleSmall: dmSerifText(textStyle: textTheme.titleSmall),
      bodyLarge: dmSerifText(textStyle: textTheme.bodyLarge),
      bodyMedium: dmSerifText(textStyle: textTheme.bodyMedium),
      bodySmall: dmSerifText(textStyle: textTheme.bodySmall),
      labelLarge: dmSerifText(textStyle: textTheme.labelLarge),
      labelMedium: dmSerifText(textStyle: textTheme.labelMedium),
      labelSmall: dmSerifText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dai Banna SIL font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dai+Banna+SIL
  static TextStyle daiBannaSil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8b58049c437bd3288ffcc7a67ac4124ee6dc044bae772e4457a650c7ae776b8',
        51996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e089802eb4875f1b79aa372bfca86fd4d3140bafef71c59b20d625e9cbd511cb',
        55384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '44dbdd8e54d7e22f6aeec2b0e7aced4aa78268a03028e18a555ffe68f139f109',
        51720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1c53ef31d81830b0a03c5e0b5fa44708cf0b880fbe02547b3dfd9c47178095b2',
        55300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f13a00387309caf2cab0a34b7aaea1b206cb7a21d922a20fb0ff5efb5ff2e67f',
        51776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a0b57fc5c0542ca292e3b4915925f60f6e5806088093f57179a52cb8e1d5d067',
        55568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dae227f92d1dc91caa3b1367cb334dc7b94ff2b4d9886bdf61b9fbe50e884a12',
        52172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd5616fd01531158a3aa11e2979892afaedd3dd1b47a62642335b13d9197c4292',
        55984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80ddb3b55a5f36b120e41645c94e49c1f8c0efb29f03a00d51c8d0e951f1500b',
        53064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'da0ec4eeac5f684b8a7e9d648092b4b3042b12db53e19685ea5c001ae97e9b41',
        56796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DaiBannaSIL',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dai Banna SIL font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dai+Banna+SIL
  static TextTheme daiBannaSilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: daiBannaSil(textStyle: textTheme.displayLarge),
      displayMedium: daiBannaSil(textStyle: textTheme.displayMedium),
      displaySmall: daiBannaSil(textStyle: textTheme.displaySmall),
      headlineLarge: daiBannaSil(textStyle: textTheme.headlineLarge),
      headlineMedium: daiBannaSil(textStyle: textTheme.headlineMedium),
      headlineSmall: daiBannaSil(textStyle: textTheme.headlineSmall),
      titleLarge: daiBannaSil(textStyle: textTheme.titleLarge),
      titleMedium: daiBannaSil(textStyle: textTheme.titleMedium),
      titleSmall: daiBannaSil(textStyle: textTheme.titleSmall),
      bodyLarge: daiBannaSil(textStyle: textTheme.bodyLarge),
      bodyMedium: daiBannaSil(textStyle: textTheme.bodyMedium),
      bodySmall: daiBannaSil(textStyle: textTheme.bodySmall),
      labelLarge: daiBannaSil(textStyle: textTheme.labelLarge),
      labelMedium: daiBannaSil(textStyle: textTheme.labelMedium),
      labelSmall: daiBannaSil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Damion font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Damion
  static TextStyle damion({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d625c14324a2a339caf3816f5e3ce355702b16814eb59349eeb0e9058975479',
        35916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Damion',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Damion font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Damion
  static TextTheme damionTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: damion(textStyle: textTheme.displayLarge),
      displayMedium: damion(textStyle: textTheme.displayMedium),
      displaySmall: damion(textStyle: textTheme.displaySmall),
      headlineLarge: damion(textStyle: textTheme.headlineLarge),
      headlineMedium: damion(textStyle: textTheme.headlineMedium),
      headlineSmall: damion(textStyle: textTheme.headlineSmall),
      titleLarge: damion(textStyle: textTheme.titleLarge),
      titleMedium: damion(textStyle: textTheme.titleMedium),
      titleSmall: damion(textStyle: textTheme.titleSmall),
      bodyLarge: damion(textStyle: textTheme.bodyLarge),
      bodyMedium: damion(textStyle: textTheme.bodyMedium),
      bodySmall: damion(textStyle: textTheme.bodySmall),
      labelLarge: damion(textStyle: textTheme.labelLarge),
      labelMedium: damion(textStyle: textTheme.labelMedium),
      labelSmall: damion(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dancing Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dancing+Script
  static TextStyle dancingScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e630b571b182bb2e337c4e40adeaa86cc05fabf97a99f9c8ee4ecd1d52f6c515',
        76316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b97af074132e89b2be1f792f6672a6884412c2d7f72b98123fd7e4f96603e01',
        76648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6dd9c99912a6635dcd3fb155ed2c4b0dc8cf7f9733aa1f8540d97c9792228c13',
        76640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8eefc65f0eb2173bd338931af2c7b501f9b617c44be72185e3743cb62a48d34c',
        76572,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DancingScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dancing Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dancing+Script
  static TextTheme dancingScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dancingScript(textStyle: textTheme.displayLarge),
      displayMedium: dancingScript(textStyle: textTheme.displayMedium),
      displaySmall: dancingScript(textStyle: textTheme.displaySmall),
      headlineLarge: dancingScript(textStyle: textTheme.headlineLarge),
      headlineMedium: dancingScript(textStyle: textTheme.headlineMedium),
      headlineSmall: dancingScript(textStyle: textTheme.headlineSmall),
      titleLarge: dancingScript(textStyle: textTheme.titleLarge),
      titleMedium: dancingScript(textStyle: textTheme.titleMedium),
      titleSmall: dancingScript(textStyle: textTheme.titleSmall),
      bodyLarge: dancingScript(textStyle: textTheme.bodyLarge),
      bodyMedium: dancingScript(textStyle: textTheme.bodyMedium),
      bodySmall: dancingScript(textStyle: textTheme.bodySmall),
      labelLarge: dancingScript(textStyle: textTheme.labelLarge),
      labelMedium: dancingScript(textStyle: textTheme.labelMedium),
      labelSmall: dancingScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dangrek font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dangrek
  static TextStyle dangrek({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69a0c9e60b6dd9801a97085e57a28499d4d943dc507570c2a6d00cf776a9f585',
        38976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dangrek',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dangrek font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dangrek
  static TextTheme dangrekTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dangrek(textStyle: textTheme.displayLarge),
      displayMedium: dangrek(textStyle: textTheme.displayMedium),
      displaySmall: dangrek(textStyle: textTheme.displaySmall),
      headlineLarge: dangrek(textStyle: textTheme.headlineLarge),
      headlineMedium: dangrek(textStyle: textTheme.headlineMedium),
      headlineSmall: dangrek(textStyle: textTheme.headlineSmall),
      titleLarge: dangrek(textStyle: textTheme.titleLarge),
      titleMedium: dangrek(textStyle: textTheme.titleMedium),
      titleSmall: dangrek(textStyle: textTheme.titleSmall),
      bodyLarge: dangrek(textStyle: textTheme.bodyLarge),
      bodyMedium: dangrek(textStyle: textTheme.bodyMedium),
      bodySmall: dangrek(textStyle: textTheme.bodySmall),
      labelLarge: dangrek(textStyle: textTheme.labelLarge),
      labelMedium: dangrek(textStyle: textTheme.labelMedium),
      labelSmall: dangrek(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Darker Grotesque font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Darker+Grotesque
  static TextStyle darkerGrotesque({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2acc32ed45258114e762421600dd0a599d6cbdb4943142182f09d2cc6f9db3b7',
        47640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80d13b60b4330594d59a0f4d5de81eff78b0d1a9bad9ba5b23fd0a00c49d91a1',
        47752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '593f886ab678262b054f5805a0272cd7bf53d17e1cdffe702adc48810ae80662',
        47720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd623721d07922987ec540ca0e5d8eec2f5905a55dfa9c4b15b709482c9560f1e',
        47744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4da7c489dc43fcd166c32d55ad917eb6b1aa0a0965d2fdb63ac6275a7eae3664',
        47724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbf707d6e6e9cd08c4df6f20242520cb32340b98f1429b691b80f1f8fc20f235',
        47688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8c63a88f2d3bb7ba7dce056242f2cfbce2c23bb6f79aed0e343fa008f909fcf',
        47440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DarkerGrotesque',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Darker Grotesque font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Darker+Grotesque
  static TextTheme darkerGrotesqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: darkerGrotesque(textStyle: textTheme.displayLarge),
      displayMedium: darkerGrotesque(textStyle: textTheme.displayMedium),
      displaySmall: darkerGrotesque(textStyle: textTheme.displaySmall),
      headlineLarge: darkerGrotesque(textStyle: textTheme.headlineLarge),
      headlineMedium: darkerGrotesque(textStyle: textTheme.headlineMedium),
      headlineSmall: darkerGrotesque(textStyle: textTheme.headlineSmall),
      titleLarge: darkerGrotesque(textStyle: textTheme.titleLarge),
      titleMedium: darkerGrotesque(textStyle: textTheme.titleMedium),
      titleSmall: darkerGrotesque(textStyle: textTheme.titleSmall),
      bodyLarge: darkerGrotesque(textStyle: textTheme.bodyLarge),
      bodyMedium: darkerGrotesque(textStyle: textTheme.bodyMedium),
      bodySmall: darkerGrotesque(textStyle: textTheme.bodySmall),
      labelLarge: darkerGrotesque(textStyle: textTheme.labelLarge),
      labelMedium: darkerGrotesque(textStyle: textTheme.labelMedium),
      labelSmall: darkerGrotesque(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Darumadrop One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Darumadrop+One
  static TextStyle darumadropOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '570b43588bf4d733c28f7a0e7d7f1feeb34a4575e239116740b7c525442a3118',
        358396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DarumadropOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Darumadrop One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Darumadrop+One
  static TextTheme darumadropOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: darumadropOne(textStyle: textTheme.displayLarge),
      displayMedium: darumadropOne(textStyle: textTheme.displayMedium),
      displaySmall: darumadropOne(textStyle: textTheme.displaySmall),
      headlineLarge: darumadropOne(textStyle: textTheme.headlineLarge),
      headlineMedium: darumadropOne(textStyle: textTheme.headlineMedium),
      headlineSmall: darumadropOne(textStyle: textTheme.headlineSmall),
      titleLarge: darumadropOne(textStyle: textTheme.titleLarge),
      titleMedium: darumadropOne(textStyle: textTheme.titleMedium),
      titleSmall: darumadropOne(textStyle: textTheme.titleSmall),
      bodyLarge: darumadropOne(textStyle: textTheme.bodyLarge),
      bodyMedium: darumadropOne(textStyle: textTheme.bodyMedium),
      bodySmall: darumadropOne(textStyle: textTheme.bodySmall),
      labelLarge: darumadropOne(textStyle: textTheme.labelLarge),
      labelMedium: darumadropOne(textStyle: textTheme.labelMedium),
      labelSmall: darumadropOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the David Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/David+Libre
  static TextStyle davidLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e153f5e8f6fff8c254d7733b84d18a6ccd117f9f0cfee49fe461dd20841d043c',
        85096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60bb0c7e7e67600b3af4e8b238c3c1e9234e98c0194594a39794db1dac7b56cf',
        85472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5682ff7de5c0f7baba5d5b05b12987b0dc8e8b7ac861a7d88f8cf603b951581a',
        86424,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DavidLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the David Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/David+Libre
  static TextTheme davidLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: davidLibre(textStyle: textTheme.displayLarge),
      displayMedium: davidLibre(textStyle: textTheme.displayMedium),
      displaySmall: davidLibre(textStyle: textTheme.displaySmall),
      headlineLarge: davidLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: davidLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: davidLibre(textStyle: textTheme.headlineSmall),
      titleLarge: davidLibre(textStyle: textTheme.titleLarge),
      titleMedium: davidLibre(textStyle: textTheme.titleMedium),
      titleSmall: davidLibre(textStyle: textTheme.titleSmall),
      bodyLarge: davidLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: davidLibre(textStyle: textTheme.bodyMedium),
      bodySmall: davidLibre(textStyle: textTheme.bodySmall),
      labelLarge: davidLibre(textStyle: textTheme.labelLarge),
      labelMedium: davidLibre(textStyle: textTheme.labelMedium),
      labelSmall: davidLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dawning of a New Day font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dawning+of+a+New+Day
  static TextStyle dawningOfANewDay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0f9c4b9a3b73d432a325f5657aa22dd916e63c7413f3a8eea76c0718a4b1365',
        50148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DawningofaNewDay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dawning of a New Day font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dawning+of+a+New+Day
  static TextTheme dawningOfANewDayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dawningOfANewDay(textStyle: textTheme.displayLarge),
      displayMedium: dawningOfANewDay(textStyle: textTheme.displayMedium),
      displaySmall: dawningOfANewDay(textStyle: textTheme.displaySmall),
      headlineLarge: dawningOfANewDay(textStyle: textTheme.headlineLarge),
      headlineMedium: dawningOfANewDay(textStyle: textTheme.headlineMedium),
      headlineSmall: dawningOfANewDay(textStyle: textTheme.headlineSmall),
      titleLarge: dawningOfANewDay(textStyle: textTheme.titleLarge),
      titleMedium: dawningOfANewDay(textStyle: textTheme.titleMedium),
      titleSmall: dawningOfANewDay(textStyle: textTheme.titleSmall),
      bodyLarge: dawningOfANewDay(textStyle: textTheme.bodyLarge),
      bodyMedium: dawningOfANewDay(textStyle: textTheme.bodyMedium),
      bodySmall: dawningOfANewDay(textStyle: textTheme.bodySmall),
      labelLarge: dawningOfANewDay(textStyle: textTheme.labelLarge),
      labelMedium: dawningOfANewDay(textStyle: textTheme.labelMedium),
      labelSmall: dawningOfANewDay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Days One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Days+One
  static TextStyle daysOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5faba5029439f25f602d79eec007a3352e57cd3ea53fee51859f0e4bf4497230',
        62680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DaysOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Days One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Days+One
  static TextTheme daysOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: daysOne(textStyle: textTheme.displayLarge),
      displayMedium: daysOne(textStyle: textTheme.displayMedium),
      displaySmall: daysOne(textStyle: textTheme.displaySmall),
      headlineLarge: daysOne(textStyle: textTheme.headlineLarge),
      headlineMedium: daysOne(textStyle: textTheme.headlineMedium),
      headlineSmall: daysOne(textStyle: textTheme.headlineSmall),
      titleLarge: daysOne(textStyle: textTheme.titleLarge),
      titleMedium: daysOne(textStyle: textTheme.titleMedium),
      titleSmall: daysOne(textStyle: textTheme.titleSmall),
      bodyLarge: daysOne(textStyle: textTheme.bodyLarge),
      bodyMedium: daysOne(textStyle: textTheme.bodyMedium),
      bodySmall: daysOne(textStyle: textTheme.bodySmall),
      labelLarge: daysOne(textStyle: textTheme.labelLarge),
      labelMedium: daysOne(textStyle: textTheme.labelMedium),
      labelSmall: daysOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dekko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dekko
  static TextStyle dekko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36fdc3263fa4fabc6785c0ceadb93bdf2dbbfe76dcb9330a3cd74119ae9d47a2',
        204816,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dekko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dekko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dekko
  static TextTheme dekkoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dekko(textStyle: textTheme.displayLarge),
      displayMedium: dekko(textStyle: textTheme.displayMedium),
      displaySmall: dekko(textStyle: textTheme.displaySmall),
      headlineLarge: dekko(textStyle: textTheme.headlineLarge),
      headlineMedium: dekko(textStyle: textTheme.headlineMedium),
      headlineSmall: dekko(textStyle: textTheme.headlineSmall),
      titleLarge: dekko(textStyle: textTheme.titleLarge),
      titleMedium: dekko(textStyle: textTheme.titleMedium),
      titleSmall: dekko(textStyle: textTheme.titleSmall),
      bodyLarge: dekko(textStyle: textTheme.bodyLarge),
      bodyMedium: dekko(textStyle: textTheme.bodyMedium),
      bodySmall: dekko(textStyle: textTheme.bodySmall),
      labelLarge: dekko(textStyle: textTheme.labelLarge),
      labelMedium: dekko(textStyle: textTheme.labelMedium),
      labelSmall: dekko(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dela Gothic One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dela+Gothic+One
  static TextStyle delaGothicOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca21b702c5c8a96a3431bd7b7496c315b8808939cd986072230e4167da1b4dbf',
        2477372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DelaGothicOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dela Gothic One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dela+Gothic+One
  static TextTheme delaGothicOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: delaGothicOne(textStyle: textTheme.displayLarge),
      displayMedium: delaGothicOne(textStyle: textTheme.displayMedium),
      displaySmall: delaGothicOne(textStyle: textTheme.displaySmall),
      headlineLarge: delaGothicOne(textStyle: textTheme.headlineLarge),
      headlineMedium: delaGothicOne(textStyle: textTheme.headlineMedium),
      headlineSmall: delaGothicOne(textStyle: textTheme.headlineSmall),
      titleLarge: delaGothicOne(textStyle: textTheme.titleLarge),
      titleMedium: delaGothicOne(textStyle: textTheme.titleMedium),
      titleSmall: delaGothicOne(textStyle: textTheme.titleSmall),
      bodyLarge: delaGothicOne(textStyle: textTheme.bodyLarge),
      bodyMedium: delaGothicOne(textStyle: textTheme.bodyMedium),
      bodySmall: delaGothicOne(textStyle: textTheme.bodySmall),
      labelLarge: delaGothicOne(textStyle: textTheme.labelLarge),
      labelMedium: delaGothicOne(textStyle: textTheme.labelMedium),
      labelSmall: delaGothicOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Delicious Handrawn font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delicious+Handrawn
  static TextStyle deliciousHandrawn({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7acfa4144e782e6d0ef721f8c64dfd2815606849b837427be442b8d0c789ba3b',
        61064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DeliciousHandrawn',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Delicious Handrawn font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delicious+Handrawn
  static TextTheme deliciousHandrawnTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: deliciousHandrawn(textStyle: textTheme.displayLarge),
      displayMedium: deliciousHandrawn(textStyle: textTheme.displayMedium),
      displaySmall: deliciousHandrawn(textStyle: textTheme.displaySmall),
      headlineLarge: deliciousHandrawn(textStyle: textTheme.headlineLarge),
      headlineMedium: deliciousHandrawn(textStyle: textTheme.headlineMedium),
      headlineSmall: deliciousHandrawn(textStyle: textTheme.headlineSmall),
      titleLarge: deliciousHandrawn(textStyle: textTheme.titleLarge),
      titleMedium: deliciousHandrawn(textStyle: textTheme.titleMedium),
      titleSmall: deliciousHandrawn(textStyle: textTheme.titleSmall),
      bodyLarge: deliciousHandrawn(textStyle: textTheme.bodyLarge),
      bodyMedium: deliciousHandrawn(textStyle: textTheme.bodyMedium),
      bodySmall: deliciousHandrawn(textStyle: textTheme.bodySmall),
      labelLarge: deliciousHandrawn(textStyle: textTheme.labelLarge),
      labelMedium: deliciousHandrawn(textStyle: textTheme.labelMedium),
      labelSmall: deliciousHandrawn(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Delius font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius
  static TextStyle delius({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd71a681bf201c3e2e4075c6da5728d4daa820addcf1605687458820d2f8bee8b',
        58256,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Delius',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Delius font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius
  static TextTheme deliusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: delius(textStyle: textTheme.displayLarge),
      displayMedium: delius(textStyle: textTheme.displayMedium),
      displaySmall: delius(textStyle: textTheme.displaySmall),
      headlineLarge: delius(textStyle: textTheme.headlineLarge),
      headlineMedium: delius(textStyle: textTheme.headlineMedium),
      headlineSmall: delius(textStyle: textTheme.headlineSmall),
      titleLarge: delius(textStyle: textTheme.titleLarge),
      titleMedium: delius(textStyle: textTheme.titleMedium),
      titleSmall: delius(textStyle: textTheme.titleSmall),
      bodyLarge: delius(textStyle: textTheme.bodyLarge),
      bodyMedium: delius(textStyle: textTheme.bodyMedium),
      bodySmall: delius(textStyle: textTheme.bodySmall),
      labelLarge: delius(textStyle: textTheme.labelLarge),
      labelMedium: delius(textStyle: textTheme.labelMedium),
      labelSmall: delius(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Delius Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius+Swash+Caps
  static TextStyle deliusSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6367e7d176347cd4cd7eefee03f80af10a3e4325b04cfa08c84121d6720ffa75',
        60040,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DeliusSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Delius Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius+Swash+Caps
  static TextTheme deliusSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: deliusSwashCaps(textStyle: textTheme.displayLarge),
      displayMedium: deliusSwashCaps(textStyle: textTheme.displayMedium),
      displaySmall: deliusSwashCaps(textStyle: textTheme.displaySmall),
      headlineLarge: deliusSwashCaps(textStyle: textTheme.headlineLarge),
      headlineMedium: deliusSwashCaps(textStyle: textTheme.headlineMedium),
      headlineSmall: deliusSwashCaps(textStyle: textTheme.headlineSmall),
      titleLarge: deliusSwashCaps(textStyle: textTheme.titleLarge),
      titleMedium: deliusSwashCaps(textStyle: textTheme.titleMedium),
      titleSmall: deliusSwashCaps(textStyle: textTheme.titleSmall),
      bodyLarge: deliusSwashCaps(textStyle: textTheme.bodyLarge),
      bodyMedium: deliusSwashCaps(textStyle: textTheme.bodyMedium),
      bodySmall: deliusSwashCaps(textStyle: textTheme.bodySmall),
      labelLarge: deliusSwashCaps(textStyle: textTheme.labelLarge),
      labelMedium: deliusSwashCaps(textStyle: textTheme.labelMedium),
      labelSmall: deliusSwashCaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Delius Unicase font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius+Unicase
  static TextStyle deliusUnicase({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '36a2a1b2c70cadfb729f3457ec1d9c4141222533e167b8620b929340d6fd70c6',
        31020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '419648b741308df1323d518eea0385675205b268f8b793c8b560e5c6366b9906',
        34376,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DeliusUnicase',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Delius Unicase font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Delius+Unicase
  static TextTheme deliusUnicaseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: deliusUnicase(textStyle: textTheme.displayLarge),
      displayMedium: deliusUnicase(textStyle: textTheme.displayMedium),
      displaySmall: deliusUnicase(textStyle: textTheme.displaySmall),
      headlineLarge: deliusUnicase(textStyle: textTheme.headlineLarge),
      headlineMedium: deliusUnicase(textStyle: textTheme.headlineMedium),
      headlineSmall: deliusUnicase(textStyle: textTheme.headlineSmall),
      titleLarge: deliusUnicase(textStyle: textTheme.titleLarge),
      titleMedium: deliusUnicase(textStyle: textTheme.titleMedium),
      titleSmall: deliusUnicase(textStyle: textTheme.titleSmall),
      bodyLarge: deliusUnicase(textStyle: textTheme.bodyLarge),
      bodyMedium: deliusUnicase(textStyle: textTheme.bodyMedium),
      bodySmall: deliusUnicase(textStyle: textTheme.bodySmall),
      labelLarge: deliusUnicase(textStyle: textTheme.labelLarge),
      labelMedium: deliusUnicase(textStyle: textTheme.labelMedium),
      labelSmall: deliusUnicase(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Della Respira font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Della+Respira
  static TextStyle dellaRespira({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2680566048569a284fa0dabe684604b64700db4034d2b9cb1d8f618eb8f4c0f8',
        48188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DellaRespira',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Della Respira font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Della+Respira
  static TextTheme dellaRespiraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dellaRespira(textStyle: textTheme.displayLarge),
      displayMedium: dellaRespira(textStyle: textTheme.displayMedium),
      displaySmall: dellaRespira(textStyle: textTheme.displaySmall),
      headlineLarge: dellaRespira(textStyle: textTheme.headlineLarge),
      headlineMedium: dellaRespira(textStyle: textTheme.headlineMedium),
      headlineSmall: dellaRespira(textStyle: textTheme.headlineSmall),
      titleLarge: dellaRespira(textStyle: textTheme.titleLarge),
      titleMedium: dellaRespira(textStyle: textTheme.titleMedium),
      titleSmall: dellaRespira(textStyle: textTheme.titleSmall),
      bodyLarge: dellaRespira(textStyle: textTheme.bodyLarge),
      bodyMedium: dellaRespira(textStyle: textTheme.bodyMedium),
      bodySmall: dellaRespira(textStyle: textTheme.bodySmall),
      labelLarge: dellaRespira(textStyle: textTheme.labelLarge),
      labelMedium: dellaRespira(textStyle: textTheme.labelMedium),
      labelSmall: dellaRespira(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Denk One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Denk+One
  static TextStyle denkOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6260ab475bea2b433c6cb88cd50b47f6ef7fee263be2d3417ea36f58e839fd2d',
        273520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DenkOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Denk One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Denk+One
  static TextTheme denkOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: denkOne(textStyle: textTheme.displayLarge),
      displayMedium: denkOne(textStyle: textTheme.displayMedium),
      displaySmall: denkOne(textStyle: textTheme.displaySmall),
      headlineLarge: denkOne(textStyle: textTheme.headlineLarge),
      headlineMedium: denkOne(textStyle: textTheme.headlineMedium),
      headlineSmall: denkOne(textStyle: textTheme.headlineSmall),
      titleLarge: denkOne(textStyle: textTheme.titleLarge),
      titleMedium: denkOne(textStyle: textTheme.titleMedium),
      titleSmall: denkOne(textStyle: textTheme.titleSmall),
      bodyLarge: denkOne(textStyle: textTheme.bodyLarge),
      bodyMedium: denkOne(textStyle: textTheme.bodyMedium),
      bodySmall: denkOne(textStyle: textTheme.bodySmall),
      labelLarge: denkOne(textStyle: textTheme.labelLarge),
      labelMedium: denkOne(textStyle: textTheme.labelMedium),
      labelSmall: denkOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Devonshire font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Devonshire
  static TextStyle devonshire({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '010b72e1a4a538d1cd0f5cc3102047f9ea65c50b6349a2f811b3bd800ffe5512',
        64116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Devonshire',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Devonshire font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Devonshire
  static TextTheme devonshireTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: devonshire(textStyle: textTheme.displayLarge),
      displayMedium: devonshire(textStyle: textTheme.displayMedium),
      displaySmall: devonshire(textStyle: textTheme.displaySmall),
      headlineLarge: devonshire(textStyle: textTheme.headlineLarge),
      headlineMedium: devonshire(textStyle: textTheme.headlineMedium),
      headlineSmall: devonshire(textStyle: textTheme.headlineSmall),
      titleLarge: devonshire(textStyle: textTheme.titleLarge),
      titleMedium: devonshire(textStyle: textTheme.titleMedium),
      titleSmall: devonshire(textStyle: textTheme.titleSmall),
      bodyLarge: devonshire(textStyle: textTheme.bodyLarge),
      bodyMedium: devonshire(textStyle: textTheme.bodyMedium),
      bodySmall: devonshire(textStyle: textTheme.bodySmall),
      labelLarge: devonshire(textStyle: textTheme.labelLarge),
      labelMedium: devonshire(textStyle: textTheme.labelMedium),
      labelSmall: devonshire(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dhurjati font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dhurjati
  static TextStyle dhurjati({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7bab2399e158e07a85421075188050d4d87a5689e43225c10021730543793b19',
        534564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dhurjati',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dhurjati font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dhurjati
  static TextTheme dhurjatiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dhurjati(textStyle: textTheme.displayLarge),
      displayMedium: dhurjati(textStyle: textTheme.displayMedium),
      displaySmall: dhurjati(textStyle: textTheme.displaySmall),
      headlineLarge: dhurjati(textStyle: textTheme.headlineLarge),
      headlineMedium: dhurjati(textStyle: textTheme.headlineMedium),
      headlineSmall: dhurjati(textStyle: textTheme.headlineSmall),
      titleLarge: dhurjati(textStyle: textTheme.titleLarge),
      titleMedium: dhurjati(textStyle: textTheme.titleMedium),
      titleSmall: dhurjati(textStyle: textTheme.titleSmall),
      bodyLarge: dhurjati(textStyle: textTheme.bodyLarge),
      bodyMedium: dhurjati(textStyle: textTheme.bodyMedium),
      bodySmall: dhurjati(textStyle: textTheme.bodySmall),
      labelLarge: dhurjati(textStyle: textTheme.labelLarge),
      labelMedium: dhurjati(textStyle: textTheme.labelMedium),
      labelSmall: dhurjati(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Didact Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Didact+Gothic
  static TextStyle didactGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84399f52701c9c84b662cc9e1fd84306753a5c127af35c8acec6f6db6f9adde4',
        117800,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DidactGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Didact Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Didact+Gothic
  static TextTheme didactGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: didactGothic(textStyle: textTheme.displayLarge),
      displayMedium: didactGothic(textStyle: textTheme.displayMedium),
      displaySmall: didactGothic(textStyle: textTheme.displaySmall),
      headlineLarge: didactGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: didactGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: didactGothic(textStyle: textTheme.headlineSmall),
      titleLarge: didactGothic(textStyle: textTheme.titleLarge),
      titleMedium: didactGothic(textStyle: textTheme.titleMedium),
      titleSmall: didactGothic(textStyle: textTheme.titleSmall),
      bodyLarge: didactGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: didactGothic(textStyle: textTheme.bodyMedium),
      bodySmall: didactGothic(textStyle: textTheme.bodySmall),
      labelLarge: didactGothic(textStyle: textTheme.labelLarge),
      labelMedium: didactGothic(textStyle: textTheme.labelMedium),
      labelSmall: didactGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Diphylleia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Diphylleia
  static TextStyle diphylleia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a8250befe5a450cc40bab76b3e54049aa7ef1808fa37e7e3a457ddde5b961bb',
        1408048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Diphylleia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Diphylleia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Diphylleia
  static TextTheme diphylleiaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: diphylleia(textStyle: textTheme.displayLarge),
      displayMedium: diphylleia(textStyle: textTheme.displayMedium),
      displaySmall: diphylleia(textStyle: textTheme.displaySmall),
      headlineLarge: diphylleia(textStyle: textTheme.headlineLarge),
      headlineMedium: diphylleia(textStyle: textTheme.headlineMedium),
      headlineSmall: diphylleia(textStyle: textTheme.headlineSmall),
      titleLarge: diphylleia(textStyle: textTheme.titleLarge),
      titleMedium: diphylleia(textStyle: textTheme.titleMedium),
      titleSmall: diphylleia(textStyle: textTheme.titleSmall),
      bodyLarge: diphylleia(textStyle: textTheme.bodyLarge),
      bodyMedium: diphylleia(textStyle: textTheme.bodyMedium),
      bodySmall: diphylleia(textStyle: textTheme.bodySmall),
      labelLarge: diphylleia(textStyle: textTheme.labelLarge),
      labelMedium: diphylleia(textStyle: textTheme.labelMedium),
      labelSmall: diphylleia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Diplomata font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Diplomata
  static TextStyle diplomata({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd885b981023b4adda3127a3a65160ab2c8c6926eca8cc9cc58d0f3a1350f791',
        52556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Diplomata',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Diplomata font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Diplomata
  static TextTheme diplomataTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: diplomata(textStyle: textTheme.displayLarge),
      displayMedium: diplomata(textStyle: textTheme.displayMedium),
      displaySmall: diplomata(textStyle: textTheme.displaySmall),
      headlineLarge: diplomata(textStyle: textTheme.headlineLarge),
      headlineMedium: diplomata(textStyle: textTheme.headlineMedium),
      headlineSmall: diplomata(textStyle: textTheme.headlineSmall),
      titleLarge: diplomata(textStyle: textTheme.titleLarge),
      titleMedium: diplomata(textStyle: textTheme.titleMedium),
      titleSmall: diplomata(textStyle: textTheme.titleSmall),
      bodyLarge: diplomata(textStyle: textTheme.bodyLarge),
      bodyMedium: diplomata(textStyle: textTheme.bodyMedium),
      bodySmall: diplomata(textStyle: textTheme.bodySmall),
      labelLarge: diplomata(textStyle: textTheme.labelLarge),
      labelMedium: diplomata(textStyle: textTheme.labelMedium),
      labelSmall: diplomata(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Diplomata SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Diplomata+SC
  static TextStyle diplomataSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '285bb4217ff88e268cf1d4956fb9053bef807aa519261e177990eaf00b654d24',
        51392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DiplomataSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Diplomata SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Diplomata+SC
  static TextTheme diplomataScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: diplomataSc(textStyle: textTheme.displayLarge),
      displayMedium: diplomataSc(textStyle: textTheme.displayMedium),
      displaySmall: diplomataSc(textStyle: textTheme.displaySmall),
      headlineLarge: diplomataSc(textStyle: textTheme.headlineLarge),
      headlineMedium: diplomataSc(textStyle: textTheme.headlineMedium),
      headlineSmall: diplomataSc(textStyle: textTheme.headlineSmall),
      titleLarge: diplomataSc(textStyle: textTheme.titleLarge),
      titleMedium: diplomataSc(textStyle: textTheme.titleMedium),
      titleSmall: diplomataSc(textStyle: textTheme.titleSmall),
      bodyLarge: diplomataSc(textStyle: textTheme.bodyLarge),
      bodyMedium: diplomataSc(textStyle: textTheme.bodyMedium),
      bodySmall: diplomataSc(textStyle: textTheme.bodySmall),
      labelLarge: diplomataSc(textStyle: textTheme.labelLarge),
      labelMedium: diplomataSc(textStyle: textTheme.labelMedium),
      labelSmall: diplomataSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Do Hyeon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Do+Hyeon
  static TextStyle doHyeon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fff9504dbe6d4d337e28af407002426d31dda9650ecce49da29a5bbe5afcd252',
        408348,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DoHyeon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Do Hyeon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Do+Hyeon
  static TextTheme doHyeonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: doHyeon(textStyle: textTheme.displayLarge),
      displayMedium: doHyeon(textStyle: textTheme.displayMedium),
      displaySmall: doHyeon(textStyle: textTheme.displaySmall),
      headlineLarge: doHyeon(textStyle: textTheme.headlineLarge),
      headlineMedium: doHyeon(textStyle: textTheme.headlineMedium),
      headlineSmall: doHyeon(textStyle: textTheme.headlineSmall),
      titleLarge: doHyeon(textStyle: textTheme.titleLarge),
      titleMedium: doHyeon(textStyle: textTheme.titleMedium),
      titleSmall: doHyeon(textStyle: textTheme.titleSmall),
      bodyLarge: doHyeon(textStyle: textTheme.bodyLarge),
      bodyMedium: doHyeon(textStyle: textTheme.bodyMedium),
      bodySmall: doHyeon(textStyle: textTheme.bodySmall),
      labelLarge: doHyeon(textStyle: textTheme.labelLarge),
      labelMedium: doHyeon(textStyle: textTheme.labelMedium),
      labelSmall: doHyeon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dokdo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dokdo
  static TextStyle dokdo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd07c17d9103584b546ec45e876d54645c5b10ada0b20b27381cb96948794772d',
        1385692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dokdo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dokdo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dokdo
  static TextTheme dokdoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dokdo(textStyle: textTheme.displayLarge),
      displayMedium: dokdo(textStyle: textTheme.displayMedium),
      displaySmall: dokdo(textStyle: textTheme.displaySmall),
      headlineLarge: dokdo(textStyle: textTheme.headlineLarge),
      headlineMedium: dokdo(textStyle: textTheme.headlineMedium),
      headlineSmall: dokdo(textStyle: textTheme.headlineSmall),
      titleLarge: dokdo(textStyle: textTheme.titleLarge),
      titleMedium: dokdo(textStyle: textTheme.titleMedium),
      titleSmall: dokdo(textStyle: textTheme.titleSmall),
      bodyLarge: dokdo(textStyle: textTheme.bodyLarge),
      bodyMedium: dokdo(textStyle: textTheme.bodyMedium),
      bodySmall: dokdo(textStyle: textTheme.bodySmall),
      labelLarge: dokdo(textStyle: textTheme.labelLarge),
      labelMedium: dokdo(textStyle: textTheme.labelMedium),
      labelSmall: dokdo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Domine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Domine
  static TextStyle domine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85168fafeca1191098f5b6f33e8b903e50cf30c5f3461224b7017f628acc5316',
        64464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '49fd8e54e816deeaa7c50765f5fd61d617b18423ac19cddee7ba134f3dd6e535',
        64636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b257afb3a3b63a864f6a2a9dd028020531d96aef718c631869cd177e13a6de0',
        64604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80204b3ba94ef267566d8adda828cb9eeff9d9cd71f49c956809f036fa71b761',
        64548,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Domine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Domine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Domine
  static TextTheme domineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: domine(textStyle: textTheme.displayLarge),
      displayMedium: domine(textStyle: textTheme.displayMedium),
      displaySmall: domine(textStyle: textTheme.displaySmall),
      headlineLarge: domine(textStyle: textTheme.headlineLarge),
      headlineMedium: domine(textStyle: textTheme.headlineMedium),
      headlineSmall: domine(textStyle: textTheme.headlineSmall),
      titleLarge: domine(textStyle: textTheme.titleLarge),
      titleMedium: domine(textStyle: textTheme.titleMedium),
      titleSmall: domine(textStyle: textTheme.titleSmall),
      bodyLarge: domine(textStyle: textTheme.bodyLarge),
      bodyMedium: domine(textStyle: textTheme.bodyMedium),
      bodySmall: domine(textStyle: textTheme.bodySmall),
      labelLarge: domine(textStyle: textTheme.labelLarge),
      labelMedium: domine(textStyle: textTheme.labelMedium),
      labelSmall: domine(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Donegal One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Donegal+One
  static TextStyle donegalOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b15d824bb9e23c5dd2c4a795f2207f17ec2fc78f294dcb0c445b6dc2b0be9e2d',
        41384,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DonegalOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Donegal One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Donegal+One
  static TextTheme donegalOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: donegalOne(textStyle: textTheme.displayLarge),
      displayMedium: donegalOne(textStyle: textTheme.displayMedium),
      displaySmall: donegalOne(textStyle: textTheme.displaySmall),
      headlineLarge: donegalOne(textStyle: textTheme.headlineLarge),
      headlineMedium: donegalOne(textStyle: textTheme.headlineMedium),
      headlineSmall: donegalOne(textStyle: textTheme.headlineSmall),
      titleLarge: donegalOne(textStyle: textTheme.titleLarge),
      titleMedium: donegalOne(textStyle: textTheme.titleMedium),
      titleSmall: donegalOne(textStyle: textTheme.titleSmall),
      bodyLarge: donegalOne(textStyle: textTheme.bodyLarge),
      bodyMedium: donegalOne(textStyle: textTheme.bodyMedium),
      bodySmall: donegalOne(textStyle: textTheme.bodySmall),
      labelLarge: donegalOne(textStyle: textTheme.labelLarge),
      labelMedium: donegalOne(textStyle: textTheme.labelMedium),
      labelSmall: donegalOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dongle font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dongle
  static TextStyle dongle({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52b8b275e5f187f63f0796d48347fd91361efae7f8620fde46b2bdc40445a0b3',
        4386532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e18c2125d7fff84a358208bfee9cec403a5ad43cc5307df066844fe61eb1fde',
        4456124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98f28ab68f53725135d76abcdf3024700600ec4f7057ff963a7803b364dc6a50',
        4474064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dongle',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dongle font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dongle
  static TextTheme dongleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dongle(textStyle: textTheme.displayLarge),
      displayMedium: dongle(textStyle: textTheme.displayMedium),
      displaySmall: dongle(textStyle: textTheme.displaySmall),
      headlineLarge: dongle(textStyle: textTheme.headlineLarge),
      headlineMedium: dongle(textStyle: textTheme.headlineMedium),
      headlineSmall: dongle(textStyle: textTheme.headlineSmall),
      titleLarge: dongle(textStyle: textTheme.titleLarge),
      titleMedium: dongle(textStyle: textTheme.titleMedium),
      titleSmall: dongle(textStyle: textTheme.titleSmall),
      bodyLarge: dongle(textStyle: textTheme.bodyLarge),
      bodyMedium: dongle(textStyle: textTheme.bodyMedium),
      bodySmall: dongle(textStyle: textTheme.bodySmall),
      labelLarge: dongle(textStyle: textTheme.labelLarge),
      labelMedium: dongle(textStyle: textTheme.labelMedium),
      labelSmall: dongle(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Doppio One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Doppio+One
  static TextStyle doppioOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2eb94a5087c2e3c58fb5ece423e485a52abbc036bb14d81515e2402ba4bc36ee',
        33196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DoppioOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Doppio One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Doppio+One
  static TextTheme doppioOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: doppioOne(textStyle: textTheme.displayLarge),
      displayMedium: doppioOne(textStyle: textTheme.displayMedium),
      displaySmall: doppioOne(textStyle: textTheme.displaySmall),
      headlineLarge: doppioOne(textStyle: textTheme.headlineLarge),
      headlineMedium: doppioOne(textStyle: textTheme.headlineMedium),
      headlineSmall: doppioOne(textStyle: textTheme.headlineSmall),
      titleLarge: doppioOne(textStyle: textTheme.titleLarge),
      titleMedium: doppioOne(textStyle: textTheme.titleMedium),
      titleSmall: doppioOne(textStyle: textTheme.titleSmall),
      bodyLarge: doppioOne(textStyle: textTheme.bodyLarge),
      bodyMedium: doppioOne(textStyle: textTheme.bodyMedium),
      bodySmall: doppioOne(textStyle: textTheme.bodySmall),
      labelLarge: doppioOne(textStyle: textTheme.labelLarge),
      labelMedium: doppioOne(textStyle: textTheme.labelMedium),
      labelSmall: doppioOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dorsa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dorsa
  static TextStyle dorsa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9fbb563ecf470cba0de50596a20910770ce04ae2cdea0018acf0cf456d915353',
        19104,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dorsa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dorsa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dorsa
  static TextTheme dorsaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dorsa(textStyle: textTheme.displayLarge),
      displayMedium: dorsa(textStyle: textTheme.displayMedium),
      displaySmall: dorsa(textStyle: textTheme.displaySmall),
      headlineLarge: dorsa(textStyle: textTheme.headlineLarge),
      headlineMedium: dorsa(textStyle: textTheme.headlineMedium),
      headlineSmall: dorsa(textStyle: textTheme.headlineSmall),
      titleLarge: dorsa(textStyle: textTheme.titleLarge),
      titleMedium: dorsa(textStyle: textTheme.titleMedium),
      titleSmall: dorsa(textStyle: textTheme.titleSmall),
      bodyLarge: dorsa(textStyle: textTheme.bodyLarge),
      bodyMedium: dorsa(textStyle: textTheme.bodyMedium),
      bodySmall: dorsa(textStyle: textTheme.bodySmall),
      labelLarge: dorsa(textStyle: textTheme.labelLarge),
      labelMedium: dorsa(textStyle: textTheme.labelMedium),
      labelSmall: dorsa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dosis font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dosis
  static TextStyle dosis({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c1f0d4ec6895c7b786555a9f0ca35ee83504a2b555a6e1f0a37e2b724d7a929',
        69040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6188fce1ab981d47b9984c852f2a6c772937bc244e874d8b65136a12f044e2d',
        69196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '38f5771ecaa79286393e5abb8f576f173c47304ed9b13ae5310225e8476c1f27',
        69300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b86aefd340dae8abc905606bd43e83a3ba63889c2be7b8c47f64973badde1d53',
        69216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ae5912d839e3101c5d511101fd07f8de2d175122e434c0bf6341a4dbf2a17f3',
        69244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e50105b66b430f7ced4dafc2fbd35b061b10e98f9169c61abf0aefb566740add',
        69152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dfc33ca9107be218b0d2e9a42ffc5bcab81138a0ba701f27229fa00ef019e14a',
        69148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dosis',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dosis font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dosis
  static TextTheme dosisTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dosis(textStyle: textTheme.displayLarge),
      displayMedium: dosis(textStyle: textTheme.displayMedium),
      displaySmall: dosis(textStyle: textTheme.displaySmall),
      headlineLarge: dosis(textStyle: textTheme.headlineLarge),
      headlineMedium: dosis(textStyle: textTheme.headlineMedium),
      headlineSmall: dosis(textStyle: textTheme.headlineSmall),
      titleLarge: dosis(textStyle: textTheme.titleLarge),
      titleMedium: dosis(textStyle: textTheme.titleMedium),
      titleSmall: dosis(textStyle: textTheme.titleSmall),
      bodyLarge: dosis(textStyle: textTheme.bodyLarge),
      bodyMedium: dosis(textStyle: textTheme.bodyMedium),
      bodySmall: dosis(textStyle: textTheme.bodySmall),
      labelLarge: dosis(textStyle: textTheme.labelLarge),
      labelMedium: dosis(textStyle: textTheme.labelMedium),
      labelSmall: dosis(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the DotGothic16 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DotGothic16
  static TextStyle dotGothic16({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e40519a2876d3a3872c93b81a0ace75d83fd74efbcb080115de9f594a7aa0625',
        1903464,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DotGothic16',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DotGothic16 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DotGothic16
  static TextTheme dotGothic16TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dotGothic16(textStyle: textTheme.displayLarge),
      displayMedium: dotGothic16(textStyle: textTheme.displayMedium),
      displaySmall: dotGothic16(textStyle: textTheme.displaySmall),
      headlineLarge: dotGothic16(textStyle: textTheme.headlineLarge),
      headlineMedium: dotGothic16(textStyle: textTheme.headlineMedium),
      headlineSmall: dotGothic16(textStyle: textTheme.headlineSmall),
      titleLarge: dotGothic16(textStyle: textTheme.titleLarge),
      titleMedium: dotGothic16(textStyle: textTheme.titleMedium),
      titleSmall: dotGothic16(textStyle: textTheme.titleSmall),
      bodyLarge: dotGothic16(textStyle: textTheme.bodyLarge),
      bodyMedium: dotGothic16(textStyle: textTheme.bodyMedium),
      bodySmall: dotGothic16(textStyle: textTheme.bodySmall),
      labelLarge: dotGothic16(textStyle: textTheme.labelLarge),
      labelMedium: dotGothic16(textStyle: textTheme.labelMedium),
      labelSmall: dotGothic16(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dr Sugiyama font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dr+Sugiyama
  static TextStyle drSugiyama({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1fb2979359fa0db24d07995444bc13f3efd562f3b8740b8f365c25acb1cb2424',
        38004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DrSugiyama',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dr Sugiyama font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dr+Sugiyama
  static TextTheme drSugiyamaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: drSugiyama(textStyle: textTheme.displayLarge),
      displayMedium: drSugiyama(textStyle: textTheme.displayMedium),
      displaySmall: drSugiyama(textStyle: textTheme.displaySmall),
      headlineLarge: drSugiyama(textStyle: textTheme.headlineLarge),
      headlineMedium: drSugiyama(textStyle: textTheme.headlineMedium),
      headlineSmall: drSugiyama(textStyle: textTheme.headlineSmall),
      titleLarge: drSugiyama(textStyle: textTheme.titleLarge),
      titleMedium: drSugiyama(textStyle: textTheme.titleMedium),
      titleSmall: drSugiyama(textStyle: textTheme.titleSmall),
      bodyLarge: drSugiyama(textStyle: textTheme.bodyLarge),
      bodyMedium: drSugiyama(textStyle: textTheme.bodyMedium),
      bodySmall: drSugiyama(textStyle: textTheme.bodySmall),
      labelLarge: drSugiyama(textStyle: textTheme.labelLarge),
      labelMedium: drSugiyama(textStyle: textTheme.labelMedium),
      labelSmall: drSugiyama(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Duru Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Duru+Sans
  static TextStyle duruSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '626d4fd7f859fbfa0ba5a8db35e636bf031dcd3542141a0496026b90e2b9d2cc',
        47188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DuruSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Duru Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Duru+Sans
  static TextTheme duruSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: duruSans(textStyle: textTheme.displayLarge),
      displayMedium: duruSans(textStyle: textTheme.displayMedium),
      displaySmall: duruSans(textStyle: textTheme.displaySmall),
      headlineLarge: duruSans(textStyle: textTheme.headlineLarge),
      headlineMedium: duruSans(textStyle: textTheme.headlineMedium),
      headlineSmall: duruSans(textStyle: textTheme.headlineSmall),
      titleLarge: duruSans(textStyle: textTheme.titleLarge),
      titleMedium: duruSans(textStyle: textTheme.titleMedium),
      titleSmall: duruSans(textStyle: textTheme.titleSmall),
      bodyLarge: duruSans(textStyle: textTheme.bodyLarge),
      bodyMedium: duruSans(textStyle: textTheme.bodyMedium),
      bodySmall: duruSans(textStyle: textTheme.bodySmall),
      labelLarge: duruSans(textStyle: textTheme.labelLarge),
      labelMedium: duruSans(textStyle: textTheme.labelMedium),
      labelSmall: duruSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the DynaPuff font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DynaPuff
  static TextStyle dynaPuff({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '530885e77a6fee60d04b92ba2c3527fd6bd15cfecd3a886d157650a6d75ff728',
        87836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '59ee240e077e12323d6c4453508480b5b94d3798b84821244f3e35a04d65ba04',
        87932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a588d62c97ce442e7b1f1a313273e94d30aac3c539d2b14cb1364e7a84d756e',
        87956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4314ea94ec4741add9168a2776bf1c075daf243583c4c37a061bf885541adb98',
        87836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'DynaPuff',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the DynaPuff font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/DynaPuff
  static TextTheme dynaPuffTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dynaPuff(textStyle: textTheme.displayLarge),
      displayMedium: dynaPuff(textStyle: textTheme.displayMedium),
      displaySmall: dynaPuff(textStyle: textTheme.displaySmall),
      headlineLarge: dynaPuff(textStyle: textTheme.headlineLarge),
      headlineMedium: dynaPuff(textStyle: textTheme.headlineMedium),
      headlineSmall: dynaPuff(textStyle: textTheme.headlineSmall),
      titleLarge: dynaPuff(textStyle: textTheme.titleLarge),
      titleMedium: dynaPuff(textStyle: textTheme.titleMedium),
      titleSmall: dynaPuff(textStyle: textTheme.titleSmall),
      bodyLarge: dynaPuff(textStyle: textTheme.bodyLarge),
      bodyMedium: dynaPuff(textStyle: textTheme.bodyMedium),
      bodySmall: dynaPuff(textStyle: textTheme.bodySmall),
      labelLarge: dynaPuff(textStyle: textTheme.labelLarge),
      labelMedium: dynaPuff(textStyle: textTheme.labelMedium),
      labelSmall: dynaPuff(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Dynalight font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dynalight
  static TextStyle dynalight({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f3df30743a90267ad6da31bedc99aaf357e8f489097dfdf852d8bea4d6ff947',
        49760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Dynalight',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Dynalight font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Dynalight
  static TextTheme dynalightTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: dynalight(textStyle: textTheme.displayLarge),
      displayMedium: dynalight(textStyle: textTheme.displayMedium),
      displaySmall: dynalight(textStyle: textTheme.displaySmall),
      headlineLarge: dynalight(textStyle: textTheme.headlineLarge),
      headlineMedium: dynalight(textStyle: textTheme.headlineMedium),
      headlineSmall: dynalight(textStyle: textTheme.headlineSmall),
      titleLarge: dynalight(textStyle: textTheme.titleLarge),
      titleMedium: dynalight(textStyle: textTheme.titleMedium),
      titleSmall: dynalight(textStyle: textTheme.titleSmall),
      bodyLarge: dynalight(textStyle: textTheme.bodyLarge),
      bodyMedium: dynalight(textStyle: textTheme.bodyMedium),
      bodySmall: dynalight(textStyle: textTheme.bodySmall),
      labelLarge: dynalight(textStyle: textTheme.labelLarge),
      labelMedium: dynalight(textStyle: textTheme.labelMedium),
      labelSmall: dynalight(textStyle: textTheme.labelSmall),
    );
  }
}
