/* sourcecode.c generated by valac, the Vala compiler
 * generated from sourcecode.vala, do not modify */

/* sourcecode.vala
 *
 * Copyright (C) 2008-2009 Didier Villevalois
 * Copyright (C) 2008-2012 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <valagee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	VALADOC_CONTENT_SOURCE_CODE_0_PROPERTY,
	VALADOC_CONTENT_SOURCE_CODE_CODE_PROPERTY,
	VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE_PROPERTY,
	VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_PROPERTY,
	VALADOC_CONTENT_SOURCE_CODE_NUM_PROPERTIES
};
static GParamSpec* valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValadocContentSourceCodePrivate {
	gchar* _code;
	ValadocContentRun* _highlighted_code;
	ValadocContentSourceCodeLanguage _language;
};

static gint ValadocContentSourceCode_private_offset;
static gpointer valadoc_content_source_code_parent_class = NULL;
static ValadocContentInlineIface * valadoc_content_source_code_valadoc_content_inline_parent_iface = NULL;

static void valadoc_content_source_code_set_highlighted_code (ValadocContentSourceCode* self,
                                                       ValadocContentRun* value);
 G_GNUC_INTERNAL ValadocContentSourceCode* valadoc_content_source_code_new (void);
 G_GNUC_INTERNAL ValadocContentSourceCode* valadoc_content_source_code_construct (GType object_type);
static gchar* valadoc_content_source_code_get_path (ValadocContentSourceCode* self,
                                             const gchar* path,
                                             ValadocApiNode* container,
                                             const gchar* source_file_path,
                                             ValadocErrorReporter* reporter);
static void valadoc_content_source_code_load_source_code (ValadocContentSourceCode* self,
                                                   const gchar* _path,
                                                   ValadocApiNode* container,
                                                   const gchar* source_file_path,
                                                   ValadocErrorReporter* reporter);
static inline gboolean valadoc_content_source_code_is_empty_string (ValadocContentSourceCode* self,
                                                      const gchar* line);
static gchar* valadoc_content_source_code_strip_code (ValadocContentSourceCode* self,
                                               const gchar* code);
static void valadoc_content_source_code_real_check (ValadocContentContentElement* base,
                                             ValadocApiTree* api_root,
                                             ValadocApiNode* container,
                                             const gchar* file_path,
                                             ValadocErrorReporter* reporter,
                                             ValadocSettings* settings);
 G_GNUC_INTERNAL ValadocContentRun* valadoc_content_run_new (ValadocContentRunStyle style);
 G_GNUC_INTERNAL ValadocContentRun* valadoc_content_run_construct (GType object_type,
                                                  ValadocContentRunStyle style);
 G_GNUC_INTERNAL ValadocContentText* valadoc_content_text_new (const gchar* text);
 G_GNUC_INTERNAL ValadocContentText* valadoc_content_text_construct (GType object_type,
                                                    const gchar* text);
static void valadoc_content_source_code_real_accept (ValadocContentContentElement* base,
                                              ValadocContentContentVisitor* visitor);
static void valadoc_content_source_code_real_accept_children (ValadocContentContentElement* base,
                                                       ValadocContentContentVisitor* visitor);
static gboolean valadoc_content_source_code_real_is_empty (ValadocContentContentElement* base);
static ValadocContentContentElement* valadoc_content_source_code_real_copy (ValadocContentContentElement* base,
                                                                     ValadocContentContentElement* new_parent);
 G_GNUC_INTERNAL void valadoc_content_content_element_set_parent (ValadocContentContentElement* self,
                                                 ValadocContentContentElement* value);
static void valadoc_content_source_code_finalize (GObject * obj);
static GType valadoc_content_source_code_get_type_once (void);
static void _vala_valadoc_content_source_code_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_valadoc_content_source_code_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
valadoc_content_source_code_get_instance_private (ValadocContentSourceCode* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocContentSourceCode_private_offset);
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

ValadocContentSourceCodeLanguage
valadoc_content_source_code_language_from_path (const gchar* path)
{
	gint pos = 0;
	gchar* ext = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ValadocContentSourceCodeLanguage result;
	g_return_val_if_fail (path != NULL, 0);
	pos = string_last_index_of (path, ".", 0);
	if (pos < 0) {
		result = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_UNKNOWN;
		return result;
	}
	_tmp0_ = string_substring (path, (glong) (pos + 1), (glong) -1);
	ext = _tmp0_;
	_tmp1_ = ext;
	result = valadoc_content_source_code_language_from_string (_tmp1_, TRUE);
	_g_free0 (ext);
	return result;
}

ValadocContentSourceCodeLanguage
valadoc_content_source_code_language_from_string (const gchar* str,
                                                  gboolean is_extension)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	ValadocContentSourceCodeLanguage result;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("genie")))) {
		switch (0) {
			default:
			{
				if (is_extension) {
					result = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_UNKNOWN;
					return result;
				}
				result = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("gs")))) {
		switch (0) {
			default:
			{
				result = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("xml")))) {
		switch (0) {
			default:
			{
				result = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("vala")))) {
		switch (0) {
			default:
			{
				result = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("c")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("h"))))) {
		switch (0) {
			default:
			{
				result = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C;
				return result;
			}
		}
	}
	result = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_UNKNOWN;
	return result;
}

const gchar*
valadoc_content_source_code_language_to_string (ValadocContentSourceCodeLanguage self)
{
	const gchar* result;
	switch (self) {
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE:
		{
			result = "genie";
			return result;
		}
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA:
		{
			result = "vala";
			return result;
		}
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML:
		{
			result = "xml";
			return result;
		}
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C:
		{
			result = "c";
			return result;
		}
		default:
		break;
	}
	g_assert_not_reached ();
}

static GType
valadoc_content_source_code_language_get_type_once (void)
{
	static const GEnumValue values[] = {{VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_UNKNOWN, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_UNKNOWN", "unknown"}, {VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_GENIE", "genie"}, {VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA", "vala"}, {VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML", "xml"}, {VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C, "VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C", "c"}, {0, NULL, NULL}};
	GType valadoc_content_source_code_language_type_id;
	valadoc_content_source_code_language_type_id = g_enum_register_static ("ValadocContentSourceCodeLanguage", values);
	return valadoc_content_source_code_language_type_id;
}

GType
valadoc_content_source_code_language_get_type (void)
{
	static volatile gsize valadoc_content_source_code_language_type_id__once = 0;
	if (g_once_init_enter (&valadoc_content_source_code_language_type_id__once)) {
		GType valadoc_content_source_code_language_type_id;
		valadoc_content_source_code_language_type_id = valadoc_content_source_code_language_get_type_once ();
		g_once_init_leave (&valadoc_content_source_code_language_type_id__once, valadoc_content_source_code_language_type_id);
	}
	return valadoc_content_source_code_language_type_id__once;
}

const gchar*
valadoc_content_source_code_get_code (ValadocContentSourceCode* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}

void
valadoc_content_source_code_set_code (ValadocContentSourceCode* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_content_source_code_get_code (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_code);
		self->priv->_code = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_CODE_PROPERTY]);
	}
}

ValadocContentRun*
valadoc_content_source_code_get_highlighted_code (ValadocContentSourceCode* self)
{
	ValadocContentRun* result;
	ValadocContentRun* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_highlighted_code;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
valadoc_content_source_code_set_highlighted_code (ValadocContentSourceCode* self,
                                                  ValadocContentRun* value)
{
	ValadocContentRun* old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_content_source_code_get_highlighted_code (self);
	if (old_value != value) {
		ValadocContentRun* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_highlighted_code);
		self->priv->_highlighted_code = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE_PROPERTY]);
	}
}

ValadocContentSourceCodeLanguage
valadoc_content_source_code_get_language (ValadocContentSourceCode* self)
{
	ValadocContentSourceCodeLanguage result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_language;
	return result;
}

void
valadoc_content_source_code_set_language (ValadocContentSourceCode* self,
                                          ValadocContentSourceCodeLanguage value)
{
	ValadocContentSourceCodeLanguage old_value;
	g_return_if_fail (self != NULL);
	old_value = valadoc_content_source_code_get_language (self);
	if (old_value != value) {
		self->priv->_language = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_PROPERTY]);
	}
}

 G_GNUC_INTERNAL ValadocContentSourceCode*
valadoc_content_source_code_construct (GType object_type)
{
	ValadocContentSourceCode * self = NULL;
	self = (ValadocContentSourceCode*) valadoc_content_content_element_construct (object_type);
	self->priv->_language = VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA;
	return self;
}

 G_GNUC_INTERNAL ValadocContentSourceCode*
valadoc_content_source_code_new (void)
{
	return valadoc_content_source_code_construct (VALADOC_CONTENT_TYPE_SOURCE_CODE);
}

static gchar*
valadoc_content_source_code_get_path (ValadocContentSourceCode* self,
                                      const gchar* path,
                                      ValadocApiNode* container,
                                      const gchar* source_file_path,
                                      ValadocErrorReporter* reporter)
{
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (source_file_path != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	if (!g_path_is_absolute (path)) {
		gchar* relative_to_file = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = g_path_get_dirname (source_file_path);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_build_path (G_DIR_SEPARATOR_S, _tmp1_, path, NULL);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		relative_to_file = _tmp3_;
		_tmp4_ = relative_to_file;
		if (g_file_test (_tmp4_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR)) {
			gchar* _tmp5_;
			_tmp5_ = relative_to_file;
			relative_to_file = NULL;
			result = _tmp5_;
			_g_free0 (relative_to_file);
			return result;
		}
		_g_free0 (relative_to_file);
	}
	if (!g_file_test (path, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR)) {
		gchar* _tmp6_ = NULL;
		gchar* node_segment = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		if (VALADOC_API_IS_PACKAGE (container)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("");
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp7_;
		} else {
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = valadoc_api_node_get_full_name (container);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp9_, ": ", NULL);
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp10_;
			_g_free0 (_tmp9_);
		}
		_tmp11_ = g_strdup (_tmp6_);
		node_segment = _tmp11_;
		_tmp12_ = g_strdup_printf ("File '%s' does not exist", path);
		_tmp13_ = _tmp12_;
		valadoc_content_source_code_set_code (self, _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = node_segment;
		_tmp15_ = g_strdup_printf ("%s: %s{{{", source_file_path, _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->_code;
		valadoc_error_reporter_simple_warning (reporter, _tmp16_, "%s", _tmp17_);
		_g_free0 (_tmp16_);
		result = NULL;
		_g_free0 (node_segment);
		_g_free0 (_tmp6_);
		return result;
	}
	_tmp18_ = g_strdup (path);
	result = _tmp18_;
	return result;
}

static void
valadoc_content_source_code_load_source_code (ValadocContentSourceCode* self,
                                              const gchar* _path,
                                              ValadocApiNode* container,
                                              const gchar* source_file_path,
                                              ValadocErrorReporter* reporter)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_path != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (source_file_path != NULL);
	g_return_if_fail (reporter != NULL);
	_tmp0_ = valadoc_content_source_code_get_path (self, _path, container, source_file_path, reporter);
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		_g_free0 (path);
		return;
	}
	{
		gchar* content = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		content = NULL;
		_tmp2_ = path;
		g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error0_);
		_g_free0 (content);
		content = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (content);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = path;
		self->priv->_language = valadoc_content_source_code_language_from_path (_tmp4_);
		_tmp5_ = content;
		content = NULL;
		_tmp6_ = _tmp5_;
		valadoc_content_source_code_set_code (self, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (content);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* err = NULL;
		gchar* _tmp7_ = NULL;
		gchar* node_segment = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		if (VALADOC_API_IS_PACKAGE (container)) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("");
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp8_;
		} else {
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = valadoc_api_node_get_full_name (container);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat (_tmp10_, ": ", NULL);
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp11_;
			_g_free0 (_tmp10_);
		}
		_tmp12_ = g_strdup (_tmp7_);
		node_segment = _tmp12_;
		_tmp13_ = node_segment;
		_tmp14_ = g_strdup_printf ("%s: %s{{{", source_file_path, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = path;
		_tmp17_ = err;
		_tmp18_ = _tmp17_->message;
		valadoc_error_reporter_simple_error (reporter, _tmp15_, "Can't read file '%s': %s", _tmp16_, _tmp18_);
		_g_free0 (_tmp15_);
		_g_free0 (node_segment);
		_g_free0 (_tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static inline gboolean
valadoc_content_source_code_is_empty_string (ValadocContentSourceCode* self,
                                             const gchar* line)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(string_get (line, (glong) i) != '\0')) {
					break;
				}
				if (g_ascii_isspace (string_get (line, (glong) i)) == FALSE) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
valadoc_content_source_code_strip_code (ValadocContentSourceCode* self,
                                        const gchar* code)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint lines_length1;
	gint _lines_size_;
	const gchar** _lines = NULL;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar** _tmp18_;
	gchar* _tmp19_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (code != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (code, "\n", 0);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = lines_length1;
	{
		gint i = 0;
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = lines;
		_tmp2__length1 = lines_length1;
		i = _tmp2__length1 - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				gchar** _tmp8_;
				gint _tmp8__length1;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				if (i >= 0) {
					gchar** _tmp6_;
					gint _tmp6__length1;
					const gchar* _tmp7_;
					_tmp6_ = lines;
					_tmp6__length1 = lines_length1;
					_tmp7_ = _tmp6_[i];
					_tmp5_ = valadoc_content_source_code_is_empty_string (self, _tmp7_);
				} else {
					_tmp5_ = FALSE;
				}
				if (!_tmp5_) {
					break;
				}
				_tmp8_ = lines;
				_tmp8__length1 = lines_length1;
				_g_free0 (_tmp8_[i]);
				_tmp8_[i] = NULL;
			}
		}
	}
	_tmp9_ = lines;
	_tmp9__length1 = lines_length1;
	_lines = _tmp9_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = lines;
				_tmp13__length1 = lines_length1;
				_tmp14_ = _tmp13_[i];
				if (_tmp14_ != NULL) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					_tmp15_ = lines;
					_tmp15__length1 = lines_length1;
					_tmp16_ = _tmp15_[i];
					_tmp12_ = valadoc_content_source_code_is_empty_string (self, _tmp16_);
				} else {
					_tmp12_ = FALSE;
				}
				if (!_tmp12_) {
					break;
				}
				_tmp17_ = lines;
				_tmp17__length1 = lines_length1;
				_lines = &_tmp17_[i + 1];
			}
		}
	}
	_tmp18_ = _lines;
	_tmp19_ = _vala_g_strjoinv ("\n", (gchar**) _tmp18_, (gint) -1);
	result = _tmp19_;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
valadoc_content_source_code_real_check (ValadocContentContentElement* base,
                                        ValadocApiTree* api_root,
                                        ValadocApiNode* container,
                                        const gchar* file_path,
                                        ValadocErrorReporter* reporter,
                                        ValadocSettings* settings)
{
	ValadocContentSourceCode * self;
	gchar** splitted = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint splitted_length1;
	gint _splitted_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	self = (ValadocContentSourceCode*) base;
	g_return_if_fail (api_root != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (file_path != NULL);
	g_return_if_fail (reporter != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = self->priv->_code;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "\n", 2);
	splitted = _tmp2_;
	splitted_length1 = _vala_array_length (_tmp1_);
	_splitted_size_ = splitted_length1;
	_tmp3_ = splitted;
	_tmp3__length1 = splitted_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, "") == 0;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = splitted;
		_tmp9__length1 = splitted_length1;
		_tmp10_ = _tmp9_[1];
		_tmp8_ = _tmp10_;
		if (_tmp8_ == NULL) {
			_tmp8_ = "";
		}
		valadoc_content_source_code_set_code (self, _tmp8_);
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		_tmp11_ = splitted;
		_tmp11__length1 = splitted_length1;
		_tmp12_ = _tmp11_[0];
		if (g_str_has_prefix (_tmp12_, "#!")) {
			const gchar* start = NULL;
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = splitted;
			_tmp13__length1 = splitted_length1;
			_tmp14_ = _tmp13_[0];
			start = (const gchar*) (((gchar*) _tmp14_) + 2);
			_tmp15_ = start;
			if (g_str_has_prefix (_tmp15_, "include:")) {
				const gchar* _tmp16_;
				gchar* path = NULL;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				_tmp16_ = start;
				start = (const gchar*) (((gchar*) _tmp16_) + 8);
				_tmp17_ = start;
				_tmp18_ = string_strip (_tmp17_);
				path = _tmp18_;
				_tmp19_ = path;
				valadoc_content_source_code_load_source_code (self, _tmp19_, container, file_path, reporter);
				_g_free0 (path);
			} else {
				gchar* name = NULL;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_ = NULL;
				gchar** _tmp25_;
				gint _tmp25__length1;
				const gchar* _tmp26_;
				gboolean _tmp27_ = FALSE;
				_tmp20_ = start;
				_tmp21_ = g_strstrip (_tmp20_);
				_tmp22_ = g_ascii_strdown (_tmp21_, (gssize) -1);
				name = _tmp22_;
				_tmp23_ = name;
				self->priv->_language = valadoc_content_source_code_language_from_string (_tmp23_, FALSE);
				_tmp25_ = splitted;
				_tmp25__length1 = splitted_length1;
				_tmp26_ = _tmp25_[1];
				_tmp24_ = _tmp26_;
				if (_tmp24_ == NULL) {
					_tmp24_ = "";
				}
				valadoc_content_source_code_set_code (self, _tmp24_);
				if (self->priv->_language == VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_UNKNOWN) {
					const gchar* _tmp28_;
					_tmp28_ = name;
					_tmp27_ = g_strcmp0 (_tmp28_, "none") != 0;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					gchar* _tmp29_ = NULL;
					gchar* node_segment = NULL;
					gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					const gchar* _tmp38_;
					if (VALADOC_API_IS_PACKAGE (container)) {
						gchar* _tmp30_;
						_tmp30_ = g_strdup ("");
						_g_free0 (_tmp29_);
						_tmp29_ = _tmp30_;
					} else {
						gchar* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						_tmp31_ = valadoc_api_node_get_full_name (container);
						_tmp32_ = _tmp31_;
						_tmp33_ = g_strconcat (_tmp32_, ": ", NULL);
						_g_free0 (_tmp29_);
						_tmp29_ = _tmp33_;
						_g_free0 (_tmp32_);
					}
					_tmp34_ = g_strdup (_tmp29_);
					node_segment = _tmp34_;
					_tmp35_ = node_segment;
					_tmp36_ = g_strdup_printf ("%s: %s{{{", file_path, _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp38_ = name;
					valadoc_error_reporter_simple_warning (reporter, _tmp37_, "Unsupported programming language '%s'", _tmp38_);
					_g_free0 (_tmp37_);
					_g_free0 (node_segment);
					_g_free0 (_tmp29_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp39_ = self->priv->_code;
	_tmp40_ = valadoc_content_source_code_strip_code (self, _tmp39_);
	_tmp41_ = _tmp40_;
	valadoc_content_source_code_set_code (self, _tmp41_);
	_g_free0 (_tmp41_);
	if (self->priv->_language == VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_VALA) {
		ValadocHighlighterHighlighter* _tmp42_;
		ValadocHighlighterHighlighter* _tmp43_;
		const gchar* _tmp44_;
		ValadocContentRun* _tmp45_;
		ValadocContentRun* _tmp46_;
		_tmp42_ = valadoc_api_tree_get_highlighter (api_root);
		_tmp43_ = _tmp42_;
		_tmp44_ = self->priv->_code;
		_tmp45_ = valadoc_highlighter_highlighter_highlight_vala (_tmp43_, _tmp44_);
		_tmp46_ = _tmp45_;
		valadoc_content_source_code_set_highlighted_code (self, _tmp46_);
		_g_object_unref0 (_tmp46_);
	} else {
		if (self->priv->_language == VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_XML) {
			ValadocHighlighterHighlighter* _tmp47_;
			ValadocHighlighterHighlighter* _tmp48_;
			const gchar* _tmp49_;
			ValadocContentRun* _tmp50_;
			ValadocContentRun* _tmp51_;
			_tmp47_ = valadoc_api_tree_get_highlighter (api_root);
			_tmp48_ = _tmp47_;
			_tmp49_ = self->priv->_code;
			_tmp50_ = valadoc_highlighter_highlighter_highlight_xml (_tmp48_, _tmp49_);
			_tmp51_ = _tmp50_;
			valadoc_content_source_code_set_highlighted_code (self, _tmp51_);
			_g_object_unref0 (_tmp51_);
		} else {
			if (self->priv->_language == VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_C) {
				ValadocHighlighterHighlighter* _tmp52_;
				ValadocHighlighterHighlighter* _tmp53_;
				const gchar* _tmp54_;
				ValadocContentRun* _tmp55_;
				ValadocContentRun* _tmp56_;
				_tmp52_ = valadoc_api_tree_get_highlighter (api_root);
				_tmp53_ = _tmp52_;
				_tmp54_ = self->priv->_code;
				_tmp55_ = valadoc_highlighter_highlighter_highlight_c (_tmp53_, _tmp54_);
				_tmp56_ = _tmp55_;
				valadoc_content_source_code_set_highlighted_code (self, _tmp56_);
				_g_object_unref0 (_tmp56_);
			} else {
				ValadocContentRun* _tmp57_;
				ValadocContentRun* _tmp58_;
				ValadocContentRun* _tmp59_;
				ValaList* _tmp60_;
				ValaList* _tmp61_;
				const gchar* _tmp62_;
				ValadocContentText* _tmp63_;
				ValadocContentText* _tmp64_;
				_tmp57_ = valadoc_content_run_new (VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
				_tmp58_ = _tmp57_;
				valadoc_content_source_code_set_highlighted_code (self, _tmp58_);
				_g_object_unref0 (_tmp58_);
				_tmp59_ = self->priv->_highlighted_code;
				_tmp60_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = self->priv->_code;
				_tmp63_ = valadoc_content_text_new (_tmp62_);
				_tmp64_ = _tmp63_;
				vala_collection_add ((ValaCollection*) _tmp61_, (ValadocContentInline*) _tmp64_);
				_g_object_unref0 (_tmp64_);
			}
		}
	}
	splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
}

static void
valadoc_content_source_code_real_accept (ValadocContentContentElement* base,
                                         ValadocContentContentVisitor* visitor)
{
	ValadocContentSourceCode * self;
	self = (ValadocContentSourceCode*) base;
	g_return_if_fail (visitor != NULL);
	valadoc_content_content_visitor_visit_source_code (visitor, self);
}

static void
valadoc_content_source_code_real_accept_children (ValadocContentContentElement* base,
                                                  ValadocContentContentVisitor* visitor)
{
	ValadocContentSourceCode * self;
	ValadocContentRun* _tmp0_;
	self = (ValadocContentSourceCode*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_highlighted_code;
	if (_tmp0_ != NULL) {
		ValadocContentRun* _tmp1_;
		_tmp1_ = self->priv->_highlighted_code;
		valadoc_content_content_element_accept ((ValadocContentContentElement*) _tmp1_, visitor);
	}
}

static gboolean
valadoc_content_source_code_real_is_empty (ValadocContentContentElement* base)
{
	ValadocContentSourceCode * self;
	gboolean result;
	self = (ValadocContentSourceCode*) base;
	result = FALSE;
	return result;
}

static ValadocContentContentElement*
valadoc_content_source_code_real_copy (ValadocContentContentElement* base,
                                       ValadocContentContentElement* new_parent)
{
	ValadocContentSourceCode * self;
	ValadocContentSourceCode* source_code = NULL;
	ValadocContentSourceCode* _tmp0_;
	ValadocContentSourceCodeLanguage _tmp1_;
	const gchar* _tmp2_;
	ValadocContentContentElement* result;
	self = (ValadocContentSourceCode*) base;
	_tmp0_ = valadoc_content_source_code_new ();
	source_code = _tmp0_;
	valadoc_content_content_element_set_parent ((ValadocContentContentElement*) source_code, new_parent);
	_tmp1_ = self->priv->_language;
	valadoc_content_source_code_set_language (source_code, _tmp1_);
	_tmp2_ = self->priv->_code;
	valadoc_content_source_code_set_code (source_code, _tmp2_);
	result = (ValadocContentContentElement*) source_code;
	return result;
}

static void
valadoc_content_source_code_class_init (ValadocContentSourceCodeClass * klass,
                                        gpointer klass_data)
{
	valadoc_content_source_code_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocContentSourceCode_private_offset);
	((ValadocContentContentElementClass *) klass)->check = (void (*) (ValadocContentContentElement*, ValadocApiTree*, ValadocApiNode*, const gchar*, ValadocErrorReporter*, ValadocSettings*)) valadoc_content_source_code_real_check;
	((ValadocContentContentElementClass *) klass)->accept = (void (*) (ValadocContentContentElement*, ValadocContentContentVisitor*)) valadoc_content_source_code_real_accept;
	((ValadocContentContentElementClass *) klass)->accept_children = (void (*) (ValadocContentContentElement*, ValadocContentContentVisitor*)) valadoc_content_source_code_real_accept_children;
	((ValadocContentContentElementClass *) klass)->is_empty = (gboolean (*) (ValadocContentContentElement*)) valadoc_content_source_code_real_is_empty;
	((ValadocContentContentElementClass *) klass)->copy = (ValadocContentContentElement* (*) (ValadocContentContentElement*, ValadocContentContentElement*)) valadoc_content_source_code_real_copy;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_content_source_code_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_content_source_code_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_content_source_code_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_CONTENT_SOURCE_CODE_CODE_PROPERTY, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_CODE_PROPERTY] = g_param_spec_string ("code", "code", "code", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE_PROPERTY, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE_PROPERTY] = g_param_spec_object ("highlighted-code", "highlighted-code", "highlighted-code", VALADOC_CONTENT_TYPE_RUN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_PROPERTY, valadoc_content_source_code_properties[VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_PROPERTY] = g_param_spec_enum ("language", "language", "language", VALADOC_CONTENT_SOURCE_CODE_TYPE_LANGUAGE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
valadoc_content_source_code_valadoc_content_inline_interface_init (ValadocContentInlineIface * iface,
                                                                   gpointer iface_data)
{
	valadoc_content_source_code_valadoc_content_inline_parent_iface = g_type_interface_peek_parent (iface);
}

static void
valadoc_content_source_code_instance_init (ValadocContentSourceCode * self,
                                           gpointer klass)
{
	self->priv = valadoc_content_source_code_get_instance_private (self);
}

static void
valadoc_content_source_code_finalize (GObject * obj)
{
	ValadocContentSourceCode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_CONTENT_TYPE_SOURCE_CODE, ValadocContentSourceCode);
	_g_free0 (self->priv->_code);
	_g_object_unref0 (self->priv->_highlighted_code);
	G_OBJECT_CLASS (valadoc_content_source_code_parent_class)->finalize (obj);
}

static GType
valadoc_content_source_code_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocContentSourceCodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_content_source_code_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocContentSourceCode), 0, (GInstanceInitFunc) valadoc_content_source_code_instance_init, NULL };
	static const GInterfaceInfo valadoc_content_inline_info = { (GInterfaceInitFunc) valadoc_content_source_code_valadoc_content_inline_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType valadoc_content_source_code_type_id;
	valadoc_content_source_code_type_id = g_type_register_static (VALADOC_CONTENT_TYPE_CONTENT_ELEMENT, "ValadocContentSourceCode", &g_define_type_info, 0);
	g_type_add_interface_static (valadoc_content_source_code_type_id, VALADOC_CONTENT_TYPE_INLINE, &valadoc_content_inline_info);
	ValadocContentSourceCode_private_offset = g_type_add_instance_private (valadoc_content_source_code_type_id, sizeof (ValadocContentSourceCodePrivate));
	return valadoc_content_source_code_type_id;
}

GType
valadoc_content_source_code_get_type (void)
{
	static volatile gsize valadoc_content_source_code_type_id__once = 0;
	if (g_once_init_enter (&valadoc_content_source_code_type_id__once)) {
		GType valadoc_content_source_code_type_id;
		valadoc_content_source_code_type_id = valadoc_content_source_code_get_type_once ();
		g_once_init_leave (&valadoc_content_source_code_type_id__once, valadoc_content_source_code_type_id);
	}
	return valadoc_content_source_code_type_id__once;
}

static void
_vala_valadoc_content_source_code_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ValadocContentSourceCode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_CONTENT_TYPE_SOURCE_CODE, ValadocContentSourceCode);
	switch (property_id) {
		case VALADOC_CONTENT_SOURCE_CODE_CODE_PROPERTY:
		g_value_set_string (value, valadoc_content_source_code_get_code (self));
		break;
		case VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE_PROPERTY:
		g_value_set_object (value, valadoc_content_source_code_get_highlighted_code (self));
		break;
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_PROPERTY:
		g_value_set_enum (value, valadoc_content_source_code_get_language (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_valadoc_content_source_code_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	ValadocContentSourceCode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_CONTENT_TYPE_SOURCE_CODE, ValadocContentSourceCode);
	switch (property_id) {
		case VALADOC_CONTENT_SOURCE_CODE_CODE_PROPERTY:
		valadoc_content_source_code_set_code (self, g_value_get_string (value));
		break;
		case VALADOC_CONTENT_SOURCE_CODE_HIGHLIGHTED_CODE_PROPERTY:
		valadoc_content_source_code_set_highlighted_code (self, g_value_get_object (value));
		break;
		case VALADOC_CONTENT_SOURCE_CODE_LANGUAGE_PROPERTY:
		valadoc_content_source_code_set_language (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

