# Juno Development Platform Support in meta-arm-bsp

## Howto Build and Run

### Configuration:
In the local.conf file, MACHINE should be set as follow:
MACHINE ?= "juno"

Juno is using a USB hard drive for root filesystem by default. The distribution
used must have ```usbhost``` and ```usbgadget``` in DISTRO_FEATURES (this is
the case in poky distribution).

### Build:
```bash$ bitbake core-image-minimal```

### Update Juno SD card:

The SD card content is generated during the build here:
tmp/deploy/images/juno/firmware-image-juno.tar.gz

Its content must be written on the Juno firmware SD card.
To do this:
- insert the sdcard of the Juno in an SD card reader and mount it:
```bash$ sudo mount /dev/sdx1 /mnt```
(replace sdx by the device of the SD card)

- erase its content and put the new one:
```bash$ sudo rm -rf /mnt/*```
```bash$ sudo tar --no-same-owner -xzf tmp/deploy/images/juno/firmware-image-juno.tar.gz -C /mnt/```
```bash$ sudo umount /mnt```

- reinsert the SD card in the Juno board

### Create an USB hard drive:

Linux root file system should be stored on the second partition of an USB
drive that must be plugged on the Juno Platform.

This partition should be initialized with the content of the filesystem
generated by yocto that you can find here:
tmp/deploy/images/juno/core-image-minimal-juno.tar.bz2

To do this
- Format a USB disk, create two primary partitions (ext4).
- mount the secondary partition
- untar tmp/deploy/images/juno/core-image-minimal-juno.tar.bz2 on to the
  secondary partition.

### Run:
You must insert the SD card and the USB drive and power-on the Juno board.
The console should be available on the second serial line:
screen -L /dev/tty.usbserial 115200

On the first boot the images will be flashed which can take some time.

## Devices supported in the kernel
- serial
- usb
- network
- watchdog
- rtc
- mmc

### Untested:
- i2c
- dma
- pci
- sata
- sound

## Devices not supported or not functional
- framebuffer: not functional
    The HDMI is not properly detected.
- GPU (no user land libraries).
    The mali-midgard-kernel can be used to have a kernel driver
