SUMMARY = "Toybox Inittab Configuration"
LICENSE = "0BSD"
LIC_FILES_CHKSUM = "file://${COREBASE}/meta/files/common-licenses/0BSD;md5=f667a3c3830a55a17ec3067709f4526c"

# Unpack to ${S}/orig
#
SRC_URI = "\
    file://inittab;subdir=${BP}/orig \
    file://rcK;subdir=${BP}/orig \
    file://rcS;subdir=${BP}/orig \
"

PACKAGE_ARCH = "${MACHINE_ARCH}"

RCONFLICTS:${PN} = "\
    busybox-inittab \
    sysvinit-inittab \
"

# Just being sure.
B = "${S}"

# most users may want to have getty enabled by default
PACKAGECONFIG ??= "getty"

PACKAGECONFIG[getty] = "\
    enable_getty \
"

do_patch[noexec] = "1"

do_configure() {
	# copy over files now to have a fresh start on each config
	cp orig/* .

	for config in ${PACKAGECONFIG_CONFARGS}; do
		if [ "${config}" = "enable_getty" ]; then
			echo "# generated by bitbake recipe ${PN}" >> ${S}/inittab
			for console in "${SERIAL_CONSOLES}"; do
				param=$(echo ${console} | sed s/\;/\ /g)
				name=$(echo ${param} | cut -d' ' -f2)
				echo "$name::respawn:${base_sbindir}/getty ${param}" >> ${S}/inittab
			done
		fi
	done
}

do_compile[noexec] = "1"

do_install() {
	install -d ${D}${sysconfdir}
	install -D -m 0644 ${S}/inittab ${D}${sysconfdir}/inittab

	install -d ${D}${sysconfdir}/init.d
	install -D -m 0744 ${S}/rcK ${D}${sysconfdir}/init.d/rcK
	install -D -m 0744 ${S}/rcS ${D}${sysconfdir}/init.d/rcS
}

FILES:${PN} = "\
    ${sysconfdir}/inittab \
    ${sysconfdir}/init.d/rcK \
    ${sysconfdir}/init.d/rcS \
"

