# rolling/ros-distro-recipe-blacklist.inc
#
# Copyright (c) 2020-2021 LG Electronics, Inc.
# Copyright (c) 2022 Wind River Systems, Inc.

SKIP_RECIPE[ament-clang-format] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-format', '', d)}"
SKIP_RECIPE[ament-clang-format-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-format', '', d)}"
SKIP_RECIPE[ament-clang-tidy] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-tidy', '', d)}"
SKIP_RECIPE[ament-clang-tidy-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-tidy', '', d)}"
SKIP_RECIPE[ament-cmake-clang-format] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on ament-clang-format-native->clang-format', '', d)}"
SKIP_RECIPE[ament-cmake-clang-tidy] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on ament-clang-tidy-native->clang-tidy', '', d)}"
SKIP_RECIPE[aws-sdk-cpp-vendor] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'aws', 'aws: depends on recipes provided by meta-aws, but not yet tested with meta-ros', '', d)}"
SKIP_RECIPE[aws-robomaker-small-warehouse-world] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-plugins and gazebo-ros->gazebo-rosdev->gazebo which is not available', '', d)}"
SKIP_RECIPE[cartographer] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'cartographer', 'cartographer: depends on ROS_UNRESOLVED_DEP-libabsl-dev', '', d)}"
SKIP_RECIPE[color-names] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on rviz2 which depends on qtbase; opengl: depends on rviz2 which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[connext-cmake-module] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
SKIP_RECIPE[connext-cmake-module-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
SKIP_RECIPE[control-box-rst] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'Depends on unavailable ROS_UNRESOLVED_DEP-coinor-libipopt-dev', '', d)}"
SKIP_RECIPE[depthai] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'hunter', 'Depends on hunter', '', d)}"
SKIP_RECIPE[depthai-bridge] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'hunter', 'Depends on hunter', '', d)}"
SKIP_RECIPE[depthai-examples] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'hunter', 'Depends on hunter', '', d)}"
SKIP_RECIPE[depthai-ros] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'hunter', 'Depends on hunter', '', d)}"
SKIP_RECIPE[depthai-ros-msgs] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'hunter', 'Depends on hunter', '', d)}"
SKIP_RECIPE[desktop] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'opengl', 'x11'], 'qt5: rdepends on rviz2, rviz-default-plugins, rqt-common-plugins which rdepends on rqt-image-view which depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on qtbase; pyqt5: rdepends on rqt-common-plugins which rdepends on rqt-image-view which depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on python3-pyqt5 which requires pyqt5; opengl: rdepends on rviz2, rviz-default-plugins which depend on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on rviz2, rviz-default-plugins which depend on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[dolly] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['gazebo', 'qt5', 'opengl', 'x11'], 'gazebo: depends on dolly-gazebo which depends on gazebo-ros-pkgs which depends on gazebo-rosdev->gazebo which is not available; qt5: depends on dolly-gazebo which depends on rviz2 which depends on qtbase; opengl: depends on dolly-gazebo which depends on rviz2 which depends on depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on dolly-gazebo which depends on rviz2 which depends on depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[dolly-gazebo] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['gazebo', 'qt5', 'opengl', 'x11'], 'gazebo: depends on gazebo-ros-pkgs which depends on gazebo-rosdev->gazebo which is not available; qt5: depends on rviz2 which depends on qtbase; opengl: depends on rviz2 which depends on depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz2 which depends on depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[gazebo-plugins] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
SKIP_RECIPE[gazebo-ros2-control] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
SKIP_RECIPE[gazebo-ros2-control-demos] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-ros2-control which depends on gazebo-rosdev->gazebo which is not available', '', d)}"
SKIP_RECIPE[gazebo-ros] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
SKIP_RECIPE[gazebo-rosdev] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo11', 'gazebo: depends on gazebo11 which is not available', '', d)}"
SKIP_RECIPE[gazebo-ros-pkgs] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
SKIP_RECIPE[gurumdds-cmake-module] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gurumdds', 'gurumdds: depends on gurumdds-2.6 which is not available', '', d)}"
SKIP_RECIPE[joint-state-publisher-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-binding which depends on qtbase; pyqt5: depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[launch-testing-ros] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'zenoh', 'launch-testing-ros: depends on zenoh-cpp which requires meta-zenoh to be included', '', d)}"
SKIP_RECIPE[libg2o] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on libglu which requires x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[librealsense2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: depends on librealsense2 which depends on glfw which is available only in dunfell and requires x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[moveit] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'libomp'], 'qt5: rdepends on moveit-ros which rdepends on moveit-ros-visualization which depends on rviz2 which depends on qtbase; opengl: rdepends on moveit-ros rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on moveit-ros rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; libomp: rdepends on moveit-planners which rdepends on moveit-planners-ompl which depends on ROS_UNRESOLVED_DEP-libomp-dev which can be provided by meta-clang, but not yet tested with meta-ros', '', d)}"
SKIP_RECIPE[moveit-planners] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', ['libomp'], 'libomp: rdepends on moveit-planners-ompl which depends on ROS_UNRESOLVED_DEP-libomp-dev which can be provided by meta-clang, but not yet tested with meta-ros', '', d)}"
SKIP_RECIPE[moveit-planners-ompl] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', ['libomp'], 'libomp: depends on ROS_UNRESOLVED_DEP-libomp-dev which can be provided by meta-clang, but not yet tested with meta-ros', '', d)}"
SKIP_RECIPE[moveit-resources] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on moveit-resources-panda-moveit-config which rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on qtbase; pyqt5: rdepends on moveit-resources-panda-moveit-config which rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[moveit-resources-panda-moveit-config] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on qtbase; pyqt5: rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[moveit-ros] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: rdepends on moveit-ros-visualization which depends on rviz2 which depends on qtbase; opengl: rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[moveit-ros-perception] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'Depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES and freeglut which requires x11', '', d)}"
SKIP_RECIPE[moveit-ros-visualization] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on rviz2 which depends on qtbase; opengl: depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[moveit-runtime] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'libomp'], 'qt5: rdepends on moveit-ros which rdepends on moveit-ros-visualization which depends on rviz2 which depends on qtbase; opengl: rdepends on moveit-ros rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on moveit-ros rdepends on moveit-ros-visualization which depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; libomp: rdepends on moveit-planners which rdepends on moveit-planners-ompl which depends on ROS_UNRESOLVED_DEP-libomp-dev which can be provided by meta-clang, but not yet tested with meta-ros', '', d)}"
SKIP_RECIPE[moveit-visual-tools] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on rviz-visual-tools which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-visual-tools which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[mrpt2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['ffmpeg', 'openni', 'x264', 'x11'], 'ffmpeg: Depends on ffmpeg which requires commercial license; openni: Depends on libopenni2-dev which is not provided; x264: Depends on ffmpeg which depends on x264 which requires commercial license; x11: Depends on libxxf86vm, freeglut, libxrandr, wxwidgets, glfw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[nav2-bringup] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on slam-toolbox which depends on qtbase; x11: depends on slam-toolbox which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[nav2-rviz-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[nav2-system-tests] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on nav2-bringup which depends on slam-toolbox which depends on qtbase; x11: depends on nav2-bringup which depends on slam-toolbox which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[navigation2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on nav2-rviz-plugins which depends on qtbase; x11: rdepends on nav2-rviz-plugins which depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[octomap-rviz-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[octovis] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'libqglviewer'], 'qt5: depends on qtbase which requires meta-qt5 to be included; libqglviewer: depends on libqglviewer2-qt5 which is not available', '', d)}"
SKIP_RECIPE[openvslam] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on libg2o which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on libg2o which depends on libglu which requires x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[packagegroup-ros-turtlebot3-core] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: rdepends on turtlebot3-bringup,hls-lfcd-lds-driver,turtlebot3-msgs,ros-base which were not ported to foxy yet', '', d)}"
SKIP_RECIPE[packagegroup-ros-turtlebot3-extended] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: rdepends on slam-karto, compressed-image-transport, depthimage-to-laserscan turtlebot3-applications-msgs, turtlebot3-autorace, cartographer-ros, turtlebot3, turtlebot3-applications which were not ported to foxy yet', '', d)}"
SKIP_RECIPE[pinocchio] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'scipy', 'pinocchio: depends on eigenpy which depends on python3-scipy which requires meta-scipy layer', '', d)}"
SKIP_RECIPE[plansys2-bringup] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-executor which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[plansys2-bt-actions] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-executor which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[plansys2-domain-expert] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-popf-plan-solver which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[plansys2-executor] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[plansys2-planner] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-popf-plan-solver which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[plansys2-popf-plan-solver] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[plansys2-problem-expert] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-domain-expert which depends on plansys2-popf-plan-solver which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[plansys2-terminal] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'coinor-libipopt: depends on plansys2-executor which depends on popf which depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[plotjuggler] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets', 'opengl'], 'qt5: Requires qtbase which requires meta-qt5 to be included; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG; opengl: requires opengl to be enabled in qtbase', '', d)}"
SKIP_RECIPE[plotjuggler-ros] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets', 'opengl'], 'qt5: Requires qtsvg, qtwebsockets, qtbase which require meta-qt5 to be included; qt5-widgets: depends on plotjuggler which needs widgets enabled in qtbase PACKAGECONFIG; opengl: depends on plotjuggler which requires opengl to be enabled in qtbase', '', d)}"
SKIP_RECIPE[popf] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'Depends on unavailable ROS_UNRESOLVED_DEP-coinor-libcbc-dev, ROS_UNRESOLVED_DEP-coinor-libclp-dev, ROS_UNRESOLVED_DEP-coinor-libcoinutils-dev, ROS_UNRESOLVED_DEP-coinor-libcgl-dev', '', d)}"
SKIP_RECIPE[python-qt-binding] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[qt-dotgraph] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on python-qt-binding which depends on qtbase which requires meta-qt5 to be included; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[qt-gui-app] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on qt-gui which depends on qtbase which requires meta-qt5 to be included; pyqt5: rdepends on qt-gui which depends on python-qt-binding which requires pyqt5', '', d)}"
SKIP_RECIPE[qt-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[qt-gui-core] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'qt-gui-cpp'], 'qt5: depends on qt-gui which depends on qtbase which requires meta-qt5 to be included; pyqt5: depends on python-qt-binding which requires pyqt5; qt-gui-cpp: depends on qt-gui-cpp which fails to compile', '', d)}"
SKIP_RECIPE[qt-gui-cpp] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'qt-gui-cpp'], 'qt5: depends on qtbase which requires meta-qt5 to be included; pyqt5: depends on python-qt-binding which requires pyqt5; qt-gui-cpp: pyqt5; qt-gui-cpp: do_compile task fails: requires pyqt5-native for sip', '', d)}"
SKIP_RECIPE[qt-gui-py-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on python-qt-binding which depends on qtbase which requires meta-qt5 to be included; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[realsense2-camera] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: depends on librealsense2->mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: Depends on librealsense2->glfw which is not available in zeus and older', '', d)}"
SKIP_RECIPE[realsense-examples] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: depends on librealsense2 which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: depends on librealsense2 which depends on glfw which is available only in dunfell and requires x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[realsense-node] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: rdepends on realsense-ros which depends on librealsense2 which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: depends on librealsense2 which depends on glfw which is available only in dunfell and requires x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[realsense-ros] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'glfw'], 'opengl: depends on librealsense2 which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; glfw: depends on librealsense2 which depends on glfw which is available only in dunfell and requires x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rmf-building-map-tools] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'python3-shapely', 'python3-shapely: depends on unavailable python3-shapely', '', d)}"
SKIP_RECIPE[rmf-building-map-tools-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'python3-shapely', 'python3-shapely: depends on unavailable python3-shapely', '', d)}"
SKIP_RECIPE[rmf-building-sim-gazebo-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['gazebo', 'qt5'], 'gazebo: depends on gazebo-ros,gazebo-rosdev->gazebo which is not available; qt5: depends on qtbase', '', d)}"
SKIP_RECIPE[rmf-building-sim-ignition-plugins] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'qt5', 'qt5: depends on qtbase, libqt5-qml, libqt5-quick', '', d)}"
SKIP_RECIPE[rmf-demos] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['gazebo', 'qt5'], 'gazebo: rdepends on rmf-robot-sim-gazebo-plugins, rmf-building-sim-gazebo-plugins which depend on gazebo-ros,gazebo-rosdev->gazebo which is not available; qt5: rdepends on rmf-robot-sim-gazebo-plugins, rmf-building-sim-gazebo-plugins which depend on qtbase', '', d)}"
SKIP_RECIPE[rmf-demos-gz] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['gazebo', 'qt5'], 'gazebo: rdepends on rmf-demos which rdepends rmf-robot-sim-gazebo-plugins, rmf-building-sim-gazebo-plugins which depend on gazebo-ros,gazebo-rosdev->gazebo which is not available; qt5: rdepends on rmf-demos which rdepends on rmf-robot-sim-gazebo-plugins, rmf-building-sim-gazebo-plugins which depend on qtbase', '', d)}"
SKIP_RECIPE[rmf-demos-ign] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['gazebo', 'qt5'], 'gazebo: rdepends on rmf-demos which rdepends rmf-robot-sim-gazebo-plugins, rmf-building-sim-gazebo-plugins which depend on gazebo-ros,gazebo-rosdev->gazebo which is not available; qt5: rdepends on rmf-demos which rdepends on rmf-robot-sim-gazebo-plugins, rmf-building-sim-gazebo-plugins which depend on qtbase', '', d)}"
SKIP_RECIPE[rmf-demos-maps] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'python3-shapely', 'python3-shapely: depends on rmf-building-map-tools-native which depends on unavailable python3-shapely', '', d)}"
SKIP_RECIPE[rmf-demos-panel] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'python3-flask-cors', 'python3-flask-cors: rdepends on unavailable python3-flask-cors', '', d)}"
SKIP_RECIPE[rmf-robot-sim-gazebo-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['gazebo', 'qt5'], 'gazebo: depends on gazebo-ros,gazebo-rosdev->gazebo which is not available; qt5: depends on qtbase', '', d)}"
SKIP_RECIPE[rmf-robot-sim-ignition-plugins] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'qt5', 'qt5: depends on qtbase, libqt5-qml, libqt5-quick', '', d)}"
SKIP_RECIPE[rmf-traffic-editor] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets'], 'qt5: Requires qtbase which requires meta-qt5 to be included; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
SKIP_RECIPE[rmf-traffic-editor-test-maps] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'python3-shapely', 'python3-shapely: depends on rmf-building-map-tools-native which depends on unavailable python3-shapely', '', d)}"
SKIP_RECIPE[rmf-visualization] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on rmf-visualization-rviz2-plugins which depends rviz-rendering, rviz-common, rviz-default-plugins which depend on qtbase; opengl: depends on rmf-visualization-rviz2-plugins which depends on rviz-rendering, rviz-common, rviz-default-plugins which depend on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rmf-visualization-rviz2-plugins which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rmf-visualization-rviz2-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on rviz-rendering, rviz-common, rviz-default-plugins which depend on qtbase; opengl: depends on rviz-rendering, rviz-common, rviz-default-plugins which depend on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rmw-connext-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
SKIP_RECIPE[rmw-connextdds] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
SKIP_RECIPE[rmw-connextdds-common] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
SKIP_RECIPE[rmw-connext-shared-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
SKIP_RECIPE[rmw-gurumdds-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gurumdds', 'gurumdds: depends on gurumdds-2.6 which is not available', '', d)}"
SKIP_RECIPE[rmw-gurumdds-shared-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gurumdds', 'gurumdds: depends on gurumdds-2.6 which is not available', '', d)}"
SKIP_RECIPE[rmw-test-fixture-implementation] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'zenoh', 'rmw-test-fixture-implementation: depends on zenoh-cpp which requires meta-zenoh to be included', '', d)}"
SKIP_RECIPE[rmw-zenoh-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'zenoh', 'rmw-zenoh-cpp: depends on zenoh-cpp which requires meta-zenoh to be included', '', d)}"
SKIP_RECIPE[ros2-ouster] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ros2-ouster', 'Depends on unavailable ROS_UNRESOLVED_DEP-libtins-dev', '', d)}"
SKIP_RECIPE[ros2trace-analysis] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'babeltrace-python', 'babeltrace-python: depends on tracetools-analysis which rdepends on tracetools-read which rdepends on ROS_UNRESOLVED_DEP-python3-babeltrace and python bindings in babeltrace are not enabled as shown in log.do_configure - configure: You may configure with --enable-python-bindings if you want Python bindings.', '', d)}"
SKIP_RECIPE[rosbag2-bag-v2-plugins] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'ros1', 'ros1: since https://github.com/ros2/rosbag2_bag_v2/commit/ef48a3ef8a8753b3005862a7c437ff19d70e1745 requires roscpp ROS1 package to be available during do_configure', '', d)}"
SKIP_RECIPE[rosidl-typesupport-connext-c] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on (rosidl-typesupport-connext-cpp-native,connext-cmake-module-native)->rti-connext-dds-native which is not available', '', d)}"
SKIP_RECIPE[rosidl-typesupport-connext-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
SKIP_RECIPE[rosidl-typesupport-connext-cpp-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
SKIP_RECIPE[ros-image-turtlebot3-all] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: Rdepends on packagegroup-ros-turtlebot3-core, packagegroup-ros-turtlebot3-extended which rdepend turtlebot3-bringup,hls-lfcd-lds-driver,turtlebot3-msgs,ros-base,slam-karto, compressed-image-transport, depthimage-to-laserscan turtlebot3-applications-msgs, turtlebot3-autorace, cartographer-ros, turtlebot3, turtlebot3-applications which were not ported to foxy yet', '', d)}"
SKIP_RECIPE[ros-image-turtlebot3-core] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: Rdepends on packagegroup-ros-turtlebot3-core, packagegroup-ros-turtlebot3-extended which rdepend turtlebot3-bringup,hls-lfcd-lds-driver,turtlebot3-msgs,ros-base,slam-karto, compressed-image-transport, depthimage-to-laserscan turtlebot3-applications-msgs, turtlebot3-autorace, cartographer-ros, turtlebot3, turtlebot3-applications which were not ported to foxy yet', '', d)}"
SKIP_RECIPE[rqt-action] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui-py which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-bag] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-bag-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'qt-gui-cpp'], 'qt5: depends on qt-gui which depends on qtbase which requires meta-qt5 to be included; pyqt5: depends on rqt-gui-cpp which depends on qt-gui-cpp which depends python-qt-binding which requires pyqt5; qt-gui-cpp: pyqt5; qt-gui-cpp: depends on rqt-gui-cpp which depends depends on qt-gui-cpp which fails to compile', '', d)}"
SKIP_RECIPE[rqt-common-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-image-view which depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on qtbase; pyqt5: rdepends on rqt-image-view which depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-console] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-graph] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-gui which depends on qtbase; pyqt5: depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-gui-cpp] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'qt-gui-cpp'], 'qt5: depends on qt-gui-cpp and qtbase itself which requires meta-qt5 to be included; pyqt5: depends on qt-gui-cpp which depends python-qt-binding which requires pyqt5; qt-gui-cpp: pyqt5; qt-gui-cpp: depends on qt-gui-cpp which fails to compile', '', d)}"
SKIP_RECIPE[rqt-gui-py] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-gui which depends on qtbase; pyqt5: depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-image-view] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on qtbase; pyqt5: depends on qt-gui-cpp, rqt-gui, rqt-gui-cpp which depend on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-moveit] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-msg] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-plot] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-publisher] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-py-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-py-console] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-reconfigure] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding and rqt-gui-py which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-robot-dashboard] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui-py which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-robot-monitor] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui,rqt-gui-py,qt-gui-py-common which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui,rqt-gui-py,qt-gui-py-common which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-robot-steering] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-runtime-monitor] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-service-caller] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui-py which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-shell] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on qt-gui and rqt-gui-py which depends on qtbase which requires meta-qt5 to be included; pyqt5: rdepends on qt-gui which depends on python-qt-binding which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-srv] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-msg which rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-top] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rqt-topic] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui-py which depends qt-gui which depends on qtbase; pyqt5: rdepends on python-qt-binding and rqt-gui-py which depends on python3-pyqt5 which requires pyqt5', '', d)}"
SKIP_RECIPE[rtabmap] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11', 'openni'], 'opengl: Depends on libfreenect and libg2o which is not available because of missing opengl in DISTRO_FEATURES; x11: Depends on libfreenect and libg2o which is not available because of missing x11 in DISTRO_FEATURES; openni: Depends on unavailable ROS_UNRESOLVED_DEP-libopenni-dev', '', d)}"
SKIP_RECIPE[rti-connext-dds-cmake-module] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
SKIP_RECIPE[run-move-group] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'opengl', 'x11'], 'qt5: rdepends on moveit-resources-panda-moveit-config which rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on qtbase; pyqt5: rdepends on moveit-resources-panda-moveit-config which rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5; opengl: depends on rviz2 which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[run-moveit-cpp] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5', 'opengl', 'x11'], 'qt5: rdepends on moveit-resources-panda-moveit-config which rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on qtbase; pyqt5: rdepends on moveit-resources-panda-moveit-config which rdepends on joint-state-publisher-gui which depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5; opengl: depends on rviz2 which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[run-ompl-constrained-planning] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['mongodb', 'mongodb-legacy-cxx-driver'], 'mongodb: rdepends on warehouse-ros-mongo which requires mongodb; mongodb-legacy-cxx-driver: rdepends on warehouse-ros-mongo which requires unavailable mongo-cxx-driver-legacy', '', d)}"
SKIP_RECIPE[rviz2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rviz-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rviz-ogre-vendor] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rviz-default-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-common which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rviz-imu-plugin] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5'], 'qt5: depends on qtbase', '', d)}"
SKIP_RECIPE[rviz-rendering] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rviz-rendering-tests] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rviz-visual-testing-framework] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[rviz-visual-tools] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[slam-toolbox] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[slider-publisher] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'scipy', 'slider-publisher: depends on python3-scipy which requires meta-scipy layer', '', d)}"
SKIP_RECIPE[spacenav] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'libspnav', 'Depends on unavailable ROS_UNRESOLVED_DEP-libspnav-dev', '', d)}"
SKIP_RECIPE[theora-image-transport] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'theora-image-transport', 'Depends on unavailable ROS_UNRESOLVED_DEP-libopencv-imgproc-dev', '', d)}"
SKIP_RECIPE[tracetools-analysis] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'babeltrace-python', 'babeltrace-python: rdepends on tracetools-read which rdepends on ROS_UNRESOLVED_DEP-python3-babeltrace and python bindings in babeltrace are not enabled as shown in log.do_configure - configure: You may configure with --enable-python-bindings if you want Python bindings.', '', d)}"
SKIP_RECIPE[tracetools-read] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'babeltrace-python', 'babeltrace-python: rdepends on ROS_UNRESOLVED_DEP-python3-babeltrace and python bindings in babeltrace are not enabled as shown in log.do_configure - configure: You may configure with --enable-python-bindings if you want Python bindings.', '', d)}"
SKIP_RECIPE[turtlebot3-gazebo] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'gazebo'], 'qt5: depends on turtlebot3 which depends on turtlebot3-bringup, turtlebot3-navigation2 which depend on rviz2 which depends on qtbase; opengl: depends on turtlebot3 which depends on turtlebot3-bringup which depends on rviz2 which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on turtlebot3 which depends on turtlebot3-bringup, turtlebot3-navigation2 which depend on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; gazebo: depends on gazebo-ros-pkgs->gazebo-rosdev->gazebo which is not available', '', d)}"
SKIP_RECIPE[turtlebot3-simulations] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'gazebo'], 'qt5: depends on turtlebot3-gazebo which depends on turtlebot3 which depends on turtlebot3-bringup, turtlebot3-navigation2 which depend on rviz2 which depends on qtbase; opengl: depends on turtlebot3-gazebo which depends on turtlebot3 which depends on turtlebot3-bringup which depends on rviz2 which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on turtlebot3-gazebo which depends on turtlebot3 which depends on turtlebot3-bringup, turtlebot3-navigation2 which depend on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; gazebo: depends on turtlebot3-gazebo which depends on gazebo-ros-pkgs->gazebo-rosdev->gazebo which is not available', '', d)}"
SKIP_RECIPE[turtlesim] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets'], 'qt5: depends on qtbase; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
SKIP_RECIPE[turtle-tf2-cpp] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets'], 'Requires turtlesim->qtbase which requires meta-qt5 to be included; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
SKIP_RECIPE[turtle-tf2-py] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets'], 'Requires turtlesim->qtbase which requires meta-qt5 to be included; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
SKIP_RECIPE[ur-description] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[ur-robot-driver] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: depends on qtbase; opengl: depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[usb-cam] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['ffmpeg', 'x264'], 'ffmpeg: Depends on ffmpeg which requires commercial license; x264: Depends on ffmpeg which depends on x264 which requires commercial license', '', d)}"
SKIP_RECIPE[warehouse-ros-mongo] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['mongodb', 'mongodb-legacy-cxx-driver'], 'Requires mongodb; mongodb-legacy-cxx-driver: requires unavailable mongo-cxx-driver-legacy', '', d)}"
SKIP_RECIPE[webots-ros2-abb] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'webots-python-modules'], 'qt5: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on qtbase; opengl: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet and webots-ros2-importer which requires python3-collada-pip, urdf2webots-pip which are not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-core] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: requires python-transforms3d-pip which is not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-demos] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'webots-python-modules'], 'qt5: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on qtbase; opengl: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-desktop] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11', 'webots-python-modules'], 'qt5: rdepends on webots-ros2 which rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on qtbase; opengl: rdepends on webots-ros2 which rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on webots-ros2 which rdepends on webots-ros2-universal-robot,webots-ros2-tiago which rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES; webots-python-modules: rdepends on webots-ros2 which rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet and webots-ros2-importer which requires python3-collada-pip, urdf2webots-pip which are not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-epuck] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: rdepends on rviz2 which depends on qtbase; opengl: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[webots-ros2-examples] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-importer] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: requires python3-collada-pip, urdf2webots-pip which are not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-mavic] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-tesla] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-tiago] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: rdepends on rviz2 which depends on qtbase; opengl: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[webots-ros2-turtlebot] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-tutorials] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'webots-python-modules', 'webots-python-modules: rdepends on webots-ros2-core which requires python-transforms3d-pip which is not available in OE yet', '', d)}"
SKIP_RECIPE[webots-ros2-universal-robot] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'opengl', 'x11'], 'qt5: rdepends on rviz2 which depends on qtbase; opengl: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: rdepends on rviz2 which depends on rviz-rendering which depends on rviz-ogre-vendor which depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
SKIP_RECIPE[wiimote] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'cwiid', 'Depends on unavailable ROS_UNRESOLVED_DEP-cwiid-dev', '', d)}"
SKIP_RECIPE[zenoh-bridge-dds] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['clang', 'cargo'], 'clang: depends on clang which requires meta-clang layer; cargo: depends on cargo which requires meta-rust layer (or oe-core[honister] or newer)', '', d)}"

# Renamed to fuse-ros in recipes-bbappends/fuse to avoid conflict with
# meta-filesystems/recipes-support/fuse/fuse_2.9.9.bb
BBMASK +=  "generated-recipes/fuse/fuse_1.2.3-1.bb"
# And renamed fuse-doc to fuse-ros-doc to avoid conflict with PN-doc package created by fuse recipe
BBMASK +=  "generated-recipes/fuse/fuse-doc_1.2.3-1.bb"

# meta-ros provides a recipe for octomap to use instead of the generated one
BBMASK +=  "generated-recipes/octomap/octomap_1.10.0-3.bb"
