SUMMARY = "A pure Python netlink and Linux network configuration library"
LICENSE = "GPL-2.0-or-later | Apache-2.0"
LIC_FILES_CHKSUM = "file://LICENSE;md5=dccbff78d7d79ae7e53953d43445c6e6 \
                    file://LICENSE.GPL-2.0-or-later;md5=b234ee4d69f5fce4486a80fdaf4a4263 \
                    file://LICENSE.Apache-2.0;md5=34281e312165f843a2b7d1f114fe65ce"

SRC_URI[sha256sum] = "cc2f90aad1517cb0b301041f678cc8d3c3427c26e53f15c78c93c67928d89a02"

inherit setuptools3 pypi ptest

RDEPENDS:${PN} += " \
    python3-ctypes \
    python3-io \
    python3-json \
    python3-fcntl \
    python3-logging \
    python3-multiprocessing \
    python3-pickle \
    python3-pkgutil \
    python3-pprint \
    python3-shell \
    python3-unixadmin \
"

SRC_URI += " \
    file://run-ptest \
"

RDEPENDS:${PN}-ptest += " \
    python3-fcntl \
    python3-pytest \
    python3-sqlite3 \
    python3-unittest-automake-output \
"

do_install_ptest() {
    install -d ${D}${PTEST_PATH}/tests
    cp -rf ${S}/tests/* ${D}${PTEST_PATH}/tests/
    sed -e  "s|'test_unit|'tests/test_unit|g" -i  ${D}${PTEST_PATH}/tests/test_unit/test_nlmsg/test_marshal.py \
    ${D}${PTEST_PATH}/tests/test_unit/test_iproute_match/test_match.py
}
