Overview
========

The
[AGL Project](https://www.automotivelinux.org/) is an automotive-specific
development environment that provides a Linux distribution
[AGL UCB](https://www.automotivelinux.org/software/unified-code-base).

AGL uses layers designed to be compatible with the
[Yocto Project](https://www.yoctoproject.org) and the
[OpenEmbedded Project (OE)](https://www.openembedded.org/wiki/Main_Page).

This section provides information about the layers used by the AGL Project:

* **`meta-agl`**: Minimal set of software needed to create an AGL distribution
  used to boot a system.
  AGL profiles are built on top of this minimal set of software.

* **`meta-agl-demo`**: Provides a reference or demo platform and applications
  for the AGL Distribution.
  The reference UI is part of the `meta-agl-demo` layer.

* **`meta-agl-devel`**: Contains components under development or being tested.
  This layer also contains software packages that OEMs need but do not exist
  in AGL.


**WRITER NOTES:** The content for this section is the `README-AGL.md`
  file that is in the `meta-agl` layer, which is a Gerrit layer.
  You can clone the layer using this command:

    ```
    $ git clone https://gerrit.automotivelinux.org/gerrit/AGL/meta-agl

