// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
//
// API docs from [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web).
// Attributions and copyright licensing by Mozilla Contributors is licensed
// under [CC-BY-SA 2.5](https://creativecommons.org/licenses/by-sa/2.5/.

// Generated from Web IDL definitions.

// ignore_for_file: unintended_html_in_doc_comment

@JS()
library;

import 'dart:js_interop';

import 'html.dart';
import 'webgl1.dart';
import 'webidl.dart';

typedef GLint64 = int;
typedef GLuint64 = int;
typedef Uint32List = JSObject;

/// The **`WebGLQuery`** interface is part of the
/// [WebGL 2](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API) API
/// and provides ways to asynchronously query for information. By default,
/// occlusion queries and primitive queries are available.
///
/// Another kind of queries are disjoint timer queries, which allow you to
/// measure performance and profiling of your GPU. Disjoint timer queries are
/// available with the [EXT_disjoint_timer_query] extension only.
///
/// When working with `WebGLQuery` objects, the following methods of the
/// [WebGL2RenderingContext] are useful:
///
/// - [WebGL2RenderingContext.createQuery]
/// - [WebGL2RenderingContext.deleteQuery]
/// - [WebGL2RenderingContext.isQuery]
/// - [WebGL2RenderingContext.beginQuery]
/// - [WebGL2RenderingContext.endQuery]
/// - [WebGL2RenderingContext.getQuery]
/// - [WebGL2RenderingContext.getQueryParameter]
///
/// ---
///
/// API documentation sourced from
/// [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/API/WebGLQuery).
extension type WebGLQuery._(JSObject _) implements JSObject {}

/// The **`WebGLSampler`** interface is part of the
/// [WebGL 2](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API) API
/// and stores sampling parameters for [WebGLTexture] access inside of a shader.
///
/// When working with `WebGLSampler` objects, the following methods of the
/// [WebGL2RenderingContext] are useful:
///
/// - [WebGL2RenderingContext.createSampler]
/// - [WebGL2RenderingContext.deleteSampler]
/// - [WebGL2RenderingContext.isSampler]
/// - [WebGL2RenderingContext.bindSampler]
/// - [WebGL2RenderingContext.getSamplerParameter]
///
/// ---
///
/// API documentation sourced from
/// [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/API/WebGLSampler).
extension type WebGLSampler._(JSObject _) implements JSObject {}

/// The **`WebGLSync`** interface is part of the
/// [WebGL 2](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API) API
/// and is used to synchronize activities between the GPU and the application.
///
/// When working with `WebGLSync` objects, the following methods of the
/// [WebGL2RenderingContext] are useful:
///
/// - [WebGL2RenderingContext.fenceSync]
/// - [WebGL2RenderingContext.deleteSync]
/// - [WebGL2RenderingContext.isSync]
/// - [WebGL2RenderingContext.clientWaitSync]
/// - [WebGL2RenderingContext.waitSync]
/// - [WebGL2RenderingContext.getSyncParameter]
///
/// ---
///
/// API documentation sourced from
/// [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/API/WebGLSync).
extension type WebGLSync._(JSObject _) implements JSObject {}

/// The **`WebGLTransformFeedback`** interface is part of the
/// [WebGL 2](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API) API
/// and enables transform feedback, which is the process of capturing primitives
/// generated by vertex processing. It allows to preserve the post-transform
/// rendering state of an object and resubmit this data multiple times.
///
/// When working with `WebGLTransformFeedback` objects, the following methods of
/// the [WebGL2RenderingContext] are useful:
///
/// - [WebGL2RenderingContext.createTransformFeedback]
/// - [WebGL2RenderingContext.deleteTransformFeedback]
/// - [WebGL2RenderingContext.isTransformFeedback]
/// - [WebGL2RenderingContext.bindTransformFeedback]
/// - [WebGL2RenderingContext.beginTransformFeedback]
/// - [WebGL2RenderingContext.endTransformFeedback]
/// - [WebGL2RenderingContext.pauseTransformFeedback]
/// - [WebGL2RenderingContext.resumeTransformFeedback]
/// - [WebGL2RenderingContext.transformFeedbackVaryings]
/// - [WebGL2RenderingContext.getTransformFeedbackVarying]
///
/// ---
///
/// API documentation sourced from
/// [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/API/WebGLTransformFeedback).
extension type WebGLTransformFeedback._(JSObject _) implements JSObject {}

/// The **`WebGLVertexArrayObject`** interface is part of the
/// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API),
/// represents vertex array objects (VAOs) pointing to vertex array data, and
/// provides names for different sets of vertex data.
///
/// When working with `WebGLVertexArrayObject` objects, the following methods
/// are useful:
///
/// - [WebGL2RenderingContext.createVertexArray]
/// - [WebGL2RenderingContext.deleteVertexArray]
/// - [WebGL2RenderingContext.isVertexArray]
/// - [WebGL2RenderingContext.bindVertexArray]
///
/// > **Note:** The [OES_vertex_array_object] extension allows you to use vertex
/// > array objects in a WebGL 1 context.
///
/// ---
///
/// API documentation sourced from
/// [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/API/WebGLVertexArrayObject).
extension type WebGLVertexArrayObject._(JSObject _) implements JSObject {}

/// The **WebGL2RenderingContext** interface provides the OpenGL ES 3.0
/// rendering context for the drawing surface of an HTML `canvas` element.
///
/// To get an object of this interface, call [HTMLCanvasElement.getContext] on a
/// `<canvas>` element, supplying "webgl2" as the argument:
///
/// ```js
/// const canvas = document.getElementById("myCanvas");
/// const gl = canvas.getContext("webgl2");
/// ```
///
/// > **Note:** WebGL 2 is an extension to WebGL 1. The `WebGL2RenderingContext`
/// > interface implements all members of the [WebGLRenderingContext] interface.
/// > Some methods of the WebGL 1 context can accept additional values when used
/// > in a WebGL 2 context. You will find this info noted on the WebGL 1
/// > reference pages.
///
/// The
/// [WebGL tutorial](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API/Tutorial)
/// has more information, examples, and resources on how to get started with
/// WebGL.
///
/// ---
///
/// API documentation sourced from
/// [MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext).
extension type WebGL2RenderingContext._(JSObject _) implements JSObject {
  static const GLenum DEPTH_BUFFER_BIT = 256;

  static const GLenum STENCIL_BUFFER_BIT = 1024;

  static const GLenum COLOR_BUFFER_BIT = 16384;

  static const GLenum POINTS = 0;

  static const GLenum LINES = 1;

  static const GLenum LINE_LOOP = 2;

  static const GLenum LINE_STRIP = 3;

  static const GLenum TRIANGLES = 4;

  static const GLenum TRIANGLE_STRIP = 5;

  static const GLenum TRIANGLE_FAN = 6;

  static const GLenum ZERO = 0;

  static const GLenum ONE = 1;

  static const GLenum SRC_COLOR = 768;

  static const GLenum ONE_MINUS_SRC_COLOR = 769;

  static const GLenum SRC_ALPHA = 770;

  static const GLenum ONE_MINUS_SRC_ALPHA = 771;

  static const GLenum DST_ALPHA = 772;

  static const GLenum ONE_MINUS_DST_ALPHA = 773;

  static const GLenum DST_COLOR = 774;

  static const GLenum ONE_MINUS_DST_COLOR = 775;

  static const GLenum SRC_ALPHA_SATURATE = 776;

  static const GLenum FUNC_ADD = 32774;

  static const GLenum BLEND_EQUATION = 32777;

  static const GLenum BLEND_EQUATION_RGB = 32777;

  static const GLenum BLEND_EQUATION_ALPHA = 34877;

  static const GLenum FUNC_SUBTRACT = 32778;

  static const GLenum FUNC_REVERSE_SUBTRACT = 32779;

  static const GLenum BLEND_DST_RGB = 32968;

  static const GLenum BLEND_SRC_RGB = 32969;

  static const GLenum BLEND_DST_ALPHA = 32970;

  static const GLenum BLEND_SRC_ALPHA = 32971;

  static const GLenum CONSTANT_COLOR = 32769;

  static const GLenum ONE_MINUS_CONSTANT_COLOR = 32770;

  static const GLenum CONSTANT_ALPHA = 32771;

  static const GLenum ONE_MINUS_CONSTANT_ALPHA = 32772;

  static const GLenum BLEND_COLOR = 32773;

  static const GLenum ARRAY_BUFFER = 34962;

  static const GLenum ELEMENT_ARRAY_BUFFER = 34963;

  static const GLenum ARRAY_BUFFER_BINDING = 34964;

  static const GLenum ELEMENT_ARRAY_BUFFER_BINDING = 34965;

  static const GLenum STREAM_DRAW = 35040;

  static const GLenum STATIC_DRAW = 35044;

  static const GLenum DYNAMIC_DRAW = 35048;

  static const GLenum BUFFER_SIZE = 34660;

  static const GLenum BUFFER_USAGE = 34661;

  static const GLenum CURRENT_VERTEX_ATTRIB = 34342;

  static const GLenum FRONT = 1028;

  static const GLenum BACK = 1029;

  static const GLenum FRONT_AND_BACK = 1032;

  static const GLenum CULL_FACE = 2884;

  static const GLenum BLEND = 3042;

  static const GLenum DITHER = 3024;

  static const GLenum STENCIL_TEST = 2960;

  static const GLenum DEPTH_TEST = 2929;

  static const GLenum SCISSOR_TEST = 3089;

  static const GLenum POLYGON_OFFSET_FILL = 32823;

  static const GLenum SAMPLE_ALPHA_TO_COVERAGE = 32926;

  static const GLenum SAMPLE_COVERAGE = 32928;

  static const GLenum NO_ERROR = 0;

  static const GLenum INVALID_ENUM = 1280;

  static const GLenum INVALID_VALUE = 1281;

  static const GLenum INVALID_OPERATION = 1282;

  static const GLenum OUT_OF_MEMORY = 1285;

  static const GLenum CW = 2304;

  static const GLenum CCW = 2305;

  static const GLenum LINE_WIDTH = 2849;

  static const GLenum ALIASED_POINT_SIZE_RANGE = 33901;

  static const GLenum ALIASED_LINE_WIDTH_RANGE = 33902;

  static const GLenum CULL_FACE_MODE = 2885;

  static const GLenum FRONT_FACE = 2886;

  static const GLenum DEPTH_RANGE = 2928;

  static const GLenum DEPTH_WRITEMASK = 2930;

  static const GLenum DEPTH_CLEAR_VALUE = 2931;

  static const GLenum DEPTH_FUNC = 2932;

  static const GLenum STENCIL_CLEAR_VALUE = 2961;

  static const GLenum STENCIL_FUNC = 2962;

  static const GLenum STENCIL_FAIL = 2964;

  static const GLenum STENCIL_PASS_DEPTH_FAIL = 2965;

  static const GLenum STENCIL_PASS_DEPTH_PASS = 2966;

  static const GLenum STENCIL_REF = 2967;

  static const GLenum STENCIL_VALUE_MASK = 2963;

  static const GLenum STENCIL_WRITEMASK = 2968;

  static const GLenum STENCIL_BACK_FUNC = 34816;

  static const GLenum STENCIL_BACK_FAIL = 34817;

  static const GLenum STENCIL_BACK_PASS_DEPTH_FAIL = 34818;

  static const GLenum STENCIL_BACK_PASS_DEPTH_PASS = 34819;

  static const GLenum STENCIL_BACK_REF = 36003;

  static const GLenum STENCIL_BACK_VALUE_MASK = 36004;

  static const GLenum STENCIL_BACK_WRITEMASK = 36005;

  static const GLenum VIEWPORT = 2978;

  static const GLenum SCISSOR_BOX = 3088;

  static const GLenum COLOR_CLEAR_VALUE = 3106;

  static const GLenum COLOR_WRITEMASK = 3107;

  static const GLenum UNPACK_ALIGNMENT = 3317;

  static const GLenum PACK_ALIGNMENT = 3333;

  static const GLenum MAX_TEXTURE_SIZE = 3379;

  static const GLenum MAX_VIEWPORT_DIMS = 3386;

  static const GLenum SUBPIXEL_BITS = 3408;

  static const GLenum RED_BITS = 3410;

  static const GLenum GREEN_BITS = 3411;

  static const GLenum BLUE_BITS = 3412;

  static const GLenum ALPHA_BITS = 3413;

  static const GLenum DEPTH_BITS = 3414;

  static const GLenum STENCIL_BITS = 3415;

  static const GLenum POLYGON_OFFSET_UNITS = 10752;

  static const GLenum POLYGON_OFFSET_FACTOR = 32824;

  static const GLenum TEXTURE_BINDING_2D = 32873;

  static const GLenum SAMPLE_BUFFERS = 32936;

  static const GLenum SAMPLES = 32937;

  static const GLenum SAMPLE_COVERAGE_VALUE = 32938;

  static const GLenum SAMPLE_COVERAGE_INVERT = 32939;

  static const GLenum COMPRESSED_TEXTURE_FORMATS = 34467;

  static const GLenum DONT_CARE = 4352;

  static const GLenum FASTEST = 4353;

  static const GLenum NICEST = 4354;

  static const GLenum GENERATE_MIPMAP_HINT = 33170;

  static const GLenum BYTE = 5120;

  static const GLenum UNSIGNED_BYTE = 5121;

  static const GLenum SHORT = 5122;

  static const GLenum UNSIGNED_SHORT = 5123;

  static const GLenum INT = 5124;

  static const GLenum UNSIGNED_INT = 5125;

  static const GLenum FLOAT = 5126;

  static const GLenum DEPTH_COMPONENT = 6402;

  static const GLenum ALPHA = 6406;

  static const GLenum RGB = 6407;

  static const GLenum RGBA = 6408;

  static const GLenum LUMINANCE = 6409;

  static const GLenum LUMINANCE_ALPHA = 6410;

  static const GLenum UNSIGNED_SHORT_4_4_4_4 = 32819;

  static const GLenum UNSIGNED_SHORT_5_5_5_1 = 32820;

  static const GLenum UNSIGNED_SHORT_5_6_5 = 33635;

  static const GLenum FRAGMENT_SHADER = 35632;

  static const GLenum VERTEX_SHADER = 35633;

  static const GLenum MAX_VERTEX_ATTRIBS = 34921;

  static const GLenum MAX_VERTEX_UNIFORM_VECTORS = 36347;

  static const GLenum MAX_VARYING_VECTORS = 36348;

  static const GLenum MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;

  static const GLenum MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;

  static const GLenum MAX_TEXTURE_IMAGE_UNITS = 34930;

  static const GLenum MAX_FRAGMENT_UNIFORM_VECTORS = 36349;

  static const GLenum SHADER_TYPE = 35663;

  static const GLenum DELETE_STATUS = 35712;

  static const GLenum LINK_STATUS = 35714;

  static const GLenum VALIDATE_STATUS = 35715;

  static const GLenum ATTACHED_SHADERS = 35717;

  static const GLenum ACTIVE_UNIFORMS = 35718;

  static const GLenum ACTIVE_ATTRIBUTES = 35721;

  static const GLenum SHADING_LANGUAGE_VERSION = 35724;

  static const GLenum CURRENT_PROGRAM = 35725;

  static const GLenum NEVER = 512;

  static const GLenum LESS = 513;

  static const GLenum EQUAL = 514;

  static const GLenum LEQUAL = 515;

  static const GLenum GREATER = 516;

  static const GLenum NOTEQUAL = 517;

  static const GLenum GEQUAL = 518;

  static const GLenum ALWAYS = 519;

  static const GLenum KEEP = 7680;

  static const GLenum REPLACE = 7681;

  static const GLenum INCR = 7682;

  static const GLenum DECR = 7683;

  static const GLenum INVERT = 5386;

  static const GLenum INCR_WRAP = 34055;

  static const GLenum DECR_WRAP = 34056;

  static const GLenum VENDOR = 7936;

  static const GLenum RENDERER = 7937;

  static const GLenum VERSION = 7938;

  static const GLenum NEAREST = 9728;

  static const GLenum LINEAR = 9729;

  static const GLenum NEAREST_MIPMAP_NEAREST = 9984;

  static const GLenum LINEAR_MIPMAP_NEAREST = 9985;

  static const GLenum NEAREST_MIPMAP_LINEAR = 9986;

  static const GLenum LINEAR_MIPMAP_LINEAR = 9987;

  static const GLenum TEXTURE_MAG_FILTER = 10240;

  static const GLenum TEXTURE_MIN_FILTER = 10241;

  static const GLenum TEXTURE_WRAP_S = 10242;

  static const GLenum TEXTURE_WRAP_T = 10243;

  static const GLenum TEXTURE_2D = 3553;

  static const GLenum TEXTURE = 5890;

  static const GLenum TEXTURE_CUBE_MAP = 34067;

  static const GLenum TEXTURE_BINDING_CUBE_MAP = 34068;

  static const GLenum TEXTURE_CUBE_MAP_POSITIVE_X = 34069;

  static const GLenum TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;

  static const GLenum TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;

  static const GLenum TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;

  static const GLenum TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;

  static const GLenum TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;

  static const GLenum MAX_CUBE_MAP_TEXTURE_SIZE = 34076;

  static const GLenum TEXTURE0 = 33984;

  static const GLenum TEXTURE1 = 33985;

  static const GLenum TEXTURE2 = 33986;

  static const GLenum TEXTURE3 = 33987;

  static const GLenum TEXTURE4 = 33988;

  static const GLenum TEXTURE5 = 33989;

  static const GLenum TEXTURE6 = 33990;

  static const GLenum TEXTURE7 = 33991;

  static const GLenum TEXTURE8 = 33992;

  static const GLenum TEXTURE9 = 33993;

  static const GLenum TEXTURE10 = 33994;

  static const GLenum TEXTURE11 = 33995;

  static const GLenum TEXTURE12 = 33996;

  static const GLenum TEXTURE13 = 33997;

  static const GLenum TEXTURE14 = 33998;

  static const GLenum TEXTURE15 = 33999;

  static const GLenum TEXTURE16 = 34000;

  static const GLenum TEXTURE17 = 34001;

  static const GLenum TEXTURE18 = 34002;

  static const GLenum TEXTURE19 = 34003;

  static const GLenum TEXTURE20 = 34004;

  static const GLenum TEXTURE21 = 34005;

  static const GLenum TEXTURE22 = 34006;

  static const GLenum TEXTURE23 = 34007;

  static const GLenum TEXTURE24 = 34008;

  static const GLenum TEXTURE25 = 34009;

  static const GLenum TEXTURE26 = 34010;

  static const GLenum TEXTURE27 = 34011;

  static const GLenum TEXTURE28 = 34012;

  static const GLenum TEXTURE29 = 34013;

  static const GLenum TEXTURE30 = 34014;

  static const GLenum TEXTURE31 = 34015;

  static const GLenum ACTIVE_TEXTURE = 34016;

  static const GLenum REPEAT = 10497;

  static const GLenum CLAMP_TO_EDGE = 33071;

  static const GLenum MIRRORED_REPEAT = 33648;

  static const GLenum FLOAT_VEC2 = 35664;

  static const GLenum FLOAT_VEC3 = 35665;

  static const GLenum FLOAT_VEC4 = 35666;

  static const GLenum INT_VEC2 = 35667;

  static const GLenum INT_VEC3 = 35668;

  static const GLenum INT_VEC4 = 35669;

  static const GLenum BOOL = 35670;

  static const GLenum BOOL_VEC2 = 35671;

  static const GLenum BOOL_VEC3 = 35672;

  static const GLenum BOOL_VEC4 = 35673;

  static const GLenum FLOAT_MAT2 = 35674;

  static const GLenum FLOAT_MAT3 = 35675;

  static const GLenum FLOAT_MAT4 = 35676;

  static const GLenum SAMPLER_2D = 35678;

  static const GLenum SAMPLER_CUBE = 35680;

  static const GLenum VERTEX_ATTRIB_ARRAY_ENABLED = 34338;

  static const GLenum VERTEX_ATTRIB_ARRAY_SIZE = 34339;

  static const GLenum VERTEX_ATTRIB_ARRAY_STRIDE = 34340;

  static const GLenum VERTEX_ATTRIB_ARRAY_TYPE = 34341;

  static const GLenum VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;

  static const GLenum VERTEX_ATTRIB_ARRAY_POINTER = 34373;

  static const GLenum VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;

  static const GLenum IMPLEMENTATION_COLOR_READ_TYPE = 35738;

  static const GLenum IMPLEMENTATION_COLOR_READ_FORMAT = 35739;

  static const GLenum COMPILE_STATUS = 35713;

  static const GLenum LOW_FLOAT = 36336;

  static const GLenum MEDIUM_FLOAT = 36337;

  static const GLenum HIGH_FLOAT = 36338;

  static const GLenum LOW_INT = 36339;

  static const GLenum MEDIUM_INT = 36340;

  static const GLenum HIGH_INT = 36341;

  static const GLenum FRAMEBUFFER = 36160;

  static const GLenum RENDERBUFFER = 36161;

  static const GLenum RGBA4 = 32854;

  static const GLenum RGB5_A1 = 32855;

  static const GLenum RGBA8 = 32856;

  static const GLenum RGB565 = 36194;

  static const GLenum DEPTH_COMPONENT16 = 33189;

  static const GLenum STENCIL_INDEX8 = 36168;

  static const GLenum DEPTH_STENCIL = 34041;

  static const GLenum RENDERBUFFER_WIDTH = 36162;

  static const GLenum RENDERBUFFER_HEIGHT = 36163;

  static const GLenum RENDERBUFFER_INTERNAL_FORMAT = 36164;

  static const GLenum RENDERBUFFER_RED_SIZE = 36176;

  static const GLenum RENDERBUFFER_GREEN_SIZE = 36177;

  static const GLenum RENDERBUFFER_BLUE_SIZE = 36178;

  static const GLenum RENDERBUFFER_ALPHA_SIZE = 36179;

  static const GLenum RENDERBUFFER_DEPTH_SIZE = 36180;

  static const GLenum RENDERBUFFER_STENCIL_SIZE = 36181;

  static const GLenum FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;

  static const GLenum FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;

  static const GLenum FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;

  static const GLenum FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;

  static const GLenum COLOR_ATTACHMENT0 = 36064;

  static const GLenum DEPTH_ATTACHMENT = 36096;

  static const GLenum STENCIL_ATTACHMENT = 36128;

  static const GLenum DEPTH_STENCIL_ATTACHMENT = 33306;

  static const GLenum NONE = 0;

  static const GLenum FRAMEBUFFER_COMPLETE = 36053;

  static const GLenum FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;

  static const GLenum FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;

  static const GLenum FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;

  static const GLenum FRAMEBUFFER_UNSUPPORTED = 36061;

  static const GLenum FRAMEBUFFER_BINDING = 36006;

  static const GLenum RENDERBUFFER_BINDING = 36007;

  static const GLenum MAX_RENDERBUFFER_SIZE = 34024;

  static const GLenum INVALID_FRAMEBUFFER_OPERATION = 1286;

  static const GLenum UNPACK_FLIP_Y_WEBGL = 37440;

  static const GLenum UNPACK_PREMULTIPLY_ALPHA_WEBGL = 37441;

  static const GLenum CONTEXT_LOST_WEBGL = 37442;

  static const GLenum UNPACK_COLORSPACE_CONVERSION_WEBGL = 37443;

  static const GLenum BROWSER_DEFAULT_WEBGL = 37444;

  static const GLenum READ_BUFFER = 3074;

  static const GLenum UNPACK_ROW_LENGTH = 3314;

  static const GLenum UNPACK_SKIP_ROWS = 3315;

  static const GLenum UNPACK_SKIP_PIXELS = 3316;

  static const GLenum PACK_ROW_LENGTH = 3330;

  static const GLenum PACK_SKIP_ROWS = 3331;

  static const GLenum PACK_SKIP_PIXELS = 3332;

  static const GLenum COLOR = 6144;

  static const GLenum DEPTH = 6145;

  static const GLenum STENCIL = 6146;

  static const GLenum RED = 6403;

  static const GLenum RGB8 = 32849;

  static const GLenum RGB10_A2 = 32857;

  static const GLenum TEXTURE_BINDING_3D = 32874;

  static const GLenum UNPACK_SKIP_IMAGES = 32877;

  static const GLenum UNPACK_IMAGE_HEIGHT = 32878;

  static const GLenum TEXTURE_3D = 32879;

  static const GLenum TEXTURE_WRAP_R = 32882;

  static const GLenum MAX_3D_TEXTURE_SIZE = 32883;

  static const GLenum UNSIGNED_INT_2_10_10_10_REV = 33640;

  static const GLenum MAX_ELEMENTS_VERTICES = 33000;

  static const GLenum MAX_ELEMENTS_INDICES = 33001;

  static const GLenum TEXTURE_MIN_LOD = 33082;

  static const GLenum TEXTURE_MAX_LOD = 33083;

  static const GLenum TEXTURE_BASE_LEVEL = 33084;

  static const GLenum TEXTURE_MAX_LEVEL = 33085;

  static const GLenum MIN = 32775;

  static const GLenum MAX = 32776;

  static const GLenum DEPTH_COMPONENT24 = 33190;

  static const GLenum MAX_TEXTURE_LOD_BIAS = 34045;

  static const GLenum TEXTURE_COMPARE_MODE = 34892;

  static const GLenum TEXTURE_COMPARE_FUNC = 34893;

  static const GLenum CURRENT_QUERY = 34917;

  static const GLenum QUERY_RESULT = 34918;

  static const GLenum QUERY_RESULT_AVAILABLE = 34919;

  static const GLenum STREAM_READ = 35041;

  static const GLenum STREAM_COPY = 35042;

  static const GLenum STATIC_READ = 35045;

  static const GLenum STATIC_COPY = 35046;

  static const GLenum DYNAMIC_READ = 35049;

  static const GLenum DYNAMIC_COPY = 35050;

  static const GLenum MAX_DRAW_BUFFERS = 34852;

  static const GLenum DRAW_BUFFER0 = 34853;

  static const GLenum DRAW_BUFFER1 = 34854;

  static const GLenum DRAW_BUFFER2 = 34855;

  static const GLenum DRAW_BUFFER3 = 34856;

  static const GLenum DRAW_BUFFER4 = 34857;

  static const GLenum DRAW_BUFFER5 = 34858;

  static const GLenum DRAW_BUFFER6 = 34859;

  static const GLenum DRAW_BUFFER7 = 34860;

  static const GLenum DRAW_BUFFER8 = 34861;

  static const GLenum DRAW_BUFFER9 = 34862;

  static const GLenum DRAW_BUFFER10 = 34863;

  static const GLenum DRAW_BUFFER11 = 34864;

  static const GLenum DRAW_BUFFER12 = 34865;

  static const GLenum DRAW_BUFFER13 = 34866;

  static const GLenum DRAW_BUFFER14 = 34867;

  static const GLenum DRAW_BUFFER15 = 34868;

  static const GLenum MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;

  static const GLenum MAX_VERTEX_UNIFORM_COMPONENTS = 35658;

  static const GLenum SAMPLER_3D = 35679;

  static const GLenum SAMPLER_2D_SHADOW = 35682;

  static const GLenum FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;

  static const GLenum PIXEL_PACK_BUFFER = 35051;

  static const GLenum PIXEL_UNPACK_BUFFER = 35052;

  static const GLenum PIXEL_PACK_BUFFER_BINDING = 35053;

  static const GLenum PIXEL_UNPACK_BUFFER_BINDING = 35055;

  static const GLenum FLOAT_MAT2x3 = 35685;

  static const GLenum FLOAT_MAT2x4 = 35686;

  static const GLenum FLOAT_MAT3x2 = 35687;

  static const GLenum FLOAT_MAT3x4 = 35688;

  static const GLenum FLOAT_MAT4x2 = 35689;

  static const GLenum FLOAT_MAT4x3 = 35690;

  static const GLenum SRGB = 35904;

  static const GLenum SRGB8 = 35905;

  static const GLenum SRGB8_ALPHA8 = 35907;

  static const GLenum COMPARE_REF_TO_TEXTURE = 34894;

  static const GLenum RGBA32F = 34836;

  static const GLenum RGB32F = 34837;

  static const GLenum RGBA16F = 34842;

  static const GLenum RGB16F = 34843;

  static const GLenum VERTEX_ATTRIB_ARRAY_INTEGER = 35069;

  static const GLenum MAX_ARRAY_TEXTURE_LAYERS = 35071;

  static const GLenum MIN_PROGRAM_TEXEL_OFFSET = 35076;

  static const GLenum MAX_PROGRAM_TEXEL_OFFSET = 35077;

  static const GLenum MAX_VARYING_COMPONENTS = 35659;

  static const GLenum TEXTURE_2D_ARRAY = 35866;

  static const GLenum TEXTURE_BINDING_2D_ARRAY = 35869;

  static const GLenum R11F_G11F_B10F = 35898;

  static const GLenum UNSIGNED_INT_10F_11F_11F_REV = 35899;

  static const GLenum RGB9_E5 = 35901;

  static const GLenum UNSIGNED_INT_5_9_9_9_REV = 35902;

  static const GLenum TRANSFORM_FEEDBACK_BUFFER_MODE = 35967;

  static const GLenum MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 35968;

  static const GLenum TRANSFORM_FEEDBACK_VARYINGS = 35971;

  static const GLenum TRANSFORM_FEEDBACK_BUFFER_START = 35972;

  static const GLenum TRANSFORM_FEEDBACK_BUFFER_SIZE = 35973;

  static const GLenum TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 35976;

  static const GLenum RASTERIZER_DISCARD = 35977;

  static const GLenum MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 35978;

  static const GLenum MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 35979;

  static const GLenum INTERLEAVED_ATTRIBS = 35980;

  static const GLenum SEPARATE_ATTRIBS = 35981;

  static const GLenum TRANSFORM_FEEDBACK_BUFFER = 35982;

  static const GLenum TRANSFORM_FEEDBACK_BUFFER_BINDING = 35983;

  static const GLenum RGBA32UI = 36208;

  static const GLenum RGB32UI = 36209;

  static const GLenum RGBA16UI = 36214;

  static const GLenum RGB16UI = 36215;

  static const GLenum RGBA8UI = 36220;

  static const GLenum RGB8UI = 36221;

  static const GLenum RGBA32I = 36226;

  static const GLenum RGB32I = 36227;

  static const GLenum RGBA16I = 36232;

  static const GLenum RGB16I = 36233;

  static const GLenum RGBA8I = 36238;

  static const GLenum RGB8I = 36239;

  static const GLenum RED_INTEGER = 36244;

  static const GLenum RGB_INTEGER = 36248;

  static const GLenum RGBA_INTEGER = 36249;

  static const GLenum SAMPLER_2D_ARRAY = 36289;

  static const GLenum SAMPLER_2D_ARRAY_SHADOW = 36292;

  static const GLenum SAMPLER_CUBE_SHADOW = 36293;

  static const GLenum UNSIGNED_INT_VEC2 = 36294;

  static const GLenum UNSIGNED_INT_VEC3 = 36295;

  static const GLenum UNSIGNED_INT_VEC4 = 36296;

  static const GLenum INT_SAMPLER_2D = 36298;

  static const GLenum INT_SAMPLER_3D = 36299;

  static const GLenum INT_SAMPLER_CUBE = 36300;

  static const GLenum INT_SAMPLER_2D_ARRAY = 36303;

  static const GLenum UNSIGNED_INT_SAMPLER_2D = 36306;

  static const GLenum UNSIGNED_INT_SAMPLER_3D = 36307;

  static const GLenum UNSIGNED_INT_SAMPLER_CUBE = 36308;

  static const GLenum UNSIGNED_INT_SAMPLER_2D_ARRAY = 36311;

  static const GLenum DEPTH_COMPONENT32F = 36012;

  static const GLenum DEPTH32F_STENCIL8 = 36013;

  static const GLenum FLOAT_32_UNSIGNED_INT_24_8_REV = 36269;

  static const GLenum FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 33296;

  static const GLenum FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 33297;

  static const GLenum FRAMEBUFFER_ATTACHMENT_RED_SIZE = 33298;

  static const GLenum FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 33299;

  static const GLenum FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 33300;

  static const GLenum FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 33301;

  static const GLenum FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 33302;

  static const GLenum FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 33303;

  static const GLenum FRAMEBUFFER_DEFAULT = 33304;

  static const GLenum UNSIGNED_INT_24_8 = 34042;

  static const GLenum DEPTH24_STENCIL8 = 35056;

  static const GLenum UNSIGNED_NORMALIZED = 35863;

  static const GLenum DRAW_FRAMEBUFFER_BINDING = 36006;

  static const GLenum READ_FRAMEBUFFER = 36008;

  static const GLenum DRAW_FRAMEBUFFER = 36009;

  static const GLenum READ_FRAMEBUFFER_BINDING = 36010;

  static const GLenum RENDERBUFFER_SAMPLES = 36011;

  static const GLenum FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 36052;

  static const GLenum MAX_COLOR_ATTACHMENTS = 36063;

  static const GLenum COLOR_ATTACHMENT1 = 36065;

  static const GLenum COLOR_ATTACHMENT2 = 36066;

  static const GLenum COLOR_ATTACHMENT3 = 36067;

  static const GLenum COLOR_ATTACHMENT4 = 36068;

  static const GLenum COLOR_ATTACHMENT5 = 36069;

  static const GLenum COLOR_ATTACHMENT6 = 36070;

  static const GLenum COLOR_ATTACHMENT7 = 36071;

  static const GLenum COLOR_ATTACHMENT8 = 36072;

  static const GLenum COLOR_ATTACHMENT9 = 36073;

  static const GLenum COLOR_ATTACHMENT10 = 36074;

  static const GLenum COLOR_ATTACHMENT11 = 36075;

  static const GLenum COLOR_ATTACHMENT12 = 36076;

  static const GLenum COLOR_ATTACHMENT13 = 36077;

  static const GLenum COLOR_ATTACHMENT14 = 36078;

  static const GLenum COLOR_ATTACHMENT15 = 36079;

  static const GLenum FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;

  static const GLenum MAX_SAMPLES = 36183;

  static const GLenum HALF_FLOAT = 5131;

  static const GLenum RG = 33319;

  static const GLenum RG_INTEGER = 33320;

  static const GLenum R8 = 33321;

  static const GLenum RG8 = 33323;

  static const GLenum R16F = 33325;

  static const GLenum R32F = 33326;

  static const GLenum RG16F = 33327;

  static const GLenum RG32F = 33328;

  static const GLenum R8I = 33329;

  static const GLenum R8UI = 33330;

  static const GLenum R16I = 33331;

  static const GLenum R16UI = 33332;

  static const GLenum R32I = 33333;

  static const GLenum R32UI = 33334;

  static const GLenum RG8I = 33335;

  static const GLenum RG8UI = 33336;

  static const GLenum RG16I = 33337;

  static const GLenum RG16UI = 33338;

  static const GLenum RG32I = 33339;

  static const GLenum RG32UI = 33340;

  static const GLenum VERTEX_ARRAY_BINDING = 34229;

  static const GLenum R8_SNORM = 36756;

  static const GLenum RG8_SNORM = 36757;

  static const GLenum RGB8_SNORM = 36758;

  static const GLenum RGBA8_SNORM = 36759;

  static const GLenum SIGNED_NORMALIZED = 36764;

  static const GLenum COPY_READ_BUFFER = 36662;

  static const GLenum COPY_WRITE_BUFFER = 36663;

  static const GLenum COPY_READ_BUFFER_BINDING = 36662;

  static const GLenum COPY_WRITE_BUFFER_BINDING = 36663;

  static const GLenum UNIFORM_BUFFER = 35345;

  static const GLenum UNIFORM_BUFFER_BINDING = 35368;

  static const GLenum UNIFORM_BUFFER_START = 35369;

  static const GLenum UNIFORM_BUFFER_SIZE = 35370;

  static const GLenum MAX_VERTEX_UNIFORM_BLOCKS = 35371;

  static const GLenum MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;

  static const GLenum MAX_COMBINED_UNIFORM_BLOCKS = 35374;

  static const GLenum MAX_UNIFORM_BUFFER_BINDINGS = 35375;

  static const GLenum MAX_UNIFORM_BLOCK_SIZE = 35376;

  static const GLenum MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;

  static const GLenum MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;

  static const GLenum UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;

  static const GLenum ACTIVE_UNIFORM_BLOCKS = 35382;

  static const GLenum UNIFORM_TYPE = 35383;

  static const GLenum UNIFORM_SIZE = 35384;

  static const GLenum UNIFORM_BLOCK_INDEX = 35386;

  static const GLenum UNIFORM_OFFSET = 35387;

  static const GLenum UNIFORM_ARRAY_STRIDE = 35388;

  static const GLenum UNIFORM_MATRIX_STRIDE = 35389;

  static const GLenum UNIFORM_IS_ROW_MAJOR = 35390;

  static const GLenum UNIFORM_BLOCK_BINDING = 35391;

  static const GLenum UNIFORM_BLOCK_DATA_SIZE = 35392;

  static const GLenum UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;

  static const GLenum UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;

  static const GLenum UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;

  static const GLenum UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;

  static const GLenum INVALID_INDEX = 4294967295;

  static const GLenum MAX_VERTEX_OUTPUT_COMPONENTS = 37154;

  static const GLenum MAX_FRAGMENT_INPUT_COMPONENTS = 37157;

  static const GLenum MAX_SERVER_WAIT_TIMEOUT = 37137;

  static const GLenum OBJECT_TYPE = 37138;

  static const GLenum SYNC_CONDITION = 37139;

  static const GLenum SYNC_STATUS = 37140;

  static const GLenum SYNC_FLAGS = 37141;

  static const GLenum SYNC_FENCE = 37142;

  static const GLenum SYNC_GPU_COMMANDS_COMPLETE = 37143;

  static const GLenum UNSIGNALED = 37144;

  static const GLenum SIGNALED = 37145;

  static const GLenum ALREADY_SIGNALED = 37146;

  static const GLenum TIMEOUT_EXPIRED = 37147;

  static const GLenum CONDITION_SATISFIED = 37148;

  static const GLenum WAIT_FAILED = 37149;

  static const GLenum SYNC_FLUSH_COMMANDS_BIT = 1;

  static const GLenum VERTEX_ATTRIB_ARRAY_DIVISOR = 35070;

  static const GLenum ANY_SAMPLES_PASSED = 35887;

  static const GLenum ANY_SAMPLES_PASSED_CONSERVATIVE = 36202;

  static const GLenum SAMPLER_BINDING = 35097;

  static const GLenum RGB10_A2UI = 36975;

  static const GLenum INT_2_10_10_10_REV = 36255;

  static const GLenum TRANSFORM_FEEDBACK = 36386;

  static const GLenum TRANSFORM_FEEDBACK_PAUSED = 36387;

  static const GLenum TRANSFORM_FEEDBACK_ACTIVE = 36388;

  static const GLenum TRANSFORM_FEEDBACK_BINDING = 36389;

  static const GLenum TEXTURE_IMMUTABLE_FORMAT = 37167;

  static const GLenum MAX_ELEMENT_INDEX = 36203;

  static const GLenum TEXTURE_IMMUTABLE_LEVELS = 33503;

  static const GLint64 TIMEOUT_IGNORED = -1;

  static const GLenum MAX_CLIENT_WAIT_TIMEOUT_WEBGL = 37447;

  external WebGLContextAttributes? getContextAttributes();
  external bool isContextLost();
  external JSArray<JSString>? getSupportedExtensions();
  external JSObject? getExtension(String name);
  external void activeTexture(GLenum texture);
  external void attachShader(
    WebGLProgram program,
    WebGLShader shader,
  );
  external void bindAttribLocation(
    WebGLProgram program,
    GLuint index,
    String name,
  );
  external void bindBuffer(
    GLenum target,
    WebGLBuffer? buffer,
  );
  external void bindFramebuffer(
    GLenum target,
    WebGLFramebuffer? framebuffer,
  );
  external void bindRenderbuffer(
    GLenum target,
    WebGLRenderbuffer? renderbuffer,
  );
  external void bindTexture(
    GLenum target,
    WebGLTexture? texture,
  );
  external void blendColor(
    GLclampf red,
    GLclampf green,
    GLclampf blue,
    GLclampf alpha,
  );
  external void blendEquation(GLenum mode);
  external void blendEquationSeparate(
    GLenum modeRGB,
    GLenum modeAlpha,
  );
  external void blendFunc(
    GLenum sfactor,
    GLenum dfactor,
  );
  external void blendFuncSeparate(
    GLenum srcRGB,
    GLenum dstRGB,
    GLenum srcAlpha,
    GLenum dstAlpha,
  );
  external GLenum checkFramebufferStatus(GLenum target);
  external void clear(GLbitfield mask);
  external void clearColor(
    GLclampf red,
    GLclampf green,
    GLclampf blue,
    GLclampf alpha,
  );
  external void clearDepth(GLclampf depth);
  external void clearStencil(GLint s);
  external void colorMask(
    GLboolean red,
    GLboolean green,
    GLboolean blue,
    GLboolean alpha,
  );
  external void compileShader(WebGLShader shader);
  external void copyTexImage2D(
    GLenum target,
    GLint level,
    GLenum internalformat,
    GLint x,
    GLint y,
    GLsizei width,
    GLsizei height,
    GLint border,
  );
  external void copyTexSubImage2D(
    GLenum target,
    GLint level,
    GLint xoffset,
    GLint yoffset,
    GLint x,
    GLint y,
    GLsizei width,
    GLsizei height,
  );
  external WebGLBuffer? createBuffer();
  external WebGLFramebuffer? createFramebuffer();
  external WebGLProgram? createProgram();
  external WebGLRenderbuffer? createRenderbuffer();
  external WebGLShader? createShader(GLenum type);
  external WebGLTexture? createTexture();
  external void cullFace(GLenum mode);
  external void deleteBuffer(WebGLBuffer? buffer);
  external void deleteFramebuffer(WebGLFramebuffer? framebuffer);
  external void deleteProgram(WebGLProgram? program);
  external void deleteRenderbuffer(WebGLRenderbuffer? renderbuffer);
  external void deleteShader(WebGLShader? shader);
  external void deleteTexture(WebGLTexture? texture);
  external void depthFunc(GLenum func);
  external void depthMask(GLboolean flag);
  external void depthRange(
    GLclampf zNear,
    GLclampf zFar,
  );
  external void detachShader(
    WebGLProgram program,
    WebGLShader shader,
  );
  external void disable(GLenum cap);
  external void disableVertexAttribArray(GLuint index);
  external void drawArrays(
    GLenum mode,
    GLint first,
    GLsizei count,
  );
  external void drawElements(
    GLenum mode,
    GLsizei count,
    GLenum type,
    GLintptr offset,
  );
  external void enable(GLenum cap);
  external void enableVertexAttribArray(GLuint index);
  external void finish();
  external void flush();
  external void framebufferRenderbuffer(
    GLenum target,
    GLenum attachment,
    GLenum renderbuffertarget,
    WebGLRenderbuffer? renderbuffer,
  );
  external void framebufferTexture2D(
    GLenum target,
    GLenum attachment,
    GLenum textarget,
    WebGLTexture? texture,
    GLint level,
  );
  external void frontFace(GLenum mode);
  external void generateMipmap(GLenum target);
  external WebGLActiveInfo? getActiveAttrib(
    WebGLProgram program,
    GLuint index,
  );
  external WebGLActiveInfo? getActiveUniform(
    WebGLProgram program,
    GLuint index,
  );
  external JSArray<WebGLShader>? getAttachedShaders(WebGLProgram program);
  external GLint getAttribLocation(
    WebGLProgram program,
    String name,
  );
  external JSAny? getBufferParameter(
    GLenum target,
    GLenum pname,
  );
  external JSAny? getParameter(GLenum pname);
  external GLenum getError();
  external JSAny? getFramebufferAttachmentParameter(
    GLenum target,
    GLenum attachment,
    GLenum pname,
  );
  external JSAny? getProgramParameter(
    WebGLProgram program,
    GLenum pname,
  );
  external String? getProgramInfoLog(WebGLProgram program);
  external JSAny? getRenderbufferParameter(
    GLenum target,
    GLenum pname,
  );
  external JSAny? getShaderParameter(
    WebGLShader shader,
    GLenum pname,
  );
  external WebGLShaderPrecisionFormat? getShaderPrecisionFormat(
    GLenum shadertype,
    GLenum precisiontype,
  );
  external String? getShaderInfoLog(WebGLShader shader);
  external String? getShaderSource(WebGLShader shader);
  external JSAny? getTexParameter(
    GLenum target,
    GLenum pname,
  );
  external JSAny? getUniform(
    WebGLProgram program,
    WebGLUniformLocation location,
  );
  external WebGLUniformLocation? getUniformLocation(
    WebGLProgram program,
    String name,
  );
  external JSAny? getVertexAttrib(
    GLuint index,
    GLenum pname,
  );
  external GLintptr getVertexAttribOffset(
    GLuint index,
    GLenum pname,
  );
  external void hint(
    GLenum target,
    GLenum mode,
  );
  external GLboolean isBuffer(WebGLBuffer? buffer);
  external GLboolean isEnabled(GLenum cap);
  external GLboolean isFramebuffer(WebGLFramebuffer? framebuffer);
  external GLboolean isProgram(WebGLProgram? program);
  external GLboolean isRenderbuffer(WebGLRenderbuffer? renderbuffer);
  external GLboolean isShader(WebGLShader? shader);
  external GLboolean isTexture(WebGLTexture? texture);
  external void lineWidth(GLfloat width);
  external void linkProgram(WebGLProgram program);
  external void pixelStorei(
    GLenum pname,
    GLint param,
  );
  external void polygonOffset(
    GLfloat factor,
    GLfloat units,
  );
  external void renderbufferStorage(
    GLenum target,
    GLenum internalformat,
    GLsizei width,
    GLsizei height,
  );
  external void sampleCoverage(
    GLclampf value,
    GLboolean invert,
  );
  external void scissor(
    GLint x,
    GLint y,
    GLsizei width,
    GLsizei height,
  );
  external void shaderSource(
    WebGLShader shader,
    String source,
  );
  external void stencilFunc(
    GLenum func,
    GLint ref,
    GLuint mask,
  );
  external void stencilFuncSeparate(
    GLenum face,
    GLenum func,
    GLint ref,
    GLuint mask,
  );
  external void stencilMask(GLuint mask);
  external void stencilMaskSeparate(
    GLenum face,
    GLuint mask,
  );
  external void stencilOp(
    GLenum fail,
    GLenum zfail,
    GLenum zpass,
  );
  external void stencilOpSeparate(
    GLenum face,
    GLenum fail,
    GLenum zfail,
    GLenum zpass,
  );
  external void texParameterf(
    GLenum target,
    GLenum pname,
    GLfloat param,
  );
  external void texParameteri(
    GLenum target,
    GLenum pname,
    GLint param,
  );
  external void uniform1f(
    WebGLUniformLocation? location,
    GLfloat x,
  );
  external void uniform2f(
    WebGLUniformLocation? location,
    GLfloat x,
    GLfloat y,
  );
  external void uniform3f(
    WebGLUniformLocation? location,
    GLfloat x,
    GLfloat y,
    GLfloat z,
  );
  external void uniform4f(
    WebGLUniformLocation? location,
    GLfloat x,
    GLfloat y,
    GLfloat z,
    GLfloat w,
  );
  external void uniform1i(
    WebGLUniformLocation? location,
    GLint x,
  );
  external void uniform2i(
    WebGLUniformLocation? location,
    GLint x,
    GLint y,
  );
  external void uniform3i(
    WebGLUniformLocation? location,
    GLint x,
    GLint y,
    GLint z,
  );
  external void uniform4i(
    WebGLUniformLocation? location,
    GLint x,
    GLint y,
    GLint z,
    GLint w,
  );
  external void useProgram(WebGLProgram? program);
  external void validateProgram(WebGLProgram program);
  external void vertexAttrib1f(
    GLuint index,
    GLfloat x,
  );
  external void vertexAttrib2f(
    GLuint index,
    GLfloat x,
    GLfloat y,
  );
  external void vertexAttrib3f(
    GLuint index,
    GLfloat x,
    GLfloat y,
    GLfloat z,
  );
  external void vertexAttrib4f(
    GLuint index,
    GLfloat x,
    GLfloat y,
    GLfloat z,
    GLfloat w,
  );
  external void vertexAttrib1fv(
    GLuint index,
    Float32List values,
  );
  external void vertexAttrib2fv(
    GLuint index,
    Float32List values,
  );
  external void vertexAttrib3fv(
    GLuint index,
    Float32List values,
  );
  external void vertexAttrib4fv(
    GLuint index,
    Float32List values,
  );
  external void vertexAttribPointer(
    GLuint index,
    GLint size,
    GLenum type,
    GLboolean normalized,
    GLsizei stride,
    GLintptr offset,
  );
  external void viewport(
    GLint x,
    GLint y,
    GLsizei width,
    GLsizei height,
  );
  external JSPromise<JSAny?> makeXRCompatible();

  /// The **`WebGL2RenderingContext.copyBufferSubData()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// copies part of the data of a
  /// buffer to another buffer.
  external void copyBufferSubData(
    GLenum readTarget,
    GLenum writeTarget,
    GLintptr readOffset,
    GLintptr writeOffset,
    GLsizeiptr size,
  );

  /// The **`WebGL2RenderingContext.getBufferSubData()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// reads data from a buffer
  /// binding point and writes them to an `ArrayBuffer` or
  /// `SharedArrayBuffer`.
  external void getBufferSubData(
    GLenum target,
    GLintptr srcByteOffset,
    ArrayBufferView dstBuffer, [
    int dstOffset,
    GLuint length,
  ]);

  /// The **`WebGL2RenderingContext.blitFramebuffer()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// transfers a block of pixels
  /// from the read framebuffer to the draw framebuffer. Read and draw
  /// framebuffers are bound
  /// using [WebGLRenderingContext.bindFramebuffer].
  external void blitFramebuffer(
    GLint srcX0,
    GLint srcY0,
    GLint srcX1,
    GLint srcY1,
    GLint dstX0,
    GLint dstY0,
    GLint dstX1,
    GLint dstY1,
    GLbitfield mask,
    GLenum filter,
  );

  /// The **`WebGL2RenderingContext.framebufferTextureLayer()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// attaches a single
  /// layer of a texture to a framebuffer.
  ///
  /// This method is similar to [WebGLRenderingContext.framebufferTexture2D],
  /// but only a given single layer of the texture level is attached to the
  /// attachment point.
  external void framebufferTextureLayer(
    GLenum target,
    GLenum attachment,
    WebGLTexture? texture,
    GLint level,
    GLint layer,
  );

  /// The **`WebGL2RenderingContext.invalidateFramebuffer()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// invalidates the contents
  /// of attachments in a framebuffer.
  external void invalidateFramebuffer(
    GLenum target,
    JSArray<JSNumber> attachments,
  );

  /// The **`WebGL2RenderingContext.invalidateSubFramebuffer()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// invalidates
  /// portions of the contents of attachments in a framebuffer.
  external void invalidateSubFramebuffer(
    GLenum target,
    JSArray<JSNumber> attachments,
    GLint x,
    GLint y,
    GLsizei width,
    GLsizei height,
  );

  /// The **`WebGL2RenderingContext.readBuffer()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// selects a color buffer as the
  /// source for pixels for subsequent calls to
  /// [WebGLRenderingContext.copyTexImage2D],
  /// [WebGLRenderingContext.copyTexSubImage2D],
  /// [WebGL2RenderingContext.copyTexSubImage3D] or
  /// [WebGLRenderingContext.readPixels].
  external void readBuffer(GLenum src);

  /// The **`WebGL2RenderingContext.getInternalformatParameter()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns
  /// information about implementation-dependent support for internal formats.
  external JSAny? getInternalformatParameter(
    GLenum target,
    GLenum internalformat,
    GLenum pname,
  );

  /// The
  /// **`WebGL2RenderingContext.renderbufferStorageMultisample()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns creates
  /// and initializes a renderbuffer object's data store and allows specifying a
  /// number of
  /// samples to be used.
  external void renderbufferStorageMultisample(
    GLenum target,
    GLsizei samples,
    GLenum internalformat,
    GLsizei width,
    GLsizei height,
  );

  /// The **`WebGL2RenderingContext.texStorage2D()`** method of the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// specifies all levels of
  /// two-dimensional texture storage.
  external void texStorage2D(
    GLenum target,
    GLsizei levels,
    GLenum internalformat,
    GLsizei width,
    GLsizei height,
  );

  /// The **`WebGL2RenderingContext.texStorage3D()`** method of the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// specifies all levels of a
  /// three-dimensional texture or two-dimensional array texture.
  external void texStorage3D(
    GLenum target,
    GLsizei levels,
    GLenum internalformat,
    GLsizei width,
    GLsizei height,
    GLsizei depth,
  );

  /// The **`WebGLRenderingContext.texImage3D()`** method of the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// specifies a three-dimensional
  /// texture image.
  external void texImage3D(
    GLenum target,
    GLint level,
    GLint internalformat,
    GLsizei width,
    GLsizei height,
    GLsizei depth,
    GLint border,
    GLenum format,
    GLenum type,
    JSAny? pboOffsetOrSourceOrSrcData, [
    int srcOffset,
  ]);

  /// The **`WebGL2RenderingContext.texSubImage3D()`** method of the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// specifies a sub-rectangle of the
  /// current texture.
  external void texSubImage3D(
    GLenum target,
    GLint level,
    GLint xoffset,
    GLint yoffset,
    GLint zoffset,
    GLsizei width,
    GLsizei height,
    GLsizei depth,
    GLenum format,
    GLenum type,
    JSAny? pboOffsetOrSourceOrSrcData, [
    int srcOffset,
  ]);

  /// The **`WebGL2RenderingContext.copyTexSubImage3D()`** method of
  /// the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// copies pixels from the current
  /// [WebGLFramebuffer] into an existing 3D texture sub-image.
  external void copyTexSubImage3D(
    GLenum target,
    GLint level,
    GLint xoffset,
    GLint yoffset,
    GLint zoffset,
    GLint x,
    GLint y,
    GLsizei width,
    GLsizei height,
  );
  external void compressedTexImage3D(
    GLenum target,
    GLint level,
    GLenum internalformat,
    GLsizei width,
    GLsizei height,
    GLsizei depth,
    GLint border,
    JSAny imageSizeOrSrcData, [
    JSAny offsetOrSrcOffset,
    GLuint srcLengthOverride,
  ]);

  /// The **`WebGL2RenderingContext.compressedTexSubImage3D()`**
  /// method of the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// specifies a
  /// three-dimensional sub-rectangle for a texture image in a compressed
  /// format.
  external void compressedTexSubImage3D(
    GLenum target,
    GLint level,
    GLint xoffset,
    GLint yoffset,
    GLint zoffset,
    GLsizei width,
    GLsizei height,
    GLsizei depth,
    GLenum format,
    JSAny imageSizeOrSrcData, [
    JSAny offsetOrSrcOffset,
    GLuint srcLengthOverride,
  ]);

  /// The **`WebGL2RenderingContext.getFragDataLocation()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns the binding of
  /// color numbers to user-defined varying out variables.
  external GLint getFragDataLocation(
    WebGLProgram program,
    String name,
  );
  external void uniform1ui(
    WebGLUniformLocation? location,
    GLuint v0,
  );
  external void uniform2ui(
    WebGLUniformLocation? location,
    GLuint v0,
    GLuint v1,
  );
  external void uniform3ui(
    WebGLUniformLocation? location,
    GLuint v0,
    GLuint v1,
    GLuint v2,
  );
  external void uniform4ui(
    WebGLUniformLocation? location,
    GLuint v0,
    GLuint v1,
    GLuint v2,
    GLuint v3,
  );
  external void uniform1uiv(
    WebGLUniformLocation? location,
    Uint32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform2uiv(
    WebGLUniformLocation? location,
    Uint32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform3uiv(
    WebGLUniformLocation? location,
    Uint32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform4uiv(
    WebGLUniformLocation? location,
    Uint32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix3x2fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix4x2fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix2x3fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix4x3fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix2x4fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix3x4fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void vertexAttribI4i(
    GLuint index,
    GLint x,
    GLint y,
    GLint z,
    GLint w,
  );
  external void vertexAttribI4iv(
    GLuint index,
    Int32List values,
  );
  external void vertexAttribI4ui(
    GLuint index,
    GLuint x,
    GLuint y,
    GLuint z,
    GLuint w,
  );
  external void vertexAttribI4uiv(
    GLuint index,
    Uint32List values,
  );

  /// The **`WebGL2RenderingContext.vertexAttribIPointer()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// specifies integer data
  /// formats and locations of vertex attributes in a vertex attributes array.
  external void vertexAttribIPointer(
    GLuint index,
    GLint size,
    GLenum type,
    GLsizei stride,
    GLintptr offset,
  );

  /// The **`WebGL2RenderingContext.vertexAttribDivisor()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// modifies the rate at
  /// which generic vertex attributes advance when rendering multiple instances
  /// of primitives
  /// with [WebGL2RenderingContext.drawArraysInstanced] and
  /// [WebGL2RenderingContext.drawElementsInstanced].
  ///
  /// > **Note:** When using [WebGLRenderingContext], the
  /// > [ANGLE_instanced_arrays] extension can provide this method,
  /// > too.
  external void vertexAttribDivisor(
    GLuint index,
    GLuint divisor,
  );

  /// The **`WebGL2RenderingContext.drawArraysInstanced()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// renders primitives from
  /// array data like the [WebGLRenderingContext.drawArrays]
  /// method. In addition, it can execute multiple instances of the range of
  /// elements.
  ///
  /// > **Note:** When using [WebGLRenderingContext],
  /// > the [ANGLE_instanced_arrays] extension can provide this method,
  /// > too.
  external void drawArraysInstanced(
    GLenum mode,
    GLint first,
    GLsizei count,
    GLsizei instanceCount,
  );

  /// The **`WebGL2RenderingContext.drawElementsInstanced()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// renders primitives from
  /// array data like the [WebGLRenderingContext.drawElements] method. In
  /// addition, it can execute multiple instances of a set
  /// of elements.
  ///
  /// > **Note:** When using [WebGLRenderingContext], the
  /// > [ANGLE_instanced_arrays] extension can provide this method,
  /// > too.
  external void drawElementsInstanced(
    GLenum mode,
    GLsizei count,
    GLenum type,
    GLintptr offset,
    GLsizei instanceCount,
  );

  /// The **`WebGL2RenderingContext.drawRangeElements()`** method of
  /// the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// renders primitives from array
  /// data in a given range.
  external void drawRangeElements(
    GLenum mode,
    GLuint start,
    GLuint end,
    GLsizei count,
    GLenum type,
    GLintptr offset,
  );

  /// The **`WebGL2RenderingContext.drawBuffers()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// defines draw buffers to which
  /// fragment colors are written into. The draw buffer settings are part of the
  /// state of the
  /// currently bound framebuffer or the drawingbuffer if no framebuffer is
  /// bound.
  external void drawBuffers(JSArray<JSNumber> buffers);
  external void clearBufferfv(
    GLenum buffer,
    GLint drawbuffer,
    Float32List values, [
    int srcOffset,
  ]);
  external void clearBufferiv(
    GLenum buffer,
    GLint drawbuffer,
    Int32List values, [
    int srcOffset,
  ]);
  external void clearBufferuiv(
    GLenum buffer,
    GLint drawbuffer,
    Uint32List values, [
    int srcOffset,
  ]);
  external void clearBufferfi(
    GLenum buffer,
    GLint drawbuffer,
    GLfloat depth,
    GLint stencil,
  );

  /// The **`WebGL2RenderingContext.createQuery()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// creates and initializes
  /// [WebGLQuery] objects, which provide ways to asynchronously query for
  /// information.
  external WebGLQuery? createQuery();

  /// The **`WebGL2RenderingContext.deleteQuery()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// deletes a given
  /// [WebGLQuery] object.
  external void deleteQuery(WebGLQuery? query);

  /// The **`WebGL2RenderingContext.isQuery()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns `true` if the
  /// passed object is a valid [WebGLQuery] object.
  external GLboolean isQuery(WebGLQuery? query);

  /// The **`WebGL2RenderingContext.beginQuery()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// starts an asynchronous query. The
  /// `target` parameter indicates which kind of query to begin.
  external void beginQuery(
    GLenum target,
    WebGLQuery query,
  );

  /// The **`WebGL2RenderingContext.endQuery()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// marks the end of a given query
  /// target.
  external void endQuery(GLenum target);

  /// The **`WebGL2RenderingContext.getQuery()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns the currently active
  /// [WebGLQuery] for the `target`, or
  /// [`null`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/null).
  external WebGLQuery? getQuery(
    GLenum target,
    GLenum pname,
  );

  /// The **`WebGL2RenderingContext.getQueryParameter()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns parameter
  /// information of a [WebGLQuery] object.
  external JSAny? getQueryParameter(
    WebGLQuery query,
    GLenum pname,
  );

  /// The **`WebGL2RenderingContext.createSampler()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// creates and initializes
  /// [WebGLSampler] objects.
  external WebGLSampler? createSampler();

  /// The **`WebGL2RenderingContext.deleteSampler()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// deletes a given
  /// [WebGLSampler] object.
  external void deleteSampler(WebGLSampler? sampler);

  /// The **`WebGL2RenderingContext.isSampler()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns `true` if the
  /// passed object is a valid [WebGLSampler] object.
  external GLboolean isSampler(WebGLSampler? sampler);

  /// The **`WebGL2RenderingContext.bindSampler()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// binds a
  /// passed [WebGLSampler] object to the texture unit at the passed index.
  external void bindSampler(
    GLuint unit,
    WebGLSampler? sampler,
  );
  external void samplerParameteri(
    WebGLSampler sampler,
    GLenum pname,
    GLint param,
  );
  external void samplerParameterf(
    WebGLSampler sampler,
    GLenum pname,
    GLfloat param,
  );

  /// The **`WebGL2RenderingContext.getSamplerParameter()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns parameter
  /// information of a [WebGLSampler] object.
  external JSAny? getSamplerParameter(
    WebGLSampler sampler,
    GLenum pname,
  );

  /// The **`WebGL2RenderingContext.fenceSync()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// creates a new
  /// [WebGLSync] object and inserts it into the GL command stream.
  external WebGLSync? fenceSync(
    GLenum condition,
    GLbitfield flags,
  );

  /// The **`WebGL2RenderingContext.isSync()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns `true` if the
  /// passed object is a valid [WebGLSync] object.
  external GLboolean isSync(WebGLSync? sync);

  /// The **`WebGL2RenderingContext.deleteSync()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// deletes a given
  /// [WebGLSync] object.
  external void deleteSync(WebGLSync? sync);

  /// The **`WebGL2RenderingContext.clientWaitSync()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// blocks and waits for a
  /// [WebGLSync] object to become signaled or a given timeout to be passed.
  external GLenum clientWaitSync(
    WebGLSync sync,
    GLbitfield flags,
    GLuint64 timeout,
  );

  /// The **`WebGL2RenderingContext.waitSync()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns immediately, but waits on
  /// the GL server until the given [WebGLSync] object is signaled.
  ///
  /// The method is a no-op in the absence of the possibility of synchronizing
  /// between
  /// multiple GL contexts.
  external void waitSync(
    WebGLSync sync,
    GLbitfield flags,
    GLint64 timeout,
  );

  /// The **`WebGL2RenderingContext.getSyncParameter()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns parameter
  /// information of a [WebGLSync] object.
  external JSAny? getSyncParameter(
    WebGLSync sync,
    GLenum pname,
  );

  /// The **`WebGL2RenderingContext.createTransformFeedback()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// creates and
  /// initializes [WebGLTransformFeedback] objects.
  external WebGLTransformFeedback? createTransformFeedback();

  /// The **`WebGL2RenderingContext.deleteTransformFeedback()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// deletes a given
  /// [WebGLTransformFeedback] object.
  external void deleteTransformFeedback(WebGLTransformFeedback? tf);

  /// The **`WebGL2RenderingContext.isTransformFeedback()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns `true`
  /// if the passed object is a valid [WebGLTransformFeedback] object.
  external GLboolean isTransformFeedback(WebGLTransformFeedback? tf);

  /// The **`WebGL2RenderingContext.bindTransformFeedback()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// binds a
  /// passed [WebGLTransformFeedback] object to the current GL state.
  external void bindTransformFeedback(
    GLenum target,
    WebGLTransformFeedback? tf,
  );

  /// The **`WebGL2RenderingContext.beginTransformFeedback()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// starts a transform
  /// feedback operation.
  external void beginTransformFeedback(GLenum primitiveMode);

  /// The **`WebGL2RenderingContext.endTransformFeedback()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// ends a transform feedback
  /// operation.
  external void endTransformFeedback();

  /// The **`WebGL2RenderingContext.transformFeedbackVaryings()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// specifies values
  /// to record in [WebGLTransformFeedback] buffers.
  external void transformFeedbackVaryings(
    WebGLProgram program,
    JSArray<JSString> varyings,
    GLenum bufferMode,
  );

  /// The **`WebGL2RenderingContext.getTransformFeedbackVarying()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns
  /// information about varying variables from [WebGLTransformFeedback] buffers.
  external WebGLActiveInfo? getTransformFeedbackVarying(
    WebGLProgram program,
    GLuint index,
  );

  /// The **`WebGL2RenderingContext.pauseTransformFeedback()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// pauses a transform
  /// feedback operation.
  external void pauseTransformFeedback();

  /// The **`WebGL2RenderingContext.resumeTransformFeedback()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// resumes a
  /// transform feedback operation.
  external void resumeTransformFeedback();

  /// The **`WebGL2RenderingContext.bindBufferBase()`** method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// binds a given
  /// [WebGLBuffer] to a given binding point (`target`) at a given
  /// `index`.
  external void bindBufferBase(
    GLenum target,
    GLuint index,
    WebGLBuffer? buffer,
  );

  /// The **`WebGL2RenderingContext.bindBufferRange()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// binds a range of a given
  /// [WebGLBuffer] to a given binding point (`target`) at a given
  /// `index`.
  external void bindBufferRange(
    GLenum target,
    GLuint index,
    WebGLBuffer? buffer,
    GLintptr offset,
    GLsizeiptr size,
  );

  /// The **`WebGL2RenderingContext.getIndexedParameter()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns indexed
  /// information about a given `target`.
  external JSAny? getIndexedParameter(
    GLenum target,
    GLuint index,
  );

  /// The **`WebGL2RenderingContext.getUniformIndices()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// retrieves the indices of a
  /// number of uniforms within a [WebGLProgram].
  external JSArray<JSNumber>? getUniformIndices(
    WebGLProgram program,
    JSArray<JSString> uniformNames,
  );

  /// The **`WebGL2RenderingContext.getActiveUniforms()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// retrieves information about
  /// active uniforms within a [WebGLProgram].
  external JSAny? getActiveUniforms(
    WebGLProgram program,
    JSArray<JSNumber> uniformIndices,
    GLenum pname,
  );

  /// The **`WebGL2RenderingContext.getUniformBlockIndex()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// retrieves the index of
  /// a uniform block within a [WebGLProgram].
  external GLuint getUniformBlockIndex(
    WebGLProgram program,
    String uniformBlockName,
  );

  /// The
  /// **`WebGL2RenderingContext.getActiveUniformBlockParameter()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// retrieves
  /// information about an active uniform block within a [WebGLProgram].
  external JSAny? getActiveUniformBlockParameter(
    WebGLProgram program,
    GLuint uniformBlockIndex,
    GLenum pname,
  );

  /// The **`WebGL2RenderingContext.getActiveUniformBlockName()`**
  /// method of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// retrieves the name
  /// of the active uniform block at a given index within a [WebGLProgram].
  external String? getActiveUniformBlockName(
    WebGLProgram program,
    GLuint uniformBlockIndex,
  );

  /// The **`WebGL2RenderingContext.uniformBlockBinding()`** method
  /// of the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// assigns binding points
  /// for active uniform blocks.
  external void uniformBlockBinding(
    WebGLProgram program,
    GLuint uniformBlockIndex,
    GLuint uniformBlockBinding,
  );

  /// The **`WebGL2RenderingContext.createVertexArray()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// creates and initializes a
  /// [WebGLVertexArrayObject] object that represents a vertex array object
  /// (VAO)
  /// pointing to vertex array data and which provides names for different sets
  /// of vertex
  /// data.
  external WebGLVertexArrayObject? createVertexArray();

  /// The **`WebGL2RenderingContext.deleteVertexArray()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// deletes a given
  /// [WebGLVertexArrayObject] object.
  external void deleteVertexArray(WebGLVertexArrayObject? vertexArray);

  /// The **`WebGL2RenderingContext.isVertexArray()`** method of the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// returns `true` if the
  /// passed object is a valid [WebGLVertexArrayObject] object.
  external GLboolean isVertexArray(WebGLVertexArrayObject? vertexArray);

  /// The **`WebGL2RenderingContext.bindVertexArray()`** method of
  /// the
  /// [WebGL 2 API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// binds a
  /// passed [WebGLVertexArrayObject] object to the buffer.
  external void bindVertexArray(WebGLVertexArrayObject? array);

  /// The **`WebGL2RenderingContext.bufferData()`** method of the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// creates and initializes the buffer object's data store.
  external void bufferData(
    GLenum target,
    JSAny? sizeOrSrcData,
    GLenum usage, [
    int srcOffset,
    GLuint length,
  ]);

  /// The **`WebGL2RenderingContext.bufferSubData()`** method of the
  /// [WebGL API](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API)
  /// updates a subset of a buffer
  /// object's data store.
  external void bufferSubData(
    GLenum target,
    GLintptr dstByteOffset,
    JSObject srcData, [
    int srcOffset,
    GLuint length,
  ]);
  external void texImage2D(
    GLenum target,
    GLint level,
    GLint internalformat,
    JSAny formatOrWidth,
    JSAny heightOrType,
    JSAny borderOrSource, [
    GLenum format,
    GLenum type,
    JSAny? pboOffsetOrPixelsOrSourceOrSrcData,
    int srcOffset,
  ]);
  external void texSubImage2D(
    GLenum target,
    GLint level,
    GLint xoffset,
    GLint yoffset,
    JSAny formatOrWidth,
    JSAny heightOrType,
    JSAny formatOrSource, [
    GLenum type,
    JSAny? pboOffsetOrPixelsOrSourceOrSrcData,
    int srcOffset,
  ]);
  external void compressedTexImage2D(
    GLenum target,
    GLint level,
    GLenum internalformat,
    GLsizei width,
    GLsizei height,
    GLint border,
    JSAny imageSizeOrSrcData, [
    JSAny offsetOrSrcOffset,
    GLuint srcLengthOverride,
  ]);
  external void compressedTexSubImage2D(
    GLenum target,
    GLint level,
    GLint xoffset,
    GLint yoffset,
    GLsizei width,
    GLsizei height,
    GLenum format,
    JSAny imageSizeOrSrcData, [
    JSAny offsetOrSrcOffset,
    GLuint srcLengthOverride,
  ]);
  external void uniform1fv(
    WebGLUniformLocation? location,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform2fv(
    WebGLUniformLocation? location,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform3fv(
    WebGLUniformLocation? location,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform4fv(
    WebGLUniformLocation? location,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform1iv(
    WebGLUniformLocation? location,
    Int32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform2iv(
    WebGLUniformLocation? location,
    Int32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform3iv(
    WebGLUniformLocation? location,
    Int32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniform4iv(
    WebGLUniformLocation? location,
    Int32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix2fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix3fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void uniformMatrix4fv(
    WebGLUniformLocation? location,
    GLboolean transpose,
    Float32List data, [
    int srcOffset,
    GLuint srcLength,
  ]);
  external void readPixels(
    GLint x,
    GLint y,
    GLsizei width,
    GLsizei height,
    GLenum format,
    GLenum type,
    JSAny? dstDataOrOffset, [
    int dstOffset,
  ]);
  external JSObject get canvas;
  external GLsizei get drawingBufferWidth;
  external GLsizei get drawingBufferHeight;
  external PredefinedColorSpace get drawingBufferColorSpace;
  external set drawingBufferColorSpace(PredefinedColorSpace value);
}
