// /*
//  * Copyright 2025 Toyota Connected North America
//  *
//  * Licensed under the Apache License, Version 2.0 (the "License");
//  * you may not use this file except in compliance with the License.
//  * You may obtain a copy of the License at
//  *
//  *      http://www.apache.org/licenses/LICENSE-2.0
//  *
//  * Unless required by applicable law or agreed to in writing, software
//  * distributed under the License is distributed on an "AS IS" BASIS,
//  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  * See the License for the specific language governing permissions and
//  * limitations under the License.
//  */
// Autogenerated from Pigeon (v22.7.4), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.g.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>

namespace plugin_filament_view {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

FlutterError CreateConnectionError(const std::string& channel_name) {
  return FlutterError(
    "channel-error", "Unable to establish connection on channel: '" + channel_name + "'.",
    EncodableValue("")
  );
}

PigeonInternalCodecSerializer::PigeonInternalCodecSerializer() = default;

EncodableValue PigeonInternalCodecSerializer::ReadValueOfType(
  uint8_t type,
  flutter::ByteStreamReader* stream
) const {
  return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
}

void PigeonInternalCodecSerializer::WriteValue(
  const EncodableValue& value,
  flutter::ByteStreamWriter* stream
) const {
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by FilamentViewApi.
const flutter::StandardMessageCodec& FilamentViewApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(&PigeonInternalCodecSerializer::GetInstance());
}

// Sets up an instance of `FilamentViewApi` to handle messages through the `binary_messenger`.
void FilamentViewApi::SetUp(flutter::BinaryMessenger* binary_messenger, FilamentViewApi* api) {
  FilamentViewApi::SetUp(binary_messenger, api, "");
}

void FilamentViewApi::SetUp(
  flutter::BinaryMessenger* binary_messenger,
  FilamentViewApi* api,
  const std::string& message_channel_suffix
) {
  const std::string prepended_suffix = !message_channel_suffix.empty()
                                         ? std::string(".") + message_channel_suffix
                                         : "";
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.changeMaterialParameter"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_params_arg = args.at(0);
            if (encodable_params_arg.IsNull()) {
              reply(WrapError("params_arg unexpectedly null."));
              return;
            }
            const auto& params_arg = std::get<EncodableMap>(encodable_params_arg);
            const auto& encodable_id_arg = args.at(1);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->ChangeMaterialParameter(params_arg, id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.changeMaterialDefinition"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_params_arg = args.at(0);
            if (encodable_params_arg.IsNull()) {
              reply(WrapError("params_arg unexpectedly null."));
              return;
            }
            const auto& params_arg = std::get<EncodableMap>(encodable_params_arg);
            const auto& encodable_id_arg = args.at(1);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->ChangeMaterialDefinition(params_arg, id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.toggleShapesInScene" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_value_arg = args.at(0);
            if (encodable_value_arg.IsNull()) {
              reply(WrapError("value_arg unexpectedly null."));
              return;
            }
            const auto& value_arg = std::get<bool>(encodable_value_arg);
            std::optional<FlutterError> output = api->ToggleShapesInScene(value_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.changeViewQualitySettings"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler([api](
                                  const EncodableValue& /* message */,
                                  const flutter::MessageReply<EncodableValue>& reply
                                ) {
        try {
          std::optional<FlutterError> output = api->ChangeViewQualitySettings();
          if (output.has_value()) {
            reply(WrapError(output.value()));
            return;
          }
          EncodableList wrapped;
          wrapped.emplace_back();
          reply(EncodableValue(std::move(wrapped)));
        } catch (const std::exception& exception) {
          reply(WrapError(exception.what()));
        }
      });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setFogOptions" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_enable_arg = args.at(0);
            if (encodable_enable_arg.IsNull()) {
              reply(WrapError("enable_arg unexpectedly null."));
              return;
            }
            const auto& enable_arg = std::get<bool>(encodable_enable_arg);
            std::optional<FlutterError> output = api->SetFogOptions(enable_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setCameraOrbit" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_origin_entity_id_arg = args.at(1);
            if (encodable_origin_entity_id_arg.IsNull()) {
              reply(WrapError("origin_entity_id_arg unexpectedly null."));
              return;
            }
            const int64_t origin_entity_id_arg = encodable_origin_entity_id_arg.LongValue();
            const auto& encodable_orbit_rotation_arg = args.at(2);
            if (encodable_orbit_rotation_arg.IsNull()) {
              reply(WrapError("orbit_rotation_arg unexpectedly null."));
              return;
            }
            const auto& orbit_rotation_arg = std::get<std::vector<double>>(
              encodable_orbit_rotation_arg
            );
            std::optional<FlutterError> output = api->SetCameraOrbit(
              id_arg, origin_entity_id_arg, orbit_rotation_arg
            );
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setCameraTarget" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_target_entity_id_arg = args.at(1);
            if (encodable_target_entity_id_arg.IsNull()) {
              reply(WrapError("target_entity_id_arg unexpectedly null."));
              return;
            }
            const int64_t target_entity_id_arg = encodable_target_entity_id_arg.LongValue();
            const auto& encodable_target_position_arg = args.at(2);
            const auto* target_position_arg = std::get_if<std::vector<double>>(
              &encodable_target_position_arg
            );
            std::optional<FlutterError> output = api->SetCameraTarget(
              id_arg, target_entity_id_arg, target_position_arg
            );
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setActiveCamera" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_view_id_arg = args.at(0);
            const auto* view_id_arg = std::get_if<int64_t>(&encodable_view_id_arg);
            const auto& encodable_camera_id_arg = args.at(1);
            if (encodable_camera_id_arg.IsNull()) {
              reply(WrapError("camera_id_arg unexpectedly null."));
              return;
            }
            const int64_t camera_id_arg = encodable_camera_id_arg.LongValue();
            std::optional<FlutterError> output = api->SetActiveCamera(view_id_arg, camera_id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setCameraDolly" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_dolly_offset_arg = args.at(1);
            if (encodable_dolly_offset_arg.IsNull()) {
              reply(WrapError("dolly_offset_arg unexpectedly null."));
              return;
            }
            const auto& dolly_offset_arg = std::get<std::vector<double>>(encodable_dolly_offset_arg
            );
            std::optional<FlutterError> output = api->SetCameraDolly(id_arg, dolly_offset_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.changeLightColorByGUID" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_color_arg = args.at(1);
            if (encodable_color_arg.IsNull()) {
              reply(WrapError("color_arg unexpectedly null."));
              return;
            }

            const auto& color_arg = std::get<std::vector<double>>(encodable_color_arg);
            const auto& encodable_intensity_arg = args.at(2);
            if (encodable_intensity_arg.IsNull()) {
              reply(WrapError("intensity_arg unexpectedly null."));
              return;
            }
            const double intensity_arg = std::get<double>(encodable_intensity_arg);
            std::optional<FlutterError> output = api->ChangeLightColorByGUID(
              id_arg, color_arg, intensity_arg
            );
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.changeLightTransformByGUID"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_posx_arg = args.at(1);
            if (encodable_posx_arg.IsNull()) {
              reply(WrapError("posx_arg unexpectedly null."));
              return;
            }
            const auto& posx_arg = std::get<double>(encodable_posx_arg);
            const auto& encodable_posy_arg = args.at(2);
            if (encodable_posy_arg.IsNull()) {
              reply(WrapError("posy_arg unexpectedly null."));
              return;
            }
            const auto& posy_arg = std::get<double>(encodable_posy_arg);
            const auto& encodable_posz_arg = args.at(3);
            if (encodable_posz_arg.IsNull()) {
              reply(WrapError("posz_arg unexpectedly null."));
              return;
            }
            const auto& posz_arg = std::get<double>(encodable_posz_arg);
            const auto& encodable_dirx_arg = args.at(4);
            if (encodable_dirx_arg.IsNull()) {
              reply(WrapError("dirx_arg unexpectedly null."));
              return;
            }
            const auto& dirx_arg = std::get<double>(encodable_dirx_arg);
            const auto& encodable_diry_arg = args.at(5);
            if (encodable_diry_arg.IsNull()) {
              reply(WrapError("diry_arg unexpectedly null."));
              return;
            }
            const auto& diry_arg = std::get<double>(encodable_diry_arg);
            const auto& encodable_dirz_arg = args.at(6);
            if (encodable_dirz_arg.IsNull()) {
              reply(WrapError("dirz_arg unexpectedly null."));
              return;
            }
            const auto& dirz_arg = std::get<double>(encodable_dirz_arg);
            std::optional<FlutterError> output = api->ChangeLightTransformByGUID(
              id_arg, posx_arg, posy_arg, posz_arg, dirx_arg, diry_arg, dirz_arg
            );
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.enqueueAnimation" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_animation_index_arg = args.at(1);
            if (encodable_animation_index_arg.IsNull()) {
              reply(WrapError("animation_index_arg unexpectedly null."));
              return;
            }
            const int64_t animation_index_arg = encodable_animation_index_arg.LongValue();
            std::optional<FlutterError> output = api->EnqueueAnimation(id_arg, animation_index_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.clearAnimationQueue" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->ClearAnimationQueue(id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.playAnimation" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_animation_index_arg = args.at(1);
            if (encodable_animation_index_arg.IsNull()) {
              reply(WrapError("animation_index_arg unexpectedly null."));
              return;
            }
            const int64_t animation_index_arg = encodable_animation_index_arg.LongValue();
            std::optional<FlutterError> output = api->PlayAnimation(id_arg, animation_index_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.changeAnimationSpeed" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_speed_arg = args.at(1);
            if (encodable_speed_arg.IsNull()) {
              reply(WrapError("speed_arg unexpectedly null."));
              return;
            }
            const auto& speed_arg = std::get<double>(encodable_speed_arg);
            std::optional<FlutterError> output = api->ChangeAnimationSpeed(id_arg, speed_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.pauseAnimation" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->PauseAnimation(id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.resumeAnimation" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->ResumeAnimation(id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setAnimationLooping" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_looping_arg = args.at(1);
            if (encodable_looping_arg.IsNull()) {
              reply(WrapError("looping_arg unexpectedly null."));
              return;
            }
            const auto& looping_arg = std::get<bool>(encodable_looping_arg);
            std::optional<FlutterError> output = api->SetAnimationLooping(id_arg, looping_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.raycastFromTap" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_x_arg = args.at(0);
            if (encodable_x_arg.IsNull()) {
              reply(WrapError("x_arg unexpectedly null."));
              return;
            }
            const auto& x_arg = std::get<double>(encodable_x_arg);
            const auto& encodable_y_arg = args.at(1);
            if (encodable_y_arg.IsNull()) {
              reply(WrapError("y_arg unexpectedly null."));
              return;
            }
            const auto& y_arg = std::get<double>(encodable_y_arg);
            std::optional<FlutterError> output = api->RaycastFromTap(x_arg, y_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.requestCollisionCheckFromRay"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_query_i_d_arg = args.at(0);
            if (encodable_query_i_d_arg.IsNull()) {
              reply(WrapError("query_i_d_arg unexpectedly null."));
              return;
            }
            const auto& query_i_d_arg = std::get<std::string>(encodable_query_i_d_arg);
            const auto& encodable_origin_x_arg = args.at(1);
            if (encodable_origin_x_arg.IsNull()) {
              reply(WrapError("origin_x_arg unexpectedly null."));
              return;
            }
            const auto& origin_x_arg = std::get<double>(encodable_origin_x_arg);
            const auto& encodable_origin_y_arg = args.at(2);
            if (encodable_origin_y_arg.IsNull()) {
              reply(WrapError("origin_y_arg unexpectedly null."));
              return;
            }
            const auto& origin_y_arg = std::get<double>(encodable_origin_y_arg);
            const auto& encodable_origin_z_arg = args.at(3);
            if (encodable_origin_z_arg.IsNull()) {
              reply(WrapError("origin_z_arg unexpectedly null."));
              return;
            }
            const auto& origin_z_arg = std::get<double>(encodable_origin_z_arg);
            const auto& encodable_direction_x_arg = args.at(4);
            if (encodable_direction_x_arg.IsNull()) {
              reply(WrapError("direction_x_arg unexpectedly null."));
              return;
            }
            const auto& direction_x_arg = std::get<double>(encodable_direction_x_arg);
            const auto& encodable_direction_y_arg = args.at(5);
            if (encodable_direction_y_arg.IsNull()) {
              reply(WrapError("direction_y_arg unexpectedly null."));
              return;
            }
            const auto& direction_y_arg = std::get<double>(encodable_direction_y_arg);
            const auto& encodable_direction_z_arg = args.at(6);
            if (encodable_direction_z_arg.IsNull()) {
              reply(WrapError("direction_z_arg unexpectedly null."));
              return;
            }
            const auto& direction_z_arg = std::get<double>(encodable_direction_z_arg);
            const auto& encodable_length_arg = args.at(7);
            if (encodable_length_arg.IsNull()) {
              reply(WrapError("length_arg unexpectedly null."));
              return;
            }
            const auto& length_arg = std::get<double>(encodable_length_arg);
            std::optional<FlutterError> output = api->RequestCollisionCheckFromRay(
              query_i_d_arg, origin_x_arg, origin_y_arg, origin_z_arg, direction_x_arg,
              direction_y_arg, direction_z_arg, length_arg
            );
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.turnOffCollisionChecksForEntity"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->TurnOffCollisionChecksForEntity(id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.turnOnCollisionChecksForEntity"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->TurnOnCollisionChecksForEntity(id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.toggleDebugCollidableViewsInScene"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_value_arg = args.at(0);
            if (encodable_value_arg.IsNull()) {
              reply(WrapError("value_arg unexpectedly null."));
              return;
            }
            const auto& value_arg = std::get<bool>(encodable_value_arg);
            std::optional<FlutterError> output = api->ToggleDebugCollidableViewsInScene(value_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setEntityTransformScale"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_scl_arg = args.at(1);
            if (encodable_scl_arg.IsNull()) {
              reply(WrapError("scl_arg unexpectedly null."));
              return;
            }
            const auto& scl_arg = std::get<std::vector<double>>(encodable_scl_arg);
            std::optional<FlutterError> output = api->SetEntityTransformScale(id_arg, scl_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setEntityTransformPosition"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_pos_arg = args.at(1);
            if (encodable_pos_arg.IsNull()) {
              reply(WrapError("pos_arg unexpectedly null."));
              return;
            }
            const auto& pos_arg = std::get<std::vector<double>>(encodable_pos_arg);
            std::optional<FlutterError> output = api->SetEntityTransformPosition(id_arg, pos_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.setEntityTransformRotation"
        + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            const auto& encodable_rot_arg = args.at(1);
            if (encodable_rot_arg.IsNull()) {
              reply(WrapError("rot_arg unexpectedly null."));
              return;
            }
            const auto& rot_arg = std::get<std::vector<double>>(encodable_rot_arg);
            std::optional<FlutterError> output = api->SetEntityTransformRotation(id_arg, rot_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.turnOffVisualForEntity" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->TurnOffVisualForEntity(id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
      binary_messenger,
      "dev.flutter.pigeon.filament_scene.FilamentViewApi.turnOnVisualForEntity" + prepended_suffix,
      &GetCodec()
    );
    if (api != nullptr) {
      channel.SetMessageHandler(
        [api](const EncodableValue& message, const flutter::MessageReply<EncodableValue>& reply) {
          try {
            const auto& args = std::get<EncodableList>(message);
            const auto& encodable_id_arg = args.at(0);
            if (encodable_id_arg.IsNull()) {
              reply(WrapError("id_arg unexpectedly null."));
              return;
            }
            const int64_t id_arg = encodable_id_arg.LongValue();
            std::optional<FlutterError> output = api->TurnOnVisualForEntity(id_arg);
            if (output.has_value()) {
              reply(WrapError(output.value()));
              return;
            }
            EncodableList wrapped;
            wrapped.emplace_back();
            reply(EncodableValue(std::move(wrapped)));
          } catch (const std::exception& exception) {
            reply(WrapError(exception.what()));
          }
        }
      );
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
}

EncodableValue FilamentViewApi::WrapError(std::string_view error_message) {
  return EncodableValue(EncodableList{
    EncodableValue(std::string(error_message)), EncodableValue("Error"), EncodableValue()
  });
}

EncodableValue FilamentViewApi::WrapError(const FlutterError& error) {
  return EncodableValue(
    EncodableList{EncodableValue(error.code()), EncodableValue(error.message()), error.details()}
  );
}

}  // namespace plugin_filament_view
