// ignore_for_file: camel_case_types, non_constant_identifier_names

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;

/// Bindings to SQLite.
class SQLite {
  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
      _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  SQLite(ffi.DynamicLibrary dynamicLibrary) : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  SQLite.fromLookup(
      ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
          lookup)
      : _lookup = lookup;

  /// CAPI3REF: Run-Time Library Version Numbers
  /// KEYWORDS: sqlite3_version sqlite3_sourceid
  ///
  /// These interfaces provide the same information as the [SQLITE_VERSION],
  /// [SQLITE_VERSION_NUMBER], and [SQLITE_SOURCE_ID] C preprocessor macros
  /// but are associated with the library instead of the header file.  ^(Cautious
  /// programmers might include assert() statements in their application to
  /// verify that values returned by these interfaces match the macros in
  /// the header, and thus ensure that the application is
  /// compiled with matching library and header files.
  ///
  /// <blockquote><pre>
  /// assert( sqlite3_libversion_number()==SQLITE_VERSION_NUMBER );
  /// assert( strncmp(sqlite3_sourceid(),SQLITE_SOURCE_ID,80)==0 );
  /// assert( strcmp(sqlite3_libversion(),SQLITE_VERSION)==0 );
  /// </pre></blockquote>)^
  ///
  /// ^The sqlite3_version[] string constant contains the text of [SQLITE_VERSION]
  /// macro.  ^The sqlite3_libversion() function returns a pointer to the
  /// to the sqlite3_version[] string constant.  The sqlite3_libversion()
  /// function is provided for use in DLLs since DLL users usually do not have
  /// direct access to string constants within the DLL.  ^The
  /// sqlite3_libversion_number() function returns an integer equal to
  /// [SQLITE_VERSION_NUMBER].  ^(The sqlite3_sourceid() function returns
  /// a pointer to a string constant whose value is the same as the
  /// [SQLITE_SOURCE_ID] C preprocessor macro.  Except if SQLite is built
  /// using an edited copy of [the amalgamation], then the last four characters
  /// of the hash might be different from [SQLITE_SOURCE_ID].)^
  ///
  /// See also: [sqlite_version()] and [sqlite_source_id()].
  late final ffi.Pointer<ffi.Pointer<ffi.Char>> _sqlite3_version =
      _lookup<ffi.Pointer<ffi.Char>>('sqlite3_version');

  ffi.Pointer<ffi.Char> get sqlite3_version => _sqlite3_version.value;

  set sqlite3_version(ffi.Pointer<ffi.Char> value) =>
      _sqlite3_version.value = value;

  ffi.Pointer<ffi.Char> sqlite3_libversion() {
    return _sqlite3_libversion();
  }

  late final _sqlite3_libversionPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function()>>(
          'sqlite3_libversion');
  late final _sqlite3_libversion =
      _sqlite3_libversionPtr.asFunction<ffi.Pointer<ffi.Char> Function()>();

  ffi.Pointer<ffi.Char> sqlite3_sourceid() {
    return _sqlite3_sourceid();
  }

  late final _sqlite3_sourceidPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function()>>(
          'sqlite3_sourceid');
  late final _sqlite3_sourceid =
      _sqlite3_sourceidPtr.asFunction<ffi.Pointer<ffi.Char> Function()>();

  int sqlite3_libversion_number() {
    return _sqlite3_libversion_number();
  }

  late final _sqlite3_libversion_numberPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>(
          'sqlite3_libversion_number');
  late final _sqlite3_libversion_number =
      _sqlite3_libversion_numberPtr.asFunction<int Function()>();

  int sqlite3_compileoption_used(
    ffi.Pointer<ffi.Char> zOptName,
  ) {
    return _sqlite3_compileoption_used(
      zOptName,
    );
  }

  late final _sqlite3_compileoption_usedPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Char>)>>(
          'sqlite3_compileoption_used');
  late final _sqlite3_compileoption_used = _sqlite3_compileoption_usedPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>)>();

  ffi.Pointer<ffi.Char> sqlite3_compileoption_get(
    int N,
  ) {
    return _sqlite3_compileoption_get(
      N,
    );
  }

  late final _sqlite3_compileoption_getPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'sqlite3_compileoption_get');
  late final _sqlite3_compileoption_get = _sqlite3_compileoption_getPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// CAPI3REF: Test To See If The Library Is Threadsafe
  ///
  /// ^The sqlite3_threadsafe() function returns zero if and only if
  /// SQLite was compiled with mutexing code omitted due to the
  /// [SQLITE_THREADSAFE] compile-time option being set to 0.
  ///
  /// SQLite can be compiled with or without mutexes.  When
  /// the [SQLITE_THREADSAFE] C preprocessor macro is 1 or 2, mutexes
  /// are enabled and SQLite is threadsafe.  When the
  /// [SQLITE_THREADSAFE] macro is 0,
  /// the mutexes are omitted.  Without the mutexes, it is not safe
  /// to use SQLite concurrently from more than one thread.
  ///
  /// Enabling mutexes incurs a measurable performance penalty.
  /// So if speed is of utmost importance, it makes sense to disable
  /// the mutexes.  But for maximum safety, mutexes should be enabled.
  /// ^The default behavior is for mutexes to be enabled.
  ///
  /// This interface can be used by an application to make sure that the
  /// version of SQLite that it is linking against was compiled with
  /// the desired setting of the [SQLITE_THREADSAFE] macro.
  ///
  /// This interface only reports on the compile-time mutex setting
  /// of the [SQLITE_THREADSAFE] flag.  If SQLite is compiled with
  /// SQLITE_THREADSAFE=1 or =2 then mutexes are enabled by default but
  /// can be fully or partially disabled using a call to [sqlite3_config()]
  /// with the verbs [SQLITE_CONFIG_SINGLETHREAD], [SQLITE_CONFIG_MULTITHREAD],
  /// or [SQLITE_CONFIG_SERIALIZED].  ^(The return value of the
  /// sqlite3_threadsafe() function shows only the compile-time setting of
  /// thread safety, not any run-time changes to that setting made by
  /// sqlite3_config(). In other words, the return value from sqlite3_threadsafe()
  /// is unchanged by calls to sqlite3_config().)^
  ///
  /// See the [threading mode] documentation for additional information.
  int sqlite3_threadsafe() {
    return _sqlite3_threadsafe();
  }

  late final _sqlite3_threadsafePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>('sqlite3_threadsafe');
  late final _sqlite3_threadsafe =
      _sqlite3_threadsafePtr.asFunction<int Function()>();

  /// CAPI3REF: Closing A Database Connection
  /// DESTRUCTOR: sqlite3
  ///
  /// ^The sqlite3_close() and sqlite3_close_v2() routines are destructors
  /// for the [sqlite3] object.
  /// ^Calls to sqlite3_close() and sqlite3_close_v2() return [SQLITE_OK] if
  /// the [sqlite3] object is successfully destroyed and all associated
  /// resources are deallocated.
  ///
  /// Ideally, applications should [sqlite3_finalize | finalize] all
  /// [prepared statements], [sqlite3_blob_close | close] all [BLOB handles], and
  /// [sqlite3_backup_finish | finish] all [sqlite3_backup] objects associated
  /// with the [sqlite3] object prior to attempting to close the object.
  /// ^If the database connection is associated with unfinalized prepared
  /// statements, BLOB handlers, and/or unfinished sqlite3_backup objects then
  /// sqlite3_close() will leave the database connection open and return
  /// [SQLITE_BUSY]. ^If sqlite3_close_v2() is called with unfinalized prepared
  /// statements, unclosed BLOB handlers, and/or unfinished sqlite3_backups,
  /// it returns [SQLITE_OK] regardless, but instead of deallocating the database
  /// connection immediately, it marks the database connection as an unusable
  /// "zombie" and makes arrangements to automatically deallocate the database
  /// connection after all prepared statements are finalized, all BLOB handles
  /// are closed, and all backups have finished. The sqlite3_close_v2() interface
  /// is intended for use with host languages that are garbage collected, and
  /// where the order in which destructors are called is arbitrary.
  ///
  /// ^If an [sqlite3] object is destroyed while a transaction is open,
  /// the transaction is automatically rolled back.
  ///
  /// The C parameter to [sqlite3_close(C)] and [sqlite3_close_v2(C)]
  /// must be either a NULL
  /// pointer or an [sqlite3] object pointer obtained
  /// from [sqlite3_open()], [sqlite3_open16()], or
  /// [sqlite3_open_v2()], and not previously closed.
  /// ^Calling sqlite3_close() or sqlite3_close_v2() with a NULL pointer
  /// argument is a harmless no-op.
  int sqlite3_close(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_close(
      arg0,
    );
  }

  late final _sqlite3_closePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_close');
  late final _sqlite3_close =
      _sqlite3_closePtr.asFunction<int Function(ffi.Pointer<sqlite3>)>();

  int sqlite3_close_v2(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_close_v2(
      arg0,
    );
  }

  late final _sqlite3_close_v2Ptr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_close_v2');
  late final _sqlite3_close_v2 =
      _sqlite3_close_v2Ptr.asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: One-Step Query Execution Interface
  /// METHOD: sqlite3
  ///
  /// The sqlite3_exec() interface is a convenience wrapper around
  /// [sqlite3_prepare_v2()], [sqlite3_step()], and [sqlite3_finalize()],
  /// that allows an application to run multiple statements of SQL
  /// without having to use a lot of C code.
  ///
  /// ^The sqlite3_exec() interface runs zero or more UTF-8 encoded,
  /// semicolon-separate SQL statements passed into its 2nd argument,
  /// in the context of the [database connection] passed in as its 1st
  /// argument.  ^If the callback function of the 3rd argument to
  /// sqlite3_exec() is not NULL, then it is invoked for each result row
  /// coming out of the evaluated SQL statements.  ^The 4th argument to
  /// sqlite3_exec() is relayed through to the 1st argument of each
  /// callback invocation.  ^If the callback pointer to sqlite3_exec()
  /// is NULL, then no callback is ever invoked and result rows are
  /// ignored.
  ///
  /// ^If an error occurs while evaluating the SQL statements passed into
  /// sqlite3_exec(), then execution of the current statement stops and
  /// subsequent statements are skipped.  ^If the 5th parameter to sqlite3_exec()
  /// is not NULL then any error message is written into memory obtained
  /// from [sqlite3_malloc()] and passed back through the 5th parameter.
  /// To avoid memory leaks, the application should invoke [sqlite3_free()]
  /// on error message strings returned through the 5th parameter of
  /// sqlite3_exec() after the error message string is no longer needed.
  /// ^If the 5th parameter to sqlite3_exec() is not NULL and no errors
  /// occur, then sqlite3_exec() sets the pointer in its 5th parameter to
  /// NULL before returning.
  ///
  /// ^If an sqlite3_exec() callback returns non-zero, the sqlite3_exec()
  /// routine returns SQLITE_ABORT without invoking the callback again and
  /// without running any subsequent SQL statements.
  ///
  /// ^The 2nd argument to the sqlite3_exec() callback function is the
  /// number of columns in the result.  ^The 3rd argument to the sqlite3_exec()
  /// callback is an array of pointers to strings obtained as if from
  /// [sqlite3_column_text()], one for each column.  ^If an element of a
  /// result row is NULL then the corresponding string pointer for the
  /// sqlite3_exec() callback is a NULL pointer.  ^The 4th argument to the
  /// sqlite3_exec() callback is an array of pointers to strings where each
  /// entry represents the name of corresponding result column as obtained
  /// from [sqlite3_column_name()].
  ///
  /// ^If the 2nd parameter to sqlite3_exec() is a NULL pointer, a pointer
  /// to an empty string, or a pointer that contains only whitespace and/or
  /// SQL comments, then no SQL statements are evaluated and the database
  /// is not changed.
  ///
  /// Restrictions:
  ///
  /// <ul>
  /// <li> The application must ensure that the 1st parameter to sqlite3_exec()
  /// is a valid and open [database connection].
  /// <li> The application must not close the [database connection] specified by
  /// the 1st parameter to sqlite3_exec() while sqlite3_exec() is running.
  /// <li> The application must not modify the SQL statement text passed into
  /// the 2nd parameter of sqlite3_exec() while sqlite3_exec() is running.
  /// </ul>
  int sqlite3_exec(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Char> sql,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(
                    ffi.Pointer<ffi.Void>,
                    ffi.Int,
                    ffi.Pointer<ffi.Pointer<ffi.Char>>,
                    ffi.Pointer<ffi.Pointer<ffi.Char>>)>>
        callback,
    ffi.Pointer<ffi.Void> arg3,
    ffi.Pointer<ffi.Pointer<ffi.Char>> errmsg,
  ) {
    return _sqlite3_exec(
      arg0,
      sql,
      callback,
      arg3,
      errmsg,
    );
  }

  late final _sqlite3_execPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Pointer<ffi.Char>>,
                          ffi.Pointer<ffi.Pointer<ffi.Char>>)>>,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_exec');
  late final _sqlite3_exec = _sqlite3_execPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Int,
                      ffi.Pointer<ffi.Pointer<ffi.Char>>,
                      ffi.Pointer<ffi.Pointer<ffi.Char>>)>>,
          ffi.Pointer<ffi.Void>,
          ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  /// CAPI3REF: Initialize The SQLite Library
  ///
  /// ^The sqlite3_initialize() routine initializes the
  /// SQLite library.  ^The sqlite3_shutdown() routine
  /// deallocates any resources that were allocated by sqlite3_initialize().
  /// These routines are designed to aid in process initialization and
  /// shutdown on embedded systems.  Workstation applications using
  /// SQLite normally do not need to invoke either of these routines.
  ///
  /// A call to sqlite3_initialize() is an "effective" call if it is
  /// the first time sqlite3_initialize() is invoked during the lifetime of
  /// the process, or if it is the first time sqlite3_initialize() is invoked
  /// following a call to sqlite3_shutdown().  ^(Only an effective call
  /// of sqlite3_initialize() does any initialization.  All other calls
  /// are harmless no-ops.)^
  ///
  /// A call to sqlite3_shutdown() is an "effective" call if it is the first
  /// call to sqlite3_shutdown() since the last sqlite3_initialize().  ^(Only
  /// an effective call to sqlite3_shutdown() does any deinitialization.
  /// All other valid calls to sqlite3_shutdown() are harmless no-ops.)^
  ///
  /// The sqlite3_initialize() interface is threadsafe, but sqlite3_shutdown()
  /// is not.  The sqlite3_shutdown() interface must only be called from a
  /// single thread.  All open [database connections] must be closed and all
  /// other SQLite resources must be deallocated prior to invoking
  /// sqlite3_shutdown().
  ///
  /// Among other things, ^sqlite3_initialize() will invoke
  /// sqlite3_os_init().  Similarly, ^sqlite3_shutdown()
  /// will invoke sqlite3_os_end().
  ///
  /// ^The sqlite3_initialize() routine returns [SQLITE_OK] on success.
  /// ^If for some reason, sqlite3_initialize() is unable to initialize
  /// the library (perhaps it is unable to allocate a needed resource such
  /// as a mutex) it returns an [error code] other than [SQLITE_OK].
  ///
  /// ^The sqlite3_initialize() routine is called internally by many other
  /// SQLite interfaces so that an application usually does not need to
  /// invoke sqlite3_initialize() directly.  For example, [sqlite3_open()]
  /// calls sqlite3_initialize() so the SQLite library will be automatically
  /// initialized when [sqlite3_open()] is called if it has not be initialized
  /// already.  ^However, if SQLite is compiled with the [SQLITE_OMIT_AUTOINIT]
  /// compile-time option, then the automatic calls to sqlite3_initialize()
  /// are omitted and the application must call sqlite3_initialize() directly
  /// prior to using any other SQLite interface.  For maximum portability,
  /// it is recommended that applications always invoke sqlite3_initialize()
  /// directly prior to using any other SQLite interface.  Future releases
  /// of SQLite may require this.  In other words, the behavior exhibited
  /// when SQLite is compiled with [SQLITE_OMIT_AUTOINIT] might become the
  /// default behavior in some future release of SQLite.
  ///
  /// The sqlite3_os_init() routine does operating-system specific
  /// initialization of the SQLite library.  The sqlite3_os_end()
  /// routine undoes the effect of sqlite3_os_init().  Typical tasks
  /// performed by these routines include allocation or deallocation
  /// of static resources, initialization of global variables,
  /// setting up a default [sqlite3_vfs] module, or setting up
  /// a default configuration using [sqlite3_config()].
  ///
  /// The application should never invoke either sqlite3_os_init()
  /// or sqlite3_os_end() directly.  The application should only invoke
  /// sqlite3_initialize() and sqlite3_shutdown().  The sqlite3_os_init()
  /// interface is called automatically by sqlite3_initialize() and
  /// sqlite3_os_end() is called by sqlite3_shutdown().  Appropriate
  /// implementations for sqlite3_os_init() and sqlite3_os_end()
  /// are built into SQLite when it is compiled for Unix, Windows, or OS/2.
  /// When [custom builds | built for other platforms]
  /// (using the [SQLITE_OS_OTHER=1] compile-time
  /// option) the application must supply a suitable implementation for
  /// sqlite3_os_init() and sqlite3_os_end().  An application-supplied
  /// implementation of sqlite3_os_init() or sqlite3_os_end()
  /// must return [SQLITE_OK] on success and some other [error code] upon
  /// failure.
  int sqlite3_initialize() {
    return _sqlite3_initialize();
  }

  late final _sqlite3_initializePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>('sqlite3_initialize');
  late final _sqlite3_initialize =
      _sqlite3_initializePtr.asFunction<int Function()>();

  int sqlite3_shutdown() {
    return _sqlite3_shutdown();
  }

  late final _sqlite3_shutdownPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>('sqlite3_shutdown');
  late final _sqlite3_shutdown =
      _sqlite3_shutdownPtr.asFunction<int Function()>();

  int sqlite3_os_init() {
    return _sqlite3_os_init();
  }

  late final _sqlite3_os_initPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>('sqlite3_os_init');
  late final _sqlite3_os_init =
      _sqlite3_os_initPtr.asFunction<int Function()>();

  int sqlite3_os_end() {
    return _sqlite3_os_end();
  }

  late final _sqlite3_os_endPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>('sqlite3_os_end');
  late final _sqlite3_os_end = _sqlite3_os_endPtr.asFunction<int Function()>();

  /// CAPI3REF: Configuring The SQLite Library
  ///
  /// The sqlite3_config() interface is used to make global configuration
  /// changes to SQLite in order to tune SQLite to the specific needs of
  /// the application.  The default configuration is recommended for most
  /// applications and so this routine is usually not necessary.  It is
  /// provided to support rare applications with unusual needs.
  ///
  /// <b>The sqlite3_config() interface is not threadsafe. The application
  /// must ensure that no other SQLite interfaces are invoked by other
  /// threads while sqlite3_config() is running.</b>
  ///
  /// The sqlite3_config() interface
  /// may only be invoked prior to library initialization using
  /// [sqlite3_initialize()] or after shutdown by [sqlite3_shutdown()].
  /// ^If sqlite3_config() is called after [sqlite3_initialize()] and before
  /// [sqlite3_shutdown()] then it will return SQLITE_MISUSE.
  /// Note, however, that ^sqlite3_config() can be called as part of the
  /// implementation of an application-defined [sqlite3_os_init()].
  ///
  /// The first argument to sqlite3_config() is an integer
  /// [configuration option] that determines
  /// what property of SQLite is to be configured.  Subsequent arguments
  /// vary depending on the [configuration option]
  /// in the first argument.
  ///
  /// ^When a configuration option is set, sqlite3_config() returns [SQLITE_OK].
  /// ^If the option is unknown or SQLite is unable to set the option
  /// then this routine returns a non-zero [error code].
  int sqlite3_config(
    int arg0,
  ) {
    return _sqlite3_config(
      arg0,
    );
  }

  late final _sqlite3_configPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Int)>>('sqlite3_config');
  late final _sqlite3_config =
      _sqlite3_configPtr.asFunction<int Function(int)>();

  /// CAPI3REF: Configure database connections
  /// METHOD: sqlite3
  ///
  /// The sqlite3_db_config() interface is used to make configuration
  /// changes to a [database connection].  The interface is similar to
  /// [sqlite3_config()] except that the changes apply to a single
  /// [database connection] (specified in the first argument).
  ///
  /// The second argument to sqlite3_db_config(D,V,...)  is the
  /// [SQLITE_DBCONFIG_LOOKASIDE | configuration verb] - an integer code
  /// that indicates what aspect of the [database connection] is being configured.
  /// Subsequent arguments vary depending on the configuration verb.
  ///
  /// ^Calls to sqlite3_db_config() return SQLITE_OK if and only if
  /// the call is considered successful.
  int sqlite3_db_config(
    ffi.Pointer<sqlite3> arg0,
    int op,
  ) {
    return _sqlite3_db_config(
      arg0,
      op,
    );
  }

  late final _sqlite3_db_configPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Int)>>(
      'sqlite3_db_config');
  late final _sqlite3_db_config = _sqlite3_db_configPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, int)>();

  /// CAPI3REF: Enable Or Disable Extended Result Codes
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_extended_result_codes() routine enables or disables the
  /// [extended result codes] feature of SQLite. ^The extended result
  /// codes are disabled by default for historical compatibility.
  int sqlite3_extended_result_codes(
    ffi.Pointer<sqlite3> arg0,
    int onoff,
  ) {
    return _sqlite3_extended_result_codes(
      arg0,
      onoff,
    );
  }

  late final _sqlite3_extended_result_codesPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Int)>>(
      'sqlite3_extended_result_codes');
  late final _sqlite3_extended_result_codes = _sqlite3_extended_result_codesPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, int)>();

  /// CAPI3REF: Last Insert Rowid
  /// METHOD: sqlite3
  ///
  /// ^Each entry in most SQLite tables (except for [WITHOUT ROWID] tables)
  /// has a unique 64-bit signed
  /// integer key called the [ROWID | "rowid"]. ^The rowid is always available
  /// as an undeclared column named ROWID, OID, or _ROWID_ as long as those
  /// names are not also used by explicitly declared columns. ^If
  /// the table has a column of type [INTEGER PRIMARY KEY] then that column
  /// is another alias for the rowid.
  ///
  /// ^The sqlite3_last_insert_rowid(D) interface usually returns the [rowid] of
  /// the most recent successful [INSERT] into a rowid table or [virtual table]
  /// on database connection D. ^Inserts into [WITHOUT ROWID] tables are not
  /// recorded. ^If no successful [INSERT]s into rowid tables have ever occurred
  /// on the database connection D, then sqlite3_last_insert_rowid(D) returns
  /// zero.
  ///
  /// As well as being set automatically as rows are inserted into database
  /// tables, the value returned by this function may be set explicitly by
  /// [sqlite3_set_last_insert_rowid()]
  ///
  /// Some virtual table implementations may INSERT rows into rowid tables as
  /// part of committing a transaction (e.g. to flush data accumulated in memory
  /// to disk). In this case subsequent calls to this function return the rowid
  /// associated with these internal INSERT operations, which leads to
  /// unintuitive results. Virtual table implementations that do write to rowid
  /// tables in this way can avoid this problem by restoring the original
  /// rowid value using [sqlite3_set_last_insert_rowid()] before returning
  /// control to the user.
  ///
  /// ^(If an [INSERT] occurs within a trigger then this routine will
  /// return the [rowid] of the inserted row as long as the trigger is
  /// running. Once the trigger program ends, the value returned
  /// by this routine reverts to what it was before the trigger was fired.)^
  ///
  /// ^An [INSERT] that fails due to a constraint violation is not a
  /// successful [INSERT] and does not change the value returned by this
  /// routine.  ^Thus INSERT OR FAIL, INSERT OR IGNORE, INSERT OR ROLLBACK,
  /// and INSERT OR ABORT make no changes to the return value of this
  /// routine when their insertion fails.  ^(When INSERT OR REPLACE
  /// encounters a constraint violation, it does not fail.  The
  /// INSERT continues to completion after deleting rows that caused
  /// the constraint problem so INSERT OR REPLACE will always change
  /// the return value of this interface.)^
  ///
  /// ^For the purposes of this routine, an [INSERT] is considered to
  /// be successful even if it is subsequently rolled back.
  ///
  /// This function is accessible to SQL statements via the
  /// [last_insert_rowid() SQL function].
  ///
  /// If a separate thread performs a new [INSERT] on the same
  /// database connection while the [sqlite3_last_insert_rowid()]
  /// function is running and thus changes the last insert [rowid],
  /// then the value returned by [sqlite3_last_insert_rowid()] is
  /// unpredictable and might not equal either the old or the new
  /// last insert [rowid].
  int sqlite3_last_insert_rowid(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_last_insert_rowid(
      arg0,
    );
  }

  late final _sqlite3_last_insert_rowidPtr =
      _lookup<ffi.NativeFunction<sqlite3_int64 Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_last_insert_rowid');
  late final _sqlite3_last_insert_rowid = _sqlite3_last_insert_rowidPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Set the Last Insert Rowid value.
  /// METHOD: sqlite3
  ///
  /// The sqlite3_set_last_insert_rowid(D, R) method allows the application to
  /// set the value returned by calling sqlite3_last_insert_rowid(D) to R
  /// without inserting a row into the database.
  void sqlite3_set_last_insert_rowid(
    ffi.Pointer<sqlite3> arg0,
    int arg1,
  ) {
    return _sqlite3_set_last_insert_rowid(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_set_last_insert_rowidPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3>,
              sqlite3_int64)>>('sqlite3_set_last_insert_rowid');
  late final _sqlite3_set_last_insert_rowid = _sqlite3_set_last_insert_rowidPtr
      .asFunction<void Function(ffi.Pointer<sqlite3>, int)>();

  /// CAPI3REF: Count The Number Of Rows Modified
  /// METHOD: sqlite3
  ///
  /// ^This function returns the number of rows modified, inserted or
  /// deleted by the most recently completed INSERT, UPDATE or DELETE
  /// statement on the database connection specified by the only parameter.
  /// ^Executing any other type of SQL statement does not modify the value
  /// returned by this function.
  ///
  /// ^Only changes made directly by the INSERT, UPDATE or DELETE statement are
  /// considered - auxiliary changes caused by [CREATE TRIGGER | triggers],
  /// [foreign key actions] or [REPLACE] constraint resolution are not counted.
  ///
  /// Changes to a view that are intercepted by
  /// [INSTEAD OF trigger | INSTEAD OF triggers] are not counted. ^The value
  /// returned by sqlite3_changes() immediately after an INSERT, UPDATE or
  /// DELETE statement run on a view is always zero. Only changes made to real
  /// tables are counted.
  ///
  /// Things are more complicated if the sqlite3_changes() function is
  /// executed while a trigger program is running. This may happen if the
  /// program uses the [changes() SQL function], or if some other callback
  /// function invokes sqlite3_changes() directly. Essentially:
  ///
  /// <ul>
  /// <li> ^(Before entering a trigger program the value returned by
  /// sqlite3_changes() function is saved. After the trigger program
  /// has finished, the original value is restored.)^
  ///
  /// <li> ^(Within a trigger program each INSERT, UPDATE and DELETE
  /// statement sets the value returned by sqlite3_changes()
  /// upon completion as normal. Of course, this value will not include
  /// any changes performed by sub-triggers, as the sqlite3_changes()
  /// value will be saved and restored after each sub-trigger has run.)^
  /// </ul>
  ///
  /// ^This means that if the changes() SQL function (or similar) is used
  /// by the first INSERT, UPDATE or DELETE statement within a trigger, it
  /// returns the value as set when the calling statement began executing.
  /// ^If it is used by the second or subsequent such statement within a trigger
  /// program, the value returned reflects the number of rows modified by the
  /// previous INSERT, UPDATE or DELETE statement within the same trigger.
  ///
  /// If a separate thread makes changes on the same database connection
  /// while [sqlite3_changes()] is running then the value returned
  /// is unpredictable and not meaningful.
  ///
  /// See also:
  /// <ul>
  /// <li> the [sqlite3_total_changes()] interface
  /// <li> the [count_changes pragma]
  /// <li> the [changes() SQL function]
  /// <li> the [data_version pragma]
  /// </ul>
  int sqlite3_changes(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_changes(
      arg0,
    );
  }

  late final _sqlite3_changesPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_changes');
  late final _sqlite3_changes =
      _sqlite3_changesPtr.asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Total Number Of Rows Modified
  /// METHOD: sqlite3
  ///
  /// ^This function returns the total number of rows inserted, modified or
  /// deleted by all [INSERT], [UPDATE] or [DELETE] statements completed
  /// since the database connection was opened, including those executed as
  /// part of trigger programs. ^Executing any other type of SQL statement
  /// does not affect the value returned by sqlite3_total_changes().
  ///
  /// ^Changes made as part of [foreign key actions] are included in the
  /// count, but those made as part of REPLACE constraint resolution are
  /// not. ^Changes to a view that are intercepted by INSTEAD OF triggers
  /// are not counted.
  ///
  /// The [sqlite3_total_changes(D)] interface only reports the number
  /// of rows that changed due to SQL statement run against database
  /// connection D.  Any changes by other database connections are ignored.
  /// To detect changes against a database file from other database
  /// connections use the [PRAGMA data_version] command or the
  /// [SQLITE_FCNTL_DATA_VERSION] [file control].
  ///
  /// If a separate thread makes changes on the same database connection
  /// while [sqlite3_total_changes()] is running then the value
  /// returned is unpredictable and not meaningful.
  ///
  /// See also:
  /// <ul>
  /// <li> the [sqlite3_changes()] interface
  /// <li> the [count_changes pragma]
  /// <li> the [changes() SQL function]
  /// <li> the [data_version pragma]
  /// <li> the [SQLITE_FCNTL_DATA_VERSION] [file control]
  /// </ul>
  int sqlite3_total_changes(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_total_changes(
      arg0,
    );
  }

  late final _sqlite3_total_changesPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_total_changes');
  late final _sqlite3_total_changes = _sqlite3_total_changesPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Interrupt A Long-Running Query
  /// METHOD: sqlite3
  ///
  /// ^This function causes any pending database operation to abort and
  /// return at its earliest opportunity. This routine is typically
  /// called in response to a user action such as pressing "Cancel"
  /// or Ctrl-C where the user wants a long query operation to halt
  /// immediately.
  ///
  /// ^It is safe to call this routine from a thread different from the
  /// thread that is currently running the database operation.  But it
  /// is not safe to call this routine with a [database connection] that
  /// is closed or might close before sqlite3_interrupt() returns.
  ///
  /// ^If an SQL operation is very nearly finished at the time when
  /// sqlite3_interrupt() is called, then it might not have an opportunity
  /// to be interrupted and might continue to completion.
  ///
  /// ^An SQL operation that is interrupted will return [SQLITE_INTERRUPT].
  /// ^If the interrupted SQL operation is an INSERT, UPDATE, or DELETE
  /// that is inside an explicit transaction, then the entire transaction
  /// will be rolled back automatically.
  ///
  /// ^The sqlite3_interrupt(D) call is in effect until all currently running
  /// SQL statements on [database connection] D complete.  ^Any new SQL statements
  /// that are started after the sqlite3_interrupt() call and before the
  /// running statement count reaches zero are interrupted as if they had been
  /// running prior to the sqlite3_interrupt() call.  ^New SQL statements
  /// that are started after the running statement count reaches zero are
  /// not effected by the sqlite3_interrupt().
  /// ^A call to sqlite3_interrupt(D) that occurs when there are no running
  /// SQL statements is a no-op and has no effect on SQL statements
  /// that are started after the sqlite3_interrupt() call returns.
  void sqlite3_interrupt(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_interrupt(
      arg0,
    );
  }

  late final _sqlite3_interruptPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_interrupt');
  late final _sqlite3_interrupt =
      _sqlite3_interruptPtr.asFunction<void Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Determine If An SQL Statement Is Complete
  ///
  /// These routines are useful during command-line input to determine if the
  /// currently entered text seems to form a complete SQL statement or
  /// if additional input is needed before sending the text into
  /// SQLite for parsing.  ^These routines return 1 if the input string
  /// appears to be a complete SQL statement.  ^A statement is judged to be
  /// complete if it ends with a semicolon token and is not a prefix of a
  /// well-formed CREATE TRIGGER statement.  ^Semicolons that are embedded within
  /// string literals or quoted identifier names or comments are not
  /// independent tokens (they are part of the token in which they are
  /// embedded) and thus do not count as a statement terminator.  ^Whitespace
  /// and comments that follow the final semicolon are ignored.
  ///
  /// ^These routines return 0 if the statement is incomplete.  ^If a
  /// memory allocation fails, then SQLITE_NOMEM is returned.
  ///
  /// ^These routines do not parse the SQL statements thus
  /// will not detect syntactically incorrect SQL.
  ///
  /// ^(If SQLite has not been initialized using [sqlite3_initialize()] prior
  /// to invoking sqlite3_complete16() then sqlite3_initialize() is invoked
  /// automatically by sqlite3_complete16().  If that initialization fails,
  /// then the return value from sqlite3_complete16() will be non-zero
  /// regardless of whether or not the input SQL is complete.)^
  ///
  /// The input to [sqlite3_complete()] must be a zero-terminated
  /// UTF-8 string.
  ///
  /// The input to [sqlite3_complete16()] must be a zero-terminated
  /// UTF-16 string in native byte order.
  int sqlite3_complete(
    ffi.Pointer<ffi.Char> sql,
  ) {
    return _sqlite3_complete(
      sql,
    );
  }

  late final _sqlite3_completePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Char>)>>(
          'sqlite3_complete');
  late final _sqlite3_complete =
      _sqlite3_completePtr.asFunction<int Function(ffi.Pointer<ffi.Char>)>();

  int sqlite3_complete16(
    ffi.Pointer<ffi.Void> sql,
  ) {
    return _sqlite3_complete16(
      sql,
    );
  }

  late final _sqlite3_complete16Ptr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>(
          'sqlite3_complete16');
  late final _sqlite3_complete16 =
      _sqlite3_complete16Ptr.asFunction<int Function(ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Register A Callback To Handle SQLITE_BUSY Errors
  /// KEYWORDS: {busy-handler callback} {busy handler}
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_busy_handler(D,X,P) routine sets a callback function X
  /// that might be invoked with argument P whenever
  /// an attempt is made to access a database table associated with
  /// [database connection] D when another thread
  /// or process has the table locked.
  /// The sqlite3_busy_handler() interface is used to implement
  /// [sqlite3_busy_timeout()] and [PRAGMA busy_timeout].
  ///
  /// ^If the busy callback is NULL, then [SQLITE_BUSY]
  /// is returned immediately upon encountering the lock.  ^If the busy callback
  /// is not NULL, then the callback might be invoked with two arguments.
  ///
  /// ^The first argument to the busy handler is a copy of the void* pointer which
  /// is the third argument to sqlite3_busy_handler().  ^The second argument to
  /// the busy handler callback is the number of times that the busy handler has
  /// been invoked previously for the same locking event.  ^If the
  /// busy callback returns 0, then no additional attempts are made to
  /// access the database and [SQLITE_BUSY] is returned
  /// to the application.
  /// ^If the callback returns non-zero, then another attempt
  /// is made to access the database and the cycle repeats.
  ///
  /// The presence of a busy handler does not guarantee that it will be invoked
  /// when there is lock contention. ^If SQLite determines that invoking the busy
  /// handler could result in a deadlock, it will go ahead and return [SQLITE_BUSY]
  /// to the application instead of invoking the
  /// busy handler.
  /// Consider a scenario where one process is holding a read lock that
  /// it is trying to promote to a reserved lock and
  /// a second process is holding a reserved lock that it is trying
  /// to promote to an exclusive lock.  The first process cannot proceed
  /// because it is blocked by the second and the second process cannot
  /// proceed because it is blocked by the first.  If both processes
  /// invoke the busy handlers, neither will make any progress.  Therefore,
  /// SQLite returns [SQLITE_BUSY] for the first process, hoping that this
  /// will induce the first process to release its read lock and allow
  /// the second process to proceed.
  ///
  /// ^The default busy callback is NULL.
  ///
  /// ^(There can only be a single busy handler defined for each
  /// [database connection].  Setting a new busy handler clears any
  /// previously set handler.)^  ^Note that calling [sqlite3_busy_timeout()]
  /// or evaluating [PRAGMA busy_timeout=N] will change the
  /// busy handler and thus clear any previously set busy handler.
  ///
  /// The busy callback should not take any actions which modify the
  /// database connection that invoked the busy handler.  In other words,
  /// the busy handler is not reentrant.  Any such actions
  /// result in undefined behavior.
  ///
  /// A busy handler must not close the database connection
  /// or [prepared statement] that invoked the busy handler.
  int sqlite3_busy_handler(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<
            ffi
            .NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>, ffi.Int)>>
        arg1,
    ffi.Pointer<ffi.Void> arg2,
  ) {
    return _sqlite3_busy_handler(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_busy_handlerPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(ffi.Pointer<ffi.Void>, ffi.Int)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_busy_handler');
  late final _sqlite3_busy_handler = _sqlite3_busy_handlerPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Int Function(ffi.Pointer<ffi.Void>, ffi.Int)>>,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Set A Busy Timeout
  /// METHOD: sqlite3
  ///
  /// ^This routine sets a [sqlite3_busy_handler | busy handler] that sleeps
  /// for a specified amount of time when a table is locked.  ^The handler
  /// will sleep multiple times until at least "ms" milliseconds of sleeping
  /// have accumulated.  ^After at least "ms" milliseconds of sleeping,
  /// the handler returns 0 which causes [sqlite3_step()] to return
  /// [SQLITE_BUSY].
  ///
  /// ^Calling this routine with an argument less than or equal to zero
  /// turns off all busy handlers.
  ///
  /// ^(There can only be a single busy handler for a particular
  /// [database connection] at any given moment.  If another busy handler
  /// was defined  (using [sqlite3_busy_handler()]) prior to calling
  /// this routine, that other busy handler is cleared.)^
  ///
  /// See also:  [PRAGMA busy_timeout]
  int sqlite3_busy_timeout(
    ffi.Pointer<sqlite3> arg0,
    int ms,
  ) {
    return _sqlite3_busy_timeout(
      arg0,
      ms,
    );
  }

  late final _sqlite3_busy_timeoutPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Int)>>(
      'sqlite3_busy_timeout');
  late final _sqlite3_busy_timeout = _sqlite3_busy_timeoutPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, int)>();

  /// CAPI3REF: Convenience Routines For Running Queries
  /// METHOD: sqlite3
  ///
  /// This is a legacy interface that is preserved for backwards compatibility.
  /// Use of this interface is not recommended.
  ///
  /// Definition: A <b>result table</b> is memory data structure created by the
  /// [sqlite3_get_table()] interface.  A result table records the
  /// complete query results from one or more queries.
  ///
  /// The table conceptually has a number of rows and columns.  But
  /// these numbers are not part of the result table itself.  These
  /// numbers are obtained separately.  Let N be the number of rows
  /// and M be the number of columns.
  ///
  /// A result table is an array of pointers to zero-terminated UTF-8 strings.
  /// There are (N+1)*M elements in the array.  The first M pointers point
  /// to zero-terminated strings that  contain the names of the columns.
  /// The remaining entries all point to query results.  NULL values result
  /// in NULL pointers.  All other values are in their UTF-8 zero-terminated
  /// string representation as returned by [sqlite3_column_text()].
  ///
  /// A result table might consist of one or more memory allocations.
  /// It is not safe to pass a result table directly to [sqlite3_free()].
  /// A result table should be deallocated using [sqlite3_free_table()].
  ///
  /// ^(As an example of the result table format, suppose a query result
  /// is as follows:
  ///
  /// <blockquote><pre>
  /// Name        | Age
  /// -----------------------
  /// Alice       | 43
  /// Bob         | 28
  /// Cindy       | 21
  /// </pre></blockquote>
  ///
  /// There are two columns (M==2) and three rows (N==3).  Thus the
  /// result table has 8 entries.  Suppose the result table is stored
  /// in an array named azResult.  Then azResult holds this content:
  ///
  /// <blockquote><pre>
  /// azResult&#91;0] = "Name";
  /// azResult&#91;1] = "Age";
  /// azResult&#91;2] = "Alice";
  /// azResult&#91;3] = "43";
  /// azResult&#91;4] = "Bob";
  /// azResult&#91;5] = "28";
  /// azResult&#91;6] = "Cindy";
  /// azResult&#91;7] = "21";
  /// </pre></blockquote>)^
  ///
  /// ^The sqlite3_get_table() function evaluates one or more
  /// semicolon-separated SQL statements in the zero-terminated UTF-8
  /// string of its 2nd parameter and returns a result table to the
  /// pointer given in its 3rd parameter.
  ///
  /// After the application has finished with the result from sqlite3_get_table(),
  /// it must pass the result table pointer to sqlite3_free_table() in order to
  /// release the memory that was malloced.  Because of the way the
  /// [sqlite3_malloc()] happens within sqlite3_get_table(), the calling
  /// function must not try to call [sqlite3_free()] directly.  Only
  /// [sqlite3_free_table()] is able to release the memory properly and safely.
  ///
  /// The sqlite3_get_table() interface is implemented as a wrapper around
  /// [sqlite3_exec()].  The sqlite3_get_table() routine does not have access
  /// to any internal data structures of SQLite.  It uses only the public
  /// interface defined here.  As a consequence, errors that occur in the
  /// wrapper layer outside of the internal [sqlite3_exec()] call are not
  /// reflected in subsequent calls to [sqlite3_errcode()] or
  /// [sqlite3_errmsg()].
  int sqlite3_get_table(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zSql,
    ffi.Pointer<ffi.Pointer<ffi.Pointer<ffi.Char>>> pazResult,
    ffi.Pointer<ffi.Int> pnRow,
    ffi.Pointer<ffi.Int> pnColumn,
    ffi.Pointer<ffi.Pointer<ffi.Char>> pzErrmsg,
  ) {
    return _sqlite3_get_table(
      db,
      zSql,
      pazResult,
      pnRow,
      pnColumn,
      pzErrmsg,
    );
  }

  late final _sqlite3_get_tablePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Pointer<ffi.Pointer<ffi.Char>>>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_get_table');
  late final _sqlite3_get_table = _sqlite3_get_tablePtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Pointer<ffi.Pointer<ffi.Char>>>,
          ffi.Pointer<ffi.Int>,
          ffi.Pointer<ffi.Int>,
          ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  void sqlite3_free_table(
    ffi.Pointer<ffi.Pointer<ffi.Char>> result,
  ) {
    return _sqlite3_free_table(
      result,
    );
  }

  late final _sqlite3_free_tablePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_free_table');
  late final _sqlite3_free_table = _sqlite3_free_tablePtr
      .asFunction<void Function(ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  /// CAPI3REF: Formatted String Printing Functions
  ///
  /// These routines are work-alikes of the "printf()" family of functions
  /// from the standard C library.
  /// These routines understand most of the common formatting options from
  /// the standard library printf()
  /// plus some additional non-standard formats ([%q], [%Q], [%w], and [%z]).
  /// See the [built-in printf()] documentation for details.
  ///
  /// ^The sqlite3_mprintf() and sqlite3_vmprintf() routines write their
  /// results into memory obtained from [sqlite3_malloc64()].
  /// The strings returned by these two routines should be
  /// released by [sqlite3_free()].  ^Both routines return a
  /// NULL pointer if [sqlite3_malloc64()] is unable to allocate enough
  /// memory to hold the resulting string.
  ///
  /// ^(The sqlite3_snprintf() routine is similar to "snprintf()" from
  /// the standard C library.  The result is written into the
  /// buffer supplied as the second parameter whose size is given by
  /// the first parameter. Note that the order of the
  /// first two parameters is reversed from snprintf().)^  This is an
  /// historical accident that cannot be fixed without breaking
  /// backwards compatibility.  ^(Note also that sqlite3_snprintf()
  /// returns a pointer to its buffer instead of the number of
  /// characters actually written into the buffer.)^  We admit that
  /// the number of characters written would be a more useful return
  /// value but we cannot change the implementation of sqlite3_snprintf()
  /// now without breaking compatibility.
  ///
  /// ^As long as the buffer size is greater than zero, sqlite3_snprintf()
  /// guarantees that the buffer is always zero-terminated.  ^The first
  /// parameter "n" is the total size of the buffer, including space for
  /// the zero terminator.  So the longest string that can be completely
  /// written will be n-1 characters.
  ///
  /// ^The sqlite3_vsnprintf() routine is a varargs version of sqlite3_snprintf().
  ///
  /// See also:  [built-in printf()], [printf() SQL function]
  ffi.Pointer<ffi.Char> sqlite3_mprintf(
    ffi.Pointer<ffi.Char> arg0,
  ) {
    return _sqlite3_mprintf(
      arg0,
    );
  }

  late final _sqlite3_mprintfPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<ffi.Char>)>>('sqlite3_mprintf');
  late final _sqlite3_mprintf = _sqlite3_mprintfPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<ffi.Char>)>();

  ffi.Pointer<ffi.Char> sqlite3_snprintf(
    int arg0,
    ffi.Pointer<ffi.Char> arg1,
    ffi.Pointer<ffi.Char> arg2,
  ) {
    return _sqlite3_snprintf(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_snprintfPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Int, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_snprintf');
  late final _sqlite3_snprintf = _sqlite3_snprintfPtr.asFunction<
      ffi.Pointer<ffi.Char> Function(
          int, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Memory Allocation Subsystem
  ///
  /// The SQLite core uses these three routines for all of its own
  /// internal memory allocation needs. "Core" in the previous sentence
  /// does not include operating-system specific [VFS] implementation.  The
  /// Windows VFS uses native malloc() and free() for some operations.
  ///
  /// ^The sqlite3_malloc() routine returns a pointer to a block
  /// of memory at least N bytes in length, where N is the parameter.
  /// ^If sqlite3_malloc() is unable to obtain sufficient free
  /// memory, it returns a NULL pointer.  ^If the parameter N to
  /// sqlite3_malloc() is zero or negative then sqlite3_malloc() returns
  /// a NULL pointer.
  ///
  /// ^The sqlite3_malloc64(N) routine works just like
  /// sqlite3_malloc(N) except that N is an unsigned 64-bit integer instead
  /// of a signed 32-bit integer.
  ///
  /// ^Calling sqlite3_free() with a pointer previously returned
  /// by sqlite3_malloc() or sqlite3_realloc() releases that memory so
  /// that it might be reused.  ^The sqlite3_free() routine is
  /// a no-op if is called with a NULL pointer.  Passing a NULL pointer
  /// to sqlite3_free() is harmless.  After being freed, memory
  /// should neither be read nor written.  Even reading previously freed
  /// memory might result in a segmentation fault or other severe error.
  /// Memory corruption, a segmentation fault, or other severe error
  /// might result if sqlite3_free() is called with a non-NULL pointer that
  /// was not obtained from sqlite3_malloc() or sqlite3_realloc().
  ///
  /// ^The sqlite3_realloc(X,N) interface attempts to resize a
  /// prior memory allocation X to be at least N bytes.
  /// ^If the X parameter to sqlite3_realloc(X,N)
  /// is a NULL pointer then its behavior is identical to calling
  /// sqlite3_malloc(N).
  /// ^If the N parameter to sqlite3_realloc(X,N) is zero or
  /// negative then the behavior is exactly the same as calling
  /// sqlite3_free(X).
  /// ^sqlite3_realloc(X,N) returns a pointer to a memory allocation
  /// of at least N bytes in size or NULL if insufficient memory is available.
  /// ^If M is the size of the prior allocation, then min(N,M) bytes
  /// of the prior allocation are copied into the beginning of buffer returned
  /// by sqlite3_realloc(X,N) and the prior allocation is freed.
  /// ^If sqlite3_realloc(X,N) returns NULL and N is positive, then the
  /// prior allocation is not freed.
  ///
  /// ^The sqlite3_realloc64(X,N) interfaces works the same as
  /// sqlite3_realloc(X,N) except that N is a 64-bit unsigned integer instead
  /// of a 32-bit signed integer.
  ///
  /// ^If X is a memory allocation previously obtained from sqlite3_malloc(),
  /// sqlite3_malloc64(), sqlite3_realloc(), or sqlite3_realloc64(), then
  /// sqlite3_msize(X) returns the size of that memory allocation in bytes.
  /// ^The value returned by sqlite3_msize(X) might be larger than the number
  /// of bytes requested when X was allocated.  ^If X is a NULL pointer then
  /// sqlite3_msize(X) returns zero.  If X points to something that is not
  /// the beginning of memory allocation, or if it points to a formerly
  /// valid memory allocation that has now been freed, then the behavior
  /// of sqlite3_msize(X) is undefined and possibly harmful.
  ///
  /// ^The memory returned by sqlite3_malloc(), sqlite3_realloc(),
  /// sqlite3_malloc64(), and sqlite3_realloc64()
  /// is always aligned to at least an 8 byte boundary, or to a
  /// 4 byte boundary if the [SQLITE_4_BYTE_ALIGNED_MALLOC] compile-time
  /// option is used.
  ///
  /// The pointer arguments to [sqlite3_free()] and [sqlite3_realloc()]
  /// must be either NULL or else pointers obtained from a prior
  /// invocation of [sqlite3_malloc()] or [sqlite3_realloc()] that have
  /// not yet been released.
  ///
  /// The application must not read or write any part of
  /// a block of memory after it has been released using
  /// [sqlite3_free()] or [sqlite3_realloc()].
  ffi.Pointer<ffi.Void> sqlite3_malloc(
    int arg0,
  ) {
    return _sqlite3_malloc(
      arg0,
    );
  }

  late final _sqlite3_mallocPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Void> Function(ffi.Int)>>(
          'sqlite3_malloc');
  late final _sqlite3_malloc =
      _sqlite3_mallocPtr.asFunction<ffi.Pointer<ffi.Void> Function(int)>();

  ffi.Pointer<ffi.Void> sqlite3_malloc64(
    int arg0,
  ) {
    return _sqlite3_malloc64(
      arg0,
    );
  }

  late final _sqlite3_malloc64Ptr = _lookup<
          ffi.NativeFunction<ffi.Pointer<ffi.Void> Function(sqlite3_uint64)>>(
      'sqlite3_malloc64');
  late final _sqlite3_malloc64 =
      _sqlite3_malloc64Ptr.asFunction<ffi.Pointer<ffi.Void> Function(int)>();

  ffi.Pointer<ffi.Void> sqlite3_realloc(
    ffi.Pointer<ffi.Void> arg0,
    int arg1,
  ) {
    return _sqlite3_realloc(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_reallocPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<ffi.Void>, ffi.Int)>>('sqlite3_realloc');
  late final _sqlite3_realloc = _sqlite3_reallocPtr
      .asFunction<ffi.Pointer<ffi.Void> Function(ffi.Pointer<ffi.Void>, int)>();

  ffi.Pointer<ffi.Void> sqlite3_realloc64(
    ffi.Pointer<ffi.Void> arg0,
    int arg1,
  ) {
    return _sqlite3_realloc64(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_realloc64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<ffi.Void>, sqlite3_uint64)>>('sqlite3_realloc64');
  late final _sqlite3_realloc64 = _sqlite3_realloc64Ptr
      .asFunction<ffi.Pointer<ffi.Void> Function(ffi.Pointer<ffi.Void>, int)>();

  void sqlite3_free(
    ffi.Pointer<ffi.Void> arg0,
  ) {
    return _sqlite3_free(
      arg0,
    );
  }

  late final _sqlite3_freePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>(
          'sqlite3_free');
  late final _sqlite3_free =
      _sqlite3_freePtr.asFunction<void Function(ffi.Pointer<ffi.Void>)>();

  int sqlite3_msize(
    ffi.Pointer<ffi.Void> arg0,
  ) {
    return _sqlite3_msize(
      arg0,
    );
  }

  late final _sqlite3_msizePtr = _lookup<
          ffi.NativeFunction<sqlite3_uint64 Function(ffi.Pointer<ffi.Void>)>>(
      'sqlite3_msize');
  late final _sqlite3_msize =
      _sqlite3_msizePtr.asFunction<int Function(ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Memory Allocator Statistics
  ///
  /// SQLite provides these two interfaces for reporting on the status
  /// of the [sqlite3_malloc()], [sqlite3_free()], and [sqlite3_realloc()]
  /// routines, which form the built-in memory allocation subsystem.
  ///
  /// ^The [sqlite3_memory_used()] routine returns the number of bytes
  /// of memory currently outstanding (malloced but not freed).
  /// ^The [sqlite3_memory_highwater()] routine returns the maximum
  /// value of [sqlite3_memory_used()] since the high-water mark
  /// was last reset.  ^The values returned by [sqlite3_memory_used()] and
  /// [sqlite3_memory_highwater()] include any overhead
  /// added by SQLite in its implementation of [sqlite3_malloc()],
  /// but not overhead added by the any underlying system library
  /// routines that [sqlite3_malloc()] may call.
  ///
  /// ^The memory high-water mark is reset to the current value of
  /// [sqlite3_memory_used()] if and only if the parameter to
  /// [sqlite3_memory_highwater()] is true.  ^The value returned
  /// by [sqlite3_memory_highwater(1)] is the high-water mark
  /// prior to the reset.
  int sqlite3_memory_used() {
    return _sqlite3_memory_used();
  }

  late final _sqlite3_memory_usedPtr =
      _lookup<ffi.NativeFunction<sqlite3_int64 Function()>>(
          'sqlite3_memory_used');
  late final _sqlite3_memory_used =
      _sqlite3_memory_usedPtr.asFunction<int Function()>();

  int sqlite3_memory_highwater(
    int resetFlag,
  ) {
    return _sqlite3_memory_highwater(
      resetFlag,
    );
  }

  late final _sqlite3_memory_highwaterPtr =
      _lookup<ffi.NativeFunction<sqlite3_int64 Function(ffi.Int)>>(
          'sqlite3_memory_highwater');
  late final _sqlite3_memory_highwater =
      _sqlite3_memory_highwaterPtr.asFunction<int Function(int)>();

  /// CAPI3REF: Pseudo-Random Number Generator
  ///
  /// SQLite contains a high-quality pseudo-random number generator (PRNG) used to
  /// select random [ROWID | ROWIDs] when inserting new records into a table that
  /// already uses the largest possible [ROWID].  The PRNG is also used for
  /// the built-in random() and randomblob() SQL functions.  This interface allows
  /// applications to access the same PRNG for other purposes.
  ///
  /// ^A call to this routine stores N bytes of randomness into buffer P.
  /// ^The P parameter can be a NULL pointer.
  ///
  /// ^If this routine has not been previously called or if the previous
  /// call had N less than one or a NULL pointer for P, then the PRNG is
  /// seeded using randomness obtained from the xRandomness method of
  /// the default [sqlite3_vfs] object.
  /// ^If the previous call to this routine had an N of 1 or more and a
  /// non-NULL P then the pseudo-randomness is generated
  /// internally and without recourse to the [sqlite3_vfs] xRandomness
  /// method.
  void sqlite3_randomness(
    int N,
    ffi.Pointer<ffi.Void> P,
  ) {
    return _sqlite3_randomness(
      N,
      P,
    );
  }

  late final _sqlite3_randomnessPtr = _lookup<
          ffi
          .NativeFunction<ffi.Void Function(ffi.Int, ffi.Pointer<ffi.Void>)>>(
      'sqlite3_randomness');
  late final _sqlite3_randomness = _sqlite3_randomnessPtr
      .asFunction<void Function(int, ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Compile-Time Authorization Callbacks
  /// METHOD: sqlite3
  /// KEYWORDS: {authorizer callback}
  ///
  /// ^This routine registers an authorizer callback with a particular
  /// [database connection], supplied in the first argument.
  /// ^The authorizer callback is invoked as SQL statements are being compiled
  /// by [sqlite3_prepare()] or its variants [sqlite3_prepare_v2()],
  /// [sqlite3_prepare_v3()], [sqlite3_prepare16()], [sqlite3_prepare16_v2()],
  /// and [sqlite3_prepare16_v3()].  ^At various
  /// points during the compilation process, as logic is being created
  /// to perform various actions, the authorizer callback is invoked to
  /// see if those actions are allowed.  ^The authorizer callback should
  /// return [SQLITE_OK] to allow the action, [SQLITE_IGNORE] to disallow the
  /// specific action but allow the SQL statement to continue to be
  /// compiled, or [SQLITE_DENY] to cause the entire SQL statement to be
  /// rejected with an error.  ^If the authorizer callback returns
  /// any value other than [SQLITE_IGNORE], [SQLITE_OK], or [SQLITE_DENY]
  /// then the [sqlite3_prepare_v2()] or equivalent call that triggered
  /// the authorizer will fail with an error message.
  ///
  /// When the callback returns [SQLITE_OK], that means the operation
  /// requested is ok.  ^When the callback returns [SQLITE_DENY], the
  /// [sqlite3_prepare_v2()] or equivalent call that triggered the
  /// authorizer will fail with an error message explaining that
  /// access is denied.
  ///
  /// ^The first parameter to the authorizer callback is a copy of the third
  /// parameter to the sqlite3_set_authorizer() interface. ^The second parameter
  /// to the callback is an integer [SQLITE_COPY | action code] that specifies
  /// the particular action to be authorized. ^The third through sixth parameters
  /// to the callback are either NULL pointers or zero-terminated strings
  /// that contain additional details about the action to be authorized.
  /// Applications must always be prepared to encounter a NULL pointer in any
  /// of the third through the sixth parameters of the authorization callback.
  ///
  /// ^If the action code is [SQLITE_READ]
  /// and the callback returns [SQLITE_IGNORE] then the
  /// [prepared statement] statement is constructed to substitute
  /// a NULL value in place of the table column that would have
  /// been read if [SQLITE_OK] had been returned.  The [SQLITE_IGNORE]
  /// return can be used to deny an untrusted user access to individual
  /// columns of a table.
  /// ^When a table is referenced by a [SELECT] but no column values are
  /// extracted from that table (for example in a query like
  /// "SELECT count(*) FROM tab") then the [SQLITE_READ] authorizer callback
  /// is invoked once for that table with a column name that is an empty string.
  /// ^If the action code is [SQLITE_DELETE] and the callback returns
  /// [SQLITE_IGNORE] then the [DELETE] operation proceeds but the
  /// [truncate optimization] is disabled and all rows are deleted individually.
  ///
  /// An authorizer is used when [sqlite3_prepare | preparing]
  /// SQL statements from an untrusted source, to ensure that the SQL statements
  /// do not try to access data they are not allowed to see, or that they do not
  /// try to execute malicious statements that damage the database.  For
  /// example, an application may allow a user to enter arbitrary
  /// SQL queries for evaluation by a database.  But the application does
  /// not want the user to be able to make arbitrary changes to the
  /// database.  An authorizer could then be put in place while the
  /// user-entered SQL is being [sqlite3_prepare | prepared] that
  /// disallows everything except [SELECT] statements.
  ///
  /// Applications that need to process SQL from untrusted sources
  /// might also consider lowering resource limits using [sqlite3_limit()]
  /// and limiting database size using the [max_page_count] [PRAGMA]
  /// in addition to using an authorizer.
  ///
  /// ^(Only a single authorizer can be in place on a database connection
  /// at a time.  Each call to sqlite3_set_authorizer overrides the
  /// previous call.)^  ^Disable the authorizer by installing a NULL callback.
  /// The authorizer is disabled by default.
  ///
  /// The authorizer callback must not do anything that will modify
  /// the database connection that invoked the authorizer callback.
  /// Note that [sqlite3_prepare_v2()] and [sqlite3_step()] both modify their
  /// database connections for the meaning of "modify" in this paragraph.
  ///
  /// ^When [sqlite3_prepare_v2()] is used to prepare a statement, the
  /// statement might be re-prepared during [sqlite3_step()] due to a
  /// schema change.  Hence, the application should ensure that the
  /// correct authorizer callback remains in place during the [sqlite3_step()].
  ///
  /// ^Note that the authorizer callback is invoked only during
  /// [sqlite3_prepare()] or its variants.  Authorization is not
  /// performed during statement evaluation in [sqlite3_step()], unless
  /// as stated in the previous paragraph, sqlite3_step() invokes
  /// sqlite3_prepare_v2() to reprepare a statement after a schema change.
  int sqlite3_set_authorizer(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(
                    ffi.Pointer<ffi.Void>,
                    ffi.Int,
                    ffi.Pointer<ffi.Char>,
                    ffi.Pointer<ffi.Char>,
                    ffi.Pointer<ffi.Char>,
                    ffi.Pointer<ffi.Char>)>>
        xAuth,
    ffi.Pointer<ffi.Void> pUserData,
  ) {
    return _sqlite3_set_authorizer(
      arg0,
      xAuth,
      pUserData,
    );
  }

  late final _sqlite3_set_authorizerPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Char>,
                          ffi.Pointer<ffi.Char>,
                          ffi.Pointer<ffi.Char>,
                          ffi.Pointer<ffi.Char>)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_set_authorizer');
  late final _sqlite3_set_authorizer = _sqlite3_set_authorizerPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Int,
                      ffi.Pointer<ffi.Char>,
                      ffi.Pointer<ffi.Char>,
                      ffi.Pointer<ffi.Char>,
                      ffi.Pointer<ffi.Char>)>>,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Tracing And Profiling Functions
  /// METHOD: sqlite3
  ///
  /// These routines are deprecated. Use the [sqlite3_trace_v2()] interface
  /// instead of the routines described here.
  ///
  /// These routines register callback functions that can be used for
  /// tracing and profiling the execution of SQL statements.
  ///
  /// ^The callback function registered by sqlite3_trace() is invoked at
  /// various times when an SQL statement is being run by [sqlite3_step()].
  /// ^The sqlite3_trace() callback is invoked with a UTF-8 rendering of the
  /// SQL statement text as the statement first begins executing.
  /// ^(Additional sqlite3_trace() callbacks might occur
  /// as each triggered subprogram is entered.  The callbacks for triggers
  /// contain a UTF-8 SQL comment that identifies the trigger.)^
  ///
  /// The [SQLITE_TRACE_SIZE_LIMIT] compile-time option can be used to limit
  /// the length of [bound parameter] expansion in the output of sqlite3_trace().
  ///
  /// ^The callback function registered by sqlite3_profile() is invoked
  /// as each SQL statement finishes.  ^The profile callback contains
  /// the original statement text and an estimate of wall-clock time
  /// of how long that statement took to run.  ^The profile callback
  /// time is in units of nanoseconds, however the current implementation
  /// is only capable of millisecond resolution so the six least significant
  /// digits in the time are meaningless.  Future versions of SQLite
  /// might provide greater resolution on the profiler callback.  Invoking
  /// either [sqlite3_trace()] or [sqlite3_trace_v2()] will cancel the
  /// profile callback.
  ffi.Pointer<ffi.Void> sqlite3_trace(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(
                    ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Char>)>>
        xTrace,
    ffi.Pointer<ffi.Void> arg2,
  ) {
    return _sqlite3_trace(
      arg0,
      xTrace,
      arg2,
    );
  }

  late final _sqlite3_tracePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Char>)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_trace');
  late final _sqlite3_trace = _sqlite3_tracePtr.asFunction<
      ffi.Pointer<ffi.Void> Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Char>)>>,
          ffi.Pointer<ffi.Void>)>();

  ffi.Pointer<ffi.Void> sqlite3_profile(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Char>,
                    sqlite3_uint64)>>
        xProfile,
    ffi.Pointer<ffi.Void> arg2,
  ) {
    return _sqlite3_profile(
      arg0,
      xProfile,
      arg2,
    );
  }

  late final _sqlite3_profilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<ffi.Void>,
                          ffi.Pointer<ffi.Char>, sqlite3_uint64)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_profile');
  late final _sqlite3_profile = _sqlite3_profilePtr.asFunction<
      ffi.Pointer<ffi.Void> Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<ffi.Void>,
                      ffi.Pointer<ffi.Char>, sqlite3_uint64)>>,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: SQL Trace Hook
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_trace_v2(D,M,X,P) interface registers a trace callback
  /// function X against [database connection] D, using property mask M
  /// and context pointer P.  ^If the X callback is
  /// NULL or if the M mask is zero, then tracing is disabled.  The
  /// M argument should be the bitwise OR-ed combination of
  /// zero or more [SQLITE_TRACE] constants.
  ///
  /// ^Each call to either sqlite3_trace() or sqlite3_trace_v2() overrides
  /// (cancels) any prior calls to sqlite3_trace() or sqlite3_trace_v2().
  ///
  /// ^The X callback is invoked whenever any of the events identified by
  /// mask M occur.  ^The integer return value from the callback is currently
  /// ignored, though this may change in future releases.  Callback
  /// implementations should return zero to ensure future compatibility.
  ///
  /// ^A trace callback is invoked with four arguments: callback(T,C,P,X).
  /// ^The T argument is one of the [SQLITE_TRACE]
  /// constants to indicate why the callback was invoked.
  /// ^The C argument is a copy of the context pointer.
  /// The P and X arguments are pointers whose meanings depend on T.
  ///
  /// The sqlite3_trace_v2() interface is intended to replace the legacy
  /// interfaces [sqlite3_trace()] and [sqlite3_profile()], both of which
  /// are deprecated.
  int sqlite3_trace_v2(
    ffi.Pointer<sqlite3> arg0,
    int uMask,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(ffi.UnsignedInt, ffi.Pointer<ffi.Void>,
                    ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Void>)>>
        xCallback,
    ffi.Pointer<ffi.Void> pCtx,
  ) {
    return _sqlite3_trace_v2(
      arg0,
      uMask,
      xCallback,
      pCtx,
    );
  }

  late final _sqlite3_trace_v2Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.UnsignedInt,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(ffi.UnsignedInt, ffi.Pointer<ffi.Void>,
                          ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Void>)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_trace_v2');
  late final _sqlite3_trace_v2 = _sqlite3_trace_v2Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Int Function(ffi.UnsignedInt, ffi.Pointer<ffi.Void>,
                      ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Void>)>>,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Query Progress Callbacks
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_progress_handler(D,N,X,P) interface causes the callback
  /// function X to be invoked periodically during long running calls to
  /// [sqlite3_exec()], [sqlite3_step()] and [sqlite3_get_table()] for
  /// database connection D.  An example use for this
  /// interface is to keep a GUI updated during a large query.
  ///
  /// ^The parameter P is passed through as the only parameter to the
  /// callback function X.  ^The parameter N is the approximate number of
  /// [virtual machine instructions] that are evaluated between successive
  /// invocations of the callback X.  ^If N is less than one then the progress
  /// handler is disabled.
  ///
  /// ^Only a single progress handler may be defined at one time per
  /// [database connection]; setting a new progress handler cancels the
  /// old one.  ^Setting parameter X to NULL disables the progress handler.
  /// ^The progress handler is also disabled by setting N to a value less
  /// than 1.
  ///
  /// ^If the progress callback returns non-zero, the operation is
  /// interrupted.  This feature can be used to implement a
  /// "Cancel" button on a GUI progress dialog box.
  ///
  /// The progress handler callback must not do anything that will modify
  /// the database connection that invoked the progress handler.
  /// Note that [sqlite3_prepare_v2()] and [sqlite3_step()] both modify their
  /// database connections for the meaning of "modify" in this paragraph.
  void sqlite3_progress_handler(
    ffi.Pointer<sqlite3> arg0,
    int arg1,
    ffi.Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>
        arg2,
    ffi.Pointer<ffi.Void> arg3,
  ) {
    return _sqlite3_progress_handler(
      arg0,
      arg1,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_progress_handlerPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3>,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_progress_handler');
  late final _sqlite3_progress_handler =
      _sqlite3_progress_handlerPtr.asFunction<
          void Function(
              ffi.Pointer<sqlite3>,
              int,
              ffi.Pointer<
                  ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>,
              ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Opening A New Database Connection
  /// CONSTRUCTOR: sqlite3
  ///
  /// ^These routines open an SQLite database file as specified by the
  /// filename argument. ^The filename argument is interpreted as UTF-8 for
  /// sqlite3_open() and sqlite3_open_v2() and as UTF-16 in the native byte
  /// order for sqlite3_open16(). ^(A [database connection] handle is usually
  /// returned in *ppDb, even if an error occurs.  The only exception is that
  /// if SQLite is unable to allocate memory to hold the [sqlite3] object,
  /// a NULL will be written into *ppDb instead of a pointer to the [sqlite3]
  /// object.)^ ^(If the database is opened (and/or created) successfully, then
  /// [SQLITE_OK] is returned.  Otherwise an [error code] is returned.)^ ^The
  /// [sqlite3_errmsg()] or [sqlite3_errmsg16()] routines can be used to obtain
  /// an English language description of the error following a failure of any
  /// of the sqlite3_open() routines.
  ///
  /// ^The default encoding will be UTF-8 for databases created using
  /// sqlite3_open() or sqlite3_open_v2().  ^The default encoding for databases
  /// created using sqlite3_open16() will be UTF-16 in the native byte order.
  ///
  /// Whether or not an error occurs when it is opened, resources
  /// associated with the [database connection] handle should be released by
  /// passing it to [sqlite3_close()] when it is no longer required.
  ///
  /// The sqlite3_open_v2() interface works like sqlite3_open()
  /// except that it accepts two additional parameters for additional control
  /// over the new database connection.  ^(The flags parameter to
  /// sqlite3_open_v2() must include, at a minimum, one of the following
  /// three flag combinations:)^
  ///
  /// <dl>
  /// ^(<dt>[SQLITE_OPEN_READONLY]</dt>
  /// <dd>The database is opened in read-only mode.  If the database does not
  /// already exist, an error is returned.</dd>)^
  ///
  /// ^(<dt>[SQLITE_OPEN_READWRITE]</dt>
  /// <dd>The database is opened for reading and writing if possible, or reading
  /// only if the file is write protected by the operating system.  In either
  /// case the database must already exist, otherwise an error is returned.</dd>)^
  ///
  /// ^(<dt>[SQLITE_OPEN_READWRITE] | [SQLITE_OPEN_CREATE]</dt>
  /// <dd>The database is opened for reading and writing, and is created if
  /// it does not already exist. This is the behavior that is always used for
  /// sqlite3_open() and sqlite3_open16().</dd>)^
  /// </dl>
  ///
  /// In addition to the required flags, the following optional flags are
  /// also supported:
  ///
  /// <dl>
  /// ^(<dt>[SQLITE_OPEN_URI]</dt>
  /// <dd>The filename can be interpreted as a URI if this flag is set.</dd>)^
  ///
  /// ^(<dt>[SQLITE_OPEN_MEMORY]</dt>
  /// <dd>The database will be opened as an in-memory database.  The database
  /// is named by the "filename" argument for the purposes of cache-sharing,
  /// if shared cache mode is enabled, but the "filename" is otherwise ignored.
  /// </dd>)^
  ///
  /// ^(<dt>[SQLITE_OPEN_NOMUTEX]</dt>
  /// <dd>The new database connection will use the "multi-thread"
  /// [threading mode].)^  This means that separate threads are allowed
  /// to use SQLite at the same time, as long as each thread is using
  /// a different [database connection].
  ///
  /// ^(<dt>[SQLITE_OPEN_FULLMUTEX]</dt>
  /// <dd>The new database connection will use the "serialized"
  /// [threading mode].)^  This means the multiple threads can safely
  /// attempt to use the same database connection at the same time.
  /// (Mutexes will block any actual concurrency, but in this mode
  /// there is no harm in trying.)
  ///
  /// ^(<dt>[SQLITE_OPEN_SHAREDCACHE]</dt>
  /// <dd>The database is opened [shared cache] enabled, overriding
  /// the default shared cache setting provided by
  /// [sqlite3_enable_shared_cache()].)^
  ///
  /// ^(<dt>[SQLITE_OPEN_PRIVATECACHE]</dt>
  /// <dd>The database is opened [shared cache] disabled, overriding
  /// the default shared cache setting provided by
  /// [sqlite3_enable_shared_cache()].)^
  ///
  /// [[OPEN_NOFOLLOW]] ^(<dt>[SQLITE_OPEN_NOFOLLOW]</dt>
  /// <dd>The database filename is not allowed to be a symbolic link</dd>
  /// </dl>)^
  ///
  /// If the 3rd parameter to sqlite3_open_v2() is not one of the
  /// required combinations shown above optionally combined with other
  /// [SQLITE_OPEN_READONLY | SQLITE_OPEN_* bits]
  /// then the behavior is undefined.
  ///
  /// ^The fourth parameter to sqlite3_open_v2() is the name of the
  /// [sqlite3_vfs] object that defines the operating system interface that
  /// the new database connection should use.  ^If the fourth parameter is
  /// a NULL pointer then the default [sqlite3_vfs] object is used.
  ///
  /// ^If the filename is ":memory:", then a private, temporary in-memory database
  /// is created for the connection.  ^This in-memory database will vanish when
  /// the database connection is closed.  Future versions of SQLite might
  /// make use of additional special filenames that begin with the ":" character.
  /// It is recommended that when a database filename actually does begin with
  /// a ":" character you should prefix the filename with a pathname such as
  /// "./" to avoid ambiguity.
  ///
  /// ^If the filename is an empty string, then a private, temporary
  /// on-disk database will be created.  ^This private database will be
  /// automatically deleted as soon as the database connection is closed.
  ///
  /// [[URI filenames in sqlite3_open()]] <h3>URI Filenames</h3>
  ///
  /// ^If [URI filename] interpretation is enabled, and the filename argument
  /// begins with "file:", then the filename is interpreted as a URI. ^URI
  /// filename interpretation is enabled if the [SQLITE_OPEN_URI] flag is
  /// set in the third argument to sqlite3_open_v2(), or if it has
  /// been enabled globally using the [SQLITE_CONFIG_URI] option with the
  /// [sqlite3_config()] method or by the [SQLITE_USE_URI] compile-time option.
  /// URI filename interpretation is turned off
  /// by default, but future releases of SQLite might enable URI filename
  /// interpretation by default.  See "[URI filenames]" for additional
  /// information.
  ///
  /// URI filenames are parsed according to RFC 3986. ^If the URI contains an
  /// authority, then it must be either an empty string or the string
  /// "localhost". ^If the authority is not an empty string or "localhost", an
  /// error is returned to the caller. ^The fragment component of a URI, if
  /// present, is ignored.
  ///
  /// ^SQLite uses the path component of the URI as the name of the disk file
  /// which contains the database. ^If the path begins with a '/' character,
  /// then it is interpreted as an absolute path. ^If the path does not begin
  /// with a '/' (meaning that the authority section is omitted from the URI)
  /// then the path is interpreted as a relative path.
  /// ^(On windows, the first component of an absolute path
  /// is a drive specification (e.g. "C:").)^
  ///
  /// [[core URI query parameters]]
  /// The query component of a URI may contain parameters that are interpreted
  /// either by SQLite itself, or by a [VFS | custom VFS implementation].
  /// SQLite and its built-in [VFSes] interpret the
  /// following query parameters:
  ///
  /// <ul>
  /// <li> <b>vfs</b>: ^The "vfs" parameter may be used to specify the name of
  /// a VFS object that provides the operating system interface that should
  /// be used to access the database file on disk. ^If this option is set to
  /// an empty string the default VFS object is used. ^Specifying an unknown
  /// VFS is an error. ^If sqlite3_open_v2() is used and the vfs option is
  /// present, then the VFS specified by the option takes precedence over
  /// the value passed as the fourth parameter to sqlite3_open_v2().
  ///
  /// <li> <b>mode</b>: ^(The mode parameter may be set to either "ro", "rw",
  /// "rwc", or "memory". Attempting to set it to any other value is
  /// an error)^.
  /// ^If "ro" is specified, then the database is opened for read-only
  /// access, just as if the [SQLITE_OPEN_READONLY] flag had been set in the
  /// third argument to sqlite3_open_v2(). ^If the mode option is set to
  /// "rw", then the database is opened for read-write (but not create)
  /// access, as if SQLITE_OPEN_READWRITE (but not SQLITE_OPEN_CREATE) had
  /// been set. ^Value "rwc" is equivalent to setting both
  /// SQLITE_OPEN_READWRITE and SQLITE_OPEN_CREATE.  ^If the mode option is
  /// set to "memory" then a pure [in-memory database] that never reads
  /// or writes from disk is used. ^It is an error to specify a value for
  /// the mode parameter that is less restrictive than that specified by
  /// the flags passed in the third parameter to sqlite3_open_v2().
  ///
  /// <li> <b>cache</b>: ^The cache parameter may be set to either "shared" or
  /// "private". ^Setting it to "shared" is equivalent to setting the
  /// SQLITE_OPEN_SHAREDCACHE bit in the flags argument passed to
  /// sqlite3_open_v2(). ^Setting the cache parameter to "private" is
  /// equivalent to setting the SQLITE_OPEN_PRIVATECACHE bit.
  /// ^If sqlite3_open_v2() is used and the "cache" parameter is present in
  /// a URI filename, its value overrides any behavior requested by setting
  /// SQLITE_OPEN_PRIVATECACHE or SQLITE_OPEN_SHAREDCACHE flag.
  ///
  /// <li> <b>psow</b>: ^The psow parameter indicates whether or not the
  /// [powersafe overwrite] property does or does not apply to the
  /// storage media on which the database file resides.
  ///
  /// <li> <b>nolock</b>: ^The nolock parameter is a boolean query parameter
  /// which if set disables file locking in rollback journal modes.  This
  /// is useful for accessing a database on a filesystem that does not
  /// support locking.  Caution:  Database corruption might result if two
  /// or more processes write to the same database and any one of those
  /// processes uses nolock=1.
  ///
  /// <li> <b>immutable</b>: ^The immutable parameter is a boolean query
  /// parameter that indicates that the database file is stored on
  /// read-only media.  ^When immutable is set, SQLite assumes that the
  /// database file cannot be changed, even by a process with higher
  /// privilege, and so the database is opened read-only and all locking
  /// and change detection is disabled.  Caution: Setting the immutable
  /// property on a database file that does in fact change can result
  /// in incorrect query results and/or [SQLITE_CORRUPT] errors.
  /// See also: [SQLITE_IOCAP_IMMUTABLE].
  ///
  /// </ul>
  ///
  /// ^Specifying an unknown parameter in the query component of a URI is not an
  /// error.  Future versions of SQLite might understand additional query
  /// parameters.  See "[query parameters with special meaning to SQLite]" for
  /// additional information.
  ///
  /// [[URI filename examples]] <h3>URI filename examples</h3>
  ///
  /// <table border="1" align=center cellpadding=5>
  /// <tr><th> URI filenames <th> Results
  /// <tr><td> file:data.db <td>
  /// Open the file "data.db" in the current directory.
  /// <tr><td> file:/home/fred/data.db<br>
  /// file:///home/fred/data.db <br>
  /// file://localhost/home/fred/data.db <br> <td>
  /// Open the database file "/home/fred/data.db".
  /// <tr><td> file://darkstar/home/fred/data.db <td>
  /// An error. "darkstar" is not a recognized authority.
  /// <tr><td style="white-space:nowrap">
  /// file:///C:/Documents%20and%20Settings/fred/Desktop/data.db
  /// <td> Windows only: Open the file "data.db" on fred's desktop on drive
  /// C:. Note that the %20 escaping in this example is not strictly
  /// necessary - space characters can be used literally
  /// in URI filenames.
  /// <tr><td> file:data.db?mode=ro&cache=private <td>
  /// Open file "data.db" in the current directory for read-only access.
  /// Regardless of whether or not shared-cache mode is enabled by
  /// default, use a private cache.
  /// <tr><td> file:/home/fred/data.db?vfs=unix-dotfile <td>
  /// Open file "/home/fred/data.db". Use the special VFS "unix-dotfile"
  /// that uses dot-files in place of posix advisory locking.
  /// <tr><td> file:data.db?mode=readonly <td>
  /// An error. "readonly" is not a valid option for the "mode" parameter.
  /// </table>
  ///
  /// ^URI hexadecimal escape sequences (%HH) are supported within the path and
  /// query components of a URI. A hexadecimal escape sequence consists of a
  /// percent sign - "%" - followed by exactly two hexadecimal digits
  /// specifying an octet value. ^Before the path or query components of a
  /// URI filename are interpreted, they are encoded using UTF-8 and all
  /// hexadecimal escape sequences replaced by a single byte containing the
  /// corresponding octet. If this process generates an invalid UTF-8 encoding,
  /// the results are undefined.
  ///
  /// <b>Note to Windows users:</b>  The encoding used for the filename argument
  /// of sqlite3_open() and sqlite3_open_v2() must be UTF-8, not whatever
  /// codepage is currently defined.  Filenames containing international
  /// characters must be converted to UTF-8 prior to passing them into
  /// sqlite3_open() or sqlite3_open_v2().
  ///
  /// <b>Note to Windows Runtime users:</b>  The temporary directory must be set
  /// prior to calling sqlite3_open() or sqlite3_open_v2().  Otherwise, various
  /// features that require the use of temporary files may fail.
  ///
  /// See also: [sqlite3_temp_directory]
  int sqlite3_open(
    ffi.Pointer<ffi.Char> filename,
    ffi.Pointer<ffi.Pointer<sqlite3>> ppDb,
  ) {
    return _sqlite3_open(
      filename,
      ppDb,
    );
  }

  late final _sqlite3_openPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Pointer<sqlite3>>)>>('sqlite3_open');
  late final _sqlite3_open = _sqlite3_openPtr.asFunction<
      int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Pointer<sqlite3>>)>();

  int sqlite3_open16(
    ffi.Pointer<ffi.Void> filename,
    ffi.Pointer<ffi.Pointer<sqlite3>> ppDb,
  ) {
    return _sqlite3_open16(
      filename,
      ppDb,
    );
  }

  late final _sqlite3_open16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Void>,
              ffi.Pointer<ffi.Pointer<sqlite3>>)>>('sqlite3_open16');
  late final _sqlite3_open16 = _sqlite3_open16Ptr.asFunction<
      int Function(ffi.Pointer<ffi.Void>, ffi.Pointer<ffi.Pointer<sqlite3>>)>();

  int sqlite3_open_v2(
    ffi.Pointer<ffi.Char> filename,
    ffi.Pointer<ffi.Pointer<sqlite3>> ppDb,
    int flags,
    ffi.Pointer<ffi.Char> zVfs,
  ) {
    return _sqlite3_open_v2(
      filename,
      ppDb,
      flags,
      zVfs,
    );
  }

  late final _sqlite3_open_v2Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Pointer<sqlite3>>,
              ffi.Int,
              ffi.Pointer<ffi.Char>)>>('sqlite3_open_v2');
  late final _sqlite3_open_v2 = _sqlite3_open_v2Ptr.asFunction<
      int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Pointer<sqlite3>>,
          int, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Obtain Values For URI Parameters
  ///
  /// These are utility routines, useful to [VFS|custom VFS implementations],
  /// that check if a database file was a URI that contained a specific query
  /// parameter, and if so obtains the value of that query parameter.
  ///
  /// The first parameter to these interfaces (hereafter referred to
  /// as F) must be one of:
  /// <ul>
  /// <li> A database filename pointer created by the SQLite core and
  /// passed into the xOpen() method of a VFS implemention, or
  /// <li> A filename obtained from [sqlite3_db_filename()], or
  /// <li> A new filename constructed using [sqlite3_create_filename()].
  /// </ul>
  /// If the F parameter is not one of the above, then the behavior is
  /// undefined and probably undesirable.  Older versions of SQLite were
  /// more tolerant of invalid F parameters than newer versions.
  ///
  /// If F is a suitable filename (as described in the previous paragraph)
  /// and if P is the name of the query parameter, then
  /// sqlite3_uri_parameter(F,P) returns the value of the P
  /// parameter if it exists or a NULL pointer if P does not appear as a
  /// query parameter on F.  If P is a query parameter of F and it
  /// has no explicit value, then sqlite3_uri_parameter(F,P) returns
  /// a pointer to an empty string.
  ///
  /// The sqlite3_uri_boolean(F,P,B) routine assumes that P is a boolean
  /// parameter and returns true (1) or false (0) according to the value
  /// of P.  The sqlite3_uri_boolean(F,P,B) routine returns true (1) if the
  /// value of query parameter P is one of "yes", "true", or "on" in any
  /// case or if the value begins with a non-zero number.  The
  /// sqlite3_uri_boolean(F,P,B) routines returns false (0) if the value of
  /// query parameter P is one of "no", "false", or "off" in any case or
  /// if the value begins with a numeric zero.  If P is not a query
  /// parameter on F or if the value of P does not match any of the
  /// above, then sqlite3_uri_boolean(F,P,B) returns (B!=0).
  ///
  /// The sqlite3_uri_int64(F,P,D) routine converts the value of P into a
  /// 64-bit signed integer and returns that integer, or D if P does not
  /// exist.  If the value of P is something other than an integer, then
  /// zero is returned.
  ///
  /// The sqlite3_uri_key(F,N) returns a pointer to the name (not
  /// the value) of the N-th query parameter for filename F, or a NULL
  /// pointer if N is less than zero or greater than the number of query
  /// parameters minus 1.  The N value is zero-based so N should be 0 to obtain
  /// the name of the first query parameter, 1 for the second parameter, and
  /// so forth.
  ///
  /// If F is a NULL pointer, then sqlite3_uri_parameter(F,P) returns NULL and
  /// sqlite3_uri_boolean(F,P,B) returns B.  If F is not a NULL pointer and
  /// is not a database file pathname pointer that the SQLite core passed
  /// into the xOpen VFS method, then the behavior of this routine is undefined
  /// and probably undesirable.
  ///
  /// Beginning with SQLite [version 3.31.0] ([dateof:3.31.0]) the input F
  /// parameter can also be the name of a rollback journal file or WAL file
  /// in addition to the main database file.  Prior to version 3.31.0, these
  /// routines would only work if F was the name of the main database file.
  /// When the F parameter is the name of the rollback journal or WAL file,
  /// it has access to all the same query parameters as were found on the
  /// main database file.
  ///
  /// See the [URI filename] documentation for additional information.
  ffi.Pointer<ffi.Char> sqlite3_uri_parameter(
    ffi.Pointer<ffi.Char> zFilename,
    ffi.Pointer<ffi.Char> zParam,
  ) {
    return _sqlite3_uri_parameter(
      zFilename,
      zParam,
    );
  }

  late final _sqlite3_uri_parameterPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_uri_parameter');
  late final _sqlite3_uri_parameter = _sqlite3_uri_parameterPtr.asFunction<
      ffi.Pointer<ffi.Char> Function(
          ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>();

  int sqlite3_uri_boolean(
    ffi.Pointer<ffi.Char> zFile,
    ffi.Pointer<ffi.Char> zParam,
    int bDefault,
  ) {
    return _sqlite3_uri_boolean(
      zFile,
      zParam,
      bDefault,
    );
  }

  late final _sqlite3_uri_booleanPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Int)>>('sqlite3_uri_boolean');
  late final _sqlite3_uri_boolean = _sqlite3_uri_booleanPtr.asFunction<
      int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>, int)>();

  int sqlite3_uri_int64(
    ffi.Pointer<ffi.Char> arg0,
    ffi.Pointer<ffi.Char> arg1,
    int arg2,
  ) {
    return _sqlite3_uri_int64(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_uri_int64Ptr = _lookup<
      ffi.NativeFunction<
          sqlite3_int64 Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              sqlite3_int64)>>('sqlite3_uri_int64');
  late final _sqlite3_uri_int64 = _sqlite3_uri_int64Ptr.asFunction<
      int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>, int)>();

  ffi.Pointer<ffi.Char> sqlite3_uri_key(
    ffi.Pointer<ffi.Char> zFilename,
    int N,
  ) {
    return _sqlite3_uri_key(
      zFilename,
      N,
    );
  }

  late final _sqlite3_uri_keyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<ffi.Char>, ffi.Int)>>('sqlite3_uri_key');
  late final _sqlite3_uri_key = _sqlite3_uri_keyPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<ffi.Char>, int)>();

  /// CAPI3REF:  Translate filenames
  ///
  /// These routines are available to [VFS|custom VFS implementations] for
  /// translating filenames between the main database file, the journal file,
  /// and the WAL file.
  ///
  /// If F is the name of an sqlite database file, journal file, or WAL file
  /// passed by the SQLite core into the VFS, then sqlite3_filename_database(F)
  /// returns the name of the corresponding database file.
  ///
  /// If F is the name of an sqlite database file, journal file, or WAL file
  /// passed by the SQLite core into the VFS, or if F is a database filename
  /// obtained from [sqlite3_db_filename()], then sqlite3_filename_journal(F)
  /// returns the name of the corresponding rollback journal file.
  ///
  /// If F is the name of an sqlite database file, journal file, or WAL file
  /// that was passed by the SQLite core into the VFS, or if F is a database
  /// filename obtained from [sqlite3_db_filename()], then
  /// sqlite3_filename_wal(F) returns the name of the corresponding
  /// WAL file.
  ///
  /// In all of the above, if F is not the name of a database, journal or WAL
  /// filename passed into the VFS from the SQLite core and F is not the
  /// return value from [sqlite3_db_filename()], then the result is
  /// undefined and is likely a memory access violation.
  ffi.Pointer<ffi.Char> sqlite3_filename_database(
    ffi.Pointer<ffi.Char> arg0,
  ) {
    return _sqlite3_filename_database(
      arg0,
    );
  }

  late final _sqlite3_filename_databasePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<ffi.Char>)>>('sqlite3_filename_database');
  late final _sqlite3_filename_database = _sqlite3_filename_databasePtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<ffi.Char>)>();

  ffi.Pointer<ffi.Char> sqlite3_filename_journal(
    ffi.Pointer<ffi.Char> arg0,
  ) {
    return _sqlite3_filename_journal(
      arg0,
    );
  }

  late final _sqlite3_filename_journalPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<ffi.Char>)>>('sqlite3_filename_journal');
  late final _sqlite3_filename_journal = _sqlite3_filename_journalPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<ffi.Char>)>();

  ffi.Pointer<ffi.Char> sqlite3_filename_wal(
    ffi.Pointer<ffi.Char> arg0,
  ) {
    return _sqlite3_filename_wal(
      arg0,
    );
  }

  late final _sqlite3_filename_walPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<ffi.Char>)>>('sqlite3_filename_wal');
  late final _sqlite3_filename_wal = _sqlite3_filename_walPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF:  Database File Corresponding To A Journal
  ///
  /// ^If X is the name of a rollback or WAL-mode journal file that is
  /// passed into the xOpen method of [sqlite3_vfs], then
  /// sqlite3_database_file_object(X) returns a pointer to the [sqlite3_file]
  /// object that represents the main database file.
  ///
  /// This routine is intended for use in custom [VFS] implementations
  /// only.  It is not a general-purpose interface.
  /// The argument sqlite3_file_object(X) must be a filename pointer that
  /// has been passed into [sqlite3_vfs].xOpen method where the
  /// flags parameter to xOpen contains one of the bits
  /// [SQLITE_OPEN_MAIN_JOURNAL] or [SQLITE_OPEN_WAL].  Any other use
  /// of this routine results in undefined and probably undesirable
  /// behavior.
  ffi.Pointer<sqlite3_file> sqlite3_database_file_object(
    ffi.Pointer<ffi.Char> arg0,
  ) {
    return _sqlite3_database_file_object(
      arg0,
    );
  }

  late final _sqlite3_database_file_objectPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_file> Function(
              ffi.Pointer<ffi.Char>)>>('sqlite3_database_file_object');
  late final _sqlite3_database_file_object = _sqlite3_database_file_objectPtr
      .asFunction<ffi.Pointer<sqlite3_file> Function(ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Create and Destroy VFS Filenames
  ///
  /// These interfces are provided for use by [VFS shim] implementations and
  /// are not useful outside of that context.
  ///
  /// The sqlite3_create_filename(D,J,W,N,P) allocates memory to hold a version of
  /// database filename D with corresponding journal file J and WAL file W and
  /// with N URI parameters key/values pairs in the array P.  The result from
  /// sqlite3_create_filename(D,J,W,N,P) is a pointer to a database filename that
  /// is safe to pass to routines like:
  /// <ul>
  /// <li> [sqlite3_uri_parameter()],
  /// <li> [sqlite3_uri_boolean()],
  /// <li> [sqlite3_uri_int64()],
  /// <li> [sqlite3_uri_key()],
  /// <li> [sqlite3_filename_database()],
  /// <li> [sqlite3_filename_journal()], or
  /// <li> [sqlite3_filename_wal()].
  /// </ul>
  /// If a memory allocation error occurs, sqlite3_create_filename() might
  /// return a NULL pointer.  The memory obtained from sqlite3_create_filename(X)
  /// must be released by a corresponding call to sqlite3_free_filename(Y).
  ///
  /// The P parameter in sqlite3_create_filename(D,J,W,N,P) should be an array
  /// of 2*N pointers to strings.  Each pair of pointers in this array corresponds
  /// to a key and value for a query parameter.  The P parameter may be a NULL
  /// pointer if N is zero.  None of the 2*N pointers in the P array may be
  /// NULL pointers and key pointers should not be empty strings.
  /// None of the D, J, or W parameters to sqlite3_create_filename(D,J,W,N,P) may
  /// be NULL pointers, though they can be empty strings.
  ///
  /// The sqlite3_free_filename(Y) routine releases a memory allocation
  /// previously obtained from sqlite3_create_filename().  Invoking
  /// sqlite3_free_filename(Y) where Y is a NULL pointer is a harmless no-op.
  ///
  /// If the Y parameter to sqlite3_free_filename(Y) is anything other
  /// than a NULL pointer or a pointer previously acquired from
  /// sqlite3_create_filename(), then bad things such as heap
  /// corruption or segfaults may occur. The value Y should be
  /// used again after sqlite3_free_filename(Y) has been called.  This means
  /// that if the [sqlite3_vfs.xOpen()] method of a VFS has been called using Y,
  /// then the corresponding [sqlite3_module.xClose() method should also be
  /// invoked prior to calling sqlite3_free_filename(Y).
  ffi.Pointer<ffi.Char> sqlite3_create_filename(
    ffi.Pointer<ffi.Char> zDatabase,
    ffi.Pointer<ffi.Char> zJournal,
    ffi.Pointer<ffi.Char> zWal,
    int nParam,
    ffi.Pointer<ffi.Pointer<ffi.Char>> azParam,
  ) {
    return _sqlite3_create_filename(
      zDatabase,
      zJournal,
      zWal,
      nParam,
      azParam,
    );
  }

  late final _sqlite3_create_filenamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_create_filename');
  late final _sqlite3_create_filename = _sqlite3_create_filenamePtr.asFunction<
      ffi.Pointer<ffi.Char> Function(
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          int,
          ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  void sqlite3_free_filename(
    ffi.Pointer<ffi.Char> arg0,
  ) {
    return _sqlite3_free_filename(
      arg0,
    );
  }

  late final _sqlite3_free_filenamePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Char>)>>(
          'sqlite3_free_filename');
  late final _sqlite3_free_filename = _sqlite3_free_filenamePtr
      .asFunction<void Function(ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Error Codes And Messages
  /// METHOD: sqlite3
  ///
  /// ^If the most recent sqlite3_* API call associated with
  /// [database connection] D failed, then the sqlite3_errcode(D) interface
  /// returns the numeric [result code] or [extended result code] for that
  /// API call.
  /// ^The sqlite3_extended_errcode()
  /// interface is the same except that it always returns the
  /// [extended result code] even when extended result codes are
  /// disabled.
  ///
  /// The values returned by sqlite3_errcode() and/or
  /// sqlite3_extended_errcode() might change with each API call.
  /// Except, there are some interfaces that are guaranteed to never
  /// change the value of the error code.  The error-code preserving
  /// interfaces are:
  ///
  /// <ul>
  /// <li> sqlite3_errcode()
  /// <li> sqlite3_extended_errcode()
  /// <li> sqlite3_errmsg()
  /// <li> sqlite3_errmsg16()
  /// </ul>
  ///
  /// ^The sqlite3_errmsg() and sqlite3_errmsg16() return English-language
  /// text that describes the error, as either UTF-8 or UTF-16 respectively.
  /// ^(Memory to hold the error message string is managed internally.
  /// The application does not need to worry about freeing the result.
  /// However, the error string might be overwritten or deallocated by
  /// subsequent calls to other SQLite interface functions.)^
  ///
  /// ^The sqlite3_errstr() interface returns the English-language text
  /// that describes the [result code], as UTF-8.
  /// ^(Memory to hold the error message string is managed internally
  /// and must not be freed by the application)^.
  ///
  /// When the serialized [threading mode] is in use, it might be the
  /// case that a second error occurs on a separate thread in between
  /// the time of the first error and the call to these interfaces.
  /// When that happens, the second error will be reported since these
  /// interfaces always report the most recent result.  To avoid
  /// this, each thread can obtain exclusive use of the [database connection] D
  /// by invoking [sqlite3_mutex_enter]([sqlite3_db_mutex](D)) before beginning
  /// to use D and invoking [sqlite3_mutex_leave]([sqlite3_db_mutex](D)) after
  /// all calls to the interfaces listed here are completed.
  ///
  /// If an interface fails with SQLITE_MISUSE, that means the interface
  /// was invoked incorrectly by the application.  In that case, the
  /// error code and message may or may not be set.
  int sqlite3_errcode(
    ffi.Pointer<sqlite3> db,
  ) {
    return _sqlite3_errcode(
      db,
    );
  }

  late final _sqlite3_errcodePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_errcode');
  late final _sqlite3_errcode =
      _sqlite3_errcodePtr.asFunction<int Function(ffi.Pointer<sqlite3>)>();

  int sqlite3_extended_errcode(
    ffi.Pointer<sqlite3> db,
  ) {
    return _sqlite3_extended_errcode(
      db,
    );
  }

  late final _sqlite3_extended_errcodePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_extended_errcode');
  late final _sqlite3_extended_errcode = _sqlite3_extended_errcodePtr
      .asFunction<int Function(ffi.Pointer<sqlite3>)>();

  ffi.Pointer<ffi.Char> sqlite3_errmsg(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_errmsg(
      arg0,
    );
  }

  late final _sqlite3_errmsgPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<sqlite3>)>>('sqlite3_errmsg');
  late final _sqlite3_errmsg = _sqlite3_errmsgPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3>)>();

  ffi.Pointer<ffi.Void> sqlite3_errmsg16(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_errmsg16(
      arg0,
    );
  }

  late final _sqlite3_errmsg16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3>)>>('sqlite3_errmsg16');
  late final _sqlite3_errmsg16 = _sqlite3_errmsg16Ptr
      .asFunction<ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3>)>();

  ffi.Pointer<ffi.Char> sqlite3_errstr(
    int arg0,
  ) {
    return _sqlite3_errstr(
      arg0,
    );
  }

  late final _sqlite3_errstrPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'sqlite3_errstr');
  late final _sqlite3_errstr =
      _sqlite3_errstrPtr.asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// CAPI3REF: Run-time Limits
  /// METHOD: sqlite3
  ///
  /// ^(This interface allows the size of various constructs to be limited
  /// on a connection by connection basis.  The first parameter is the
  /// [database connection] whose limit is to be set or queried.  The
  /// second parameter is one of the [limit categories] that define a
  /// class of constructs to be size limited.  The third parameter is the
  /// new limit for that construct.)^
  ///
  /// ^If the new limit is a negative number, the limit is unchanged.
  /// ^(For each limit category SQLITE_LIMIT_<i>NAME</i> there is a
  /// [limits | hard upper bound]
  /// set at compile-time by a C preprocessor macro called
  /// [limits | SQLITE_MAX_<i>NAME</i>].
  /// (The "_LIMIT_" in the name is changed to "_MAX_".))^
  /// ^Attempts to increase a limit above its hard upper bound are
  /// silently truncated to the hard upper bound.
  ///
  /// ^Regardless of whether or not the limit was changed, the
  /// [sqlite3_limit()] interface returns the prior value of the limit.
  /// ^Hence, to find the current value of a limit without changing it,
  /// simply invoke this interface with the third parameter set to -1.
  ///
  /// Run-time limits are intended for use in applications that manage
  /// both their own internal database and also databases that are controlled
  /// by untrusted external sources.  An example application might be a
  /// web browser that has its own databases for storing history and
  /// separate databases controlled by JavaScript applications downloaded
  /// off the Internet.  The internal databases can be given the
  /// large, default limits.  Databases managed by external sources can
  /// be given much smaller limits designed to prevent a denial of service
  /// attack.  Developers might also want to use the [sqlite3_set_authorizer()]
  /// interface to further control untrusted SQL.  The size of the database
  /// created by an untrusted script can be contained using the
  /// [max_page_count] [PRAGMA].
  ///
  /// New run-time limit categories may be added in future releases.
  int sqlite3_limit(
    ffi.Pointer<sqlite3> arg0,
    int id,
    int newVal,
  ) {
    return _sqlite3_limit(
      arg0,
      id,
      newVal,
    );
  }

  late final _sqlite3_limitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>, ffi.Int, ffi.Int)>>('sqlite3_limit');
  late final _sqlite3_limit = _sqlite3_limitPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, int, int)>();

  /// CAPI3REF: Compiling An SQL Statement
  /// KEYWORDS: {SQL statement compiler}
  /// METHOD: sqlite3
  /// CONSTRUCTOR: sqlite3_stmt
  ///
  /// To execute an SQL statement, it must first be compiled into a byte-code
  /// program using one of these routines.  Or, in other words, these routines
  /// are constructors for the [prepared statement] object.
  ///
  /// The preferred routine to use is [sqlite3_prepare_v2()].  The
  /// [sqlite3_prepare()] interface is legacy and should be avoided.
  /// [sqlite3_prepare_v3()] has an extra "prepFlags" option that is used
  /// for special purposes.
  ///
  /// The use of the UTF-8 interfaces is preferred, as SQLite currently
  /// does all parsing using UTF-8.  The UTF-16 interfaces are provided
  /// as a convenience.  The UTF-16 interfaces work by converting the
  /// input text into UTF-8, then invoking the corresponding UTF-8 interface.
  ///
  /// The first argument, "db", is a [database connection] obtained from a
  /// prior successful call to [sqlite3_open()], [sqlite3_open_v2()] or
  /// [sqlite3_open16()].  The database connection must not have been closed.
  ///
  /// The second argument, "zSql", is the statement to be compiled, encoded
  /// as either UTF-8 or UTF-16.  The sqlite3_prepare(), sqlite3_prepare_v2(),
  /// and sqlite3_prepare_v3()
  /// interfaces use UTF-8, and sqlite3_prepare16(), sqlite3_prepare16_v2(),
  /// and sqlite3_prepare16_v3() use UTF-16.
  ///
  /// ^If the nByte argument is negative, then zSql is read up to the
  /// first zero terminator. ^If nByte is positive, then it is the
  /// number of bytes read from zSql.  ^If nByte is zero, then no prepared
  /// statement is generated.
  /// If the caller knows that the supplied string is nul-terminated, then
  /// there is a small performance advantage to passing an nByte parameter that
  /// is the number of bytes in the input string <i>including</i>
  /// the nul-terminator.
  ///
  /// ^If pzTail is not NULL then *pzTail is made to point to the first byte
  /// past the end of the first SQL statement in zSql.  These routines only
  /// compile the first statement in zSql, so *pzTail is left pointing to
  /// what remains uncompiled.
  ///
  /// ^*ppStmt is left pointing to a compiled [prepared statement] that can be
  /// executed using [sqlite3_step()].  ^If there is an error, *ppStmt is set
  /// to NULL.  ^If the input text contains no SQL (if the input is an empty
  /// string or a comment) then *ppStmt is set to NULL.
  /// The calling procedure is responsible for deleting the compiled
  /// SQL statement using [sqlite3_finalize()] after it has finished with it.
  /// ppStmt may not be NULL.
  ///
  /// ^On success, the sqlite3_prepare() family of routines return [SQLITE_OK];
  /// otherwise an [error code] is returned.
  ///
  /// The sqlite3_prepare_v2(), sqlite3_prepare_v3(), sqlite3_prepare16_v2(),
  /// and sqlite3_prepare16_v3() interfaces are recommended for all new programs.
  /// The older interfaces (sqlite3_prepare() and sqlite3_prepare16())
  /// are retained for backwards compatibility, but their use is discouraged.
  /// ^In the "vX" interfaces, the prepared statement
  /// that is returned (the [sqlite3_stmt] object) contains a copy of the
  /// original SQL text. This causes the [sqlite3_step()] interface to
  /// behave differently in three ways:
  ///
  /// <ol>
  /// <li>
  /// ^If the database schema changes, instead of returning [SQLITE_SCHEMA] as it
  /// always used to do, [sqlite3_step()] will automatically recompile the SQL
  /// statement and try to run it again. As many as [SQLITE_MAX_SCHEMA_RETRY]
  /// retries will occur before sqlite3_step() gives up and returns an error.
  /// </li>
  ///
  /// <li>
  /// ^When an error occurs, [sqlite3_step()] will return one of the detailed
  /// [error codes] or [extended error codes].  ^The legacy behavior was that
  /// [sqlite3_step()] would only return a generic [SQLITE_ERROR] result code
  /// and the application would have to make a second call to [sqlite3_reset()]
  /// in order to find the underlying cause of the problem. With the "v2" prepare
  /// interfaces, the underlying reason for the error is returned immediately.
  /// </li>
  ///
  /// <li>
  /// ^If the specific value bound to a [parameter | host parameter] in the
  /// WHERE clause might influence the choice of query plan for a statement,
  /// then the statement will be automatically recompiled, as if there had been
  /// a schema change, on the first [sqlite3_step()] call following any change
  /// to the [sqlite3_bind_text | bindings] of that [parameter].
  /// ^The specific value of a WHERE-clause [parameter] might influence the
  /// choice of query plan if the parameter is the left-hand side of a [LIKE]
  /// or [GLOB] operator or if the parameter is compared to an indexed column
  /// and the [SQLITE_ENABLE_STAT4] compile-time option is enabled.
  /// </li>
  /// </ol>
  ///
  /// <p>^sqlite3_prepare_v3() differs from sqlite3_prepare_v2() only in having
  /// the extra prepFlags parameter, which is a bit array consisting of zero or
  /// more of the [SQLITE_PREPARE_PERSISTENT|SQLITE_PREPARE_*] flags.  ^The
  /// sqlite3_prepare_v2() interface works exactly the same as
  /// sqlite3_prepare_v3() with a zero prepFlags parameter.
  int sqlite3_prepare(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zSql,
    int nByte,
    ffi.Pointer<ffi.Pointer<sqlite3_stmt>> ppStmt,
    ffi.Pointer<ffi.Pointer<ffi.Char>> pzTail,
  ) {
    return _sqlite3_prepare(
      db,
      zSql,
      nByte,
      ppStmt,
      pzTail,
    );
  }

  late final _sqlite3_preparePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_prepare');
  late final _sqlite3_prepare = _sqlite3_preparePtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>,
          int,
          ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
          ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  int sqlite3_prepare_v2(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zSql,
    int nByte,
    ffi.Pointer<ffi.Pointer<sqlite3_stmt>> ppStmt,
    ffi.Pointer<ffi.Pointer<ffi.Char>> pzTail,
  ) {
    return _sqlite3_prepare_v2(
      db,
      zSql,
      nByte,
      ppStmt,
      pzTail,
    );
  }

  late final _sqlite3_prepare_v2Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_prepare_v2');
  late final _sqlite3_prepare_v2 = _sqlite3_prepare_v2Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>,
          int,
          ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
          ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  int sqlite3_prepare_v3(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zSql,
    int nByte,
    int prepFlags,
    ffi.Pointer<ffi.Pointer<sqlite3_stmt>> ppStmt,
    ffi.Pointer<ffi.Pointer<ffi.Char>> pzTail,
  ) {
    return _sqlite3_prepare_v3(
      db,
      zSql,
      nByte,
      prepFlags,
      ppStmt,
      pzTail,
    );
  }

  late final _sqlite3_prepare_v3Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.UnsignedInt,
              ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_prepare_v3');
  late final _sqlite3_prepare_v3 = _sqlite3_prepare_v3Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>,
          int,
          int,
          ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
          ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  int sqlite3_prepare16(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Void> zSql,
    int nByte,
    ffi.Pointer<ffi.Pointer<sqlite3_stmt>> ppStmt,
    ffi.Pointer<ffi.Pointer<ffi.Void>> pzTail,
  ) {
    return _sqlite3_prepare16(
      db,
      zSql,
      nByte,
      ppStmt,
      pzTail,
    );
  }

  late final _sqlite3_prepare16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
              ffi.Pointer<ffi.Pointer<ffi.Void>>)>>('sqlite3_prepare16');
  late final _sqlite3_prepare16 = _sqlite3_prepare16Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
          ffi.Pointer<ffi.Pointer<ffi.Void>>)>();

  int sqlite3_prepare16_v2(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Void> zSql,
    int nByte,
    ffi.Pointer<ffi.Pointer<sqlite3_stmt>> ppStmt,
    ffi.Pointer<ffi.Pointer<ffi.Void>> pzTail,
  ) {
    return _sqlite3_prepare16_v2(
      db,
      zSql,
      nByte,
      ppStmt,
      pzTail,
    );
  }

  late final _sqlite3_prepare16_v2Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
              ffi.Pointer<ffi.Pointer<ffi.Void>>)>>('sqlite3_prepare16_v2');
  late final _sqlite3_prepare16_v2 = _sqlite3_prepare16_v2Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
          ffi.Pointer<ffi.Pointer<ffi.Void>>)>();

  int sqlite3_prepare16_v3(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Void> zSql,
    int nByte,
    int prepFlags,
    ffi.Pointer<ffi.Pointer<sqlite3_stmt>> ppStmt,
    ffi.Pointer<ffi.Pointer<ffi.Void>> pzTail,
  ) {
    return _sqlite3_prepare16_v3(
      db,
      zSql,
      nByte,
      prepFlags,
      ppStmt,
      pzTail,
    );
  }

  late final _sqlite3_prepare16_v3Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.UnsignedInt,
              ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
              ffi.Pointer<ffi.Pointer<ffi.Void>>)>>('sqlite3_prepare16_v3');
  late final _sqlite3_prepare16_v3 = _sqlite3_prepare16_v3Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Void>,
          int,
          int,
          ffi.Pointer<ffi.Pointer<sqlite3_stmt>>,
          ffi.Pointer<ffi.Pointer<ffi.Void>>)>();

  /// CAPI3REF: Retrieving Statement SQL
  /// METHOD: sqlite3_stmt
  ///
  /// ^The sqlite3_sql(P) interface returns a pointer to a copy of the UTF-8
  /// SQL text used to create [prepared statement] P if P was
  /// created by [sqlite3_prepare_v2()], [sqlite3_prepare_v3()],
  /// [sqlite3_prepare16_v2()], or [sqlite3_prepare16_v3()].
  /// ^The sqlite3_expanded_sql(P) interface returns a pointer to a UTF-8
  /// string containing the SQL text of prepared statement P with
  /// [bound parameters] expanded.
  /// ^The sqlite3_normalized_sql(P) interface returns a pointer to a UTF-8
  /// string containing the normalized SQL text of prepared statement P.  The
  /// semantics used to normalize a SQL statement are unspecified and subject
  /// to change.  At a minimum, literal values will be replaced with suitable
  /// placeholders.
  ///
  /// ^(For example, if a prepared statement is created using the SQL
  /// text "SELECT $abc,:xyz" and if parameter $abc is bound to integer 2345
  /// and parameter :xyz is unbound, then sqlite3_sql() will return
  /// the original string, "SELECT $abc,:xyz" but sqlite3_expanded_sql()
  /// will return "SELECT 2345,NULL".)^
  ///
  /// ^The sqlite3_expanded_sql() interface returns NULL if insufficient memory
  /// is available to hold the result, or if the result would exceed the
  /// the maximum string length determined by the [SQLITE_LIMIT_LENGTH].
  ///
  /// ^The [SQLITE_TRACE_SIZE_LIMIT] compile-time option limits the size of
  /// bound parameter expansions.  ^The [SQLITE_OMIT_TRACE] compile-time
  /// option causes sqlite3_expanded_sql() to always return NULL.
  ///
  /// ^The strings returned by sqlite3_sql(P) and sqlite3_normalized_sql(P)
  /// are managed by SQLite and are automatically freed when the prepared
  /// statement is finalized.
  /// ^The string returned by sqlite3_expanded_sql(P), on the other hand,
  /// is obtained from [sqlite3_malloc()] and must be free by the application
  /// by passing it to [sqlite3_free()].
  ffi.Pointer<ffi.Char> sqlite3_sql(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_sql(
      pStmt,
    );
  }

  late final _sqlite3_sqlPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<sqlite3_stmt>)>>('sqlite3_sql');
  late final _sqlite3_sql = _sqlite3_sqlPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>)>();

  ffi.Pointer<ffi.Char> sqlite3_expanded_sql(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_expanded_sql(
      pStmt,
    );
  }

  late final _sqlite3_expanded_sqlPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<sqlite3_stmt>)>>('sqlite3_expanded_sql');
  late final _sqlite3_expanded_sql = _sqlite3_expanded_sqlPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>)>();

  ffi.Pointer<ffi.Char> sqlite3_normalized_sql(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_normalized_sql(
      pStmt,
    );
  }

  late final _sqlite3_normalized_sqlPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<sqlite3_stmt>)>>('sqlite3_normalized_sql');
  late final _sqlite3_normalized_sql = _sqlite3_normalized_sqlPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Determine If An SQL Statement Writes The Database
  /// METHOD: sqlite3_stmt
  ///
  /// ^The sqlite3_stmt_readonly(X) interface returns true (non-zero) if
  /// and only if the [prepared statement] X makes no direct changes to
  /// the content of the database file.
  ///
  /// Note that [application-defined SQL functions] or
  /// [virtual tables] might change the database indirectly as a side effect.
  /// ^(For example, if an application defines a function "eval()" that
  /// calls [sqlite3_exec()], then the following SQL statement would
  /// change the database file through side-effects:
  ///
  /// <blockquote><pre>
  /// SELECT eval('DELETE FROM t1') FROM t2;
  /// </pre></blockquote>
  ///
  /// But because the [SELECT] statement does not change the database file
  /// directly, sqlite3_stmt_readonly() would still return true.)^
  ///
  /// ^Transaction control statements such as [BEGIN], [COMMIT], [ROLLBACK],
  /// [SAVEPOINT], and [RELEASE] cause sqlite3_stmt_readonly() to return true,
  /// since the statements themselves do not actually modify the database but
  /// rather they control the timing of when other statements modify the
  /// database.  ^The [ATTACH] and [DETACH] statements also cause
  /// sqlite3_stmt_readonly() to return true since, while those statements
  /// change the configuration of a database connection, they do not make
  /// changes to the content of the database files on disk.
  /// ^The sqlite3_stmt_readonly() interface returns true for [BEGIN] since
  /// [BEGIN] merely sets internal flags, but the [BEGIN|BEGIN IMMEDIATE] and
  /// [BEGIN|BEGIN EXCLUSIVE] commands do touch the database and so
  /// sqlite3_stmt_readonly() returns false for those commands.
  int sqlite3_stmt_readonly(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_stmt_readonly(
      pStmt,
    );
  }

  late final _sqlite3_stmt_readonlyPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_stmt_readonly');
  late final _sqlite3_stmt_readonly = _sqlite3_stmt_readonlyPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Query The EXPLAIN Setting For A Prepared Statement
  /// METHOD: sqlite3_stmt
  ///
  /// ^The sqlite3_stmt_isexplain(S) interface returns 1 if the
  /// prepared statement S is an EXPLAIN statement, or 2 if the
  /// statement S is an EXPLAIN QUERY PLAN.
  /// ^The sqlite3_stmt_isexplain(S) interface returns 0 if S is
  /// an ordinary statement or a NULL pointer.
  int sqlite3_stmt_isexplain(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_stmt_isexplain(
      pStmt,
    );
  }

  late final _sqlite3_stmt_isexplainPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_stmt_isexplain');
  late final _sqlite3_stmt_isexplain = _sqlite3_stmt_isexplainPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Determine If A Prepared Statement Has Been Reset
  /// METHOD: sqlite3_stmt
  ///
  /// ^The sqlite3_stmt_busy(S) interface returns true (non-zero) if the
  /// [prepared statement] S has been stepped at least once using
  /// [sqlite3_step(S)] but has neither run to completion (returned
  /// [SQLITE_DONE] from [sqlite3_step(S)]) nor
  /// been reset using [sqlite3_reset(S)].  ^The sqlite3_stmt_busy(S)
  /// interface returns false if S is a NULL pointer.  If S is not a
  /// NULL pointer and is not a pointer to a valid [prepared statement]
  /// object, then the behavior is undefined and probably undesirable.
  ///
  /// This interface can be used in combination [sqlite3_next_stmt()]
  /// to locate all prepared statements associated with a database
  /// connection that are in need of being reset.  This can be used,
  /// for example, in diagnostic routines to search for prepared
  /// statements that are holding a transaction open.
  int sqlite3_stmt_busy(
    ffi.Pointer<sqlite3_stmt> arg0,
  ) {
    return _sqlite3_stmt_busy(
      arg0,
    );
  }

  late final _sqlite3_stmt_busyPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_stmt_busy');
  late final _sqlite3_stmt_busy = _sqlite3_stmt_busyPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Binding Values To Prepared Statements
  /// KEYWORDS: {host parameter} {host parameters} {host parameter name}
  /// KEYWORDS: {SQL parameter} {SQL parameters} {parameter binding}
  /// METHOD: sqlite3_stmt
  ///
  /// ^(In the SQL statement text input to [sqlite3_prepare_v2()] and its variants,
  /// literals may be replaced by a [parameter] that matches one of following
  /// templates:
  ///
  /// <ul>
  /// <li>  ?
  /// <li>  ?NNN
  /// <li>  :VVV
  /// <li>  @VVV
  /// <li>  $VVV
  /// </ul>
  ///
  /// In the templates above, NNN represents an integer literal,
  /// and VVV represents an alphanumeric identifier.)^  ^The values of these
  /// parameters (also called "host parameter names" or "SQL parameters")
  /// can be set using the sqlite3_bind_*() routines defined here.
  ///
  /// ^The first argument to the sqlite3_bind_*() routines is always
  /// a pointer to the [sqlite3_stmt] object returned from
  /// [sqlite3_prepare_v2()] or its variants.
  ///
  /// ^The second argument is the index of the SQL parameter to be set.
  /// ^The leftmost SQL parameter has an index of 1.  ^When the same named
  /// SQL parameter is used more than once, second and subsequent
  /// occurrences have the same index as the first occurrence.
  /// ^The index for named parameters can be looked up using the
  /// [sqlite3_bind_parameter_index()] API if desired.  ^The index
  /// for "?NNN" parameters is the value of NNN.
  /// ^The NNN value must be between 1 and the [sqlite3_limit()]
  /// parameter [SQLITE_LIMIT_VARIABLE_NUMBER] (default value: 32766).
  ///
  /// ^The third argument is the value to bind to the parameter.
  /// ^If the third parameter to sqlite3_bind_text() or sqlite3_bind_text16()
  /// or sqlite3_bind_blob() is a NULL pointer then the fourth parameter
  /// is ignored and the end result is the same as sqlite3_bind_null().
  /// ^If the third parameter to sqlite3_bind_text() is not NULL, then
  /// it should be a pointer to well-formed UTF8 text.
  /// ^If the third parameter to sqlite3_bind_text16() is not NULL, then
  /// it should be a pointer to well-formed UTF16 text.
  /// ^If the third parameter to sqlite3_bind_text64() is not NULL, then
  /// it should be a pointer to a well-formed unicode string that is
  /// either UTF8 if the sixth parameter is SQLITE_UTF8, or UTF16
  /// otherwise.
  ///
  /// [[byte-order determination rules]] ^The byte-order of
  /// UTF16 input text is determined by the byte-order mark (BOM, U+FEFF)
  /// found in first character, which is removed, or in the absence of a BOM
  /// the byte order is the native byte order of the host
  /// machine for sqlite3_bind_text16() or the byte order specified in
  /// the 6th parameter for sqlite3_bind_text64().)^
  /// ^If UTF16 input text contains invalid unicode
  /// characters, then SQLite might change those invalid characters
  /// into the unicode replacement character: U+FFFD.
  ///
  /// ^(In those routines that have a fourth argument, its value is the
  /// number of bytes in the parameter.  To be clear: the value is the
  /// number of <u>bytes</u> in the value, not the number of characters.)^
  /// ^If the fourth parameter to sqlite3_bind_text() or sqlite3_bind_text16()
  /// is negative, then the length of the string is
  /// the number of bytes up to the first zero terminator.
  /// If the fourth parameter to sqlite3_bind_blob() is negative, then
  /// the behavior is undefined.
  /// If a non-negative fourth parameter is provided to sqlite3_bind_text()
  /// or sqlite3_bind_text16() or sqlite3_bind_text64() then
  /// that parameter must be the byte offset
  /// where the NUL terminator would occur assuming the string were NUL
  /// terminated.  If any NUL characters occurs at byte offsets less than
  /// the value of the fourth parameter then the resulting string value will
  /// contain embedded NULs.  The result of expressions involving strings
  /// with embedded NULs is undefined.
  ///
  /// ^The fifth argument to the BLOB and string binding interfaces
  /// is a destructor used to dispose of the BLOB or
  /// string after SQLite has finished with it.  ^The destructor is called
  /// to dispose of the BLOB or string even if the call to the bind API fails,
  /// except the destructor is not called if the third parameter is a NULL
  /// pointer or the fourth parameter is negative.
  /// ^If the fifth argument is
  /// the special value [SQLITE_STATIC], then SQLite assumes that the
  /// information is in static, unmanaged space and does not need to be freed.
  /// ^If the fifth argument has the value [SQLITE_TRANSIENT], then
  /// SQLite makes its own private copy of the data immediately, before
  /// the sqlite3_bind_*() routine returns.
  ///
  /// ^The sixth argument to sqlite3_bind_text64() must be one of
  /// [SQLITE_UTF8], [SQLITE_UTF16], [SQLITE_UTF16BE], or [SQLITE_UTF16LE]
  /// to specify the encoding of the text in the third parameter.  If
  /// the sixth argument to sqlite3_bind_text64() is not one of the
  /// allowed values shown above, or if the text encoding is different
  /// from the encoding specified by the sixth parameter, then the behavior
  /// is undefined.
  ///
  /// ^The sqlite3_bind_zeroblob() routine binds a BLOB of length N that
  /// is filled with zeroes.  ^A zeroblob uses a fixed amount of memory
  /// (just an integer to hold its size) while it is being processed.
  /// Zeroblobs are intended to serve as placeholders for BLOBs whose
  /// content is later written using
  /// [sqlite3_blob_open | incremental BLOB I/O] routines.
  /// ^A negative value for the zeroblob results in a zero-length BLOB.
  ///
  /// ^The sqlite3_bind_pointer(S,I,P,T,D) routine causes the I-th parameter in
  /// [prepared statement] S to have an SQL value of NULL, but to also be
  /// associated with the pointer P of type T.  ^D is either a NULL pointer or
  /// a pointer to a destructor function for P. ^SQLite will invoke the
  /// destructor D with a single argument of P when it is finished using
  /// P.  The T parameter should be a static string, preferably a string
  /// literal. The sqlite3_bind_pointer() routine is part of the
  /// [pointer passing interface] added for SQLite 3.20.0.
  ///
  /// ^If any of the sqlite3_bind_*() routines are called with a NULL pointer
  /// for the [prepared statement] or with a prepared statement for which
  /// [sqlite3_step()] has been called more recently than [sqlite3_reset()],
  /// then the call will return [SQLITE_MISUSE].  If any sqlite3_bind_()
  /// routine is passed a [prepared statement] that has been finalized, the
  /// result is undefined and probably harmful.
  ///
  /// ^Bindings are not cleared by the [sqlite3_reset()] routine.
  /// ^Unbound parameters are interpreted as NULL.
  ///
  /// ^The sqlite3_bind_* routines return [SQLITE_OK] on success or an
  /// [error code] if anything goes wrong.
  /// ^[SQLITE_TOOBIG] might be returned if the size of a string or BLOB
  /// exceeds limits imposed by [sqlite3_limit]([SQLITE_LIMIT_LENGTH]) or
  /// [SQLITE_MAX_LENGTH].
  /// ^[SQLITE_RANGE] is returned if the parameter
  /// index is out of range.  ^[SQLITE_NOMEM] is returned if malloc() fails.
  ///
  /// See also: [sqlite3_bind_parameter_count()],
  /// [sqlite3_bind_parameter_name()], and [sqlite3_bind_parameter_index()].
  int sqlite3_bind_blob(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    ffi.Pointer<ffi.Void> arg2,
    int n,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg4,
  ) {
    return _sqlite3_bind_blob(
      arg0,
      arg1,
      arg2,
      n,
      arg4,
    );
  }

  late final _sqlite3_bind_blobPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>,
              ffi.Int,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_bind_blob');
  late final _sqlite3_bind_blob = _sqlite3_bind_blobPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_stmt>,
          int,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_bind_blob64(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    ffi.Pointer<ffi.Void> arg2,
    int arg3,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg4,
  ) {
    return _sqlite3_bind_blob64(
      arg0,
      arg1,
      arg2,
      arg3,
      arg4,
    );
  }

  late final _sqlite3_bind_blob64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>,
              ffi.Int,
              ffi.Pointer<ffi.Void>,
              sqlite3_uint64,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_bind_blob64');
  late final _sqlite3_bind_blob64 = _sqlite3_bind_blob64Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_stmt>,
          int,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_bind_double(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    double arg2,
  ) {
    return _sqlite3_bind_double(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_bind_doublePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>, ffi.Int,
              ffi.Double)>>('sqlite3_bind_double');
  late final _sqlite3_bind_double = _sqlite3_bind_doublePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int, double)>();

  int sqlite3_bind_int(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    int arg2,
  ) {
    return _sqlite3_bind_int(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_bind_intPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>, ffi.Int,
              ffi.Int)>>('sqlite3_bind_int');
  late final _sqlite3_bind_int = _sqlite3_bind_intPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int, int)>();

  int sqlite3_bind_int64(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    int arg2,
  ) {
    return _sqlite3_bind_int64(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_bind_int64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>, ffi.Int,
              sqlite3_int64)>>('sqlite3_bind_int64');
  late final _sqlite3_bind_int64 = _sqlite3_bind_int64Ptr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int, int)>();

  int sqlite3_bind_null(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_bind_null(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_bind_nullPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_bind_null');
  late final _sqlite3_bind_null = _sqlite3_bind_nullPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int)>();

  int sqlite3_bind_text(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    ffi.Pointer<ffi.Char> arg2,
    int arg3,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg4,
  ) {
    return _sqlite3_bind_text(
      arg0,
      arg1,
      arg2,
      arg3,
      arg4,
    );
  }

  late final _sqlite3_bind_textPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>,
              ffi.Int,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_bind_text');
  late final _sqlite3_bind_text = _sqlite3_bind_textPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_stmt>,
          int,
          ffi.Pointer<ffi.Char>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_bind_text16(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    ffi.Pointer<ffi.Void> arg2,
    int arg3,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg4,
  ) {
    return _sqlite3_bind_text16(
      arg0,
      arg1,
      arg2,
      arg3,
      arg4,
    );
  }

  late final _sqlite3_bind_text16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>,
              ffi.Int,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_bind_text16');
  late final _sqlite3_bind_text16 = _sqlite3_bind_text16Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_stmt>,
          int,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_bind_text64(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    ffi.Pointer<ffi.Char> arg2,
    int arg3,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg4,
    int encoding,
  ) {
    return _sqlite3_bind_text64(
      arg0,
      arg1,
      arg2,
      arg3,
      arg4,
      encoding,
    );
  }

  late final _sqlite3_bind_text64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>,
              ffi.Int,
              ffi.Pointer<ffi.Char>,
              sqlite3_uint64,
              ffi.Pointer<
                  ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>,
              ffi.UnsignedChar)>>('sqlite3_bind_text64');
  late final _sqlite3_bind_text64 = _sqlite3_bind_text64Ptr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_stmt>,
          int,
          ffi.Pointer<ffi.Char>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>,
          int)>();

  int sqlite3_bind_value(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    ffi.Pointer<sqlite3_value> arg2,
  ) {
    return _sqlite3_bind_value(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_bind_valuePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>, ffi.Int,
              ffi.Pointer<sqlite3_value>)>>('sqlite3_bind_value');
  late final _sqlite3_bind_value = _sqlite3_bind_valuePtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_stmt>, int, ffi.Pointer<sqlite3_value>)>();

  int sqlite3_bind_pointer(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    ffi.Pointer<ffi.Void> arg2,
    ffi.Pointer<ffi.Char> arg3,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg4,
  ) {
    return _sqlite3_bind_pointer(
      arg0,
      arg1,
      arg2,
      arg3,
      arg4,
    );
  }

  late final _sqlite3_bind_pointerPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>,
              ffi.Int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_bind_pointer');
  late final _sqlite3_bind_pointer = _sqlite3_bind_pointerPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_stmt>,
          int,
          ffi.Pointer<ffi.Void>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_bind_zeroblob(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    int n,
  ) {
    return _sqlite3_bind_zeroblob(
      arg0,
      arg1,
      n,
    );
  }

  late final _sqlite3_bind_zeroblobPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>, ffi.Int,
              ffi.Int)>>('sqlite3_bind_zeroblob');
  late final _sqlite3_bind_zeroblob = _sqlite3_bind_zeroblobPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int, int)>();

  int sqlite3_bind_zeroblob64(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
    int arg2,
  ) {
    return _sqlite3_bind_zeroblob64(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_bind_zeroblob64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>, ffi.Int,
              sqlite3_uint64)>>('sqlite3_bind_zeroblob64');
  late final _sqlite3_bind_zeroblob64 = _sqlite3_bind_zeroblob64Ptr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int, int)>();

  /// CAPI3REF: Number Of SQL Parameters
  /// METHOD: sqlite3_stmt
  ///
  /// ^This routine can be used to find the number of [SQL parameters]
  /// in a [prepared statement].  SQL parameters are tokens of the
  /// form "?", "?NNN", ":AAA", "$AAA", or "@AAA" that serve as
  /// placeholders for values that are [sqlite3_bind_blob | bound]
  /// to the parameters at a later time.
  ///
  /// ^(This routine actually returns the index of the largest (rightmost)
  /// parameter. For all forms except ?NNN, this will correspond to the
  /// number of unique parameters.  If parameters of the ?NNN form are used,
  /// there may be gaps in the list.)^
  ///
  /// See also: [sqlite3_bind_blob|sqlite3_bind()],
  /// [sqlite3_bind_parameter_name()], and
  /// [sqlite3_bind_parameter_index()].
  int sqlite3_bind_parameter_count(
    ffi.Pointer<sqlite3_stmt> arg0,
  ) {
    return _sqlite3_bind_parameter_count(
      arg0,
    );
  }

  late final _sqlite3_bind_parameter_countPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_bind_parameter_count');
  late final _sqlite3_bind_parameter_count = _sqlite3_bind_parameter_countPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Name Of A Host Parameter
  /// METHOD: sqlite3_stmt
  ///
  /// ^The sqlite3_bind_parameter_name(P,N) interface returns
  /// the name of the N-th [SQL parameter] in the [prepared statement] P.
  /// ^(SQL parameters of the form "?NNN" or ":AAA" or "@AAA" or "$AAA"
  /// have a name which is the string "?NNN" or ":AAA" or "@AAA" or "$AAA"
  /// respectively.
  /// In other words, the initial ":" or "$" or "@" or "?"
  /// is included as part of the name.)^
  /// ^Parameters of the form "?" without a following integer have no name
  /// and are referred to as "nameless" or "anonymous parameters".
  ///
  /// ^The first host parameter has an index of 1, not 0.
  ///
  /// ^If the value N is out of range or if the N-th parameter is
  /// nameless, then NULL is returned.  ^The returned string is
  /// always in UTF-8 encoding even if the named parameter was
  /// originally specified as UTF-16 in [sqlite3_prepare16()],
  /// [sqlite3_prepare16_v2()], or [sqlite3_prepare16_v3()].
  ///
  /// See also: [sqlite3_bind_blob|sqlite3_bind()],
  /// [sqlite3_bind_parameter_count()], and
  /// [sqlite3_bind_parameter_index()].
  ffi.Pointer<ffi.Char> sqlite3_bind_parameter_name(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_bind_parameter_name(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_bind_parameter_namePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Int)>>('sqlite3_bind_parameter_name');
  late final _sqlite3_bind_parameter_name =
      _sqlite3_bind_parameter_namePtr.asFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  /// CAPI3REF: Index Of A Parameter With A Given Name
  /// METHOD: sqlite3_stmt
  ///
  /// ^Return the index of an SQL parameter given its name.  ^The
  /// index value returned is suitable for use as the second
  /// parameter to [sqlite3_bind_blob|sqlite3_bind()].  ^A zero
  /// is returned if no matching parameter is found.  ^The parameter
  /// name must be given in UTF-8 even if the original statement
  /// was prepared from UTF-16 text using [sqlite3_prepare16_v2()] or
  /// [sqlite3_prepare16_v3()].
  ///
  /// See also: [sqlite3_bind_blob|sqlite3_bind()],
  /// [sqlite3_bind_parameter_count()], and
  /// [sqlite3_bind_parameter_name()].
  int sqlite3_bind_parameter_index(
    ffi.Pointer<sqlite3_stmt> arg0,
    ffi.Pointer<ffi.Char> zName,
  ) {
    return _sqlite3_bind_parameter_index(
      arg0,
      zName,
    );
  }

  late final _sqlite3_bind_parameter_indexPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_bind_parameter_index');
  late final _sqlite3_bind_parameter_index =
      _sqlite3_bind_parameter_indexPtr.asFunction<
          int Function(ffi.Pointer<sqlite3_stmt>, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Reset All Bindings On A Prepared Statement
  /// METHOD: sqlite3_stmt
  ///
  /// ^Contrary to the intuition of many, [sqlite3_reset()] does not reset
  /// the [sqlite3_bind_blob | bindings] on a [prepared statement].
  /// ^Use this routine to reset all host parameters to NULL.
  int sqlite3_clear_bindings(
    ffi.Pointer<sqlite3_stmt> arg0,
  ) {
    return _sqlite3_clear_bindings(
      arg0,
    );
  }

  late final _sqlite3_clear_bindingsPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_clear_bindings');
  late final _sqlite3_clear_bindings = _sqlite3_clear_bindingsPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Number Of Columns In A Result Set
  /// METHOD: sqlite3_stmt
  ///
  /// ^Return the number of columns in the result set returned by the
  /// [prepared statement]. ^If this routine returns 0, that means the
  /// [prepared statement] returns no data (for example an [UPDATE]).
  /// ^However, just because this routine returns a positive number does not
  /// mean that one or more rows of data will be returned.  ^A SELECT statement
  /// will always have a positive sqlite3_column_count() but depending on the
  /// WHERE clause constraints and the table content, it might return no rows.
  ///
  /// See also: [sqlite3_data_count()]
  int sqlite3_column_count(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_column_count(
      pStmt,
    );
  }

  late final _sqlite3_column_countPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_column_count');
  late final _sqlite3_column_count = _sqlite3_column_countPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Column Names In A Result Set
  /// METHOD: sqlite3_stmt
  ///
  /// ^These routines return the name assigned to a particular column
  /// in the result set of a [SELECT] statement.  ^The sqlite3_column_name()
  /// interface returns a pointer to a zero-terminated UTF-8 string
  /// and sqlite3_column_name16() returns a pointer to a zero-terminated
  /// UTF-16 string.  ^The first parameter is the [prepared statement]
  /// that implements the [SELECT] statement. ^The second parameter is the
  /// column number.  ^The leftmost column is number 0.
  ///
  /// ^The returned string pointer is valid until either the [prepared statement]
  /// is destroyed by [sqlite3_finalize()] or until the statement is automatically
  /// reprepared by the first call to [sqlite3_step()] for a particular run
  /// or until the next call to
  /// sqlite3_column_name() or sqlite3_column_name16() on the same column.
  ///
  /// ^If sqlite3_malloc() fails during the processing of either routine
  /// (for example during a conversion from UTF-8 to UTF-16) then a
  /// NULL pointer is returned.
  ///
  /// ^The name of a result column is the value of the "AS" clause for
  /// that column, if there is an AS clause.  If there is no AS clause
  /// then the name of the column is unspecified and may change from
  /// one release of SQLite to the next.
  ffi.Pointer<ffi.Char> sqlite3_column_name(
    ffi.Pointer<sqlite3_stmt> arg0,
    int N,
  ) {
    return _sqlite3_column_name(
      arg0,
      N,
    );
  }

  late final _sqlite3_column_namePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_name');
  late final _sqlite3_column_name = _sqlite3_column_namePtr.asFunction<
      ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.Void> sqlite3_column_name16(
    ffi.Pointer<sqlite3_stmt> arg0,
    int N,
  ) {
    return _sqlite3_column_name16(
      arg0,
      N,
    );
  }

  late final _sqlite3_column_name16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_name16');
  late final _sqlite3_column_name16 = _sqlite3_column_name16Ptr.asFunction<
      ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  /// CAPI3REF: Source Of Data In A Query Result
  /// METHOD: sqlite3_stmt
  ///
  /// ^These routines provide a means to determine the database, table, and
  /// table column that is the origin of a particular result column in
  /// [SELECT] statement.
  /// ^The name of the database or table or column can be returned as
  /// either a UTF-8 or UTF-16 string.  ^The _database_ routines return
  /// the database name, the _table_ routines return the table name, and
  /// the origin_ routines return the column name.
  /// ^The returned string is valid until the [prepared statement] is destroyed
  /// using [sqlite3_finalize()] or until the statement is automatically
  /// reprepared by the first call to [sqlite3_step()] for a particular run
  /// or until the same information is requested
  /// again in a different encoding.
  ///
  /// ^The names returned are the original un-aliased names of the
  /// database, table, and column.
  ///
  /// ^The first argument to these interfaces is a [prepared statement].
  /// ^These functions return information about the Nth result column returned by
  /// the statement, where N is the second function argument.
  /// ^The left-most column is column 0 for these routines.
  ///
  /// ^If the Nth column returned by the statement is an expression or
  /// subquery and is not a column value, then all of these functions return
  /// NULL.  ^These routines might also return NULL if a memory allocation error
  /// occurs.  ^Otherwise, they return the name of the attached database, table,
  /// or column that query result column was extracted from.
  ///
  /// ^As with all other SQLite APIs, those whose names end with "16" return
  /// UTF-16 encoded strings and the other functions return UTF-8.
  ///
  /// ^These APIs are only available if the library was compiled with the
  /// [SQLITE_ENABLE_COLUMN_METADATA] C-preprocessor symbol.
  ///
  /// If two or more threads call one or more
  /// [sqlite3_column_database_name | column metadata interfaces]
  /// for the same [prepared statement] and result column
  /// at the same time then the results are undefined.
  ffi.Pointer<ffi.Char> sqlite3_column_database_name(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_column_database_name(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_column_database_namePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Int)>>('sqlite3_column_database_name');
  late final _sqlite3_column_database_name =
      _sqlite3_column_database_namePtr.asFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.Void> sqlite3_column_database_name16(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_column_database_name16(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_column_database_name16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Int)>>('sqlite3_column_database_name16');
  late final _sqlite3_column_database_name16 =
      _sqlite3_column_database_name16Ptr.asFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.Char> sqlite3_column_table_name(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_column_table_name(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_column_table_namePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Int)>>('sqlite3_column_table_name');
  late final _sqlite3_column_table_name =
      _sqlite3_column_table_namePtr.asFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.Void> sqlite3_column_table_name16(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_column_table_name16(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_column_table_name16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Int)>>('sqlite3_column_table_name16');
  late final _sqlite3_column_table_name16 =
      _sqlite3_column_table_name16Ptr.asFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.Char> sqlite3_column_origin_name(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_column_origin_name(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_column_origin_namePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Int)>>('sqlite3_column_origin_name');
  late final _sqlite3_column_origin_name =
      _sqlite3_column_origin_namePtr.asFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.Void> sqlite3_column_origin_name16(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_column_origin_name16(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_column_origin_name16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Int)>>('sqlite3_column_origin_name16');
  late final _sqlite3_column_origin_name16 =
      _sqlite3_column_origin_name16Ptr.asFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  /// CAPI3REF: Declared Datatype Of A Query Result
  /// METHOD: sqlite3_stmt
  ///
  /// ^(The first parameter is a [prepared statement].
  /// If this statement is a [SELECT] statement and the Nth column of the
  /// returned result set of that [SELECT] is a table column (not an
  /// expression or subquery) then the declared type of the table
  /// column is returned.)^  ^If the Nth column of the result set is an
  /// expression or subquery, then a NULL pointer is returned.
  /// ^The returned string is always UTF-8 encoded.
  ///
  /// ^(For example, given the database schema:
  ///
  /// CREATE TABLE t1(c1 VARIANT);
  ///
  /// and the following statement to be compiled:
  ///
  /// SELECT c1 + 1, c1 FROM t1;
  ///
  /// this routine would return the string "VARIANT" for the second result
  /// column (i==1), and a NULL pointer for the first result column (i==0).)^
  ///
  /// ^SQLite uses dynamic run-time typing.  ^So just because a column
  /// is declared to contain a particular type does not mean that the
  /// data stored in that column is of the declared type.  SQLite is
  /// strongly typed, but the typing is dynamic not static.  ^Type
  /// is associated with individual values, not with the containers
  /// used to hold those values.
  ffi.Pointer<ffi.Char> sqlite3_column_decltype(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_column_decltype(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_column_decltypePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_decltype');
  late final _sqlite3_column_decltype = _sqlite3_column_decltypePtr.asFunction<
      ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.Void> sqlite3_column_decltype16(
    ffi.Pointer<sqlite3_stmt> arg0,
    int arg1,
  ) {
    return _sqlite3_column_decltype16(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_column_decltype16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Int)>>('sqlite3_column_decltype16');
  late final _sqlite3_column_decltype16 =
      _sqlite3_column_decltype16Ptr.asFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  /// CAPI3REF: Evaluate An SQL Statement
  /// METHOD: sqlite3_stmt
  ///
  /// After a [prepared statement] has been prepared using any of
  /// [sqlite3_prepare_v2()], [sqlite3_prepare_v3()], [sqlite3_prepare16_v2()],
  /// or [sqlite3_prepare16_v3()] or one of the legacy
  /// interfaces [sqlite3_prepare()] or [sqlite3_prepare16()], this function
  /// must be called one or more times to evaluate the statement.
  ///
  /// The details of the behavior of the sqlite3_step() interface depend
  /// on whether the statement was prepared using the newer "vX" interfaces
  /// [sqlite3_prepare_v3()], [sqlite3_prepare_v2()], [sqlite3_prepare16_v3()],
  /// [sqlite3_prepare16_v2()] or the older legacy
  /// interfaces [sqlite3_prepare()] and [sqlite3_prepare16()].  The use of the
  /// new "vX" interface is recommended for new applications but the legacy
  /// interface will continue to be supported.
  ///
  /// ^In the legacy interface, the return value will be either [SQLITE_BUSY],
  /// [SQLITE_DONE], [SQLITE_ROW], [SQLITE_ERROR], or [SQLITE_MISUSE].
  /// ^With the "v2" interface, any of the other [result codes] or
  /// [extended result codes] might be returned as well.
  ///
  /// ^[SQLITE_BUSY] means that the database engine was unable to acquire the
  /// database locks it needs to do its job.  ^If the statement is a [COMMIT]
  /// or occurs outside of an explicit transaction, then you can retry the
  /// statement.  If the statement is not a [COMMIT] and occurs within an
  /// explicit transaction then you should rollback the transaction before
  /// continuing.
  ///
  /// ^[SQLITE_DONE] means that the statement has finished executing
  /// successfully.  sqlite3_step() should not be called again on this virtual
  /// machine without first calling [sqlite3_reset()] to reset the virtual
  /// machine back to its initial state.
  ///
  /// ^If the SQL statement being executed returns any data, then [SQLITE_ROW]
  /// is returned each time a new row of data is ready for processing by the
  /// caller. The values may be accessed using the [column access functions].
  /// sqlite3_step() is called again to retrieve the next row of data.
  ///
  /// ^[SQLITE_ERROR] means that a run-time error (such as a constraint
  /// violation) has occurred.  sqlite3_step() should not be called again on
  /// the VM. More information may be found by calling [sqlite3_errmsg()].
  /// ^With the legacy interface, a more specific error code (for example,
  /// [SQLITE_INTERRUPT], [SQLITE_SCHEMA], [SQLITE_CORRUPT], and so forth)
  /// can be obtained by calling [sqlite3_reset()] on the
  /// [prepared statement].  ^In the "v2" interface,
  /// the more specific error code is returned directly by sqlite3_step().
  ///
  /// [SQLITE_MISUSE] means that the this routine was called inappropriately.
  /// Perhaps it was called on a [prepared statement] that has
  /// already been [sqlite3_finalize | finalized] or on one that had
  /// previously returned [SQLITE_ERROR] or [SQLITE_DONE].  Or it could
  /// be the case that the same database connection is being used by two or
  /// more threads at the same moment in time.
  ///
  /// For all versions of SQLite up to and including 3.6.23.1, a call to
  /// [sqlite3_reset()] was required after sqlite3_step() returned anything
  /// other than [SQLITE_ROW] before any subsequent invocation of
  /// sqlite3_step().  Failure to reset the prepared statement using
  /// [sqlite3_reset()] would result in an [SQLITE_MISUSE] return from
  /// sqlite3_step().  But after [version 3.6.23.1] ([dateof:3.6.23.1],
  /// sqlite3_step() began
  /// calling [sqlite3_reset()] automatically in this circumstance rather
  /// than returning [SQLITE_MISUSE].  This is not considered a compatibility
  /// break because any application that ever receives an SQLITE_MISUSE error
  /// is broken by definition.  The [SQLITE_OMIT_AUTORESET] compile-time option
  /// can be used to restore the legacy behavior.
  ///
  /// <b>Goofy Interface Alert:</b> In the legacy interface, the sqlite3_step()
  /// API always returns a generic error code, [SQLITE_ERROR], following any
  /// error other than [SQLITE_BUSY] and [SQLITE_MISUSE].  You must call
  /// [sqlite3_reset()] or [sqlite3_finalize()] in order to find one of the
  /// specific [error codes] that better describes the error.
  /// We admit that this is a goofy design.  The problem has been fixed
  /// with the "v2" interface.  If you prepare all of your SQL statements
  /// using [sqlite3_prepare_v3()] or [sqlite3_prepare_v2()]
  /// or [sqlite3_prepare16_v2()] or [sqlite3_prepare16_v3()] instead
  /// of the legacy [sqlite3_prepare()] and [sqlite3_prepare16()] interfaces,
  /// then the more specific [error codes] are returned directly
  /// by sqlite3_step().  The use of the "vX" interfaces is recommended.
  int sqlite3_step(
    ffi.Pointer<sqlite3_stmt> arg0,
  ) {
    return _sqlite3_step(
      arg0,
    );
  }

  late final _sqlite3_stepPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_step');
  late final _sqlite3_step =
      _sqlite3_stepPtr.asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Number of columns in a result set
  /// METHOD: sqlite3_stmt
  ///
  /// ^The sqlite3_data_count(P) interface returns the number of columns in the
  /// current row of the result set of [prepared statement] P.
  /// ^If prepared statement P does not have results ready to return
  /// (via calls to the [sqlite3_column_int | sqlite3_column()] family of
  /// interfaces) then sqlite3_data_count(P) returns 0.
  /// ^The sqlite3_data_count(P) routine also returns 0 if P is a NULL pointer.
  /// ^The sqlite3_data_count(P) routine returns 0 if the previous call to
  /// [sqlite3_step](P) returned [SQLITE_DONE].  ^The sqlite3_data_count(P)
  /// will return non-zero if previous call to [sqlite3_step](P) returned
  /// [SQLITE_ROW], except in the case of the [PRAGMA incremental_vacuum]
  /// where it always returns zero since each step of that multi-step
  /// pragma returns 0 columns of data.
  ///
  /// See also: [sqlite3_column_count()]
  int sqlite3_data_count(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_data_count(
      pStmt,
    );
  }

  late final _sqlite3_data_countPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_data_count');
  late final _sqlite3_data_count = _sqlite3_data_countPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Result Values From A Query
  /// KEYWORDS: {column access functions}
  /// METHOD: sqlite3_stmt
  ///
  /// <b>Summary:</b>
  /// <blockquote><table border=0 cellpadding=0 cellspacing=0>
  /// <tr><td><b>sqlite3_column_blob</b><td>&rarr;<td>BLOB result
  /// <tr><td><b>sqlite3_column_double</b><td>&rarr;<td>REAL result
  /// <tr><td><b>sqlite3_column_int</b><td>&rarr;<td>32-bit INTEGER result
  /// <tr><td><b>sqlite3_column_int64</b><td>&rarr;<td>64-bit INTEGER result
  /// <tr><td><b>sqlite3_column_text</b><td>&rarr;<td>UTF-8 TEXT result
  /// <tr><td><b>sqlite3_column_text16</b><td>&rarr;<td>UTF-16 TEXT result
  /// <tr><td><b>sqlite3_column_value</b><td>&rarr;<td>The result as an
  /// [sqlite3_value|unprotected sqlite3_value] object.
  /// <tr><td>&nbsp;<td>&nbsp;<td>&nbsp;
  /// <tr><td><b>sqlite3_column_bytes</b><td>&rarr;<td>Size of a BLOB
  /// or a UTF-8 TEXT result in bytes
  /// <tr><td><b>sqlite3_column_bytes16&nbsp;&nbsp;</b>
  /// <td>&rarr;&nbsp;&nbsp;<td>Size of UTF-16
  /// TEXT in bytes
  /// <tr><td><b>sqlite3_column_type</b><td>&rarr;<td>Default
  /// datatype of the result
  /// </table></blockquote>
  ///
  /// <b>Details:</b>
  ///
  /// ^These routines return information about a single column of the current
  /// result row of a query.  ^In every case the first argument is a pointer
  /// to the [prepared statement] that is being evaluated (the [sqlite3_stmt*]
  /// that was returned from [sqlite3_prepare_v2()] or one of its variants)
  /// and the second argument is the index of the column for which information
  /// should be returned. ^The leftmost column of the result set has the index 0.
  /// ^The number of columns in the result can be determined using
  /// [sqlite3_column_count()].
  ///
  /// If the SQL statement does not currently point to a valid row, or if the
  /// column index is out of range, the result is undefined.
  /// These routines may only be called when the most recent call to
  /// [sqlite3_step()] has returned [SQLITE_ROW] and neither
  /// [sqlite3_reset()] nor [sqlite3_finalize()] have been called subsequently.
  /// If any of these routines are called after [sqlite3_reset()] or
  /// [sqlite3_finalize()] or after [sqlite3_step()] has returned
  /// something other than [SQLITE_ROW], the results are undefined.
  /// If [sqlite3_step()] or [sqlite3_reset()] or [sqlite3_finalize()]
  /// are called from a different thread while any of these routines
  /// are pending, then the results are undefined.
  ///
  /// The first six interfaces (_blob, _double, _int, _int64, _text, and _text16)
  /// each return the value of a result column in a specific data format.  If
  /// the result column is not initially in the requested format (for example,
  /// if the query returns an integer but the sqlite3_column_text() interface
  /// is used to extract the value) then an automatic type conversion is performed.
  ///
  /// ^The sqlite3_column_type() routine returns the
  /// [SQLITE_INTEGER | datatype code] for the initial data type
  /// of the result column.  ^The returned value is one of [SQLITE_INTEGER],
  /// [SQLITE_FLOAT], [SQLITE_TEXT], [SQLITE_BLOB], or [SQLITE_NULL].
  /// The return value of sqlite3_column_type() can be used to decide which
  /// of the first six interface should be used to extract the column value.
  /// The value returned by sqlite3_column_type() is only meaningful if no
  /// automatic type conversions have occurred for the value in question.
  /// After a type conversion, the result of calling sqlite3_column_type()
  /// is undefined, though harmless.  Future
  /// versions of SQLite may change the behavior of sqlite3_column_type()
  /// following a type conversion.
  ///
  /// If the result is a BLOB or a TEXT string, then the sqlite3_column_bytes()
  /// or sqlite3_column_bytes16() interfaces can be used to determine the size
  /// of that BLOB or string.
  ///
  /// ^If the result is a BLOB or UTF-8 string then the sqlite3_column_bytes()
  /// routine returns the number of bytes in that BLOB or string.
  /// ^If the result is a UTF-16 string, then sqlite3_column_bytes() converts
  /// the string to UTF-8 and then returns the number of bytes.
  /// ^If the result is a numeric value then sqlite3_column_bytes() uses
  /// [sqlite3_snprintf()] to convert that value to a UTF-8 string and returns
  /// the number of bytes in that string.
  /// ^If the result is NULL, then sqlite3_column_bytes() returns zero.
  ///
  /// ^If the result is a BLOB or UTF-16 string then the sqlite3_column_bytes16()
  /// routine returns the number of bytes in that BLOB or string.
  /// ^If the result is a UTF-8 string, then sqlite3_column_bytes16() converts
  /// the string to UTF-16 and then returns the number of bytes.
  /// ^If the result is a numeric value then sqlite3_column_bytes16() uses
  /// [sqlite3_snprintf()] to convert that value to a UTF-16 string and returns
  /// the number of bytes in that string.
  /// ^If the result is NULL, then sqlite3_column_bytes16() returns zero.
  ///
  /// ^The values returned by [sqlite3_column_bytes()] and
  /// [sqlite3_column_bytes16()] do not include the zero terminators at the end
  /// of the string.  ^For clarity: the values returned by
  /// [sqlite3_column_bytes()] and [sqlite3_column_bytes16()] are the number of
  /// bytes in the string, not the number of characters.
  ///
  /// ^Strings returned by sqlite3_column_text() and sqlite3_column_text16(),
  /// even empty strings, are always zero-terminated.  ^The return
  /// value from sqlite3_column_blob() for a zero-length BLOB is a NULL pointer.
  ///
  /// <b>Warning:</b> ^The object returned by [sqlite3_column_value()] is an
  /// [unprotected sqlite3_value] object.  In a multithreaded environment,
  /// an unprotected sqlite3_value object may only be used safely with
  /// [sqlite3_bind_value()] and [sqlite3_result_value()].
  /// If the [unprotected sqlite3_value] object returned by
  /// [sqlite3_column_value()] is used in any other way, including calls
  /// to routines like [sqlite3_value_int()], [sqlite3_value_text()],
  /// or [sqlite3_value_bytes()], the behavior is not threadsafe.
  /// Hence, the sqlite3_column_value() interface
  /// is normally only useful within the implementation of
  /// [application-defined SQL functions] or [virtual tables], not within
  /// top-level application code.
  ///
  /// The these routines may attempt to convert the datatype of the result.
  /// ^For example, if the internal representation is FLOAT and a text result
  /// is requested, [sqlite3_snprintf()] is used internally to perform the
  /// conversion automatically.  ^(The following table details the conversions
  /// that are applied:
  ///
  /// <blockquote>
  /// <table border="1">
  /// <tr><th> Internal<br>Type <th> Requested<br>Type <th>  Conversion
  ///
  /// <tr><td>  NULL    <td> INTEGER   <td> Result is 0
  /// <tr><td>  NULL    <td>  FLOAT    <td> Result is 0.0
  /// <tr><td>  NULL    <td>   TEXT    <td> Result is a NULL pointer
  /// <tr><td>  NULL    <td>   BLOB    <td> Result is a NULL pointer
  /// <tr><td> INTEGER  <td>  FLOAT    <td> Convert from integer to float
  /// <tr><td> INTEGER  <td>   TEXT    <td> ASCII rendering of the integer
  /// <tr><td> INTEGER  <td>   BLOB    <td> Same as INTEGER->TEXT
  /// <tr><td>  FLOAT   <td> INTEGER   <td> [CAST] to INTEGER
  /// <tr><td>  FLOAT   <td>   TEXT    <td> ASCII rendering of the float
  /// <tr><td>  FLOAT   <td>   BLOB    <td> [CAST] to BLOB
  /// <tr><td>  TEXT    <td> INTEGER   <td> [CAST] to INTEGER
  /// <tr><td>  TEXT    <td>  FLOAT    <td> [CAST] to REAL
  /// <tr><td>  TEXT    <td>   BLOB    <td> No change
  /// <tr><td>  BLOB    <td> INTEGER   <td> [CAST] to INTEGER
  /// <tr><td>  BLOB    <td>  FLOAT    <td> [CAST] to REAL
  /// <tr><td>  BLOB    <td>   TEXT    <td> Add a zero terminator if needed
  /// </table>
  /// </blockquote>)^
  ///
  /// Note that when type conversions occur, pointers returned by prior
  /// calls to sqlite3_column_blob(), sqlite3_column_text(), and/or
  /// sqlite3_column_text16() may be invalidated.
  /// Type conversions and pointer invalidations might occur
  /// in the following cases:
  ///
  /// <ul>
  /// <li> The initial content is a BLOB and sqlite3_column_text() or
  /// sqlite3_column_text16() is called.  A zero-terminator might
  /// need to be added to the string.</li>
  /// <li> The initial content is UTF-8 text and sqlite3_column_bytes16() or
  /// sqlite3_column_text16() is called.  The content must be converted
  /// to UTF-16.</li>
  /// <li> The initial content is UTF-16 text and sqlite3_column_bytes() or
  /// sqlite3_column_text() is called.  The content must be converted
  /// to UTF-8.</li>
  /// </ul>
  ///
  /// ^Conversions between UTF-16be and UTF-16le are always done in place and do
  /// not invalidate a prior pointer, though of course the content of the buffer
  /// that the prior pointer references will have been modified.  Other kinds
  /// of conversion are done in place when it is possible, but sometimes they
  /// are not possible and in those cases prior pointers are invalidated.
  ///
  /// The safest policy is to invoke these routines
  /// in one of the following ways:
  ///
  /// <ul>
  /// <li>sqlite3_column_text() followed by sqlite3_column_bytes()</li>
  /// <li>sqlite3_column_blob() followed by sqlite3_column_bytes()</li>
  /// <li>sqlite3_column_text16() followed by sqlite3_column_bytes16()</li>
  /// </ul>
  ///
  /// In other words, you should call sqlite3_column_text(),
  /// sqlite3_column_blob(), or sqlite3_column_text16() first to force the result
  /// into the desired format, then invoke sqlite3_column_bytes() or
  /// sqlite3_column_bytes16() to find the size of the result.  Do not mix calls
  /// to sqlite3_column_text() or sqlite3_column_blob() with calls to
  /// sqlite3_column_bytes16(), and do not mix calls to sqlite3_column_text16()
  /// with calls to sqlite3_column_bytes().
  ///
  /// ^The pointers returned are valid until a type conversion occurs as
  /// described above, or until [sqlite3_step()] or [sqlite3_reset()] or
  /// [sqlite3_finalize()] is called.  ^The memory space used to hold strings
  /// and BLOBs is freed automatically.  Do not pass the pointers returned
  /// from [sqlite3_column_blob()], [sqlite3_column_text()], etc. into
  /// [sqlite3_free()].
  ///
  /// As long as the input parameters are correct, these routines will only
  /// fail if an out-of-memory error occurs during a format conversion.
  /// Only the following subset of interfaces are subject to out-of-memory
  /// errors:
  ///
  /// <ul>
  /// <li> sqlite3_column_blob()
  /// <li> sqlite3_column_text()
  /// <li> sqlite3_column_text16()
  /// <li> sqlite3_column_bytes()
  /// <li> sqlite3_column_bytes16()
  /// </ul>
  ///
  /// If an out-of-memory error occurs, then the return value from these
  /// routines is the same as if the column had contained an SQL NULL value.
  /// Valid SQL NULL returns can be distinguished from out-of-memory errors
  /// by invoking the [sqlite3_errcode()] immediately after the suspect
  /// return value is obtained and before any
  /// other SQLite interface is called on the same [database connection].
  ffi.Pointer<ffi.Void> sqlite3_column_blob(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_blob(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_blobPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_blob');
  late final _sqlite3_column_blob = _sqlite3_column_blobPtr.asFunction<
      ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  double sqlite3_column_double(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_double(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_doublePtr = _lookup<
      ffi.NativeFunction<
          ffi.Double Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_double');
  late final _sqlite3_column_double = _sqlite3_column_doublePtr
      .asFunction<double Function(ffi.Pointer<sqlite3_stmt>, int)>();

  int sqlite3_column_int(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_int(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_intPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_int');
  late final _sqlite3_column_int = _sqlite3_column_intPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int)>();

  int sqlite3_column_int64(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_int64(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_int64Ptr = _lookup<
      ffi.NativeFunction<
          sqlite3_int64 Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_int64');
  late final _sqlite3_column_int64 = _sqlite3_column_int64Ptr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.UnsignedChar> sqlite3_column_text(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_text(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_textPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_text');
  late final _sqlite3_column_text = _sqlite3_column_textPtr.asFunction<
      ffi.Pointer<ffi.UnsignedChar> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<ffi.Void> sqlite3_column_text16(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_text16(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_text16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_text16');
  late final _sqlite3_column_text16 = _sqlite3_column_text16Ptr.asFunction<
      ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  ffi.Pointer<sqlite3_value> sqlite3_column_value(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_value(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_valuePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_value> Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_value');
  late final _sqlite3_column_value = _sqlite3_column_valuePtr.asFunction<
      ffi.Pointer<sqlite3_value> Function(ffi.Pointer<sqlite3_stmt>, int)>();

  int sqlite3_column_bytes(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_bytes(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_bytesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_bytes');
  late final _sqlite3_column_bytes = _sqlite3_column_bytesPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int)>();

  int sqlite3_column_bytes16(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_bytes16(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_bytes16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_bytes16');
  late final _sqlite3_column_bytes16 = _sqlite3_column_bytes16Ptr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int)>();

  int sqlite3_column_type(
    ffi.Pointer<sqlite3_stmt> arg0,
    int iCol,
  ) {
    return _sqlite3_column_type(
      arg0,
      iCol,
    );
  }

  late final _sqlite3_column_typePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_stmt>, ffi.Int)>>('sqlite3_column_type');
  late final _sqlite3_column_type = _sqlite3_column_typePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int)>();

  /// CAPI3REF: Destroy A Prepared Statement Object
  /// DESTRUCTOR: sqlite3_stmt
  ///
  /// ^The sqlite3_finalize() function is called to delete a [prepared statement].
  /// ^If the most recent evaluation of the statement encountered no errors
  /// or if the statement is never been evaluated, then sqlite3_finalize() returns
  /// SQLITE_OK.  ^If the most recent evaluation of statement S failed, then
  /// sqlite3_finalize(S) returns the appropriate [error code] or
  /// [extended error code].
  ///
  /// ^The sqlite3_finalize(S) routine can be called at any point during
  /// the life cycle of [prepared statement] S:
  /// before statement S is ever evaluated, after
  /// one or more calls to [sqlite3_reset()], or after any call
  /// to [sqlite3_step()] regardless of whether or not the statement has
  /// completed execution.
  ///
  /// ^Invoking sqlite3_finalize() on a NULL pointer is a harmless no-op.
  ///
  /// The application must finalize every [prepared statement] in order to avoid
  /// resource leaks.  It is a grievous error for the application to try to use
  /// a prepared statement after it has been finalized.  Any use of a prepared
  /// statement after it has been finalized can result in undefined and
  /// undesirable behavior such as segfaults and heap corruption.
  int sqlite3_finalize(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_finalize(
      pStmt,
    );
  }

  late final _sqlite3_finalizePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_finalize');
  late final _sqlite3_finalize = _sqlite3_finalizePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Reset A Prepared Statement Object
  /// METHOD: sqlite3_stmt
  ///
  /// The sqlite3_reset() function is called to reset a [prepared statement]
  /// object back to its initial state, ready to be re-executed.
  /// ^Any SQL statement variables that had values bound to them using
  /// the [sqlite3_bind_blob | sqlite3_bind_*() API] retain their values.
  /// Use [sqlite3_clear_bindings()] to reset the bindings.
  ///
  /// ^The [sqlite3_reset(S)] interface resets the [prepared statement] S
  /// back to the beginning of its program.
  ///
  /// ^If the most recent call to [sqlite3_step(S)] for the
  /// [prepared statement] S returned [SQLITE_ROW] or [SQLITE_DONE],
  /// or if [sqlite3_step(S)] has never before been called on S,
  /// then [sqlite3_reset(S)] returns [SQLITE_OK].
  ///
  /// ^If the most recent call to [sqlite3_step(S)] for the
  /// [prepared statement] S indicated an error, then
  /// [sqlite3_reset(S)] returns an appropriate [error code].
  ///
  /// ^The [sqlite3_reset(S)] interface does not change the values
  /// of any [sqlite3_bind_blob|bindings] on the [prepared statement] S.
  int sqlite3_reset(
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_reset(
      pStmt,
    );
  }

  late final _sqlite3_resetPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_reset');
  late final _sqlite3_reset =
      _sqlite3_resetPtr.asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Create Or Redefine SQL Functions
  /// KEYWORDS: {function creation routines}
  /// METHOD: sqlite3
  ///
  /// ^These functions (collectively known as "function creation routines")
  /// are used to add SQL functions or aggregates or to redefine the behavior
  /// of existing SQL functions or aggregates. The only differences between
  /// the three "sqlite3_create_function*" routines are the text encoding
  /// expected for the second parameter (the name of the function being
  /// created) and the presence or absence of a destructor callback for
  /// the application data pointer. Function sqlite3_create_window_function()
  /// is similar, but allows the user to supply the extra callback functions
  /// needed by [aggregate window functions].
  ///
  /// ^The first parameter is the [database connection] to which the SQL
  /// function is to be added.  ^If an application uses more than one database
  /// connection then application-defined SQL functions must be added
  /// to each database connection separately.
  ///
  /// ^The second parameter is the name of the SQL function to be created or
  /// redefined.  ^The length of the name is limited to 255 bytes in a UTF-8
  /// representation, exclusive of the zero-terminator.  ^Note that the name
  /// length limit is in UTF-8 bytes, not characters nor UTF-16 bytes.
  /// ^Any attempt to create a function with a longer name
  /// will result in [SQLITE_MISUSE] being returned.
  ///
  /// ^The third parameter (nArg)
  /// is the number of arguments that the SQL function or
  /// aggregate takes. ^If this parameter is -1, then the SQL function or
  /// aggregate may take any number of arguments between 0 and the limit
  /// set by [sqlite3_limit]([SQLITE_LIMIT_FUNCTION_ARG]).  If the third
  /// parameter is less than -1 or greater than 127 then the behavior is
  /// undefined.
  ///
  /// ^The fourth parameter, eTextRep, specifies what
  /// [SQLITE_UTF8 | text encoding] this SQL function prefers for
  /// its parameters.  The application should set this parameter to
  /// [SQLITE_UTF16LE] if the function implementation invokes
  /// [sqlite3_value_text16le()] on an input, or [SQLITE_UTF16BE] if the
  /// implementation invokes [sqlite3_value_text16be()] on an input, or
  /// [SQLITE_UTF16] if [sqlite3_value_text16()] is used, or [SQLITE_UTF8]
  /// otherwise.  ^The same SQL function may be registered multiple times using
  /// different preferred text encodings, with different implementations for
  /// each encoding.
  /// ^When multiple implementations of the same function are available, SQLite
  /// will pick the one that involves the least amount of data conversion.
  ///
  /// ^The fourth parameter may optionally be ORed with [SQLITE_DETERMINISTIC]
  /// to signal that the function will always return the same result given
  /// the same inputs within a single SQL statement.  Most SQL functions are
  /// deterministic.  The built-in [random()] SQL function is an example of a
  /// function that is not deterministic.  The SQLite query planner is able to
  /// perform additional optimizations on deterministic functions, so use
  /// of the [SQLITE_DETERMINISTIC] flag is recommended where possible.
  ///
  /// ^The fourth parameter may also optionally include the [SQLITE_DIRECTONLY]
  /// flag, which if present prevents the function from being invoked from
  /// within VIEWs, TRIGGERs, CHECK constraints, generated column expressions,
  /// index expressions, or the WHERE clause of partial indexes.
  ///
  /// <span style="background-color:#ffff90;">
  /// For best security, the [SQLITE_DIRECTONLY] flag is recommended for
  /// all application-defined SQL functions that do not need to be
  /// used inside of triggers, view, CHECK constraints, or other elements of
  /// the database schema.  This flags is especially recommended for SQL
  /// functions that have side effects or reveal internal application state.
  /// Without this flag, an attacker might be able to modify the schema of
  /// a database file to include invocations of the function with parameters
  /// chosen by the attacker, which the application will then execute when
  /// the database file is opened and read.
  /// </span>
  ///
  /// ^(The fifth parameter is an arbitrary pointer.  The implementation of the
  /// function can gain access to this pointer using [sqlite3_user_data()].)^
  ///
  /// ^The sixth, seventh and eighth parameters passed to the three
  /// "sqlite3_create_function*" functions, xFunc, xStep and xFinal, are
  /// pointers to C-language functions that implement the SQL function or
  /// aggregate. ^A scalar SQL function requires an implementation of the xFunc
  /// callback only; NULL pointers must be passed as the xStep and xFinal
  /// parameters. ^An aggregate SQL function requires an implementation of xStep
  /// and xFinal and NULL pointer must be passed for xFunc. ^To delete an existing
  /// SQL function or aggregate, pass NULL pointers for all three function
  /// callbacks.
  ///
  /// ^The sixth, seventh, eighth and ninth parameters (xStep, xFinal, xValue
  /// and xInverse) passed to sqlite3_create_window_function are pointers to
  /// C-language callbacks that implement the new function. xStep and xFinal
  /// must both be non-NULL. xValue and xInverse may either both be NULL, in
  /// which case a regular aggregate function is created, or must both be
  /// non-NULL, in which case the new function may be used as either an aggregate
  /// or aggregate window function. More details regarding the implementation
  /// of aggregate window functions are
  /// [user-defined window functions|available here].
  ///
  /// ^(If the final parameter to sqlite3_create_function_v2() or
  /// sqlite3_create_window_function() is not NULL, then it is destructor for
  /// the application data pointer. The destructor is invoked when the function
  /// is deleted, either by being overloaded or when the database connection
  /// closes.)^ ^The destructor is also invoked if the call to
  /// sqlite3_create_function_v2() fails.  ^When the destructor callback is
  /// invoked, it is passed a single argument which is a copy of the application
  /// data pointer which was the fifth parameter to sqlite3_create_function_v2().
  ///
  /// ^It is permitted to register multiple implementations of the same
  /// functions with the same name but with either differing numbers of
  /// arguments or differing preferred text encodings.  ^SQLite will use
  /// the implementation that most closely matches the way in which the
  /// SQL function is used.  ^A function implementation with a non-negative
  /// nArg parameter is a better match than a function implementation with
  /// a negative nArg.  ^A function where the preferred text encoding
  /// matches the database encoding is a better
  /// match than a function where the encoding is different.
  /// ^A function where the encoding difference is between UTF16le and UTF16be
  /// is a closer match than a function where the encoding difference is
  /// between UTF8 and UTF16.
  ///
  /// ^Built-in functions may be overloaded by new application-defined functions.
  ///
  /// ^An application-defined function is permitted to call other
  /// SQLite interfaces.  However, such calls must not
  /// close the database connection nor finalize or reset the prepared
  /// statement in which the function is running.
  int sqlite3_create_function(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zFunctionName,
    int nArg,
    int eTextRep,
    ffi.Pointer<ffi.Void> pApp,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                    ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>
        xFunc,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                    ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>
        xStep,
    ffi.Pointer<
            ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_context>)>>
        xFinal,
  ) {
    return _sqlite3_create_function(
      db,
      zFunctionName,
      nArg,
      eTextRep,
      pApp,
      xFunc,
      xStep,
      xFinal,
    );
  }

  late final _sqlite3_create_functionPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ffi.Pointer<sqlite3>,
                      ffi.Pointer<ffi.Char>,
                      ffi.Int,
                      ffi.Int,
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>)>>)>>(
          'sqlite3_create_function');
  late final _sqlite3_create_function = _sqlite3_create_functionPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>,
          int,
          int,
          ffi.Pointer<ffi.Void>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                      ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                      ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(ffi.Pointer<sqlite3_context>)>>)>();

  int sqlite3_create_function16(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Void> zFunctionName,
    int nArg,
    int eTextRep,
    ffi.Pointer<ffi.Void> pApp,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                    ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>
        xFunc,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                    ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>
        xStep,
    ffi.Pointer<
            ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_context>)>>
        xFinal,
  ) {
    return _sqlite3_create_function16(
      db,
      zFunctionName,
      nArg,
      eTextRep,
      pApp,
      xFunc,
      xStep,
      xFinal,
    );
  }

  late final _sqlite3_create_function16Ptr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ffi.Pointer<sqlite3>,
                      ffi.Pointer<ffi.Void>,
                      ffi.Int,
                      ffi.Int,
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>)>>)>>(
          'sqlite3_create_function16');
  late final _sqlite3_create_function16 =
      _sqlite3_create_function16Ptr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              int,
              int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                          ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                          ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>)>>)>();

  int sqlite3_create_function_v2(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zFunctionName,
    int nArg,
    int eTextRep,
    ffi.Pointer<ffi.Void> pApp,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                    ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>
        xFunc,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                    ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>
        xStep,
    ffi.Pointer<
            ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_context>)>>
        xFinal,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        xDestroy,
  ) {
    return _sqlite3_create_function_v2(
      db,
      zFunctionName,
      nArg,
      eTextRep,
      pApp,
      xFunc,
      xStep,
      xFinal,
      xDestroy,
    );
  }

  late final _sqlite3_create_function_v2Ptr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ffi.Pointer<sqlite3>,
                      ffi.Pointer<ffi.Char>,
                      ffi.Int,
                      ffi.Int,
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(ffi.Pointer<sqlite3_context>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>>(
          'sqlite3_create_function_v2');
  late final _sqlite3_create_function_v2 =
      _sqlite3_create_function_v2Ptr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              int,
              int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                          ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                          ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_create_window_function(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zFunctionName,
    int nArg,
    int eTextRep,
    ffi.Pointer<ffi.Void> pApp,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                    ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>
        xStep,
    ffi.Pointer<
            ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_context>)>>
        xFinal,
    ffi.Pointer<
            ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_context>)>>
        xValue,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                    ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>
        xInverse,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        xDestroy,
  ) {
    return _sqlite3_create_window_function(
      db,
      zFunctionName,
      nArg,
      eTextRep,
      pApp,
      xStep,
      xFinal,
      xValue,
      xInverse,
      xDestroy,
    );
  }

  late final _sqlite3_create_window_functionPtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ffi.Pointer<sqlite3>,
                      ffi.Pointer<ffi.Char>,
                      ffi.Int,
                      ffi.Int,
                      ffi.Pointer<ffi.Void>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(ffi.Pointer<sqlite3_context>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(ffi.Pointer<sqlite3_context>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>>(
          'sqlite3_create_window_function');
  late final _sqlite3_create_window_function =
      _sqlite3_create_window_functionPtr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              int,
              int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                          ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Int,
                          ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_aggregate_count(
    ffi.Pointer<sqlite3_context> arg0,
  ) {
    return _sqlite3_aggregate_count(
      arg0,
    );
  }

  late final _sqlite3_aggregate_countPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_context>)>>(
      'sqlite3_aggregate_count');
  late final _sqlite3_aggregate_count = _sqlite3_aggregate_countPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_context>)>();

  int sqlite3_expired(
    ffi.Pointer<sqlite3_stmt> arg0,
  ) {
    return _sqlite3_expired(
      arg0,
    );
  }

  late final _sqlite3_expiredPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_expired');
  late final _sqlite3_expired =
      _sqlite3_expiredPtr.asFunction<int Function(ffi.Pointer<sqlite3_stmt>)>();

  int sqlite3_transfer_bindings(
    ffi.Pointer<sqlite3_stmt> arg0,
    ffi.Pointer<sqlite3_stmt> arg1,
  ) {
    return _sqlite3_transfer_bindings(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_transfer_bindingsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>,
              ffi.Pointer<sqlite3_stmt>)>>('sqlite3_transfer_bindings');
  late final _sqlite3_transfer_bindings =
      _sqlite3_transfer_bindingsPtr.asFunction<
          int Function(ffi.Pointer<sqlite3_stmt>, ffi.Pointer<sqlite3_stmt>)>();

  int sqlite3_global_recover() {
    return _sqlite3_global_recover();
  }

  late final _sqlite3_global_recoverPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>('sqlite3_global_recover');
  late final _sqlite3_global_recover =
      _sqlite3_global_recoverPtr.asFunction<int Function()>();

  void sqlite3_thread_cleanup() {
    return _sqlite3_thread_cleanup();
  }

  late final _sqlite3_thread_cleanupPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function()>>(
          'sqlite3_thread_cleanup');
  late final _sqlite3_thread_cleanup =
      _sqlite3_thread_cleanupPtr.asFunction<void Function()>();

  int sqlite3_memory_alarm(
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(
                    ffi.Pointer<ffi.Void>, sqlite3_int64, ffi.Int)>>
        arg0,
    ffi.Pointer<ffi.Void> arg1,
    int arg2,
  ) {
    return _sqlite3_memory_alarm(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_memory_alarmPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>, sqlite3_int64, ffi.Int)>>,
              ffi.Pointer<ffi.Void>,
              sqlite3_int64)>>('sqlite3_memory_alarm');
  late final _sqlite3_memory_alarm = _sqlite3_memory_alarmPtr.asFunction<
      int Function(
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<ffi.Void>, sqlite3_int64, ffi.Int)>>,
          ffi.Pointer<ffi.Void>,
          int)>();

  /// CAPI3REF: Obtaining SQL Values
  /// METHOD: sqlite3_value
  ///
  /// <b>Summary:</b>
  /// <blockquote><table border=0 cellpadding=0 cellspacing=0>
  /// <tr><td><b>sqlite3_value_blob</b><td>&rarr;<td>BLOB value
  /// <tr><td><b>sqlite3_value_double</b><td>&rarr;<td>REAL value
  /// <tr><td><b>sqlite3_value_int</b><td>&rarr;<td>32-bit INTEGER value
  /// <tr><td><b>sqlite3_value_int64</b><td>&rarr;<td>64-bit INTEGER value
  /// <tr><td><b>sqlite3_value_pointer</b><td>&rarr;<td>Pointer value
  /// <tr><td><b>sqlite3_value_text</b><td>&rarr;<td>UTF-8 TEXT value
  /// <tr><td><b>sqlite3_value_text16</b><td>&rarr;<td>UTF-16 TEXT value in
  /// the native byteorder
  /// <tr><td><b>sqlite3_value_text16be</b><td>&rarr;<td>UTF-16be TEXT value
  /// <tr><td><b>sqlite3_value_text16le</b><td>&rarr;<td>UTF-16le TEXT value
  /// <tr><td>&nbsp;<td>&nbsp;<td>&nbsp;
  /// <tr><td><b>sqlite3_value_bytes</b><td>&rarr;<td>Size of a BLOB
  /// or a UTF-8 TEXT in bytes
  /// <tr><td><b>sqlite3_value_bytes16&nbsp;&nbsp;</b>
  /// <td>&rarr;&nbsp;&nbsp;<td>Size of UTF-16
  /// TEXT in bytes
  /// <tr><td><b>sqlite3_value_type</b><td>&rarr;<td>Default
  /// datatype of the value
  /// <tr><td><b>sqlite3_value_numeric_type&nbsp;&nbsp;</b>
  /// <td>&rarr;&nbsp;&nbsp;<td>Best numeric datatype of the value
  /// <tr><td><b>sqlite3_value_nochange&nbsp;&nbsp;</b>
  /// <td>&rarr;&nbsp;&nbsp;<td>True if the column is unchanged in an UPDATE
  /// against a virtual table.
  /// <tr><td><b>sqlite3_value_frombind&nbsp;&nbsp;</b>
  /// <td>&rarr;&nbsp;&nbsp;<td>True if value originated from a [bound parameter]
  /// </table></blockquote>
  ///
  /// <b>Details:</b>
  ///
  /// These routines extract type, size, and content information from
  /// [protected sqlite3_value] objects.  Protected sqlite3_value objects
  /// are used to pass parameter information into the functions that
  /// implement [application-defined SQL functions] and [virtual tables].
  ///
  /// These routines work only with [protected sqlite3_value] objects.
  /// Any attempt to use these routines on an [unprotected sqlite3_value]
  /// is not threadsafe.
  ///
  /// ^These routines work just like the corresponding [column access functions]
  /// except that these routines take a single [protected sqlite3_value] object
  /// pointer instead of a [sqlite3_stmt*] pointer and an integer column number.
  ///
  /// ^The sqlite3_value_text16() interface extracts a UTF-16 string
  /// in the native byte-order of the host machine.  ^The
  /// sqlite3_value_text16be() and sqlite3_value_text16le() interfaces
  /// extract UTF-16 strings as big-endian and little-endian respectively.
  ///
  /// ^If [sqlite3_value] object V was initialized
  /// using [sqlite3_bind_pointer(S,I,P,X,D)] or [sqlite3_result_pointer(C,P,X,D)]
  /// and if X and Y are strings that compare equal according to strcmp(X,Y),
  /// then sqlite3_value_pointer(V,Y) will return the pointer P.  ^Otherwise,
  /// sqlite3_value_pointer(V,Y) returns a NULL. The sqlite3_bind_pointer()
  /// routine is part of the [pointer passing interface] added for SQLite 3.20.0.
  ///
  /// ^(The sqlite3_value_type(V) interface returns the
  /// [SQLITE_INTEGER | datatype code] for the initial datatype of the
  /// [sqlite3_value] object V. The returned value is one of [SQLITE_INTEGER],
  /// [SQLITE_FLOAT], [SQLITE_TEXT], [SQLITE_BLOB], or [SQLITE_NULL].)^
  /// Other interfaces might change the datatype for an sqlite3_value object.
  /// For example, if the datatype is initially SQLITE_INTEGER and
  /// sqlite3_value_text(V) is called to extract a text value for that
  /// integer, then subsequent calls to sqlite3_value_type(V) might return
  /// SQLITE_TEXT.  Whether or not a persistent internal datatype conversion
  /// occurs is undefined and may change from one release of SQLite to the next.
  ///
  /// ^(The sqlite3_value_numeric_type() interface attempts to apply
  /// numeric affinity to the value.  This means that an attempt is
  /// made to convert the value to an integer or floating point.  If
  /// such a conversion is possible without loss of information (in other
  /// words, if the value is a string that looks like a number)
  /// then the conversion is performed.  Otherwise no conversion occurs.
  /// The [SQLITE_INTEGER | datatype] after conversion is returned.)^
  ///
  /// ^Within the [xUpdate] method of a [virtual table], the
  /// sqlite3_value_nochange(X) interface returns true if and only if
  /// the column corresponding to X is unchanged by the UPDATE operation
  /// that the xUpdate method call was invoked to implement and if
  /// and the prior [xColumn] method call that was invoked to extracted
  /// the value for that column returned without setting a result (probably
  /// because it queried [sqlite3_vtab_nochange()] and found that the column
  /// was unchanging).  ^Within an [xUpdate] method, any value for which
  /// sqlite3_value_nochange(X) is true will in all other respects appear
  /// to be a NULL value.  If sqlite3_value_nochange(X) is invoked anywhere other
  /// than within an [xUpdate] method call for an UPDATE statement, then
  /// the return value is arbitrary and meaningless.
  ///
  /// ^The sqlite3_value_frombind(X) interface returns non-zero if the
  /// value X originated from one of the [sqlite3_bind_int|sqlite3_bind()]
  /// interfaces.  ^If X comes from an SQL literal value, or a table column,
  /// or an expression, then sqlite3_value_frombind(X) returns zero.
  ///
  /// Please pay particular attention to the fact that the pointer returned
  /// from [sqlite3_value_blob()], [sqlite3_value_text()], or
  /// [sqlite3_value_text16()] can be invalidated by a subsequent call to
  /// [sqlite3_value_bytes()], [sqlite3_value_bytes16()], [sqlite3_value_text()],
  /// or [sqlite3_value_text16()].
  ///
  /// These routines must be called from the same thread as
  /// the SQL function that supplied the [sqlite3_value*] parameters.
  ///
  /// As long as the input parameter is correct, these routines can only
  /// fail if an out-of-memory error occurs during a format conversion.
  /// Only the following subset of interfaces are subject to out-of-memory
  /// errors:
  ///
  /// <ul>
  /// <li> sqlite3_value_blob()
  /// <li> sqlite3_value_text()
  /// <li> sqlite3_value_text16()
  /// <li> sqlite3_value_text16le()
  /// <li> sqlite3_value_text16be()
  /// <li> sqlite3_value_bytes()
  /// <li> sqlite3_value_bytes16()
  /// </ul>
  ///
  /// If an out-of-memory error occurs, then the return value from these
  /// routines is the same as if the column had contained an SQL NULL value.
  /// Valid SQL NULL returns can be distinguished from out-of-memory errors
  /// by invoking the [sqlite3_errcode()] immediately after the suspect
  /// return value is obtained and before any
  /// other SQLite interface is called on the same [database connection].
  ffi.Pointer<ffi.Void> sqlite3_value_blob(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_blob(
      arg0,
    );
  }

  late final _sqlite3_value_blobPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_value>)>>('sqlite3_value_blob');
  late final _sqlite3_value_blob = _sqlite3_value_blobPtr
      .asFunction<ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_value>)>();

  double sqlite3_value_double(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_double(
      arg0,
    );
  }

  late final _sqlite3_value_doublePtr = _lookup<
          ffi.NativeFunction<ffi.Double Function(ffi.Pointer<sqlite3_value>)>>(
      'sqlite3_value_double');
  late final _sqlite3_value_double = _sqlite3_value_doublePtr
      .asFunction<double Function(ffi.Pointer<sqlite3_value>)>();

  int sqlite3_value_int(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_int(
      arg0,
    );
  }

  late final _sqlite3_value_intPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_value>)>>(
          'sqlite3_value_int');
  late final _sqlite3_value_int = _sqlite3_value_intPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  int sqlite3_value_int64(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_int64(
      arg0,
    );
  }

  late final _sqlite3_value_int64Ptr = _lookup<
          ffi
          .NativeFunction<sqlite3_int64 Function(ffi.Pointer<sqlite3_value>)>>(
      'sqlite3_value_int64');
  late final _sqlite3_value_int64 = _sqlite3_value_int64Ptr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  ffi.Pointer<ffi.Void> sqlite3_value_pointer(
    ffi.Pointer<sqlite3_value> arg0,
    ffi.Pointer<ffi.Char> arg1,
  ) {
    return _sqlite3_value_pointer(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_value_pointerPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_value>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_value_pointer');
  late final _sqlite3_value_pointer = _sqlite3_value_pointerPtr.asFunction<
      ffi.Pointer<ffi.Void> Function(
          ffi.Pointer<sqlite3_value>, ffi.Pointer<ffi.Char>)>();

  ffi.Pointer<ffi.UnsignedChar> sqlite3_value_text(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_text(
      arg0,
    );
  }

  late final _sqlite3_value_textPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<sqlite3_value>)>>('sqlite3_value_text');
  late final _sqlite3_value_text = _sqlite3_value_textPtr.asFunction<
      ffi.Pointer<ffi.UnsignedChar> Function(ffi.Pointer<sqlite3_value>)>();

  ffi.Pointer<ffi.Void> sqlite3_value_text16(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_text16(
      arg0,
    );
  }

  late final _sqlite3_value_text16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_value>)>>('sqlite3_value_text16');
  late final _sqlite3_value_text16 = _sqlite3_value_text16Ptr
      .asFunction<ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_value>)>();

  ffi.Pointer<ffi.Void> sqlite3_value_text16le(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_text16le(
      arg0,
    );
  }

  late final _sqlite3_value_text16lePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_value>)>>('sqlite3_value_text16le');
  late final _sqlite3_value_text16le = _sqlite3_value_text16lePtr
      .asFunction<ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_value>)>();

  ffi.Pointer<ffi.Void> sqlite3_value_text16be(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_text16be(
      arg0,
    );
  }

  late final _sqlite3_value_text16bePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_value>)>>('sqlite3_value_text16be');
  late final _sqlite3_value_text16be = _sqlite3_value_text16bePtr
      .asFunction<ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_value>)>();

  int sqlite3_value_bytes(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_bytes(
      arg0,
    );
  }

  late final _sqlite3_value_bytesPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_value>)>>(
          'sqlite3_value_bytes');
  late final _sqlite3_value_bytes = _sqlite3_value_bytesPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  int sqlite3_value_bytes16(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_bytes16(
      arg0,
    );
  }

  late final _sqlite3_value_bytes16Ptr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_value>)>>(
          'sqlite3_value_bytes16');
  late final _sqlite3_value_bytes16 = _sqlite3_value_bytes16Ptr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  int sqlite3_value_type(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_type(
      arg0,
    );
  }

  late final _sqlite3_value_typePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_value>)>>(
          'sqlite3_value_type');
  late final _sqlite3_value_type = _sqlite3_value_typePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  int sqlite3_value_numeric_type(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_numeric_type(
      arg0,
    );
  }

  late final _sqlite3_value_numeric_typePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_value>)>>(
          'sqlite3_value_numeric_type');
  late final _sqlite3_value_numeric_type = _sqlite3_value_numeric_typePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  int sqlite3_value_nochange(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_nochange(
      arg0,
    );
  }

  late final _sqlite3_value_nochangePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_value>)>>(
          'sqlite3_value_nochange');
  late final _sqlite3_value_nochange = _sqlite3_value_nochangePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  int sqlite3_value_frombind(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_frombind(
      arg0,
    );
  }

  late final _sqlite3_value_frombindPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_value>)>>(
          'sqlite3_value_frombind');
  late final _sqlite3_value_frombind = _sqlite3_value_frombindPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  /// CAPI3REF: Finding The Subtype Of SQL Values
  /// METHOD: sqlite3_value
  ///
  /// The sqlite3_value_subtype(V) function returns the subtype for
  /// an [application-defined SQL function] argument V.  The subtype
  /// information can be used to pass a limited amount of context from
  /// one SQL function to another.  Use the [sqlite3_result_subtype()]
  /// routine to set the subtype for the return value of an SQL function.
  int sqlite3_value_subtype(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_subtype(
      arg0,
    );
  }

  late final _sqlite3_value_subtypePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<sqlite3_value>)>>('sqlite3_value_subtype');
  late final _sqlite3_value_subtype = _sqlite3_value_subtypePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_value>)>();

  /// CAPI3REF: Copy And Free SQL Values
  /// METHOD: sqlite3_value
  ///
  /// ^The sqlite3_value_dup(V) interface makes a copy of the [sqlite3_value]
  /// object D and returns a pointer to that copy.  ^The [sqlite3_value] returned
  /// is a [protected sqlite3_value] object even if the input is not.
  /// ^The sqlite3_value_dup(V) interface returns NULL if V is NULL or if a
  /// memory allocation fails.
  ///
  /// ^The sqlite3_value_free(V) interface frees an [sqlite3_value] object
  /// previously obtained from [sqlite3_value_dup()].  ^If V is a NULL pointer
  /// then sqlite3_value_free(V) is a harmless no-op.
  ffi.Pointer<sqlite3_value> sqlite3_value_dup(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_dup(
      arg0,
    );
  }

  late final _sqlite3_value_dupPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_value> Function(
              ffi.Pointer<sqlite3_value>)>>('sqlite3_value_dup');
  late final _sqlite3_value_dup = _sqlite3_value_dupPtr.asFunction<
      ffi.Pointer<sqlite3_value> Function(ffi.Pointer<sqlite3_value>)>();

  void sqlite3_value_free(
    ffi.Pointer<sqlite3_value> arg0,
  ) {
    return _sqlite3_value_free(
      arg0,
    );
  }

  late final _sqlite3_value_freePtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_value>)>>(
      'sqlite3_value_free');
  late final _sqlite3_value_free = _sqlite3_value_freePtr
      .asFunction<void Function(ffi.Pointer<sqlite3_value>)>();

  /// CAPI3REF: Obtain Aggregate Function Context
  /// METHOD: sqlite3_context
  ///
  /// Implementations of aggregate SQL functions use this
  /// routine to allocate memory for storing their state.
  ///
  /// ^The first time the sqlite3_aggregate_context(C,N) routine is called
  /// for a particular aggregate function, SQLite allocates
  /// N bytes of memory, zeroes out that memory, and returns a pointer
  /// to the new memory. ^On second and subsequent calls to
  /// sqlite3_aggregate_context() for the same aggregate function instance,
  /// the same buffer is returned.  Sqlite3_aggregate_context() is normally
  /// called once for each invocation of the xStep callback and then one
  /// last time when the xFinal callback is invoked.  ^(When no rows match
  /// an aggregate query, the xStep() callback of the aggregate function
  /// implementation is never called and xFinal() is called exactly once.
  /// In those cases, sqlite3_aggregate_context() might be called for the
  /// first time from within xFinal().)^
  ///
  /// ^The sqlite3_aggregate_context(C,N) routine returns a NULL pointer
  /// when first called if N is less than or equal to zero or if a memory
  /// allocate error occurs.
  ///
  /// ^(The amount of space allocated by sqlite3_aggregate_context(C,N) is
  /// determined by the N parameter on first successful call.  Changing the
  /// value of N in any subsequent call to sqlite3_aggregate_context() within
  /// the same aggregate function instance will not resize the memory
  /// allocation.)^  Within the xFinal callback, it is customary to set
  /// N=0 in calls to sqlite3_aggregate_context(C,N) so that no
  /// pointless memory allocations occur.
  ///
  /// ^SQLite automatically frees the memory allocated by
  /// sqlite3_aggregate_context() when the aggregate query concludes.
  ///
  /// The first parameter must be a copy of the
  /// [sqlite3_context | SQL function context] that is the first parameter
  /// to the xStep or xFinal callback routine that implements the aggregate
  /// function.
  ///
  /// This routine must be called from the same thread in which
  /// the aggregate SQL function is running.
  ffi.Pointer<ffi.Void> sqlite3_aggregate_context(
    ffi.Pointer<sqlite3_context> arg0,
    int nBytes,
  ) {
    return _sqlite3_aggregate_context(
      arg0,
      nBytes,
    );
  }

  late final _sqlite3_aggregate_contextPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_context>,
              ffi.Int)>>('sqlite3_aggregate_context');
  late final _sqlite3_aggregate_context =
      _sqlite3_aggregate_contextPtr.asFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_context>, int)>();

  /// CAPI3REF: User Data For Functions
  /// METHOD: sqlite3_context
  ///
  /// ^The sqlite3_user_data() interface returns a copy of
  /// the pointer that was the pUserData parameter (the 5th parameter)
  /// of the [sqlite3_create_function()]
  /// and [sqlite3_create_function16()] routines that originally
  /// registered the application defined function.
  ///
  /// This routine must be called from the same thread in which
  /// the application-defined function is running.
  ffi.Pointer<ffi.Void> sqlite3_user_data(
    ffi.Pointer<sqlite3_context> arg0,
  ) {
    return _sqlite3_user_data(
      arg0,
    );
  }

  late final _sqlite3_user_dataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_context>)>>('sqlite3_user_data');
  late final _sqlite3_user_data = _sqlite3_user_dataPtr.asFunction<
      ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_context>)>();

  /// CAPI3REF: Database Connection For Functions
  /// METHOD: sqlite3_context
  ///
  /// ^The sqlite3_context_db_handle() interface returns a copy of
  /// the pointer to the [database connection] (the 1st parameter)
  /// of the [sqlite3_create_function()]
  /// and [sqlite3_create_function16()] routines that originally
  /// registered the application defined function.
  ffi.Pointer<sqlite3> sqlite3_context_db_handle(
    ffi.Pointer<sqlite3_context> arg0,
  ) {
    return _sqlite3_context_db_handle(
      arg0,
    );
  }

  late final _sqlite3_context_db_handlePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3> Function(
              ffi.Pointer<sqlite3_context>)>>('sqlite3_context_db_handle');
  late final _sqlite3_context_db_handle =
      _sqlite3_context_db_handlePtr.asFunction<
          ffi.Pointer<sqlite3> Function(ffi.Pointer<sqlite3_context>)>();

  /// CAPI3REF: Function Auxiliary Data
  /// METHOD: sqlite3_context
  ///
  /// These functions may be used by (non-aggregate) SQL functions to
  /// associate metadata with argument values. If the same value is passed to
  /// multiple invocations of the same SQL function during query execution, under
  /// some circumstances the associated metadata may be preserved.  An example
  /// of where this might be useful is in a regular-expression matching
  /// function. The compiled version of the regular expression can be stored as
  /// metadata associated with the pattern string.
  /// Then as long as the pattern string remains the same,
  /// the compiled regular expression can be reused on multiple
  /// invocations of the same function.
  ///
  /// ^The sqlite3_get_auxdata(C,N) interface returns a pointer to the metadata
  /// associated by the sqlite3_set_auxdata(C,N,P,X) function with the Nth argument
  /// value to the application-defined function.  ^N is zero for the left-most
  /// function argument.  ^If there is no metadata
  /// associated with the function argument, the sqlite3_get_auxdata(C,N) interface
  /// returns a NULL pointer.
  ///
  /// ^The sqlite3_set_auxdata(C,N,P,X) interface saves P as metadata for the N-th
  /// argument of the application-defined function.  ^Subsequent
  /// calls to sqlite3_get_auxdata(C,N) return P from the most recent
  /// sqlite3_set_auxdata(C,N,P,X) call if the metadata is still valid or
  /// NULL if the metadata has been discarded.
  /// ^After each call to sqlite3_set_auxdata(C,N,P,X) where X is not NULL,
  /// SQLite will invoke the destructor function X with parameter P exactly
  /// once, when the metadata is discarded.
  /// SQLite is free to discard the metadata at any time, including: <ul>
  /// <li> ^(when the corresponding function parameter changes)^, or
  /// <li> ^(when [sqlite3_reset()] or [sqlite3_finalize()] is called for the
  /// SQL statement)^, or
  /// <li> ^(when sqlite3_set_auxdata() is invoked again on the same
  /// parameter)^, or
  /// <li> ^(during the original sqlite3_set_auxdata() call when a memory
  /// allocation error occurs.)^ </ul>
  ///
  /// Note the last bullet in particular.  The destructor X in
  /// sqlite3_set_auxdata(C,N,P,X) might be called immediately, before the
  /// sqlite3_set_auxdata() interface even returns.  Hence sqlite3_set_auxdata()
  /// should be called near the end of the function implementation and the
  /// function implementation should not make any use of P after
  /// sqlite3_set_auxdata() has been called.
  ///
  /// ^(In practice, metadata is preserved between function calls for
  /// function parameters that are compile-time constants, including literal
  /// values and [parameters] and expressions composed from the same.)^
  ///
  /// The value of the N parameter to these interfaces should be non-negative.
  /// Future enhancements may make use of negative N values to define new
  /// kinds of function caching behavior.
  ///
  /// These routines must be called from the same thread in which
  /// the SQL function is running.
  ffi.Pointer<ffi.Void> sqlite3_get_auxdata(
    ffi.Pointer<sqlite3_context> arg0,
    int N,
  ) {
    return _sqlite3_get_auxdata(
      arg0,
      N,
    );
  }

  late final _sqlite3_get_auxdataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_context>, ffi.Int)>>('sqlite3_get_auxdata');
  late final _sqlite3_get_auxdata = _sqlite3_get_auxdataPtr.asFunction<
      ffi.Pointer<ffi.Void> Function(ffi.Pointer<sqlite3_context>, int)>();

  void sqlite3_set_auxdata(
    ffi.Pointer<sqlite3_context> arg0,
    int N,
    ffi.Pointer<ffi.Void> arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
  ) {
    return _sqlite3_set_auxdata(
      arg0,
      N,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_set_auxdataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_context>,
              ffi.Int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_set_auxdata');
  late final _sqlite3_set_auxdata = _sqlite3_set_auxdataPtr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          int,
          ffi.Pointer<ffi.Void>,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  /// CAPI3REF: Setting The Result Of An SQL Function
  /// METHOD: sqlite3_context
  ///
  /// These routines are used by the xFunc or xFinal callbacks that
  /// implement SQL functions and aggregates.  See
  /// [sqlite3_create_function()] and [sqlite3_create_function16()]
  /// for additional information.
  ///
  /// These functions work very much like the [parameter binding] family of
  /// functions used to bind values to host parameters in prepared statements.
  /// Refer to the [SQL parameter] documentation for additional information.
  ///
  /// ^The sqlite3_result_blob() interface sets the result from
  /// an application-defined function to be the BLOB whose content is pointed
  /// to by the second parameter and which is N bytes long where N is the
  /// third parameter.
  ///
  /// ^The sqlite3_result_zeroblob(C,N) and sqlite3_result_zeroblob64(C,N)
  /// interfaces set the result of the application-defined function to be
  /// a BLOB containing all zero bytes and N bytes in size.
  ///
  /// ^The sqlite3_result_double() interface sets the result from
  /// an application-defined function to be a floating point value specified
  /// by its 2nd argument.
  ///
  /// ^The sqlite3_result_error() and sqlite3_result_error16() functions
  /// cause the implemented SQL function to throw an exception.
  /// ^SQLite uses the string pointed to by the
  /// 2nd parameter of sqlite3_result_error() or sqlite3_result_error16()
  /// as the text of an error message.  ^SQLite interprets the error
  /// message string from sqlite3_result_error() as UTF-8. ^SQLite
  /// interprets the string from sqlite3_result_error16() as UTF-16 using
  /// the same [byte-order determination rules] as [sqlite3_bind_text16()].
  /// ^If the third parameter to sqlite3_result_error()
  /// or sqlite3_result_error16() is negative then SQLite takes as the error
  /// message all text up through the first zero character.
  /// ^If the third parameter to sqlite3_result_error() or
  /// sqlite3_result_error16() is non-negative then SQLite takes that many
  /// bytes (not characters) from the 2nd parameter as the error message.
  /// ^The sqlite3_result_error() and sqlite3_result_error16()
  /// routines make a private copy of the error message text before
  /// they return.  Hence, the calling function can deallocate or
  /// modify the text after they return without harm.
  /// ^The sqlite3_result_error_code() function changes the error code
  /// returned by SQLite as a result of an error in a function.  ^By default,
  /// the error code is SQLITE_ERROR.  ^A subsequent call to sqlite3_result_error()
  /// or sqlite3_result_error16() resets the error code to SQLITE_ERROR.
  ///
  /// ^The sqlite3_result_error_toobig() interface causes SQLite to throw an
  /// error indicating that a string or BLOB is too long to represent.
  ///
  /// ^The sqlite3_result_error_nomem() interface causes SQLite to throw an
  /// error indicating that a memory allocation failed.
  ///
  /// ^The sqlite3_result_int() interface sets the return value
  /// of the application-defined function to be the 32-bit signed integer
  /// value given in the 2nd argument.
  /// ^The sqlite3_result_int64() interface sets the return value
  /// of the application-defined function to be the 64-bit signed integer
  /// value given in the 2nd argument.
  ///
  /// ^The sqlite3_result_null() interface sets the return value
  /// of the application-defined function to be NULL.
  ///
  /// ^The sqlite3_result_text(), sqlite3_result_text16(),
  /// sqlite3_result_text16le(), and sqlite3_result_text16be() interfaces
  /// set the return value of the application-defined function to be
  /// a text string which is represented as UTF-8, UTF-16 native byte order,
  /// UTF-16 little endian, or UTF-16 big endian, respectively.
  /// ^The sqlite3_result_text64() interface sets the return value of an
  /// application-defined function to be a text string in an encoding
  /// specified by the fifth (and last) parameter, which must be one
  /// of [SQLITE_UTF8], [SQLITE_UTF16], [SQLITE_UTF16BE], or [SQLITE_UTF16LE].
  /// ^SQLite takes the text result from the application from
  /// the 2nd parameter of the sqlite3_result_text* interfaces.
  /// ^If the 3rd parameter to the sqlite3_result_text* interfaces
  /// is negative, then SQLite takes result text from the 2nd parameter
  /// through the first zero character.
  /// ^If the 3rd parameter to the sqlite3_result_text* interfaces
  /// is non-negative, then as many bytes (not characters) of the text
  /// pointed to by the 2nd parameter are taken as the application-defined
  /// function result.  If the 3rd parameter is non-negative, then it
  /// must be the byte offset into the string where the NUL terminator would
  /// appear if the string where NUL terminated.  If any NUL characters occur
  /// in the string at a byte offset that is less than the value of the 3rd
  /// parameter, then the resulting string will contain embedded NULs and the
  /// result of expressions operating on strings with embedded NULs is undefined.
  /// ^If the 4th parameter to the sqlite3_result_text* interfaces
  /// or sqlite3_result_blob is a non-NULL pointer, then SQLite calls that
  /// function as the destructor on the text or BLOB result when it has
  /// finished using that result.
  /// ^If the 4th parameter to the sqlite3_result_text* interfaces or to
  /// sqlite3_result_blob is the special constant SQLITE_STATIC, then SQLite
  /// assumes that the text or BLOB result is in constant space and does not
  /// copy the content of the parameter nor call a destructor on the content
  /// when it has finished using that result.
  /// ^If the 4th parameter to the sqlite3_result_text* interfaces
  /// or sqlite3_result_blob is the special constant SQLITE_TRANSIENT
  /// then SQLite makes a copy of the result into space obtained
  /// from [sqlite3_malloc()] before it returns.
  ///
  /// ^For the sqlite3_result_text16(), sqlite3_result_text16le(), and
  /// sqlite3_result_text16be() routines, and for sqlite3_result_text64()
  /// when the encoding is not UTF8, if the input UTF16 begins with a
  /// byte-order mark (BOM, U+FEFF) then the BOM is removed from the
  /// string and the rest of the string is interpreted according to the
  /// byte-order specified by the BOM.  ^The byte-order specified by
  /// the BOM at the beginning of the text overrides the byte-order
  /// specified by the interface procedure.  ^So, for example, if
  /// sqlite3_result_text16le() is invoked with text that begins
  /// with bytes 0xfe, 0xff (a big-endian byte-order mark) then the
  /// first two bytes of input are skipped and the remaining input
  /// is interpreted as UTF16BE text.
  ///
  /// ^For UTF16 input text to the sqlite3_result_text16(),
  /// sqlite3_result_text16be(), sqlite3_result_text16le(), and
  /// sqlite3_result_text64() routines, if the text contains invalid
  /// UTF16 characters, the invalid characters might be converted
  /// into the unicode replacement character, U+FFFD.
  ///
  /// ^The sqlite3_result_value() interface sets the result of
  /// the application-defined function to be a copy of the
  /// [unprotected sqlite3_value] object specified by the 2nd parameter.  ^The
  /// sqlite3_result_value() interface makes a copy of the [sqlite3_value]
  /// so that the [sqlite3_value] specified in the parameter may change or
  /// be deallocated after sqlite3_result_value() returns without harm.
  /// ^A [protected sqlite3_value] object may always be used where an
  /// [unprotected sqlite3_value] object is required, so either
  /// kind of [sqlite3_value] object can be used with this interface.
  ///
  /// ^The sqlite3_result_pointer(C,P,T,D) interface sets the result to an
  /// SQL NULL value, just like [sqlite3_result_null(C)], except that it
  /// also associates the host-language pointer P or type T with that
  /// NULL value such that the pointer can be retrieved within an
  /// [application-defined SQL function] using [sqlite3_value_pointer()].
  /// ^If the D parameter is not NULL, then it is a pointer to a destructor
  /// for the P parameter.  ^SQLite invokes D with P as its only argument
  /// when SQLite is finished with P.  The T parameter should be a static
  /// string and preferably a string literal. The sqlite3_result_pointer()
  /// routine is part of the [pointer passing interface] added for SQLite 3.20.0.
  ///
  /// If these routines are called from within the different thread
  /// than the one containing the application-defined function that received
  /// the [sqlite3_context] pointer, the results are undefined.
  void sqlite3_result_blob(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Void> arg1,
    int arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
  ) {
    return _sqlite3_result_blob(
      arg0,
      arg1,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_result_blobPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_context>,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_result_blob');
  late final _sqlite3_result_blob = _sqlite3_result_blobPtr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  void sqlite3_result_blob64(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Void> arg1,
    int arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
  ) {
    return _sqlite3_result_blob64(
      arg0,
      arg1,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_result_blob64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_context>,
              ffi.Pointer<ffi.Void>,
              sqlite3_uint64,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_result_blob64');
  late final _sqlite3_result_blob64 = _sqlite3_result_blob64Ptr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  void sqlite3_result_double(
    ffi.Pointer<sqlite3_context> arg0,
    double arg1,
  ) {
    return _sqlite3_result_double(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_result_doublePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_context>,
              ffi.Double)>>('sqlite3_result_double');
  late final _sqlite3_result_double = _sqlite3_result_doublePtr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>, double)>();

  void sqlite3_result_error(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Char> arg1,
    int arg2,
  ) {
    return _sqlite3_result_error(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_result_errorPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Pointer<ffi.Char>,
              ffi.Int)>>('sqlite3_result_error');
  late final _sqlite3_result_error = _sqlite3_result_errorPtr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>, ffi.Pointer<ffi.Char>, int)>();

  void sqlite3_result_error16(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Void> arg1,
    int arg2,
  ) {
    return _sqlite3_result_error16(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_result_error16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_context>, ffi.Pointer<ffi.Void>,
              ffi.Int)>>('sqlite3_result_error16');
  late final _sqlite3_result_error16 = _sqlite3_result_error16Ptr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>, ffi.Pointer<ffi.Void>, int)>();

  void sqlite3_result_error_toobig(
    ffi.Pointer<sqlite3_context> arg0,
  ) {
    return _sqlite3_result_error_toobig(
      arg0,
    );
  }

  late final _sqlite3_result_error_toobigPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_context>)>>(
      'sqlite3_result_error_toobig');
  late final _sqlite3_result_error_toobig = _sqlite3_result_error_toobigPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>)>();

  void sqlite3_result_error_nomem(
    ffi.Pointer<sqlite3_context> arg0,
  ) {
    return _sqlite3_result_error_nomem(
      arg0,
    );
  }

  late final _sqlite3_result_error_nomemPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_context>)>>(
      'sqlite3_result_error_nomem');
  late final _sqlite3_result_error_nomem = _sqlite3_result_error_nomemPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>)>();

  void sqlite3_result_error_code(
    ffi.Pointer<sqlite3_context> arg0,
    int arg1,
  ) {
    return _sqlite3_result_error_code(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_result_error_codePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_context>,
              ffi.Int)>>('sqlite3_result_error_code');
  late final _sqlite3_result_error_code = _sqlite3_result_error_codePtr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>, int)>();

  void sqlite3_result_int(
    ffi.Pointer<sqlite3_context> arg0,
    int arg1,
  ) {
    return _sqlite3_result_int(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_result_intPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_context>, ffi.Int)>>('sqlite3_result_int');
  late final _sqlite3_result_int = _sqlite3_result_intPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>, int)>();

  void sqlite3_result_int64(
    ffi.Pointer<sqlite3_context> arg0,
    int arg1,
  ) {
    return _sqlite3_result_int64(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_result_int64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_context>,
              sqlite3_int64)>>('sqlite3_result_int64');
  late final _sqlite3_result_int64 = _sqlite3_result_int64Ptr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>, int)>();

  void sqlite3_result_null(
    ffi.Pointer<sqlite3_context> arg0,
  ) {
    return _sqlite3_result_null(
      arg0,
    );
  }

  late final _sqlite3_result_nullPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_context>)>>(
      'sqlite3_result_null');
  late final _sqlite3_result_null = _sqlite3_result_nullPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>)>();

  void sqlite3_result_text(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Char> arg1,
    int arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
  ) {
    return _sqlite3_result_text(
      arg0,
      arg1,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_result_textPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_context>,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_result_text');
  late final _sqlite3_result_text = _sqlite3_result_textPtr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          ffi.Pointer<ffi.Char>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  void sqlite3_result_text64(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Char> arg1,
    int arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
    int encoding,
  ) {
    return _sqlite3_result_text64(
      arg0,
      arg1,
      arg2,
      arg3,
      encoding,
    );
  }

  late final _sqlite3_result_text64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_context>,
              ffi.Pointer<ffi.Char>,
              sqlite3_uint64,
              ffi.Pointer<
                  ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>,
              ffi.UnsignedChar)>>('sqlite3_result_text64');
  late final _sqlite3_result_text64 = _sqlite3_result_text64Ptr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          ffi.Pointer<ffi.Char>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>,
          int)>();

  void sqlite3_result_text16(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Void> arg1,
    int arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
  ) {
    return _sqlite3_result_text16(
      arg0,
      arg1,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_result_text16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_context>,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_result_text16');
  late final _sqlite3_result_text16 = _sqlite3_result_text16Ptr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  void sqlite3_result_text16le(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Void> arg1,
    int arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
  ) {
    return _sqlite3_result_text16le(
      arg0,
      arg1,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_result_text16lePtr = _lookup<
          ffi.NativeFunction<
              ffi.Void Function(
                  ffi.Pointer<sqlite3_context>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Int,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>>(
      'sqlite3_result_text16le');
  late final _sqlite3_result_text16le = _sqlite3_result_text16lePtr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  void sqlite3_result_text16be(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Void> arg1,
    int arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
  ) {
    return _sqlite3_result_text16be(
      arg0,
      arg1,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_result_text16bePtr = _lookup<
          ffi.NativeFunction<
              ffi.Void Function(
                  ffi.Pointer<sqlite3_context>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Int,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>>(
      'sqlite3_result_text16be');
  late final _sqlite3_result_text16be = _sqlite3_result_text16bePtr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          ffi.Pointer<ffi.Void>,
          int,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  void sqlite3_result_value(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<sqlite3_value> arg1,
  ) {
    return _sqlite3_result_value(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_result_valuePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_context>,
              ffi.Pointer<sqlite3_value>)>>('sqlite3_result_value');
  late final _sqlite3_result_value = _sqlite3_result_valuePtr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>, ffi.Pointer<sqlite3_value>)>();

  void sqlite3_result_pointer(
    ffi.Pointer<sqlite3_context> arg0,
    ffi.Pointer<ffi.Void> arg1,
    ffi.Pointer<ffi.Char> arg2,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg3,
  ) {
    return _sqlite3_result_pointer(
      arg0,
      arg1,
      arg2,
      arg3,
    );
  }

  late final _sqlite3_result_pointerPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_context>,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>)>>)>>('sqlite3_result_pointer');
  late final _sqlite3_result_pointer = _sqlite3_result_pointerPtr.asFunction<
      void Function(
          ffi.Pointer<sqlite3_context>,
          ffi.Pointer<ffi.Void>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  void sqlite3_result_zeroblob(
    ffi.Pointer<sqlite3_context> arg0,
    int n,
  ) {
    return _sqlite3_result_zeroblob(
      arg0,
      n,
    );
  }

  late final _sqlite3_result_zeroblobPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_context>,
              ffi.Int)>>('sqlite3_result_zeroblob');
  late final _sqlite3_result_zeroblob = _sqlite3_result_zeroblobPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>, int)>();

  int sqlite3_result_zeroblob64(
    ffi.Pointer<sqlite3_context> arg0,
    int n,
  ) {
    return _sqlite3_result_zeroblob64(
      arg0,
      n,
    );
  }

  late final _sqlite3_result_zeroblob64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_context>,
              sqlite3_uint64)>>('sqlite3_result_zeroblob64');
  late final _sqlite3_result_zeroblob64 = _sqlite3_result_zeroblob64Ptr
      .asFunction<int Function(ffi.Pointer<sqlite3_context>, int)>();

  /// CAPI3REF: Setting The Subtype Of An SQL Function
  /// METHOD: sqlite3_context
  ///
  /// The sqlite3_result_subtype(C,T) function causes the subtype of
  /// the result from the [application-defined SQL function] with
  /// [sqlite3_context] C to be the value T.  Only the lower 8 bits
  /// of the subtype T are preserved in current versions of SQLite;
  /// higher order bits are discarded.
  /// The number of subtype bytes preserved by SQLite might increase
  /// in future releases of SQLite.
  void sqlite3_result_subtype(
    ffi.Pointer<sqlite3_context> arg0,
    int arg1,
  ) {
    return _sqlite3_result_subtype(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_result_subtypePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_context>,
              ffi.UnsignedInt)>>('sqlite3_result_subtype');
  late final _sqlite3_result_subtype = _sqlite3_result_subtypePtr
      .asFunction<void Function(ffi.Pointer<sqlite3_context>, int)>();

  /// CAPI3REF: Define New Collating Sequences
  /// METHOD: sqlite3
  ///
  /// ^These functions add, remove, or modify a [collation] associated
  /// with the [database connection] specified as the first argument.
  ///
  /// ^The name of the collation is a UTF-8 string
  /// for sqlite3_create_collation() and sqlite3_create_collation_v2()
  /// and a UTF-16 string in native byte order for sqlite3_create_collation16().
  /// ^Collation names that compare equal according to [sqlite3_strnicmp()] are
  /// considered to be the same name.
  ///
  /// ^(The third argument (eTextRep) must be one of the constants:
  /// <ul>
  /// <li> [SQLITE_UTF8],
  /// <li> [SQLITE_UTF16LE],
  /// <li> [SQLITE_UTF16BE],
  /// <li> [SQLITE_UTF16], or
  /// <li> [SQLITE_UTF16_ALIGNED].
  /// </ul>)^
  /// ^The eTextRep argument determines the encoding of strings passed
  /// to the collating function callback, xCompare.
  /// ^The [SQLITE_UTF16] and [SQLITE_UTF16_ALIGNED] values for eTextRep
  /// force strings to be UTF16 with native byte order.
  /// ^The [SQLITE_UTF16_ALIGNED] value for eTextRep forces strings to begin
  /// on an even byte address.
  ///
  /// ^The fourth argument, pArg, is an application data pointer that is passed
  /// through as the first argument to the collating function callback.
  ///
  /// ^The fifth argument, xCompare, is a pointer to the collating function.
  /// ^Multiple collating functions can be registered using the same name but
  /// with different eTextRep parameters and SQLite will use whichever
  /// function requires the least amount of data transformation.
  /// ^If the xCompare argument is NULL then the collating function is
  /// deleted.  ^When all collating functions having the same name are deleted,
  /// that collation is no longer usable.
  ///
  /// ^The collating function callback is invoked with a copy of the pArg
  /// application data pointer and with two strings in the encoding specified
  /// by the eTextRep argument.  The two integer parameters to the collating
  /// function callback are the length of the two strings, in bytes. The collating
  /// function must return an integer that is negative, zero, or positive
  /// if the first string is less than, equal to, or greater than the second,
  /// respectively.  A collating function must always return the same answer
  /// given the same inputs.  If two or more collating functions are registered
  /// to the same collation name (using different eTextRep values) then all
  /// must give an equivalent answer when invoked with equivalent strings.
  /// The collating function must obey the following properties for all
  /// strings A, B, and C:
  ///
  /// <ol>
  /// <li> If A==B then B==A.
  /// <li> If A==B and B==C then A==C.
  /// <li> If A&lt;B THEN B&gt;A.
  /// <li> If A&lt;B and B&lt;C then A&lt;C.
  /// </ol>
  ///
  /// If a collating function fails any of the above constraints and that
  /// collating function is registered and used, then the behavior of SQLite
  /// is undefined.
  ///
  /// ^The sqlite3_create_collation_v2() works like sqlite3_create_collation()
  /// with the addition that the xDestroy callback is invoked on pArg when
  /// the collating function is deleted.
  /// ^Collating functions are deleted when they are overridden by later
  /// calls to the collation creation functions or when the
  /// [database connection] is closed using [sqlite3_close()].
  ///
  /// ^The xDestroy callback is <u>not</u> called if the
  /// sqlite3_create_collation_v2() function fails.  Applications that invoke
  /// sqlite3_create_collation_v2() with a non-NULL xDestroy argument should
  /// check the return code and dispose of the application data pointer
  /// themselves rather than expecting SQLite to deal with it for them.
  /// This is different from every other SQLite interface.  The inconsistency
  /// is unfortunate but cannot be changed without breaking backwards
  /// compatibility.
  ///
  /// See also:  [sqlite3_collation_needed()] and [sqlite3_collation_needed16()].
  int sqlite3_create_collation(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Char> zName,
    int eTextRep,
    ffi.Pointer<ffi.Void> pArg,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(ffi.Pointer<ffi.Void>, ffi.Int,
                    ffi.Pointer<ffi.Void>, ffi.Int, ffi.Pointer<ffi.Void>)>>
        xCompare,
  ) {
    return _sqlite3_create_collation(
      arg0,
      zName,
      eTextRep,
      pArg,
      xCompare,
    );
  }

  late final _sqlite3_create_collationPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Int,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Int Function(
                              ffi.Pointer<ffi.Void>,
                              ffi.Int,
                              ffi.Pointer<ffi.Void>,
                              ffi.Int,
                              ffi.Pointer<ffi.Void>)>>)>>(
      'sqlite3_create_collation');
  late final _sqlite3_create_collation =
      _sqlite3_create_collationPtr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_create_collation_v2(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Char> zName,
    int eTextRep,
    ffi.Pointer<ffi.Void> pArg,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(ffi.Pointer<ffi.Void>, ffi.Int,
                    ffi.Pointer<ffi.Void>, ffi.Int, ffi.Pointer<ffi.Void>)>>
        xCompare,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        xDestroy,
  ) {
    return _sqlite3_create_collation_v2(
      arg0,
      zName,
      eTextRep,
      pArg,
      xCompare,
      xDestroy,
    );
  }

  late final _sqlite3_create_collation_v2Ptr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Int,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Int Function(
                              ffi.Pointer<ffi.Void>,
                              ffi.Int,
                              ffi.Pointer<ffi.Void>,
                              ffi.Int,
                              ffi.Pointer<ffi.Void>)>>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>>(
      'sqlite3_create_collation_v2');
  late final _sqlite3_create_collation_v2 =
      _sqlite3_create_collation_v2Ptr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Void>)>>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  int sqlite3_create_collation16(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Void> zName,
    int eTextRep,
    ffi.Pointer<ffi.Void> pArg,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(ffi.Pointer<ffi.Void>, ffi.Int,
                    ffi.Pointer<ffi.Void>, ffi.Int, ffi.Pointer<ffi.Void>)>>
        xCompare,
  ) {
    return _sqlite3_create_collation16(
      arg0,
      zName,
      eTextRep,
      pArg,
      xCompare,
    );
  }

  late final _sqlite3_create_collation16Ptr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Int,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Int Function(
                              ffi.Pointer<ffi.Void>,
                              ffi.Int,
                              ffi.Pointer<ffi.Void>,
                              ffi.Int,
                              ffi.Pointer<ffi.Void>)>>)>>(
      'sqlite3_create_collation16');
  late final _sqlite3_create_collation16 =
      _sqlite3_create_collation16Ptr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Void>)>>)>();

  /// CAPI3REF: Collation Needed Callbacks
  /// METHOD: sqlite3
  ///
  /// ^To avoid having to register all collation sequences before a database
  /// can be used, a single callback function may be registered with the
  /// [database connection] to be invoked whenever an undefined collation
  /// sequence is required.
  ///
  /// ^If the function is registered using the sqlite3_collation_needed() API,
  /// then it is passed the names of undefined collation sequences as strings
  /// encoded in UTF-8. ^If sqlite3_collation_needed16() is used,
  /// the names are passed as UTF-16 in machine native byte order.
  /// ^A call to either function replaces the existing collation-needed callback.
  ///
  /// ^(When the callback is invoked, the first argument passed is a copy
  /// of the second argument to sqlite3_collation_needed() or
  /// sqlite3_collation_needed16().  The second argument is the database
  /// connection.  The third argument is one of [SQLITE_UTF8], [SQLITE_UTF16BE],
  /// or [SQLITE_UTF16LE], indicating the most desirable form of the collation
  /// sequence function required.  The fourth parameter is the name of the
  /// required collation sequence.)^
  ///
  /// The callback function should register the desired collation using
  /// [sqlite3_create_collation()], [sqlite3_create_collation16()], or
  /// [sqlite3_create_collation_v2()].
  int sqlite3_collation_needed(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Void> arg1,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<ffi.Void>, ffi.Pointer<sqlite3>,
                    ffi.Int, ffi.Pointer<ffi.Char>)>>
        arg2,
  ) {
    return _sqlite3_collation_needed(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_collation_neededPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Void Function(
                              ffi.Pointer<ffi.Void>,
                              ffi.Pointer<sqlite3>,
                              ffi.Int,
                              ffi.Pointer<ffi.Char>)>>)>>(
      'sqlite3_collation_needed');
  late final _sqlite3_collation_needed =
      _sqlite3_collation_neededPtr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Pointer<sqlite3>,
                          ffi.Int,
                          ffi.Pointer<ffi.Char>)>>)>();

  int sqlite3_collation_needed16(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Void> arg1,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(ffi.Pointer<ffi.Void>, ffi.Pointer<sqlite3>,
                    ffi.Int, ffi.Pointer<ffi.Void>)>>
        arg2,
  ) {
    return _sqlite3_collation_needed16(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_collation_needed16Ptr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Void Function(
                              ffi.Pointer<ffi.Void>,
                              ffi.Pointer<sqlite3>,
                              ffi.Int,
                              ffi.Pointer<ffi.Void>)>>)>>(
      'sqlite3_collation_needed16');
  late final _sqlite3_collation_needed16 =
      _sqlite3_collation_needed16Ptr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Pointer<sqlite3>,
                          ffi.Int,
                          ffi.Pointer<ffi.Void>)>>)>();

  /// CAPI3REF: Suspend Execution For A Short Time
  ///
  /// The sqlite3_sleep() function causes the current thread to suspend execution
  /// for at least a number of milliseconds specified in its parameter.
  ///
  /// If the operating system does not support sleep requests with
  /// millisecond time resolution, then the time will be rounded up to
  /// the nearest second. The number of milliseconds of sleep actually
  /// requested from the operating system is returned.
  ///
  /// ^SQLite implements this interface by calling the xSleep()
  /// method of the default [sqlite3_vfs] object.  If the xSleep() method
  /// of the default VFS is not implemented correctly, or not implemented at
  /// all, then the behavior of sqlite3_sleep() may deviate from the description
  /// in the previous paragraphs.
  int sqlite3_sleep(
    int arg0,
  ) {
    return _sqlite3_sleep(
      arg0,
    );
  }

  late final _sqlite3_sleepPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Int)>>('sqlite3_sleep');
  late final _sqlite3_sleep = _sqlite3_sleepPtr.asFunction<int Function(int)>();

  /// CAPI3REF: Name Of The Folder Holding Temporary Files
  ///
  /// ^(If this global variable is made to point to a string which is
  /// the name of a folder (a.k.a. directory), then all temporary files
  /// created by SQLite when using a built-in [sqlite3_vfs | VFS]
  /// will be placed in that directory.)^  ^If this variable
  /// is a NULL pointer, then SQLite performs a search for an appropriate
  /// temporary file directory.
  ///
  /// Applications are strongly discouraged from using this global variable.
  /// It is required to set a temporary folder on Windows Runtime (WinRT).
  /// But for all other platforms, it is highly recommended that applications
  /// neither read nor write this variable.  This global variable is a relic
  /// that exists for backwards compatibility of legacy applications and should
  /// be avoided in new projects.
  ///
  /// It is not safe to read or modify this variable in more than one
  /// thread at a time.  It is not safe to read or modify this variable
  /// if a [database connection] is being used at the same time in a separate
  /// thread.
  /// It is intended that this variable be set once
  /// as part of process initialization and before any SQLite interface
  /// routines have been called and that this variable remain unchanged
  /// thereafter.
  ///
  /// ^The [temp_store_directory pragma] may modify this variable and cause
  /// it to point to memory obtained from [sqlite3_malloc].  ^Furthermore,
  /// the [temp_store_directory pragma] always assumes that any string
  /// that this variable points to is held in memory obtained from
  /// [sqlite3_malloc] and the pragma may attempt to free that memory
  /// using [sqlite3_free].
  /// Hence, if this variable is modified directly, either it should be
  /// made NULL or made to point to memory obtained from [sqlite3_malloc]
  /// or else the use of the [temp_store_directory pragma] should be avoided.
  /// Except when requested by the [temp_store_directory pragma], SQLite
  /// does not free the memory that sqlite3_temp_directory points to.  If
  /// the application wants that memory to be freed, it must do
  /// so itself, taking care to only do so after all [database connection]
  /// objects have been destroyed.
  ///
  /// <b>Note to Windows Runtime users:</b>  The temporary directory must be set
  /// prior to calling [sqlite3_open] or [sqlite3_open_v2].  Otherwise, various
  /// features that require the use of temporary files may fail.  Here is an
  /// example of how to do this using C++ with the Windows Runtime:
  ///
  /// <blockquote><pre>
  /// LPCWSTR zPath = Windows::Storage::ApplicationData::Current->
  /// &nbsp;     TemporaryFolder->Path->Data();
  /// char zPathBuf&#91;MAX_PATH + 1&#93;;
  /// memset(zPathBuf, 0, sizeof(zPathBuf));
  /// WideCharToMultiByte(CP_UTF8, 0, zPath, -1, zPathBuf, sizeof(zPathBuf),
  /// &nbsp;     NULL, NULL);
  /// sqlite3_temp_directory = sqlite3_mprintf("%s", zPathBuf);
  /// </pre></blockquote>
  late final ffi.Pointer<ffi.Pointer<ffi.Char>> _sqlite3_temp_directory =
      _lookup<ffi.Pointer<ffi.Char>>('sqlite3_temp_directory');

  ffi.Pointer<ffi.Char> get sqlite3_temp_directory =>
      _sqlite3_temp_directory.value;

  set sqlite3_temp_directory(ffi.Pointer<ffi.Char> value) =>
      _sqlite3_temp_directory.value = value;

  /// CAPI3REF: Name Of The Folder Holding Database Files
  ///
  /// ^(If this global variable is made to point to a string which is
  /// the name of a folder (a.k.a. directory), then all database files
  /// specified with a relative pathname and created or accessed by
  /// SQLite when using a built-in windows [sqlite3_vfs | VFS] will be assumed
  /// to be relative to that directory.)^ ^If this variable is a NULL
  /// pointer, then SQLite assumes that all database files specified
  /// with a relative pathname are relative to the current directory
  /// for the process.  Only the windows VFS makes use of this global
  /// variable; it is ignored by the unix VFS.
  ///
  /// Changing the value of this variable while a database connection is
  /// open can result in a corrupt database.
  ///
  /// It is not safe to read or modify this variable in more than one
  /// thread at a time.  It is not safe to read or modify this variable
  /// if a [database connection] is being used at the same time in a separate
  /// thread.
  /// It is intended that this variable be set once
  /// as part of process initialization and before any SQLite interface
  /// routines have been called and that this variable remain unchanged
  /// thereafter.
  ///
  /// ^The [data_store_directory pragma] may modify this variable and cause
  /// it to point to memory obtained from [sqlite3_malloc].  ^Furthermore,
  /// the [data_store_directory pragma] always assumes that any string
  /// that this variable points to is held in memory obtained from
  /// [sqlite3_malloc] and the pragma may attempt to free that memory
  /// using [sqlite3_free].
  /// Hence, if this variable is modified directly, either it should be
  /// made NULL or made to point to memory obtained from [sqlite3_malloc]
  /// or else the use of the [data_store_directory pragma] should be avoided.
  late final ffi.Pointer<ffi.Pointer<ffi.Char>> _sqlite3_data_directory =
      _lookup<ffi.Pointer<ffi.Char>>('sqlite3_data_directory');

  ffi.Pointer<ffi.Char> get sqlite3_data_directory =>
      _sqlite3_data_directory.value;

  set sqlite3_data_directory(ffi.Pointer<ffi.Char> value) =>
      _sqlite3_data_directory.value = value;

  /// CAPI3REF: Win32 Specific Interface
  ///
  /// These interfaces are available only on Windows.  The
  /// [sqlite3_win32_set_directory] interface is used to set the value associated
  /// with the [sqlite3_temp_directory] or [sqlite3_data_directory] variable, to
  /// zValue, depending on the value of the type parameter.  The zValue parameter
  /// should be NULL to cause the previous value to be freed via [sqlite3_free];
  /// a non-NULL value will be copied into memory obtained from [sqlite3_malloc]
  /// prior to being used.  The [sqlite3_win32_set_directory] interface returns
  /// [SQLITE_OK] to indicate success, [SQLITE_ERROR] if the type is unsupported,
  /// or [SQLITE_NOMEM] if memory could not be allocated.  The value of the
  /// [sqlite3_data_directory] variable is intended to act as a replacement for
  /// the current directory on the sub-platforms of Win32 where that concept is
  /// not present, e.g. WinRT and UWP.  The [sqlite3_win32_set_directory8] and
  /// [sqlite3_win32_set_directory16] interfaces behave exactly the same as the
  /// sqlite3_win32_set_directory interface except the string parameter must be
  /// UTF-8 or UTF-16, respectively.
  int sqlite3_win32_set_directory(
    int type,
    ffi.Pointer<ffi.Void> zValue,
  ) {
    return _sqlite3_win32_set_directory(
      type,
      zValue,
    );
  }

  late final _sqlite3_win32_set_directoryPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.UnsignedLong,
              ffi.Pointer<ffi.Void>)>>('sqlite3_win32_set_directory');
  late final _sqlite3_win32_set_directory = _sqlite3_win32_set_directoryPtr
      .asFunction<int Function(int, ffi.Pointer<ffi.Void>)>();

  int sqlite3_win32_set_directory8(
    int type,
    ffi.Pointer<ffi.Char> zValue,
  ) {
    return _sqlite3_win32_set_directory8(
      type,
      zValue,
    );
  }

  late final _sqlite3_win32_set_directory8Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.UnsignedLong,
              ffi.Pointer<ffi.Char>)>>('sqlite3_win32_set_directory8');
  late final _sqlite3_win32_set_directory8 = _sqlite3_win32_set_directory8Ptr
      .asFunction<int Function(int, ffi.Pointer<ffi.Char>)>();

  int sqlite3_win32_set_directory16(
    int type,
    ffi.Pointer<ffi.Void> zValue,
  ) {
    return _sqlite3_win32_set_directory16(
      type,
      zValue,
    );
  }

  late final _sqlite3_win32_set_directory16Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.UnsignedLong,
              ffi.Pointer<ffi.Void>)>>('sqlite3_win32_set_directory16');
  late final _sqlite3_win32_set_directory16 = _sqlite3_win32_set_directory16Ptr
      .asFunction<int Function(int, ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Test For Auto-Commit Mode
  /// KEYWORDS: {autocommit mode}
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_get_autocommit() interface returns non-zero or
  /// zero if the given database connection is or is not in autocommit mode,
  /// respectively.  ^Autocommit mode is on by default.
  /// ^Autocommit mode is disabled by a [BEGIN] statement.
  /// ^Autocommit mode is re-enabled by a [COMMIT] or [ROLLBACK].
  ///
  /// If certain kinds of errors occur on a statement within a multi-statement
  /// transaction (errors including [SQLITE_FULL], [SQLITE_IOERR],
  /// [SQLITE_NOMEM], [SQLITE_BUSY], and [SQLITE_INTERRUPT]) then the
  /// transaction might be rolled back automatically.  The only way to
  /// find out whether SQLite automatically rolled back the transaction after
  /// an error is to use this function.
  ///
  /// If another thread changes the autocommit status of the database
  /// connection while this routine is running, then the return value
  /// is undefined.
  int sqlite3_get_autocommit(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_get_autocommit(
      arg0,
    );
  }

  late final _sqlite3_get_autocommitPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_get_autocommit');
  late final _sqlite3_get_autocommit = _sqlite3_get_autocommitPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Find The Database Handle Of A Prepared Statement
  /// METHOD: sqlite3_stmt
  ///
  /// ^The sqlite3_db_handle interface returns the [database connection] handle
  /// to which a [prepared statement] belongs.  ^The [database connection]
  /// returned by sqlite3_db_handle is the same [database connection]
  /// that was the first argument
  /// to the [sqlite3_prepare_v2()] call (or its variants) that was used to
  /// create the statement in the first place.
  ffi.Pointer<sqlite3> sqlite3_db_handle(
    ffi.Pointer<sqlite3_stmt> arg0,
  ) {
    return _sqlite3_db_handle(
      arg0,
    );
  }

  late final _sqlite3_db_handlePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3> Function(
              ffi.Pointer<sqlite3_stmt>)>>('sqlite3_db_handle');
  late final _sqlite3_db_handle = _sqlite3_db_handlePtr
      .asFunction<ffi.Pointer<sqlite3> Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Return The Filename For A Database Connection
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_db_filename(D,N) interface returns a pointer to the filename
  /// associated with database N of connection D.
  /// ^If there is no attached database N on the database
  /// connection D, or if database N is a temporary or in-memory database, then
  /// this function will return either a NULL pointer or an empty string.
  ///
  /// ^The string value returned by this routine is owned and managed by
  /// the database connection.  ^The value will be valid until the database N
  /// is [DETACH]-ed or until the database connection closes.
  ///
  /// ^The filename returned by this function is the output of the
  /// xFullPathname method of the [VFS].  ^In other words, the filename
  /// will be an absolute pathname, even if the filename used
  /// to open the database originally was a URI or relative pathname.
  ///
  /// If the filename pointer returned by this routine is not NULL, then it
  /// can be used as the filename input parameter to these routines:
  /// <ul>
  /// <li> [sqlite3_uri_parameter()]
  /// <li> [sqlite3_uri_boolean()]
  /// <li> [sqlite3_uri_int64()]
  /// <li> [sqlite3_filename_database()]
  /// <li> [sqlite3_filename_journal()]
  /// <li> [sqlite3_filename_wal()]
  /// </ul>
  ffi.Pointer<ffi.Char> sqlite3_db_filename(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zDbName,
  ) {
    return _sqlite3_db_filename(
      db,
      zDbName,
    );
  }

  late final _sqlite3_db_filenamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_db_filename');
  late final _sqlite3_db_filename = _sqlite3_db_filenamePtr.asFunction<
      ffi.Pointer<ffi.Char> Function(
          ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Determine if a database is read-only
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_db_readonly(D,N) interface returns 1 if the database N
  /// of connection D is read-only, 0 if it is read/write, or -1 if N is not
  /// the name of a database on connection D.
  int sqlite3_db_readonly(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zDbName,
  ) {
    return _sqlite3_db_readonly(
      db,
      zDbName,
    );
  }

  late final _sqlite3_db_readonlyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_db_readonly');
  late final _sqlite3_db_readonly = _sqlite3_db_readonlyPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Find the next prepared statement
  /// METHOD: sqlite3
  ///
  /// ^This interface returns a pointer to the next [prepared statement] after
  /// pStmt associated with the [database connection] pDb.  ^If pStmt is NULL
  /// then this interface returns a pointer to the first prepared statement
  /// associated with the database connection pDb.  ^If no prepared statement
  /// satisfies the conditions of this routine, it returns NULL.
  ///
  /// The [database connection] pointer D in a call to
  /// [sqlite3_next_stmt(D,S)] must refer to an open database
  /// connection and in particular must not be a NULL pointer.
  ffi.Pointer<sqlite3_stmt> sqlite3_next_stmt(
    ffi.Pointer<sqlite3> pDb,
    ffi.Pointer<sqlite3_stmt> pStmt,
  ) {
    return _sqlite3_next_stmt(
      pDb,
      pStmt,
    );
  }

  late final _sqlite3_next_stmtPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_stmt> Function(ffi.Pointer<sqlite3>,
              ffi.Pointer<sqlite3_stmt>)>>('sqlite3_next_stmt');
  late final _sqlite3_next_stmt = _sqlite3_next_stmtPtr.asFunction<
      ffi.Pointer<sqlite3_stmt> Function(
          ffi.Pointer<sqlite3>, ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Commit And Rollback Notification Callbacks
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_commit_hook() interface registers a callback
  /// function to be invoked whenever a transaction is [COMMIT | committed].
  /// ^Any callback set by a previous call to sqlite3_commit_hook()
  /// for the same database connection is overridden.
  /// ^The sqlite3_rollback_hook() interface registers a callback
  /// function to be invoked whenever a transaction is [ROLLBACK | rolled back].
  /// ^Any callback set by a previous call to sqlite3_rollback_hook()
  /// for the same database connection is overridden.
  /// ^The pArg argument is passed through to the callback.
  /// ^If the callback on a commit hook function returns non-zero,
  /// then the commit is converted into a rollback.
  ///
  /// ^The sqlite3_commit_hook(D,C,P) and sqlite3_rollback_hook(D,C,P) functions
  /// return the P argument from the previous call of the same function
  /// on the same [database connection] D, or NULL for
  /// the first call for each function on D.
  ///
  /// The commit and rollback hook callbacks are not reentrant.
  /// The callback implementation must not do anything that will modify
  /// the database connection that invoked the callback.  Any actions
  /// to modify the database connection must be deferred until after the
  /// completion of the [sqlite3_step()] call that triggered the commit
  /// or rollback hook in the first place.
  /// Note that running any other SQL statements, including SELECT statements,
  /// or merely calling [sqlite3_prepare_v2()] and [sqlite3_step()] will modify
  /// the database connections for the meaning of "modify" in this paragraph.
  ///
  /// ^Registering a NULL function disables the callback.
  ///
  /// ^When the commit hook callback routine returns zero, the [COMMIT]
  /// operation is allowed to continue normally.  ^If the commit hook
  /// returns non-zero, then the [COMMIT] is converted into a [ROLLBACK].
  /// ^The rollback hook is invoked on a rollback that results from a commit
  /// hook returning non-zero, just as it would be with any other rollback.
  ///
  /// ^For the purposes of this API, a transaction is said to have been
  /// rolled back if an explicit "ROLLBACK" statement is executed, or
  /// an error or constraint causes an implicit rollback to occur.
  /// ^The rollback callback is not invoked if a transaction is
  /// automatically rolled back because the database connection is closed.
  ///
  /// See also the [sqlite3_update_hook()] interface.
  ffi.Pointer<ffi.Void> sqlite3_commit_hook(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>
        arg1,
    ffi.Pointer<ffi.Void> arg2,
  ) {
    return _sqlite3_commit_hook(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_commit_hookPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_commit_hook');
  late final _sqlite3_commit_hook = _sqlite3_commit_hookPtr.asFunction<
      ffi.Pointer<ffi.Void> Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>,
          ffi.Pointer<ffi.Void>)>();

  ffi.Pointer<ffi.Void> sqlite3_rollback_hook(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        arg1,
    ffi.Pointer<ffi.Void> arg2,
  ) {
    return _sqlite3_rollback_hook(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_rollback_hookPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_rollback_hook');
  late final _sqlite3_rollback_hook = _sqlite3_rollback_hookPtr.asFunction<
      ffi.Pointer<ffi.Void> Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Data Change Notification Callbacks
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_update_hook() interface registers a callback function
  /// with the [database connection] identified by the first argument
  /// to be invoked whenever a row is updated, inserted or deleted in
  /// a [rowid table].
  /// ^Any callback set by a previous call to this function
  /// for the same database connection is overridden.
  ///
  /// ^The second argument is a pointer to the function to invoke when a
  /// row is updated, inserted or deleted in a rowid table.
  /// ^The first argument to the callback is a copy of the third argument
  /// to sqlite3_update_hook().
  /// ^The second callback argument is one of [SQLITE_INSERT], [SQLITE_DELETE],
  /// or [SQLITE_UPDATE], depending on the operation that caused the callback
  /// to be invoked.
  /// ^The third and fourth arguments to the callback contain pointers to the
  /// database and table name containing the affected row.
  /// ^The final callback parameter is the [rowid] of the row.
  /// ^In the case of an update, this is the [rowid] after the update takes place.
  ///
  /// ^(The update hook is not invoked when internal system tables are
  /// modified (i.e. sqlite_master and sqlite_sequence).)^
  /// ^The update hook is not invoked when [WITHOUT ROWID] tables are modified.
  ///
  /// ^In the current implementation, the update hook
  /// is not invoked when conflicting rows are deleted because of an
  /// [ON CONFLICT | ON CONFLICT REPLACE] clause.  ^Nor is the update hook
  /// invoked when rows are deleted using the [truncate optimization].
  /// The exceptions defined in this paragraph might change in a future
  /// release of SQLite.
  ///
  /// The update hook implementation must not do anything that will modify
  /// the database connection that invoked the update hook.  Any actions
  /// to modify the database connection must be deferred until after the
  /// completion of the [sqlite3_step()] call that triggered the update hook.
  /// Note that [sqlite3_prepare_v2()] and [sqlite3_step()] both modify their
  /// database connections for the meaning of "modify" in this paragraph.
  ///
  /// ^The sqlite3_update_hook(D,C,P) function
  /// returns the P argument from the previous call
  /// on the same [database connection] D, or NULL for
  /// the first call on D.
  ///
  /// See also the [sqlite3_commit_hook()], [sqlite3_rollback_hook()],
  /// and [sqlite3_preupdate_hook()] interfaces.
  ffi.Pointer<ffi.Void> sqlite3_update_hook(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(
                    ffi.Pointer<ffi.Void>,
                    ffi.Int,
                    ffi.Pointer<ffi.Char>,
                    ffi.Pointer<ffi.Char>,
                    sqlite3_int64)>>
        arg1,
    ffi.Pointer<ffi.Void> arg2,
  ) {
    return _sqlite3_update_hook(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_update_hookPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Char>,
                          ffi.Pointer<ffi.Char>,
                          sqlite3_int64)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_update_hook');
  late final _sqlite3_update_hook = _sqlite3_update_hookPtr.asFunction<
      ffi.Pointer<ffi.Void> Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<ffi.Void>,
                      ffi.Int,
                      ffi.Pointer<ffi.Char>,
                      ffi.Pointer<ffi.Char>,
                      sqlite3_int64)>>,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Enable Or Disable Shared Pager Cache
  ///
  /// ^(This routine enables or disables the sharing of the database cache
  /// and schema data structures between [database connection | connections]
  /// to the same database. Sharing is enabled if the argument is true
  /// and disabled if the argument is false.)^
  ///
  /// ^Cache sharing is enabled and disabled for an entire process.
  /// This is a change as of SQLite [version 3.5.0] ([dateof:3.5.0]).
  /// In prior versions of SQLite,
  /// sharing was enabled or disabled for each thread separately.
  ///
  /// ^(The cache sharing mode set by this interface effects all subsequent
  /// calls to [sqlite3_open()], [sqlite3_open_v2()], and [sqlite3_open16()].
  /// Existing database connections continue to use the sharing mode
  /// that was in effect at the time they were opened.)^
  ///
  /// ^(This routine returns [SQLITE_OK] if shared cache was enabled or disabled
  /// successfully.  An [error code] is returned otherwise.)^
  ///
  /// ^Shared cache is disabled by default. It is recommended that it stay
  /// that way.  In other words, do not use this routine.  This interface
  /// continues to be provided for historical compatibility, but its use is
  /// discouraged.  Any use of shared cache is discouraged.  If shared cache
  /// must be used, it is recommended that shared cache only be enabled for
  /// individual database connections using the [sqlite3_open_v2()] interface
  /// with the [SQLITE_OPEN_SHAREDCACHE] flag.
  ///
  /// Note: This method is disabled on MacOS X 10.7 and iOS version 5.0
  /// and will always return SQLITE_MISUSE. On those systems,
  /// shared cache mode should be enabled per-database connection via
  /// [sqlite3_open_v2()] with [SQLITE_OPEN_SHAREDCACHE].
  ///
  /// This interface is threadsafe on processors where writing a
  /// 32-bit integer is atomic.
  ///
  /// See Also:  [SQLite Shared-Cache Mode]
  int sqlite3_enable_shared_cache(
    int arg0,
  ) {
    return _sqlite3_enable_shared_cache(
      arg0,
    );
  }

  late final _sqlite3_enable_shared_cachePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Int)>>(
          'sqlite3_enable_shared_cache');
  late final _sqlite3_enable_shared_cache =
      _sqlite3_enable_shared_cachePtr.asFunction<int Function(int)>();

  /// CAPI3REF: Attempt To Free Heap Memory
  ///
  /// ^The sqlite3_release_memory() interface attempts to free N bytes
  /// of heap memory by deallocating non-essential memory allocations
  /// held by the database library.   Memory used to cache database
  /// pages to improve performance is an example of non-essential memory.
  /// ^sqlite3_release_memory() returns the number of bytes actually freed,
  /// which might be more or less than the amount requested.
  /// ^The sqlite3_release_memory() routine is a no-op returning zero
  /// if SQLite is not compiled with [SQLITE_ENABLE_MEMORY_MANAGEMENT].
  ///
  /// See also: [sqlite3_db_release_memory()]
  int sqlite3_release_memory(
    int arg0,
  ) {
    return _sqlite3_release_memory(
      arg0,
    );
  }

  late final _sqlite3_release_memoryPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Int)>>(
          'sqlite3_release_memory');
  late final _sqlite3_release_memory =
      _sqlite3_release_memoryPtr.asFunction<int Function(int)>();

  /// CAPI3REF: Free Memory Used By A Database Connection
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_db_release_memory(D) interface attempts to free as much heap
  /// memory as possible from database connection D. Unlike the
  /// [sqlite3_release_memory()] interface, this interface is in effect even
  /// when the [SQLITE_ENABLE_MEMORY_MANAGEMENT] compile-time option is
  /// omitted.
  ///
  /// See also: [sqlite3_release_memory()]
  int sqlite3_db_release_memory(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_db_release_memory(
      arg0,
    );
  }

  late final _sqlite3_db_release_memoryPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_db_release_memory');
  late final _sqlite3_db_release_memory = _sqlite3_db_release_memoryPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Impose A Limit On Heap Size
  ///
  /// These interfaces impose limits on the amount of heap memory that will be
  /// by all database connections within a single process.
  ///
  /// ^The sqlite3_soft_heap_limit64() interface sets and/or queries the
  /// soft limit on the amount of heap memory that may be allocated by SQLite.
  /// ^SQLite strives to keep heap memory utilization below the soft heap
  /// limit by reducing the number of pages held in the page cache
  /// as heap memory usages approaches the limit.
  /// ^The soft heap limit is "soft" because even though SQLite strives to stay
  /// below the limit, it will exceed the limit rather than generate
  /// an [SQLITE_NOMEM] error.  In other words, the soft heap limit
  /// is advisory only.
  ///
  /// ^The sqlite3_hard_heap_limit64(N) interface sets a hard upper bound of
  /// N bytes on the amount of memory that will be allocated.  ^The
  /// sqlite3_hard_heap_limit64(N) interface is similar to
  /// sqlite3_soft_heap_limit64(N) except that memory allocations will fail
  /// when the hard heap limit is reached.
  ///
  /// ^The return value from both sqlite3_soft_heap_limit64() and
  /// sqlite3_hard_heap_limit64() is the size of
  /// the heap limit prior to the call, or negative in the case of an
  /// error.  ^If the argument N is negative
  /// then no change is made to the heap limit.  Hence, the current
  /// size of heap limits can be determined by invoking
  /// sqlite3_soft_heap_limit64(-1) or sqlite3_hard_heap_limit(-1).
  ///
  /// ^Setting the heap limits to zero disables the heap limiter mechanism.
  ///
  /// ^The soft heap limit may not be greater than the hard heap limit.
  /// ^If the hard heap limit is enabled and if sqlite3_soft_heap_limit(N)
  /// is invoked with a value of N that is greater than the hard heap limit,
  /// the the soft heap limit is set to the value of the hard heap limit.
  /// ^The soft heap limit is automatically enabled whenever the hard heap
  /// limit is enabled. ^When sqlite3_hard_heap_limit64(N) is invoked and
  /// the soft heap limit is outside the range of 1..N, then the soft heap
  /// limit is set to N.  ^Invoking sqlite3_soft_heap_limit64(0) when the
  /// hard heap limit is enabled makes the soft heap limit equal to the
  /// hard heap limit.
  ///
  /// The memory allocation limits can also be adjusted using
  /// [PRAGMA soft_heap_limit] and [PRAGMA hard_heap_limit].
  ///
  /// ^(The heap limits are not enforced in the current implementation
  /// if one or more of following conditions are true:
  ///
  /// <ul>
  /// <li> The limit value is set to zero.
  /// <li> Memory accounting is disabled using a combination of the
  /// [sqlite3_config]([SQLITE_CONFIG_MEMSTATUS],...) start-time option and
  /// the [SQLITE_DEFAULT_MEMSTATUS] compile-time option.
  /// <li> An alternative page cache implementation is specified using
  /// [sqlite3_config]([SQLITE_CONFIG_PCACHE2],...).
  /// <li> The page cache allocates from its own memory pool supplied
  /// by [sqlite3_config]([SQLITE_CONFIG_PAGECACHE],...) rather than
  /// from the heap.
  /// </ul>)^
  ///
  /// The circumstances under which SQLite will enforce the heap limits may
  /// changes in future releases of SQLite.
  int sqlite3_soft_heap_limit64(
    int N,
  ) {
    return _sqlite3_soft_heap_limit64(
      N,
    );
  }

  late final _sqlite3_soft_heap_limit64Ptr =
      _lookup<ffi.NativeFunction<sqlite3_int64 Function(sqlite3_int64)>>(
          'sqlite3_soft_heap_limit64');
  late final _sqlite3_soft_heap_limit64 =
      _sqlite3_soft_heap_limit64Ptr.asFunction<int Function(int)>();

  int sqlite3_hard_heap_limit64(
    int N,
  ) {
    return _sqlite3_hard_heap_limit64(
      N,
    );
  }

  late final _sqlite3_hard_heap_limit64Ptr =
      _lookup<ffi.NativeFunction<sqlite3_int64 Function(sqlite3_int64)>>(
          'sqlite3_hard_heap_limit64');
  late final _sqlite3_hard_heap_limit64 =
      _sqlite3_hard_heap_limit64Ptr.asFunction<int Function(int)>();

  /// CAPI3REF: Deprecated Soft Heap Limit Interface
  /// DEPRECATED
  ///
  /// This is a deprecated version of the [sqlite3_soft_heap_limit64()]
  /// interface.  This routine is provided for historical compatibility
  /// only.  All new applications should use the
  /// [sqlite3_soft_heap_limit64()] interface rather than this one.
  void sqlite3_soft_heap_limit(
    int N,
  ) {
    return _sqlite3_soft_heap_limit(
      N,
    );
  }

  late final _sqlite3_soft_heap_limitPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Int)>>(
          'sqlite3_soft_heap_limit');
  late final _sqlite3_soft_heap_limit =
      _sqlite3_soft_heap_limitPtr.asFunction<void Function(int)>();

  /// CAPI3REF: Extract Metadata About A Column Of A Table
  /// METHOD: sqlite3
  ///
  /// ^(The sqlite3_table_column_metadata(X,D,T,C,....) routine returns
  /// information about column C of table T in database D
  /// on [database connection] X.)^  ^The sqlite3_table_column_metadata()
  /// interface returns SQLITE_OK and fills in the non-NULL pointers in
  /// the final five arguments with appropriate values if the specified
  /// column exists.  ^The sqlite3_table_column_metadata() interface returns
  /// SQLITE_ERROR if the specified column does not exist.
  /// ^If the column-name parameter to sqlite3_table_column_metadata() is a
  /// NULL pointer, then this routine simply checks for the existence of the
  /// table and returns SQLITE_OK if the table exists and SQLITE_ERROR if it
  /// does not.  If the table name parameter T in a call to
  /// sqlite3_table_column_metadata(X,D,T,C,...) is NULL then the result is
  /// undefined behavior.
  ///
  /// ^The column is identified by the second, third and fourth parameters to
  /// this function. ^(The second parameter is either the name of the database
  /// (i.e. "main", "temp", or an attached database) containing the specified
  /// table or NULL.)^ ^If it is NULL, then all attached databases are searched
  /// for the table using the same algorithm used by the database engine to
  /// resolve unqualified table references.
  ///
  /// ^The third and fourth parameters to this function are the table and column
  /// name of the desired column, respectively.
  ///
  /// ^Metadata is returned by writing to the memory locations passed as the 5th
  /// and subsequent parameters to this function. ^Any of these arguments may be
  /// NULL, in which case the corresponding element of metadata is omitted.
  ///
  /// ^(<blockquote>
  /// <table border="1">
  /// <tr><th> Parameter <th> Output<br>Type <th>  Description
  ///
  /// <tr><td> 5th <td> const char* <td> Data type
  /// <tr><td> 6th <td> const char* <td> Name of default collation sequence
  /// <tr><td> 7th <td> int         <td> True if column has a NOT NULL constraint
  /// <tr><td> 8th <td> int         <td> True if column is part of the PRIMARY KEY
  /// <tr><td> 9th <td> int         <td> True if column is [AUTOINCREMENT]
  /// </table>
  /// </blockquote>)^
  ///
  /// ^The memory pointed to by the character pointers returned for the
  /// declaration type and collation sequence is valid until the next
  /// call to any SQLite API function.
  ///
  /// ^If the specified table is actually a view, an [error code] is returned.
  ///
  /// ^If the specified column is "rowid", "oid" or "_rowid_" and the table
  /// is not a [WITHOUT ROWID] table and an
  /// [INTEGER PRIMARY KEY] column has been explicitly declared, then the output
  /// parameters are set for the explicitly declared column. ^(If there is no
  /// [INTEGER PRIMARY KEY] column, then the outputs
  /// for the [rowid] are set as follows:
  ///
  /// <pre>
  /// data type: "INTEGER"
  /// collation sequence: "BINARY"
  /// not null: 0
  /// primary key: 1
  /// auto increment: 0
  /// </pre>)^
  ///
  /// ^This function causes all database schemas to be read from disk and
  /// parsed, if that has not already been done, and returns an error if
  /// any errors are encountered while loading the schema.
  int sqlite3_table_column_metadata(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zDbName,
    ffi.Pointer<ffi.Char> zTableName,
    ffi.Pointer<ffi.Char> zColumnName,
    ffi.Pointer<ffi.Pointer<ffi.Char>> pzDataType,
    ffi.Pointer<ffi.Pointer<ffi.Char>> pzCollSeq,
    ffi.Pointer<ffi.Int> pNotNull,
    ffi.Pointer<ffi.Int> pPrimaryKey,
    ffi.Pointer<ffi.Int> pAutoinc,
  ) {
    return _sqlite3_table_column_metadata(
      db,
      zDbName,
      zTableName,
      zColumnName,
      pzDataType,
      pzCollSeq,
      pNotNull,
      pPrimaryKey,
      pAutoinc,
    );
  }

  late final _sqlite3_table_column_metadataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>>('sqlite3_table_column_metadata');
  late final _sqlite3_table_column_metadata =
      _sqlite3_table_column_metadataPtr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>();

  /// CAPI3REF: Load An Extension
  /// METHOD: sqlite3
  ///
  /// ^This interface loads an SQLite extension library from the named file.
  ///
  /// ^The sqlite3_load_extension() interface attempts to load an
  /// [SQLite extension] library contained in the file zFile.  If
  /// the file cannot be loaded directly, attempts are made to load
  /// with various operating-system specific extensions added.
  /// So for example, if "samplelib" cannot be loaded, then names like
  /// "samplelib.so" or "samplelib.dylib" or "samplelib.dll" might
  /// be tried also.
  ///
  /// ^The entry point is zProc.
  /// ^(zProc may be 0, in which case SQLite will try to come up with an
  /// entry point name on its own.  It first tries "sqlite3_extension_init".
  /// If that does not work, it constructs a name "sqlite3_X_init" where the
  /// X is consists of the lower-case equivalent of all ASCII alphabetic
  /// characters in the filename from the last "/" to the first following
  /// "." and omitting any initial "lib".)^
  /// ^The sqlite3_load_extension() interface returns
  /// [SQLITE_OK] on success and [SQLITE_ERROR] if something goes wrong.
  /// ^If an error occurs and pzErrMsg is not 0, then the
  /// [sqlite3_load_extension()] interface shall attempt to
  /// fill *pzErrMsg with error message text stored in memory
  /// obtained from [sqlite3_malloc()]. The calling function
  /// should free this memory by calling [sqlite3_free()].
  ///
  /// ^Extension loading must be enabled using
  /// [sqlite3_enable_load_extension()] or
  /// [sqlite3_db_config](db,[SQLITE_DBCONFIG_ENABLE_LOAD_EXTENSION],1,NULL)
  /// prior to calling this API,
  /// otherwise an error will be returned.
  ///
  /// <b>Security warning:</b> It is recommended that the
  /// [SQLITE_DBCONFIG_ENABLE_LOAD_EXTENSION] method be used to enable only this
  /// interface.  The use of the [sqlite3_enable_load_extension()] interface
  /// should be avoided.  This will keep the SQL function [load_extension()]
  /// disabled and prevent SQL injections from giving attackers
  /// access to extension loading capabilities.
  ///
  /// See also the [load_extension() SQL function].
  int sqlite3_load_extension(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zFile,
    ffi.Pointer<ffi.Char> zProc,
    ffi.Pointer<ffi.Pointer<ffi.Char>> pzErrMsg,
  ) {
    return _sqlite3_load_extension(
      db,
      zFile,
      zProc,
      pzErrMsg,
    );
  }

  late final _sqlite3_load_extensionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_load_extension');
  late final _sqlite3_load_extension = _sqlite3_load_extensionPtr.asFunction<
      int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  /// CAPI3REF: Enable Or Disable Extension Loading
  /// METHOD: sqlite3
  ///
  /// ^So as not to open security holes in older applications that are
  /// unprepared to deal with [extension loading], and as a means of disabling
  /// [extension loading] while evaluating user-entered SQL, the following API
  /// is provided to turn the [sqlite3_load_extension()] mechanism on and off.
  ///
  /// ^Extension loading is off by default.
  /// ^Call the sqlite3_enable_load_extension() routine with onoff==1
  /// to turn extension loading on and call it with onoff==0 to turn
  /// it back off again.
  ///
  /// ^This interface enables or disables both the C-API
  /// [sqlite3_load_extension()] and the SQL function [load_extension()].
  /// ^(Use [sqlite3_db_config](db,[SQLITE_DBCONFIG_ENABLE_LOAD_EXTENSION],..)
  /// to enable or disable only the C-API.)^
  ///
  /// <b>Security warning:</b> It is recommended that extension loading
  /// be enabled using the [SQLITE_DBCONFIG_ENABLE_LOAD_EXTENSION] method
  /// rather than this interface, so the [load_extension()] SQL function
  /// remains disabled. This will prevent SQL injections from giving attackers
  /// access to extension loading capabilities.
  int sqlite3_enable_load_extension(
    ffi.Pointer<sqlite3> db,
    int onoff,
  ) {
    return _sqlite3_enable_load_extension(
      db,
      onoff,
    );
  }

  late final _sqlite3_enable_load_extensionPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Int)>>(
      'sqlite3_enable_load_extension');
  late final _sqlite3_enable_load_extension = _sqlite3_enable_load_extensionPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, int)>();

  /// CAPI3REF: Automatically Load Statically Linked Extensions
  ///
  /// ^This interface causes the xEntryPoint() function to be invoked for
  /// each new [database connection] that is created.  The idea here is that
  /// xEntryPoint() is the entry point for a statically linked [SQLite extension]
  /// that is to be automatically loaded into all new database connections.
  ///
  /// ^(Even though the function prototype shows that xEntryPoint() takes
  /// no arguments and returns void, SQLite invokes xEntryPoint() with three
  /// arguments and expects an integer result as if the signature of the
  /// entry point where as follows:
  ///
  /// <blockquote><pre>
  /// &nbsp;  int xEntryPoint(
  /// &nbsp;    sqlite3 *db,
  /// &nbsp;    const char **pzErrMsg,
  /// &nbsp;    const struct sqlite3_api_routines *pThunk
  /// &nbsp;  );
  /// </pre></blockquote>)^
  ///
  /// If the xEntryPoint routine encounters an error, it should make *pzErrMsg
  /// point to an appropriate error message (obtained from [sqlite3_mprintf()])
  /// and return an appropriate [error code].  ^SQLite ensures that *pzErrMsg
  /// is NULL before calling the xEntryPoint().  ^SQLite will invoke
  /// [sqlite3_free()] on *pzErrMsg after xEntryPoint() returns.  ^If any
  /// xEntryPoint() returns an error, the [sqlite3_open()], [sqlite3_open16()],
  /// or [sqlite3_open_v2()] call that provoked the xEntryPoint() will fail.
  ///
  /// ^Calling sqlite3_auto_extension(X) with an entry point X that is already
  /// on the list of automatic extensions is a harmless no-op. ^No entry point
  /// will be called more than once for each database connection that is opened.
  ///
  /// See also: [sqlite3_reset_auto_extension()]
  /// and [sqlite3_cancel_auto_extension()]
  int sqlite3_auto_extension(
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>> xEntryPoint,
  ) {
    return _sqlite3_auto_extension(
      xEntryPoint,
    );
  }

  late final _sqlite3_auto_extensionPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>>)>>(
      'sqlite3_auto_extension');
  late final _sqlite3_auto_extension = _sqlite3_auto_extensionPtr.asFunction<
      int Function(ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>>)>();

  /// CAPI3REF: Cancel Automatic Extension Loading
  ///
  /// ^The [sqlite3_cancel_auto_extension(X)] interface unregisters the
  /// initialization routine X that was registered using a prior call to
  /// [sqlite3_auto_extension(X)].  ^The [sqlite3_cancel_auto_extension(X)]
  /// routine returns 1 if initialization routine X was successfully
  /// unregistered and it returns 0 if X was not on the list of initialization
  /// routines.
  int sqlite3_cancel_auto_extension(
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>> xEntryPoint,
  ) {
    return _sqlite3_cancel_auto_extension(
      xEntryPoint,
    );
  }

  late final _sqlite3_cancel_auto_extensionPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>>)>>(
      'sqlite3_cancel_auto_extension');
  late final _sqlite3_cancel_auto_extension =
      _sqlite3_cancel_auto_extensionPtr.asFunction<
          int Function(ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>>)>();

  /// CAPI3REF: Reset Automatic Extension Loading
  ///
  /// ^This interface disables all automatic extensions previously
  /// registered using [sqlite3_auto_extension()].
  void sqlite3_reset_auto_extension() {
    return _sqlite3_reset_auto_extension();
  }

  late final _sqlite3_reset_auto_extensionPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function()>>(
          'sqlite3_reset_auto_extension');
  late final _sqlite3_reset_auto_extension =
      _sqlite3_reset_auto_extensionPtr.asFunction<void Function()>();

  /// CAPI3REF: Register A Virtual Table Implementation
  /// METHOD: sqlite3
  ///
  /// ^These routines are used to register a new [virtual table module] name.
  /// ^Module names must be registered before
  /// creating a new [virtual table] using the module and before using a
  /// preexisting [virtual table] for the module.
  ///
  /// ^The module name is registered on the [database connection] specified
  /// by the first parameter.  ^The name of the module is given by the
  /// second parameter.  ^The third parameter is a pointer to
  /// the implementation of the [virtual table module].   ^The fourth
  /// parameter is an arbitrary client data pointer that is passed through
  /// into the [xCreate] and [xConnect] methods of the virtual table module
  /// when a new virtual table is be being created or reinitialized.
  ///
  /// ^The sqlite3_create_module_v2() interface has a fifth parameter which
  /// is a pointer to a destructor for the pClientData.  ^SQLite will
  /// invoke the destructor function (if it is not NULL) when SQLite
  /// no longer needs the pClientData pointer.  ^The destructor will also
  /// be invoked if the call to sqlite3_create_module_v2() fails.
  /// ^The sqlite3_create_module()
  /// interface is equivalent to sqlite3_create_module_v2() with a NULL
  /// destructor.
  ///
  /// ^If the third parameter (the pointer to the sqlite3_module object) is
  /// NULL then no new module is create and any existing modules with the
  /// same name are dropped.
  ///
  /// See also: [sqlite3_drop_modules()]
  int sqlite3_create_module(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zName,
    ffi.Pointer<sqlite3_module> p,
    ffi.Pointer<ffi.Void> pClientData,
  ) {
    return _sqlite3_create_module(
      db,
      zName,
      p,
      pClientData,
    );
  }

  late final _sqlite3_create_modulePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<sqlite3_module>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_create_module');
  late final _sqlite3_create_module = _sqlite3_create_modulePtr.asFunction<
      int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>,
          ffi.Pointer<sqlite3_module>, ffi.Pointer<ffi.Void>)>();

  int sqlite3_create_module_v2(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zName,
    ffi.Pointer<sqlite3_module> p,
    ffi.Pointer<ffi.Void> pClientData,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        xDestroy,
  ) {
    return _sqlite3_create_module_v2(
      db,
      zName,
      p,
      pClientData,
      xDestroy,
    );
  }

  late final _sqlite3_create_module_v2Ptr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<sqlite3_module>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>>(
      'sqlite3_create_module_v2');
  late final _sqlite3_create_module_v2 =
      _sqlite3_create_module_v2Ptr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<sqlite3_module>,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();

  /// CAPI3REF: Remove Unnecessary Virtual Table Implementations
  /// METHOD: sqlite3
  ///
  /// ^The sqlite3_drop_modules(D,L) interface removes all virtual
  /// table modules from database connection D except those named on list L.
  /// The L parameter must be either NULL or a pointer to an array of pointers
  /// to strings where the array is terminated by a single NULL pointer.
  /// ^If the L parameter is NULL, then all virtual table modules are removed.
  ///
  /// See also: [sqlite3_create_module()]
  int sqlite3_drop_modules(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Pointer<ffi.Char>> azKeep,
  ) {
    return _sqlite3_drop_modules(
      db,
      azKeep,
    );
  }

  late final _sqlite3_drop_modulesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('sqlite3_drop_modules');
  late final _sqlite3_drop_modules = _sqlite3_drop_modulesPtr.asFunction<
      int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  /// CAPI3REF: Declare The Schema Of A Virtual Table
  ///
  /// ^The [xCreate] and [xConnect] methods of a
  /// [virtual table module] call this interface
  /// to declare the format (the names and datatypes of the columns) of
  /// the virtual tables they implement.
  int sqlite3_declare_vtab(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Char> zSQL,
  ) {
    return _sqlite3_declare_vtab(
      arg0,
      zSQL,
    );
  }

  late final _sqlite3_declare_vtabPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_declare_vtab');
  late final _sqlite3_declare_vtab = _sqlite3_declare_vtabPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Overload A Function For A Virtual Table
  /// METHOD: sqlite3
  ///
  /// ^(Virtual tables can provide alternative implementations of functions
  /// using the [xFindFunction] method of the [virtual table module].
  /// But global versions of those functions
  /// must exist in order to be overloaded.)^
  ///
  /// ^(This API makes sure a global version of a function with a particular
  /// name and number of parameters exists.  If no such function exists
  /// before this API is called, a new function is created.)^  ^The implementation
  /// of the new function always causes an exception to be thrown.  So
  /// the new function is not good for anything by itself.  Its only
  /// purpose is to be a placeholder function that can be overloaded
  /// by a [virtual table].
  int sqlite3_overload_function(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Char> zFuncName,
    int nArg,
  ) {
    return _sqlite3_overload_function(
      arg0,
      zFuncName,
      nArg,
    );
  }

  late final _sqlite3_overload_functionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>,
              ffi.Int)>>('sqlite3_overload_function');
  late final _sqlite3_overload_function =
      _sqlite3_overload_functionPtr.asFunction<
          int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>, int)>();

  /// CAPI3REF: Open A BLOB For Incremental I/O
  /// METHOD: sqlite3
  /// CONSTRUCTOR: sqlite3_blob
  ///
  /// ^(This interfaces opens a [BLOB handle | handle] to the BLOB located
  /// in row iRow, column zColumn, table zTable in database zDb;
  /// in other words, the same BLOB that would be selected by:
  ///
  /// <pre>
  /// SELECT zColumn FROM zDb.zTable WHERE [rowid] = iRow;
  /// </pre>)^
  ///
  /// ^(Parameter zDb is not the filename that contains the database, but
  /// rather the symbolic name of the database. For attached databases, this is
  /// the name that appears after the AS keyword in the [ATTACH] statement.
  /// For the main database file, the database name is "main". For TEMP
  /// tables, the database name is "temp".)^
  ///
  /// ^If the flags parameter is non-zero, then the BLOB is opened for read
  /// and write access. ^If the flags parameter is zero, the BLOB is opened for
  /// read-only access.
  ///
  /// ^(On success, [SQLITE_OK] is returned and the new [BLOB handle] is stored
  /// in *ppBlob. Otherwise an [error code] is returned and, unless the error
  /// code is SQLITE_MISUSE, *ppBlob is set to NULL.)^ ^This means that, provided
  /// the API is not misused, it is always safe to call [sqlite3_blob_close()]
  /// on *ppBlob after this function it returns.
  ///
  /// This function fails with SQLITE_ERROR if any of the following are true:
  /// <ul>
  /// <li> ^(Database zDb does not exist)^,
  /// <li> ^(Table zTable does not exist within database zDb)^,
  /// <li> ^(Table zTable is a WITHOUT ROWID table)^,
  /// <li> ^(Column zColumn does not exist)^,
  /// <li> ^(Row iRow is not present in the table)^,
  /// <li> ^(The specified column of row iRow contains a value that is not
  /// a TEXT or BLOB value)^,
  /// <li> ^(Column zColumn is part of an index, PRIMARY KEY or UNIQUE
  /// constraint and the blob is being opened for read/write access)^,
  /// <li> ^([foreign key constraints | Foreign key constraints] are enabled,
  /// column zColumn is part of a [child key] definition and the blob is
  /// being opened for read/write access)^.
  /// </ul>
  ///
  /// ^Unless it returns SQLITE_MISUSE, this function sets the
  /// [database connection] error code and message accessible via
  /// [sqlite3_errcode()] and [sqlite3_errmsg()] and related functions.
  ///
  /// A BLOB referenced by sqlite3_blob_open() may be read using the
  /// [sqlite3_blob_read()] interface and modified by using
  /// [sqlite3_blob_write()].  The [BLOB handle] can be moved to a
  /// different row of the same table using the [sqlite3_blob_reopen()]
  /// interface.  However, the column, table, or database of a [BLOB handle]
  /// cannot be changed after the [BLOB handle] is opened.
  ///
  /// ^(If the row that a BLOB handle points to is modified by an
  /// [UPDATE], [DELETE], or by [ON CONFLICT] side-effects
  /// then the BLOB handle is marked as "expired".
  /// This is true if any column of the row is changed, even a column
  /// other than the one the BLOB handle is open on.)^
  /// ^Calls to [sqlite3_blob_read()] and [sqlite3_blob_write()] for
  /// an expired BLOB handle fail with a return code of [SQLITE_ABORT].
  /// ^(Changes written into a BLOB prior to the BLOB expiring are not
  /// rolled back by the expiration of the BLOB.  Such changes will eventually
  /// commit if the transaction continues to completion.)^
  ///
  /// ^Use the [sqlite3_blob_bytes()] interface to determine the size of
  /// the opened blob.  ^The size of a blob may not be changed by this
  /// interface.  Use the [UPDATE] SQL command to change the size of a
  /// blob.
  ///
  /// ^The [sqlite3_bind_zeroblob()] and [sqlite3_result_zeroblob()] interfaces
  /// and the built-in [zeroblob] SQL function may be used to create a
  /// zero-filled blob to read or write using the incremental-blob interface.
  ///
  /// To avoid a resource leak, every open [BLOB handle] should eventually
  /// be released by a call to [sqlite3_blob_close()].
  ///
  /// See also: [sqlite3_blob_close()],
  /// [sqlite3_blob_reopen()], [sqlite3_blob_read()],
  /// [sqlite3_blob_bytes()], [sqlite3_blob_write()].
  int sqlite3_blob_open(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Char> zDb,
    ffi.Pointer<ffi.Char> zTable,
    ffi.Pointer<ffi.Char> zColumn,
    int iRow,
    int flags,
    ffi.Pointer<ffi.Pointer<sqlite3_blob>> ppBlob,
  ) {
    return _sqlite3_blob_open(
      arg0,
      zDb,
      zTable,
      zColumn,
      iRow,
      flags,
      ppBlob,
    );
  }

  late final _sqlite3_blob_openPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              sqlite3_int64,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<sqlite3_blob>>)>>('sqlite3_blob_open');
  late final _sqlite3_blob_open = _sqlite3_blob_openPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          int,
          int,
          ffi.Pointer<ffi.Pointer<sqlite3_blob>>)>();

  /// CAPI3REF: Move a BLOB Handle to a New Row
  /// METHOD: sqlite3_blob
  ///
  /// ^This function is used to move an existing [BLOB handle] so that it points
  /// to a different row of the same database table. ^The new row is identified
  /// by the rowid value passed as the second argument. Only the row can be
  /// changed. ^The database, table and column on which the blob handle is open
  /// remain the same. Moving an existing [BLOB handle] to a new row is
  /// faster than closing the existing handle and opening a new one.
  ///
  /// ^(The new row must meet the same criteria as for [sqlite3_blob_open()] -
  /// it must exist and there must be either a blob or text value stored in
  /// the nominated column.)^ ^If the new row is not present in the table, or if
  /// it does not contain a blob or text value, or if another error occurs, an
  /// SQLite error code is returned and the blob handle is considered aborted.
  /// ^All subsequent calls to [sqlite3_blob_read()], [sqlite3_blob_write()] or
  /// [sqlite3_blob_reopen()] on an aborted blob handle immediately return
  /// SQLITE_ABORT. ^Calling [sqlite3_blob_bytes()] on an aborted blob handle
  /// always returns zero.
  ///
  /// ^This function sets the database handle error code and message.
  int sqlite3_blob_reopen(
    ffi.Pointer<sqlite3_blob> arg0,
    int arg1,
  ) {
    return _sqlite3_blob_reopen(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_blob_reopenPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_blob>,
              sqlite3_int64)>>('sqlite3_blob_reopen');
  late final _sqlite3_blob_reopen = _sqlite3_blob_reopenPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_blob>, int)>();

  /// CAPI3REF: Close A BLOB Handle
  /// DESTRUCTOR: sqlite3_blob
  ///
  /// ^This function closes an open [BLOB handle]. ^(The BLOB handle is closed
  /// unconditionally.  Even if this routine returns an error code, the
  /// handle is still closed.)^
  ///
  /// ^If the blob handle being closed was opened for read-write access, and if
  /// the database is in auto-commit mode and there are no other open read-write
  /// blob handles or active write statements, the current transaction is
  /// committed. ^If an error occurs while committing the transaction, an error
  /// code is returned and the transaction rolled back.
  ///
  /// Calling this function with an argument that is not a NULL pointer or an
  /// open blob handle results in undefined behaviour. ^Calling this routine
  /// with a null pointer (such as would be returned by a failed call to
  /// [sqlite3_blob_open()]) is a harmless no-op. ^Otherwise, if this function
  /// is passed a valid open blob handle, the values returned by the
  /// sqlite3_errcode() and sqlite3_errmsg() functions are set before returning.
  int sqlite3_blob_close(
    ffi.Pointer<sqlite3_blob> arg0,
  ) {
    return _sqlite3_blob_close(
      arg0,
    );
  }

  late final _sqlite3_blob_closePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_blob>)>>(
          'sqlite3_blob_close');
  late final _sqlite3_blob_close = _sqlite3_blob_closePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_blob>)>();

  /// CAPI3REF: Return The Size Of An Open BLOB
  /// METHOD: sqlite3_blob
  ///
  /// ^Returns the size in bytes of the BLOB accessible via the
  /// successfully opened [BLOB handle] in its only argument.  ^The
  /// incremental blob I/O routines can only read or overwriting existing
  /// blob content; they cannot change the size of a blob.
  ///
  /// This routine only works on a [BLOB handle] which has been created
  /// by a prior successful call to [sqlite3_blob_open()] and which has not
  /// been closed by [sqlite3_blob_close()].  Passing any other pointer in
  /// to this routine results in undefined and probably undesirable behavior.
  int sqlite3_blob_bytes(
    ffi.Pointer<sqlite3_blob> arg0,
  ) {
    return _sqlite3_blob_bytes(
      arg0,
    );
  }

  late final _sqlite3_blob_bytesPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_blob>)>>(
          'sqlite3_blob_bytes');
  late final _sqlite3_blob_bytes = _sqlite3_blob_bytesPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_blob>)>();

  /// CAPI3REF: Read Data From A BLOB Incrementally
  /// METHOD: sqlite3_blob
  ///
  /// ^(This function is used to read data from an open [BLOB handle] into a
  /// caller-supplied buffer. N bytes of data are copied into buffer Z
  /// from the open BLOB, starting at offset iOffset.)^
  ///
  /// ^If offset iOffset is less than N bytes from the end of the BLOB,
  /// [SQLITE_ERROR] is returned and no data is read.  ^If N or iOffset is
  /// less than zero, [SQLITE_ERROR] is returned and no data is read.
  /// ^The size of the blob (and hence the maximum value of N+iOffset)
  /// can be determined using the [sqlite3_blob_bytes()] interface.
  ///
  /// ^An attempt to read from an expired [BLOB handle] fails with an
  /// error code of [SQLITE_ABORT].
  ///
  /// ^(On success, sqlite3_blob_read() returns SQLITE_OK.
  /// Otherwise, an [error code] or an [extended error code] is returned.)^
  ///
  /// This routine only works on a [BLOB handle] which has been created
  /// by a prior successful call to [sqlite3_blob_open()] and which has not
  /// been closed by [sqlite3_blob_close()].  Passing any other pointer in
  /// to this routine results in undefined and probably undesirable behavior.
  ///
  /// See also: [sqlite3_blob_write()].
  int sqlite3_blob_read(
    ffi.Pointer<sqlite3_blob> arg0,
    ffi.Pointer<ffi.Void> Z,
    int N,
    int iOffset,
  ) {
    return _sqlite3_blob_read(
      arg0,
      Z,
      N,
      iOffset,
    );
  }

  late final _sqlite3_blob_readPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_blob>, ffi.Pointer<ffi.Void>,
              ffi.Int, ffi.Int)>>('sqlite3_blob_read');
  late final _sqlite3_blob_read = _sqlite3_blob_readPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_blob>, ffi.Pointer<ffi.Void>, int, int)>();

  /// CAPI3REF: Write Data Into A BLOB Incrementally
  /// METHOD: sqlite3_blob
  ///
  /// ^(This function is used to write data into an open [BLOB handle] from a
  /// caller-supplied buffer. N bytes of data are copied from the buffer Z
  /// into the open BLOB, starting at offset iOffset.)^
  ///
  /// ^(On success, sqlite3_blob_write() returns SQLITE_OK.
  /// Otherwise, an  [error code] or an [extended error code] is returned.)^
  /// ^Unless SQLITE_MISUSE is returned, this function sets the
  /// [database connection] error code and message accessible via
  /// [sqlite3_errcode()] and [sqlite3_errmsg()] and related functions.
  ///
  /// ^If the [BLOB handle] passed as the first argument was not opened for
  /// writing (the flags parameter to [sqlite3_blob_open()] was zero),
  /// this function returns [SQLITE_READONLY].
  ///
  /// This function may only modify the contents of the BLOB; it is
  /// not possible to increase the size of a BLOB using this API.
  /// ^If offset iOffset is less than N bytes from the end of the BLOB,
  /// [SQLITE_ERROR] is returned and no data is written. The size of the
  /// BLOB (and hence the maximum value of N+iOffset) can be determined
  /// using the [sqlite3_blob_bytes()] interface. ^If N or iOffset are less
  /// than zero [SQLITE_ERROR] is returned and no data is written.
  ///
  /// ^An attempt to write to an expired [BLOB handle] fails with an
  /// error code of [SQLITE_ABORT].  ^Writes to the BLOB that occurred
  /// before the [BLOB handle] expired are not rolled back by the
  /// expiration of the handle, though of course those changes might
  /// have been overwritten by the statement that expired the BLOB handle
  /// or by other independent statements.
  ///
  /// This routine only works on a [BLOB handle] which has been created
  /// by a prior successful call to [sqlite3_blob_open()] and which has not
  /// been closed by [sqlite3_blob_close()].  Passing any other pointer in
  /// to this routine results in undefined and probably undesirable behavior.
  ///
  /// See also: [sqlite3_blob_read()].
  int sqlite3_blob_write(
    ffi.Pointer<sqlite3_blob> arg0,
    ffi.Pointer<ffi.Void> z,
    int n,
    int iOffset,
  ) {
    return _sqlite3_blob_write(
      arg0,
      z,
      n,
      iOffset,
    );
  }

  late final _sqlite3_blob_writePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_blob>, ffi.Pointer<ffi.Void>,
              ffi.Int, ffi.Int)>>('sqlite3_blob_write');
  late final _sqlite3_blob_write = _sqlite3_blob_writePtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_blob>, ffi.Pointer<ffi.Void>, int, int)>();

  /// CAPI3REF: Virtual File System Objects
  ///
  /// A virtual filesystem (VFS) is an [sqlite3_vfs] object
  /// that SQLite uses to interact
  /// with the underlying operating system.  Most SQLite builds come with a
  /// single default VFS that is appropriate for the host computer.
  /// New VFSes can be registered and existing VFSes can be unregistered.
  /// The following interfaces are provided.
  ///
  /// ^The sqlite3_vfs_find() interface returns a pointer to a VFS given its name.
  /// ^Names are case sensitive.
  /// ^Names are zero-terminated UTF-8 strings.
  /// ^If there is no match, a NULL pointer is returned.
  /// ^If zVfsName is NULL then the default VFS is returned.
  ///
  /// ^New VFSes are registered with sqlite3_vfs_register().
  /// ^Each new VFS becomes the default VFS if the makeDflt flag is set.
  /// ^The same VFS can be registered multiple times without injury.
  /// ^To make an existing VFS into the default VFS, register it again
  /// with the makeDflt flag set.  If two different VFSes with the
  /// same name are registered, the behavior is undefined.  If a
  /// VFS is registered with a name that is NULL or an empty string,
  /// then the behavior is undefined.
  ///
  /// ^Unregister a VFS with the sqlite3_vfs_unregister() interface.
  /// ^(If the default VFS is unregistered, another VFS is chosen as
  /// the default.  The choice for the new VFS is arbitrary.)^
  ffi.Pointer<sqlite3_vfs> sqlite3_vfs_find(
    ffi.Pointer<ffi.Char> zVfsName,
  ) {
    return _sqlite3_vfs_find(
      zVfsName,
    );
  }

  late final _sqlite3_vfs_findPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_vfs> Function(
              ffi.Pointer<ffi.Char>)>>('sqlite3_vfs_find');
  late final _sqlite3_vfs_find = _sqlite3_vfs_findPtr
      .asFunction<ffi.Pointer<sqlite3_vfs> Function(ffi.Pointer<ffi.Char>)>();

  int sqlite3_vfs_register(
    ffi.Pointer<sqlite3_vfs> arg0,
    int makeDflt,
  ) {
    return _sqlite3_vfs_register(
      arg0,
      makeDflt,
    );
  }

  late final _sqlite3_vfs_registerPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vfs>, ffi.Int)>>(
      'sqlite3_vfs_register');
  late final _sqlite3_vfs_register = _sqlite3_vfs_registerPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_vfs>, int)>();

  int sqlite3_vfs_unregister(
    ffi.Pointer<sqlite3_vfs> arg0,
  ) {
    return _sqlite3_vfs_unregister(
      arg0,
    );
  }

  late final _sqlite3_vfs_unregisterPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vfs>)>>(
          'sqlite3_vfs_unregister');
  late final _sqlite3_vfs_unregister = _sqlite3_vfs_unregisterPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_vfs>)>();

  /// CAPI3REF: Mutexes
  ///
  /// The SQLite core uses these routines for thread
  /// synchronization. Though they are intended for internal
  /// use by SQLite, code that links against SQLite is
  /// permitted to use any of these routines.
  ///
  /// The SQLite source code contains multiple implementations
  /// of these mutex routines.  An appropriate implementation
  /// is selected automatically at compile-time.  The following
  /// implementations are available in the SQLite core:
  ///
  /// <ul>
  /// <li>   SQLITE_MUTEX_PTHREADS
  /// <li>   SQLITE_MUTEX_W32
  /// <li>   SQLITE_MUTEX_NOOP
  /// </ul>
  ///
  /// The SQLITE_MUTEX_NOOP implementation is a set of routines
  /// that does no real locking and is appropriate for use in
  /// a single-threaded application.  The SQLITE_MUTEX_PTHREADS and
  /// SQLITE_MUTEX_W32 implementations are appropriate for use on Unix
  /// and Windows.
  ///
  /// If SQLite is compiled with the SQLITE_MUTEX_APPDEF preprocessor
  /// macro defined (with "-DSQLITE_MUTEX_APPDEF=1"), then no mutex
  /// implementation is included with the library. In this case the
  /// application must supply a custom mutex implementation using the
  /// [SQLITE_CONFIG_MUTEX] option of the sqlite3_config() function
  /// before calling sqlite3_initialize() or any other public sqlite3_
  /// function that calls sqlite3_initialize().
  ///
  /// ^The sqlite3_mutex_alloc() routine allocates a new
  /// mutex and returns a pointer to it. ^The sqlite3_mutex_alloc()
  /// routine returns NULL if it is unable to allocate the requested
  /// mutex.  The argument to sqlite3_mutex_alloc() must one of these
  /// integer constants:
  ///
  /// <ul>
  /// <li>  SQLITE_MUTEX_FAST
  /// <li>  SQLITE_MUTEX_RECURSIVE
  /// <li>  SQLITE_MUTEX_STATIC_MASTER
  /// <li>  SQLITE_MUTEX_STATIC_MEM
  /// <li>  SQLITE_MUTEX_STATIC_OPEN
  /// <li>  SQLITE_MUTEX_STATIC_PRNG
  /// <li>  SQLITE_MUTEX_STATIC_LRU
  /// <li>  SQLITE_MUTEX_STATIC_PMEM
  /// <li>  SQLITE_MUTEX_STATIC_APP1
  /// <li>  SQLITE_MUTEX_STATIC_APP2
  /// <li>  SQLITE_MUTEX_STATIC_APP3
  /// <li>  SQLITE_MUTEX_STATIC_VFS1
  /// <li>  SQLITE_MUTEX_STATIC_VFS2
  /// <li>  SQLITE_MUTEX_STATIC_VFS3
  /// </ul>
  ///
  /// ^The first two constants (SQLITE_MUTEX_FAST and SQLITE_MUTEX_RECURSIVE)
  /// cause sqlite3_mutex_alloc() to create
  /// a new mutex.  ^The new mutex is recursive when SQLITE_MUTEX_RECURSIVE
  /// is used but not necessarily so when SQLITE_MUTEX_FAST is used.
  /// The mutex implementation does not need to make a distinction
  /// between SQLITE_MUTEX_RECURSIVE and SQLITE_MUTEX_FAST if it does
  /// not want to.  SQLite will only request a recursive mutex in
  /// cases where it really needs one.  If a faster non-recursive mutex
  /// implementation is available on the host platform, the mutex subsystem
  /// might return such a mutex in response to SQLITE_MUTEX_FAST.
  ///
  /// ^The other allowed parameters to sqlite3_mutex_alloc() (anything other
  /// than SQLITE_MUTEX_FAST and SQLITE_MUTEX_RECURSIVE) each return
  /// a pointer to a static preexisting mutex.  ^Nine static mutexes are
  /// used by the current version of SQLite.  Future versions of SQLite
  /// may add additional static mutexes.  Static mutexes are for internal
  /// use by SQLite only.  Applications that use SQLite mutexes should
  /// use only the dynamic mutexes returned by SQLITE_MUTEX_FAST or
  /// SQLITE_MUTEX_RECURSIVE.
  ///
  /// ^Note that if one of the dynamic mutex parameters (SQLITE_MUTEX_FAST
  /// or SQLITE_MUTEX_RECURSIVE) is used then sqlite3_mutex_alloc()
  /// returns a different mutex on every call.  ^For the static
  /// mutex types, the same mutex is returned on every call that has
  /// the same type number.
  ///
  /// ^The sqlite3_mutex_free() routine deallocates a previously
  /// allocated dynamic mutex.  Attempting to deallocate a static
  /// mutex results in undefined behavior.
  ///
  /// ^The sqlite3_mutex_enter() and sqlite3_mutex_try() routines attempt
  /// to enter a mutex.  ^If another thread is already within the mutex,
  /// sqlite3_mutex_enter() will block and sqlite3_mutex_try() will return
  /// SQLITE_BUSY.  ^The sqlite3_mutex_try() interface returns [SQLITE_OK]
  /// upon successful entry.  ^(Mutexes created using
  /// SQLITE_MUTEX_RECURSIVE can be entered multiple times by the same thread.
  /// In such cases, the
  /// mutex must be exited an equal number of times before another thread
  /// can enter.)^  If the same thread tries to enter any mutex other
  /// than an SQLITE_MUTEX_RECURSIVE more than once, the behavior is undefined.
  ///
  /// ^(Some systems (for example, Windows 95) do not support the operation
  /// implemented by sqlite3_mutex_try().  On those systems, sqlite3_mutex_try()
  /// will always return SQLITE_BUSY. The SQLite core only ever uses
  /// sqlite3_mutex_try() as an optimization so this is acceptable
  /// behavior.)^
  ///
  /// ^The sqlite3_mutex_leave() routine exits a mutex that was
  /// previously entered by the same thread.   The behavior
  /// is undefined if the mutex is not currently entered by the
  /// calling thread or is not currently allocated.
  ///
  /// ^If the argument to sqlite3_mutex_enter(), sqlite3_mutex_try(), or
  /// sqlite3_mutex_leave() is a NULL pointer, then all three routines
  /// behave as no-ops.
  ///
  /// See also: [sqlite3_mutex_held()] and [sqlite3_mutex_notheld()].
  ffi.Pointer<sqlite3_mutex> sqlite3_mutex_alloc(
    int arg0,
  ) {
    return _sqlite3_mutex_alloc(
      arg0,
    );
  }

  late final _sqlite3_mutex_allocPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<sqlite3_mutex> Function(ffi.Int)>>(
          'sqlite3_mutex_alloc');
  late final _sqlite3_mutex_alloc = _sqlite3_mutex_allocPtr
      .asFunction<ffi.Pointer<sqlite3_mutex> Function(int)>();

  void sqlite3_mutex_free(
    ffi.Pointer<sqlite3_mutex> arg0,
  ) {
    return _sqlite3_mutex_free(
      arg0,
    );
  }

  late final _sqlite3_mutex_freePtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_mutex>)>>(
      'sqlite3_mutex_free');
  late final _sqlite3_mutex_free = _sqlite3_mutex_freePtr
      .asFunction<void Function(ffi.Pointer<sqlite3_mutex>)>();

  void sqlite3_mutex_enter(
    ffi.Pointer<sqlite3_mutex> arg0,
  ) {
    return _sqlite3_mutex_enter(
      arg0,
    );
  }

  late final _sqlite3_mutex_enterPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_mutex>)>>(
      'sqlite3_mutex_enter');
  late final _sqlite3_mutex_enter = _sqlite3_mutex_enterPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_mutex>)>();

  int sqlite3_mutex_try(
    ffi.Pointer<sqlite3_mutex> arg0,
  ) {
    return _sqlite3_mutex_try(
      arg0,
    );
  }

  late final _sqlite3_mutex_tryPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_mutex>)>>(
          'sqlite3_mutex_try');
  late final _sqlite3_mutex_try = _sqlite3_mutex_tryPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_mutex>)>();

  void sqlite3_mutex_leave(
    ffi.Pointer<sqlite3_mutex> arg0,
  ) {
    return _sqlite3_mutex_leave(
      arg0,
    );
  }

  late final _sqlite3_mutex_leavePtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_mutex>)>>(
      'sqlite3_mutex_leave');
  late final _sqlite3_mutex_leave = _sqlite3_mutex_leavePtr
      .asFunction<void Function(ffi.Pointer<sqlite3_mutex>)>();

  int sqlite3_mutex_held(
    ffi.Pointer<sqlite3_mutex> arg0,
  ) {
    return _sqlite3_mutex_held(
      arg0,
    );
  }

  late final _sqlite3_mutex_heldPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_mutex>)>>(
          'sqlite3_mutex_held');
  late final _sqlite3_mutex_held = _sqlite3_mutex_heldPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_mutex>)>();

  int sqlite3_mutex_notheld(
    ffi.Pointer<sqlite3_mutex> arg0,
  ) {
    return _sqlite3_mutex_notheld(
      arg0,
    );
  }

  late final _sqlite3_mutex_notheldPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_mutex>)>>(
          'sqlite3_mutex_notheld');
  late final _sqlite3_mutex_notheld = _sqlite3_mutex_notheldPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_mutex>)>();

  /// CAPI3REF: Retrieve the mutex for a database connection
  /// METHOD: sqlite3
  ///
  /// ^This interface returns a pointer the [sqlite3_mutex] object that
  /// serializes access to the [database connection] given in the argument
  /// when the [threading mode] is Serialized.
  /// ^If the [threading mode] is Single-thread or Multi-thread then this
  /// routine returns a NULL pointer.
  ffi.Pointer<sqlite3_mutex> sqlite3_db_mutex(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_db_mutex(
      arg0,
    );
  }

  late final _sqlite3_db_mutexPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_mutex> Function(
              ffi.Pointer<sqlite3>)>>('sqlite3_db_mutex');
  late final _sqlite3_db_mutex = _sqlite3_db_mutexPtr
      .asFunction<ffi.Pointer<sqlite3_mutex> Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Low-Level Control Of Database Files
  /// METHOD: sqlite3
  /// KEYWORDS: {file control}
  ///
  /// ^The [sqlite3_file_control()] interface makes a direct call to the
  /// xFileControl method for the [sqlite3_io_methods] object associated
  /// with a particular database identified by the second argument. ^The
  /// name of the database is "main" for the main database or "temp" for the
  /// TEMP database, or the name that appears after the AS keyword for
  /// databases that are added using the [ATTACH] SQL command.
  /// ^A NULL pointer can be used in place of "main" to refer to the
  /// main database file.
  /// ^The third and fourth parameters to this routine
  /// are passed directly through to the second and third parameters of
  /// the xFileControl method.  ^The return value of the xFileControl
  /// method becomes the return value of this routine.
  ///
  /// A few opcodes for [sqlite3_file_control()] are handled directly
  /// by the SQLite core and never invoke the
  /// sqlite3_io_methods.xFileControl method.
  /// ^The [SQLITE_FCNTL_FILE_POINTER] value for the op parameter causes
  /// a pointer to the underlying [sqlite3_file] object to be written into
  /// the space pointed to by the 4th parameter.  The
  /// [SQLITE_FCNTL_JOURNAL_POINTER] works similarly except that it returns
  /// the [sqlite3_file] object associated with the journal file instead of
  /// the main database.  The [SQLITE_FCNTL_VFS_POINTER] opcode returns
  /// a pointer to the underlying [sqlite3_vfs] object for the file.
  /// The [SQLITE_FCNTL_DATA_VERSION] returns the data version counter
  /// from the pager.
  ///
  /// ^If the second parameter (zDbName) does not match the name of any
  /// open database file, then SQLITE_ERROR is returned.  ^This error
  /// code is not remembered and will not be recalled by [sqlite3_errcode()]
  /// or [sqlite3_errmsg()].  The underlying xFileControl method might
  /// also return SQLITE_ERROR.  There is no way to distinguish between
  /// an incorrect zDbName and an SQLITE_ERROR return from the underlying
  /// xFileControl method.
  ///
  /// See also: [file control opcodes]
  int sqlite3_file_control(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<ffi.Char> zDbName,
    int op,
    ffi.Pointer<ffi.Void> arg3,
  ) {
    return _sqlite3_file_control(
      arg0,
      zDbName,
      op,
      arg3,
    );
  }

  late final _sqlite3_file_controlPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>, ffi.Int,
              ffi.Pointer<ffi.Void>)>>('sqlite3_file_control');
  late final _sqlite3_file_control = _sqlite3_file_controlPtr.asFunction<
      int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>, int,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Testing Interface
  ///
  /// ^The sqlite3_test_control() interface is used to read out internal
  /// state of SQLite and to inject faults into SQLite for testing
  /// purposes.  ^The first parameter is an operation code that determines
  /// the number, meaning, and operation of all subsequent parameters.
  ///
  /// This interface is not for use by applications.  It exists solely
  /// for verifying the correct operation of the SQLite library.  Depending
  /// on how the SQLite library is compiled, this interface might not exist.
  ///
  /// The details of the operation codes, their meanings, the parameters
  /// they take, and what they do are all subject to change without notice.
  /// Unlike most of the SQLite API, this function is not guaranteed to
  /// operate consistently from one release to the next.
  int sqlite3_test_control(
    int op,
  ) {
    return _sqlite3_test_control(
      op,
    );
  }

  late final _sqlite3_test_controlPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Int)>>(
          'sqlite3_test_control');
  late final _sqlite3_test_control =
      _sqlite3_test_controlPtr.asFunction<int Function(int)>();

  /// CAPI3REF: SQL Keyword Checking
  ///
  /// These routines provide access to the set of SQL language keywords
  /// recognized by SQLite.  Applications can uses these routines to determine
  /// whether or not a specific identifier needs to be escaped (for example,
  /// by enclosing in double-quotes) so as not to confuse the parser.
  ///
  /// The sqlite3_keyword_count() interface returns the number of distinct
  /// keywords understood by SQLite.
  ///
  /// The sqlite3_keyword_name(N,Z,L) interface finds the N-th keyword and
  /// makes *Z point to that keyword expressed as UTF8 and writes the number
  /// of bytes in the keyword into *L.  The string that *Z points to is not
  /// zero-terminated.  The sqlite3_keyword_name(N,Z,L) routine returns
  /// SQLITE_OK if N is within bounds and SQLITE_ERROR if not. If either Z
  /// or L are NULL or invalid pointers then calls to
  /// sqlite3_keyword_name(N,Z,L) result in undefined behavior.
  ///
  /// The sqlite3_keyword_check(Z,L) interface checks to see whether or not
  /// the L-byte UTF8 identifier that Z points to is a keyword, returning non-zero
  /// if it is and zero if not.
  ///
  /// The parser used by SQLite is forgiving.  It is often possible to use
  /// a keyword as an identifier as long as such use does not result in a
  /// parsing ambiguity.  For example, the statement
  /// "CREATE TABLE BEGIN(REPLACE,PRAGMA,END);" is accepted by SQLite, and
  /// creates a new table named "BEGIN" with three columns named
  /// "REPLACE", "PRAGMA", and "END".  Nevertheless, best practice is to avoid
  /// using keywords as identifiers.  Common techniques used to avoid keyword
  /// name collisions include:
  /// <ul>
  /// <li> Put all identifier names inside double-quotes.  This is the official
  /// SQL way to escape identifier names.
  /// <li> Put identifier names inside &#91;...&#93;.  This is not standard SQL,
  /// but it is what SQL Server does and so lots of programmers use this
  /// technique.
  /// <li> Begin every identifier with the letter "Z" as no SQL keywords start
  /// with "Z".
  /// <li> Include a digit somewhere in every identifier name.
  /// </ul>
  ///
  /// Note that the number of keywords understood by SQLite can depend on
  /// compile-time options.  For example, "VACUUM" is not a keyword if
  /// SQLite is compiled with the [-DSQLITE_OMIT_VACUUM] option.  Also,
  /// new keywords may be added to future releases of SQLite.
  int sqlite3_keyword_count() {
    return _sqlite3_keyword_count();
  }

  late final _sqlite3_keyword_countPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>('sqlite3_keyword_count');
  late final _sqlite3_keyword_count =
      _sqlite3_keyword_countPtr.asFunction<int Function()>();

  int sqlite3_keyword_name(
    int arg0,
    ffi.Pointer<ffi.Pointer<ffi.Char>> arg1,
    ffi.Pointer<ffi.Int> arg2,
  ) {
    return _sqlite3_keyword_name(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_keyword_namePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Int, ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Int>)>>('sqlite3_keyword_name');
  late final _sqlite3_keyword_name = _sqlite3_keyword_namePtr.asFunction<
      int Function(
          int, ffi.Pointer<ffi.Pointer<ffi.Char>>, ffi.Pointer<ffi.Int>)>();

  int sqlite3_keyword_check(
    ffi.Pointer<ffi.Char> arg0,
    int arg1,
  ) {
    return _sqlite3_keyword_check(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_keyword_checkPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Int)>>(
      'sqlite3_keyword_check');
  late final _sqlite3_keyword_check = _sqlite3_keyword_checkPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, int)>();

  /// CAPI3REF: Create A New Dynamic String Object
  /// CONSTRUCTOR: sqlite3_str
  ///
  /// ^The [sqlite3_str_new(D)] interface allocates and initializes
  /// a new [sqlite3_str] object.  To avoid memory leaks, the object returned by
  /// [sqlite3_str_new()] must be freed by a subsequent call to
  /// [sqlite3_str_finish(X)].
  ///
  /// ^The [sqlite3_str_new(D)] interface always returns a pointer to a
  /// valid [sqlite3_str] object, though in the event of an out-of-memory
  /// error the returned object might be a special singleton that will
  /// silently reject new text, always return SQLITE_NOMEM from
  /// [sqlite3_str_errcode()], always return 0 for
  /// [sqlite3_str_length()], and always return NULL from
  /// [sqlite3_str_finish(X)].  It is always safe to use the value
  /// returned by [sqlite3_str_new(D)] as the sqlite3_str parameter
  /// to any of the other [sqlite3_str] methods.
  ///
  /// The D parameter to [sqlite3_str_new(D)] may be NULL.  If the
  /// D parameter in [sqlite3_str_new(D)] is not NULL, then the maximum
  /// length of the string contained in the [sqlite3_str] object will be
  /// the value set for [sqlite3_limit](D,[SQLITE_LIMIT_LENGTH]) instead
  /// of [SQLITE_MAX_LENGTH].
  ffi.Pointer<sqlite3_str> sqlite3_str_new(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_str_new(
      arg0,
    );
  }

  late final _sqlite3_str_newPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_str> Function(
              ffi.Pointer<sqlite3>)>>('sqlite3_str_new');
  late final _sqlite3_str_new = _sqlite3_str_newPtr
      .asFunction<ffi.Pointer<sqlite3_str> Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Finalize A Dynamic String
  /// DESTRUCTOR: sqlite3_str
  ///
  /// ^The [sqlite3_str_finish(X)] interface destroys the sqlite3_str object X
  /// and returns a pointer to a memory buffer obtained from [sqlite3_malloc64()]
  /// that contains the constructed string.  The calling application should
  /// pass the returned value to [sqlite3_free()] to avoid a memory leak.
  /// ^The [sqlite3_str_finish(X)] interface may return a NULL pointer if any
  /// errors were encountered during construction of the string.  ^The
  /// [sqlite3_str_finish(X)] interface will also return a NULL pointer if the
  /// string in [sqlite3_str] object X is zero bytes long.
  ffi.Pointer<ffi.Char> sqlite3_str_finish(
    ffi.Pointer<sqlite3_str> arg0,
  ) {
    return _sqlite3_str_finish(
      arg0,
    );
  }

  late final _sqlite3_str_finishPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<sqlite3_str>)>>('sqlite3_str_finish');
  late final _sqlite3_str_finish = _sqlite3_str_finishPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_str>)>();

  /// CAPI3REF: Add Content To A Dynamic String
  /// METHOD: sqlite3_str
  ///
  /// These interfaces add content to an sqlite3_str object previously obtained
  /// from [sqlite3_str_new()].
  ///
  /// ^The [sqlite3_str_appendf(X,F,...)] and
  /// [sqlite3_str_vappendf(X,F,V)] interfaces uses the [built-in printf]
  /// functionality of SQLite to append formatted text onto the end of
  /// [sqlite3_str] object X.
  ///
  /// ^The [sqlite3_str_append(X,S,N)] method appends exactly N bytes from string S
  /// onto the end of the [sqlite3_str] object X.  N must be non-negative.
  /// S must contain at least N non-zero bytes of content.  To append a
  /// zero-terminated string in its entirety, use the [sqlite3_str_appendall()]
  /// method instead.
  ///
  /// ^The [sqlite3_str_appendall(X,S)] method appends the complete content of
  /// zero-terminated string S onto the end of [sqlite3_str] object X.
  ///
  /// ^The [sqlite3_str_appendchar(X,N,C)] method appends N copies of the
  /// single-byte character C onto the end of [sqlite3_str] object X.
  /// ^This method can be used, for example, to add whitespace indentation.
  ///
  /// ^The [sqlite3_str_reset(X)] method resets the string under construction
  /// inside [sqlite3_str] object X back to zero bytes in length.
  ///
  /// These methods do not return a result code.  ^If an error occurs, that fact
  /// is recorded in the [sqlite3_str] object and can be recovered by a
  /// subsequent call to [sqlite3_str_errcode(X)].
  void sqlite3_str_appendf(
    ffi.Pointer<sqlite3_str> arg0,
    ffi.Pointer<ffi.Char> zFormat,
  ) {
    return _sqlite3_str_appendf(
      arg0,
      zFormat,
    );
  }

  late final _sqlite3_str_appendfPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_str>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_str_appendf');
  late final _sqlite3_str_appendf = _sqlite3_str_appendfPtr.asFunction<
      void Function(ffi.Pointer<sqlite3_str>, ffi.Pointer<ffi.Char>)>();

  void sqlite3_str_append(
    ffi.Pointer<sqlite3_str> arg0,
    ffi.Pointer<ffi.Char> zIn,
    int N,
  ) {
    return _sqlite3_str_append(
      arg0,
      zIn,
      N,
    );
  }

  late final _sqlite3_str_appendPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_str>, ffi.Pointer<ffi.Char>,
              ffi.Int)>>('sqlite3_str_append');
  late final _sqlite3_str_append = _sqlite3_str_appendPtr.asFunction<
      void Function(ffi.Pointer<sqlite3_str>, ffi.Pointer<ffi.Char>, int)>();

  void sqlite3_str_appendall(
    ffi.Pointer<sqlite3_str> arg0,
    ffi.Pointer<ffi.Char> zIn,
  ) {
    return _sqlite3_str_appendall(
      arg0,
      zIn,
    );
  }

  late final _sqlite3_str_appendallPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_str>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_str_appendall');
  late final _sqlite3_str_appendall = _sqlite3_str_appendallPtr.asFunction<
      void Function(ffi.Pointer<sqlite3_str>, ffi.Pointer<ffi.Char>)>();

  void sqlite3_str_appendchar(
    ffi.Pointer<sqlite3_str> arg0,
    int N,
    int C,
  ) {
    return _sqlite3_str_appendchar(
      arg0,
      N,
      C,
    );
  }

  late final _sqlite3_str_appendcharPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_str>, ffi.Int,
              ffi.Char)>>('sqlite3_str_appendchar');
  late final _sqlite3_str_appendchar = _sqlite3_str_appendcharPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_str>, int, int)>();

  void sqlite3_str_reset(
    ffi.Pointer<sqlite3_str> arg0,
  ) {
    return _sqlite3_str_reset(
      arg0,
    );
  }

  late final _sqlite3_str_resetPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_str>)>>(
          'sqlite3_str_reset');
  late final _sqlite3_str_reset = _sqlite3_str_resetPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_str>)>();

  /// CAPI3REF: Status Of A Dynamic String
  /// METHOD: sqlite3_str
  ///
  /// These interfaces return the current status of an [sqlite3_str] object.
  ///
  /// ^If any prior errors have occurred while constructing the dynamic string
  /// in sqlite3_str X, then the [sqlite3_str_errcode(X)] method will return
  /// an appropriate error code.  ^The [sqlite3_str_errcode(X)] method returns
  /// [SQLITE_NOMEM] following any out-of-memory error, or
  /// [SQLITE_TOOBIG] if the size of the dynamic string exceeds
  /// [SQLITE_MAX_LENGTH], or [SQLITE_OK] if there have been no errors.
  ///
  /// ^The [sqlite3_str_length(X)] method returns the current length, in bytes,
  /// of the dynamic string under construction in [sqlite3_str] object X.
  /// ^The length returned by [sqlite3_str_length(X)] does not include the
  /// zero-termination byte.
  ///
  /// ^The [sqlite3_str_value(X)] method returns a pointer to the current
  /// content of the dynamic string under construction in X.  The value
  /// returned by [sqlite3_str_value(X)] is managed by the sqlite3_str object X
  /// and might be freed or altered by any subsequent method on the same
  /// [sqlite3_str] object.  Applications must not used the pointer returned
  /// [sqlite3_str_value(X)] after any subsequent method call on the same
  /// object.  ^Applications may change the content of the string returned
  /// by [sqlite3_str_value(X)] as long as they do not write into any bytes
  /// outside the range of 0 to [sqlite3_str_length(X)] and do not read or
  /// write any byte after any subsequent sqlite3_str method call.
  int sqlite3_str_errcode(
    ffi.Pointer<sqlite3_str> arg0,
  ) {
    return _sqlite3_str_errcode(
      arg0,
    );
  }

  late final _sqlite3_str_errcodePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_str>)>>(
          'sqlite3_str_errcode');
  late final _sqlite3_str_errcode = _sqlite3_str_errcodePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_str>)>();

  int sqlite3_str_length(
    ffi.Pointer<sqlite3_str> arg0,
  ) {
    return _sqlite3_str_length(
      arg0,
    );
  }

  late final _sqlite3_str_lengthPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_str>)>>(
          'sqlite3_str_length');
  late final _sqlite3_str_length = _sqlite3_str_lengthPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_str>)>();

  ffi.Pointer<ffi.Char> sqlite3_str_value(
    ffi.Pointer<sqlite3_str> arg0,
  ) {
    return _sqlite3_str_value(
      arg0,
    );
  }

  late final _sqlite3_str_valuePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(
              ffi.Pointer<sqlite3_str>)>>('sqlite3_str_value');
  late final _sqlite3_str_value = _sqlite3_str_valuePtr
      .asFunction<ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_str>)>();

  /// CAPI3REF: SQLite Runtime Status
  ///
  /// ^These interfaces are used to retrieve runtime status information
  /// about the performance of SQLite, and optionally to reset various
  /// highwater marks.  ^The first argument is an integer code for
  /// the specific parameter to measure.  ^(Recognized integer codes
  /// are of the form [status parameters | SQLITE_STATUS_...].)^
  /// ^The current value of the parameter is returned into *pCurrent.
  /// ^The highest recorded value is returned in *pHighwater.  ^If the
  /// resetFlag is true, then the highest record value is reset after
  /// *pHighwater is written.  ^(Some parameters do not record the highest
  /// value.  For those parameters
  /// nothing is written into *pHighwater and the resetFlag is ignored.)^
  /// ^(Other parameters record only the highwater mark and not the current
  /// value.  For these latter parameters nothing is written into *pCurrent.)^
  ///
  /// ^The sqlite3_status() and sqlite3_status64() routines return
  /// SQLITE_OK on success and a non-zero [error code] on failure.
  ///
  /// If either the current value or the highwater mark is too large to
  /// be represented by a 32-bit integer, then the values returned by
  /// sqlite3_status() are undefined.
  ///
  /// See also: [sqlite3_db_status()]
  int sqlite3_status(
    int op,
    ffi.Pointer<ffi.Int> pCurrent,
    ffi.Pointer<ffi.Int> pHighwater,
    int resetFlag,
  ) {
    return _sqlite3_status(
      op,
      pCurrent,
      pHighwater,
      resetFlag,
    );
  }

  late final _sqlite3_statusPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Int, ffi.Pointer<ffi.Int>, ffi.Pointer<ffi.Int>,
              ffi.Int)>>('sqlite3_status');
  late final _sqlite3_status = _sqlite3_statusPtr.asFunction<
      int Function(int, ffi.Pointer<ffi.Int>, ffi.Pointer<ffi.Int>, int)>();

  int sqlite3_status64(
    int op,
    ffi.Pointer<sqlite3_int64> pCurrent,
    ffi.Pointer<sqlite3_int64> pHighwater,
    int resetFlag,
  ) {
    return _sqlite3_status64(
      op,
      pCurrent,
      pHighwater,
      resetFlag,
    );
  }

  late final _sqlite3_status64Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Int, ffi.Pointer<sqlite3_int64>,
              ffi.Pointer<sqlite3_int64>, ffi.Int)>>('sqlite3_status64');
  late final _sqlite3_status64 = _sqlite3_status64Ptr.asFunction<
      int Function(
          int, ffi.Pointer<sqlite3_int64>, ffi.Pointer<sqlite3_int64>, int)>();

  /// CAPI3REF: Database Connection Status
  /// METHOD: sqlite3
  ///
  /// ^This interface is used to retrieve runtime status information
  /// about a single [database connection].  ^The first argument is the
  /// database connection object to be interrogated.  ^The second argument
  /// is an integer constant, taken from the set of
  /// [SQLITE_DBSTATUS options], that
  /// determines the parameter to interrogate.  The set of
  /// [SQLITE_DBSTATUS options] is likely
  /// to grow in future releases of SQLite.
  ///
  /// ^The current value of the requested parameter is written into *pCur
  /// and the highest instantaneous value is written into *pHiwtr.  ^If
  /// the resetFlg is true, then the highest instantaneous value is
  /// reset back down to the current value.
  ///
  /// ^The sqlite3_db_status() routine returns SQLITE_OK on success and a
  /// non-zero [error code] on failure.
  ///
  /// See also: [sqlite3_status()] and [sqlite3_stmt_status()].
  int sqlite3_db_status(
    ffi.Pointer<sqlite3> arg0,
    int op,
    ffi.Pointer<ffi.Int> pCur,
    ffi.Pointer<ffi.Int> pHiwtr,
    int resetFlg,
  ) {
    return _sqlite3_db_status(
      arg0,
      op,
      pCur,
      pHiwtr,
      resetFlg,
    );
  }

  late final _sqlite3_db_statusPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Int, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>, ffi.Int)>>('sqlite3_db_status');
  late final _sqlite3_db_status = _sqlite3_db_statusPtr.asFunction<
      int Function(ffi.Pointer<sqlite3>, int, ffi.Pointer<ffi.Int>,
          ffi.Pointer<ffi.Int>, int)>();

  /// CAPI3REF: Prepared Statement Status
  /// METHOD: sqlite3_stmt
  ///
  /// ^(Each prepared statement maintains various
  /// [SQLITE_STMTSTATUS counters] that measure the number
  /// of times it has performed specific operations.)^  These counters can
  /// be used to monitor the performance characteristics of the prepared
  /// statements.  For example, if the number of table steps greatly exceeds
  /// the number of table searches or result rows, that would tend to indicate
  /// that the prepared statement is using a full table scan rather than
  /// an index.
  ///
  /// ^(This interface is used to retrieve and reset counter values from
  /// a [prepared statement].  The first argument is the prepared statement
  /// object to be interrogated.  The second argument
  /// is an integer code for a specific [SQLITE_STMTSTATUS counter]
  /// to be interrogated.)^
  /// ^The current value of the requested counter is returned.
  /// ^If the resetFlg is true, then the counter is reset to zero after this
  /// interface call returns.
  ///
  /// See also: [sqlite3_status()] and [sqlite3_db_status()].
  int sqlite3_stmt_status(
    ffi.Pointer<sqlite3_stmt> arg0,
    int op,
    int resetFlg,
  ) {
    return _sqlite3_stmt_status(
      arg0,
      op,
      resetFlg,
    );
  }

  late final _sqlite3_stmt_statusPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>, ffi.Int,
              ffi.Int)>>('sqlite3_stmt_status');
  late final _sqlite3_stmt_status = _sqlite3_stmt_statusPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_stmt>, int, int)>();

  /// CAPI3REF: Online Backup API.
  ///
  /// The backup API copies the content of one database into another.
  /// It is useful either for creating backups of databases or
  /// for copying in-memory databases to or from persistent files.
  ///
  /// See Also: [Using the SQLite Online Backup API]
  ///
  /// ^SQLite holds a write transaction open on the destination database file
  /// for the duration of the backup operation.
  /// ^The source database is read-locked only while it is being read;
  /// it is not locked continuously for the entire backup operation.
  /// ^Thus, the backup may be performed on a live source database without
  /// preventing other database connections from
  /// reading or writing to the source database while the backup is underway.
  ///
  /// ^(To perform a backup operation:
  /// <ol>
  /// <li><b>sqlite3_backup_init()</b> is called once to initialize the
  /// backup,
  /// <li><b>sqlite3_backup_step()</b> is called one or more times to transfer
  /// the data between the two databases, and finally
  /// <li><b>sqlite3_backup_finish()</b> is called to release all resources
  /// associated with the backup operation.
  /// </ol>)^
  /// There should be exactly one call to sqlite3_backup_finish() for each
  /// successful call to sqlite3_backup_init().
  ///
  /// [[sqlite3_backup_init()]] <b>sqlite3_backup_init()</b>
  ///
  /// ^The D and N arguments to sqlite3_backup_init(D,N,S,M) are the
  /// [database connection] associated with the destination database
  /// and the database name, respectively.
  /// ^The database name is "main" for the main database, "temp" for the
  /// temporary database, or the name specified after the AS keyword in
  /// an [ATTACH] statement for an attached database.
  /// ^The S and M arguments passed to
  /// sqlite3_backup_init(D,N,S,M) identify the [database connection]
  /// and database name of the source database, respectively.
  /// ^The source and destination [database connections] (parameters S and D)
  /// must be different or else sqlite3_backup_init(D,N,S,M) will fail with
  /// an error.
  ///
  /// ^A call to sqlite3_backup_init() will fail, returning NULL, if
  /// there is already a read or read-write transaction open on the
  /// destination database.
  ///
  /// ^If an error occurs within sqlite3_backup_init(D,N,S,M), then NULL is
  /// returned and an error code and error message are stored in the
  /// destination [database connection] D.
  /// ^The error code and message for the failed call to sqlite3_backup_init()
  /// can be retrieved using the [sqlite3_errcode()], [sqlite3_errmsg()], and/or
  /// [sqlite3_errmsg16()] functions.
  /// ^A successful call to sqlite3_backup_init() returns a pointer to an
  /// [sqlite3_backup] object.
  /// ^The [sqlite3_backup] object may be used with the sqlite3_backup_step() and
  /// sqlite3_backup_finish() functions to perform the specified backup
  /// operation.
  ///
  /// [[sqlite3_backup_step()]] <b>sqlite3_backup_step()</b>
  ///
  /// ^Function sqlite3_backup_step(B,N) will copy up to N pages between
  /// the source and destination databases specified by [sqlite3_backup] object B.
  /// ^If N is negative, all remaining source pages are copied.
  /// ^If sqlite3_backup_step(B,N) successfully copies N pages and there
  /// are still more pages to be copied, then the function returns [SQLITE_OK].
  /// ^If sqlite3_backup_step(B,N) successfully finishes copying all pages
  /// from source to destination, then it returns [SQLITE_DONE].
  /// ^If an error occurs while running sqlite3_backup_step(B,N),
  /// then an [error code] is returned. ^As well as [SQLITE_OK] and
  /// [SQLITE_DONE], a call to sqlite3_backup_step() may return [SQLITE_READONLY],
  /// [SQLITE_NOMEM], [SQLITE_BUSY], [SQLITE_LOCKED], or an
  /// [SQLITE_IOERR_ACCESS | SQLITE_IOERR_XXX] extended error code.
  ///
  /// ^(The sqlite3_backup_step() might return [SQLITE_READONLY] if
  /// <ol>
  /// <li> the destination database was opened read-only, or
  /// <li> the destination database is using write-ahead-log journaling
  /// and the destination and source page sizes differ, or
  /// <li> the destination database is an in-memory database and the
  /// destination and source page sizes differ.
  /// </ol>)^
  ///
  /// ^If sqlite3_backup_step() cannot obtain a required file-system lock, then
  /// the [sqlite3_busy_handler | busy-handler function]
  /// is invoked (if one is specified). ^If the
  /// busy-handler returns non-zero before the lock is available, then
  /// [SQLITE_BUSY] is returned to the caller. ^In this case the call to
  /// sqlite3_backup_step() can be retried later. ^If the source
  /// [database connection]
  /// is being used to write to the source database when sqlite3_backup_step()
  /// is called, then [SQLITE_LOCKED] is returned immediately. ^Again, in this
  /// case the call to sqlite3_backup_step() can be retried later on. ^(If
  /// [SQLITE_IOERR_ACCESS | SQLITE_IOERR_XXX], [SQLITE_NOMEM], or
  /// [SQLITE_READONLY] is returned, then
  /// there is no point in retrying the call to sqlite3_backup_step(). These
  /// errors are considered fatal.)^  The application must accept
  /// that the backup operation has failed and pass the backup operation handle
  /// to the sqlite3_backup_finish() to release associated resources.
  ///
  /// ^The first call to sqlite3_backup_step() obtains an exclusive lock
  /// on the destination file. ^The exclusive lock is not released until either
  /// sqlite3_backup_finish() is called or the backup operation is complete
  /// and sqlite3_backup_step() returns [SQLITE_DONE].  ^Every call to
  /// sqlite3_backup_step() obtains a [shared lock] on the source database that
  /// lasts for the duration of the sqlite3_backup_step() call.
  /// ^Because the source database is not locked between calls to
  /// sqlite3_backup_step(), the source database may be modified mid-way
  /// through the backup process.  ^If the source database is modified by an
  /// external process or via a database connection other than the one being
  /// used by the backup operation, then the backup will be automatically
  /// restarted by the next call to sqlite3_backup_step(). ^If the source
  /// database is modified by the using the same database connection as is used
  /// by the backup operation, then the backup database is automatically
  /// updated at the same time.
  ///
  /// [[sqlite3_backup_finish()]] <b>sqlite3_backup_finish()</b>
  ///
  /// When sqlite3_backup_step() has returned [SQLITE_DONE], or when the
  /// application wishes to abandon the backup operation, the application
  /// should destroy the [sqlite3_backup] by passing it to sqlite3_backup_finish().
  /// ^The sqlite3_backup_finish() interfaces releases all
  /// resources associated with the [sqlite3_backup] object.
  /// ^If sqlite3_backup_step() has not yet returned [SQLITE_DONE], then any
  /// active write-transaction on the destination database is rolled back.
  /// The [sqlite3_backup] object is invalid
  /// and may not be used following a call to sqlite3_backup_finish().
  ///
  /// ^The value returned by sqlite3_backup_finish is [SQLITE_OK] if no
  /// sqlite3_backup_step() errors occurred, regardless or whether or not
  /// sqlite3_backup_step() completed.
  /// ^If an out-of-memory condition or IO error occurred during any prior
  /// sqlite3_backup_step() call on the same [sqlite3_backup] object, then
  /// sqlite3_backup_finish() returns the corresponding [error code].
  ///
  /// ^A return of [SQLITE_BUSY] or [SQLITE_LOCKED] from sqlite3_backup_step()
  /// is not a permanent error and does not affect the return value of
  /// sqlite3_backup_finish().
  ///
  /// [[sqlite3_backup_remaining()]] [[sqlite3_backup_pagecount()]]
  /// <b>sqlite3_backup_remaining() and sqlite3_backup_pagecount()</b>
  ///
  /// ^The sqlite3_backup_remaining() routine returns the number of pages still
  /// to be backed up at the conclusion of the most recent sqlite3_backup_step().
  /// ^The sqlite3_backup_pagecount() routine returns the total number of pages
  /// in the source database at the conclusion of the most recent
  /// sqlite3_backup_step().
  /// ^(The values returned by these functions are only updated by
  /// sqlite3_backup_step(). If the source database is modified in a way that
  /// changes the size of the source database or the number of pages remaining,
  /// those changes are not reflected in the output of sqlite3_backup_pagecount()
  /// and sqlite3_backup_remaining() until after the next
  /// sqlite3_backup_step().)^
  ///
  /// <b>Concurrent Usage of Database Handles</b>
  ///
  /// ^The source [database connection] may be used by the application for other
  /// purposes while a backup operation is underway or being initialized.
  /// ^If SQLite is compiled and configured to support threadsafe database
  /// connections, then the source database connection may be used concurrently
  /// from within other threads.
  ///
  /// However, the application must guarantee that the destination
  /// [database connection] is not passed to any other API (by any thread) after
  /// sqlite3_backup_init() is called and before the corresponding call to
  /// sqlite3_backup_finish().  SQLite does not currently check to see
  /// if the application incorrectly accesses the destination [database connection]
  /// and so no error code is reported, but the operations may malfunction
  /// nevertheless.  Use of the destination database connection while a
  /// backup is in progress might also also cause a mutex deadlock.
  ///
  /// If running in [shared cache mode], the application must
  /// guarantee that the shared cache used by the destination database
  /// is not accessed while the backup is running. In practice this means
  /// that the application must guarantee that the disk file being
  /// backed up to is not accessed by any connection within the process,
  /// not just the specific connection that was passed to sqlite3_backup_init().
  ///
  /// The [sqlite3_backup] object itself is partially threadsafe. Multiple
  /// threads may safely make multiple concurrent calls to sqlite3_backup_step().
  /// However, the sqlite3_backup_remaining() and sqlite3_backup_pagecount()
  /// APIs are not strictly speaking threadsafe. If they are invoked at the
  /// same time as another thread is invoking sqlite3_backup_step() it is
  /// possible that they return invalid values.
  ffi.Pointer<sqlite3_backup> sqlite3_backup_init(
    ffi.Pointer<sqlite3> pDest,
    ffi.Pointer<ffi.Char> zDestName,
    ffi.Pointer<sqlite3> pSource,
    ffi.Pointer<ffi.Char> zSourceName,
  ) {
    return _sqlite3_backup_init(
      pDest,
      zDestName,
      pSource,
      zSourceName,
    );
  }

  late final _sqlite3_backup_initPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_backup> Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_backup_init');
  late final _sqlite3_backup_init = _sqlite3_backup_initPtr.asFunction<
      ffi.Pointer<sqlite3_backup> Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>)>();

  int sqlite3_backup_step(
    ffi.Pointer<sqlite3_backup> p,
    int nPage,
  ) {
    return _sqlite3_backup_step(
      p,
      nPage,
    );
  }

  late final _sqlite3_backup_stepPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_backup>, ffi.Int)>>('sqlite3_backup_step');
  late final _sqlite3_backup_step = _sqlite3_backup_stepPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_backup>, int)>();

  int sqlite3_backup_finish(
    ffi.Pointer<sqlite3_backup> p,
  ) {
    return _sqlite3_backup_finish(
      p,
    );
  }

  late final _sqlite3_backup_finishPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_backup>)>>(
      'sqlite3_backup_finish');
  late final _sqlite3_backup_finish = _sqlite3_backup_finishPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_backup>)>();

  int sqlite3_backup_remaining(
    ffi.Pointer<sqlite3_backup> p,
  ) {
    return _sqlite3_backup_remaining(
      p,
    );
  }

  late final _sqlite3_backup_remainingPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_backup>)>>(
      'sqlite3_backup_remaining');
  late final _sqlite3_backup_remaining = _sqlite3_backup_remainingPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_backup>)>();

  int sqlite3_backup_pagecount(
    ffi.Pointer<sqlite3_backup> p,
  ) {
    return _sqlite3_backup_pagecount(
      p,
    );
  }

  late final _sqlite3_backup_pagecountPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_backup>)>>(
      'sqlite3_backup_pagecount');
  late final _sqlite3_backup_pagecount = _sqlite3_backup_pagecountPtr
      .asFunction<int Function(ffi.Pointer<sqlite3_backup>)>();

  /// CAPI3REF: Unlock Notification
  /// METHOD: sqlite3
  ///
  /// ^When running in shared-cache mode, a database operation may fail with
  /// an [SQLITE_LOCKED] error if the required locks on the shared-cache or
  /// individual tables within the shared-cache cannot be obtained. See
  /// [SQLite Shared-Cache Mode] for a description of shared-cache locking.
  /// ^This API may be used to register a callback that SQLite will invoke
  /// when the connection currently holding the required lock relinquishes it.
  /// ^This API is only available if the library was compiled with the
  /// [SQLITE_ENABLE_UNLOCK_NOTIFY] C-preprocessor symbol defined.
  ///
  /// See Also: [Using the SQLite Unlock Notification Feature].
  ///
  /// ^Shared-cache locks are released when a database connection concludes
  /// its current transaction, either by committing it or rolling it back.
  ///
  /// ^When a connection (known as the blocked connection) fails to obtain a
  /// shared-cache lock and SQLITE_LOCKED is returned to the caller, the
  /// identity of the database connection (the blocking connection) that
  /// has locked the required resource is stored internally. ^After an
  /// application receives an SQLITE_LOCKED error, it may call the
  /// sqlite3_unlock_notify() method with the blocked connection handle as
  /// the first argument to register for a callback that will be invoked
  /// when the blocking connections current transaction is concluded. ^The
  /// callback is invoked from within the [sqlite3_step] or [sqlite3_close]
  /// call that concludes the blocking connection's transaction.
  ///
  /// ^(If sqlite3_unlock_notify() is called in a multi-threaded application,
  /// there is a chance that the blocking connection will have already
  /// concluded its transaction by the time sqlite3_unlock_notify() is invoked.
  /// If this happens, then the specified callback is invoked immediately,
  /// from within the call to sqlite3_unlock_notify().)^
  ///
  /// ^If the blocked connection is attempting to obtain a write-lock on a
  /// shared-cache table, and more than one other connection currently holds
  /// a read-lock on the same table, then SQLite arbitrarily selects one of
  /// the other connections to use as the blocking connection.
  ///
  /// ^(There may be at most one unlock-notify callback registered by a
  /// blocked connection. If sqlite3_unlock_notify() is called when the
  /// blocked connection already has a registered unlock-notify callback,
  /// then the new callback replaces the old.)^ ^If sqlite3_unlock_notify() is
  /// called with a NULL pointer as its second argument, then any existing
  /// unlock-notify callback is canceled. ^The blocked connections
  /// unlock-notify callback may also be canceled by closing the blocked
  /// connection using [sqlite3_close()].
  ///
  /// The unlock-notify callback is not reentrant. If an application invokes
  /// any sqlite3_xxx API functions from within an unlock-notify callback, a
  /// crash or deadlock may be the result.
  ///
  /// ^Unless deadlock is detected (see below), sqlite3_unlock_notify() always
  /// returns SQLITE_OK.
  ///
  /// <b>Callback Invocation Details</b>
  ///
  /// When an unlock-notify callback is registered, the application provides a
  /// single void* pointer that is passed to the callback when it is invoked.
  /// However, the signature of the callback function allows SQLite to pass
  /// it an array of void* context pointers. The first argument passed to
  /// an unlock-notify callback is a pointer to an array of void* pointers,
  /// and the second is the number of entries in the array.
  ///
  /// When a blocking connection's transaction is concluded, there may be
  /// more than one blocked connection that has registered for an unlock-notify
  /// callback. ^If two or more such blocked connections have specified the
  /// same callback function, then instead of invoking the callback function
  /// multiple times, it is invoked once with the set of void* context pointers
  /// specified by the blocked connections bundled together into an array.
  /// This gives the application an opportunity to prioritize any actions
  /// related to the set of unblocked database connections.
  ///
  /// <b>Deadlock Detection</b>
  ///
  /// Assuming that after registering for an unlock-notify callback a
  /// database waits for the callback to be issued before taking any further
  /// action (a reasonable assumption), then using this API may cause the
  /// application to deadlock. For example, if connection X is waiting for
  /// connection Y's transaction to be concluded, and similarly connection
  /// Y is waiting on connection X's transaction, then neither connection
  /// will proceed and the system may remain deadlocked indefinitely.
  ///
  /// To avoid this scenario, the sqlite3_unlock_notify() performs deadlock
  /// detection. ^If a given call to sqlite3_unlock_notify() would put the
  /// system in a deadlocked state, then SQLITE_LOCKED is returned and no
  /// unlock-notify callback is registered. The system is said to be in
  /// a deadlocked state if connection A has registered for an unlock-notify
  /// callback on the conclusion of connection B's transaction, and connection
  /// B has itself registered for an unlock-notify callback when connection
  /// A's transaction is concluded. ^Indirect deadlock is also detected, so
  /// the system is also considered to be deadlocked if connection B has
  /// registered for an unlock-notify callback on the conclusion of connection
  /// C's transaction, where connection C is waiting on connection A. ^Any
  /// number of levels of indirection are allowed.
  ///
  /// <b>The "DROP TABLE" Exception</b>
  ///
  /// When a call to [sqlite3_step()] returns SQLITE_LOCKED, it is almost
  /// always appropriate to call sqlite3_unlock_notify(). There is however,
  /// one exception. When executing a "DROP TABLE" or "DROP INDEX" statement,
  /// SQLite checks if there are any currently executing SELECT statements
  /// that belong to the same connection. If there are, SQLITE_LOCKED is
  /// returned. In this case there is no "blocking connection", so invoking
  /// sqlite3_unlock_notify() results in the unlock-notify callback being
  /// invoked immediately. If the application then re-attempts the "DROP TABLE"
  /// or "DROP INDEX" query, an infinite loop might be the result.
  ///
  /// One way around this problem is to check the extended error code returned
  /// by an sqlite3_step() call. ^(If there is a blocking connection, then the
  /// extended error code is set to SQLITE_LOCKED_SHAREDCACHE. Otherwise, in
  /// the special "DROP TABLE/INDEX" case, the extended error code is just
  /// SQLITE_LOCKED.)^
  int sqlite3_unlock_notify(
    ffi.Pointer<sqlite3> pBlocked,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Void Function(
                    ffi.Pointer<ffi.Pointer<ffi.Void>> apArg, ffi.Int nArg)>>
        xNotify,
    ffi.Pointer<ffi.Void> pNotifyArg,
  ) {
    return _sqlite3_unlock_notify(
      pBlocked,
      xNotify,
      pNotifyArg,
    );
  }

  late final _sqlite3_unlock_notifyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(
                          ffi.Pointer<ffi.Pointer<ffi.Void>> apArg,
                          ffi.Int nArg)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_unlock_notify');
  late final _sqlite3_unlock_notify = _sqlite3_unlock_notifyPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Void Function(
                      ffi.Pointer<ffi.Pointer<ffi.Void>> apArg, ffi.Int nArg)>>,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: String Comparison
  ///
  /// ^The [sqlite3_stricmp()] and [sqlite3_strnicmp()] APIs allow applications
  /// and extensions to compare the contents of two buffers containing UTF-8
  /// strings in a case-independent fashion, using the same definition of "case
  /// independence" that SQLite uses internally when comparing identifiers.
  int sqlite3_stricmp(
    ffi.Pointer<ffi.Char> arg0,
    ffi.Pointer<ffi.Char> arg1,
  ) {
    return _sqlite3_stricmp(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_stricmpPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_stricmp');
  late final _sqlite3_stricmp = _sqlite3_stricmpPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>();

  int sqlite3_strnicmp(
    ffi.Pointer<ffi.Char> arg0,
    ffi.Pointer<ffi.Char> arg1,
    int arg2,
  ) {
    return _sqlite3_strnicmp(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_strnicmpPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Int)>>('sqlite3_strnicmp');
  late final _sqlite3_strnicmp = _sqlite3_strnicmpPtr.asFunction<
      int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>, int)>();

  /// CAPI3REF: String Globbing
  ///
  /// ^The [sqlite3_strglob(P,X)] interface returns zero if and only if
  /// string X matches the [GLOB] pattern P.
  /// ^The definition of [GLOB] pattern matching used in
  /// [sqlite3_strglob(P,X)] is the same as for the "X GLOB P" operator in the
  /// SQL dialect understood by SQLite.  ^The [sqlite3_strglob(P,X)] function
  /// is case sensitive.
  ///
  /// Note that this routine returns zero on a match and non-zero if the strings
  /// do not match, the same as [sqlite3_stricmp()] and [sqlite3_strnicmp()].
  ///
  /// See also: [sqlite3_strlike()].
  int sqlite3_strglob(
    ffi.Pointer<ffi.Char> zGlob,
    ffi.Pointer<ffi.Char> zStr,
  ) {
    return _sqlite3_strglob(
      zGlob,
      zStr,
    );
  }

  late final _sqlite3_strglobPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_strglob');
  late final _sqlite3_strglob = _sqlite3_strglobPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: String LIKE Matching
  ///
  /// ^The [sqlite3_strlike(P,X,E)] interface returns zero if and only if
  /// string X matches the [LIKE] pattern P with escape character E.
  /// ^The definition of [LIKE] pattern matching used in
  /// [sqlite3_strlike(P,X,E)] is the same as for the "X LIKE P ESCAPE E"
  /// operator in the SQL dialect understood by SQLite.  ^For "X LIKE P" without
  /// the ESCAPE clause, set the E parameter of [sqlite3_strlike(P,X,E)] to 0.
  /// ^As with the LIKE operator, the [sqlite3_strlike(P,X,E)] function is case
  /// insensitive - equivalent upper and lower case ASCII characters match
  /// one another.
  ///
  /// ^The [sqlite3_strlike(P,X,E)] function matches Unicode characters, though
  /// only ASCII characters are case folded.
  ///
  /// Note that this routine returns zero on a match and non-zero if the strings
  /// do not match, the same as [sqlite3_stricmp()] and [sqlite3_strnicmp()].
  ///
  /// See also: [sqlite3_strglob()].
  int sqlite3_strlike(
    ffi.Pointer<ffi.Char> zGlob,
    ffi.Pointer<ffi.Char> zStr,
    int cEsc,
  ) {
    return _sqlite3_strlike(
      zGlob,
      zStr,
      cEsc,
    );
  }

  late final _sqlite3_strlikePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.UnsignedInt)>>('sqlite3_strlike');
  late final _sqlite3_strlike = _sqlite3_strlikePtr.asFunction<
      int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>, int)>();

  /// CAPI3REF: Error Logging Interface
  ///
  /// ^The [sqlite3_log()] interface writes a message into the [error log]
  /// established by the [SQLITE_CONFIG_LOG] option to [sqlite3_config()].
  /// ^If logging is enabled, the zFormat string and subsequent arguments are
  /// used with [sqlite3_snprintf()] to generate the final output string.
  ///
  /// The sqlite3_log() interface is intended for use by extensions such as
  /// virtual tables, collating functions, and SQL functions.  While there is
  /// nothing to prevent an application from calling sqlite3_log(), doing so
  /// is considered bad form.
  ///
  /// The zFormat string must not be NULL.
  ///
  /// To avoid deadlocks and other threading problems, the sqlite3_log() routine
  /// will not use dynamically allocated memory.  The log message is stored in
  /// a fixed-length buffer on the stack.  If the log message is longer than
  /// a few hundred characters, it will be truncated to the length of the
  /// buffer.
  void sqlite3_log(
    int iErrCode,
    ffi.Pointer<ffi.Char> zFormat,
  ) {
    return _sqlite3_log(
      iErrCode,
      zFormat,
    );
  }

  late final _sqlite3_logPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Int, ffi.Pointer<ffi.Char>)>>('sqlite3_log');
  late final _sqlite3_log =
      _sqlite3_logPtr.asFunction<void Function(int, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Write-Ahead Log Commit Hook
  /// METHOD: sqlite3
  ///
  /// ^The [sqlite3_wal_hook()] function is used to register a callback that
  /// is invoked each time data is committed to a database in wal mode.
  ///
  /// ^(The callback is invoked by SQLite after the commit has taken place and
  /// the associated write-lock on the database released)^, so the implementation
  /// may read, write or [checkpoint] the database as required.
  ///
  /// ^The first parameter passed to the callback function when it is invoked
  /// is a copy of the third parameter passed to sqlite3_wal_hook() when
  /// registering the callback. ^The second is a copy of the database handle.
  /// ^The third parameter is the name of the database that was written to -
  /// either "main" or the name of an [ATTACH]-ed database. ^The fourth parameter
  /// is the number of pages currently in the write-ahead log file,
  /// including those that were just committed.
  ///
  /// The callback function should normally return [SQLITE_OK].  ^If an error
  /// code is returned, that error will propagate back up through the
  /// SQLite code base to cause the statement that provoked the callback
  /// to report an error, though the commit will have still occurred. If the
  /// callback returns [SQLITE_ROW] or [SQLITE_DONE], or if it returns a value
  /// that does not correspond to any valid SQLite error code, the results
  /// are undefined.
  ///
  /// A single database handle may have at most a single write-ahead log callback
  /// registered at one time. ^Calling [sqlite3_wal_hook()] replaces any
  /// previously registered write-ahead log callback. ^Note that the
  /// [sqlite3_wal_autocheckpoint()] interface and the
  /// [wal_autocheckpoint pragma] both invoke [sqlite3_wal_hook()] and will
  /// overwrite any prior [sqlite3_wal_hook()] settings.
  ffi.Pointer<ffi.Void> sqlite3_wal_hook(
    ffi.Pointer<sqlite3> arg0,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(ffi.Pointer<ffi.Void>, ffi.Pointer<sqlite3>,
                    ffi.Pointer<ffi.Char>, ffi.Int)>>
        arg1,
    ffi.Pointer<ffi.Void> arg2,
  ) {
    return _sqlite3_wal_hook(
      arg0,
      arg1,
      arg2,
    );
  }

  late final _sqlite3_wal_hookPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Pointer<sqlite3>,
                          ffi.Pointer<ffi.Char>,
                          ffi.Int)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_wal_hook');
  late final _sqlite3_wal_hook = _sqlite3_wal_hookPtr.asFunction<
      ffi.Pointer<ffi.Void> Function(
          ffi.Pointer<sqlite3>,
          ffi.Pointer<
              ffi.NativeFunction<
                  ffi.Int Function(ffi.Pointer<ffi.Void>, ffi.Pointer<sqlite3>,
                      ffi.Pointer<ffi.Char>, ffi.Int)>>,
          ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Configure an auto-checkpoint
  /// METHOD: sqlite3
  ///
  /// ^The [sqlite3_wal_autocheckpoint(D,N)] is a wrapper around
  /// [sqlite3_wal_hook()] that causes any database on [database connection] D
  /// to automatically [checkpoint]
  /// after committing a transaction if there are N or
  /// more frames in the [write-ahead log] file.  ^Passing zero or
  /// a negative value as the nFrame parameter disables automatic
  /// checkpoints entirely.
  ///
  /// ^The callback registered by this function replaces any existing callback
  /// registered using [sqlite3_wal_hook()].  ^Likewise, registering a callback
  /// using [sqlite3_wal_hook()] disables the automatic checkpoint mechanism
  /// configured by this function.
  ///
  /// ^The [wal_autocheckpoint pragma] can be used to invoke this interface
  /// from SQL.
  ///
  /// ^Checkpoints initiated by this mechanism are
  /// [sqlite3_wal_checkpoint_v2|PASSIVE].
  ///
  /// ^Every new [database connection] defaults to having the auto-checkpoint
  /// enabled with a threshold of 1000 or [SQLITE_DEFAULT_WAL_AUTOCHECKPOINT]
  /// pages.  The use of this interface
  /// is only necessary if the default setting is found to be suboptimal
  /// for a particular application.
  int sqlite3_wal_autocheckpoint(
    ffi.Pointer<sqlite3> db,
    int N,
  ) {
    return _sqlite3_wal_autocheckpoint(
      db,
      N,
    );
  }

  late final _sqlite3_wal_autocheckpointPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Int)>>(
      'sqlite3_wal_autocheckpoint');
  late final _sqlite3_wal_autocheckpoint = _sqlite3_wal_autocheckpointPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, int)>();

  /// CAPI3REF: Checkpoint a database
  /// METHOD: sqlite3
  ///
  /// ^(The sqlite3_wal_checkpoint(D,X) is equivalent to
  /// [sqlite3_wal_checkpoint_v2](D,X,[SQLITE_CHECKPOINT_PASSIVE],0,0).)^
  ///
  /// In brief, sqlite3_wal_checkpoint(D,X) causes the content in the
  /// [write-ahead log] for database X on [database connection] D to be
  /// transferred into the database file and for the write-ahead log to
  /// be reset.  See the [checkpointing] documentation for addition
  /// information.
  ///
  /// This interface used to be the only way to cause a checkpoint to
  /// occur.  But then the newer and more powerful [sqlite3_wal_checkpoint_v2()]
  /// interface was added.  This interface is retained for backwards
  /// compatibility and as a convenience for applications that need to manually
  /// start a callback but which do not need the full power (and corresponding
  /// complication) of [sqlite3_wal_checkpoint_v2()].
  int sqlite3_wal_checkpoint(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zDb,
  ) {
    return _sqlite3_wal_checkpoint(
      db,
      zDb,
    );
  }

  late final _sqlite3_wal_checkpointPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_wal_checkpoint');
  late final _sqlite3_wal_checkpoint = _sqlite3_wal_checkpointPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Checkpoint a database
  /// METHOD: sqlite3
  ///
  /// ^(The sqlite3_wal_checkpoint_v2(D,X,M,L,C) interface runs a checkpoint
  /// operation on database X of [database connection] D in mode M.  Status
  /// information is written back into integers pointed to by L and C.)^
  /// ^(The M parameter must be a valid [checkpoint mode]:)^
  ///
  /// <dl>
  /// <dt>SQLITE_CHECKPOINT_PASSIVE<dd>
  /// ^Checkpoint as many frames as possible without waiting for any database
  /// readers or writers to finish, then sync the database file if all frames
  /// in the log were checkpointed. ^The [busy-handler callback]
  /// is never invoked in the SQLITE_CHECKPOINT_PASSIVE mode.
  /// ^On the other hand, passive mode might leave the checkpoint unfinished
  /// if there are concurrent readers or writers.
  ///
  /// <dt>SQLITE_CHECKPOINT_FULL<dd>
  /// ^This mode blocks (it invokes the
  /// [sqlite3_busy_handler|busy-handler callback]) until there is no
  /// database writer and all readers are reading from the most recent database
  /// snapshot. ^It then checkpoints all frames in the log file and syncs the
  /// database file. ^This mode blocks new database writers while it is pending,
  /// but new database readers are allowed to continue unimpeded.
  ///
  /// <dt>SQLITE_CHECKPOINT_RESTART<dd>
  /// ^This mode works the same way as SQLITE_CHECKPOINT_FULL with the addition
  /// that after checkpointing the log file it blocks (calls the
  /// [busy-handler callback])
  /// until all readers are reading from the database file only. ^This ensures
  /// that the next writer will restart the log file from the beginning.
  /// ^Like SQLITE_CHECKPOINT_FULL, this mode blocks new
  /// database writer attempts while it is pending, but does not impede readers.
  ///
  /// <dt>SQLITE_CHECKPOINT_TRUNCATE<dd>
  /// ^This mode works the same way as SQLITE_CHECKPOINT_RESTART with the
  /// addition that it also truncates the log file to zero bytes just prior
  /// to a successful return.
  /// </dl>
  ///
  /// ^If pnLog is not NULL, then *pnLog is set to the total number of frames in
  /// the log file or to -1 if the checkpoint could not run because
  /// of an error or because the database is not in [WAL mode]. ^If pnCkpt is not
  /// NULL,then *pnCkpt is set to the total number of checkpointed frames in the
  /// log file (including any that were already checkpointed before the function
  /// was called) or to -1 if the checkpoint could not run due to an error or
  /// because the database is not in WAL mode. ^Note that upon successful
  /// completion of an SQLITE_CHECKPOINT_TRUNCATE, the log file will have been
  /// truncated to zero bytes and so both *pnLog and *pnCkpt will be set to zero.
  ///
  /// ^All calls obtain an exclusive "checkpoint" lock on the database file. ^If
  /// any other process is running a checkpoint operation at the same time, the
  /// lock cannot be obtained and SQLITE_BUSY is returned. ^Even if there is a
  /// busy-handler configured, it will not be invoked in this case.
  ///
  /// ^The SQLITE_CHECKPOINT_FULL, RESTART and TRUNCATE modes also obtain the
  /// exclusive "writer" lock on the database file. ^If the writer lock cannot be
  /// obtained immediately, and a busy-handler is configured, it is invoked and
  /// the writer lock retried until either the busy-handler returns 0 or the lock
  /// is successfully obtained. ^The busy-handler is also invoked while waiting for
  /// database readers as described above. ^If the busy-handler returns 0 before
  /// the writer lock is obtained or while waiting for database readers, the
  /// checkpoint operation proceeds from that point in the same way as
  /// SQLITE_CHECKPOINT_PASSIVE - checkpointing as many frames as possible
  /// without blocking any further. ^SQLITE_BUSY is returned in this case.
  ///
  /// ^If parameter zDb is NULL or points to a zero length string, then the
  /// specified operation is attempted on all WAL databases [attached] to
  /// [database connection] db.  In this case the
  /// values written to output parameters *pnLog and *pnCkpt are undefined. ^If
  /// an SQLITE_BUSY error is encountered when processing one or more of the
  /// attached WAL databases, the operation is still attempted on any remaining
  /// attached databases and SQLITE_BUSY is returned at the end. ^If any other
  /// error occurs while processing an attached database, processing is abandoned
  /// and the error code is returned to the caller immediately. ^If no error
  /// (SQLITE_BUSY or otherwise) is encountered while processing the attached
  /// databases, SQLITE_OK is returned.
  ///
  /// ^If database zDb is the name of an attached database that is not in WAL
  /// mode, SQLITE_OK is returned and both *pnLog and *pnCkpt set to -1. ^If
  /// zDb is not NULL (or a zero length string) and is not the name of any
  /// attached database, SQLITE_ERROR is returned to the caller.
  ///
  /// ^Unless it returns SQLITE_MISUSE,
  /// the sqlite3_wal_checkpoint_v2() interface
  /// sets the error information that is queried by
  /// [sqlite3_errcode()] and [sqlite3_errmsg()].
  ///
  /// ^The [PRAGMA wal_checkpoint] command can be used to invoke this interface
  /// from SQL.
  int sqlite3_wal_checkpoint_v2(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zDb,
    int eMode,
    ffi.Pointer<ffi.Int> pnLog,
    ffi.Pointer<ffi.Int> pnCkpt,
  ) {
    return _sqlite3_wal_checkpoint_v2(
      db,
      zDb,
      eMode,
      pnLog,
      pnCkpt,
    );
  }

  late final _sqlite3_wal_checkpoint_v2Ptr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>>('sqlite3_wal_checkpoint_v2');
  late final _sqlite3_wal_checkpoint_v2 =
      _sqlite3_wal_checkpoint_v2Ptr.asFunction<
          int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>, int,
              ffi.Pointer<ffi.Int>, ffi.Pointer<ffi.Int>)>();

  /// CAPI3REF: Virtual Table Interface Configuration
  ///
  /// This function may be called by either the [xConnect] or [xCreate] method
  /// of a [virtual table] implementation to configure
  /// various facets of the virtual table interface.
  ///
  /// If this interface is invoked outside the context of an xConnect or
  /// xCreate virtual table method then the behavior is undefined.
  ///
  /// In the call sqlite3_vtab_config(D,C,...) the D parameter is the
  /// [database connection] in which the virtual table is being created and
  /// which is passed in as the first argument to the [xConnect] or [xCreate]
  /// method that is invoking sqlite3_vtab_config().  The C parameter is one
  /// of the [virtual table configuration options].  The presence and meaning
  /// of parameters after C depend on which [virtual table configuration option]
  /// is used.
  int sqlite3_vtab_config(
    ffi.Pointer<sqlite3> arg0,
    int op,
  ) {
    return _sqlite3_vtab_config(
      arg0,
      op,
    );
  }

  late final _sqlite3_vtab_configPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Int)>>(
      'sqlite3_vtab_config');
  late final _sqlite3_vtab_config = _sqlite3_vtab_configPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, int)>();

  /// CAPI3REF: Determine The Virtual Table Conflict Policy
  ///
  /// This function may only be called from within a call to the [xUpdate] method
  /// of a [virtual table] implementation for an INSERT or UPDATE operation. ^The
  /// value returned is one of [SQLITE_ROLLBACK], [SQLITE_IGNORE], [SQLITE_FAIL],
  /// [SQLITE_ABORT], or [SQLITE_REPLACE], according to the [ON CONFLICT] mode
  /// of the SQL statement that triggered the call to the [xUpdate] method of the
  /// [virtual table].
  int sqlite3_vtab_on_conflict(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_vtab_on_conflict(
      arg0,
    );
  }

  late final _sqlite3_vtab_on_conflictPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_vtab_on_conflict');
  late final _sqlite3_vtab_on_conflict = _sqlite3_vtab_on_conflictPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Determine If Virtual Table Column Access Is For UPDATE
  ///
  /// If the sqlite3_vtab_nochange(X) routine is called within the [xColumn]
  /// method of a [virtual table], then it returns true if and only if the
  /// column is being fetched as part of an UPDATE operation during which the
  /// column value will not change.  Applications might use this to substitute
  /// a return value that is less expensive to compute and that the corresponding
  /// [xUpdate] method understands as a "no-change" value.
  ///
  /// If the [xColumn] method calls sqlite3_vtab_nochange() and finds that
  /// the column is not changed by the UPDATE statement, then the xColumn
  /// method can optionally return without setting a result, without calling
  /// any of the [sqlite3_result_int|sqlite3_result_xxxxx() interfaces].
  /// In that case, [sqlite3_value_nochange(X)] will return true for the
  /// same column in the [xUpdate] method.
  int sqlite3_vtab_nochange(
    ffi.Pointer<sqlite3_context> arg0,
  ) {
    return _sqlite3_vtab_nochange(
      arg0,
    );
  }

  late final _sqlite3_vtab_nochangePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_context>)>>(
      'sqlite3_vtab_nochange');
  late final _sqlite3_vtab_nochange = _sqlite3_vtab_nochangePtr
      .asFunction<int Function(ffi.Pointer<sqlite3_context>)>();

  /// CAPI3REF: Determine The Collation For a Virtual Table Constraint
  ///
  /// This function may only be called from within a call to the [xBestIndex]
  /// method of a [virtual table].
  ///
  /// The first argument must be the sqlite3_index_info object that is the
  /// first parameter to the xBestIndex() method. The second argument must be
  /// an index into the aConstraint[] array belonging to the sqlite3_index_info
  /// structure passed to xBestIndex. This function returns a pointer to a buffer
  /// containing the name of the collation sequence for the corresponding
  /// constraint.
  ffi.Pointer<ffi.Char> sqlite3_vtab_collation(
    ffi.Pointer<sqlite3_index_info> arg0,
    int arg1,
  ) {
    return _sqlite3_vtab_collation(
      arg0,
      arg1,
    );
  }

  late final _sqlite3_vtab_collationPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_index_info>,
              ffi.Int)>>('sqlite3_vtab_collation');
  late final _sqlite3_vtab_collation = _sqlite3_vtab_collationPtr.asFunction<
      ffi.Pointer<ffi.Char> Function(ffi.Pointer<sqlite3_index_info>, int)>();

  /// CAPI3REF: Prepared Statement Scan Status
  /// METHOD: sqlite3_stmt
  ///
  /// This interface returns information about the predicted and measured
  /// performance for pStmt.  Advanced applications can use this
  /// interface to compare the predicted and the measured performance and
  /// issue warnings and/or rerun [ANALYZE] if discrepancies are found.
  ///
  /// Since this interface is expected to be rarely used, it is only
  /// available if SQLite is compiled using the [SQLITE_ENABLE_STMT_SCANSTATUS]
  /// compile-time option.
  ///
  /// The "iScanStatusOp" parameter determines which status information to return.
  /// The "iScanStatusOp" must be one of the [scanstatus options] or the behavior
  /// of this interface is undefined.
  /// ^The requested measurement is written into a variable pointed to by
  /// the "pOut" parameter.
  /// Parameter "idx" identifies the specific loop to retrieve statistics for.
  /// Loops are numbered starting from zero. ^If idx is out of range - less than
  /// zero or greater than or equal to the total number of loops used to implement
  /// the statement - a non-zero value is returned and the variable that pOut
  /// points to is unchanged.
  ///
  /// ^Statistics might not be available for all loops in all statements. ^In cases
  /// where there exist loops with no available statistics, this function behaves
  /// as if the loop did not exist - it returns non-zero and leave the variable
  /// that pOut points to unchanged.
  ///
  /// See also: [sqlite3_stmt_scanstatus_reset()]
  int sqlite3_stmt_scanstatus(
    ffi.Pointer<sqlite3_stmt> pStmt,
    int idx,
    int iScanStatusOp,
    ffi.Pointer<ffi.Void> pOut,
  ) {
    return _sqlite3_stmt_scanstatus(
      pStmt,
      idx,
      iScanStatusOp,
      pOut,
    );
  }

  late final _sqlite3_stmt_scanstatusPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_stmt>, ffi.Int, ffi.Int,
              ffi.Pointer<ffi.Void>)>>('sqlite3_stmt_scanstatus');
  late final _sqlite3_stmt_scanstatus = _sqlite3_stmt_scanstatusPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_stmt>, int, int, ffi.Pointer<ffi.Void>)>();

  /// CAPI3REF: Zero Scan-Status Counters
  /// METHOD: sqlite3_stmt
  ///
  /// ^Zero all [sqlite3_stmt_scanstatus()] related event counters.
  ///
  /// This API is only available if the library is built with pre-processor
  /// symbol [SQLITE_ENABLE_STMT_SCANSTATUS] defined.
  void sqlite3_stmt_scanstatus_reset(
    ffi.Pointer<sqlite3_stmt> arg0,
  ) {
    return _sqlite3_stmt_scanstatus_reset(
      arg0,
    );
  }

  late final _sqlite3_stmt_scanstatus_resetPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_stmt>)>>(
          'sqlite3_stmt_scanstatus_reset');
  late final _sqlite3_stmt_scanstatus_reset = _sqlite3_stmt_scanstatus_resetPtr
      .asFunction<void Function(ffi.Pointer<sqlite3_stmt>)>();

  /// CAPI3REF: Flush caches to disk mid-transaction
  ///
  /// ^If a write-transaction is open on [database connection] D when the
  /// [sqlite3_db_cacheflush(D)] interface invoked, any dirty
  /// pages in the pager-cache that are not currently in use are written out
  /// to disk. A dirty page may be in use if a database cursor created by an
  /// active SQL statement is reading from it, or if it is page 1 of a database
  /// file (page 1 is always "in use").  ^The [sqlite3_db_cacheflush(D)]
  /// interface flushes caches for all schemas - "main", "temp", and
  /// any [attached] databases.
  ///
  /// ^If this function needs to obtain extra database locks before dirty pages
  /// can be flushed to disk, it does so. ^If those locks cannot be obtained
  /// immediately and there is a busy-handler callback configured, it is invoked
  /// in the usual manner. ^If the required lock still cannot be obtained, then
  /// the database is skipped and an attempt made to flush any dirty pages
  /// belonging to the next (if any) database. ^If any databases are skipped
  /// because locks cannot be obtained, but no other error occurs, this
  /// function returns SQLITE_BUSY.
  ///
  /// ^If any other error occurs while flushing dirty pages to disk (for
  /// example an IO error or out-of-memory condition), then processing is
  /// abandoned and an SQLite [error code] is returned to the caller immediately.
  ///
  /// ^Otherwise, if no error occurs, [sqlite3_db_cacheflush()] returns SQLITE_OK.
  ///
  /// ^This function does not set the database handle error code or message
  /// returned by the [sqlite3_errcode()] and [sqlite3_errmsg()] functions.
  int sqlite3_db_cacheflush(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_db_cacheflush(
      arg0,
    );
  }

  late final _sqlite3_db_cacheflushPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_db_cacheflush');
  late final _sqlite3_db_cacheflush = _sqlite3_db_cacheflushPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Low-level system error code
  ///
  /// ^Attempt to return the underlying operating system error code or error
  /// number that caused the most recent I/O error or failure to open a file.
  /// The return value is OS-dependent.  For example, on unix systems, after
  /// [sqlite3_open_v2()] returns [SQLITE_CANTOPEN], this interface could be
  /// called to get back the underlying "errno" that caused the problem, such
  /// as ENOSPC, EAUTH, EISDIR, and so forth.
  int sqlite3_system_errno(
    ffi.Pointer<sqlite3> arg0,
  ) {
    return _sqlite3_system_errno(
      arg0,
    );
  }

  late final _sqlite3_system_errnoPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3>)>>(
          'sqlite3_system_errno');
  late final _sqlite3_system_errno =
      _sqlite3_system_errnoPtr.asFunction<int Function(ffi.Pointer<sqlite3>)>();

  /// CAPI3REF: Record A Database Snapshot
  /// CONSTRUCTOR: sqlite3_snapshot
  ///
  /// ^The [sqlite3_snapshot_get(D,S,P)] interface attempts to make a
  /// new [sqlite3_snapshot] object that records the current state of
  /// schema S in database connection D.  ^On success, the
  /// [sqlite3_snapshot_get(D,S,P)] interface writes a pointer to the newly
  /// created [sqlite3_snapshot] object into *P and returns SQLITE_OK.
  /// If there is not already a read-transaction open on schema S when
  /// this function is called, one is opened automatically.
  ///
  /// The following must be true for this function to succeed. If any of
  /// the following statements are false when sqlite3_snapshot_get() is
  /// called, SQLITE_ERROR is returned. The final value of *P is undefined
  /// in this case.
  ///
  /// <ul>
  /// <li> The database handle must not be in [autocommit mode].
  ///
  /// <li> Schema S of [database connection] D must be a [WAL mode] database.
  ///
  /// <li> There must not be a write transaction open on schema S of database
  /// connection D.
  ///
  /// <li> One or more transactions must have been written to the current wal
  /// file since it was created on disk (by any connection). This means
  /// that a snapshot cannot be taken on a wal mode database with no wal
  /// file immediately after it is first opened. At least one transaction
  /// must be written to it first.
  /// </ul>
  ///
  /// This function may also return SQLITE_NOMEM.  If it is called with the
  /// database handle in autocommit mode but fails for some other reason,
  /// whether or not a read transaction is opened on schema S is undefined.
  ///
  /// The [sqlite3_snapshot] object returned from a successful call to
  /// [sqlite3_snapshot_get()] must be freed using [sqlite3_snapshot_free()]
  /// to avoid a memory leak.
  ///
  /// The [sqlite3_snapshot_get()] interface is only available when the
  /// [SQLITE_ENABLE_SNAPSHOT] compile-time option is used.
  int sqlite3_snapshot_get(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zSchema,
    ffi.Pointer<ffi.Pointer<sqlite3_snapshot>> ppSnapshot,
  ) {
    return _sqlite3_snapshot_get(
      db,
      zSchema,
      ppSnapshot,
    );
  }

  late final _sqlite3_snapshot_getPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Pointer<sqlite3_snapshot>>)>>(
      'sqlite3_snapshot_get');
  late final _sqlite3_snapshot_get = _sqlite3_snapshot_getPtr.asFunction<
      int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Pointer<sqlite3_snapshot>>)>();

  /// CAPI3REF: Start a read transaction on an historical snapshot
  /// METHOD: sqlite3_snapshot
  ///
  /// ^The [sqlite3_snapshot_open(D,S,P)] interface either starts a new read
  /// transaction or upgrades an existing one for schema S of
  /// [database connection] D such that the read transaction refers to
  /// historical [snapshot] P, rather than the most recent change to the
  /// database. ^The [sqlite3_snapshot_open()] interface returns SQLITE_OK
  /// on success or an appropriate [error code] if it fails.
  ///
  /// ^In order to succeed, the database connection must not be in
  /// [autocommit mode] when [sqlite3_snapshot_open(D,S,P)] is called. If there
  /// is already a read transaction open on schema S, then the database handle
  /// must have no active statements (SELECT statements that have been passed
  /// to sqlite3_step() but not sqlite3_reset() or sqlite3_finalize()).
  /// SQLITE_ERROR is returned if either of these conditions is violated, or
  /// if schema S does not exist, or if the snapshot object is invalid.
  ///
  /// ^A call to sqlite3_snapshot_open() will fail to open if the specified
  /// snapshot has been overwritten by a [checkpoint]. In this case
  /// SQLITE_ERROR_SNAPSHOT is returned.
  ///
  /// If there is already a read transaction open when this function is
  /// invoked, then the same read transaction remains open (on the same
  /// database snapshot) if SQLITE_ERROR, SQLITE_BUSY or SQLITE_ERROR_SNAPSHOT
  /// is returned. If another error code - for example SQLITE_PROTOCOL or an
  /// SQLITE_IOERR error code - is returned, then the final state of the
  /// read transaction is undefined. If SQLITE_OK is returned, then the
  /// read transaction is now open on database snapshot P.
  ///
  /// ^(A call to [sqlite3_snapshot_open(D,S,P)] will fail if the
  /// database connection D does not know that the database file for
  /// schema S is in [WAL mode].  A database connection might not know
  /// that the database file is in [WAL mode] if there has been no prior
  /// I/O on that database connection, or if the database entered [WAL mode]
  /// after the most recent I/O on the database connection.)^
  /// (Hint: Run "[PRAGMA application_id]" against a newly opened
  /// database connection in order to make it ready to use snapshots.)
  ///
  /// The [sqlite3_snapshot_open()] interface is only available when the
  /// [SQLITE_ENABLE_SNAPSHOT] compile-time option is used.
  int sqlite3_snapshot_open(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zSchema,
    ffi.Pointer<sqlite3_snapshot> pSnapshot,
  ) {
    return _sqlite3_snapshot_open(
      db,
      zSchema,
      pSnapshot,
    );
  }

  late final _sqlite3_snapshot_openPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<sqlite3_snapshot>)>>('sqlite3_snapshot_open');
  late final _sqlite3_snapshot_open = _sqlite3_snapshot_openPtr.asFunction<
      int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>,
          ffi.Pointer<sqlite3_snapshot>)>();

  /// CAPI3REF: Destroy a snapshot
  /// DESTRUCTOR: sqlite3_snapshot
  ///
  /// ^The [sqlite3_snapshot_free(P)] interface destroys [sqlite3_snapshot] P.
  /// The application must eventually free every [sqlite3_snapshot] object
  /// using this routine to avoid a memory leak.
  ///
  /// The [sqlite3_snapshot_free()] interface is only available when the
  /// [SQLITE_ENABLE_SNAPSHOT] compile-time option is used.
  void sqlite3_snapshot_free(
    ffi.Pointer<sqlite3_snapshot> arg0,
  ) {
    return _sqlite3_snapshot_free(
      arg0,
    );
  }

  late final _sqlite3_snapshot_freePtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_snapshot>)>>(
      'sqlite3_snapshot_free');
  late final _sqlite3_snapshot_free = _sqlite3_snapshot_freePtr
      .asFunction<void Function(ffi.Pointer<sqlite3_snapshot>)>();

  /// CAPI3REF: Compare the ages of two snapshot handles.
  /// METHOD: sqlite3_snapshot
  ///
  /// The sqlite3_snapshot_cmp(P1, P2) interface is used to compare the ages
  /// of two valid snapshot handles.
  ///
  /// If the two snapshot handles are not associated with the same database
  /// file, the result of the comparison is undefined.
  ///
  /// Additionally, the result of the comparison is only valid if both of the
  /// snapshot handles were obtained by calling sqlite3_snapshot_get() since the
  /// last time the wal file was deleted. The wal file is deleted when the
  /// database is changed back to rollback mode or when the number of database
  /// clients drops to zero. If either snapshot handle was obtained before the
  /// wal file was last deleted, the value returned by this function
  /// is undefined.
  ///
  /// Otherwise, this API returns a negative value if P1 refers to an older
  /// snapshot than P2, zero if the two handles refer to the same database
  /// snapshot, and a positive value if P1 is a newer snapshot than P2.
  ///
  /// This interface is only available if SQLite is compiled with the
  /// [SQLITE_ENABLE_SNAPSHOT] option.
  int sqlite3_snapshot_cmp(
    ffi.Pointer<sqlite3_snapshot> p1,
    ffi.Pointer<sqlite3_snapshot> p2,
  ) {
    return _sqlite3_snapshot_cmp(
      p1,
      p2,
    );
  }

  late final _sqlite3_snapshot_cmpPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_snapshot>,
              ffi.Pointer<sqlite3_snapshot>)>>('sqlite3_snapshot_cmp');
  late final _sqlite3_snapshot_cmp = _sqlite3_snapshot_cmpPtr.asFunction<
      int Function(
          ffi.Pointer<sqlite3_snapshot>, ffi.Pointer<sqlite3_snapshot>)>();

  /// CAPI3REF: Recover snapshots from a wal file
  /// METHOD: sqlite3_snapshot
  ///
  /// If a [WAL file] remains on disk after all database connections close
  /// (either through the use of the [SQLITE_FCNTL_PERSIST_WAL] [file control]
  /// or because the last process to have the database opened exited without
  /// calling [sqlite3_close()]) and a new connection is subsequently opened
  /// on that database and [WAL file], the [sqlite3_snapshot_open()] interface
  /// will only be able to open the last transaction added to the WAL file
  /// even though the WAL file contains other valid transactions.
  ///
  /// This function attempts to scan the WAL file associated with database zDb
  /// of database handle db and make all valid snapshots available to
  /// sqlite3_snapshot_open(). It is an error if there is already a read
  /// transaction open on the database, or if the database is not a WAL mode
  /// database.
  ///
  /// SQLITE_OK is returned if successful, or an SQLite error code otherwise.
  ///
  /// This interface is only available if SQLite is compiled with the
  /// [SQLITE_ENABLE_SNAPSHOT] option.
  int sqlite3_snapshot_recover(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zDb,
  ) {
    return _sqlite3_snapshot_recover(
      db,
      zDb,
    );
  }

  late final _sqlite3_snapshot_recoverPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>)>>('sqlite3_snapshot_recover');
  late final _sqlite3_snapshot_recover = _sqlite3_snapshot_recoverPtr
      .asFunction<int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>)>();

  /// CAPI3REF: Serialize a database
  ///
  /// The sqlite3_serialize(D,S,P,F) interface returns a pointer to memory
  /// that is a serialization of the S database on [database connection] D.
  /// If P is not a NULL pointer, then the size of the database in bytes
  /// is written into *P.
  ///
  /// For an ordinary on-disk database file, the serialization is just a
  /// copy of the disk file.  For an in-memory database or a "TEMP" database,
  /// the serialization is the same sequence of bytes which would be written
  /// to disk if that database where backed up to disk.
  ///
  /// The usual case is that sqlite3_serialize() copies the serialization of
  /// the database into memory obtained from [sqlite3_malloc64()] and returns
  /// a pointer to that memory.  The caller is responsible for freeing the
  /// returned value to avoid a memory leak.  However, if the F argument
  /// contains the SQLITE_SERIALIZE_NOCOPY bit, then no memory allocations
  /// are made, and the sqlite3_serialize() function will return a pointer
  /// to the contiguous memory representation of the database that SQLite
  /// is currently using for that database, or NULL if the no such contiguous
  /// memory representation of the database exists.  A contiguous memory
  /// representation of the database will usually only exist if there has
  /// been a prior call to [sqlite3_deserialize(D,S,...)] with the same
  /// values of D and S.
  /// The size of the database is written into *P even if the
  /// SQLITE_SERIALIZE_NOCOPY bit is set but no contiguous copy
  /// of the database exists.
  ///
  /// A call to sqlite3_serialize(D,S,P,F) might return NULL even if the
  /// SQLITE_SERIALIZE_NOCOPY bit is omitted from argument F if a memory
  /// allocation error occurs.
  ///
  /// This interface is only available if SQLite is compiled with the
  /// [SQLITE_ENABLE_DESERIALIZE] option.
  ffi.Pointer<ffi.UnsignedChar> sqlite3_serialize(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zSchema,
    ffi.Pointer<sqlite3_int64> piSize,
    int mFlags,
  ) {
    return _sqlite3_serialize(
      db,
      zSchema,
      piSize,
      mFlags,
    );
  }

  late final _sqlite3_serializePtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<sqlite3_int64>,
              ffi.UnsignedInt)>>('sqlite3_serialize');
  late final _sqlite3_serialize = _sqlite3_serializePtr.asFunction<
      ffi.Pointer<ffi.UnsignedChar> Function(ffi.Pointer<sqlite3>,
          ffi.Pointer<ffi.Char>, ffi.Pointer<sqlite3_int64>, int)>();

  /// CAPI3REF: Deserialize a database
  ///
  /// The sqlite3_deserialize(D,S,P,N,M,F) interface causes the
  /// [database connection] D to disconnect from database S and then
  /// reopen S as an in-memory database based on the serialization contained
  /// in P.  The serialized database P is N bytes in size.  M is the size of
  /// the buffer P, which might be larger than N.  If M is larger than N, and
  /// the SQLITE_DESERIALIZE_READONLY bit is not set in F, then SQLite is
  /// permitted to add content to the in-memory database as long as the total
  /// size does not exceed M bytes.
  ///
  /// If the SQLITE_DESERIALIZE_FREEONCLOSE bit is set in F, then SQLite will
  /// invoke sqlite3_free() on the serialization buffer when the database
  /// connection closes.  If the SQLITE_DESERIALIZE_RESIZEABLE bit is set, then
  /// SQLite will try to increase the buffer size using sqlite3_realloc64()
  /// if writes on the database cause it to grow larger than M bytes.
  ///
  /// The sqlite3_deserialize() interface will fail with SQLITE_BUSY if the
  /// database is currently in a read transaction or is involved in a backup
  /// operation.
  ///
  /// If sqlite3_deserialize(D,S,P,N,M,F) fails for any reason and if the
  /// SQLITE_DESERIALIZE_FREEONCLOSE bit is set in argument F, then
  /// [sqlite3_free()] is invoked on argument P prior to returning.
  ///
  /// This interface is only available if SQLite is compiled with the
  /// [SQLITE_ENABLE_DESERIALIZE] option.
  int sqlite3_deserialize(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zSchema,
    ffi.Pointer<ffi.UnsignedChar> pData,
    int szDb,
    int szBuf,
    int mFlags,
  ) {
    return _sqlite3_deserialize(
      db,
      zSchema,
      pData,
      szDb,
      szBuf,
      mFlags,
    );
  }

  late final _sqlite3_deserializePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              sqlite3_int64,
              sqlite3_int64,
              ffi.UnsignedInt)>>('sqlite3_deserialize');
  late final _sqlite3_deserialize = _sqlite3_deserializePtr.asFunction<
      int Function(ffi.Pointer<sqlite3>, ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.UnsignedChar>, int, int, int)>();

  /// Register a geometry callback named zGeom that can be used as part of an
  /// R-Tree geometry query as follows:
  ///
  /// SELECT ... FROM <rtree> WHERE <rtree col> MATCH $zGeom(... params ...)
  int sqlite3_rtree_geometry_callback(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zGeom,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(ffi.Pointer<sqlite3_rtree_geometry>, ffi.Int,
                    ffi.Pointer<sqlite3_rtree_dbl>, ffi.Pointer<ffi.Int>)>>
        xGeom,
    ffi.Pointer<ffi.Void> pContext,
  ) {
    return _sqlite3_rtree_geometry_callback(
      db,
      zGeom,
      xGeom,
      pContext,
    );
  }

  late final _sqlite3_rtree_geometry_callbackPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<sqlite3_rtree_geometry>,
                          ffi.Int,
                          ffi.Pointer<sqlite3_rtree_dbl>,
                          ffi.Pointer<ffi.Int>)>>,
              ffi.Pointer<ffi.Void>)>>('sqlite3_rtree_geometry_callback');
  late final _sqlite3_rtree_geometry_callback =
      _sqlite3_rtree_geometry_callbackPtr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<sqlite3_rtree_geometry>,
                          ffi.Int,
                          ffi.Pointer<sqlite3_rtree_dbl>,
                          ffi.Pointer<ffi.Int>)>>,
              ffi.Pointer<ffi.Void>)>();

  /// Register a 2nd-generation geometry callback named zScore that can be
  /// used as part of an R-Tree geometry query as follows:
  ///
  /// SELECT ... FROM <rtree> WHERE <rtree col> MATCH $zQueryFunc(... params ...)
  int sqlite3_rtree_query_callback(
    ffi.Pointer<sqlite3> db,
    ffi.Pointer<ffi.Char> zQueryFunc,
    ffi.Pointer<
            ffi.NativeFunction<
                ffi.Int Function(ffi.Pointer<sqlite3_rtree_query_info>)>>
        xQueryFunc,
    ffi.Pointer<ffi.Void> pContext,
    ffi.Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
        xDestructor,
  ) {
    return _sqlite3_rtree_query_callback(
      db,
      zQueryFunc,
      xQueryFunc,
      pContext,
      xDestructor,
    );
  }

  late final _sqlite3_rtree_query_callbackPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3>,
                  ffi.Pointer<ffi.Char>,
                  ffi
                      .Pointer<
                          ffi.NativeFunction<
                              ffi.Int Function(
                                  ffi.Pointer<sqlite3_rtree_query_info>)>>,
                  ffi.Pointer<ffi.Void>,
                  ffi.Pointer<
                      ffi.NativeFunction<
                          ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>>(
      'sqlite3_rtree_query_callback');
  late final _sqlite3_rtree_query_callback =
      _sqlite3_rtree_query_callbackPtr.asFunction<
          int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(ffi.Pointer<sqlite3_rtree_query_info>)>>,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>();
}

final class sqlite3 extends ffi.Opaque {}

typedef sqlite_int64 = ffi.LongLong;
typedef Dartsqlite_int64 = int;
typedef sqlite_uint64 = ffi.UnsignedLongLong;
typedef Dartsqlite_uint64 = int;
typedef sqlite3_int64 = sqlite_int64;
typedef sqlite3_uint64 = sqlite_uint64;
typedef sqlite3_callbackFunction = ffi.Int Function(
    ffi.Pointer<ffi.Void>,
    ffi.Int,
    ffi.Pointer<ffi.Pointer<ffi.Char>>,
    ffi.Pointer<ffi.Pointer<ffi.Char>>);
typedef Dartsqlite3_callbackFunction = int Function(ffi.Pointer<ffi.Void>, int,
    ffi.Pointer<ffi.Pointer<ffi.Char>>, ffi.Pointer<ffi.Pointer<ffi.Char>>);

/// The type for a callback function.
/// This is legacy and deprecated.  It is included for historical
/// compatibility and is not documented.
typedef sqlite3_callback
    = ffi.Pointer<ffi.NativeFunction<sqlite3_callbackFunction>>;

final class sqlite3_io_methods extends ffi.Opaque {}

final class sqlite3_file extends ffi.Struct {
  /// Methods for an open file
  external ffi.Pointer<sqlite3_io_methods> pMethods;
}

final class sqlite3_mutex extends ffi.Opaque {}

final class sqlite3_api_routines extends ffi.Opaque {}

typedef sqlite3_syscall_ptrFunction = ffi.Void Function();
typedef Dartsqlite3_syscall_ptrFunction = void Function();
typedef sqlite3_syscall_ptr
    = ffi.Pointer<ffi.NativeFunction<sqlite3_syscall_ptrFunction>>;

final class sqlite3_vfs extends ffi.Struct {
  /// Structure version number (currently 3)
  @ffi.Int()
  external int iVersion;

  /// Size of subclassed sqlite3_file
  @ffi.Int()
  external int szOsFile;

  /// Maximum file pathname length
  @ffi.Int()
  external int mxPathname;

  /// Next registered VFS
  external ffi.Pointer<sqlite3_vfs> pNext;

  /// Name of this virtual file system
  external ffi.Pointer<ffi.Char> zName;

  /// Pointer to application-specific data
  external ffi.Pointer<ffi.Void> pAppData;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<sqlite3_file>, ffi.Int, ffi.Pointer<ffi.Int>)>> xOpen;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Char>, ffi.Int)>>
      xDelete;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Char>,
              ffi.Int, ffi.Pointer<ffi.Int>)>> xAccess;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Char>,
              ffi.Int, ffi.Pointer<ffi.Char>)>> xFullPathname;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Char>)>> xDlOpen;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Void Function(
                  ffi.Pointer<sqlite3_vfs>, ffi.Int, ffi.Pointer<ffi.Char>)>>
      xDlError;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.NativeFunction<ffi.Void Function()>> Function(
              ffi.Pointer<sqlite3_vfs>,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<ffi.Char>)>> xDlSym;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Void>)>> xDlClose;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3_vfs>, ffi.Int, ffi.Pointer<ffi.Char>)>>
      xRandomness;

  external ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vfs>, ffi.Int)>>
      xSleep;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Double>)>> xCurrentTime;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3_vfs>, ffi.Int, ffi.Pointer<ffi.Char>)>>
      xGetLastError;

  /// The methods above are in version 1 of the sqlite_vfs object
  /// definition.  Those that follow are added in version 2 or later
  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3_vfs>, ffi.Pointer<sqlite3_int64>)>>
      xCurrentTimeInt64;

  /// The methods above are in versions 1 and 2 of the sqlite_vfs object.
  /// Those below are for version 3 and greater.
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Char>,
              sqlite3_syscall_ptr)>> xSetSystemCall;

  external ffi.Pointer<
      ffi.NativeFunction<
          sqlite3_syscall_ptr Function(
              ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Char>)>> xGetSystemCall;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Pointer<ffi.Char> Function(
                  ffi.Pointer<sqlite3_vfs>, ffi.Pointer<ffi.Char>)>>
      xNextSystemCall;
}

final class sqlite3_mem_methods extends ffi.Struct {
  /// Memory allocation function
  external ffi
      .Pointer<ffi.NativeFunction<ffi.Pointer<ffi.Void> Function(ffi.Int)>>
      xMalloc;

  /// Free a prior allocation
  external ffi
      .Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
      xFree;

  /// Resize an allocation
  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Pointer<ffi.Void> Function(ffi.Pointer<ffi.Void>, ffi.Int)>>
      xRealloc;

  /// Return the size of an allocation
  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>
      xSize;

  /// Round up request size to allocation size
  external ffi.Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Int)>> xRoundup;

  /// Initialize the memory allocator
  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>
      xInit;

  /// Deinitialize the memory allocator
  external ffi
      .Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
      xShutdown;

  /// Argument to xInit() and xShutdown()
  external ffi.Pointer<ffi.Void> pAppData;
}

final class sqlite3_stmt extends ffi.Opaque {}

final class sqlite3_value extends ffi.Opaque {}

final class sqlite3_context extends ffi.Opaque {}

typedef sqlite3_destructor_typeFunction = ffi.Void Function(
    ffi.Pointer<ffi.Void>);
typedef Dartsqlite3_destructor_typeFunction = void Function(
    ffi.Pointer<ffi.Void>);

/// CAPI3REF: Constants Defining Special Destructor Behavior
///
/// These are special values for the destructor that is passed in as the
/// final argument to routines like [sqlite3_result_blob()].  ^If the destructor
/// argument is SQLITE_STATIC, it means that the content pointer is constant
/// and will never change.  It does not need to be destroyed.  ^The
/// SQLITE_TRANSIENT value means that the content will likely change in
/// the near future and that SQLite should make its own private copy of
/// the content before returning.
///
/// The typedef is necessary to work around problems in certain
/// C++ compilers.
typedef sqlite3_destructor_type
    = ffi.Pointer<ffi.NativeFunction<sqlite3_destructor_typeFunction>>;

final class sqlite3_index_constraint extends ffi.Struct {
  /// Column constrained.  -1 for ROWID
  @ffi.Int()
  external int iColumn;

  /// Constraint operator
  @ffi.UnsignedChar()
  external int op;

  /// True if this constraint is usable
  @ffi.UnsignedChar()
  external int usable;

  /// Used internally - xBestIndex should ignore
  @ffi.Int()
  external int iTermOffset;
}

final class sqlite3_index_orderby extends ffi.Struct {
  /// Column number
  @ffi.Int()
  external int iColumn;

  /// True for DESC.  False for ASC.
  @ffi.UnsignedChar()
  external int desc;
}

/// Outputs
final class sqlite3_index_constraint_usage extends ffi.Struct {
  /// if >0, constraint is part of argv to xFilter
  @ffi.Int()
  external int argvIndex;

  /// Do not code a test for this constraint
  @ffi.UnsignedChar()
  external int omit;
}

/// CAPI3REF: Virtual Table Indexing Information
/// KEYWORDS: sqlite3_index_info
///
/// The sqlite3_index_info structure and its substructures is used as part
/// of the [virtual table] interface to
/// pass information into and receive the reply from the [xBestIndex]
/// method of a [virtual table module].  The fields under **Inputs** are the
/// inputs to xBestIndex and are read-only.  xBestIndex inserts its
/// results into the **Outputs** fields.
///
/// ^(The aConstraint[] array records WHERE clause constraints of the form:
///
/// <blockquote>column OP expr</blockquote>
///
/// where OP is =, &lt;, &lt;=, &gt;, or &gt;=.)^  ^(The particular operator is
/// stored in aConstraint[].op using one of the
/// [SQLITE_INDEX_CONSTRAINT_EQ | SQLITE_INDEX_CONSTRAINT_ values].)^
/// ^(The index of the column is stored in
/// aConstraint[].iColumn.)^  ^(aConstraint[].usable is TRUE if the
/// expr on the right-hand side can be evaluated (and thus the constraint
/// is usable) and false if it cannot.)^
///
/// ^The optimizer automatically inverts terms of the form "expr OP column"
/// and makes other simplifications to the WHERE clause in an attempt to
/// get as many WHERE clause terms into the form shown above as possible.
/// ^The aConstraint[] array only reports WHERE clause terms that are
/// relevant to the particular virtual table being queried.
///
/// ^Information about the ORDER BY clause is stored in aOrderBy[].
/// ^Each term of aOrderBy records a column of the ORDER BY clause.
///
/// The colUsed field indicates which columns of the virtual table may be
/// required by the current scan. Virtual table columns are numbered from
/// zero in the order in which they appear within the CREATE TABLE statement
/// passed to sqlite3_declare_vtab(). For the first 63 columns (columns 0-62),
/// the corresponding bit is set within the colUsed mask if the column may be
/// required by SQLite. If the table has at least 64 columns and any column
/// to the right of the first 63 is required, then bit 63 of colUsed is also
/// set. In other words, column iCol may be required if the expression
/// (colUsed & ((sqlite3_uint64)1 << (iCol>=63 ? 63 : iCol))) evaluates to
/// non-zero.
///
/// The [xBestIndex] method must fill aConstraintUsage[] with information
/// about what parameters to pass to xFilter.  ^If argvIndex>0 then
/// the right-hand side of the corresponding aConstraint[] is evaluated
/// and becomes the argvIndex-th entry in argv.  ^(If aConstraintUsage[].omit
/// is true, then the constraint is assumed to be fully handled by the
/// virtual table and might not be checked again by the byte code.)^ ^(The
/// aConstraintUsage[].omit flag is an optimization hint. When the omit flag
/// is left in its default setting of false, the constraint will always be
/// checked separately in byte code.  If the omit flag is change to true, then
/// the constraint may or may not be checked in byte code.  In other words,
/// when the omit flag is true there is no guarantee that the constraint will
/// not be checked again using byte code.)^
///
/// ^The idxNum and idxPtr values are recorded and passed into the
/// [xFilter] method.
/// ^[sqlite3_free()] is used to free idxPtr if and only if
/// needToFreeIdxPtr is true.
///
/// ^The orderByConsumed means that output from [xFilter]/[xNext] will occur in
/// the correct order to satisfy the ORDER BY clause so that no separate
/// sorting step is required.
///
/// ^The estimatedCost value is an estimate of the cost of a particular
/// strategy. A cost of N indicates that the cost of the strategy is similar
/// to a linear scan of an SQLite table with N rows. A cost of log(N)
/// indicates that the expense of the operation is similar to that of a
/// binary search on a unique indexed field of an SQLite table with N rows.
///
/// ^The estimatedRows value is an estimate of the number of rows that
/// will be returned by the strategy.
///
/// The xBestIndex method may optionally populate the idxFlags field with a
/// mask of SQLITE_INDEX_SCAN_* flags. Currently there is only one such flag -
/// SQLITE_INDEX_SCAN_UNIQUE. If the xBestIndex method sets this flag, SQLite
/// assumes that the strategy may visit at most one row.
///
/// Additionally, if xBestIndex sets the SQLITE_INDEX_SCAN_UNIQUE flag, then
/// SQLite also assumes that if a call to the xUpdate() method is made as
/// part of the same statement to delete or update a virtual table row and the
/// implementation returns SQLITE_CONSTRAINT, then there is no need to rollback
/// any database changes. In other words, if the xUpdate() returns
/// SQLITE_CONSTRAINT, the database contents must be exactly as they were
/// before xUpdate was called. By contrast, if SQLITE_INDEX_SCAN_UNIQUE is not
/// set and xUpdate returns SQLITE_CONSTRAINT, any database changes made by
/// the xUpdate method are automatically rolled back by SQLite.
///
/// IMPORTANT: The estimatedRows field was added to the sqlite3_index_info
/// structure for SQLite [version 3.8.2] ([dateof:3.8.2]).
/// If a virtual table extension is
/// used with an SQLite version earlier than 3.8.2, the results of attempting
/// to read or write the estimatedRows field are undefined (but are likely
/// to include crashing the application). The estimatedRows field should
/// therefore only be used if [sqlite3_libversion_number()] returns a
/// value greater than or equal to 3008002. Similarly, the idxFlags field
/// was added for [version 3.9.0] ([dateof:3.9.0]).
/// It may therefore only be used if
/// sqlite3_libversion_number() returns a value greater than or equal to
/// 3009000.
final class sqlite3_index_info extends ffi.Struct {
  /// Number of entries in aConstraint
  @ffi.Int()
  external int nConstraint;

  /// Table of WHERE clause constraints
  external ffi.Pointer<sqlite3_index_constraint> aConstraint;

  /// Number of terms in the ORDER BY clause
  @ffi.Int()
  external int nOrderBy;

  /// The ORDER BY clause
  external ffi.Pointer<sqlite3_index_orderby> aOrderBy;

  external ffi.Pointer<sqlite3_index_constraint_usage> aConstraintUsage;

  /// Number used to identify the index
  @ffi.Int()
  external int idxNum;

  /// String, possibly obtained from sqlite3_malloc
  external ffi.Pointer<ffi.Char> idxStr;

  /// Free idxStr using sqlite3_free() if true
  @ffi.Int()
  external int needToFreeIdxStr;

  /// True if output is already ordered
  @ffi.Int()
  external int orderByConsumed;

  /// Estimated cost of using this index
  @ffi.Double()
  external double estimatedCost;

  /// Estimated number of rows returned
  @sqlite3_int64()
  external int estimatedRows;

  /// Mask of SQLITE_INDEX_SCAN_* flags
  @ffi.Int()
  external int idxFlags;

  /// Input: Mask of columns used by statement
  @sqlite3_uint64()
  external int colUsed;
}

/// CAPI3REF: Virtual Table Cursor Object
/// KEYWORDS: sqlite3_vtab_cursor {virtual table cursor}
///
/// Every [virtual table module] implementation uses a subclass of the
/// following structure to describe cursors that point into the
/// [virtual table] and are used
/// to loop through the virtual table.  Cursors are created using the
/// [sqlite3_module.xOpen | xOpen] method of the module and are destroyed
/// by the [sqlite3_module.xClose | xClose] method.  Cursors are used
/// by the [xFilter], [xNext], [xEof], [xColumn], and [xRowid] methods
/// of the module.  Each module implementation will define
/// the content of a cursor structure to suit its own needs.
///
/// This superclass exists in order to define fields of the cursor that
/// are common to all implementations.
final class sqlite3_vtab_cursor extends ffi.Struct {
  /// Virtual table of this cursor
  external ffi.Pointer<sqlite3_vtab> pVtab;
}

/// CAPI3REF: Virtual Table Object
/// KEYWORDS: sqlite3_module {virtual table module}
///
/// This structure, sometimes called a "virtual table module",
/// defines the implementation of a [virtual table].
/// This structure consists mostly of methods for the module.
///
/// ^A virtual table module is created by filling in a persistent
/// instance of this structure and passing a pointer to that instance
/// to [sqlite3_create_module()] or [sqlite3_create_module_v2()].
/// ^The registration remains valid until it is replaced by a different
/// module or until the [database connection] closes.  The content
/// of this structure must not change while it is registered with
/// any database connection.
final class sqlite3_module extends ffi.Struct {
  @ffi.Int()
  external int iVersion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Pointer<sqlite3_vtab>>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>> xCreate;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3>,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Pointer<sqlite3_vtab>>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>> xConnect;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3_vtab>, ffi.Pointer<sqlite3_index_info>)>>
      xBestIndex;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab> pVTab)>>
      xDisconnect;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab> pVTab)>>
      xDestroy;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_vtab> pVTab,
              ffi.Pointer<ffi.Pointer<sqlite3_vtab_cursor>> ppCursor)>> xOpen;

  external ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab_cursor>)>>
      xClose;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_vtab_cursor>,
              ffi.Int,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<sqlite3_value>>)>> xFilter;

  external ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab_cursor>)>>
      xNext;

  external ffi.Pointer<
      ffi
      .NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab_cursor>)>> xEof;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_vtab_cursor>,
              ffi.Pointer<sqlite3_context>, ffi.Int)>> xColumn;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<sqlite3_vtab_cursor>,
              ffi.Pointer<sqlite3_int64>)>> xRowid;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_vtab>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<sqlite3_value>>,
              ffi.Pointer<sqlite3_int64>)>> xUpdate;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab> pVTab)>>
      xBegin;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab> pVTab)>>
      xSync;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab> pVTab)>>
      xCommit;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab> pVTab)>>
      xRollback;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<sqlite3_vtab> pVtab,
              ffi.Int nArg,
              ffi.Pointer<ffi.Char> zName,
              ffi.Pointer<
                      ffi.Pointer<
                          ffi.NativeFunction<
                              ffi.Void Function(
                                  ffi.Pointer<sqlite3_context>,
                                  ffi.Int,
                                  ffi.Pointer<ffi.Pointer<sqlite3_value>>)>>>
                  pxFunc,
              ffi.Pointer<ffi.Pointer<ffi.Void>> ppArg)>> xFindFunction;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<sqlite3_vtab> pVtab, ffi.Pointer<ffi.Char> zNew)>>
      xRename;

  /// The methods above are in version 1 of the sqlite_module object. Those
  /// below are for version 2 and greater.
  external ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab>, ffi.Int)>>
      xSavepoint;

  external ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab>, ffi.Int)>>
      xRelease;

  external ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_vtab>, ffi.Int)>>
      xRollbackTo;

  /// The methods above are in versions 1 and 2 of the sqlite_module object.
  /// Those below are for version 3 and greater.
  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Char>)>>
      xShadowName;
}

/// CAPI3REF: Virtual Table Instance Object
/// KEYWORDS: sqlite3_vtab
///
/// Every [virtual table module] implementation uses a subclass
/// of this object to describe a particular instance
/// of the [virtual table].  Each subclass will
/// be tailored to the specific needs of the module implementation.
/// The purpose of this superclass is to define certain fields that are
/// common to all module implementations.
///
/// ^Virtual tables methods can set an error message by assigning a
/// string obtained from [sqlite3_mprintf()] to zErrMsg.  The method should
/// take care that any prior string is freed by a call to [sqlite3_free()]
/// prior to assigning a new string to zErrMsg.  ^After the error message
/// is delivered up to the client application, the string will be automatically
/// freed by sqlite3_free() and the zErrMsg field will be zeroed.
final class sqlite3_vtab extends ffi.Struct {
  /// The module for this virtual table
  external ffi.Pointer<sqlite3_module> pModule;

  /// Number of open cursors
  @ffi.Int()
  external int nRef;

  /// Error message from sqlite3_mprintf()
  external ffi.Pointer<ffi.Char> zErrMsg;
}

final class sqlite3_blob extends ffi.Opaque {}

final class sqlite3_mutex_methods extends ffi.Struct {
  external ffi.Pointer<ffi.NativeFunction<ffi.Int Function()>> xMutexInit;

  external ffi.Pointer<ffi.NativeFunction<ffi.Int Function()>> xMutexEnd;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Pointer<sqlite3_mutex> Function(ffi.Int)>>
      xMutexAlloc;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_mutex>)>>
      xMutexFree;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_mutex>)>>
      xMutexEnter;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_mutex>)>>
      xMutexTry;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_mutex>)>>
      xMutexLeave;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_mutex>)>>
      xMutexHeld;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_mutex>)>>
      xMutexNotheld;
}

final class sqlite3_str extends ffi.Opaque {}

final class sqlite3_pcache extends ffi.Opaque {}

final class sqlite3_pcache_page extends ffi.Struct {
  /// The content of the page
  external ffi.Pointer<ffi.Void> pBuf;

  /// Extra information associated with the page
  external ffi.Pointer<ffi.Void> pExtra;
}

final class sqlite3_pcache_methods2 extends ffi.Struct {
  @ffi.Int()
  external int iVersion;

  external ffi.Pointer<ffi.Void> pArg;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>
      xInit;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
      xShutdown;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_pcache> Function(
              ffi.Int szPage, ffi.Int szExtra, ffi.Int bPurgeable)>> xCreate;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_pcache>, ffi.Int)>> xCachesize;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_pcache>)>>
      xPagecount;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_pcache_page> Function(
              ffi.Pointer<sqlite3_pcache>, ffi.UnsignedInt, ffi.Int)>> xFetch;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_pcache>,
              ffi.Pointer<sqlite3_pcache_page>, ffi.Int)>> xUnpin;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<sqlite3_pcache>,
              ffi.Pointer<sqlite3_pcache_page>,
              ffi.UnsignedInt,
              ffi.UnsignedInt)>> xRekey;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<sqlite3_pcache>, ffi.UnsignedInt)>>
      xTruncate;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_pcache>)>>
      xDestroy;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_pcache>)>>
      xShrink;
}

final class sqlite3_pcache_methods extends ffi.Struct {
  external ffi.Pointer<ffi.Void> pArg;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Void>)>>
      xInit;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
      xShutdown;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<sqlite3_pcache> Function(
              ffi.Int szPage, ffi.Int bPurgeable)>> xCreate;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_pcache>, ffi.Int)>> xCachesize;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<sqlite3_pcache>)>>
      xPagecount;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<sqlite3_pcache>, ffi.UnsignedInt, ffi.Int)>> xFetch;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Void Function(
                  ffi.Pointer<sqlite3_pcache>, ffi.Pointer<ffi.Void>, ffi.Int)>>
      xUnpin;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<sqlite3_pcache>, ffi.Pointer<ffi.Void>,
              ffi.UnsignedInt, ffi.UnsignedInt)>> xRekey;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<sqlite3_pcache>, ffi.UnsignedInt)>>
      xTruncate;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<sqlite3_pcache>)>>
      xDestroy;
}

final class sqlite3_backup extends ffi.Opaque {}

/// CAPI3REF: Database Snapshot
/// KEYWORDS: {snapshot} {sqlite3_snapshot}
///
/// An instance of the snapshot object records the state of a [WAL mode]
/// database for some specific point in history.
///
/// In [WAL mode], multiple [database connections] that are open on the
/// same database file can each be reading a different historical version
/// of the database file.  When a [database connection] begins a read
/// transaction, that connection sees an unchanging copy of the database
/// as it existed for the point in time when the transaction first started.
/// Subsequent changes to the database from other connections are not seen
/// by the reader until a new read transaction is started.
///
/// The sqlite3_snapshot object records state information about an historical
/// version of the database file so that it is possible to later open a new read
/// transaction that sees that historical version of the database rather than
/// the most recent version.
final class sqlite3_snapshot extends ffi.Struct {
  @ffi.Array.multi([48])
  external ffi.Array<ffi.UnsignedChar> hidden;
}

typedef sqlite3_rtree_dbl = ffi.Double;
typedef Dartsqlite3_rtree_dbl = double;

/// A pointer to a structure of the following type is passed as the first
/// argument to callbacks registered using rtree_geometry_callback().
final class sqlite3_rtree_geometry extends ffi.Struct {
  /// Copy of pContext passed to s_r_g_c()
  external ffi.Pointer<ffi.Void> pContext;

  /// Size of array aParam[]
  @ffi.Int()
  external int nParam;

  /// Parameters passed to SQL geom function
  external ffi.Pointer<sqlite3_rtree_dbl> aParam;

  /// Callback implementation user data
  external ffi.Pointer<ffi.Void> pUser;

  /// Called by SQLite to clean up pUser
  external ffi
      .Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
      xDelUser;
}

/// A pointer to a structure of the following type is passed as the
/// argument to scored geometry callback registered using
/// sqlite3_rtree_query_callback().
///
/// Note that the first 5 fields of this structure are identical to
/// sqlite3_rtree_geometry.  This structure is a subclass of
/// sqlite3_rtree_geometry.
final class sqlite3_rtree_query_info extends ffi.Struct {
  /// pContext from when function registered
  external ffi.Pointer<ffi.Void> pContext;

  /// Number of function parameters
  @ffi.Int()
  external int nParam;

  /// value of function parameters
  external ffi.Pointer<sqlite3_rtree_dbl> aParam;

  /// callback can use this, if desired
  external ffi.Pointer<ffi.Void> pUser;

  /// function to free pUser
  external ffi
      .Pointer<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
      xDelUser;

  /// Coordinates of node or entry to check
  external ffi.Pointer<sqlite3_rtree_dbl> aCoord;

  /// Number of pending entries in the queue
  external ffi.Pointer<ffi.UnsignedInt> anQueue;

  /// Number of coordinates
  @ffi.Int()
  external int nCoord;

  /// Level of current node or entry
  @ffi.Int()
  external int iLevel;

  /// The largest iLevel value in the tree
  @ffi.Int()
  external int mxLevel;

  /// Rowid for current entry
  @sqlite3_int64()
  external int iRowid;

  /// Score of parent node
  @sqlite3_rtree_dbl()
  external double rParentScore;

  /// Visibility of parent node
  @ffi.Int()
  external int eParentWithin;

  /// OUT: Visibility
  @ffi.Int()
  external int eWithin;

  /// OUT: Write the score here
  @sqlite3_rtree_dbl()
  external double rScore;

  /// Original SQL values of parameters
  external ffi.Pointer<ffi.Pointer<sqlite3_value>> apSqlParam;
}

final class Fts5Context extends ffi.Opaque {}

final class Fts5PhraseIter extends ffi.Struct {
  external ffi.Pointer<ffi.UnsignedChar> a;

  external ffi.Pointer<ffi.UnsignedChar> b;
}

/// EXTENSION API FUNCTIONS
///
/// xUserData(pFts):
/// Return a copy of the context pointer the extension function was
/// registered with.
///
/// xColumnTotalSize(pFts, iCol, pnToken):
/// If parameter iCol is less than zero, set output variable *pnToken
/// to the total number of tokens in the FTS5 table. Or, if iCol is
/// non-negative but less than the number of columns in the table, return
/// the total number of tokens in column iCol, considering all rows in
/// the FTS5 table.
///
/// If parameter iCol is greater than or equal to the number of columns
/// in the table, SQLITE_RANGE is returned. Or, if an error occurs (e.g.
/// an OOM condition or IO error), an appropriate SQLite error code is
/// returned.
///
/// xColumnCount(pFts):
/// Return the number of columns in the table.
///
/// xColumnSize(pFts, iCol, pnToken):
/// If parameter iCol is less than zero, set output variable *pnToken
/// to the total number of tokens in the current row. Or, if iCol is
/// non-negative but less than the number of columns in the table, set
/// *pnToken to the number of tokens in column iCol of the current row.
///
/// If parameter iCol is greater than or equal to the number of columns
/// in the table, SQLITE_RANGE is returned. Or, if an error occurs (e.g.
/// an OOM condition or IO error), an appropriate SQLite error code is
/// returned.
///
/// This function may be quite inefficient if used with an FTS5 table
/// created with the "columnsize=0" option.
///
/// xColumnText:
/// This function attempts to retrieve the text of column iCol of the
/// current document. If successful, (*pz) is set to point to a buffer
/// containing the text in utf-8 encoding, (*pn) is set to the size in bytes
/// (not characters) of the buffer and SQLITE_OK is returned. Otherwise,
/// if an error occurs, an SQLite error code is returned and the final values
/// of (*pz) and (*pn) are undefined.
///
/// xPhraseCount:
/// Returns the number of phrases in the current query expression.
///
/// xPhraseSize:
/// Returns the number of tokens in phrase iPhrase of the query. Phrases
/// are numbered starting from zero.
///
/// xInstCount:
/// Set *pnInst to the total number of occurrences of all phrases within
/// the query within the current row. Return SQLITE_OK if successful, or
/// an error code (i.e. SQLITE_NOMEM) if an error occurs.
///
/// This API can be quite slow if used with an FTS5 table created with the
/// "detail=none" or "detail=column" option. If the FTS5 table is created
/// with either "detail=none" or "detail=column" and "content=" option
/// (i.e. if it is a contentless table), then this API always returns 0.
///
/// xInst:
/// Query for the details of phrase match iIdx within the current row.
/// Phrase matches are numbered starting from zero, so the iIdx argument
/// should be greater than or equal to zero and smaller than the value
/// output by xInstCount().
///
/// Usually, output parameter *piPhrase is set to the phrase number, *piCol
/// to the column in which it occurs and *piOff the token offset of the
/// first token of the phrase. Returns SQLITE_OK if successful, or an error
/// code (i.e. SQLITE_NOMEM) if an error occurs.
///
/// This API can be quite slow if used with an FTS5 table created with the
/// "detail=none" or "detail=column" option.
///
/// xRowid:
/// Returns the rowid of the current row.
///
/// xTokenize:
/// Tokenize text using the tokenizer belonging to the FTS5 table.
///
/// xQueryPhrase(pFts5, iPhrase, pUserData, xCallback):
/// This API function is used to query the FTS table for phrase iPhrase
/// of the current query. Specifically, a query equivalent to:
///
/// ... FROM ftstable WHERE ftstable MATCH $p ORDER BY rowid
///
/// with $p set to a phrase equivalent to the phrase iPhrase of the
/// current query is executed. Any column filter that applies to
/// phrase iPhrase of the current query is included in $p. For each
/// row visited, the callback function passed as the fourth argument
/// is invoked. The context and API objects passed to the callback
/// function may be used to access the properties of each matched row.
/// Invoking Api.xUserData() returns a copy of the pointer passed as
/// the third argument to pUserData.
///
/// If the callback function returns any value other than SQLITE_OK, the
/// query is abandoned and the xQueryPhrase function returns immediately.
/// If the returned value is SQLITE_DONE, xQueryPhrase returns SQLITE_OK.
/// Otherwise, the error code is propagated upwards.
///
/// If the query runs to completion without incident, SQLITE_OK is returned.
/// Or, if some error occurs before the query completes or is aborted by
/// the callback, an SQLite error code is returned.
///
///
/// xSetAuxdata(pFts5, pAux, xDelete)
///
/// Save the pointer passed as the second argument as the extension function's
/// "auxiliary data". The pointer may then be retrieved by the current or any
/// future invocation of the same fts5 extension function made as part of
/// the same MATCH query using the xGetAuxdata() API.
///
/// Each extension function is allocated a single auxiliary data slot for
/// each FTS query (MATCH expression). If the extension function is invoked
/// more than once for a single FTS query, then all invocations share a
/// single auxiliary data context.
///
/// If there is already an auxiliary data pointer when this function is
/// invoked, then it is replaced by the new pointer. If an xDelete callback
/// was specified along with the original pointer, it is invoked at this
/// point.
///
/// The xDelete callback, if one is specified, is also invoked on the
/// auxiliary data pointer after the FTS5 query has finished.
///
/// If an error (e.g. an OOM condition) occurs within this function,
/// the auxiliary data is set to NULL and an error code returned. If the
/// xDelete parameter was not NULL, it is invoked on the auxiliary data
/// pointer before returning.
///
///
/// xGetAuxdata(pFts5, bClear)
///
/// Returns the current auxiliary data pointer for the fts5 extension
/// function. See the xSetAuxdata() method for details.
///
/// If the bClear argument is non-zero, then the auxiliary data is cleared
/// (set to NULL) before this function returns. In this case the xDelete,
/// if any, is not invoked.
///
///
/// xRowCount(pFts5, pnRow)
///
/// This function is used to retrieve the total number of rows in the table.
/// In other words, the same value that would be returned by:
///
/// SELECT count(*) FROM ftstable;
///
/// xPhraseFirst()
/// This function is used, along with type Fts5PhraseIter and the xPhraseNext
/// method, to iterate through all instances of a single query phrase within
/// the current row. This is the same information as is accessible via the
/// xInstCount/xInst APIs. While the xInstCount/xInst APIs are more convenient
/// to use, this API may be faster under some circumstances. To iterate
/// through instances of phrase iPhrase, use the following code:
///
/// Fts5PhraseIter iter;
/// int iCol, iOff;
/// for(pApi->xPhraseFirst(pFts, iPhrase, &iter, &iCol, &iOff);
/// iCol>=0;
/// pApi->xPhraseNext(pFts, &iter, &iCol, &iOff)
/// ){
/// // An instance of phrase iPhrase at offset iOff of column iCol
/// }
///
/// The Fts5PhraseIter structure is defined above. Applications should not
/// modify this structure directly - it should only be used as shown above
/// with the xPhraseFirst() and xPhraseNext() API methods (and by
/// xPhraseFirstColumn() and xPhraseNextColumn() as illustrated below).
///
/// This API can be quite slow if used with an FTS5 table created with the
/// "detail=none" or "detail=column" option. If the FTS5 table is created
/// with either "detail=none" or "detail=column" and "content=" option
/// (i.e. if it is a contentless table), then this API always iterates
/// through an empty set (all calls to xPhraseFirst() set iCol to -1).
///
/// xPhraseNext()
/// See xPhraseFirst above.
///
/// xPhraseFirstColumn()
/// This function and xPhraseNextColumn() are similar to the xPhraseFirst()
/// and xPhraseNext() APIs described above. The difference is that instead
/// of iterating through all instances of a phrase in the current row, these
/// APIs are used to iterate through the set of columns in the current row
/// that contain one or more instances of a specified phrase. For example:
///
/// Fts5PhraseIter iter;
/// int iCol;
/// for(pApi->xPhraseFirstColumn(pFts, iPhrase, &iter, &iCol);
/// iCol>=0;
/// pApi->xPhraseNextColumn(pFts, &iter, &iCol)
/// ){
/// // Column iCol contains at least one instance of phrase iPhrase
/// }
///
/// This API can be quite slow if used with an FTS5 table created with the
/// "detail=none" option. If the FTS5 table is created with either
/// "detail=none" "content=" option (i.e. if it is a contentless table),
/// then this API always iterates through an empty set (all calls to
/// xPhraseFirstColumn() set iCol to -1).
///
/// The information accessed using this API and its companion
/// xPhraseFirstColumn() may also be obtained using xPhraseFirst/xPhraseNext
/// (or xInst/xInstCount). The chief advantage of this API is that it is
/// significantly more efficient than those alternatives when used with
/// "detail=column" tables.
///
/// xPhraseNextColumn()
/// See xPhraseFirstColumn above.
final class Fts5ExtensionApi extends ffi.Struct {
  /// Currently always set to 3
  @ffi.Int()
  external int iVersion;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(ffi.Pointer<Fts5Context>)>> xUserData;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<Fts5Context>)>>
      xColumnCount;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Context>, ffi.Pointer<sqlite3_int64>)>> xRowCount;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<Fts5Context>, ffi.Int,
              ffi.Pointer<sqlite3_int64>)>> xColumnTotalSize;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Context>,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Char>,
                          ffi.Int,
                          ffi.Int,
                          ffi.Int)>>)>> xTokenize;

  external ffi
      .Pointer<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<Fts5Context>)>>
      xPhraseCount;

  external ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<Fts5Context>, ffi.Int)>>
      xPhraseSize;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<Fts5Context>, ffi.Pointer<ffi.Int>)>>
      xInstCount;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Context>,
              ffi.Int,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>> xInst;

  external ffi.Pointer<
          ffi.NativeFunction<sqlite3_int64 Function(ffi.Pointer<Fts5Context>)>>
      xRowid;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Context>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Int>)>> xColumnText;

  external ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<Fts5Context>, ffi.Int, ffi.Pointer<ffi.Int>)>>
      xColumnSize;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Context>,
              ffi.Int,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<Fts5ExtensionApi>,
                          ffi.Pointer<Fts5Context>,
                          ffi.Pointer<ffi.Void>)>>)>> xQueryPhrase;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Context>,
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Pointer<ffi.Void>)>>)>> xSetAuxdata;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Pointer<ffi.Void> Function(
              ffi.Pointer<Fts5Context>, ffi.Int)>> xGetAuxdata;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Context>,
              ffi.Int,
              ffi.Pointer<Fts5PhraseIter>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>> xPhraseFirst;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<Fts5Context>,
              ffi.Pointer<Fts5PhraseIter>,
              ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Int>)>> xPhraseNext;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Context>,
              ffi.Int,
              ffi.Pointer<Fts5PhraseIter>,
              ffi.Pointer<ffi.Int>)>> xPhraseFirstColumn;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<Fts5Context>,
              ffi.Pointer<Fts5PhraseIter>,
              ffi.Pointer<ffi.Int>)>> xPhraseNextColumn;
}

typedef fts5_extension_functionFunction = ffi.Void Function(
    ffi.Pointer<Fts5ExtensionApi> pApi,
    ffi.Pointer<Fts5Context> pFts,
    ffi.Pointer<sqlite3_context> pCtx,
    ffi.Int nVal,
    ffi.Pointer<ffi.Pointer<sqlite3_value>> apVal);
typedef Dartfts5_extension_functionFunction = void Function(
    ffi.Pointer<Fts5ExtensionApi> pApi,
    ffi.Pointer<Fts5Context> pFts,
    ffi.Pointer<sqlite3_context> pCtx,
    int nVal,
    ffi.Pointer<ffi.Pointer<sqlite3_value>> apVal);
typedef fts5_extension_function
    = ffi.Pointer<ffi.NativeFunction<fts5_extension_functionFunction>>;

final class Fts5Tokenizer extends ffi.Opaque {}

final class fts5_tokenizer extends ffi.Struct {
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Void>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Int,
              ffi.Pointer<ffi.Pointer<Fts5Tokenizer>>)>> xCreate;

  external ffi.Pointer<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<Fts5Tokenizer>)>>
      xDelete;

  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<Fts5Tokenizer>,
              ffi.Pointer<ffi.Void>,
              ffi.Int,
              ffi.Pointer<ffi.Char>,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Int Function(
                          ffi.Pointer<ffi.Void>,
                          ffi.Int,
                          ffi.Pointer<ffi.Char>,
                          ffi.Int,
                          ffi.Int,
                          ffi.Int)>>)>> xTokenize;
}

final class fts5_api extends ffi.Struct {
  /// Currently always set to 2
  @ffi.Int()
  external int iVersion;

  /// Create a new tokenizer
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<fts5_api> pApi,
              ffi.Pointer<ffi.Char> zName,
              ffi.Pointer<ffi.Void> pContext,
              ffi.Pointer<fts5_tokenizer> pTokenizer,
              ffi.Pointer<
                      ffi
                      .NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
                  xDestroy)>> xCreateTokenizer;

  /// Find an existing tokenizer
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<fts5_api> pApi,
              ffi.Pointer<ffi.Char> zName,
              ffi.Pointer<ffi.Pointer<ffi.Void>> ppContext,
              ffi.Pointer<fts5_tokenizer> pTokenizer)>> xFindTokenizer;

  /// Create a new auxiliary function
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<fts5_api> pApi,
              ffi.Pointer<ffi.Char> zName,
              ffi.Pointer<ffi.Void> pContext,
              fts5_extension_function xFunction,
              ffi.Pointer<
                      ffi
                      .NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>
                  xDestroy)>> xCreateFunction;
}

const String SQLITE_VERSION = '3.32.3';

const int SQLITE_VERSION_NUMBER = 3032003;

const String SQLITE_SOURCE_ID =
    '2020-06-18 14:00:33 7ebdfa80be8e8e73324b8d66b3460222eb74c7e9dfd655b48d6ca7e1933cc8fd';

const int SQLITE_OK = 0;

const int SQLITE_ERROR = 1;

const int SQLITE_INTERNAL = 2;

const int SQLITE_PERM = 3;

const int SQLITE_ABORT = 4;

const int SQLITE_BUSY = 5;

const int SQLITE_LOCKED = 6;

const int SQLITE_NOMEM = 7;

const int SQLITE_READONLY = 8;

const int SQLITE_INTERRUPT = 9;

const int SQLITE_IOERR = 10;

const int SQLITE_CORRUPT = 11;

const int SQLITE_NOTFOUND = 12;

const int SQLITE_FULL = 13;

const int SQLITE_CANTOPEN = 14;

const int SQLITE_PROTOCOL = 15;

const int SQLITE_EMPTY = 16;

const int SQLITE_SCHEMA = 17;

const int SQLITE_TOOBIG = 18;

const int SQLITE_CONSTRAINT = 19;

const int SQLITE_MISMATCH = 20;

const int SQLITE_MISUSE = 21;

const int SQLITE_NOLFS = 22;

const int SQLITE_AUTH = 23;

const int SQLITE_FORMAT = 24;

const int SQLITE_RANGE = 25;

const int SQLITE_NOTADB = 26;

const int SQLITE_NOTICE = 27;

const int SQLITE_WARNING = 28;

const int SQLITE_ROW = 100;

const int SQLITE_DONE = 101;

const int SQLITE_ERROR_MISSING_COLLSEQ = 257;

const int SQLITE_ERROR_RETRY = 513;

const int SQLITE_ERROR_SNAPSHOT = 769;

const int SQLITE_IOERR_READ = 266;

const int SQLITE_IOERR_SHORT_READ = 522;

const int SQLITE_IOERR_WRITE = 778;

const int SQLITE_IOERR_FSYNC = 1034;

const int SQLITE_IOERR_DIR_FSYNC = 1290;

const int SQLITE_IOERR_TRUNCATE = 1546;

const int SQLITE_IOERR_FSTAT = 1802;

const int SQLITE_IOERR_UNLOCK = 2058;

const int SQLITE_IOERR_RDLOCK = 2314;

const int SQLITE_IOERR_DELETE = 2570;

const int SQLITE_IOERR_BLOCKED = 2826;

const int SQLITE_IOERR_NOMEM = 3082;

const int SQLITE_IOERR_ACCESS = 3338;

const int SQLITE_IOERR_CHECKRESERVEDLOCK = 3594;

const int SQLITE_IOERR_LOCK = 3850;

const int SQLITE_IOERR_CLOSE = 4106;

const int SQLITE_IOERR_DIR_CLOSE = 4362;

const int SQLITE_IOERR_SHMOPEN = 4618;

const int SQLITE_IOERR_SHMSIZE = 4874;

const int SQLITE_IOERR_SHMLOCK = 5130;

const int SQLITE_IOERR_SHMMAP = 5386;

const int SQLITE_IOERR_SEEK = 5642;

const int SQLITE_IOERR_DELETE_NOENT = 5898;

const int SQLITE_IOERR_MMAP = 6154;

const int SQLITE_IOERR_GETTEMPPATH = 6410;

const int SQLITE_IOERR_CONVPATH = 6666;

const int SQLITE_IOERR_VNODE = 6922;

const int SQLITE_IOERR_AUTH = 7178;

const int SQLITE_IOERR_BEGIN_ATOMIC = 7434;

const int SQLITE_IOERR_COMMIT_ATOMIC = 7690;

const int SQLITE_IOERR_ROLLBACK_ATOMIC = 7946;

const int SQLITE_IOERR_DATA = 8202;

const int SQLITE_LOCKED_SHAREDCACHE = 262;

const int SQLITE_LOCKED_VTAB = 518;

const int SQLITE_BUSY_RECOVERY = 261;

const int SQLITE_BUSY_SNAPSHOT = 517;

const int SQLITE_BUSY_TIMEOUT = 773;

const int SQLITE_CANTOPEN_NOTEMPDIR = 270;

const int SQLITE_CANTOPEN_ISDIR = 526;

const int SQLITE_CANTOPEN_FULLPATH = 782;

const int SQLITE_CANTOPEN_CONVPATH = 1038;

const int SQLITE_CANTOPEN_DIRTYWAL = 1294;

const int SQLITE_CANTOPEN_SYMLINK = 1550;

const int SQLITE_CORRUPT_VTAB = 267;

const int SQLITE_CORRUPT_SEQUENCE = 523;

const int SQLITE_CORRUPT_INDEX = 779;

const int SQLITE_READONLY_RECOVERY = 264;

const int SQLITE_READONLY_CANTLOCK = 520;

const int SQLITE_READONLY_ROLLBACK = 776;

const int SQLITE_READONLY_DBMOVED = 1032;

const int SQLITE_READONLY_CANTINIT = 1288;

const int SQLITE_READONLY_DIRECTORY = 1544;

const int SQLITE_ABORT_ROLLBACK = 516;

const int SQLITE_CONSTRAINT_CHECK = 275;

const int SQLITE_CONSTRAINT_COMMITHOOK = 531;

const int SQLITE_CONSTRAINT_FOREIGNKEY = 787;

const int SQLITE_CONSTRAINT_FUNCTION = 1043;

const int SQLITE_CONSTRAINT_NOTNULL = 1299;

const int SQLITE_CONSTRAINT_PRIMARYKEY = 1555;

const int SQLITE_CONSTRAINT_TRIGGER = 1811;

const int SQLITE_CONSTRAINT_UNIQUE = 2067;

const int SQLITE_CONSTRAINT_VTAB = 2323;

const int SQLITE_CONSTRAINT_ROWID = 2579;

const int SQLITE_CONSTRAINT_PINNED = 2835;

const int SQLITE_NOTICE_RECOVER_WAL = 283;

const int SQLITE_NOTICE_RECOVER_ROLLBACK = 539;

const int SQLITE_WARNING_AUTOINDEX = 284;

const int SQLITE_AUTH_USER = 279;

const int SQLITE_OK_LOAD_PERMANENTLY = 256;

const int SQLITE_OK_SYMLINK = 512;

const int SQLITE_OPEN_READONLY = 1;

const int SQLITE_OPEN_READWRITE = 2;

const int SQLITE_OPEN_CREATE = 4;

const int SQLITE_OPEN_DELETEONCLOSE = 8;

const int SQLITE_OPEN_EXCLUSIVE = 16;

const int SQLITE_OPEN_AUTOPROXY = 32;

const int SQLITE_OPEN_URI = 64;

const int SQLITE_OPEN_MEMORY = 128;

const int SQLITE_OPEN_MAIN_DB = 256;

const int SQLITE_OPEN_TEMP_DB = 512;

const int SQLITE_OPEN_TRANSIENT_DB = 1024;

const int SQLITE_OPEN_MAIN_JOURNAL = 2048;

const int SQLITE_OPEN_TEMP_JOURNAL = 4096;

const int SQLITE_OPEN_SUBJOURNAL = 8192;

const int SQLITE_OPEN_MASTER_JOURNAL = 16384;

const int SQLITE_OPEN_NOMUTEX = 32768;

const int SQLITE_OPEN_FULLMUTEX = 65536;

const int SQLITE_OPEN_SHAREDCACHE = 131072;

const int SQLITE_OPEN_PRIVATECACHE = 262144;

const int SQLITE_OPEN_WAL = 524288;

const int SQLITE_OPEN_NOFOLLOW = 16777216;

const int SQLITE_IOCAP_ATOMIC = 1;

const int SQLITE_IOCAP_ATOMIC512 = 2;

const int SQLITE_IOCAP_ATOMIC1K = 4;

const int SQLITE_IOCAP_ATOMIC2K = 8;

const int SQLITE_IOCAP_ATOMIC4K = 16;

const int SQLITE_IOCAP_ATOMIC8K = 32;

const int SQLITE_IOCAP_ATOMIC16K = 64;

const int SQLITE_IOCAP_ATOMIC32K = 128;

const int SQLITE_IOCAP_ATOMIC64K = 256;

const int SQLITE_IOCAP_SAFE_APPEND = 512;

const int SQLITE_IOCAP_SEQUENTIAL = 1024;

const int SQLITE_IOCAP_UNDELETABLE_WHEN_OPEN = 2048;

const int SQLITE_IOCAP_POWERSAFE_OVERWRITE = 4096;

const int SQLITE_IOCAP_IMMUTABLE = 8192;

const int SQLITE_IOCAP_BATCH_ATOMIC = 16384;

const int SQLITE_LOCK_NONE = 0;

const int SQLITE_LOCK_SHARED = 1;

const int SQLITE_LOCK_RESERVED = 2;

const int SQLITE_LOCK_PENDING = 3;

const int SQLITE_LOCK_EXCLUSIVE = 4;

const int SQLITE_SYNC_NORMAL = 2;

const int SQLITE_SYNC_FULL = 3;

const int SQLITE_SYNC_DATAONLY = 16;

const int SQLITE_FCNTL_LOCKSTATE = 1;

const int SQLITE_FCNTL_GET_LOCKPROXYFILE = 2;

const int SQLITE_FCNTL_SET_LOCKPROXYFILE = 3;

const int SQLITE_FCNTL_LAST_ERRNO = 4;

const int SQLITE_FCNTL_SIZE_HINT = 5;

const int SQLITE_FCNTL_CHUNK_SIZE = 6;

const int SQLITE_FCNTL_FILE_POINTER = 7;

const int SQLITE_FCNTL_SYNC_OMITTED = 8;

const int SQLITE_FCNTL_WIN32_AV_RETRY = 9;

const int SQLITE_FCNTL_PERSIST_WAL = 10;

const int SQLITE_FCNTL_OVERWRITE = 11;

const int SQLITE_FCNTL_VFSNAME = 12;

const int SQLITE_FCNTL_POWERSAFE_OVERWRITE = 13;

const int SQLITE_FCNTL_PRAGMA = 14;

const int SQLITE_FCNTL_BUSYHANDLER = 15;

const int SQLITE_FCNTL_TEMPFILENAME = 16;

const int SQLITE_FCNTL_MMAP_SIZE = 18;

const int SQLITE_FCNTL_TRACE = 19;

const int SQLITE_FCNTL_HAS_MOVED = 20;

const int SQLITE_FCNTL_SYNC = 21;

const int SQLITE_FCNTL_COMMIT_PHASETWO = 22;

const int SQLITE_FCNTL_WIN32_SET_HANDLE = 23;

const int SQLITE_FCNTL_WAL_BLOCK = 24;

const int SQLITE_FCNTL_ZIPVFS = 25;

const int SQLITE_FCNTL_RBU = 26;

const int SQLITE_FCNTL_VFS_POINTER = 27;

const int SQLITE_FCNTL_JOURNAL_POINTER = 28;

const int SQLITE_FCNTL_WIN32_GET_HANDLE = 29;

const int SQLITE_FCNTL_PDB = 30;

const int SQLITE_FCNTL_BEGIN_ATOMIC_WRITE = 31;

const int SQLITE_FCNTL_COMMIT_ATOMIC_WRITE = 32;

const int SQLITE_FCNTL_ROLLBACK_ATOMIC_WRITE = 33;

const int SQLITE_FCNTL_LOCK_TIMEOUT = 34;

const int SQLITE_FCNTL_DATA_VERSION = 35;

const int SQLITE_FCNTL_SIZE_LIMIT = 36;

const int SQLITE_FCNTL_CKPT_DONE = 37;

const int SQLITE_FCNTL_RESERVE_BYTES = 38;

const int SQLITE_FCNTL_CKPT_START = 39;

const int SQLITE_GET_LOCKPROXYFILE = 2;

const int SQLITE_SET_LOCKPROXYFILE = 3;

const int SQLITE_LAST_ERRNO = 4;

const int SQLITE_ACCESS_EXISTS = 0;

const int SQLITE_ACCESS_READWRITE = 1;

const int SQLITE_ACCESS_READ = 2;

const int SQLITE_SHM_UNLOCK = 1;

const int SQLITE_SHM_LOCK = 2;

const int SQLITE_SHM_SHARED = 4;

const int SQLITE_SHM_EXCLUSIVE = 8;

const int SQLITE_SHM_NLOCK = 8;

const int SQLITE_CONFIG_SINGLETHREAD = 1;

const int SQLITE_CONFIG_MULTITHREAD = 2;

const int SQLITE_CONFIG_SERIALIZED = 3;

const int SQLITE_CONFIG_MALLOC = 4;

const int SQLITE_CONFIG_GETMALLOC = 5;

const int SQLITE_CONFIG_SCRATCH = 6;

const int SQLITE_CONFIG_PAGECACHE = 7;

const int SQLITE_CONFIG_HEAP = 8;

const int SQLITE_CONFIG_MEMSTATUS = 9;

const int SQLITE_CONFIG_MUTEX = 10;

const int SQLITE_CONFIG_GETMUTEX = 11;

const int SQLITE_CONFIG_LOOKASIDE = 13;

const int SQLITE_CONFIG_PCACHE = 14;

const int SQLITE_CONFIG_GETPCACHE = 15;

const int SQLITE_CONFIG_LOG = 16;

const int SQLITE_CONFIG_URI = 17;

const int SQLITE_CONFIG_PCACHE2 = 18;

const int SQLITE_CONFIG_GETPCACHE2 = 19;

const int SQLITE_CONFIG_COVERING_INDEX_SCAN = 20;

const int SQLITE_CONFIG_SQLLOG = 21;

const int SQLITE_CONFIG_MMAP_SIZE = 22;

const int SQLITE_CONFIG_WIN32_HEAPSIZE = 23;

const int SQLITE_CONFIG_PCACHE_HDRSZ = 24;

const int SQLITE_CONFIG_PMASZ = 25;

const int SQLITE_CONFIG_STMTJRNL_SPILL = 26;

const int SQLITE_CONFIG_SMALL_MALLOC = 27;

const int SQLITE_CONFIG_SORTERREF_SIZE = 28;

const int SQLITE_CONFIG_MEMDB_MAXSIZE = 29;

const int SQLITE_DBCONFIG_MAINDBNAME = 1000;

const int SQLITE_DBCONFIG_LOOKASIDE = 1001;

const int SQLITE_DBCONFIG_ENABLE_FKEY = 1002;

const int SQLITE_DBCONFIG_ENABLE_TRIGGER = 1003;

const int SQLITE_DBCONFIG_ENABLE_FTS3_TOKENIZER = 1004;

const int SQLITE_DBCONFIG_ENABLE_LOAD_EXTENSION = 1005;

const int SQLITE_DBCONFIG_NO_CKPT_ON_CLOSE = 1006;

const int SQLITE_DBCONFIG_ENABLE_QPSG = 1007;

const int SQLITE_DBCONFIG_TRIGGER_EQP = 1008;

const int SQLITE_DBCONFIG_RESET_DATABASE = 1009;

const int SQLITE_DBCONFIG_DEFENSIVE = 1010;

const int SQLITE_DBCONFIG_WRITABLE_SCHEMA = 1011;

const int SQLITE_DBCONFIG_LEGACY_ALTER_TABLE = 1012;

const int SQLITE_DBCONFIG_DQS_DML = 1013;

const int SQLITE_DBCONFIG_DQS_DDL = 1014;

const int SQLITE_DBCONFIG_ENABLE_VIEW = 1015;

const int SQLITE_DBCONFIG_LEGACY_FILE_FORMAT = 1016;

const int SQLITE_DBCONFIG_TRUSTED_SCHEMA = 1017;

const int SQLITE_DBCONFIG_MAX = 1017;

const int SQLITE_DENY = 1;

const int SQLITE_IGNORE = 2;

const int SQLITE_CREATE_INDEX = 1;

const int SQLITE_CREATE_TABLE = 2;

const int SQLITE_CREATE_TEMP_INDEX = 3;

const int SQLITE_CREATE_TEMP_TABLE = 4;

const int SQLITE_CREATE_TEMP_TRIGGER = 5;

const int SQLITE_CREATE_TEMP_VIEW = 6;

const int SQLITE_CREATE_TRIGGER = 7;

const int SQLITE_CREATE_VIEW = 8;

const int SQLITE_DELETE = 9;

const int SQLITE_DROP_INDEX = 10;

const int SQLITE_DROP_TABLE = 11;

const int SQLITE_DROP_TEMP_INDEX = 12;

const int SQLITE_DROP_TEMP_TABLE = 13;

const int SQLITE_DROP_TEMP_TRIGGER = 14;

const int SQLITE_DROP_TEMP_VIEW = 15;

const int SQLITE_DROP_TRIGGER = 16;

const int SQLITE_DROP_VIEW = 17;

const int SQLITE_INSERT = 18;

const int SQLITE_PRAGMA = 19;

const int SQLITE_READ = 20;

const int SQLITE_SELECT = 21;

const int SQLITE_TRANSACTION = 22;

const int SQLITE_UPDATE = 23;

const int SQLITE_ATTACH = 24;

const int SQLITE_DETACH = 25;

const int SQLITE_ALTER_TABLE = 26;

const int SQLITE_REINDEX = 27;

const int SQLITE_ANALYZE = 28;

const int SQLITE_CREATE_VTABLE = 29;

const int SQLITE_DROP_VTABLE = 30;

const int SQLITE_FUNCTION = 31;

const int SQLITE_SAVEPOINT = 32;

const int SQLITE_COPY = 0;

const int SQLITE_RECURSIVE = 33;

const int SQLITE_TRACE_STMT = 1;

const int SQLITE_TRACE_PROFILE = 2;

const int SQLITE_TRACE_ROW = 4;

const int SQLITE_TRACE_CLOSE = 8;

const int SQLITE_LIMIT_LENGTH = 0;

const int SQLITE_LIMIT_SQL_LENGTH = 1;

const int SQLITE_LIMIT_COLUMN = 2;

const int SQLITE_LIMIT_EXPR_DEPTH = 3;

const int SQLITE_LIMIT_COMPOUND_SELECT = 4;

const int SQLITE_LIMIT_VDBE_OP = 5;

const int SQLITE_LIMIT_FUNCTION_ARG = 6;

const int SQLITE_LIMIT_ATTACHED = 7;

const int SQLITE_LIMIT_LIKE_PATTERN_LENGTH = 8;

const int SQLITE_LIMIT_VARIABLE_NUMBER = 9;

const int SQLITE_LIMIT_TRIGGER_DEPTH = 10;

const int SQLITE_LIMIT_WORKER_THREADS = 11;

const int SQLITE_PREPARE_PERSISTENT = 1;

const int SQLITE_PREPARE_NORMALIZE = 2;

const int SQLITE_PREPARE_NO_VTAB = 4;

const int SQLITE_INTEGER = 1;

const int SQLITE_FLOAT = 2;

const int SQLITE_BLOB = 4;

const int SQLITE_NULL = 5;

const int SQLITE_TEXT = 3;

const int SQLITE3_TEXT = 3;

const int SQLITE_UTF8 = 1;

const int SQLITE_UTF16LE = 2;

const int SQLITE_UTF16BE = 3;

const int SQLITE_UTF16 = 4;

const int SQLITE_ANY = 5;

const int SQLITE_UTF16_ALIGNED = 8;

const int SQLITE_DETERMINISTIC = 2048;

const int SQLITE_DIRECTONLY = 524288;

const int SQLITE_SUBTYPE = 1048576;

const int SQLITE_INNOCUOUS = 2097152;

const int SQLITE_WIN32_DATA_DIRECTORY_TYPE = 1;

const int SQLITE_WIN32_TEMP_DIRECTORY_TYPE = 2;

const int SQLITE_INDEX_SCAN_UNIQUE = 1;

const int SQLITE_INDEX_CONSTRAINT_EQ = 2;

const int SQLITE_INDEX_CONSTRAINT_GT = 4;

const int SQLITE_INDEX_CONSTRAINT_LE = 8;

const int SQLITE_INDEX_CONSTRAINT_LT = 16;

const int SQLITE_INDEX_CONSTRAINT_GE = 32;

const int SQLITE_INDEX_CONSTRAINT_MATCH = 64;

const int SQLITE_INDEX_CONSTRAINT_LIKE = 65;

const int SQLITE_INDEX_CONSTRAINT_GLOB = 66;

const int SQLITE_INDEX_CONSTRAINT_REGEXP = 67;

const int SQLITE_INDEX_CONSTRAINT_NE = 68;

const int SQLITE_INDEX_CONSTRAINT_ISNOT = 69;

const int SQLITE_INDEX_CONSTRAINT_ISNOTNULL = 70;

const int SQLITE_INDEX_CONSTRAINT_ISNULL = 71;

const int SQLITE_INDEX_CONSTRAINT_IS = 72;

const int SQLITE_INDEX_CONSTRAINT_FUNCTION = 150;

const int SQLITE_MUTEX_FAST = 0;

const int SQLITE_MUTEX_RECURSIVE = 1;

const int SQLITE_MUTEX_STATIC_MASTER = 2;

const int SQLITE_MUTEX_STATIC_MEM = 3;

const int SQLITE_MUTEX_STATIC_MEM2 = 4;

const int SQLITE_MUTEX_STATIC_OPEN = 4;

const int SQLITE_MUTEX_STATIC_PRNG = 5;

const int SQLITE_MUTEX_STATIC_LRU = 6;

const int SQLITE_MUTEX_STATIC_LRU2 = 7;

const int SQLITE_MUTEX_STATIC_PMEM = 7;

const int SQLITE_MUTEX_STATIC_APP1 = 8;

const int SQLITE_MUTEX_STATIC_APP2 = 9;

const int SQLITE_MUTEX_STATIC_APP3 = 10;

const int SQLITE_MUTEX_STATIC_VFS1 = 11;

const int SQLITE_MUTEX_STATIC_VFS2 = 12;

const int SQLITE_MUTEX_STATIC_VFS3 = 13;

const int SQLITE_TESTCTRL_FIRST = 5;

const int SQLITE_TESTCTRL_PRNG_SAVE = 5;

const int SQLITE_TESTCTRL_PRNG_RESTORE = 6;

const int SQLITE_TESTCTRL_PRNG_RESET = 7;

const int SQLITE_TESTCTRL_BITVEC_TEST = 8;

const int SQLITE_TESTCTRL_FAULT_INSTALL = 9;

const int SQLITE_TESTCTRL_BENIGN_MALLOC_HOOKS = 10;

const int SQLITE_TESTCTRL_PENDING_BYTE = 11;

const int SQLITE_TESTCTRL_ASSERT = 12;

const int SQLITE_TESTCTRL_ALWAYS = 13;

const int SQLITE_TESTCTRL_RESERVE = 14;

const int SQLITE_TESTCTRL_OPTIMIZATIONS = 15;

const int SQLITE_TESTCTRL_ISKEYWORD = 16;

const int SQLITE_TESTCTRL_SCRATCHMALLOC = 17;

const int SQLITE_TESTCTRL_INTERNAL_FUNCTIONS = 17;

const int SQLITE_TESTCTRL_LOCALTIME_FAULT = 18;

const int SQLITE_TESTCTRL_EXPLAIN_STMT = 19;

const int SQLITE_TESTCTRL_ONCE_RESET_THRESHOLD = 19;

const int SQLITE_TESTCTRL_NEVER_CORRUPT = 20;

const int SQLITE_TESTCTRL_VDBE_COVERAGE = 21;

const int SQLITE_TESTCTRL_BYTEORDER = 22;

const int SQLITE_TESTCTRL_ISINIT = 23;

const int SQLITE_TESTCTRL_SORTER_MMAP = 24;

const int SQLITE_TESTCTRL_IMPOSTER = 25;

const int SQLITE_TESTCTRL_PARSER_COVERAGE = 26;

const int SQLITE_TESTCTRL_RESULT_INTREAL = 27;

const int SQLITE_TESTCTRL_PRNG_SEED = 28;

const int SQLITE_TESTCTRL_EXTRA_SCHEMA_CHECKS = 29;

const int SQLITE_TESTCTRL_LAST = 29;

const int SQLITE_STATUS_MEMORY_USED = 0;

const int SQLITE_STATUS_PAGECACHE_USED = 1;

const int SQLITE_STATUS_PAGECACHE_OVERFLOW = 2;

const int SQLITE_STATUS_SCRATCH_USED = 3;

const int SQLITE_STATUS_SCRATCH_OVERFLOW = 4;

const int SQLITE_STATUS_MALLOC_SIZE = 5;

const int SQLITE_STATUS_PARSER_STACK = 6;

const int SQLITE_STATUS_PAGECACHE_SIZE = 7;

const int SQLITE_STATUS_SCRATCH_SIZE = 8;

const int SQLITE_STATUS_MALLOC_COUNT = 9;

const int SQLITE_DBSTATUS_LOOKASIDE_USED = 0;

const int SQLITE_DBSTATUS_CACHE_USED = 1;

const int SQLITE_DBSTATUS_SCHEMA_USED = 2;

const int SQLITE_DBSTATUS_STMT_USED = 3;

const int SQLITE_DBSTATUS_LOOKASIDE_HIT = 4;

const int SQLITE_DBSTATUS_LOOKASIDE_MISS_SIZE = 5;

const int SQLITE_DBSTATUS_LOOKASIDE_MISS_FULL = 6;

const int SQLITE_DBSTATUS_CACHE_HIT = 7;

const int SQLITE_DBSTATUS_CACHE_MISS = 8;

const int SQLITE_DBSTATUS_CACHE_WRITE = 9;

const int SQLITE_DBSTATUS_DEFERRED_FKS = 10;

const int SQLITE_DBSTATUS_CACHE_USED_SHARED = 11;

const int SQLITE_DBSTATUS_CACHE_SPILL = 12;

const int SQLITE_DBSTATUS_MAX = 12;

const int SQLITE_STMTSTATUS_FULLSCAN_STEP = 1;

const int SQLITE_STMTSTATUS_SORT = 2;

const int SQLITE_STMTSTATUS_AUTOINDEX = 3;

const int SQLITE_STMTSTATUS_VM_STEP = 4;

const int SQLITE_STMTSTATUS_REPREPARE = 5;

const int SQLITE_STMTSTATUS_RUN = 6;

const int SQLITE_STMTSTATUS_MEMUSED = 99;

const int SQLITE_CHECKPOINT_PASSIVE = 0;

const int SQLITE_CHECKPOINT_FULL = 1;

const int SQLITE_CHECKPOINT_RESTART = 2;

const int SQLITE_CHECKPOINT_TRUNCATE = 3;

const int SQLITE_VTAB_CONSTRAINT_SUPPORT = 1;

const int SQLITE_VTAB_INNOCUOUS = 2;

const int SQLITE_VTAB_DIRECTONLY = 3;

const int SQLITE_ROLLBACK = 1;

const int SQLITE_FAIL = 3;

const int SQLITE_REPLACE = 5;

const int SQLITE_SCANSTAT_NLOOP = 0;

const int SQLITE_SCANSTAT_NVISIT = 1;

const int SQLITE_SCANSTAT_EST = 2;

const int SQLITE_SCANSTAT_NAME = 3;

const int SQLITE_SCANSTAT_EXPLAIN = 4;

const int SQLITE_SCANSTAT_SELECTID = 5;

const int SQLITE_SERIALIZE_NOCOPY = 1;

const int SQLITE_DESERIALIZE_FREEONCLOSE = 1;

const int SQLITE_DESERIALIZE_RESIZEABLE = 2;

const int SQLITE_DESERIALIZE_READONLY = 4;

const int NOT_WITHIN = 0;

const int PARTLY_WITHIN = 1;

const int FULLY_WITHIN = 2;

const int FTS5_TOKENIZE_QUERY = 1;

const int FTS5_TOKENIZE_PREFIX = 2;

const int FTS5_TOKENIZE_DOCUMENT = 4;

const int FTS5_TOKENIZE_AUX = 8;

const int FTS5_TOKEN_COLOCATED = 1;
