// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v22.7.4), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.g.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>
#include <utility>

namespace plugin_file_selector {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

FlutterError CreateConnectionError(const std::string& channel_name) {
  return FlutterError(
      "channel-error",
      "Unable to establish connection on channel: '" + channel_name + "'.",
      EncodableValue(""));
}

// PlatformTypeGroup

PlatformTypeGroup::PlatformTypeGroup(std::string label,
                                     EncodableList extensions,
                                     EncodableList mime_types)
    : label_(std::move(label)),
      extensions_(std::move(extensions)),
      mime_types_(std::move(mime_types)) {}

const std::string& PlatformTypeGroup::label() const {
  return label_;
}

void PlatformTypeGroup::set_label(std::string_view value_arg) {
  label_ = value_arg;
}

const EncodableList& PlatformTypeGroup::extensions() const {
  return extensions_;
}

void PlatformTypeGroup::set_extensions(const EncodableList& value_arg) {
  extensions_ = value_arg;
}

const EncodableList& PlatformTypeGroup::mime_types() const {
  return mime_types_;
}

void PlatformTypeGroup::set_mime_types(const EncodableList& value_arg) {
  mime_types_ = value_arg;
}

EncodableList PlatformTypeGroup::ToEncodableList() const {
  EncodableList list;
  list.reserve(3);
  list.emplace_back(label_);
  list.emplace_back(extensions_);
  list.emplace_back(mime_types_);
  return list;
}

PlatformTypeGroup PlatformTypeGroup::FromEncodableList(
    const EncodableList& list) {
  PlatformTypeGroup decoded(std::get<std::string>(list[0]),
                            std::get<EncodableList>(list[1]),
                            std::get<EncodableList>(list[2]));
  return decoded;
}

// PlatformFileChooserOptions

PlatformFileChooserOptions::PlatformFileChooserOptions() = default;

PlatformFileChooserOptions::PlatformFileChooserOptions(
    const EncodableList* allowed_file_types,
    const std::string* current_folder_path,
    const std::string* current_name,
    const std::string* accept_button_label,
    const bool* select_multiple)
    : allowed_file_types_(
          allowed_file_types ? std::optional<EncodableList>(*allowed_file_types)
                             : std::nullopt),
      current_folder_path_(
          current_folder_path ? std::optional<std::string>(*current_folder_path)
                              : std::nullopt),
      current_name_(current_name ? std::optional<std::string>(*current_name)
                                 : std::nullopt),
      accept_button_label_(
          accept_button_label ? std::optional<std::string>(*accept_button_label)
                              : std::nullopt),
      select_multiple_(select_multiple ? std::optional<bool>(*select_multiple)
                                       : std::nullopt) {}

const EncodableList* PlatformFileChooserOptions::allowed_file_types() const {
  return allowed_file_types_ ? &(*allowed_file_types_) : nullptr;
}

void PlatformFileChooserOptions::set_allowed_file_types(
    const EncodableList* value_arg) {
  allowed_file_types_ =
      value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void PlatformFileChooserOptions::set_allowed_file_types(
    const EncodableList& value_arg) {
  allowed_file_types_ = value_arg;
}

const std::string* PlatformFileChooserOptions::current_folder_path() const {
  return current_folder_path_ ? &(*current_folder_path_) : nullptr;
}

void PlatformFileChooserOptions::set_current_folder_path(
    const std::string_view* value_arg) {
  current_folder_path_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PlatformFileChooserOptions::set_current_folder_path(
    std::string_view value_arg) {
  current_folder_path_ = value_arg;
}

const std::string* PlatformFileChooserOptions::current_name() const {
  return current_name_ ? &(*current_name_) : nullptr;
}

void PlatformFileChooserOptions::set_current_name(
    const std::string_view* value_arg) {
  current_name_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PlatformFileChooserOptions::set_current_name(std::string_view value_arg) {
  current_name_ = value_arg;
}

const std::string* PlatformFileChooserOptions::accept_button_label() const {
  return accept_button_label_ ? &(*accept_button_label_) : nullptr;
}

void PlatformFileChooserOptions::set_accept_button_label(
    const std::string_view* value_arg) {
  accept_button_label_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PlatformFileChooserOptions::set_accept_button_label(
    std::string_view value_arg) {
  accept_button_label_ = value_arg;
}

const bool* PlatformFileChooserOptions::select_multiple() const {
  return select_multiple_ ? &(*select_multiple_) : nullptr;
}

void PlatformFileChooserOptions::set_select_multiple(const bool* value_arg) {
  select_multiple_ = value_arg ? std::optional<bool>(*value_arg) : std::nullopt;
}

void PlatformFileChooserOptions::set_select_multiple(bool value_arg) {
  select_multiple_ = value_arg;
}

EncodableList PlatformFileChooserOptions::ToEncodableList() const {
  EncodableList list;
  list.reserve(5);
  list.push_back(allowed_file_types_ ? EncodableValue(*allowed_file_types_)
                                     : EncodableValue());
  list.push_back(current_folder_path_ ? EncodableValue(*current_folder_path_)
                                      : EncodableValue());
  list.push_back(current_name_ ? EncodableValue(*current_name_)
                               : EncodableValue());
  list.push_back(accept_button_label_ ? EncodableValue(*accept_button_label_)
                                      : EncodableValue());
  list.push_back(select_multiple_ ? EncodableValue(*select_multiple_)
                                  : EncodableValue());
  return list;
}

PlatformFileChooserOptions PlatformFileChooserOptions::FromEncodableList(
    const EncodableList& list) {
  PlatformFileChooserOptions decoded;
  if (auto& encodable_allowed_file_types = list[0];
      !encodable_allowed_file_types.IsNull()) {
    decoded.set_allowed_file_types(
        std::get<EncodableList>(encodable_allowed_file_types));
  }
  if (auto& encodable_current_folder_path = list[1];
      !encodable_current_folder_path.IsNull()) {
    decoded.set_current_folder_path(
        std::get<std::string>(encodable_current_folder_path));
  }
  if (auto& encodable_current_name = list[2];
      !encodable_current_name.IsNull()) {
    decoded.set_current_name(std::get<std::string>(encodable_current_name));
  }
  if (auto& encodable_accept_button_label = list[3];
      !encodable_accept_button_label.IsNull()) {
    decoded.set_accept_button_label(
        std::get<std::string>(encodable_accept_button_label));
  }
  if (auto& encodable_select_multiple = list[4];
      !encodable_select_multiple.IsNull()) {
    decoded.set_select_multiple(std::get<bool>(encodable_select_multiple));
  }
  return decoded;
}

PigeonInternalCodecSerializer::PigeonInternalCodecSerializer() = default;

EncodableValue PigeonInternalCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 129: {
      const auto& encodable_enum_arg = ReadValue(stream);
      const int64_t enum_arg_value =
          encodable_enum_arg.IsNull() ? 0 : encodable_enum_arg.LongValue();
      return encodable_enum_arg.IsNull()
                 ? EncodableValue()
                 : CustomEncodableValue(
                       static_cast<PlatformFileChooserActionType>(
                           enum_arg_value));
    }
    case 130: {
      return CustomEncodableValue(PlatformTypeGroup::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    case 131: {
      return CustomEncodableValue(PlatformFileChooserOptions::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void PigeonInternalCodecSerializer::WriteValue(  // NOLINT(misc-no-recursion)
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(PlatformFileChooserActionType)) {
      stream->WriteByte(129);
      WriteValue(
          EncodableValue(static_cast<int>(
              std::any_cast<PlatformFileChooserActionType>(*custom_value))),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PlatformTypeGroup)) {
      stream->WriteByte(130);
      WriteValue(EncodableValue(std::any_cast<PlatformTypeGroup>(*custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PlatformFileChooserOptions)) {
      stream->WriteByte(131);
      WriteValue(EncodableValue(
                     std::any_cast<PlatformFileChooserOptions>(*custom_value)
                         .ToEncodableList()),
                 stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by FileSelectorApi.
const flutter::StandardMessageCodec& FileSelectorApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &PigeonInternalCodecSerializer::GetInstance());
}

// Sets up an instance of `FileSelectorApi` to handle messages through the
// `binary_messenger`.
void FileSelectorApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                            FileSelectorApi* api) {
  FileSelectorApi::SetUp(binary_messenger, api, "");
}

void FileSelectorApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                            FileSelectorApi* api,
                            const std::string& message_channel_suffix) {
  {
    const std::string prepended_suffix =
        !message_channel_suffix.empty()
            ? std::string(".") + message_channel_suffix
            : "";
    const BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.file_selector_linux.FileSelectorApi."
        "showFileChooser" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_type_arg = args.at(0);
              if (encodable_type_arg.IsNull()) {
                reply(WrapError("type_arg unexpectedly null."));
                return;
              }
              const auto& type_arg =
                  std::any_cast<const PlatformFileChooserActionType&>(
                      std::get<CustomEncodableValue>(encodable_type_arg));
              const auto& encodable_options_arg = args.at(1);
              if (encodable_options_arg.IsNull()) {
                reply(WrapError("options_arg unexpectedly null."));
                return;
              }
              const auto& options_arg =
                  std::any_cast<const PlatformFileChooserOptions&>(
                      std::get<CustomEncodableValue>(encodable_options_arg));
              ErrorOr<EncodableList> output =
                  api->ShowFileChooser(type_arg, options_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
}

EncodableValue FileSelectorApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue FileSelectorApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}
}  // namespace plugin_file_selector
