// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v22.7.4), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#ifndef PIGEON_MESSAGES_G_H_
#define PIGEON_MESSAGES_G_H_

#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <optional>
#include <string>

namespace plugin_file_selector {

// Generated class from Pigeon.

class FlutterError {
 public:
  explicit FlutterError(const std::string& code) : code_(code) {}
  explicit FlutterError(const std::string& code, const std::string& message)
      : code_(code), message_(message) {}
  explicit FlutterError(const std::string& code,
                        const std::string& message,
                        const flutter::EncodableValue& details)
      : code_(code), message_(message), details_(details) {}

  [[nodiscard]] const std::string& code() const { return code_; }
  [[nodiscard]] const std::string& message() const { return message_; }
  [[nodiscard]] const flutter::EncodableValue& details() const {
    return details_;
  }

 private:
  std::string code_;
  std::string message_;
  flutter::EncodableValue details_;
};

template <class T>
class ErrorOr {
 public:
  ErrorOr(const T& rhs) : v_(rhs) {}
  ErrorOr(const T&& rhs) : v_(std::move(rhs)) {}
  ErrorOr(const FlutterError& rhs) : v_(rhs) {}
  ErrorOr(const FlutterError&& rhs) : v_(std::move(rhs)) {}

  [[nodiscard]] bool has_error() const {
    return std::holds_alternative<FlutterError>(v_);
  }
  const T& value() const { return std::get<T>(v_); };
  [[nodiscard]] const FlutterError& error() const {
    return std::get<FlutterError>(v_);
  };

 private:
  friend class FileSelectorApi;
  ErrorOr() = default;
  T TakeValue() && { return std::get<T>(std::move(v_)); }

  std::variant<T, FlutterError> v_;
};

// A Pigeon representation of the GTK_FILE_CHOOSER_ACTION_* options.
enum class PlatformFileChooserActionType {
  kOpen = 0,
  kChooseDirectory = 1,
  kSave = 2
};

// A Pigeon representation of the Linux portion of an `XTypeGroup`.
//
// Generated class from Pigeon that represents data sent in messages.
class PlatformTypeGroup {
 public:
  // Constructs an object setting all fields.
  explicit PlatformTypeGroup(std::string label,
                             flutter::EncodableList extensions,
                             flutter::EncodableList mime_types);

  [[nodiscard]] const std::string& label() const;
  void set_label(std::string_view value_arg);

  [[nodiscard]] const flutter::EncodableList& extensions() const;
  void set_extensions(const flutter::EncodableList& value_arg);

  [[nodiscard]] const flutter::EncodableList& mime_types() const;
  void set_mime_types(const flutter::EncodableList& value_arg);

 private:
  static PlatformTypeGroup FromEncodableList(
      const flutter::EncodableList& list);
  [[nodiscard]] flutter::EncodableList ToEncodableList() const;
  friend class FileSelectorApi;
  friend class PigeonInternalCodecSerializer;
  std::string label_;
  flutter::EncodableList extensions_;
  flutter::EncodableList mime_types_;
};

// Options for GKT file chooser.
//
// These correspond to gtk_file_chooser_set_* options.
//
// Generated class from Pigeon that represents data sent in messages.
class PlatformFileChooserOptions {
 public:
  // Constructs an object setting all non-nullable fields.
  PlatformFileChooserOptions();

  // Constructs an object setting all fields.
  explicit PlatformFileChooserOptions(
      const flutter::EncodableList* allowed_file_types,
      const std::string* current_folder_path,
      const std::string* current_name,
      const std::string* accept_button_label,
      const bool* select_multiple);

  [[nodiscard]] const flutter::EncodableList* allowed_file_types() const;
  void set_allowed_file_types(const flutter::EncodableList* value_arg);
  void set_allowed_file_types(const flutter::EncodableList& value_arg);

  [[nodiscard]] const std::string* current_folder_path() const;
  void set_current_folder_path(const std::string_view* value_arg);
  void set_current_folder_path(std::string_view value_arg);

  [[nodiscard]] const std::string* current_name() const;
  void set_current_name(const std::string_view* value_arg);
  void set_current_name(std::string_view value_arg);

  [[nodiscard]] const std::string* accept_button_label() const;
  void set_accept_button_label(const std::string_view* value_arg);
  void set_accept_button_label(std::string_view value_arg);

  // Whether to allow multiple file selection.
  //
  // Nullable because it does not apply to the "save" action.
  [[nodiscard]] const bool* select_multiple() const;
  void set_select_multiple(const bool* value_arg);
  void set_select_multiple(bool value_arg);

 private:
  static PlatformFileChooserOptions FromEncodableList(
      const flutter::EncodableList& list);
  [[nodiscard]] flutter::EncodableList ToEncodableList() const;
  friend class FileSelectorApi;
  friend class PigeonInternalCodecSerializer;
  std::optional<flutter::EncodableList> allowed_file_types_;
  std::optional<std::string> current_folder_path_;
  std::optional<std::string> current_name_;
  std::optional<std::string> accept_button_label_;
  std::optional<bool> select_multiple_;
};

class PigeonInternalCodecSerializer final
    : public flutter::StandardCodecSerializer {
 public:
  PigeonInternalCodecSerializer();
  inline static PigeonInternalCodecSerializer& GetInstance() {
    static PigeonInternalCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class FileSelectorApi {
 public:
  FileSelectorApi(const FileSelectorApi&) = delete;
  FileSelectorApi& operator=(const FileSelectorApi&) = delete;
  virtual ~FileSelectorApi() = default;
  // Shows an file chooser with the given [type] and [options], returning the
  // list of selected paths.
  //
  // An empty list corresponds to a cancelled selection.
  virtual ErrorOr<flutter::EncodableList> ShowFileChooser(
      const PlatformFileChooserActionType& type,
      const PlatformFileChooserOptions& options) = 0;

  // The codec used by FileSelectorApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `FileSelectorApi` to handle messages through the
  // `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    FileSelectorApi* api);
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    FileSelectorApi* api,
                    const std::string& message_channel_suffix);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  FileSelectorApi() = default;
};
}  // namespace plugin_file_selector
#endif  // PIGEON_MESSAGES_G_H_
