/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.common;

import androidx.annotation.NonNull;
import io.flutter.Log;
import io.flutter.plugin.common.FlutterException;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class StandardMethodCodec
implements MethodCodec {
    public static final StandardMethodCodec INSTANCE = new StandardMethodCodec(StandardMessageCodec.INSTANCE);
    private final StandardMessageCodec messageCodec;

    public StandardMethodCodec(@NonNull StandardMessageCodec messageCodec) {
        this.messageCodec = messageCodec;
    }

    @Override
    @NonNull
    public ByteBuffer encodeMethodCall(@NonNull MethodCall methodCall) {
        StandardMessageCodec.ExposedByteArrayOutputStream stream = new StandardMessageCodec.ExposedByteArrayOutputStream();
        this.messageCodec.writeValue(stream, methodCall.method);
        this.messageCodec.writeValue(stream, methodCall.arguments);
        ByteBuffer buffer = ByteBuffer.allocateDirect(stream.size());
        buffer.put(stream.buffer(), 0, stream.size());
        return buffer;
    }

    @Override
    @NonNull
    public MethodCall decodeMethodCall(@NonNull ByteBuffer methodCall) {
        methodCall.order(ByteOrder.nativeOrder());
        Object method = this.messageCodec.readValue(methodCall);
        Object arguments = this.messageCodec.readValue(methodCall);
        if (method instanceof String && !methodCall.hasRemaining()) {
            return new MethodCall((String)method, arguments);
        }
        throw new IllegalArgumentException("Method call corrupted");
    }

    @Override
    @NonNull
    public ByteBuffer encodeSuccessEnvelope(@NonNull Object result) {
        StandardMessageCodec.ExposedByteArrayOutputStream stream = new StandardMessageCodec.ExposedByteArrayOutputStream();
        stream.write(0);
        this.messageCodec.writeValue(stream, result);
        ByteBuffer buffer = ByteBuffer.allocateDirect(stream.size());
        buffer.put(stream.buffer(), 0, stream.size());
        return buffer;
    }

    @Override
    @NonNull
    public ByteBuffer encodeErrorEnvelope(@NonNull String errorCode, @NonNull String errorMessage, @NonNull Object errorDetails) {
        StandardMessageCodec.ExposedByteArrayOutputStream stream = new StandardMessageCodec.ExposedByteArrayOutputStream();
        stream.write(1);
        this.messageCodec.writeValue(stream, errorCode);
        this.messageCodec.writeValue(stream, errorMessage);
        if (errorDetails instanceof Throwable) {
            this.messageCodec.writeValue(stream, Log.getStackTraceString((Throwable)errorDetails));
        } else {
            this.messageCodec.writeValue(stream, errorDetails);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(stream.size());
        buffer.put(stream.buffer(), 0, stream.size());
        return buffer;
    }

    @Override
    @NonNull
    public ByteBuffer encodeErrorEnvelopeWithStacktrace(@NonNull String errorCode, @NonNull String errorMessage, @NonNull Object errorDetails, @NonNull String errorStacktrace) {
        StandardMessageCodec.ExposedByteArrayOutputStream stream = new StandardMessageCodec.ExposedByteArrayOutputStream();
        stream.write(1);
        this.messageCodec.writeValue(stream, errorCode);
        this.messageCodec.writeValue(stream, errorMessage);
        if (errorDetails instanceof Throwable) {
            this.messageCodec.writeValue(stream, Log.getStackTraceString((Throwable)errorDetails));
        } else {
            this.messageCodec.writeValue(stream, errorDetails);
        }
        this.messageCodec.writeValue(stream, errorStacktrace);
        ByteBuffer buffer = ByteBuffer.allocateDirect(stream.size());
        buffer.put(stream.buffer(), 0, stream.size());
        return buffer;
    }

    @Override
    @NonNull
    public Object decodeEnvelope(@NonNull ByteBuffer envelope) {
        envelope.order(ByteOrder.nativeOrder());
        byte flag = envelope.get();
        switch (flag) {
            case 0: {
                Object result = this.messageCodec.readValue(envelope);
                if (!envelope.hasRemaining()) {
                    return result;
                }
            }
            case 1: {
                Object code = this.messageCodec.readValue(envelope);
                Object message = this.messageCodec.readValue(envelope);
                Object details = this.messageCodec.readValue(envelope);
                if (!(code instanceof String) || message != null && !(message instanceof String) || envelope.hasRemaining()) break;
                throw new FlutterException((String)code, (String)message, details);
            }
        }
        throw new IllegalArgumentException("Envelope corrupted");
    }
}

