// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
// VMOptions=--verbose_debug

import 'dart:developer';

import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/step_into_async_no_await_test.dart
//
const LINE_A = 27;
const LINE_B = 31;
const LINE_C = 32;
// AUTOGENERATED END

// :async_op will not be captured in this function because it never needs to
// reschedule it.
Future<void> asyncWithoutAwait() async {
  print('asyncWithoutAwait'); // LINE_A
}

void testMain() {
  debugger(); // LINE_B
  asyncWithoutAwait(); // LINE_C
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  stepOver,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_C),
  stepInto,
  hasStoppedAtBreakpoint,
  (VmService service, IsolateRef isolateRef) async {
    await service.getStack(isolateRef.id!); // Should not crash.
  },
  stoppedAtLine(LINE_A),
  resumeIsolate,
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_into_async_no_await_test.dart',
      testeeConcurrent: testMain,
    );
