/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.MutableContextWrapper;
import android.os.Build;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.MotionEventTracker;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.FlutterOverlaySurface;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorView;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorsStack;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.PlatformViewCreationRequest;
import io.flutter.embedding.engine.systemchannels.PlatformViewTouch;
import io.flutter.embedding.engine.systemchannels.PlatformViewsChannel;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.ImageReaderPlatformViewRenderTarget;
import io.flutter.plugin.platform.PlatformOverlayView;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.plugin.platform.PlatformViewRegistryImpl;
import io.flutter.plugin.platform.PlatformViewRenderTarget;
import io.flutter.plugin.platform.PlatformViewWrapper;
import io.flutter.plugin.platform.PlatformViewsAccessibilityDelegate;
import io.flutter.plugin.platform.SurfaceProducerPlatformViewRenderTarget;
import io.flutter.plugin.platform.SurfaceTexturePlatformViewRenderTarget;
import io.flutter.plugin.platform.VirtualDisplayController;
import io.flutter.util.ViewUtils;
import io.flutter.view.AccessibilityBridge;
import io.flutter.view.TextureRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class PlatformViewsController
implements PlatformViewsAccessibilityDelegate {
    private static final String TAG = "PlatformViewsController";
    private static Class[] VIEW_TYPES_REQUIRE_NON_TLHC = new Class[]{SurfaceView.class};
    private final PlatformViewRegistryImpl registry;
    private AndroidTouchProcessor androidTouchProcessor;
    private Context context;
    private FlutterView flutterView;
    private FlutterJNI flutterJNI = null;
    @VisibleForTesting
    @Nullable
    TextureRegistry textureRegistry;
    @Nullable
    private TextInputPlugin textInputPlugin;
    private PlatformViewsChannel platformViewsChannel;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    @VisibleForTesting
    final HashMap<Integer, VirtualDisplayController> vdControllers;
    @VisibleForTesting
    final HashMap<Context, View> contextToEmbeddedView;
    private final SparseArray<PlatformView> platformViews;
    private final SparseArray<FlutterMutatorView> platformViewParent;
    private final SparseArray<PlatformOverlayView> overlayLayerViews;
    private final SparseArray<PlatformViewWrapper> viewWrappers;
    private int nextOverlayLayerId = 0;
    private boolean flutterViewConvertedToImageView = false;
    private boolean synchronizeToNativeViewHierarchy = true;
    private final HashSet<Integer> currentFrameUsedOverlayLayerIds;
    private final HashSet<Integer> currentFrameUsedPlatformViewIds;
    private final MotionEventTracker motionEventTracker;
    private boolean usesSoftwareRendering = false;
    private static boolean enableImageRenderTarget = true;
    private static boolean enableSurfaceProducerRenderTarget = true;
    final PlatformViewsChannel.PlatformViewsHandler channelHandler = new PlatformViewsChannel.PlatformViewsHandler(){

        @Override
        public void createForPlatformViewLayer(@NonNull PlatformViewCreationRequest request) {
            PlatformViewsController.this.enforceMinimumAndroidApiVersion(19);
            PlatformViewsController.this.ensureValidRequest(request);
            PlatformViewsController.this.throwIfHCPPEnabled();
            PlatformView platformView = PlatformViewsController.this.createPlatformView(request, false);
            PlatformViewsController.this.configureForHybridComposition(platformView, request);
        }

        @Override
        public boolean isHcppEnabled() {
            return false;
        }

        @Override
        public void createPlatformViewHcpp(@NonNull PlatformViewCreationRequest request) {
            throw new IllegalStateException("Trying to create an HC++ platform view from within PlatformViewsController1. Request: " + request);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public long createForTextureLayer(@NonNull PlatformViewCreationRequest request) {
            boolean supportsTextureLayerMode;
            PlatformViewsController.this.ensureValidRequest(request);
            int viewId = request.viewId;
            if (PlatformViewsController.this.viewWrappers.get(viewId) != null) {
                throw new IllegalStateException("Trying to create an already created platform view, view id: " + viewId);
            }
            if (PlatformViewsController.this.textureRegistry == null) {
                throw new IllegalStateException("Texture registry is null. This means that platform views controller was detached, view id: " + viewId);
            }
            if (PlatformViewsController.this.flutterView == null) {
                throw new IllegalStateException("Flutter view is null. This means the platform views controller doesn't have an attached view, view id: " + viewId);
            }
            PlatformView platformView = PlatformViewsController.this.createPlatformView(request, true);
            View embeddedView = platformView.getView();
            if (embeddedView.getParent() != null) {
                throw new IllegalStateException("The Android view returned from PlatformView#getView() was already added to a parent view.");
            }
            boolean bl = supportsTextureLayerMode = Build.VERSION.SDK_INT >= 23 && !ViewUtils.hasChildViewOfType(embeddedView, VIEW_TYPES_REQUIRE_NON_TLHC);
            if (!supportsTextureLayerMode) {
                if (request.displayMode == PlatformViewCreationRequest.RequestedDisplayMode.TEXTURE_WITH_HYBRID_FALLBACK) {
                    PlatformViewsController.this.configureForHybridComposition(platformView, request);
                    return -2L;
                }
                if (!PlatformViewsController.this.usesSoftwareRendering) {
                    return PlatformViewsController.this.configureForVirtualDisplay(platformView, request);
                }
            }
            return PlatformViewsController.this.configureForTextureLayerComposition(platformView, request);
        }

        @Override
        @RequiresApi(value=23)
        public void dispose(int viewId) {
            View embeddedView;
            ViewGroup pvParent;
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController.TAG, "Disposing unknown platform view with id: " + viewId);
                return;
            }
            if (platformView.getView() != null && (pvParent = (ViewGroup)(embeddedView = platformView.getView()).getParent()) != null) {
                pvParent.removeView(embeddedView);
            }
            PlatformViewsController.this.platformViews.remove(viewId);
            try {
                platformView.dispose();
            }
            catch (RuntimeException exception) {
                Log.e(PlatformViewsController.TAG, "Disposing platform view threw an exception", exception);
            }
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(viewId);
                View embeddedView2 = vdController.getView();
                if (embeddedView2 != null) {
                    PlatformViewsController.this.contextToEmbeddedView.remove(embeddedView2.getContext());
                }
                vdController.dispose();
                PlatformViewsController.this.vdControllers.remove(viewId);
                return;
            }
            PlatformViewWrapper viewWrapper = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId));
            if (viewWrapper != null) {
                viewWrapper.removeAllViews();
                viewWrapper.release();
                viewWrapper.unsetOnDescendantFocusChangeListener();
                ViewGroup wrapperParent = (ViewGroup)viewWrapper.getParent();
                if (wrapperParent != null) {
                    wrapperParent.removeView((View)viewWrapper);
                }
                PlatformViewsController.this.viewWrappers.remove(viewId);
                return;
            }
            FlutterMutatorView parentView = (FlutterMutatorView)((Object)PlatformViewsController.this.platformViewParent.get(viewId));
            if (parentView != null) {
                parentView.removeAllViews();
                parentView.unsetOnDescendantFocusChangeListener();
                ViewGroup mutatorViewParent = (ViewGroup)parentView.getParent();
                if (mutatorViewParent != null) {
                    mutatorViewParent.removeView((View)parentView);
                }
                PlatformViewsController.this.platformViewParent.remove(viewId);
            }
        }

        @Override
        @RequiresApi(value=23)
        public void offset(int viewId, double top, double left) {
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                return;
            }
            PlatformViewWrapper viewWrapper = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId));
            if (viewWrapper == null) {
                Log.e(PlatformViewsController.TAG, "Setting offset for unknown platform view with id: " + viewId);
                return;
            }
            int physicalTop = PlatformViewsController.this.toPhysicalPixels(top);
            int physicalLeft = PlatformViewsController.this.toPhysicalPixels(left);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)viewWrapper.getLayoutParams();
            layoutParams.topMargin = physicalTop;
            layoutParams.leftMargin = physicalLeft;
            viewWrapper.setLayoutParams(layoutParams);
        }

        @Override
        @RequiresApi(value=23)
        public void resize(@NonNull PlatformViewsChannel.PlatformViewResizeRequest request, @NonNull PlatformViewsChannel.PlatformViewBufferResized onComplete) {
            int physicalWidth = PlatformViewsController.this.toPhysicalPixels(request.newLogicalWidth);
            int physicalHeight = PlatformViewsController.this.toPhysicalPixels(request.newLogicalHeight);
            int viewId = request.viewId;
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                float originalDisplayDensity = PlatformViewsController.this.getDisplayDensity();
                VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(viewId);
                PlatformViewsController.this.lockInputConnection(vdController);
                vdController.resize(physicalWidth, physicalHeight, () -> {
                    PlatformViewsController.this.unlockInputConnection(vdController);
                    float displayDensity = PlatformViewsController.this.context == null ? originalDisplayDensity : PlatformViewsController.this.getDisplayDensity();
                    onComplete.run(new PlatformViewsChannel.PlatformViewBufferSize(PlatformViewsController.this.toLogicalPixels(vdController.getRenderTargetWidth(), displayDensity), PlatformViewsController.this.toLogicalPixels(vdController.getRenderTargetHeight(), displayDensity)));
                });
                return;
            }
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            PlatformViewWrapper viewWrapper = (PlatformViewWrapper)((Object)PlatformViewsController.this.viewWrappers.get(viewId));
            if (platformView == null || viewWrapper == null) {
                Log.e(PlatformViewsController.TAG, "Resizing unknown platform view with id: " + viewId);
                return;
            }
            if (physicalWidth > viewWrapper.getRenderTargetWidth() || physicalHeight > viewWrapper.getRenderTargetHeight()) {
                viewWrapper.resizeRenderTarget(physicalWidth, physicalHeight);
            }
            ViewGroup.LayoutParams viewWrapperLayoutParams = viewWrapper.getLayoutParams();
            viewWrapperLayoutParams.width = physicalWidth;
            viewWrapperLayoutParams.height = physicalHeight;
            viewWrapper.setLayoutParams(viewWrapperLayoutParams);
            View embeddedView = platformView.getView();
            if (embeddedView != null) {
                ViewGroup.LayoutParams embeddedViewLayoutParams = embeddedView.getLayoutParams();
                embeddedViewLayoutParams.width = physicalWidth;
                embeddedViewLayoutParams.height = physicalHeight;
                embeddedView.setLayoutParams(embeddedViewLayoutParams);
            }
            onComplete.run(new PlatformViewsChannel.PlatformViewBufferSize(PlatformViewsController.this.toLogicalPixels(viewWrapper.getRenderTargetWidth()), PlatformViewsController.this.toLogicalPixels(viewWrapper.getRenderTargetHeight())));
        }

        @Override
        public void onTouch(@NonNull PlatformViewTouch touch) {
            int viewId = touch.viewId;
            float density = ((PlatformViewsController)PlatformViewsController.this).context.getResources().getDisplayMetrics().density;
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController vdController = PlatformViewsController.this.vdControllers.get(viewId);
                MotionEvent event = PlatformViewsController.this.toMotionEvent(density, touch, true);
                vdController.dispatchTouchEvent(event);
                return;
            }
            PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController.TAG, "Sending touch to an unknown view with id: " + viewId);
                return;
            }
            View view = platformView.getView();
            if (view == null) {
                Log.e(PlatformViewsController.TAG, "Sending touch to a null view with id: " + viewId);
                return;
            }
            MotionEvent event = PlatformViewsController.this.toMotionEvent(density, touch, false);
            view.dispatchTouchEvent(event);
        }

        @Override
        public void setDirection(int viewId, int direction) {
            View embeddedView;
            if (!PlatformViewsController.validateDirection(direction)) {
                throw new IllegalStateException("Trying to set unknown direction value: " + direction + "(view id: " + viewId + ")");
            }
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController controller = PlatformViewsController.this.vdControllers.get(viewId);
                embeddedView = controller.getView();
            } else {
                PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
                if (platformView == null) {
                    Log.e(PlatformViewsController.TAG, "Setting direction to an unknown view with id: " + viewId);
                    return;
                }
                embeddedView = platformView.getView();
            }
            if (embeddedView == null) {
                Log.e(PlatformViewsController.TAG, "Setting direction to a null view with id: " + viewId);
                return;
            }
            embeddedView.setLayoutDirection(direction);
        }

        @Override
        public void clearFocus(int viewId) {
            View embeddedView;
            if (PlatformViewsController.this.usesVirtualDisplay(viewId)) {
                VirtualDisplayController controller = PlatformViewsController.this.vdControllers.get(viewId);
                embeddedView = controller.getView();
            } else {
                PlatformView platformView = (PlatformView)PlatformViewsController.this.platformViews.get(viewId);
                if (platformView == null) {
                    Log.e(PlatformViewsController.TAG, "Clearing focus on an unknown view with id: " + viewId);
                    return;
                }
                embeddedView = platformView.getView();
            }
            if (embeddedView == null) {
                Log.e(PlatformViewsController.TAG, "Clearing focus on a null view with id: " + viewId);
                return;
            }
            embeddedView.clearFocus();
        }

        @Override
        public void synchronizeToNativeViewHierarchy(boolean yes) {
            PlatformViewsController.this.synchronizeToNativeViewHierarchy = yes;
        }
    };

    private void enforceMinimumAndroidApiVersion(int minSdkVersion) {
        if (Build.VERSION.SDK_INT < minSdkVersion) {
            throw new IllegalStateException("Trying to use platform views with API " + Build.VERSION.SDK_INT + ", required API level is: " + minSdkVersion);
        }
    }

    private void ensureValidRequest(@NonNull PlatformViewCreationRequest request) {
        if (!PlatformViewsController.validateDirection(request.direction)) {
            throw new IllegalStateException("Trying to create a view with unknown direction value: " + request.direction + "(view id: " + request.viewId + ")");
        }
    }

    public PlatformViewsChannel getPlatformViewsChannel() {
        return this.platformViewsChannel;
    }

    @VisibleForTesting(otherwise=3)
    public PlatformView createPlatformView(@NonNull PlatformViewCreationRequest request, boolean wrapContext) {
        MutableContextWrapper mutableContext;
        PlatformView platformView;
        View embeddedView;
        PlatformViewFactory viewFactory = this.registry.getFactory(request.viewType);
        if (viewFactory == null) {
            throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
        }
        Object createParams = null;
        if (request.params != null) {
            createParams = viewFactory.getCreateArgsCodec().decodeMessage(request.params);
        }
        if ((embeddedView = (platformView = viewFactory.create((Context)(mutableContext = wrapContext ? new MutableContextWrapper(this.context) : this.context), request.viewId, createParams)).getView()) == null) {
            throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
        }
        embeddedView.setLayoutDirection(request.direction);
        this.platformViews.put(request.viewId, (Object)platformView);
        this.maybeInvokeOnFlutterViewAttached(platformView);
        return platformView;
    }

    private void configureForHybridComposition(@NonNull PlatformView platformView, @NonNull PlatformViewCreationRequest request) {
        this.enforceMinimumAndroidApiVersion(19);
        Log.i(TAG, "Using hybrid composition for platform view: " + request.viewId);
        this.throwIfHCPPEnabled();
    }

    private void throwIfHCPPEnabled() {
        if (this.flutterJNI.IsSurfaceControlEnabled()) {
            throw new IllegalStateException("Trying to create a Hybrid Composition view with HC++ enabled.");
        }
    }

    private long configureForVirtualDisplay(@NonNull PlatformView platformView, @NonNull PlatformViewCreationRequest request) {
        this.enforceMinimumAndroidApiVersion(20);
        Log.i(TAG, "Hosting view in a virtual display for platform view: " + request.viewId);
        PlatformViewRenderTarget renderTarget = PlatformViewsController.makePlatformViewRenderTarget(this.textureRegistry);
        int physicalWidth = this.toPhysicalPixels(request.logicalWidth);
        int physicalHeight = this.toPhysicalPixels(request.logicalHeight);
        VirtualDisplayController vdController = VirtualDisplayController.create(this.context, this.accessibilityEventsDelegate, platformView, renderTarget, physicalWidth, physicalHeight, request.viewId, null, (view, hasFocus) -> {
            if (hasFocus) {
                this.platformViewsChannel.invokeViewFocused(request.viewId);
            }
        });
        if (vdController == null) {
            throw new IllegalStateException("Failed creating virtual display for a " + request.viewType + " with id: " + request.viewId);
        }
        this.vdControllers.put(request.viewId, vdController);
        View embeddedView = platformView.getView();
        this.contextToEmbeddedView.put(embeddedView.getContext(), embeddedView);
        return renderTarget.getId();
    }

    @RequiresApi(value=23)
    @VisibleForTesting(otherwise=3)
    public long configureForTextureLayerComposition(@NonNull PlatformView platformView, @NonNull PlatformViewCreationRequest request) {
        long textureId;
        PlatformViewWrapper viewWrapper;
        this.enforceMinimumAndroidApiVersion(23);
        Log.i(TAG, "Hosting view in view hierarchy for platform view: " + request.viewId);
        int physicalWidth = this.toPhysicalPixels(request.logicalWidth);
        int physicalHeight = this.toPhysicalPixels(request.logicalHeight);
        if (this.usesSoftwareRendering) {
            viewWrapper = new PlatformViewWrapper(this.context);
            textureId = -1L;
        } else {
            PlatformViewRenderTarget renderTarget = PlatformViewsController.makePlatformViewRenderTarget(this.textureRegistry);
            viewWrapper = new PlatformViewWrapper(this.context, renderTarget);
            textureId = renderTarget.getId();
        }
        viewWrapper.setTouchProcessor(this.androidTouchProcessor);
        viewWrapper.resizeRenderTarget(physicalWidth, physicalHeight);
        FrameLayout.LayoutParams viewWrapperLayoutParams = new FrameLayout.LayoutParams(physicalWidth, physicalHeight);
        int physicalTop = this.toPhysicalPixels(request.logicalTop);
        int physicalLeft = this.toPhysicalPixels(request.logicalLeft);
        viewWrapperLayoutParams.topMargin = physicalTop;
        viewWrapperLayoutParams.leftMargin = physicalLeft;
        viewWrapper.setLayoutParams(viewWrapperLayoutParams);
        View embeddedView = platformView.getView();
        embeddedView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(physicalWidth, physicalHeight));
        embeddedView.setImportantForAccessibility(4);
        viewWrapper.addView(embeddedView);
        viewWrapper.setOnDescendantFocusChangeListener((v, hasFocus) -> {
            if (hasFocus) {
                this.platformViewsChannel.invokeViewFocused(request.viewId);
            } else if (this.textInputPlugin != null) {
                this.textInputPlugin.clearPlatformViewClient(request.viewId);
            }
        });
        this.flutterView.addView((View)viewWrapper);
        this.viewWrappers.append(request.viewId, (Object)viewWrapper);
        this.maybeInvokeOnFlutterViewAttached(platformView);
        return textureId;
    }

    private static void translateMotionEvent(MotionEvent originalEvent, MotionEvent.PointerCoords[] pointerCoords) {
        if (pointerCoords.length < 1) {
            return;
        }
        float xOffset = pointerCoords[0].x - originalEvent.getX();
        float yOffset = pointerCoords[0].y - originalEvent.getY();
        originalEvent.offsetLocation(xOffset, yOffset);
    }

    @VisibleForTesting
    public MotionEvent toMotionEvent(float density, PlatformViewTouch touch, boolean usingVirtualDiplay) {
        MotionEventTracker.MotionEventId motionEventId = MotionEventTracker.MotionEventId.from(touch.motionEventId);
        MotionEvent trackedEvent = this.motionEventTracker.pop(motionEventId);
        MotionEvent.PointerCoords[] pointerCoords = PlatformViewsController.parsePointerCoordsList(touch.rawPointerCoords, density).toArray(new MotionEvent.PointerCoords[touch.pointerCount]);
        if (!usingVirtualDiplay && trackedEvent != null) {
            PlatformViewsController.translateMotionEvent(trackedEvent, pointerCoords);
            return trackedEvent;
        }
        MotionEvent.PointerProperties[] pointerProperties = PlatformViewsController.parsePointerPropertiesList(touch.rawPointerPropertiesList).toArray(new MotionEvent.PointerProperties[touch.pointerCount]);
        return MotionEvent.obtain((long)touch.downTime.longValue(), (long)touch.eventTime.longValue(), (int)touch.action, (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)touch.metaState, (int)touch.buttonState, (float)touch.xPrecision, (float)touch.yPrecision, (int)touch.deviceId, (int)touch.edgeFlags, (int)touch.source, (int)touch.flags);
    }

    public PlatformViewsController() {
        this.registry = new PlatformViewRegistryImpl();
        this.vdControllers = new HashMap();
        this.accessibilityEventsDelegate = new AccessibilityEventsDelegate();
        this.contextToEmbeddedView = new HashMap();
        this.overlayLayerViews = new SparseArray();
        this.currentFrameUsedOverlayLayerIds = new HashSet();
        this.currentFrameUsedPlatformViewIds = new HashSet();
        this.viewWrappers = new SparseArray();
        this.platformViews = new SparseArray();
        this.platformViewParent = new SparseArray();
        this.motionEventTracker = MotionEventTracker.getInstance();
    }

    public void attach(@Nullable Context context, @NonNull TextureRegistry textureRegistry, @NonNull DartExecutor dartExecutor) {
        if (this.context != null) {
            throw new AssertionError((Object)"A PlatformViewsController can only be attached to a single output target.\nattach was called while the PlatformViewsController was already attached.");
        }
        this.context = context;
        this.textureRegistry = textureRegistry;
        this.platformViewsChannel = new PlatformViewsChannel(dartExecutor);
    }

    public void setSoftwareRendering(boolean useSoftwareRendering) {
        this.usesSoftwareRendering = useSoftwareRendering;
    }

    @UiThread
    public void detach() {
        if (this.platformViewsChannel != null) {
            this.platformViewsChannel.setPlatformViewsHandler(null);
        }
        this.destroyOverlaySurfaces();
        this.platformViewsChannel = null;
        this.context = null;
        this.textureRegistry = null;
    }

    public void attachToView(@NonNull FlutterView newFlutterView) {
        Object view;
        int index;
        this.flutterView = newFlutterView;
        for (index = 0; index < this.viewWrappers.size(); ++index) {
            view = (PlatformViewWrapper)((Object)this.viewWrappers.valueAt(index));
            this.flutterView.addView((View)view);
        }
        for (index = 0; index < this.platformViewParent.size(); ++index) {
            view = (FlutterMutatorView)((Object)this.platformViewParent.valueAt(index));
            this.flutterView.addView((View)view);
        }
        for (index = 0; index < this.platformViews.size(); ++index) {
            view = (PlatformView)this.platformViews.valueAt(index);
            view.onFlutterViewAttached((View)this.flutterView);
        }
    }

    public void detachFromView() {
        Object view;
        int index;
        for (index = 0; index < this.viewWrappers.size(); ++index) {
            view = (PlatformViewWrapper)((Object)this.viewWrappers.valueAt(index));
            this.flutterView.removeView((View)view);
        }
        for (index = 0; index < this.platformViewParent.size(); ++index) {
            view = (FlutterMutatorView)((Object)this.platformViewParent.valueAt(index));
            this.flutterView.removeView((View)view);
        }
        this.destroyOverlaySurfaces();
        this.removeOverlaySurfaces();
        this.flutterView = null;
        this.flutterViewConvertedToImageView = false;
        for (index = 0; index < this.platformViews.size(); ++index) {
            view = (PlatformView)this.platformViews.valueAt(index);
            view.onFlutterViewDetached();
        }
    }

    private void maybeInvokeOnFlutterViewAttached(PlatformView view) {
        if (this.flutterView == null) {
            Log.i(TAG, "null flutterView");
            return;
        }
        view.onFlutterViewAttached((View)this.flutterView);
    }

    @Override
    public void attachAccessibilityBridge(@NonNull AccessibilityBridge accessibilityBridge) {
        this.accessibilityEventsDelegate.setAccessibilityBridge(accessibilityBridge);
    }

    @Override
    public void detachAccessibilityBridge() {
        this.accessibilityEventsDelegate.setAccessibilityBridge(null);
    }

    public void attachTextInputPlugin(@NonNull TextInputPlugin textInputPlugin) {
        this.textInputPlugin = textInputPlugin;
    }

    public void detachTextInputPlugin() {
        this.textInputPlugin = null;
    }

    public boolean checkInputConnectionProxy(@Nullable View view) {
        if (view == null) {
            return false;
        }
        if (!this.contextToEmbeddedView.containsKey(view.getContext())) {
            return false;
        }
        View platformView = this.contextToEmbeddedView.get(view.getContext());
        if (platformView == view) {
            return true;
        }
        return platformView.checkInputConnectionProxy(view);
    }

    public PlatformViewRegistry getRegistry() {
        return this.registry;
    }

    public void onDetachedFromJNI() {
        this.diposeAllViews();
    }

    public void onPreEngineRestart() {
        this.diposeAllViews();
    }

    @Override
    @Nullable
    public View getPlatformViewById(int viewId) {
        if (this.usesVirtualDisplay(viewId)) {
            VirtualDisplayController controller = this.vdControllers.get(viewId);
            return controller.getView();
        }
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            return null;
        }
        return platformView.getView();
    }

    public void setFlutterJNI(FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
    }

    @Override
    public boolean usesVirtualDisplay(int id) {
        return this.vdControllers.containsKey(id);
    }

    private void lockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.lockPlatformViewInputConnection();
        controller.onInputConnectionLocked();
    }

    private void unlockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.unlockPlatformViewInputConnection();
        controller.onInputConnectionUnlocked();
    }

    private static PlatformViewRenderTarget makePlatformViewRenderTarget(TextureRegistry textureRegistry) {
        if (enableSurfaceProducerRenderTarget && Build.VERSION.SDK_INT >= 29) {
            TextureRegistry.SurfaceLifecycle lifecycle = Build.VERSION.SDK_INT <= 34 ? TextureRegistry.SurfaceLifecycle.resetInBackground : TextureRegistry.SurfaceLifecycle.manual;
            TextureRegistry.SurfaceProducer textureEntry = textureRegistry.createSurfaceProducer(lifecycle);
            Log.i(TAG, "PlatformView is using SurfaceProducer backend");
            return new SurfaceProducerPlatformViewRenderTarget(textureEntry);
        }
        if (enableImageRenderTarget && Build.VERSION.SDK_INT >= 29) {
            TextureRegistry.ImageTextureEntry textureEntry = textureRegistry.createImageTexture();
            Log.i(TAG, "PlatformView is using ImageReader backend");
            return new ImageReaderPlatformViewRenderTarget(textureEntry);
        }
        TextureRegistry.SurfaceTextureEntry textureEntry = textureRegistry.createSurfaceTexture();
        Log.i(TAG, "PlatformView is using SurfaceTexture backend");
        return new SurfaceTexturePlatformViewRenderTarget(textureEntry);
    }

    private static boolean validateDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    private static List<MotionEvent.PointerProperties> parsePointerPropertiesList(Object rawPropertiesList) {
        List rawProperties = (List)rawPropertiesList;
        ArrayList<MotionEvent.PointerProperties> pointerProperties = new ArrayList<MotionEvent.PointerProperties>();
        for (Object o : rawProperties) {
            pointerProperties.add(PlatformViewsController.parsePointerProperties(o));
        }
        return pointerProperties;
    }

    private static MotionEvent.PointerProperties parsePointerProperties(Object rawProperties) {
        List propertiesList = (List)rawProperties;
        MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
        properties.id = (Integer)propertiesList.get(0);
        properties.toolType = (Integer)propertiesList.get(1);
        return properties;
    }

    private static List<MotionEvent.PointerCoords> parsePointerCoordsList(Object rawCoordsList, float density) {
        List rawCoords = (List)rawCoordsList;
        ArrayList<MotionEvent.PointerCoords> pointerCoords = new ArrayList<MotionEvent.PointerCoords>();
        for (Object o : rawCoords) {
            pointerCoords.add(PlatformViewsController.parsePointerCoords(o, density));
        }
        return pointerCoords;
    }

    private static MotionEvent.PointerCoords parsePointerCoords(Object rawCoords, float density) {
        List coordsList = (List)rawCoords;
        MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
        coords.orientation = (float)((Double)coordsList.get(0)).doubleValue();
        coords.pressure = (float)((Double)coordsList.get(1)).doubleValue();
        coords.size = (float)((Double)coordsList.get(2)).doubleValue();
        coords.toolMajor = (float)((Double)coordsList.get(3) * (double)density);
        coords.toolMinor = (float)((Double)coordsList.get(4) * (double)density);
        coords.touchMajor = (float)((Double)coordsList.get(5) * (double)density);
        coords.touchMinor = (float)((Double)coordsList.get(6) * (double)density);
        coords.x = (float)((Double)coordsList.get(7) * (double)density);
        coords.y = (float)((Double)coordsList.get(8) * (double)density);
        return coords;
    }

    private float getDisplayDensity() {
        return this.context.getResources().getDisplayMetrics().density;
    }

    private int toPhysicalPixels(double logicalPixels) {
        return (int)Math.round(logicalPixels * (double)this.getDisplayDensity());
    }

    private int toLogicalPixels(double physicalPixels, float displayDensity) {
        return (int)Math.round(physicalPixels / (double)displayDensity);
    }

    private int toLogicalPixels(double physicalPixels) {
        return this.toLogicalPixels(physicalPixels, this.getDisplayDensity());
    }

    private void diposeAllViews() {
        while (this.platformViews.size() > 0) {
            int viewId = this.platformViews.keyAt(0);
            this.channelHandler.dispose(viewId);
        }
    }

    public void onTrimMemory(int level) {
        if (level < 40) {
            return;
        }
        for (VirtualDisplayController vdc : this.vdControllers.values()) {
            vdc.clearSurface();
        }
    }

    public void onResume() {
        for (VirtualDisplayController vdc : this.vdControllers.values()) {
            vdc.resetSurface();
        }
    }

    @VisibleForTesting
    public void disposePlatformView(int viewId) {
        this.channelHandler.dispose(viewId);
    }

    private void initializeRootImageViewIfNeeded() {
        if (this.synchronizeToNativeViewHierarchy && !this.flutterViewConvertedToImageView) {
            this.flutterView.convertToImageView();
            this.flutterViewConvertedToImageView = true;
        }
    }

    @VisibleForTesting
    boolean initializePlatformViewIfNeeded(int viewId) {
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            return false;
        }
        if (this.platformViewParent.get(viewId) != null) {
            return true;
        }
        View embeddedView = platformView.getView();
        if (embeddedView == null) {
            throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
        }
        if (embeddedView.getParent() != null) {
            throw new IllegalStateException("The Android view returned from PlatformView#getView() was already added to a parent view.");
        }
        FlutterMutatorView parentView = new FlutterMutatorView(this.context, this.context.getResources().getDisplayMetrics().density, this.androidTouchProcessor);
        parentView.setOnDescendantFocusChangeListener((view, hasFocus) -> {
            if (hasFocus) {
                this.platformViewsChannel.invokeViewFocused(viewId);
            } else if (this.textInputPlugin != null) {
                this.textInputPlugin.clearPlatformViewClient(viewId);
            }
        });
        this.platformViewParent.put(viewId, (Object)parentView);
        embeddedView.setImportantForAccessibility(4);
        parentView.addView(embeddedView);
        this.flutterView.addView((View)parentView);
        return true;
    }

    public void attachToFlutterRenderer(@NonNull FlutterRenderer flutterRenderer) {
        this.androidTouchProcessor = new AndroidTouchProcessor(flutterRenderer, true);
    }

    public void onDisplayPlatformView(int viewId, int x, int y, int width, int height, int viewWidth, int viewHeight, @NonNull FlutterMutatorsStack mutatorsStack) {
        this.initializeRootImageViewIfNeeded();
        if (!this.initializePlatformViewIfNeeded(viewId)) {
            return;
        }
        FlutterMutatorView parentView = (FlutterMutatorView)((Object)this.platformViewParent.get(viewId));
        parentView.readyToDisplay(mutatorsStack, x, y, width, height);
        parentView.setVisibility(0);
        parentView.bringToFront();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(viewWidth, viewHeight);
        View view = ((PlatformView)this.platformViews.get(viewId)).getView();
        if (view != null) {
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            view.bringToFront();
        }
        this.currentFrameUsedPlatformViewIds.add(viewId);
    }

    public void onDisplayOverlaySurface(int id, int x, int y, int width, int height) {
        if (this.overlayLayerViews.get(id) == null) {
            throw new IllegalStateException("The overlay surface (id:" + id + ") doesn't exist");
        }
        this.initializeRootImageViewIfNeeded();
        PlatformOverlayView overlayView = (PlatformOverlayView)this.overlayLayerViews.get(id);
        if (overlayView.getParent() == null) {
            this.flutterView.addView(overlayView);
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
        layoutParams.leftMargin = x;
        layoutParams.topMargin = y;
        overlayView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        overlayView.setVisibility(0);
        overlayView.bringToFront();
        this.currentFrameUsedOverlayLayerIds.add(id);
    }

    public void onBeginFrame() {
        this.currentFrameUsedOverlayLayerIds.clear();
        this.currentFrameUsedPlatformViewIds.clear();
    }

    public void onEndFrame() {
        if (this.flutterViewConvertedToImageView && this.currentFrameUsedPlatformViewIds.isEmpty()) {
            this.flutterViewConvertedToImageView = false;
            this.flutterView.revertImageView(() -> this.finishFrame(false));
            return;
        }
        boolean isFrameRenderedUsingImageReaders = this.flutterViewConvertedToImageView && this.flutterView.acquireLatestImageViewFrame();
        this.finishFrame(isFrameRenderedUsingImageReaders);
    }

    private void finishFrame(boolean isFrameRenderedUsingImageReaders) {
        int i;
        for (i = 0; i < this.overlayLayerViews.size(); ++i) {
            int overlayId = this.overlayLayerViews.keyAt(i);
            PlatformOverlayView overlayView = (PlatformOverlayView)this.overlayLayerViews.valueAt(i);
            if (this.currentFrameUsedOverlayLayerIds.contains(overlayId)) {
                this.flutterView.attachOverlaySurfaceToRender(overlayView);
                boolean didAcquireOverlaySurfaceImage = overlayView.acquireLatestImage();
                isFrameRenderedUsingImageReaders &= didAcquireOverlaySurfaceImage;
                continue;
            }
            if (!this.flutterViewConvertedToImageView) {
                overlayView.detachFromRenderer();
            }
            overlayView.setVisibility(8);
            this.flutterView.removeView(overlayView);
        }
        for (i = 0; i < this.platformViewParent.size(); ++i) {
            int viewId = this.platformViewParent.keyAt(i);
            View parentView = (View)this.platformViewParent.get(viewId);
            if (this.currentFrameUsedPlatformViewIds.contains(viewId) && (isFrameRenderedUsingImageReaders || !this.synchronizeToNativeViewHierarchy)) {
                parentView.setVisibility(0);
                continue;
            }
            parentView.setVisibility(8);
        }
    }

    @VisibleForTesting
    @NonNull
    public FlutterOverlaySurface createOverlaySurface(@NonNull PlatformOverlayView imageView) {
        int id = this.nextOverlayLayerId++;
        this.overlayLayerViews.put(id, (Object)imageView);
        return new FlutterOverlaySurface(id, imageView.getSurface());
    }

    @NonNull
    public FlutterOverlaySurface createOverlaySurface() {
        return this.createOverlaySurface(new PlatformOverlayView(this.flutterView.getContext(), this.flutterView.getWidth(), this.flutterView.getHeight(), this.accessibilityEventsDelegate));
    }

    public void destroyOverlaySurfaces() {
        for (int viewId = 0; viewId < this.overlayLayerViews.size(); ++viewId) {
            PlatformOverlayView overlayView = (PlatformOverlayView)this.overlayLayerViews.valueAt(viewId);
            overlayView.detachFromRenderer();
            overlayView.closeImageReader();
        }
    }

    private void removeOverlaySurfaces() {
        if (this.flutterView == null) {
            Log.e(TAG, "removeOverlaySurfaces called while flutter view is null");
            return;
        }
        for (int viewId = 0; viewId < this.overlayLayerViews.size(); ++viewId) {
            this.flutterView.removeView((View)this.overlayLayerViews.valueAt(viewId));
        }
        this.overlayLayerViews.clear();
    }

    @VisibleForTesting
    public SparseArray<PlatformOverlayView> getOverlayLayerViews() {
        return this.overlayLayerViews;
    }
}

