#
# Copyright (c) 2020-2025 Joel Winarske. All rights reserved.
#

SUMMARY = "PDFium"
DESCRIPTION = "PDF rendering engine \
               Reference: https://github.com/bblanchon/pdfium-binaries"
AUTHOR = "Google PDFium Team"
HOMEPAGE = "https://pdfium.googlesource.com/pdfium"
BUGTRACKER = "https://bugs.chromium.org/p/pdfium/issues/list"
SECTION = "graphics"
LICENSE = "BSD-3-Clause"
LIC_FILES_CHKSUM = "file://LICENSE;md5=c93507531cc9bb8e24a05f2a1a4036c7"

DEPENDS += "\
    freetype \
    glib-2.0 \
    libpng \
    openjpeg \
    zlib \
    depot-tools-native \
    ninja-native \
    "

DEPENDS:append:x86-64 = " nasm-native"

SRCREV = "4e4d7a14a4d9d484feb4a4770a892cd964cfd968"
SRC_URI = "\
    gn://pdfium.googlesource.com/pdfium.git \
    \
    file://0001-public-headers.patch \
    file://0002-shared-library.patch \
    file://0003-sysroot-fix-path.patch \
    file://0004-v8-init.patch \
    \
    file://toolchain.gn.in \
    "

S = "${WORKDIR}/gn/pdfium"
B = "${WORKDIR}/gn/out"

inherit gn-fetcher pkgconfig

require conf/include/gn-utils.inc

# For gn.bbclass
# Trick `gclient sync`. Download some binary in order to satisfy dependencies.
# Check reasoning at:
# - https://github.com/meta-flutter/meta-flutter/issues/411#issuecomment-2955621158
# Keep this workaround while the following issue is unsolved:
# - https://issues.chromium.org/issues/424205782
GN_CUSTOM_VARS ?= '\
{\
    "reclient_package": "gn/gn/", \
    "reclient_version": "git_revision:b99a82ca8ee957da829d6313b818b99df8e7ccb8", \
    "checkout_configuration": "small" \
}'

EXTRA_GN_SYNC ?= "--shallow --no-history -R -D"

EXTRA_CXXFLAGS = ""
EXTRA_CXXFLAGS:append:libc-musl = "\
    -flax-vector-conversions \
    "

PACKAGECONFIG ??= "release"

PACKAGECONFIG[release] = "is_debug = false, is_debug = true"
PACKAGECONFIG[skia] = "pdf_use_skia = true, pdf_use_skia = false, fontconfig"
PACKAGECONFIG[v8] = "pdf_enable_v8=true pdf_enable_xfa=true, pdf_enable_v8=false pdf_enable_xfa=false"

GN_ARGS = '\
    ${PACKAGECONFIG_CONFARGS} \
    pdf_is_standalone = true \
    is_component_build = false \
    treat_warnings_as_errors = false \
    \
    use_system_freetype = true \
    use_system_libopenjpeg2 = true \
    use_system_zlib = true \
    use_system_libpng = true \
    \
    is_clang = false \
    clang_use_chrome_plugins = false \
    use_custom_libcxx = false \
    libcxx_is_shared = false \
    \
    target_os = "linux" \
    target_cpu = "${GN_TARGET_ARCH_NAME}" \
    target_triple = "${TARGET_SYS}" \
    target_sysroot = "${STAGING_DIR_TARGET}" \
'

do_configure() {
    cd ${S}

    #
    # configure toolchain file
    #
    cp ${S}/../../toolchain.gn.in ${S}/build/toolchain/linux/BUILD.gn
    sed -i "s|@GN_TARGET_ARCH_NAME@|${GN_TARGET_ARCH_NAME}|g" ${S}/build/toolchain/linux/BUILD.gn
    sed -i "s|@TARGET_SYS@|${TARGET_SYS}|g"                   ${S}/build/toolchain/linux/BUILD.gn
    sed -i "s|@LDFLAGS@|${LDFLAGS}|g"                         ${S}/build/toolchain/linux/BUILD.gn
    sed -i "s|@EXTRA_CXXFLAGS@|${EXTRA_CXXFLAGS}|g"           ${S}/build/toolchain/linux/BUILD.gn

    gn gen --args='${GN_ARGS}' "${B}"
}

do_compile() {
    ninja -C "${B}" pdfium $PARALLEL_MAKE
}
do_compile[progress] = "outof:^\[(\d+)/(\d+)\]\s+"

do_install() {
    install -d ${D}${libdir}/pdfium
    install -m 0755 ${B}/libpdfium.so ${D}${libdir}/pdfium
    install -m 0644 ${B}/icudtl.dat ${D}${libdir}/pdfium
    cp ${S}/LICENSE ${D}${libdir}/pdfium

    if ${@bb.utils.contains('PACKAGECONFIG', 'v8', 'true', 'false', d)}; then
        install -m 0644 ${B}/snapshot_blob.bin ${D}${libdir}/pdfium/snapshot_blob.bin
    fi

    install -d ${D}${includedir}
    cp -R ${S}/public/* ${D}${includedir}
}

FILES:${PN}-dev += "\
    ${libdir}/pdfium/LICENSE \
    ${includedir}/PRESUBMIT.py \
"