SUMMARY = "A DSP library for telephony"
DESCRIPTION = "\
    SpanDSP is a low-level signal processing library that modulates and \
    demodulates signals commonly used in telephony, such as the \"noise\" \
    generated by a fax modem or DTMF touchpad. \
"
HOMEPAGE = "https://www.soft-switch.org/"
BUGTRACKER = "https://github.com/freeswitch/spandsp/issues"
SECTION = "libs"
LICENSE = "LGPL-2.1-only"
LIC_FILES_CHKSUM = "file://COPYING;md5=8791c23ddf418deb5be264cffb5fa6bc"

DEPENDS = "\
    libxml2 \
    tiff \
    tiff-native \
"

PV = "3.0.0+git"

SRC_URI = "\
    git://github.com/freeswitch/spandsp.git;protocol=https;branch=master \
    file://configure.patch \
    file://makefile.patch \
"
# Fails to build with Clang since 5394b2cae6c482ccb835335b769469977e6802ae
# https://github.com/freeswitch/spandsp/issues/67
# https://lists.openembedded.org/g/openembedded-devel/message/109325
SRCREV = "df1282eb9af538ab1aadb6d66146e258451d4fe4"

S = "${WORKDIR}/git"

inherit autotools

PACKAGECONFIG ?= ""

PACKAGECONFIG[mmx] = "--enable-mmx,--disable-mmx"
PACKAGECONFIG[sse] = "--enable-sse,--disable-sse"
PACKAGECONFIG[sse2] = "--enable-sse2,--disable-sse2"
PACKAGECONFIG[sse3] = "--enable-sse3,--disable-sse3"
PACKAGECONFIG[ssse3] = "--enable-ssse3,--disable-ssse3"
PACKAGECONFIG[sse4-1] = "--enable-sse4-1,--disable-sse4-1"
PACKAGECONFIG[sse4-2] = "--enable-sse4-2,--disable-sse4-2"
PACKAGECONFIG[avx] = "--enable-avx,--disable-avx"
PACKAGECONFIG[avx2] = "--enable-avx2,--disable-avx2"
PACKAGECONFIG[neon] = "--enable-neon,--disable-neon"
PACKAGECONFIG[fixed-point] = "--enable-fixed-point,--disable-fixed-point"
PACKAGECONFIG[v32bis] = "--enable-v32bis,--disable-v32bis"
PACKAGECONFIG[v34] = "--enable-v34,--disable-v34"
PACKAGECONFIG[sslfax] = "--enable-sslfax,--disable-sslfax"
