//
// Copyright 2024 Toyota Connected North America
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Autogenerated from Pigeon (v22.7.4), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.g.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>
#include <utility>

namespace flatpak_plugin {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

FlutterError CreateConnectionError(const std::string& channel_name) {
  return FlutterError(
      "channel-error",
      "Unable to establish connection on channel: '" + channel_name + "'.",
      EncodableValue(""));
}

// Remote

Remote::Remote(std::string name,
               std::string url,
               std::string collection_id,
               std::string title,
               std::string comment,
               std::string description,
               std::string homepage,
               std::string icon,
               std::string default_branch,
               std::string main_ref,
               std::string remote_type,
               std::string filter,
               std::string appstream_timestamp,
               std::string appstream_dir,
               bool gpg_verify,
               bool no_enumerate,
               bool no_deps,
               bool disabled,
               int64_t prio)
    : name_(std::move(name)),
      url_(std::move(url)),
      collection_id_(std::move(collection_id)),
      title_(std::move(title)),
      comment_(std::move(comment)),
      description_(std::move(description)),
      homepage_(std::move(homepage)),
      icon_(std::move(icon)),
      default_branch_(std::move(default_branch)),
      main_ref_(std::move(main_ref)),
      remote_type_(std::move(remote_type)),
      filter_(std::move(filter)),
      appstream_timestamp_(std::move(appstream_timestamp)),
      appstream_dir_(std::move(appstream_dir)),
      gpg_verify_(gpg_verify),
      no_enumerate_(no_enumerate),
      no_deps_(no_deps),
      disabled_(disabled),
      prio_(prio) {}

const std::string& Remote::name() const {
  return name_;
}

void Remote::set_name(std::string_view value_arg) {
  name_ = value_arg;
}

const std::string& Remote::url() const {
  return url_;
}

void Remote::set_url(std::string_view value_arg) {
  url_ = value_arg;
}

const std::string& Remote::collection_id() const {
  return collection_id_;
}

void Remote::set_collection_id(std::string_view value_arg) {
  collection_id_ = value_arg;
}

const std::string& Remote::title() const {
  return title_;
}

void Remote::set_title(std::string_view value_arg) {
  title_ = value_arg;
}

const std::string& Remote::comment() const {
  return comment_;
}

void Remote::set_comment(std::string_view value_arg) {
  comment_ = value_arg;
}

const std::string& Remote::description() const {
  return description_;
}

void Remote::set_description(std::string_view value_arg) {
  description_ = value_arg;
}

const std::string& Remote::homepage() const {
  return homepage_;
}

void Remote::set_homepage(std::string_view value_arg) {
  homepage_ = value_arg;
}

const std::string& Remote::icon() const {
  return icon_;
}

void Remote::set_icon(std::string_view value_arg) {
  icon_ = value_arg;
}

const std::string& Remote::default_branch() const {
  return default_branch_;
}

void Remote::set_default_branch(std::string_view value_arg) {
  default_branch_ = value_arg;
}

const std::string& Remote::main_ref() const {
  return main_ref_;
}

void Remote::set_main_ref(std::string_view value_arg) {
  main_ref_ = value_arg;
}

const std::string& Remote::remote_type() const {
  return remote_type_;
}

void Remote::set_remote_type(std::string_view value_arg) {
  remote_type_ = value_arg;
}

const std::string& Remote::filter() const {
  return filter_;
}

void Remote::set_filter(std::string_view value_arg) {
  filter_ = value_arg;
}

const std::string& Remote::appstream_timestamp() const {
  return appstream_timestamp_;
}

void Remote::set_appstream_timestamp(std::string_view value_arg) {
  appstream_timestamp_ = value_arg;
}

const std::string& Remote::appstream_dir() const {
  return appstream_dir_;
}

void Remote::set_appstream_dir(std::string_view value_arg) {
  appstream_dir_ = value_arg;
}

bool Remote::gpg_verify() const {
  return gpg_verify_;
}

void Remote::set_gpg_verify(bool value_arg) {
  gpg_verify_ = value_arg;
}

bool Remote::no_enumerate() const {
  return no_enumerate_;
}

void Remote::set_no_enumerate(bool value_arg) {
  no_enumerate_ = value_arg;
}

bool Remote::no_deps() const {
  return no_deps_;
}

void Remote::set_no_deps(bool value_arg) {
  no_deps_ = value_arg;
}

bool Remote::disabled() const {
  return disabled_;
}

void Remote::set_disabled(bool value_arg) {
  disabled_ = value_arg;
}

int64_t Remote::prio() const {
  return prio_;
}

void Remote::set_prio(int64_t value_arg) {
  prio_ = value_arg;
}

EncodableList Remote::ToEncodableList() const {
  EncodableList list;
  list.reserve(19);
  list.emplace_back(name_);
  list.emplace_back(url_);
  list.emplace_back(collection_id_);
  list.emplace_back(title_);
  list.emplace_back(comment_);
  list.emplace_back(description_);
  list.emplace_back(homepage_);
  list.emplace_back(icon_);
  list.emplace_back(default_branch_);
  list.emplace_back(main_ref_);
  list.emplace_back(remote_type_);
  list.emplace_back(filter_);
  list.emplace_back(appstream_timestamp_);
  list.emplace_back(appstream_dir_);
  list.emplace_back(gpg_verify_);
  list.emplace_back(no_enumerate_);
  list.emplace_back(no_deps_);
  list.emplace_back(disabled_);
  list.emplace_back(prio_);
  return list;
}

Remote Remote::FromEncodableList(const EncodableList& list) {
  Remote decoded(std::get<std::string>(list[0]), std::get<std::string>(list[1]),
                 std::get<std::string>(list[2]), std::get<std::string>(list[3]),
                 std::get<std::string>(list[4]), std::get<std::string>(list[5]),
                 std::get<std::string>(list[6]), std::get<std::string>(list[7]),
                 std::get<std::string>(list[8]), std::get<std::string>(list[9]),
                 std::get<std::string>(list[10]),
                 std::get<std::string>(list[11]),
                 std::get<std::string>(list[12]),
                 std::get<std::string>(list[13]), std::get<bool>(list[14]),
                 std::get<bool>(list[15]), std::get<bool>(list[16]),
                 std::get<bool>(list[17]), std::get<int64_t>(list[18]));
  return decoded;
}

// Application

Application::Application(std::string name,
                         std::string id,
                         std::string summary,
                         std::string version,
                         std::string origin,
                         std::string license,
                         int64_t installed_size,
                         std::string deploy_dir,
                         bool is_current,
                         std::string content_rating_type,
                         EncodableMap content_rating,
                         std::string latest_commit,
                         std::string eol,
                         std::string eol_rebase,
                         EncodableList subpaths,
                         std::string metadata,
                         std::string appdata)
    : name_(std::move(name)),
      id_(std::move(id)),
      summary_(std::move(summary)),
      version_(std::move(version)),
      origin_(std::move(origin)),
      license_(std::move(license)),
      installed_size_(installed_size),
      deploy_dir_(std::move(deploy_dir)),
      is_current_(is_current),
      content_rating_type_(std::move(content_rating_type)),
      content_rating_(std::move(content_rating)),
      latest_commit_(std::move(latest_commit)),
      eol_(std::move(eol)),
      eol_rebase_(std::move(eol_rebase)),
      subpaths_(std::move(subpaths)),
      metadata_(std::move(metadata)),
      appdata_(std::move(appdata)) {}

const std::string& Application::name() const {
  return name_;
}

void Application::set_name(std::string_view value_arg) {
  name_ = value_arg;
}

const std::string& Application::id() const {
  return id_;
}

void Application::set_id(std::string_view value_arg) {
  id_ = value_arg;
}

const std::string& Application::summary() const {
  return summary_;
}

void Application::set_summary(std::string_view value_arg) {
  summary_ = value_arg;
}

const std::string& Application::version() const {
  return version_;
}

void Application::set_version(std::string_view value_arg) {
  version_ = value_arg;
}

const std::string& Application::origin() const {
  return origin_;
}

void Application::set_origin(std::string_view value_arg) {
  origin_ = value_arg;
}

const std::string& Application::license() const {
  return license_;
}

void Application::set_license(std::string_view value_arg) {
  license_ = value_arg;
}

int64_t Application::installed_size() const {
  return installed_size_;
}

void Application::set_installed_size(int64_t value_arg) {
  installed_size_ = value_arg;
}

const std::string& Application::deploy_dir() const {
  return deploy_dir_;
}

void Application::set_deploy_dir(std::string_view value_arg) {
  deploy_dir_ = value_arg;
}

bool Application::is_current() const {
  return is_current_;
}

void Application::set_is_current(bool value_arg) {
  is_current_ = value_arg;
}

const std::string& Application::content_rating_type() const {
  return content_rating_type_;
}

void Application::set_content_rating_type(std::string_view value_arg) {
  content_rating_type_ = value_arg;
}

const EncodableMap& Application::content_rating() const {
  return content_rating_;
}

void Application::set_content_rating(const EncodableMap& value_arg) {
  content_rating_ = value_arg;
}

const std::string& Application::latest_commit() const {
  return latest_commit_;
}

void Application::set_latest_commit(std::string_view value_arg) {
  latest_commit_ = value_arg;
}

const std::string& Application::eol() const {
  return eol_;
}

void Application::set_eol(std::string_view value_arg) {
  eol_ = value_arg;
}

const std::string& Application::eol_rebase() const {
  return eol_rebase_;
}

void Application::set_eol_rebase(std::string_view value_arg) {
  eol_rebase_ = value_arg;
}

const EncodableList& Application::subpaths() const {
  return subpaths_;
}

void Application::set_subpaths(const EncodableList& value_arg) {
  subpaths_ = value_arg;
}

const std::string& Application::metadata() const {
  return metadata_;
}

void Application::set_metadata(std::string_view value_arg) {
  metadata_ = value_arg;
}

const std::string& Application::appdata() const {
  return appdata_;
}

void Application::set_appdata(std::string_view value_arg) {
  appdata_ = value_arg;
}

EncodableList Application::ToEncodableList() const {
  EncodableList list;
  list.reserve(17);
  list.emplace_back(name_);
  list.emplace_back(id_);
  list.emplace_back(summary_);
  list.emplace_back(version_);
  list.emplace_back(origin_);
  list.emplace_back(license_);
  list.emplace_back(installed_size_);
  list.emplace_back(deploy_dir_);
  list.emplace_back(is_current_);
  list.emplace_back(content_rating_type_);
  list.emplace_back(content_rating_);
  list.emplace_back(latest_commit_);
  list.emplace_back(eol_);
  list.emplace_back(eol_rebase_);
  list.emplace_back(subpaths_);
  list.emplace_back(metadata_);
  list.emplace_back(appdata_);
  return list;
}

Application Application::FromEncodableList(const EncodableList& list) {
  Application decoded(
      std::get<std::string>(list[0]), std::get<std::string>(list[1]),
      std::get<std::string>(list[2]), std::get<std::string>(list[3]),
      std::get<std::string>(list[4]), std::get<std::string>(list[5]),
      std::get<int64_t>(list[6]), std::get<std::string>(list[7]),
      std::get<bool>(list[8]), std::get<std::string>(list[9]),
      std::get<EncodableMap>(list[10]), std::get<std::string>(list[11]),
      std::get<std::string>(list[12]), std::get<std::string>(list[13]),
      std::get<EncodableList>(list[14]), std::get<std::string>(list[15]),
      std::get<std::string>(list[16]));
  return decoded;
}

// Installation

Installation::Installation(std::string id,
                           std::string display_name,
                           std::string path,
                           bool no_interaction,
                           bool is_user,
                           int64_t priority,
                           EncodableList default_languages,
                           EncodableList default_locale,
                           EncodableList remotes)
    : id_(std::move(id)),
      display_name_(std::move(display_name)),
      path_(std::move(path)),
      no_interaction_(no_interaction),
      is_user_(is_user),
      priority_(priority),
      default_languages_(std::move(default_languages)),
      default_locale_(std::move(default_locale)),
      remotes_(std::move(remotes)) {}

const std::string& Installation::id() const {
  return id_;
}

void Installation::set_id(std::string_view value_arg) {
  id_ = value_arg;
}

const std::string& Installation::display_name() const {
  return display_name_;
}

void Installation::set_display_name(std::string_view value_arg) {
  display_name_ = value_arg;
}

const std::string& Installation::path() const {
  return path_;
}

void Installation::set_path(std::string_view value_arg) {
  path_ = value_arg;
}

bool Installation::no_interaction() const {
  return no_interaction_;
}

void Installation::set_no_interaction(bool value_arg) {
  no_interaction_ = value_arg;
}

bool Installation::is_user() const {
  return is_user_;
}

void Installation::set_is_user(bool value_arg) {
  is_user_ = value_arg;
}

int64_t Installation::priority() const {
  return priority_;
}

void Installation::set_priority(int64_t value_arg) {
  priority_ = value_arg;
}

const EncodableList& Installation::default_languages() const {
  return default_languages_;
}

void Installation::set_default_languages(const EncodableList& value_arg) {
  default_languages_ = value_arg;
}

const EncodableList& Installation::default_locale() const {
  return default_locale_;
}

void Installation::set_default_locale(const EncodableList& value_arg) {
  default_locale_ = value_arg;
}

const EncodableList& Installation::remotes() const {
  return remotes_;
}

void Installation::set_remotes(const EncodableList& value_arg) {
  remotes_ = value_arg;
}

EncodableList Installation::ToEncodableList() const {
  EncodableList list;
  list.reserve(9);
  list.reserve(9);
  list.emplace_back(id_);
  list.emplace_back(display_name_);
  list.emplace_back(path_);
  list.emplace_back(no_interaction_);
  list.emplace_back(is_user_);
  list.emplace_back(priority_);
  list.emplace_back(default_languages_);
  list.emplace_back(default_locale_);
  list.emplace_back(remotes_);
  return list;
}

Installation Installation::FromEncodableList(const EncodableList& list) {
  Installation decoded(
      std::get<std::string>(list[0]), std::get<std::string>(list[1]),
      std::get<std::string>(list[2]), std::get<bool>(list[3]),
      std::get<bool>(list[4]), std::get<int64_t>(list[5]),
      std::get<EncodableList>(list[6]), std::get<EncodableList>(list[7]),
      std::get<EncodableList>(list[8]));
  return decoded;
}

PigeonInternalCodecSerializer::PigeonInternalCodecSerializer() = default;

EncodableValue PigeonInternalCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 129: {
      return CustomEncodableValue(Remote::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    case 130: {
      return CustomEncodableValue(Application::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    case 131: {
      return CustomEncodableValue(Installation::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    }
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void PigeonInternalCodecSerializer::WriteValue(  // NOLINT(misc-no-recursion)
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(Remote)) {
      stream->WriteByte(129);
      WriteValue(EncodableValue(
                     std::any_cast<Remote>(*custom_value).ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(Application)) {
      stream->WriteByte(130);
      WriteValue(
          EncodableValue(
              std::any_cast<Application>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(Installation)) {
      stream->WriteByte(131);
      WriteValue(
          EncodableValue(
              std::any_cast<Installation>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by FlatpakApi.
const flutter::StandardMessageCodec& FlatpakApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &PigeonInternalCodecSerializer::GetInstance());
}

// Sets up an instance of `FlatpakApi` to handle messages through the
// `binary_messenger`.
void FlatpakApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                       FlatpakApi* api) {
  FlatpakApi::SetUp(binary_messenger, api, "");
}

void FlatpakApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                       FlatpakApi* api,
                       const std::string& message_channel_suffix) {
  const std::string prepended_suffix =
      !message_channel_suffix.empty()
          ? std::string(".") + message_channel_suffix
          : "";
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.getVersion" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& /* message */,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<std::string> output = api->GetVersion();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.getDefaultArch" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& /* message */,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<std::string> output = api->GetDefaultArch();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.getSupportedArches" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& /* message */,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<EncodableList> output = api->GetSupportedArches();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.getSystemInstallations" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& /* message */,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<EncodableList> output = api->GetSystemInstallations();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.getUserInstallation" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& /* message */,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<Installation> output = api->GetUserInstallation();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(
                  CustomEncodableValue(std::move(output).TakeValue()));
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.remoteAdd" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_configuration_arg = args.at(0);
              if (encodable_configuration_arg.IsNull()) {
                reply(WrapError("configuration_arg unexpectedly null."));
                return;
              }
              const auto& configuration_arg = std::any_cast<const Remote&>(
                  std::get<CustomEncodableValue>(encodable_configuration_arg));
              ErrorOr<bool> output = api->RemoteAdd(configuration_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.remoteRemove" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_id_arg = args.at(0);
              if (encodable_id_arg.IsNull()) {
                reply(WrapError("id_arg unexpectedly null."));
                return;
              }
              const auto& id_arg = std::get<std::string>(encodable_id_arg);
              ErrorOr<bool> output = api->RemoteRemove(id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(binary_messenger,
                                  "dev.flutter.pigeon.flatpak_flutter."
                                  "FlatpakApi.getApplicationsInstalled" +
                                      prepended_suffix,
                                  &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& /* message */,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<EncodableList> output = api->GetApplicationsInstalled();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.getApplicationsUpdate" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& /* message */,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              ErrorOr<EncodableList> output = api->GetApplicationsUpdate();
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.getApplicationsRemote" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_id_arg = args.at(0);
              if (encodable_id_arg.IsNull()) {
                reply(WrapError("id_arg unexpectedly null."));
                return;
              }
              const auto& id_arg = std::get<std::string>(encodable_id_arg);
              ErrorOr<EncodableList> output =
                  api->GetApplicationsRemote(id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.applicationInstall" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_id_arg = args.at(0);
              if (encodable_id_arg.IsNull()) {
                reply(WrapError("id_arg unexpectedly null."));
                return;
              }
              const auto& id_arg = std::get<std::string>(encodable_id_arg);
              api->ApplicationInstall(id_arg, [reply](ErrorOr<bool>&& output) {
                if (output.has_error()) {
                  reply(WrapError(output.error()));
                  return;
                }
                EncodableList wrapped;
                wrapped.emplace_back(std::move(output).TakeValue());
                reply(EncodableValue(std::move(wrapped)));
              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.applicationUninstall" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_id_arg = args.at(0);
              if (encodable_id_arg.IsNull()) {
                reply(WrapError("id_arg unexpectedly null."));
                return;
              }
              const auto& id_arg = std::get<std::string>(encodable_id_arg);
              api->ApplicationUninstall(
                  id_arg, [reply](ErrorOr<bool>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.applicationUpdate" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_id_arg = args.at(0);
              if (encodable_id_arg.IsNull()) {
                reply(WrapError("id_arg unexpectedly null."));
                return;
              }
              const auto& id_arg = std::get<std::string>(encodable_id_arg);
              api->ApplicationUpdate(id_arg, [reply](ErrorOr<bool>&& output) {
                if (output.has_error()) {
                  reply(WrapError(output.error()));
                  return;
                }
                EncodableList wrapped;
                wrapped.emplace_back(std::move(output).TakeValue());
                reply(EncodableValue(std::move(wrapped)));
              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.applicationStart" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_id_arg = args.at(0);
              if (encodable_id_arg.IsNull()) {
                reply(WrapError("id_arg unexpectedly null."));
                return;
              }
              const auto& id_arg = std::get<std::string>(encodable_id_arg);
              api->ApplicationStart(id_arg, [reply](ErrorOr<bool>&& output) {
                if (output.has_error()) {
                  reply(WrapError(output.error()));
                  return;
                }
                EncodableList wrapped;
                wrapped.emplace_back(std::move(output).TakeValue());
                reply(EncodableValue(std::move(wrapped)));
              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
  {
    BasicMessageChannel<> channel(
        binary_messenger,
        "dev.flutter.pigeon.flatpak_flutter.FlatpakApi.applicationStop" +
            prepended_suffix,
        &GetCodec());
    if (api != nullptr) {
      channel.SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_id_arg = args.at(0);
              if (encodable_id_arg.IsNull()) {
                reply(WrapError("id_arg unexpectedly null."));
                return;
              }
              const auto& id_arg = std::get<std::string>(encodable_id_arg);
              ErrorOr<bool> output = api->ApplicationStop(id_arg);
              if (output.has_error()) {
                reply(WrapError(output.error()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back(std::move(output).TakeValue());
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel.SetMessageHandler(nullptr);
    }
  }
}

EncodableValue FlatpakApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue FlatpakApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

}  // namespace flatpak_plugin
