// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v16.0.3), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#ifndef PIGEON_MESSAGES_H_
#define PIGEON_MESSAGES_H_
#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>

namespace video_player_linux {

// Generated class from Pigeon.

class FlutterError {
 public:
  explicit FlutterError(const std::string& code) : code_(code) {}
  explicit FlutterError(const std::string& code, const std::string& message)
      : code_(code), message_(message) {}
  explicit FlutterError(const std::string& code,
                        const std::string& message,
                        const flutter::EncodableValue& details)
      : code_(code), message_(message), details_(details) {}

  const std::string& code() const { return code_; }
  const std::string& message() const { return message_; }
  const flutter::EncodableValue& details() const { return details_; }

 private:
  std::string code_;
  std::string message_;
  flutter::EncodableValue details_;
};

template <class T>
class ErrorOr {
 public:
  ErrorOr(const T& rhs) : v_(rhs) {}
  ErrorOr(const T&& rhs) : v_(std::move(rhs)) {}
  ErrorOr(const FlutterError& rhs) : v_(rhs) {}
  ErrorOr(const FlutterError&& rhs) : v_(std::move(rhs)) {}

  bool has_error() const { return std::holds_alternative<FlutterError>(v_); }
  const T& value() const { return std::get<T>(v_); };
  const FlutterError& error() const { return std::get<FlutterError>(v_); };

 private:
  friend class VideoPlayerApi;
  ErrorOr() = default;
  T TakeValue() && { return std::get<T>(std::move(v_)); }

  std::variant<T, FlutterError> v_;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class VideoPlayerApi {
 public:
  VideoPlayerApi(const VideoPlayerApi&) = delete;
  VideoPlayerApi& operator=(const VideoPlayerApi&) = delete;
  virtual ~VideoPlayerApi() {}
  // Initializes the video player.
  virtual std::optional<FlutterError> Initialize() = 0;
  // Creates a new instance of the video player.
  // Returns the textureId of the created player.
  virtual ErrorOr<int64_t> Create(
      const std::string* asset,
      const std::string* uri,
      const flutter::EncodableMap& http_headers) = 0;
  // Disposes the video player with the given textureId.
  virtual std::optional<FlutterError> Dispose(int64_t texture_id) = 0;
  // Sets the looping state of the video player with the given textureId.
  virtual std::optional<FlutterError> SetLooping(int64_t texture_id,
                                                 bool is_looping) = 0;
  // Sets the volume of the video player with the given textureId.
  virtual std::optional<FlutterError> SetVolume(int64_t texture_id,
                                                double volume) = 0;
  // Sets the playback speed of the video player with the given textureId.
  virtual std::optional<FlutterError> SetPlaybackSpeed(int64_t texture_id,
                                                       double speed) = 0;
  // Starts playing the video in the video player with the given textureId.
  virtual std::optional<FlutterError> Play(int64_t texture_id) = 0;
  // Gets the current position of the video player with the given textureId.
  // Returns the position in milliseconds.
  virtual ErrorOr<int64_t> GetPosition(int64_t texture_id) = 0;
  // Seeks to the given position in the video player with the given textureId.
  // The position is in milliseconds.
  virtual std::optional<FlutterError> SeekTo(int64_t texture_id,
                                             int64_t position) = 0;
  // Pauses the video in the video player with the given textureId.
  virtual std::optional<FlutterError> Pause(int64_t texture_id) = 0;

  // The codec used by LinuxVideoPlayerApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `LinuxVideoPlayerApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    VideoPlayerApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  VideoPlayerApi() = default;
};
}  // namespace video_player_linux
#endif  // PIGEON_MESSAGES_H_
