/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.content.Context;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.android.AndroidTouchProcessor;
import io.flutter.embedding.android.FlutterView;
import io.flutter.embedding.android.MotionEventTracker;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.FlutterOverlaySurface;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorView;
import io.flutter.embedding.engine.mutatorsstack.FlutterMutatorsStack;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.systemchannels.PlatformViewCreationRequest;
import io.flutter.embedding.engine.systemchannels.PlatformViewTouch;
import io.flutter.embedding.engine.systemchannels.PlatformViewsChannel2;
import io.flutter.plugin.editing.TextInputPlugin;
import io.flutter.plugin.platform.AccessibilityEventsDelegate;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;
import io.flutter.plugin.platform.PlatformViewRegistry;
import io.flutter.plugin.platform.PlatformViewRegistryImpl;
import io.flutter.plugin.platform.PlatformViewsAccessibilityDelegate;
import io.flutter.plugin.platform.VirtualDisplayController;
import io.flutter.view.AccessibilityBridge;
import java.util.ArrayList;
import java.util.List;

public class PlatformViewsController2
implements PlatformViewsAccessibilityDelegate {
    private static final String TAG = "PlatformViewsController2";
    private PlatformViewRegistryImpl registry;
    private AndroidTouchProcessor androidTouchProcessor;
    private Context context;
    private FlutterView flutterView;
    private FlutterJNI flutterJNI = null;
    @Nullable
    private TextInputPlugin textInputPlugin;
    private PlatformViewsChannel2 platformViewsChannel;
    private final AccessibilityEventsDelegate accessibilityEventsDelegate;
    private final SparseArray<PlatformView> platformViews;
    private final SparseArray<FlutterMutatorView> platformViewParent;
    private final MotionEventTracker motionEventTracker;
    private final ArrayList<SurfaceControl.Transaction> pendingTransactions;
    private final ArrayList<SurfaceControl.Transaction> activeTransactions;
    private Surface overlayerSurface = null;
    private SurfaceControl overlaySurfaceControl = null;
    final PlatformViewsChannel2.PlatformViewsHandler channelHandler = new PlatformViewsChannel2.PlatformViewsHandler(){

        @Override
        public void createPlatformView(@NonNull PlatformViewCreationRequest request) {
            PlatformViewsController2.this.createFlutterPlatformView(request);
        }

        @Override
        public void dispose(int viewId) {
            View embeddedView;
            ViewGroup pvParent;
            PlatformView platformView = (PlatformView)PlatformViewsController2.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController2.TAG, "Disposing unknown platform view with id: " + viewId);
                return;
            }
            if (platformView.getView() != null && (pvParent = (ViewGroup)(embeddedView = platformView.getView()).getParent()) != null) {
                pvParent.removeView(embeddedView);
            }
            PlatformViewsController2.this.platformViews.remove(viewId);
            try {
                platformView.dispose();
            }
            catch (RuntimeException exception) {
                Log.e(PlatformViewsController2.TAG, "Disposing platform view threw an exception", exception);
            }
            FlutterMutatorView parentView = (FlutterMutatorView)((Object)PlatformViewsController2.this.platformViewParent.get(viewId));
            if (parentView != null) {
                parentView.removeAllViews();
                parentView.unsetOnDescendantFocusChangeListener();
                ViewGroup mutatorViewParent = (ViewGroup)parentView.getParent();
                if (mutatorViewParent != null) {
                    mutatorViewParent.removeView((View)parentView);
                }
                PlatformViewsController2.this.platformViewParent.remove(viewId);
            }
        }

        @Override
        public void onTouch(@NonNull PlatformViewTouch touch) {
            int viewId = touch.viewId;
            float density = ((PlatformViewsController2)PlatformViewsController2.this).context.getResources().getDisplayMetrics().density;
            PlatformView platformView = (PlatformView)PlatformViewsController2.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController2.TAG, "Sending touch to an unknown view with id: " + viewId);
                return;
            }
            View view = platformView.getView();
            if (view == null) {
                Log.e(PlatformViewsController2.TAG, "Sending touch to a null view with id: " + viewId);
                return;
            }
            MotionEvent event = PlatformViewsController2.this.toMotionEvent(density, touch);
            view.dispatchTouchEvent(event);
        }

        @Override
        public void setDirection(int viewId, int direction) {
            PlatformView platformView = (PlatformView)PlatformViewsController2.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController2.TAG, "Setting direction to an unknown view with id: " + viewId);
                return;
            }
            View embeddedView = platformView.getView();
            if (embeddedView == null) {
                Log.e(PlatformViewsController2.TAG, "Setting direction to a null view with id: " + viewId);
                return;
            }
            embeddedView.setLayoutDirection(direction);
        }

        @Override
        public void clearFocus(int viewId) {
            PlatformView platformView = (PlatformView)PlatformViewsController2.this.platformViews.get(viewId);
            if (platformView == null) {
                Log.e(PlatformViewsController2.TAG, "Clearing focus on an unknown view with id: " + viewId);
                return;
            }
            View embeddedView = platformView.getView();
            if (embeddedView == null) {
                Log.e(PlatformViewsController2.TAG, "Clearing focus on a null view with id: " + viewId);
                return;
            }
            embeddedView.clearFocus();
        }

        @Override
        public boolean isSurfaceControlEnabled() {
            return PlatformViewsController2.this.isHcppEnabled();
        }
    };

    public PlatformViewsController2() {
        this.accessibilityEventsDelegate = new AccessibilityEventsDelegate();
        this.platformViews = new SparseArray();
        this.platformViewParent = new SparseArray();
        this.pendingTransactions = new ArrayList();
        this.activeTransactions = new ArrayList();
        this.motionEventTracker = MotionEventTracker.getInstance();
    }

    public void setRegistry(@NonNull PlatformViewRegistry registry) {
        this.registry = (PlatformViewRegistryImpl)registry;
    }

    public void setFlutterJNI(FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
    }

    @Override
    public boolean usesVirtualDisplay(int id) {
        return false;
    }

    public PlatformView createFlutterPlatformView(@NonNull PlatformViewCreationRequest request) {
        PlatformView platformView;
        View embeddedView;
        PlatformViewFactory viewFactory = this.registry.getFactory(request.viewType);
        if (viewFactory == null) {
            throw new IllegalStateException("Trying to create a platform view of unregistered type: " + request.viewType);
        }
        Object createParams = null;
        if (request.params != null) {
            createParams = viewFactory.getCreateArgsCodec().decodeMessage(request.params);
        }
        if ((embeddedView = (platformView = viewFactory.create(this.context, request.viewId, createParams)).getView()) == null) {
            throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
        }
        embeddedView.setLayoutDirection(request.direction);
        this.platformViews.put(request.viewId, (Object)platformView);
        this.maybeInvokeOnFlutterViewAttached(platformView);
        return platformView;
    }

    private static void translateMotionEvent(MotionEvent originalEvent, MotionEvent.PointerCoords[] pointerCoords) {
        if (pointerCoords.length < 1) {
            return;
        }
        float xOffset = pointerCoords[0].x - originalEvent.getX();
        float yOffset = pointerCoords[0].y - originalEvent.getY();
        originalEvent.offsetLocation(xOffset, yOffset);
    }

    @VisibleForTesting
    public MotionEvent toMotionEvent(float density, PlatformViewTouch touch) {
        MotionEventTracker.MotionEventId motionEventId = MotionEventTracker.MotionEventId.from(touch.motionEventId);
        MotionEvent trackedEvent = this.motionEventTracker.pop(motionEventId);
        MotionEvent.PointerCoords[] pointerCoords = PlatformViewsController2.parsePointerCoordsList(touch.rawPointerCoords, density).toArray(new MotionEvent.PointerCoords[touch.pointerCount]);
        if (trackedEvent != null) {
            PlatformViewsController2.translateMotionEvent(trackedEvent, pointerCoords);
            return trackedEvent;
        }
        MotionEvent.PointerProperties[] pointerProperties = PlatformViewsController2.parsePointerPropertiesList(touch.rawPointerPropertiesList).toArray(new MotionEvent.PointerProperties[touch.pointerCount]);
        return MotionEvent.obtain((long)touch.downTime.longValue(), (long)touch.eventTime.longValue(), (int)touch.action, (int)touch.pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords, (int)touch.metaState, (int)touch.buttonState, (float)touch.xPrecision, (float)touch.yPrecision, (int)touch.deviceId, (int)touch.edgeFlags, (int)touch.source, (int)touch.flags);
    }

    public void attach(@Nullable Context context, @NonNull DartExecutor dartExecutor) {
        if (this.context != null) {
            throw new AssertionError((Object)"A PlatformViewsController can only be attached to a single output target.\nattach was called while the PlatformViewsController was already attached.");
        }
        this.context = context;
        this.platformViewsChannel = new PlatformViewsChannel2(dartExecutor);
        this.platformViewsChannel.setPlatformViewsHandler(this.channelHandler);
    }

    @UiThread
    public void detach() {
        if (this.platformViewsChannel != null) {
            this.platformViewsChannel.setPlatformViewsHandler(null);
        }
        this.destroyOverlaySurface();
        this.platformViewsChannel = null;
        this.context = null;
    }

    public void attachToView(@NonNull FlutterView newFlutterView) {
        Object view;
        int index;
        this.flutterView = newFlutterView;
        for (index = 0; index < this.platformViewParent.size(); ++index) {
            view = (FlutterMutatorView)((Object)this.platformViewParent.valueAt(index));
            this.flutterView.addView((View)view);
        }
        for (index = 0; index < this.platformViews.size(); ++index) {
            view = (PlatformView)this.platformViews.valueAt(index);
            view.onFlutterViewAttached((View)this.flutterView);
        }
    }

    public void detachFromView() {
        Object view;
        int index;
        for (index = 0; index < this.platformViewParent.size(); ++index) {
            view = (FlutterMutatorView)((Object)this.platformViewParent.valueAt(index));
            this.flutterView.removeView((View)view);
        }
        this.destroyOverlaySurface();
        this.flutterView = null;
        for (index = 0; index < this.platformViews.size(); ++index) {
            view = (PlatformView)this.platformViews.valueAt(index);
            view.onFlutterViewDetached();
        }
    }

    private void maybeInvokeOnFlutterViewAttached(PlatformView view) {
        if (this.flutterView == null) {
            Log.i(TAG, "null flutterView");
            return;
        }
        view.onFlutterViewAttached((View)this.flutterView);
    }

    @Override
    public void attachAccessibilityBridge(@NonNull AccessibilityBridge accessibilityBridge) {
        this.accessibilityEventsDelegate.setAccessibilityBridge(accessibilityBridge);
    }

    @Override
    public void detachAccessibilityBridge() {
        this.accessibilityEventsDelegate.setAccessibilityBridge(null);
    }

    public void attachTextInputPlugin(@NonNull TextInputPlugin textInputPlugin) {
        this.textInputPlugin = textInputPlugin;
    }

    public void detachTextInputPlugin() {
        this.textInputPlugin = null;
    }

    public PlatformViewRegistry getRegistry() {
        return this.registry;
    }

    public void onDetachedFromJNI() {
        this.diposeAllViews();
    }

    public void onPreEngineRestart() {
        this.diposeAllViews();
    }

    @Override
    @Nullable
    public View getPlatformViewById(int viewId) {
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            return null;
        }
        return platformView.getView();
    }

    private void lockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.lockPlatformViewInputConnection();
        controller.onInputConnectionLocked();
    }

    private void unlockInputConnection(@NonNull VirtualDisplayController controller) {
        if (this.textInputPlugin == null) {
            return;
        }
        this.textInputPlugin.unlockPlatformViewInputConnection();
        controller.onInputConnectionUnlocked();
    }

    private static boolean validateDirection(int direction) {
        return direction == 0 || direction == 1;
    }

    private static List<MotionEvent.PointerProperties> parsePointerPropertiesList(Object rawPropertiesList) {
        List rawProperties = (List)rawPropertiesList;
        ArrayList<MotionEvent.PointerProperties> pointerProperties = new ArrayList<MotionEvent.PointerProperties>();
        for (Object o : rawProperties) {
            pointerProperties.add(PlatformViewsController2.parsePointerProperties(o));
        }
        return pointerProperties;
    }

    private static MotionEvent.PointerProperties parsePointerProperties(Object rawProperties) {
        List propertiesList = (List)rawProperties;
        MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
        properties.id = (Integer)propertiesList.get(0);
        properties.toolType = (Integer)propertiesList.get(1);
        return properties;
    }

    private static List<MotionEvent.PointerCoords> parsePointerCoordsList(Object rawCoordsList, float density) {
        List rawCoords = (List)rawCoordsList;
        ArrayList<MotionEvent.PointerCoords> pointerCoords = new ArrayList<MotionEvent.PointerCoords>();
        for (Object o : rawCoords) {
            pointerCoords.add(PlatformViewsController2.parsePointerCoords(o, density));
        }
        return pointerCoords;
    }

    private static MotionEvent.PointerCoords parsePointerCoords(Object rawCoords, float density) {
        List coordsList = (List)rawCoords;
        MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
        coords.orientation = (float)((Double)coordsList.get(0)).doubleValue();
        coords.pressure = (float)((Double)coordsList.get(1)).doubleValue();
        coords.size = (float)((Double)coordsList.get(2)).doubleValue();
        coords.toolMajor = (float)((Double)coordsList.get(3) * (double)density);
        coords.toolMinor = (float)((Double)coordsList.get(4) * (double)density);
        coords.touchMajor = (float)((Double)coordsList.get(5) * (double)density);
        coords.touchMinor = (float)((Double)coordsList.get(6) * (double)density);
        coords.x = (float)((Double)coordsList.get(7) * (double)density);
        coords.y = (float)((Double)coordsList.get(8) * (double)density);
        return coords;
    }

    private float getDisplayDensity() {
        return this.context.getResources().getDisplayMetrics().density;
    }

    private int toPhysicalPixels(double logicalPixels) {
        return (int)Math.round(logicalPixels * (double)this.getDisplayDensity());
    }

    private int toLogicalPixels(double physicalPixels, float displayDensity) {
        return (int)Math.round(physicalPixels / (double)displayDensity);
    }

    private int toLogicalPixels(double physicalPixels) {
        return this.toLogicalPixels(physicalPixels, this.getDisplayDensity());
    }

    private void diposeAllViews() {
        while (this.platformViews.size() > 0) {
            int viewId = this.platformViews.keyAt(0);
            this.channelHandler.dispose(viewId);
        }
    }

    @VisibleForTesting
    public void disposePlatformView(int viewId) {
        this.channelHandler.dispose(viewId);
    }

    @VisibleForTesting
    boolean initializePlatformViewIfNeeded(int viewId) {
        PlatformView platformView = (PlatformView)this.platformViews.get(viewId);
        if (platformView == null) {
            return false;
        }
        if (this.platformViewParent.get(viewId) != null) {
            return true;
        }
        View embeddedView = platformView.getView();
        if (embeddedView == null) {
            throw new IllegalStateException("PlatformView#getView() returned null, but an Android view reference was expected.");
        }
        if (embeddedView.getParent() != null) {
            throw new IllegalStateException("The Android view returned from PlatformView#getView() was already added to a parent view.");
        }
        FlutterMutatorView parentView = new FlutterMutatorView(this.context, this.context.getResources().getDisplayMetrics().density, this.androidTouchProcessor);
        parentView.setOnDescendantFocusChangeListener((view, hasFocus) -> {
            if (hasFocus) {
                this.platformViewsChannel.invokeViewFocused(viewId);
            } else if (this.textInputPlugin != null) {
                this.textInputPlugin.clearPlatformViewClient(viewId);
            }
        });
        this.platformViewParent.put(viewId, (Object)parentView);
        embeddedView.setImportantForAccessibility(4);
        parentView.addView(embeddedView);
        this.flutterView.addView((View)parentView);
        return true;
    }

    public void attachToFlutterRenderer(@NonNull FlutterRenderer flutterRenderer) {
        this.androidTouchProcessor = new AndroidTouchProcessor(flutterRenderer, true);
    }

    public void onDisplayPlatformView(int viewId, int x, int y, int width, int height, int viewWidth, int viewHeight, @NonNull FlutterMutatorsStack mutatorsStack) {
        if (!this.initializePlatformViewIfNeeded(viewId)) {
            return;
        }
        FlutterMutatorView parentView = (FlutterMutatorView)((Object)this.platformViewParent.get(viewId));
        parentView.readyToDisplay(mutatorsStack, x, y, width, height);
        parentView.setVisibility(0);
        parentView.bringToFront();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(viewWidth, viewHeight);
        View view = ((PlatformView)this.platformViews.get(viewId)).getView();
        if (view != null) {
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            view.bringToFront();
        }
    }

    @RequiresApi(value=34)
    public void onEndFrame() {
        SurfaceControl.Transaction tx = new SurfaceControl.Transaction();
        for (int i = 0; i < this.activeTransactions.size(); ++i) {
            tx = tx.merge(this.activeTransactions.get(i));
        }
        this.activeTransactions.clear();
        this.flutterView.invalidate();
        this.flutterView.getRootSurfaceControl().applyTransactionOnDraw(tx);
    }

    public synchronized void swapTransactions() {
        this.activeTransactions.clear();
        for (int i = 0; i < this.pendingTransactions.size(); ++i) {
            this.activeTransactions.add(this.pendingTransactions.get(i));
        }
        this.pendingTransactions.clear();
    }

    @RequiresApi(value=34)
    public SurfaceControl.Transaction createTransaction() {
        SurfaceControl.Transaction tx = new SurfaceControl.Transaction();
        this.pendingTransactions.add(tx);
        return tx;
    }

    @RequiresApi(value=34)
    public void applyTransactions() {
        SurfaceControl.Transaction tx = new SurfaceControl.Transaction();
        for (int i = 0; i < this.pendingTransactions.size(); ++i) {
            tx = tx.merge(this.pendingTransactions.get(i));
        }
        tx.apply();
        this.pendingTransactions.clear();
    }

    @RequiresApi(value=34)
    public FlutterOverlaySurface createOverlaySurface() {
        if (this.overlayerSurface == null) {
            SurfaceControl.Builder surfaceControlBuilder = new SurfaceControl.Builder();
            surfaceControlBuilder.setBufferSize(this.flutterView.getWidth(), this.flutterView.getHeight());
            surfaceControlBuilder.setFormat(1);
            surfaceControlBuilder.setName("Flutter Overlay Surface");
            surfaceControlBuilder.setOpaque(false);
            surfaceControlBuilder.setHidden(false);
            SurfaceControl surfaceControl = surfaceControlBuilder.build();
            SurfaceControl.Transaction tx = this.flutterView.getRootSurfaceControl().buildReparentTransaction(surfaceControl);
            tx.setLayer(surfaceControl, 1000);
            tx.apply();
            this.overlayerSurface = new Surface(surfaceControl);
            this.overlaySurfaceControl = surfaceControl;
        }
        return new FlutterOverlaySurface(0, this.overlayerSurface);
    }

    public void destroyOverlaySurface() {
        if (this.overlayerSurface != null) {
            this.overlayerSurface.release();
            this.overlayerSurface = null;
            this.overlaySurfaceControl = null;
        }
    }

    @RequiresApi(value=34)
    public void showOverlaySurface() {
        if (this.overlaySurfaceControl == null) {
            return;
        }
        SurfaceControl.Transaction tx = new SurfaceControl.Transaction();
        tx.setVisibility(this.overlaySurfaceControl, true);
        tx.apply();
    }

    @RequiresApi(value=34)
    public void hideOverlaySurface() {
        if (this.overlaySurfaceControl == null) {
            return;
        }
        SurfaceControl.Transaction tx = new SurfaceControl.Transaction();
        tx.setVisibility(this.overlaySurfaceControl, false);
        tx.apply();
    }

    public boolean isHcppEnabled() {
        if (this.flutterJNI == null) {
            return false;
        }
        return this.flutterJNI.IsSurfaceControlEnabled();
    }
}

