/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.window.BackEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BackGestureChannel {
    private static final String TAG = "BackGestureChannel";
    @NonNull
    public final MethodChannel channel;
    private final MethodChannel.MethodCallHandler defaultHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            result.success(null);
        }
    };

    public BackGestureChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/backgesture", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.defaultHandler);
    }

    @RequiresApi(value=34)
    public void startBackGesture(@NonNull BackEvent backEvent) {
        Log.v(TAG, "Sending message to start back gesture");
        this.channel.invokeMethod("startBackGesture", this.backEventToJsonMap(backEvent));
    }

    @RequiresApi(value=34)
    public void updateBackGestureProgress(@NonNull BackEvent backEvent) {
        Log.v(TAG, "Sending message to update back gesture progress");
        this.channel.invokeMethod("updateBackGestureProgress", this.backEventToJsonMap(backEvent));
    }

    @RequiresApi(value=34)
    public void commitBackGesture() {
        Log.v(TAG, "Sending message to commit back gesture");
        this.channel.invokeMethod("commitBackGesture", null);
    }

    @RequiresApi(value=34)
    public void cancelBackGesture() {
        Log.v(TAG, "Sending message to cancel back gesture");
        this.channel.invokeMethod("cancelBackGesture", null);
    }

    public void setMethodCallHandler(@Nullable MethodChannel.MethodCallHandler handler) {
        this.channel.setMethodCallHandler(handler);
    }

    @RequiresApi(value=34)
    private Map<String, Object> backEventToJsonMap(@NonNull BackEvent backEvent) {
        HashMap<String, Object> message = new HashMap<String, Object>(3);
        float x = backEvent.getTouchX();
        float y = backEvent.getTouchY();
        List<Float> touchOffset = Float.isNaN(x) || Float.isNaN(y) ? null : Arrays.asList(Float.valueOf(x), Float.valueOf(y));
        message.put("touchOffset", touchOffset);
        message.put("progress", Float.valueOf(backEvent.getProgress()));
        message.put("swipeEdge", backEvent.getSwipeEdge());
        return message;
    }
}

