.TH grap2graph @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grap2graph \- convert a
.I grap
diagram into a cropped image
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" This documentation is released to the public domain.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grap2graph_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY grap2graph
.RB [ \-unsafe ]
.RB [ \-format\~\c
.IR output-format ]
.RI [ convert-argument \~.\|.\|.]
.YS
.
.
.SY grap2graph
.B \-\-help
.YS
.
.
.SY grap2graph
.B \-v
.
.SY grap2graph
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I grap2graph
reads a
.MR grap 1
program from the standard input and writes an image file,
by default in Portable Network Graphics (PNG) format,
to the standard output.
.
.
.PP
The input GRAP code should
.I not
be wrapped with the
.B .G1
and
.B .G2
macros that normally guard it within
.MR groff @MAN1EXT@
documents.
.
.
.\" FIXME: How old?  This text hasn't been touched since 2008 at latest.
.\" Older versions of
.\" .I \%convert
.\" will produce a black-on-white graphic; newer ones may produce a
.\" black-on-transparent graphic.
.
.PP
Arguments not recognized by
.I grap2graph
are passed to the ImageMagick or GraphicsMagick program
.MR convert 1 .
.
.
By specifying these, you can give your image a border,
.\" Transparent backgrounds are the default in 2018.
.\" force the background transparent,
set the image's pixel density,
or perform other useful transformations.
.
.
.PP
The output image is clipped using
.IR \%convert 's
.B \-trim
option to the smallest possible bounding box that contains all the black
pixels.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-format\~ output-format
Write the image in
.IR output-format ,
which must be understood by
.IR \%convert ;
the default is PNG.
.
.
.TP
.B \-unsafe
Run
.I groff
in
.I unsafe
mode, enabling the PIC command
.B sh
to execute arbitrary Unix shell commands.
.
The
.I groff
default is to forbid this.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I \%GROFF_TMPDIR
.TQ
.I \%TMPDIR
.TQ
.I TMP
.TQ
.I TEMP
These environment variables are searched in the given order to determine
the directory where temporary files will be created.
.
If none are set,
.I /tmp
is used.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I grap2graph
was written by
.MT esr@\:thyrsus\:.com
Eric S.\& Raymond
.ME ,
based on a recipe for
.MR pic2graph @MAN1EXT@ ,
by W.\& Richard Stevens.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR pic2graph @MAN1EXT@ ,
.MR eqn2graph @MAN1EXT@ ,
.MR grap 1 ,
.MR @g@pic @MAN1EXT@ ,
.MR groff @MAN1EXT@ ,
.MR convert 1
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grap2graph_1_man_C]
.do rr *groff_grap2graph_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
