from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class DataType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    STRING: _ClassVar[DataType]
    BOOL: _ClassVar[DataType]
    INT8: _ClassVar[DataType]
    INT16: _ClassVar[DataType]
    INT32: _ClassVar[DataType]
    INT64: _ClassVar[DataType]
    UINT8: _ClassVar[DataType]
    UINT16: _ClassVar[DataType]
    UINT32: _ClassVar[DataType]
    UINT64: _ClassVar[DataType]
    FLOAT: _ClassVar[DataType]
    DOUBLE: _ClassVar[DataType]
    STRING_ARRAY: _ClassVar[DataType]
    BOOL_ARRAY: _ClassVar[DataType]
    INT8_ARRAY: _ClassVar[DataType]
    INT16_ARRAY: _ClassVar[DataType]
    INT32_ARRAY: _ClassVar[DataType]
    INT64_ARRAY: _ClassVar[DataType]
    UINT8_ARRAY: _ClassVar[DataType]
    UINT16_ARRAY: _ClassVar[DataType]
    UINT32_ARRAY: _ClassVar[DataType]
    UINT64_ARRAY: _ClassVar[DataType]
    FLOAT_ARRAY: _ClassVar[DataType]
    DOUBLE_ARRAY: _ClassVar[DataType]

class DatapointError(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    UNKNOWN_DATAPOINT: _ClassVar[DatapointError]
    INVALID_TYPE: _ClassVar[DatapointError]
    ACCESS_DENIED: _ClassVar[DatapointError]
    INTERNAL_ERROR: _ClassVar[DatapointError]
    OUT_OF_BOUNDS: _ClassVar[DatapointError]

class EntryType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    ENTRY_TYPE_UNSPECIFIED: _ClassVar[EntryType]
    ENTRY_TYPE_SENSOR: _ClassVar[EntryType]
    ENTRY_TYPE_ACTUATOR: _ClassVar[EntryType]
    ENTRY_TYPE_ATTRIBUTE: _ClassVar[EntryType]

class ChangeType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    STATIC: _ClassVar[ChangeType]
    ON_CHANGE: _ClassVar[ChangeType]
    CONTINUOUS: _ClassVar[ChangeType]
STRING: DataType
BOOL: DataType
INT8: DataType
INT16: DataType
INT32: DataType
INT64: DataType
UINT8: DataType
UINT16: DataType
UINT32: DataType
UINT64: DataType
FLOAT: DataType
DOUBLE: DataType
STRING_ARRAY: DataType
BOOL_ARRAY: DataType
INT8_ARRAY: DataType
INT16_ARRAY: DataType
INT32_ARRAY: DataType
INT64_ARRAY: DataType
UINT8_ARRAY: DataType
UINT16_ARRAY: DataType
UINT32_ARRAY: DataType
UINT64_ARRAY: DataType
FLOAT_ARRAY: DataType
DOUBLE_ARRAY: DataType
UNKNOWN_DATAPOINT: DatapointError
INVALID_TYPE: DatapointError
ACCESS_DENIED: DatapointError
INTERNAL_ERROR: DatapointError
OUT_OF_BOUNDS: DatapointError
ENTRY_TYPE_UNSPECIFIED: EntryType
ENTRY_TYPE_SENSOR: EntryType
ENTRY_TYPE_ACTUATOR: EntryType
ENTRY_TYPE_ATTRIBUTE: EntryType
STATIC: ChangeType
ON_CHANGE: ChangeType
CONTINUOUS: ChangeType

class StringArray(_message.Message):
    __slots__ = ("values",)
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, values: _Optional[_Iterable[str]] = ...) -> None: ...

class BoolArray(_message.Message):
    __slots__ = ("values",)
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[bool]
    def __init__(self, values: _Optional[_Iterable[bool]] = ...) -> None: ...

class Int32Array(_message.Message):
    __slots__ = ("values",)
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[int]
    def __init__(self, values: _Optional[_Iterable[int]] = ...) -> None: ...

class Int64Array(_message.Message):
    __slots__ = ("values",)
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[int]
    def __init__(self, values: _Optional[_Iterable[int]] = ...) -> None: ...

class Uint32Array(_message.Message):
    __slots__ = ("values",)
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[int]
    def __init__(self, values: _Optional[_Iterable[int]] = ...) -> None: ...

class Uint64Array(_message.Message):
    __slots__ = ("values",)
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[int]
    def __init__(self, values: _Optional[_Iterable[int]] = ...) -> None: ...

class FloatArray(_message.Message):
    __slots__ = ("values",)
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[float]
    def __init__(self, values: _Optional[_Iterable[float]] = ...) -> None: ...

class DoubleArray(_message.Message):
    __slots__ = ("values",)
    VALUES_FIELD_NUMBER: _ClassVar[int]
    values: _containers.RepeatedScalarFieldContainer[float]
    def __init__(self, values: _Optional[_Iterable[float]] = ...) -> None: ...

class Datapoint(_message.Message):
    __slots__ = ("timestamp", "failure_value", "string_value", "bool_value", "int32_value", "int64_value", "uint32_value", "uint64_value", "float_value", "double_value", "string_array", "bool_array", "int32_array", "int64_array", "uint32_array", "uint64_array", "float_array", "double_array")
    class Failure(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        INVALID_VALUE: _ClassVar[Datapoint.Failure]
        NOT_AVAILABLE: _ClassVar[Datapoint.Failure]
        UNKNOWN_DATAPOINT: _ClassVar[Datapoint.Failure]
        ACCESS_DENIED: _ClassVar[Datapoint.Failure]
        INTERNAL_ERROR: _ClassVar[Datapoint.Failure]
    INVALID_VALUE: Datapoint.Failure
    NOT_AVAILABLE: Datapoint.Failure
    UNKNOWN_DATAPOINT: Datapoint.Failure
    ACCESS_DENIED: Datapoint.Failure
    INTERNAL_ERROR: Datapoint.Failure
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    FAILURE_VALUE_FIELD_NUMBER: _ClassVar[int]
    STRING_VALUE_FIELD_NUMBER: _ClassVar[int]
    BOOL_VALUE_FIELD_NUMBER: _ClassVar[int]
    INT32_VALUE_FIELD_NUMBER: _ClassVar[int]
    INT64_VALUE_FIELD_NUMBER: _ClassVar[int]
    UINT32_VALUE_FIELD_NUMBER: _ClassVar[int]
    UINT64_VALUE_FIELD_NUMBER: _ClassVar[int]
    FLOAT_VALUE_FIELD_NUMBER: _ClassVar[int]
    DOUBLE_VALUE_FIELD_NUMBER: _ClassVar[int]
    STRING_ARRAY_FIELD_NUMBER: _ClassVar[int]
    BOOL_ARRAY_FIELD_NUMBER: _ClassVar[int]
    INT32_ARRAY_FIELD_NUMBER: _ClassVar[int]
    INT64_ARRAY_FIELD_NUMBER: _ClassVar[int]
    UINT32_ARRAY_FIELD_NUMBER: _ClassVar[int]
    UINT64_ARRAY_FIELD_NUMBER: _ClassVar[int]
    FLOAT_ARRAY_FIELD_NUMBER: _ClassVar[int]
    DOUBLE_ARRAY_FIELD_NUMBER: _ClassVar[int]
    timestamp: _timestamp_pb2.Timestamp
    failure_value: Datapoint.Failure
    string_value: str
    bool_value: bool
    int32_value: int
    int64_value: int
    uint32_value: int
    uint64_value: int
    float_value: float
    double_value: float
    string_array: StringArray
    bool_array: BoolArray
    int32_array: Int32Array
    int64_array: Int64Array
    uint32_array: Uint32Array
    uint64_array: Uint64Array
    float_array: FloatArray
    double_array: DoubleArray
    def __init__(self, timestamp: _Optional[_Union[_timestamp_pb2.Timestamp, _Mapping]] = ..., failure_value: _Optional[_Union[Datapoint.Failure, str]] = ..., string_value: _Optional[str] = ..., bool_value: bool = ..., int32_value: _Optional[int] = ..., int64_value: _Optional[int] = ..., uint32_value: _Optional[int] = ..., uint64_value: _Optional[int] = ..., float_value: _Optional[float] = ..., double_value: _Optional[float] = ..., string_array: _Optional[_Union[StringArray, _Mapping]] = ..., bool_array: _Optional[_Union[BoolArray, _Mapping]] = ..., int32_array: _Optional[_Union[Int32Array, _Mapping]] = ..., int64_array: _Optional[_Union[Int64Array, _Mapping]] = ..., uint32_array: _Optional[_Union[Uint32Array, _Mapping]] = ..., uint64_array: _Optional[_Union[Uint64Array, _Mapping]] = ..., float_array: _Optional[_Union[FloatArray, _Mapping]] = ..., double_array: _Optional[_Union[DoubleArray, _Mapping]] = ...) -> None: ...

class Metadata(_message.Message):
    __slots__ = ("id", "entry_type", "name", "data_type", "change_type", "description", "allowed", "min", "max")
    ID_FIELD_NUMBER: _ClassVar[int]
    ENTRY_TYPE_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DATA_TYPE_FIELD_NUMBER: _ClassVar[int]
    CHANGE_TYPE_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    ALLOWED_FIELD_NUMBER: _ClassVar[int]
    MIN_FIELD_NUMBER: _ClassVar[int]
    MAX_FIELD_NUMBER: _ClassVar[int]
    id: int
    entry_type: EntryType
    name: str
    data_type: DataType
    change_type: ChangeType
    description: str
    allowed: Allowed
    min: ValueRestriction
    max: ValueRestriction
    def __init__(self, id: _Optional[int] = ..., entry_type: _Optional[_Union[EntryType, str]] = ..., name: _Optional[str] = ..., data_type: _Optional[_Union[DataType, str]] = ..., change_type: _Optional[_Union[ChangeType, str]] = ..., description: _Optional[str] = ..., allowed: _Optional[_Union[Allowed, _Mapping]] = ..., min: _Optional[_Union[ValueRestriction, _Mapping]] = ..., max: _Optional[_Union[ValueRestriction, _Mapping]] = ...) -> None: ...

class Allowed(_message.Message):
    __slots__ = ("string_values", "int32_values", "int64_values", "uint32_values", "uint64_values", "float_values", "double_values")
    STRING_VALUES_FIELD_NUMBER: _ClassVar[int]
    INT32_VALUES_FIELD_NUMBER: _ClassVar[int]
    INT64_VALUES_FIELD_NUMBER: _ClassVar[int]
    UINT32_VALUES_FIELD_NUMBER: _ClassVar[int]
    UINT64_VALUES_FIELD_NUMBER: _ClassVar[int]
    FLOAT_VALUES_FIELD_NUMBER: _ClassVar[int]
    DOUBLE_VALUES_FIELD_NUMBER: _ClassVar[int]
    string_values: StringArray
    int32_values: Int32Array
    int64_values: Int64Array
    uint32_values: Uint32Array
    uint64_values: Uint64Array
    float_values: FloatArray
    double_values: DoubleArray
    def __init__(self, string_values: _Optional[_Union[StringArray, _Mapping]] = ..., int32_values: _Optional[_Union[Int32Array, _Mapping]] = ..., int64_values: _Optional[_Union[Int64Array, _Mapping]] = ..., uint32_values: _Optional[_Union[Uint32Array, _Mapping]] = ..., uint64_values: _Optional[_Union[Uint64Array, _Mapping]] = ..., float_values: _Optional[_Union[FloatArray, _Mapping]] = ..., double_values: _Optional[_Union[DoubleArray, _Mapping]] = ...) -> None: ...

class ValueRestriction(_message.Message):
    __slots__ = ("string", "bool", "int32", "int64", "uint32", "uint64", "float", "double")
    STRING_FIELD_NUMBER: _ClassVar[int]
    BOOL_FIELD_NUMBER: _ClassVar[int]
    INT32_FIELD_NUMBER: _ClassVar[int]
    INT64_FIELD_NUMBER: _ClassVar[int]
    UINT32_FIELD_NUMBER: _ClassVar[int]
    UINT64_FIELD_NUMBER: _ClassVar[int]
    FLOAT_FIELD_NUMBER: _ClassVar[int]
    DOUBLE_FIELD_NUMBER: _ClassVar[int]
    string: str
    bool: bool
    int32: int
    int64: int
    uint32: int
    uint64: int
    float: float
    double: float
    def __init__(self, string: _Optional[str] = ..., bool: bool = ..., int32: _Optional[int] = ..., int64: _Optional[int] = ..., uint32: _Optional[int] = ..., uint64: _Optional[int] = ..., float: _Optional[float] = ..., double: _Optional[float] = ...) -> None: ...
