/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 29 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "sourcescanner.h"
#include "scannerparser.h"

#ifdef G_OS_WIN32
#include <io.h>
#endif

extern FILE *yyin;
extern int lineno;
extern char linebuf[2000];
extern char *yytext;

extern int yylex (GISourceScanner *scanner);
static void yyerror (GISourceScanner *scanner, const char *str);

extern void ctype_free (GISourceType * type);

static int last_enum_value = -1;
static gboolean is_bitfield;

/**
 * parse_c_string_literal:
 * @str: A string containing a C string literal
 *
 * Based on g_strcompress(), but also handles
 * hexadecimal escapes.
 */
static char *
parse_c_string_literal (const char *str)
{
  const gchar *p = str, *num;
  gchar *dest = g_malloc (strlen (str) + 1);
  gchar *q = dest;

  while (*p)
    {
      if (*p == '\\')
        {
          p++;
          switch (*p)
            {
            case '\0':
              g_warning ("parse_c_string_literal: trailing \\");
              goto out;
            case '0':  case '1':  case '2':  case '3':  case '4':
            case '5':  case '6':  case '7':
              *q = 0;
              num = p;
              while ((p < num + 3) && (*p >= '0') && (*p <= '7'))
                {
                  *q = (*q * 8) + (*p - '0');
                  p++;
                }
              q++;
              p--;
              break;
	    case 'x':
	      *q = 0;
	      p++;
	      num = p;
	      while ((p < num + 2) && (g_ascii_isxdigit(*p)))
		{
		  *q = (*q * 16) + g_ascii_xdigit_value(*p);
		  p++;
		}
              q++;
              p--;
	      break;
            case 'b':
              *q++ = '\b';
              break;
            case 'f':
              *q++ = '\f';
              break;
            case 'n':
              *q++ = '\n';
              break;
            case 'r':
              *q++ = '\r';
              break;
            case 't':
              *q++ = '\t';
              break;
            default:            /* Also handles \" and \\ */
              *q++ = *p;
              break;
            }
        }
      else
        *q++ = *p;
      p++;
    }
out:
  *q = 0;

  return dest;
}

enum {
  IRRELEVANT = 1,
  NOT_GI_SCANNER = 2,
  FOR_GI_SCANNER = 3,
};

static void
update_skipping (GISourceScanner *scanner)
{
  GList *l;
  for (l = scanner->conditionals.head; l != NULL; l = g_list_next (l))
    {
      if (GPOINTER_TO_INT (l->data) == NOT_GI_SCANNER)
        {
           scanner->skipping = TRUE;
           return;
        }
    }

  scanner->skipping = FALSE;
}

static void
push_conditional (GISourceScanner *scanner,
                  gint type)
{
  g_assert (type != 0);
  g_queue_push_head (&scanner->conditionals, GINT_TO_POINTER (type));
}

static gint
pop_conditional (GISourceScanner *scanner)
{
  gint type = GPOINTER_TO_INT (g_queue_pop_head (&scanner->conditionals));

  if (type == 0)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error = g_strdup_printf ("%s:%d: mismatched %s", filename, lineno, yytext);
      g_ptr_array_add (scanner->errors, error);
      g_free (filename);
    }

  return type;
}

static void
warn_if_cond_has_gi_scanner (GISourceScanner *scanner,
                             const gchar *text)
{
  /* Some other conditional that is not __GI_SCANNER__ */
  if (strstr (text, "__GI_SCANNER__"))
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error = g_strdup_printf ("%s:%d: the __GI_SCANNER__ constant should only be used with simple #ifdef or #endif: %s",
               filename, lineno, text);
      g_ptr_array_add (scanner->errors, error);
      g_free (filename);
    }
}

static void
toggle_conditional (GISourceScanner *scanner)
{
  switch (pop_conditional (scanner))
    {
    case FOR_GI_SCANNER:
      push_conditional (scanner, NOT_GI_SCANNER);
      break;
    case NOT_GI_SCANNER:
      push_conditional (scanner, FOR_GI_SCANNER);
      break;
    case 0:
      break;
    default:
      push_conditional (scanner, IRRELEVANT);
      break;
    }
}

static void
set_or_merge_base_type (GISourceType *type,
                        GISourceType *base)
{
  /* combine basic types like unsigned int and long long */
  if (base->type == CTYPE_BASIC_TYPE && type->type == CTYPE_BASIC_TYPE)
    {
      char *name = g_strdup_printf ("%s %s", type->name, base->name);
      g_free (type->name);
      type->name = name;

      type->storage_class_specifier |= base->storage_class_specifier;
      type->type_qualifier |= base->type_qualifier;
      type->function_specifier |= base->function_specifier;
      type->is_bitfield |= base->is_bitfield;

      ctype_free (base);
    }
  else if (base->type == CTYPE_INVALID)
    {
      g_assert (base->base_type == NULL);

      type->storage_class_specifier |= base->storage_class_specifier;
      type->type_qualifier |= base->type_qualifier;
      type->function_specifier |= base->function_specifier;
      type->is_bitfield |= base->is_bitfield;

      ctype_free (base);
    }
  else
    {
      g_assert (type->base_type == NULL);

      type->base_type = base;
    }
}


#line 295 "giscanner/scannerparser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "scannerparser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_BASIC_TYPE = 3,                 /* BASIC_TYPE  */
  YYSYMBOL_IDENTIFIER = 4,                 /* "identifier"  */
  YYSYMBOL_TYPEDEF_NAME = 5,               /* "typedef-name"  */
  YYSYMBOL_INTEGER = 6,                    /* INTEGER  */
  YYSYMBOL_FLOATING = 7,                   /* FLOATING  */
  YYSYMBOL_BOOLEAN = 8,                    /* BOOLEAN  */
  YYSYMBOL_CHARACTER = 9,                  /* CHARACTER  */
  YYSYMBOL_STRING = 10,                    /* STRING  */
  YYSYMBOL_INTL_CONST = 11,                /* INTL_CONST  */
  YYSYMBOL_INTUL_CONST = 12,               /* INTUL_CONST  */
  YYSYMBOL_ELLIPSIS = 13,                  /* ELLIPSIS  */
  YYSYMBOL_ADDEQ = 14,                     /* ADDEQ  */
  YYSYMBOL_SUBEQ = 15,                     /* SUBEQ  */
  YYSYMBOL_MULEQ = 16,                     /* MULEQ  */
  YYSYMBOL_DIVEQ = 17,                     /* DIVEQ  */
  YYSYMBOL_MODEQ = 18,                     /* MODEQ  */
  YYSYMBOL_XOREQ = 19,                     /* XOREQ  */
  YYSYMBOL_ANDEQ = 20,                     /* ANDEQ  */
  YYSYMBOL_OREQ = 21,                      /* OREQ  */
  YYSYMBOL_SL = 22,                        /* SL  */
  YYSYMBOL_SR = 23,                        /* SR  */
  YYSYMBOL_SLEQ = 24,                      /* SLEQ  */
  YYSYMBOL_SREQ = 25,                      /* SREQ  */
  YYSYMBOL_EQ = 26,                        /* EQ  */
  YYSYMBOL_NOTEQ = 27,                     /* NOTEQ  */
  YYSYMBOL_LTEQ = 28,                      /* LTEQ  */
  YYSYMBOL_GTEQ = 29,                      /* GTEQ  */
  YYSYMBOL_ANDAND = 30,                    /* ANDAND  */
  YYSYMBOL_OROR = 31,                      /* OROR  */
  YYSYMBOL_PLUSPLUS = 32,                  /* PLUSPLUS  */
  YYSYMBOL_MINUSMINUS = 33,                /* MINUSMINUS  */
  YYSYMBOL_ARROW = 34,                     /* ARROW  */
  YYSYMBOL_AUTO = 35,                      /* AUTO  */
  YYSYMBOL_BREAK = 36,                     /* BREAK  */
  YYSYMBOL_CASE = 37,                      /* CASE  */
  YYSYMBOL_CONST = 38,                     /* CONST  */
  YYSYMBOL_CONTINUE = 39,                  /* CONTINUE  */
  YYSYMBOL_DEFAULT = 40,                   /* DEFAULT  */
  YYSYMBOL_DO = 41,                        /* DO  */
  YYSYMBOL_ELSE = 42,                      /* ELSE  */
  YYSYMBOL_ENUM = 43,                      /* ENUM  */
  YYSYMBOL_EXTENSION = 44,                 /* EXTENSION  */
  YYSYMBOL_EXTERN = 45,                    /* EXTERN  */
  YYSYMBOL_FOR = 46,                       /* FOR  */
  YYSYMBOL_GOTO = 47,                      /* GOTO  */
  YYSYMBOL_IF = 48,                        /* IF  */
  YYSYMBOL_INLINE = 49,                    /* INLINE  */
  YYSYMBOL_REGISTER = 50,                  /* REGISTER  */
  YYSYMBOL_RESTRICT = 51,                  /* RESTRICT  */
  YYSYMBOL_RETURN = 52,                    /* RETURN  */
  YYSYMBOL_SHORT = 53,                     /* SHORT  */
  YYSYMBOL_SIGNED = 54,                    /* SIGNED  */
  YYSYMBOL_SIZEOF = 55,                    /* SIZEOF  */
  YYSYMBOL_STATIC = 56,                    /* STATIC  */
  YYSYMBOL_STRUCT = 57,                    /* STRUCT  */
  YYSYMBOL_SWITCH = 58,                    /* SWITCH  */
  YYSYMBOL_THREAD_LOCAL = 59,              /* THREAD_LOCAL  */
  YYSYMBOL_TYPEDEF = 60,                   /* TYPEDEF  */
  YYSYMBOL_UNION = 61,                     /* UNION  */
  YYSYMBOL_UNSIGNED = 62,                  /* UNSIGNED  */
  YYSYMBOL_VOID = 63,                      /* VOID  */
  YYSYMBOL_VOLATILE = 64,                  /* VOLATILE  */
  YYSYMBOL_WHILE = 65,                     /* WHILE  */
  YYSYMBOL_FUNCTION_MACRO = 66,            /* FUNCTION_MACRO  */
  YYSYMBOL_OBJECT_MACRO = 67,              /* OBJECT_MACRO  */
  YYSYMBOL_IFDEF_GI_SCANNER = 68,          /* IFDEF_GI_SCANNER  */
  YYSYMBOL_IFNDEF_GI_SCANNER = 69,         /* IFNDEF_GI_SCANNER  */
  YYSYMBOL_IFDEF_COND = 70,                /* IFDEF_COND  */
  YYSYMBOL_IFNDEF_COND = 71,               /* IFNDEF_COND  */
  YYSYMBOL_IF_COND = 72,                   /* IF_COND  */
  YYSYMBOL_ELIF_COND = 73,                 /* ELIF_COND  */
  YYSYMBOL_ELSE_COND = 74,                 /* ELSE_COND  */
  YYSYMBOL_ENDIF_COND = 75,                /* ENDIF_COND  */
  YYSYMBOL_76_ = 76,                       /* '('  */
  YYSYMBOL_77_ = 77,                       /* ')'  */
  YYSYMBOL_78_ = 78,                       /* '{'  */
  YYSYMBOL_79_ = 79,                       /* '}'  */
  YYSYMBOL_80_ = 80,                       /* '['  */
  YYSYMBOL_81_ = 81,                       /* ']'  */
  YYSYMBOL_82_ = 82,                       /* '.'  */
  YYSYMBOL_83_ = 83,                       /* ','  */
  YYSYMBOL_84_ = 84,                       /* '&'  */
  YYSYMBOL_85_ = 85,                       /* '*'  */
  YYSYMBOL_86_ = 86,                       /* '+'  */
  YYSYMBOL_87_ = 87,                       /* '-'  */
  YYSYMBOL_88_ = 88,                       /* '~'  */
  YYSYMBOL_89_ = 89,                       /* '!'  */
  YYSYMBOL_90_ = 90,                       /* '/'  */
  YYSYMBOL_91_ = 91,                       /* '%'  */
  YYSYMBOL_92_ = 92,                       /* '<'  */
  YYSYMBOL_93_ = 93,                       /* '>'  */
  YYSYMBOL_94_ = 94,                       /* '^'  */
  YYSYMBOL_95_ = 95,                       /* '|'  */
  YYSYMBOL_96_ = 96,                       /* '?'  */
  YYSYMBOL_97_ = 97,                       /* ':'  */
  YYSYMBOL_98_ = 98,                       /* '='  */
  YYSYMBOL_99_ = 99,                       /* ';'  */
  YYSYMBOL_YYACCEPT = 100,                 /* $accept  */
  YYSYMBOL_primary_expression = 101,       /* primary_expression  */
  YYSYMBOL_strings = 102,                  /* strings  */
  YYSYMBOL_identifier = 103,               /* identifier  */
  YYSYMBOL_identifier_or_typedef_name = 104, /* identifier_or_typedef_name  */
  YYSYMBOL_postfix_expression = 105,       /* postfix_expression  */
  YYSYMBOL_argument_expression_list = 106, /* argument_expression_list  */
  YYSYMBOL_unary_expression = 107,         /* unary_expression  */
  YYSYMBOL_unary_operator = 108,           /* unary_operator  */
  YYSYMBOL_cast_expression = 109,          /* cast_expression  */
  YYSYMBOL_multiplicative_expression = 110, /* multiplicative_expression  */
  YYSYMBOL_additive_expression = 111,      /* additive_expression  */
  YYSYMBOL_shift_expression = 112,         /* shift_expression  */
  YYSYMBOL_relational_expression = 113,    /* relational_expression  */
  YYSYMBOL_equality_expression = 114,      /* equality_expression  */
  YYSYMBOL_and_expression = 115,           /* and_expression  */
  YYSYMBOL_exclusive_or_expression = 116,  /* exclusive_or_expression  */
  YYSYMBOL_inclusive_or_expression = 117,  /* inclusive_or_expression  */
  YYSYMBOL_logical_and_expression = 118,   /* logical_and_expression  */
  YYSYMBOL_logical_or_expression = 119,    /* logical_or_expression  */
  YYSYMBOL_conditional_expression = 120,   /* conditional_expression  */
  YYSYMBOL_assignment_expression = 121,    /* assignment_expression  */
  YYSYMBOL_assignment_operator = 122,      /* assignment_operator  */
  YYSYMBOL_expression = 123,               /* expression  */
  YYSYMBOL_constant_expression = 124,      /* constant_expression  */
  YYSYMBOL_declaration = 125,              /* declaration  */
  YYSYMBOL_empty_declaration = 126,        /* empty_declaration  */
  YYSYMBOL_declaration_specifiers = 127,   /* declaration_specifiers  */
  YYSYMBOL_init_declarator_list = 128,     /* init_declarator_list  */
  YYSYMBOL_init_declarator = 129,          /* init_declarator  */
  YYSYMBOL_storage_class_specifier = 130,  /* storage_class_specifier  */
  YYSYMBOL_basic_type = 131,               /* basic_type  */
  YYSYMBOL_type_specifier = 132,           /* type_specifier  */
  YYSYMBOL_struct_or_union_specifier = 133, /* struct_or_union_specifier  */
  YYSYMBOL_struct_or_union = 134,          /* struct_or_union  */
  YYSYMBOL_struct_declaration_list = 135,  /* struct_declaration_list  */
  YYSYMBOL_struct_declaration = 136,       /* struct_declaration  */
  YYSYMBOL_specifier_qualifier_list = 137, /* specifier_qualifier_list  */
  YYSYMBOL_struct_declarator_list = 138,   /* struct_declarator_list  */
  YYSYMBOL_struct_declarator = 139,        /* struct_declarator  */
  YYSYMBOL_enum_specifier = 140,           /* enum_specifier  */
  YYSYMBOL_enum_keyword = 141,             /* enum_keyword  */
  YYSYMBOL_static_keyword = 142,           /* static_keyword  */
  YYSYMBOL_enumerator_list = 143,          /* enumerator_list  */
  YYSYMBOL_144_1 = 144,                    /* $@1  */
  YYSYMBOL_enumerator = 145,               /* enumerator  */
  YYSYMBOL_type_qualifier = 146,           /* type_qualifier  */
  YYSYMBOL_function_specifier = 147,       /* function_specifier  */
  YYSYMBOL_declarator = 148,               /* declarator  */
  YYSYMBOL_direct_declarator = 149,        /* direct_declarator  */
  YYSYMBOL_pointer = 150,                  /* pointer  */
  YYSYMBOL_type_qualifier_list = 151,      /* type_qualifier_list  */
  YYSYMBOL_parameter_list = 152,           /* parameter_list  */
  YYSYMBOL_parameter_declaration = 153,    /* parameter_declaration  */
  YYSYMBOL_identifier_list = 154,          /* identifier_list  */
  YYSYMBOL_type_name = 155,                /* type_name  */
  YYSYMBOL_abstract_declarator = 156,      /* abstract_declarator  */
  YYSYMBOL_direct_abstract_declarator = 157, /* direct_abstract_declarator  */
  YYSYMBOL_typedef_name = 158,             /* typedef_name  */
  YYSYMBOL_initializer = 159,              /* initializer  */
  YYSYMBOL_initializer_list = 160,         /* initializer_list  */
  YYSYMBOL_initializer_list_item = 161,    /* initializer_list_item  */
  YYSYMBOL_designator_list = 162,          /* designator_list  */
  YYSYMBOL_designator = 163,               /* designator  */
  YYSYMBOL_statement = 164,                /* statement  */
  YYSYMBOL_labeled_statement = 165,        /* labeled_statement  */
  YYSYMBOL_compound_statement = 166,       /* compound_statement  */
  YYSYMBOL_block_item_list = 167,          /* block_item_list  */
  YYSYMBOL_block_item = 168,               /* block_item  */
  YYSYMBOL_expression_statement = 169,     /* expression_statement  */
  YYSYMBOL_selection_statement = 170,      /* selection_statement  */
  YYSYMBOL_iteration_statement = 171,      /* iteration_statement  */
  YYSYMBOL_jump_statement = 172,           /* jump_statement  */
  YYSYMBOL_translation_unit = 173,         /* translation_unit  */
  YYSYMBOL_external_declaration = 174,     /* external_declaration  */
  YYSYMBOL_function_definition = 175,      /* function_definition  */
  YYSYMBOL_declaration_list = 176,         /* declaration_list  */
  YYSYMBOL_function_macro = 177,           /* function_macro  */
  YYSYMBOL_object_macro = 178,             /* object_macro  */
  YYSYMBOL_function_macro_argument_list = 179, /* function_macro_argument_list  */
  YYSYMBOL_function_macro_define = 180,    /* function_macro_define  */
  YYSYMBOL_object_macro_define = 181,      /* object_macro_define  */
  YYSYMBOL_preproc_conditional = 182,      /* preproc_conditional  */
  YYSYMBOL_macro = 183                     /* macro  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  74
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2474

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  100
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  84
/* YYNRULES -- Number of rules.  */
#define YYNRULES  266
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  444

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   330


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    89,     2,     2,     2,    91,    84,     2,
      76,    77,    85,    86,    83,    87,    82,    90,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    97,    99,
      92,    98,    93,    96,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    80,     2,    81,    94,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    78,    95,    79,    88,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   349,   349,   358,   374,   380,   386,   393,   394,   398,
     406,   421,   435,   442,   443,   447,   448,   452,   456,   460,
     464,   468,   472,   479,   480,   484,   485,   489,   493,   516,
     523,   530,   534,   542,   546,   550,   554,   558,   562,   569,
     570,   582,   583,   589,   597,   608,   609,   615,   624,   625,
     637,   646,   647,   653,   659,   665,   674,   675,   681,   690,
     691,   700,   701,   710,   711,   720,   721,   732,   733,   744,
     745,   752,   753,   760,   761,   762,   763,   764,   765,   766,
     767,   768,   769,   770,   774,   775,   776,   783,   789,   807,
     814,   817,   822,   827,   832,   833,   838,   843,   848,   856,
     860,   867,   868,   872,   876,   880,   884,   888,   892,   899,
     906,   910,   914,   918,   923,   924,   925,   933,   953,   958,
     966,   971,   979,   980,   987,  1007,  1012,  1013,  1018,  1026,
    1030,  1038,  1041,  1042,  1046,  1057,  1064,  1071,  1078,  1085,
    1092,  1100,  1107,  1107,  1116,  1124,  1132,  1144,  1148,  1152,
    1156,  1163,  1170,  1175,  1179,  1184,  1188,  1193,  1198,  1203,
    1213,  1220,  1229,  1234,  1238,  1249,  1262,  1263,  1270,  1274,
    1281,  1286,  1291,  1296,  1303,  1309,  1318,  1319,  1323,  1328,
    1329,  1337,  1341,  1346,  1351,  1356,  1361,  1367,  1377,  1383,
    1396,  1403,  1404,  1405,  1409,  1410,  1414,  1415,  1419,  1420,
    1424,  1425,  1431,  1432,  1433,  1434,  1435,  1436,  1440,  1441,
    1442,  1446,  1447,  1451,  1452,  1456,  1457,  1461,  1462,  1466,
    1467,  1468,  1472,  1473,  1474,  1475,  1476,  1477,  1478,  1479,
    1480,  1481,  1485,  1486,  1487,  1488,  1489,  1495,  1496,  1500,
    1501,  1502,  1503,  1507,  1508,  1512,  1513,  1519,  1526,  1533,
    1539,  1544,  1553,  1563,  1576,  1593,  1598,  1603,  1608,  1613,
    1618,  1625,  1630,  1638,  1639,  1640,  1641
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "BASIC_TYPE",
  "\"identifier\"", "\"typedef-name\"", "INTEGER", "FLOATING", "BOOLEAN",
  "CHARACTER", "STRING", "INTL_CONST", "INTUL_CONST", "ELLIPSIS", "ADDEQ",
  "SUBEQ", "MULEQ", "DIVEQ", "MODEQ", "XOREQ", "ANDEQ", "OREQ", "SL", "SR",
  "SLEQ", "SREQ", "EQ", "NOTEQ", "LTEQ", "GTEQ", "ANDAND", "OROR",
  "PLUSPLUS", "MINUSMINUS", "ARROW", "AUTO", "BREAK", "CASE", "CONST",
  "CONTINUE", "DEFAULT", "DO", "ELSE", "ENUM", "EXTENSION", "EXTERN",
  "FOR", "GOTO", "IF", "INLINE", "REGISTER", "RESTRICT", "RETURN", "SHORT",
  "SIGNED", "SIZEOF", "STATIC", "STRUCT", "SWITCH", "THREAD_LOCAL",
  "TYPEDEF", "UNION", "UNSIGNED", "VOID", "VOLATILE", "WHILE",
  "FUNCTION_MACRO", "OBJECT_MACRO", "IFDEF_GI_SCANNER",
  "IFNDEF_GI_SCANNER", "IFDEF_COND", "IFNDEF_COND", "IF_COND", "ELIF_COND",
  "ELSE_COND", "ENDIF_COND", "'('", "')'", "'{'", "'}'", "'['", "']'",
  "'.'", "','", "'&'", "'*'", "'+'", "'-'", "'~'", "'!'", "'/'", "'%'",
  "'<'", "'>'", "'^'", "'|'", "'?'", "':'", "'='", "';'", "$accept",
  "primary_expression", "strings", "identifier",
  "identifier_or_typedef_name", "postfix_expression",
  "argument_expression_list", "unary_expression", "unary_operator",
  "cast_expression", "multiplicative_expression", "additive_expression",
  "shift_expression", "relational_expression", "equality_expression",
  "and_expression", "exclusive_or_expression", "inclusive_or_expression",
  "logical_and_expression", "logical_or_expression",
  "conditional_expression", "assignment_expression", "assignment_operator",
  "expression", "constant_expression", "declaration", "empty_declaration",
  "declaration_specifiers", "init_declarator_list", "init_declarator",
  "storage_class_specifier", "basic_type", "type_specifier",
  "struct_or_union_specifier", "struct_or_union",
  "struct_declaration_list", "struct_declaration",
  "specifier_qualifier_list", "struct_declarator_list",
  "struct_declarator", "enum_specifier", "enum_keyword", "static_keyword",
  "enumerator_list", "$@1", "enumerator", "type_qualifier",
  "function_specifier", "declarator", "direct_declarator", "pointer",
  "type_qualifier_list", "parameter_list", "parameter_declaration",
  "identifier_list", "type_name", "abstract_declarator",
  "direct_abstract_declarator", "typedef_name", "initializer",
  "initializer_list", "initializer_list_item", "designator_list",
  "designator", "statement", "labeled_statement", "compound_statement",
  "block_item_list", "block_item", "expression_statement",
  "selection_statement", "iteration_statement", "jump_statement",
  "translation_unit", "external_declaration", "function_definition",
  "declaration_list", "function_macro", "object_macro",
  "function_macro_argument_list", "function_macro_define",
  "object_macro_define", "preproc_conditional", "macro", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-252)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-15)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     568,  -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,
    -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,
    -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,  -252,
    -252,  -252,  -252,  -252,    15,  2410,  -252,  2410,  -252,    46,
    -252,    52,  2410,  2410,  -252,   481,  -252,  -252,   -43,  1865,
    -252,  -252,  -252,  -252,  -252,    31,   301,  -252,  -252,   -56,
    -252,  1075,    75,    62,  -252,  -252,   310,  -252,   -42,  -252,
    -252,   -37,  -252,  -252,  -252,  -252,    67,  -252,  -252,  -252,
    -252,  -252,   -18,    27,  1915,  1915,    74,  1954,  1413,  -252,
    -252,  -252,  -252,  -252,  -252,  -252,    18,  -252,   159,  -252,
    1865,  -252,    73,    92,   236,    53,   253,    38,   127,    76,
     156,    -9,  -252,  -252,   137,  -252,  -252,   301,    31,  -252,
     641,  1571,  -252,    15,  -252,  2193,  2255,  1532,    75,   310,
    2030,  -252,    20,   310,   310,    83,   248,  -252,  -252,  -252,
     177,   189,  1915,  1915,  1973,  -252,  -252,   192,  1413,  -252,
    2012,   212,  -252,  -252,   -14,    72,   210,  -252,  -252,  -252,
     258,  1621,  1973,   258,  -252,  1865,  1865,  1865,  1865,  1865,
    1865,  1865,  1865,  1865,  1865,  1865,  1865,  1865,  1865,  1865,
    1865,  1865,  1865,  1973,  -252,  -252,  -252,  -252,   197,   191,
    1865,   199,   202,  1018,   226,   258,   227,  1136,   228,   231,
    -252,  -252,   217,   222,   -24,  -252,   224,  -252,  -252,  -252,
     738,  -252,  -252,  -252,  -252,  -252,  1513,  -252,  -252,  -252,
    -252,  -252,  -252,  -252,    30,    77,  -252,    98,  -252,  -252,
     241,  1865,  -252,  -252,  -252,  1865,   -23,  -252,   229,  -252,
    2156,  -252,    14,   211,  -252,   123,    60,  -252,   246,   247,
    2012,   932,   250,  1351,   245,  -252,  -252,  -252,  -252,  -252,
    -252,  -252,  -252,  -252,  -252,  -252,  1865,  -252,  1865,  2129,
    1660,   143,  -252,   175,  1865,  -252,  -252,   106,  -252,    42,
    -252,  -252,  -252,  -252,    73,    73,    92,    92,   236,   236,
     236,   236,    53,    53,   253,    38,   127,    76,   156,   -45,
    -252,   234,  -252,  1018,   267,  1152,   239,  1973,  -252,   -21,
    1973,  1973,  1018,  -252,  -252,  -252,  1865,   248,  -252,   174,
    -252,   -50,  -252,  2067,  -252,    63,  -252,  -252,  2379,  -252,
     248,  -252,   254,  -252,    20,  -252,  1865,  -252,  -252,  -252,
    1865,  -252,    22,  -252,  -252,  -252,   835,  -252,  -252,  -252,
    -252,   120,   263,  -252,   260,   175,  2317,  1679,  -252,  -252,
    1865,  -252,  1973,  1018,  -252,   266,  1238,   -11,  -252,   124,
    -252,   128,   132,  -252,   274,  -252,  -252,  1474,  1571,  -252,
    -252,  -252,  -252,  -252,  -252,  -252,  -252,   279,  -252,  -252,
    -252,  -252,   133,  -252,   278,  -252,   245,  -252,  1973,  1718,
      57,  1254,  1018,  1018,  1018,  -252,  -252,  -252,  -252,  -252,
    -252,  -252,   141,  1018,   161,  1768,  1807,    66,   302,  -252,
    -252,   244,  -252,  1018,  1018,   166,  1018,   171,  1826,  1018,
    -252,  -252,  -252,  1018,  -252,  1018,  1018,   173,  -252,  -252,
    -252,  -252,  1018,  -252
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,   266,   109,   190,   106,   147,   140,   149,   104,   151,
     107,   148,   111,   105,   120,   108,   103,   121,   112,   110,
     150,   247,   248,   255,   256,   257,   258,   259,   260,   261,
     262,    90,   240,   241,     0,    92,   113,    94,   114,     0,
     115,     0,    96,    98,   116,     0,   237,   239,     0,     0,
     263,   264,   265,   242,    12,     0,   163,    89,   154,     0,
      99,   101,   153,     0,    91,    93,     0,    13,   119,    14,
     142,   139,    95,    97,     1,   238,     0,     3,     6,     4,
       5,    10,     0,     0,     0,     0,     0,     0,     0,    33,
      34,    35,    36,    37,    38,    15,     7,     2,    25,    39,
       0,    41,    45,    48,    51,    56,    59,    61,    63,    65,
      67,    69,    87,   254,     0,   166,   165,   162,     0,    88,
       0,     0,   245,     0,   244,     0,     0,     0,   152,   126,
       0,   122,   131,   128,     0,     0,     0,   142,   250,   253,
     249,     0,     0,     0,     0,    26,    27,     0,     0,    31,
     149,    39,    71,    84,     0,   176,     0,    11,    21,    22,
       0,     0,     0,     0,    28,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   167,   164,   100,   101,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,   217,     2,     0,     0,   215,   116,   216,   202,   203,
       0,   213,   204,   205,   206,   207,     0,   191,   102,   246,
     243,   173,   161,   174,   172,     0,   168,     0,   141,   158,
       0,     0,   125,   118,   123,     0,     0,   129,   132,   127,
       0,   136,     0,   145,   143,     0,     0,   252,     0,     0,
       0,     0,     0,     0,    86,    77,    78,    74,    75,    76,
      82,    81,    83,    79,    80,    73,     0,     8,     0,     0,
       0,   178,   177,   179,     0,    20,    18,     0,    23,     0,
      19,    42,    43,    44,    46,    47,    49,    50,    54,    55,
      52,    53,    57,    58,    60,    62,    64,    66,    68,     0,
     234,     0,   233,     0,     0,     0,     0,     0,   235,     0,
       0,     0,     0,   218,   212,   214,     0,     0,   197,     0,
     194,     0,   198,     0,   170,   178,   171,   159,     0,   160,
       0,   157,     0,   133,   131,   124,     0,   117,   138,   144,
       0,   135,     0,   251,    29,    30,     0,    32,    72,    85,
     186,     0,     0,   182,     0,   180,     0,     0,    40,    17,
       0,    16,     0,     0,   210,     0,     0,     0,   232,     0,
     236,     0,     0,   208,     0,   201,   192,     0,     0,   199,
     169,   175,   156,   130,   134,   146,   137,     0,   187,   181,
     183,   188,     0,   184,     0,    24,    70,   209,     0,     0,
       0,     0,     0,     0,     0,   200,   193,   195,   196,     9,
     189,   185,     0,     0,     0,     0,     0,     0,   219,   221,
     222,     0,   224,     0,     0,     0,     0,     0,     0,     0,
     223,   228,   226,     0,   225,     0,     0,     0,   220,   230,
     229,   227,     0,   231
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -252,  -252,  -252,   -34,   -27,  -252,  -252,   262,  -252,   -54,
     116,   146,   100,   117,   182,   196,   200,   201,   203,  -252,
     -48,   -96,  -252,   -65,  -136,    16,  -252,     2,  -252,   265,
    -252,  -252,   380,  -252,  -252,   257,  -113,   -80,  -252,    47,
    -252,  -252,  -252,   251,  -252,   270,    65,  -252,   -28,   -60,
     -47,  -252,  -122,    56,  -252,   264,  -115,  -251,   -26,  -111,
    -252,    17,  -252,    90,    54,  -252,    -6,   142,  -199,  -252,
    -252,  -252,  -252,  -252,   351,  -252,  -252,  -252,  -252,   167,
    -252,  -252,  -252,  -252
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    95,    96,    97,   203,    98,   277,   151,   100,   101,
     102,   103,   104,   105,   106,   107,   108,   109,   110,   111,
     152,   153,   266,   204,   113,   205,    33,   123,    59,    60,
      35,    36,    37,    38,    39,   130,   131,   132,   236,   237,
      40,    41,   231,   135,   136,   339,    42,    43,   114,    62,
      63,   117,   351,   226,   227,   156,   352,   273,    44,   318,
     319,   320,   321,   322,   207,   208,   209,   210,   211,   212,
     213,   214,   215,    45,    46,    47,   125,    48,    49,   141,
      50,    51,    52,    53
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      58,   112,    34,   128,   225,    67,    61,    67,   155,   116,
     218,   315,    68,    69,    71,    69,    32,   234,    54,    54,
     355,    58,   182,   154,    54,   217,    54,   118,   157,    58,
     316,   230,   317,    76,    54,    54,   134,    64,   268,    65,
     272,   137,   140,   119,    72,    73,   164,    34,   378,   232,
      54,     3,   362,   239,   301,   124,    54,     3,   142,   268,
     334,    32,   268,   267,    54,   278,    54,    54,   155,   268,
     186,    54,   268,   138,   355,   313,   335,   122,   370,   154,
     138,   172,   173,   154,    58,   254,   202,   183,   401,    58,
     188,    55,   223,   338,   206,   188,    55,   279,    58,   333,
      56,   386,   243,   143,   238,    56,   323,    55,   271,   326,
     270,   281,   282,   283,    57,    56,    56,   235,   299,   220,
     217,   115,   178,   361,    66,   268,    67,   234,   224,    67,
      70,   133,   309,   275,    69,   332,   280,    69,    55,   323,
     268,   219,   112,   270,   139,   174,   175,   315,   269,   268,
     147,   126,   270,   133,   327,   127,   415,    56,   165,   202,
     328,    67,   241,   166,   167,   428,   242,    69,   306,    69,
     348,   180,   349,   155,   354,   329,   202,   325,   168,   169,
     374,   330,   185,   359,   206,   254,   181,   112,   154,   360,
      58,   158,   159,   160,   133,   133,   324,   388,   133,   133,
     384,   402,   341,   328,   385,   403,   342,   268,   243,   404,
     410,   268,   140,   133,   184,   268,   328,   202,   421,   269,
     358,   179,   271,   270,   268,   206,   255,   256,   257,   258,
     259,   260,   261,   262,   392,   161,   263,   264,   423,   162,
     367,   163,   369,   433,   268,   371,   372,   304,   435,   268,
     442,   356,    54,   376,   268,   357,   268,   377,   170,   171,
     246,   394,    54,     3,   395,   128,   247,   408,   112,   202,
     251,   224,   288,   289,   290,   291,   325,    69,   202,   176,
     177,   217,   217,   375,   284,   285,    69,   274,   112,    58,
     300,    58,   112,   292,   293,   121,   381,   396,   302,   303,
      58,   400,   305,   307,   310,   133,   238,   311,   243,   340,
     265,    99,   202,     2,   -13,     3,   286,   287,   133,   312,
     206,   -14,   331,   344,   345,   224,   336,   347,   268,   202,
     224,   363,   365,   412,   414,   382,   417,    69,   368,     5,
     389,   390,   398,   430,   429,     7,   145,   146,     5,   149,
     425,   427,    11,     6,     7,   405,   409,   364,   224,   411,
     294,    11,    99,   437,    12,    20,   373,    14,   202,   202,
     202,    17,    18,    19,    20,   295,    69,    69,    69,   202,
     296,   383,   297,   187,   380,   298,    56,    69,   245,   202,
     202,   240,   202,   346,   407,   202,    75,    69,    69,   202,
      69,   202,   202,    69,   248,   249,   244,    69,   202,    69,
      69,   379,   252,   343,     0,     0,    69,   397,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    99,    99,    99,
      99,    99,    99,    99,    99,    99,    99,    99,    99,    99,
      99,    99,    99,    99,    99,     0,   129,     0,     0,     0,
       0,     0,    99,     0,     0,     0,   418,   419,   420,     0,
       0,     0,     0,     0,     0,     0,     0,   422,   129,     0,
       0,     0,     0,     0,     0,     0,     0,   431,   432,     0,
     434,    74,     1,   438,     2,     0,     3,   439,     0,   440,
     441,     0,     0,     0,     0,     0,   443,    99,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
     129,     0,     0,   129,   129,     0,     4,     0,     0,     5,
       0,     0,     0,     0,     6,     7,     8,     0,   129,     0,
       9,    10,    11,     0,     0,    12,    99,    13,    14,     0,
      15,    16,    17,    18,    19,    20,     0,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     1,
       0,     2,     0,     3,     0,     0,     0,     0,    99,     0,
      31,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    99,     0,
       0,     0,    99,     4,     0,     0,     5,     0,     0,     0,
       0,     6,     7,     8,     0,     0,     0,     9,    10,    11,
     129,     0,    12,     0,    13,    14,     0,    15,    16,    17,
      18,    19,    20,   129,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,     2,    54,     3,    77,    78,    79,
      80,    81,    82,    83,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    31,     0,     0,
       0,     0,     0,    84,    85,     0,     4,   189,   190,     5,
     191,   192,   193,     0,     6,   150,     8,   194,   195,   196,
       9,    10,    11,   197,     0,    12,    87,    13,    14,   198,
      15,    16,    17,    18,    19,    20,   199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    88,     0,   120,
     200,     0,     0,     0,     0,    89,    90,    91,    92,    93,
      94,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     201,     2,    54,     3,    77,    78,    79,    80,    81,    82,
      83,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      84,    85,     0,     4,   189,   190,     5,   191,   192,   193,
       0,     6,   150,     8,   194,   195,   196,     9,    10,    11,
     197,     0,    12,    87,    13,    14,   198,    15,    16,    17,
      18,    19,    20,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    88,     0,   120,   314,     0,     0,
       0,     0,    89,    90,    91,    92,    93,    94,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     2,    54,
       3,    77,    78,    79,    80,    81,    82,    83,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    84,    85,     0,
       4,   189,   190,     5,   191,   192,   193,     0,     6,   150,
       8,   194,   195,   196,     9,    10,    11,   197,     0,    12,
      87,    13,    14,   198,    15,    16,    17,    18,    19,    20,
     199,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    88,     0,   120,   387,     0,     0,     0,     0,    89,
      90,    91,    92,    93,    94,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   201,     2,    54,     3,    77,    78,
      79,    80,    81,    82,    83,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    84,    85,     0,     4,   189,   190,
       5,   191,   192,   193,     0,     6,   150,     8,   194,   195,
     196,     9,    10,    11,   197,     0,    12,    87,    13,    14,
     198,    15,    16,    17,    18,    19,    20,   199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    88,     0,
     120,     0,     0,     0,     0,     0,    89,    90,    91,    92,
      93,    94,    54,     3,    77,    78,    79,    80,    81,    82,
      83,   201,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      84,    85,     0,     0,   189,   190,     0,   191,   192,   193,
       0,     0,   250,     0,   194,   195,   196,     0,     0,     0,
     197,     0,     0,    87,     0,     0,   198,     0,     2,     0,
       3,     0,     0,   199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    88,     0,   120,     0,     0,     0,
       0,     0,    89,    90,    91,    92,    93,    94,     0,     0,
       4,     0,     0,     5,     0,     0,     0,   201,     6,     7,
       8,     0,     0,     0,     9,    10,    11,     0,     0,    12,
       0,    13,    14,     0,    15,    16,    17,    18,    19,    20,
      54,     0,    77,    78,    79,    80,    81,    82,    83,     0,
       0,     0,     0,   120,     0,     0,    54,     0,    77,    78,
      79,    80,    81,    82,    83,     0,     0,     0,    84,    85,
       0,     0,     0,   121,     0,     0,     0,     0,     0,     0,
     250,     0,     0,     0,    84,    85,     0,     0,     0,     0,
       0,    87,     0,     0,     0,     0,   250,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    87,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
      89,    90,    91,    92,    93,    94,     0,     0,    88,     0,
       0,     0,     0,     0,     0,   308,    89,    90,    91,    92,
      93,    94,    54,     0,    77,    78,    79,    80,    81,    82,
      83,   366,     0,     0,     0,     0,     0,     0,    54,     0,
      77,    78,    79,    80,    81,    82,    83,     0,     0,     0,
      84,    85,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   250,     0,     0,     0,    84,    85,     0,     0,
       0,     0,     0,    87,     0,     0,     0,     0,   250,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    87,
       0,     0,     0,     0,    88,     0,     0,     0,     0,     0,
       0,     0,    89,    90,    91,    92,    93,    94,     0,     0,
      88,     0,     0,     0,     0,     0,     0,   399,    89,    90,
      91,    92,    93,    94,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   416,     2,    54,     3,    77,    78,    79,
      80,    81,    82,    83,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    84,    85,     0,     0,     0,     0,     5,
       0,     0,     0,     0,     6,   150,     0,     0,     0,     0,
       0,     0,    11,     0,     0,    12,    87,     0,    14,     0,
       0,     0,    17,    18,    19,    20,     2,    54,     3,    77,
      78,    79,    80,    81,    82,    83,     0,    88,     0,   251,
       0,     0,     0,     0,     0,    89,    90,    91,    92,    93,
      94,     0,     0,     0,     0,    84,    85,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     6,   150,     0,     0,
       0,     0,     0,     0,    11,     0,     0,    12,    87,     0,
      14,     0,     0,     0,    17,    18,    19,    20,    54,     0,
      77,    78,    79,    80,    81,    82,    83,     0,     0,    88,
       0,     0,     0,     0,     0,     0,     0,    89,    90,    91,
      92,    93,    94,     0,     0,     0,    84,    85,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    54,    86,    77,
      78,    79,    80,    81,    82,    83,     0,     0,     0,    87,
       0,     0,     0,     0,     0,     0,    54,     0,    77,    78,
      79,    80,    81,    82,    83,    84,    85,     0,     0,     0,
      88,     0,   216,   406,   316,     0,   317,    86,    89,    90,
      91,    92,    93,    94,    84,    85,     0,     0,    87,     0,
       0,     0,     0,     0,     0,    54,    86,    77,    78,    79,
      80,    81,    82,    83,     0,     0,     0,    87,   228,    88,
       0,   216,     0,   316,     0,   317,     0,    89,    90,    91,
      92,    93,    94,    84,    85,     0,     0,     0,    88,     0,
       0,     0,     0,   229,     0,    86,    89,    90,    91,    92,
      93,    94,     0,     0,     0,    54,    87,    77,    78,    79,
      80,    81,    82,    83,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    88,     0,   216,
       0,     0,     0,    84,    85,    89,    90,    91,    92,    93,
      94,     0,     0,     0,    54,    86,    77,    78,    79,    80,
      81,    82,    83,     0,     0,     0,    87,     0,     0,     0,
       0,     0,     0,    54,     0,    77,    78,    79,    80,    81,
      82,    83,    84,    85,     0,     0,     0,    88,   276,     0,
       0,     0,     0,     0,    86,    89,    90,    91,    92,    93,
      94,    84,    85,     0,     0,    87,     0,     0,     0,     0,
       0,     0,    54,    86,    77,    78,    79,    80,    81,    82,
      83,     0,     0,     0,    87,     0,    88,     0,     0,     0,
       0,   353,     0,     0,    89,    90,    91,    92,    93,    94,
      84,    85,     0,     0,     0,    88,     0,     0,     0,     0,
     393,     0,   250,    89,    90,    91,    92,    93,    94,     0,
       0,     0,    54,    87,    77,    78,    79,    80,    81,    82,
      83,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    88,   413,     0,     0,     0,     0,
      84,    85,    89,    90,    91,    92,    93,    94,     0,     0,
       0,    54,   250,    77,    78,    79,    80,    81,    82,    83,
       0,     0,     0,    87,     0,     0,     0,     0,     0,     0,
      54,     0,    77,    78,    79,    80,    81,    82,    83,    84,
      85,     0,     0,     0,    88,   424,     0,     0,     0,     0,
       0,   250,    89,    90,    91,    92,    93,    94,    84,    85,
       0,     0,    87,     0,     0,     0,     0,     0,     0,    54,
     250,    77,    78,    79,    80,    81,    82,    83,     0,     0,
       0,    87,     0,    88,   426,     0,     0,     0,     0,     0,
       0,    89,    90,    91,    92,    93,    94,    84,    85,     0,
       0,     0,    88,   436,     0,     0,     0,     0,     0,    86,
      89,    90,    91,    92,    93,    94,     0,     0,     0,    54,
      87,    77,    78,    79,    80,    81,    82,    83,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    88,     0,     0,     0,     0,     0,    84,    85,    89,
      90,    91,    92,    93,    94,     0,     0,     0,    54,    86,
      77,    78,    79,    80,    81,    82,    83,     0,     0,     0,
      87,     0,     0,     0,     0,     0,     0,    54,     0,    77,
      78,    79,    80,    81,    82,    83,    84,    85,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,    86,    89,
      90,    91,    92,    93,    94,    84,    85,     0,     0,    87,
       0,     0,     0,     0,     0,     0,    54,   250,    77,    78,
      79,    80,    81,    82,    83,     0,     0,     0,    87,     0,
     148,     0,     0,     2,     0,     3,     0,     0,    89,    90,
      91,    92,    93,    94,    84,    85,     0,     0,     0,    88,
       0,     0,     0,     0,     0,     0,   250,    89,    90,    91,
      92,    93,    94,     0,     0,     0,     0,    87,     5,     0,
       2,    54,     3,     6,     7,     0,     0,     0,     0,     0,
     221,    11,     0,     0,    12,     0,     0,    14,   253,     0,
       0,    17,    18,    19,    20,     0,    89,    90,    91,    92,
      93,    94,     4,     0,     0,     5,     0,     0,     0,   233,
       6,     7,     8,     0,     0,     0,     9,    10,    11,     0,
       0,    12,     0,    13,    14,     0,    15,    16,    17,    18,
      19,    20,     2,     0,     3,     0,     0,     0,     0,     0,
       0,     0,   221,   323,   350,     0,     0,   270,     0,     0,
       0,     0,    56,     0,     0,     0,     0,     0,     0,     2,
       0,     3,     0,     0,     4,     0,     0,     5,     0,     0,
       0,     0,     6,     7,     8,     0,     0,     0,     9,    10,
      11,     0,     0,    12,     0,    13,    14,     0,    15,    16,
      17,    18,    19,    20,     5,     0,     2,     0,     3,     6,
       7,     0,     0,     0,     0,   269,   350,    11,     0,   270,
      12,     0,     0,    14,    56,     0,     0,    17,    18,    19,
      20,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,     5,     0,     0,     0,   337,     6,     7,     8,     0,
       0,     0,     9,    10,    11,     0,     0,    12,     0,    13,
      14,     0,    15,    16,    17,    18,    19,    20,     2,    54,
       3,     0,     0,     0,     0,     0,     0,     0,   221,     0,
       0,   120,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     5,     0,     0,     0,     0,     6,     7,
       8,     0,     0,     0,     9,    10,    11,     0,     0,    12,
       0,    13,    14,     0,    15,    16,    17,    18,    19,    20,
       2,     0,     3,     0,     0,     0,     0,     0,     0,     0,
     221,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     5,     0,     0,     0,     0,
       6,     7,     8,     0,     0,     0,     9,    10,    11,     0,
       0,    12,     0,    13,    14,     0,    15,    16,    17,    18,
      19,    20,     2,     0,     3,     0,     0,     0,     0,     0,
       0,     0,   221,     0,   391,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     2,     4,     3,     0,     5,     0,     0,
       0,     0,     6,     7,     8,     0,     0,     0,     9,    10,
      11,     0,     0,    12,     0,    13,    14,     0,    15,    16,
      17,    18,    19,    20,     0,     4,     0,     0,     5,     0,
       0,     0,     0,     6,     7,     8,     0,     0,     0,     9,
      10,    11,     0,     0,    12,     0,    13,    14,     0,    15,
      16,    17,    18,    19,    20
};

static const yytype_int16 yycheck[] =
{
      34,    49,     0,    63,   126,    39,    34,    41,    88,    56,
     121,   210,    39,    39,    41,    41,     0,   130,     4,     4,
     271,    55,    31,    88,     4,   121,     4,    83,    10,    63,
      80,   127,    82,    76,     4,     4,    78,    35,    83,    37,
     155,    78,    76,    99,    42,    43,   100,    45,    98,   129,
       4,     5,    97,   133,   190,    61,     4,     5,    76,    83,
      83,    45,    83,    77,     4,   161,     4,     4,   148,    83,
     117,     4,    83,    13,   325,    99,    99,    61,    99,   144,
      13,    28,    29,   148,   118,   150,   120,    96,    99,   123,
     118,    76,   126,    79,   120,   123,    76,   162,   132,   235,
      85,    79,   136,    76,   132,    85,    76,    76,   155,   224,
      80,   165,   166,   167,    99,    85,    85,    97,   183,   125,
     216,    56,    84,    81,    78,    83,   160,   240,   126,   163,
      78,    66,   197,   160,   160,   231,   163,   163,    76,    76,
      83,   125,   190,    80,    77,    92,    93,   346,    76,    83,
      76,    76,    80,    88,    77,    80,    99,    85,    85,   193,
      83,   195,    79,    90,    91,    99,    83,   193,   195,   195,
     266,    95,   268,   253,   270,    77,   210,   224,    86,    87,
     316,    83,   117,    77,   210,   250,    30,   235,   253,    83,
     224,    32,    33,    34,   129,   130,   224,    77,   133,   134,
     336,    77,    79,    83,   340,    77,    83,    83,   242,    77,
      77,    83,   246,   148,    77,    83,    83,   251,    77,    76,
     274,    94,   269,    80,    83,   251,    14,    15,    16,    17,
      18,    19,    20,    21,   356,    76,    24,    25,    77,    80,
     305,    82,   307,    77,    83,   310,   311,   193,    77,    83,
      77,    76,     4,    79,    83,    80,    83,    83,    22,    23,
      83,   357,     4,     5,   360,   325,    77,   378,   316,   303,
      78,   269,   172,   173,   174,   175,   323,   303,   312,    26,
      27,   377,   378,   317,   168,   169,   312,    77,   336,   323,
      99,   325,   340,   176,   177,    98,   330,   362,    99,    97,
     334,   366,    76,    76,    76,   240,   334,    76,   342,    98,
      98,    49,   346,     3,    97,     5,   170,   171,   253,    97,
     346,    97,    81,    77,    77,   323,    97,    77,    83,   363,
     328,    97,    65,   398,   399,    81,   401,   363,    99,    38,
      77,    81,    76,    99,    42,    44,    84,    85,    38,    87,
     415,   416,    51,    43,    44,    81,    77,   303,   356,    81,
     178,    51,   100,   428,    54,    64,   312,    57,   402,   403,
     404,    61,    62,    63,    64,   179,   402,   403,   404,   413,
     180,   334,   181,   118,   328,   182,    85,   413,   137,   423,
     424,   134,   426,   251,   377,   429,    45,   423,   424,   433,
     426,   435,   436,   429,   142,   143,   136,   433,   442,   435,
     436,   321,   148,   246,    -1,    -1,   442,   363,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,    -1,    66,    -1,    -1,    -1,
      -1,    -1,   190,    -1,    -1,    -1,   402,   403,   404,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,    88,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,   424,    -1,
     426,     0,     1,   429,     3,    -1,     5,   433,    -1,   435,
     436,    -1,    -1,    -1,    -1,    -1,   442,   235,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   129,
     130,    -1,    -1,   133,   134,    -1,    35,    -1,    -1,    38,
      -1,    -1,    -1,    -1,    43,    44,    45,    -1,   148,    -1,
      49,    50,    51,    -1,    -1,    54,   274,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,
      -1,     3,    -1,     5,    -1,    -1,    -1,    -1,   316,    -1,
      99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,    -1,
      -1,    -1,   340,    35,    -1,    -1,    38,    -1,    -1,    -1,
      -1,    43,    44,    45,    -1,    -1,    -1,    49,    50,    51,
     240,    -1,    54,    -1,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,   253,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
      -1,    -1,    -1,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    41,    -1,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    -1,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    78,
      79,    -1,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    41,
      -1,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    -1,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    -1,    78,    79,    -1,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    -1,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    -1,    78,    79,    -1,    -1,    -1,    -1,    84,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    41,    -1,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    -1,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,
      78,    -1,    -1,    -1,    -1,    -1,    84,    85,    86,    87,
      88,    89,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    99,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      32,    33,    -1,    -1,    36,    37,    -1,    39,    40,    41,
      -1,    -1,    44,    -1,    46,    47,    48,    -1,    -1,    -1,
      52,    -1,    -1,    55,    -1,    -1,    58,    -1,     3,    -1,
       5,    -1,    -1,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    -1,    78,    -1,    -1,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    -1,    -1,
      35,    -1,    -1,    38,    -1,    -1,    -1,    99,    43,    44,
      45,    -1,    -1,    -1,    49,    50,    51,    -1,    -1,    54,
      -1,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    78,    -1,    -1,     4,    -1,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    32,    33,
      -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,    -1,    -1,
      44,    -1,    -1,    -1,    32,    33,    -1,    -1,    -1,    -1,
      -1,    55,    -1,    -1,    -1,    -1,    44,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    55,    -1,    -1,
      -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      84,    85,    86,    87,    88,    89,    -1,    -1,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    84,    85,    86,    87,
      88,    89,     4,    -1,     6,     7,     8,     9,    10,    11,
      12,    99,    -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      32,    33,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    -1,    -1,    -1,    32,    33,    -1,    -1,
      -1,    -1,    -1,    55,    -1,    -1,    -1,    -1,    44,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    55,
      -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    84,    85,    86,    87,    88,    89,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    99,    84,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    32,    33,    -1,    -1,    -1,    -1,    38,
      -1,    -1,    -1,    -1,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    -1,
      -1,    -1,    61,    62,    63,    64,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    -1,    76,    -1,    78,
      -1,    -1,    -1,    -1,    -1,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    -1,    32,    33,    -1,    -1,    -1,
      -1,    38,    -1,    -1,    -1,    -1,    43,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    -1,    -1,    -1,    61,    62,    63,    64,     4,    -1,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    32,    33,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     4,    44,     6,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    55,
      -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,     6,     7,
       8,     9,    10,    11,    12,    32,    33,    -1,    -1,    -1,
      76,    -1,    78,    79,    80,    -1,    82,    44,    84,    85,
      86,    87,    88,    89,    32,    33,    -1,    -1,    55,    -1,
      -1,    -1,    -1,    -1,    -1,     4,    44,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    55,    56,    76,
      -1,    78,    -1,    80,    -1,    82,    -1,    84,    85,    86,
      87,    88,    89,    32,    33,    -1,    -1,    -1,    76,    -1,
      -1,    -1,    -1,    81,    -1,    44,    84,    85,    86,    87,
      88,    89,    -1,    -1,    -1,     4,    55,     6,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    78,
      -1,    -1,    -1,    32,    33,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,     4,    44,     6,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    55,    -1,    -1,    -1,
      -1,    -1,    -1,     4,    -1,     6,     7,     8,     9,    10,
      11,    12,    32,    33,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    44,    84,    85,    86,    87,    88,
      89,    32,    33,    -1,    -1,    55,    -1,    -1,    -1,    -1,
      -1,    -1,     4,    44,     6,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    55,    -1,    76,    -1,    -1,    -1,
      -1,    81,    -1,    -1,    84,    85,    86,    87,    88,    89,
      32,    33,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      81,    -1,    44,    84,    85,    86,    87,    88,    89,    -1,
      -1,    -1,     4,    55,     6,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,
      32,    33,    84,    85,    86,    87,    88,    89,    -1,    -1,
      -1,     4,    44,     6,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,    -1,
       4,    -1,     6,     7,     8,     9,    10,    11,    12,    32,
      33,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    44,    84,    85,    86,    87,    88,    89,    32,    33,
      -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,    -1,     4,
      44,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    55,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    84,    85,    86,    87,    88,    89,    32,    33,    -1,
      -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    44,
      84,    85,    86,    87,    88,    89,    -1,    -1,    -1,     4,
      55,     6,     7,     8,     9,    10,    11,    12,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    -1,    -1,    -1,    -1,    -1,    32,    33,    84,
      85,    86,    87,    88,    89,    -1,    -1,    -1,     4,    44,
       6,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      55,    -1,    -1,    -1,    -1,    -1,    -1,     4,    -1,     6,
       7,     8,     9,    10,    11,    12,    32,    33,    -1,    -1,
      -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    44,    84,
      85,    86,    87,    88,    89,    32,    33,    -1,    -1,    55,
      -1,    -1,    -1,    -1,    -1,    -1,     4,    44,     6,     7,
       8,     9,    10,    11,    12,    -1,    -1,    -1,    55,    -1,
      76,    -1,    -1,     3,    -1,     5,    -1,    -1,    84,    85,
      86,    87,    88,    89,    32,    33,    -1,    -1,    -1,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    44,    84,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    -1,    55,    38,    -1,
       3,     4,     5,    43,    44,    -1,    -1,    -1,    -1,    -1,
      13,    51,    -1,    -1,    54,    -1,    -1,    57,    76,    -1,
      -1,    61,    62,    63,    64,    -1,    84,    85,    86,    87,
      88,    89,    35,    -1,    -1,    38,    -1,    -1,    -1,    79,
      43,    44,    45,    -1,    -1,    -1,    49,    50,    51,    -1,
      -1,    54,    -1,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,     3,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    76,    77,    -1,    -1,    80,    -1,    -1,
      -1,    -1,    85,    -1,    -1,    -1,    -1,    -1,    -1,     3,
      -1,     5,    -1,    -1,    35,    -1,    -1,    38,    -1,    -1,
      -1,    -1,    43,    44,    45,    -1,    -1,    -1,    49,    50,
      51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    38,    -1,     3,    -1,     5,    43,
      44,    -1,    -1,    -1,    -1,    76,    77,    51,    -1,    80,
      54,    -1,    -1,    57,    85,    -1,    -1,    61,    62,    63,
      64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    38,    -1,    -1,    -1,    79,    43,    44,    45,    -1,
      -1,    -1,    49,    50,    51,    -1,    -1,    54,    -1,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,     3,     4,
       5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      35,    -1,    -1,    38,    -1,    -1,    -1,    -1,    43,    44,
      45,    -1,    -1,    -1,    49,    50,    51,    -1,    -1,    54,
      -1,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
       3,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      13,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    35,    -1,    -1,    38,    -1,    -1,    -1,    -1,
      43,    44,    45,    -1,    -1,    -1,    49,    50,    51,    -1,
      -1,    54,    -1,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,     3,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,    35,     5,    -1,    38,    -1,    -1,
      -1,    -1,    43,    44,    45,    -1,    -1,    -1,    49,    50,
      51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    -1,    35,    -1,    -1,    38,    -1,
      -1,    -1,    -1,    43,    44,    45,    -1,    -1,    -1,    49,
      50,    51,    -1,    -1,    54,    -1,    56,    57,    -1,    59,
      60,    61,    62,    63,    64
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     5,    35,    38,    43,    44,    45,    49,
      50,    51,    54,    56,    57,    59,    60,    61,    62,    63,
      64,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    99,   125,   126,   127,   130,   131,   132,   133,   134,
     140,   141,   146,   147,   158,   173,   174,   175,   177,   178,
     180,   181,   182,   183,     4,    76,    85,    99,   103,   128,
     129,   148,   149,   150,   127,   127,    78,   103,   104,   158,
      78,   104,   127,   127,     0,   174,    76,     6,     7,     8,
       9,    10,    11,    12,    32,    33,    44,    55,    76,    84,
      85,    86,    87,    88,    89,   101,   102,   103,   105,   107,
     108,   109,   110,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   124,   148,   146,   150,   151,    83,    99,
      78,    98,   125,   127,   166,   176,    76,    80,   149,   132,
     135,   136,   137,   146,    78,   143,   144,    78,    13,    77,
     103,   179,    76,    76,    76,   107,   107,    76,    76,   107,
      44,   107,   120,   121,   123,   137,   155,    10,    32,    33,
      34,    76,    80,    82,   109,    85,    90,    91,    86,    87,
      22,    23,    28,    29,    92,    93,    26,    27,    84,    94,
      95,    30,    31,    96,    77,   146,   150,   129,   148,    36,
      37,    39,    40,    41,    46,    47,    48,    52,    58,    65,
      79,    99,   103,   104,   123,   125,   158,   164,   165,   166,
     167,   168,   169,   170,   171,   172,    78,   121,   159,   125,
     166,    13,    77,   103,   127,   152,   153,   154,    56,    81,
     121,   142,   137,    79,   136,    97,   138,   139,   148,   137,
     135,    79,    83,   103,   145,   143,    83,    77,   107,   107,
      44,    78,   155,    76,   123,    14,    15,    16,    17,    18,
      19,    20,    21,    24,    25,    98,   122,    77,    83,    76,
      80,   150,   156,   157,    77,   104,    77,   106,   121,   123,
     104,   109,   109,   109,   110,   110,   111,   111,   112,   112,
     112,   112,   113,   113,   114,   115,   116,   117,   118,   123,
      99,   124,    99,    97,   164,    76,   104,    76,    99,   123,
      76,    76,    97,    99,    79,   168,    80,    82,   159,   160,
     161,   162,   163,    76,   148,   150,   156,    77,    83,    77,
      83,    81,   121,   124,    83,    99,    97,    79,    79,   145,
      98,    79,    83,   179,    77,    77,   167,    77,   121,   121,
      77,   152,   156,    81,   121,   157,    76,    80,   109,    77,
      83,    81,    97,    97,   164,    65,    99,   123,    99,   123,
      99,   123,   123,   164,   124,   103,    79,    83,    98,   163,
     153,   103,    81,   139,   124,   124,    79,    79,    77,    77,
      81,    77,   152,    81,   121,   121,   123,   164,    76,    99,
     123,    99,    77,    77,    77,    81,    79,   161,   159,    77,
      77,    81,   123,    77,   123,    99,    99,   123,   164,   164,
     164,    77,   164,    77,    77,   123,    77,   123,    99,    42,
      99,   164,   164,    77,   164,    77,    77,   123,   164,   164,
     164,   164,    77,   164
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   100,   101,   101,   101,   101,   101,   101,   101,   101,
     102,   102,   103,   104,   104,   105,   105,   105,   105,   105,
     105,   105,   105,   106,   106,   107,   107,   107,   107,   107,
     107,   107,   107,   108,   108,   108,   108,   108,   108,   109,
     109,   110,   110,   110,   110,   111,   111,   111,   112,   112,
     112,   113,   113,   113,   113,   113,   114,   114,   114,   115,
     115,   116,   116,   117,   117,   118,   118,   119,   119,   120,
     120,   121,   121,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   123,   123,   123,   124,   125,   125,
     126,   127,   127,   127,   127,   127,   127,   127,   127,   128,
     128,   129,   129,   130,   130,   130,   130,   130,   130,   131,
     132,   132,   132,   132,   132,   132,   132,   133,   133,   133,
     134,   134,   135,   135,   136,   137,   137,   137,   137,   138,
     138,   139,   139,   139,   139,   140,   140,   140,   140,   140,
     141,   142,   144,   143,   143,   145,   145,   146,   146,   146,
     146,   147,   148,   148,   149,   149,   149,   149,   149,   149,
     149,   149,   150,   150,   150,   150,   151,   151,   152,   152,
     153,   153,   153,   153,   154,   154,   155,   155,   156,   156,
     156,   157,   157,   157,   157,   157,   157,   157,   157,   157,
     158,   159,   159,   159,   160,   160,   161,   161,   162,   162,
     163,   163,   164,   164,   164,   164,   164,   164,   165,   165,
     165,   166,   166,   167,   167,   168,   168,   169,   169,   170,
     170,   170,   171,   171,   171,   171,   171,   171,   171,   171,
     171,   171,   172,   172,   172,   172,   172,   173,   173,   174,
     174,   174,   174,   175,   175,   176,   176,   177,   178,   179,
     179,   179,   180,   180,   181,   182,   182,   182,   182,   182,
     182,   182,   182,   183,   183,   183,   183
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     3,     6,
       1,     2,     1,     1,     1,     1,     4,     4,     3,     3,
       3,     2,     2,     1,     3,     1,     2,     2,     2,     4,
       4,     2,     4,     1,     1,     1,     1,     1,     1,     1,
       4,     1,     3,     3,     3,     1,     3,     3,     1,     3,
       3,     1,     3,     3,     3,     3,     1,     3,     3,     1,
       3,     1,     3,     1,     3,     1,     3,     1,     3,     1,
       5,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     3,     2,
       1,     2,     1,     2,     1,     2,     1,     2,     1,     1,
       3,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     5,     4,     2,
       1,     1,     1,     2,     3,     2,     1,     2,     1,     1,
       3,     0,     1,     2,     3,     5,     4,     6,     5,     2,
       1,     1,     0,     2,     3,     1,     3,     1,     1,     1,
       1,     1,     2,     1,     1,     3,     5,     4,     3,     4,
       4,     3,     2,     1,     3,     2,     1,     2,     1,     3,
       2,     2,     1,     1,     1,     3,     1,     2,     1,     1,
       2,     3,     2,     3,     3,     4,     2,     3,     3,     4,
       1,     1,     3,     4,     1,     3,     3,     1,     1,     2,
       3,     2,     1,     1,     1,     1,     1,     1,     3,     4,
       3,     2,     3,     1,     2,     1,     1,     1,     2,     5,
       7,     5,     5,     7,     6,     7,     7,     8,     7,     8,
       8,     9,     3,     2,     2,     2,     3,     1,     2,     1,
       1,     1,     1,     4,     3,     1,     2,     1,     1,     1,
       1,     3,     4,     3,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, GISourceScanner* scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, GISourceScanner* scanner)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (GISourceScanner* scanner)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* primary_expression: identifier  */
#line 350 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = g_hash_table_lookup (scanner->const_table, (yyvsp[0].str));
		if ((yyval.symbol) == NULL) {
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		} else {
			(yyval.symbol) = gi_source_symbol_ref ((yyval.symbol));
		}
	  }
#line 2499 "giscanner/scannerparser.c"
    break;

  case 3: /* primary_expression: INTEGER  */
#line 359 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		char *rest;
		guint64 value;
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if (g_str_has_prefix (yytext, "0x") && strlen (yytext) > 2) {
			value = g_ascii_strtoull (yytext + 2, &rest, 16);
		} else if (g_str_has_prefix (yytext, "0") && strlen (yytext) > 1) {
			value = g_ascii_strtoull (yytext + 1, &rest, 8);
		} else {
			value = g_ascii_strtoull (yytext, &rest, 10);
		}
		(yyval.symbol)->const_int = value;
		(yyval.symbol)->const_int_is_unsigned = (rest && (rest[0] == 'U'));
	  }
#line 2519 "giscanner/scannerparser.c"
    break;

  case 4: /* primary_expression: BOOLEAN  */
#line 375 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_boolean_set = TRUE;
		(yyval.symbol)->const_boolean = g_ascii_strcasecmp (yytext, "true") == 0 ? TRUE : FALSE;
	  }
#line 2529 "giscanner/scannerparser.c"
    break;

  case 5: /* primary_expression: CHARACTER  */
#line 381 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = g_utf8_get_char(yytext + 1);
	  }
#line 2539 "giscanner/scannerparser.c"
    break;

  case 6: /* primary_expression: FLOATING  */
#line 387 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_double_set = TRUE;
		(yyval.symbol)->const_double = 0.0;
        sscanf (yytext, "%lf", &((yyval.symbol)->const_double));
	  }
#line 2550 "giscanner/scannerparser.c"
    break;

  case 8: /* primary_expression: '(' expression ')'  */
#line 395 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 2558 "giscanner/scannerparser.c"
    break;

  case 9: /* primary_expression: EXTENSION '(' '{' block_item_list '}' ')'  */
#line 399 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2566 "giscanner/scannerparser.c"
    break;

  case 10: /* strings: STRING  */
#line 407 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		yytext[strlen (yytext) - 1] = '\0';
		(yyval.symbol)->const_string = parse_c_string_literal (yytext + 1);
                if (!g_utf8_validate ((yyval.symbol)->const_string, -1, NULL))
                  {
#if 0
                    g_warning ("Ignoring non-UTF-8 constant string \"%s\"", yytext + 1);
#endif
                    g_free((yyval.symbol)->const_string);
                    (yyval.symbol)->const_string = NULL;
                  }

	  }
#line 2585 "giscanner/scannerparser.c"
    break;

  case 11: /* strings: strings STRING  */
#line 422 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		char *strings, *string2;
		(yyval.symbol) = (yyvsp[-1].symbol);
		yytext[strlen (yytext) - 1] = '\0';
		string2 = parse_c_string_literal (yytext + 1);
		strings = g_strconcat ((yyval.symbol)->const_string, string2, NULL);
		g_free ((yyval.symbol)->const_string);
		g_free (string2);
		(yyval.symbol)->const_string = strings;
	  }
#line 2600 "giscanner/scannerparser.c"
    break;

  case 12: /* identifier: "identifier"  */
#line 436 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 2608 "giscanner/scannerparser.c"
    break;

  case 16: /* postfix_expression: postfix_expression '[' expression ']'  */
#line 449 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2616 "giscanner/scannerparser.c"
    break;

  case 17: /* postfix_expression: postfix_expression '(' argument_expression_list ')'  */
#line 453 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2624 "giscanner/scannerparser.c"
    break;

  case 18: /* postfix_expression: postfix_expression '(' ')'  */
#line 457 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2632 "giscanner/scannerparser.c"
    break;

  case 19: /* postfix_expression: postfix_expression '.' identifier_or_typedef_name  */
#line 461 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2640 "giscanner/scannerparser.c"
    break;

  case 20: /* postfix_expression: postfix_expression ARROW identifier_or_typedef_name  */
#line 465 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2648 "giscanner/scannerparser.c"
    break;

  case 21: /* postfix_expression: postfix_expression PLUSPLUS  */
#line 469 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2656 "giscanner/scannerparser.c"
    break;

  case 22: /* postfix_expression: postfix_expression MINUSMINUS  */
#line 473 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2664 "giscanner/scannerparser.c"
    break;

  case 26: /* unary_expression: PLUSPLUS unary_expression  */
#line 486 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2672 "giscanner/scannerparser.c"
    break;

  case 27: /* unary_expression: MINUSMINUS unary_expression  */
#line 490 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2680 "giscanner/scannerparser.c"
    break;

  case 28: /* unary_expression: unary_operator cast_expression  */
#line 494 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		switch ((yyvsp[-1].unary_operator)) {
		case UNARY_PLUS:
			(yyval.symbol) = (yyvsp[0].symbol);
			break;
		case UNARY_MINUS:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = -(yyvsp[0].symbol)->const_int;
			break;
		case UNARY_BITWISE_COMPLEMENT:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = ~(yyvsp[0].symbol)->const_int;
			break;
		case UNARY_LOGICAL_NEGATION:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[0].symbol));
			(yyval.symbol)->const_int = !gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
			break;
		default:
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
			break;
		}
	  }
#line 2707 "giscanner/scannerparser.c"
    break;

  case 29: /* unary_expression: INTL_CONST '(' unary_expression ')'  */
#line 517 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ((yyval.symbol)->const_int_is_unsigned ? "guint64" : "gint64");
		}
	  }
#line 2718 "giscanner/scannerparser.c"
    break;

  case 30: /* unary_expression: INTUL_CONST '(' unary_expression ')'  */
#line 524 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ("guint64");
		}
	  }
#line 2729 "giscanner/scannerparser.c"
    break;

  case 31: /* unary_expression: SIZEOF unary_expression  */
#line 531 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2737 "giscanner/scannerparser.c"
    break;

  case 32: /* unary_expression: SIZEOF '(' type_name ')'  */
#line 535 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 2746 "giscanner/scannerparser.c"
    break;

  case 33: /* unary_operator: '&'  */
#line 543 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_ADDRESS_OF;
	  }
#line 2754 "giscanner/scannerparser.c"
    break;

  case 34: /* unary_operator: '*'  */
#line 547 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_POINTER_INDIRECTION;
	  }
#line 2762 "giscanner/scannerparser.c"
    break;

  case 35: /* unary_operator: '+'  */
#line 551 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_PLUS;
	  }
#line 2770 "giscanner/scannerparser.c"
    break;

  case 36: /* unary_operator: '-'  */
#line 555 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_MINUS;
	  }
#line 2778 "giscanner/scannerparser.c"
    break;

  case 37: /* unary_operator: '~'  */
#line 559 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_BITWISE_COMPLEMENT;
	  }
#line 2786 "giscanner/scannerparser.c"
    break;

  case 38: /* unary_operator: '!'  */
#line 563 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.unary_operator) = UNARY_LOGICAL_NEGATION;
	  }
#line 2794 "giscanner/scannerparser.c"
    break;

  case 40: /* cast_expression: '(' type_name ')' cast_expression  */
#line 571 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		if ((yyval.symbol)->const_int_set || (yyval.symbol)->const_double_set || (yyval.symbol)->const_string != NULL) {
			(yyval.symbol)->base_type = (yyvsp[-2].ctype);
		} else {
			ctype_free ((yyvsp[-2].ctype));
		}
	  }
#line 2807 "giscanner/scannerparser.c"
    break;

  case 42: /* multiplicative_expression: multiplicative_expression '*' cast_expression  */
#line 584 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int * (yyvsp[0].symbol)->const_int;
	  }
#line 2817 "giscanner/scannerparser.c"
    break;

  case 43: /* multiplicative_expression: multiplicative_expression '/' cast_expression  */
#line 590 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[0].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int / (yyvsp[0].symbol)->const_int;
		}
	  }
#line 2829 "giscanner/scannerparser.c"
    break;

  case 44: /* multiplicative_expression: multiplicative_expression '%' cast_expression  */
#line 598 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[0].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int % (yyvsp[0].symbol)->const_int;
		}
	  }
#line 2841 "giscanner/scannerparser.c"
    break;

  case 46: /* additive_expression: additive_expression '+' multiplicative_expression  */
#line 610 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int + (yyvsp[0].symbol)->const_int;
	  }
#line 2851 "giscanner/scannerparser.c"
    break;

  case 47: /* additive_expression: additive_expression '-' multiplicative_expression  */
#line 616 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int - (yyvsp[0].symbol)->const_int;
	  }
#line 2861 "giscanner/scannerparser.c"
    break;

  case 49: /* shift_expression: shift_expression SL additive_expression  */
#line 626 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int << (yyvsp[0].symbol)->const_int;

		/* assume this is a bitfield/flags declaration
		 * if a left shift operator is sued in an enum value
                 * This mimics the glib-mkenum behavior.
		 */
		is_bitfield = TRUE;
	  }
#line 2877 "giscanner/scannerparser.c"
    break;

  case 50: /* shift_expression: shift_expression SR additive_expression  */
#line 638 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int >> (yyvsp[0].symbol)->const_int;
	  }
#line 2887 "giscanner/scannerparser.c"
    break;

  case 52: /* relational_expression: relational_expression '<' shift_expression  */
#line 648 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int < (yyvsp[0].symbol)->const_int;
	  }
#line 2897 "giscanner/scannerparser.c"
    break;

  case 53: /* relational_expression: relational_expression '>' shift_expression  */
#line 654 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int > (yyvsp[0].symbol)->const_int;
	  }
#line 2907 "giscanner/scannerparser.c"
    break;

  case 54: /* relational_expression: relational_expression LTEQ shift_expression  */
#line 660 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int <= (yyvsp[0].symbol)->const_int;
	  }
#line 2917 "giscanner/scannerparser.c"
    break;

  case 55: /* relational_expression: relational_expression GTEQ shift_expression  */
#line 666 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int >= (yyvsp[0].symbol)->const_int;
	  }
#line 2927 "giscanner/scannerparser.c"
    break;

  case 57: /* equality_expression: equality_expression EQ relational_expression  */
#line 676 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int == (yyvsp[0].symbol)->const_int;
	  }
#line 2937 "giscanner/scannerparser.c"
    break;

  case 58: /* equality_expression: equality_expression NOTEQ relational_expression  */
#line 682 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int != (yyvsp[0].symbol)->const_int;
	  }
#line 2947 "giscanner/scannerparser.c"
    break;

  case 60: /* and_expression: and_expression '&' equality_expression  */
#line 692 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int & (yyvsp[0].symbol)->const_int;
	  }
#line 2957 "giscanner/scannerparser.c"
    break;

  case 62: /* exclusive_or_expression: exclusive_or_expression '^' and_expression  */
#line 702 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int ^ (yyvsp[0].symbol)->const_int;
	  }
#line 2967 "giscanner/scannerparser.c"
    break;

  case 64: /* inclusive_or_expression: inclusive_or_expression '|' exclusive_or_expression  */
#line 712 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[-2].symbol)->const_int | (yyvsp[0].symbol)->const_int;
	  }
#line 2977 "giscanner/scannerparser.c"
    break;

  case 66: /* logical_and_expression: logical_and_expression ANDAND inclusive_or_expression  */
#line 722 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[-2].symbol)) &&
		  gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
	  }
#line 2989 "giscanner/scannerparser.c"
    break;

  case 68: /* logical_or_expression: logical_or_expression OROR logical_and_expression  */
#line 734 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[-2].symbol)) ||
		  gi_source_symbol_get_const_boolean ((yyvsp[0].symbol));
	  }
#line 3001 "giscanner/scannerparser.c"
    break;

  case 70: /* conditional_expression: logical_or_expression '?' expression ':' expression  */
#line 746 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_get_const_boolean ((yyvsp[-4].symbol)) ? (yyvsp[-2].symbol) : (yyvsp[0].symbol);
	  }
#line 3009 "giscanner/scannerparser.c"
    break;

  case 72: /* assignment_expression: unary_expression assignment_operator assignment_expression  */
#line 754 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3017 "giscanner/scannerparser.c"
    break;

  case 86: /* expression: EXTENSION expression  */
#line 777 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3025 "giscanner/scannerparser.c"
    break;

  case 88: /* declaration: declaration_specifiers init_declarator_list ';'  */
#line 790 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GList *l;
		for (l = (yyvsp[-1].list); l != NULL; l = l->next) {
			GISourceSymbol *sym = l->data;
			gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[-2].ctype)));
			if ((yyvsp[-2].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF) {
				sym->type = CSYMBOL_TYPE_TYPEDEF;
			} else if (sym->base_type->type == CTYPE_FUNCTION) {
				sym->type = CSYMBOL_TYPE_FUNCTION;
			} else {
				sym->type = CSYMBOL_TYPE_OBJECT;
			}
			gi_source_scanner_add_symbol (scanner, sym);
			gi_source_symbol_unref (sym);
		}
		ctype_free ((yyvsp[-2].ctype));
	  }
#line 3047 "giscanner/scannerparser.c"
    break;

  case 89: /* declaration: declaration_specifiers ';'  */
#line 808 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		ctype_free ((yyvsp[-1].ctype));
	  }
#line 3055 "giscanner/scannerparser.c"
    break;

  case 91: /* declaration_specifiers: storage_class_specifier declaration_specifiers  */
#line 818 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[-1].storage_class_specifier);
	  }
#line 3064 "giscanner/scannerparser.c"
    break;

  case 92: /* declaration_specifiers: storage_class_specifier  */
#line 823 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[0].storage_class_specifier);
	  }
#line 3073 "giscanner/scannerparser.c"
    break;

  case 93: /* declaration_specifiers: type_specifier declaration_specifiers  */
#line 828 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		set_or_merge_base_type ((yyvsp[-1].ctype), (yyvsp[0].ctype));
	  }
#line 3082 "giscanner/scannerparser.c"
    break;

  case 95: /* declaration_specifiers: type_qualifier declaration_specifiers  */
#line 834 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[-1].type_qualifier);
	  }
#line 3091 "giscanner/scannerparser.c"
    break;

  case 96: /* declaration_specifiers: type_qualifier  */
#line 839 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[0].type_qualifier);
	  }
#line 3100 "giscanner/scannerparser.c"
    break;

  case 97: /* declaration_specifiers: function_specifier declaration_specifiers  */
#line 844 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->function_specifier |= (yyvsp[-1].function_specifier);
	  }
#line 3109 "giscanner/scannerparser.c"
    break;

  case 98: /* declaration_specifiers: function_specifier  */
#line 849 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->function_specifier |= (yyvsp[0].function_specifier);
	  }
#line 3118 "giscanner/scannerparser.c"
    break;

  case 99: /* init_declarator_list: init_declarator  */
#line 857 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3126 "giscanner/scannerparser.c"
    break;

  case 100: /* init_declarator_list: init_declarator_list ',' init_declarator  */
#line 861 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3134 "giscanner/scannerparser.c"
    break;

  case 103: /* storage_class_specifier: TYPEDEF  */
#line 873 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_TYPEDEF;
	  }
#line 3142 "giscanner/scannerparser.c"
    break;

  case 104: /* storage_class_specifier: EXTERN  */
#line 877 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_EXTERN;
	  }
#line 3150 "giscanner/scannerparser.c"
    break;

  case 105: /* storage_class_specifier: STATIC  */
#line 881 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_STATIC;
	  }
#line 3158 "giscanner/scannerparser.c"
    break;

  case 106: /* storage_class_specifier: AUTO  */
#line 885 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_AUTO;
	  }
#line 3166 "giscanner/scannerparser.c"
    break;

  case 107: /* storage_class_specifier: REGISTER  */
#line 889 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_REGISTER;
	  }
#line 3174 "giscanner/scannerparser.c"
    break;

  case 108: /* storage_class_specifier: THREAD_LOCAL  */
#line 893 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.storage_class_specifier) = STORAGE_CLASS_THREAD_LOCAL;
	  }
#line 3182 "giscanner/scannerparser.c"
    break;

  case 109: /* basic_type: BASIC_TYPE  */
#line 900 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 3190 "giscanner/scannerparser.c"
    break;

  case 110: /* type_specifier: VOID  */
#line 907 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_VOID);
	  }
#line 3198 "giscanner/scannerparser.c"
    break;

  case 111: /* type_specifier: SIGNED  */
#line 911 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("signed");
	  }
#line 3206 "giscanner/scannerparser.c"
    break;

  case 112: /* type_specifier: UNSIGNED  */
#line 915 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_basic_type_new ("unsigned");
	  }
#line 3214 "giscanner/scannerparser.c"
    break;

  case 113: /* type_specifier: basic_type  */
#line 919 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_BASIC_TYPE);
		(yyval.ctype)->name = (yyvsp[0].str);
	  }
#line 3223 "giscanner/scannerparser.c"
    break;

  case 116: /* type_specifier: typedef_name  */
#line 926 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_typedef_new ((yyvsp[0].str));
		g_free ((yyvsp[0].str));
	  }
#line 3232 "giscanner/scannerparser.c"
    break;

  case 117: /* struct_or_union_specifier: struct_or_union identifier_or_typedef_name '{' struct_declaration_list '}'  */
#line 934 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym;
		(yyval.ctype) = (yyvsp[-4].ctype);
		(yyval.ctype)->name = (yyvsp[-3].str);
		(yyval.ctype)->child_list = (yyvsp[-1].list);

		sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		if ((yyval.ctype)->type == CTYPE_STRUCT) {
			sym->type = CSYMBOL_TYPE_STRUCT;
		} else if ((yyval.ctype)->type == CTYPE_UNION) {
			sym->type = CSYMBOL_TYPE_UNION;
		} else {
			g_assert_not_reached ();
		}
		sym->ident = g_strdup ((yyval.ctype)->name);
		sym->base_type = gi_source_type_copy ((yyval.ctype));
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	  }
#line 3256 "giscanner/scannerparser.c"
    break;

  case 118: /* struct_or_union_specifier: struct_or_union '{' struct_declaration_list '}'  */
#line 954 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-3].ctype);
		(yyval.ctype)->child_list = (yyvsp[-1].list);
	  }
#line 3265 "giscanner/scannerparser.c"
    break;

  case 119: /* struct_or_union_specifier: struct_or_union identifier_or_typedef_name  */
#line 959 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		(yyval.ctype)->name = (yyvsp[0].str);
	  }
#line 3274 "giscanner/scannerparser.c"
    break;

  case 120: /* struct_or_union: STRUCT  */
#line 967 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_struct_new (NULL);
	  }
#line 3283 "giscanner/scannerparser.c"
    break;

  case 121: /* struct_or_union: UNION  */
#line 972 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_union_new (NULL);
	  }
#line 3292 "giscanner/scannerparser.c"
    break;

  case 123: /* struct_declaration_list: struct_declaration_list struct_declaration  */
#line 981 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_concat ((yyvsp[-1].list), (yyvsp[0].list));
	  }
#line 3300 "giscanner/scannerparser.c"
    break;

  case 124: /* struct_declaration: specifier_qualifier_list struct_declarator_list ';'  */
#line 988 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
	    GList *l;
	    (yyval.list) = NULL;
	    for (l = (yyvsp[-1].list); l != NULL; l = l->next)
	      {
		GISourceSymbol *sym = l->data;
		if ((yyvsp[-2].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF)
		    sym->type = CSYMBOL_TYPE_TYPEDEF;
		else
		    sym->type = CSYMBOL_TYPE_MEMBER;
		gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[-2].ctype)));
                sym->private = scanner->private;
                (yyval.list) = g_list_append ((yyval.list), sym);
	      }
	    ctype_free ((yyvsp[-2].ctype));
	  }
#line 3321 "giscanner/scannerparser.c"
    break;

  case 125: /* specifier_qualifier_list: type_specifier specifier_qualifier_list  */
#line 1008 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[-1].ctype);
		set_or_merge_base_type ((yyvsp[-1].ctype), (yyvsp[0].ctype));
	  }
#line 3330 "giscanner/scannerparser.c"
    break;

  case 127: /* specifier_qualifier_list: type_qualifier specifier_qualifier_list  */
#line 1014 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = (yyvsp[0].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[-1].type_qualifier);
	  }
#line 3339 "giscanner/scannerparser.c"
    break;

  case 128: /* specifier_qualifier_list: type_qualifier  */
#line 1019 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[0].type_qualifier);
	  }
#line 3348 "giscanner/scannerparser.c"
    break;

  case 129: /* struct_declarator_list: struct_declarator  */
#line 1027 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3356 "giscanner/scannerparser.c"
    break;

  case 130: /* struct_declarator_list: struct_declarator_list ',' struct_declarator  */
#line 1031 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3364 "giscanner/scannerparser.c"
    break;

  case 131: /* struct_declarator: %empty  */
#line 1038 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3372 "giscanner/scannerparser.c"
    break;

  case 133: /* struct_declarator: ':' constant_expression  */
#line 1043 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
#line 3380 "giscanner/scannerparser.c"
    break;

  case 134: /* struct_declarator: declarator ':' constant_expression  */
#line 1047 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		if ((yyvsp[0].symbol)->const_int_set) {
		  (yyval.symbol)->const_int_set = TRUE;
		  (yyval.symbol)->const_int = (yyvsp[0].symbol)->const_int;
		}
	  }
#line 3392 "giscanner/scannerparser.c"
    break;

  case 135: /* enum_specifier: enum_keyword identifier_or_typedef_name '{' enumerator_list '}'  */
#line 1058 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[-3].str));
		(yyval.ctype)->child_list = (yyvsp[-1].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3403 "giscanner/scannerparser.c"
    break;

  case 136: /* enum_specifier: enum_keyword '{' enumerator_list '}'  */
#line 1065 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[-1].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3414 "giscanner/scannerparser.c"
    break;

  case 137: /* enum_specifier: enum_keyword identifier_or_typedef_name '{' enumerator_list ',' '}'  */
#line 1072 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[-4].str));
		(yyval.ctype)->child_list = (yyvsp[-2].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3425 "giscanner/scannerparser.c"
    break;

  case 138: /* enum_specifier: enum_keyword '{' enumerator_list ',' '}'  */
#line 1079 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[-2].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
#line 3436 "giscanner/scannerparser.c"
    break;

  case 139: /* enum_specifier: enum_keyword identifier_or_typedef_name  */
#line 1086 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[0].str));
	  }
#line 3444 "giscanner/scannerparser.c"
    break;

  case 140: /* enum_keyword: ENUM  */
#line 1093 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
                scanner->flags = FALSE;
                scanner->private = FALSE;
          }
#line 3453 "giscanner/scannerparser.c"
    break;

  case 141: /* static_keyword: STATIC  */
#line 1101 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
          }
#line 3460 "giscanner/scannerparser.c"
    break;

  case 142: /* $@1: %empty  */
#line 1107 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		/* reset flag before the first enum value */
		is_bitfield = FALSE;
	  }
#line 3469 "giscanner/scannerparser.c"
    break;

  case 143: /* enumerator_list: $@1 enumerator  */
#line 1112 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
            (yyvsp[0].symbol)->private = scanner->private;
            (yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3478 "giscanner/scannerparser.c"
    break;

  case 144: /* enumerator_list: enumerator_list ',' enumerator  */
#line 1117 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
            (yyvsp[0].symbol)->private = scanner->private;
            (yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3487 "giscanner/scannerparser.c"
    break;

  case 145: /* enumerator: identifier  */
#line 1125 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[0].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = ++last_enum_value;
		g_hash_table_insert (scanner->const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
#line 3499 "giscanner/scannerparser.c"
    break;

  case 146: /* enumerator: identifier '=' constant_expression  */
#line 1133 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[-2].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[0].symbol)->const_int;
		last_enum_value = (yyval.symbol)->const_int;
		g_hash_table_insert (scanner->const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
#line 3512 "giscanner/scannerparser.c"
    break;

  case 147: /* type_qualifier: CONST  */
#line 1145 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_CONST;
	  }
#line 3520 "giscanner/scannerparser.c"
    break;

  case 148: /* type_qualifier: RESTRICT  */
#line 1149 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_RESTRICT;
	  }
#line 3528 "giscanner/scannerparser.c"
    break;

  case 149: /* type_qualifier: EXTENSION  */
#line 1153 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_EXTENSION;
	  }
#line 3536 "giscanner/scannerparser.c"
    break;

  case 150: /* type_qualifier: VOLATILE  */
#line 1157 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = TYPE_QUALIFIER_VOLATILE;
	  }
#line 3544 "giscanner/scannerparser.c"
    break;

  case 151: /* function_specifier: INLINE  */
#line 1164 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.function_specifier) = FUNCTION_INLINE;
	  }
#line 3552 "giscanner/scannerparser.c"
    break;

  case 152: /* declarator: pointer direct_declarator  */
#line 1171 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3561 "giscanner/scannerparser.c"
    break;

  case 154: /* direct_declarator: identifier  */
#line 1180 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[0].str);
	  }
#line 3570 "giscanner/scannerparser.c"
    break;

  case 155: /* direct_declarator: '(' declarator ')'  */
#line 1185 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 3578 "giscanner/scannerparser.c"
    break;

  case 156: /* direct_declarator: direct_declarator '[' static_keyword assignment_expression ']'  */
#line 1189 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
                (yyval.symbol) = (yyvsp[-4].symbol);
                gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
          }
#line 3587 "giscanner/scannerparser.c"
    break;

  case 157: /* direct_declarator: direct_declarator '[' assignment_expression ']'  */
#line 1194 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3596 "giscanner/scannerparser.c"
    break;

  case 158: /* direct_declarator: direct_declarator '[' ']'  */
#line 1199 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3605 "giscanner/scannerparser.c"
    break;

  case 159: /* direct_declarator: direct_declarator '(' parameter_list ')'  */
#line 1204 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3619 "giscanner/scannerparser.c"
    break;

  case 160: /* direct_declarator: direct_declarator '(' identifier_list ')'  */
#line 1214 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		func->child_list = (yyvsp[-1].list);
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3630 "giscanner/scannerparser.c"
    break;

  case 161: /* direct_declarator: direct_declarator '(' ')'  */
#line 1221 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3640 "giscanner/scannerparser.c"
    break;

  case 162: /* pointer: '*' type_qualifier_list  */
#line 1230 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_pointer_new (NULL);
		(yyval.ctype)->type_qualifier = (yyvsp[0].type_qualifier);
	  }
#line 3649 "giscanner/scannerparser.c"
    break;

  case 163: /* pointer: '*'  */
#line 1235 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.ctype) = gi_source_pointer_new (NULL);
	  }
#line 3657 "giscanner/scannerparser.c"
    break;

  case 164: /* pointer: '*' type_qualifier_list pointer  */
#line 1239 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType **base = &((yyvsp[0].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(*base)->type_qualifier = (yyvsp[-1].type_qualifier);
		(yyval.ctype) = (yyvsp[0].ctype);
	  }
#line 3672 "giscanner/scannerparser.c"
    break;

  case 165: /* pointer: '*' pointer  */
#line 1250 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType **base = &((yyvsp[0].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(yyval.ctype) = (yyvsp[0].ctype);
	  }
#line 3686 "giscanner/scannerparser.c"
    break;

  case 167: /* type_qualifier_list: type_qualifier_list type_qualifier  */
#line 1264 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.type_qualifier) = (yyvsp[-1].type_qualifier) | (yyvsp[0].type_qualifier);
	  }
#line 3694 "giscanner/scannerparser.c"
    break;

  case 168: /* parameter_list: parameter_declaration  */
#line 1271 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append (NULL, (yyvsp[0].symbol));
	  }
#line 3702 "giscanner/scannerparser.c"
    break;

  case 169: /* parameter_list: parameter_list ',' parameter_declaration  */
#line 1275 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.list) = g_list_append ((yyvsp[-2].list), (yyvsp[0].symbol));
	  }
#line 3710 "giscanner/scannerparser.c"
    break;

  case 170: /* parameter_declaration: declaration_specifiers declarator  */
#line 1282 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3719 "giscanner/scannerparser.c"
    break;

  case 171: /* parameter_declaration: declaration_specifiers abstract_declarator  */
#line 1287 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3728 "giscanner/scannerparser.c"
    break;

  case 172: /* parameter_declaration: declaration_specifiers  */
#line 1292 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->base_type = (yyvsp[0].ctype);
	  }
#line 3737 "giscanner/scannerparser.c"
    break;

  case 173: /* parameter_declaration: ELLIPSIS  */
#line 1297 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, scanner->current_file, lineno);
	  }
#line 3745 "giscanner/scannerparser.c"
    break;

  case 174: /* identifier_list: identifier  */
#line 1304 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 3755 "giscanner/scannerparser.c"
    break;

  case 175: /* identifier_list: identifier_list ',' identifier  */
#line 1310 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append ((yyvsp[-2].list), sym);
	  }
#line 3765 "giscanner/scannerparser.c"
    break;

  case 178: /* abstract_declarator: pointer  */
#line 1324 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[0].ctype));
	  }
#line 3774 "giscanner/scannerparser.c"
    break;

  case 180: /* abstract_declarator: pointer direct_abstract_declarator  */
#line 1330 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[0].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[-1].ctype));
	  }
#line 3783 "giscanner/scannerparser.c"
    break;

  case 181: /* direct_abstract_declarator: '(' abstract_declarator ')'  */
#line 1338 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-1].symbol);
	  }
#line 3791 "giscanner/scannerparser.c"
    break;

  case 182: /* direct_abstract_declarator: '[' ']'  */
#line 1342 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3800 "giscanner/scannerparser.c"
    break;

  case 183: /* direct_abstract_declarator: '[' assignment_expression ']'  */
#line 1347 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3809 "giscanner/scannerparser.c"
    break;

  case 184: /* direct_abstract_declarator: direct_abstract_declarator '[' ']'  */
#line 1352 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
#line 3818 "giscanner/scannerparser.c"
    break;

  case 185: /* direct_abstract_declarator: direct_abstract_declarator '[' assignment_expression ']'  */
#line 1357 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[-1].symbol)));
	  }
#line 3827 "giscanner/scannerparser.c"
    break;

  case 186: /* direct_abstract_declarator: '(' ')'  */
#line 1362 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3837 "giscanner/scannerparser.c"
    break;

  case 187: /* direct_abstract_declarator: '(' parameter_list ')'  */
#line 1368 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3851 "giscanner/scannerparser.c"
    break;

  case 188: /* direct_abstract_declarator: direct_abstract_declarator '(' ')'  */
#line 1378 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[-2].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3861 "giscanner/scannerparser.c"
    break;

  case 189: /* direct_abstract_declarator: direct_abstract_declarator '(' parameter_list ')'  */
#line 1384 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[-1].list) != NULL && ((yyvsp[-1].list)->next != NULL || ((GISourceSymbol *) (yyvsp[-1].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[-1].list);
		}
		(yyval.symbol) = (yyvsp[-3].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
#line 3875 "giscanner/scannerparser.c"
    break;

  case 190: /* typedef_name: "typedef-name"  */
#line 1397 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext);
	  }
#line 3883 "giscanner/scannerparser.c"
    break;

  case 247: /* function_macro: FUNCTION_MACRO  */
#line 1520 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
#line 3891 "giscanner/scannerparser.c"
    break;

  case 248: /* object_macro: OBJECT_MACRO  */
#line 1527 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
#line 3899 "giscanner/scannerparser.c"
    break;

  case 249: /* function_macro_argument_list: identifier  */
#line 1534 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[0].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 3909 "giscanner/scannerparser.c"
    break;

  case 250: /* function_macro_argument_list: ELLIPSIS  */
#line 1540 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, scanner->current_file, lineno);
		(yyval.list) = g_list_append (NULL, sym);
	  }
#line 3918 "giscanner/scannerparser.c"
    break;

  case 251: /* function_macro_argument_list: identifier ',' function_macro_argument_list  */
#line 1545 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[-2].str);
		(yyval.list) = g_list_prepend ((yyvsp[0].list), sym);
	  }
#line 3928 "giscanner/scannerparser.c"
    break;

  case 252: /* function_macro_define: function_macro '(' function_macro_argument_list ')'  */
#line 1554 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
           {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_FUNCTION_MACRO, scanner->current_file, lineno);
		GISourceType *func = gi_source_function_new ();
		sym->ident = g_strdup ((yyvsp[-3].str));
		func->child_list = (yyvsp[-1].list);
		gi_source_symbol_merge_type (sym, func);
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	   }
#line 3942 "giscanner/scannerparser.c"
    break;

  case 253: /* function_macro_define: function_macro '(' ')'  */
#line 1564 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
           {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_FUNCTION_MACRO, scanner->current_file, lineno);
		GISourceType *func = gi_source_function_new ();
		sym->ident = g_strdup ((yyvsp[-2].str));
		func->child_list = NULL;
		gi_source_symbol_merge_type (sym, func);
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	   }
#line 3956 "giscanner/scannerparser.c"
    break;

  case 254: /* object_macro_define: object_macro constant_expression  */
#line 1577 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		if ((yyvsp[0].symbol)->const_int_set || (yyvsp[0].symbol)->const_boolean_set || (yyvsp[0].symbol)->const_double_set || (yyvsp[0].symbol)->const_string != NULL) {
			GISourceSymbol *macro = gi_source_symbol_copy ((yyvsp[0].symbol));
			g_free (macro->ident);
			macro->ident = (yyvsp[-1].str);
			gi_source_scanner_add_symbol (scanner, macro);
			gi_source_symbol_unref (macro);
			gi_source_symbol_unref ((yyvsp[0].symbol));
		} else {
			g_free ((yyvsp[-1].str));
			gi_source_symbol_unref ((yyvsp[0].symbol));
		}
	  }
#line 3974 "giscanner/scannerparser.c"
    break;

  case 255: /* preproc_conditional: IFDEF_GI_SCANNER  */
#line 1594 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		push_conditional (scanner, FOR_GI_SCANNER);
		update_skipping (scanner);
	  }
#line 3983 "giscanner/scannerparser.c"
    break;

  case 256: /* preproc_conditional: IFNDEF_GI_SCANNER  */
#line 1599 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		push_conditional (scanner, NOT_GI_SCANNER);
		update_skipping (scanner);
	  }
#line 3992 "giscanner/scannerparser.c"
    break;

  case 257: /* preproc_conditional: IFDEF_COND  */
#line 1604 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
	 	warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4001 "giscanner/scannerparser.c"
    break;

  case 258: /* preproc_conditional: IFNDEF_COND  */
#line 1609 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4010 "giscanner/scannerparser.c"
    break;

  case 259: /* preproc_conditional: IF_COND  */
#line 1614 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
#line 4019 "giscanner/scannerparser.c"
    break;

  case 260: /* preproc_conditional: ELIF_COND  */
#line 1619 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		pop_conditional (scanner);
		push_conditional (scanner, IRRELEVANT);
		update_skipping (scanner);
	  }
#line 4030 "giscanner/scannerparser.c"
    break;

  case 261: /* preproc_conditional: ELSE_COND  */
#line 1626 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		toggle_conditional (scanner);
		update_skipping (scanner);
	  }
#line 4039 "giscanner/scannerparser.c"
    break;

  case 262: /* preproc_conditional: ENDIF_COND  */
#line 1631 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"
          {
		pop_conditional (scanner);
		update_skipping (scanner);
	  }
#line 4048 "giscanner/scannerparser.c"
    break;


#line 4052 "giscanner/scannerparser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (scanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 1644 "../gobject-introspection-1.78.1/giscanner/scannerparser.y"

static void
yyerror (GISourceScanner *scanner, const char *s)
{
  /* ignore errors while doing a macro scan as not all object macros
   * have valid expressions */
  if (!scanner->macro_scan)
    {
      gchar *error = g_strdup_printf ("%s:%d: %s in '%s' at '%s'",
          g_file_get_parse_name (scanner->current_file), lineno, s, linebuf, yytext);
      g_ptr_array_add (scanner->errors, error);
    }
}

static int
eat_hspace (FILE * f)
{
  int c;
  do
    {
      c = fgetc (f);
    }
  while (c == ' ' || c == '\t');
  return c;
}

static int
pass_line (FILE * f, int c,
           FILE *out)
{
  while (c != EOF && c != '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
    }
  if (c == '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
      if (c == ' ' || c == '\t')
        {
          c = eat_hspace (f);
        }
    }
  return c;
}

static int
eat_line (FILE * f, int c)
{
  return pass_line (f, c, NULL);
}

static int
read_identifier (FILE * f, int c, char **identifier)
{
  GString *id = g_string_new ("");
  while (g_ascii_isalnum (c) || c == '_')
    {
      g_string_append_c (id, c);
      c = fgetc (f);
    }
  *identifier = g_string_free (id, FALSE);
  return c;
}

static gboolean
parse_file (GISourceScanner *scanner, FILE *file)
{
  g_return_val_if_fail (file != NULL, FALSE);

  lineno = 1;
  yyin = file;
  yyparse (scanner);
  yyin = NULL;

  return TRUE;
}

void
gi_source_scanner_parse_macros (GISourceScanner *scanner, GList *filenames)
{
  GError *error = NULL;
  char *tmp_name = NULL;
  gint tmp_fd;
  FILE *fmacros;
  GList *l;

  tmp_fd = g_file_open_tmp ("gen-introspect-XXXXXX.h", &tmp_name, &error);

  if (tmp_fd == -1)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error_msg = g_strdup_printf ("%s: failed to create temporary file '%s' while parsing macros: %s", filename, tmp_name, error->message);
      g_ptr_array_add (scanner->errors, error_msg);
      g_free (filename);
      g_error_free (error);
      return;
    }

  fmacros = fdopen (tmp_fd, "w+");

  if (!fmacros)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      gchar *error_msg = g_strdup_printf ("%s: failed to open temporary file '%s' while parsing macros", filename, tmp_name);
      g_ptr_array_add (scanner->errors, error_msg);
      g_free (filename);
      close (tmp_fd);
      g_unlink (tmp_name);
      g_free (tmp_name);
      return;
    }

  for (l = filenames; l != NULL; l = l->next)
    {
      FILE *f = fopen (l->data, "r");
      int line = 1;

      GString *define_line;
      char *str;
      gboolean error_line = FALSE;
      gboolean end_of_word;
      int c = eat_hspace (f);
      while (c != EOF)
        {
          if (c != '#')
            {
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }

          /* print current location */
          str = g_strescape (l->data, "");
          fprintf (fmacros, "# %d \"%s\"\n", line, str);
          g_free (str);

          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          end_of_word = (c == ' ' || c == '\t' || c == '\n' || c == EOF);
          if (end_of_word &&
              (g_str_equal (str, "if") ||
               g_str_equal (str, "endif") ||
               g_str_equal (str, "ifndef") ||
               g_str_equal (str, "ifdef") ||
               g_str_equal (str, "else") ||
               g_str_equal (str, "elif")))
            {
              fprintf (fmacros, "#%s ", str);
              g_free (str);
              c = pass_line (f, c, fmacros);
              line++;
              continue;
            }
          else if (strcmp (str, "define") != 0 || !end_of_word)
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          g_free (str);
          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          if (strlen (str) == 0 || (c != ' ' && c != '\t' && c != '('))
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          define_line = g_string_new ("#define ");
          g_string_append (define_line, str);
          g_free (str);
          if (c == '(')
            {
              while (c != ')')
                {
                  g_string_append_c (define_line, c);
                  c = fgetc (f);
                  if (c == EOF || c == '\n')
                    {
                      error_line = TRUE;
                      break;
                    }
                }
              if (error_line)
                {
                  g_string_free (define_line, TRUE);
                  /* ignore line */
                  c = eat_line (f, c);
                  line++;
                  continue;
                }

              g_assert (c == ')');
              g_string_append_c (define_line, c);
              c = fgetc (f);

              /* found function-like macro */
              fprintf (fmacros, "%s\n", define_line->str);

              g_string_free (define_line, TRUE);
              /* ignore rest of line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          if (c != ' ' && c != '\t')
            {
              g_string_free (define_line, TRUE);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          while (c != EOF && c != '\n')
            {
              g_string_append_c (define_line, c);
              c = fgetc (f);
              if (c == '\\')
                {
                  c = fgetc (f);
                  if (c == '\n')
                    {
                      /* fold lines when seeing backslash new-line sequence */
                      c = fgetc (f);
                    }
                  else
                    {
                      g_string_append_c (define_line, '\\');
                    }
                }
            }

          /* found object-like macro */
          fprintf (fmacros, "%s\n", define_line->str);

          c = eat_line (f, c);
          line++;
        }

      fclose (f);
    }

  rewind (fmacros);
  parse_file (scanner, fmacros);
  fclose (fmacros);
  g_unlink (tmp_name);
  g_free (tmp_name);
}

gboolean
gi_source_scanner_parse_file (GISourceScanner *scanner, const gchar *filename)
{
  FILE *file;
  gboolean result;

  file = g_fopen (filename, "r");
  result = parse_file (scanner, file);
  fclose (file);

  return result;
}

gboolean
gi_source_scanner_lex_filename (GISourceScanner *scanner, const gchar *filename)
{
  lineno = 1;
  yyin = g_fopen (filename, "r");

  while (yylex (scanner) != YYEOF)
    ;

  fclose (yyin);

  return TRUE;
}
