# Protocol Documentation
<a name="top"></a>

## Table of Contents

- [kuksa/val/v1/val.proto](#kuksa_val_v1_val-proto)
    - [EntryRequest](#kuksa-val-v1-EntryRequest)
    - [EntryUpdate](#kuksa-val-v1-EntryUpdate)
    - [GetRequest](#kuksa-val-v1-GetRequest)
    - [GetResponse](#kuksa-val-v1-GetResponse)
    - [GetServerInfoRequest](#kuksa-val-v1-GetServerInfoRequest)
    - [GetServerInfoResponse](#kuksa-val-v1-GetServerInfoResponse)
    - [SetRequest](#kuksa-val-v1-SetRequest)
    - [SetResponse](#kuksa-val-v1-SetResponse)
    - [StreamedUpdateRequest](#kuksa-val-v1-StreamedUpdateRequest)
    - [StreamedUpdateResponse](#kuksa-val-v1-StreamedUpdateResponse)
    - [SubscribeEntry](#kuksa-val-v1-SubscribeEntry)
    - [SubscribeRequest](#kuksa-val-v1-SubscribeRequest)
    - [SubscribeResponse](#kuksa-val-v1-SubscribeResponse)

    - [VAL](#kuksa-val-v1-VAL)

- [Scalar Value Types](#scalar-value-types)



<a name="kuksa_val_v1_val-proto"></a>
<p align="right"><a href="#top">Top</a></p>

## kuksa/val/v1/val.proto



<a name="kuksa-val-v1-EntryRequest"></a>

### EntryRequest
Define which data we want


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| path | [string](#string) |  |  |
| view | [View](#kuksa-val-v1-View) |  |  |
| fields | [Field](#kuksa-val-v1-Field) | repeated |  |






<a name="kuksa-val-v1-EntryUpdate"></a>

### EntryUpdate
Define the data we want to set


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| entry | [DataEntry](#kuksa-val-v1-DataEntry) |  |  |
| fields | [Field](#kuksa-val-v1-Field) | repeated |  |






<a name="kuksa-val-v1-GetRequest"></a>

### GetRequest
Request a set of entries.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| entries | [EntryRequest](#kuksa-val-v1-EntryRequest) | repeated |  |






<a name="kuksa-val-v1-GetResponse"></a>

### GetResponse
Global errors are specified in `error`.
Errors for individual entries are specified in `errors`.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| entries | [DataEntry](#kuksa-val-v1-DataEntry) | repeated |  |
| errors | [DataEntryError](#kuksa-val-v1-DataEntryError) | repeated |  |
| error | [Error](#kuksa-val-v1-Error) |  |  |






<a name="kuksa-val-v1-GetServerInfoRequest"></a>

### GetServerInfoRequest
Nothing yet






<a name="kuksa-val-v1-GetServerInfoResponse"></a>

### GetServerInfoResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| name | [string](#string) |  |  |
| version | [string](#string) |  |  |






<a name="kuksa-val-v1-SetRequest"></a>

### SetRequest
A list of entries to be updated


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| updates | [EntryUpdate](#kuksa-val-v1-EntryUpdate) | repeated |  |






<a name="kuksa-val-v1-SetResponse"></a>

### SetResponse
Global errors are specified in `error`.
Errors for individual entries are specified in `errors`.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| error | [Error](#kuksa-val-v1-Error) |  |  |
| errors | [DataEntryError](#kuksa-val-v1-DataEntryError) | repeated |  |






<a name="kuksa-val-v1-StreamedUpdateRequest"></a>

### StreamedUpdateRequest



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| updates | [EntryUpdate](#kuksa-val-v1-EntryUpdate) | repeated |  |






<a name="kuksa-val-v1-StreamedUpdateResponse"></a>

### StreamedUpdateResponse



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| error | [Error](#kuksa-val-v1-Error) |  |  |
| errors | [DataEntryError](#kuksa-val-v1-DataEntryError) | repeated |  |






<a name="kuksa-val-v1-SubscribeEntry"></a>

### SubscribeEntry
Define what to subscribe to


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| path | [string](#string) |  |  |
| view | [View](#kuksa-val-v1-View) |  |  |
| fields | [Field](#kuksa-val-v1-Field) | repeated |  |






<a name="kuksa-val-v1-SubscribeRequest"></a>

### SubscribeRequest
Subscribe to changes in datapoints.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| entries | [SubscribeEntry](#kuksa-val-v1-SubscribeEntry) | repeated |  |






<a name="kuksa-val-v1-SubscribeResponse"></a>

### SubscribeResponse
A subscription response


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| updates | [EntryUpdate](#kuksa-val-v1-EntryUpdate) | repeated |  |












<a name="kuksa-val-v1-VAL"></a>

### VAL


| Method Name | Request Type | Response Type | Description |
| ----------- | ------------ | ------------- | ------------|
| Get | [GetRequest](#kuksa-val-v1-GetRequest) | [GetResponse](#kuksa-val-v1-GetResponse) | Get entries |
| Set | [SetRequest](#kuksa-val-v1-SetRequest) | [SetResponse](#kuksa-val-v1-SetResponse) | Set entries |
| StreamedUpdate | [StreamedUpdateRequest](#kuksa-val-v1-StreamedUpdateRequest) stream | [StreamedUpdateResponse](#kuksa-val-v1-StreamedUpdateResponse) stream |  |
| Subscribe | [SubscribeRequest](#kuksa-val-v1-SubscribeRequest) | [SubscribeResponse](#kuksa-val-v1-SubscribeResponse) stream | Subscribe to a set of entries. Returns a stream of notifications. InvalidArgument is returned if the request is malformed. |
| GetServerInfo | [GetServerInfoRequest](#kuksa-val-v1-GetServerInfoRequest) | [GetServerInfoResponse](#kuksa-val-v1-GetServerInfoResponse) | Shall return information that allows the client to determine what server/server implementation/version it is talking to eg. kuksa-databroker 0.5.1 |





## Scalar Value Types

| .proto Type | Notes | C++ | Java | Python | Go | C# | PHP | Ruby |
| ----------- | ----- | --- | ---- | ------ | -- | -- | --- | ---- |
| <a name="double" /> double |  | double | double | float | float64 | double | float | Float |
| <a name="float" /> float |  | float | float | float | float32 | float | float | Float |
| <a name="int32" /> int32 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint32 instead. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="int64" /> int64 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint64 instead. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="uint32" /> uint32 | Uses variable-length encoding. | uint32 | int | int/long | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="uint64" /> uint64 | Uses variable-length encoding. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum or Fixnum (as required) |
| <a name="sint32" /> sint32 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int32s. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sint64" /> sint64 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int64s. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="fixed32" /> fixed32 | Always four bytes. More efficient than uint32 if values are often greater than 2^28. | uint32 | int | int | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="fixed64" /> fixed64 | Always eight bytes. More efficient than uint64 if values are often greater than 2^56. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum |
| <a name="sfixed32" /> sfixed32 | Always four bytes. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sfixed64" /> sfixed64 | Always eight bytes. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="bool" /> bool |  | bool | boolean | boolean | bool | bool | boolean | TrueClass/FalseClass |
| <a name="string" /> string | A string must always contain UTF-8 encoded or 7-bit ASCII text. | string | String | str/unicode | string | string | string | String (UTF-8) |
| <a name="bytes" /> bytes | May contain any arbitrary sequence of bytes. | string | ByteString | str | []byte | ByteString | string | String (ASCII-8BIT) |
