/*
 * Copyright (C) 2001-2004 Sistina Software, Inc. All rights reserved.  
 * Copyright (C) 2004-2023 Red Hat, Inc. All rights reserved.
 *
 * This file is part of LVM2.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License v.2.1.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
/* Do not edit. This file is generated by the Makefile. */
static const char _command_input[] =

"OO_ALL: --commandprofile String, --config String, --debug,\n"
"--driverloaded Bool, --help, --nolocking, --lockopt String, --longhelp, --profile String, --quiet,\n"
"--verbose, --version, --yes, --test, --devicesfile String, --devices PV, --nohints --journal String\n"
"OO_REPORT: --aligned, --all, --binary, --configreport ConfigReport, --foreign,\n"
"--ignorelockingfailure, --logonly,\n"
"--nameprefixes, --noheadings, --nosuffix,\n"
"--options String, --readonly, --reportformat ReportFmt, --rows,\n"
"--select String, --separator String, --shared, --sort String,\n"
"--unbuffered, --units Units, --unquoted\n"
"OO_CONFIG: --atversion String, --typeconfig ConfigType, --file String, --ignoreadvanced,\n"
"--ignoreunsupported, --ignorelocal, --list, --mergedconfig, --metadataprofile String,\n"
"--sinceversion String, --showdeprecated, --showunsupported, --validate, --valuesonly,\n"
"--withsummary, --withcomments, --withgeneralpreamble, --withlocalpreamble, --withspaces,\n"
"--unconfigured, --withversions\n"
"OO_LVCHANGE: --autobackup Bool, --force, --ignoremonitoring,\n"
"--noudevsync, --reportformat ReportFmt, --select String\n"
"OO_LVCHANGE_META: --addtag Tag, --deltag Tag,\n"
"--alloc Alloc, --contiguous Bool,\n"
"--compression Bool, --deduplication Bool,\n"
"--detachprofile, --metadataprofile String, --profile String,\n"
"--permission Permission, --readahead Readahead, --setactivationskip Bool,\n"
"--setautoactivation Bool, --errorwhenfull Bool, --discards Discards, --zero Bool,\n"
"--cachemode CacheMode, --cachepolicy String, --cachesettings String,\n"
"--minrecoveryrate SizeKB, --maxrecoveryrate SizeKB,\n"
"--vdosettings String,\n"
"--writebehind Number, --writemostly WriteMostlyPV, --persistent n\n"
"lvchange OO_LVCHANGE_META VG|LV|Tag|Select ...\n"
"OO: --activate Active, --poll Bool, --monitor Bool, OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_properties\n"
"DESC: Change a general LV attribute.\n"
"DESC: For options listed in parentheses, any one is\n"
"DESC: required, after which the others are optional.\n"
"RULE: all not lv_is_pvmove lv_is_mirror_log lv_is_mirror_image\n"
"RULE: all and lv_is_vg_writable\n"
"RULE: --contiguous not --alloc\n"
"RULE: --profile not --detachprofile\n"
"RULE: --metadataprofile not --detachprofile\n"
"RULE: --minrecoveryrate --maxrecoveryrate and LV_raid\n"
"RULE: --writebehind --writemostly and LV_raid1\n"
"RULE: --cachemode --cachepolicy --cachesettings and LV_cache LV_cachepool LV_writecache\n"
"RULE: --errorwhenfull --discards --zero and LV_thinpool\n"
"RULE: --permission not lv_is_external_origin lv_is_raid_metadata lv_is_raid_image LV_thinpool\n"
"RULE: --alloc --contiguous --metadataprofile --persistent --profile --readahead not lv_is_thick_origin\n"
"RULE: --alloc --discards --zero --cachemode --cachepolicy --cachesettings not lv_is_partial\n"
"lvchange --resync VG|LV_raid_mirror|Tag|Select ...\n"
"OO: --activate Active, OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_resync\n"
"DESC: Resyncronize a mirror or raid LV.\n"
"DESC: Use to reset 'R' attribute on a not initially synchronized LV.\n"
"RULE: all not lv_is_pvmove lv_is_locked lv_is_raid_with_integrity\n"
"RULE: all not LV_raid0\n"
"lvchange --syncaction SyncAction VG|LV_raid|Tag|Select ...\n"
"OO: OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_syncaction\n"
"DESC: Resynchronize or check a raid LV.\n"
"RULE: all not LV_raid0\n"
"lvchange --rebuild PV VG|LV_raid|Tag|Select ...\n"
"OO: OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_rebuild\n"
"DESC: Reconstruct data on specific PVs of a raid LV.\n"
"RULE: all not LV_raid0\n"
"lvchange --activate Active VG|LV|Tag|Select ...\n"
"OO: --activationmode ActivationMode, --partial, --poll Bool, --monitor Bool,\n"
"--ignoreactivationskip, --ignorelockingfailure, --sysinit, --readonly, OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_activate\n"
"DESC: Activate or deactivate an LV.\n"
"lvchange --refresh VG|LV|Tag|Select ...\n"
"OO: --activationmode ActivationMode, --partial, --poll Bool, --monitor Bool, OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_refresh\n"
"DESC: Reactivate an LV using the latest metadata.\n"
"lvchange --monitor Bool VG|LV|Tag|Select ...\n"
"OO: OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_monitor\n"
"DESC: Start or stop monitoring an LV from dmeventd.\n"
"RULE: all not lv_is_pvmove\n"
"lvchange --poll Bool VG|LV|Tag|Select ...\n"
"OO: --monitor Bool, OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_poll\n"
"DESC: Start or stop processing an LV conversion.\n"
"lvchange --persistent y --minor Number LV\n"
"OO: --major Number, --activate Active, --poll Bool, --monitor Bool, OO_LVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: lvchange_persistent\n"
"DESC: Make the minor device number persistent for an LV.\n"
"RULE: all not LV_thinpool LV_cachepool LV_vdopool\n"
"OO_LVCONVERT_POOL: --poolmetadata LV, --poolmetadatasize SizeMB,\n"
"--poolmetadataspare Bool, --readahead Readahead, --chunksize SizeKB,\n"
"--zero Bool, --metadataprofile String\n"
"OO_LVCONVERT_THINPOOL: --discards Discards, --errorwhenfull Bool\n"
"OO_LVCONVERT_CACHE: --cachemetadataformat CacheMetadataFormat,\n"
"--cachemode CacheMode, --cachepolicy String,\n"
"--cachesettings String, --zero Bool\n"
"OO_LVCONVERT_VDO: --metadataprofile String, --readahead Readahead,\n"
"--compression Bool, --deduplication Bool, --vdosettings String,\n"
"--zero Bool\n"
"OO_LVCONVERT: --alloc Alloc, --background, --force, --noudevsync\n"
"lvconvert --type linear LV\n"
"OO: OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_raid_types\n"
"DESC: Convert LV to linear.\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"lvconvert --type striped LV\n"
"OO: --stripes_long Number, --stripesize SizeKB, --regionsize RegionSize, --interval Number, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_raid_types\n"
"DESC: Convert LV to striped.\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"lvconvert --type mirror LV\n"
"OO: --mirrors SNumber, --stripes_long Number, --stripesize SizeKB, --regionsize RegionSize, --interval Number, --mirrorlog MirrorLog, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_raid_types\n"
"DESC: Convert LV to type mirror (also see type raid1),\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"lvconvert --type raid LV\n"
"OO: --mirrors SNumber, --stripes_long Number, --stripesize SizeKB, --regionsize RegionSize, --interval Number, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_raid_types\n"
"DESC: Convert LV to raid or change raid layout\n"
"DESC: (a specific raid level must be used, e.g. raid1).\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"RULE: lv_is_raid_with_integrity not --stripes_long --stripesize --regionsize --interval\n"
"lvconvert --mirrors SNumber LV\n"
"OO: --regionsize RegionSize, --interval Number, --mirrorlog MirrorLog, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_raid_types\n"
"DESC: Convert LV to raid1 or mirror, or change number of mirror images.\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"lvconvert --stripes_long Number LV_raid\n"
"OO: OO_LVCONVERT, --interval Number, --regionsize RegionSize, --stripesize SizeKB\n"
"OP: PV ...\n"
"ID: lvconvert_raid_types\n"
"DESC: Convert raid LV to change number of stripe images.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\n"
"RULE: all not LV_raid0 LV_raid1\n"
"lvconvert --stripesize SizeKB LV_raid\n"
"OO: OO_LVCONVERT, --interval Number, --regionsize RegionSize\n"
"ID: lvconvert_raid_types\n"
"DESC: Convert raid LV to change the stripe size.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\n"
"RULE: all not LV_raid0 LV_raid1\n"
"lvconvert --regionsize RegionSize LV_raid\n"
"OO: OO_LVCONVERT\n"
"ID: lvconvert_change_region_size\n"
"DESC: Change the region size of an LV.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\n"
"RULE: all not LV_raid0\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvconvert --splitmirrors Number --name LV_new LV_raid1_mirror_cache\n"
"OO: OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_split_mirror_images\n"
"DESC: Split images from a raid1 or mirror LV and use them to create a new LV.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\n"
"lvconvert --splitmirrors Number --trackchanges LV_raid1_cache\n"
"OO: OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_split_mirror_images\n"
"DESC: Split images from a raid1 LV and track changes to origin for later merge.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_raid_with_integrity\n"
"lvconvert --mergemirrors LV_linear_raid|VG|Tag ...\n"
"OO: OO_LVCONVERT\n"
"ID: lvconvert_merge_mirror_images\n"
"DESC: Merge LV images that were split from a raid1 LV.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_merging_origin lv_is_virtual_origin lv_is_external_origin lv_is_merging_cow lv_is_raid_with_integrity\n"
"lvconvert --mirrorlog MirrorLog LV_mirror\n"
"OO: OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_change_mirrorlog\n"
"DESC: Change the type of mirror log used by a mirror LV.\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvconvert --type thin --thinpool LV LV_linear_striped_raid_cache_thin_error_zero\n"
"OO: --thin, --originname LV_new, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"ID: lvconvert_to_thin_with_external\n"
"DESC: Convert LV to a thin LV, using the original LV as an external origin.\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_locked lv_is_raid_with_integrity\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"lvconvert --thin --thinpool LV LV_linear_striped_raid_cache_thin_error_zero\n"
"OO: --originname LV_new, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"ID: lvconvert_to_thin_with_external\n"
"DESC: Convert LV to a thin LV, using the original LV as an external origin.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_locked lv_is_raid_with_integrity\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"lvconvert --type thin LV_linear_striped_raid_cache_writecache_vdo_error_zero\n"
"OO: --thin, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"ID: lvconvert_to_thin_with_data\n"
"DESC: Convert LV to a thin LV, using LV as thin-pool data volume.\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_raid_with_integrity\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"lvconvert --thin LV_linear_striped_raid_cache_writecache_vdo_error_zero\n"
"OO: OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"ID: lvconvert_to_thin_with_data\n"
"DESC: Convert LV to a thin LV, using LV as thin-pool data volume.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_raid_with_integrity\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"lvconvert --type cache --cachepool LV LV_linear_striped_raid_thinpool_vdo_vdopool_vdopooldata_thin_error_zero\n"
"OO: --cache, OO_LVCONVERT_CACHE, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"ID: lvconvert_to_cache_with_cachepool\n"
"DESC: Attach a cache pool to an LV, converts the LV to type cache.\n"
"RULE: all not lv_is_locked lv_is_merging_origin lv_is_merging_cow lv_is_cow\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"lvconvert --cache --cachepool LV LV_linear_striped_raid_thinpool_vdo_vdopool_vdopooldata_thin_error_zero\n"
"OO: OO_LVCONVERT_CACHE, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"ID: lvconvert_to_cache_with_cachepool\n"
"DESC: Attach a cache pool to an LV.\n"
"RULE: all not lv_is_locked lv_is_merging_origin lv_is_merging_cow lv_is_cow\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: cache\n"
"lvconvert --type writecache --cachevol LV LV_linear_striped_raid_thinpool\n"
"OO: OO_LVCONVERT, --cachesettings String\n"
"ID: lvconvert_to_writecache\n"
"DESC: Attach a writecache to an LV, converts the LV to type writecache.\n"
"RULE: all and lv_is_visible\n"
"lvconvert --type cache --cachevol LV LV_linear_striped_raid_thinpool\n"
"OO: --cache, OO_LVCONVERT_CACHE, OO_LVCONVERT, --poolmetadatasize SizeMB, --chunksize SizeKB\n"
"ID: lvconvert_to_cache_with_cachevol\n"
"DESC: Attach a cache to an LV, converts the LV to type cache.\n"
"RULE: all and lv_is_visible\n"
"lvconvert --cache --cachevol LV LV_linear_striped_raid_thinpool\n"
"OO: OO_LVCONVERT_CACHE, OO_LVCONVERT, --poolmetadatasize SizeMB, --chunksize SizeKB\n"
"ID: lvconvert_to_cache_with_cachevol\n"
"DESC: Attach a cache to an LV, converts the LV to type cache.\n"
"RULE: all and lv_is_visible\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvconvert --type writecache --cachedevice PV LV_linear_striped_raid_thinpool\n"
"OO: OO_LVCONVERT, --cachesize SizeMB, --cachesettings String\n"
"ID: lvconvert_to_writecache_with_device\n"
"DESC: Add a writecache to an LV, using a specified cache device.\n"
"RULE: all and lv_is_visible\n"
"lvconvert --type cache --cachedevice PV LV_linear_striped_raid_thinpool\n"
"OO: OO_LVCONVERT, --cachesize SizeMB, --cachesettings String, --chunksize SizeKB\n"
"ID: lvconvert_to_cache_with_device\n"
"DESC: Add a cache to an LV, using a specified cache device.\n"
"RULE: all and lv_is_visible\n"
"lvconvert --type thin-pool LV_linear_striped_raid_cache_writecache_error_zero\n"
"OO: --stripes_long Number, --stripesize SizeKB,\n"
"OO_LVCONVERT_THINPOOL, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_to_thinpool\n"
"DESC: Convert LV to type thin-pool.\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_raid_with_integrity\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"lvconvert --thinpool LV_linear_striped_raid_cache_writecache_error_zero_thinpool\n"
"OO: --stripes_long Number, --stripesize SizeKB,\n"
"OO_LVCONVERT_THINPOOL, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_to_thinpool_or_swap_metadata\n"
"DESC: Convert LV to type thin-pool (variant, use --type thin-pool).\n"
"DESC: Swap metadata LV in a thin pool (variant, use --swapmetadata).\n"
"FLAGS: PREVIOUS_SYNTAX\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_raid_with_integrity\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"AUTOTYPE: thin-pool\n"
"lvconvert --type cache-pool LV_linear_striped_raid_error_zero\n"
"OO: OO_LVCONVERT_CACHE, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_to_cachepool\n"
"DESC: Convert LV to type cache-pool.\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"RULE: all not lv_is_raid_with_integrity\n"
"lvconvert --cachepool LV_linear_striped_raid_cachepool_error_zero\n"
"OO: --type cache-pool, OO_LVCONVERT_CACHE, OO_LVCONVERT_POOL, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_to_cachepool_or_swap_metadata\n"
"DESC: Convert LV to type cache-pool (variant, use --type cache-pool).\n"
"DESC: Swap metadata LV in a cache pool (variant, use --swapmetadata).\n"
"FLAGS: PREVIOUS_SYNTAX\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_raid_with_integrity\n"
"RULE: --poolmetadata not --readahead --stripesize --stripes_long\n"
"lvconvert --type vdo-pool LV_linear_striped_raid_cache\n"
"OO: --name LV_new, --virtualsize SizeMB, OO_LVCONVERT_VDO, OO_LVCONVERT\n"
"ID: lvconvert_to_vdopool\n"
"DESC: Convert LV to type vdopool.\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_virtual lv_is_raid_with_integrity\n"
"lvconvert --vdopool LV_linear_striped_raid_cache\n"
"OO: OO_LVCONVERT_VDO, OO_LVCONVERT, --name LV_new, --virtualsize SizeMB,\n"
"ID: lvconvert_to_vdopool_param\n"
"DESC: Convert LV to type vdopool.\n"
"RULE: all and lv_is_visible\n"
"RULE: all not lv_is_locked lv_is_origin lv_is_merging_origin lv_is_external_origin lv_is_virtual lv_is_raid_with_integrity\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: vdo-pool\n"
"lvconvert --splitcache LV_cachepool_cache_thinpool_vdopool_writecache\n"
"OO: OO_LVCONVERT, --cachesettings String\n"
"ID: lvconvert_split_and_keep_cache\n"
"DESC: Detach a cache from an LV.\n"
"lvconvert --uncache LV_cache_thinpool_vdopool_writecache\n"
"OO: OO_LVCONVERT, --cachesettings String\n"
"ID: lvconvert_split_and_remove_cache\n"
"DESC: Detach and delete a cache from an LV.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvconvert --swapmetadata --poolmetadata LV LV_thinpool_cachepool\n"
"OO: --chunksize SizeKB, OO_LVCONVERT\n"
"ID: lvconvert_swap_pool_metadata\n"
"DESC: Swap metadata LV in a thin pool or cache pool (for repair only).\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvconvert --merge LV_linear_striped_raid_thin_snapshot|VG|Tag ...\n"
"OO: --background, --interval Number, OO_LVCONVERT\n"
"ID: lvconvert_merge\n"
"DESC: Merge LV that was split from a mirror (variant, use --mergemirrors).\n"
"DESC: Merge thin LV into its origin LV (variant, use --mergethin).\n"
"DESC: Merge COW snapshot LV into its origin (variant, use --mergesnapshot).\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_merging_origin lv_is_virtual_origin lv_is_external_origin lv_is_merging_cow\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvconvert --mergethin LV_thin ...\n"
"OO: OO_LVCONVERT\n"
"ID: lvconvert_merge_thin\n"
"DESC: Merge thin LV into its origin LV.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_merging_origin lv_is_virtual_origin lv_is_external_origin lv_is_merging_cow\n"
"RULE: all and lv_is_visible\n"
"lvconvert --mergesnapshot LV_snapshot ...\n"
"OO: --background, --interval Number, OO_LVCONVERT\n"
"ID: lvconvert_merge_snapshot\n"
"DESC: Merge COW snapshot LV into its origin.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_merging_origin lv_is_virtual_origin lv_is_external_origin lv_is_merging_cow\n"
"RULE: all and lv_is_visible\n"
"lvconvert --splitsnapshot LV_snapshot\n"
"OO: OO_LVCONVERT\n"
"ID: lvconvert_split_cow_snapshot\n"
"DESC: Separate a COW snapshot from its origin LV.\n"
"RULE: all not lv_is_locked lv_is_pvmove lv_is_origin lv_is_external_origin lv_is_merging_cow\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvconvert --type snapshot LV LV_linear_striped\n"
"OO: --snapshot, --chunksize SizeKB, --zero Bool, OO_LVCONVERT\n"
"ID: lvconvert_combine_split_snapshot\n"
"DESC: Combine a former COW snapshot (second arg) with a former\n"
"DESC: origin LV (first arg) to reverse a splitsnapshot command.\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"RULE: all and lv_is_visible\n"
"lvconvert --snapshot LV LV_linear_striped\n"
"OO: --chunksize SizeKB, --zero Bool, OO_LVCONVERT\n"
"ID: lvconvert_combine_split_snapshot\n"
"DESC: Combine a former COW snapshot (second arg) with a former\n"
"DESC: origin LV (first arg) to reverse a splitsnapshot command.\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"RULE: all and lv_is_visible\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: snapshot\n"
"lvconvert --repair LV_cache_cachepool_mirror_raid_thinpool\n"
"OO: --usepolicies, --interval Number, --setactivationskip Bool, --poolmetadataspare Bool, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_repair\n"
"DESC: Replace failed PVs in a raid or mirror LV.\n"
"DESC: Repair a thin pool.\n"
"DESC: Repair a cache pool.\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"RULE: --poolmetadataspare and LV_cache LV_cachepool LV_thinpool\n"
"RULE: --setactivationskip and LV_cache LV_cachepool LV_thinpool\n"
"lvconvert --replace PV LV_raid\n"
"OO: OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_replace_pv\n"
"DESC: Replace specific PV(s) in a raid LV with another PV.\n"
"RULE: all not lv_is_locked lv_is_pvmove\n"
"lvconvert --startpoll LV_mirror_raid\n"
"OO: OO_LVCONVERT\n"
"ID: lvconvert_start_poll\n"
"DESC: Poll LV to continue conversion.\n"
"RULE: all and lv_is_converting\n"
"lvconvert LV_mirror_raid\n"
"OO: OO_LVCONVERT\n"
"ID: lvconvert_plain\n"
"DESC: Poll LV to continue conversion (also see --startpoll)\n"
"DESC: or waits till conversion/mirror syncing is finished\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvconvert --raidintegrity Bool LV_raid\n"
"OO: --raidintegritymode String, --raidintegrityblocksize Number, OO_LVCONVERT\n"
"OP: PV ...\n"
"ID: lvconvert_integrity\n"
"DESC: Add or remove data integrity checksums to raid images.\n"
"OO_LVCREATE: --addtag Tag, --alloc Alloc, --autobackup Bool, --activate Active,\n"
"--contiguous Bool, --ignoreactivationskip, --ignoremonitoring, --major Number,\n"
"--metadataprofile String, --minor Number, --monitor Bool, --name String, --nosync,\n"
"--noudevsync, --permission Permission, --persistent Bool, --readahead Readahead,\n"
"--reportformat ReportFmt, --setactivationskip Bool, --wipesignatures Bool,\n"
"--zero Bool, --setautoactivation Bool\n"
"OO_LVCREATE_CACHE: --cachemode CacheMode, --cachepolicy String, --cachesettings String,\n"
"--chunksize SizeKB, --cachemetadataformat CacheMetadataFormat\n"
"OO_LVCREATE_POOL: --poolmetadatasize SizeMB, --poolmetadataspare Bool, --chunksize SizeKB\n"
"OO_LVCREATE_THINPOOL: --discards Discards, --errorwhenfull Bool\n"
"OO_LVCREATE_VDO: --compression Bool, --deduplication Bool, --vdosettings String\n"
"lvcreate --type error --size SizeMB VG\n"
"OO: OO_LVCREATE\n"
"ID: lvcreate_error_vol\n"
"DESC: Create an LV that returns errors when used.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --type zero --size SizeMB VG\n"
"OO: OO_LVCREATE\n"
"ID: lvcreate_zero_vol\n"
"DESC: Create an LV that returns zeros when read.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --type linear --size SizeMB VG\n"
"OO: OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0, --stripes 1\n"
"ID: lvcreate_linear\n"
"DESC: Create a linear LV.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --size SizeMB VG\n"
"OO: OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0, --stripes 1\n"
"ID: lvcreate_linear\n"
"DESC: Create a linear LV.\n"
"AUTOTYPE: linear\n"
"lvcreate --type striped --size SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_striped\n"
"DESC: Create a striped LV (also see lvcreate --stripes).\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --stripes Number --size SizeMB VG\n"
"OO: --stripesize SizeKB, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_striped\n"
"DESC: Create a striped LV.\n"
"AUTOTYPE: striped\n"
"lvcreate --type mirror --size SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--mirrors PNumber, --mirrorlog MirrorLog, --regionsize RegionSize, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_mirror\n"
"DESC: Create a mirror LV (also see --type raid1).\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --mirrors PNumber --size SizeMB VG\n"
"OO: --stripesize SizeKB, --mirrorlog MirrorLog, --regionsize RegionSize, --minrecoveryrate SizeKB, --maxrecoveryrate SizeKB, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --stripes 1\n"
"ID: lvcreate_mirror_or_raid1\n"
"DESC: Create a raid1 or mirror LV.\n"
"AUTOTYPE: raid1\n"
"AUTOTYPE: mirror\n"
"lvcreate --type raid --size SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--mirrors PNumber, --regionsize RegionSize, --minrecoveryrate SizeKB, --maxrecoveryrate SizeKB,\n"
"--raidintegrity Bool, --raidintegritymode String, --raidintegrityblocksize Number, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_raid_any\n"
"DESC: Create a raid LV (a specific raid level must be used, e.g. raid1).\n"
"lvcreate --mirrors PNumber --stripes Number --size SizeMB VG\n"
"OO: --stripesize SizeKB, --regionsize RegionSize, --minrecoveryrate SizeKB, --maxrecoveryrate SizeKB, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_raid_any\n"
"DESC: Create a raid10 LV.\n"
"AUTOTYPE: raid10\n"
"lvcreate --type snapshot --size SizeMB LV\n"
"OO: --snapshot, --stripes Number, --stripesize SizeKB,\n"
"--chunksize SizeKB, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_cow_snapshot\n"
"DESC: Create a COW snapshot LV of an origin LV\n"
"DESC: (also see --snapshot).\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --snapshot --size SizeMB LV\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--chunksize SizeKB, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_cow_snapshot\n"
"DESC: Create a COW snapshot LV of an origin LV.\n"
"AUTOTYPE: snapshot\n"
"lvcreate --type snapshot --size SizeMB --virtualsize SizeMB VG\n"
"OO: --snapshot, --chunksize SizeKB, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_cow_snapshot_with_virtual_origin\n"
"DESC: Create a sparse COW snapshot LV of a virtual origin LV\n"
"DESC: (also see --snapshot).\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --type thin-pool --size SizeMB VG\n"
"OO: --thinpool LV_new, --stripes Number, --stripesize SizeKB,\n"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thinpool\n"
"DESC: Create a thin pool.\n"
"lvcreate --thin --size SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB, OO_LVCREATE_THINPOOL, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thinpool\n"
"DESC: Create a thin pool.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin-pool\n"
"lvcreate --size SizeMB --thinpool LV_new VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thinpool\n"
"DESC: Create a thin pool named in --thinpool.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin-pool\n"
"lvcreate --type cache-pool --size SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_cachepool\n"
"DESC: Create a cache pool.\n"
"lvcreate --type cache-pool --size SizeMB --cachepool LV_new VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_cachepool\n"
"DESC: Create a cache pool named by the --cachepool arg\n"
"DESC: (variant, uses --cachepool in place of --name).\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --type thin --virtualsize SizeMB --thinpool LV_thinpool VG\n"
"OO: --thin, OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol\n"
"DESC: Create a thin LV in a thin pool.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --type thin --virtualsize SizeMB LV_thinpool\n"
"OO: --thin, OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol\n"
"DESC: Create a thin LV in a thin pool named in the first arg\n"
"DESC: (variant, also see --thinpool for naming pool).\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --virtualsize SizeMB --thinpool LV_thinpool VG\n"
"OO: --thin, OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol\n"
"DESC: Create a thin LV in a thin pool.\n"
"AUTOTYPE: thin\n"
"lvcreate --virtualsize SizeMB LV_thinpool\n"
"OO: --thin, OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol\n"
"DESC: Create a thin LV in the thin pool named in the first arg\n"
"DESC: (also see --thinpool for naming pool.)\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin\n"
"lvcreate --type thin LV_thin\n"
"OO: --thin, --snapshot, OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_snapshot\n"
"DESC: Create a thin LV that is a snapshot of an existing thin LV.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --thin LV_thin\n"
"OO: --snapshot, OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_snapshot\n"
"DESC: Create a thin LV that is a snapshot of an existing thin LV.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin\n"
"lvcreate --snapshot LV_thin\n"
"OO: --thin, OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_snapshot\n"
"DESC: Create a thin LV that is a snapshot of an existing thin LV.\n"
"AUTOTYPE: thin\n"
"lvcreate --type thin --thinpool LV_thinpool LV\n"
"OO: --thin, OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_snapshot_of_external\n"
"DESC: Create a thin LV that is a snapshot of an external origin LV.\n"
"lvcreate --snapshot --thinpool LV_thinpool LV\n"
"OO: OO_LVCREATE\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_snapshot_of_external\n"
"DESC: Create a thin LV that is a snapshot of an external origin LV.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin\n"
"lvcreate --type vdo --size SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--vdo, --virtualsize SizeMB, --vdopool LV_new, OO_LVCREATE_VDO, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_vdo_vol\n"
"DESC: Create a LV that returns VDO when used.\n"
"lvcreate --vdo --size SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--virtualsize SizeMB, --vdopool LV_new, OO_LVCREATE_VDO, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_vdo_vol\n"
"DESC: Create a VDO LV with VDO pool.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: vdo\n"
"lvcreate --vdopool LV_new --size SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--virtualsize SizeMB, OO_LVCREATE_VDO, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_vdo_vol\n"
"DESC: Create a VDO LV with VDO pool.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: vdo\n"
"lvcreate --type thin --virtualsize SizeMB --size SizeMB --thinpool LV_new VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol_and_thinpool\n"
"DESC: Create a thin LV, first creating a thin pool for it,\n"
"DESC: where the new thin pool is named by the --thinpool arg.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --virtualsize SizeMB --size SizeMB --thinpool LV_new VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol_and_thinpool\n"
"DESC: Create a thin LV, first creating a thin pool for it,\n"
"DESC: where the new thin pool is named by --thinpool.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin\n"
"lvcreate --type thin --virtualsize SizeMB --size SizeMB LV_new|VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--thin, OO_LVCREATE_THINPOOL, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol_and_thinpool\n"
"DESC: Create a thin LV, first creating a thin pool for it,\n"
"DESC: where the new thin pool is named in the first arg,\n"
"DESC: or the new thin pool name is generated when the first\n"
"DESC: arg is a VG name.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --thin --virtualsize SizeMB --size SizeMB LV_new|VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"OO_LVCREATE_THINPOOL, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol_and_thinpool\n"
"DESC: Create a thin LV, first creating a thin pool for it,\n"
"DESC: where the new thin pool is named in the first arg,\n"
"DESC: or the new thin pool name is generated when the first\n"
"DESC: arg is a VG name.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin\n"
"lvcreate --size SizeMB --virtualsize SizeMB VG\n"
"OO: --stripes Number, --stripesize SizeKB, --snapshot, --thin,\n"
"OO_LVCREATE_THINPOOL, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"IO: --mirrors 0\n"
"ID: lvcreate_thin_vol_with_thinpool_or_sparse_snapshot\n"
"DESC: Create a thin LV, first creating a thin pool for it.\n"
"DESC: Create a sparse snapshot of a virtual origin LV\n"
"DESC: Chooses type thin or snapshot according to\n"
"DESC: config setting sparse_segtype_default.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: thin\n"
"AUTOTYPE: snapshot\n"
"lvcreate --type cache --size SizeMB --cachepool LV_cachepool VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_and_attach_cachepool\n"
"DESC: Create a new LV, then attach the specified cachepool\n"
"DESC: which converts the new LV to type cache.\n"
"lvcreate --size SizeMB --cachepool LV_cachepool VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_and_attach_cachepool_v2\n"
"DESC: Create a new LV, then attach the specified cachepool\n"
"DESC: which converts the new LV to type cache.\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: cache\n"
"lvcreate --type cache --size SizeMB LV_cachepool\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--cache, OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_and_attach_cachepool_v3\n"
"DESC: Create a new LV, then attach the specified cachepool\n"
"DESC: which converts the new LV to type cache.\n"
"DESC: (variant, also use --cachepool).\n"
"FLAGS: SECONDARY_SYNTAX\n"
"lvcreate --cache --size SizeMB LV\n"
"OO: OO_LVCREATE_CACHE, OO_LVCREATE_POOL, OO_LVCREATE,\n"
"--stripes Number, --stripesize SizeKB\n"
"OP: PV ...\n"
"ID: lvcreate_new_plus_old_cachepool_or_lvconvert_old_plus_new_cachepool\n"
"DESC: When the LV arg is a cachepool, then create a new LV and\n"
"DESC: attach the cachepool arg to it.\n"
"DESC: (variant, use --type cache and --cachepool.)\n"
"DESC: When the LV arg is not a cachepool, then create a new cachepool\n"
"DESC: and attach it to the LV arg (alternative, use lvconvert.)\n"
"FLAGS: SECONDARY_SYNTAX\n"
"AUTOTYPE: cache\n"
"lvcreate --type cache --size SizeMB --cachevol LV VG\n"
"OO: --stripes Number, --stripesize SizeKB, OO_LVCREATE_CACHE, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_and_attach_cachevol_for_cache\n"
"DESC: Create a new LV, then attach the specified cachevol\n"
"DESC: which converts the new LV to type cache.\n"
"lvcreate --type cache --size SizeMB --cachedevice PV VG\n"
"OO: --stripes Number, --stripesize SizeKB,\n"
"--cachesize SizeMB, OO_LVCREATE_CACHE, OO_LVCREATE\n"
"OP: PV ...\n"
"ID: lvcreate_and_attach_cachedevice_for_cache\n"
"DESC: Create a new LV, then attach a cachevol created from\n"
"DESC: the specified cache device, which converts the\n"
"DESC: new LV to type cache.\n"
"lvcreate --type writecache --size SizeMB --cachevol LV VG\n"
"OO: OO_LVCREATE, --cachesettings String, --stripes Number, --stripesize SizeKB\n"
"OP: PV ...\n"
"ID: lvcreate_and_attach_cachevol_for_writecache\n"
"DESC: Create a new LV, then attach the specified cachevol\n"
"DESC: which converts the new LV to type writecache.\n"
"lvcreate --type writecache --size SizeMB --cachedevice PV VG\n"
"OO: OO_LVCREATE, --cachesize SizeMB, --cachesettings String, --stripes Number, --stripesize SizeKB\n"
"OP: PV ...\n"
"ID: lvcreate_and_attach_cachedevice_for_writecache\n"
"DESC: Create a new LV, then attach a cachevol created from\n"
"DESC: the specified cache device, which converts the\n"
"DESC: new LV to type writecache.\n"
"lvdisplay\n"
"OO: --aligned, --all, --binary, --colon, --columns,\n"
"--configreport ConfigReport, --foreign, --history, --ignorelockingfailure,\n"
"--logonly, --maps, --noheadings,\n"
"--nosuffix, --options String, --sort String, --readonly,\n"
"--segments, --select String, --separator String,\n"
"--shared, --unbuffered, --units Units\n"
"OP: VG|LV|Tag ...\n"
"IO: --partial, --ignoreskippedcluster, --reportformat ReportFmt\n"
"ID: lvdisplay_general\n"
"lvextend --size PSizeMB LV\n"
"OO: --alloc Alloc, --autobackup Bool, --force, --mirrors Number,\n"
"--nofsck, --nosync, --noudevsync, --reportformat ReportFmt, --resizefs,\n"
"--stripes Number, --stripesize SizeKB, --poolmetadatasize PSizeMB,\n"
"--type SegType, --fs String, --fsmode String\n"
"OP: PV ...\n"
"ID: lvextend_size\n"
"DESC: Extend an LV by a specified size.\n"
"lvextend LV PV ...\n"
"OO: --alloc Alloc, --autobackup Bool, --force, --mirrors Number,\n"
"--nofsck, --nosync, --noudevsync,\n"
"--reportformat ReportFmt, --resizefs, --stripes Number, --stripesize SizeKB,\n"
"--type SegType, --fs String, --fsmode String\n"
"ID: lvextend_pv\n"
"DESC: Extend an LV by specified PV extents.\n"
"lvextend --poolmetadatasize PSizeMB LV_thinpool_linear\n"
"OO: --alloc Alloc, --autobackup Bool, --force, --mirrors Number,\n"
"--nofsck, --nosync, --noudevsync,\n"
"--reportformat ReportFmt, --stripes Number, --stripesize SizeKB,\n"
"--type SegType\n"
"OP: PV ...\n"
"ID: lvextend_pool_metadata\n"
"DESC: Extend a pool metadata SubLV by a specified size.\n"
"lvextend --usepolicies LV_snapshot_thinpool_vdopool\n"
"OO: --alloc Alloc, --autobackup Bool, --force, --mirrors Number,\n"
"--nofsck, --nosync, --noudevsync,\n"
"--reportformat ReportFmt, --resizefs,\n"
"--type SegType, --fs String, --fsmode String\n"
"OP: PV ...\n"
"ID: lvextend_policy\n"
"DESC: Extend an LV according to a predefined policy.\n"
"lvmconfig\n"
"OO: OO_CONFIG\n"
"OP: String ...\n"
"ID: lvmconfig_general\n"
"lvmdevices\n"
"ID: lvmdevices_list\n"
"DESC: Print devices in the devices file.\n"
"lvmdevices --check\n"
"ID: lvmdevices_check\n"
"DESC: Check the devices file and report incorrect values.\n"
"lvmdevices --update\n"
"OO: --delnotfound\n"
"ID: lvmdevices_update\n"
"DESC: Update the devices file to fix incorrect values.\n"
"lvmdevices --adddev PV\n"
"OO: --deviceidtype String\n"
"ID: lvmdevices_edit\n"
"DESC: Add a device to the devices file.\n"
"lvmdevices --deldev PV|String\n"
"OO: --deviceidtype String\n"
"ID: lvmdevices_edit\n"
"DESC: Remove a device from the devices file.\n"
"lvmdevices --addpvid String\n"
"OO: --deviceidtype String\n"
"ID: lvmdevices_edit\n"
"DESC: Find the device with the given PVID and add it to the devices file.\n"
"lvmdevices --delpvid String\n"
"ID: lvmdevices_edit\n"
"DESC: Remove the devices file entry for the given PVID.\n"
"lvreduce --size NSizeMB LV\n"
"OO: --autobackup Bool, --force, --nofsck, --noudevsync,\n"
"--reportformat ReportFmt, --resizefs, --fs String, --fsmode String\n"
"ID: lvreduce_size\n"
"lvremove VG|LV|Tag|Select ...\n"
"OO: --autobackup Bool, --force, --nohistory, --noudevsync,\n"
"--reportformat ReportFmt, --select String\n"
"ID: lvremove_general\n"
"lvrename VG LV LV_new\n"
"OO: --autobackup Bool, --noudevsync, --reportformat ReportFmt\n"
"ID: lvrename_vg_lv_lv\n"
"lvrename LV LV_new\n"
"OO: --autobackup Bool, --noudevsync, --reportformat ReportFmt\n"
"ID: lvrename_lv_lv\n"
"lvresize --size SSizeMB LV\n"
"OO: --alloc Alloc, --autobackup Bool, --force,\n"
"--nofsck, --nosync, --noudevsync, --reportformat ReportFmt, --resizefs,\n"
"--stripes Number, --stripesize SizeKB, --poolmetadatasize PSizeMB,\n"
"--type SegType, --fs String, --fsmode String\n"
"OP: PV ...\n"
"ID: lvresize_size\n"
"DESC: Resize an LV by a specified size.\n"
"lvresize LV PV ...\n"
"OO: --alloc Alloc, --autobackup Bool, --force,\n"
"--nofsck, --nosync, --noudevsync,\n"
"--reportformat ReportFmt, --resizefs, --stripes Number, --stripesize SizeKB,\n"
"--type SegType, --fs String, --fsmode String\n"
"ID: lvresize_pv\n"
"DESC: Resize an LV by specified PV extents.\n"
"lvresize --poolmetadatasize PSizeMB LV_thinpool\n"
"OO: --alloc Alloc, --autobackup Bool, --force,\n"
"--nofsck, --nosync, --noudevsync,\n"
"--reportformat ReportFmt, --stripes Number, --stripesize SizeKB,\n"
"--type SegType\n"
"OP: PV ...\n"
"ID: lvresize_pool_metadata\n"
"DESC: Resize a pool metadata SubLV by a specified size.\n"
"lvs\n"
"OO: --history, --segments, OO_REPORT\n"
"OP: VG|LV|Tag ...\n"
"IO: --partial, --ignoreskippedcluster, --trustcache\n"
"ID: lvs_general\n"
"lvscan\n"
"OO: --all, --blockdevice, --ignorelockingfailure,\n"
"--readonly, --reportformat ReportFmt\n"
"IO: --partial, --cache_long\n"
"ID: lvscan_general\n"
"OO_PVCHANGE: --autobackup Bool, --force, --reportformat ReportFmt, --uuid\n"
"OO_PVCHANGE_META: --allocatable Bool, --addtag Tag, --deltag Tag,\n"
"--uuid, --metadataignore Bool\n"
"pvchange --all OO_PVCHANGE_META\n"
"OO: OO_PVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: pvchange_properties_all\n"
"DESC: Change properties of all PVs.\n"
"pvchange OO_PVCHANGE_META PV|Select ...\n"
"OO: --select String, OO_PVCHANGE\n"
"IO: --ignoreskippedcluster\n"
"ID: pvchange_properties_some\n"
"DESC: Change properties of specified PVs.\n"
"pvresize PV ...\n"
"OO: --setphysicalvolumesize SizeMB, --reportformat ReportFmt\n"
"ID: pvresize_general\n"
"pvck PV ...\n"
"OO: --labelsector Number\n"
"ID: pvck_general\n"
"DESC: Check for metadata on a device\n"
"pvck --dump DumpType PV\n"
"OO: --settings String, --file String,\n"
"--pvmetadatacopies MetadataCopiesPV, --labelsector Number\n"
"ID: pvck_dump\n"
"DESC: Check and print LVM headers and metadata on a device\n"
"pvck --repairtype RepairType PV\n"
"OO: --settings String, --file String, --labelsector Number\n"
"ID: pvck_repair_type\n"
"DESC: Repair LVM headers or metadata on a device\n"
"pvck --repair --file String PV\n"
"OO: --settings String, --labelsector Number\n"
"ID: pvck_repair\n"
"DESC: Repair LVM headers and metadata on a device\n"
"pvcreate PV ...\n"
"OO: --dataalignment SizeKB, --dataalignmentoffset SizeKB, --bootloaderareasize SizeMB,\n"
"--force, --labelsector Number, --metadatatype MetadataType,\n"
"--pvmetadatacopies MetadataCopiesPV, --metadatasize SizeMB,\n"
"--metadataignore Bool, --norestorefile, --setphysicalvolumesize SizeMB,\n"
"--reportformat ReportFmt, --restorefile String, --uuidstr String, --zero Bool\n"
"ID: pvcreate_general\n"
"RULE: --norestorefile not --restorefile\n"
"RULE: --bootloaderareasize not --restorefile\n"
"pvdisplay\n"
"OO: --aligned, --all, --binary, --colon, --columns, --configreport ConfigReport,\n"
"--foreign, --ignorelockingfailure,\n"
"--logonly, --maps, --noheadings, --nosuffix, --options String,\n"
"--readonly, --reportformat ReportFmt, --select String, --separator String, --shared,\n"
"--short, --sort String, --unbuffered, --units Units\n"
"OP: PV|Tag ...\n"
"IO: --ignoreskippedcluster\n"
"ID: pvdisplay_general\n"
"pvmove PV\n"
"OO: --abort, --alloc Alloc, --atomic, --autobackup Bool, --background,\n"
"--interval Number, --name LV, --noudevsync, --reportformat ReportFmt\n"
"OP: PV ...\n"
"ID: pvmove_one\n"
"DESC: Move PV extents.\n"
"pvmove\n"
"OO: --abort, --background, --interval Number\n"
"ID: pvmove_any\n"
"DESC: Continue or abort existing pvmove operations.\n"
"pvremove PV ...\n"
"OO: --force, --reportformat ReportFmt\n"
"ID: pvremove_general\n"
"pvs\n"
"OO: --segments, OO_REPORT\n"
"OP: PV|Tag ...\n"
"IO: --partial, --ignoreskippedcluster, --trustcache\n"
"ID: pvs_general\n"
"pvscan\n"
"OO: --ignorelockingfailure, --reportformat ReportFmt, --exported, --novolumegroup,\n"
"--short, --uuid\n"
"ID: pvscan_display\n"
"DESC: Display PV information.\n"
"pvscan --cache_long\n"
"OO: --ignorelockingfailure, --reportformat ReportFmt,\n"
"--major Number, --minor Number, --noudevsync\n"
"OP: PV|String ...\n"
"IO: --background\n"
"ID: pvscan_cache\n"
"DESC: Record that a PV is online or offline.\n"
"pvscan --cache_long --activate ay\n"
"OO: --ignorelockingfailure, --reportformat ReportFmt,\n"
"--major Number, --minor Number, --noudevsync, --autoactivation String\n"
"OP: PV|String ...\n"
"IO: --background\n"
"ID: pvscan_cache\n"
"DESC: Record that a PV is online and autoactivate the VG if complete.\n"
"pvscan --cache_long --listvg PV\n"
"OO: --ignorelockingfailure, --checkcomplete, --vgonline, --udevoutput,\n"
"--autoactivation String\n"
"ID: pvscan_cache\n"
"DESC: Record that a PV is online and list the VG using the PV.\n"
"pvscan --cache_long --listlvs PV\n"
"OO: --ignorelockingfailure, --checkcomplete, --vgonline\n"
"ID: pvscan_cache\n"
"DESC: Record that a PV is online and list LVs using the PV.\n"
"pvscan --listlvs PV\n"
"ID: pvscan_cache\n"
"DESC: List LVs using the PV.\n"
"pvscan --listvg PV\n"
"ID: pvscan_cache\n"
"DESC: List the VG using the PV.\n"
"vgcfgbackup\n"
"OO: --file String, --foreign, --ignorelockingfailure, --readonly,\n"
"--reportformat ReportFmt\n"
"OP: VG ...\n"
"IO: --partial\n"
"ID: vgcfgbackup_general\n"
"OO_VGCFGRESTORE: --force_long, --metadatatype MetadataType\n"
"vgcfgrestore VG\n"
"OO: OO_VGCFGRESTORE\n"
"ID: vgcfgrestore_by_vg\n"
"DESC: Restore VG metadata from last backup.\n"
"vgcfgrestore --file String VG\n"
"OO: OO_VGCFGRESTORE\n"
"ID: vgcfgrestore_by_file\n"
"DESC: Restore VG metadata from specified file.\n"
"vgcfgrestore --list VG\n"
"OO: OO_VGCFGRESTORE\n"
"ID: vgcfgrestore_list_by_vg\n"
"DESC: List all VG metadata backups.\n"
"vgcfgrestore --list --file String\n"
"OO: OO_VGCFGRESTORE\n"
"OP: VG\n"
"ID: vgcfgrestore_list_by_file\n"
"DESC: List one VG metadata backup file.\n"
"OO_VGCHANGE: --autobackup Bool, --ignoremonitoring,\n"
"--noudevsync, --reportformat ReportFmt, --select String, --force\n"
"OO_VGCHANGE_META: --addtag Tag, --deltag Tag,\n"
"--logicalvolume Uint32, --maxphysicalvolumes Uint32, --alloc Alloc, --uuid,\n"
"--pvmetadatacopies MetadataCopiesPV, --vgmetadatacopies MetadataCopiesVG,\n"
"--physicalextentsize SizeMB, --resizeable Bool,\n"
"--profile String, --detachprofile, --metadataprofile String,\n"
"--setautoactivation Bool\n"
"vgchange OO_VGCHANGE_META\n"
"OO: --poll Bool, OO_VGCHANGE\n"
"OP: VG|Tag|Select ...\n"
"IO: --ignoreskippedcluster\n"
"ID: vgchange_properties\n"
"DESC: Change a general VG attribute.\n"
"DESC: For options listed in parentheses, any one is\n"
"DESC: required, after which the others are optional.\n"
"vgchange --monitor Bool\n"
"OO: --sysinit, --ignorelockingfailure, --poll Bool, OO_VGCHANGE\n"
"OP: VG|Tag|Select ...\n"
"IO: --ignoreskippedcluster\n"
"ID: vgchange_monitor\n"
"DESC: Start or stop monitoring LVs from dmeventd.\n"
"vgchange --poll Bool\n"
"OO: --ignorelockingfailure, OO_VGCHANGE\n"
"OP: VG|Tag|Select ...\n"
"IO: --ignoreskippedcluster\n"
"ID: vgchange_poll\n"
"DESC: Start or stop processing LV conversions.\n"
"vgchange --activate Active\n"
"OO: --activationmode ActivationMode, --ignoreactivationskip, --partial, --sysinit,\n"
"--readonly, --ignorelockingfailure, --monitor Bool, --poll Bool,\n"
"--autoactivation String, OO_VGCHANGE\n"
"OP: VG|Tag|Select ...\n"
"IO: --ignoreskippedcluster\n"
"ID: vgchange_activate\n"
"DESC: Activate or deactivate LVs.\n"
"vgchange --refresh\n"
"OO: --sysinit, --ignorelockingfailure, --poll Bool, OO_VGCHANGE\n"
"OP: VG|Tag|Select ...\n"
"IO: --ignoreskippedcluster\n"
"ID: vgchange_refresh\n"
"DESC: Reactivate LVs using the latest metadata.\n"
"vgchange --systemid String VG|Tag|Select\n"
"OO: --select String, --majoritypvs\n"
"ID: vgchange_systemid\n"
"DESC: Change the system ID of a VG.\n"
"vgchange --lockstart\n"
"OO: --select String\n"
"OP: VG|Tag|Select ...\n"
"ID: vgchange_lockstart\n"
"DESC: Start the lockspace of a shared VG in lvmlockd.\n"
"vgchange --lockstop\n"
"OO: --select String\n"
"OP: VG|Tag|Select ...\n"
"ID: vgchange_lockstop\n"
"DESC: Stop the lockspace of a shared VG in lvmlockd.\n"
"vgchange --locktype LockType VG\n"
"ID: vgchange_locktype\n"
"DESC: Change the lock type for a shared VG.\n"
"vgck\n"
"OO: --reportformat ReportFmt\n"
"OP: VG|Tag ...\n"
"ID: vgck_general\n"
"DESC: Read and display information about a VG.\n"
"vgck --updatemetadata VG\n"
"ID: vgck_update_metadata\n"
"DESC: Rewrite VG metadata to correct problems.\n"
"vgcreate VG_new PV ...\n"
"OO: --addtag Tag, --alloc Alloc, --autobackup Bool, --clustered Bool, --maxlogicalvolumes Uint32,\n"
"--maxphysicalvolumes Uint32, --metadataprofile String, --metadatatype MetadataType,\n"
"--physicalextentsize SizeMB, --force, --zero Bool, --labelsector Number,\n"
"--metadatasize SizeMB, --pvmetadatacopies MetadataCopiesPV, --vgmetadatacopies MetadataCopiesVG,\n"
"--reportformat ReportFmt, --dataalignment SizeKB, --dataalignmentoffset SizeKB,\n"
"--shared, --systemid String, --locktype LockType, --setautoactivation Bool\n"
"ID: vgcreate_general\n"
"vgdisplay\n"
"OO: --activevolumegroups, --aligned, --binary, --colon, --columns,\n"
"--configreport ConfigReport, --foreign, --ignorelockingfailure,\n"
"--logonly, --noheadings, --nosuffix,\n"
"--options String, --readonly, --select String,\n"
"--shared, --short, --separator String, --sort String, --unbuffered, --units Units\n"
"OP: VG|Tag ...\n"
"IO: --partial, --ignoreskippedcluster, --reportformat ReportFmt\n"
"ID: vgdisplay_general\n"
"OO_VGEXPORT: --reportformat ReportFmt\n"
"vgexport VG|Tag|Select ...\n"
"OO: --select String, OO_VGEXPORT\n"
"ID: vgexport_some\n"
"DESC: Export specified VGs.\n"
"vgexport --all\n"
"OO: OO_VGEXPORT\n"
"ID: vgexport_all\n"
"DESC: Export all VGs.\n"
"vgextend VG PV ...\n"
"OO: --autobackup Bool,\n"
"--force, --zero Bool, --labelsector Number, --metadatatype MetadataType,\n"
"--metadatasize SizeMB, --pvmetadatacopies MetadataCopiesPV,\n"
"--metadataignore Bool, --dataalignment SizeKB, --dataalignmentoffset SizeKB,\n"
"--reportformat ReportFmt, --restoremissing\n"
"ID: vgextend_general\n"
"OO_VGIMPORT: --force, --reportformat ReportFmt\n"
"vgimport VG|Tag|Select ...\n"
"OO: --select String, OO_VGIMPORT\n"
"ID: vgimport_some\n"
"DESC: Import specified VGs.\n"
"vgimport --all\n"
"OO: OO_VGIMPORT\n"
"ID: vgimport_all\n"
"DESC: Import all VGs.\n"
"vgimportclone PV ...\n"
"OO: --basevgname VG, --import, --importdevices\n"
"ID: vgimportclone_general\n"
"vgimportdevices VG|Tag|Select ...\n"
"OO: --select String, --foreign, --reportformat ReportFmt\n"
"ID: vgimportdevices_some\n"
"DESC: Add devices from specific VGs to the devices file.\n"
"vgimportdevices --all\n"
"OO: --foreign, --reportformat ReportFmt\n"
"ID: vgimportdevices_all\n"
"DESC: Add devices from all accessible VGs to the devices file.\n"
"vgmerge VG VG\n"
"OO: --autobackup Bool, --list, --poolmetadataspare Bool\n"
"ID: vgmerge_general\n"
"vgmknodes\n"
"OO: --ignorelockingfailure, --refresh, --reportformat ReportFmt\n"
"OP: VG|LV|Tag ...\n"
"ID: vgmknodes_general\n"
"OO_VGREDUCE: --autobackup Bool, --force, --reportformat ReportFmt\n"
"vgreduce VG PV ...\n"
"OO: OO_VGREDUCE\n"
"ID: vgreduce_by_pv\n"
"DESC: Remove a PV from a VG.\n"
"vgreduce --all VG\n"
"OO: OO_VGREDUCE\n"
"ID: vgreduce_all\n"
"DESC: Remove all unused PVs from a VG.\n"
"vgreduce --removemissing VG\n"
"OO: --mirrorsonly, OO_VGREDUCE\n"
"ID: vgreduce_missing\n"
"DESC: Remove all missing PVs from a VG.\n"
"vgremove VG|Tag|Select ...\n"
"OO: --force, --noudevsync, --reportformat ReportFmt, --select String\n"
"ID: vgremove_general\n"
"vgrename VG VG_new\n"
"OO: --autobackup Bool, --force, --reportformat ReportFmt\n"
"ID: vgrename_by_name\n"
"DESC: Rename a VG.\n"
"vgrename String VG_new\n"
"OO: --autobackup Bool, --force, --reportformat ReportFmt\n"
"ID: vgrename_by_uuid\n"
"DESC: Rename a VG by specifying the VG UUID.\n"
"vgs\n"
"OO: OO_REPORT\n"
"OP: VG|Tag ...\n"
"IO: --partial, --ignoreskippedcluster, --trustcache\n"
"ID: vgs_general\n"
"vgscan\n"
"OO: --ignorelockingfailure, --mknodes, --notifydbus,\n"
"--reportformat ReportFmt\n"
"IO: --partial, --cache_long\n"
"ID: vgscan_general\n"
"OO_VGSPLIT: --autobackup Bool, --poolmetadataspare Bool\n"
"OO_VGSPLIT_NEW: --alloc Alloc,\n"
"--maxlogicalvolumes Uint32, --maxphysicalvolumes Uint32,\n"
"--metadatatype MetadataType, --vgmetadatacopies MetadataCopiesVG\n"
"vgsplit VG VG PV ...\n"
"OO: OO_VGSPLIT, OO_VGSPLIT_NEW\n"
"ID: vgsplit_by_pv\n"
"DESC: Split a VG by specified PVs.\n"
"vgsplit --name LV VG VG\n"
"OO: OO_VGSPLIT, OO_VGSPLIT_NEW\n"
"ID: vgsplit_by_lv\n"
"DESC: Split a VG by PVs in a specified LV.\n"
"config\n"
"OO: OO_CONFIG\n"
"OP: String ...\n"
"ID: lvmconfig_general\n"
"dumpconfig\n"
"OO: OO_CONFIG\n"
"OP: String ...\n"
"ID: lvmconfig_general\n"
"devtypes\n"
"OO: --aligned, --binary, --nameprefixes, --noheadings,\n"
"--nosuffix, --options String, --reportformat ReportFmt, --rows,\n"
"--select String, --separator String, --sort String, --unbuffered, --unquoted\n"
"ID: devtypes_general\n"
"fullreport\n"
"OO: OO_REPORT\n"
"OP: VG ...\n"
"IO: --partial, --ignoreskippedcluster, --trustcache\n"
"ID: fullreport_general\n"
"lastlog\n"
"OO: --reportformat ReportFmt, --select String\n"
"ID: lastlog_general\n"
"lvpoll --polloperation PollOp LV ...\n"
"OO: --abort, --autobackup Bool, --handlemissingpvs, --interval Number\n"
"ID: lvpoll_general\n"
"formats\n"
"ID: formats_general\n"
"help\n"
"OP: String ...\n"
"ID: help_general\n"
"version\n"
"ID: version_general\n"
"pvdata\n"
"ID: pvdata_general\n"
"segtypes\n"
"ID: segtypes_general\n"
"systemid\n"
"ID: systemid_general\n"
"tags\n"
"ID: tags_general\n"
"lvmchange\n"
"ID: lvmchange_general\n"
"lvmdiskscan\n"
"OO: --lvmpartition, --readonly\n"
"ID: lvmdiskscan_general\n"
"lvmsadc\n"
"ID: lvmsadc_general\n"
"lvmsar\n"
"OO: --full, --stdin\n"
"ID: lvmsar_general\n"
"vgconvert VG ...\n"
"OO: --force, --labelsector Number, --bootloaderareasize SizeMB,\n"
"--metadatatype MetadataType, --pvmetadatacopies MetadataCopiesPV,\n"
"--metadatasize SizeMB, --reportformat ReportFmt\n"
"ID: vgconvert_general\n"
"\n\n";
