/*
* Copyright(c) 2011-2014 Renesas Electronics Corporation
* RENESAS ELECTRONICS CONFIDENTIAL AND PROPRIETARY.
* This program must be used solely for the purpose for which
* it was furnished by Renesas Electronics Corporation. No part of this
* program may be reproduced or disclosed to others, in any
* form, without the prior written permission of Renesas Electronics
* Corporation.
*/

#ifndef __eglext_REL_h__
#define __eglext_REL_h__

#ifdef __cplusplus
extern "C" {
#endif

#include <EGL/egl.h>
#include <EGL/eglplatform.h>

typedef struct EGLNativePixmapTypeREL_TAG
{
	EGLint	width;
	EGLint	height;
	EGLint	stride;
	EGLint	usage;
	EGLint	format;
	void*	pixelData;
} EGLNativePixmapTypeREL;

#define EGL_NATIVE_PIXFORMAT_RGB565_REL			0
#define EGL_NATIVE_PIXFORMAT_ARGB1555_REL		1
#define EGL_NATIVE_PIXFORMAT_ARGB8888_REL		2
#define EGL_NATIVE_PIXFORMAT_ARGB4444_REL		3


/* [RELCOMMENT STD-0052:P-0149] Add parameters for YUV formats. */
#define EGL_NATIVE_PIXFORMAT_UYVY_REL			4
#define EGL_NATIVE_PIXFORMAT_NV12_REL			5  // YUV420 2 plane

/* [RELCOMMENT STD-0052:P-0149] Following formats are not opened to user. */
#define EGL_NATIVE_PIXFORMAT_YUYV_REL			6
#define EGL_NATIVE_PIXFORMAT_VYUY_REL			7
#define EGL_NATIVE_PIXFORMAT_YVYU_REL			8
#define EGL_NATIVE_PIXFORMAT_NV21_REL			9  // YVU420 2 plane
#define EGL_NATIVE_PIXFORMAT_I420_REL			10 // YUV420 3 plane
#define EGL_NATIVE_PIXFORMAT_YV12_REL			11 // YVU420 3 plane
#define EGL_NATIVE_PIXFORMAT_NV16_REL			12

#define EGL_YUV_COLORSPACE_BT601_CONFORMANT_RANGE_REL   0x100
#define EGL_YUV_COLORSPACE_BT601_FULL_RANGE_REL                 0x200
#define EGL_YUV_COLORSPACE_BT709_CONFORMANT_RANGE_REL   0x300
#define EGL_YUV_COLORSPACE_BT709_FULL_RANGE_REL                 0x400

/* [RELCOMMENT STD-0052:P-0149] EGL_CHROMA_INTERP_XXX are not opened to user. */
#define EGL_CHROMA_INTERP_U_ZERO_REL			0x00010000
#define EGL_CHROMA_INTERP_U_QUATER_REL			0x00020000
#define EGL_CHROMA_INTERP_U_HALF_REL			0x00030000
#define EGL_CHROMA_INTERP_U_THREEQUARTERS_REL           0x00040000

#define EGL_CHROMA_INTERP_V_ZERO_REL			0x01000000
#define EGL_CHROMA_INTERP_V_QUATER_REL			0x02000000
#define EGL_CHROMA_INTERP_V_HALF_REL			0x03000000
#define EGL_CHROMA_INTERP_V_THREEQUARTERS_REL           0x04000000

#define D_MASK_FORMAT					0x000000FF
#define D_MASK_YUV_COLORSPACE				0x0000FF00
#define D_MASK_YUV_CHROMA_INTERP_U			0x00FF0000
#define D_MASK_YUV_CHROMA_INTERP_V			0xFF000000

#ifdef __cplusplus
}
#endif

#endif
